"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _arrayPrototype = _interopRequireDefault(require("array.prototype.flat"));

var _globalCache = _interopRequireDefault(require("global-cache"));

var _constants = require("./utils/constants");

var _getClassName = _interopRequireDefault(require("./utils/getClassName"));

var _separateStyles2 = _interopRequireDefault(require("./utils/separateStyles"));

/**
 * Function required as part of the react-with-styles interface. Parses the styles provided by
 * react-with-styles to produce class names based on the style name and optionally the namespace if
 * available.
 *
 * stylesObject {Object} The styles object passed to withStyles.
 *
 * Return an object mapping style names to class names.
 */
function create(stylesObject) {
  var stylesToClasses = {};
  var styleNames = Object.keys(stylesObject);
  var sharedState = _globalCache["default"].get(_constants.GLOBAL_CACHE_KEY) || {};
  var _sharedState$namespac = sharedState.namespace,
      namespace = _sharedState$namespac === void 0 ? '' : _sharedState$namespac;
  styleNames.forEach(function (styleName) {
    var className = (0, _getClassName["default"])(namespace, styleName);
    stylesToClasses[styleName] = className;
  });
  return stylesToClasses;
}
/**
 * Process styles to be consumed by a component.
 *
 * stylesArray {Array} Array of the following: values returned by create, plain JavaScript objects
 * representing inline styles, or arrays thereof.
 *
 * Return an object with optional className and style properties to be spread on a component.
 */


function resolve(stylesArray) {
  var flattenedStyles = (0, _arrayPrototype["default"])(stylesArray, Infinity);

  var _separateStyles = (0, _separateStyles2["default"])(flattenedStyles),
      classNames = _separateStyles.classNames,
      hasInlineStyles = _separateStyles.hasInlineStyles,
      inlineStyles = _separateStyles.inlineStyles;

  var specificClassNames = classNames.map(function (name, index) {
    return "".concat(name, " ").concat(name, "_").concat(index + 1);
  });
  var className = specificClassNames.join(' ');
  var result = {
    className: className
  };
  if (hasInlineStyles) result.style = inlineStyles;
  return result;
}

var _default = {
  create: create,
  resolve: resolve
};
exports["default"] = _default;