/** @module pkg-install */
import { InstallConfig } from './config';
import { SupportedPackageManagers } from './types';
/**
 * Determine what package manager to use based on what preference is set,
 * and whether it's currently running in a yarn/npm script
 *
 * @export
 * @param {InstallConfig} config
 * @returns {Promise<SupportedPackageManagers>}
 */
export declare function getPackageManager(config: InstallConfig): Promise<SupportedPackageManagers>;
/**
 * SYNC: Determine what package manager to use based on what preference is set,
 * and whether it's currently running in a yarn/npm script
 *
 * @export
 * @param {InstallConfig} config
 * @returns {SupportedPackageManagers}
 */
export declare function getPackageManagerSync(config: InstallConfig): SupportedPackageManagers;
