/*!
 * ONNX Runtime Web v1.17.1
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
"use strict";var ort=(()=>{var Al=Object.create;var Fe=Object.defineProperty;var Pl=Object.getOwnPropertyDescriptor;var El=Object.getOwnPropertyNames;var Dl=Object.getPrototypeOf,Ll=Object.prototype.hasOwnProperty;var x=(a,e)=>()=>(a&&(e=a(a=0)),e);var Z=(a,e)=>()=>(e||a((e={exports:{}}).exports,e),e.exports),Br=(a,e)=>{for(var o in e)Fe(a,o,{get:e[o],enumerable:!0})},qn=(a,e,o,t)=>{if(e&&typeof e=="object"||typeof e=="function")for(let r of El(e))!Ll.call(a,r)&&r!==o&&Fe(a,r,{get:()=>e[r],enumerable:!(t=Pl(e,r))||t.enumerable});return a};var re=(a,e,o)=>(o=a!=null?Al(Dl(a)):{},qn(e||!a||!a.__esModule?Fe(o,"default",{value:a,enumerable:!0}):o,a)),jn=a=>qn(Fe({},"__esModule",{value:!0}),a);var Ne,Mt,me,Ce,Ge=x(()=>{"use strict";Ne=new Map,Mt=[],me=(a,e,o)=>{if(e&&typeof e.init=="function"&&typeof e.createInferenceSessionHandler=="function"){let t=Ne.get(a);if(t===void 0)Ne.set(a,{backend:e,priority:o});else{if(t.priority>o)return;if(t.priority===o&&t.backend!==e)throw new Error(`cannot register backend "${a}" using priority ${o}`)}if(o>=0){let r=Mt.indexOf(a);r!==-1&&Mt.splice(r,1);for(let n=0;n<Mt.length;n++)if(Ne.get(Mt[n]).priority<=o){Mt.splice(n,0,a);return}Mt.push(a)}return}throw new TypeError("not a valid backend")},Ce=async a=>{let e=a.length===0?Mt:a,o=[];for(let t of e){let r=Ne.get(t);if(r){if(r.initialized)return r.backend;if(r.aborted)continue;let n=!!r.initPromise;try{return n||(r.initPromise=r.backend.init(t)),await r.initPromise,r.initialized=!0,r.backend}catch(s){n||o.push({name:t,err:s}),r.aborted=!0}finally{delete r.initPromise}}}throw new Error(`no available backend found. ERR: ${o.map(t=>`[${t.name}] ${t.err}`).join(", ")}`)}});var Kn=x(()=>{"use strict";Ge()});var Xn,Jn=x(()=>{"use strict";Xn="1.17.1"});var Zn,Ut,Fr=x(()=>{"use strict";Jn();Zn="warning",Ut={wasm:{},webgl:{},webgpu:{},versions:{common:Xn},set logLevel(a){if(a!==void 0){if(typeof a!="string"||["verbose","info","warning","error","fatal"].indexOf(a)===-1)throw new Error(`Unsupported logging level: ${a}`);Zn=a}},get logLevel(){return Zn}};Object.defineProperty(Ut,"logLevel",{enumerable:!0})});var j,Yn=x(()=>{"use strict";Fr();j=Ut});var Qn,to,eo=x(()=>{"use strict";Qn=(a,e)=>{let o=typeof document<"u"?document.createElement("canvas"):new OffscreenCanvas(1,1);o.width=a.dims[3],o.height=a.dims[2];let t=o.getContext("2d");if(t!=null){let r,n;e?.tensorLayout!==void 0&&e.tensorLayout==="NHWC"?(r=a.dims[2],n=a.dims[3]):(r=a.dims[3],n=a.dims[2]);let s=e?.format!==void 0?e.format:"RGB",i=e?.norm,u,l;i===void 0||i.mean===void 0?u=[255,255,255,255]:typeof i.mean=="number"?u=[i.mean,i.mean,i.mean,i.mean]:(u=[i.mean[0],i.mean[1],i.mean[2],0],i.mean[3]!==void 0&&(u[3]=i.mean[3])),i===void 0||i.bias===void 0?l=[0,0,0,0]:typeof i.bias=="number"?l=[i.bias,i.bias,i.bias,i.bias]:(l=[i.bias[0],i.bias[1],i.bias[2],0],i.bias[3]!==void 0&&(l[3]=i.bias[3]));let f=n*r,p=0,d=f,m=f*2,g=-1;s==="RGBA"?(p=0,d=f,m=f*2,g=f*3):s==="RGB"?(p=0,d=f,m=f*2):s==="RBG"&&(p=0,m=f,d=f*2);for(let y=0;y<n;y++)for(let v=0;v<r;v++){let _=(a.data[p++]-l[0])*u[0],O=(a.data[d++]-l[1])*u[1],S=(a.data[m++]-l[2])*u[2],C=g===-1?255:(a.data[g++]-l[3])*u[3];t.fillStyle="rgba("+_+","+O+","+S+","+C+")",t.fillRect(v,y,1,1)}if("toDataURL"in o)return o.toDataURL();throw new Error("toDataURL is not supported")}else throw new Error("Can not access image data")},to=(a,e)=>{let o=typeof document<"u"?document.createElement("canvas").getContext("2d"):new OffscreenCanvas(1,1).getContext("2d"),t;if(o!=null){let r,n,s;e?.tensorLayout!==void 0&&e.tensorLayout==="NHWC"?(r=a.dims[2],n=a.dims[1],s=a.dims[3]):(r=a.dims[3],n=a.dims[2],s=a.dims[1]);let i=e!==void 0&&e.format!==void 0?e.format:"RGB",u=e?.norm,l,f;u===void 0||u.mean===void 0?l=[255,255,255,255]:typeof u.mean=="number"?l=[u.mean,u.mean,u.mean,u.mean]:(l=[u.mean[0],u.mean[1],u.mean[2],255],u.mean[3]!==void 0&&(l[3]=u.mean[3])),u===void 0||u.bias===void 0?f=[0,0,0,0]:typeof u.bias=="number"?f=[u.bias,u.bias,u.bias,u.bias]:(f=[u.bias[0],u.bias[1],u.bias[2],0],u.bias[3]!==void 0&&(f[3]=u.bias[3]));let p=n*r;if(e!==void 0&&(e.format!==void 0&&s===4&&e.format!=="RGBA"||s===3&&e.format!=="RGB"&&e.format!=="BGR"))throw new Error("Tensor format doesn't match input tensor dims");let d=4,m=0,g=1,y=2,v=3,_=0,O=p,S=p*2,C=-1;i==="RGBA"?(_=0,O=p,S=p*2,C=p*3):i==="RGB"?(_=0,O=p,S=p*2):i==="RBG"&&(_=0,S=p,O=p*2),t=o.createImageData(r,n);for(let F=0;F<n*r;m+=d,g+=d,y+=d,v+=d,F++)t.data[m]=(a.data[_++]-f[0])*l[0],t.data[g]=(a.data[O++]-f[1])*l[1],t.data[y]=(a.data[S++]-f[2])*l[2],t.data[v]=C===-1?255:(a.data[C++]-f[3])*l[3]}else throw new Error("Can not access image data");return t}});var Nr,ro,no,oo,io,ao=x(()=>{"use strict";Re();Nr=(a,e)=>{if(a===void 0)throw new Error("Image buffer must be defined");if(e.height===void 0||e.width===void 0)throw new Error("Image height and width must be defined");if(e.tensorLayout==="NHWC")throw new Error("NHWC Tensor layout is not supported yet");let{height:o,width:t}=e,r=e.norm??{mean:255,bias:0},n,s;typeof r.mean=="number"?n=[r.mean,r.mean,r.mean,r.mean]:n=[r.mean[0],r.mean[1],r.mean[2],r.mean[3]??255],typeof r.bias=="number"?s=[r.bias,r.bias,r.bias,r.bias]:s=[r.bias[0],r.bias[1],r.bias[2],r.bias[3]??0];let i=e.format!==void 0?e.format:"RGBA",u=e.tensorFormat!==void 0&&e.tensorFormat!==void 0?e.tensorFormat:"RGB",l=o*t,f=u==="RGBA"?new Float32Array(l*4):new Float32Array(l*3),p=4,d=0,m=1,g=2,y=3,v=0,_=l,O=l*2,S=-1;i==="RGB"&&(p=3,d=0,m=1,g=2,y=-1),u==="RGBA"?S=l*3:u==="RBG"?(v=0,O=l,_=l*2):u==="BGR"&&(O=0,_=l,v=l*2);for(let F=0;F<l;F++,d+=p,g+=p,m+=p,y+=p)f[v++]=(a[d]+s[0])/n[0],f[_++]=(a[m]+s[1])/n[1],f[O++]=(a[g]+s[2])/n[2],S!==-1&&y!==-1&&(f[S++]=(a[y]+s[3])/n[3]);return u==="RGBA"?new ot("float32",f,[1,4,o,t]):new ot("float32",f,[1,3,o,t])},ro=async(a,e)=>{let o=typeof HTMLImageElement<"u"&&a instanceof HTMLImageElement,t=typeof ImageData<"u"&&a instanceof ImageData,r=typeof ImageBitmap<"u"&&a instanceof ImageBitmap,n=typeof a=="string",s,i=e??{},u=()=>{if(typeof document<"u")return document.createElement("canvas");if(typeof OffscreenCanvas<"u")return new OffscreenCanvas(1,1);throw new Error("Canvas is not supported")},l=f=>f instanceof HTMLCanvasElement||f instanceof OffscreenCanvas?f.getContext("2d"):null;if(o){let f=u();f.width=a.width,f.height=a.height;let p=l(f);if(p!=null){let d=a.height,m=a.width;if(e!==void 0&&e.resizedHeight!==void 0&&e.resizedWidth!==void 0&&(d=e.resizedHeight,m=e.resizedWidth),e!==void 0){if(i=e,e.tensorFormat!==void 0)throw new Error("Image input config format must be RGBA for HTMLImageElement");i.tensorFormat="RGBA",i.height=d,i.width=m}else i.tensorFormat="RGBA",i.height=d,i.width=m;p.drawImage(a,0,0),s=p.getImageData(0,0,m,d).data}else throw new Error("Can not access image data")}else if(t){let f,p;if(e!==void 0&&e.resizedWidth!==void 0&&e.resizedHeight!==void 0?(f=e.resizedHeight,p=e.resizedWidth):(f=a.height,p=a.width),e!==void 0&&(i=e),i.format="RGBA",i.height=f,i.width=p,e!==void 0){let d=u();d.width=p,d.height=f;let m=l(d);if(m!=null)m.putImageData(a,0,0),s=m.getImageData(0,0,p,f).data;else throw new Error("Can not access image data")}else s=a.data}else if(r){if(e===void 0)throw new Error("Please provide image config with format for Imagebitmap");let f=u();f.width=a.width,f.height=a.height;let p=l(f);if(p!=null){let d=a.height,m=a.width;return p.drawImage(a,0,0,m,d),s=p.getImageData(0,0,m,d).data,i.height=d,i.width=m,Nr(s,i)}else throw new Error("Can not access image data")}else{if(n)return new Promise((f,p)=>{let d=u(),m=l(d);if(!a||!m)return p();let g=new Image;g.crossOrigin="Anonymous",g.src=a,g.onload=()=>{d.width=g.width,d.height=g.height,m.drawImage(g,0,0,d.width,d.height);let y=m.getImageData(0,0,d.width,d.height);i.height=d.height,i.width=d.width,f(Nr(y.data,i))}});throw new Error("Input data provided is not supported - aborted tensor creation")}if(s!==void 0)return Nr(s,i);throw new Error("Input data provided is not supported - aborted tensor creation")},no=(a,e)=>{let{width:o,height:t,download:r,dispose:n}=e,s=[1,t,o,4];return new ot({location:"texture",type:"float32",texture:a,dims:s,download:r,dispose:n})},oo=(a,e)=>{let{dataType:o,dims:t,download:r,dispose:n}=e;return new ot({location:"gpu-buffer",type:o??"float32",gpuBuffer:a,dims:t,download:r,dispose:n})},io=(a,e,o)=>new ot({location:"cpu-pinned",type:a,data:e,dims:o??[e.length]})});var be,Ve,so,uo,lo=x(()=>{"use strict";be=new Map([["float32",Float32Array],["uint8",Uint8Array],["int8",Int8Array],["uint16",Uint16Array],["float16",Uint16Array],["int16",Int16Array],["int32",Int32Array],["bool",Uint8Array],["float64",Float64Array],["uint32",Uint32Array]]),Ve=new Map([[Float32Array,"float32"],[Uint8Array,"uint8"],[Int8Array,"int8"],[Uint16Array,"uint16"],[Int16Array,"int16"],[Int32Array,"int32"],[Float64Array,"float64"],[Uint32Array,"uint32"]]),so=!1,uo=()=>{if(!so){so=!0;let a=typeof BigInt64Array<"u"&&typeof BigInt64Array.from=="function",e=typeof BigUint64Array<"u"&&typeof BigUint64Array.from=="function";a&&(be.set("int64",BigInt64Array),Ve.set(BigInt64Array,"int64")),e&&(be.set("uint64",BigUint64Array),Ve.set(BigUint64Array,"uint64"))}}});var fo,co,po=x(()=>{"use strict";Re();fo=a=>{let e=1;for(let o=0;o<a.length;o++){let t=a[o];if(typeof t!="number"||!Number.isSafeInteger(t))throw new TypeError(`dims[${o}] must be an integer, got: ${t}`);if(t<0)throw new RangeError(`dims[${o}] must be a non-negative integer, got: ${t}`);e*=t}return e},co=(a,e)=>{switch(a.location){case"cpu":return new ot(a.type,a.data,e);case"cpu-pinned":return new ot({location:"cpu-pinned",data:a.data,type:a.type,dims:e});case"texture":return new ot({location:"texture",texture:a.texture,type:a.type,dims:e});case"gpu-buffer":return new ot({location:"gpu-buffer",gpuBuffer:a.gpuBuffer,type:a.type,dims:e});default:throw new Error(`tensorReshape: tensor location ${a.location} is not supported`)}}});var ot,Re=x(()=>{"use strict";eo();ao();lo();po();ot=class{constructor(e,o,t){uo();let r,n;if(typeof e=="object"&&"location"in e)switch(this.dataLocation=e.location,r=e.type,n=e.dims,e.location){case"cpu-pinned":{let i=be.get(r);if(!i)throw new TypeError(`unsupported type "${r}" to create tensor from pinned buffer`);if(!(e.data instanceof i))throw new TypeError(`buffer should be of type ${i.name}`);this.cpuData=e.data;break}case"texture":{if(r!=="float32")throw new TypeError(`unsupported type "${r}" to create tensor from texture`);this.gpuTextureData=e.texture,this.downloader=e.download,this.disposer=e.dispose;break}case"gpu-buffer":{if(r!=="float32"&&r!=="float16"&&r!=="int32"&&r!=="int64"&&r!=="uint32"&&r!=="bool")throw new TypeError(`unsupported type "${r}" to create tensor from gpu buffer`);this.gpuBufferData=e.gpuBuffer,this.downloader=e.download,this.disposer=e.dispose;break}default:throw new Error(`Tensor constructor: unsupported location '${this.dataLocation}'`)}else{let i,u;if(typeof e=="string")if(r=e,u=t,e==="string"){if(!Array.isArray(o))throw new TypeError("A string tensor's data must be a string array.");i=o}else{let l=be.get(e);if(l===void 0)throw new TypeError(`Unsupported tensor type: ${e}.`);if(Array.isArray(o)){if(e==="float16")throw new TypeError("Creating a float16 tensor from number array is not supported. Please use Uint16Array as data.");e==="uint64"||e==="int64"?i=l.from(o,BigInt):i=l.from(o)}else if(o instanceof l)i=o;else throw new TypeError(`A ${r} tensor's data must be type of ${l}`)}else if(u=o,Array.isArray(e)){if(e.length===0)throw new TypeError("Tensor type cannot be inferred from an empty array.");let l=typeof e[0];if(l==="string")r="string",i=e;else if(l==="boolean")r="bool",i=Uint8Array.from(e);else throw new TypeError(`Invalid element type of data array: ${l}.`)}else{let l=Ve.get(e.constructor);if(l===void 0)throw new TypeError(`Unsupported type for tensor data: ${e.constructor}.`);r=l,i=e}if(u===void 0)u=[i.length];else if(!Array.isArray(u))throw new TypeError("A tensor's dims must be a number array");n=u,this.cpuData=i,this.dataLocation="cpu"}let s=fo(n);if(this.cpuData&&s!==this.cpuData.length)throw new Error(`Tensor's size(${s}) does not match data length(${this.cpuData.length}).`);this.type=r,this.dims=n,this.size=s}static async fromImage(e,o){return ro(e,o)}static fromTexture(e,o){return no(e,o)}static fromGpuBuffer(e,o){return oo(e,o)}static fromPinnedBuffer(e,o,t){return io(e,o,t)}toDataURL(e){return Qn(this,e)}toImageData(e){return to(this,e)}get data(){if(this.ensureValid(),!this.cpuData)throw new Error("The data is not on CPU. Use `getData()` to download GPU data to CPU, or use `texture` or `gpuBuffer` property to access the GPU data directly.");return this.cpuData}get location(){return this.dataLocation}get texture(){if(this.ensureValid(),!this.gpuTextureData)throw new Error("The data is not stored as a WebGL texture.");return this.gpuTextureData}get gpuBuffer(){if(this.ensureValid(),!this.gpuBufferData)throw new Error("The data is not stored as a WebGPU buffer.");return this.gpuBufferData}async getData(e){switch(this.ensureValid(),this.dataLocation){case"cpu":case"cpu-pinned":return this.data;case"texture":case"gpu-buffer":{if(!this.downloader)throw new Error("The current tensor is not created with a specified data downloader.");if(this.isDownloading)throw new Error("The current tensor is being downloaded.");try{this.isDownloading=!0;let o=await this.downloader();return this.downloader=void 0,this.dataLocation="cpu",this.cpuData=o,e&&this.disposer&&(this.disposer(),this.disposer=void 0),o}finally{this.isDownloading=!1}}default:throw new Error(`cannot get data from location: ${this.dataLocation}`)}}dispose(){if(this.isDownloading)throw new Error("The current tensor is being downloaded.");this.disposer&&(this.disposer(),this.disposer=void 0),this.cpuData=void 0,this.gpuTextureData=void 0,this.gpuBufferData=void 0,this.downloader=void 0,this.isDownloading=void 0,this.dataLocation="none"}ensureValid(){if(this.dataLocation==="none")throw new Error("The tensor is disposed.")}reshape(e){if(this.ensureValid(),this.downloader||this.disposer)throw new Error("Cannot reshape a tensor that owns GPU resource.");return co(this,e)}}});var rt,ze=x(()=>{"use strict";Re();rt=ot});var Cr,ho,ye,ge,Gr=x(()=>{"use strict";Fr();Cr=(a,e)=>{Ut.wasm.trace&&console.timeStamp(`${a}::ORT::${e}`)},ho=(a,e)=>{let o=new Error().stack?.split(/\r\n|\r|\n/g)||[],t=!1;for(let r=0;r<o.length;r++){if(t&&!o[r].includes("TRACE_FUNC")){let n=`FUNC_${a}::${o[r].trim().split(" ")[1]}`;e&&(n+=`::${e}`),Cr("CPU",n);return}o[r].includes("TRACE_FUNC")&&(t=!0)}},ye=a=>{Ut.wasm.trace&&ho("BEGIN",a)},ge=a=>{Ut.wasm.trace&&ho("END",a)}});var Me,mo=x(()=>{"use strict";Ge();ze();Gr();Me=class a{constructor(e){this.handler=e}async run(e,o,t){ye();let r={},n={};if(typeof e!="object"||e===null||e instanceof rt||Array.isArray(e))throw new TypeError("'feeds' must be an object that use input names as keys and OnnxValue as corresponding values.");let s=!0;if(typeof o=="object"){if(o===null)throw new TypeError("Unexpected argument[1]: cannot be null.");if(o instanceof rt)throw new TypeError("'fetches' cannot be a Tensor");if(Array.isArray(o)){if(o.length===0)throw new TypeError("'fetches' cannot be an empty array.");s=!1;for(let l of o){if(typeof l!="string")throw new TypeError("'fetches' must be a string array or an object.");if(this.outputNames.indexOf(l)===-1)throw new RangeError(`'fetches' contains invalid output name: ${l}.`);r[l]=null}if(typeof t=="object"&&t!==null)n=t;else if(typeof t<"u")throw new TypeError("'options' must be an object.")}else{let l=!1,f=Object.getOwnPropertyNames(o);for(let p of this.outputNames)if(f.indexOf(p)!==-1){let d=o[p];(d===null||d instanceof rt)&&(l=!0,s=!1,r[p]=d)}if(l){if(typeof t=="object"&&t!==null)n=t;else if(typeof t<"u")throw new TypeError("'options' must be an object.")}else n=o}}else if(typeof o<"u")throw new TypeError("Unexpected argument[1]: must be 'fetches' or 'options'.");for(let l of this.inputNames)if(typeof e[l]>"u")throw new Error(`input '${l}' is missing in 'feeds'.`);if(s)for(let l of this.outputNames)r[l]=null;let i=await this.handler.run(e,r,n),u={};for(let l in i)if(Object.hasOwnProperty.call(i,l)){let f=i[l];f instanceof rt?u[l]=f:u[l]=new rt(f.type,f.data,f.dims)}return ge(),u}async release(){return this.handler.dispose()}static async create(e,o,t,r){ye();let n,s={};if(typeof e=="string"){if(n=e,typeof o=="object"&&o!==null)s=o;else if(typeof o<"u")throw new TypeError("'options' must be an object.")}else if(e instanceof Uint8Array){if(n=e,typeof o=="object"&&o!==null)s=o;else if(typeof o<"u")throw new TypeError("'options' must be an object.")}else if(e instanceof ArrayBuffer||typeof SharedArrayBuffer<"u"&&e instanceof SharedArrayBuffer){let p=e,d=0,m=e.byteLength;if(typeof o=="object"&&o!==null)s=o;else if(typeof o=="number"){if(d=o,!Number.isSafeInteger(d))throw new RangeError("'byteOffset' must be an integer.");if(d<0||d>=p.byteLength)throw new RangeError(`'byteOffset' is out of range [0, ${p.byteLength}).`);if(m=e.byteLength-d,typeof t=="number"){if(m=t,!Number.isSafeInteger(m))throw new RangeError("'byteLength' must be an integer.");if(m<=0||d+m>p.byteLength)throw new RangeError(`'byteLength' is out of range (0, ${p.byteLength-d}].`);if(typeof r=="object"&&r!==null)s=r;else if(typeof r<"u")throw new TypeError("'options' must be an object.")}else if(typeof t<"u")throw new TypeError("'byteLength' must be a number.")}else if(typeof o<"u")throw new TypeError("'options' must be an object.");n=new Uint8Array(p,d,m)}else throw new TypeError("Unexpected argument[0]: must be 'path' or 'buffer'.");let u=(s.executionProviders||[]).map(p=>typeof p=="string"?p:p.name),f=await(await Ce(u)).createInferenceSessionHandler(n,s);return ge(),new a(f)}startProfiling(){this.handler.startProfiling()}endProfiling(){this.handler.endProfiling()}get inputNames(){return this.handler.inputNames}get outputNames(){return this.handler.outputNames}}});var bo,yo=x(()=>{"use strict";mo();bo=Me});var go=x(()=>{"use strict"});var $l,Ue,xo=x(()=>{"use strict";Ge();ze();$l="Training backend could not be resolved. Make sure you're using the correct configuration & WebAssembly files.",Ue=class a{constructor(e,o,t){this.handler=e,this.hasOptimizerModel=o,this.hasEvalModel=t}get trainingInputNames(){return this.handler.inputNames}get trainingOutputNames(){return this.handler.outputNames}get evalInputNames(){if(this.hasEvalModel)return this.handler.evalInputNames;throw new Error("This training session has no evalModel loaded.")}get evalOutputNames(){if(this.hasEvalModel)return this.handler.evalOutputNames;throw new Error("This training session has no evalModel loaded.")}static async create(e,o){let t=e.evalModel||"",r=e.optimizerModel||"",n=o||{},i=(n.executionProviders||[]).map(l=>typeof l=="string"?l:l.name),u=await Ce(i);if(u.createTrainingSessionHandler){let l=await u.createTrainingSessionHandler(e.checkpointState,e.trainModel,t,r,n);return new a(l,!!e.optimizerModel,!!e.evalModel)}else throw new Error($l)}typeNarrowingForRunStep(e,o,t,r,n){let s={},i={};if(typeof t!="object"||t===null||t instanceof rt||Array.isArray(t))throw new TypeError("'feeds' must be an object that use input names as keys and OnnxValue as corresponding values.");let u=!0;if(typeof r=="object"){if(r===null)throw new TypeError("Unexpected argument[1]: cannot be null.");if(r instanceof rt)throw new TypeError("'fetches' cannot be a Tensor");if(Array.isArray(r)){if(r.length===0)throw new TypeError("'fetches' cannot be an empty array.");u=!1;for(let l of r){if(typeof l!="string")throw new TypeError("'fetches' must be a string array or an object.");if(o.indexOf(l)===-1)throw new RangeError(`'fetches' contains invalid output name: ${l}.`);s[l]=null}if(typeof n=="object"&&n!==null)i=n;else if(typeof n<"u")throw new TypeError("'options' must be an object.")}else{let l=!1,f=Object.getOwnPropertyNames(r);for(let p of o)if(f.indexOf(p)!==-1){let d=r[p];(d===null||d instanceof rt)&&(l=!0,u=!1,s[p]=d)}if(l){if(typeof n=="object"&&n!==null)i=n;else if(typeof n<"u")throw new TypeError("'options' must be an object.")}else i=r}}else if(typeof r<"u")throw new TypeError("Unexpected argument[1]: must be 'fetches' or 'options'.");for(let l of e)if(typeof t[l]>"u")throw new Error(`input '${l}' is missing in 'feeds'.`);if(u)for(let l of o)s[l]=null;return[s,i]}convertHandlerReturnTypeToMapOfTensors(e){let o={};for(let t in e)if(Object.hasOwnProperty.call(e,t)){let r=e[t];r instanceof rt?o[t]=r:o[t]=new rt(r.type,r.data,r.dims)}return o}async lazyResetGrad(){await this.handler.lazyResetGrad()}async runTrainStep(e,o,t){let[r,n]=this.typeNarrowingForRunStep(this.trainingInputNames,this.trainingOutputNames,e,o,t),s=await this.handler.runTrainStep(e,r,n);return this.convertHandlerReturnTypeToMapOfTensors(s)}async runOptimizerStep(e){if(this.hasOptimizerModel)await this.handler.runOptimizerStep(e||{});else throw new Error("This TrainingSession has no OptimizerModel loaded.")}async runEvalStep(e,o,t){if(this.hasEvalModel){let[r,n]=this.typeNarrowingForRunStep(this.evalInputNames,this.evalOutputNames,e,o,t),s=await this.handler.runEvalStep(e,r,n);return this.convertHandlerReturnTypeToMapOfTensors(s)}else throw new Error("This TrainingSession has no EvalModel loaded.")}async getParametersSize(e=!0){return this.handler.getParametersSize(e)}async loadParametersBuffer(e,o=!0){let t=await this.getParametersSize(o);if(e.length!==4*t)throw new Error("Size of the buffer passed into loadParametersBuffer must match the number of parameters in the model. Please use getParametersSize method to check.");return this.handler.loadParametersBuffer(e,o)}async getContiguousParameters(e=!0){return this.handler.getContiguousParameters(e)}async release(){return this.handler.dispose()}}});var To,vo=x(()=>{"use strict";xo();To=Ue});var Rr={};Br(Rr,{InferenceSession:()=>bo,TRACE:()=>Cr,TRACE_FUNC_BEGIN:()=>ye,TRACE_FUNC_END:()=>ge,Tensor:()=>rt,TrainingSession:()=>To,env:()=>j,registerBackend:()=>me});var Bt=x(()=>{"use strict";Kn();Yn();yo();ze();Gr();go();vo()});function Ft(a,e,o,t){if(e===void 0)return Bl(a);if(o===void 0)We(a,e,1);else if(typeof o=="number"&&t===void 0)We(a,e,o);else if(typeof o=="string"&&t===void 0)We(a,o,1,e);else if(typeof o=="string"&&typeof t=="number")We(a,o,t,e);else throw new TypeError("input is valid")}function Bl(a){return{verbose:Ft.verbose.bind(null,a),info:Ft.info.bind(null,a),warning:Ft.warning.bind(null,a),error:Ft.error.bind(null,a),fatal:Ft.fatal.bind(null,a)}}function We(a,e,o,t){let r=xe[t||""]||xe[""];Io[a]<Io[r.minimalSeverity]||(r.logDateTime&&(e=`${new Date().toISOString()}|${e}`),r.logSourceLocation,kl[r.provider].log(a,e,t))}var Vr,zr,Io,kl,_o,xe,M,qe,je,Ke,He,ct=x(()=>{"use strict";Vr=class{log(e,o,t){}},zr=class{log(e,o,t){console.log(`${this.color(e)} ${t?"\x1B[35m"+t+"\x1B[0m ":""}${o}`)}color(e){switch(e){case"verbose":return"\x1B[34;40mv\x1B[0m";case"info":return"\x1B[32mi\x1B[0m";case"warning":return"\x1B[30;43mw\x1B[0m";case"error":return"\x1B[31;40me\x1B[0m";case"fatal":return"\x1B[101mf\x1B[0m";default:throw new Error(`unsupported severity: ${e}`)}}},Io={verbose:1e3,info:2e3,warning:4e3,error:5e3,fatal:6e3},kl={none:new Vr,console:new zr},_o={provider:"console",minimalSeverity:"warning",logDateTime:!0,logSourceLocation:!1},xe={"":_o};(u=>{function a(l,f){u("verbose",l,f)}u.verbose=a;function e(l,f){u("info",l,f)}u.info=e;function o(l,f){u("warning",l,f)}u.warning=o;function t(l,f){u("error",l,f)}u.error=t;function r(l,f){u("fatal",l,f)}u.fatal=r;function n(l){xe={},s("",l||{})}u.reset=n;function s(l,f){if(l==="*")n(f);else{let p=xe[l]||_o;xe[l]={provider:f.provider||p.provider,minimalSeverity:f.minimalSeverity||p.minimalSeverity,logDateTime:f.logDateTime===void 0?p.logDateTime:f.logDateTime,logSourceLocation:f.logSourceLocation===void 0?p.logSourceLocation:f.logSourceLocation}}}u.set=s;function i(l){let f={};l.logLevel&&(f.minimalSeverity=l.logLevel),s("",f)}u.setWithEnv=i})(Ft||={});M=Ft,qe=class{constructor(e,o,t,r,n,s){this.category=e;this.name=o;this.startTime=t;this.endCallback=r;this.timer=n;this.ctx=s}async end(){return this.endCallback(this)}async checkTimer(){if(this.ctx===void 0||this.timer===void 0)throw new Error("No webgl timer found");return this.ctx.endTimer(),this.ctx.waitForQueryAndGetTime(this.timer)}},je=class{constructor(e,o,t,r){this.category=e;this.name=o;this.startTime=t;this.endTime=r}},Ke=class{constructor(e,o,t){this._started=!1;this._flushPointer=0;this._started=!1,this._maxNumberEvents=e===void 0?1e4:e,this._flushBatchSize=o===void 0?10:o,this._flushIntervalInMilliseconds=t===void 0?5e3:t}static create(e){return e===void 0?new this:new this(e.maxNumberEvents,e.flushBatchSize,e.flushIntervalInMilliseconds)}start(){this._started=!0,this._timingEvents=[],this._flushTime=He(),this._flushPointer=0}stop(){for(this._started=!1;this._flushPointer<this._timingEvents.length;this._flushPointer++)this.logOneEvent(this._timingEvents[this._flushPointer])}event(e,o,t,r){let n=this._started?this.begin(e,o,r):void 0,s=!1,i=t();if(i&&typeof i.then=="function")return s=!0,new Promise((u,l)=>{i.then(async f=>{n&&await n.end(),u(f)},async f=>{n&&await n.end(),l(f)})});if(!s&&n){let u=n.end();if(u&&typeof u.then=="function")return new Promise((l,f)=>{u.then(()=>{l(i)},p=>{f(p)})})}return i}begin(e,o,t){if(!this._started)throw new Error("profiler is not started yet");if(t===void 0){let r=He();return this.flush(r),new qe(e,o,r,n=>this.endSync(n))}else{let r=t.beginTimer();return new qe(e,o,0,async n=>this.end(n),r,t)}}async end(e){let o=await e.checkTimer();this._timingEvents.length<this._maxNumberEvents&&(this._timingEvents.push(new je(e.category,e.name,e.startTime,o)),this.flush(o))}endSync(e){let o=He();this._timingEvents.length<this._maxNumberEvents&&(this._timingEvents.push(new je(e.category,e.name,e.startTime,o)),this.flush(o))}logOneEvent(e){M.verbose(`Profiler.${e.category}`,`${(e.endTime-e.startTime).toFixed(2)}ms on event '${e.name}' at ${e.endTime.toFixed(2)}`)}flush(e){if(this._timingEvents.length-this._flushPointer>=this._flushBatchSize||e-this._flushTime>=this._flushIntervalInMilliseconds){for(let o=this._flushPointer;this._flushPointer<o+this._flushBatchSize&&this._flushPointer<this._timingEvents.length;this._flushPointer++)this.logOneEvent(this._timingEvents[this._flushPointer]);this._flushTime=He()}}get started(){return this._started}},He=typeof performance<"u"&&performance.now?()=>performance.now():Date.now});function So(a,e,o){for(let t of o){let r=t[0],n=t[1],s=t[2],i=t[3],u=t[4];if(a.opType===r){for(let l of e)if((l.domain===n||l.domain==="ai.onnx"&&n==="")&&Fl(l.version,s))return{opImpl:i,opInit:u}}}throw new TypeError(`cannot resolve operator '${a.opType}' with opsets: ${e.map(t=>`${t.domain||"ai.onnx"} v${t.version}`).join(", ")}`)}function Fl(a,e){if(e.endsWith("+")){let o=Number.parseInt(e.substring(0,e.length-1),10);return!isNaN(o)&&o<=a}else if(e.split("-").length===2){let o=e.split("-"),t=Number.parseInt(o[0],10),r=Number.parseInt(o[1],10);return!isNaN(t)&&!isNaN(r)&&t<=a&&a<=r}else return Number.parseInt(e,10)===a}var Oo=x(()=>{"use strict"});var Ao=Z(Mr=>{"use strict";Mr.__esModule=!0;var Nl=function(){function a(e){if(!e)throw new TypeError("Invalid argument; `value` has no value.");this.value=a.EMPTY,e&&a.isGuid(e)&&(this.value=e)}return a.isGuid=function(e){var o=e.toString();return e&&(e instanceof a||a.validator.test(o))},a.create=function(){return new a([a.gen(2),a.gen(1),a.gen(1),a.gen(1),a.gen(3)].join("-"))},a.createEmpty=function(){return new a("emptyguid")},a.parse=function(e){return new a(e)},a.raw=function(){return[a.gen(2),a.gen(1),a.gen(1),a.gen(1),a.gen(3)].join("-")},a.gen=function(e){for(var o="",t=0;t<e;t++)o+=((1+Math.random())*65536|0).toString(16).substring(1);return o},a.prototype.equals=function(e){return a.isGuid(e)&&this.value===e.toString()},a.prototype.isEmpty=function(){return this.value===a.EMPTY},a.prototype.toString=function(){return this.value},a.prototype.toJSON=function(){return{value:this.value}},a.validator=new RegExp("^[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}$","i"),a.EMPTY="00000000-0000-0000-0000-000000000000",a}();Mr.Guid=Nl});function U(a,e,o){this.low=a|0,this.high=e|0,this.unsigned=!!o}function nt(a){return(a&&a.__isLong__)===!0}function Po(a){var e=Math.clz32(a&-a);return a?31-e:e}function Wt(a,e){var o,t,r;return e?(a>>>=0,(r=0<=a&&a<256)&&(t=Do[a],t)?t:(o=V(a,0,!0),r&&(Do[a]=o),o)):(a|=0,(r=-128<=a&&a<128)&&(t=Eo[a],t)?t:(o=V(a,a<0?-1:0,!1),r&&(Eo[a]=o),o))}function dt(a,e){if(isNaN(a))return e?Lt:xt;if(e){if(a<0)return Lt;if(a>=Bo)return Co}else{if(a<=-$o)return ut;if(a+1>=$o)return No}return a<0?dt(-a,e).neg():V(a%oe|0,a/oe|0,e)}function V(a,e,o){return new U(a,e,o)}function Wr(a,e,o){if(a.length===0)throw Error("empty string");if(typeof e=="number"?(o=e,e=!1):e=!!e,a==="NaN"||a==="Infinity"||a==="+Infinity"||a==="-Infinity")return e?Lt:xt;if(o=o||10,o<2||36<o)throw RangeError("radix");var t;if((t=a.indexOf("-"))>0)throw Error("interior hyphen");if(t===0)return Wr(a.substring(1),e,o).neg();for(var r=dt(Xe(o,8)),n=xt,s=0;s<a.length;s+=8){var i=Math.min(8,a.length-s),u=parseInt(a.substring(s,s+i),o);if(i<8){var l=dt(Xe(o,i));n=n.mul(l).add(dt(u))}else n=n.mul(r),n=n.add(dt(u))}return n.unsigned=e,n}function Tt(a,e){return typeof a=="number"?dt(a,e):typeof a=="string"?Wr(a,e):V(a.low,a.high,typeof e=="boolean"?e:a.unsigned)}var pt,Eo,Do,Xe,Lo,Cl,oe,Bo,$o,ko,xt,Lt,ne,Fo,Ur,No,Co,ut,T,$t,Hr=x(()=>{pt=null;try{pt=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch{}U.prototype.__isLong__;Object.defineProperty(U.prototype,"__isLong__",{value:!0});U.isLong=nt;Eo={},Do={};U.fromInt=Wt;U.fromNumber=dt;U.fromBits=V;Xe=Math.pow;U.fromString=Wr;U.fromValue=Tt;Lo=65536,Cl=1<<24,oe=Lo*Lo,Bo=oe*oe,$o=Bo/2,ko=Wt(Cl),xt=Wt(0);U.ZERO=xt;Lt=Wt(0,!0);U.UZERO=Lt;ne=Wt(1);U.ONE=ne;Fo=Wt(1,!0);U.UONE=Fo;Ur=Wt(-1);U.NEG_ONE=Ur;No=V(-1,2147483647,!1);U.MAX_VALUE=No;Co=V(-1,-1,!0);U.MAX_UNSIGNED_VALUE=Co;ut=V(0,-2147483648,!1);U.MIN_VALUE=ut;T=U.prototype;T.toInt=function(){return this.unsigned?this.low>>>0:this.low};T.toNumber=function(){return this.unsigned?(this.high>>>0)*oe+(this.low>>>0):this.high*oe+(this.low>>>0)};T.toString=function(e){if(e=e||10,e<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative())if(this.eq(ut)){var o=dt(e),t=this.div(o),r=t.mul(o).sub(this);return t.toString(e)+r.toInt().toString(e)}else return"-"+this.neg().toString(e);for(var n=dt(Xe(e,6),this.unsigned),s=this,i="";;){var u=s.div(n),l=s.sub(u.mul(n)).toInt()>>>0,f=l.toString(e);if(s=u,s.isZero())return f+i;for(;f.length<6;)f="0"+f;i=""+f+i}};T.getHighBits=function(){return this.high};T.getHighBitsUnsigned=function(){return this.high>>>0};T.getLowBits=function(){return this.low};T.getLowBitsUnsigned=function(){return this.low>>>0};T.getNumBitsAbs=function(){if(this.isNegative())return this.eq(ut)?64:this.neg().getNumBitsAbs();for(var e=this.high!=0?this.high:this.low,o=31;o>0&&!(e&1<<o);o--);return this.high!=0?o+33:o+1};T.isZero=function(){return this.high===0&&this.low===0};T.eqz=T.isZero;T.isNegative=function(){return!this.unsigned&&this.high<0};T.isPositive=function(){return this.unsigned||this.high>=0};T.isOdd=function(){return(this.low&1)===1};T.isEven=function(){return(this.low&1)===0};T.equals=function(e){return nt(e)||(e=Tt(e)),this.unsigned!==e.unsigned&&this.high>>>31===1&&e.high>>>31===1?!1:this.high===e.high&&this.low===e.low};T.eq=T.equals;T.notEquals=function(e){return!this.eq(e)};T.neq=T.notEquals;T.ne=T.notEquals;T.lessThan=function(e){return this.comp(e)<0};T.lt=T.lessThan;T.lessThanOrEqual=function(e){return this.comp(e)<=0};T.lte=T.lessThanOrEqual;T.le=T.lessThanOrEqual;T.greaterThan=function(e){return this.comp(e)>0};T.gt=T.greaterThan;T.greaterThanOrEqual=function(e){return this.comp(e)>=0};T.gte=T.greaterThanOrEqual;T.ge=T.greaterThanOrEqual;T.compare=function(e){if(nt(e)||(e=Tt(e)),this.eq(e))return 0;var o=this.isNegative(),t=e.isNegative();return o&&!t?-1:!o&&t?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1};T.comp=T.compare;T.negate=function(){return!this.unsigned&&this.eq(ut)?ut:this.not().add(ne)};T.neg=T.negate;T.add=function(e){nt(e)||(e=Tt(e));var o=this.high>>>16,t=this.high&65535,r=this.low>>>16,n=this.low&65535,s=e.high>>>16,i=e.high&65535,u=e.low>>>16,l=e.low&65535,f=0,p=0,d=0,m=0;return m+=n+l,d+=m>>>16,m&=65535,d+=r+u,p+=d>>>16,d&=65535,p+=t+i,f+=p>>>16,p&=65535,f+=o+s,f&=65535,V(d<<16|m,f<<16|p,this.unsigned)};T.subtract=function(e){return nt(e)||(e=Tt(e)),this.add(e.neg())};T.sub=T.subtract;T.multiply=function(e){if(this.isZero())return this;if(nt(e)||(e=Tt(e)),pt){var o=pt.mul(this.low,this.high,e.low,e.high);return V(o,pt.get_high(),this.unsigned)}if(e.isZero())return this.unsigned?Lt:xt;if(this.eq(ut))return e.isOdd()?ut:xt;if(e.eq(ut))return this.isOdd()?ut:xt;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(ko)&&e.lt(ko))return dt(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,r=this.high&65535,n=this.low>>>16,s=this.low&65535,i=e.high>>>16,u=e.high&65535,l=e.low>>>16,f=e.low&65535,p=0,d=0,m=0,g=0;return g+=s*f,m+=g>>>16,g&=65535,m+=n*f,d+=m>>>16,m&=65535,m+=s*l,d+=m>>>16,m&=65535,d+=r*f,p+=d>>>16,d&=65535,d+=n*l,p+=d>>>16,d&=65535,d+=s*u,p+=d>>>16,d&=65535,p+=t*f+r*l+n*u+s*i,p&=65535,V(m<<16|g,p<<16|d,this.unsigned)};T.mul=T.multiply;T.divide=function(e){if(nt(e)||(e=Tt(e)),e.isZero())throw Error("division by zero");if(pt){if(!this.unsigned&&this.high===-2147483648&&e.low===-1&&e.high===-1)return this;var o=(this.unsigned?pt.div_u:pt.div_s)(this.low,this.high,e.low,e.high);return V(o,pt.get_high(),this.unsigned)}if(this.isZero())return this.unsigned?Lt:xt;var t,r,n;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return Lt;if(e.gt(this.shru(1)))return Fo;n=Lt}else{if(this.eq(ut)){if(e.eq(ne)||e.eq(Ur))return ut;if(e.eq(ut))return ne;var s=this.shr(1);return t=s.div(e).shl(1),t.eq(xt)?e.isNegative()?ne:Ur:(r=this.sub(e.mul(t)),n=t.add(r.div(e)),n)}else if(e.eq(ut))return this.unsigned?Lt:xt;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();n=xt}for(r=this;r.gte(e);){t=Math.max(1,Math.floor(r.toNumber()/e.toNumber()));for(var i=Math.ceil(Math.log(t)/Math.LN2),u=i<=48?1:Xe(2,i-48),l=dt(t),f=l.mul(e);f.isNegative()||f.gt(r);)t-=u,l=dt(t,this.unsigned),f=l.mul(e);l.isZero()&&(l=ne),n=n.add(l),r=r.sub(f)}return n};T.div=T.divide;T.modulo=function(e){if(nt(e)||(e=Tt(e)),pt){var o=(this.unsigned?pt.rem_u:pt.rem_s)(this.low,this.high,e.low,e.high);return V(o,pt.get_high(),this.unsigned)}return this.sub(this.div(e).mul(e))};T.mod=T.modulo;T.rem=T.modulo;T.not=function(){return V(~this.low,~this.high,this.unsigned)};T.countLeadingZeros=function(){return this.high?Math.clz32(this.high):Math.clz32(this.low)+32};T.clz=T.countLeadingZeros;T.countTrailingZeros=function(){return this.low?Po(this.low):Po(this.high)+32};T.ctz=T.countTrailingZeros;T.and=function(e){return nt(e)||(e=Tt(e)),V(this.low&e.low,this.high&e.high,this.unsigned)};T.or=function(e){return nt(e)||(e=Tt(e)),V(this.low|e.low,this.high|e.high,this.unsigned)};T.xor=function(e){return nt(e)||(e=Tt(e)),V(this.low^e.low,this.high^e.high,this.unsigned)};T.shiftLeft=function(e){return nt(e)&&(e=e.toInt()),(e&=63)===0?this:e<32?V(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):V(0,this.low<<e-32,this.unsigned)};T.shl=T.shiftLeft;T.shiftRight=function(e){return nt(e)&&(e=e.toInt()),(e&=63)===0?this:e<32?V(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):V(this.high>>e-32,this.high>=0?0:-1,this.unsigned)};T.shr=T.shiftRight;T.shiftRightUnsigned=function(e){return nt(e)&&(e=e.toInt()),(e&=63)===0?this:e<32?V(this.low>>>e|this.high<<32-e,this.high>>>e,this.unsigned):e===32?V(this.high,0,this.unsigned):V(this.high>>>e-32,0,this.unsigned)};T.shru=T.shiftRightUnsigned;T.shr_u=T.shiftRightUnsigned;T.rotateLeft=function(e){var o;return nt(e)&&(e=e.toInt()),(e&=63)===0?this:e===32?V(this.high,this.low,this.unsigned):e<32?(o=32-e,V(this.low<<e|this.high>>>o,this.high<<e|this.low>>>o,this.unsigned)):(e-=32,o=32-e,V(this.high<<e|this.low>>>o,this.low<<e|this.high>>>o,this.unsigned))};T.rotl=T.rotateLeft;T.rotateRight=function(e){var o;return nt(e)&&(e=e.toInt()),(e&=63)===0?this:e===32?V(this.high,this.low,this.unsigned):e<32?(o=32-e,V(this.high<<o|this.low>>>e,this.low<<o|this.high>>>e,this.unsigned)):(e-=32,o=32-e,V(this.low<<o|this.high>>>e,this.high<<o|this.low>>>e,this.unsigned))};T.rotr=T.rotateRight;T.toSigned=function(){return this.unsigned?V(this.low,this.high,!1):this};T.toUnsigned=function(){return this.unsigned?this:V(this.low,this.high,!0)};T.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()};T.toBytesLE=function(){var e=this.high,o=this.low;return[o&255,o>>>8&255,o>>>16&255,o>>>24,e&255,e>>>8&255,e>>>16&255,e>>>24]};T.toBytesBE=function(){var e=this.high,o=this.low;return[e>>>24,e>>>16&255,e>>>8&255,e&255,o>>>24,o>>>16&255,o>>>8&255,o&255]};U.fromBytes=function(e,o,t){return t?U.fromBytesLE(e,o):U.fromBytesBE(e,o)};U.fromBytesLE=function(e,o){return new U(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,o)};U.fromBytesBE=function(e,o){return new U(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],o)};$t=U});var b,Je=x(()=>{b={};b.Offset;b.Table;b.SIZEOF_SHORT=2;b.SIZEOF_INT=4;b.FILE_IDENTIFIER_LENGTH=4;b.SIZE_PREFIX_LENGTH=4;b.Encoding={UTF8_BYTES:1,UTF16_STRING:2};b.int32=new Int32Array(2);b.float32=new Float32Array(b.int32.buffer);b.float64=new Float64Array(b.int32.buffer);b.isLittleEndian=new Uint16Array(new Uint8Array([1,0]).buffer)[0]===1;b.Long=function(a,e){this.low=a|0,this.high=e|0};b.Long.create=function(a,e){return a==0&&e==0?b.Long.ZERO:new b.Long(a,e)};b.Long.prototype.toFloat64=function(){return(this.low>>>0)+this.high*4294967296};b.Long.prototype.equals=function(a){return this.low==a.low&&this.high==a.high};b.Long.ZERO=new b.Long(0,0);b.Builder=function(a){if(a)var e=a;else var e=1024;this.bb=b.ByteBuffer.allocate(e),this.space=e,this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1};b.Builder.prototype.clear=function(){this.bb.clear(),this.space=this.bb.capacity(),this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1};b.Builder.prototype.forceDefaults=function(a){this.force_defaults=a};b.Builder.prototype.dataBuffer=function(){return this.bb};b.Builder.prototype.asUint8Array=function(){return this.bb.bytes().subarray(this.bb.position(),this.bb.position()+this.offset())};b.Builder.prototype.prep=function(a,e){a>this.minalign&&(this.minalign=a);for(var o=~(this.bb.capacity()-this.space+e)+1&a-1;this.space<o+a+e;){var t=this.bb.capacity();this.bb=b.Builder.growByteBuffer(this.bb),this.space+=this.bb.capacity()-t}this.pad(o)};b.Builder.prototype.pad=function(a){for(var e=0;e<a;e++)this.bb.writeInt8(--this.space,0)};b.Builder.prototype.writeInt8=function(a){this.bb.writeInt8(this.space-=1,a)};b.Builder.prototype.writeInt16=function(a){this.bb.writeInt16(this.space-=2,a)};b.Builder.prototype.writeInt32=function(a){this.bb.writeInt32(this.space-=4,a)};b.Builder.prototype.writeInt64=function(a){this.bb.writeInt64(this.space-=8,a)};b.Builder.prototype.writeFloat32=function(a){this.bb.writeFloat32(this.space-=4,a)};b.Builder.prototype.writeFloat64=function(a){this.bb.writeFloat64(this.space-=8,a)};b.Builder.prototype.addInt8=function(a){this.prep(1,0),this.writeInt8(a)};b.Builder.prototype.addInt16=function(a){this.prep(2,0),this.writeInt16(a)};b.Builder.prototype.addInt32=function(a){this.prep(4,0),this.writeInt32(a)};b.Builder.prototype.addInt64=function(a){this.prep(8,0),this.writeInt64(a)};b.Builder.prototype.addFloat32=function(a){this.prep(4,0),this.writeFloat32(a)};b.Builder.prototype.addFloat64=function(a){this.prep(8,0),this.writeFloat64(a)};b.Builder.prototype.addFieldInt8=function(a,e,o){(this.force_defaults||e!=o)&&(this.addInt8(e),this.slot(a))};b.Builder.prototype.addFieldInt16=function(a,e,o){(this.force_defaults||e!=o)&&(this.addInt16(e),this.slot(a))};b.Builder.prototype.addFieldInt32=function(a,e,o){(this.force_defaults||e!=o)&&(this.addInt32(e),this.slot(a))};b.Builder.prototype.addFieldInt64=function(a,e,o){(this.force_defaults||!e.equals(o))&&(this.addInt64(e),this.slot(a))};b.Builder.prototype.addFieldFloat32=function(a,e,o){(this.force_defaults||e!=o)&&(this.addFloat32(e),this.slot(a))};b.Builder.prototype.addFieldFloat64=function(a,e,o){(this.force_defaults||e!=o)&&(this.addFloat64(e),this.slot(a))};b.Builder.prototype.addFieldOffset=function(a,e,o){(this.force_defaults||e!=o)&&(this.addOffset(e),this.slot(a))};b.Builder.prototype.addFieldStruct=function(a,e,o){e!=o&&(this.nested(e),this.slot(a))};b.Builder.prototype.nested=function(a){if(a!=this.offset())throw new Error("FlatBuffers: struct must be serialized inline.")};b.Builder.prototype.notNested=function(){if(this.isNested)throw new Error("FlatBuffers: object serialization must not be nested.")};b.Builder.prototype.slot=function(a){this.vtable[a]=this.offset()};b.Builder.prototype.offset=function(){return this.bb.capacity()-this.space};b.Builder.growByteBuffer=function(a){var e=a.capacity();if(e&3221225472)throw new Error("FlatBuffers: cannot grow buffer beyond 2 gigabytes.");var o=e<<1,t=b.ByteBuffer.allocate(o);return t.setPosition(o-e),t.bytes().set(a.bytes(),o-e),t};b.Builder.prototype.addOffset=function(a){this.prep(b.SIZEOF_INT,0),this.writeInt32(this.offset()-a+b.SIZEOF_INT)};b.Builder.prototype.startObject=function(a){this.notNested(),this.vtable==null&&(this.vtable=[]),this.vtable_in_use=a;for(var e=0;e<a;e++)this.vtable[e]=0;this.isNested=!0,this.object_start=this.offset()};b.Builder.prototype.endObject=function(){if(this.vtable==null||!this.isNested)throw new Error("FlatBuffers: endObject called without startObject");this.addInt32(0);for(var a=this.offset(),e=this.vtable_in_use-1;e>=0&&this.vtable[e]==0;e--);for(var o=e+1;e>=0;e--)this.addInt16(this.vtable[e]!=0?a-this.vtable[e]:0);var t=2;this.addInt16(a-this.object_start);var r=(o+t)*b.SIZEOF_SHORT;this.addInt16(r);var n=0,s=this.space;t:for(e=0;e<this.vtables.length;e++){var i=this.bb.capacity()-this.vtables[e];if(r==this.bb.readInt16(i)){for(var u=b.SIZEOF_SHORT;u<r;u+=b.SIZEOF_SHORT)if(this.bb.readInt16(s+u)!=this.bb.readInt16(i+u))continue t;n=this.vtables[e];break}}return n?(this.space=this.bb.capacity()-a,this.bb.writeInt32(this.space,n-a)):(this.vtables.push(this.offset()),this.bb.writeInt32(this.bb.capacity()-a,this.offset()-a)),this.isNested=!1,a};b.Builder.prototype.finish=function(a,e,o){var t=o?b.SIZE_PREFIX_LENGTH:0;if(e){var r=e;if(this.prep(this.minalign,b.SIZEOF_INT+b.FILE_IDENTIFIER_LENGTH+t),r.length!=b.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+b.FILE_IDENTIFIER_LENGTH);for(var n=b.FILE_IDENTIFIER_LENGTH-1;n>=0;n--)this.writeInt8(r.charCodeAt(n))}this.prep(this.minalign,b.SIZEOF_INT+t),this.addOffset(a),t&&this.addInt32(this.bb.capacity()-this.space),this.bb.setPosition(this.space)};b.Builder.prototype.finishSizePrefixed=function(a,e){this.finish(a,e,!0)};b.Builder.prototype.requiredField=function(a,e){var o=this.bb.capacity()-a,t=o-this.bb.readInt32(o),r=this.bb.readInt16(t+e)!=0;if(!r)throw new Error("FlatBuffers: field "+e+" must be set")};b.Builder.prototype.startVector=function(a,e,o){this.notNested(),this.vector_num_elems=e,this.prep(b.SIZEOF_INT,a*e),this.prep(o,a*e)};b.Builder.prototype.endVector=function(){return this.writeInt32(this.vector_num_elems),this.offset()};b.Builder.prototype.createString=function(a){if(a instanceof Uint8Array)var e=a;else for(var e=[],o=0;o<a.length;){var t,r=a.charCodeAt(o++);if(r<55296||r>=56320)t=r;else{var n=a.charCodeAt(o++);t=(r<<10)+n+(65536-56623104-56320)}t<128?e.push(t):(t<2048?e.push(t>>6&31|192):(t<65536?e.push(t>>12&15|224):e.push(t>>18&7|240,t>>12&63|128),e.push(t>>6&63|128)),e.push(t&63|128))}this.addInt8(0),this.startVector(1,e.length,1),this.bb.setPosition(this.space-=e.length);for(var o=0,s=this.space,i=this.bb.bytes();o<e.length;o++)i[s++]=e[o];return this.endVector()};b.Builder.prototype.createLong=function(a,e){return b.Long.create(a,e)};b.ByteBuffer=function(a){this.bytes_=a,this.position_=0};b.ByteBuffer.allocate=function(a){return new b.ByteBuffer(new Uint8Array(a))};b.ByteBuffer.prototype.clear=function(){this.position_=0};b.ByteBuffer.prototype.bytes=function(){return this.bytes_};b.ByteBuffer.prototype.position=function(){return this.position_};b.ByteBuffer.prototype.setPosition=function(a){this.position_=a};b.ByteBuffer.prototype.capacity=function(){return this.bytes_.length};b.ByteBuffer.prototype.readInt8=function(a){return this.readUint8(a)<<24>>24};b.ByteBuffer.prototype.readUint8=function(a){return this.bytes_[a]};b.ByteBuffer.prototype.readInt16=function(a){return this.readUint16(a)<<16>>16};b.ByteBuffer.prototype.readUint16=function(a){return this.bytes_[a]|this.bytes_[a+1]<<8};b.ByteBuffer.prototype.readInt32=function(a){return this.bytes_[a]|this.bytes_[a+1]<<8|this.bytes_[a+2]<<16|this.bytes_[a+3]<<24};b.ByteBuffer.prototype.readUint32=function(a){return this.readInt32(a)>>>0};b.ByteBuffer.prototype.readInt64=function(a){return new b.Long(this.readInt32(a),this.readInt32(a+4))};b.ByteBuffer.prototype.readUint64=function(a){return new b.Long(this.readUint32(a),this.readUint32(a+4))};b.ByteBuffer.prototype.readFloat32=function(a){return b.int32[0]=this.readInt32(a),b.float32[0]};b.ByteBuffer.prototype.readFloat64=function(a){return b.int32[b.isLittleEndian?0:1]=this.readInt32(a),b.int32[b.isLittleEndian?1:0]=this.readInt32(a+4),b.float64[0]};b.ByteBuffer.prototype.writeInt8=function(a,e){this.bytes_[a]=e};b.ByteBuffer.prototype.writeUint8=function(a,e){this.bytes_[a]=e};b.ByteBuffer.prototype.writeInt16=function(a,e){this.bytes_[a]=e,this.bytes_[a+1]=e>>8};b.ByteBuffer.prototype.writeUint16=function(a,e){this.bytes_[a]=e,this.bytes_[a+1]=e>>8};b.ByteBuffer.prototype.writeInt32=function(a,e){this.bytes_[a]=e,this.bytes_[a+1]=e>>8,this.bytes_[a+2]=e>>16,this.bytes_[a+3]=e>>24};b.ByteBuffer.prototype.writeUint32=function(a,e){this.bytes_[a]=e,this.bytes_[a+1]=e>>8,this.bytes_[a+2]=e>>16,this.bytes_[a+3]=e>>24};b.ByteBuffer.prototype.writeInt64=function(a,e){this.writeInt32(a,e.low),this.writeInt32(a+4,e.high)};b.ByteBuffer.prototype.writeUint64=function(a,e){this.writeUint32(a,e.low),this.writeUint32(a+4,e.high)};b.ByteBuffer.prototype.writeFloat32=function(a,e){b.float32[0]=e,this.writeInt32(a,b.int32[0])};b.ByteBuffer.prototype.writeFloat64=function(a,e){b.float64[0]=e,this.writeInt32(a,b.int32[b.isLittleEndian?0:1]),this.writeInt32(a+4,b.int32[b.isLittleEndian?1:0])};b.ByteBuffer.prototype.getBufferIdentifier=function(){if(this.bytes_.length<this.position_+b.SIZEOF_INT+b.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: ByteBuffer is too short to contain an identifier.");for(var a="",e=0;e<b.FILE_IDENTIFIER_LENGTH;e++)a+=String.fromCharCode(this.readInt8(this.position_+b.SIZEOF_INT+e));return a};b.ByteBuffer.prototype.__offset=function(a,e){var o=a-this.readInt32(a);return e<this.readInt16(o)?this.readInt16(o+e):0};b.ByteBuffer.prototype.__union=function(a,e){return a.bb_pos=e+this.readInt32(e),a.bb=this,a};b.ByteBuffer.prototype.__string=function(a,e){a+=this.readInt32(a);var o=this.readInt32(a),t="",r=0;if(a+=b.SIZEOF_INT,e===b.Encoding.UTF8_BYTES)return this.bytes_.subarray(a,a+o);for(;r<o;){var n,s=this.readUint8(a+r++);if(s<192)n=s;else{var i=this.readUint8(a+r++);if(s<224)n=(s&31)<<6|i&63;else{var u=this.readUint8(a+r++);if(s<240)n=(s&15)<<12|(i&63)<<6|u&63;else{var l=this.readUint8(a+r++);n=(s&7)<<18|(i&63)<<12|(u&63)<<6|l&63}}}n<65536?t+=String.fromCharCode(n):(n-=65536,t+=String.fromCharCode((n>>10)+55296,(n&1024-1)+56320))}return t};b.ByteBuffer.prototype.__indirect=function(a){return a+this.readInt32(a)};b.ByteBuffer.prototype.__vector=function(a){return a+this.readInt32(a)+b.SIZEOF_INT};b.ByteBuffer.prototype.__vector_len=function(a){return this.readInt32(a+this.readInt32(a))};b.ByteBuffer.prototype.__has_identifier=function(a){if(a.length!=b.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+b.FILE_IDENTIFIER_LENGTH);for(var e=0;e<b.FILE_IDENTIFIER_LENGTH;e++)if(a.charCodeAt(e)!=this.readInt8(this.position_+b.SIZEOF_INT+e))return!1;return!0};b.ByteBuffer.prototype.createLong=function(a,e){return b.Long.create(a,e)}});var P,Te=x(()=>{"use strict";Je();(e=>{let a;(t=>{let o;(n=>{let r;(S=>(S[S.UNDEFINED=0]="UNDEFINED",S[S.FLOAT=1]="FLOAT",S[S.INT=2]="INT",S[S.STRING=3]="STRING",S[S.TENSOR=4]="TENSOR",S[S.GRAPH=5]="GRAPH",S[S.FLOATS=6]="FLOATS",S[S.INTS=7]="INTS",S[S.STRINGS=8]="STRINGS",S[S.TENSORS=9]="TENSORS",S[S.GRAPHS=10]="GRAPHS",S[S.SPARSE_TENSOR=11]="SPARSE_TENSOR",S[S.SPARSE_TENSORS=12]="SPARSE_TENSORS"))(r=n.AttributeType||={})})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{let r;(l=>(l[l.UNKNOWN=0]="UNKNOWN",l[l.VALUE=1]="VALUE",l[l.PARAM=2]="PARAM"))(r=n.DimensionValueType||={})})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{let r;(L=>(L[L.UNDEFINED=0]="UNDEFINED",L[L.FLOAT=1]="FLOAT",L[L.UINT8=2]="UINT8",L[L.INT8=3]="INT8",L[L.UINT16=4]="UINT16",L[L.INT16=5]="INT16",L[L.INT32=6]="INT32",L[L.INT64=7]="INT64",L[L.STRING=8]="STRING",L[L.BOOL=9]="BOOL",L[L.FLOAT16=10]="FLOAT16",L[L.DOUBLE=11]="DOUBLE",L[L.UINT32=12]="UINT32",L[L.UINT64=13]="UINT64",L[L.COMPLEX64=14]="COMPLEX64",L[L.COMPLEX128=15]="COMPLEX128",L[L.BFLOAT16=16]="BFLOAT16",L[L.FLOAT8E4M3FN=17]="FLOAT8E4M3FN",L[L.FLOAT8E4M3FNUZ=18]="FLOAT8E4M3FNUZ",L[L.FLOAT8E5M2=19]="FLOAT8E5M2",L[L.FLOAT8E5M2FNUZ=20]="FLOAT8E5M2FNUZ"))(r=n.TensorDataType||={})})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{let r;(u=>(u[u.Primitive=0]="Primitive",u[u.Fused=1]="Fused"))(r=n.NodeType||={})})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{let r;(f=>(f[f.NONE=0]="NONE",f[f.tensor_type=1]="tensor_type",f[f.sequence_type=2]="sequence_type",f[f.map_type=3]="map_type"))(r=n.TypeInfoValue||={})})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsShape(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsShape(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}dim(i,u){let l=this.bb.__offset(this.bb_pos,4);return l?(u||new e.experimental.fbs.Dimension).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}dimLength(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.__vector_len(this.bb_pos+i):0}static startShape(i){i.startObject(1)}static addDim(i,u){i.addFieldOffset(0,u,0)}static createDimVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startDimVector(i,u){i.startVector(4,u,4)}static endShape(i){return i.endObject()}static createShape(i,u){return r.startShape(i),r.addDim(i,u),r.endShape(i)}}n.Shape=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsDimension(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsDimension(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}value(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new e.experimental.fbs.DimensionValue).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}denotation(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}static startDimension(i){i.startObject(2)}static addValue(i,u){i.addFieldOffset(0,u,0)}static addDenotation(i,u){i.addFieldOffset(1,u,0)}static endDimension(i){return i.endObject()}static createDimension(i,u,l){return r.startDimension(i),r.addValue(i,u),r.addDenotation(i,l),r.endDimension(i)}}n.Dimension=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsDimensionValue(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsDimensionValue(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}dimType(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt8(this.bb_pos+i):0}dimValue(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}dimParam(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,i):null}static startDimensionValue(i){i.startObject(3)}static addDimType(i,u){i.addFieldInt8(0,u,0)}static addDimValue(i,u){i.addFieldInt64(1,u,i.createLong(0,0))}static addDimParam(i,u){i.addFieldOffset(2,u,0)}static endDimensionValue(i){return i.endObject()}static createDimensionValue(i,u,l,f){return r.startDimensionValue(i),r.addDimType(i,u),r.addDimValue(i,l),r.addDimParam(i,f),r.endDimensionValue(i)}}n.DimensionValue=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsTensorTypeAndShape(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsTensorTypeAndShape(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}elemType(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt32(this.bb_pos+i):0}shape(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new e.experimental.fbs.Shape).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startTensorTypeAndShape(i){i.startObject(2)}static addElemType(i,u){i.addFieldInt32(0,u,0)}static addShape(i,u){i.addFieldOffset(1,u,0)}static endTensorTypeAndShape(i){return i.endObject()}static createTensorTypeAndShape(i,u,l){return r.startTensorTypeAndShape(i),r.addElemType(i,u),r.addShape(i,l),r.endTensorTypeAndShape(i)}}n.TensorTypeAndShape=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsMapType(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsMapType(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}keyType(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt32(this.bb_pos+i):0}valueType(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new e.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startMapType(i){i.startObject(2)}static addKeyType(i,u){i.addFieldInt32(0,u,0)}static addValueType(i,u){i.addFieldOffset(1,u,0)}static endMapType(i){return i.endObject()}static createMapType(i,u,l){return r.startMapType(i),r.addKeyType(i,u),r.addValueType(i,l),r.endMapType(i)}}n.MapType=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSequenceType(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSequenceType(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}elemType(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new e.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startSequenceType(i){i.startObject(1)}static addElemType(i,u){i.addFieldOffset(0,u,0)}static endSequenceType(i){return i.endObject()}static createSequenceType(i,u){return r.startSequenceType(i),r.addElemType(i,u),r.endSequenceType(i)}}n.SequenceType=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}nodeIndex(){return this.bb.readUint32(this.bb_pos)}srcArgIndex(){return this.bb.readInt32(this.bb_pos+4)}dstArgIndex(){return this.bb.readInt32(this.bb_pos+8)}static createEdgeEnd(i,u,l,f){return i.prep(4,12),i.writeInt32(f),i.writeInt32(l),i.writeInt32(u),i.offset()}}n.EdgeEnd=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsNodeEdge(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsNodeEdge(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}nodeIndex(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readUint32(this.bb_pos+i):0}inputEdges(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.EdgeEnd).__init(this.bb.__vector(this.bb_pos+l)+i*12,this.bb):null}inputEdgesLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}outputEdges(i,u){let l=this.bb.__offset(this.bb_pos,8);return l?(u||new e.experimental.fbs.EdgeEnd).__init(this.bb.__vector(this.bb_pos+l)+i*12,this.bb):null}outputEdgesLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}static startNodeEdge(i){i.startObject(3)}static addNodeIndex(i,u){i.addFieldInt32(0,u,0)}static addInputEdges(i,u){i.addFieldOffset(1,u,0)}static startInputEdgesVector(i,u){i.startVector(12,u,4)}static addOutputEdges(i,u){i.addFieldOffset(2,u,0)}static startOutputEdgesVector(i,u){i.startVector(12,u,4)}static endNodeEdge(i){return i.endObject()}static createNodeEdge(i,u,l,f){return r.startNodeEdge(i),r.addNodeIndex(i,u),r.addInputEdges(i,l),r.addOutputEdges(i,f),r.endNodeEdge(i)}}n.NodeEdge=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsNode(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsNode(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}domain(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,i):null}sinceVersion(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readInt32(this.bb_pos+i):0}index(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.readUint32(this.bb_pos+i):0}opType(i){let u=this.bb.__offset(this.bb_pos,14);return u?this.bb.__string(this.bb_pos+u,i):null}type(){let i=this.bb.__offset(this.bb_pos,16);return i?this.bb.readInt32(this.bb_pos+i):0}executionProviderType(i){let u=this.bb.__offset(this.bb_pos,18);return u?this.bb.__string(this.bb_pos+u,i):null}inputs(i,u){let l=this.bb.__offset(this.bb_pos,20);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}inputsLength(){let i=this.bb.__offset(this.bb_pos,20);return i?this.bb.__vector_len(this.bb_pos+i):0}outputs(i,u){let l=this.bb.__offset(this.bb_pos,22);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}outputsLength(){let i=this.bb.__offset(this.bb_pos,22);return i?this.bb.__vector_len(this.bb_pos+i):0}attributes(i,u){let l=this.bb.__offset(this.bb_pos,24);return l?(u||new e.experimental.fbs.Attribute).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}attributesLength(){let i=this.bb.__offset(this.bb_pos,24);return i?this.bb.__vector_len(this.bb_pos+i):0}inputArgCounts(i){let u=this.bb.__offset(this.bb_pos,26);return u?this.bb.readInt32(this.bb.__vector(this.bb_pos+u)+i*4):0}inputArgCountsLength(){let i=this.bb.__offset(this.bb_pos,26);return i?this.bb.__vector_len(this.bb_pos+i):0}inputArgCountsArray(){let i=this.bb.__offset(this.bb_pos,26);return i?new Int32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}implicitInputs(i,u){let l=this.bb.__offset(this.bb_pos,28);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}implicitInputsLength(){let i=this.bb.__offset(this.bb_pos,28);return i?this.bb.__vector_len(this.bb_pos+i):0}static startNode(i){i.startObject(13)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addDomain(i,u){i.addFieldOffset(2,u,0)}static addSinceVersion(i,u){i.addFieldInt32(3,u,0)}static addIndex(i,u){i.addFieldInt32(4,u,0)}static addOpType(i,u){i.addFieldOffset(5,u,0)}static addType(i,u){i.addFieldInt32(6,u,0)}static addExecutionProviderType(i,u){i.addFieldOffset(7,u,0)}static addInputs(i,u){i.addFieldOffset(8,u,0)}static createInputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startInputsVector(i,u){i.startVector(4,u,4)}static addOutputs(i,u){i.addFieldOffset(9,u,0)}static createOutputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startOutputsVector(i,u){i.startVector(4,u,4)}static addAttributes(i,u){i.addFieldOffset(10,u,0)}static createAttributesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startAttributesVector(i,u){i.startVector(4,u,4)}static addInputArgCounts(i,u){i.addFieldOffset(11,u,0)}static createInputArgCountsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addInt32(u[l]);return i.endVector()}static startInputArgCountsVector(i,u){i.startVector(4,u,4)}static addImplicitInputs(i,u){i.addFieldOffset(12,u,0)}static createImplicitInputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startImplicitInputsVector(i,u){i.startVector(4,u,4)}static endNode(i){return i.endObject()}static createNode(i,u,l,f,p,d,m,g,y,v,_,O,S,C){return r.startNode(i),r.addName(i,u),r.addDocString(i,l),r.addDomain(i,f),r.addSinceVersion(i,p),r.addIndex(i,d),r.addOpType(i,m),r.addType(i,g),r.addExecutionProviderType(i,y),r.addInputs(i,v),r.addOutputs(i,_),r.addAttributes(i,O),r.addInputArgCounts(i,S),r.addImplicitInputs(i,C),r.endNode(i)}}n.Node=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsValueInfo(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsValueInfo(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}type(i){let u=this.bb.__offset(this.bb_pos,8);return u?(i||new e.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startValueInfo(i){i.startObject(3)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addType(i,u){i.addFieldOffset(2,u,0)}static endValueInfo(i){return i.endObject()}static createValueInfo(i,u,l,f){return r.startValueInfo(i),r.addName(i,u),r.addDocString(i,l),r.addType(i,f),r.endValueInfo(i)}}n.ValueInfo=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsTypeInfo(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsTypeInfo(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}denotation(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}valueType(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.readUint8(this.bb_pos+i):0}value(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__union(i,this.bb_pos+u):null}static startTypeInfo(i){i.startObject(3)}static addDenotation(i,u){i.addFieldOffset(0,u,0)}static addValueType(i,u){i.addFieldInt8(1,u,0)}static addValue(i,u){i.addFieldOffset(2,u,0)}static endTypeInfo(i){return i.endObject()}static createTypeInfo(i,u,l,f){return r.startTypeInfo(i),r.addDenotation(i,u),r.addValueType(i,l),r.addValue(i,f),r.endTypeInfo(i)}}n.TypeInfo=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsOperatorSetId(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsOperatorSetId(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}domain(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}version(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}static startOperatorSetId(i){i.startObject(2)}static addDomain(i,u){i.addFieldOffset(0,u,0)}static addVersion(i,u){i.addFieldInt64(1,u,i.createLong(0,0))}static endOperatorSetId(i){return i.endObject()}static createOperatorSetId(i,u,l){return r.startOperatorSetId(i),r.addDomain(i,u),r.addVersion(i,l),r.endOperatorSetId(i)}}n.OperatorSetId=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsTensor(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsTensor(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}dims(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}dimsLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}dataType(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readInt32(this.bb_pos+i):0}rawData(i){let u=this.bb.__offset(this.bb_pos,12);return u?this.bb.readUint8(this.bb.__vector(this.bb_pos+u)+i):0}rawDataLength(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.__vector_len(this.bb_pos+i):0}rawDataArray(){let i=this.bb.__offset(this.bb_pos,12);return i?new Uint8Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}stringData(i,u){let l=this.bb.__offset(this.bb_pos,14);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}stringDataLength(){let i=this.bb.__offset(this.bb_pos,14);return i?this.bb.__vector_len(this.bb_pos+i):0}static startTensor(i){i.startObject(6)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addDims(i,u){i.addFieldOffset(2,u,0)}static createDimsVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startDimsVector(i,u){i.startVector(8,u,8)}static addDataType(i,u){i.addFieldInt32(3,u,0)}static addRawData(i,u){i.addFieldOffset(4,u,0)}static createRawDataVector(i,u){i.startVector(1,u.length,1);for(let l=u.length-1;l>=0;l--)i.addInt8(u[l]);return i.endVector()}static startRawDataVector(i,u){i.startVector(1,u,1)}static addStringData(i,u){i.addFieldOffset(5,u,0)}static createStringDataVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startStringDataVector(i,u){i.startVector(4,u,4)}static endTensor(i){return i.endObject()}static createTensor(i,u,l,f,p,d,m){return r.startTensor(i),r.addName(i,u),r.addDocString(i,l),r.addDims(i,f),r.addDataType(i,p),r.addRawData(i,d),r.addStringData(i,m),r.endTensor(i)}}n.Tensor=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSparseTensor(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSparseTensor(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}values(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}indices(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}dims(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}dimsLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}static startSparseTensor(i){i.startObject(3)}static addValues(i,u){i.addFieldOffset(0,u,0)}static addIndices(i,u){i.addFieldOffset(1,u,0)}static addDims(i,u){i.addFieldOffset(2,u,0)}static createDimsVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startDimsVector(i,u){i.startVector(8,u,8)}static endSparseTensor(i){return i.endObject()}static createSparseTensor(i,u,l,f){return r.startSparseTensor(i),r.addValues(i,u),r.addIndices(i,l),r.addDims(i,f),r.endSparseTensor(i)}}n.SparseTensor=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsAttribute(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsAttribute(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}type(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.readInt32(this.bb_pos+i):0}f(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readFloat32(this.bb_pos+i):0}i(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}s(i){let u=this.bb.__offset(this.bb_pos,14);return u?this.bb.__string(this.bb_pos+u,i):null}t(i){let u=this.bb.__offset(this.bb_pos,16);return u?(i||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}g(i){let u=this.bb.__offset(this.bb_pos,18);return u?(i||new e.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}floats(i){let u=this.bb.__offset(this.bb_pos,20);return u?this.bb.readFloat32(this.bb.__vector(this.bb_pos+u)+i*4):0}floatsLength(){let i=this.bb.__offset(this.bb_pos,20);return i?this.bb.__vector_len(this.bb_pos+i):0}floatsArray(){let i=this.bb.__offset(this.bb_pos,20);return i?new Float32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}ints(i){let u=this.bb.__offset(this.bb_pos,22);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}intsLength(){let i=this.bb.__offset(this.bb_pos,22);return i?this.bb.__vector_len(this.bb_pos+i):0}strings(i,u){let l=this.bb.__offset(this.bb_pos,24);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}stringsLength(){let i=this.bb.__offset(this.bb_pos,24);return i?this.bb.__vector_len(this.bb_pos+i):0}tensors(i,u){let l=this.bb.__offset(this.bb_pos,26);return l?(u||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}tensorsLength(){let i=this.bb.__offset(this.bb_pos,26);return i?this.bb.__vector_len(this.bb_pos+i):0}graphs(i,u){let l=this.bb.__offset(this.bb_pos,28);return l?(u||new e.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}graphsLength(){let i=this.bb.__offset(this.bb_pos,28);return i?this.bb.__vector_len(this.bb_pos+i):0}static startAttribute(i){i.startObject(13)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addType(i,u){i.addFieldInt32(2,u,0)}static addF(i,u){i.addFieldFloat32(3,u,0)}static addI(i,u){i.addFieldInt64(4,u,i.createLong(0,0))}static addS(i,u){i.addFieldOffset(5,u,0)}static addT(i,u){i.addFieldOffset(6,u,0)}static addG(i,u){i.addFieldOffset(7,u,0)}static addFloats(i,u){i.addFieldOffset(8,u,0)}static createFloatsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addFloat32(u[l]);return i.endVector()}static startFloatsVector(i,u){i.startVector(4,u,4)}static addInts(i,u){i.addFieldOffset(9,u,0)}static createIntsVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startIntsVector(i,u){i.startVector(8,u,8)}static addStrings(i,u){i.addFieldOffset(10,u,0)}static createStringsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startStringsVector(i,u){i.startVector(4,u,4)}static addTensors(i,u){i.addFieldOffset(11,u,0)}static createTensorsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startTensorsVector(i,u){i.startVector(4,u,4)}static addGraphs(i,u){i.addFieldOffset(12,u,0)}static createGraphsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startGraphsVector(i,u){i.startVector(4,u,4)}static endAttribute(i){return i.endObject()}static createAttribute(i,u,l,f,p,d,m,g,y,v,_,O,S,C){return r.startAttribute(i),r.addName(i,u),r.addDocString(i,l),r.addType(i,f),r.addF(i,p),r.addI(i,d),r.addS(i,m),r.addT(i,g),r.addG(i,y),r.addFloats(i,v),r.addInts(i,_),r.addStrings(i,O),r.addTensors(i,S),r.addGraphs(i,C),r.endAttribute(i)}}n.Attribute=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsGraph(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsGraph(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}initializers(i,u){let l=this.bb.__offset(this.bb_pos,4);return l?(u||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}initializersLength(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.__vector_len(this.bb_pos+i):0}nodeArgs(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.ValueInfo).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}nodeArgsLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}nodes(i,u){let l=this.bb.__offset(this.bb_pos,8);return l?(u||new e.experimental.fbs.Node).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}nodesLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}maxNodeIndex(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readUint32(this.bb_pos+i):0}nodeEdges(i,u){let l=this.bb.__offset(this.bb_pos,12);return l?(u||new e.experimental.fbs.NodeEdge).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}nodeEdgesLength(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.__vector_len(this.bb_pos+i):0}inputs(i,u){let l=this.bb.__offset(this.bb_pos,14);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}inputsLength(){let i=this.bb.__offset(this.bb_pos,14);return i?this.bb.__vector_len(this.bb_pos+i):0}outputs(i,u){let l=this.bb.__offset(this.bb_pos,16);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}outputsLength(){let i=this.bb.__offset(this.bb_pos,16);return i?this.bb.__vector_len(this.bb_pos+i):0}sparseInitializers(i,u){let l=this.bb.__offset(this.bb_pos,18);return l?(u||new e.experimental.fbs.SparseTensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}sparseInitializersLength(){let i=this.bb.__offset(this.bb_pos,18);return i?this.bb.__vector_len(this.bb_pos+i):0}static startGraph(i){i.startObject(8)}static addInitializers(i,u){i.addFieldOffset(0,u,0)}static createInitializersVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startInitializersVector(i,u){i.startVector(4,u,4)}static addNodeArgs(i,u){i.addFieldOffset(1,u,0)}static createNodeArgsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startNodeArgsVector(i,u){i.startVector(4,u,4)}static addNodes(i,u){i.addFieldOffset(2,u,0)}static createNodesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startNodesVector(i,u){i.startVector(4,u,4)}static addMaxNodeIndex(i,u){i.addFieldInt32(3,u,0)}static addNodeEdges(i,u){i.addFieldOffset(4,u,0)}static createNodeEdgesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startNodeEdgesVector(i,u){i.startVector(4,u,4)}static addInputs(i,u){i.addFieldOffset(5,u,0)}static createInputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startInputsVector(i,u){i.startVector(4,u,4)}static addOutputs(i,u){i.addFieldOffset(6,u,0)}static createOutputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startOutputsVector(i,u){i.startVector(4,u,4)}static addSparseInitializers(i,u){i.addFieldOffset(7,u,0)}static createSparseInitializersVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startSparseInitializersVector(i,u){i.startVector(4,u,4)}static endGraph(i){return i.endObject()}static createGraph(i,u,l,f,p,d,m,g,y){return r.startGraph(i),r.addInitializers(i,u),r.addNodeArgs(i,l),r.addNodes(i,f),r.addMaxNodeIndex(i,p),r.addNodeEdges(i,d),r.addInputs(i,m),r.addOutputs(i,g),r.addSparseInitializers(i,y),r.endGraph(i)}}n.Graph=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsModel(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsModel(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}irVersion(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}opsetImport(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.OperatorSetId).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}opsetImportLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}producerName(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,i):null}producerVersion(i){let u=this.bb.__offset(this.bb_pos,10);return u?this.bb.__string(this.bb_pos+u,i):null}domain(i){let u=this.bb.__offset(this.bb_pos,12);return u?this.bb.__string(this.bb_pos+u,i):null}modelVersion(){let i=this.bb.__offset(this.bb_pos,14);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}docString(i){let u=this.bb.__offset(this.bb_pos,16);return u?this.bb.__string(this.bb_pos+u,i):null}graph(i){let u=this.bb.__offset(this.bb_pos,18);return u?(i||new e.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}graphDocString(i){let u=this.bb.__offset(this.bb_pos,20);return u?this.bb.__string(this.bb_pos+u,i):null}static startModel(i){i.startObject(9)}static addIrVersion(i,u){i.addFieldInt64(0,u,i.createLong(0,0))}static addOpsetImport(i,u){i.addFieldOffset(1,u,0)}static createOpsetImportVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startOpsetImportVector(i,u){i.startVector(4,u,4)}static addProducerName(i,u){i.addFieldOffset(2,u,0)}static addProducerVersion(i,u){i.addFieldOffset(3,u,0)}static addDomain(i,u){i.addFieldOffset(4,u,0)}static addModelVersion(i,u){i.addFieldInt64(5,u,i.createLong(0,0))}static addDocString(i,u){i.addFieldOffset(6,u,0)}static addGraph(i,u){i.addFieldOffset(7,u,0)}static addGraphDocString(i,u){i.addFieldOffset(8,u,0)}static endModel(i){return i.endObject()}static createModel(i,u,l,f,p,d,m,g,y,v){return r.startModel(i),r.addIrVersion(i,u),r.addOpsetImport(i,l),r.addProducerName(i,f),r.addProducerVersion(i,p),r.addDomain(i,d),r.addModelVersion(i,m),r.addDocString(i,g),r.addGraph(i,y),r.addGraphDocString(i,v),r.endModel(i)}}n.Model=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsKernelCreateInfos(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsKernelCreateInfos(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}nodeIndices(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.readUint32(this.bb.__vector(this.bb_pos+u)+i*4):0}nodeIndicesLength(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.__vector_len(this.bb_pos+i):0}nodeIndicesArray(){let i=this.bb.__offset(this.bb_pos,4);return i?new Uint32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}kernelDefHashes(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.readUint64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}kernelDefHashesLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}static startKernelCreateInfos(i){i.startObject(2)}static addNodeIndices(i,u){i.addFieldOffset(0,u,0)}static createNodeIndicesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addInt32(u[l]);return i.endVector()}static startNodeIndicesVector(i,u){i.startVector(4,u,4)}static addKernelDefHashes(i,u){i.addFieldOffset(1,u,0)}static createKernelDefHashesVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startKernelDefHashesVector(i,u){i.startVector(8,u,8)}static endKernelCreateInfos(i){return i.endObject()}static createKernelCreateInfos(i,u,l){return r.startKernelCreateInfos(i),r.addNodeIndices(i,u),r.addKernelDefHashes(i,l),r.endKernelCreateInfos(i)}}n.KernelCreateInfos=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSubGraphSessionState(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSubGraphSessionState(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}graphId(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}sessionState(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new e.experimental.fbs.SessionState).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startSubGraphSessionState(i){i.startObject(2)}static addGraphId(i,u){i.addFieldOffset(0,u,0)}static addSessionState(i,u){i.addFieldOffset(1,u,0)}static endSubGraphSessionState(i){let u=i.endObject();return i.requiredField(u,4),u}static createSubGraphSessionState(i,u,l){return r.startSubGraphSessionState(i),r.addGraphId(i,u),r.addSessionState(i,l),r.endSubGraphSessionState(i)}}n.SubGraphSessionState=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSessionState(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSessionState(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}kernels(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new e.experimental.fbs.KernelCreateInfos).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}subGraphSessionStates(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.SubGraphSessionState).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}subGraphSessionStatesLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}static startSessionState(i){i.startObject(2)}static addKernels(i,u){i.addFieldOffset(0,u,0)}static addSubGraphSessionStates(i,u){i.addFieldOffset(1,u,0)}static createSubGraphSessionStatesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startSubGraphSessionStatesVector(i,u){i.startVector(4,u,4)}static endSessionState(i){return i.endObject()}static createSessionState(i,u,l){return r.startSessionState(i),r.addKernels(i,u),r.addSubGraphSessionStates(i,l),r.endSessionState(i)}}n.SessionState=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={});(e=>{let a;(t=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsInferenceSession(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsInferenceSession(i,u){return i.setPosition(i.position()+b.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static bufferHasIdentifier(i){return i.__has_identifier("ORTM")}ortVersion(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}model(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new e.experimental.fbs.Model).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}sessionState(i){let u=this.bb.__offset(this.bb_pos,8);return u?(i||new e.experimental.fbs.SessionState).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startInferenceSession(i){i.startObject(3)}static addOrtVersion(i,u){i.addFieldOffset(0,u,0)}static addModel(i,u){i.addFieldOffset(1,u,0)}static addSessionState(i,u){i.addFieldOffset(2,u,0)}static endInferenceSession(i){return i.endObject()}static finishInferenceSessionBuffer(i,u){i.finish(u,"ORTM")}static finishSizePrefixedInferenceSessionBuffer(i,u){i.finish(u,"ORTM",!0)}static createInferenceSession(i,u,l,f){return r.startInferenceSession(i),r.addOrtVersion(i,u),r.addModel(i,l),r.addSessionState(i,f),r.endInferenceSession(i)}}n.InferenceSession=r})(o=t.fbs||={})})(a=e.experimental||={})})(P||={})});var Ro=Z((rh,Go)=>{"use strict";Go.exports=Gl;function Gl(a,e){for(var o=new Array(arguments.length-1),t=0,r=2,n=!0;r<arguments.length;)o[t++]=arguments[r++];return new Promise(function(i,u){o[t]=function(f){if(n)if(n=!1,f)u(f);else{for(var p=new Array(arguments.length-1),d=0;d<p.length;)p[d++]=arguments[d];i.apply(null,p)}};try{a.apply(e||null,o)}catch(l){n&&(n=!1,u(l))}})}});var Uo=Z(Mo=>{"use strict";var Ze=Mo;Ze.length=function(e){var o=e.length;if(!o)return 0;for(var t=0;--o%4>1&&e.charAt(o)==="=";)++t;return Math.ceil(e.length*3)/4-t};var ie=new Array(64),zo=new Array(123);for(vt=0;vt<64;)zo[ie[vt]=vt<26?vt+65:vt<52?vt+71:vt<62?vt-4:vt-59|43]=vt++;var vt;Ze.encode=function(e,o,t){for(var r=null,n=[],s=0,i=0,u;o<t;){var l=e[o++];switch(i){case 0:n[s++]=ie[l>>2],u=(l&3)<<4,i=1;break;case 1:n[s++]=ie[u|l>>4],u=(l&15)<<2,i=2;break;case 2:n[s++]=ie[u|l>>6],n[s++]=ie[l&63],i=0;break}s>8191&&((r||(r=[])).push(String.fromCharCode.apply(String,n)),s=0)}return i&&(n[s++]=ie[u],n[s++]=61,i===1&&(n[s++]=61)),r?(s&&r.push(String.fromCharCode.apply(String,n.slice(0,s))),r.join("")):String.fromCharCode.apply(String,n.slice(0,s))};var Vo="invalid encoding";Ze.decode=function(e,o,t){for(var r=t,n=0,s,i=0;i<e.length;){var u=e.charCodeAt(i++);if(u===61&&n>1)break;if((u=zo[u])===void 0)throw Error(Vo);switch(n){case 0:s=u,n=1;break;case 1:o[t++]=s<<2|(u&48)>>4,s=u,n=2;break;case 2:o[t++]=(s&15)<<4|(u&60)>>2,s=u,n=3;break;case 3:o[t++]=(s&3)<<6|u,n=0;break}}if(n===1)throw Error(Vo);return t-r};Ze.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}});var Ho=Z((oh,Wo)=>{"use strict";Wo.exports=Ye;function Ye(){this._listeners={}}Ye.prototype.on=function(e,o,t){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:o,ctx:t||this}),this};Ye.prototype.off=function(e,o){if(e===void 0)this._listeners={};else if(o===void 0)this._listeners[e]=[];else for(var t=this._listeners[e],r=0;r<t.length;)t[r].fn===o?t.splice(r,1):++r;return this};Ye.prototype.emit=function(e){var o=this._listeners[e];if(o){for(var t=[],r=1;r<arguments.length;)t.push(arguments[r++]);for(r=0;r<o.length;)o[r].fn.apply(o[r++].ctx,t)}return this}});var Yo=Z((ih,Zo)=>{"use strict";Zo.exports=qo(qo);function qo(a){return typeof Float32Array<"u"?function(){var e=new Float32Array([-0]),o=new Uint8Array(e.buffer),t=o[3]===128;function r(u,l,f){e[0]=u,l[f]=o[0],l[f+1]=o[1],l[f+2]=o[2],l[f+3]=o[3]}function n(u,l,f){e[0]=u,l[f]=o[3],l[f+1]=o[2],l[f+2]=o[1],l[f+3]=o[0]}a.writeFloatLE=t?r:n,a.writeFloatBE=t?n:r;function s(u,l){return o[0]=u[l],o[1]=u[l+1],o[2]=u[l+2],o[3]=u[l+3],e[0]}function i(u,l){return o[3]=u[l],o[2]=u[l+1],o[1]=u[l+2],o[0]=u[l+3],e[0]}a.readFloatLE=t?s:i,a.readFloatBE=t?i:s}():function(){function e(t,r,n,s){var i=r<0?1:0;if(i&&(r=-r),r===0)t(1/r>0?0:2147483648,n,s);else if(isNaN(r))t(2143289344,n,s);else if(r>34028234663852886e22)t((i<<31|2139095040)>>>0,n,s);else if(r<11754943508222875e-54)t((i<<31|Math.round(r/1401298464324817e-60))>>>0,n,s);else{var u=Math.floor(Math.log(r)/Math.LN2),l=Math.round(r*Math.pow(2,-u)*8388608)&8388607;t((i<<31|u+127<<23|l)>>>0,n,s)}}a.writeFloatLE=e.bind(null,jo),a.writeFloatBE=e.bind(null,Ko);function o(t,r,n){var s=t(r,n),i=(s>>31)*2+1,u=s>>>23&255,l=s&8388607;return u===255?l?NaN:i*(1/0):u===0?i*1401298464324817e-60*l:i*Math.pow(2,u-150)*(l+8388608)}a.readFloatLE=o.bind(null,Xo),a.readFloatBE=o.bind(null,Jo)}(),typeof Float64Array<"u"?function(){var e=new Float64Array([-0]),o=new Uint8Array(e.buffer),t=o[7]===128;function r(u,l,f){e[0]=u,l[f]=o[0],l[f+1]=o[1],l[f+2]=o[2],l[f+3]=o[3],l[f+4]=o[4],l[f+5]=o[5],l[f+6]=o[6],l[f+7]=o[7]}function n(u,l,f){e[0]=u,l[f]=o[7],l[f+1]=o[6],l[f+2]=o[5],l[f+3]=o[4],l[f+4]=o[3],l[f+5]=o[2],l[f+6]=o[1],l[f+7]=o[0]}a.writeDoubleLE=t?r:n,a.writeDoubleBE=t?n:r;function s(u,l){return o[0]=u[l],o[1]=u[l+1],o[2]=u[l+2],o[3]=u[l+3],o[4]=u[l+4],o[5]=u[l+5],o[6]=u[l+6],o[7]=u[l+7],e[0]}function i(u,l){return o[7]=u[l],o[6]=u[l+1],o[5]=u[l+2],o[4]=u[l+3],o[3]=u[l+4],o[2]=u[l+5],o[1]=u[l+6],o[0]=u[l+7],e[0]}a.readDoubleLE=t?s:i,a.readDoubleBE=t?i:s}():function(){function e(t,r,n,s,i,u){var l=s<0?1:0;if(l&&(s=-s),s===0)t(0,i,u+r),t(1/s>0?0:2147483648,i,u+n);else if(isNaN(s))t(0,i,u+r),t(2146959360,i,u+n);else if(s>17976931348623157e292)t(0,i,u+r),t((l<<31|2146435072)>>>0,i,u+n);else{var f;if(s<22250738585072014e-324)f=s/5e-324,t(f>>>0,i,u+r),t((l<<31|f/4294967296)>>>0,i,u+n);else{var p=Math.floor(Math.log(s)/Math.LN2);p===1024&&(p=1023),f=s*Math.pow(2,-p),t(f*4503599627370496>>>0,i,u+r),t((l<<31|p+1023<<20|f*1048576&1048575)>>>0,i,u+n)}}}a.writeDoubleLE=e.bind(null,jo,0,4),a.writeDoubleBE=e.bind(null,Ko,4,0);function o(t,r,n,s,i){var u=t(s,i+r),l=t(s,i+n),f=(l>>31)*2+1,p=l>>>20&2047,d=4294967296*(l&1048575)+u;return p===2047?d?NaN:f*(1/0):p===0?f*5e-324*d:f*Math.pow(2,p-1075)*(d+4503599627370496)}a.readDoubleLE=o.bind(null,Xo,0,4),a.readDoubleBE=o.bind(null,Jo,4,0)}(),a}function jo(a,e,o){e[o]=a&255,e[o+1]=a>>>8&255,e[o+2]=a>>>16&255,e[o+3]=a>>>24}function Ko(a,e,o){e[o]=a>>>24,e[o+1]=a>>>16&255,e[o+2]=a>>>8&255,e[o+3]=a&255}function Xo(a,e){return(a[e]|a[e+1]<<8|a[e+2]<<16|a[e+3]<<24)>>>0}function Jo(a,e){return(a[e]<<24|a[e+1]<<16|a[e+2]<<8|a[e+3])>>>0}});var Qo=Z((exports,module)=>{"use strict";module.exports=inquire;function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(a){}return null}});var ei=Z(ti=>{"use strict";var qr=ti;qr.length=function(e){for(var o=0,t=0,r=0;r<e.length;++r)t=e.charCodeAt(r),t<128?o+=1:t<2048?o+=2:(t&64512)===55296&&(e.charCodeAt(r+1)&64512)===56320?(++r,o+=4):o+=3;return o};qr.read=function(e,o,t){var r=t-o;if(r<1)return"";for(var n=null,s=[],i=0,u;o<t;)u=e[o++],u<128?s[i++]=u:u>191&&u<224?s[i++]=(u&31)<<6|e[o++]&63:u>239&&u<365?(u=((u&7)<<18|(e[o++]&63)<<12|(e[o++]&63)<<6|e[o++]&63)-65536,s[i++]=55296+(u>>10),s[i++]=56320+(u&1023)):s[i++]=(u&15)<<12|(e[o++]&63)<<6|e[o++]&63,i>8191&&((n||(n=[])).push(String.fromCharCode.apply(String,s)),i=0);return n?(i&&n.push(String.fromCharCode.apply(String,s.slice(0,i))),n.join("")):String.fromCharCode.apply(String,s.slice(0,i))};qr.write=function(e,o,t){for(var r=t,n,s,i=0;i<e.length;++i)n=e.charCodeAt(i),n<128?o[t++]=n:n<2048?(o[t++]=n>>6|192,o[t++]=n&63|128):(n&64512)===55296&&((s=e.charCodeAt(i+1))&64512)===56320?(n=65536+((n&1023)<<10)+(s&1023),++i,o[t++]=n>>18|240,o[t++]=n>>12&63|128,o[t++]=n>>6&63|128,o[t++]=n&63|128):(o[t++]=n>>12|224,o[t++]=n>>6&63|128,o[t++]=n&63|128);return t-r}});var ni=Z((sh,ri)=>{"use strict";ri.exports=Rl;function Rl(a,e,o){var t=o||8192,r=t>>>1,n=null,s=t;return function(u){if(u<1||u>r)return a(u);s+u>t&&(n=a(t),s=0);var l=e.call(n,s,s+=u);return s&7&&(s=(s|7)+1),l}}});var ii=Z((uh,oi)=>{"use strict";oi.exports=Q;var ve=Ct();function Q(a,e){this.lo=a>>>0,this.hi=e>>>0}var Ht=Q.zero=new Q(0,0);Ht.toNumber=function(){return 0};Ht.zzEncode=Ht.zzDecode=function(){return this};Ht.length=function(){return 1};var Vl=Q.zeroHash="\0\0\0\0\0\0\0\0";Q.fromNumber=function(e){if(e===0)return Ht;var o=e<0;o&&(e=-e);var t=e>>>0,r=(e-t)/4294967296>>>0;return o&&(r=~r>>>0,t=~t>>>0,++t>4294967295&&(t=0,++r>4294967295&&(r=0))),new Q(t,r)};Q.from=function(e){if(typeof e=="number")return Q.fromNumber(e);if(ve.isString(e))if(ve.Long)e=ve.Long.fromString(e);else return Q.fromNumber(parseInt(e,10));return e.low||e.high?new Q(e.low>>>0,e.high>>>0):Ht};Q.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var o=~this.lo+1>>>0,t=~this.hi>>>0;return o||(t=t+1>>>0),-(o+t*4294967296)}return this.lo+this.hi*4294967296};Q.prototype.toLong=function(e){return ve.Long?new ve.Long(this.lo|0,this.hi|0,!!e):{low:this.lo|0,high:this.hi|0,unsigned:!!e}};var Nt=String.prototype.charCodeAt;Q.fromHash=function(e){return e===Vl?Ht:new Q((Nt.call(e,0)|Nt.call(e,1)<<8|Nt.call(e,2)<<16|Nt.call(e,3)<<24)>>>0,(Nt.call(e,4)|Nt.call(e,5)<<8|Nt.call(e,6)<<16|Nt.call(e,7)<<24)>>>0)};Q.prototype.toHash=function(){return String.fromCharCode(this.lo&255,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,this.hi&255,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)};Q.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this};Q.prototype.zzDecode=function(){var e=-(this.lo&1);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this};Q.prototype.length=function(){var e=this.lo,o=(this.lo>>>28|this.hi<<4)>>>0,t=this.hi>>>24;return t===0?o===0?e<16384?e<128?1:2:e<2097152?3:4:o<16384?o<128?5:6:o<2097152?7:8:t<128?9:10}});var Ct=Z(jr=>{"use strict";var E=jr;E.asPromise=Ro();E.base64=Uo();E.EventEmitter=Ho();E.float=Yo();E.inquire=Qo();E.utf8=ei();E.pool=ni();E.LongBits=ii();E.isNode=!!(typeof global<"u"&&global&&global.process&&global.process.versions&&global.process.versions.node);E.global=E.isNode&&global||typeof window<"u"&&window||typeof self<"u"&&self||jr;E.emptyArray=Object.freeze?Object.freeze([]):[];E.emptyObject=Object.freeze?Object.freeze({}):{};E.isInteger=Number.isInteger||function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e};E.isString=function(e){return typeof e=="string"||e instanceof String};E.isObject=function(e){return e&&typeof e=="object"};E.isset=E.isSet=function(e,o){var t=e[o];return t!=null&&e.hasOwnProperty(o)?typeof t!="object"||(Array.isArray(t)?t.length:Object.keys(t).length)>0:!1};E.Buffer=function(){try{var a=E.inquire("buffer").Buffer;return a.prototype.utf8Write?a:null}catch{return null}}();E._Buffer_from=null;E._Buffer_allocUnsafe=null;E.newBuffer=function(e){return typeof e=="number"?E.Buffer?E._Buffer_allocUnsafe(e):new E.Array(e):E.Buffer?E._Buffer_from(e):typeof Uint8Array>"u"?e:new Uint8Array(e)};E.Array=typeof Uint8Array<"u"?Uint8Array:Array;E.Long=E.global.dcodeIO&&E.global.dcodeIO.Long||E.global.Long||E.inquire("long");E.key2Re=/^true|false|0|1$/;E.key32Re=/^-?(?:0|[1-9][0-9]*)$/;E.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;E.longToHash=function(e){return e?E.LongBits.from(e).toHash():E.LongBits.zeroHash};E.longFromHash=function(e,o){var t=E.LongBits.fromHash(e);return E.Long?E.Long.fromBits(t.lo,t.hi,o):t.toNumber(!!o)};function ai(a,e,o){for(var t=Object.keys(e),r=0;r<t.length;++r)(a[t[r]]===void 0||!o)&&(a[t[r]]=e[t[r]]);return a}E.merge=ai;E.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)};function si(a){function e(o,t){if(!(this instanceof e))return new e(o,t);Object.defineProperty(this,"message",{get:function(){return o}}),Error.captureStackTrace?Error.captureStackTrace(this,e):Object.defineProperty(this,"stack",{value:new Error().stack||""}),t&&ai(this,t)}return e.prototype=Object.create(Error.prototype,{constructor:{value:e,writable:!0,enumerable:!1,configurable:!0},name:{get:function(){return a},set:void 0,enumerable:!1,configurable:!0},toString:{value:function(){return this.name+": "+this.message},writable:!0,enumerable:!1,configurable:!0}}),e}E.newError=si;E.ProtocolError=si("ProtocolError");E.oneOfGetter=function(e){for(var o={},t=0;t<e.length;++t)o[e[t]]=1;return function(){for(var r=Object.keys(this),n=r.length-1;n>-1;--n)if(o[r[n]]===1&&this[r[n]]!==void 0&&this[r[n]]!==null)return r[n]}};E.oneOfSetter=function(e){return function(o){for(var t=0;t<e.length;++t)e[t]!==o&&delete this[e[t]]}};E.toJSONOptions={longs:String,enums:String,bytes:String,json:!0};E._configure=function(){var a=E.Buffer;if(!a){E._Buffer_from=E._Buffer_allocUnsafe=null;return}E._Buffer_from=a.from!==Uint8Array.from&&a.from||function(o,t){return new a(o,t)},E._Buffer_allocUnsafe=a.allocUnsafe||function(o){return new a(o)}}});var tn=Z((fh,ci)=>{"use strict";ci.exports=G;var ht=Ct(),Kr,Qe=ht.LongBits,ui=ht.base64,li=ht.utf8;function we(a,e,o){this.fn=a,this.len=e,this.next=void 0,this.val=o}function Jr(){}function zl(a){this.head=a.head,this.tail=a.tail,this.len=a.len,this.next=a.states}function G(){this.len=0,this.head=new we(Jr,0,0),this.tail=this.head,this.states=null}var fi=function(){return ht.Buffer?function(){return(G.create=function(){return new Kr})()}:function(){return new G}};G.create=fi();G.alloc=function(e){return new ht.Array(e)};ht.Array!==Array&&(G.alloc=ht.pool(G.alloc,ht.Array.prototype.subarray));G.prototype._push=function(e,o,t){return this.tail=this.tail.next=new we(e,o,t),this.len+=o,this};function Zr(a,e,o){e[o]=a&255}function Ml(a,e,o){for(;a>127;)e[o++]=a&127|128,a>>>=7;e[o]=a}function Yr(a,e){this.len=a,this.next=void 0,this.val=e}Yr.prototype=Object.create(we.prototype);Yr.prototype.fn=Ml;G.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new Yr((e=e>>>0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this};G.prototype.int32=function(e){return e<0?this._push(Qr,10,Qe.fromNumber(e)):this.uint32(e)};G.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)};function Qr(a,e,o){for(;a.hi;)e[o++]=a.lo&127|128,a.lo=(a.lo>>>7|a.hi<<25)>>>0,a.hi>>>=7;for(;a.lo>127;)e[o++]=a.lo&127|128,a.lo=a.lo>>>7;e[o++]=a.lo}G.prototype.uint64=function(e){var o=Qe.from(e);return this._push(Qr,o.length(),o)};G.prototype.int64=G.prototype.uint64;G.prototype.sint64=function(e){var o=Qe.from(e).zzEncode();return this._push(Qr,o.length(),o)};G.prototype.bool=function(e){return this._push(Zr,1,e?1:0)};function Xr(a,e,o){e[o]=a&255,e[o+1]=a>>>8&255,e[o+2]=a>>>16&255,e[o+3]=a>>>24}G.prototype.fixed32=function(e){return this._push(Xr,4,e>>>0)};G.prototype.sfixed32=G.prototype.fixed32;G.prototype.fixed64=function(e){var o=Qe.from(e);return this._push(Xr,4,o.lo)._push(Xr,4,o.hi)};G.prototype.sfixed64=G.prototype.fixed64;G.prototype.float=function(e){return this._push(ht.float.writeFloatLE,4,e)};G.prototype.double=function(e){return this._push(ht.float.writeDoubleLE,8,e)};var Ul=ht.Array.prototype.set?function(e,o,t){o.set(e,t)}:function(e,o,t){for(var r=0;r<e.length;++r)o[t+r]=e[r]};G.prototype.bytes=function(e){var o=e.length>>>0;if(!o)return this._push(Zr,1,0);if(ht.isString(e)){var t=G.alloc(o=ui.length(e));ui.decode(e,t,0),e=t}return this.uint32(o)._push(Ul,o,e)};G.prototype.string=function(e){var o=li.length(e);return o?this.uint32(o)._push(li.write,o,e):this._push(Zr,1,0)};G.prototype.fork=function(){return this.states=new zl(this),this.head=this.tail=new we(Jr,0,0),this.len=0,this};G.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new we(Jr,0,0),this.len=0),this};G.prototype.ldelim=function(){var e=this.head,o=this.tail,t=this.len;return this.reset().uint32(t),t&&(this.tail.next=e.next,this.tail=o,this.len+=t),this};G.prototype.finish=function(){for(var e=this.head.next,o=this.constructor.alloc(this.len),t=0;e;)e.fn(e.val,o,t),t+=e.len,e=e.next;return o};G._configure=function(a){Kr=a,G.create=fi(),Kr._configure()}});var hi=Z((ch,di)=>{"use strict";di.exports=St;var pi=tn();(St.prototype=Object.create(pi.prototype)).constructor=St;var Gt=Ct();function St(){pi.call(this)}St._configure=function(){St.alloc=Gt._Buffer_allocUnsafe,St.writeBytesBuffer=Gt.Buffer&&Gt.Buffer.prototype instanceof Uint8Array&&Gt.Buffer.prototype.set.name==="set"?function(e,o,t){o.set(e,t)}:function(e,o,t){if(e.copy)e.copy(o,t,0,e.length);else for(var r=0;r<e.length;)o[t++]=e[r++]}};St.prototype.bytes=function(e){Gt.isString(e)&&(e=Gt._Buffer_from(e,"base64"));var o=e.length>>>0;return this.uint32(o),o&&this._push(St.writeBytesBuffer,o,e),this};function Wl(a,e,o){a.length<40?Gt.utf8.write(a,e,o):e.utf8Write?e.utf8Write(a,o):e.write(a,o)}St.prototype.string=function(e){var o=Gt.Buffer.byteLength(e);return this.uint32(o),o&&this._push(Wl,o,e),this};St._configure()});var nn=Z((ph,xi)=>{"use strict";xi.exports=K;var Ot=Ct(),rn,yi=Ot.LongBits,Hl=Ot.utf8;function wt(a,e){return RangeError("index out of range: "+a.pos+" + "+(e||1)+" > "+a.len)}function K(a){this.buf=a,this.pos=0,this.len=a.length}var mi=typeof Uint8Array<"u"?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new K(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new K(e);throw Error("illegal buffer")},gi=function(){return Ot.Buffer?function(o){return(K.create=function(r){return Ot.Buffer.isBuffer(r)?new rn(r):mi(r)})(o)}:mi};K.create=gi();K.prototype._slice=Ot.Array.prototype.subarray||Ot.Array.prototype.slice;K.prototype.uint32=function(){var e=4294967295;return function(){if(e=(this.buf[this.pos]&127)>>>0,this.buf[this.pos++]<128||(e=(e|(this.buf[this.pos]&127)<<7)>>>0,this.buf[this.pos++]<128)||(e=(e|(this.buf[this.pos]&127)<<14)>>>0,this.buf[this.pos++]<128)||(e=(e|(this.buf[this.pos]&127)<<21)>>>0,this.buf[this.pos++]<128)||(e=(e|(this.buf[this.pos]&15)<<28)>>>0,this.buf[this.pos++]<128))return e;if((this.pos+=5)>this.len)throw this.pos=this.len,wt(this,10);return e}}();K.prototype.int32=function(){return this.uint32()|0};K.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(e&1)|0};function en(){var a=new yi(0,0),e=0;if(this.len-this.pos>4){for(;e<4;++e)if(a.lo=(a.lo|(this.buf[this.pos]&127)<<e*7)>>>0,this.buf[this.pos++]<128)return a;if(a.lo=(a.lo|(this.buf[this.pos]&127)<<28)>>>0,a.hi=(a.hi|(this.buf[this.pos]&127)>>4)>>>0,this.buf[this.pos++]<128)return a;e=0}else{for(;e<3;++e){if(this.pos>=this.len)throw wt(this);if(a.lo=(a.lo|(this.buf[this.pos]&127)<<e*7)>>>0,this.buf[this.pos++]<128)return a}return a.lo=(a.lo|(this.buf[this.pos++]&127)<<e*7)>>>0,a}if(this.len-this.pos>4){for(;e<5;++e)if(a.hi=(a.hi|(this.buf[this.pos]&127)<<e*7+3)>>>0,this.buf[this.pos++]<128)return a}else for(;e<5;++e){if(this.pos>=this.len)throw wt(this);if(a.hi=(a.hi|(this.buf[this.pos]&127)<<e*7+3)>>>0,this.buf[this.pos++]<128)return a}throw Error("invalid varint encoding")}K.prototype.bool=function(){return this.uint32()!==0};function tr(a,e){return(a[e-4]|a[e-3]<<8|a[e-2]<<16|a[e-1]<<24)>>>0}K.prototype.fixed32=function(){if(this.pos+4>this.len)throw wt(this,4);return tr(this.buf,this.pos+=4)};K.prototype.sfixed32=function(){if(this.pos+4>this.len)throw wt(this,4);return tr(this.buf,this.pos+=4)|0};function bi(){if(this.pos+8>this.len)throw wt(this,8);return new yi(tr(this.buf,this.pos+=4),tr(this.buf,this.pos+=4))}K.prototype.float=function(){if(this.pos+4>this.len)throw wt(this,4);var e=Ot.float.readFloatLE(this.buf,this.pos);return this.pos+=4,e};K.prototype.double=function(){if(this.pos+8>this.len)throw wt(this,4);var e=Ot.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,e};K.prototype.bytes=function(){var e=this.uint32(),o=this.pos,t=this.pos+e;if(t>this.len)throw wt(this,e);return this.pos+=e,Array.isArray(this.buf)?this.buf.slice(o,t):o===t?new this.buf.constructor(0):this._slice.call(this.buf,o,t)};K.prototype.string=function(){var e=this.bytes();return Hl.read(e,0,e.length)};K.prototype.skip=function(e){if(typeof e=="number"){if(this.pos+e>this.len)throw wt(this,e);this.pos+=e}else do if(this.pos>=this.len)throw wt(this);while(this.buf[this.pos++]&128);return this};K.prototype.skipType=function(a){switch(a){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;(a=this.uint32()&7)!==4;)this.skipType(a);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+a+" at offset "+this.pos)}return this};K._configure=function(a){rn=a,K.create=gi(),rn._configure();var e=Ot.Long?"toLong":"toNumber";Ot.merge(K.prototype,{int64:function(){return en.call(this)[e](!1)},uint64:function(){return en.call(this)[e](!0)},sint64:function(){return en.call(this).zzDecode()[e](!1)},fixed64:function(){return bi.call(this)[e](!0)},sfixed64:function(){return bi.call(this)[e](!1)}})}});var Ii=Z((dh,wi)=>{"use strict";wi.exports=qt;var vi=nn();(qt.prototype=Object.create(vi.prototype)).constructor=qt;var Ti=Ct();function qt(a){vi.call(this,a)}qt._configure=function(){Ti.Buffer&&(qt.prototype._slice=Ti.Buffer.prototype.slice)};qt.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice?this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len)):this.buf.toString("utf-8",this.pos,this.pos=Math.min(this.pos+e,this.len))};qt._configure()});var Si=Z((hh,_i)=>{"use strict";_i.exports=Ie;var on=Ct();(Ie.prototype=Object.create(on.EventEmitter.prototype)).constructor=Ie;function Ie(a,e,o){if(typeof a!="function")throw TypeError("rpcImpl must be a function");on.EventEmitter.call(this),this.rpcImpl=a,this.requestDelimited=!!e,this.responseDelimited=!!o}Ie.prototype.rpcCall=function a(e,o,t,r,n){if(!r)throw TypeError("request must be specified");var s=this;if(!n)return on.asPromise(a,s,e,o,t,r);if(!s.rpcImpl){setTimeout(function(){n(Error("already ended"))},0);return}try{return s.rpcImpl(e,o[s.requestDelimited?"encodeDelimited":"encode"](r).finish(),function(u,l){if(u)return s.emit("error",u,e),n(u);if(l===null){s.end(!0);return}if(!(l instanceof t))try{l=t[s.responseDelimited?"decodeDelimited":"decode"](l)}catch(f){return s.emit("error",f,e),n(f)}return s.emit("data",l,e),n(null,l)})}catch(i){s.emit("error",i,e),setTimeout(function(){n(i)},0);return}};Ie.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}});var Ai=Z(Oi=>{"use strict";var ql=Oi;ql.Service=Si()});var Ei=Z((bh,Pi)=>{"use strict";Pi.exports={}});var $i=Z(Li=>{"use strict";var lt=Li;lt.build="minimal";lt.Writer=tn();lt.BufferWriter=hi();lt.Reader=nn();lt.BufferReader=Ii();lt.util=Ct();lt.rpc=Ai();lt.roots=Ei();lt.configure=Di;function Di(){lt.util._configure(),lt.Writer._configure(lt.BufferWriter),lt.Reader._configure(lt.BufferReader)}Di()});var Bi=Z((gh,ki)=>{"use strict";ki.exports=$i()});var ae=Z((xh,Fi)=>{"use strict";var W=Bi(),w=W.Reader,X=W.Writer,h=W.util,c=W.roots.default||(W.roots.default={});c.onnx=function(){var a={};return a.Version=function(){var e={},o=Object.create(e);return o[e[0]="_START_VERSION"]=0,o[e[1]="IR_VERSION_2017_10_10"]=1,o[e[2]="IR_VERSION_2017_10_30"]=2,o[e[3]="IR_VERSION_2017_11_3"]=3,o[e[4]="IR_VERSION_2019_1_22"]=4,o[e[5]="IR_VERSION_2019_3_18"]=5,o[e[6]="IR_VERSION_2019_9_19"]=6,o[e[7]="IR_VERSION_2020_5_8"]=7,o[e[8]="IR_VERSION_2021_7_30"]=8,o[e[9]="IR_VERSION"]=9,o}(),a.AttributeProto=function(){function e(o){if(this.floats=[],this.ints=[],this.strings=[],this.tensors=[],this.graphs=[],this.sparseTensors=[],this.typeProtos=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.name="",e.prototype.refAttrName="",e.prototype.docString="",e.prototype.type=0,e.prototype.f=0,e.prototype.i=h.Long?h.Long.fromBits(0,0,!1):0,e.prototype.s=h.newBuffer([]),e.prototype.t=null,e.prototype.g=null,e.prototype.sparseTensor=null,e.prototype.tp=null,e.prototype.floats=h.emptyArray,e.prototype.ints=h.emptyArray,e.prototype.strings=h.emptyArray,e.prototype.tensors=h.emptyArray,e.prototype.graphs=h.emptyArray,e.prototype.sparseTensors=h.emptyArray,e.prototype.typeProtos=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.name!=null&&Object.hasOwnProperty.call(t,"name")&&r.uint32(10).string(t.name),t.f!=null&&Object.hasOwnProperty.call(t,"f")&&r.uint32(21).float(t.f),t.i!=null&&Object.hasOwnProperty.call(t,"i")&&r.uint32(24).int64(t.i),t.s!=null&&Object.hasOwnProperty.call(t,"s")&&r.uint32(34).bytes(t.s),t.t!=null&&Object.hasOwnProperty.call(t,"t")&&c.onnx.TensorProto.encode(t.t,r.uint32(42).fork()).ldelim(),t.g!=null&&Object.hasOwnProperty.call(t,"g")&&c.onnx.GraphProto.encode(t.g,r.uint32(50).fork()).ldelim(),t.floats!=null&&t.floats.length){r.uint32(58).fork();for(var n=0;n<t.floats.length;++n)r.float(t.floats[n]);r.ldelim()}if(t.ints!=null&&t.ints.length){r.uint32(66).fork();for(var n=0;n<t.ints.length;++n)r.int64(t.ints[n]);r.ldelim()}if(t.strings!=null&&t.strings.length)for(var n=0;n<t.strings.length;++n)r.uint32(74).bytes(t.strings[n]);if(t.tensors!=null&&t.tensors.length)for(var n=0;n<t.tensors.length;++n)c.onnx.TensorProto.encode(t.tensors[n],r.uint32(82).fork()).ldelim();if(t.graphs!=null&&t.graphs.length)for(var n=0;n<t.graphs.length;++n)c.onnx.GraphProto.encode(t.graphs[n],r.uint32(90).fork()).ldelim();if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(106).string(t.docString),t.tp!=null&&Object.hasOwnProperty.call(t,"tp")&&c.onnx.TypeProto.encode(t.tp,r.uint32(114).fork()).ldelim(),t.typeProtos!=null&&t.typeProtos.length)for(var n=0;n<t.typeProtos.length;++n)c.onnx.TypeProto.encode(t.typeProtos[n],r.uint32(122).fork()).ldelim();if(t.type!=null&&Object.hasOwnProperty.call(t,"type")&&r.uint32(160).int32(t.type),t.refAttrName!=null&&Object.hasOwnProperty.call(t,"refAttrName")&&r.uint32(170).string(t.refAttrName),t.sparseTensor!=null&&Object.hasOwnProperty.call(t,"sparseTensor")&&c.onnx.SparseTensorProto.encode(t.sparseTensor,r.uint32(178).fork()).ldelim(),t.sparseTensors!=null&&t.sparseTensors.length)for(var n=0;n<t.sparseTensors.length;++n)c.onnx.SparseTensorProto.encode(t.sparseTensors[n],r.uint32(186).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.AttributeProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.name=t.string();break}case 21:{s.refAttrName=t.string();break}case 13:{s.docString=t.string();break}case 20:{s.type=t.int32();break}case 2:{s.f=t.float();break}case 3:{s.i=t.int64();break}case 4:{s.s=t.bytes();break}case 5:{s.t=c.onnx.TensorProto.decode(t,t.uint32());break}case 6:{s.g=c.onnx.GraphProto.decode(t,t.uint32());break}case 22:{s.sparseTensor=c.onnx.SparseTensorProto.decode(t,t.uint32());break}case 14:{s.tp=c.onnx.TypeProto.decode(t,t.uint32());break}case 7:{if(s.floats&&s.floats.length||(s.floats=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.floats.push(t.float());else s.floats.push(t.float());break}case 8:{if(s.ints&&s.ints.length||(s.ints=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.ints.push(t.int64());else s.ints.push(t.int64());break}case 9:{s.strings&&s.strings.length||(s.strings=[]),s.strings.push(t.bytes());break}case 10:{s.tensors&&s.tensors.length||(s.tensors=[]),s.tensors.push(c.onnx.TensorProto.decode(t,t.uint32()));break}case 11:{s.graphs&&s.graphs.length||(s.graphs=[]),s.graphs.push(c.onnx.GraphProto.decode(t,t.uint32()));break}case 23:{s.sparseTensors&&s.sparseTensors.length||(s.sparseTensors=[]),s.sparseTensors.push(c.onnx.SparseTensorProto.decode(t,t.uint32()));break}case 15:{s.typeProtos&&s.typeProtos.length||(s.typeProtos=[]),s.typeProtos.push(c.onnx.TypeProto.decode(t,t.uint32()));break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.name!=null&&t.hasOwnProperty("name")&&!h.isString(t.name))return"name: string expected";if(t.refAttrName!=null&&t.hasOwnProperty("refAttrName")&&!h.isString(t.refAttrName))return"refAttrName: string expected";if(t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString))return"docString: string expected";if(t.type!=null&&t.hasOwnProperty("type"))switch(t.type){default:return"type: enum value expected";case 0:case 1:case 2:case 3:case 4:case 5:case 11:case 13:case 6:case 7:case 8:case 9:case 10:case 12:case 14:break}if(t.f!=null&&t.hasOwnProperty("f")&&typeof t.f!="number")return"f: number expected";if(t.i!=null&&t.hasOwnProperty("i")&&!h.isInteger(t.i)&&!(t.i&&h.isInteger(t.i.low)&&h.isInteger(t.i.high)))return"i: integer|Long expected";if(t.s!=null&&t.hasOwnProperty("s")&&!(t.s&&typeof t.s.length=="number"||h.isString(t.s)))return"s: buffer expected";if(t.t!=null&&t.hasOwnProperty("t")){var r=c.onnx.TensorProto.verify(t.t);if(r)return"t."+r}if(t.g!=null&&t.hasOwnProperty("g")){var r=c.onnx.GraphProto.verify(t.g);if(r)return"g."+r}if(t.sparseTensor!=null&&t.hasOwnProperty("sparseTensor")){var r=c.onnx.SparseTensorProto.verify(t.sparseTensor);if(r)return"sparseTensor."+r}if(t.tp!=null&&t.hasOwnProperty("tp")){var r=c.onnx.TypeProto.verify(t.tp);if(r)return"tp."+r}if(t.floats!=null&&t.hasOwnProperty("floats")){if(!Array.isArray(t.floats))return"floats: array expected";for(var n=0;n<t.floats.length;++n)if(typeof t.floats[n]!="number")return"floats: number[] expected"}if(t.ints!=null&&t.hasOwnProperty("ints")){if(!Array.isArray(t.ints))return"ints: array expected";for(var n=0;n<t.ints.length;++n)if(!h.isInteger(t.ints[n])&&!(t.ints[n]&&h.isInteger(t.ints[n].low)&&h.isInteger(t.ints[n].high)))return"ints: integer|Long[] expected"}if(t.strings!=null&&t.hasOwnProperty("strings")){if(!Array.isArray(t.strings))return"strings: array expected";for(var n=0;n<t.strings.length;++n)if(!(t.strings[n]&&typeof t.strings[n].length=="number"||h.isString(t.strings[n])))return"strings: buffer[] expected"}if(t.tensors!=null&&t.hasOwnProperty("tensors")){if(!Array.isArray(t.tensors))return"tensors: array expected";for(var n=0;n<t.tensors.length;++n){var r=c.onnx.TensorProto.verify(t.tensors[n]);if(r)return"tensors."+r}}if(t.graphs!=null&&t.hasOwnProperty("graphs")){if(!Array.isArray(t.graphs))return"graphs: array expected";for(var n=0;n<t.graphs.length;++n){var r=c.onnx.GraphProto.verify(t.graphs[n]);if(r)return"graphs."+r}}if(t.sparseTensors!=null&&t.hasOwnProperty("sparseTensors")){if(!Array.isArray(t.sparseTensors))return"sparseTensors: array expected";for(var n=0;n<t.sparseTensors.length;++n){var r=c.onnx.SparseTensorProto.verify(t.sparseTensors[n]);if(r)return"sparseTensors."+r}}if(t.typeProtos!=null&&t.hasOwnProperty("typeProtos")){if(!Array.isArray(t.typeProtos))return"typeProtos: array expected";for(var n=0;n<t.typeProtos.length;++n){var r=c.onnx.TypeProto.verify(t.typeProtos[n]);if(r)return"typeProtos."+r}}return null},e.fromObject=function(t){if(t instanceof c.onnx.AttributeProto)return t;var r=new c.onnx.AttributeProto;switch(t.name!=null&&(r.name=String(t.name)),t.refAttrName!=null&&(r.refAttrName=String(t.refAttrName)),t.docString!=null&&(r.docString=String(t.docString)),t.type){default:if(typeof t.type=="number"){r.type=t.type;break}break;case"UNDEFINED":case 0:r.type=0;break;case"FLOAT":case 1:r.type=1;break;case"INT":case 2:r.type=2;break;case"STRING":case 3:r.type=3;break;case"TENSOR":case 4:r.type=4;break;case"GRAPH":case 5:r.type=5;break;case"SPARSE_TENSOR":case 11:r.type=11;break;case"TYPE_PROTO":case 13:r.type=13;break;case"FLOATS":case 6:r.type=6;break;case"INTS":case 7:r.type=7;break;case"STRINGS":case 8:r.type=8;break;case"TENSORS":case 9:r.type=9;break;case"GRAPHS":case 10:r.type=10;break;case"SPARSE_TENSORS":case 12:r.type=12;break;case"TYPE_PROTOS":case 14:r.type=14;break}if(t.f!=null&&(r.f=Number(t.f)),t.i!=null&&(h.Long?(r.i=h.Long.fromValue(t.i)).unsigned=!1:typeof t.i=="string"?r.i=parseInt(t.i,10):typeof t.i=="number"?r.i=t.i:typeof t.i=="object"&&(r.i=new h.LongBits(t.i.low>>>0,t.i.high>>>0).toNumber())),t.s!=null&&(typeof t.s=="string"?h.base64.decode(t.s,r.s=h.newBuffer(h.base64.length(t.s)),0):t.s.length>=0&&(r.s=t.s)),t.t!=null){if(typeof t.t!="object")throw TypeError(".onnx.AttributeProto.t: object expected");r.t=c.onnx.TensorProto.fromObject(t.t)}if(t.g!=null){if(typeof t.g!="object")throw TypeError(".onnx.AttributeProto.g: object expected");r.g=c.onnx.GraphProto.fromObject(t.g)}if(t.sparseTensor!=null){if(typeof t.sparseTensor!="object")throw TypeError(".onnx.AttributeProto.sparseTensor: object expected");r.sparseTensor=c.onnx.SparseTensorProto.fromObject(t.sparseTensor)}if(t.tp!=null){if(typeof t.tp!="object")throw TypeError(".onnx.AttributeProto.tp: object expected");r.tp=c.onnx.TypeProto.fromObject(t.tp)}if(t.floats){if(!Array.isArray(t.floats))throw TypeError(".onnx.AttributeProto.floats: array expected");r.floats=[];for(var n=0;n<t.floats.length;++n)r.floats[n]=Number(t.floats[n])}if(t.ints){if(!Array.isArray(t.ints))throw TypeError(".onnx.AttributeProto.ints: array expected");r.ints=[];for(var n=0;n<t.ints.length;++n)h.Long?(r.ints[n]=h.Long.fromValue(t.ints[n])).unsigned=!1:typeof t.ints[n]=="string"?r.ints[n]=parseInt(t.ints[n],10):typeof t.ints[n]=="number"?r.ints[n]=t.ints[n]:typeof t.ints[n]=="object"&&(r.ints[n]=new h.LongBits(t.ints[n].low>>>0,t.ints[n].high>>>0).toNumber())}if(t.strings){if(!Array.isArray(t.strings))throw TypeError(".onnx.AttributeProto.strings: array expected");r.strings=[];for(var n=0;n<t.strings.length;++n)typeof t.strings[n]=="string"?h.base64.decode(t.strings[n],r.strings[n]=h.newBuffer(h.base64.length(t.strings[n])),0):t.strings[n].length>=0&&(r.strings[n]=t.strings[n])}if(t.tensors){if(!Array.isArray(t.tensors))throw TypeError(".onnx.AttributeProto.tensors: array expected");r.tensors=[];for(var n=0;n<t.tensors.length;++n){if(typeof t.tensors[n]!="object")throw TypeError(".onnx.AttributeProto.tensors: object expected");r.tensors[n]=c.onnx.TensorProto.fromObject(t.tensors[n])}}if(t.graphs){if(!Array.isArray(t.graphs))throw TypeError(".onnx.AttributeProto.graphs: array expected");r.graphs=[];for(var n=0;n<t.graphs.length;++n){if(typeof t.graphs[n]!="object")throw TypeError(".onnx.AttributeProto.graphs: object expected");r.graphs[n]=c.onnx.GraphProto.fromObject(t.graphs[n])}}if(t.sparseTensors){if(!Array.isArray(t.sparseTensors))throw TypeError(".onnx.AttributeProto.sparseTensors: array expected");r.sparseTensors=[];for(var n=0;n<t.sparseTensors.length;++n){if(typeof t.sparseTensors[n]!="object")throw TypeError(".onnx.AttributeProto.sparseTensors: object expected");r.sparseTensors[n]=c.onnx.SparseTensorProto.fromObject(t.sparseTensors[n])}}if(t.typeProtos){if(!Array.isArray(t.typeProtos))throw TypeError(".onnx.AttributeProto.typeProtos: array expected");r.typeProtos=[];for(var n=0;n<t.typeProtos.length;++n){if(typeof t.typeProtos[n]!="object")throw TypeError(".onnx.AttributeProto.typeProtos: object expected");r.typeProtos[n]=c.onnx.TypeProto.fromObject(t.typeProtos[n])}}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.floats=[],n.ints=[],n.strings=[],n.tensors=[],n.graphs=[],n.typeProtos=[],n.sparseTensors=[]),r.defaults){if(n.name="",n.f=0,h.Long){var s=new h.Long(0,0,!1);n.i=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.i=r.longs===String?"0":0;r.bytes===String?n.s="":(n.s=[],r.bytes!==Array&&(n.s=h.newBuffer(n.s))),n.t=null,n.g=null,n.docString="",n.tp=null,n.type=r.enums===String?"UNDEFINED":0,n.refAttrName="",n.sparseTensor=null}if(t.name!=null&&t.hasOwnProperty("name")&&(n.name=t.name),t.f!=null&&t.hasOwnProperty("f")&&(n.f=r.json&&!isFinite(t.f)?String(t.f):t.f),t.i!=null&&t.hasOwnProperty("i")&&(typeof t.i=="number"?n.i=r.longs===String?String(t.i):t.i:n.i=r.longs===String?h.Long.prototype.toString.call(t.i):r.longs===Number?new h.LongBits(t.i.low>>>0,t.i.high>>>0).toNumber():t.i),t.s!=null&&t.hasOwnProperty("s")&&(n.s=r.bytes===String?h.base64.encode(t.s,0,t.s.length):r.bytes===Array?Array.prototype.slice.call(t.s):t.s),t.t!=null&&t.hasOwnProperty("t")&&(n.t=c.onnx.TensorProto.toObject(t.t,r)),t.g!=null&&t.hasOwnProperty("g")&&(n.g=c.onnx.GraphProto.toObject(t.g,r)),t.floats&&t.floats.length){n.floats=[];for(var i=0;i<t.floats.length;++i)n.floats[i]=r.json&&!isFinite(t.floats[i])?String(t.floats[i]):t.floats[i]}if(t.ints&&t.ints.length){n.ints=[];for(var i=0;i<t.ints.length;++i)typeof t.ints[i]=="number"?n.ints[i]=r.longs===String?String(t.ints[i]):t.ints[i]:n.ints[i]=r.longs===String?h.Long.prototype.toString.call(t.ints[i]):r.longs===Number?new h.LongBits(t.ints[i].low>>>0,t.ints[i].high>>>0).toNumber():t.ints[i]}if(t.strings&&t.strings.length){n.strings=[];for(var i=0;i<t.strings.length;++i)n.strings[i]=r.bytes===String?h.base64.encode(t.strings[i],0,t.strings[i].length):r.bytes===Array?Array.prototype.slice.call(t.strings[i]):t.strings[i]}if(t.tensors&&t.tensors.length){n.tensors=[];for(var i=0;i<t.tensors.length;++i)n.tensors[i]=c.onnx.TensorProto.toObject(t.tensors[i],r)}if(t.graphs&&t.graphs.length){n.graphs=[];for(var i=0;i<t.graphs.length;++i)n.graphs[i]=c.onnx.GraphProto.toObject(t.graphs[i],r)}if(t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),t.tp!=null&&t.hasOwnProperty("tp")&&(n.tp=c.onnx.TypeProto.toObject(t.tp,r)),t.typeProtos&&t.typeProtos.length){n.typeProtos=[];for(var i=0;i<t.typeProtos.length;++i)n.typeProtos[i]=c.onnx.TypeProto.toObject(t.typeProtos[i],r)}if(t.type!=null&&t.hasOwnProperty("type")&&(n.type=r.enums===String?c.onnx.AttributeProto.AttributeType[t.type]===void 0?t.type:c.onnx.AttributeProto.AttributeType[t.type]:t.type),t.refAttrName!=null&&t.hasOwnProperty("refAttrName")&&(n.refAttrName=t.refAttrName),t.sparseTensor!=null&&t.hasOwnProperty("sparseTensor")&&(n.sparseTensor=c.onnx.SparseTensorProto.toObject(t.sparseTensor,r)),t.sparseTensors&&t.sparseTensors.length){n.sparseTensors=[];for(var i=0;i<t.sparseTensors.length;++i)n.sparseTensors[i]=c.onnx.SparseTensorProto.toObject(t.sparseTensors[i],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.AttributeProto"},e.AttributeType=function(){var o={},t=Object.create(o);return t[o[0]="UNDEFINED"]=0,t[o[1]="FLOAT"]=1,t[o[2]="INT"]=2,t[o[3]="STRING"]=3,t[o[4]="TENSOR"]=4,t[o[5]="GRAPH"]=5,t[o[11]="SPARSE_TENSOR"]=11,t[o[13]="TYPE_PROTO"]=13,t[o[6]="FLOATS"]=6,t[o[7]="INTS"]=7,t[o[8]="STRINGS"]=8,t[o[9]="TENSORS"]=9,t[o[10]="GRAPHS"]=10,t[o[12]="SPARSE_TENSORS"]=12,t[o[14]="TYPE_PROTOS"]=14,t}(),e}(),a.ValueInfoProto=function(){function e(o){if(o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.name="",e.prototype.type=null,e.prototype.docString="",e.create=function(t){return new e(t)},e.encode=function(t,r){return r||(r=X.create()),t.name!=null&&Object.hasOwnProperty.call(t,"name")&&r.uint32(10).string(t.name),t.type!=null&&Object.hasOwnProperty.call(t,"type")&&c.onnx.TypeProto.encode(t.type,r.uint32(18).fork()).ldelim(),t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(26).string(t.docString),r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.ValueInfoProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.name=t.string();break}case 2:{s.type=c.onnx.TypeProto.decode(t,t.uint32());break}case 3:{s.docString=t.string();break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.name!=null&&t.hasOwnProperty("name")&&!h.isString(t.name))return"name: string expected";if(t.type!=null&&t.hasOwnProperty("type")){var r=c.onnx.TypeProto.verify(t.type);if(r)return"type."+r}return t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString)?"docString: string expected":null},e.fromObject=function(t){if(t instanceof c.onnx.ValueInfoProto)return t;var r=new c.onnx.ValueInfoProto;if(t.name!=null&&(r.name=String(t.name)),t.type!=null){if(typeof t.type!="object")throw TypeError(".onnx.ValueInfoProto.type: object expected");r.type=c.onnx.TypeProto.fromObject(t.type)}return t.docString!=null&&(r.docString=String(t.docString)),r},e.toObject=function(t,r){r||(r={});var n={};return r.defaults&&(n.name="",n.type=null,n.docString=""),t.name!=null&&t.hasOwnProperty("name")&&(n.name=t.name),t.type!=null&&t.hasOwnProperty("type")&&(n.type=c.onnx.TypeProto.toObject(t.type,r)),t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.ValueInfoProto"},e}(),a.NodeProto=function(){function e(o){if(this.input=[],this.output=[],this.attribute=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.input=h.emptyArray,e.prototype.output=h.emptyArray,e.prototype.name="",e.prototype.opType="",e.prototype.domain="",e.prototype.attribute=h.emptyArray,e.prototype.docString="",e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.input!=null&&t.input.length)for(var n=0;n<t.input.length;++n)r.uint32(10).string(t.input[n]);if(t.output!=null&&t.output.length)for(var n=0;n<t.output.length;++n)r.uint32(18).string(t.output[n]);if(t.name!=null&&Object.hasOwnProperty.call(t,"name")&&r.uint32(26).string(t.name),t.opType!=null&&Object.hasOwnProperty.call(t,"opType")&&r.uint32(34).string(t.opType),t.attribute!=null&&t.attribute.length)for(var n=0;n<t.attribute.length;++n)c.onnx.AttributeProto.encode(t.attribute[n],r.uint32(42).fork()).ldelim();return t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(50).string(t.docString),t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&r.uint32(58).string(t.domain),r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.NodeProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.input&&s.input.length||(s.input=[]),s.input.push(t.string());break}case 2:{s.output&&s.output.length||(s.output=[]),s.output.push(t.string());break}case 3:{s.name=t.string();break}case 4:{s.opType=t.string();break}case 7:{s.domain=t.string();break}case 5:{s.attribute&&s.attribute.length||(s.attribute=[]),s.attribute.push(c.onnx.AttributeProto.decode(t,t.uint32()));break}case 6:{s.docString=t.string();break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.input!=null&&t.hasOwnProperty("input")){if(!Array.isArray(t.input))return"input: array expected";for(var r=0;r<t.input.length;++r)if(!h.isString(t.input[r]))return"input: string[] expected"}if(t.output!=null&&t.hasOwnProperty("output")){if(!Array.isArray(t.output))return"output: array expected";for(var r=0;r<t.output.length;++r)if(!h.isString(t.output[r]))return"output: string[] expected"}if(t.name!=null&&t.hasOwnProperty("name")&&!h.isString(t.name))return"name: string expected";if(t.opType!=null&&t.hasOwnProperty("opType")&&!h.isString(t.opType))return"opType: string expected";if(t.domain!=null&&t.hasOwnProperty("domain")&&!h.isString(t.domain))return"domain: string expected";if(t.attribute!=null&&t.hasOwnProperty("attribute")){if(!Array.isArray(t.attribute))return"attribute: array expected";for(var r=0;r<t.attribute.length;++r){var n=c.onnx.AttributeProto.verify(t.attribute[r]);if(n)return"attribute."+n}}return t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString)?"docString: string expected":null},e.fromObject=function(t){if(t instanceof c.onnx.NodeProto)return t;var r=new c.onnx.NodeProto;if(t.input){if(!Array.isArray(t.input))throw TypeError(".onnx.NodeProto.input: array expected");r.input=[];for(var n=0;n<t.input.length;++n)r.input[n]=String(t.input[n])}if(t.output){if(!Array.isArray(t.output))throw TypeError(".onnx.NodeProto.output: array expected");r.output=[];for(var n=0;n<t.output.length;++n)r.output[n]=String(t.output[n])}if(t.name!=null&&(r.name=String(t.name)),t.opType!=null&&(r.opType=String(t.opType)),t.domain!=null&&(r.domain=String(t.domain)),t.attribute){if(!Array.isArray(t.attribute))throw TypeError(".onnx.NodeProto.attribute: array expected");r.attribute=[];for(var n=0;n<t.attribute.length;++n){if(typeof t.attribute[n]!="object")throw TypeError(".onnx.NodeProto.attribute: object expected");r.attribute[n]=c.onnx.AttributeProto.fromObject(t.attribute[n])}}return t.docString!=null&&(r.docString=String(t.docString)),r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.input=[],n.output=[],n.attribute=[]),r.defaults&&(n.name="",n.opType="",n.docString="",n.domain=""),t.input&&t.input.length){n.input=[];for(var s=0;s<t.input.length;++s)n.input[s]=t.input[s]}if(t.output&&t.output.length){n.output=[];for(var s=0;s<t.output.length;++s)n.output[s]=t.output[s]}if(t.name!=null&&t.hasOwnProperty("name")&&(n.name=t.name),t.opType!=null&&t.hasOwnProperty("opType")&&(n.opType=t.opType),t.attribute&&t.attribute.length){n.attribute=[];for(var s=0;s<t.attribute.length;++s)n.attribute[s]=c.onnx.AttributeProto.toObject(t.attribute[s],r)}return t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),t.domain!=null&&t.hasOwnProperty("domain")&&(n.domain=t.domain),n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.NodeProto"},e}(),a.TrainingInfoProto=function(){function e(o){if(this.initializationBinding=[],this.updateBinding=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.initialization=null,e.prototype.algorithm=null,e.prototype.initializationBinding=h.emptyArray,e.prototype.updateBinding=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.initialization!=null&&Object.hasOwnProperty.call(t,"initialization")&&c.onnx.GraphProto.encode(t.initialization,r.uint32(10).fork()).ldelim(),t.algorithm!=null&&Object.hasOwnProperty.call(t,"algorithm")&&c.onnx.GraphProto.encode(t.algorithm,r.uint32(18).fork()).ldelim(),t.initializationBinding!=null&&t.initializationBinding.length)for(var n=0;n<t.initializationBinding.length;++n)c.onnx.StringStringEntryProto.encode(t.initializationBinding[n],r.uint32(26).fork()).ldelim();if(t.updateBinding!=null&&t.updateBinding.length)for(var n=0;n<t.updateBinding.length;++n)c.onnx.StringStringEntryProto.encode(t.updateBinding[n],r.uint32(34).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.TrainingInfoProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.initialization=c.onnx.GraphProto.decode(t,t.uint32());break}case 2:{s.algorithm=c.onnx.GraphProto.decode(t,t.uint32());break}case 3:{s.initializationBinding&&s.initializationBinding.length||(s.initializationBinding=[]),s.initializationBinding.push(c.onnx.StringStringEntryProto.decode(t,t.uint32()));break}case 4:{s.updateBinding&&s.updateBinding.length||(s.updateBinding=[]),s.updateBinding.push(c.onnx.StringStringEntryProto.decode(t,t.uint32()));break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.initialization!=null&&t.hasOwnProperty("initialization")){var r=c.onnx.GraphProto.verify(t.initialization);if(r)return"initialization."+r}if(t.algorithm!=null&&t.hasOwnProperty("algorithm")){var r=c.onnx.GraphProto.verify(t.algorithm);if(r)return"algorithm."+r}if(t.initializationBinding!=null&&t.hasOwnProperty("initializationBinding")){if(!Array.isArray(t.initializationBinding))return"initializationBinding: array expected";for(var n=0;n<t.initializationBinding.length;++n){var r=c.onnx.StringStringEntryProto.verify(t.initializationBinding[n]);if(r)return"initializationBinding."+r}}if(t.updateBinding!=null&&t.hasOwnProperty("updateBinding")){if(!Array.isArray(t.updateBinding))return"updateBinding: array expected";for(var n=0;n<t.updateBinding.length;++n){var r=c.onnx.StringStringEntryProto.verify(t.updateBinding[n]);if(r)return"updateBinding."+r}}return null},e.fromObject=function(t){if(t instanceof c.onnx.TrainingInfoProto)return t;var r=new c.onnx.TrainingInfoProto;if(t.initialization!=null){if(typeof t.initialization!="object")throw TypeError(".onnx.TrainingInfoProto.initialization: object expected");r.initialization=c.onnx.GraphProto.fromObject(t.initialization)}if(t.algorithm!=null){if(typeof t.algorithm!="object")throw TypeError(".onnx.TrainingInfoProto.algorithm: object expected");r.algorithm=c.onnx.GraphProto.fromObject(t.algorithm)}if(t.initializationBinding){if(!Array.isArray(t.initializationBinding))throw TypeError(".onnx.TrainingInfoProto.initializationBinding: array expected");r.initializationBinding=[];for(var n=0;n<t.initializationBinding.length;++n){if(typeof t.initializationBinding[n]!="object")throw TypeError(".onnx.TrainingInfoProto.initializationBinding: object expected");r.initializationBinding[n]=c.onnx.StringStringEntryProto.fromObject(t.initializationBinding[n])}}if(t.updateBinding){if(!Array.isArray(t.updateBinding))throw TypeError(".onnx.TrainingInfoProto.updateBinding: array expected");r.updateBinding=[];for(var n=0;n<t.updateBinding.length;++n){if(typeof t.updateBinding[n]!="object")throw TypeError(".onnx.TrainingInfoProto.updateBinding: object expected");r.updateBinding[n]=c.onnx.StringStringEntryProto.fromObject(t.updateBinding[n])}}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.initializationBinding=[],n.updateBinding=[]),r.defaults&&(n.initialization=null,n.algorithm=null),t.initialization!=null&&t.hasOwnProperty("initialization")&&(n.initialization=c.onnx.GraphProto.toObject(t.initialization,r)),t.algorithm!=null&&t.hasOwnProperty("algorithm")&&(n.algorithm=c.onnx.GraphProto.toObject(t.algorithm,r)),t.initializationBinding&&t.initializationBinding.length){n.initializationBinding=[];for(var s=0;s<t.initializationBinding.length;++s)n.initializationBinding[s]=c.onnx.StringStringEntryProto.toObject(t.initializationBinding[s],r)}if(t.updateBinding&&t.updateBinding.length){n.updateBinding=[];for(var s=0;s<t.updateBinding.length;++s)n.updateBinding[s]=c.onnx.StringStringEntryProto.toObject(t.updateBinding[s],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TrainingInfoProto"},e}(),a.ModelProto=function(){function e(o){if(this.opsetImport=[],this.metadataProps=[],this.trainingInfo=[],this.functions=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.irVersion=h.Long?h.Long.fromBits(0,0,!1):0,e.prototype.opsetImport=h.emptyArray,e.prototype.producerName="",e.prototype.producerVersion="",e.prototype.domain="",e.prototype.modelVersion=h.Long?h.Long.fromBits(0,0,!1):0,e.prototype.docString="",e.prototype.graph=null,e.prototype.metadataProps=h.emptyArray,e.prototype.trainingInfo=h.emptyArray,e.prototype.functions=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.irVersion!=null&&Object.hasOwnProperty.call(t,"irVersion")&&r.uint32(8).int64(t.irVersion),t.producerName!=null&&Object.hasOwnProperty.call(t,"producerName")&&r.uint32(18).string(t.producerName),t.producerVersion!=null&&Object.hasOwnProperty.call(t,"producerVersion")&&r.uint32(26).string(t.producerVersion),t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&r.uint32(34).string(t.domain),t.modelVersion!=null&&Object.hasOwnProperty.call(t,"modelVersion")&&r.uint32(40).int64(t.modelVersion),t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(50).string(t.docString),t.graph!=null&&Object.hasOwnProperty.call(t,"graph")&&c.onnx.GraphProto.encode(t.graph,r.uint32(58).fork()).ldelim(),t.opsetImport!=null&&t.opsetImport.length)for(var n=0;n<t.opsetImport.length;++n)c.onnx.OperatorSetIdProto.encode(t.opsetImport[n],r.uint32(66).fork()).ldelim();if(t.metadataProps!=null&&t.metadataProps.length)for(var n=0;n<t.metadataProps.length;++n)c.onnx.StringStringEntryProto.encode(t.metadataProps[n],r.uint32(114).fork()).ldelim();if(t.trainingInfo!=null&&t.trainingInfo.length)for(var n=0;n<t.trainingInfo.length;++n)c.onnx.TrainingInfoProto.encode(t.trainingInfo[n],r.uint32(162).fork()).ldelim();if(t.functions!=null&&t.functions.length)for(var n=0;n<t.functions.length;++n)c.onnx.FunctionProto.encode(t.functions[n],r.uint32(202).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.ModelProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.irVersion=t.int64();break}case 8:{s.opsetImport&&s.opsetImport.length||(s.opsetImport=[]),s.opsetImport.push(c.onnx.OperatorSetIdProto.decode(t,t.uint32()));break}case 2:{s.producerName=t.string();break}case 3:{s.producerVersion=t.string();break}case 4:{s.domain=t.string();break}case 5:{s.modelVersion=t.int64();break}case 6:{s.docString=t.string();break}case 7:{s.graph=c.onnx.GraphProto.decode(t,t.uint32());break}case 14:{s.metadataProps&&s.metadataProps.length||(s.metadataProps=[]),s.metadataProps.push(c.onnx.StringStringEntryProto.decode(t,t.uint32()));break}case 20:{s.trainingInfo&&s.trainingInfo.length||(s.trainingInfo=[]),s.trainingInfo.push(c.onnx.TrainingInfoProto.decode(t,t.uint32()));break}case 25:{s.functions&&s.functions.length||(s.functions=[]),s.functions.push(c.onnx.FunctionProto.decode(t,t.uint32()));break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.irVersion!=null&&t.hasOwnProperty("irVersion")&&!h.isInteger(t.irVersion)&&!(t.irVersion&&h.isInteger(t.irVersion.low)&&h.isInteger(t.irVersion.high)))return"irVersion: integer|Long expected";if(t.opsetImport!=null&&t.hasOwnProperty("opsetImport")){if(!Array.isArray(t.opsetImport))return"opsetImport: array expected";for(var r=0;r<t.opsetImport.length;++r){var n=c.onnx.OperatorSetIdProto.verify(t.opsetImport[r]);if(n)return"opsetImport."+n}}if(t.producerName!=null&&t.hasOwnProperty("producerName")&&!h.isString(t.producerName))return"producerName: string expected";if(t.producerVersion!=null&&t.hasOwnProperty("producerVersion")&&!h.isString(t.producerVersion))return"producerVersion: string expected";if(t.domain!=null&&t.hasOwnProperty("domain")&&!h.isString(t.domain))return"domain: string expected";if(t.modelVersion!=null&&t.hasOwnProperty("modelVersion")&&!h.isInteger(t.modelVersion)&&!(t.modelVersion&&h.isInteger(t.modelVersion.low)&&h.isInteger(t.modelVersion.high)))return"modelVersion: integer|Long expected";if(t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString))return"docString: string expected";if(t.graph!=null&&t.hasOwnProperty("graph")){var n=c.onnx.GraphProto.verify(t.graph);if(n)return"graph."+n}if(t.metadataProps!=null&&t.hasOwnProperty("metadataProps")){if(!Array.isArray(t.metadataProps))return"metadataProps: array expected";for(var r=0;r<t.metadataProps.length;++r){var n=c.onnx.StringStringEntryProto.verify(t.metadataProps[r]);if(n)return"metadataProps."+n}}if(t.trainingInfo!=null&&t.hasOwnProperty("trainingInfo")){if(!Array.isArray(t.trainingInfo))return"trainingInfo: array expected";for(var r=0;r<t.trainingInfo.length;++r){var n=c.onnx.TrainingInfoProto.verify(t.trainingInfo[r]);if(n)return"trainingInfo."+n}}if(t.functions!=null&&t.hasOwnProperty("functions")){if(!Array.isArray(t.functions))return"functions: array expected";for(var r=0;r<t.functions.length;++r){var n=c.onnx.FunctionProto.verify(t.functions[r]);if(n)return"functions."+n}}return null},e.fromObject=function(t){if(t instanceof c.onnx.ModelProto)return t;var r=new c.onnx.ModelProto;if(t.irVersion!=null&&(h.Long?(r.irVersion=h.Long.fromValue(t.irVersion)).unsigned=!1:typeof t.irVersion=="string"?r.irVersion=parseInt(t.irVersion,10):typeof t.irVersion=="number"?r.irVersion=t.irVersion:typeof t.irVersion=="object"&&(r.irVersion=new h.LongBits(t.irVersion.low>>>0,t.irVersion.high>>>0).toNumber())),t.opsetImport){if(!Array.isArray(t.opsetImport))throw TypeError(".onnx.ModelProto.opsetImport: array expected");r.opsetImport=[];for(var n=0;n<t.opsetImport.length;++n){if(typeof t.opsetImport[n]!="object")throw TypeError(".onnx.ModelProto.opsetImport: object expected");r.opsetImport[n]=c.onnx.OperatorSetIdProto.fromObject(t.opsetImport[n])}}if(t.producerName!=null&&(r.producerName=String(t.producerName)),t.producerVersion!=null&&(r.producerVersion=String(t.producerVersion)),t.domain!=null&&(r.domain=String(t.domain)),t.modelVersion!=null&&(h.Long?(r.modelVersion=h.Long.fromValue(t.modelVersion)).unsigned=!1:typeof t.modelVersion=="string"?r.modelVersion=parseInt(t.modelVersion,10):typeof t.modelVersion=="number"?r.modelVersion=t.modelVersion:typeof t.modelVersion=="object"&&(r.modelVersion=new h.LongBits(t.modelVersion.low>>>0,t.modelVersion.high>>>0).toNumber())),t.docString!=null&&(r.docString=String(t.docString)),t.graph!=null){if(typeof t.graph!="object")throw TypeError(".onnx.ModelProto.graph: object expected");r.graph=c.onnx.GraphProto.fromObject(t.graph)}if(t.metadataProps){if(!Array.isArray(t.metadataProps))throw TypeError(".onnx.ModelProto.metadataProps: array expected");r.metadataProps=[];for(var n=0;n<t.metadataProps.length;++n){if(typeof t.metadataProps[n]!="object")throw TypeError(".onnx.ModelProto.metadataProps: object expected");r.metadataProps[n]=c.onnx.StringStringEntryProto.fromObject(t.metadataProps[n])}}if(t.trainingInfo){if(!Array.isArray(t.trainingInfo))throw TypeError(".onnx.ModelProto.trainingInfo: array expected");r.trainingInfo=[];for(var n=0;n<t.trainingInfo.length;++n){if(typeof t.trainingInfo[n]!="object")throw TypeError(".onnx.ModelProto.trainingInfo: object expected");r.trainingInfo[n]=c.onnx.TrainingInfoProto.fromObject(t.trainingInfo[n])}}if(t.functions){if(!Array.isArray(t.functions))throw TypeError(".onnx.ModelProto.functions: array expected");r.functions=[];for(var n=0;n<t.functions.length;++n){if(typeof t.functions[n]!="object")throw TypeError(".onnx.ModelProto.functions: object expected");r.functions[n]=c.onnx.FunctionProto.fromObject(t.functions[n])}}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.opsetImport=[],n.metadataProps=[],n.trainingInfo=[],n.functions=[]),r.defaults){if(h.Long){var s=new h.Long(0,0,!1);n.irVersion=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.irVersion=r.longs===String?"0":0;if(n.producerName="",n.producerVersion="",n.domain="",h.Long){var s=new h.Long(0,0,!1);n.modelVersion=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.modelVersion=r.longs===String?"0":0;n.docString="",n.graph=null}if(t.irVersion!=null&&t.hasOwnProperty("irVersion")&&(typeof t.irVersion=="number"?n.irVersion=r.longs===String?String(t.irVersion):t.irVersion:n.irVersion=r.longs===String?h.Long.prototype.toString.call(t.irVersion):r.longs===Number?new h.LongBits(t.irVersion.low>>>0,t.irVersion.high>>>0).toNumber():t.irVersion),t.producerName!=null&&t.hasOwnProperty("producerName")&&(n.producerName=t.producerName),t.producerVersion!=null&&t.hasOwnProperty("producerVersion")&&(n.producerVersion=t.producerVersion),t.domain!=null&&t.hasOwnProperty("domain")&&(n.domain=t.domain),t.modelVersion!=null&&t.hasOwnProperty("modelVersion")&&(typeof t.modelVersion=="number"?n.modelVersion=r.longs===String?String(t.modelVersion):t.modelVersion:n.modelVersion=r.longs===String?h.Long.prototype.toString.call(t.modelVersion):r.longs===Number?new h.LongBits(t.modelVersion.low>>>0,t.modelVersion.high>>>0).toNumber():t.modelVersion),t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),t.graph!=null&&t.hasOwnProperty("graph")&&(n.graph=c.onnx.GraphProto.toObject(t.graph,r)),t.opsetImport&&t.opsetImport.length){n.opsetImport=[];for(var i=0;i<t.opsetImport.length;++i)n.opsetImport[i]=c.onnx.OperatorSetIdProto.toObject(t.opsetImport[i],r)}if(t.metadataProps&&t.metadataProps.length){n.metadataProps=[];for(var i=0;i<t.metadataProps.length;++i)n.metadataProps[i]=c.onnx.StringStringEntryProto.toObject(t.metadataProps[i],r)}if(t.trainingInfo&&t.trainingInfo.length){n.trainingInfo=[];for(var i=0;i<t.trainingInfo.length;++i)n.trainingInfo[i]=c.onnx.TrainingInfoProto.toObject(t.trainingInfo[i],r)}if(t.functions&&t.functions.length){n.functions=[];for(var i=0;i<t.functions.length;++i)n.functions[i]=c.onnx.FunctionProto.toObject(t.functions[i],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.ModelProto"},e}(),a.StringStringEntryProto=function(){function e(o){if(o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.key="",e.prototype.value="",e.create=function(t){return new e(t)},e.encode=function(t,r){return r||(r=X.create()),t.key!=null&&Object.hasOwnProperty.call(t,"key")&&r.uint32(10).string(t.key),t.value!=null&&Object.hasOwnProperty.call(t,"value")&&r.uint32(18).string(t.value),r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.StringStringEntryProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.key=t.string();break}case 2:{s.value=t.string();break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){return typeof t!="object"||t===null?"object expected":t.key!=null&&t.hasOwnProperty("key")&&!h.isString(t.key)?"key: string expected":t.value!=null&&t.hasOwnProperty("value")&&!h.isString(t.value)?"value: string expected":null},e.fromObject=function(t){if(t instanceof c.onnx.StringStringEntryProto)return t;var r=new c.onnx.StringStringEntryProto;return t.key!=null&&(r.key=String(t.key)),t.value!=null&&(r.value=String(t.value)),r},e.toObject=function(t,r){r||(r={});var n={};return r.defaults&&(n.key="",n.value=""),t.key!=null&&t.hasOwnProperty("key")&&(n.key=t.key),t.value!=null&&t.hasOwnProperty("value")&&(n.value=t.value),n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.StringStringEntryProto"},e}(),a.TensorAnnotation=function(){function e(o){if(this.quantParameterTensorNames=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.tensorName="",e.prototype.quantParameterTensorNames=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.tensorName!=null&&Object.hasOwnProperty.call(t,"tensorName")&&r.uint32(10).string(t.tensorName),t.quantParameterTensorNames!=null&&t.quantParameterTensorNames.length)for(var n=0;n<t.quantParameterTensorNames.length;++n)c.onnx.StringStringEntryProto.encode(t.quantParameterTensorNames[n],r.uint32(18).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.TensorAnnotation;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.tensorName=t.string();break}case 2:{s.quantParameterTensorNames&&s.quantParameterTensorNames.length||(s.quantParameterTensorNames=[]),s.quantParameterTensorNames.push(c.onnx.StringStringEntryProto.decode(t,t.uint32()));break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.tensorName!=null&&t.hasOwnProperty("tensorName")&&!h.isString(t.tensorName))return"tensorName: string expected";if(t.quantParameterTensorNames!=null&&t.hasOwnProperty("quantParameterTensorNames")){if(!Array.isArray(t.quantParameterTensorNames))return"quantParameterTensorNames: array expected";for(var r=0;r<t.quantParameterTensorNames.length;++r){var n=c.onnx.StringStringEntryProto.verify(t.quantParameterTensorNames[r]);if(n)return"quantParameterTensorNames."+n}}return null},e.fromObject=function(t){if(t instanceof c.onnx.TensorAnnotation)return t;var r=new c.onnx.TensorAnnotation;if(t.tensorName!=null&&(r.tensorName=String(t.tensorName)),t.quantParameterTensorNames){if(!Array.isArray(t.quantParameterTensorNames))throw TypeError(".onnx.TensorAnnotation.quantParameterTensorNames: array expected");r.quantParameterTensorNames=[];for(var n=0;n<t.quantParameterTensorNames.length;++n){if(typeof t.quantParameterTensorNames[n]!="object")throw TypeError(".onnx.TensorAnnotation.quantParameterTensorNames: object expected");r.quantParameterTensorNames[n]=c.onnx.StringStringEntryProto.fromObject(t.quantParameterTensorNames[n])}}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.quantParameterTensorNames=[]),r.defaults&&(n.tensorName=""),t.tensorName!=null&&t.hasOwnProperty("tensorName")&&(n.tensorName=t.tensorName),t.quantParameterTensorNames&&t.quantParameterTensorNames.length){n.quantParameterTensorNames=[];for(var s=0;s<t.quantParameterTensorNames.length;++s)n.quantParameterTensorNames[s]=c.onnx.StringStringEntryProto.toObject(t.quantParameterTensorNames[s],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TensorAnnotation"},e}(),a.GraphProto=function(){function e(o){if(this.node=[],this.initializer=[],this.sparseInitializer=[],this.input=[],this.output=[],this.valueInfo=[],this.quantizationAnnotation=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.node=h.emptyArray,e.prototype.name="",e.prototype.initializer=h.emptyArray,e.prototype.sparseInitializer=h.emptyArray,e.prototype.docString="",e.prototype.input=h.emptyArray,e.prototype.output=h.emptyArray,e.prototype.valueInfo=h.emptyArray,e.prototype.quantizationAnnotation=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.node!=null&&t.node.length)for(var n=0;n<t.node.length;++n)c.onnx.NodeProto.encode(t.node[n],r.uint32(10).fork()).ldelim();if(t.name!=null&&Object.hasOwnProperty.call(t,"name")&&r.uint32(18).string(t.name),t.initializer!=null&&t.initializer.length)for(var n=0;n<t.initializer.length;++n)c.onnx.TensorProto.encode(t.initializer[n],r.uint32(42).fork()).ldelim();if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(82).string(t.docString),t.input!=null&&t.input.length)for(var n=0;n<t.input.length;++n)c.onnx.ValueInfoProto.encode(t.input[n],r.uint32(90).fork()).ldelim();if(t.output!=null&&t.output.length)for(var n=0;n<t.output.length;++n)c.onnx.ValueInfoProto.encode(t.output[n],r.uint32(98).fork()).ldelim();if(t.valueInfo!=null&&t.valueInfo.length)for(var n=0;n<t.valueInfo.length;++n)c.onnx.ValueInfoProto.encode(t.valueInfo[n],r.uint32(106).fork()).ldelim();if(t.quantizationAnnotation!=null&&t.quantizationAnnotation.length)for(var n=0;n<t.quantizationAnnotation.length;++n)c.onnx.TensorAnnotation.encode(t.quantizationAnnotation[n],r.uint32(114).fork()).ldelim();if(t.sparseInitializer!=null&&t.sparseInitializer.length)for(var n=0;n<t.sparseInitializer.length;++n)c.onnx.SparseTensorProto.encode(t.sparseInitializer[n],r.uint32(122).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.GraphProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.node&&s.node.length||(s.node=[]),s.node.push(c.onnx.NodeProto.decode(t,t.uint32()));break}case 2:{s.name=t.string();break}case 5:{s.initializer&&s.initializer.length||(s.initializer=[]),s.initializer.push(c.onnx.TensorProto.decode(t,t.uint32()));break}case 15:{s.sparseInitializer&&s.sparseInitializer.length||(s.sparseInitializer=[]),s.sparseInitializer.push(c.onnx.SparseTensorProto.decode(t,t.uint32()));break}case 10:{s.docString=t.string();break}case 11:{s.input&&s.input.length||(s.input=[]),s.input.push(c.onnx.ValueInfoProto.decode(t,t.uint32()));break}case 12:{s.output&&s.output.length||(s.output=[]),s.output.push(c.onnx.ValueInfoProto.decode(t,t.uint32()));break}case 13:{s.valueInfo&&s.valueInfo.length||(s.valueInfo=[]),s.valueInfo.push(c.onnx.ValueInfoProto.decode(t,t.uint32()));break}case 14:{s.quantizationAnnotation&&s.quantizationAnnotation.length||(s.quantizationAnnotation=[]),s.quantizationAnnotation.push(c.onnx.TensorAnnotation.decode(t,t.uint32()));break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.node!=null&&t.hasOwnProperty("node")){if(!Array.isArray(t.node))return"node: array expected";for(var r=0;r<t.node.length;++r){var n=c.onnx.NodeProto.verify(t.node[r]);if(n)return"node."+n}}if(t.name!=null&&t.hasOwnProperty("name")&&!h.isString(t.name))return"name: string expected";if(t.initializer!=null&&t.hasOwnProperty("initializer")){if(!Array.isArray(t.initializer))return"initializer: array expected";for(var r=0;r<t.initializer.length;++r){var n=c.onnx.TensorProto.verify(t.initializer[r]);if(n)return"initializer."+n}}if(t.sparseInitializer!=null&&t.hasOwnProperty("sparseInitializer")){if(!Array.isArray(t.sparseInitializer))return"sparseInitializer: array expected";for(var r=0;r<t.sparseInitializer.length;++r){var n=c.onnx.SparseTensorProto.verify(t.sparseInitializer[r]);if(n)return"sparseInitializer."+n}}if(t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString))return"docString: string expected";if(t.input!=null&&t.hasOwnProperty("input")){if(!Array.isArray(t.input))return"input: array expected";for(var r=0;r<t.input.length;++r){var n=c.onnx.ValueInfoProto.verify(t.input[r]);if(n)return"input."+n}}if(t.output!=null&&t.hasOwnProperty("output")){if(!Array.isArray(t.output))return"output: array expected";for(var r=0;r<t.output.length;++r){var n=c.onnx.ValueInfoProto.verify(t.output[r]);if(n)return"output."+n}}if(t.valueInfo!=null&&t.hasOwnProperty("valueInfo")){if(!Array.isArray(t.valueInfo))return"valueInfo: array expected";for(var r=0;r<t.valueInfo.length;++r){var n=c.onnx.ValueInfoProto.verify(t.valueInfo[r]);if(n)return"valueInfo."+n}}if(t.quantizationAnnotation!=null&&t.hasOwnProperty("quantizationAnnotation")){if(!Array.isArray(t.quantizationAnnotation))return"quantizationAnnotation: array expected";for(var r=0;r<t.quantizationAnnotation.length;++r){var n=c.onnx.TensorAnnotation.verify(t.quantizationAnnotation[r]);if(n)return"quantizationAnnotation."+n}}return null},e.fromObject=function(t){if(t instanceof c.onnx.GraphProto)return t;var r=new c.onnx.GraphProto;if(t.node){if(!Array.isArray(t.node))throw TypeError(".onnx.GraphProto.node: array expected");r.node=[];for(var n=0;n<t.node.length;++n){if(typeof t.node[n]!="object")throw TypeError(".onnx.GraphProto.node: object expected");r.node[n]=c.onnx.NodeProto.fromObject(t.node[n])}}if(t.name!=null&&(r.name=String(t.name)),t.initializer){if(!Array.isArray(t.initializer))throw TypeError(".onnx.GraphProto.initializer: array expected");r.initializer=[];for(var n=0;n<t.initializer.length;++n){if(typeof t.initializer[n]!="object")throw TypeError(".onnx.GraphProto.initializer: object expected");r.initializer[n]=c.onnx.TensorProto.fromObject(t.initializer[n])}}if(t.sparseInitializer){if(!Array.isArray(t.sparseInitializer))throw TypeError(".onnx.GraphProto.sparseInitializer: array expected");r.sparseInitializer=[];for(var n=0;n<t.sparseInitializer.length;++n){if(typeof t.sparseInitializer[n]!="object")throw TypeError(".onnx.GraphProto.sparseInitializer: object expected");r.sparseInitializer[n]=c.onnx.SparseTensorProto.fromObject(t.sparseInitializer[n])}}if(t.docString!=null&&(r.docString=String(t.docString)),t.input){if(!Array.isArray(t.input))throw TypeError(".onnx.GraphProto.input: array expected");r.input=[];for(var n=0;n<t.input.length;++n){if(typeof t.input[n]!="object")throw TypeError(".onnx.GraphProto.input: object expected");r.input[n]=c.onnx.ValueInfoProto.fromObject(t.input[n])}}if(t.output){if(!Array.isArray(t.output))throw TypeError(".onnx.GraphProto.output: array expected");r.output=[];for(var n=0;n<t.output.length;++n){if(typeof t.output[n]!="object")throw TypeError(".onnx.GraphProto.output: object expected");r.output[n]=c.onnx.ValueInfoProto.fromObject(t.output[n])}}if(t.valueInfo){if(!Array.isArray(t.valueInfo))throw TypeError(".onnx.GraphProto.valueInfo: array expected");r.valueInfo=[];for(var n=0;n<t.valueInfo.length;++n){if(typeof t.valueInfo[n]!="object")throw TypeError(".onnx.GraphProto.valueInfo: object expected");r.valueInfo[n]=c.onnx.ValueInfoProto.fromObject(t.valueInfo[n])}}if(t.quantizationAnnotation){if(!Array.isArray(t.quantizationAnnotation))throw TypeError(".onnx.GraphProto.quantizationAnnotation: array expected");r.quantizationAnnotation=[];for(var n=0;n<t.quantizationAnnotation.length;++n){if(typeof t.quantizationAnnotation[n]!="object")throw TypeError(".onnx.GraphProto.quantizationAnnotation: object expected");r.quantizationAnnotation[n]=c.onnx.TensorAnnotation.fromObject(t.quantizationAnnotation[n])}}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.node=[],n.initializer=[],n.input=[],n.output=[],n.valueInfo=[],n.quantizationAnnotation=[],n.sparseInitializer=[]),r.defaults&&(n.name="",n.docString=""),t.node&&t.node.length){n.node=[];for(var s=0;s<t.node.length;++s)n.node[s]=c.onnx.NodeProto.toObject(t.node[s],r)}if(t.name!=null&&t.hasOwnProperty("name")&&(n.name=t.name),t.initializer&&t.initializer.length){n.initializer=[];for(var s=0;s<t.initializer.length;++s)n.initializer[s]=c.onnx.TensorProto.toObject(t.initializer[s],r)}if(t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),t.input&&t.input.length){n.input=[];for(var s=0;s<t.input.length;++s)n.input[s]=c.onnx.ValueInfoProto.toObject(t.input[s],r)}if(t.output&&t.output.length){n.output=[];for(var s=0;s<t.output.length;++s)n.output[s]=c.onnx.ValueInfoProto.toObject(t.output[s],r)}if(t.valueInfo&&t.valueInfo.length){n.valueInfo=[];for(var s=0;s<t.valueInfo.length;++s)n.valueInfo[s]=c.onnx.ValueInfoProto.toObject(t.valueInfo[s],r)}if(t.quantizationAnnotation&&t.quantizationAnnotation.length){n.quantizationAnnotation=[];for(var s=0;s<t.quantizationAnnotation.length;++s)n.quantizationAnnotation[s]=c.onnx.TensorAnnotation.toObject(t.quantizationAnnotation[s],r)}if(t.sparseInitializer&&t.sparseInitializer.length){n.sparseInitializer=[];for(var s=0;s<t.sparseInitializer.length;++s)n.sparseInitializer[s]=c.onnx.SparseTensorProto.toObject(t.sparseInitializer[s],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.GraphProto"},e}(),a.TensorProto=function(){function e(o){if(this.dims=[],this.floatData=[],this.int32Data=[],this.stringData=[],this.int64Data=[],this.externalData=[],this.doubleData=[],this.uint64Data=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.dims=h.emptyArray,e.prototype.dataType=0,e.prototype.segment=null,e.prototype.floatData=h.emptyArray,e.prototype.int32Data=h.emptyArray,e.prototype.stringData=h.emptyArray,e.prototype.int64Data=h.emptyArray,e.prototype.name="",e.prototype.docString="",e.prototype.rawData=h.newBuffer([]),e.prototype.externalData=h.emptyArray,e.prototype.dataLocation=0,e.prototype.doubleData=h.emptyArray,e.prototype.uint64Data=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.dims!=null&&t.dims.length){r.uint32(10).fork();for(var n=0;n<t.dims.length;++n)r.int64(t.dims[n]);r.ldelim()}if(t.dataType!=null&&Object.hasOwnProperty.call(t,"dataType")&&r.uint32(16).int32(t.dataType),t.segment!=null&&Object.hasOwnProperty.call(t,"segment")&&c.onnx.TensorProto.Segment.encode(t.segment,r.uint32(26).fork()).ldelim(),t.floatData!=null&&t.floatData.length){r.uint32(34).fork();for(var n=0;n<t.floatData.length;++n)r.float(t.floatData[n]);r.ldelim()}if(t.int32Data!=null&&t.int32Data.length){r.uint32(42).fork();for(var n=0;n<t.int32Data.length;++n)r.int32(t.int32Data[n]);r.ldelim()}if(t.stringData!=null&&t.stringData.length)for(var n=0;n<t.stringData.length;++n)r.uint32(50).bytes(t.stringData[n]);if(t.int64Data!=null&&t.int64Data.length){r.uint32(58).fork();for(var n=0;n<t.int64Data.length;++n)r.int64(t.int64Data[n]);r.ldelim()}if(t.name!=null&&Object.hasOwnProperty.call(t,"name")&&r.uint32(66).string(t.name),t.rawData!=null&&Object.hasOwnProperty.call(t,"rawData")&&r.uint32(74).bytes(t.rawData),t.doubleData!=null&&t.doubleData.length){r.uint32(82).fork();for(var n=0;n<t.doubleData.length;++n)r.double(t.doubleData[n]);r.ldelim()}if(t.uint64Data!=null&&t.uint64Data.length){r.uint32(90).fork();for(var n=0;n<t.uint64Data.length;++n)r.uint64(t.uint64Data[n]);r.ldelim()}if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(98).string(t.docString),t.externalData!=null&&t.externalData.length)for(var n=0;n<t.externalData.length;++n)c.onnx.StringStringEntryProto.encode(t.externalData[n],r.uint32(106).fork()).ldelim();return t.dataLocation!=null&&Object.hasOwnProperty.call(t,"dataLocation")&&r.uint32(112).int32(t.dataLocation),r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.TensorProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{if(s.dims&&s.dims.length||(s.dims=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.dims.push(t.int64());else s.dims.push(t.int64());break}case 2:{s.dataType=t.int32();break}case 3:{s.segment=c.onnx.TensorProto.Segment.decode(t,t.uint32());break}case 4:{if(s.floatData&&s.floatData.length||(s.floatData=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.floatData.push(t.float());else s.floatData.push(t.float());break}case 5:{if(s.int32Data&&s.int32Data.length||(s.int32Data=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.int32Data.push(t.int32());else s.int32Data.push(t.int32());break}case 6:{s.stringData&&s.stringData.length||(s.stringData=[]),s.stringData.push(t.bytes());break}case 7:{if(s.int64Data&&s.int64Data.length||(s.int64Data=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.int64Data.push(t.int64());else s.int64Data.push(t.int64());break}case 8:{s.name=t.string();break}case 12:{s.docString=t.string();break}case 9:{s.rawData=t.bytes();break}case 13:{s.externalData&&s.externalData.length||(s.externalData=[]),s.externalData.push(c.onnx.StringStringEntryProto.decode(t,t.uint32()));break}case 14:{s.dataLocation=t.int32();break}case 10:{if(s.doubleData&&s.doubleData.length||(s.doubleData=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.doubleData.push(t.double());else s.doubleData.push(t.double());break}case 11:{if(s.uint64Data&&s.uint64Data.length||(s.uint64Data=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.uint64Data.push(t.uint64());else s.uint64Data.push(t.uint64());break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.dims!=null&&t.hasOwnProperty("dims")){if(!Array.isArray(t.dims))return"dims: array expected";for(var r=0;r<t.dims.length;++r)if(!h.isInteger(t.dims[r])&&!(t.dims[r]&&h.isInteger(t.dims[r].low)&&h.isInteger(t.dims[r].high)))return"dims: integer|Long[] expected"}if(t.dataType!=null&&t.hasOwnProperty("dataType")&&!h.isInteger(t.dataType))return"dataType: integer expected";if(t.segment!=null&&t.hasOwnProperty("segment")){var n=c.onnx.TensorProto.Segment.verify(t.segment);if(n)return"segment."+n}if(t.floatData!=null&&t.hasOwnProperty("floatData")){if(!Array.isArray(t.floatData))return"floatData: array expected";for(var r=0;r<t.floatData.length;++r)if(typeof t.floatData[r]!="number")return"floatData: number[] expected"}if(t.int32Data!=null&&t.hasOwnProperty("int32Data")){if(!Array.isArray(t.int32Data))return"int32Data: array expected";for(var r=0;r<t.int32Data.length;++r)if(!h.isInteger(t.int32Data[r]))return"int32Data: integer[] expected"}if(t.stringData!=null&&t.hasOwnProperty("stringData")){if(!Array.isArray(t.stringData))return"stringData: array expected";for(var r=0;r<t.stringData.length;++r)if(!(t.stringData[r]&&typeof t.stringData[r].length=="number"||h.isString(t.stringData[r])))return"stringData: buffer[] expected"}if(t.int64Data!=null&&t.hasOwnProperty("int64Data")){if(!Array.isArray(t.int64Data))return"int64Data: array expected";for(var r=0;r<t.int64Data.length;++r)if(!h.isInteger(t.int64Data[r])&&!(t.int64Data[r]&&h.isInteger(t.int64Data[r].low)&&h.isInteger(t.int64Data[r].high)))return"int64Data: integer|Long[] expected"}if(t.name!=null&&t.hasOwnProperty("name")&&!h.isString(t.name))return"name: string expected";if(t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString))return"docString: string expected";if(t.rawData!=null&&t.hasOwnProperty("rawData")&&!(t.rawData&&typeof t.rawData.length=="number"||h.isString(t.rawData)))return"rawData: buffer expected";if(t.externalData!=null&&t.hasOwnProperty("externalData")){if(!Array.isArray(t.externalData))return"externalData: array expected";for(var r=0;r<t.externalData.length;++r){var n=c.onnx.StringStringEntryProto.verify(t.externalData[r]);if(n)return"externalData."+n}}if(t.dataLocation!=null&&t.hasOwnProperty("dataLocation"))switch(t.dataLocation){default:return"dataLocation: enum value expected";case 0:case 1:break}if(t.doubleData!=null&&t.hasOwnProperty("doubleData")){if(!Array.isArray(t.doubleData))return"doubleData: array expected";for(var r=0;r<t.doubleData.length;++r)if(typeof t.doubleData[r]!="number")return"doubleData: number[] expected"}if(t.uint64Data!=null&&t.hasOwnProperty("uint64Data")){if(!Array.isArray(t.uint64Data))return"uint64Data: array expected";for(var r=0;r<t.uint64Data.length;++r)if(!h.isInteger(t.uint64Data[r])&&!(t.uint64Data[r]&&h.isInteger(t.uint64Data[r].low)&&h.isInteger(t.uint64Data[r].high)))return"uint64Data: integer|Long[] expected"}return null},e.fromObject=function(t){if(t instanceof c.onnx.TensorProto)return t;var r=new c.onnx.TensorProto;if(t.dims){if(!Array.isArray(t.dims))throw TypeError(".onnx.TensorProto.dims: array expected");r.dims=[];for(var n=0;n<t.dims.length;++n)h.Long?(r.dims[n]=h.Long.fromValue(t.dims[n])).unsigned=!1:typeof t.dims[n]=="string"?r.dims[n]=parseInt(t.dims[n],10):typeof t.dims[n]=="number"?r.dims[n]=t.dims[n]:typeof t.dims[n]=="object"&&(r.dims[n]=new h.LongBits(t.dims[n].low>>>0,t.dims[n].high>>>0).toNumber())}if(t.dataType!=null&&(r.dataType=t.dataType|0),t.segment!=null){if(typeof t.segment!="object")throw TypeError(".onnx.TensorProto.segment: object expected");r.segment=c.onnx.TensorProto.Segment.fromObject(t.segment)}if(t.floatData){if(!Array.isArray(t.floatData))throw TypeError(".onnx.TensorProto.floatData: array expected");r.floatData=[];for(var n=0;n<t.floatData.length;++n)r.floatData[n]=Number(t.floatData[n])}if(t.int32Data){if(!Array.isArray(t.int32Data))throw TypeError(".onnx.TensorProto.int32Data: array expected");r.int32Data=[];for(var n=0;n<t.int32Data.length;++n)r.int32Data[n]=t.int32Data[n]|0}if(t.stringData){if(!Array.isArray(t.stringData))throw TypeError(".onnx.TensorProto.stringData: array expected");r.stringData=[];for(var n=0;n<t.stringData.length;++n)typeof t.stringData[n]=="string"?h.base64.decode(t.stringData[n],r.stringData[n]=h.newBuffer(h.base64.length(t.stringData[n])),0):t.stringData[n].length>=0&&(r.stringData[n]=t.stringData[n])}if(t.int64Data){if(!Array.isArray(t.int64Data))throw TypeError(".onnx.TensorProto.int64Data: array expected");r.int64Data=[];for(var n=0;n<t.int64Data.length;++n)h.Long?(r.int64Data[n]=h.Long.fromValue(t.int64Data[n])).unsigned=!1:typeof t.int64Data[n]=="string"?r.int64Data[n]=parseInt(t.int64Data[n],10):typeof t.int64Data[n]=="number"?r.int64Data[n]=t.int64Data[n]:typeof t.int64Data[n]=="object"&&(r.int64Data[n]=new h.LongBits(t.int64Data[n].low>>>0,t.int64Data[n].high>>>0).toNumber())}if(t.name!=null&&(r.name=String(t.name)),t.docString!=null&&(r.docString=String(t.docString)),t.rawData!=null&&(typeof t.rawData=="string"?h.base64.decode(t.rawData,r.rawData=h.newBuffer(h.base64.length(t.rawData)),0):t.rawData.length>=0&&(r.rawData=t.rawData)),t.externalData){if(!Array.isArray(t.externalData))throw TypeError(".onnx.TensorProto.externalData: array expected");r.externalData=[];for(var n=0;n<t.externalData.length;++n){if(typeof t.externalData[n]!="object")throw TypeError(".onnx.TensorProto.externalData: object expected");r.externalData[n]=c.onnx.StringStringEntryProto.fromObject(t.externalData[n])}}switch(t.dataLocation){default:if(typeof t.dataLocation=="number"){r.dataLocation=t.dataLocation;break}break;case"DEFAULT":case 0:r.dataLocation=0;break;case"EXTERNAL":case 1:r.dataLocation=1;break}if(t.doubleData){if(!Array.isArray(t.doubleData))throw TypeError(".onnx.TensorProto.doubleData: array expected");r.doubleData=[];for(var n=0;n<t.doubleData.length;++n)r.doubleData[n]=Number(t.doubleData[n])}if(t.uint64Data){if(!Array.isArray(t.uint64Data))throw TypeError(".onnx.TensorProto.uint64Data: array expected");r.uint64Data=[];for(var n=0;n<t.uint64Data.length;++n)h.Long?(r.uint64Data[n]=h.Long.fromValue(t.uint64Data[n])).unsigned=!0:typeof t.uint64Data[n]=="string"?r.uint64Data[n]=parseInt(t.uint64Data[n],10):typeof t.uint64Data[n]=="number"?r.uint64Data[n]=t.uint64Data[n]:typeof t.uint64Data[n]=="object"&&(r.uint64Data[n]=new h.LongBits(t.uint64Data[n].low>>>0,t.uint64Data[n].high>>>0).toNumber(!0))}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.dims=[],n.floatData=[],n.int32Data=[],n.stringData=[],n.int64Data=[],n.doubleData=[],n.uint64Data=[],n.externalData=[]),r.defaults&&(n.dataType=0,n.segment=null,n.name="",r.bytes===String?n.rawData="":(n.rawData=[],r.bytes!==Array&&(n.rawData=h.newBuffer(n.rawData))),n.docString="",n.dataLocation=r.enums===String?"DEFAULT":0),t.dims&&t.dims.length){n.dims=[];for(var s=0;s<t.dims.length;++s)typeof t.dims[s]=="number"?n.dims[s]=r.longs===String?String(t.dims[s]):t.dims[s]:n.dims[s]=r.longs===String?h.Long.prototype.toString.call(t.dims[s]):r.longs===Number?new h.LongBits(t.dims[s].low>>>0,t.dims[s].high>>>0).toNumber():t.dims[s]}if(t.dataType!=null&&t.hasOwnProperty("dataType")&&(n.dataType=t.dataType),t.segment!=null&&t.hasOwnProperty("segment")&&(n.segment=c.onnx.TensorProto.Segment.toObject(t.segment,r)),t.floatData&&t.floatData.length){n.floatData=[];for(var s=0;s<t.floatData.length;++s)n.floatData[s]=r.json&&!isFinite(t.floatData[s])?String(t.floatData[s]):t.floatData[s]}if(t.int32Data&&t.int32Data.length){n.int32Data=[];for(var s=0;s<t.int32Data.length;++s)n.int32Data[s]=t.int32Data[s]}if(t.stringData&&t.stringData.length){n.stringData=[];for(var s=0;s<t.stringData.length;++s)n.stringData[s]=r.bytes===String?h.base64.encode(t.stringData[s],0,t.stringData[s].length):r.bytes===Array?Array.prototype.slice.call(t.stringData[s]):t.stringData[s]}if(t.int64Data&&t.int64Data.length){n.int64Data=[];for(var s=0;s<t.int64Data.length;++s)typeof t.int64Data[s]=="number"?n.int64Data[s]=r.longs===String?String(t.int64Data[s]):t.int64Data[s]:n.int64Data[s]=r.longs===String?h.Long.prototype.toString.call(t.int64Data[s]):r.longs===Number?new h.LongBits(t.int64Data[s].low>>>0,t.int64Data[s].high>>>0).toNumber():t.int64Data[s]}if(t.name!=null&&t.hasOwnProperty("name")&&(n.name=t.name),t.rawData!=null&&t.hasOwnProperty("rawData")&&(n.rawData=r.bytes===String?h.base64.encode(t.rawData,0,t.rawData.length):r.bytes===Array?Array.prototype.slice.call(t.rawData):t.rawData),t.doubleData&&t.doubleData.length){n.doubleData=[];for(var s=0;s<t.doubleData.length;++s)n.doubleData[s]=r.json&&!isFinite(t.doubleData[s])?String(t.doubleData[s]):t.doubleData[s]}if(t.uint64Data&&t.uint64Data.length){n.uint64Data=[];for(var s=0;s<t.uint64Data.length;++s)typeof t.uint64Data[s]=="number"?n.uint64Data[s]=r.longs===String?String(t.uint64Data[s]):t.uint64Data[s]:n.uint64Data[s]=r.longs===String?h.Long.prototype.toString.call(t.uint64Data[s]):r.longs===Number?new h.LongBits(t.uint64Data[s].low>>>0,t.uint64Data[s].high>>>0).toNumber(!0):t.uint64Data[s]}if(t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),t.externalData&&t.externalData.length){n.externalData=[];for(var s=0;s<t.externalData.length;++s)n.externalData[s]=c.onnx.StringStringEntryProto.toObject(t.externalData[s],r)}return t.dataLocation!=null&&t.hasOwnProperty("dataLocation")&&(n.dataLocation=r.enums===String?c.onnx.TensorProto.DataLocation[t.dataLocation]===void 0?t.dataLocation:c.onnx.TensorProto.DataLocation[t.dataLocation]:t.dataLocation),n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TensorProto"},e.DataType=function(){var o={},t=Object.create(o);return t[o[0]="UNDEFINED"]=0,t[o[1]="FLOAT"]=1,t[o[2]="UINT8"]=2,t[o[3]="INT8"]=3,t[o[4]="UINT16"]=4,t[o[5]="INT16"]=5,t[o[6]="INT32"]=6,t[o[7]="INT64"]=7,t[o[8]="STRING"]=8,t[o[9]="BOOL"]=9,t[o[10]="FLOAT16"]=10,t[o[11]="DOUBLE"]=11,t[o[12]="UINT32"]=12,t[o[13]="UINT64"]=13,t[o[14]="COMPLEX64"]=14,t[o[15]="COMPLEX128"]=15,t[o[16]="BFLOAT16"]=16,t[o[17]="FLOAT8E4M3FN"]=17,t[o[18]="FLOAT8E4M3FNUZ"]=18,t[o[19]="FLOAT8E5M2"]=19,t[o[20]="FLOAT8E5M2FNUZ"]=20,t}(),e.Segment=function(){function o(t){if(t)for(var r=Object.keys(t),n=0;n<r.length;++n)t[r[n]]!=null&&(this[r[n]]=t[r[n]])}return o.prototype.begin=h.Long?h.Long.fromBits(0,0,!1):0,o.prototype.end=h.Long?h.Long.fromBits(0,0,!1):0,o.create=function(r){return new o(r)},o.encode=function(r,n){return n||(n=X.create()),r.begin!=null&&Object.hasOwnProperty.call(r,"begin")&&n.uint32(8).int64(r.begin),r.end!=null&&Object.hasOwnProperty.call(r,"end")&&n.uint32(16).int64(r.end),n},o.encodeDelimited=function(r,n){return this.encode(r,n).ldelim()},o.decode=function(r,n){r instanceof w||(r=w.create(r));for(var s=n===void 0?r.len:r.pos+n,i=new c.onnx.TensorProto.Segment;r.pos<s;){var u=r.uint32();switch(u>>>3){case 1:{i.begin=r.int64();break}case 2:{i.end=r.int64();break}default:r.skipType(u&7);break}}return i},o.decodeDelimited=function(r){return r instanceof w||(r=new w(r)),this.decode(r,r.uint32())},o.verify=function(r){return typeof r!="object"||r===null?"object expected":r.begin!=null&&r.hasOwnProperty("begin")&&!h.isInteger(r.begin)&&!(r.begin&&h.isInteger(r.begin.low)&&h.isInteger(r.begin.high))?"begin: integer|Long expected":r.end!=null&&r.hasOwnProperty("end")&&!h.isInteger(r.end)&&!(r.end&&h.isInteger(r.end.low)&&h.isInteger(r.end.high))?"end: integer|Long expected":null},o.fromObject=function(r){if(r instanceof c.onnx.TensorProto.Segment)return r;var n=new c.onnx.TensorProto.Segment;return r.begin!=null&&(h.Long?(n.begin=h.Long.fromValue(r.begin)).unsigned=!1:typeof r.begin=="string"?n.begin=parseInt(r.begin,10):typeof r.begin=="number"?n.begin=r.begin:typeof r.begin=="object"&&(n.begin=new h.LongBits(r.begin.low>>>0,r.begin.high>>>0).toNumber())),r.end!=null&&(h.Long?(n.end=h.Long.fromValue(r.end)).unsigned=!1:typeof r.end=="string"?n.end=parseInt(r.end,10):typeof r.end=="number"?n.end=r.end:typeof r.end=="object"&&(n.end=new h.LongBits(r.end.low>>>0,r.end.high>>>0).toNumber())),n},o.toObject=function(r,n){n||(n={});var s={};if(n.defaults){if(h.Long){var i=new h.Long(0,0,!1);s.begin=n.longs===String?i.toString():n.longs===Number?i.toNumber():i}else s.begin=n.longs===String?"0":0;if(h.Long){var i=new h.Long(0,0,!1);s.end=n.longs===String?i.toString():n.longs===Number?i.toNumber():i}else s.end=n.longs===String?"0":0}return r.begin!=null&&r.hasOwnProperty("begin")&&(typeof r.begin=="number"?s.begin=n.longs===String?String(r.begin):r.begin:s.begin=n.longs===String?h.Long.prototype.toString.call(r.begin):n.longs===Number?new h.LongBits(r.begin.low>>>0,r.begin.high>>>0).toNumber():r.begin),r.end!=null&&r.hasOwnProperty("end")&&(typeof r.end=="number"?s.end=n.longs===String?String(r.end):r.end:s.end=n.longs===String?h.Long.prototype.toString.call(r.end):n.longs===Number?new h.LongBits(r.end.low>>>0,r.end.high>>>0).toNumber():r.end),s},o.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},o.getTypeUrl=function(r){return r===void 0&&(r="type.googleapis.com"),r+"/onnx.TensorProto.Segment"},o}(),e.DataLocation=function(){var o={},t=Object.create(o);return t[o[0]="DEFAULT"]=0,t[o[1]="EXTERNAL"]=1,t}(),e}(),a.SparseTensorProto=function(){function e(o){if(this.dims=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.values=null,e.prototype.indices=null,e.prototype.dims=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.values!=null&&Object.hasOwnProperty.call(t,"values")&&c.onnx.TensorProto.encode(t.values,r.uint32(10).fork()).ldelim(),t.indices!=null&&Object.hasOwnProperty.call(t,"indices")&&c.onnx.TensorProto.encode(t.indices,r.uint32(18).fork()).ldelim(),t.dims!=null&&t.dims.length){r.uint32(26).fork();for(var n=0;n<t.dims.length;++n)r.int64(t.dims[n]);r.ldelim()}return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.SparseTensorProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.values=c.onnx.TensorProto.decode(t,t.uint32());break}case 2:{s.indices=c.onnx.TensorProto.decode(t,t.uint32());break}case 3:{if(s.dims&&s.dims.length||(s.dims=[]),(i&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.dims.push(t.int64());else s.dims.push(t.int64());break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.values!=null&&t.hasOwnProperty("values")){var r=c.onnx.TensorProto.verify(t.values);if(r)return"values."+r}if(t.indices!=null&&t.hasOwnProperty("indices")){var r=c.onnx.TensorProto.verify(t.indices);if(r)return"indices."+r}if(t.dims!=null&&t.hasOwnProperty("dims")){if(!Array.isArray(t.dims))return"dims: array expected";for(var n=0;n<t.dims.length;++n)if(!h.isInteger(t.dims[n])&&!(t.dims[n]&&h.isInteger(t.dims[n].low)&&h.isInteger(t.dims[n].high)))return"dims: integer|Long[] expected"}return null},e.fromObject=function(t){if(t instanceof c.onnx.SparseTensorProto)return t;var r=new c.onnx.SparseTensorProto;if(t.values!=null){if(typeof t.values!="object")throw TypeError(".onnx.SparseTensorProto.values: object expected");r.values=c.onnx.TensorProto.fromObject(t.values)}if(t.indices!=null){if(typeof t.indices!="object")throw TypeError(".onnx.SparseTensorProto.indices: object expected");r.indices=c.onnx.TensorProto.fromObject(t.indices)}if(t.dims){if(!Array.isArray(t.dims))throw TypeError(".onnx.SparseTensorProto.dims: array expected");r.dims=[];for(var n=0;n<t.dims.length;++n)h.Long?(r.dims[n]=h.Long.fromValue(t.dims[n])).unsigned=!1:typeof t.dims[n]=="string"?r.dims[n]=parseInt(t.dims[n],10):typeof t.dims[n]=="number"?r.dims[n]=t.dims[n]:typeof t.dims[n]=="object"&&(r.dims[n]=new h.LongBits(t.dims[n].low>>>0,t.dims[n].high>>>0).toNumber())}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.dims=[]),r.defaults&&(n.values=null,n.indices=null),t.values!=null&&t.hasOwnProperty("values")&&(n.values=c.onnx.TensorProto.toObject(t.values,r)),t.indices!=null&&t.hasOwnProperty("indices")&&(n.indices=c.onnx.TensorProto.toObject(t.indices,r)),t.dims&&t.dims.length){n.dims=[];for(var s=0;s<t.dims.length;++s)typeof t.dims[s]=="number"?n.dims[s]=r.longs===String?String(t.dims[s]):t.dims[s]:n.dims[s]=r.longs===String?h.Long.prototype.toString.call(t.dims[s]):r.longs===Number?new h.LongBits(t.dims[s].low>>>0,t.dims[s].high>>>0).toNumber():t.dims[s]}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.SparseTensorProto"},e}(),a.TensorShapeProto=function(){function e(o){if(this.dim=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.dim=h.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.dim!=null&&t.dim.length)for(var n=0;n<t.dim.length;++n)c.onnx.TensorShapeProto.Dimension.encode(t.dim[n],r.uint32(10).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.TensorShapeProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.dim&&s.dim.length||(s.dim=[]),s.dim.push(c.onnx.TensorShapeProto.Dimension.decode(t,t.uint32()));break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.dim!=null&&t.hasOwnProperty("dim")){if(!Array.isArray(t.dim))return"dim: array expected";for(var r=0;r<t.dim.length;++r){var n=c.onnx.TensorShapeProto.Dimension.verify(t.dim[r]);if(n)return"dim."+n}}return null},e.fromObject=function(t){if(t instanceof c.onnx.TensorShapeProto)return t;var r=new c.onnx.TensorShapeProto;if(t.dim){if(!Array.isArray(t.dim))throw TypeError(".onnx.TensorShapeProto.dim: array expected");r.dim=[];for(var n=0;n<t.dim.length;++n){if(typeof t.dim[n]!="object")throw TypeError(".onnx.TensorShapeProto.dim: object expected");r.dim[n]=c.onnx.TensorShapeProto.Dimension.fromObject(t.dim[n])}}return r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.dim=[]),t.dim&&t.dim.length){n.dim=[];for(var s=0;s<t.dim.length;++s)n.dim[s]=c.onnx.TensorShapeProto.Dimension.toObject(t.dim[s],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TensorShapeProto"},e.Dimension=function(){function o(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}o.prototype.dimValue=null,o.prototype.dimParam=null,o.prototype.denotation="";var t;return Object.defineProperty(o.prototype,"value",{get:h.oneOfGetter(t=["dimValue","dimParam"]),set:h.oneOfSetter(t)}),o.create=function(n){return new o(n)},o.encode=function(n,s){return s||(s=X.create()),n.dimValue!=null&&Object.hasOwnProperty.call(n,"dimValue")&&s.uint32(8).int64(n.dimValue),n.dimParam!=null&&Object.hasOwnProperty.call(n,"dimParam")&&s.uint32(18).string(n.dimParam),n.denotation!=null&&Object.hasOwnProperty.call(n,"denotation")&&s.uint32(26).string(n.denotation),s},o.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},o.decode=function(n,s){n instanceof w||(n=w.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new c.onnx.TensorShapeProto.Dimension;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.dimValue=n.int64();break}case 2:{u.dimParam=n.string();break}case 3:{u.denotation=n.string();break}default:n.skipType(l&7);break}}return u},o.decodeDelimited=function(n){return n instanceof w||(n=new w(n)),this.decode(n,n.uint32())},o.verify=function(n){if(typeof n!="object"||n===null)return"object expected";var s={};if(n.dimValue!=null&&n.hasOwnProperty("dimValue")&&(s.value=1,!h.isInteger(n.dimValue)&&!(n.dimValue&&h.isInteger(n.dimValue.low)&&h.isInteger(n.dimValue.high))))return"dimValue: integer|Long expected";if(n.dimParam!=null&&n.hasOwnProperty("dimParam")){if(s.value===1)return"value: multiple values";if(s.value=1,!h.isString(n.dimParam))return"dimParam: string expected"}return n.denotation!=null&&n.hasOwnProperty("denotation")&&!h.isString(n.denotation)?"denotation: string expected":null},o.fromObject=function(n){if(n instanceof c.onnx.TensorShapeProto.Dimension)return n;var s=new c.onnx.TensorShapeProto.Dimension;return n.dimValue!=null&&(h.Long?(s.dimValue=h.Long.fromValue(n.dimValue)).unsigned=!1:typeof n.dimValue=="string"?s.dimValue=parseInt(n.dimValue,10):typeof n.dimValue=="number"?s.dimValue=n.dimValue:typeof n.dimValue=="object"&&(s.dimValue=new h.LongBits(n.dimValue.low>>>0,n.dimValue.high>>>0).toNumber())),n.dimParam!=null&&(s.dimParam=String(n.dimParam)),n.denotation!=null&&(s.denotation=String(n.denotation)),s},o.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.denotation=""),n.dimValue!=null&&n.hasOwnProperty("dimValue")&&(typeof n.dimValue=="number"?i.dimValue=s.longs===String?String(n.dimValue):n.dimValue:i.dimValue=s.longs===String?h.Long.prototype.toString.call(n.dimValue):s.longs===Number?new h.LongBits(n.dimValue.low>>>0,n.dimValue.high>>>0).toNumber():n.dimValue,s.oneofs&&(i.value="dimValue")),n.dimParam!=null&&n.hasOwnProperty("dimParam")&&(i.dimParam=n.dimParam,s.oneofs&&(i.value="dimParam")),n.denotation!=null&&n.hasOwnProperty("denotation")&&(i.denotation=n.denotation),i},o.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},o.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TensorShapeProto.Dimension"},o}(),e}(),a.TypeProto=function(){function e(t){if(t)for(var r=Object.keys(t),n=0;n<r.length;++n)t[r[n]]!=null&&(this[r[n]]=t[r[n]])}e.prototype.tensorType=null,e.prototype.sequenceType=null,e.prototype.mapType=null,e.prototype.optionalType=null,e.prototype.sparseTensorType=null,e.prototype.denotation="";var o;return Object.defineProperty(e.prototype,"value",{get:h.oneOfGetter(o=["tensorType","sequenceType","mapType","optionalType","sparseTensorType"]),set:h.oneOfSetter(o)}),e.create=function(r){return new e(r)},e.encode=function(r,n){return n||(n=X.create()),r.tensorType!=null&&Object.hasOwnProperty.call(r,"tensorType")&&c.onnx.TypeProto.Tensor.encode(r.tensorType,n.uint32(10).fork()).ldelim(),r.sequenceType!=null&&Object.hasOwnProperty.call(r,"sequenceType")&&c.onnx.TypeProto.Sequence.encode(r.sequenceType,n.uint32(34).fork()).ldelim(),r.mapType!=null&&Object.hasOwnProperty.call(r,"mapType")&&c.onnx.TypeProto.Map.encode(r.mapType,n.uint32(42).fork()).ldelim(),r.denotation!=null&&Object.hasOwnProperty.call(r,"denotation")&&n.uint32(50).string(r.denotation),r.sparseTensorType!=null&&Object.hasOwnProperty.call(r,"sparseTensorType")&&c.onnx.TypeProto.SparseTensor.encode(r.sparseTensorType,n.uint32(66).fork()).ldelim(),r.optionalType!=null&&Object.hasOwnProperty.call(r,"optionalType")&&c.onnx.TypeProto.Optional.encode(r.optionalType,n.uint32(74).fork()).ldelim(),n},e.encodeDelimited=function(r,n){return this.encode(r,n).ldelim()},e.decode=function(r,n){r instanceof w||(r=w.create(r));for(var s=n===void 0?r.len:r.pos+n,i=new c.onnx.TypeProto;r.pos<s;){var u=r.uint32();switch(u>>>3){case 1:{i.tensorType=c.onnx.TypeProto.Tensor.decode(r,r.uint32());break}case 4:{i.sequenceType=c.onnx.TypeProto.Sequence.decode(r,r.uint32());break}case 5:{i.mapType=c.onnx.TypeProto.Map.decode(r,r.uint32());break}case 9:{i.optionalType=c.onnx.TypeProto.Optional.decode(r,r.uint32());break}case 8:{i.sparseTensorType=c.onnx.TypeProto.SparseTensor.decode(r,r.uint32());break}case 6:{i.denotation=r.string();break}default:r.skipType(u&7);break}}return i},e.decodeDelimited=function(r){return r instanceof w||(r=new w(r)),this.decode(r,r.uint32())},e.verify=function(r){if(typeof r!="object"||r===null)return"object expected";var n={};if(r.tensorType!=null&&r.hasOwnProperty("tensorType")){n.value=1;{var s=c.onnx.TypeProto.Tensor.verify(r.tensorType);if(s)return"tensorType."+s}}if(r.sequenceType!=null&&r.hasOwnProperty("sequenceType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=c.onnx.TypeProto.Sequence.verify(r.sequenceType);if(s)return"sequenceType."+s}}if(r.mapType!=null&&r.hasOwnProperty("mapType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=c.onnx.TypeProto.Map.verify(r.mapType);if(s)return"mapType."+s}}if(r.optionalType!=null&&r.hasOwnProperty("optionalType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=c.onnx.TypeProto.Optional.verify(r.optionalType);if(s)return"optionalType."+s}}if(r.sparseTensorType!=null&&r.hasOwnProperty("sparseTensorType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=c.onnx.TypeProto.SparseTensor.verify(r.sparseTensorType);if(s)return"sparseTensorType."+s}}return r.denotation!=null&&r.hasOwnProperty("denotation")&&!h.isString(r.denotation)?"denotation: string expected":null},e.fromObject=function(r){if(r instanceof c.onnx.TypeProto)return r;var n=new c.onnx.TypeProto;if(r.tensorType!=null){if(typeof r.tensorType!="object")throw TypeError(".onnx.TypeProto.tensorType: object expected");n.tensorType=c.onnx.TypeProto.Tensor.fromObject(r.tensorType)}if(r.sequenceType!=null){if(typeof r.sequenceType!="object")throw TypeError(".onnx.TypeProto.sequenceType: object expected");n.sequenceType=c.onnx.TypeProto.Sequence.fromObject(r.sequenceType)}if(r.mapType!=null){if(typeof r.mapType!="object")throw TypeError(".onnx.TypeProto.mapType: object expected");n.mapType=c.onnx.TypeProto.Map.fromObject(r.mapType)}if(r.optionalType!=null){if(typeof r.optionalType!="object")throw TypeError(".onnx.TypeProto.optionalType: object expected");n.optionalType=c.onnx.TypeProto.Optional.fromObject(r.optionalType)}if(r.sparseTensorType!=null){if(typeof r.sparseTensorType!="object")throw TypeError(".onnx.TypeProto.sparseTensorType: object expected");n.sparseTensorType=c.onnx.TypeProto.SparseTensor.fromObject(r.sparseTensorType)}return r.denotation!=null&&(n.denotation=String(r.denotation)),n},e.toObject=function(r,n){n||(n={});var s={};return n.defaults&&(s.denotation=""),r.tensorType!=null&&r.hasOwnProperty("tensorType")&&(s.tensorType=c.onnx.TypeProto.Tensor.toObject(r.tensorType,n),n.oneofs&&(s.value="tensorType")),r.sequenceType!=null&&r.hasOwnProperty("sequenceType")&&(s.sequenceType=c.onnx.TypeProto.Sequence.toObject(r.sequenceType,n),n.oneofs&&(s.value="sequenceType")),r.mapType!=null&&r.hasOwnProperty("mapType")&&(s.mapType=c.onnx.TypeProto.Map.toObject(r.mapType,n),n.oneofs&&(s.value="mapType")),r.denotation!=null&&r.hasOwnProperty("denotation")&&(s.denotation=r.denotation),r.sparseTensorType!=null&&r.hasOwnProperty("sparseTensorType")&&(s.sparseTensorType=c.onnx.TypeProto.SparseTensor.toObject(r.sparseTensorType,n),n.oneofs&&(s.value="sparseTensorType")),r.optionalType!=null&&r.hasOwnProperty("optionalType")&&(s.optionalType=c.onnx.TypeProto.Optional.toObject(r.optionalType,n),n.oneofs&&(s.value="optionalType")),s},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(r){return r===void 0&&(r="type.googleapis.com"),r+"/onnx.TypeProto"},e.Tensor=function(){function t(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return t.prototype.elemType=0,t.prototype.shape=null,t.create=function(n){return new t(n)},t.encode=function(n,s){return s||(s=X.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&s.uint32(8).int32(n.elemType),n.shape!=null&&Object.hasOwnProperty.call(n,"shape")&&c.onnx.TensorShapeProto.encode(n.shape,s.uint32(18).fork()).ldelim(),s},t.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},t.decode=function(n,s){n instanceof w||(n=w.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new c.onnx.TypeProto.Tensor;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=n.int32();break}case 2:{u.shape=c.onnx.TensorShapeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},t.decodeDelimited=function(n){return n instanceof w||(n=new w(n)),this.decode(n,n.uint32())},t.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")&&!h.isInteger(n.elemType))return"elemType: integer expected";if(n.shape!=null&&n.hasOwnProperty("shape")){var s=c.onnx.TensorShapeProto.verify(n.shape);if(s)return"shape."+s}return null},t.fromObject=function(n){if(n instanceof c.onnx.TypeProto.Tensor)return n;var s=new c.onnx.TypeProto.Tensor;if(n.elemType!=null&&(s.elemType=n.elemType|0),n.shape!=null){if(typeof n.shape!="object")throw TypeError(".onnx.TypeProto.Tensor.shape: object expected");s.shape=c.onnx.TensorShapeProto.fromObject(n.shape)}return s},t.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=0,i.shape=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=n.elemType),n.shape!=null&&n.hasOwnProperty("shape")&&(i.shape=c.onnx.TensorShapeProto.toObject(n.shape,s)),i},t.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},t.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Tensor"},t}(),e.Sequence=function(){function t(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return t.prototype.elemType=null,t.create=function(n){return new t(n)},t.encode=function(n,s){return s||(s=X.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&c.onnx.TypeProto.encode(n.elemType,s.uint32(10).fork()).ldelim(),s},t.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},t.decode=function(n,s){n instanceof w||(n=w.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new c.onnx.TypeProto.Sequence;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=c.onnx.TypeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},t.decodeDelimited=function(n){return n instanceof w||(n=new w(n)),this.decode(n,n.uint32())},t.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")){var s=c.onnx.TypeProto.verify(n.elemType);if(s)return"elemType."+s}return null},t.fromObject=function(n){if(n instanceof c.onnx.TypeProto.Sequence)return n;var s=new c.onnx.TypeProto.Sequence;if(n.elemType!=null){if(typeof n.elemType!="object")throw TypeError(".onnx.TypeProto.Sequence.elemType: object expected");s.elemType=c.onnx.TypeProto.fromObject(n.elemType)}return s},t.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=c.onnx.TypeProto.toObject(n.elemType,s)),i},t.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},t.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Sequence"},t}(),e.Map=function(){function t(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return t.prototype.keyType=0,t.prototype.valueType=null,t.create=function(n){return new t(n)},t.encode=function(n,s){return s||(s=X.create()),n.keyType!=null&&Object.hasOwnProperty.call(n,"keyType")&&s.uint32(8).int32(n.keyType),n.valueType!=null&&Object.hasOwnProperty.call(n,"valueType")&&c.onnx.TypeProto.encode(n.valueType,s.uint32(18).fork()).ldelim(),s},t.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},t.decode=function(n,s){n instanceof w||(n=w.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new c.onnx.TypeProto.Map;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.keyType=n.int32();break}case 2:{u.valueType=c.onnx.TypeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},t.decodeDelimited=function(n){return n instanceof w||(n=new w(n)),this.decode(n,n.uint32())},t.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.keyType!=null&&n.hasOwnProperty("keyType")&&!h.isInteger(n.keyType))return"keyType: integer expected";if(n.valueType!=null&&n.hasOwnProperty("valueType")){var s=c.onnx.TypeProto.verify(n.valueType);if(s)return"valueType."+s}return null},t.fromObject=function(n){if(n instanceof c.onnx.TypeProto.Map)return n;var s=new c.onnx.TypeProto.Map;if(n.keyType!=null&&(s.keyType=n.keyType|0),n.valueType!=null){if(typeof n.valueType!="object")throw TypeError(".onnx.TypeProto.Map.valueType: object expected");s.valueType=c.onnx.TypeProto.fromObject(n.valueType)}return s},t.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.keyType=0,i.valueType=null),n.keyType!=null&&n.hasOwnProperty("keyType")&&(i.keyType=n.keyType),n.valueType!=null&&n.hasOwnProperty("valueType")&&(i.valueType=c.onnx.TypeProto.toObject(n.valueType,s)),i},t.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},t.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Map"},t}(),e.Optional=function(){function t(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return t.prototype.elemType=null,t.create=function(n){return new t(n)},t.encode=function(n,s){return s||(s=X.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&c.onnx.TypeProto.encode(n.elemType,s.uint32(10).fork()).ldelim(),s},t.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},t.decode=function(n,s){n instanceof w||(n=w.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new c.onnx.TypeProto.Optional;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=c.onnx.TypeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},t.decodeDelimited=function(n){return n instanceof w||(n=new w(n)),this.decode(n,n.uint32())},t.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")){var s=c.onnx.TypeProto.verify(n.elemType);if(s)return"elemType."+s}return null},t.fromObject=function(n){if(n instanceof c.onnx.TypeProto.Optional)return n;var s=new c.onnx.TypeProto.Optional;if(n.elemType!=null){if(typeof n.elemType!="object")throw TypeError(".onnx.TypeProto.Optional.elemType: object expected");s.elemType=c.onnx.TypeProto.fromObject(n.elemType)}return s},t.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=c.onnx.TypeProto.toObject(n.elemType,s)),i},t.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},t.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Optional"},t}(),e.SparseTensor=function(){function t(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return t.prototype.elemType=0,t.prototype.shape=null,t.create=function(n){return new t(n)},t.encode=function(n,s){return s||(s=X.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&s.uint32(8).int32(n.elemType),n.shape!=null&&Object.hasOwnProperty.call(n,"shape")&&c.onnx.TensorShapeProto.encode(n.shape,s.uint32(18).fork()).ldelim(),s},t.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},t.decode=function(n,s){n instanceof w||(n=w.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new c.onnx.TypeProto.SparseTensor;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=n.int32();break}case 2:{u.shape=c.onnx.TensorShapeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},t.decodeDelimited=function(n){return n instanceof w||(n=new w(n)),this.decode(n,n.uint32())},t.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")&&!h.isInteger(n.elemType))return"elemType: integer expected";if(n.shape!=null&&n.hasOwnProperty("shape")){var s=c.onnx.TensorShapeProto.verify(n.shape);if(s)return"shape."+s}return null},t.fromObject=function(n){if(n instanceof c.onnx.TypeProto.SparseTensor)return n;var s=new c.onnx.TypeProto.SparseTensor;if(n.elemType!=null&&(s.elemType=n.elemType|0),n.shape!=null){if(typeof n.shape!="object")throw TypeError(".onnx.TypeProto.SparseTensor.shape: object expected");s.shape=c.onnx.TensorShapeProto.fromObject(n.shape)}return s},t.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=0,i.shape=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=n.elemType),n.shape!=null&&n.hasOwnProperty("shape")&&(i.shape=c.onnx.TensorShapeProto.toObject(n.shape,s)),i},t.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},t.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.SparseTensor"},t}(),e}(),a.OperatorSetIdProto=function(){function e(o){if(o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.domain="",e.prototype.version=h.Long?h.Long.fromBits(0,0,!1):0,e.create=function(t){return new e(t)},e.encode=function(t,r){return r||(r=X.create()),t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&r.uint32(10).string(t.domain),t.version!=null&&Object.hasOwnProperty.call(t,"version")&&r.uint32(16).int64(t.version),r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.OperatorSetIdProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.domain=t.string();break}case 2:{s.version=t.int64();break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){return typeof t!="object"||t===null?"object expected":t.domain!=null&&t.hasOwnProperty("domain")&&!h.isString(t.domain)?"domain: string expected":t.version!=null&&t.hasOwnProperty("version")&&!h.isInteger(t.version)&&!(t.version&&h.isInteger(t.version.low)&&h.isInteger(t.version.high))?"version: integer|Long expected":null},e.fromObject=function(t){if(t instanceof c.onnx.OperatorSetIdProto)return t;var r=new c.onnx.OperatorSetIdProto;return t.domain!=null&&(r.domain=String(t.domain)),t.version!=null&&(h.Long?(r.version=h.Long.fromValue(t.version)).unsigned=!1:typeof t.version=="string"?r.version=parseInt(t.version,10):typeof t.version=="number"?r.version=t.version:typeof t.version=="object"&&(r.version=new h.LongBits(t.version.low>>>0,t.version.high>>>0).toNumber())),r},e.toObject=function(t,r){r||(r={});var n={};if(r.defaults)if(n.domain="",h.Long){var s=new h.Long(0,0,!1);n.version=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.version=r.longs===String?"0":0;return t.domain!=null&&t.hasOwnProperty("domain")&&(n.domain=t.domain),t.version!=null&&t.hasOwnProperty("version")&&(typeof t.version=="number"?n.version=r.longs===String?String(t.version):t.version:n.version=r.longs===String?h.Long.prototype.toString.call(t.version):r.longs===Number?new h.LongBits(t.version.low>>>0,t.version.high>>>0).toNumber():t.version),n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.OperatorSetIdProto"},e}(),a.OperatorStatus=function(){var e={},o=Object.create(e);return o[e[0]="EXPERIMENTAL"]=0,o[e[1]="STABLE"]=1,o}(),a.FunctionProto=function(){function e(o){if(this.input=[],this.output=[],this.attribute=[],this.attributeProto=[],this.node=[],this.opsetImport=[],o)for(var t=Object.keys(o),r=0;r<t.length;++r)o[t[r]]!=null&&(this[t[r]]=o[t[r]])}return e.prototype.name="",e.prototype.input=h.emptyArray,e.prototype.output=h.emptyArray,e.prototype.attribute=h.emptyArray,e.prototype.attributeProto=h.emptyArray,e.prototype.node=h.emptyArray,e.prototype.docString="",e.prototype.opsetImport=h.emptyArray,e.prototype.domain="",e.create=function(t){return new e(t)},e.encode=function(t,r){if(r||(r=X.create()),t.name!=null&&Object.hasOwnProperty.call(t,"name")&&r.uint32(10).string(t.name),t.input!=null&&t.input.length)for(var n=0;n<t.input.length;++n)r.uint32(34).string(t.input[n]);if(t.output!=null&&t.output.length)for(var n=0;n<t.output.length;++n)r.uint32(42).string(t.output[n]);if(t.attribute!=null&&t.attribute.length)for(var n=0;n<t.attribute.length;++n)r.uint32(50).string(t.attribute[n]);if(t.node!=null&&t.node.length)for(var n=0;n<t.node.length;++n)c.onnx.NodeProto.encode(t.node[n],r.uint32(58).fork()).ldelim();if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&r.uint32(66).string(t.docString),t.opsetImport!=null&&t.opsetImport.length)for(var n=0;n<t.opsetImport.length;++n)c.onnx.OperatorSetIdProto.encode(t.opsetImport[n],r.uint32(74).fork()).ldelim();if(t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&r.uint32(82).string(t.domain),t.attributeProto!=null&&t.attributeProto.length)for(var n=0;n<t.attributeProto.length;++n)c.onnx.AttributeProto.encode(t.attributeProto[n],r.uint32(90).fork()).ldelim();return r},e.encodeDelimited=function(t,r){return this.encode(t,r).ldelim()},e.decode=function(t,r){t instanceof w||(t=w.create(t));for(var n=r===void 0?t.len:t.pos+r,s=new c.onnx.FunctionProto;t.pos<n;){var i=t.uint32();switch(i>>>3){case 1:{s.name=t.string();break}case 4:{s.input&&s.input.length||(s.input=[]),s.input.push(t.string());break}case 5:{s.output&&s.output.length||(s.output=[]),s.output.push(t.string());break}case 6:{s.attribute&&s.attribute.length||(s.attribute=[]),s.attribute.push(t.string());break}case 11:{s.attributeProto&&s.attributeProto.length||(s.attributeProto=[]),s.attributeProto.push(c.onnx.AttributeProto.decode(t,t.uint32()));break}case 7:{s.node&&s.node.length||(s.node=[]),s.node.push(c.onnx.NodeProto.decode(t,t.uint32()));break}case 8:{s.docString=t.string();break}case 9:{s.opsetImport&&s.opsetImport.length||(s.opsetImport=[]),s.opsetImport.push(c.onnx.OperatorSetIdProto.decode(t,t.uint32()));break}case 10:{s.domain=t.string();break}default:t.skipType(i&7);break}}return s},e.decodeDelimited=function(t){return t instanceof w||(t=new w(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.name!=null&&t.hasOwnProperty("name")&&!h.isString(t.name))return"name: string expected";if(t.input!=null&&t.hasOwnProperty("input")){if(!Array.isArray(t.input))return"input: array expected";for(var r=0;r<t.input.length;++r)if(!h.isString(t.input[r]))return"input: string[] expected"}if(t.output!=null&&t.hasOwnProperty("output")){if(!Array.isArray(t.output))return"output: array expected";for(var r=0;r<t.output.length;++r)if(!h.isString(t.output[r]))return"output: string[] expected"}if(t.attribute!=null&&t.hasOwnProperty("attribute")){if(!Array.isArray(t.attribute))return"attribute: array expected";for(var r=0;r<t.attribute.length;++r)if(!h.isString(t.attribute[r]))return"attribute: string[] expected"}if(t.attributeProto!=null&&t.hasOwnProperty("attributeProto")){if(!Array.isArray(t.attributeProto))return"attributeProto: array expected";for(var r=0;r<t.attributeProto.length;++r){var n=c.onnx.AttributeProto.verify(t.attributeProto[r]);if(n)return"attributeProto."+n}}if(t.node!=null&&t.hasOwnProperty("node")){if(!Array.isArray(t.node))return"node: array expected";for(var r=0;r<t.node.length;++r){var n=c.onnx.NodeProto.verify(t.node[r]);if(n)return"node."+n}}if(t.docString!=null&&t.hasOwnProperty("docString")&&!h.isString(t.docString))return"docString: string expected";if(t.opsetImport!=null&&t.hasOwnProperty("opsetImport")){if(!Array.isArray(t.opsetImport))return"opsetImport: array expected";for(var r=0;r<t.opsetImport.length;++r){var n=c.onnx.OperatorSetIdProto.verify(t.opsetImport[r]);if(n)return"opsetImport."+n}}return t.domain!=null&&t.hasOwnProperty("domain")&&!h.isString(t.domain)?"domain: string expected":null},e.fromObject=function(t){if(t instanceof c.onnx.FunctionProto)return t;var r=new c.onnx.FunctionProto;if(t.name!=null&&(r.name=String(t.name)),t.input){if(!Array.isArray(t.input))throw TypeError(".onnx.FunctionProto.input: array expected");r.input=[];for(var n=0;n<t.input.length;++n)r.input[n]=String(t.input[n])}if(t.output){if(!Array.isArray(t.output))throw TypeError(".onnx.FunctionProto.output: array expected");r.output=[];for(var n=0;n<t.output.length;++n)r.output[n]=String(t.output[n])}if(t.attribute){if(!Array.isArray(t.attribute))throw TypeError(".onnx.FunctionProto.attribute: array expected");r.attribute=[];for(var n=0;n<t.attribute.length;++n)r.attribute[n]=String(t.attribute[n])}if(t.attributeProto){if(!Array.isArray(t.attributeProto))throw TypeError(".onnx.FunctionProto.attributeProto: array expected");r.attributeProto=[];for(var n=0;n<t.attributeProto.length;++n){if(typeof t.attributeProto[n]!="object")throw TypeError(".onnx.FunctionProto.attributeProto: object expected");r.attributeProto[n]=c.onnx.AttributeProto.fromObject(t.attributeProto[n])}}if(t.node){if(!Array.isArray(t.node))throw TypeError(".onnx.FunctionProto.node: array expected");r.node=[];for(var n=0;n<t.node.length;++n){if(typeof t.node[n]!="object")throw TypeError(".onnx.FunctionProto.node: object expected");r.node[n]=c.onnx.NodeProto.fromObject(t.node[n])}}if(t.docString!=null&&(r.docString=String(t.docString)),t.opsetImport){if(!Array.isArray(t.opsetImport))throw TypeError(".onnx.FunctionProto.opsetImport: array expected");r.opsetImport=[];for(var n=0;n<t.opsetImport.length;++n){if(typeof t.opsetImport[n]!="object")throw TypeError(".onnx.FunctionProto.opsetImport: object expected");r.opsetImport[n]=c.onnx.OperatorSetIdProto.fromObject(t.opsetImport[n])}}return t.domain!=null&&(r.domain=String(t.domain)),r},e.toObject=function(t,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.input=[],n.output=[],n.attribute=[],n.node=[],n.opsetImport=[],n.attributeProto=[]),r.defaults&&(n.name="",n.docString="",n.domain=""),t.name!=null&&t.hasOwnProperty("name")&&(n.name=t.name),t.input&&t.input.length){n.input=[];for(var s=0;s<t.input.length;++s)n.input[s]=t.input[s]}if(t.output&&t.output.length){n.output=[];for(var s=0;s<t.output.length;++s)n.output[s]=t.output[s]}if(t.attribute&&t.attribute.length){n.attribute=[];for(var s=0;s<t.attribute.length;++s)n.attribute[s]=t.attribute[s]}if(t.node&&t.node.length){n.node=[];for(var s=0;s<t.node.length;++s)n.node[s]=c.onnx.NodeProto.toObject(t.node[s],r)}if(t.docString!=null&&t.hasOwnProperty("docString")&&(n.docString=t.docString),t.opsetImport&&t.opsetImport.length){n.opsetImport=[];for(var s=0;s<t.opsetImport.length;++s)n.opsetImport[s]=c.onnx.OperatorSetIdProto.toObject(t.opsetImport[s],r)}if(t.domain!=null&&t.hasOwnProperty("domain")&&(n.domain=t.domain),t.attributeProto&&t.attributeProto.length){n.attributeProto=[];for(var s=0;s<t.attributeProto.length;++s)n.attributeProto[s]=c.onnx.AttributeProto.toObject(t.attributeProto[s],r)}return n},e.prototype.toJSON=function(){return this.constructor.toObject(this,W.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.FunctionProto"},e}(),a}();Fi.exports=c});function se(a,e){if(!a)throw new Error(typeof e=="string"?e:e())}function Se(a){return new TextDecoder().decode(a)}var H,jt,an,it,er,et,ft,A,_e,Kt,Xt,Jt,z=x(()=>{"use strict";Je();Hr();H=re(ae());Zt();jt=class{static arraysEqual(e,o){if(e.length!==o.length)return!1;for(let t=0;t<e.length;t++)if(e[t]!==o[t])return!1;return!0}},an=class{static preprocessInputShapes(e,o){let t=e.length===1?[1,e[0]]:e,r=o.length===1?[o[0],1]:o;return[t,r]}static postprocessOutputShape(e,o,t){o===1&&e.splice(e.length-2,1),t===1&&e.pop()}static calcMatMulShape(e,o){return e[1]!==o[0]?void 0:[e[0],o[1]]}},it=class a{static calcShape(e,o,t=!1){let r=e.length,n=o.length;if(r===0)return o;if(n===0)return e;let s=Math.max(e.length,o.length),i=new Array(s);if(t){if(r<2||n<2)return;let u=an.calcMatMulShape([e[r-2],e[r-1]],[o[n-2],o[n-1]]);if(u===void 0)return;[i[s-2],i[s-1]]=u}for(let u=t?3:1;u<=s;u++){let l=r-u<0?1:e[r-u],f=n-u<0?1:o[n-u];if(l!==f&&l>1&&f>1)return;i[s-u]=Math.max(l,f)}return i}static index(e,o){let t=new Array(o.length);return a.fillIndex(e,o,t),t}static fillIndex(e,o,t){let r=e.length-o.length;for(let n=0;n<o.length;n++)t[n]=e[r+n]%o[n]}static calc(e,o,t,r,n){let s=a.calcShape(e.dims,o.dims);if(s){if(r&&!A.areEqual(s,e.dims))return;let i=A.size(s),u=r?e:new Y(s,n||e.type);if(s.length===0)u.set([],t(e.get([]),o.get([])));else{let l=new Array(s.length),f=new Array(e.dims.length),p=new Array(o.dims.length),d=0,m=0,g=!1,y=!1;e.dims.length===0&&(d=e.get([]),g=!0),o.dims.length===0&&(m=o.get([]),y=!0);let v;for(let _=0;_<i;_++){v=_;for(let O=s.length-1;O>=0;O--)l[O]=v%s[O],v=Math.floor(v/s[O]);g||(a.fillIndex(l,e.dims,f),d=e.get(f)),y||(a.fillIndex(l,o.dims,p),m=o.get(p)),u.set(l,t(d,m))}}return u}}static isValidBroadcast(e,o){let t=e.length,r=o.length;if(t>r)return!1;for(let n=1;n<=t;n++)if(e[t-n]!==1&&e[t-n]!==o[r-n])return!1;return!0}static getBroadcastDims(e,o){let t=e.length,r=[];for(let n=0;n<t;n++){let s=t-1-n,i=e[s]||1;(o[o.length-1-n]||1)>1&&i===1&&r.unshift(s)}return r}},er=class{static getShapeOfGemmResult(e,o,t,r,n){if(e.length!==2||t.length!==2)throw new Error("shape need to be of size 2");let s,i,u;o?(s=e[1],i=e[0]):(s=e[0],i=e[1]);let l=-1;if(r?(u=t[0],l=1):(u=t[1],l=0),t[l]!==i)throw new Error("dimension mismatch");if(s<=0||u<=0||i<=0)throw new Error("invalid shape specified");if(n&&!it.isValidBroadcast(n,[s,u]))throw new Error("gemm: invalid bias shape for broadcast");return[s,u,i]}},et=class a{static tensorDataTypeFromProto(e){switch(e){case H.onnx.TensorProto.DataType.INT8:return"int8";case H.onnx.TensorProto.DataType.UINT8:return"uint8";case H.onnx.TensorProto.DataType.BOOL:return"bool";case H.onnx.TensorProto.DataType.INT16:return"int16";case H.onnx.TensorProto.DataType.UINT16:return"uint16";case H.onnx.TensorProto.DataType.INT32:return"int32";case H.onnx.TensorProto.DataType.UINT32:return"uint32";case H.onnx.TensorProto.DataType.FLOAT:return"float32";case H.onnx.TensorProto.DataType.DOUBLE:return"float64";case H.onnx.TensorProto.DataType.STRING:return"string";case H.onnx.TensorProto.DataType.INT64:return"int32";case H.onnx.TensorProto.DataType.UINT64:return"uint32";default:throw new Error(`unsupported data type: ${H.onnx.TensorProto.DataType[e]}`)}}static tensorDataTypeStringToEnum(e){switch(e){case"int8":return H.onnx.TensorProto.DataType.INT8;case"uint8":return H.onnx.TensorProto.DataType.UINT8;case"bool":return H.onnx.TensorProto.DataType.BOOL;case"int16":return H.onnx.TensorProto.DataType.INT16;case"uint16":return H.onnx.TensorProto.DataType.UINT16;case"int32":return H.onnx.TensorProto.DataType.INT32;case"uint32":return H.onnx.TensorProto.DataType.UINT32;case"float32":return H.onnx.TensorProto.DataType.FLOAT;case"float64":return H.onnx.TensorProto.DataType.DOUBLE;case"string":return H.onnx.TensorProto.DataType.STRING;case"int64":return H.onnx.TensorProto.DataType.INT64;case"uint64":return H.onnx.TensorProto.DataType.UINT64;default:throw new Error(`unsupported data type: ${e}`)}}static tensorDimsFromProto(e){return e.map(o=>$t.isLong(o)?o.toNumber():o)}static tensorValueTypeFromProto(e){return{tensorType:a.tensorDataTypeFromProto(e.elemType),shape:{dims:a.tensorDimsFromProto(e.shape.dim.map(o=>o.dimValue))}}}static tensorDimsFromORTFormat(e){let o=[];for(let t=0;t<e.dimsLength();t++)o.push(ft.longToNumber(e.dims(t)));return o}static tensorAttributesFromORTFormat(e){let o=[];for(let t=0;t<e.attributesLength();t++)o.push(e.attributes(t));return o}},ft=class{static longToNumber(e,o){return $t.isLong(e)?e.toNumber():e instanceof b.Long?$t.fromValue({low:e.low,high:e.high,unsigned:o??!1}).toNumber():e}static isLong(e){return $t.isLong(e)||e instanceof b.Long}},A=class a{static size(e){return a.getSizeFromDimensionRange(e,0,e.length)}static sizeFromDimension(e,o){if(o<0||o>e.length)throw new Error(`invalid dimension of ${o} for sizeFromDimension as Tensor has ${e.length} dimensions.`);return a.getSizeFromDimensionRange(e,o,e.length)}static sizeToDimension(e,o){if(o<0||o>e.length)throw new Error(`invalid dimension of ${o} for sizeToDimension as Tensor has ${e.length} dimensions.`);return a.getSizeFromDimensionRange(e,0,o)}static getSizeFromDimensionRange(e,o,t){let r=1;for(let n=o;n<t;n++){if(e[n]<=0)throw new Error("cannot get valid size from specified dimension range. Most likely the range contains 0 or negative values in them.");r*=e[n]}return r}static computeStrides(e){let o=e.length;if(o===0)return[];if(o===1)return[1];let t=new Array(o);t[o-1]=1,t[o-2]=e[o-1];for(let r=o-3;r>=0;--r)t[r]=t[r+1]*e[r+1];return t}static transpose(e){return e.slice().reverse()}static indicesToOffset(e,o,t){t===void 0&&(t=e.length);let r=0;for(let n=0;n<t;++n)r+=o[n]*e[n];return r}static offsetToIndices(e,o){let t=o.length;if(t===0)return[];if(t===1)return[e*o[0]];let r=new Array(o.length);for(let n=0;n<r.length-1;++n)r[n]=Math.floor(e/o[n]),e-=r[n]*o[n];return r[r.length-1]=e,r}static normalizeAxis(e,o){if(e<-o&&e>=o)throw new Error("unsupported axis for this operation.");return e<0?e+o:e}static normalizeAxes(e,o){return e.map(t=>this.normalizeAxis(t,o))}static incrementIndex(e,o,t){if(o.length===0||e.length===0)throw new Error("Index incrementing unsupported for scalar Tensor");if(t===void 0)t=o.length;else if(t<=0||t>o.length)throw new Error("Incorrect axis to increment on");for(let r=t-1;r>=0&&(e[r]++,!(e[r]<o[r]));--r)e[r]=0}static calculateReshapedDims(e,o){if(o.length===0){if(e.length===0||a.size(e)===1)return[];throw new Error("cannot reshape to a scalar Tensor")}let t=o.length,r=new Array(t),n=-1,s=1;for(let u=0;u<t;u++){if(o[u]<-1)throw new Error("a dimension in shape hints cannot be less than -1");if(o[u]===-1){if(n!==-1)throw new Error("at most one dimension in shape hints can be -1");n=u}else{if(o[u]===0){if(u>=e.length)throw new Error("the dimension with value zero exceeds the dimension size of the input tensor");r[u]=e[u]}else r[u]=o[u];s*=r[u]}}let i=a.size(e);if(n!==-1){if(i%s!==0)throw new Error(`the input tensor cannot be reshaped to the requested shape. Input shape: [${e}] Output shape: [${o}]`);r[n]=i/s}else if(s!==i)throw new Error("reshapedDims and originalDims don't have matching sizes");return r}static sortBasedOnPerm(e,o){return o?o.map(t=>e[t]):e.slice().reverse()}static padShape(e,o){let t=e.length;return e.map((r,n)=>r+o[n]+o[n+t])}static areEqual(e,o){return e.length!==o.length?!1:e.every((t,r)=>t===o[r])}static validateDimsAndCalcSize(e){if(e.length>6)throw new TypeError("Only rank 0 to 6 is supported for tensor shape.");let o=1;for(let t of e){if(!Number.isInteger(t))throw new TypeError(`Invalid shape: ${t} is not an integer`);if(t<0||t>2147483647)throw new TypeError(`Invalid shape: length ${t} is not allowed`);o*=t}return o}static flattenShape(e,o){o<0&&(o+=e.length);let t=e.reduce((s,i)=>s*i,1),r=e.slice(o).reduce((s,i)=>s*i,1);return[t/r,r]}static squeezeShape(e,o){let t=new Array;o=a.normalizeAxes(o,e.length);for(let r=0;r<e.length;r++){let n=o.indexOf(r)>=0;if(n&&e[r]!==1)throw new Error("squeeze an axis of size different than 1");(o.length===0&&e[r]>1||o.length>0&&!n)&&t.push(e[r])}return t}static unsqueezeShape(e,o){let t=new Array(e.length+o.length);t.fill(0);for(let n=0;n<o.length;n++){let s=a.normalizeAxis(o[n],t.length);if(s>=t.length)throw new Error("'axes' has an out of range axis");if(t[s]!==0)throw new Error("'axes' has a duplicate axis");t[s]=1}let r=0;for(let n=0;n<t.length;n++)t[n]===0&&(t[n]=e[r++]);if(r!==e.length)throw new Error("the unsqueezed dimension could not be established");return t}},_e=class a{static splitShape(e,o,t,r){if(t.length===0){if(!r)throw new Error("need to know number of outputs when the 'split' attribute is not specified");a.determineSplit(e[o],r,t)}let n=[],s=[0];for(let i=0;i<t.length;++i){i!==0&&s.push(s[i-1]+t[i-1]);let u=e.slice();u[o]=t[i],n.push(u)}return[n,s]}static determineSplit(e,o,t){if(e%o!==0)throw new Error("cannot split tensor to equal sized parts");for(let r=0;r<o;++r)t.push(e/o)}},Kt=class a{static adjustPoolAttributes(e,o,t,r,n,s){if(!e&&t.length!==o.length-2)throw new Error("length of specified kernel shapes should be 2 less than length of input dimensions");if(e)for(let i=0;i<o.length-2;i++)i>=t.length?t.push(o[i+2]):t[i]=o[i+2];for(let i=0;i<t.length;i++)if(i<r.length){if(r[i]<0)throw new Error("strides should be greater than or equal to 1")}else r.push(1);for(let i=0;i<t.length;i++)if(i<n.length){if(n[i]<0)throw new Error("dilations should be greater than or equal to 1")}else n.push(1);for(let i=0;i<t.length*2;i++)if(i<s.length){if(s[i]<0)throw new Error("pad should be greater than or equal to 1")}else s.push(0);for(let i=0;i<t.length;i++){if(t[i]<=0)throw new Error("kernel shapes need to be greater than 0");if(s[i]>=t[i]||s[i+t.length]>=t[i])throw new Error("pads should be smaller than kernel")}}static adjustPadsBasedOnAutoPad(e,o,t,r,n,s){if(s){if(n.length!==2*(e.length-2))throw new Error("length of pads should be twice the length of data dimensions");if(o.length!==e.length-2)throw new Error("length of strides should be the length of data dimensions");if(r.length!==e.length-2)throw new Error("length of kernel shapes should be the length of data dimensions");for(let i=0;i<e.length-2;i++)a.adjustPadAndReturnShape(e[i+2],o[i],t[i],r[i],n,i,i+e.length-2,s)}}static computePoolOutputShape(e,o,t,r,n,s,i){if(o.length<=0)throw new Error("input shape must be of size greater than 0");let u=[o[0],o[1]];return a.computeShapeHelper(e,o,u,t,r,n,s,i),u}static computeConvOutputShape(e,o,t,r,n,s,i){if(e.length<=0||o.length<=0)throw new Error("invalid input tensor dims or invalid filter tensor dims");let u=[e[0],o[0]];return a.computeShapeHelper(!1,e,u,t,r,n,s,i),u}static computeShapeHelper(e,o,t,r,n,s,i,u){if(e)for(let l=0;l<o.length-2;l++)t.push(1);else for(let l=0;l<o.length-2;l++)t.push(a.adjustPadAndReturnShape(o[l+2],r[l],n[l],s[l],i,l,l+o.length-2,u))}static adjustPadAndReturnShape(e,o,t,r,n,s,i,u){let l=t*(r-1)+1;if(u&&u!=="NOTSET")switch(u){case"VALID":return n[s]=0,n[i]=0,Math.floor((e-l)/o+1);case"SAME_LOWER":case"SAME_UPPER":if(t!==1)throw new Error("Dilation not supported for SAME_UPPER or SAME_LOWER");{let p=((e+o-1)/o-1)*o+r-e;return n[s]=Math.floor(u==="SAME_LOWER"?(p+1)/2:p/2),n[i]=p-n[s],Math.floor((e+p-r)/o+1)}default:throw new Error("Unsupported AutoPad type")}else return Math.floor((e+n[s]+n[i]-l)/o+1)}},Xt=-34028234663852886e22,Jt=34028234663852886e22});function jl(a){switch(a){case"bool":case"int8":case"uint8":return 1;case"int16":case"uint16":return 2;case"int32":case"uint32":case"float32":return 4;case"float64":return 8;default:throw new Error(`cannot calculate sizeof() on type ${a}`)}}function Ni(a){switch(a){case k.onnx.TensorProto.DataType.UINT8:case k.onnx.TensorProto.DataType.INT8:case k.onnx.TensorProto.DataType.BOOL:return 1;case k.onnx.TensorProto.DataType.UINT16:case k.onnx.TensorProto.DataType.INT16:return 2;case k.onnx.TensorProto.DataType.FLOAT:case k.onnx.TensorProto.DataType.INT32:case k.onnx.TensorProto.DataType.UINT32:return 4;case k.onnx.TensorProto.DataType.INT64:case k.onnx.TensorProto.DataType.DOUBLE:case k.onnx.TensorProto.DataType.UINT64:return 8;default:throw new Error(`cannot calculate sizeof() on type ${k.onnx.TensorProto.DataType[a]}`)}}function Kl(a,e){return new(Ri(e))(a)}function Ri(a){switch(a){case"bool":case"uint8":return Uint8Array;case"int8":return Int8Array;case"int16":return Int16Array;case"uint16":return Uint16Array;case"int32":return Int32Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"float32":return Float32Array;case"float64":return Float64Array;default:throw new Error("unspecified error")}}function un(a,e){if(e===k.onnx.TensorProto.DataType.INT64||e===sn.TensorDataType.INT64){if(a.greaterThanOrEqual(2147483648)||a.lessThan(-2147483648))throw new TypeError("int64 is not supported")}else if(e===k.onnx.TensorProto.DataType.UINT32||e===sn.TensorDataType.UINT32||e===k.onnx.TensorProto.DataType.UINT64||e===sn.TensorDataType.UINT64){if(a.greaterThanOrEqual(4294967296)||a.lessThan(0))throw new TypeError("uint64 is not supported")}else throw new TypeError(`not a LONG type: ${k.onnx.TensorProto.DataType[e]}`);return a.toNumber()}function Ci(a,e,o){switch(e){case k.onnx.TensorProto.DataType.BOOL:case k.onnx.TensorProto.DataType.UINT8:return a.getUint8(o);case k.onnx.TensorProto.DataType.INT8:return a.getInt8(o);case k.onnx.TensorProto.DataType.UINT16:return a.getUint16(o,!0);case k.onnx.TensorProto.DataType.INT16:return a.getInt16(o,!0);case k.onnx.TensorProto.DataType.FLOAT:return a.getFloat32(o,!0);case k.onnx.TensorProto.DataType.INT32:return a.getInt32(o,!0);case k.onnx.TensorProto.DataType.UINT32:return a.getUint32(o,!0);case k.onnx.TensorProto.DataType.INT64:return un($t.fromBits(a.getUint32(o,!0),a.getUint32(o+4,!0),!1),e);case k.onnx.TensorProto.DataType.DOUBLE:return a.getFloat64(o,!0);case k.onnx.TensorProto.DataType.UINT64:return un($t.fromBits(a.getUint32(o,!0),a.getUint32(o+4,!0),!0),e);default:throw new Error(`cannot read from DataView for type ${k.onnx.TensorProto.DataType[e]}`)}}var Gi,k,sn,Y,Zt=x(()=>{"use strict";Gi=re(Ao());Hr();Te();k=re(ae());z();sn=P.experimental.fbs,Y=class a{constructor(e,o,t,r,n,s=Gi.Guid.create()){this.dims=e;this.type=o;this.dataProvider=t;this.asyncDataProvider=r;this.cache=n;this.dataId=s;this.size=A.validateDimsAndCalcSize(e);let i=this.size,u=t===void 0&&r===void 0&&n===void 0;if(n!==void 0&&n.length!==i)throw new RangeError("Input dims doesn't match data length.");if(o==="string"){if(n!==void 0&&(!Array.isArray(n)||!n.every(l=>typeof l=="string")))throw new TypeError("cache should be a string array");u&&(this.cache=new Array(i))}else{if(n!==void 0){let l=Ri(o);if(!(n instanceof l))throw new TypeError(`cache should be type ${l.name}`)}if(u){let l=new ArrayBuffer(i*jl(o));this.cache=Kl(l,o)}}}get data(){if(this.cache===void 0){let e=this.dataProvider(this.dataId);if(e.length!==this.size)throw new Error("Length of data provided by the Data Provider is inconsistent with the dims of this Tensor.");this.cache=e}return this.cache}get stringData(){if(this.type!=="string")throw new TypeError("data type is not string");return this.data}get integerData(){switch(this.type){case"uint8":case"int8":case"uint16":case"int16":case"int32":case"uint32":case"bool":return this.data;default:throw new TypeError("data type is not integer (uint8, int8, uint16, int16, int32, uint32, bool)")}}get floatData(){switch(this.type){case"float32":case"float64":return this.data;default:throw new TypeError("data type is not float (float32, float64)")}}get numberData(){if(this.type!=="string")return this.data;throw new TypeError("type cannot be non-number (string)")}get(e){return this.data[A.indicesToOffset(e,this.strides)]}set(e,o){this.data[A.indicesToOffset(e,this.strides)]=o}async getData(){return this.cache===void 0&&(this.cache=await this.asyncDataProvider(this.dataId)),this.cache}get strides(){return this._strides||(this._strides=A.computeStrides(this.dims)),this._strides}static fromProto(e){if(!e)throw new Error("cannot construct Value from an empty tensor");let o=et.tensorDataTypeFromProto(e.dataType),t=et.tensorDimsFromProto(e.dims),r=new a(t,o);if(o==="string")e.stringData.forEach((n,s)=>{r.data[s]=Se(n)});else if(e.rawData&&typeof e.rawData.byteLength=="number"&&e.rawData.byteLength>0){let n=r.data,s=new DataView(e.rawData.buffer,e.rawData.byteOffset,e.rawData.byteLength),i=Ni(e.dataType),u=e.rawData.byteLength/i;if(e.rawData.byteLength%i!==0)throw new Error("invalid buffer length");if(n.length!==u)throw new Error("buffer length mismatch");for(let l=0;l<u;l++){let f=Ci(s,e.dataType,l*i);n[l]=f}}else{let n;switch(e.dataType){case k.onnx.TensorProto.DataType.FLOAT:n=e.floatData;break;case k.onnx.TensorProto.DataType.INT32:case k.onnx.TensorProto.DataType.INT16:case k.onnx.TensorProto.DataType.UINT16:case k.onnx.TensorProto.DataType.INT8:case k.onnx.TensorProto.DataType.UINT8:case k.onnx.TensorProto.DataType.BOOL:n=e.int32Data;break;case k.onnx.TensorProto.DataType.INT64:n=e.int64Data;break;case k.onnx.TensorProto.DataType.DOUBLE:n=e.doubleData;break;case k.onnx.TensorProto.DataType.UINT32:case k.onnx.TensorProto.DataType.UINT64:n=e.uint64Data;break;default:throw new Error("unspecific error")}if(n==null)throw new Error("failed to populate data from a tensorproto value");let s=r.data;if(s.length!==n.length)throw new Error("array length mismatch");for(let i=0;i<n.length;i++){let u=n[i];$t.isLong(u)?s[i]=un(u,e.dataType):s[i]=u}}return r}static fromData(e,o,t){return new a(o,t,void 0,void 0,e)}static fromOrtTensor(e){if(!e)throw new Error("cannot construct Value from an empty tensor");let o=et.tensorDimsFromORTFormat(e),t=et.tensorDataTypeFromProto(e.dataType()),r=new a(o,t);if(t==="string")for(let n=0;n<e.stringDataLength();n++)r.data[n]=e.stringData(n);else if(e.rawDataArray()&&typeof e.rawDataLength()=="number"&&e.rawDataLength()>0){let n=r.data,s=new DataView(e.rawDataArray().buffer,e.rawDataArray().byteOffset,e.rawDataLength()),i=Ni(e.dataType()),u=e.rawDataLength()/i;if(e.rawDataLength()%i!==0)throw new Error("invalid buffer length");if(n.length!==u)throw new Error("buffer length mismatch");for(let l=0;l<u;l++){let f=Ci(s,e.dataType(),l*i);n[l]=f}}return r}}});function D(a){return a===1?Xl:Jl}function Vi(a){let e=D(a);return`${e.version}
      precision highp float;
      ${e.attribute} vec3 position;
      ${e.attribute} vec2 textureCoord;

      ${e.varyingVertex} vec2 TexCoords;

      void main()
      {
          gl_Position = vec4(position, 1.0);
          TexCoords = textureCoord;
      }`}function zi(a){let e=D(a);return`${e.version}
    precision highp float;
    precision highp int;
    precision highp sampler2D;
    ${e.varyingFrag} vec2 TexCoords;
    ${e.outputDeclaration}
    const vec2 halfCR = vec2(0.5, 0.5);

    // Custom vector types to handle higher dimenalities.
    struct ivec5
    {
      int x;
      int y;
      int z;
      int w;
      int u;
    };

    struct ivec6
    {
      int x;
      int y;
      int z;
      int w;
      int u;
      int v;
    };

    int imod(int x, int y) {
      return x - y * (x / y);
    }

    `}function Mi(a,e){let o=D(a);return`
  void main() {
    int indices[${e}];
    toVec(TexCoords, indices);
    vec4 result = vec4(process(indices));
    ${o.output} = result;
  }
  `}var Xl,Jl,q=x(()=>{"use strict";Xl={version:"",attribute:"attribute",varyingVertex:"varying",varyingFrag:"varying",texture2D:"texture2D",output:"gl_FragColor",outputDeclaration:""},Jl={version:"#version 300 es",attribute:"in",varyingVertex:"out",varyingFrag:"in",texture2D:"texture",output:"outputColor",outputDeclaration:"out vec4 outputColor;"}});var N=x(()=>{"use strict"});async function ln(a,e=t=>0,o){return new Promise((t,r)=>{let n=0,s=()=>{if(a()){t();return}n++;let i=e(n);if(o!=null&&n>=o){r();return}setTimeout(s,i)};s()})}function rr(a){return se(typeof a<"u"&&a.length!==0,()=>"empty string found for sampler name"),"get"+a.charAt(0).toUpperCase()+a.slice(1)}function Ui(a){return se(typeof a<"u"&&a.length!==0,()=>"empty string found for sampler name"),"get"+a.charAt(0).toUpperCase()+a.slice(1)+"AtOutCoords"}function ue(a,e){let o=JSON.parse(JSON.stringify(a));return o=e,o}function le(a,e){return e.map(o=>a[o]).join(", ")}function at(a){if(a<=1)return"int";if(a===2)return"ivec2";if(a===3)return"ivec3";if(a===4)return"ivec4";if(a===5)return"ivec5";if(a===6)return"ivec6";throw Error(`GPU for rank ${a} is not yet supported`)}function It(a=6){return["x","y","z","w","u","v"].slice(0,a)}var At=x(()=>{"use strict";z()});function Zl(a,e){return It(e).map(o=>`${a}.${o}`)}function fe(a,e){return e===1?[a]:Zl(a,e)}function Pt(){return`
    float getChannel(vec4 frag, int dim) {
      int modCoord = imod(dim, 2);
      return modCoord == 0 ? frag.r : frag.g;
    }

    float getChannel(vec4 frag, vec2 innerDims) {
      vec2 modCoord = mod(innerDims, 2.);
      return modCoord.x == 0. ?
        (modCoord.y == 0. ? frag.r : frag.g) :
        (modCoord.y == 0. ? frag.b : frag.a);
    }
  `}var Yt=x(()=>{"use strict";At()});function Ql(a,e,o){if(a===0)return"false";if(a===1)return`rc > ${e[0]}`;let t="";for(let r=a-2;r<a;r++)t+=`${o[r]} >= ${e[r-a+2]}`,r<a-1&&(t+="||");return t}function tf(a,e){let o=a.length;if(o===0)return"getA(), 0, 0, 0";if(o===1)return`getA(rc),
            rc + 1 >= ${a[0]} ? 0. : getA(rc + 1),
            0, 0`;let t="r, c",r="r, cp1",n="rp1, c",s="rp1, cp1",i="";if(o>2)for(let u=0;u<o-2;++u)i=i+`${e[u]},`;return`getA(${i}${t}),
          rEdge ? 0. : getA(${i}${n}),
          cEdge ? 0. : getA(${i}${r}),
          rEdge || cEdge ? 0. : getA(${i}${s})`}function ef(a,e,o,t){return a===0||a===1?"":`
    int r = ${e[a-2]};
    int c = ${e[a-1]};
    int rp1 = ${e[a-2]} + 1;
    int cp1 = ${e[a-1]} + 1;
    bool rEdge = rp1 >= ${t};
    bool cEdge = cp1 >= ${o};
    `}var Wi,Yl,Hi,qi=x(()=>{"use strict";q();N();At();Yt();Wi={name:"pack",inputNames:["A"],inputTypes:[1]},Yl=(a,e)=>{let o=D(a.session.backend.glContext.version),t=e.dims,r=t.length,n=e.dims.length,s=at(n),i=fe("rc",n),u=ef(n,i,t[t.length-2],t[t.length-1]),l;r===0?l=[1,1]:r===1?l=[t[0],1]:l=[t[n-1],t[n-2]];let f=Ql(n,l,i),p=tf(t,i),d=`
        void main() {
          ${s} rc = getOutputCoords();

          if(${f}) {
            ${o.output} = vec4(0);
          } else {
            ${u}

            ${o.output} = vec4(${p});
          }
        }
      `;return{...Wi,hasMain:!0,output:{dims:e.dims,type:e.type,textureType:2},shaderSource:d}},Hi=(a,e)=>({...Wi,get:()=>Yl(a,e)})});function fn(a){if(a.length===0)return[1,1,1];let e=1;for(let o=0;o<a.length-2;++o)e*=a[o];return[e,a.length>1?a[a.length-2]:1,a[a.length-1]]}function Ki(a,e){let o=!1;return a.length===0||e.length===0?o=!0:a.length<2||e.length<2?o=a[a.length-1]===e[e.length-1]:o=a[a.length-1]===e[e.length-1]&&a[a.length-2]===e[e.length-2],o}function of(a){let e=A.computeStrides(a),o=["b","r","c"],t="index";return`
    ivec3 inputCoordsFromReshapedOutCoords(int index) {
      ${e.map((n,s)=>{let i=`int ${o[s]} = ${t} / ${n}`,u=s===e.length-1?`int ${o[s+1]} = ${t} - ${o[s]} * ${n}`:`index -= ${o[s]} * ${n}`;return`${i}; ${u};`}).join("")}
      return ivec3(b, r, c);
    }
  `}function af(a){let e=A.computeStrides(a);return`
  int getFlattenedIndex(ivec3 coords) {
    // reverse y, z order
    return coords.x * ${e[0]} + coords.z * ${e[1]} + coords.y;
  }
`}var rf,nf,ji,Xi=x(()=>{"use strict";z();q();N();Yt();rf=a=>({name:"Reshape (packed)",inputTypes:[2],inputNames:["A"],cacheHint:`${a}`}),nf=(a,e,o,t)=>{let r=e.dims,n=t,s="";for(let l=0;l<4;l++){let f="";switch(l){case 0:f="outputCoords = rc;";break;case 1:f="outputCoords = ivec3(rc.x, rc.y+1, rc.z);";break;case 2:f="outputCoords = ivec3(rc.x, rc.y, rc.z+1);";break;case 3:f="outputCoords = ivec3(rc.x, rc.y+1, rc.z+1);";break;default:throw new Error}s+=`
        ${f}
        ${l>0?"if(outputCoords.y < rows && outputCoords.z < cols){":""}
          int flattenedIndex = getFlattenedIndex(outputCoords);

          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flattenedIndex);
          vec2 innerDims = vec2(float(inputRC.y),float(inputRC.z));

          result[${l}] = getChannel(getA(inputRC.x, inputRC.y, inputRC.z), innerDims);

        ${l>0?"}":""}
      `}let i=D(a.session.backend.glContext.version),u=`
      ${of(r)}
      ${af(n)}
      ${Pt()}

      void main() {
        ivec3 rc = getOutputCoords();

        vec4 result = vec4(0.0);

        ivec3 outputCoords;
        int rows = ${n[2]};
        int cols = ${n[1]};

        ${s}
        ${i.output} = result;
      }
    `;return{...o,output:{dims:n,type:e.type,textureType:2},shaderSource:u,hasMain:!0}},ji=(a,e,o)=>{let t=rf(o);return{...t,get:()=>nf(a,e,t,o)}}});var cn,Ji=x(()=>{"use strict";q();N();cn=(a,e)=>{let o=e.shape,t=D(a.session.backend.glContext.version),r=`
    const float FLOAT_MAX = 1.70141184e38;
    const float FLOAT_MIN = 1.17549435e-38;

    bool isNaN(float val) {
      return (val < 1.0 || 0.0 < val || val == 0.0) ? false : true;
    }

    highp vec4 encodeAsUint8(highp float v) {
      if (isNaN(v)) {
        return vec4(255, 255, 255, 255);
      }

      highp float av = abs(v);

      if(av < FLOAT_MIN) {
        return vec4(0.0, 0.0, 0.0, 0.0);
      } else if(v > FLOAT_MAX) {
        return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;
      } else if(v < -FLOAT_MAX) {
        return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;
      }

      highp vec4 c = vec4(0,0,0,0);

      highp float e = floor(log2(av));
      highp float m = exp2(fract(log2(av))) - 1.0;

      c[2] = floor(128.0 * m);
      m -= c[2] / 128.0;
      c[1] = floor(32768.0 * m);
      m -= c[1] / 32768.0;
      c[0] = floor(8388608.0 * m);

      highp float ebias = e + 127.0;
      c[3] = floor(ebias / 2.0);
      ebias -= c[3] * 2.0;
      c[2] += floor(ebias) * 128.0;

      c[3] += 128.0 * step(0.0, -v);

      return c / 255.0;
    }

    void main() {
      float value = ${t.texture2D}(X,TexCoords).r;
      ${t.output} = encodeAsUint8(value);
    }`,n={name:"Uint8Encode",inputTypes:[0],inputNames:["X"],output:{dims:o,type:e.tensor.type,textureType:3},shaderSource:r,hasMain:!0};return a.executeProgram(n,[e.tensor])}});function uf(a,e){if(a===1)return"rc";let o="";for(let t=0;t<a;t++)o+=e[t],t<a-1&&(o+=",");return o}var Zi,sf,Yi,Qi=x(()=>{"use strict";q();N();At();Yt();Zi={name:"unpack",inputNames:["A"],inputTypes:[2]},sf=(a,e)=>{let o=e.dims.length,t=fe("rc",o),r=t.slice(-2),n=at(o),s=Pt(),u=e.dims.length===0?"":uf(o,t),l=o<=1?"rc":`vec2(${r.join(",")})`,f=D(a.session.backend.glContext.version),p=`
    ${s}
    void main() {
      ${n} rc = getOutputCoords();

       // Sample the texture with the coords to get the rgba channel value.
       vec4 packedInput = getA(${u});

       ${f.output} = vec4(getChannel(packedInput, ${l}), 0, 0, 0);
     }
   `;return{...Zi,hasMain:!0,output:{dims:e.dims,type:e.type,textureType:0},shaderSource:p}},Yi=(a,e)=>({...Zi,get:()=>sf(a,e)})});var nr,Oe,or,Ae=x(()=>{"use strict";ct();nr=class{constructor(e,o=1){if(o===1)this.internalFormat=e.R32F,this.format=e.RED,this.textureType=e.FLOAT,this.channelSize=o;else if(o===4)this.internalFormat=e.RGBA32F,this.format=e.RGBA,this.textureType=e.FLOAT,this.channelSize=o;else throw new Error(`Invalid number of channels: ${o}`)}encode(e,o){let t,r;return e.constructor!==Float32Array&&(M.warning("Encoder","data was not of type Float32; creating new Float32Array"),r=new Float32Array(e)),o*this.channelSize>e.length?(M.warning("Encoder","Source data too small. Allocating larger array"),r=e,t=this.allocate(o*this.channelSize),r.forEach((n,s)=>t[s]=n)):(r=e,t=r),t}allocate(e){return new Float32Array(e*4)}decode(e,o){return this.channelSize===1?e.filter((r,n)=>n%4===0).subarray(0,o):e.subarray(0,o)}},Oe=class{constructor(e,o=1,t){if(o!==1&&o!==4)throw new Error(`Invalid number of channels: ${o}`);this.internalFormat=e.RGBA,this.format=e.RGBA,this.channelSize=o,this.textureType=t||e.FLOAT}encode(e,o){let t=e;return this.channelSize===1&&(M.verbose("Encoder","Exploding into a larger array"),t=this.allocate(o),e.forEach((r,n)=>t[n*4]=r)),t}allocate(e){return new Float32Array(e*4)}decode(e,o){return this.channelSize===1?e.filter((r,n)=>n%4===0).subarray(0,o):e.subarray(0,o)}},or=class{constructor(e,o=1){this.channelSize=4;if(o===1)this.internalFormat=e.ALPHA,this.format=e.ALPHA,this.textureType=e.UNSIGNED_BYTE,this.channelSize=o;else if(o===4)this.internalFormat=e.RGBA,this.format=e.RGBA,this.textureType=e.UNSIGNED_BYTE,this.channelSize=o;else throw new Error(`Invalid number of channels: ${o}`)}encode(e,o){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)}allocate(e){return new Uint8Array(e*this.channelSize)}decode(e,o){if(e instanceof Uint8Array)return e.subarray(0,o);throw new Error(`Invalid array type: ${e.constructor}`)}}});var Pe,ta,pn,ea=x(()=>{"use strict";z();N();Pe=(a,e,o)=>{let t=o===0||o===1?1:4,r=o===2,n=o===1||o===2,s=o===4?e.length-1:void 0,i=o===4?e.map((u,l)=>l===e.length-1?u*4:u):void 0;return pn(a,e,t,i,{isPacked:r,reverseWH:n,breakAxis:s})},ta=(a,e,o)=>{let t=Pe(a,e,o);return[t.width,t.height]},pn=(a,e,o=1,t,r)=>{let n=!!(r&&r.isPacked),[s,i]=a.computeTextureWH(n&&t||e,r),u=e.length,l=e.slice(0);if(u===0&&(l=[1]),o===1)t=e;else if(n){if(o!==4)throw new Error("a packed texture must be 4-channel");t=e,u>0&&(l[u-1]=Math.ceil(l[u-1]/2)),u>1&&(l[u-2]=Math.ceil(l[u-2]/2))}else if(!t)throw new Error("Unpacked shape is needed when using channels > 1");return{width:s,height:i,channels:o,isPacked:n,shape:l,strides:A.computeStrides(l),unpackedShape:t,reversedWH:r&&r.reverseWH}}});var ff,ir,na=x(()=>{"use strict";ct();Zt();z();qi();Xi();Ji();Qi();Ae();ea();N();ff=(a,e)=>{let o=e.map(r=>`${r.unpackedShape.join(",")};${r.width}x${r.height}`).join("_"),t=a.name;return a.cacheHint&&(t+="["+a.cacheHint+"]"),t+=":"+o,t},ir=class{constructor(e){this.session=e;this.packedTextureDataCache=new Map,this.unpackedTextureDataCache=new Map}calculateTextureWidthAndHeight(e,o){return ta(this.session.layoutStrategy,e,o)}executeProgram(e,o){if(o.length<e.inputNames.length)throw new Error(`Input size mustn't be less than ${e.inputNames.length}.`);if(e.inputNames.length!==e.inputTypes.length)throw new Error("input names size does not match input types");let t=[];for(let l=0;l<e.inputNames.length;++l)t[l]=this.getOrCreateTextureData(o[l],e.inputTypes[l]);let r=ff(e,t),n=this.session.programManager.getArtifact(r),s=n?n.programInfo:typeof e.get=="function"?e.get():e,i=Pe(this.session.layoutStrategy,s.output.dims,s.output.textureType),u=this.createTextureData(i,s.output.type);return n||(n=this.session.programManager.build(s,t,u),this.session.programManager.setArtifact(r,n)),this.runProgram(n,t,u),u}run(e,o){return this.executeProgram(e,o).tensor}runProgram(e,o,t){for(let r=0;r<o.length;++r)if(!!o[r].isPacked!=(e.programInfo.inputTypes[r]===2))throw new Error(`input[${r}] property packed inconsistent`);if(!!t.isPacked!=(e.programInfo.output.textureType===2))throw new Error("output property packed inconsistent");this.session.programManager.run(e,o,t)}getOrCreateTextureData(e,o){let t=this.getTextureData(e.dataId,o===2);if(!t&&(t=this.getTextureData(e.dataId,o!==2),t))return o===2?this.pack(t):this.unpack(t);if(!t){let r=Pe(this.session.layoutStrategy,e.dims,o);if(o===4){let i=e.dims;if(i.length===4){let u=[i[0],Math.ceil(i[1]*i[2]*i[3]/4)],l=Pe(this.session.layoutStrategy,u,o),f=e.numberData;if(i[1]*i[2]*i[3]%4!==0){let p=i[0],d=i[1]*i[2]*i[3],m=Math.ceil(d*1/4)*4,g=p*m;f=new Float32Array(g);for(let y=0;y<p;++y){let v=y*d,_=y*m+y%1*d;f.set(e.numberData.subarray(v,v+d),_)}}return this.createTextureData(l,e.type,f,e,1)}}if(o===2){let n=pn(this.session.layoutStrategy,e.dims,1,[],{reverseWH:!0}),s=this.createTextureData(n,e.type,e.numberData,e,1);t=this.pack(s)}else t=this.createTextureData(r,e.type,e.numberData,e,1)}return t}createTextureDataFromLayoutBindTensor(e,o,t,r){return this.createTextureData(e,o,t,r,1)}createTextureData(e,o,t,r,n){M.verbose("InferenceHandler",`Creating TextureData: layout:[${JSON.stringify(e)}]`);let s=this.session.textureManager.createTextureFromLayout(o,e,t,n);return this.createTextureDataFromTexture(e,o,s,r)}reshapeUnpacked(e,o){let t=this.getOrCreateTextureData(e,0),r={channels:t.channels,height:t.height,width:t.width,shape:o.length!==0?o:[1],strides:A.computeStrides(o),unpackedShape:o};return this.createTextureDataFromTexture(r,e.type,t.texture).tensor}reshapePacked(e,o){let t=this.getOrCreateTextureData(e,2);if(Ki(e.dims,o)){let l={channels:t.channels,height:t.height,width:t.width,shape:o.length!==0?o:[1],strides:A.computeStrides(o),unpackedShape:o,isPacked:!0};return this.createTextureDataFromTexture(l,e.type,t.texture).tensor}let r=fn(e.dims),n=fn(o),s=this.reshapePacked(e,r),i=this.run(ji(this,s,n),[s]);return this.reshapePacked(i,o)}cast(e,o){let t=this.getOrCreateTextureData(e,0);return this.createTextureDataFromTexture(t,o,t.texture).tensor}createTextureDataFromTexture(e,o,t,r,n){let s={...e,tensor:r||new Y(e.unpackedShape,o,i=>this.readTexture(s),async i=>this.readTextureAsync(s),void 0,n),texture:t};return this.setTextureData(s.tensor.dataId,s,e.isPacked),s}getTextureData(e,o=!1){return this.session.isInitializer(e)?this.session.getTextureData(e,o):o?this.packedTextureDataCache.get(e):this.unpackedTextureDataCache.get(e)}setTextureData(e,o,t=!1){this.session.isInitializer(e)?this.session.setTextureData(e,o,t):(t?this.packedTextureDataCache:this.unpackedTextureDataCache).set(e,o)}isTextureLayoutCached(e,o=!1){return!!this.getTextureData(e.dataId,o)}dispose(){this.session.textureManager.clearActiveTextures(),this.packedTextureDataCache.forEach(e=>this.session.textureManager.releaseTexture(e)),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache.forEach(e=>this.session.textureManager.releaseTexture(e)),this.unpackedTextureDataCache=new Map}readTexture(e){return e.isPacked?this.readTexture(this.unpack(e)):this.session.backend.glContext.isFloat32DownloadSupported?this.session.textureManager.readTexture(e,e.tensor.type,e.channels):this.session.textureManager.readUint8TextureAsFloat(cn(this,e))}async readTextureAsync(e){return e.isPacked?this.readTextureAsync(this.unpack(e)):this.session.backend.glContext.isFloat32DownloadSupported?this.session.textureManager.readTextureAsync(e,e.tensor.type,e.channels):this.session.textureManager.readUint8TextureAsFloat(cn(this,e))}pack(e){return this.executeProgram(Hi(this,e.tensor),[e.tensor])}unpack(e){return this.executeProgram(Yi(this,e.tensor),[e.tensor])}}});var dn,$,tt=x(()=>{"use strict";dn=class{constructor(e){Object.assign(this,e)}get cacheKey(){return this.key||(this.key=Object.getOwnPropertyNames(this).sort().map(e=>`${this[e]}`).join(";")),this.key}},$=a=>new dn(a)});var oa,ia,aa,cf,pf,sa=x(()=>{"use strict";tt();q();N();oa={name:"BatchNormalization",inputNames:["A","Scale","B","Mean","Variance"],inputTypes:[0,0,0,0,0]},ia=(a,e,o)=>(pf(e),[a.run({...oa,cacheHint:o.cacheKey,get:()=>cf(a,e,o)},e)]),aa=a=>{let e=a.attributes.getFloat("epsilon",1e-5),o=a.attributes.getFloat("momentum",.9),t=a.attributes.getInt("spatial",1);return $({epsilon:e,momentum:o,spatial:t})},cf=(a,e,o)=>{let t=D(a.session.backend.glContext.version),r=e[0].dims.length,[n,s]=a.calculateTextureWidthAndHeight(e[1].dims,0),i=`
  float process(int[${r}] indices) {
    vec2 position = offsetToCoords(indices[1], ${n}, ${s});
    float scale = getColorAsFloat(${t.texture2D}(Scale, position));
    float mean = getColorAsFloat(${t.texture2D}(Mean, position));
    float variance = getColorAsFloat(${t.texture2D}(Variance, position));
    float b = getColorAsFloat(${t.texture2D}(B, position));

    return scale * ( (_A(indices) - mean) / sqrt(variance + float(${o.epsilon})) ) + b;
  }`;return{...oa,output:{dims:e[0].dims,type:e[0].type,textureType:0},shaderSource:i}},pf=a=>{if(!a||a.length!==5)throw new Error("BatchNormalization requires 5 inputs.");let e=a[0],o=a[1],t=a[2],r=a[3],n=a[4];if(e.dims.length<3||o.dims.length!==1||t.dims.length!==1||r.dims.length!==1||n.dims.length!==1)throw new Error("invalid input shape.");if(o.dims[0]!==e.dims[1]||t.dims[0]!==e.dims[1]||r.dims[0]!==e.dims[1]||n.dims[0]!==e.dims[1])throw new Error("invalid input shape.");if(e.type!=="float32"&&e.type!=="float64"||o.type!=="float32"&&o.type!=="float64"||t.type!=="float32"&&t.type!=="float64"||r.type!=="float32"&&r.type!=="float64"||n.type!=="float32"&&n.type!=="float64")throw new Error("invalid input tensor types.")}});var ar,mt,I,Ee,sr,kt=x(()=>{"use strict";ar=class{constructor(e,o,t,r){this.glContext=e;this.programInfo=o;this.inputTextureLayouts=t;this.outputTextureLayout=r}},mt=class{constructor(e){this.context=e}},I=class{constructor(e,o){this.routineBody=e;this.dependencies=o}},Ee=class{constructor(e,o,t){this.name=e;t?this.dependencies=t:this.dependencies=[],o&&(this.routineBody=o)}addDependency(e){e&&this.dependencies.push(e)}},sr=class{static returnOrderedNodes(e){if(!e||e.length===0)return[];if(e.length===1)return e;let o=new Set,t=new Set,r=new Array;return this.createOrderedNodes(e,o,t,r),r}static createOrderedNodes(e,o,t,r){for(let n=0;n<e.length;++n)this.dfsTraverse(e[n],o,t,r)}static dfsTraverse(e,o,t,r){if(!e||t.has(e.name))return;if(o.has(e.name))throw new Error("Cyclic dependency detected. Can't topologically sort routines needed for shader.");o.add(e.name);let n=e.dependencies;if(n&&n.length>0)for(let s=0;s<n.length;++s)this.dfsTraverse(n[s],o,t,r);r.push(e),t.add(e.name),o.delete(e.name)}}});function hf(){let a="add_";return{body:`
  float ${a}(float a, float b) {
    return a + b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 + v2;
  }
  `,name:a,type:0}}function mf(){let a="div_";return{body:`
  float ${a}(float a, float b) {
    return a / b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 / v2;
  }
  `,name:a,type:0}}function bf(){let a="mul_";return{body:`
  float ${a}(float a, float b) {
    return a * b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 * v2;
  }
  `,name:a,type:0}}function yf(){let a="sub_";return{body:`
  float ${a}(float a, float b) {
    return a - b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 - v2;
  }
  `,name:a,type:0}}function gf(){let a="equal_";return{body:`
  float ${a}(float a, float b) {
    return float(a == b);
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4(equal(v1, v2));
  }
  `,name:a,type:0}}function xf(){let a="greater_";return{body:`
  float ${a}(float a, float b) {
    return float(a > b);
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4( v1.r > v2.r ,
      v1.g > v2.g,
      v1.b > v2.b,
      v1.a > v2.a );
  }
  `,name:a,type:0}}function Tf(){let a="less_";return{body:`
  float ${a}(float a, float b) {
    return float(a < b);
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4( v1.r < v2.r ,
                v1.g < v2.g,
                v1.b < v2.b,
                v1.a < v2.a );
  }
  `,name:a,type:0}}function vf(){let a="and_";return{body:`
  float ${a}(float a, float b) {
    return float( bool(a) && bool(b) );
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r && b2.r ,
                b1.g && b2.g,
                b1.b && b2.b,
                b1.a && b2.a );
  }
  `,name:a,type:0}}function wf(){let a="or_";return{body:`
  float ${a}(float a, float b) {
    return float( bool(a) || bool(b) );
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r || b2.r ,
                b1.g || b2.g,
                b1.b || b2.b,
                b1.a || b2.a );
  }
  `,name:a,type:0}}function If(){let a="xor_";return{body:`
  float ${a}(float a, float b) {
    return float( bool(a) ^^ bool(b) );
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r ^^ b2.r ,
                b1.g ^^ b2.g,
                b1.b ^^ b2.b,
                b1.a ^^ b2.a );
  }
  `,name:a,type:0}}function _f(){return Of("pow")}function Sf(){let a="prelu_";return{body:`
  float ${a}(float a, float b) {
    return a < 0.0 ? a * b: a;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4(
      v1.r < 0.0 ? v1.r * v2.r: v1.r,
      v1.g < 0.0 ? v1.g * v2.g: v1.g,
      v1.b < 0.0 ? v1.b * v2.b: v1.b,
      v1.a < 0.0 ? v1.a * v2.a: v1.a
      );
  }
  `,name:a,type:0}}function Of(a){let e=`${a}_`;return{body:`
  float ${e}(float a, float b) {
    return ${a}(a, b);
  }
  vec4 ${e}(vec4 v1, vec4 v2) {
    return ${a}(v1, v2);
  }
  `,name:e,type:0}}var bt,Af,ua,la,fa,ca,pa,da,ha,ma,ba,ya,ga,xa,Ta=x(()=>{"use strict";z();kt();q();N();bt=(a,e,o,t=e[0].type,r)=>{let n=a.session.pack?2:0;return{name:o.name,inputNames:["A","B"],inputTypes:[n,n],cacheHint:r,get:()=>Af(a,e,o,t)}},Af=(a,e,o,t=e[0].type)=>{let r=a.session.pack?2:0,n=!A.areEqual(e[0].dims,e[1].dims),s=e[0].dims,i=a.session.pack;if(n){let f=it.calcShape(e[0].dims,e[1].dims,!1);if(!f)throw new Error("Can't perform binary op on the given tensors");s=f;let p=s.length,d=e[0].dims.length!==0?e[0].dims.length:1,m=e[1].dims.length!==0?e[1].dims.length:1,g=e[0].dims.length!==0?"bcastIndices_A(indices, aindices);":"aindices[0] = 0;",y=e[1].dims.length!==0?"bcastIndices_B(indices, bindices);":"bindices[0] = 0;",v=D(a.session.backend.glContext.version),_=i?`
      ${o.body}
      void main() {
        vec4 a = getAAtOutCoords();
        vec4 b = getBAtOutCoords();
        vec4 result = ${o.name}(a, b);
        ${v.output} = result;
      }`:`
      ${o.body}
      float process(int indices[${p}]) {
        int aindices[${d}];
        int bindices[${m}];
        ${g}
        ${y}
        return ${o.name}(_A(aindices), _B(bindices));
      }`;return{name:o.name,inputNames:["A","B"],inputTypes:[r,r],output:{dims:s,type:t,textureType:r},shaderSource:_,hasMain:i}}let u=D(a.session.backend.glContext.version),l=`
    ${o.body}
    void main() {
      vec4 v1 = ${u.texture2D}(A, TexCoords);
      vec4 v2 = ${u.texture2D}(B, TexCoords);
      vec4 result = ${o.name}(v1, v2);
      ${u.output} = result;
    }
    `;return{name:o.name,inputNames:["A","B"],inputTypes:[r,r],output:{dims:e[0].dims,type:t,textureType:r},shaderSource:l,hasMain:!0}},ua=(a,e)=>[a.run(bt(a,e,hf()),e)],la=(a,e)=>[a.run(bt(a,e,vf(),"bool"),e)],fa=(a,e)=>[a.run(bt(a,e,mf()),e)],ca=(a,e)=>[a.run(bt(a,e,gf(),"bool"),e)],pa=(a,e)=>[a.run(bt(a,e,xf(),"bool"),e)],da=(a,e)=>[a.run(bt(a,e,Tf(),"bool"),e)],ha=(a,e)=>[a.run(bt(a,e,bf()),e)],ma=(a,e)=>[a.run(bt(a,e,wf(),"bool"),e)],ba=(a,e)=>[a.run(bt(a,e,_f()),e)],ya=(a,e)=>[a.run(bt(a,e,Sf()),e)],ga=(a,e)=>[a.run(bt(a,e,yf()),e)],xa=(a,e)=>[a.run(bt(a,e,If(),"bool"),e)]});var va,wa,Ef,Ia=x(()=>{"use strict";z();va=(a,e,o)=>(Ef(e),[a.cast(e[0],o)]),wa=a=>et.tensorDataTypeFromProto(a.attributes.getInt("to")),Ef=a=>{if(!a||a.length!==1)throw new Error("Cast requires 1 input.");if(a[0].type==="string")throw new Error("Invalid input type.")}});var Df,Lf,_a,ur,Sa=x(()=>{"use strict";q();N();At();Yt();Df=(a,e)=>({name:"Concat (packed)",inputNames:Array.from({length:a},(o,t)=>`X${t}`),inputTypes:Array(a).fill(2),cacheHint:e}),Lf=(a,e,o,t)=>{let r=o[0].dims.slice();if(t>=r.length||t<-1*r.length)throw new Error("axis specified for concat doesn't match input dimensionality");t<0&&(t=r.length+t);let n=r.slice(0);for(let F=1;F<o.length;F++){let st=o[F].dims.slice();for(let _t=0;_t<r.length;_t++)if(_t===t)n[t]+=st[_t];else if(r[_t]!==st[_t])throw new Error("non concat dimensions must match")}let s=n.length,i=fe("coords",s),u=at(s),l=Pt(),f=o.map(F=>F.dims),p=It(s),d=new Array(f.length-1);d[0]=f[0][t];for(let F=1;F<d.length;F++)d[F]=d[F-1]+f[F][t];let m=p[t],g=p.slice(-2),y=p.join(),v=`if (${m} < ${d[0]}) {
        return getChannel(
            getX0(${y}), vec2(${g.join()}));
        }`;for(let F=1;F<d.length;F++){let st=d[F-1];v+=`
            if (${m} < ${d[F]}  && ${m} >= ${d[F-1]}) {
              return getChannel(
                getX${F}(${ur(p,m,st)}),
                vec2(${ur(g,m,st)}));
            }`}let _=d.length,O=d[d.length-1];v+=`
            return getChannel(
              getX${_}(${ur(p,m,O)}),
              vec2(${ur(g,m,O)}));`;let S=D(a.session.backend.glContext.version),C=`
          ${l}
          float getValue(${p.map(F=>"int "+F)}) {
            ${v}
          }

          void main() {
            ${u} coords = getOutputCoords();
            int lastDim = coords.${p[s-1]};
            coords.${p[s-1]} = coords.${p[s-2]};
            coords.${p[s-2]} = lastDim;

            vec4 result = vec4(getValue(${i}), 0., 0., 0.);

            ${i[s-1]} = ${i[s-1]} + 1;
            if (${i[s-1]} < ${n[s-1]}) {
              result.g = getValue(${i});
            }

            ${i[s-2]} = ${i[s-2]} + 1;
            if (${i[s-2]} < ${n[s-2]}) {
              result.a = getValue(${i});
            }

            ${i[s-1]} = ${i[s-1]} - 1;
            if (${i[s-2]} < ${n[s-2]} &&
                ${i[s-1]} < ${n[s-1]}) {
              result.b = getValue(${i});
            }
            ${S.output} = result;
          }
        `;return{...e,output:{dims:n,type:o[0].type,textureType:2},shaderSource:C,hasMain:!0}},_a=(a,e,o)=>{let t=Df(e.length,o.cacheKey);return{...t,get:()=>Lf(a,t,e,o.axis)}},ur=(a,e,o)=>{let t=a.indexOf(e);return a.map((n,s)=>s===t?`${n} - ${o}`:n).join()}});var Oa,$f,kf,Bf,Aa,Ff,Nf,Cf,Pa,Gf,Ea=x(()=>{"use strict";tt();N();Sa();Oa=(a,e,o)=>(Gf(e),a.session.pack&&e[0].dims.length>1?[a.run(_a(a,e,o),e)]:[a.run(Bf(a,e,o),e)]),$f=(a,e)=>({name:"Concat",inputNames:Array.from({length:a},(o,t)=>`X${t}`),inputTypes:Array(a).fill(0),cacheHint:e}),kf=(a,e,o,t)=>{let r=o[0].dims.slice();if(t>=r.length||t<-1*r.length)throw new Error("axis specified for concat doesn't match input dimensionality");t<0&&(t=r.length+t);let n=r.slice(0);for(let m=1;m<o.length;m++){let g=o[m].dims.slice();for(let y=0;y<r.length;y++)if(y===t)n[t]+=g[y];else if(r[y]!==g[y])throw new Error("non concat dimensions must match")}let s=n.length,i=new Array(o.length),u=0;for(let m=0;m<i.length;++m)u+=o[m].dims[t],i[m]=u;let l="";o.length<5?l=Aa(i):l=Ff(i);let f=Nf(o.length,s),p=Cf(i),d=`
        ${f}
        ${p}
        ${l}
        float process(int indices[${s}]) {
          int textureIndex = getTextureWhereDataResides (indices[${t}]);

          if(textureIndex != 0) {
            indices[${t}] = indices[${t}] - int(getSizeInConcatAxisValueFromIndex(textureIndex-int(1)));
          }

          return fetchDataFromCorrectTexture(textureIndex, indices);
        }`;return{...e,output:{dims:n,type:o[0].type,textureType:0},shaderSource:d}},Bf=(a,e,o)=>{let t=$f(e.length,o.cacheKey);return{...t,get:()=>kf(a,t,e,o.axis)}},Aa=a=>`int getTextureWhereDataResides(int index) {
      ${a.map((o,t)=>`if(index<${o}) {return ${t};}
`).join("")}
    }`,Ff=a=>Aa(a),Nf=(a,e)=>{let o=[`float fetchDataFromCorrectTexture(int textureIndex, int indices[${e}]) {`];for(let t=0;t<a;++t)t===0?o.push(`	if (textureIndex == ${t}) { return _X${t}(indices); }`):t===a-1?o.push(`	else { return _X${t}(indices); }`):o.push(`	else if (textureIndex == ${t}) { return _X${t}(indices); }`);return o.push("	}"),o.join(`
`)},Cf=a=>{let e=["int getSizeInConcatAxisValueFromIndex(int index) {"];for(let o=0;o<a.length;++o)o===0?e.push(`	if (index == ${o}) { return ${a[o]}; }`):o===a.length-1?e.push(`	else { return ${a[o]}; }`):e.push(`	else if (index == ${o}) { return ${a[o]}; }`);return e.push("	}"),e.join(`
`)},Pa=a=>$({axis:a.attributes.getInt("axis")}),Gf=a=>{if(!a||a.length<1)throw new Error("too few inputs");let e=a[0].type,o=a[0].dims.length;if(e==="string")throw new Error("string tensor is not supported yet");for(let t of a){if(t.type!==e)throw new Error("input tensors should be one type");if(t.dims.length!==o)throw new Error("input tensors should have the same shape")}}});function Rf(){return yt("abs")}function Vf(){return yt("acos")}function zf(){return yt("asin")}function Mf(){return yt("atan")}function Uf(){return yt("ceil")}function Wf(){return yt("cos")}function Hf(a){let e="elu";return{body:`
  const float alpha = float(${a});

  float ${e}_(float a) {
    return a >= 0.0 ? a: (exp(a) - 1.0) * alpha;
  }
  vec4 ${e}_(vec4 v) {
    return vec4(${e}_(v.x), ${e}_(v.y), ${e}_(v.z), ${e}_(v.w));
  }
  `,name:e,type:0}}function qf(){return yt("exp")}function jf(){return yt("floor")}function hn(a,e){let o="clip";return{body:`
  const float min = float(${a});
  const float max = float(${e});

  float ${o}_(float a) {
    return clamp(a, min, max);
  }
  vec4 ${o}_(vec4 v) {
    return clamp(v, min, max);
  }
  `,name:o,type:0}}function Kf(){let a="indentity";return{body:`
  float ${a}_(float a) {
    return a;
  }
  vec4 ${a}_(vec4 v) {
    return v;
  }
  `,name:a,type:0}}function Xf(a){let e="leakyRelu";return{body:`
  const float alpha = float(${a});

  float ${e}_(float a) {
    return a < 0.0 ? a * alpha : a;
  }
  vec4 ${e}_(vec4 v) {
    return vec4(${e}_(v.x), ${e}_(v.y), ${e}_(v.z), ${e}_(v.w));
  }
  `,name:e,type:0}}function Jf(){return yt("log")}function Zf(){let a="neg";return{body:`
  float ${a}_(float a) {
    return -a;
  }
  vec4 ${a}_(vec4 v) {
    return -v;
  }
  `,name:a,type:0}}function Yf(){let a="not";return{body:`
  float ${a}_(float a) {
    return float( ! bool(a) );
  }
  bool ${a}_(bool a) {
    return !a;
  }
  vec4 ${a}_(vec4 v) {
    return vec4(!bool(v.x), !bool(v.y), !bool(v.z), !bool(v.w));
  }
  bvec4 ${a}_(bvec4 v) {
    return bvec4(!v.x, !v.y, !v.z, !v.w);
  }
  `,name:a,type:0}}function Qf(){return yt("sin")}function mn(){let a="relu";return{body:`
  float ${a}_(float a) {
    return max( a, 0.0 );
  }
  vec4 ${a}_(vec4 v) {
    return max( v, 0.0 );
  }
  `,name:a,type:0}}function bn(){let a="sigmoid";return{body:`
  float ${a}_(float a) {
    return 1.0 / (1.0 + exp(-a));
  }
  vec4 ${a}_(vec4 v) {
    return 1.0 / (1.0 + exp(-v));
  }
  `,name:a,type:0}}function tc(){return yt("sqrt")}function ec(){return yt("tan")}function rc(){let a="tanh";return{body:`
  float ${a}_(float a) {
    a = clamp(a, -10., 10.);
    a = exp(2.*a);
    return (a - 1.) / (a + 1.);
  }
  vec4 ${a}_(vec4 v) {
    v = clamp(v, -10., 10.);
    v = exp(2.*v);
    return (v - 1.) / (v + 1.);
  }
  `,name:a,type:0}}function yt(a){return{body:`
  float ${a}_(float a) {
    return ${a}(a);
  }
  vec4 ${a}_(vec4 v) {
    return ${a}(v);
  }
  `,name:a,type:0}}var nc,J,Da,La,$a,ka,yn,Ba,Fa,oc,Na,Ca,Ga,Ra,Va,za,gn,Ma,Ua,Wa,Ha,qa,ja,Ka,Xa,Ja,Za,Ya,xn=x(()=>{"use strict";tt();z();kt();q();N();nc=(a,e,o,t)=>{let r=a.session.pack?2:0,n=D(a.session.backend.glContext.version);return{...e,output:{dims:o.dims,type:o.type,textureType:r},shaderSource:`
     ${t.body}
     void main() {
       vec4 v = ${n.texture2D}(A, TexCoords);
       v = ${t.name}_(v);
       ${n.output} = v;
     }
     `,hasMain:!0}},J=(a,e,o,t)=>{let r=a.session.pack?2:0,n={name:o.name,inputTypes:[r],inputNames:["A"],cacheHint:t};return{...n,get:()=>nc(a,n,e,o)}},Da=(a,e)=>[a.run(J(a,e[0],Rf()),e)],La=(a,e)=>[a.run(J(a,e[0],Vf()),e)],$a=(a,e)=>[a.run(J(a,e[0],zf()),e)],ka=(a,e)=>[a.run(J(a,e[0],Mf()),e)],yn=(a,e,o)=>[a.run(J(a,e[0],hn(o.min,o.max),o.cacheKey),e)],Ba=a=>$({min:a.attributes.getFloat("min",Xt),max:a.attributes.getFloat("max",Jt)}),Fa=(a,e)=>{let o=oc(a,e);return yn(a,[e[0]],o)},oc=(a,e)=>{if(e.length>=3&&(!a.session.isInitializer(e[1].dataId)||!a.session.isInitializer(e[2].dataId)))throw new Error("dynamic clip attributes are not allowed");let o=e.length>=3?e[1].numberData[0]:Xt,t=e.length>=3?e[2].numberData[0]:Jt;return $({min:o,max:t})},Na=(a,e)=>[a.run(J(a,e[0],Uf()),e)],Ca=(a,e)=>[a.run(J(a,e[0],Wf()),e)],Ga=(a,e,o)=>[a.run(J(a,e[0],Hf(o.alpha),o.cacheKey),e)],Ra=a=>$({alpha:a.attributes.getFloat("alpha",1)}),Va=(a,e)=>[a.run(J(a,e[0],qf()),e)],za=(a,e)=>[a.run(J(a,e[0],jf()),e)],gn=(a,e)=>[a.run(J(a,e[0],Kf()),e)],Ma=(a,e,o)=>[a.run(J(a,e[0],Xf(o.alpha),o.cacheKey),e)],Ua=a=>$({alpha:a.attributes.getFloat("alpha",.01)}),Wa=(a,e)=>[a.run(J(a,e[0],Jf()),e)],Ha=(a,e)=>[a.run(J(a,e[0],Zf()),e)],qa=(a,e)=>[a.run(J(a,e[0],Yf()),e)],ja=(a,e)=>[a.run(J(a,e[0],mn()),e)],Ka=(a,e)=>[a.run(J(a,e[0],bn()),e)],Xa=(a,e)=>[a.run(J(a,e[0],Qf()),e)],Ja=(a,e)=>[a.run(J(a,e[0],tc()),e)],Za=(a,e)=>[a.run(J(a,e[0],ec()),e)],Ya=(a,e)=>[a.run(J(a,e[0],rc()),e)]});function Et(a){let e;switch(a.activation){case"Relu":e=mn();break;case"Sigmoid":e=bn();break;case"Clip":e=hn(a.clipMin,a.clipMax);break;default:return{activationFunction:"",applyActivation:""}}let o=e.name,t=e.body,r=`value = ${o}_(value);`;return{activationFunction:t,applyActivation:r}}var ce,Qt=x(()=>{"use strict";z();xn();ce=a=>{let e=a.getString("activation","");if(e==="Clip"){let[o,t]=a.getFloats("activation_params",[Xt,Jt]);return{activation:e,clipMax:t,clipMin:o,activationCacheKey:`${e}:${o},${t}`}}return{activation:e,activationCacheKey:e}}});var ac,sc,Qa,ts=x(()=>{"use strict";ct();q();N();lr();Qt();ac=(a,e)=>({name:"GroupedConv",inputNames:a?["X","W","Bias"]:["X","W"],inputTypes:a?[0,0,0]:[0,0],cacheHint:e}),sc=(a,e,o,t)=>{let n=e.length>2?"value += getBias(output_channel);":"",s=e[0].dims.slice(),i=e[1].dims.slice(),u=i[0]/t.group;M.verbose("GroupedConv",`autpPad:${t.autoPad}, dilations:${t.dilations}, group:${t.group}, kernelShape:${t.kernelShape}, pads:${t.pads}, strides:${t.strides}`);let l=pe(s,i,t.dilations,t.pads,t.strides),f=D(a.session.backend.glContext.version),{activationFunction:p,applyActivation:d}=Et(t),m=`
  const ivec2 strides = ivec2(${t.strides[0]}, ${t.strides[1]});
  const ivec2 pads = ivec2(${t.pads[0]}, ${t.pads[1]});
  ${p}
  void main() {
    ivec4 coords = getOutputCoords();
    int batch = coords.x;
    int output_channel = coords.y;
    ivec2 xRCCorner = coords.zw * strides - pads;
    int group_id = output_channel / ${u};

    float value = 0.0;
    for (int wInChannel = 0; wInChannel < ${i[1]}; wInChannel++) {
      int input_channel = group_id * ${i[1]} + wInChannel;
      for (int wHeight = 0; wHeight < ${i[2]}; wHeight++) {
        int xHeight = xRCCorner.x + wHeight * ${t.dilations[0]};

        if (xHeight < 0 || xHeight >= ${s[2]}) {
          continue;
        }

        for (int wWidth = 0; wWidth < ${i[3]}; wWidth++) {
          int xWidth = xRCCorner.y + wWidth * ${t.dilations[1]};
          if (xWidth < 0 || xWidth >= ${s[3]}) {
            continue;
          }

          float xVal = getX(batch, input_channel, xWidth, xHeight);
          float wVal = getW(output_channel, wInChannel, wWidth, wHeight);
          value += xVal*wVal;
        }
      }
    }
    ${n}
    ${d}
    ${f.output} = vec4(value, .0, .0, .0);
  }
`;return{...o,output:{dims:l,type:e[0].type,textureType:0},shaderSource:m,hasMain:!0}},Qa=(a,e,o)=>{let t=ac(e.length>2,o.cacheKey);return{...t,get:()=>sc(a,e,t,o)}}});var uc,lc,es,rs=x(()=>{"use strict";q();N();Yt();uc=a=>({name:"Im2Col (packed)",inputNames:["A"],inputTypes:[2],cacheHint:a}),lc=(a,e,o,t,r,n)=>{let s=o.dims,i=t.dims,u=2,l=3,f=r.length,p=[i[1]*i[2]*i[3],r[2]*r[3]],d=i[2]*i[3],m=Pt(),g=D(a.session.backend.glContext.version),y="";for(let _=0;_<=1;_++)for(let O=0;O<=1;O++)y+=`
            blockIndex = rc.x + ${O};
            pos = rc.y + ${_};

            if(blockIndex < ${p[1]} && pos < ${p[0]}) {
              offsetY = int(blockIndex / (${r[f-1]})) * ${n.strides[0]} -
                ${n.pads[0]};
              d0 = offsetY + ${n.dilations[0]} * (imod(pos, ${d}) / ${i[2]});

              if(d0 < ${s[u]} && d0 >= 0) {
                offsetX = imod(blockIndex, ${r[f-1]}) * ${n.strides[1]} -
                  ${n.pads[1]};
                d1 = offsetX + ${n.dilations[1]} * imod(imod(pos, ${d}), ${i[2]});

                if(d1 < ${s[l]} && d1 >= 0) {

                  ch = int(float(pos)/ ${d}.);
                    innerDims = vec2(d0, d1);
                    result[${_*2+O}] = getChannel(
                      getA(0, ch, int(innerDims.x),
                      int(innerDims.y)), innerDims);
                }
              }
            }

          `;let v=`
      ${m}

      void main() {
        ivec2 rc = getOutputCoords();
          vec4 result = vec4(0.0);
          int blockIndex, pos, offsetY, d0, offsetX, d1, ch;
          vec2 innerDims;
          ${y}
          ${g.output} = result;
      }
            `;return{...e,output:{dims:p,type:o.type,textureType:2},shaderSource:v,hasMain:!0}},es=(a,e,o,t,r)=>{let n=uc(r.cacheKey);return{...n,get:()=>lc(a,n,e,o,t,r)}}});function cc(a,e,o){let t=e[0].dims,r=e[1].dims,n=it.calcShape(t,r,!0);if(!n)throw new Error("Can't use matmul on the given tensors");let s=at(n.length),i=It(),{activationFunction:u,applyActivation:l}=Et(o),f=e.length>2,p=f?"value += getBiasForMatmul();":"",d=f?`${vn(s,i,e[2].dims,n,!1)}`:"",m=n.length,g=t.length,y=r.length,v=t[t.length-1],_=`
    ${u}
    ${d}
    float process(int indices[${m}]) {
        int a[${g}];
        int b[${y}];
        bcastMatmulIndices_A(indices, a);
        bcastMatmulIndices_B(indices, b);

        float value;
        for (int k=0; k<${v}; ++k) {
            a[${g-1}] = k;
            b[${y-2}] = k;
            value += _A(a) * _B(b);
        }
        ${p}
        ${l}
        return value;
    }`;return{...a,output:{dims:n,type:e[0].type,textureType:0},shaderSource:_}}function Tn(a,e){let o=fc(a.length>2,e.activationCacheKey);return{...o,get:()=>cc(o,a,e)}}function vn(a,e,o,t,r){let n="",s=o.length,i=t.length,u=i-s;i<2&&s>0?n="coords":n=o.map((y,v)=>`coords.${e[v+u]}`).join(", ");let f=it.getBroadcastDims(o,t).map(y=>`coords.${e[y+u]} = 0;`).join(`
`),d=A.size(o)===1,m="vec4(outputValue.xx, outputValue.yy)";return d&&(m="vec4(outputValue.x)"),r?`
vec4 getBiasForMatmul() {
  ${a} coords = getOutputCoords();
  ${f}
  vec4 outputValue = getBias(${n});
  return ${m};
}`:`
float getBiasForMatmul() {
  ${a} coords = getOutputCoords();
  ${f}
  return getBias(coords.x);
}`}var ns,os,fc,pc,fr=x(()=>{"use strict";z();N();At();Qt();wn();ns=(a,e,o)=>(pc(e),a.session.pack?[a.run(cr(a,e,o),e)]:[a.run(Tn(e,o),e)]),os=a=>ce(a.attributes),fc=(a,e)=>({name:"MatMul",inputNames:a?["A","B","Bias"]:["A","B"],inputTypes:a?[0,0,0]:[0,0],cacheHint:e});pc=a=>{if(!a||a.length!==2)throw new Error("MatMul requires 2 inputs.");if(a[0].dims[a[0].dims.length-1]!==a[1].dims[a[1].dims.length-2])throw new Error("shared dimension does not match.");if(a[0].type!=="float32"&&a[0].type!=="float64"||a[1].type!=="float32"&&a[1].type!=="float64")throw new Error("inputs should be float type");if(a[0].type!==a[1].type)throw new Error("inputs types should match")}});function mc(a,e,o,t){let r=[],n=[],s=o[0].dims,i=o[1].dims,u=s.length,l=i.length,f=t.length,p=f-u,d=f-l;r=s.map((S,C)=>`coords.${e[C+p]}`),r[u-1]="i*2",r.join(", "),n=i.map((S,C)=>`coords.${e[C+d]}`),n[l-2]="i*2",n.join(", ");let m=it.getBroadcastDims(s,t),g=it.getBroadcastDims(i,t),y=m.map(S=>`coords.${e[S+p]} = 0;`).join(`
`),v=g.map(S=>`coords.${e[S+d]} = 0;`).join(`
`),_=`int lastDim = coords.${e[f-1]};
  coords.${e[f-1]} = coords.${e[f-2]};
  coords.${e[f-2]} = lastDim;`;return`
vec4 getAAtOutCoordsMatmul(int i) {
  ${a} coords = getOutputCoords();
  ${_}
  ${y}
  vec4 outputValue = getA(${r});
  return outputValue;
}

vec4 getBAtOutCoordsMatmul(int i) {
  ${a} coords = getOutputCoords();
  ${_}
  ${v}
  vec4 outputValue = getB(${n});
  return outputValue;
}`}function bc(a,e){let o="";for(let t=0;t<e-2;t++)o+=`rc.${a[t]}, `;return o+=`rc.${a[e-2]}, i*2`,o}function yc(a,e){let o="";for(let t=0;t<e-2;t++)o+=`rc.${a[t]}, `;return o+=`i*2, rc.${a[e-1]}`,o}var dc,hc,cr,wn=x(()=>{"use strict";z();q();N();At();Qt();fr();dc=(a,e)=>({name:"MatMul (packed)",inputNames:a?["A","B","Bias"]:["A","B"],inputTypes:a?[2,2,2]:[2,2],cacheHint:e}),hc=(a,e,o,t)=>{let r=o.length>2,n=r?"value += getBiasForMatmul();":"",s=o[0].dims,i=o[1].dims,u=it.calcShape(s,i,!0),l=!A.areEqual(o[0].dims,o[1].dims);if(!u)throw new Error("Can't use matmul on the given tensors");let f=s[s.length-1],p=Math.ceil(f/2),d=s.length,m=i.length,g=D(a.session.backend.glContext.version),y=at(u.length),v=u.length,_=It(),{activationFunction:O,applyActivation:S}=Et(t),C=r?`${vn(y,_,o[2].dims,u,!0)}`:"",F=l?`${mc(y,_,o,u)}`:"",st=l?"getAAtOutCoordsMatmul(i)":`getA(${bc(_,d)})`,_t=l?"getBAtOutCoordsMatmul(i)":`getB(${yc(_,m)})`,kr=l?"":`${y} rc =
          getOutputCoords(); int lastDim = rc.${_[v-1]}; rc.${_[v-1]} =
          rc.${_[v-2]}; rc.${_[v-2]} = lastDim;
      `,zt=`
            ${F}
            ${C}
            ${O}
            void main() {
              ${kr}

              vec4 value = vec4(0);
              for (int i = 0; i < ${p}; i++) {
                vec4 a = ${st};
                vec4 b = ${_t};

                value += (a.rrbb * b.rgrg);
                value += (a.ggaa * b.baba);
              }
              ${n}
              ${S}
              ${g.output} = value;
            }`;return{...e,output:{dims:u,type:o[0].type,textureType:2},shaderSource:zt,hasMain:!0}},cr=(a,e,o)=>{let t=dc(e.length>2,o.activationCacheKey);return{...t,get:()=>hc(a,t,e,o)}}});var is,as=x(()=>{"use strict";lr();rs();wn();is=(a,e,o)=>{let t=e[0].dims,r=e[1].dims,n=pe(t,r,o.dilations,o.pads,o.strides),s=a.run(es(a,e[0],e[1],n,o),[e[0]]),i=a.reshapePacked(e[1],[r[0],r[1]*r[2]*r[3]]),u=e.length===3?[i,s,e[2]]:[i,s],l=a.run(cr(a,u,o),u);return a.reshapePacked(l,n)}});var gc,xc,ss,In,_n=x(()=>{"use strict";N();gc=a=>({name:"Im2Col",inputNames:["X"],inputTypes:[0],cacheHint:a}),xc=(a,e,o,t,r,n)=>{let s=o.dims,i=t.dims,u=r.length,l=In(s,i,r,4),f=`
        const int XC = ${s[1]};
        const int XH = ${s[2]};
        const int XW = ${s[3]};
        const int KH = ${n.kernelShape[0]};
        const int KW = ${n.kernelShape[1]};
        const int dilationH = ${n.dilations[0]};
        const int dilationW = ${n.dilations[1]};
        const int strideH = ${n.strides[0]};
        const int strideW = ${n.strides[1]};
        const int padH = ${n.pads[0]};
        const int padW = ${n.pads[1]};
        const int KHKW = KH*KW;
        const int XCKHKW = XC * KHKW;
        const int outputChannels = 4;
        vec4 process(int indices[${u}]) {
          int b  = indices[0]; // batch size
          int oh = indices[1] * strideH - padH; //output height
          int ow = indices[2] * strideW - padW; //output width
          int p = indices[3] * outputChannels; //patch
          vec4 value = vec4(0.0);
          for(int i=0; i < outputChannels; ++i) {
            if(p < XCKHKW) {
              int patchC = p / KHKW;
              int patchH = (p - patchC*KHKW) / KW;
              int patchW = (p - patchC*KHKW) - patchH * KW;
              int xh2 = oh + patchH * dilationH;
              int xw2 = ow + patchW * dilationW;
              int x[${s.length}];
              x[0] = b;
              x[1] = patchC;
              x[2] = xh2;
              x[3] = xw2;
              if(xh2 >= 0 &&
                  xh2 < XH &&
                  xw2 >= 0 &&
                  xw2 < XW) {
                value[i] = _X(x);
              }
            }
            ++p;
          }
          return value;
        }
        `;return{...e,output:{dims:l,type:o.type,textureType:4},shaderSource:f}},ss=(a,e,o,t,r)=>{let n=gc(r.cacheKey);return{...n,get:()=>xc(a,n,e,o,t,r)}},In=(a,e,o,t=4)=>[o[0],o[2],o[3],Math.ceil(a[1]*e[2]*e[3]/t)]});var Tc,vc,us,ls=x(()=>{"use strict";z();q();N();Qt();_n();Tc=(a,e)=>({name:"ConvDotProduct",inputNames:a?["Im2Col","K","B"]:["Im2Col","K"],inputTypes:a?[0,4,0]:[0,4],cacheKey:e.activationCacheKey}),vc=(a,e,o,t,r)=>{let n=o[0].dims,s=o[1].dims,i=[s[0],Math.ceil(n[1]*s[2]*s[3]/4)],u=In(n,s,t),[l,f]=a.calculateTextureWidthAndHeight(i,4),p=A.computeStrides(u),[d,m]=a.calculateTextureWidthAndHeight(u,4),g=t.length,y=o.length<3?"0.0":"_B(b)",v=Math.ceil(n[1]*s[2]*s[3]/4),{activationFunction:_,applyActivation:O}=Et(r),S=D(a.session.backend.glContext.version),C=`
${_}
float process(int indices[${g}]) {
  int b[1];
  b[0] = indices[1];
  int im2col[4];
  im2col[0] = indices[0];
  im2col[1] = indices[2];
  im2col[2] = indices[3];
  int im2colOffset = im2col[0] * ${p[0]} + im2col[1] * ${p[1]} + im2col[2] * ${p[2]};
  int kernelOffset = indices[1] * ${i[1]};
  float value = ${y};
  for (int i = 0; i < ${v}; ++i) {
    vec2 im2colCoords = offsetToCoords(im2colOffset, ${d}, ${m});
    vec2 kernelCoords = offsetToCoords(kernelOffset, ${l}, ${f});
    value += dot(${S.texture2D}(Im2Col, im2colCoords), ${S.texture2D}(K, kernelCoords));
    ++im2colOffset;
    ++kernelOffset;
  }
  ${O}
  return value;
}`;return{...e,output:{dims:t,type:o[0].type,textureType:0},shaderSource:C}},us=(a,e,o,t)=>{let r=Tc(e.length>2,t);return{...r,get:()=>vc(a,r,e,o,t)}}});var pe,Sn,wc,Ic,_c,Sc,On,Oc,lr=x(()=>{"use strict";tt();z();ts();as();ls();Qt();_n();fr();pe=(a,e,o,t,r)=>{let n=a[0],s=a.slice(2),i=s.length,u=e[0],f=e.slice(2).map((g,y)=>g+(g-1)*(o[y]-1)),d=s.map((g,y)=>g+t[y]+t[y+i]).map((g,y)=>Math.floor((g-f[y]+r[y])/r[y]));return[n,u].concat(...d)},Sn=(a,e,o)=>(Oc(e,o),wc(a,e,o)),wc=(a,e,o)=>{let t=Sc(o,e),r=a.session.pack,n=t.kernelShape[0]===1&&t.kernelShape[1]===1;return t.group>1?[a.run(Qa(a,e,t),e)]:n&&r?[Ic(a,e,t)]:r&&e[0].dims.length===4&&e[0].dims[0]===1&&!n?[is(a,e,t)]:[_c(a,e,t)]},Ic=(a,e,o)=>{let t=e[0].dims,r=e[1].dims,n=pe(t,r,o.dilations,o.pads,o.strides),s=a.reshapeUnpacked(e[0],[t[1],t[2]*t[3]]),i=a.reshapeUnpacked(e[1],[r[0],r[1]]),u=e.length>2?[i,s,e[2]]:[i,s],l=a.run(Tn(u,o),u);return a.reshapeUnpacked(l,n)},_c=(a,e,o)=>{let t=e[0].dims,r=e[1].dims,n=pe(t,r,o.dilations,o.pads,o.strides),s=a.run(ss(a,e[0],e[1],n,o),[e[0]]),i=e.length===3?[s,e[1],e[2]]:[s,e[1]];return a.run(us(a,e,n,o),i)},Sc=(a,e)=>{let o=a.kernelShape.slice();if(a.kernelShape.length===0)for(let n=2;n<e[1].dims.length;++n)o.push(e[1].dims[n]);let t=a.pads.slice();Kt.adjustPadsBasedOnAutoPad(e[0].dims,a.strides,a.dilations,o,t,a.autoPad);let r=Object.assign({},a);return Object.assign(r,{kernelShape:o,pads:t,cacheKey:a.cacheKey}),r},On=a=>{let e=a.attributes,o=ce(e),t=e.getString("auto_pad","NOTSET"),r=e.getInts("dilations",[1,1]),n=e.getInt("group",1),s=e.getInts("kernel_shape",[]),i=e.getInts("pads",[0,0,0,0]),u=e.getInts("strides",[1,1]);return $({autoPad:t,dilations:r,group:n,kernelShape:s,pads:i,strides:u,...o})},Oc=(a,e)=>{if(!a||a.length!==2&&a.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(a[0].dims.length!==4||a[1].dims.length!==4)throw new Error("currently only support 2-dimensional conv");let o=a[0].dims[1],t=a[1].dims[1]*e.group;if(o!==t)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");if(a.length===3&&(a[2].dims.length!==1||a[1].dims[0]!==a[2].dims[0]))throw new Error("invalid bias");let r=a[0].dims.length-2;if(e.dilations.length!==r)throw new Error(`dilations should be ${r}D`);if(e.strides.length!==r)throw new Error(`strides should be ${r}D`);if(e.pads.length!==r*2)throw new Error(`pads should be ${r*2}D`);if(e.kernelShape.length!==0&&e.kernelShape.length!==a[1].dims.length-2)throw new Error("invalid kernel shape");if(a[0].type!=="float32"||a[1].type!=="float32")throw new Error("Conv input(X,W) should be float tensor");if(a.length===3&&a[2].type!=="float32")throw new Error("Conv input(bias) should be float tensor")}});var Ac,Pc,Ec,fs,Dc,Lc,$c,kc,Bc,Fc,cs,Nc,ps=x(()=>{"use strict";tt();q();N();Qt();Ac=(a,e,o,t,r,n)=>(a-1)*e+o+(t-1)*r+1-n,Pc=(a,e,o,t,r)=>{let n=Math.floor(a/2);e==="SAME_UPPER"?(o[t]=n,o[r]=a-n):e==="SAME_LOWER"&&(o[t]=a-n,o[r]=n)},Ec=(a,e,o,t,r,n,s,i)=>{let u=a.length-2,l=i.length===0;for(let f=0;f<u;++f){let p=l?a[f+2]*n[f]:i[f],d=Ac(a[f+2],n[f],r[f],e[f],o[f],p);Pc(d,t,r,f,f+u),l&&i.push(n[f]*(a[f+2]-1)+s[f]+(e[f]-1)*o[f]+1-r[f]-r[f+u])}},fs=(a,e,o)=>(Nc(e,o),Dc(a,e,o)),Dc=(a,e,o)=>{let t=Fc(o,e);return[Bc(a,e,t)]},Lc=(a,e)=>({name:"ConvTranspose",inputNames:a?["X","W","B"]:["X","W"],inputTypes:a?[0,0,0]:[0,0],cacheHint:e}),$c=(a,e,o,t)=>{let n=e.length>2?"getB(output_channel)":"0.0",s=e[0].dims,i=e[1].dims,u=i[1],l=i[0]/t.group,f=[e[0].dims[0],e[1].dims[1]*t.group,...t.outputShape],p=D(a.session.backend.glContext.version),{activationFunction:d,applyActivation:m}=Et(t),g=`
  const ivec2 strides = ivec2(${t.strides[0]}, ${t.strides[1]});
  const ivec2 pads = ivec2(${t.pads[0]}, ${t.pads[1]});
  ${d}
  void main() {
    ivec4 coords = getOutputCoords();
    int batch = coords.x;
    int output_channel = coords.y;

    ivec2 loc = coords.zw + pads;

    int group_id = output_channel / ${u};
    int wOutChannel = output_channel - group_id * ${u};

    float value = ${n};
    for (int inChannelOffset = 0; inChannelOffset < ${l}; inChannelOffset++) {
      int input_channel = group_id * ${l} + inChannelOffset;
      for (int wWOff = 0; wWOff < ${i[2]}; wWOff++) {
        for (int wHOff = 0; wHOff < ${i[3]}; wHOff++) {
          ivec2 wOff = ivec2(wWOff * ${t.dilations[0]}, wHOff * ${t.dilations[1]});
          ivec2 wLoc = loc - wOff;
          ivec2 wLocIn = wLoc / strides;
          if (
            wLocIn * strides == wLoc &&
            wLocIn.x >= 0 && wLocIn.x < ${s[2]} &&
            wLocIn.y >= 0 && wLocIn.y < ${s[3]}
          ) {
            float xVal = getX(batch, input_channel, wLocIn.y, wLocIn.x);
            float wVal = getW(input_channel, wOutChannel, wHOff, wWOff);
            value += xVal * wVal;
          }
        }
      }
    }
    ${m}
    ${p.output} = vec4(value, .0, .0, .0);
  }
`;return{...o,output:{dims:f,type:e[0].type,textureType:0},shaderSource:g,hasMain:!0}},kc=(a,e,o)=>{let t=Lc(e.length>2,o.cacheKey);return{...t,get:()=>$c(a,e,t,o)}},Bc=(a,e,o)=>a.run(kc(a,e,o),e),Fc=(a,e)=>{let o=a.kernelShape.slice();if(a.kernelShape.length===0)for(let i=2;i<e[1].dims.length;++i)o.push(e[1].dims[i]);let t=a.pads.slice(),r=a.outputShape.slice(),n=e[0].dims;Ec(n,o,a.dilations,a.autoPad,t,a.strides,a.outputPadding,r);let s=Object.assign({},a);return Object.assign(s,{kernelShape:o,pads:t,outputShape:r,cacheKey:a.cacheKey}),s},cs=a=>{let e=a.attributes,o=ce(e),t=e.getString("auto_pad","NOTSET"),r=e.getInts("dilations",[1,1]),n=e.getInt("group",1),s=e.getInts("kernel_shape",[]),i=e.getInts("output_padding",[0,0]),u=e.getInts("output_shape",[]),l=e.getInts("pads",[0,0,0,0]),f=e.getInts("strides",[1,1]);return $({autoPad:t,dilations:r,group:n,kernelShape:s,outputPadding:i,outputShape:u,pads:l,strides:f,...o})},Nc=(a,e)=>{if(!a||a.length!==2&&a.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(a[0].dims.length!==4||a[1].dims.length!==4)throw new Error("currently only support 2-dimensional conv");let o=a[0].dims[1],t=a[1].dims[0];if(o!==t)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");let r=a[1].dims[1]*e.group;if(a.length===3&&(a[2].dims.length!==1||a[2].dims[0]!==r))throw new Error("invalid bias");let n=a[0].dims.length-2;if(e.dilations.length!==n)throw new Error(`dilations should be ${n}D`);if(e.strides.length!==n)throw new Error(`strides should be ${n}D`);if(e.pads.length!==n*2)throw new Error(`pads should be ${n*2}D`);if(e.outputPadding.length!==n)throw new Error(`output_padding should be ${n}D`);if(e.kernelShape.length!==0&&e.kernelShape.length!==a[1].dims.length-2)throw new Error("invalid kernel shape");if(e.outputShape.length!==0&&e.outputShape.length!==a[0].dims.length-2)throw new Error("invalid output shape");if(a[0].type!=="float32"||a[1].type!=="float32")throw new Error("ConvTranspose input(X,W) should be float tensor");if(a.length===3&&a[2].type!=="float32")throw new Error("ConvTranspose input(bias) should be float tensor")}});var ds,te,hs,Cc,ms,Gc,Rc,Vc,pr=x(()=>{"use strict";tt();z();N();ds={name:"Transpose",inputNames:["A"],inputTypes:[0]},te=(a,e,o)=>(Vc(e),[a.run({...ds,cacheHint:o.cacheKey,get:()=>Cc(a,e[0],o.perm)},e)]),hs=a=>$({perm:a.attributes.getInts("perm",[])}),Cc=(a,e,o)=>{let t=e.dims;o=ms(t,o);let r=Gc(t,o),n=t.length,s=`
      ${Rc("perm",o,n)}
      float process(int indices[${n}]) {
        int a[${n}];
        perm(a, indices);
        return _A(a);
      }`;return{...ds,output:{dims:r,type:e.type,textureType:0},shaderSource:s}},ms=(a,e)=>(e&&e.length!==a.length&&(e=[...a.keys()].reverse()),e),Gc=(a,e)=>(e=ms(a,e),A.sortBasedOnPerm(a,e)),Rc=(a,e,o)=>{let t=[];t.push(`void ${a}(out int a[${o}], int src[${o}]) {`);for(let r=0;r<o;++r)t.push(`	a[${e[r]}]=src[${r}];`);return t.push("	}"),t.join(`
`)},Vc=a=>{if(!a||a.length!==1)throw new Error("Transpose requires 1 input.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("input should be float tensor")}});var bs,ys,zc,gs=x(()=>{"use strict";pr();bs=(a,e,o)=>{zc(e);let t=o.blocksize,r=t*t,n=o.mode==="DCR"?[0,3,4,1,5,2]:[0,1,4,2,5,3],s=o.mode==="DCR"?[e[0].dims[0],t,t,e[0].dims[1]/r,e[0].dims[2],e[0].dims[3]]:[e[0].dims[0],e[0].dims[1]/r,t,t,e[0].dims[2],e[0].dims[3]],i=a.reshapeUnpacked(e[0],s),u={perm:n,cacheKey:`${n}`},[l]=te(a,[i],u),f=[e[0].dims[0],e[0].dims[1]/r,e[0].dims[2]*t,e[0].dims[3]*t];return[a.reshapeUnpacked(l,f)]},ys=a=>{let e=a.attributes.getInt("blocksize");if(e<1)throw new Error(`blocksize must be >= 1, but got : ${e} for DepthToSpace`);let o=a.attributes.getString("mode","DCR");if(o!=="DCR"&&o!=="CRD")throw new Error(`unrecognized mode: ${o} for DepthToSpace`);return{mode:o,blocksize:e}},zc=a=>{if(a.length!==1)throw new Error(`DepthToSpace expect 1 inputs, but got ${a.length}`);if(a[0].type==="string"||a[0].dims.length!==4)throw new TypeError("DepthToSpace input should be a 4-D numeric tensor")}});var xs,Ts,Mc,vs=x(()=>{"use strict";z();xs=(a,e,o)=>{Mc(e,o);let t=A.flattenShape(e[0].dims,o);return[a.reshapeUnpacked(e[0],t)]},Ts=a=>a.attributes.getInt("axis",1),Mc=(a,e)=>{if(!a||a.length!==1)throw new Error("Flatten requires 1 input.");let o=a[0].dims.length;if(o===0)throw new Error("scalar tensor is not supported.");if(e<-o||e>o)throw new Error("Invalid axis");if(a[0].type==="string")throw new Error("string tensor is not supported.")}});var Rt,De=x(()=>{"use strict";Rt=["float32","float64","int32","int16","int8","uint16","uint32","uint8"]});var ws,Is,Uc,Wc,Hc,qc,_s=x(()=>{"use strict";tt();De();z();N();ws=(a,e,o)=>(qc(e,o.axis),[a.run(Hc(a,e,o),e)]),Is=a=>$({axis:a.attributes.getInt("axis",0)}),Uc={name:"Gather",inputNames:["A","B"],inputTypes:[0,0]},Wc=(a,e,o,t)=>{let r=o[0].dims.slice(),n=o[1].dims.slice(),s=new Array(r.length+n.length-1);t=A.normalizeAxis(t,r.length);let i=[];for(let d=0;d<s.length;d++)d<t?(s[d]=r[d],i.push(`inputIdx[${d}] = outputIdx[${d}];`)):d<t+n.length?(s[d]=n[d-t],i.push(`indexDataIdx[${d-t}] = outputIdx[${d}];`)):(s[d]=r[d-n.length+1],i.push(`inputIdx[${d-n.length+1}] = outputIdx[${d}];`));let u=s.length||1,l=r.length,f=n.length||1,p=`
      float process(int outputIdx[${u}]) {
        int inputIdx[${l}];
        int indexDataIdx[${f}];
        indexDataIdx[0] = 0;
        ${i.join(`
        `)}
        int idx = int(_B(indexDataIdx));
        inputIdx[${t}] = idx < 0 ? idx + ${r[t]} : idx;
        return _A(inputIdx);
      }`;return{...e,output:{dims:s,type:o[0].type,textureType:0},shaderSource:p}},Hc=(a,e,o)=>{let t={...Uc,cacheHint:o.cacheKey};return{...t,get:()=>Wc(a,t,e,o.axis)}},qc=(a,e)=>{if(!a||a.length!==2)throw new Error("Gather requires 2 inputs.");let o=a[0].dims.length;if(o<1)throw new Error("Invalid input shape.");if(e<-o||e>o-1)throw new Error("Invalid axis.");if(Rt.indexOf(a[0].type)===-1)throw new Error("Invaid input type.");if(a[1].type!=="int32"&&a[1].type!=="int16")throw new Error("Invaid input type.")}});var An,Ss,Os,As,jc,Kc,Xc,Ps=x(()=>{"use strict";tt();z();N();An=(a,e,o)=>(Xc(e,o),[a.run(jc(e,o),e)]),Ss=(a,e)=>{let o=a.attributes.getInt("transA",0)!==0,t=a.attributes.getInt("transB",0)!==0,r=a.attributes.getFloat("alpha",1),n=a.attributes.getFloat("beta",1);return $({transA:o,transB:t,alpha:r,beta:n,isOptionalC:e})},Os=a=>Ss(a,!1),As=a=>Ss(a,!0),jc=(a,e)=>{let o={name:"Gemm",inputNames:a.length===3?["A","B","C"]:["A","B"],inputTypes:a.length===3?[0,0,0]:[0,0],key:e.cacheKey};return{...o,get:()=>Kc(o,a,e)}},Kc=(a,e,o)=>{let t=e[0].dims.slice(),r=e[1].dims.slice(),[n,s]=er.getShapeOfGemmResult(t,o.transA,r,o.transB,e.length===3?e[2].dims:void 0),i=[n,s];if(!i)throw new Error("Can't use gemm on the given tensors");let u=t[t.length-1],l="";o.transA&&(u=t[0]),o.transA&&o.transB?l="value += _A_T(a) * _B_T(b);":o.transA&&!o.transB?l="value += _A_T(a) * _B(b);":!o.transA&&o.transB?l="value += _A(a) * _B_T(b);":!o.transA&&!o.transB&&(l="value += _A(a) * _B(b);");let f=i.length,p=e.length===3?`int c[${e[2].dims.length}];`:"",d=e.length===3?"bcastIndices_C(indices, c);":"",m=e.length===3?"value += beta * _C(c);":"",g=`
      float process(int indices[${f}]) {
          int a[${f}];
          int b[${f}];
          ${p}

          copyVec(indices, a);
          copyVec(indices, b);
          ${d}

          float value = 0.0;
          for (int k=0; k<${u}; ++k) {
              a[${f-1}] = k;
              b[${f-2}] = k;
              ${l}
          }

          value = value * alpha;
          ${m}
          return value;
      }`;return{...a,output:{dims:i,type:e[0].type,textureType:0},variables:[{name:"alpha",type:"float",data:o.alpha},{name:"beta",type:"float",data:o.beta}],shaderSource:g}},Xc=(a,e)=>{if(!a)throw new Error("Input is missing");if(e.isOptionalC&&(a.length<2||a.length>3))throw new Error("Invaid input shape.");if(!e.isOptionalC&&a.length!==3)throw new Error("Gemm requires 3 inputs");if(a.length===3&&a[2].dims.length!==1&&a[2].dims.length!==2)throw new Error("Invalid input shape of C");if(a[0].type!=="float32"&&a[0].type!=="float64"||a[1].type!=="float32"&&a[1].type!=="float64"||a.length===3&&a[2].type!=="float32"&&a[2].type!=="float64")throw new Error("Invalid input type.");if(a[0].type!==a[1].type||a.length===3&&a[0].type!==a[2].type)throw new Error("Input types are mismatched")}});var Es,Ds,Jc,Zc,Yc,Qc,tp,Ls=x(()=>{"use strict";tt();N();Es=(a,e,o)=>(tp(e),[a.run(Yc(a,e,o),e)]),Ds=a=>{let e=a.attributes.getFloat("scale"),o=a.attributes.getFloats("bias");return $({scale:e,bias:o})},Jc={name:"ImageScaler",inputNames:["X"],inputTypes:[0]},Zc=(a,e,o,t)=>{let r=o[0].dims.slice(),n=r.length,i=`
      ${Qc(t.bias.length)}
      float process(int indices[${n}]) {
        return _X(indices) * scale + getBias(bias, indices[1]);
      }`;return{...e,output:{dims:r,type:o[0].type,textureType:0},variables:[{name:"bias",type:"float",arrayLength:t.bias.length,data:t.bias},{name:"scale",type:"float",data:t.scale}],shaderSource:i}},Yc=(a,e,o)=>{let t={...Jc,cacheHint:o.cacheKey};return{...t,get:()=>Zc(a,t,e,o)}},Qc=a=>{let e=[`float getBias(float bias[${a}], int channel) {`];for(let o=0;o<a;++o)o===0?e.push(`	if (channel == ${o}) { return bias[${o}]; }`):o===a-1?e.push(`	else { return bias[${o}]; }`):e.push(`	else if (channel == ${o}) { return bias[${o}]; }`);return e.push("	}"),e.join(`
`)},tp=a=>{if(!a||a.length!==1)throw new Error("ImageScaler requires 1 input.");if(a[0].dims.length!==4)throw new Error("Invalid input shape.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.")}});var ks,Bs,$s,ep,rp,np,op,ip,ap,Fs=x(()=>{"use strict";q();N();ks=(a,e,o)=>{ap(e);let t=a.run(rp(e[0]),e);return[a.run(ip(a,e[0],o,t.dims),[e[0],t,e[1],e[2]])]},Bs=a=>a.attributes.getFloat("epsilon",1e-5),$s={name:"InstanceNormalization_MeanAndVariance",inputNames:["X"],inputTypes:[0]},ep=(a,e)=>{let o=e.dims.slice(),t=o[1],r=o[2]*o[3],n=[o[0],t],s=`
      vec4 process(int[2] indices) {
        vec4 v = vec4(0.0);
        int a[4];
        a[0] = indices[0];
        a[1] = indices[1];
        float temp = 0.0;
        for(int a2=0; a2<${o[2]}; a2++) {
          a[2] = a2;
          for(int a3=0; a3<${o[3]}; a3++) {
            a[3] = a3;
            float x = _X(a);
            temp += x;
          }
        }
        float mean = temp / float(${r});
        temp = 0.0;
        for(int a2=0; a2<${o[2]}; a2++) {
          a[2] = a2;
          for(int a3=0; a3<${o[3]}; a3++) {
            a[3] = a3;
            float x = _X(a);
            temp += (x - mean) * (x - mean);
          }
        }
        v.r = mean;
        v.g = temp / float(${r});

        return v;
      }`;return{...a,output:{dims:n,type:e.type,textureType:4},shaderSource:s}},rp=a=>({...$s,get:()=>ep($s,a)}),np={name:"InstanceNormalization_ComputeOutput",inputNames:["X","MeanAndVariance","Scale","B"],inputTypes:[0,4,0,0]},op=(a,e,o,t,r)=>{let n=D(a.session.backend.glContext.version),[s,i]=a.calculateTextureWidthAndHeight(r,4),[u,l]=[s/4,i],f=`
      vec4 get_MeanAndVariance(int[2] mv) {
        int offset = indicesToOffset_MeanAndVariance(mv);
        vec2 coords = offsetToCoords(offset, ${u}, ${l});
        return ${n.texture2D}(MeanAndVariance, coords);
      }

      float process(int[4] indices) {
        int mv[2];
        mv[0] = indices[0];
        mv[1] = indices[1];
        vec4 mean_and_variance = get_MeanAndVariance(mv);
        float mean = mean_and_variance.r;
        float variance = mean_and_variance.g;

        int sb[1];
        sb[0] = indices[1];
        float scale = _Scale(sb);
        float b = _B(sb);

        return scale * (_X(indices) - mean) / sqrt(variance + epsilon) + b;
      }`;return{...e,output:{dims:o.dims,type:o.type,textureType:0},variables:[{name:"epsilon",type:"float",data:t}],shaderSource:f}},ip=(a,e,o,t)=>{let r={...np,cacheHint:`${o}`};return{...r,get:()=>op(a,r,e,o,t)}},ap=a=>{if(!a||a.length!==3)throw new Error("InstanceNormalization requires 3 inputs.");let e=a[0],o=a[1],t=a[2];if(e.dims.length<3||o.dims.length!==1||t.dims.length!==1)throw new Error("Invalid input shape.");if(o.dims[0]!==e.dims[1]||t.dims[0]!==e.dims[1])throw new Error("Input shapes are mismatched.");if(e.type!=="float32"&&e.type!=="float64"||o.type!=="float32"&&o.type!=="float64"||t.type!=="float32"&&t.type!=="float64")throw new Error("Invalid input type.");if(a[0].dims.length!==4)throw new Error("Only support 4-D input shape.")}});function sp(a,e){let o=a[0].dims[1],t=a[0].dims.length,r=-Math.floor((e.size-1)/2),n=Math.ceil((e.size-1)/2),s=`float(${e.alpha}) / float(${e.size})`,i=`float(${e.bias})`,u=`float(${e.beta})`,l=`
    float process(int indices[${t}]) {
        int c = indices[1];
        float x = _X(indices);
        float square_sum = 0.0;

        for (int i = ${r}; i <= ${n}; i++) {
          int idx = c + i;
          if (c >= 0 && c < ${o}) {
            indices[1] = idx;
            float j = _X(indices);
            square_sum += j * j;
          }
        }
        return x / pow(${i} + ${s} * square_sum, ${u});
    }`;return{...Gs,cacheHint:e.cacheKey,output:{dims:a[0].dims,type:a[0].type,textureType:0},shaderSource:l}}function up(a,e){return{...Gs,cacheHint:e.cacheKey,get:()=>sp(a,e)}}var Ns,Cs,Gs,lp,Rs=x(()=>{"use strict";tt();N();Ns=(a,e,o)=>(lp(e),[a.run(up(e,o),e)]),Cs=a=>{let e=a.attributes.getFloat("alpha",1e-4),o=a.attributes.getFloat("beta",.75),t=a.attributes.getFloat("bias",1),r=a.attributes.getInt("size");return $({alpha:e,beta:o,bias:t,size:r})},Gs={name:"LRN",inputNames:["X"],inputTypes:[0]};lp=a=>{if(!a||a.length!==1)throw new Error("LRN requires 1 input.");if(a[0].dims.length!==4)throw new Error('currently only support LRN for input with "NCHW" format');if(a[0].type!=="float32")throw new Error("input should be float type")}});var fp,Pn,Vs,zs,Ms,cp,pp,dp,hp,mp,bp,yp,gp,Us=x(()=>{"use strict";tt();z();q();N();fp={name:"Pad",inputNames:["A"],inputTypes:[0]},Pn=(a,e,o)=>(dp(e),[a.run({...fp,cacheHint:o.cacheKey,get:()=>pp(a,e[0],o)},e)]),Vs=a=>{let e=a.attributes.getString("mode","constant"),o=a.attributes.getFloat("value",0),t=a.attributes.getInts("pads");return $({mode:e,value:o,pads:t})},zs=(a,e,o)=>{hp(e);let t=cp(a,e,o);return Pn(a,[e[0]],t)},Ms=a=>a.attributes.getString("mode","constant"),cp=(a,e,o)=>{if(!a.session.isInitializer(e[1].dataId)||e.length>=3&&!a.session.isInitializer(e[2].dataId))throw new Error("dynamic pad attributes are not allowed");let t=Array.from(e[1].integerData),r=e.length>=3?e[2].floatData[0]:0;return $({mode:o,pads:t,value:r})},pp=(a,e,o)=>{let t=A.padShape(e.dims.slice(),o.pads),r=t.length,s=`
      ${mp(a,e,o)}
      float process(int[${r}] indices) {
          return padA(indices);
      }`;return{name:"Pad",inputNames:["A"],inputTypes:[0],output:{dims:t,type:e.type,textureType:0},shaderSource:s}},dp=a=>{if(!a||a.length!==1)throw new Error("Pad requires 1 input");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.")},hp=a=>{if(!a||a.length!==2&&a.length!==3)throw new Error("Pad requires 2 or 3 inputs");if(a[1].type!=="int32")throw new Error("Invalid input type.");if(a.length>=3&&a[2].type==="string")throw new Error("Invalid input type.")},mp=(a,e,o)=>{let t=D(a.session.backend.glContext.version),[r,n]=a.calculateTextureWidthAndHeight(e.dims,0),s=A.computeStrides(e.dims);switch(o.mode){case"constant":return bp(t,e.dims,s,r,n,o.pads,o.value);case"reflect":return yp(t,e.dims,s,r,n,o.pads);case"edge":return gp(t,e.dims,s,r,n,o.pads);default:throw new Error("Invalid mode")}},bp=(a,e,o,t,r,n,s)=>{let i=e.length,u="";for(let l=i-1;l>=0;--l)u+=`
        k = m[${l}] - ${n[l]};
        if (k < 0)  return constant;
        if (k >= ${e[l]}) return constant;
        offset += k * ${o[l]};
        `;return`
      float padA(int m[${i}]) {
        const float constant = float(${s});
        int offset = 0;
        int k = 0;
        ${u}
        vec2 coords = offsetToCoords(offset, ${t}, ${r});
        float value = getColorAsFloat(${a.texture2D}(A, coords));
        return value;
      }
      `},yp=(a,e,o,t,r,n)=>{let s=e.length,i="";for(let u=s-1;u>=0;--u)i+=`
        k = m[${u}] - ${n[u]};
        if (k < 0) { k = -k; }
        {
          const int _2n_1 = ${2*(e[u]-1)};
          k = int( mod( float(k), float(_2n_1) ) ) ;
          if(k >= ${e[u]}) { k = _2n_1 - k; }
        }
        offset += k * ${o[u]};
        `;return`
      float padA(int m[${s}]) {
        int offset = 0;
        int k = 0;
        ${i}
        vec2 coords = offsetToCoords(offset, ${t}, ${r});
        float value = getColorAsFloat(${a.texture2D}(A, coords));
        return value;
      }
      `},gp=(a,e,o,t,r,n)=>{let s=e.length,i="";for(let u=s-1;u>=0;--u)i+=`
        k = m[${u}] - ${n[u]};
        if (k < 0)  k = 0;
        if (k >= ${e[u]}) k = ${e[u]-1};
        offset += k * ${o[u]};
      `;return`
      float padA(int m[${s}]) {
        int offset = 0;
        int k = 0;
        ${i}
        vec2 coords = offsetToCoords(offset, ${t}, ${r});
        float value = getColorAsFloat(${a.texture2D}(A, coords));
        return value;
      }
      `}});var Hs,qs,js,Ks,Xs,Js,Zs,Ys,Qs,xp,Ws,tu,hr,eu,dr,Tp,ru=x(()=>{"use strict";tt();z();N();Hs=(a,e,o)=>{hr(e);let t={name:"AveragePool",inputNames:["X"],inputTypes:[0],cacheHint:o.cacheKey};return[a.run({...t,get:()=>js(e,t,!1,o)},e)]},qs=a=>{let e=a.attributes.getString("auto_pad","NOTSET"),o=a.attributes.getInt("ceil_mode",0),t=a.attributes.getInt("count_include_pad",0)!==0,r=a.attributes.getInts("kernel_shape"),n=a.attributes.getInts("strides",[]),s=a.attributes.getInts("pads",[]);if(o!==0)throw new Error("using ceil() in shape computation is not yet supported for AveragePool");return $({autoPad:e,ceilMode:o,countIncludePad:t,kernelShape:r,strides:n,pads:s})},js=(a,e,o,t)=>{let[r,n]=Qs(a,t,o),s=A.size(r.kernelShape),i="value += _X(x);",u="";r.countIncludePad?u+=`value /= float(${s});`:u+=`value /= float(${s} - pad);`;let f=`
        ${eu(a[0].dims,r,i,u,"0.0")}
      `;return{...e,output:{dims:n,type:a[0].type,textureType:0},shaderSource:f}},Ks=(a,e,o)=>{hr(e);let t={name:"GlobalAveragePool",inputNames:["X"],inputTypes:[0],cacheHint:`${o.countIncludePad}`};return[a.run({...t,get:()=>js(e,t,!0,o)},e)]},Xs=a=>{let e=a.attributes.getInt("count_include_pad",0)!==0;return $({autoPad:"",ceilMode:0,countIncludePad:e,kernelShape:[],strides:[],pads:[]})},Js=(a,e,o)=>{hr(e);let t={name:"MaxPool",inputNames:["X"],inputTypes:[0],cacheHint:o.cacheKey};return[a.run({...t,get:()=>Ys(e,t,!1,o)},e)]},Zs=a=>{let e=a.attributes.getString("auto_pad","NOTSET"),o=a.attributes.getInt("ceil_mode",0),t=a.attributes.getInts("kernel_shape"),r=a.attributes.getInts("strides",[]),n=a.attributes.getInts("pads",[]),s=a.attributes.getInt("storage_order",0),i=a.attributes.getInts("dilations",[]);if(s!==0)throw new Error("column major storage order is not yet supported for MaxPool");if(o!==0)throw new Error("using ceil() in shape computation is not yet supported for MaxPool");return $({autoPad:e,ceilMode:o,countIncludePad:!1,kernelShape:t,strides:r,pads:n,storageOrder:s,dilations:i})},Ys=(a,e,o,t)=>{let[r,n]=Qs(a,t,o),s=`
      value = max(_X(x), value);
    `,i="",l=`
      ${eu(a[0].dims,r,s,i,"-1e5")}
    `;return{...e,output:{dims:n,type:a[0].type,textureType:0},shaderSource:l}},Qs=(a,e,o)=>{let t=a[0].dims.slice(),r=Object.hasOwnProperty.call(e,"dilations"),n=e.kernelShape.slice(),s=e.strides.slice(),i=r?e.dilations.slice():[],u=e.pads.slice();Kt.adjustPoolAttributes(o,t,n,s,i,u);let l=Kt.computePoolOutputShape(o,t,s,i,n,u,e.autoPad),f=Object.assign({},e);return r?Object.assign(f,{kernelShape:n,strides:s,pads:u,dilations:i,cacheKey:e.cacheKey}):Object.assign(f,{kernelShape:n,strides:s,pads:u,cacheKey:e.cacheKey}),[f,l]},xp={autoPad:"",ceilMode:0,countIncludePad:!1,kernelShape:[],strides:[],pads:[],storageOrder:0,dilations:[],cacheKey:""},Ws={name:"GlobalMaxPool",inputNames:["X"],inputTypes:[0]},tu=(a,e)=>(hr(e),[a.run({...Ws,get:()=>Ys(e,Ws,!0,xp)},e)]),hr=a=>{if(!a||a.length!==1)throw new Error("Pool ops requires 1 input.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.")},eu=(a,e,o,t,r)=>{let n=a.length;if(e.kernelShape.length<=2){let s=e.kernelShape[e.kernelShape.length-1],i=e.strides[e.strides.length-1],u=e.pads[e.pads.length/2-1],l=e.pads[e.pads.length-1],f=a[n-1],p="",d="",m="";if(u+l!==0?p=`
          for (int i = 0; i < ${s}; i++) {
            x[${n} - 1] = indices[${n} - 1] * ${i} - ${u} + i;
            if (x[${n} - 1] < 0 || x[${n} - 1] >= ${f}) {
              pad++;
              continue;
            }
            ${o}
          }`:p=`
          for (int i = 0; i < ${s}; i++) {
            x[${n} - 1] = indices[${n} - 1] * ${i} - ${u} + i;
            ${o}
          }`,e.kernelShape.length===2){let y=e.kernelShape[e.kernelShape.length-2],v=e.strides[e.strides.length-2],_=e.pads[e.pads.length/2-2],O=e.pads[e.pads.length-2],S=a[n-2];_+O!==0?d=`
            for (int j = 0; j < ${y}; j++) {
              x[${n} - 2] = indices[${n} - 2] * ${v} - ${_} + j;
              if (x[${n} - 2] < 0 || x[${n} - 2] >= ${S}) {
                pad+= ${s};
                continue;
              }
          `:d=`
            for (int j = 0; j < ${y}; j++) {
              x[${n} - 2] = indices[${n} - 2] * ${v} - ${_} + j;
            `,m=`
          }
        `}return`
        float process(int indices[${n}]) {
          int x[${n}];
          copyVec(indices, x);

          float value = ${r};
          int pad = 0;
          ${d}
          ${p}
          ${m}
          ${t}
          return value;
        }
      `}else{let s=A.size(e.kernelShape),i=A.computeStrides(e.kernelShape),u=i.length,l=e.pads.length,f=Tp(u),p=dr(a,"inputDims"),d=dr(e.pads,"pads"),m=dr(i,"kernelStrides"),g=dr(e.strides,"strides"),y=e.pads.reduce((O,S)=>O+S),v="";return y?v=`
            if (x[j] >= inputDims[j] || x[j] < 0) {
              pad++;
              isPad = true;
              break;
            }
          }
          if (!isPad) {
            ${o}
          }`:v=`
          }
          ${o}
        `,`
        ${f}
        float process(int indices[${n}]) {
          int x[${n}];
          copyVec(indices, x);
          int offset[${u}];
          int pads[${l}];
          int inputDims[${n}];
          int kernelStrides[${u}];
          int strides[${u}];
          ${d}
          ${p}
          ${g}
          ${m}

          float value = ${r};
          int pad = 0;
          bool isPad = false;
          for (int i = 0; i < ${s}; i++) {
            offsetToIndices(i, kernelStrides, offset);
            isPad = false;
            for (int j = ${n} - ${u}; j < ${n}; j++) {
              x[j] = indices[j] * strides[j - ${n} + ${u}]
                + offset[j - ${n} + ${u}] - pads[j - 2];
              ${v}
          }
          ${t}

          return value;
        }
      `}},dr=(a,e)=>{let o="";for(let t=0;t<a.length;t++)o+=`
      ${e}[${t}] = ${a[t]};
    `;return o},Tp=a=>`
  void offsetToIndices(int offset, int[${a}] strides, out int[${a}] indices) {
    if (${a} == 0) {
      return;
    }
    for (int i = 0; i < ${a} - 1; ++i) {
      indices[i] = offset / strides[i];
      offset -= indices[i] * strides[i];
    }
    indices[${a} - 1] = offset;
  }`});var ee,Vt,vp,wp,nu,ou,iu,au,su,uu,lu,fu=x(()=>{"use strict";tt();De();z();N();ee=(a,e,o,t,r)=>{wp(e);let n={name:t,inputNames:["A"],inputTypes:[0]};return[a.run({...n,cacheHint:o.cacheKey,get:()=>vp(a,e,o,t,r,n)},e)]},Vt=a=>{let e=a.attributes.getInts("axes",[]),o=a.attributes.getInt("keepdims",1)===1;return $({axes:e,keepDims:o})},vp=(a,e,o,t,r,n)=>{let s=[],i=e[0].dims.length||1,u=[],l=A.normalizeAxes(o.axes,e[0].dims.length),f=r(e,l),p=f[1];for(let g=0;g<e[0].dims.length;g++)l.indexOf(g)>=0||l.length===0?(o.keepDims&&s.push(1),p=`
          for(int j${g} = 0; j${g} < ${e[0].dims[g]}; j${g}++) {
            inputIdx[${g}] = j${g};
            ${p}
          }`):(u.push(`inputIdx[${g}] = outputIdx[${s.length}];`),s.push(e[0].dims[g]));let m=`
      float process(int outputIdx[${s.length||1}]) {
        float value;                 // final result
        int inputIdx[${i}];      // addressing input data
        ${u.join(`
`)}
        ${f[0]}       // init ops for reduce max/min
        ${p}
        ${f[2]}       // final computation for reduce mean
        return value;
      }`;return{...n,output:{dims:s,type:e[0].type,textureType:0},shaderSource:m}},wp=a=>{if(!a||a.length!==1)throw new Error("Reduce op requires 1 input.");if(Rt.indexOf(a[0].type)===-1)throw new Error("Invalid input type.")},nu=(a,e,o)=>ee(a,e,o,"ReduceSum",()=>["value = 0.0;","value += _A(inputIdx);",""]),ou=(a,e,o)=>ee(a,e,o,"ReduceMean",(r,n)=>{let s=1;for(let i=0;i<r[0].dims.length;i++)(n.indexOf(i)>=0||n.length===0)&&(s*=r[0].dims[i]);return["value = 0.0;","value += _A(inputIdx);",`value /= ${s}.;`]}),iu=(a,e,o)=>ee(a,e,o,"ReduceMax",(r,n)=>{let s=[];for(let i=0;i<r[0].dims.length;i++)(n.indexOf(i)>=0||n.length===0)&&s.push(`inputIdx[${i}] = 0;`);return[`${s.join(`
`)}
value = _A(inputIdx);`,"value = max(value, _A(inputIdx));",""]}),au=(a,e,o)=>ee(a,e,o,"ReduceMin",(r,n)=>{let s=[];for(let i=0;i<r[0].dims.length;i++)(n.indexOf(i)>=0||n.length===0)&&s.push(`inputIdx[${i}] = 0;`);return[`${s.join(`
`)}
value = _A(inputIdx);`,"value = min(value, _A(inputIdx));",""]}),su=(a,e,o)=>ee(a,e,o,"ReduceProd",()=>["value = 1.0;","value *= _A(inputIdx);",""]),uu=(a,e,o)=>ee(a,e,o,"ReduceLogSum",()=>["value = 0.0;","value += _A(inputIdx);","value = log(value);"]),lu=(a,e,o)=>ee(a,e,o,"ReduceLogSumSquare",()=>["float t; value = 0.0;","t = _A(inputIdx); value += t * t;",""])});var cu,pu=x(()=>{"use strict";z();cu=(a,e)=>{let o=A.calculateReshapedDims(e[0].dims,e[1].integerData);return a.session.pack?[a.reshapePacked(e[0],o)]:[a.reshapeUnpacked(e[0],o)]}});var du,En,hu,mu,Le,Ip,Dn,mr,Ln=x(()=>{"use strict";tt();q();N();du={name:"Upsample",inputNames:["X"],inputTypes:[0]},En=(a,e,o)=>(Dn(e,o),[a.run({...du,cacheHint:o.cacheKey,get:()=>Ip(a,e,o)},e)]),hu=a=>Le(a,7),mu=a=>Le(a,9),Le=(a,e)=>{let o=e>=10,t=a.attributes.getString("mode","nearest");if(t!=="nearest"&&t!=="linear"&&(e<11||t!=="cubic"))throw new Error(`unrecognized mode: ${t}`);let r=[];e<9&&(r=a.attributes.getFloats("scales"),mr(r,t,o));let n=a.attributes.getFloat("extrapolation_value",0),s=e>10?a.attributes.getString("coordinate_transformation_mode","half_pixel"):"asymmetric";if(["asymmetric","pytorch_half_pixel","tf_half_pixel_for_nn","align_corners","tf_crop_and_resize","half_pixel"].indexOf(s)===-1)throw new Error(`coordinate_transform_mode '${s}' is not supported`);let i=s==="tf_crop_and_resize",u=i,l=t==="nearest"&&e>=11?a.attributes.getString("nearest_mode","round_prefer_floor"):"";if(["round_prefer_floor","round_prefer_ceil","floor","ceil",""].indexOf(l)===-1)throw new Error(`nearest_mode '${l}' is not supported`);let f=a.attributes.getFloat("cubic_coeff_a",-.75),p=a.attributes.getInt("exclude_outside",0)!==0;if(p&&t!=="cubic")throw new Error("exclude_outside can be set to 1 only when mode is CUBIC.");let d=e<11?!0:t==="nearest"&&s==="asymmetric"&&l==="floor",m=0,g=0,y=0;return e>10?a.inputs.length>2?(m=1,g=2,y=3):(g=1,y=2):e===9&&(g=1),$({opset:e,isResize:o,mode:t,scales:r,extrapolationValue:n,coordinateTransformMode:s,useExtrapolation:u,needRoiInput:i,nearestMode:l,cubicCoefficientA:f,excludeOutside:p,useNearest2xOptimization:d,roiInputIdx:m,scalesInputIdx:g,sizesInputIdx:y})},Ip=(a,e,o)=>{let t=D(a.session.backend.glContext.version),[r,n]=a.calculateTextureWidthAndHeight(e[0].dims,0),s=e[0].dims.map((y,v)=>Math.floor(y*o.scales[v])),[i,u]=a.calculateTextureWidthAndHeight(s,0),l=s.length,f=new Array(l),p=new Array(l),d=`
      int output_pitches[${l}];
      int input_pitches[${l}];
      `;for(let y=l-1;y>=0;y--)f[y]=y===l-1?1:f[y+1]*s[y+1],p[y]=y===l-1?1:p[y+1]*e[0].dims[y+1],d+=`
        output_pitches[${y}] = ${f[y]};
        input_pitches[${y}] = ${p[y]};
        `;let m=`
      float getInputFloat(int index) {
        vec2 coords = offsetToCoords(index, ${r}, ${n});
        float value = getColorAsFloat(${t.texture2D}(X, coords));
        return value;
      }
      `,g=o.mode==="nearest"?`
    ${m}
    float process(int indices[${l}]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${i}, ${u});

      ${d}

      int d, m;
      for (int dim = 0; dim < ${l}; ++dim) {
        d = output_index / output_pitches[dim];
        m = output_index - d * output_pitches[dim];
        output_index = m;

        if (scales[dim] != 1 && d > 0) {
          int d2 = d / scales[dim];
          m = d - d2 * scales[dim];
          d = d2;
        }
        input_index += input_pitches[dim] * d;
      }

      return getInputFloat(input_index);
    }`:l===4?`
    ${m}
    float process(int indices[4]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${i}, ${u});

      ${d}

      int m;
      int index_of_dim0, index_of_dim1, index_of_dim2, index_of_dim3;
      index_of_dim0 = output_index / output_pitches[0];
      m = output_index - index_of_dim0 * output_pitches[0];
      index_of_dim1 = m / output_pitches[1];
      m = m - index_of_dim1 * output_pitches[1];
      index_of_dim2 = m / output_pitches[2];
      m = m - index_of_dim2 * output_pitches[2];
      index_of_dim3 = m;

      int index_of_input_dim2, index_of_input_dim3, x_offset, y_offset;
      index_of_input_dim2 = index_of_dim2 / scales[2];
      y_offset = index_of_dim2 - index_of_input_dim2 * scales[2];
      index_of_input_dim3 = index_of_dim3 / scales[3];
      x_offset = index_of_dim3 - index_of_input_dim3 * scales[3];

      input_index = index_of_dim0 * input_pitches[0] +
            index_of_dim1 * input_pitches[1] +
            index_of_input_dim2 * input_pitches[2] +
            index_of_input_dim3;

      float x00 = getInputFloat(input_index);
      float x10, x01, x11;

      bool end_of_dim2 = false;
      if (index_of_input_dim2 == (${e[0].dims[2]} - 1)) {
        // It's the end in dimension 2
        x01 = x00;
        end_of_dim2 = true;
      } else {
        x01 = getInputFloat(input_index + input_pitches[2]);
      }

      if (index_of_input_dim3 == (input_pitches[2] - 1)) {
        // It's the end in dimension 3
        x10 = x00;
        x11 = x01;
      }
      else {
        x10 = getInputFloat(input_index + 1);
        x11 = end_of_dim2 ? x10 : getInputFloat(input_index + input_pitches[2] + 1);
      }

      float y0 = x00 + float(y_offset) * (x01 - x00) / float(scales[2]);
      float y1 = x10 + float(y_offset) * (x11 - x10) / float(scales[2]);
      return y0 + float(x_offset) * (y1 - y0) / float(scales[3]);
    }`:`
    ${m}
    float process(int indices[2]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${i}, ${u});

      ${d}

      int m;
      int index_of_dim0, index_of_dim1;
      index_of_dim0 = output_index / output_pitches[0];
      m = output_index - index_of_dim0 * output_pitches[0];
      index_of_dim1 = m;

      int index_of_input_dim0, index_of_input_dim1, x_offset, y_offset;
      index_of_input_dim0 = index_of_dim0 / scales[0];
      y_offset = index_of_dim0 - index_of_input_dim0 * scales[0];
      index_of_input_dim1 = index_of_dim1 / scales[1];
      x_offset = index_of_dim1 - index_of_input_dim1 * scales[1];

      input_index = index_of_input_dim0 * input_pitches[0] + index_of_input_dim1;

      float x00 = getInputFloat(input_index);
      float x10, x01, x11;

      bool end_of_dim0 = false;
      if (index_of_input_dim0 == (${e[0].dims[0]} - 1)) {
        // It's the end in dimension 0
        x01 = x00;
        end_of_dim0 = true;
      } else {
        x01 = getInputFloat(input_index + input_pitches[0]);
      }

      if (index_of_input_dim1 == (input_pitches[0] - 1)) {
        // It's the end in dimension 1
        x10 = x00;
        x11 = x01;
      }
      else {
        x10 = getInputFloat(input_index + 1);
        x11 = end_of_dim0 ? x10 : getInputFloat(input_index + input_pitches[0] + 1);
      }

      float y0 = x00 + float(y_offset) * (x01 - x00) / float(scales[0]);
      float y1 = x10 + float(y_offset) * (x11 - x10) / float(scales[0]);
      return y0 + float(x_offset) * (y1 - y0) / float(scales[1]);
    }`;return{...du,output:{dims:s,type:e[0].type,textureType:0},shaderSource:g,variables:[{name:"scales",type:"int",arrayLength:o.scales.length,data:o.scales.map(y=>Math.ceil(y))}]}},Dn=(a,e)=>{if(!a||e.opset<9&&a.length!==1||e.opset>=9&&e.opset<11&&a.length!==2||e.opset>=11&&a.length<2)throw new Error("invalid inputs.");if(e.scales.length>0&&a[0].dims.length!==e.scales.length)throw new Error("Invalid input shape.");if(a[0].type==="string")throw new Error("Invalid input tensor types.")},mr=(a,e,o)=>{if(o){for(let t of a)if(t<=0)throw new Error("Scale value should be greater than 0.")}else for(let t of a)if(t<1)throw new Error("Scale value should be greater than or equal to 1.");if((e==="linear"||e==="cubic")&&a.length!==2&&(a.length!==4||a[0]!==1||a[1]!==1))throw new Error(`'Linear' mode and 'Cubic' mode only support 2-D inputs ('Bilinear', 'Bicubic')         or 4-D inputs with the corresponding outermost 2 scale values being 1         in the ${o?"Resize":"Upsample"} opeartor.`)}});var $n,kn,bu,yu,_p,Sp,Op,Ap,gu=x(()=>{"use strict";q();N();At();Yt();Ln();$n={name:"Resize",inputNames:["A"],inputTypes:[2]},kn=(a,e,o)=>(Dn(e,o),[a.run({...$n,cacheHint:o.cacheKey,get:()=>_p(a,e,o)},e)]),bu=a=>Le(a,10),yu=a=>Le(a,11),_p=(a,e,o)=>{let t=D(a.session.backend.glContext.version),[r,n]=Sp(e,o);if(r.every(S=>S===1)&&o.coordinateTransformMode!=="tf_crop_and_resize")return{...$n,output:{dims:n,type:e[0].type,textureType:2},hasMain:!0,shaderSource:`void main() {
                    vec4 v = ${t.texture2D}(X, TexCoords);
                    ${t.output} = v;
                }`};let i=n.length;if(i<2)throw new Error(`output dimension should be at least 2, but got ${i}`);let u=n[i-2],l=n[i-1],f=e[0].dims;if(i!==f.length)throw new Error(`output dimension should match input ${f.length}, but got ${i}`);let p=f[i-2],d=f[i-1],m=r[i-2],g=r[i-1],y="";if(o.mode!=="linear")throw new Error(`resize (packed) does not support mode: '${o.mode}'`);switch(o.coordinateTransformMode){case"asymmetric":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        return vec4(coords) / scaleWHWH;
                    }
                `;break;case"half_pixel":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        return (vec4(coords) + 0.5) / scaleWHWH - 0.5;
                    }
                `;break;case"pytorch_half_pixel":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        vec4 fcoords = vec4(coords);
                        return vec4(
                            ${l}.0 > 1.0 ? (fcoords.x + 0.5) / scaleWHWH.x - 0.5 : 0.0,
                            ${u}.0 > 1.0 ? (fcoords.y + 0.5) / scaleWHWH.y - 0.5 : 0.0,
                            ${l}.0 > 1.0 ? (fcoords.z + 0.5) / scaleWHWH.z - 0.5 : 0.0,
                            ${u}.0 > 1.0 ? (fcoords.w + 0.5) / scaleWHWH.w - 0.5 : 0.0
                          );
                    }
                `;break;case"align_corners":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        vec4 resized = vec4(${l}.0 - 1.0, ${u}.0 - 1.0, ${l}.0 - 1.0,
                            ${u}.0 - 1.0);
                        vec4 original = vec4(${d}.0 - 1.0, ${p}.0 - 1.0, ${d}.0 - 1.0,
                            ${p}.0 - 1.0);
                        vec4 new_scale = original / resized;
                        return vec4(coords) * new_scale;
                    }
                `;break;default:throw new Error(`resize (packed) does not support coordinateTransformMode:                                 '${o.coordinateTransformMode}'`)}let v=at(i),_=Pt(),O=`
            const vec2 inputWH = vec2(${p}.0, ${d}.0);
            const vec4 scaleWHWH = vec4(float(${m}), float(${g}), float(${m}), float(${g}));
            ${_}
            ${y}
            float getAValue(int x10, int r, int c, int d) {
                return getChannel(getA(x10, r, c, d), vec2(c, d));
            }
            void main() {
                ${v} rc = getOutputCoords();

                int batch = rc[0];
                int depth = rc[1];

                // retrieve the 4 coordinates that is used in the 4 packed output values.
                ivec4 coords = ivec4(rc.wz, rc.w + 1, rc.z + 1);

                // calculate the source index in fraction
                vec4 sourceFrac = getSourceFracIndex(coords);

                // get the lower and upper bound of the 4 values that will be packed into one texel.
                ivec4 x00 = ivec4(max(sourceFrac.xy, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.xy)));
                ivec4 x01 = ivec4(max(sourceFrac.xw, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.xw)));
                ivec4 x10 = ivec4(max(sourceFrac.zy, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.zy)));
                ivec4 x11 = ivec4(max(sourceFrac.zw, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.zw)));

                bool hasNextRow = rc.w < ${u-1};
                bool hasNextCol = rc.z < ${l-1};

                // pack x00, x01, x10, x11's top-left corner into one vec4 structure
                vec4 topLeft = vec4(
                    getAValue(batch, depth, x00.x, x00.y),
                    hasNextCol ? getAValue(batch, depth, x01.x, x01.y) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.x, x10.y) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.x, x11.y) : 0.0);

                // pack x00, x01, x10, x11's top-right corner into one vec4 structure
                vec4 topRight = vec4(
                    getAValue(batch, depth, x00.x, x00.w),
                    hasNextCol ? getAValue(batch, depth, x01.x, x01.w) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.x, x10.w) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.x, x11.w) : 0.0);

                // pack x00, x01, x10, x11's bottom-left corner into one vec4 structure
                vec4 bottomLeft = vec4(
                    getAValue(batch, depth, x00.z, x00.y),
                    hasNextCol ? getAValue(batch, depth, x01.z, x01.y) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.z, x10.y) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.z, x11.y) : 0.0);

                // pack x00, x01, x10, x11's bottom-right corner into one vec4 structure
                vec4 bottomRight = vec4(
                    getAValue(batch, depth, x00.z, x00.w),
                    hasNextCol ? getAValue(batch, depth, x01.z, x01.w) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.z, x10.w) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.z, x11.w) : 0.0);

                // calculate the interpolation fraction on u and v direction
                vec4 frac = vec4(sourceFrac) - floor(sourceFrac);
                vec4 clampFrac = clamp(frac, vec4(0.0), vec4(1.0));

                vec4 top = mix(topLeft, topRight, clampFrac.ywyw);
                vec4 bottom = mix(bottomLeft, bottomRight, clampFrac.ywyw);
                vec4 newValue = mix(top, bottom, clampFrac.xxzz);

                ${t.output} = vec4(newValue);
            }
        `;return{...$n,output:{dims:n,type:e[0].type,textureType:2},hasMain:!0,shaderSource:O}},Sp=(a,e)=>{let t=a[0].dims,r=e.scales,n;if(r.length===0){let i=a[e.scalesInputIdx];if(i&&i.size!==0){if(a[e.sizesInputIdx])throw new Error("Only one of scales or sizes must be provided as input.");r=Op(i,e.mode,e.isResize)}else{let u=a[e.sizesInputIdx];if(!u||u.size===0)throw new Error("Either scales or sizes MUST be provided as input.");n=Array.from(u.integerData),r=Ap(n,t,e.mode,e.isResize)}}else if(a[e.sizesInputIdx])throw new Error("Only one of scales or sizes must be provided as input.");let s=n||t.map((i,u)=>Math.floor(i*r[u]));return[r,s]},Op=(a,e,o)=>{let t=Array.from(a.floatData);return mr(t,e,o),t},Ap=(a,e,o,t)=>{let r=e.length,n=new Array(r);for(let s=0,i=r;s<i;s++)if(e[s]===0){if(a[s]!==0)throw new Error("Input dim is zero but required output dim is non-zero.");n[s]=1}else n[s]=a[s]/e[s];return mr(n,o,t),n}});var xu,Pp,Tu=x(()=>{"use strict";Zt();xu=(a,e)=>(Pp(e),[new Y([e[0].dims.length],"int32",void 0,void 0,new Int32Array(e[0].dims))]),Pp=a=>{if(!a||a.length!==1)throw new Error("Shape requires 1 input.")}});var Bn,vu,wu,Iu,Ep,_u,Dp,Lp,Su=x(()=>{"use strict";tt();De();z();N();Bn={name:"Slice",inputNames:["A"],inputTypes:[0]},vu=(a,e,o)=>(Ep(e),[a.run({...Bn,cacheHint:o.cacheKey,get:()=>Iu(a,e[0],o)},e)]),wu=a=>{let e=a.attributes.getInts("starts"),o=a.attributes.getInts("ends"),t=a.attributes.getInts("axes",[]);return $({starts:e,ends:o,axes:t})},Iu=(a,e,o)=>{let t=o.axes.length===0?e.dims.slice(0).map((p,d)=>d):o.axes,r=A.normalizeAxes(t,e.dims.length),n=o.starts.map((p,d)=>p>e.dims[r[d]]-1?e.dims[r[d]]:A.normalizeAxis(p,e.dims[r[d]])),s=o.ends.map((p,d)=>p>e.dims[r[d]]-1?e.dims[r[d]]:A.normalizeAxis(p,e.dims[r[d]])),i=e.dims.slice(),u=[];for(let p=0;p<r.length;p++)i[r[p]]=s[p]-n[p],n[p]>0&&u.push(`outputIdx[${r[p]}] += ${n[p]};`);let f=`
      float process(int outputIdx[${i.length}]) {
        ${u.join(`
      `)}
        return _A(outputIdx);
      }`;return{...Bn,output:{dims:i,type:e.type,textureType:0},shaderSource:f}},Ep=a=>{if(!a||a.length!==1)throw new Error("Slice requires 1 input.");if(Rt.indexOf(a[0].type)===-1)throw new Error("Invalid input type.")},_u=(a,e)=>{Lp(e);let o=Dp(a,e);return[a.run({...Bn,cacheHint:o.cacheKey,get:()=>Iu(a,e[0],o)},[e[0]])]},Dp=(a,e)=>{if(!a.session.isInitializer(e[1].dataId)||!a.session.isInitializer(e[2].dataId)||e.length>=4&&!a.session.isInitializer(e[3].dataId)||e.length>=5&&!a.session.isInitializer(e[4].dataId))throw new Error("dynamic slice attributes are not allowed");if(e.length>=5&&e[4].integerData.some(s=>s!==1))throw new Error("currently non-1 steps is not supported for Slice");let o=Array.from(e[1].integerData),t=Array.from(e[2].integerData),r=e.length>=4?Array.from(e[3].integerData):[],n=`${r};${o};${t}`;return{starts:o,ends:t,axes:r,cacheKey:n}},Lp=a=>{if(!a||a.length<3||a.length>5)throw new Error("Invalid input number.");if(a[1].type!=="int32"||a[1].dims.length!==1)throw new Error("Invalid input type.");if(a[2].type!=="int32"||a[2].dims.length!==1)throw new Error("Invalid input type.");if(a.length>=4&&(a[3].type!=="int32"||a[3].dims.length!==1))throw new Error("Invalid input type.");if(a.length>=5&&(a[4].type!=="int32"||a[4].dims.length!==1))throw new Error("Invalid input type.")}});var Ou,Au,Pu,Eu,Du,Lu,$u,ku,$p,kp,Bp,Bu,Fu=x(()=>{"use strict";tt();z();q();N();pr();Ou={name:"SoftmaxComputeMax",inputNames:["A"],inputTypes:[0]},Au={name:"SoftmaxComputeScale",inputNames:["A","Max"],inputTypes:[0,0]},Pu={name:"SoftMax",inputNames:["A","Max","Norm"],inputTypes:[0,0,0]},Eu=(a,e,o)=>{Bu(e);let t=e[0].dims.slice(),r=A.normalizeAxis(o.axis,t.length),n=A.sizeToDimension(t,r),s=A.sizeFromDimension(t,r);return ku(a,e,o,n,s)},Du=a=>$({axis:a.attributes.getInt("axis",1)}),Lu=a=>$({axis:a.attributes.getInt("axis",-1)}),$u=(a,e,o)=>{Bu(e);let t=e[0].dims.slice(),r=A.normalizeAxis(o.axis,t.length),n=t.length,s=r!==n-1,i=[],u=[],l=[],f;s&&(u=Array.from({length:n}).map((g,y)=>y),u[r]=n-1,u[n-1]=r,u.map(g=>i.push(t[g])),f=$({perm:u}),l=te(a,e,f));let p=s?A.sizeToDimension(i,n-1):A.sizeToDimension(t,n-1),d=s?A.sizeFromDimension(i,n-1):A.sizeFromDimension(t,n-1),m=ku(a,s?l:e,o,p,d);return s?te(a,m,f):m},ku=(a,e,o,t,r)=>{let n=$p(a,e[0],t,r,[t]),s=a.run({...Ou,cacheHint:o.cacheKey,get:()=>n},e),i=kp(a,e[0],t,r,n.output.dims,[t]),u=a.run({...Au,cacheHint:o.cacheKey,get:()=>i},[e[0],s]),l=Bp(a,e[0],t,r,n.output.dims,i.output.dims);return[a.run({...Pu,cacheHint:o.cacheKey,get:()=>l},[e[0],s,u])]},$p=(a,e,o,t,r)=>{let[n,s]=a.calculateTextureWidthAndHeight(e.dims,0),i=r.length;if(o<1||t<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(r.length!==1)throw new Error("Dimensionality of the output should be 1");if(r[0]!==o)throw new Error("Shape of the output should be equal to logical row count");let u=D(a.session.backend.glContext.version),l=`
      float process(int[${i}] indices) {
        int logical_row_start_offset = indices[0] * ${t};

        float max = getColorAsFloat(${u.texture2D}(A, offsetToCoords(logical_row_start_offset, ${n},
        ${s} )));
        for(int i=1; i<${t}; ++i)
        {
          float current = getColorAsFloat(${u.texture2D}(A, offsetToCoords(logical_row_start_offset + i,
            ${n}, ${s})));
          if(current > max)
          max = current;
        }

        return max;
      }`;return{...Ou,output:{dims:r,type:e.type,textureType:0},shaderSource:l}},kp=(a,e,o,t,r,n)=>{let[s,i]=a.calculateTextureWidthAndHeight(e.dims,0),u=n.length;if(o<1||t<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(n.length!==1)throw new Error("Dimensionality of the output should be 1");if(n[0]!==o)throw new Error("Shape of the output should be equal to logical row count");if(r.length!==1)throw new Error("Dimensionality of the intermediate results should be 1");if(r[0]!==o)throw new Error("Shape of the intermediate results should be equal to logical row count");let l=D(a.session.backend.glContext.version),f=`
      float process(int[${u}] indices) {
        int logical_row_start_offset = indices[0] * ${t};

        float norm_factor = 0.0;
        float max = _Max(indices);
        for(int i=0; i<${t}; ++i)
        {
          norm_factor += exp(getColorAsFloat(${l.texture2D}(A, offsetToCoords(logical_row_start_offset + i,
            ${s}, ${i}))) - max);
        }

        return norm_factor;
      }`;return{...Au,output:{dims:n,type:e.type,textureType:0},shaderSource:f}},Bp=(a,e,o,t,r,n)=>{let[s,i]=a.calculateTextureWidthAndHeight(e.dims,0),u=e.dims.length;if(o<1||t<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(r.length!==1||n.length!==1)throw new Error("Dimensionality of the intermediate results should be 1");if(r[0]!==o||n[0]!==o)throw new Error("Shape of the intermediate results should be equal to logical row count");let l=`
      float process(int[${u}] indices) {

      // get offset of current logical tensor index from the 2-D texture coordinates (TexCoords)
      int offset = coordsToOffset(TexCoords, ${s}, ${i});

      //determine the logical row for this index
      int logical_row_index[1];
      logical_row_index[0] = offset / ${t};

      float norm_factor = _Norm(logical_row_index);

      // avoid possible division by 0
      // if norm_facor is 0, all elements are zero
      // if so, return 0
      if(norm_factor == 0.0)
        return 0.0;

      return exp(_A(indices) - _Max(logical_row_index)) / norm_factor;
    }`;return{...Pu,output:{dims:e.dims,type:e.type,textureType:0},shaderSource:l}},Bu=a=>{if(!a||a.length!==1)throw new Error("Softmax requires 1 input.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type")}});var Nu,Cu,Gu,Fp,Np,Cp,Ru=x(()=>{"use strict";tt();z();N();Nu={name:"Split",inputNames:["A"],inputTypes:[0]},Cu=(a,e,o)=>{Cp(e);let t=A.normalizeAxis(o.axis,e[0].dims.length),r=Fp(a,e,t,o),n=[];for(let s=0;s<r;++s)n.push(a.run({...Nu,cacheHint:`${o.cacheKey};${s}`,get:()=>Np(a,e[0],o,t,s)},e));return n},Gu=a=>{let e=a.attributes.getInt("axis",0),o=a.attributes.getInts("split",[]),t=a.outputs.length;return $({axis:e,split:o,numOutputs:t})},Fp=(a,e,o,t)=>{let[,r]=_e.splitShape(e[0].dims,o,t.split,t.numOutputs);return r.length},Np=(a,e,o,t,r)=>{let[n,s]=_e.splitShape(e.dims,t,o.split,o.numOutputs),i=s[r],u=n[r],f=`
      float process(int indices[${u.length}]) {
        indices[${t}] += ${i};
        return _A(indices);
      }
    `;return{...Nu,cacheHint:`${o.cacheKey}:${r}`,output:{dims:u,type:e.type,textureType:0},shaderSource:f}},Cp=a=>{if(!a||a.length!==1)throw new Error("Split requires one input.");if(a[0].type!=="int8"&&a[0].type!=="uint8"&&a[0].type!=="int16"&&a[0].type!=="uint16"&&a[0].type!=="int32"&&a[0].type!=="uint32"&&a[0].type!=="float32"&&a[0].type!=="float64"&&a[0].type!=="bool")throw new Error("Invalid input type.")}});var Fn,Vu,zu,Gp,Rp,Mu=x(()=>{"use strict";z();Fn=(a,e,o)=>{Gp(e);let t=A.squeezeShape(e[0].dims,o);return[a.reshapeUnpacked(e[0],t)]},Vu=(a,e)=>(Rp(e),Fn(a,[e[0]],Array.from(e[1].integerData))),zu=a=>a.attributes.getInts("axes"),Gp=a=>{if(!a||a.length!==1)throw new Error("Squeeze requires 1 input.");if(a[0].type==="string")throw new Error("invalid input tensor types.")},Rp=a=>{if(!a||a.length!==2)throw new Error("Squeeze requires 2 inputs.");if(a[1].type!=="int32")throw new Error("Invalid input type.")}});var Uu,Vp,zp,Wu=x(()=>{"use strict";q();N();Uu=(a,e)=>{zp(e);let o={name:"Sum",inputNames:e.map((r,n)=>`X${n}`),inputTypes:new Array(e.length).fill(0)};return[a.run({...o,get:()=>Vp(a,e,o)},e)]},Vp=(a,e,o)=>{let t=D(a.session.backend.glContext.version),r=e[0].dims.slice(),s=`
      void main() {
        vec4 result = ${e.map((i,u)=>`${t.texture2D}(X${u},TexCoords)`).join(" + ")};
        ${t.output} = result;
      }
    `;return{...o,output:{dims:r,type:e[0].type,textureType:0},hasMain:!0,shaderSource:s}},zp=a=>{if(!a||a.length===0)throw new Error("Sum requires inputs.");let e=a[0].dims.length;for(let o=1;o<a.length;o++){if(e!==a[o].dims.length)throw new Error("Input shapes are mismatched.");for(let t=0;t<e;t++)if(a[0].dims[t]!==a[o].dims[t])throw new Error("Input shapes are not matched.")}if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.");for(let o=1;o<a.length;o++)if(a[0].type!==a[o].type)throw new Error("Input types are not matched.")}});var Hu,Mp,Up,qu=x(()=>{"use strict";De();N();Hu=(a,e)=>{Up(e);let o={name:"Tile",inputNames:["A"],inputTypes:[0]};return[a.run({...o,get:()=>Mp(a,e,o)},e)]},Mp=(a,e,o)=>{let t=e[0].dims.slice(),r=new Array(t.length),n=[];for(let u=0;u<t.length;u++)r[u]=t[u]*e[1].numberData[u],n.push(`inputIdx[${u}] = int(mod(float(outputIdx[${u}]), ${t[u]}.));`);let s=r.length,i=`
      float process(int outputIdx[${s}]) {
        int inputIdx[${s}];
        ${n.join(`
`)}
        return _A(inputIdx);
      }
    `;return{...o,output:{dims:r,type:e[0].type,textureType:0},shaderSource:i}},Up=a=>{if(!a||a.length!==2)throw new Error("Tile requires 2 input.");if(a[1].dims.length!==1)throw new Error("The second input shape must 1 dimension.");if(a[1].dims[0]!==a[0].dims.length)throw new Error("Invalid input shape.");if(Rt.indexOf(a[0].type)===-1)throw new Error("Invalid input type.");if(a[1].type!=="int32"&&a[1].type!=="int16")throw new Error("Invalid repeat type.")}});var Nn,ju,Ku,Wp,Hp,Xu=x(()=>{"use strict";z();Nn=(a,e,o)=>{Wp(e);let t=A.unsqueezeShape(e[0].dims,o);return[a.reshapeUnpacked(e[0],t)]},ju=(a,e)=>(Hp(e),Nn(a,[e[0]],Array.from(e[1].integerData))),Ku=a=>a.attributes.getInts("axes"),Wp=a=>{if(!a||a.length!==1)throw new Error("Unsqueeze requires 1 input.");if(a[0].type==="string")throw new Error("invalid input tensor types.")},Hp=a=>{if(!a||a.length!==2)throw new Error("Unsqueeze requires 2 inputs.");if(a[1].type!=="int32")throw new Error("Invalid input type.")}});var Ju,Zu=x(()=>{"use strict";sa();Ta();Ia();Ea();lr();ps();gs();vs();_s();Ps();Ls();Fs();Rs();fr();Us();ru();fu();pu();gu();Tu();Su();Fu();Ru();Mu();Wu();qu();pr();xn();Xu();Ln();Ju=[["Abs","","6+",Da],["Acos","","7+",La],["Add","","7+",ua],["And","","7+",la],["Asin","","7+",$a],["Atan","","7+",ka],["AveragePool","","7+",Hs,qs],["BatchNormalization","","7+",ia,aa],["Cast","","6+",va,wa],["Ceil","","6+",Na],["Clip","","6-10",yn,Ba],["Clip","","11+",Fa],["Concat","","4+",Oa,Pa],["Conv","","1+",Sn,On],["ConvTranspose","","1+",fs,cs],["Cos","","7+",Ca],["Div","","7+",fa],["Dropout","","7+",gn],["DepthToSpace","","1+",bs,ys],["Equal","","7+",ca],["Elu","","6+",Ga,Ra],["Exp","","6+",Va],["Flatten","","1+",xs,Ts],["Floor","","6+",za],["FusedConv","com.microsoft","1+",Sn,On],["Gather","","1+",ws,Is],["Gemm","","7-10",An,Os],["Gemm","","11+",An,As],["GlobalAveragePool","","1+",Ks,Xs],["GlobalMaxPool","","1+",tu],["Greater","","7+",pa],["Identity","","1+",gn],["ImageScaler","","1+",Es,Ds],["InstanceNormalization","","6+",ks,Bs],["LeakyRelu","","6+",Ma,Ua],["Less","","7+",da],["LRN","","1+",Ns,Cs],["Log","","6+",Wa],["MatMul","","1+",ns,os],["MaxPool","","1+",Js,Zs],["Mul","","7+",ha],["Neg","","6+",Ha],["Not","","1+",qa],["Or","","7+",ma],["Pad","","2-10",Pn,Vs],["Pad","","11+",zs,Ms],["Pow","","7+",ba],["PRelu","","7+",ya],["ReduceLogSum","","1+",uu,Vt],["ReduceMax","","1+",iu,Vt],["ReduceMean","","1+",ou,Vt],["ReduceMin","","1+",au,Vt],["ReduceProd","","1+",su,Vt],["ReduceSum","","1-12",nu,Vt],["ReduceSumSquare","","1+",lu,Vt],["Relu","","6+",ja],["Reshape","","5+",cu],["Resize","","10",kn,bu],["Resize","","11+",kn,yu],["Shape","","1+",xu],["Sigmoid","","6+",Ka],["Sin","","7+",Xa],["Slice","","10+",_u],["Slice","","1-9",vu,wu],["Softmax","","1-12",Eu,Du],["Softmax","","13+",$u,Lu],["Split","","2-12",Cu,Gu],["Sqrt","","6+",Ja],["Squeeze","","1-12",Fn,zu],["Squeeze","","13+",Vu],["Sub","","7+",ga],["Sum","","6+",Uu],["Tan","","7+",Za],["Tanh","","6+",Ya],["Tile","","6+",Hu],["Transpose","","1+",te,hs],["Upsample","","7-8",En,hu],["Upsample","","9",En,mu],["Unsqueeze","","1-12",Nn,Ku],["Unsqueeze","","13+",ju],["Xor","","7+",xa]]});function Qu(a){let e={},o;for(;(o=Yu.exec(a))!==null;){let t=o[3].split(",").map(r=>{let n=r.trim().split(" ");return n&&n.length===2?{type:n[0],name:n[1]}:null}).filter(r=>r!==null);e[o[2]]={params:t,body:o[4]}}for(let t in e){let r=qp.replace("__FUNC__",t),n=new RegExp(r,"gm");for(;(o=n.exec(a))!==null;){let s=o[1],i=o[2],u=o[3].split(","),l=s?`${s} ${i};`:"",f=e[t].body,p="";e[t].params.forEach((m,g)=>{m&&(p+=`${m.type} ${m.name} = ${u[g]};
`)}),f=`${p}
 ${f}`,f=f.replace("return",`${i} = `);let d=`
      ${l}
      {
        ${f}
      }
      `;a=a.replace(o[0],d)}}return a=a.replace(Yu,""),a}var Yu,qp,tl=x(()=>{"use strict";Yu=/@inline[\s\n\r]+(\w+)[\s\n\r]+([0-9a-zA-Z_]+)\s*\(([^)]*)\)\s*{(([^}]|[\n\r])*)}/gm,qp="(\\w+)?\\s+([_0-9a-zA-Z]+)\\s+=\\s+__FUNC__\\((.*)\\)\\s*;"});function de(a,e){let o=[],t=[],r=e!=null&&Array.isArray(e)&&e.length===0,n=e==null||r?null:jp(e,a).sort(),s=0;for(let i=0;i<a.length;++i){if(n!=null){if(n[s]===i&&a[i]!==1)throw new Error(`Can't squeeze axis ${i} since its dim '${a[i]}' is not 1`);(n[s]==null||n[s]>i)&&a[i]===1&&(o.push(a[i]),t.push(i)),n[s]<=i&&s++}a[i]!==1&&(o.push(a[i]),t.push(i))}return{newShape:o,keptDims:t}}function jp(a,e){let o=e.length;return a=a==null?e.map((t,r)=>r):[].concat(a),se(a.every(t=>t>=-o&&t<o),()=>`All values in axis param must be in range [-${o}, ${o}) but got axis ${a}`),se(a.every(Kp),()=>`All values in axis param must be integers but got axis ${a}`),a.map(t=>t<0?o+t:t)}function Kp(a){return a%1===0}function Xp(a){if(a.length===0)return 1;let e=a[0];for(let o=1;o<a.length;o++)e*=a[o];return e}function el(a){let e=Math.ceil(Math.sqrt(a));return[e,Math.ceil(a/e)]}var br,Cn=x(()=>{"use strict";ct();z();br=class{constructor(e){this.maxTextureSize=e}computeTextureWH(e,o){let t=this.computeTexture(e,o);return o&&o.isPacked&&(t[0]/=2,t[1]/=2),o&&o.reverseWH?[t[1],t[0]]:t}computeTexture(e,o){let t=o&&o.isPacked;if(e.length===0)return t?[2,2]:[1,1];let r=this.maxTextureSize;if(o&&o.breakAxis!==void 0){let i=o.breakAxis>=e.length?1:e.slice(o.breakAxis).reduce((l,f)=>l*f),u=o.breakAxis<=0?1:e.slice(0,o.breakAxis).reduce((l,f)=>l*f);if(i>r||u>r)M.verbose("TextureLayout",`Given width/height preferences were unattainable: shape:${e}, breakAxis:${o.breakAxis}`);else return[i,u]}let n=e.slice(0);t&&(r=r*2,n=n.map((i,u)=>u>=n.length-2?n[u]%2===0?n[u]:n[u]+1:n[u]),n.length===1&&(n=[2,n[0]])),n.length!==2&&(n=de(n).newShape);let s=Xp(n);return n.length<=1&&s<=r?[1,s]:n.length===2&&n[0]<=r&&n[1]<=r?n:n.length===3&&n[0]*n[1]<=r&&n[2]<=r?[n[0]*n[1],n[2]]:n.length===3&&n[0]<=r&&n[1]*n[2]<=r?[n[0],n[1]*n[2]]:n.length===4&&n[0]*n[1]*n[2]<=r&&n[3]<=r?[n[0]*n[1]*n[2],n[3]]:n.length===4&&n[0]<=r&&n[1]*n[2]*n[3]<=r?[n[0],n[1]*n[2]*n[3]]:t?el(s/4).map(i=>i*2):el(s)}}});var yr,rl=x(()=>{"use strict";z();kt();q();Cn();At();yr=class extends mt{constructor(o){super(o)}getFunctions(){return{...this.offsetToCoords(),...this.coordsToOffset(),...this.toVec(),...this.valueFrom(),...this.getCommonUtilFuncs(),...this.getInputsSamplingSnippets(),...this.getOutputSamplingSnippet()}}getCustomTypes(){return{}}offsetToCoords(){let o="offsetToCoords";return{offsetToCoords:new I(`
      vec2 ${o}(int offset, int width, int height) {
        int t = offset / width;
        int s = offset - t*width;
        vec2 coords = (vec2(s,t) + vec2(0.5,0.5)) / vec2(width, height);
        return coords;
      }
      `)}}coordsToOffset(){let o="coordsToOffset";return{coordsToOffset:new I(`
      int ${o}(vec2 coords, int width, int height) {
        float s = coords.s * float(width);
        float t = coords.t * float(height);
        int offset = int(t) * width + int(s);
        return offset;
      }
      `)}}getOutputSamplingSnippet(){let o=this.context.outputTextureLayout;return o.isPacked?this.getPackedOutputSamplingSnippet(o):this.getUnpackedOutputSamplingSnippet(o)}getPackedOutputSamplingSnippet(o){let t=o.unpackedShape,r=[o.width,o.height],n={},s="getOutputCoords";switch(t.length){case 0:n[s]=this.getOutputScalarCoords();break;case 1:n[s]=this.getOutputPacked1DCoords(t,r);break;case 2:n[s]=this.getOutputPacked2DCoords(t,r);break;case 3:n[s]=this.getOutputPacked3DCoords(t,r);break;default:n[s]=this.getOutputPackedNDCoords(t,r)}let u=`
      void setOutput(vec4 val) {
        ${D(this.context.glContext.version).output} = val;
      }
    `,l="floatTextureSetRGBA";return n[l]=new I(u),n}getUnpackedOutputSamplingSnippet(o){let t=o.unpackedShape,r=[o.width,o.height],n={},s="getOutputCoords";switch(t.length){case 0:n[s]=this.getOutputScalarCoords();break;case 1:n[s]=this.getOutputUnpacked1DCoords(t,r);break;case 2:n[s]=this.getOutputUnpacked2DCoords(t,r);break;case 3:n[s]=this.getOutputUnpacked3DCoords(t,r);break;case 4:n[s]=this.getOutputUnpacked4DCoords(t,r);break;case 5:n[s]=this.getOutputUnpacked5DCoords(t,r);break;case 6:n[s]=this.getOutputUnpacked6DCoords(t,r);break;default:throw new Error(`Unsupported output dimensionality: ${t.length}`)}let u=`
        void setOutput(float val) {
          ${D(this.context.glContext.version).output} = vec4(val, 0, 0, 0);
        }
    `,l="floatTextureSetR";return n[l]=new I(u),n}getOutputScalarCoords(){return new I(`
      int getOutputCoords() {
        return 0;
      }
    `)}getOutputPacked1DCoords(o,t){let r=t,n="";return r[0]===1?(n=`
          int getOutputCoords() {
            return 2 * int(TexCoords.y * ${r[1]}.0);
          }
        `,new I(n)):r[1]===1?(n=`
          int getOutputCoords() {
            return 2 * int(TexCoords.x * ${r[0]}.0);
          }
        `,new I(n)):(n=`
        int getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                 vec2(${r[0]}, ${r[1]}));
          return 2 * (resTexRC.y * ${r[0]} + resTexRC.x);
        }
      `,new I(n))}getOutputPacked2DCoords(o,t){let r="";if(jt.arraysEqual(o,t))return r=`
        ivec2 getOutputCoords() {
          return 2 * ivec2(TexCoords.xy * vec2(${t[0]}, ${t[1]}));
        }
      `,new I(r);let n=t,s=Math.ceil(o[1]/2);return r=`
        ivec2 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${n[0]}, ${n[1]}));

          int index = resTexRC.y * ${n[0]} + resTexRC.x;

          // reverse r and c order for packed texture
          int r = imod(index, ${s}) * 2;
          int c = 2 * (index / ${s});

          return ivec2(r, c);
        }
      `,new I(r)}getOutputPacked3DCoords(o,t){let r=[t[0],t[1]],n=Math.ceil(o[2]/2),s=n*Math.ceil(o[1]/2),i=`
        ivec3 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${r[0]}, ${r[1]}));
          int index = resTexRC.y * ${r[0]} + resTexRC.x;

          int b = index / ${s};
          index -= b * ${s};

          // reverse r and c order for packed texture
          int r = imod(index, ${n}) * 2;
          int c = 2 * (index / ${n});

          return ivec3(b, r, c);
        }
      `;return new I(i)}getOutputPackedNDCoords(o,t){let r=[t[0],t[1]],n=Math.ceil(o[o.length-1]/2),s=n*Math.ceil(o[o.length-2]/2),i=s,u="",l="b, r, c";for(let p=2;p<o.length-1;p++)i*=o[o.length-p-1],u=`
      int b${p} = index / ${i};
      index -= b${p} * ${i};
    `+u,l=`b${p}, `+l;let f=`
      ivec${o.length} getOutputCoords() {
        ivec2 resTexRC = ivec2(TexCoords.xy *
                              vec2(${r[0]}, ${r[1]}));
        int index = resTexRC.y * ${r[0]} + resTexRC.x;

        ${u}

        int b = index / ${s};
        index -= b * ${s};

        // reverse r and c order for packed texture
        int r = imod(index, ${n}) * 2;
        int c = 2 * (index / ${n});

        return ivec${o.length}(${l});
      }
    `;return new I(f)}getOutputUnpacked1DCoords(o,t){let r=`
        int getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          return resTexRC.y * ${t[0]} + resTexRC.x;
        }
      `;return new I(r)}getOutputUnpacked2DCoords(o,t){let r=`
        ivec2 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          int r = index / ${o[1]};
          int c = index - r * ${o[1]};
          return ivec2(r, c);
        }
      `;return new I(r)}getOutputUnpacked3DCoords(o,t){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
        ivec3 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          ${u}
          return ivec3(r, c, d);
        }
      `,new I(r)}getOutputUnpacked4DCoords(o,t){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d","d2"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
      ivec4 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          ${u}
          return ivec4(r, c, d, d2);
        }
      `,new I(r)}getOutputUnpacked5DCoords(o,t){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d","d2","d3"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
      ivec5 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          ${u}
          return ivec5(r, c, d, d2, d3);
        }
      `,new I(r)}getOutputUnpacked6DCoords(o,t){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d","d2","d3","d4"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
     ivec6 getOutputCoords() {
         ivec2 resTexRC = ivec2(TexCoords.xy *
                               vec2(${t[0]}, ${t[1]}));
         int index = resTexRC.y * ${t[0]} + resTexRC.x;
         ${u}
         return ivec6(r, c, d, d2, d3, d4);
       }
     `,new I(r)}getCommonUtilFuncs(){let o={},t="uvFromFlat";o[t]=new I(`
    vec2 uvFromFlat(int texNumR, int texNumC, int index) {
      int texC = index / texNumR;
      int texR = index - texC * texNumR;
      // TODO: swap texR, texC order in following function so row is corresponding to u and column is corresponding to
      //       v.
      return (vec2(texR, texC) + halfCR) / vec2(texNumR, texNumC);
    }
    `),t="packedUVfrom1D",o[t]=new I(`
      vec2 packedUVfrom1D(int texNumR, int texNumC, int index) {
        int texelIndex = index / 2;
        int texR = texelIndex / texNumC;
        int texC = texelIndex - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),t="packedUVfrom2D",o[t]=new I(`
      vec2 packedUVfrom2D(int texNumR, int texNumC, int texelsInLogicalRow, int row, int col) {
        int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);
        int texR = texelIndex / texNumC;
        int texC = texelIndex - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),t="packedUVfrom3D",o[t]=new I(`
      vec2 packedUVfrom3D(int texNumR, int texNumC,
          int texelsInBatch, int texelsInLogicalRow, int b,
          int row, int col) {
        int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);
        int texR = index / texNumC;
        int texC = index - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),t="sampleTexture";let r=D(this.context.glContext.version);return o[t]=new I(`
        float sampleTexture(sampler2D textureSampler, vec2 uv) {
            return ${r.texture2D}(textureSampler, uv).r;
        }`),o}getInputsSamplingSnippets(){let o={},t=this.context.outputTextureLayout;return this.context.programInfo.inputNames.forEach((r,n)=>{let s=this.context.inputTextureLayouts[n],i=rr(r);s.isPacked?o[i]=this.getPackedSamplerFromInput(i,r,s):o[i]=this.getUnpackedSamplerFromInput(i,r,s);let u=Ui(r);s.unpackedShape.length<=t.unpackedShape.length&&(s.isPacked?o[u]=this.getPackedSamplerAtOutputCoords(u,s,t,r):o[u]=this.getUnpackedSamplerAtOutputCoords(u,s,t,r))}),o}getPackedSamplerAtOutputCoords(o,t,r,n){let s=t.unpackedShape,i=r.unpackedShape,l=rr(n),f=s.length,p=i.length,d=it.getBroadcastDims(s,i),m=at(p),g=p-f,y,v=It();f===0?y="":p<2&&d.length>=1?y="coords = 0;":y=d.map(zt=>`coords.${v[zt+g]} = 0;`).join(`
`);let _="";p<2&&f>0?_="coords":_=s.map((zt,Be)=>`coords.${v[Be+g]}`).join(", ");let O="return outputValue;",C=A.size(s)===1,st=A.size(i)===1;if(f===1&&!C&&!st)O=`
        return vec4(outputValue.xy, outputValue.xy);
      `;else if(C&&!st)p===1?O=`
          return vec4(outputValue.x, outputValue.x, 0., 0.);
        `:O=`
          return vec4(outputValue.x);
        `;else if(d.length){let zt=f-2,Be=f-1;d.indexOf(zt)>-1&&d.indexOf(Be)>-1?O="return vec4(outputValue.x);":d.indexOf(zt)>-1?O="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":d.indexOf(Be)>-1&&(O="return vec4(outputValue.xx, outputValue.zz);")}let _t=`
        int lastDim = coords.${v[p-1]};
        coords.${v[p-1]} = coords.${v[p-2]};
        coords.${v[p-2]} = lastDim;
      `,kr=`
      vec4 ${o}() {
        ${m} coords = getOutputCoords();
        ${_t}
        ${y}
        vec4 outputValue = ${l}(${_});
        ${O}
      }
    `;return new I(kr,["coordinates.getOutputCoords"])}getUnpackedSamplerAtOutputCoords(o,t,r,n){let s=[r.width,r.height],i=[t.width,t.height],u=t.unpackedShape.length,l=r.unpackedShape.length,f=t.unpackedShape,p=r.unpackedShape,d=rr(n);if(u===l&&jt.arraysEqual(i,s)){let C=`
          float ${o}() {
            return sampleTexture(${n}, TexCoords);
          }
        `;return new I(C,["coordinates.sampleTexture"])}let m=at(l),g=it.getBroadcastDims(f,p),y=l-u,v,_=It();u===0?v="":l<2&&g.length>=1?v="coords = 0;":v=g.map(C=>`coords.${_[C+y]} = 0;`).join(`
`);let O="";l<2&&u>0?O="coords":O=t.unpackedShape.map((C,F)=>`coords.${_[F+y]}`).join(", ");let S=`
        float ${o}() {
          ${m} coords = getOutputCoords();
          ${v}
          return ${d}(${O});
        }
      `;return new I(S,["coordinates.getOutputCoords"])}getPackedSamplerFromInput(o,t,r){switch(r.unpackedShape.length){case 0:return this.getPackedSamplerScalar(o,t);case 1:return this.getPackedSampler1D(o,t,r);case 2:return this.getPackedSampler2D(o,t,r);case 3:return this.getPackedSampler3D(o,t,r);default:return this.getPackedSamplerND(o,t,r)}}getUnpackedSamplerFromInput(o,t,r){let n=r.unpackedShape;switch(n.length){case 0:return this.getUnpackedSamplerScalar(o,t,r);case 1:return this.getUnpackedSampler1D(o,t,r);case 2:return this.getUnpackedSampler2D(o,t,r);case 3:return this.getUnpackedSampler3D(o,t,r);case 4:return this.getUnpackedSampler4D(o,t,r);case 5:return this.getUnpackedSampler5D(o,t,r);case 6:return this.getUnpackedSampler6D(o,t,r);default:throw new Error(`Unsupported dimension ${n.length}-D`)}}getPackedSamplerScalar(o,t){let r=D(this.context.glContext.version),n=`
          vec4 ${o}() {
            return ${r.texture2D}(${t}, halfCR);
          }
        `;return new I(n)}getPackedSampler1D(o,t,r){let n=[r.width,r.height],s=[n[1],n[0]],i=D(this.context.glContext.version),l=`vec4 ${o}(int index) {
      vec2 uv = packedUVfrom1D(
      ${s[0]}, ${s[1]}, index);
      return ${i.texture2D}(${t}, uv);
    }`;return new I(l,["coordinates.packedUVfrom1D"])}getPackedSampler2D(o,t,r){let n=r.unpackedShape,s=[r.width,r.height],i=D(this.context.glContext.version),u=s[0],l=s[1];if(s!=null&&jt.arraysEqual(n,s)){let g=`vec4 ${o}(int row, int col) {
        vec2 uv = (vec2(col, row) + halfCR) / vec2(${l}.0, ${u}.0);
        return ${i.texture2D}(${t}, uv);
      }`;return new I(g)}let f=s,p=Math.ceil(n[1]/2),m=`vec4 ${o}(int row, int col) {
      vec2 uv = packedUVfrom2D(${f[1]}, ${f[0]}, ${p}, row, col);
      return ${i.texture2D}(${t}, uv);
    }`;return new I(m,["coordinates.packedUVfrom2D"])}getPackedSampler3D(o,t,r){let n=r.unpackedShape,s=[r.width,r.height],i=[s[0],s[1]],u=D(this.context.glContext.version);if(n[0]===1){let y=n.slice(1),v=[1,2],_=ue(n,y),O=["b","row","col"],S=JSON.parse(JSON.stringify(r));S.unpackedShape=_;let C=this.getPackedSamplerFromInput(o,t,S),st=`${C.routineBody}
      vec4 ${o}(int b, int row, int col) {
        return ${o}(${le(O,v)});
      } `;return new I(st,C.dependencies)}let l=i[0],f=i[1],p=Math.ceil(n[2]/2),d=p*Math.ceil(n[1]/2),g=`vec4 ${o}(int b, int row, int col) {
      vec2 uv = packedUVfrom3D(
        ${f}, ${l}, ${d}, ${p}, b, row, col);
      return ${u.texture2D}(${t}, uv);}`;return new I(g,["coordinates.packedUVfrom3D"])}getPackedSamplerND(o,t,r){let n=r.unpackedShape,s=n.length,i=[r.width,r.height],u=D(this.context.glContext.version),l=[i[0],i[1]],f=l[1],p=l[0],d=Math.ceil(n[s-1]/2),m=d*Math.ceil(n[s-2]/2),g="int b, int row, int col",y=`b * ${m} + (row / 2) * ${d} + (col / 2)`;for(let O=2;O<s-1;O++)g=`int b${O}, `+g,m*=n[s-O-1],y=`b${O} * ${m} + `+y;let _=`vec4 ${o}(${g}) {
      int index = ${y};
      int texR = index / ${p};
      int texC = index - texR * ${p};
      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${p}, ${f});
      return ${u.texture2D}(${t}, uv);
    }`;return new I(_)}getUnpackedSamplerScalar(o,t,r){let[n,s]=[r.width,r.height];if(n===1&&s===1){let u=`
          float ${o}() {
            return sampleTexture(${t}, halfCR);
          }
        `;return new I(u,["coordinates.sampleTexture"])}let i=`
        float ${o}() {
          int offset_${t} = coordsToOffset(TexCoords, ${n}, ${s});
          vec2 uv = uvFromFlat(${n}, ${s}, offset_${t});
          return sampleTexture(${t}, uv);
        }
      `;return new I(i,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler1D(o,t,r){let n=r.width,s=r.height;if(s===1&&n===1){let u=`
        float ${o}(int index) {
          return sampleTexture(${t}, halfCR);
        }
      `;return new I(u,["coordinates.sampleTexture"])}if(s===1){let u=`
          float ${o}(int index) {
            vec2 uv = vec2((float(index) + 0.5) / ${n}.0, 0.5);
            return sampleTexture(${t}, uv);
          }
        `;return new I(u,["coordinates.sampleTexture"])}if(n===1){let u=`
          float ${o}(int index) {
            vec2 uv = vec2(0.5, (float(index) + 0.5) / ${s}.0);
            return sampleTexture(${t}, uv);
          }
        `;return new I(u,["coordinates.sampleTexture"])}let i=`
        float ${o}(int index) {
          vec2 uv = uvFromFlat(${n}, ${s}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new I(i,["coordinates.uvFromFlat","coordinates.sampleTexture"])}getUnpackedSampler2D(o,t,r){let n=r.unpackedShape,s=[r.height,r.width];if(s!=null&&jt.arraysEqual(n,s)){let m=s[1],g=s[0],y=`
          float ${o}(int row, int col) {
            vec2 uv = (vec2(row, col) + halfCR) / vec2(${m}.0, ${g}.0);
            return sampleTexture(${t}, uv);
          }
        `;return new I(y,["coordinates.sampleTexture"])}let{newShape:i,keptDims:u}=de(n),l=i;if(l.length<n.length){let m=ue(n,l),g=JSON.parse(JSON.stringify(r));g.unpackedShape=m;let y=["col","row"],v=`
          ${this.getUnpackedSamplerFromInput(o,t,g).routineBody}
          float ${o}(int row, int col) {
            return ${o}(${le(y,u)});
          }
        `;return new I(v,["coordinates.sampleTexture"])}let f=s[1],p=s[0];if(p===1){let m=`
          float ${o}(int row, int col) {
            int offset_${t} = coordsToOffset(TexCoords, ${f}, ${p});
            float index = dot(vec3(row, col, offset_${t}), vec3(${n[1]}, 1, 1));
            vec2 uv = vec2(0.5, (index + 0.5) / ${f}.0);
            return sampleTexture(${t}, uv);
          }
        `;return new I(m,["coordinates.sampleTexture","coordinates.coordsToOffset"])}if(f===1){let m=`
          float ${o}(int row, int col) {
            int offset_${t} = coordsToOffset(TexCoords, ${f}, ${p});
            float index = dot(vec3(row, col, offset_${t}), vec3(${n[1]}, 1, 1));
            vec2 uv = vec2((index + 0.5) / ${p}.0, 0.5);
            return sampleTexture(${t}, uv);
          }
        `;return new I(m,["coordinates.sampleTexture","coordinates.coordsToOffset"])}let d=`
        float ${o}(int row, int col) {
          int index = col * ${n[1]} + row;
          vec2 uv = uvFromFlat(${f}, ${p}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new I(d,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler3D(o,t,r){let n=r.unpackedShape,s=n[1]*n[2],i=n[2],{newShape:u,keptDims:l}=de(n),f=u;if(f.length<n.length){let g=ue(n,f),y=["batch","col","row"],v=JSON.parse(JSON.stringify(r));v.unpackedShape=g;let _=this.getUnpackedSamplerFromInput(o,t,v),O=l.reverse(),S=`
          ${_.routineBody}
          float ${o}(int batch, int row, int col) {
            return ${o}(${le(y,O)});
          }
        `;return new I(S,_.dependencies)}let p=r.width,d=r.height,m=`
          float ${o}(int depth, int row, int col) {
            // Explicitly use integer operations as dot() only works on floats.
            int index = depth * ${s} + col * ${i} + row;
            vec2 uv = uvFromFlat(${p}, ${d}, index);
            return sampleTexture(${t}, uv);
          }
      `;return new I(m,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler4D(o,t,r){let n=r.unpackedShape,s=n[3],i=n[2]*s,u=n[1]*i,l=r.width,f=r.height,p=`
        float ${o}(int row, int col, int depth, int depth2) {
          int index = row * ${u} + col * ${i} +
              depth2 * ${s} + depth;
          vec2 uv = uvFromFlat(${l}, ${f}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new I(p,["coordinates.uvFromFlat","coordinates.sampleTexture"])}getUnpackedSampler5D(o,t,r){let n=r.unpackedShape,s=n[4],i=n[3]*s,u=n[2]*i,l=n[1]*u,{newShape:f,keptDims:p}=de(n);if(f.length<n.length){let y=ue(n,f),v=["row","col","depth","depth2","depth3"],_=JSON.parse(JSON.stringify(r));_.unpackedShape=y;let O=`
          ${this.getUnpackedSamplerFromInput(o,t,_).routineBody}
          float ${o}(int row, int col, int depth, int depth2, int depth3) {
            return ${o}(${le(v,p)});
          }
        `;return new I(O,["coordinates.sampleTexture","coordinates.uvFromFlat"])}let d=r.width,m=r.height,g=`
        float ${o}(int row, int col, int depth, int depth2, int depth3) {
          int index = row * ${l} + col * ${u} + depth * ${i} +
          depth3 * ${s} + depth2;
          vec2 uv = uvFromFlat(${d}, ${m}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new I(g,["coordinates.sampleTexture","coordinates.uvFromFlat"])}getUnpackedSampler6D(o,t,r){let n=r.unpackedShape,s=n[5],i=n[4]*s,u=n[3]*i,l=n[2]*u,f=n[1]*l,{newShape:p,keptDims:d}=de(n);if(p.length<n.length){let v=ue(n,p),_=["row","col","depth","depth2","depth3","depth4"],O=JSON.parse(JSON.stringify(r));O.unpackedShape=v;let S=`
            ${this.getUnpackedSamplerFromInput(o,t,O).routineBody}
            float ${o}(int row, int col, int depth,
              int depth2, int depth3, int depth4) {
              return ${o}(${le(_,d)});
            }
          `;return new I(S,["coordinates.sampleTexture","coordinates.uvFromFlat"])}let m=r.width,g=r.height,y=`
          float ${o}(int row, int col, int depth,
            int depth2, int depth3, int depth4) {
            int index = row * ${f} + col * ${l} + depth * ${u} +
            depth2 * ${i} + depth3 * ${s} + depth4;
            vec2 uv = uvFromFlat(${m}, ${g}, index);
            return sampleTexture(${t}, uv);
          }
        `;return new I(y,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}toVec(){let o=this.context.outputTextureLayout,t=o.shape.length,r=o.strides,n=o.width,s=o.height,i=[];for(let l=0;l<t-1;++l)i.push(`
        c[${l}] = offset / ${r[l]};`),i.push(`
        offset -= c[${l}] * ${r[l]};`);i.push(`
        c[${t-1}] = offset;`);let u=`
      void toVec(vec2 texCoords, out int c[${t}]) {
        int offset = coordsToOffset(texCoords, ${n}, ${s});
        ${i.join("")}
      }
      void toVec(int offset, out int c[${t}]) {
        ${i.join("")}
      }
    `;return{toVec:new I(u,["coordinates.coordsToOffset"])}}valueFrom(){let o={};return this.context.programInfo.inputNames.forEach((t,r)=>{let n=this.context.inputTextureLayouts[r],i=(n.unpackedShape.length>0?n.unpackedShape:n.shape).length,u=`_${t}`;o[u]=new I(this.getValueFromSingle(t,i,n.width,n.height,!1),[`shapeUtils.indicesToOffset${u}`,"coordinates.offsetToCoords","fragcolor.getColorAsFloat"]),u=u+"_T",o[u]=new I(this.getValueFromSingle(t,i,n.width,n.height,!0),[`shapeUtils.indicesToOffset${u}`,"coordinates.offsetToCoords","fragcolor.getColorAsFloat"])}),o}getValueFromSingle(o,t,r,n,s){let i=`_${o}`;s&&(i=i+"_T");let u=D(this.context.glContext.version);return`
        float ${i}(int m[${t}]) {
          int offset = indicesToOffset${i}(m);
          vec2 coords = offsetToCoords(offset, ${r}, ${n});
          float value = getColorAsFloat(${u.texture2D}(${o}, coords));
          return value;
        }
        `}getPackedValueFrom(o,t,r,n,s){let i=`_${o}_Pack`;s&&(i=i+"_T");let u=D(this.context.glContext.version);return`
        vec4 ${i}(int m[${t}]) {
          int offset = indicesToOffset_${o}(m);
          vec2 coords = offsetToCoords(offset, ${r}, ${n});
          return ${u.texture2D}(${o}, coords);
        }
        `}}});var gr,nl=x(()=>{"use strict";kt();gr=class a extends mt{constructor(e){super(e)}getFunctions(){return{...this.encodeFloat32(),...this.decodeFloat32()}}getCustomTypes(){return{}}encodeFloat32(){return{encode:new I(`highp vec4 encode(highp float f) {
        return vec4(f, 0.0, 0.0, 0.0);
      }
        `)}}decodeFloat32(){return{decode:new I(`highp float decode(highp vec4 rgba) {
        return rgba.r;
      }
        `)}}encodeUint8(){let e=a.isLittleEndian()?"rgba.rgba=rgba.abgr;":"";return{encode:new I(`
      highp vec4 encode(highp float f) {
        highp float F = abs(f);
        highp float Sign = step(0.0,-f);
        highp float Exponent = floor(log2(F));
        highp float Mantissa = (exp2(- Exponent) * F);
        Exponent = floor(log2(F) + 127.0) + floor(log2(Mantissa));
        highp vec4 rgba;
        rgba[0] = 128.0 * Sign  + floor(Exponent*exp2(-1.0));
        rgba[1] = 128.0 * mod(Exponent,2.0) + mod(floor(Mantissa*128.0),128.0);
        rgba[2] = floor(mod(floor(Mantissa*exp2(23.0 -8.0)),exp2(8.0)));
        rgba[3] = floor(exp2(23.0)*mod(Mantissa,exp2(-15.0)));
        ${e}
        rgba = rgba / 255.0; // values need to be normalized to [0,1]
        return rgba;
    }
        `)}}decodeUint8(){let e=a.isLittleEndian()?"rgba.rgba=rgba.abgr;":"";return{decode:new I(`
        highp float decode(highp vec4 rgba) {
          rgba = rgba * 255.0; // values need to be de-normalized from [0,1] to [0,255]
          ${e}
          highp float Sign = 1.0 - step(128.0,rgba[0])*2.0;
          highp float Exponent = 2.0 * mod(rgba[0],128.0) + step(128.0,rgba[1]) - 127.0;
          highp float Mantissa = mod(rgba[1],128.0)*65536.0 + rgba[2]*256.0 +rgba[3] + float(0x800000);
          highp float Result =  Sign * exp2(Exponent) * (Mantissa * exp2(-23.0 ));
          return Result;
      }
        `)}}static isLittleEndian(){let e=new ArrayBuffer(4),o=new Uint32Array(e),t=new Uint8Array(e);if(o[0]=3735928559,t[0]===239)return!0;if(t[0]===222)return!1;throw new Error("unknown endianness")}}});var xr,ol=x(()=>{"use strict";kt();q();xr=class extends mt{constructor(e){super(e)}getFunctions(){return{...this.setFragColor(),...this.getColorAsFloat()}}getCustomTypes(){return{}}setFragColor(){let e=D(this.context.glContext.version);return{setFragColor:new I(`
        void setFragColor(float value) {
            ${e.output} = encode(value);
        }
        `,["encoding.encode"])}}getColorAsFloat(){return{getColorAsFloat:new I(`
        float getColorAsFloat(vec4 color) {
            return decode(color);
        }
        `,["encoding.decode"])}}}});var Tr,il=x(()=>{"use strict";kt();Tr=class a extends mt{constructor(e){super(e)}getFunctions(){return{...this.bcastIndex(),...this.bcastMatmulIndex(),...this.offsetToIndices(),...this.indicesToOffset(),...this.incrementIndices()}}getCustomTypes(){return{}}bcastIndex(){let e=this.context.outputTextureLayout.shape.length,o={};return this.context.programInfo.inputNames.forEach((t,r)=>{let n=this.context.inputTextureLayouts[r].unpackedShape;if(n.length<=e){let s=n.length,i=e-s,u=`bcastIndices_${t}`,l="";for(let p=0;p<s;++p)l+=`
          realIndices[${p}] = int( mod(float(bcastedIndices[${i+p}]), ${n[p]}.0) );
          `;let f=`
        void ${u} (int bcastedIndices[${e}], out int realIndices[${s}]) {
          ${l}
        }
        `;o[u]=new I(f)}}),o}bcastMatmulIndex(){let e=this.context.outputTextureLayout.shape.length,o={};return this.context.programInfo.inputNames.forEach((t,r)=>{let n=this.context.inputTextureLayouts[r].shape;if(!(n.length<2||n.length>e)){let s=n.length,i=e-s,u=`bcastMatmulIndices_${t}`,l="";for(let p=0;p<s-2;++p)l+=`
          realIndices[${p}] = int( mod(float(bcastedIndices[${i+p}]), ${n[p]}.0) );
          `;let f=`
        void ${u}(int bcastedIndices[${e}], out int realIndices[${s}]) {
          ${l}
          realIndices[${s-1}] = bcastedIndices[${e-1}];
          realIndices[${s-2}] = bcastedIndices[${e-2}];
        }
        `;o[u]=new I(f)}}),o}indicesToOffset(){let e={};return this.context.programInfo.inputNames.forEach((o,t)=>{let r=this.context.inputTextureLayouts[t].shape,n=this.context.inputTextureLayouts[t].strides,s=r.length,i=`indicesToOffset_${o}`;e[i]=new I(a.indexToOffsetSingle(i,s,n)),i=`indicesToOffset_${o}_T`,e[i]=new I(a.indexToOffsetSingle(i,s,n.slice().reverse()))}),e}static indexToOffsetSingle(e,o,t){let r="";for(let n=o-1;n>=0;--n)r+=`
        offset += indices[${n}] * ${t[n]};
        `;return`
      int ${e}(int indices[${o}]) {
        int offset = 0;
        ${r}
        return offset;
      }
      `}offsetToIndices(){let e={};return this.context.programInfo.inputNames.forEach((o,t)=>{let r=this.context.inputTextureLayouts[t].shape,n=this.context.inputTextureLayouts[t].strides,s=r.length,i=`offsetToIndices_${o}`;e[i]=new I(a.offsetToIndicesSingle(i,s,n)),i=`offsetToIndices_${o}_T`,e[i]=new I(a.offsetToIndicesSingle(i,s,n.slice().reverse()))}),e}static offsetToIndicesSingle(e,o,t){let r=[];for(let n=0;n<o-1;++n)r.push(`
      indices[${n}] = offset / ${t[n]};`),r.push(`
        offset -= indices[${n}] * ${t[n]};`);return r.push(`
      indices[${o-1}] = offset;`),`
      void ${e}(int offset, out int indices[${o}]) {
        ${r.join("")}
      }
      `}incrementIndices(){let e={};return this.context.programInfo.inputNames.forEach((o,t)=>{let r=this.context.inputTextureLayouts[t].shape,n=r.length,s=`incrementIndices_${o}`,i="";for(let l=0;l<n;++l)i+=`
        shape[${l}] = ${r[l]};`;let u=`
        void ${s}(int axis, out int indices[${n}]) {
          int shape[${n}];
          ${i};
          for(int i = ${n} -1 ; i >= 0; --i) {
            if(i > axis) continue;
            indices[i] += 1;
            if(indices[i] < shape[i]) {
              break;
            }
            indices[i] = 0;
          }
        }
        `;e[s]=new I(u)}),e}}});var vr,al=x(()=>{"use strict";kt();vr=class extends mt{constructor(e){super(e)}getCustomTypes(){return{}}getFunctions(){return{...this.binaryVecFunctions(),...this.copyVec(),...this.setVecItem(),...this.getVecItem()}}binaryVecFunctions(){let o=this.context.outputTextureLayout.shape.length,t={add:"+=",sub:"-=",mul:"*=",div:"/="},r={};for(let n in t){let s=`${n}Vec`,i="";for(let l=0;l<o;++l)i+=`
          dest[${l}] ${t[n]} src[${l}];
          `;let u=`
        void ${s}(int src[${o}], out int dest[${o}]) {
          ${i}
        }
        `;r[s]=new I(u)}return r}copyVec(){let o=this.context.outputTextureLayout.shape.length,t="";for(let n=0;n<o;++n)t+=`
        dest[${n}] = src[${n}];
        `;let r=`
      void copyVec(int src[${o}], out int dest[${o}]) {
        ${t}
      }
      `;return{copyVec:new I(r)}}setVecItem(){let o=this.context.outputTextureLayout.shape.length,t=`
        if(index < 0)
            index =${o} + index;
        if (index == 0)
            m[0] = value;
        `;for(let n=1;n<o-1;++n)t+=`
        else if (index == ${n})
            m[${n}] = value;
            `;t+=`
        else
            m[${o-1}] = value;
        `;let r=`
      void setVecItem(out int m[${o}], int index, int value) {
        ${t}
      }
        `;return{setVecItem:new I(r)}}getVecItem(){let o=this.context.outputTextureLayout.shape.length,t=`
        if(index < 0)
            index = ${o} + index;
        if (index == 0)
            return m[0];
      `;for(let n=1;n<o-1;++n)t+=`
        else if (index == ${n})
            return m[${n}];
      `;t+=`
        else
            return m[${o-1}];
        `;let r=`
      int getVecItem(int m[${o}], int index) {
        ${t}
      }
    `;return{getVecItem:new I(r)}}}});var Gn,sl=x(()=>{"use strict";rl();nl();ol();il();al();Gn={encoding:gr,fragcolor:xr,vec:vr,shapeUtils:Tr,coordinates:yr}});var wr,ul=x(()=>{"use strict";kt();tl();sl();q();wr=class{constructor(e,o,t,r){this.libs={};this.glslLibRoutineDependencyGraph={};this.context=new ar(e,o,t,r),Object.keys(Gn).forEach(s=>{let i=new Gn[s](this.context);this.libs[s]=i});let n=this.glslLibRoutineDependencyGraph;for(let s in this.libs){let u=this.libs[s].getFunctions();for(let l in u){let f=s+"."+l,p;n[f]?(p=n[f],p.routineBody=u[l].routineBody):(p=new Ee(f,u[l].routineBody),n[f]=p);let d=u[l].dependencies;if(d)for(let m=0;m<d.length;++m)if(n[d[m]])p.addDependency(n[d[m]]);else{let g=new Ee(d[m]);n[d[m]]=g,p.addDependency(g)}}}}preprocess(){let e=this.context.programInfo,o=e.shaderSource;return this.context.programInfo.hasMain||(o=`${o}
      ${Mi(this.context.glContext.version,this.context.outputTextureLayout.shape.length)}`),o=Qu(o),`${zi(this.context.glContext.version)}
    ${this.getUniforms(e.inputNames,e.variables)}
    ${this.getImports(o)}
    ${o}`}getImports(e){let o=this.selectGlslLibRoutinesToBeIncluded(e);if(o.length===0)return"";let t="";for(let r=0;r<o.length;++r)if(o[r].routineBody)t+=o[r].routineBody+`
`;else throw new Error(`Missing body for the Glsl Library routine: ${o[r].name}`);return t}selectGlslLibRoutinesToBeIncluded(e){let o=[];return Object.keys(this.glslLibRoutineDependencyGraph).forEach(t=>{let r=t.split(".")[1];e.indexOf(r)!==-1&&o.push(this.glslLibRoutineDependencyGraph[t])}),sr.returnOrderedNodes(o)}getUniforms(e,o){let t=[];if(e)for(let r of e)t.push(`uniform sampler2D ${r};`);if(o)for(let r of o)t.push(`uniform ${r.type} ${r.name}${r.arrayLength?`[${r.arrayLength}]`:""};`);return t.join(`
`)}}});var Ir,ll=x(()=>{"use strict";Bt();ct();ul();q();Ir=class{constructor(e,o,t){this.profiler=e;this.glContext=o;this.textureLayoutStrategy=t;this.repo=new Map,this.attributesBound=!1}getArtifact(e){return this.repo.get(e)}setArtifact(e,o){this.repo.set(e,o)}run(e,o,t){this.profiler.event("op",`ProgramManager.run ${e.programInfo.name??"unknown kernel"}`,()=>{let r=this.glContext.gl,n=e.program;r.useProgram(n);try{this.bindOutput(t),this.attributesBound||this.bindAttributes(e.attribLocations),this.bindUniforms(e.uniformLocations,e.programInfo.variables??[],o)}catch(s){throw M.error("ProgramManager",e.programInfo.shaderSource),s}this.profiler.event("backend","GlContext.draw()",()=>{this.glContext.draw()})},this.glContext)}dispose(){this.vertexShader&&this.glContext.deleteShader(this.vertexShader),this.repo.forEach(e=>this.glContext.deleteProgram(e.program))}build(e,o,t){return this.profiler.event("backend","ProgramManager.build",()=>{let r=new wr(this.glContext,e,o,t),n=r.preprocess(),s=this.compile(n);return{programInfo:e,program:s,uniformLocations:this.getUniformLocations(s,r.context.programInfo.inputNames,r.context.programInfo.variables),attribLocations:this.getAttribLocations(s)}})}compile(e){if(!this.vertexShader){M.verbose("ProrgramManager","Compiling and caching Vertex shader for the first time");let r=Vi(this.glContext.version);this.vertexShader=this.glContext.compileShader(r,this.glContext.gl.VERTEX_SHADER)}j.debug&&M.verbose("ProrgramManager",`FragShader:
${e}
`);let o=this.glContext.compileShader(e,this.glContext.gl.FRAGMENT_SHADER),t=this.glContext.createProgram(this.vertexShader,o);return this.glContext.deleteShader(o),t}bindOutput(e){let o=e.width,t=e.height;M.verbose("ProrgramManager",`Binding output texture to Framebuffer: w/h=${o}/${t}, shape=${e.shape}, type=${e.tensor.type}`),this.glContext.attachFramebuffer(e.texture,o,t)}bindAttributes(e){let o=e.position,t=e.textureCoord;this.glContext.setVertexAttributes(o,t),this.attributesBound=!0}bindUniforms(e,o,t){let r=this.glContext.gl,n=0;for(let{name:s,type:i,location:u,arrayLength:l}of e){let f=o.find(p=>p.name===s)?.data;if(i!=="sampler2D"&&!f)throw new Error(`variable '${s}' does not have data defined in program info`);switch(i){case"sampler2D":this.bindTexture(t[n],u,n),n++;break;case"float":l?r.uniform1fv(u,f):r.uniform1f(u,f);break;case"int":l?r.uniform1iv(u,f):r.uniform1i(u,f);break;default:throw new Error(`Uniform not implemented: ${i}`)}}}bindTexture(e,o,t){this.glContext.bindTextureToUniform(e.texture,t,o)}getAttribLocations(e){return{position:this.getAttribLocation(e,"position"),textureCoord:this.getAttribLocation(e,"textureCoord")}}getUniformLocations(e,o,t){let r=[];if(o)for(let n of o)r.push({name:n,type:"sampler2D",location:this.getUniformLocation(e,n)});if(t)for(let n of t)r.push({...n,location:this.getUniformLocation(e,n.name)});return r}getUniformLocation(e,o){let r=this.glContext.gl.getUniformLocation(e,o);if(r===null)throw new Error(`Uniform ${o} not found.`);return r}getAttribLocation(e,o){return this.glContext.gl.getAttribLocation(e,o)}}});var _r,fl=x(()=>{"use strict";ct();Ae();_r=class{constructor(e,o,t,r){this.glContext=e;this.layoutStrategy=o;this.profiler=t;this.config=r;this.pendingRead=new Map;r.reuseTextures&&(this.inUseTextures=new Map,this.idleTextures=new Map,this.textureLookup=new Map)}createTextureFromLayout(e,o,t,r){let n=this.toEncoderType(e),s=this.glContext.getEncoder(n,o.channels||1,r);if(o.isPacked&&r===1)throw new Error("not implemented");let i=o.width,u=o.height,l,f;if(this.config.reuseTextures){l=`${i}x${u}_${s.format}_${s.internalFormat}_${s.textureType}`,f=this.inUseTextures.get(l),f||(f=[],this.inUseTextures.set(l,f));let d=this.idleTextures.get(l);if(d&&d.length>0){let m=d.pop();return f.push(m),r===1&&this.glContext.updateTexture(m,i,u,s,this.toTextureData(e,t)),m}}M.verbose("TextureManager",`Creating new texture of size ${o.width}x${o.height}`);let p=this.glContext.allocateTexture(i,u,s,this.toTextureData(e,t));return this.config.reuseTextures&&(f.push(p),this.textureLookup.set(p,l)),p}readTexture(e,o,t){return t||(t=1),this.profiler.event("backend","TextureManager.readTexture",()=>{let r=e.shape.reduce((s,i)=>s*i)*t,n=this.glContext.readTexture(e.texture,e.width,e.height,r,this.toEncoderType(o),t);return this.toTensorData(o,n)})}async readTextureAsync(e,o,t){let r=e.tensor.dataId;if(t||(t=1),this.pendingRead.has(r)){let n=this.pendingRead.get(r);return new Promise(s=>n?.push(s))}return this.profiler.event("backend","TextureManager.readTextureAsync",async()=>{this.pendingRead.set(r,[]);let n=e.shape.reduce((l,f)=>l*f)*t;await this.glContext.createAndWaitForFence();let s=this.glContext.readTexture(e.texture,e.width,e.height,n,this.toEncoderType(o),t),i=this.toTensorData(o,s),u=this.pendingRead.get(r);return this.pendingRead.delete(r),u?.forEach(l=>l(i)),i})}readUint8TextureAsFloat(e){return this.profiler.event("backend","TextureManager.readUint8TextureAsFloat",()=>{let o=e.shape.reduce((r,n)=>r*n),t=this.glContext.readTexture(e.texture,e.width,e.height,o*4,"byte",4);return new Float32Array(t.buffer,t.byteOffset,o)})}releaseTexture(e,o){let t;if(this.config.reuseTextures&&(t=this.textureLookup.get(e.texture),t)){o&&this.textureLookup.delete(t);let r=this.inUseTextures.get(t);if(r){let n=r.indexOf(e.texture);if(n!==-1){r.splice(n,1);let s=this.idleTextures.get(t);s||(s=[],this.idleTextures.set(t,s)),s.push(e.texture)}}}(!t||o)&&(M.verbose("TextureManager",`Deleting texture of size ${e.width}x${e.height}`),this.glContext.deleteTexture(e.texture))}toTensorData(e,o){switch(e){case"int16":return o instanceof Int16Array?o:Int16Array.from(o);case"int32":return o instanceof Int32Array?o:Int32Array.from(o);case"int8":return o instanceof Int8Array?o:Int8Array.from(o);case"uint16":return o instanceof Uint16Array?o:Uint16Array.from(o);case"uint32":return o instanceof Uint32Array?o:Uint32Array.from(o);case"uint8":case"bool":return o instanceof Uint8Array?o:Uint8Array.from(o);case"float32":return o instanceof Float32Array?o:Float32Array.from(o);case"float64":return o instanceof Float64Array?o:Float64Array.from(o);default:throw new Error(`TensorData type ${e} is not supported`)}}toTextureData(e,o){if(o)return o instanceof Float32Array?o:new Float32Array(o)}toEncoderType(e){return"float"}clearActiveTextures(){this.glContext.clearActiveTextures()}}});var Sr,cl=x(()=>{"use strict";ct();Oo();na();Zu();ll();Cn();fl();Sr=class{constructor(e,o){this.backend=e;this.context=o;this.layoutStrategy=new br(e.glContext.maxTextureSize),this.programManager=new Ir(this.context.profiler,e.glContext,this.layoutStrategy),this.textureManager=new _r(e.glContext,this.layoutStrategy,this.context.profiler,{reuseTextures:e.textureCacheMode==="full"}),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache=new Map,this.pack=e.pack,this.pack2unpackMap=new Map,this.unpack2packMap=new Map}createInferenceHandler(){return new ir(this)}onGraphInitialized(e){let o=e.getValues().filter(t=>t.from===-1&&t.tensor).map(t=>t.tensor.dataId);this.initializers=new Set(o)}isInitializer(e){return this.initializers?this.initializers.has(e):!1}addInitializer(e){this.initializers.add(e)}getTextureData(e,o){return o?this.packedTextureDataCache.get(e):this.unpackedTextureDataCache.get(e)}setTextureData(e,o,t=!1){M.verbose("WebGLSessionHandler","Storing Texture data in cache"),t?this.packedTextureDataCache.set(e,o):this.unpackedTextureDataCache.set(e,o)}dispose(){this.programManager.dispose(),this.textureManager.clearActiveTextures(),this.packedTextureDataCache.forEach(e=>this.textureManager.releaseTexture(e,!0)),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache.forEach(e=>this.textureManager.releaseTexture(e,!0)),this.unpackedTextureDataCache=new Map}resolve(e,o,t){let r=So(e,o,Ju);return{impl:r.opImpl,context:r.opInit?r.opInit(e,t):e}}}});function Jp(a){let e=0;for(;e<a.length&&a[e]();++e);return e-1}var $e,pl=x(()=>{"use strict";Bt();Ae();Ae();At();$e=class{constructor(e,o){this.frameBufferBound=!1;this.itemsToPoll=[];this.gl=e,this.version=o,this.getExtensions(),this.vertexbuffer=this.createVertexbuffer(),this.framebuffer=this.createFramebuffer(),this.queryVitalParameters()}allocateTexture(e,o,t,r){let n=this.gl,s=n.createTexture();n.bindTexture(n.TEXTURE_2D,s),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,n.NEAREST),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,n.NEAREST),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE);let i=r?t.encode(r,e*o):null;return n.texImage2D(n.TEXTURE_2D,0,t.internalFormat,e,o,0,t.format,t.textureType,i),this.checkError(),s}updateTexture(e,o,t,r,n){let s=this.gl;s.bindTexture(s.TEXTURE_2D,e);let i=r.encode(n,o*t);s.texSubImage2D(s.TEXTURE_2D,0,0,0,o,t,r.format,r.textureType,i),this.checkError()}attachFramebuffer(e,o,t){let r=this.gl;r.bindTexture(r.TEXTURE_2D,e),r.bindFramebuffer(r.FRAMEBUFFER,this.framebuffer),r.framebufferTexture2D(r.FRAMEBUFFER,r.COLOR_ATTACHMENT0,r.TEXTURE_2D,e,0),this.checkError(),r.viewport(0,0,o,t),r.scissor(0,0,o,t)}readTexture(e,o,t,r,n,s){let i=this.gl;s||(s=1),this.frameBufferBound||this.attachFramebuffer(e,o,t);let u=this.getEncoder(n,s),l=u.allocate(o*t);return i.bindTexture(i.TEXTURE_2D,e),i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,e,0),i.readPixels(0,0,o,t,i.RGBA,u.textureType,l),this.checkError(),u.decode(l,r)}isFramebufferReady(){return!0}getActiveTexture(){let e=this.gl;return`TEXTURE${e.getParameter(this.gl.ACTIVE_TEXTURE)-e.TEXTURE0}`}getTextureBinding(){return this.gl.getParameter(this.gl.TEXTURE_BINDING_2D)}getFramebufferBinding(){return this.gl.getParameter(this.gl.FRAMEBUFFER_BINDING)}setVertexAttributes(e,o){let t=this.gl;t.vertexAttribPointer(e,3,t.FLOAT,!1,20,0),t.enableVertexAttribArray(e),o!==-1&&(t.vertexAttribPointer(o,2,t.FLOAT,!1,20,12),t.enableVertexAttribArray(o)),this.checkError()}createProgram(e,o){let t=this.gl,r=t.createProgram();return t.attachShader(r,e),t.attachShader(r,o),t.linkProgram(r),r}compileShader(e,o){let t=this.gl,r=t.createShader(o);if(!r)throw new Error(`createShader() returned null with type ${o}`);if(t.shaderSource(r,e),t.compileShader(r),t.getShaderParameter(r,t.COMPILE_STATUS)===!1)throw new Error(`Failed to compile shader: ${t.getShaderInfoLog(r)}
Shader source:
${e}`);return r}deleteShader(e){this.gl.deleteShader(e)}bindTextureToUniform(e,o,t){let r=this.gl;r.activeTexture(r.TEXTURE0+o),this.checkError(),r.bindTexture(r.TEXTURE_2D,e),this.checkError(),r.uniform1i(t,o),this.checkError()}draw(){this.gl.drawArrays(this.gl.TRIANGLE_STRIP,0,4),this.checkError()}checkError(){if(j.debug){let e=this.gl,o=e.getError(),t="";switch(o){case e.NO_ERROR:return;case e.INVALID_ENUM:t="INVALID_ENUM";break;case e.INVALID_VALUE:t="INVALID_VALUE";break;case e.INVALID_OPERATION:t="INVALID_OPERATION";break;case e.INVALID_FRAMEBUFFER_OPERATION:t="INVALID_FRAMEBUFFER_OPERATION";break;case e.OUT_OF_MEMORY:t="OUT_OF_MEMORY";break;case e.CONTEXT_LOST_WEBGL:t="CONTEXT_LOST_WEBGL";break;default:t=`Unknown WebGL Error: ${o.toString(16)}`}throw new Error(t)}}deleteTexture(e){this.gl.deleteTexture(e)}deleteProgram(e){this.gl.deleteProgram(e)}getEncoder(e,o,t=0){if(this.version===2)return new nr(this.gl,o);switch(e){case"float":return t===1||this.isRenderFloat32Supported?new Oe(this.gl,o):new Oe(this.gl,o,this.textureHalfFloatExtension.HALF_FLOAT_OES);case"int":throw new Error("not implemented");case"byte":return new or(this.gl,o);default:throw new Error(`Invalid dataType: ${e}`)}}clearActiveTextures(){let e=this.gl;for(let o=0;o<this.maxTextureImageUnits;++o)e.activeTexture(e.TEXTURE0+o),e.bindTexture(e.TEXTURE_2D,null)}dispose(){if(this.disposed)return;let e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteFramebuffer(this.framebuffer),e.bindBuffer(e.ARRAY_BUFFER,null),e.deleteBuffer(this.vertexbuffer),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null),e.finish(),this.disposed=!0}createDefaultGeometry(){return new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0])}createVertexbuffer(){let e=this.gl,o=e.createBuffer();if(!o)throw new Error("createBuffer() returned null");let t=this.createDefaultGeometry();return e.bindBuffer(e.ARRAY_BUFFER,o),e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW),this.checkError(),o}createFramebuffer(){let e=this.gl.createFramebuffer();if(!e)throw new Error("createFramebuffer returned null");return e}queryVitalParameters(){let e=this.gl;if(this.isFloatTextureAttachableToFrameBuffer=this.checkFloatTextureAttachableToFrameBuffer(),this.isRenderFloat32Supported=this.checkRenderFloat32(),this.isFloat32DownloadSupported=this.checkFloat32Download(),this.version===1&&!this.textureHalfFloatExtension&&!this.isRenderFloat32Supported)throw new Error("both float32 and float16 TextureType are not supported");this.isBlendSupported=!this.isRenderFloat32Supported||this.checkFloat32Blend(),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),this.maxTextureImageUnits=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS),this.version}getExtensions(){this.version===2?(this.colorBufferFloatExtension=this.gl.getExtension("EXT_color_buffer_float"),this.disjointTimerQueryWebgl2Extension=this.gl.getExtension("EXT_disjoint_timer_query_webgl2")):(this.textureFloatExtension=this.gl.getExtension("OES_texture_float"),this.textureHalfFloatExtension=this.gl.getExtension("OES_texture_half_float"))}checkFloatTextureAttachableToFrameBuffer(){let e=this.gl,o=e.createTexture();e.bindTexture(e.TEXTURE_2D,o);let t=this.version===2?e.RGBA32F:e.RGBA;e.texImage2D(e.TEXTURE_2D,0,t,1,1,0,e.RGBA,e.FLOAT,null);let r=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,r),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,o,0);let n=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(o),e.deleteFramebuffer(r),n}checkRenderFloat32(){if(this.version===2){if(!this.colorBufferFloatExtension)return!1}else if(!this.textureFloatExtension)return!1;return this.isFloatTextureAttachableToFrameBuffer}checkFloat32Download(){if(this.version===2){if(!this.colorBufferFloatExtension)return!1}else if(!this.textureFloatExtension||!this.gl.getExtension("WEBGL_color_buffer_float"))return!1;return this.isFloatTextureAttachableToFrameBuffer}checkFloat32Blend(){let e=this.gl,o,t,r,n,s;try{o=e.createTexture(),t=e.createFramebuffer(),e.bindTexture(e.TEXTURE_2D,o);let i=this.version===2?e.RGBA32F:e.RGBA;return e.texImage2D(e.TEXTURE_2D,0,i,1,1,0,e.RGBA,e.FLOAT,null),e.bindFramebuffer(e.FRAMEBUFFER,t),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,o,0),e.enable(e.BLEND),r=e.createShader(e.VERTEX_SHADER),!r||(e.shaderSource(r,"void main(){}"),e.compileShader(r),n=e.createShader(e.FRAGMENT_SHADER),!n)||(e.shaderSource(n,"precision highp float;void main(){gl_FragColor=vec4(0.5);}"),e.compileShader(n),s=e.createProgram(),!s)?!1:(e.attachShader(s,r),e.attachShader(s,n),e.linkProgram(s),e.useProgram(s),e.drawArrays(e.POINTS,0,1),e.getError()===e.NO_ERROR)}finally{e.disable(e.BLEND),s&&e.deleteProgram(s),r&&e.deleteShader(r),n&&e.deleteShader(n),t&&(e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteFramebuffer(t)),o&&(e.bindTexture(e.TEXTURE_2D,null),e.deleteTexture(o))}}beginTimer(){if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let e=this.gl,o=this.disjointTimerQueryWebgl2Extension,t=e.createQuery();return e.beginQuery(o.TIME_ELAPSED_EXT,t),t}else throw new Error("WebGL1 profiling currently not supported.")}endTimer(){if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let e=this.gl,o=this.disjointTimerQueryWebgl2Extension;e.endQuery(o.TIME_ELAPSED_EXT);return}else throw new Error("WebGL1 profiling currently not supported")}isTimerResultAvailable(e){let o=!1,t=!1;if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let r=this.gl,n=this.disjointTimerQueryWebgl2Extension;o=r.getQueryParameter(e,r.QUERY_RESULT_AVAILABLE),t=r.getParameter(n.GPU_DISJOINT_EXT)}else throw new Error("WebGL1 profiling currently not supported");return o&&!t}getTimerResult(e){let o=0;if(this.version===2){let t=this.gl;o=t.getQueryParameter(e,t.QUERY_RESULT),t.deleteQuery(e)}else throw new Error("WebGL1 profiling currently not supported");return o/1e6}async waitForQueryAndGetTime(e){return await ln(()=>this.isTimerResultAvailable(e)),this.getTimerResult(e)}async createAndWaitForFence(){let e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let o,t=e,r=t.fenceSync(t.SYNC_GPU_COMMANDS_COMPLETE,0);return e.flush(),r===null?o=()=>!0:o=()=>{let n=t.clientWaitSync(r,0,0);return n===t.ALREADY_SIGNALED||n===t.CONDITION_SATISFIED},{query:r,isFencePassed:o}}async pollFence(e){return new Promise(o=>{this.addItemToPoll(()=>e.isFencePassed(),()=>o())})}pollItems(){let e=Jp(this.itemsToPoll.map(o=>o.isDoneFn));for(let o=0;o<=e;++o){let{resolveFn:t}=this.itemsToPoll[o];t()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}async addItemToPoll(e,o){this.itemsToPoll.push({isDoneFn:e,resolveFn:o}),!(this.itemsToPoll.length>1)&&await ln(()=>(this.pollItems(),this.itemsToPoll.length===0))}}});function Rn(a){let e;if((!a||a==="webgl2")&&"webgl2"in he?e=he.webgl2:(!a||a==="webgl")&&"webgl"in he&&(e=he.webgl),!e)try{let t=Yp();e=dl(t,a)}catch{let r=Zp();e=dl(r,a)}a=a||e.version===1?"webgl":"webgl2";let o=e.gl;return he[a]=e,o.isContextLost()?(delete he[a],Rn(a)):(o.disable(o.DEPTH_TEST),o.disable(o.STENCIL_TEST),o.disable(o.BLEND),o.disable(o.DITHER),o.disable(o.POLYGON_OFFSET_FILL),o.disable(o.SAMPLE_COVERAGE),o.enable(o.SCISSOR_TEST),o.enable(o.CULL_FACE),o.cullFace(o.BACK),e)}function dl(a,e){let o={alpha:!1,depth:!1,antialias:!1,stencil:!1,preserveDrawingBuffer:!1,premultipliedAlpha:!1,failIfMajorPerformanceCaveat:!1},t,r=o;if((!e||e==="webgl2")&&(t=a.getContext("webgl2",r),t))try{return new $e(t,2)}catch(n){M.warning("GlContextFactory",`failed to create WebGLContext using contextId 'webgl2'. Error: ${n}`)}if((!e||e==="webgl")&&(t=a.getContext("webgl",r)||a.getContext("experimental-webgl",r),t))try{return new $e(t,1)}catch(n){M.warning("GlContextFactory",`failed to create WebGLContext using contextId 'webgl' or 'experimental-webgl'. Error: ${n}`)}throw new Error("WebGL is not supported")}function Zp(){if(typeof document>"u")throw new TypeError("failed to create canvas: document is not supported");let a=document.createElement("canvas");return a.width=1,a.height=1,a}function Yp(){if(typeof OffscreenCanvas>"u")throw new TypeError("failed to create offscreen canvas: OffscreenCanvas is not supported");return new OffscreenCanvas(1,1)}var he,hl=x(()=>{"use strict";ct();pl();he={}});var Or,ml=x(()=>{"use strict";Bt();ct();cl();hl();Or=class{get contextId(){return j.webgl.contextId}set contextId(e){j.webgl.contextId=e}get matmulMaxBatchSize(){return j.webgl.matmulMaxBatchSize}set matmulMaxBatchSize(e){j.webgl.matmulMaxBatchSize=e}get textureCacheMode(){return j.webgl.textureCacheMode}set textureCacheMode(e){j.webgl.textureCacheMode=e}get pack(){return j.webgl.pack}set pack(e){j.webgl.pack=e}get async(){return j.webgl.async}set async(e){j.webgl.async=e}initialize(){try{return this.glContext=Rn(this.contextId),typeof this.matmulMaxBatchSize!="number"&&(this.matmulMaxBatchSize=16),typeof this.textureCacheMode!="string"&&(this.textureCacheMode="full"),typeof this.pack!="boolean"&&(this.pack=!1),typeof this.async!="boolean"&&(this.async=!1),M.setWithEnv(j),j.webgl.context||Object.defineProperty(j.webgl,"context",{value:this.glContext.gl}),M.verbose("WebGLBackend",`Created WebGLContext: ${typeof this.glContext} with matmulMaxBatchSize: ${this.matmulMaxBatchSize}; textureCacheMode: ${this.textureCacheMode}; pack: ${this.pack}; async: ${this.async}.`),!0}catch(e){return M.warning("WebGLBackend",`Unable to initialize WebGLBackend. ${e}`),!1}}createSessionHandler(e){return new Sr(this,e)}dispose(){this.glContext.dispose()}}});async function Vn(a){if(a){let e=typeof a=="string"?[a]:a;for(let o of e){let t=bl.get(o);if(t)return t;let r=await td(o);if(r)return r}}else return Vn(["webgl"]);throw new Error("no available backend to use")}async function td(a){let e=Qp;if(typeof e[a]<"u"&&ed(e[a])){let o=e[a],t=o.initialize();if(typeof t=="object"&&"then"in t&&(t=await t),t)return bl.set(a,o),o}}function ed(a){let e=a;return"initialize"in e&&typeof e.initialize=="function"&&"createSessionHandler"in e&&typeof e.createSessionHandler=="function"&&"dispose"in e&&typeof e.dispose=="function"}var bl,Qp,yl=x(()=>{"use strict";ml();bl=new Map,Qp={webgl:new Or}});var zn,Ar,gl=x(()=>{"use strict";ct();zn=class{constructor(e,o){this.op=e;this.node=o}},Ar=class{constructor(e,o,t){this.graph=e;this.profiler=t;this.initialize(o)}initialize(e){this.profiler.event("session","ExecutionPlan.initialize",()=>{let o=this.graph.getNodes();if(o.length!==e.length)throw new Error("The size of nodes and OPs do not match.");this._ops=e.map((t,r)=>new zn(t,o[r])),this.reset(),this._starter=[],this._ops.forEach((t,r)=>{let n=!0;for(let s of t.node.inputs)if(!this._values[s]&&this.graph.getInputIndices().indexOf(s)===-1){n=!1;break}n&&this._starter.push(r)})})}reset(){this._values=this.graph.getValues().map(e=>e.tensor)}async execute(e,o){return this.profiler.event("session","ExecutionPlan.execute",async()=>{this.reset();let t=e.createInferenceHandler(),r=this.graph.getInputIndices();if(o.length!==r.length)throw new Error(`number of input tensors don't match the number of inputs to the model: actual: ${o.length} expected: ${r.length}`);o.forEach((f,p)=>{let d=r[p];this._values[d]=f});let n=this._starter.slice(0),s=this.graph.getValues(),i=this.graph.getNodes(),u=0;for(;u<n.length;){let f=n[u++],p=this._ops[f],d=p.node.inputs.map(v=>this._values[v]);if(d.indexOf(void 0)!==-1)throw new Error(`unresolved input detected: op: ${p.node}`);let m=d;M.verbose("ExecPlan",`Runing op:${p.node.name} (${m.map((v,_)=>`'${p.node.inputs[_]}': ${v.type}[${v.dims.join(",")}]`).join(", ")})`);let g=await this.profiler.event("node",p.node.name,async()=>p.op.impl(t,m,p.op.context));if(g.length!==p.node.outputs.length)throw new Error("the size of output does not match model definition.");g.forEach((v,_)=>{let O=p.node.outputs[_];if(this._values[O])throw new Error(`output [${O}] already has value: op:${p.node.name}`);this._values[O]=v});let y=new Set;g.forEach((v,_)=>{let O=p.node.outputs[_];for(let S of s[O].to){let C=i[S],F=!0;for(let st of C.inputs)if(!this._values[st]){F=!1;break}F&&y.add(S)}}),n.push(...y)}let l=[];for(let f=0;f<this.graph.getOutputIndices().length;f++){let p=this.graph.getOutputIndices()[f],d=this._values[p];if(d===void 0)throw new Error(`required output [${p}] does not have value`);p===0?await d.getData():d.data,l.push(d)}return M.verbose("ExecPlan","disposing of inferenceHandler"),t.dispose(),l})}}});var B,gt,ke,xl=x(()=>{"use strict";Te();B=re(ae());Zt();z();gt=P.experimental.fbs,ke=class a{constructor(e){if(this._attributes=new Map,e!=null){for(let o of e)o instanceof B.onnx.AttributeProto?this._attributes.set(o.name,[a.getValue(o),a.getType(o)]):o instanceof gt.Attribute&&this._attributes.set(o.name(),[a.getValue(o),a.getType(o)]);if(this._attributes.size<e.length)throw new Error("duplicated attribute names")}}set(e,o,t){this._attributes.set(e,[t,o])}delete(e){this._attributes.delete(e)}getFloat(e,o){return this.get(e,"float",o)}getInt(e,o){return this.get(e,"int",o)}getString(e,o){return this.get(e,"string",o)}getTensor(e,o){return this.get(e,"tensor",o)}getFloats(e,o){return this.get(e,"floats",o)}getInts(e,o){return this.get(e,"ints",o)}getStrings(e,o){return this.get(e,"strings",o)}getTensors(e,o){return this.get(e,"tensors",o)}get(e,o,t){let r=this._attributes.get(e);if(r===void 0){if(t!==void 0)return t;throw new Error(`required attribute not found: ${e}`)}if(r[1]!==o)throw new Error(`type mismatch: expected ${o} but got ${r[1]}`);return r[0]}static getType(e){let o=e instanceof B.onnx.AttributeProto?e.type:e.type();switch(o){case B.onnx.AttributeProto.AttributeType.FLOAT:return"float";case B.onnx.AttributeProto.AttributeType.INT:return"int";case B.onnx.AttributeProto.AttributeType.STRING:return"string";case B.onnx.AttributeProto.AttributeType.TENSOR:return"tensor";case B.onnx.AttributeProto.AttributeType.FLOATS:return"floats";case B.onnx.AttributeProto.AttributeType.INTS:return"ints";case B.onnx.AttributeProto.AttributeType.STRINGS:return"strings";case B.onnx.AttributeProto.AttributeType.TENSORS:return"tensors";default:throw new Error(`attribute type is not supported yet: ${B.onnx.AttributeProto.AttributeType[o]}`)}}static getValue(e){let o=e instanceof B.onnx.AttributeProto?e.type:e.type();if(o===B.onnx.AttributeProto.AttributeType.GRAPH||o===B.onnx.AttributeProto.AttributeType.GRAPHS)throw new Error("graph attribute is not supported yet");let t=this.getValueNoCheck(e);if(o===B.onnx.AttributeProto.AttributeType.INT&&ft.isLong(t))return ft.longToNumber(t);if(o===B.onnx.AttributeProto.AttributeType.INTS){let r=t,n=new Array(r.length);for(let s=0;s<r.length;s++){let i=r[s];n[s]=ft.longToNumber(i)}return n}if(o===B.onnx.AttributeProto.AttributeType.TENSOR)return e instanceof B.onnx.AttributeProto?Y.fromProto(t):Y.fromOrtTensor(t);if(o===B.onnx.AttributeProto.AttributeType.TENSORS){if(e instanceof B.onnx.AttributeProto)return t.map(n=>Y.fromProto(n));if(e instanceof gt.Attribute)return t.map(n=>Y.fromOrtTensor(n))}return o===B.onnx.AttributeProto.AttributeType.STRING&&e instanceof B.onnx.AttributeProto?Se(t):o===B.onnx.AttributeProto.AttributeType.STRINGS&&e instanceof B.onnx.AttributeProto?t.map(Se):t}static getValueNoCheck(e){return e instanceof B.onnx.AttributeProto?this.getValueNoCheckFromOnnxFormat(e):this.getValueNoCheckFromOrtFormat(e)}static getValueNoCheckFromOnnxFormat(e){switch(e.type){case B.onnx.AttributeProto.AttributeType.FLOAT:return e.f;case B.onnx.AttributeProto.AttributeType.INT:return e.i;case B.onnx.AttributeProto.AttributeType.STRING:return e.s;case B.onnx.AttributeProto.AttributeType.TENSOR:return e.t;case B.onnx.AttributeProto.AttributeType.GRAPH:return e.g;case B.onnx.AttributeProto.AttributeType.FLOATS:return e.floats;case B.onnx.AttributeProto.AttributeType.INTS:return e.ints;case B.onnx.AttributeProto.AttributeType.STRINGS:return e.strings;case B.onnx.AttributeProto.AttributeType.TENSORS:return e.tensors;case B.onnx.AttributeProto.AttributeType.GRAPHS:return e.graphs;default:throw new Error(`unsupported attribute type: ${B.onnx.AttributeProto.AttributeType[e.type]}`)}}static getValueNoCheckFromOrtFormat(e){switch(e.type()){case gt.AttributeType.FLOAT:return e.f();case gt.AttributeType.INT:return e.i();case gt.AttributeType.STRING:return e.s();case gt.AttributeType.TENSOR:return e.t();case gt.AttributeType.GRAPH:return e.g();case gt.AttributeType.FLOATS:return e.floatsArray();case gt.AttributeType.INTS:{let o=[];for(let t=0;t<e.intsLength();t++)o.push(e.ints(t));return o}case gt.AttributeType.STRINGS:{let o=[];for(let t=0;t<e.stringsLength();t++)o.push(e.strings(t));return o}case gt.AttributeType.TENSORS:{let o=[];for(let t=0;t<e.tensorsLength();t++)o.push(e.tensors(t));return o}default:throw new Error(`unsupported attribute type: ${gt.AttributeType[e.type()]}`)}}}});var Un,Pr,Wn,Dt,Er,Mn,Tl=x(()=>{"use strict";xl();Te();Un=re(ae());Zt();z();Pr=P.experimental.fbs,Wn={from:(a,e)=>new Mn(a,e)},Dt=class{constructor(e){this._from=void 0,this._to=[],this.tensor=void 0,this.type=void 0,e&&(this.type=et.tensorValueTypeFromProto(e.type.tensorType))}get from(){return this._from}get to(){return this._to}},Er=class{constructor(e,o){e instanceof Un.onnx.NodeProto?(this.name=e.name,this.opType=e.opType,this.attributes=new ke(e.attribute)):e instanceof Pr.Node&&(this.name=o??e.name(),this.opType=e.opType(),this.attributes=new ke(et.tensorAttributesFromORTFormat(e))),this.inputs=[],this.outputs=[],this.executeNode=!0}},Mn=class{constructor(e,o){if(!e)throw new TypeError("graph is empty");this.buildGraph(e),this.transformGraph(o),this.checkIsAcyclic()}getInputIndices(){return this._allInputIndices}getInputNames(){return this._allInputNames}getOutputIndices(){return this._allOutputIndices}getOutputNames(){return this._allOutputNames}getValues(){return this._allData}getNodes(){return this._nodes}buildGraph(e){if(e instanceof Un.onnx.GraphProto)this.buildGraphFromOnnxFormat(e);else if(e instanceof Pr.Graph)this.buildGraphFromOrtFormat(e);else throw new TypeError("Graph type is not supported.")}buildGraphFromOnnxFormat(e){let o=new Map;this._allData=[],this._allInputIndices=[],this._allInputNames=[],this._allOutputIndices=[],this._allOutputNames=[],this._nodes=[];let t=new Map;if(!e.input)throw new Error("missing information in graph: input");let r=[];for(let n of e.input){if(o.has(n.name))throw new Error(`duplicated input name: ${n.name}`);let s=this._allData.push(new Dt(n))-1;o.set(n.name,s),r.push(n.name)}if(!e.initializer)throw new Error("missing information in graph: initializer");for(let n of e.initializer){let s=o.get(n.name);if(s===void 0){let i=new Dt;i.type={shape:{dims:et.tensorDimsFromProto(n.dims)},tensorType:et.tensorDataTypeFromProto(n.dataType)},s=this._allData.push(i)-1,o.set(n.name,s)}this._allData[s]._from=-1,this._allData[s].tensor=Y.fromProto(n)}for(let n=0;n<this._allData.length;n++)this._allData[n].tensor||(this._allInputIndices.push(n),this._allInputNames.push(r[n]));if(!e.output)throw new Error("missing information in graph: output");for(let n of e.output){if(o.has(n.name))throw new Error(`duplicated output name: ${n.name}`);let s=this._allData.push(new Dt(n))-1;o.set(n.name,s),this._allOutputIndices.push(s),this._allOutputNames.push(n.name)}if(!e.node)throw new Error("missing information in graph: node");for(let n of e.node){if(!n.name)for(let i=0;;i++){let u=`unnamed_${n.opType}_${i}`;if(!t.has(u)){n.name=u;break}}if(t.has(n.name))throw new Error(`duplicated node name: ${n.name}`);let s=this._nodes.push(new Er(n))-1;t.set(n.name,s)}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=e.node[n];if(!i.output)throw new Error(`missing output for node: ${i.name}`);for(let u of i.output){let l=o.get(u);if(typeof l>"u"&&(l=this._allData.push(new Dt)-1,o.set(u,l)),s.outputs.push(l),this._allData[l]._from!==void 0)throw new Error(`multiple nodes output to one data value: ${l}`);if(this._allData[l]._from=n,i.opType==="Constant"){if(!i.attribute||i.attribute.length!==1||!i.attribute[0].t)throw new Error("missing attributes or missing tensor value in attributes for this Constant operator");if(!i.output||i.output.length!==1)throw new Error("missing output or incorrect number of outputs for this Constant operator");s.outputs.pop(),s.executeNode=!1,this._allData[l]._from=-1,this._allData[l].tensor=Y.fromProto(i.attribute[0].t)}}}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=e.node[n];if(!i.input)throw new Error(`missing input for node: ${i.name}`);for(let u of i.input){let l=o.get(u);if(typeof l>"u"){if(u===""&&(i.input.length===3||i.input.length===4)&&i.opType==="Resize")continue;throw new Error(`unrecognized input '${u}' for node: ${i.name}`)}s.inputs.push(l),this._allData[l]._to.push(n)}}return!0}buildGraphFromOrtFormat(e){let o=new Map;this._allData=[],this._allInputIndices=[],this._allInputNames=[],this._allOutputIndices=[],this._allOutputNames=[],this._nodes=[];let t=new Map,r=[];for(let n=0;n<e.inputsLength();n++){let s=e.inputs(n);if(o.has(s))throw new Error(`duplicated input name: ${s}`);for(let i=0;i<e.nodeArgsLength();i++)if(e.nodeArgs(i)?.name()===s){let u=new Dt;if(e.nodeArgs(i)?.type()?.valueType()!==Pr.TypeInfoValue.tensor_type)throw new Error("Unexpected value type for the nodeArg.");let f=e.nodeArgs(i).type().value(new Pr.TensorTypeAndShape),p=et.tensorDataTypeFromProto(f.elemType()),d=f.shape(),m=[];for(let y=0;y<d.dimLength();y++)m.push(ft.longToNumber(d.dim(y).value().dimValue()));u.type={shape:{dims:m},tensorType:p};let g=this._allData.push(u)-1;o.set(s,g),r.push(s)}}for(let n=0;n<e.initializersLength();n++){let s=e.initializers(n),i=o.get(s.name());if(i===void 0){let u=new Dt,l=et.tensorDimsFromORTFormat(s),f=et.tensorDataTypeFromProto(s.dataType());u.type={shape:{dims:l},tensorType:f},i=this._allData.push(u)-1,o.set(s.name(),i)}this._allData[i]._from=-1,this._allData[i].tensor=Y.fromOrtTensor(s)}for(let n=0;n<this._allData.length;n++)this._allData[n].tensor||(this._allInputIndices.push(n),this._allInputNames.push(r[n]));for(let n=0;n<e.outputsLength();n++){let s=e.outputs(n);if(o.has(s))throw new Error(`duplicated output name: ${s}`);let i=this._allData.push(new Dt)-1;o.set(s,i),this._allOutputIndices.push(i),this._allOutputNames.push(s)}if(!e.nodes)throw new Error("missing information in graph: node");for(let n=0;n<e.nodesLength();n++){let s=e.nodes(n),i=s.name();if(!i)for(let l=0;i=`unnamed_${s.opType()}_${l}`,!!t.has(i);l++);if(t.has(i))throw new Error(`duplicated node name: ${i}`);let u=this._nodes.push(new Er(s,i))-1;t.set(i,u)}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=e.nodes(n);if(i==null)throw new Error(`No node exists at index ${n}`);if(i?.outputsLength()===0)throw new Error(`missing output for node: ${i.name}`);for(let u=0;u<i?.outputsLength();u++){let l=i?.outputs(u),f=o.get(l);if(typeof f>"u"&&(f=this._allData.push(new Dt)-1,o.set(l,f)),s.outputs.push(f),this._allData[f]._from!==void 0)throw new Error(`multiple nodes output to one data value: ${f}`);if(this._allData[f]._from=n,i.opType()==="Constant"){if(i.attributesLength()!==1||!i.attributes(0).t())throw new Error("missing attributes or missing tensor value in attributes for this Constant operator");if(i.outputsLength()!==1)throw new Error("missing output or incorrect number of outputs for this Constant operator");s.outputs.pop(),s.executeNode=!1,this._allData[f]._from=-1,this._allData[f].tensor=Y.fromOrtTensor(i.attributes(0).t())}}}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=e.nodes(n);if(i.inputsLength()===0)throw new Error(`missing input for node: ${i.name}`);for(let u=0;u<i.inputsLength();u++){let l=i.inputs(u),f=o.get(l);if(typeof f>"u")throw new Error(`unrecognized input '${l}' for node: ${i.name()}`);s.inputs.push(f),this._allData[f]._to.push(n)}}}checkIsAcyclic(){let e=new Set;this._allInputIndices.forEach(r=>{this._allData[r]._to.forEach(s=>{e.add(s)})});let o=Array.from(e),t=new Array(this._nodes.length).fill("white");for(;o.length>0;){let r=o.pop();t[r]==="gray"?t[r]="black":(o.push(r),t[r]="gray",this._nodes[r].outputs.forEach(n=>{let s=this._allData[n];if(typeof s.tensor<"u")throw new Error("node outputs should not be initialized");if(s._from!==r)throw new Error("from property of the Value object doesn't match index of Node being processed");s._to.forEach(i=>{if(t[i]==="gray")throw new Error("model graph is cyclic");t[i]==="white"&&o.push(i)})}))}}transformGraph(e){this.removeAllIdentityNodes(),this.removeAllDropoutNodes(),this.fuseConvActivationNodes(),e&&e.transformGraph(this),this.finalizeGraph()}finalizeGraph(){let e=0,o=new Array(this._nodes.length,0),t=0;for(let r=0;r<this._nodes.length;r++)o[r]=t,this._nodes[r].executeNode?(t!==r&&(this._nodes[t]=this._nodes[r]),t++):this._nodes[r].outputs.forEach(n=>{this._allData[n]._from=-2});this._nodes.splice(t,this._nodes.length-t);for(let r=0;r<this._allData.length;r++){let n=this._allData[r];n._from!==void 0&&n._from!==-1&&n._from!==-2&&(n._from=o[n._from]);for(let s=0;s<n._to.length;s++)if(n._to[s]>=0)n._to[s]=o[n._to[s]];else throw new Error("Trying to update a removed node")}e=0;for(let r=0;r<this._allData.length;r++){if(this._allData[r].from===-2&&this._allOutputIndices.indexOf(r+e)===-1){e++,this._allData.splice(r,1),r--;continue}if(e>0){let n=-1;this._allData[r].from!==void 0&&this._allData[r].from!==-1?(n=this._nodes[this._allData[r].from].outputs.indexOf(r+e),n!==-1&&(this._nodes[this._allData[r].from].outputs[n]=r)):(n=this._allInputIndices.indexOf(r+e),n!==-1&&(this._allInputIndices[n]=r)),this._allData[r].to.forEach(s=>{n=this._nodes[s].inputs.indexOf(r+e),n!==-1&&(this._nodes[s].inputs[n]=r)}),this._allData[r].to.length===0&&(n=this._allOutputIndices.indexOf(r+e),n!==-1&&(this._allOutputIndices[n]=r))}}}deleteNode(e){let o=this._nodes[e];if(o.outputs.length>1){for(let i=1;i<o.outputs.length;i++)if(this._allData[o.outputs[i]].to.length>0)throw new Error("Node deletion with more than one output connected to other nodes is not supported. ")}o.executeNode=!1;let t=o.inputs[0],r=o.outputs[0],n=this._allData[r].to;for(let i=0;i<o.inputs.length;i++){let u=this._allData[o.inputs[i]].to.indexOf(e);if(u===-1)throw new Error("The Value object doesn't have the current Node in it's 'to' property ");this._allData[o.inputs[i]].to.splice(u,1)}this._allData[r]._to=[];let s=this._allOutputIndices.indexOf(r);if(s!==-1&&(this._allOutputIndices[s]=t),n&&n.length>0)for(let i of n){let u=this._nodes[i].inputs.indexOf(r);if(u===-1)throw new Error("The Node object doesn't have the output Value in it's 'inputs' property ");this._nodes[i].inputs[u]=t,this._allData[t].to.push(i)}}removeAllDropoutNodes(){let e=0;for(let o of this._nodes){if(o.opType==="Dropout"){if(o.inputs.length!==1)throw new Error("Dropout nodes should only contain one input. ");if(o.outputs.length!==1&&o.outputs.length!==2)throw new Error("Dropout nodes should contain either 1 or 2 output(s)");if(o.outputs.length===2&&this._allData[o.outputs[1]]._to.length!==0)throw new Error("Dropout nodes's second output should not be referenced by other nodes");this.deleteNode(e)}e++}}removeAllIdentityNodes(){let e=0;for(let o of this._nodes)o.opType==="Identity"&&this.deleteNode(e),e++}isActivation(e){switch(e.opType){case"Relu":case"Sigmoid":case"Clip":return!0;default:return!1}}fuseConvActivationNodes(){for(let e of this._nodes)if(e.opType==="Conv"){let o=this._allData[e.outputs[0]]._to;if(o.length===1&&this.isActivation(this._nodes[o[0]])){let t=this._nodes[o[0]];if(t.opType==="Clip")if(t.inputs.length===1)try{e.attributes.set("activation_params","floats",[t.attributes.getFloat("min"),t.attributes.getFloat("max")])}catch{e.attributes.set("activation_params","floats",[Xt,Jt])}else if(t.inputs.length>=3&&this._allData[t.inputs[1]].tensor!==void 0&&this._allData[t.inputs[2]].tensor!==void 0)e.attributes.set("activation_params","floats",[this._allData[t.inputs[1]].tensor.floatData[0],this._allData[t.inputs[2]].tensor.floatData[0]]);else continue;e.attributes.set("activation","string",t.opType),this.deleteNode(o[0])}}}}});var vl,rd,Dr,wl=x(()=>{"use strict";Je();Tl();Te();vl=re(ae());z();rd=P.experimental.fbs,Dr=class{constructor(){}load(e,o,t){if(!t)try{this.loadFromOnnxFormat(e,o);return}catch(r){if(t!==void 0)throw r}this.loadFromOrtFormat(e,o)}loadFromOnnxFormat(e,o){let t=vl.onnx.ModelProto.decode(e);if(ft.longToNumber(t.irVersion)<3)throw new Error("only support ONNX model with IR_VERSION>=3");this._opsets=t.opsetImport.map(n=>({domain:n.domain,version:ft.longToNumber(n.version)})),this._graph=Wn.from(t.graph,o)}loadFromOrtFormat(e,o){let t=new b.ByteBuffer(e),r=rd.InferenceSession.getRootAsInferenceSession(t).model();if(ft.longToNumber(r.irVersion())<3)throw new Error("only support ONNX model with IR_VERSION>=3");this._opsets=[];for(let s=0;s<r.opsetImportLength();s++){let i=r.opsetImport(s);this._opsets.push({domain:i?.domain(),version:ft.longToNumber(i.version())})}this._graph=Wn.from(r.graph(),o)}get graph(){return this._graph}get opsets(){return this._opsets}}});var Lr,Il=x(()=>{"use strict";yl();gl();ct();wl();Lr=class{constructor(e={}){this._initialized=!1,this.backendHint=e.backendHint,this.profiler=Ke.create(e.profiler),this.context={profiler:this.profiler,graphInputTypes:[],graphInputDims:[]}}get inputNames(){return this._model.graph.getInputNames()}get outputNames(){return this._model.graph.getOutputNames()}startProfiling(){this.profiler.start()}endProfiling(){this.profiler.stop()}async loadModel(e,o,t){await this.profiler.event("session","Session.loadModel",async()=>{let r=await Vn(this.backendHint);if(this.sessionHandler=r.createSessionHandler(this.context),this._model=new Dr,typeof e=="string"){let n=e.endsWith(".ort");if(typeof process<"u"&&process.versions&&process.versions.node){let s=await(void 0)(e);this.initialize(s,n)}else{let i=await(await fetch(e)).arrayBuffer();this.initialize(new Uint8Array(i),n)}}else if(ArrayBuffer.isView(e))this.initialize(e);else{let n=new Uint8Array(e,o||0,t||e.byteLength);this.initialize(n)}})}initialize(e,o){if(this._initialized)throw new Error("already initialized");this.profiler.event("session","Session.initialize",()=>{let t=this.sessionHandler.transformGraph?this.sessionHandler:void 0;this._model.load(e,t,o),this.sessionHandler.onGraphInitialized&&this.sessionHandler.onGraphInitialized(this._model.graph),this.initializeOps(this._model.graph),this._executionPlan=new Ar(this._model.graph,this._ops,this.profiler)}),this._initialized=!0}async run(e){if(!this._initialized)throw new Error("session not initialized yet");return this.profiler.event("session","Session.run",async()=>{let o=this.normalizeAndValidateInputs(e),t=await this._executionPlan.execute(this.sessionHandler,o);return this.createOutput(t)})}normalizeAndValidateInputs(e){let o=this._model.graph.getInputNames();if(Array.isArray(e)){if(e.length!==o.length)throw new Error(`incorrect input array length: expected ${o.length} but got ${e.length}`)}else{if(e.size!==o.length)throw new Error(`incorrect input map size: expected ${o.length} but got ${e.size}`);let t=new Array(e.size),r=0;for(let n=0;n<o.length;++n){let s=e.get(o[n]);if(!s)throw new Error(`missing input tensor for: '${name}'`);t[r++]=s}e=t}if(!this.context.graphInputTypes||this.context.graphInputTypes.length===0||!this.context.graphInputDims||this.context.graphInputDims.length===0){let t=this._model.graph.getInputIndices(),r=this._model.graph.getValues(),n=new Array(t.length);for(let s=0;s<t.length;++s){let i=r[t[s]];n[s]=i.type.shape.dims,this.context.graphInputTypes.push(i.type.tensorType),this.context.graphInputDims.push(e[s].dims)}this.validateInputTensorDims(n,e,!0)}else this.validateInputTensorDims(this.context.graphInputDims,e,!1);return this.validateInputTensorTypes(this.context.graphInputTypes,e),e}validateInputTensorTypes(e,o){for(let t=0;t<o.length;t++){let r=e[t],n=o[t].type;if(r!==n)throw new Error(`input tensor[${t}] check failed: expected type '${r}' but got ${n}`)}}validateInputTensorDims(e,o,t){for(let r=0;r<o.length;r++){let n=e[r],s=o[r].dims;if(!this.compareTensorDims(n,s,t))throw new Error(`input tensor[${r}] check failed: expected shape '[${n.join(",")}]' but got [${s.join(",")}]`)}}compareTensorDims(e,o,t){if(e.length!==o.length)return!1;for(let r=0;r<e.length;++r)if(e[r]!==o[r]&&(!t||e[r]!==0))return!1;return!0}createOutput(e){let o=this._model.graph.getOutputNames();if(e.length!==o.length)throw new Error("expected number of outputs do not match number of generated outputs");let t=new Map;for(let r=0;r<o.length;++r)t.set(o[r],e[r]);return t}initializeOps(e){let o=e.getNodes();this._ops=new Array(o.length);for(let t=0;t<o.length;t++)this._ops[t]=this.sessionHandler.resolve(o[t],this._model.opsets,e)}}});var $r,_l=x(()=>{"use strict";Bt();Zt();$r=class{constructor(e){this.session=e;this.inputNames=this.session.inputNames,this.outputNames=this.session.outputNames}async dispose(){}async run(e,o,t){let r=new Map;for(let i in e)if(Object.hasOwnProperty.call(e,i)){let u=e[i];r.set(i,new Y(u.dims,u.type,void 0,void 0,u.data))}let n=await this.session.run(r),s={};return n.forEach((i,u)=>{s[u]=new rt(i.type,i.data,i.dims)}),s}startProfiling(){this.session.startProfiling()}endProfiling(){this.session.endProfiling()}}});var Sl={};Br(Sl,{onnxjsBackend:()=>nd});var Hn,nd,Ol=x(()=>{"use strict";Il();_l();Hn=class{async init(){}async createInferenceSessionHandler(e,o){let t=new Lr(o);return typeof e=="string"?await t.loadModel(e):await t.loadModel(e),new $r(t)}},nd=new Hn});var id={};Br(id,{InferenceSession:()=>bo,TRACE:()=>Cr,TRACE_FUNC_BEGIN:()=>ye,TRACE_FUNC_END:()=>ge,Tensor:()=>rt,TrainingSession:()=>To,default:()=>od,env:()=>j,registerBackend:()=>me});Bt();Bt();Bt();var wo="1.17.1";var od=Rr;{let a=(Ol(),jn(Sl)).onnxjsBackend;me("webgl",a,-10)}Object.defineProperty(j.versions,"web",{value:wo,enumerable:!0});return jn(id);})();
/*! Bundled license information:

long/index.js:
  (**
   * @license
   * Copyright 2009 The Closure Library Authors
   * Copyright 2020 Daniel Wirtz / The long.js Authors.
   *
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   *
   * SPDX-License-Identifier: Apache-2.0
   *)
*/
//# sourceMappingURL=ort.webgl.min.js.map
