/*!
 * ONNX Runtime Web v1.17.1
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
"use strict";var ort=(()=>{var _d=Object.create;var En=Object.defineProperty;var Od=Object.getOwnPropertyDescriptor;var Id=Object.getOwnPropertyNames;var Sd=Object.getPrototypeOf,Ad=Object.prototype.hasOwnProperty;var L=(a,t)=>()=>(a&&(t=a(a=0)),t);var me=(a,t)=>()=>(t||a((t={exports:{}}).exports,t),t.exports),ar=(a,t)=>{for(var o in t)En(a,o,{get:t[o],enumerable:!0})},qa=(a,t,o,e)=>{if(t&&typeof t=="object"||typeof t=="function")for(let r of Id(t))!Ad.call(a,r)&&r!==o&&En(a,r,{get:()=>t[r],enumerable:!(e=Od(t,r))||e.enumerable});return a};var Er=(a,t,o)=>(o=a!=null?_d(Sd(a)):{},qa(t||!a||!a.__esModule?En(o,"default",{value:a,enumerable:!0}):o,a)),jt=a=>qa(En({},"__esModule",{value:!0}),a);var Dn,sr,Yt,Ln,Fn=L(()=>{"use strict";Dn=new Map,sr=[],Yt=(a,t,o)=>{if(t&&typeof t.init=="function"&&typeof t.createInferenceSessionHandler=="function"){let e=Dn.get(a);if(e===void 0)Dn.set(a,{backend:t,priority:o});else{if(e.priority>o)return;if(e.priority===o&&e.backend!==t)throw new Error(`cannot register backend "${a}" using priority ${o}`)}if(o>=0){let r=sr.indexOf(a);r!==-1&&sr.splice(r,1);for(let n=0;n<sr.length;n++)if(Dn.get(sr[n]).priority<=o){sr.splice(n,0,a);return}sr.push(a)}return}throw new TypeError("not a valid backend")},Ln=async a=>{let t=a.length===0?sr:a,o=[];for(let e of t){let r=Dn.get(e);if(r){if(r.initialized)return r.backend;if(r.aborted)continue;let n=!!r.initPromise;try{return n||(r.initPromise=r.backend.init(e)),await r.initPromise,r.initialized=!0,r.backend}catch(s){n||o.push({name:e,err:s}),r.aborted=!0}finally{delete r.initPromise}}}throw new Error(`no available backend found. ERR: ${o.map(e=>`[${e.name}] ${e.err}`).join(", ")}`)}});var ja=L(()=>{"use strict";Fn()});var Ya,Xa=L(()=>{"use strict";Ya="1.17.1"});var Ka,ur,Ho=L(()=>{"use strict";Xa();Ka="warning",ur={wasm:{},webgl:{},webgpu:{},versions:{common:Ya},set logLevel(a){if(a!==void 0){if(typeof a!="string"||["verbose","info","warning","error","fatal"].indexOf(a)===-1)throw new Error(`Unsupported logging level: ${a}`);Ka=a}},get logLevel(){return Ka}};Object.defineProperty(ur,"logLevel",{enumerable:!0})});var Z,Ja=L(()=>{"use strict";Ho();Z=ur});var Za,Qa,es=L(()=>{"use strict";Za=(a,t)=>{let o=typeof document<"u"?document.createElement("canvas"):new OffscreenCanvas(1,1);o.width=a.dims[3],o.height=a.dims[2];let e=o.getContext("2d");if(e!=null){let r,n;t?.tensorLayout!==void 0&&t.tensorLayout==="NHWC"?(r=a.dims[2],n=a.dims[3]):(r=a.dims[3],n=a.dims[2]);let s=t?.format!==void 0?t.format:"RGB",i=t?.norm,u,l;i===void 0||i.mean===void 0?u=[255,255,255,255]:typeof i.mean=="number"?u=[i.mean,i.mean,i.mean,i.mean]:(u=[i.mean[0],i.mean[1],i.mean[2],0],i.mean[3]!==void 0&&(u[3]=i.mean[3])),i===void 0||i.bias===void 0?l=[0,0,0,0]:typeof i.bias=="number"?l=[i.bias,i.bias,i.bias,i.bias]:(l=[i.bias[0],i.bias[1],i.bias[2],0],i.bias[3]!==void 0&&(l[3]=i.bias[3]));let f=n*r,p=0,d=f,T=f*2,O=-1;s==="RGBA"?(p=0,d=f,T=f*2,O=f*3):s==="RGB"?(p=0,d=f,T=f*2):s==="RBG"&&(p=0,T=f,d=f*2);for(let v=0;v<n;v++)for(let S=0;S<r;S++){let E=(a.data[p++]-l[0])*u[0],F=(a.data[d++]-l[1])*u[1],B=(a.data[T++]-l[2])*u[2],K=O===-1?255:(a.data[O++]-l[3])*u[3];e.fillStyle="rgba("+E+","+F+","+B+","+K+")",e.fillRect(S,v,1,1)}if("toDataURL"in o)return o.toDataURL();throw new Error("toDataURL is not supported")}else throw new Error("Can not access image data")},Qa=(a,t)=>{let o=typeof document<"u"?document.createElement("canvas").getContext("2d"):new OffscreenCanvas(1,1).getContext("2d"),e;if(o!=null){let r,n,s;t?.tensorLayout!==void 0&&t.tensorLayout==="NHWC"?(r=a.dims[2],n=a.dims[1],s=a.dims[3]):(r=a.dims[3],n=a.dims[2],s=a.dims[1]);let i=t!==void 0&&t.format!==void 0?t.format:"RGB",u=t?.norm,l,f;u===void 0||u.mean===void 0?l=[255,255,255,255]:typeof u.mean=="number"?l=[u.mean,u.mean,u.mean,u.mean]:(l=[u.mean[0],u.mean[1],u.mean[2],255],u.mean[3]!==void 0&&(l[3]=u.mean[3])),u===void 0||u.bias===void 0?f=[0,0,0,0]:typeof u.bias=="number"?f=[u.bias,u.bias,u.bias,u.bias]:(f=[u.bias[0],u.bias[1],u.bias[2],0],u.bias[3]!==void 0&&(f[3]=u.bias[3]));let p=n*r;if(t!==void 0&&(t.format!==void 0&&s===4&&t.format!=="RGBA"||s===3&&t.format!=="RGB"&&t.format!=="BGR"))throw new Error("Tensor format doesn't match input tensor dims");let d=4,T=0,O=1,v=2,S=3,E=0,F=p,B=p*2,K=-1;i==="RGBA"?(E=0,F=p,B=p*2,K=p*3):i==="RGB"?(E=0,F=p,B=p*2):i==="RBG"&&(E=0,B=p,F=p*2),e=o.createImageData(r,n);for(let j=0;j<n*r;T+=d,O+=d,v+=d,S+=d,j++)e.data[T]=(a.data[E++]-f[0])*l[0],e.data[O]=(a.data[F++]-f[1])*l[1],e.data[v]=(a.data[B++]-f[2])*l[2],e.data[S]=K===-1?255:(a.data[K++]-f[3])*l[3]}else throw new Error("Can not access image data");return e}});var qo,ts,rs,ns,os,is=L(()=>{"use strict";$n();qo=(a,t)=>{if(a===void 0)throw new Error("Image buffer must be defined");if(t.height===void 0||t.width===void 0)throw new Error("Image height and width must be defined");if(t.tensorLayout==="NHWC")throw new Error("NHWC Tensor layout is not supported yet");let{height:o,width:e}=t,r=t.norm??{mean:255,bias:0},n,s;typeof r.mean=="number"?n=[r.mean,r.mean,r.mean,r.mean]:n=[r.mean[0],r.mean[1],r.mean[2],r.mean[3]??255],typeof r.bias=="number"?s=[r.bias,r.bias,r.bias,r.bias]:s=[r.bias[0],r.bias[1],r.bias[2],r.bias[3]??0];let i=t.format!==void 0?t.format:"RGBA",u=t.tensorFormat!==void 0&&t.tensorFormat!==void 0?t.tensorFormat:"RGB",l=o*e,f=u==="RGBA"?new Float32Array(l*4):new Float32Array(l*3),p=4,d=0,T=1,O=2,v=3,S=0,E=l,F=l*2,B=-1;i==="RGB"&&(p=3,d=0,T=1,O=2,v=-1),u==="RGBA"?B=l*3:u==="RBG"?(S=0,F=l,E=l*2):u==="BGR"&&(F=0,E=l,S=l*2);for(let j=0;j<l;j++,d+=p,O+=p,T+=p,v+=p)f[S++]=(a[d]+s[0])/n[0],f[E++]=(a[T]+s[1])/n[1],f[F++]=(a[O]+s[2])/n[2],B!==-1&&v!==-1&&(f[B++]=(a[v]+s[3])/n[3]);return u==="RGBA"?new Ye("float32",f,[1,4,o,e]):new Ye("float32",f,[1,3,o,e])},ts=async(a,t)=>{let o=typeof HTMLImageElement<"u"&&a instanceof HTMLImageElement,e=typeof ImageData<"u"&&a instanceof ImageData,r=typeof ImageBitmap<"u"&&a instanceof ImageBitmap,n=typeof a=="string",s,i=t??{},u=()=>{if(typeof document<"u")return document.createElement("canvas");if(typeof OffscreenCanvas<"u")return new OffscreenCanvas(1,1);throw new Error("Canvas is not supported")},l=f=>f instanceof HTMLCanvasElement||f instanceof OffscreenCanvas?f.getContext("2d"):null;if(o){let f=u();f.width=a.width,f.height=a.height;let p=l(f);if(p!=null){let d=a.height,T=a.width;if(t!==void 0&&t.resizedHeight!==void 0&&t.resizedWidth!==void 0&&(d=t.resizedHeight,T=t.resizedWidth),t!==void 0){if(i=t,t.tensorFormat!==void 0)throw new Error("Image input config format must be RGBA for HTMLImageElement");i.tensorFormat="RGBA",i.height=d,i.width=T}else i.tensorFormat="RGBA",i.height=d,i.width=T;p.drawImage(a,0,0),s=p.getImageData(0,0,T,d).data}else throw new Error("Can not access image data")}else if(e){let f,p;if(t!==void 0&&t.resizedWidth!==void 0&&t.resizedHeight!==void 0?(f=t.resizedHeight,p=t.resizedWidth):(f=a.height,p=a.width),t!==void 0&&(i=t),i.format="RGBA",i.height=f,i.width=p,t!==void 0){let d=u();d.width=p,d.height=f;let T=l(d);if(T!=null)T.putImageData(a,0,0),s=T.getImageData(0,0,p,f).data;else throw new Error("Can not access image data")}else s=a.data}else if(r){if(t===void 0)throw new Error("Please provide image config with format for Imagebitmap");let f=u();f.width=a.width,f.height=a.height;let p=l(f);if(p!=null){let d=a.height,T=a.width;return p.drawImage(a,0,0,T,d),s=p.getImageData(0,0,T,d).data,i.height=d,i.width=T,qo(s,i)}else throw new Error("Can not access image data")}else{if(n)return new Promise((f,p)=>{let d=u(),T=l(d);if(!a||!T)return p();let O=new Image;O.crossOrigin="Anonymous",O.src=a,O.onload=()=>{d.width=O.width,d.height=O.height,T.drawImage(O,0,0,d.width,d.height);let v=T.getImageData(0,0,d.width,d.height);i.height=d.height,i.width=d.width,f(qo(v.data,i))}});throw new Error("Input data provided is not supported - aborted tensor creation")}if(s!==void 0)return qo(s,i);throw new Error("Input data provided is not supported - aborted tensor creation")},rs=(a,t)=>{let{width:o,height:e,download:r,dispose:n}=t,s=[1,e,o,4];return new Ye({location:"texture",type:"float32",texture:a,dims:s,download:r,dispose:n})},ns=(a,t)=>{let{dataType:o,dims:e,download:r,dispose:n}=t;return new Ye({location:"gpu-buffer",type:o??"float32",gpuBuffer:a,dims:e,download:r,dispose:n})},os=(a,t,o)=>new Ye({location:"cpu-pinned",type:a,data:t,dims:o??[t.length]})});var Qr,Cn,as,ss,us=L(()=>{"use strict";Qr=new Map([["float32",Float32Array],["uint8",Uint8Array],["int8",Int8Array],["uint16",Uint16Array],["float16",Uint16Array],["int16",Int16Array],["int32",Int32Array],["bool",Uint8Array],["float64",Float64Array],["uint32",Uint32Array]]),Cn=new Map([[Float32Array,"float32"],[Uint8Array,"uint8"],[Int8Array,"int8"],[Uint16Array,"uint16"],[Int16Array,"int16"],[Int32Array,"int32"],[Float64Array,"float64"],[Uint32Array,"uint32"]]),as=!1,ss=()=>{if(!as){as=!0;let a=typeof BigInt64Array<"u"&&typeof BigInt64Array.from=="function",t=typeof BigUint64Array<"u"&&typeof BigUint64Array.from=="function";a&&(Qr.set("int64",BigInt64Array),Cn.set(BigInt64Array,"int64")),t&&(Qr.set("uint64",BigUint64Array),Cn.set(BigUint64Array,"uint64"))}}});var ls,fs,cs=L(()=>{"use strict";$n();ls=a=>{let t=1;for(let o=0;o<a.length;o++){let e=a[o];if(typeof e!="number"||!Number.isSafeInteger(e))throw new TypeError(`dims[${o}] must be an integer, got: ${e}`);if(e<0)throw new RangeError(`dims[${o}] must be a non-negative integer, got: ${e}`);t*=e}return t},fs=(a,t)=>{switch(a.location){case"cpu":return new Ye(a.type,a.data,t);case"cpu-pinned":return new Ye({location:"cpu-pinned",data:a.data,type:a.type,dims:t});case"texture":return new Ye({location:"texture",texture:a.texture,type:a.type,dims:t});case"gpu-buffer":return new Ye({location:"gpu-buffer",gpuBuffer:a.gpuBuffer,type:a.type,dims:t});default:throw new Error(`tensorReshape: tensor location ${a.location} is not supported`)}}});var Ye,$n=L(()=>{"use strict";es();is();us();cs();Ye=class{constructor(t,o,e){ss();let r,n;if(typeof t=="object"&&"location"in t)switch(this.dataLocation=t.location,r=t.type,n=t.dims,t.location){case"cpu-pinned":{let i=Qr.get(r);if(!i)throw new TypeError(`unsupported type "${r}" to create tensor from pinned buffer`);if(!(t.data instanceof i))throw new TypeError(`buffer should be of type ${i.name}`);this.cpuData=t.data;break}case"texture":{if(r!=="float32")throw new TypeError(`unsupported type "${r}" to create tensor from texture`);this.gpuTextureData=t.texture,this.downloader=t.download,this.disposer=t.dispose;break}case"gpu-buffer":{if(r!=="float32"&&r!=="float16"&&r!=="int32"&&r!=="int64"&&r!=="uint32"&&r!=="bool")throw new TypeError(`unsupported type "${r}" to create tensor from gpu buffer`);this.gpuBufferData=t.gpuBuffer,this.downloader=t.download,this.disposer=t.dispose;break}default:throw new Error(`Tensor constructor: unsupported location '${this.dataLocation}'`)}else{let i,u;if(typeof t=="string")if(r=t,u=e,t==="string"){if(!Array.isArray(o))throw new TypeError("A string tensor's data must be a string array.");i=o}else{let l=Qr.get(t);if(l===void 0)throw new TypeError(`Unsupported tensor type: ${t}.`);if(Array.isArray(o)){if(t==="float16")throw new TypeError("Creating a float16 tensor from number array is not supported. Please use Uint16Array as data.");t==="uint64"||t==="int64"?i=l.from(o,BigInt):i=l.from(o)}else if(o instanceof l)i=o;else throw new TypeError(`A ${r} tensor's data must be type of ${l}`)}else if(u=o,Array.isArray(t)){if(t.length===0)throw new TypeError("Tensor type cannot be inferred from an empty array.");let l=typeof t[0];if(l==="string")r="string",i=t;else if(l==="boolean")r="bool",i=Uint8Array.from(t);else throw new TypeError(`Invalid element type of data array: ${l}.`)}else{let l=Cn.get(t.constructor);if(l===void 0)throw new TypeError(`Unsupported type for tensor data: ${t.constructor}.`);r=l,i=t}if(u===void 0)u=[i.length];else if(!Array.isArray(u))throw new TypeError("A tensor's dims must be a number array");n=u,this.cpuData=i,this.dataLocation="cpu"}let s=ls(n);if(this.cpuData&&s!==this.cpuData.length)throw new Error(`Tensor's size(${s}) does not match data length(${this.cpuData.length}).`);this.type=r,this.dims=n,this.size=s}static async fromImage(t,o){return ts(t,o)}static fromTexture(t,o){return rs(t,o)}static fromGpuBuffer(t,o){return ns(t,o)}static fromPinnedBuffer(t,o,e){return os(t,o,e)}toDataURL(t){return Za(this,t)}toImageData(t){return Qa(this,t)}get data(){if(this.ensureValid(),!this.cpuData)throw new Error("The data is not on CPU. Use `getData()` to download GPU data to CPU, or use `texture` or `gpuBuffer` property to access the GPU data directly.");return this.cpuData}get location(){return this.dataLocation}get texture(){if(this.ensureValid(),!this.gpuTextureData)throw new Error("The data is not stored as a WebGL texture.");return this.gpuTextureData}get gpuBuffer(){if(this.ensureValid(),!this.gpuBufferData)throw new Error("The data is not stored as a WebGPU buffer.");return this.gpuBufferData}async getData(t){switch(this.ensureValid(),this.dataLocation){case"cpu":case"cpu-pinned":return this.data;case"texture":case"gpu-buffer":{if(!this.downloader)throw new Error("The current tensor is not created with a specified data downloader.");if(this.isDownloading)throw new Error("The current tensor is being downloaded.");try{this.isDownloading=!0;let o=await this.downloader();return this.downloader=void 0,this.dataLocation="cpu",this.cpuData=o,t&&this.disposer&&(this.disposer(),this.disposer=void 0),o}finally{this.isDownloading=!1}}default:throw new Error(`cannot get data from location: ${this.dataLocation}`)}}dispose(){if(this.isDownloading)throw new Error("The current tensor is being downloaded.");this.disposer&&(this.disposer(),this.disposer=void 0),this.cpuData=void 0,this.gpuTextureData=void 0,this.gpuBufferData=void 0,this.downloader=void 0,this.isDownloading=void 0,this.dataLocation="none"}ensureValid(){if(this.dataLocation==="none")throw new Error("The tensor is disposed.")}reshape(t){if(this.ensureValid(),this.downloader||this.disposer)throw new Error("Cannot reshape a tensor that owns GPU resource.");return fs(this,t)}}});var ke,kn=L(()=>{"use strict";$n();ke=Ye});var jo,ps,Xt,Kt,Yo=L(()=>{"use strict";Ho();jo=(a,t)=>{ur.wasm.trace&&console.timeStamp(`${a}::ORT::${t}`)},ps=(a,t)=>{let o=new Error().stack?.split(/\r\n|\r|\n/g)||[],e=!1;for(let r=0;r<o.length;r++){if(e&&!o[r].includes("TRACE_FUNC")){let n=`FUNC_${a}::${o[r].trim().split(" ")[1]}`;t&&(n+=`::${t}`),jo("CPU",n);return}o[r].includes("TRACE_FUNC")&&(e=!0)}},Xt=a=>{ur.wasm.trace&&ps("BEGIN",a)},Kt=a=>{ur.wasm.trace&&ps("END",a)}});var Bn,ds=L(()=>{"use strict";Fn();kn();Yo();Bn=class a{constructor(t){this.handler=t}async run(t,o,e){Xt();let r={},n={};if(typeof t!="object"||t===null||t instanceof ke||Array.isArray(t))throw new TypeError("'feeds' must be an object that use input names as keys and OnnxValue as corresponding values.");let s=!0;if(typeof o=="object"){if(o===null)throw new TypeError("Unexpected argument[1]: cannot be null.");if(o instanceof ke)throw new TypeError("'fetches' cannot be a Tensor");if(Array.isArray(o)){if(o.length===0)throw new TypeError("'fetches' cannot be an empty array.");s=!1;for(let l of o){if(typeof l!="string")throw new TypeError("'fetches' must be a string array or an object.");if(this.outputNames.indexOf(l)===-1)throw new RangeError(`'fetches' contains invalid output name: ${l}.`);r[l]=null}if(typeof e=="object"&&e!==null)n=e;else if(typeof e<"u")throw new TypeError("'options' must be an object.")}else{let l=!1,f=Object.getOwnPropertyNames(o);for(let p of this.outputNames)if(f.indexOf(p)!==-1){let d=o[p];(d===null||d instanceof ke)&&(l=!0,s=!1,r[p]=d)}if(l){if(typeof e=="object"&&e!==null)n=e;else if(typeof e<"u")throw new TypeError("'options' must be an object.")}else n=o}}else if(typeof o<"u")throw new TypeError("Unexpected argument[1]: must be 'fetches' or 'options'.");for(let l of this.inputNames)if(typeof t[l]>"u")throw new Error(`input '${l}' is missing in 'feeds'.`);if(s)for(let l of this.outputNames)r[l]=null;let i=await this.handler.run(t,r,n),u={};for(let l in i)if(Object.hasOwnProperty.call(i,l)){let f=i[l];f instanceof ke?u[l]=f:u[l]=new ke(f.type,f.data,f.dims)}return Kt(),u}async release(){return this.handler.dispose()}static async create(t,o,e,r){Xt();let n,s={};if(typeof t=="string"){if(n=t,typeof o=="object"&&o!==null)s=o;else if(typeof o<"u")throw new TypeError("'options' must be an object.")}else if(t instanceof Uint8Array){if(n=t,typeof o=="object"&&o!==null)s=o;else if(typeof o<"u")throw new TypeError("'options' must be an object.")}else if(t instanceof ArrayBuffer||typeof SharedArrayBuffer<"u"&&t instanceof SharedArrayBuffer){let p=t,d=0,T=t.byteLength;if(typeof o=="object"&&o!==null)s=o;else if(typeof o=="number"){if(d=o,!Number.isSafeInteger(d))throw new RangeError("'byteOffset' must be an integer.");if(d<0||d>=p.byteLength)throw new RangeError(`'byteOffset' is out of range [0, ${p.byteLength}).`);if(T=t.byteLength-d,typeof e=="number"){if(T=e,!Number.isSafeInteger(T))throw new RangeError("'byteLength' must be an integer.");if(T<=0||d+T>p.byteLength)throw new RangeError(`'byteLength' is out of range (0, ${p.byteLength-d}].`);if(typeof r=="object"&&r!==null)s=r;else if(typeof r<"u")throw new TypeError("'options' must be an object.")}else if(typeof e<"u")throw new TypeError("'byteLength' must be a number.")}else if(typeof o<"u")throw new TypeError("'options' must be an object.");n=new Uint8Array(p,d,T)}else throw new TypeError("Unexpected argument[0]: must be 'path' or 'buffer'.");let u=(s.executionProviders||[]).map(p=>typeof p=="string"?p:p.name),f=await(await Ln(u)).createInferenceSessionHandler(n,s);return Kt(),new a(f)}startProfiling(){this.handler.startProfiling()}endProfiling(){this.handler.endProfiling()}get inputNames(){return this.handler.inputNames}get outputNames(){return this.handler.outputNames}}});var hs,ms=L(()=>{"use strict";ds();hs=Bn});var bs=L(()=>{"use strict"});var Pd,Nn,gs=L(()=>{"use strict";Fn();kn();Pd="Training backend could not be resolved. Make sure you're using the correct configuration & WebAssembly files.",Nn=class a{constructor(t,o,e){this.handler=t,this.hasOptimizerModel=o,this.hasEvalModel=e}get trainingInputNames(){return this.handler.inputNames}get trainingOutputNames(){return this.handler.outputNames}get evalInputNames(){if(this.hasEvalModel)return this.handler.evalInputNames;throw new Error("This training session has no evalModel loaded.")}get evalOutputNames(){if(this.hasEvalModel)return this.handler.evalOutputNames;throw new Error("This training session has no evalModel loaded.")}static async create(t,o){let e=t.evalModel||"",r=t.optimizerModel||"",n=o||{},i=(n.executionProviders||[]).map(l=>typeof l=="string"?l:l.name),u=await Ln(i);if(u.createTrainingSessionHandler){let l=await u.createTrainingSessionHandler(t.checkpointState,t.trainModel,e,r,n);return new a(l,!!t.optimizerModel,!!t.evalModel)}else throw new Error(Pd)}typeNarrowingForRunStep(t,o,e,r,n){let s={},i={};if(typeof e!="object"||e===null||e instanceof ke||Array.isArray(e))throw new TypeError("'feeds' must be an object that use input names as keys and OnnxValue as corresponding values.");let u=!0;if(typeof r=="object"){if(r===null)throw new TypeError("Unexpected argument[1]: cannot be null.");if(r instanceof ke)throw new TypeError("'fetches' cannot be a Tensor");if(Array.isArray(r)){if(r.length===0)throw new TypeError("'fetches' cannot be an empty array.");u=!1;for(let l of r){if(typeof l!="string")throw new TypeError("'fetches' must be a string array or an object.");if(o.indexOf(l)===-1)throw new RangeError(`'fetches' contains invalid output name: ${l}.`);s[l]=null}if(typeof n=="object"&&n!==null)i=n;else if(typeof n<"u")throw new TypeError("'options' must be an object.")}else{let l=!1,f=Object.getOwnPropertyNames(r);for(let p of o)if(f.indexOf(p)!==-1){let d=r[p];(d===null||d instanceof ke)&&(l=!0,u=!1,s[p]=d)}if(l){if(typeof n=="object"&&n!==null)i=n;else if(typeof n<"u")throw new TypeError("'options' must be an object.")}else i=r}}else if(typeof r<"u")throw new TypeError("Unexpected argument[1]: must be 'fetches' or 'options'.");for(let l of t)if(typeof e[l]>"u")throw new Error(`input '${l}' is missing in 'feeds'.`);if(u)for(let l of o)s[l]=null;return[s,i]}convertHandlerReturnTypeToMapOfTensors(t){let o={};for(let e in t)if(Object.hasOwnProperty.call(t,e)){let r=t[e];r instanceof ke?o[e]=r:o[e]=new ke(r.type,r.data,r.dims)}return o}async lazyResetGrad(){await this.handler.lazyResetGrad()}async runTrainStep(t,o,e){let[r,n]=this.typeNarrowingForRunStep(this.trainingInputNames,this.trainingOutputNames,t,o,e),s=await this.handler.runTrainStep(t,r,n);return this.convertHandlerReturnTypeToMapOfTensors(s)}async runOptimizerStep(t){if(this.hasOptimizerModel)await this.handler.runOptimizerStep(t||{});else throw new Error("This TrainingSession has no OptimizerModel loaded.")}async runEvalStep(t,o,e){if(this.hasEvalModel){let[r,n]=this.typeNarrowingForRunStep(this.evalInputNames,this.evalOutputNames,t,o,e),s=await this.handler.runEvalStep(t,r,n);return this.convertHandlerReturnTypeToMapOfTensors(s)}else throw new Error("This TrainingSession has no EvalModel loaded.")}async getParametersSize(t=!0){return this.handler.getParametersSize(t)}async loadParametersBuffer(t,o=!0){let e=await this.getParametersSize(o);if(t.length!==4*e)throw new Error("Size of the buffer passed into loadParametersBuffer must match the number of parameters in the model. Please use getParametersSize method to check.");return this.handler.loadParametersBuffer(t,o)}async getContiguousParameters(t=!0){return this.handler.getContiguousParameters(t)}async release(){return this.handler.dispose()}}});var ys,Ts=L(()=>{"use strict";gs();ys=Nn});var Xo={};ar(Xo,{InferenceSession:()=>hs,TRACE:()=>jo,TRACE_FUNC_BEGIN:()=>Xt,TRACE_FUNC_END:()=>Kt,Tensor:()=>ke,TrainingSession:()=>ys,env:()=>Z,registerBackend:()=>Yt});var vt=L(()=>{"use strict";ja();Ja();ms();kn();Yo();bs();Ts()});function Jt(a,t,o,e){if(t===void 0)return Dd(a);if(o===void 0)Rn(a,t,1);else if(typeof o=="number"&&e===void 0)Rn(a,t,o);else if(typeof o=="string"&&e===void 0)Rn(a,o,1,t);else if(typeof o=="string"&&typeof e=="number")Rn(a,o,e,t);else throw new TypeError("input is valid")}function Dd(a){return{verbose:Jt.verbose.bind(null,a),info:Jt.info.bind(null,a),warning:Jt.warning.bind(null,a),error:Jt.error.bind(null,a),fatal:Jt.fatal.bind(null,a)}}function Rn(a,t,o,e){let r=en[e||""]||en[""];vs[a]<vs[r.minimalSeverity]||(r.logDateTime&&(t=`${new Date().toISOString()}|${t}`),r.logSourceLocation,Ed[r.provider].log(a,t,e))}var Ko,Jo,vs,Ed,ws,en,ce,Gn,Un,zn,Mn,ut=L(()=>{"use strict";Ko=class{log(t,o,e){}},Jo=class{log(t,o,e){console.log(`${this.color(t)} ${e?"\x1B[35m"+e+"\x1B[0m ":""}${o}`)}color(t){switch(t){case"verbose":return"\x1B[34;40mv\x1B[0m";case"info":return"\x1B[32mi\x1B[0m";case"warning":return"\x1B[30;43mw\x1B[0m";case"error":return"\x1B[31;40me\x1B[0m";case"fatal":return"\x1B[101mf\x1B[0m";default:throw new Error(`unsupported severity: ${t}`)}}},vs={verbose:1e3,info:2e3,warning:4e3,error:5e3,fatal:6e3},Ed={none:new Ko,console:new Jo},ws={provider:"console",minimalSeverity:"warning",logDateTime:!0,logSourceLocation:!1},en={"":ws};(u=>{function a(l,f){u("verbose",l,f)}u.verbose=a;function t(l,f){u("info",l,f)}u.info=t;function o(l,f){u("warning",l,f)}u.warning=o;function e(l,f){u("error",l,f)}u.error=e;function r(l,f){u("fatal",l,f)}u.fatal=r;function n(l){en={},s("",l||{})}u.reset=n;function s(l,f){if(l==="*")n(f);else{let p=en[l]||ws;en[l]={provider:f.provider||p.provider,minimalSeverity:f.minimalSeverity||p.minimalSeverity,logDateTime:f.logDateTime===void 0?p.logDateTime:f.logDateTime,logSourceLocation:f.logSourceLocation===void 0?p.logSourceLocation:f.logSourceLocation}}}u.set=s;function i(l){let f={};l.logLevel&&(f.minimalSeverity=l.logLevel),s("",f)}u.setWithEnv=i})(Jt||={});ce=Jt,Gn=class{constructor(t,o,e,r,n,s){this.category=t;this.name=o;this.startTime=e;this.endCallback=r;this.timer=n;this.ctx=s}async end(){return this.endCallback(this)}async checkTimer(){if(this.ctx===void 0||this.timer===void 0)throw new Error("No webgl timer found");return this.ctx.endTimer(),this.ctx.waitForQueryAndGetTime(this.timer)}},Un=class{constructor(t,o,e,r){this.category=t;this.name=o;this.startTime=e;this.endTime=r}},zn=class{constructor(t,o,e){this._started=!1;this._flushPointer=0;this._started=!1,this._maxNumberEvents=t===void 0?1e4:t,this._flushBatchSize=o===void 0?10:o,this._flushIntervalInMilliseconds=e===void 0?5e3:e}static create(t){return t===void 0?new this:new this(t.maxNumberEvents,t.flushBatchSize,t.flushIntervalInMilliseconds)}start(){this._started=!0,this._timingEvents=[],this._flushTime=Mn(),this._flushPointer=0}stop(){for(this._started=!1;this._flushPointer<this._timingEvents.length;this._flushPointer++)this.logOneEvent(this._timingEvents[this._flushPointer])}event(t,o,e,r){let n=this._started?this.begin(t,o,r):void 0,s=!1,i=e();if(i&&typeof i.then=="function")return s=!0,new Promise((u,l)=>{i.then(async f=>{n&&await n.end(),u(f)},async f=>{n&&await n.end(),l(f)})});if(!s&&n){let u=n.end();if(u&&typeof u.then=="function")return new Promise((l,f)=>{u.then(()=>{l(i)},p=>{f(p)})})}return i}begin(t,o,e){if(!this._started)throw new Error("profiler is not started yet");if(e===void 0){let r=Mn();return this.flush(r),new Gn(t,o,r,n=>this.endSync(n))}else{let r=e.beginTimer();return new Gn(t,o,0,async n=>this.end(n),r,e)}}async end(t){let o=await t.checkTimer();this._timingEvents.length<this._maxNumberEvents&&(this._timingEvents.push(new Un(t.category,t.name,t.startTime,o)),this.flush(o))}endSync(t){let o=Mn();this._timingEvents.length<this._maxNumberEvents&&(this._timingEvents.push(new Un(t.category,t.name,t.startTime,o)),this.flush(o))}logOneEvent(t){ce.verbose(`Profiler.${t.category}`,`${(t.endTime-t.startTime).toFixed(2)}ms on event '${t.name}' at ${t.endTime.toFixed(2)}`)}flush(t){if(this._timingEvents.length-this._flushPointer>=this._flushBatchSize||t-this._flushTime>=this._flushIntervalInMilliseconds){for(let o=this._flushPointer;this._flushPointer<o+this._flushBatchSize&&this._flushPointer<this._timingEvents.length;this._flushPointer++)this.logOneEvent(this._timingEvents[this._flushPointer]);this._flushTime=Mn()}}get started(){return this._started}},Mn=typeof performance<"u"&&performance.now?()=>performance.now():Date.now});function _s(a,t,o){for(let e of o){let r=e[0],n=e[1],s=e[2],i=e[3],u=e[4];if(a.opType===r){for(let l of t)if((l.domain===n||l.domain==="ai.onnx"&&n==="")&&Ld(l.version,s))return{opImpl:i,opInit:u}}}throw new TypeError(`cannot resolve operator '${a.opType}' with opsets: ${t.map(e=>`${e.domain||"ai.onnx"} v${e.version}`).join(", ")}`)}function Ld(a,t){if(t.endsWith("+")){let o=Number.parseInt(t.substring(0,t.length-1),10);return!isNaN(o)&&o<=a}else if(t.split("-").length===2){let o=t.split("-"),e=Number.parseInt(o[0],10),r=Number.parseInt(o[1],10);return!isNaN(e)&&!isNaN(r)&&e<=a&&a<=r}else return Number.parseInt(t,10)===a}var Os=L(()=>{"use strict"});var Is=me(Zo=>{"use strict";Zo.__esModule=!0;var Fd=function(){function a(t){if(!t)throw new TypeError("Invalid argument; `value` has no value.");this.value=a.EMPTY,t&&a.isGuid(t)&&(this.value=t)}return a.isGuid=function(t){var o=t.toString();return t&&(t instanceof a||a.validator.test(o))},a.create=function(){return new a([a.gen(2),a.gen(1),a.gen(1),a.gen(1),a.gen(3)].join("-"))},a.createEmpty=function(){return new a("emptyguid")},a.parse=function(t){return new a(t)},a.raw=function(){return[a.gen(2),a.gen(1),a.gen(1),a.gen(1),a.gen(3)].join("-")},a.gen=function(t){for(var o="",e=0;e<t;e++)o+=((1+Math.random())*65536|0).toString(16).substring(1);return o},a.prototype.equals=function(t){return a.isGuid(t)&&this.value===t.toString()},a.prototype.isEmpty=function(){return this.value===a.EMPTY},a.prototype.toString=function(){return this.value},a.prototype.toJSON=function(){return{value:this.value}},a.validator=new RegExp("^[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}$","i"),a.EMPTY="00000000-0000-0000-0000-000000000000",a}();Zo.Guid=Fd});function be(a,t,o){this.low=a|0,this.high=t|0,this.unsigned=!!o}function We(a){return(a&&a.__isLong__)===!0}function Ss(a){var t=Math.clz32(a&-a);return a?31-t:t}function lr(a,t){var o,e,r;return t?(a>>>=0,(r=0<=a&&a<256)&&(e=Ps[a],e)?e:(o=le(a,0,!0),r&&(Ps[a]=o),o)):(a|=0,(r=-128<=a&&a<128)&&(e=As[a],e)?e:(o=le(a,a<0?-1:0,!1),r&&(As[a]=o),o))}function ft(a,t){if(isNaN(a))return t?Ut:wt;if(t){if(a<0)return Ut;if(a>=Fs)return ks}else{if(a<=-Ds)return tt;if(a+1>=Ds)return Cs}return a<0?ft(-a,t).neg():le(a%Lr|0,a/Lr|0,t)}function le(a,t,o){return new be(a,t,o)}function ei(a,t,o){if(a.length===0)throw Error("empty string");if(typeof t=="number"?(o=t,t=!1):t=!!t,a==="NaN"||a==="Infinity"||a==="+Infinity"||a==="-Infinity")return t?Ut:wt;if(o=o||10,o<2||36<o)throw RangeError("radix");var e;if((e=a.indexOf("-"))>0)throw Error("interior hyphen");if(e===0)return ei(a.substring(1),t,o).neg();for(var r=ft(Vn(o,8)),n=wt,s=0;s<a.length;s+=8){var i=Math.min(8,a.length-s),u=parseInt(a.substring(s,s+i),o);if(i<8){var l=ft(Vn(o,i));n=n.mul(l).add(ft(u))}else n=n.mul(r),n=n.add(ft(u))}return n.unsigned=t,n}function _t(a,t){return typeof a=="number"?ft(a,t):typeof a=="string"?ei(a,t):le(a.low,a.high,typeof t=="boolean"?t:a.unsigned)}var lt,As,Ps,Vn,Es,$d,Lr,Fs,Ds,Ls,wt,Ut,Dr,$s,Qo,Cs,ks,tt,$,zt,ti=L(()=>{lt=null;try{lt=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch{}be.prototype.__isLong__;Object.defineProperty(be.prototype,"__isLong__",{value:!0});be.isLong=We;As={},Ps={};be.fromInt=lr;be.fromNumber=ft;be.fromBits=le;Vn=Math.pow;be.fromString=ei;be.fromValue=_t;Es=65536,$d=1<<24,Lr=Es*Es,Fs=Lr*Lr,Ds=Fs/2,Ls=lr($d),wt=lr(0);be.ZERO=wt;Ut=lr(0,!0);be.UZERO=Ut;Dr=lr(1);be.ONE=Dr;$s=lr(1,!0);be.UONE=$s;Qo=lr(-1);be.NEG_ONE=Qo;Cs=le(-1,2147483647,!1);be.MAX_VALUE=Cs;ks=le(-1,-1,!0);be.MAX_UNSIGNED_VALUE=ks;tt=le(0,-2147483648,!1);be.MIN_VALUE=tt;$=be.prototype;$.toInt=function(){return this.unsigned?this.low>>>0:this.low};$.toNumber=function(){return this.unsigned?(this.high>>>0)*Lr+(this.low>>>0):this.high*Lr+(this.low>>>0)};$.toString=function(t){if(t=t||10,t<2||36<t)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative())if(this.eq(tt)){var o=ft(t),e=this.div(o),r=e.mul(o).sub(this);return e.toString(t)+r.toInt().toString(t)}else return"-"+this.neg().toString(t);for(var n=ft(Vn(t,6),this.unsigned),s=this,i="";;){var u=s.div(n),l=s.sub(u.mul(n)).toInt()>>>0,f=l.toString(t);if(s=u,s.isZero())return f+i;for(;f.length<6;)f="0"+f;i=""+f+i}};$.getHighBits=function(){return this.high};$.getHighBitsUnsigned=function(){return this.high>>>0};$.getLowBits=function(){return this.low};$.getLowBitsUnsigned=function(){return this.low>>>0};$.getNumBitsAbs=function(){if(this.isNegative())return this.eq(tt)?64:this.neg().getNumBitsAbs();for(var t=this.high!=0?this.high:this.low,o=31;o>0&&!(t&1<<o);o--);return this.high!=0?o+33:o+1};$.isZero=function(){return this.high===0&&this.low===0};$.eqz=$.isZero;$.isNegative=function(){return!this.unsigned&&this.high<0};$.isPositive=function(){return this.unsigned||this.high>=0};$.isOdd=function(){return(this.low&1)===1};$.isEven=function(){return(this.low&1)===0};$.equals=function(t){return We(t)||(t=_t(t)),this.unsigned!==t.unsigned&&this.high>>>31===1&&t.high>>>31===1?!1:this.high===t.high&&this.low===t.low};$.eq=$.equals;$.notEquals=function(t){return!this.eq(t)};$.neq=$.notEquals;$.ne=$.notEquals;$.lessThan=function(t){return this.comp(t)<0};$.lt=$.lessThan;$.lessThanOrEqual=function(t){return this.comp(t)<=0};$.lte=$.lessThanOrEqual;$.le=$.lessThanOrEqual;$.greaterThan=function(t){return this.comp(t)>0};$.gt=$.greaterThan;$.greaterThanOrEqual=function(t){return this.comp(t)>=0};$.gte=$.greaterThanOrEqual;$.ge=$.greaterThanOrEqual;$.compare=function(t){if(We(t)||(t=_t(t)),this.eq(t))return 0;var o=this.isNegative(),e=t.isNegative();return o&&!e?-1:!o&&e?1:this.unsigned?t.high>>>0>this.high>>>0||t.high===this.high&&t.low>>>0>this.low>>>0?-1:1:this.sub(t).isNegative()?-1:1};$.comp=$.compare;$.negate=function(){return!this.unsigned&&this.eq(tt)?tt:this.not().add(Dr)};$.neg=$.negate;$.add=function(t){We(t)||(t=_t(t));var o=this.high>>>16,e=this.high&65535,r=this.low>>>16,n=this.low&65535,s=t.high>>>16,i=t.high&65535,u=t.low>>>16,l=t.low&65535,f=0,p=0,d=0,T=0;return T+=n+l,d+=T>>>16,T&=65535,d+=r+u,p+=d>>>16,d&=65535,p+=e+i,f+=p>>>16,p&=65535,f+=o+s,f&=65535,le(d<<16|T,f<<16|p,this.unsigned)};$.subtract=function(t){return We(t)||(t=_t(t)),this.add(t.neg())};$.sub=$.subtract;$.multiply=function(t){if(this.isZero())return this;if(We(t)||(t=_t(t)),lt){var o=lt.mul(this.low,this.high,t.low,t.high);return le(o,lt.get_high(),this.unsigned)}if(t.isZero())return this.unsigned?Ut:wt;if(this.eq(tt))return t.isOdd()?tt:wt;if(t.eq(tt))return this.isOdd()?tt:wt;if(this.isNegative())return t.isNegative()?this.neg().mul(t.neg()):this.neg().mul(t).neg();if(t.isNegative())return this.mul(t.neg()).neg();if(this.lt(Ls)&&t.lt(Ls))return ft(this.toNumber()*t.toNumber(),this.unsigned);var e=this.high>>>16,r=this.high&65535,n=this.low>>>16,s=this.low&65535,i=t.high>>>16,u=t.high&65535,l=t.low>>>16,f=t.low&65535,p=0,d=0,T=0,O=0;return O+=s*f,T+=O>>>16,O&=65535,T+=n*f,d+=T>>>16,T&=65535,T+=s*l,d+=T>>>16,T&=65535,d+=r*f,p+=d>>>16,d&=65535,d+=n*l,p+=d>>>16,d&=65535,d+=s*u,p+=d>>>16,d&=65535,p+=e*f+r*l+n*u+s*i,p&=65535,le(T<<16|O,p<<16|d,this.unsigned)};$.mul=$.multiply;$.divide=function(t){if(We(t)||(t=_t(t)),t.isZero())throw Error("division by zero");if(lt){if(!this.unsigned&&this.high===-2147483648&&t.low===-1&&t.high===-1)return this;var o=(this.unsigned?lt.div_u:lt.div_s)(this.low,this.high,t.low,t.high);return le(o,lt.get_high(),this.unsigned)}if(this.isZero())return this.unsigned?Ut:wt;var e,r,n;if(this.unsigned){if(t.unsigned||(t=t.toUnsigned()),t.gt(this))return Ut;if(t.gt(this.shru(1)))return $s;n=Ut}else{if(this.eq(tt)){if(t.eq(Dr)||t.eq(Qo))return tt;if(t.eq(tt))return Dr;var s=this.shr(1);return e=s.div(t).shl(1),e.eq(wt)?t.isNegative()?Dr:Qo:(r=this.sub(t.mul(e)),n=e.add(r.div(t)),n)}else if(t.eq(tt))return this.unsigned?Ut:wt;if(this.isNegative())return t.isNegative()?this.neg().div(t.neg()):this.neg().div(t).neg();if(t.isNegative())return this.div(t.neg()).neg();n=wt}for(r=this;r.gte(t);){e=Math.max(1,Math.floor(r.toNumber()/t.toNumber()));for(var i=Math.ceil(Math.log(e)/Math.LN2),u=i<=48?1:Vn(2,i-48),l=ft(e),f=l.mul(t);f.isNegative()||f.gt(r);)e-=u,l=ft(e,this.unsigned),f=l.mul(t);l.isZero()&&(l=Dr),n=n.add(l),r=r.sub(f)}return n};$.div=$.divide;$.modulo=function(t){if(We(t)||(t=_t(t)),lt){var o=(this.unsigned?lt.rem_u:lt.rem_s)(this.low,this.high,t.low,t.high);return le(o,lt.get_high(),this.unsigned)}return this.sub(this.div(t).mul(t))};$.mod=$.modulo;$.rem=$.modulo;$.not=function(){return le(~this.low,~this.high,this.unsigned)};$.countLeadingZeros=function(){return this.high?Math.clz32(this.high):Math.clz32(this.low)+32};$.clz=$.countLeadingZeros;$.countTrailingZeros=function(){return this.low?Ss(this.low):Ss(this.high)+32};$.ctz=$.countTrailingZeros;$.and=function(t){return We(t)||(t=_t(t)),le(this.low&t.low,this.high&t.high,this.unsigned)};$.or=function(t){return We(t)||(t=_t(t)),le(this.low|t.low,this.high|t.high,this.unsigned)};$.xor=function(t){return We(t)||(t=_t(t)),le(this.low^t.low,this.high^t.high,this.unsigned)};$.shiftLeft=function(t){return We(t)&&(t=t.toInt()),(t&=63)===0?this:t<32?le(this.low<<t,this.high<<t|this.low>>>32-t,this.unsigned):le(0,this.low<<t-32,this.unsigned)};$.shl=$.shiftLeft;$.shiftRight=function(t){return We(t)&&(t=t.toInt()),(t&=63)===0?this:t<32?le(this.low>>>t|this.high<<32-t,this.high>>t,this.unsigned):le(this.high>>t-32,this.high>=0?0:-1,this.unsigned)};$.shr=$.shiftRight;$.shiftRightUnsigned=function(t){return We(t)&&(t=t.toInt()),(t&=63)===0?this:t<32?le(this.low>>>t|this.high<<32-t,this.high>>>t,this.unsigned):t===32?le(this.high,0,this.unsigned):le(this.high>>>t-32,0,this.unsigned)};$.shru=$.shiftRightUnsigned;$.shr_u=$.shiftRightUnsigned;$.rotateLeft=function(t){var o;return We(t)&&(t=t.toInt()),(t&=63)===0?this:t===32?le(this.high,this.low,this.unsigned):t<32?(o=32-t,le(this.low<<t|this.high>>>o,this.high<<t|this.low>>>o,this.unsigned)):(t-=32,o=32-t,le(this.high<<t|this.low>>>o,this.low<<t|this.high>>>o,this.unsigned))};$.rotl=$.rotateLeft;$.rotateRight=function(t){var o;return We(t)&&(t=t.toInt()),(t&=63)===0?this:t===32?le(this.high,this.low,this.unsigned):t<32?(o=32-t,le(this.high<<o|this.low>>>t,this.low<<o|this.high>>>t,this.unsigned)):(t-=32,o=32-t,le(this.low<<o|this.high>>>t,this.high<<o|this.low>>>t,this.unsigned))};$.rotr=$.rotateRight;$.toSigned=function(){return this.unsigned?le(this.low,this.high,!1):this};$.toUnsigned=function(){return this.unsigned?this:le(this.low,this.high,!0)};$.toBytes=function(t){return t?this.toBytesLE():this.toBytesBE()};$.toBytesLE=function(){var t=this.high,o=this.low;return[o&255,o>>>8&255,o>>>16&255,o>>>24,t&255,t>>>8&255,t>>>16&255,t>>>24]};$.toBytesBE=function(){var t=this.high,o=this.low;return[t>>>24,t>>>16&255,t>>>8&255,t&255,o>>>24,o>>>16&255,o>>>8&255,o&255]};be.fromBytes=function(t,o,e){return e?be.fromBytesLE(t,o):be.fromBytesBE(t,o)};be.fromBytesLE=function(t,o){return new be(t[0]|t[1]<<8|t[2]<<16|t[3]<<24,t[4]|t[5]<<8|t[6]<<16|t[7]<<24,o)};be.fromBytesBE=function(t,o){return new be(t[4]<<24|t[5]<<16|t[6]<<8|t[7],t[0]<<24|t[1]<<16|t[2]<<8|t[3],o)};zt=be});var _,Wn=L(()=>{_={};_.Offset;_.Table;_.SIZEOF_SHORT=2;_.SIZEOF_INT=4;_.FILE_IDENTIFIER_LENGTH=4;_.SIZE_PREFIX_LENGTH=4;_.Encoding={UTF8_BYTES:1,UTF16_STRING:2};_.int32=new Int32Array(2);_.float32=new Float32Array(_.int32.buffer);_.float64=new Float64Array(_.int32.buffer);_.isLittleEndian=new Uint16Array(new Uint8Array([1,0]).buffer)[0]===1;_.Long=function(a,t){this.low=a|0,this.high=t|0};_.Long.create=function(a,t){return a==0&&t==0?_.Long.ZERO:new _.Long(a,t)};_.Long.prototype.toFloat64=function(){return(this.low>>>0)+this.high*4294967296};_.Long.prototype.equals=function(a){return this.low==a.low&&this.high==a.high};_.Long.ZERO=new _.Long(0,0);_.Builder=function(a){if(a)var t=a;else var t=1024;this.bb=_.ByteBuffer.allocate(t),this.space=t,this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1};_.Builder.prototype.clear=function(){this.bb.clear(),this.space=this.bb.capacity(),this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1};_.Builder.prototype.forceDefaults=function(a){this.force_defaults=a};_.Builder.prototype.dataBuffer=function(){return this.bb};_.Builder.prototype.asUint8Array=function(){return this.bb.bytes().subarray(this.bb.position(),this.bb.position()+this.offset())};_.Builder.prototype.prep=function(a,t){a>this.minalign&&(this.minalign=a);for(var o=~(this.bb.capacity()-this.space+t)+1&a-1;this.space<o+a+t;){var e=this.bb.capacity();this.bb=_.Builder.growByteBuffer(this.bb),this.space+=this.bb.capacity()-e}this.pad(o)};_.Builder.prototype.pad=function(a){for(var t=0;t<a;t++)this.bb.writeInt8(--this.space,0)};_.Builder.prototype.writeInt8=function(a){this.bb.writeInt8(this.space-=1,a)};_.Builder.prototype.writeInt16=function(a){this.bb.writeInt16(this.space-=2,a)};_.Builder.prototype.writeInt32=function(a){this.bb.writeInt32(this.space-=4,a)};_.Builder.prototype.writeInt64=function(a){this.bb.writeInt64(this.space-=8,a)};_.Builder.prototype.writeFloat32=function(a){this.bb.writeFloat32(this.space-=4,a)};_.Builder.prototype.writeFloat64=function(a){this.bb.writeFloat64(this.space-=8,a)};_.Builder.prototype.addInt8=function(a){this.prep(1,0),this.writeInt8(a)};_.Builder.prototype.addInt16=function(a){this.prep(2,0),this.writeInt16(a)};_.Builder.prototype.addInt32=function(a){this.prep(4,0),this.writeInt32(a)};_.Builder.prototype.addInt64=function(a){this.prep(8,0),this.writeInt64(a)};_.Builder.prototype.addFloat32=function(a){this.prep(4,0),this.writeFloat32(a)};_.Builder.prototype.addFloat64=function(a){this.prep(8,0),this.writeFloat64(a)};_.Builder.prototype.addFieldInt8=function(a,t,o){(this.force_defaults||t!=o)&&(this.addInt8(t),this.slot(a))};_.Builder.prototype.addFieldInt16=function(a,t,o){(this.force_defaults||t!=o)&&(this.addInt16(t),this.slot(a))};_.Builder.prototype.addFieldInt32=function(a,t,o){(this.force_defaults||t!=o)&&(this.addInt32(t),this.slot(a))};_.Builder.prototype.addFieldInt64=function(a,t,o){(this.force_defaults||!t.equals(o))&&(this.addInt64(t),this.slot(a))};_.Builder.prototype.addFieldFloat32=function(a,t,o){(this.force_defaults||t!=o)&&(this.addFloat32(t),this.slot(a))};_.Builder.prototype.addFieldFloat64=function(a,t,o){(this.force_defaults||t!=o)&&(this.addFloat64(t),this.slot(a))};_.Builder.prototype.addFieldOffset=function(a,t,o){(this.force_defaults||t!=o)&&(this.addOffset(t),this.slot(a))};_.Builder.prototype.addFieldStruct=function(a,t,o){t!=o&&(this.nested(t),this.slot(a))};_.Builder.prototype.nested=function(a){if(a!=this.offset())throw new Error("FlatBuffers: struct must be serialized inline.")};_.Builder.prototype.notNested=function(){if(this.isNested)throw new Error("FlatBuffers: object serialization must not be nested.")};_.Builder.prototype.slot=function(a){this.vtable[a]=this.offset()};_.Builder.prototype.offset=function(){return this.bb.capacity()-this.space};_.Builder.growByteBuffer=function(a){var t=a.capacity();if(t&3221225472)throw new Error("FlatBuffers: cannot grow buffer beyond 2 gigabytes.");var o=t<<1,e=_.ByteBuffer.allocate(o);return e.setPosition(o-t),e.bytes().set(a.bytes(),o-t),e};_.Builder.prototype.addOffset=function(a){this.prep(_.SIZEOF_INT,0),this.writeInt32(this.offset()-a+_.SIZEOF_INT)};_.Builder.prototype.startObject=function(a){this.notNested(),this.vtable==null&&(this.vtable=[]),this.vtable_in_use=a;for(var t=0;t<a;t++)this.vtable[t]=0;this.isNested=!0,this.object_start=this.offset()};_.Builder.prototype.endObject=function(){if(this.vtable==null||!this.isNested)throw new Error("FlatBuffers: endObject called without startObject");this.addInt32(0);for(var a=this.offset(),t=this.vtable_in_use-1;t>=0&&this.vtable[t]==0;t--);for(var o=t+1;t>=0;t--)this.addInt16(this.vtable[t]!=0?a-this.vtable[t]:0);var e=2;this.addInt16(a-this.object_start);var r=(o+e)*_.SIZEOF_SHORT;this.addInt16(r);var n=0,s=this.space;e:for(t=0;t<this.vtables.length;t++){var i=this.bb.capacity()-this.vtables[t];if(r==this.bb.readInt16(i)){for(var u=_.SIZEOF_SHORT;u<r;u+=_.SIZEOF_SHORT)if(this.bb.readInt16(s+u)!=this.bb.readInt16(i+u))continue e;n=this.vtables[t];break}}return n?(this.space=this.bb.capacity()-a,this.bb.writeInt32(this.space,n-a)):(this.vtables.push(this.offset()),this.bb.writeInt32(this.bb.capacity()-a,this.offset()-a)),this.isNested=!1,a};_.Builder.prototype.finish=function(a,t,o){var e=o?_.SIZE_PREFIX_LENGTH:0;if(t){var r=t;if(this.prep(this.minalign,_.SIZEOF_INT+_.FILE_IDENTIFIER_LENGTH+e),r.length!=_.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+_.FILE_IDENTIFIER_LENGTH);for(var n=_.FILE_IDENTIFIER_LENGTH-1;n>=0;n--)this.writeInt8(r.charCodeAt(n))}this.prep(this.minalign,_.SIZEOF_INT+e),this.addOffset(a),e&&this.addInt32(this.bb.capacity()-this.space),this.bb.setPosition(this.space)};_.Builder.prototype.finishSizePrefixed=function(a,t){this.finish(a,t,!0)};_.Builder.prototype.requiredField=function(a,t){var o=this.bb.capacity()-a,e=o-this.bb.readInt32(o),r=this.bb.readInt16(e+t)!=0;if(!r)throw new Error("FlatBuffers: field "+t+" must be set")};_.Builder.prototype.startVector=function(a,t,o){this.notNested(),this.vector_num_elems=t,this.prep(_.SIZEOF_INT,a*t),this.prep(o,a*t)};_.Builder.prototype.endVector=function(){return this.writeInt32(this.vector_num_elems),this.offset()};_.Builder.prototype.createString=function(a){if(a instanceof Uint8Array)var t=a;else for(var t=[],o=0;o<a.length;){var e,r=a.charCodeAt(o++);if(r<55296||r>=56320)e=r;else{var n=a.charCodeAt(o++);e=(r<<10)+n+(65536-56623104-56320)}e<128?t.push(e):(e<2048?t.push(e>>6&31|192):(e<65536?t.push(e>>12&15|224):t.push(e>>18&7|240,e>>12&63|128),t.push(e>>6&63|128)),t.push(e&63|128))}this.addInt8(0),this.startVector(1,t.length,1),this.bb.setPosition(this.space-=t.length);for(var o=0,s=this.space,i=this.bb.bytes();o<t.length;o++)i[s++]=t[o];return this.endVector()};_.Builder.prototype.createLong=function(a,t){return _.Long.create(a,t)};_.ByteBuffer=function(a){this.bytes_=a,this.position_=0};_.ByteBuffer.allocate=function(a){return new _.ByteBuffer(new Uint8Array(a))};_.ByteBuffer.prototype.clear=function(){this.position_=0};_.ByteBuffer.prototype.bytes=function(){return this.bytes_};_.ByteBuffer.prototype.position=function(){return this.position_};_.ByteBuffer.prototype.setPosition=function(a){this.position_=a};_.ByteBuffer.prototype.capacity=function(){return this.bytes_.length};_.ByteBuffer.prototype.readInt8=function(a){return this.readUint8(a)<<24>>24};_.ByteBuffer.prototype.readUint8=function(a){return this.bytes_[a]};_.ByteBuffer.prototype.readInt16=function(a){return this.readUint16(a)<<16>>16};_.ByteBuffer.prototype.readUint16=function(a){return this.bytes_[a]|this.bytes_[a+1]<<8};_.ByteBuffer.prototype.readInt32=function(a){return this.bytes_[a]|this.bytes_[a+1]<<8|this.bytes_[a+2]<<16|this.bytes_[a+3]<<24};_.ByteBuffer.prototype.readUint32=function(a){return this.readInt32(a)>>>0};_.ByteBuffer.prototype.readInt64=function(a){return new _.Long(this.readInt32(a),this.readInt32(a+4))};_.ByteBuffer.prototype.readUint64=function(a){return new _.Long(this.readUint32(a),this.readUint32(a+4))};_.ByteBuffer.prototype.readFloat32=function(a){return _.int32[0]=this.readInt32(a),_.float32[0]};_.ByteBuffer.prototype.readFloat64=function(a){return _.int32[_.isLittleEndian?0:1]=this.readInt32(a),_.int32[_.isLittleEndian?1:0]=this.readInt32(a+4),_.float64[0]};_.ByteBuffer.prototype.writeInt8=function(a,t){this.bytes_[a]=t};_.ByteBuffer.prototype.writeUint8=function(a,t){this.bytes_[a]=t};_.ByteBuffer.prototype.writeInt16=function(a,t){this.bytes_[a]=t,this.bytes_[a+1]=t>>8};_.ByteBuffer.prototype.writeUint16=function(a,t){this.bytes_[a]=t,this.bytes_[a+1]=t>>8};_.ByteBuffer.prototype.writeInt32=function(a,t){this.bytes_[a]=t,this.bytes_[a+1]=t>>8,this.bytes_[a+2]=t>>16,this.bytes_[a+3]=t>>24};_.ByteBuffer.prototype.writeUint32=function(a,t){this.bytes_[a]=t,this.bytes_[a+1]=t>>8,this.bytes_[a+2]=t>>16,this.bytes_[a+3]=t>>24};_.ByteBuffer.prototype.writeInt64=function(a,t){this.writeInt32(a,t.low),this.writeInt32(a+4,t.high)};_.ByteBuffer.prototype.writeUint64=function(a,t){this.writeUint32(a,t.low),this.writeUint32(a+4,t.high)};_.ByteBuffer.prototype.writeFloat32=function(a,t){_.float32[0]=t,this.writeInt32(a,_.int32[0])};_.ByteBuffer.prototype.writeFloat64=function(a,t){_.float64[0]=t,this.writeInt32(a,_.int32[_.isLittleEndian?0:1]),this.writeInt32(a+4,_.int32[_.isLittleEndian?1:0])};_.ByteBuffer.prototype.getBufferIdentifier=function(){if(this.bytes_.length<this.position_+_.SIZEOF_INT+_.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: ByteBuffer is too short to contain an identifier.");for(var a="",t=0;t<_.FILE_IDENTIFIER_LENGTH;t++)a+=String.fromCharCode(this.readInt8(this.position_+_.SIZEOF_INT+t));return a};_.ByteBuffer.prototype.__offset=function(a,t){var o=a-this.readInt32(a);return t<this.readInt16(o)?this.readInt16(o+t):0};_.ByteBuffer.prototype.__union=function(a,t){return a.bb_pos=t+this.readInt32(t),a.bb=this,a};_.ByteBuffer.prototype.__string=function(a,t){a+=this.readInt32(a);var o=this.readInt32(a),e="",r=0;if(a+=_.SIZEOF_INT,t===_.Encoding.UTF8_BYTES)return this.bytes_.subarray(a,a+o);for(;r<o;){var n,s=this.readUint8(a+r++);if(s<192)n=s;else{var i=this.readUint8(a+r++);if(s<224)n=(s&31)<<6|i&63;else{var u=this.readUint8(a+r++);if(s<240)n=(s&15)<<12|(i&63)<<6|u&63;else{var l=this.readUint8(a+r++);n=(s&7)<<18|(i&63)<<12|(u&63)<<6|l&63}}}n<65536?e+=String.fromCharCode(n):(n-=65536,e+=String.fromCharCode((n>>10)+55296,(n&1024-1)+56320))}return e};_.ByteBuffer.prototype.__indirect=function(a){return a+this.readInt32(a)};_.ByteBuffer.prototype.__vector=function(a){return a+this.readInt32(a)+_.SIZEOF_INT};_.ByteBuffer.prototype.__vector_len=function(a){return this.readInt32(a+this.readInt32(a))};_.ByteBuffer.prototype.__has_identifier=function(a){if(a.length!=_.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+_.FILE_IDENTIFIER_LENGTH);for(var t=0;t<_.FILE_IDENTIFIER_LENGTH;t++)if(a.charCodeAt(t)!=this.readInt8(this.position_+_.SIZEOF_INT+t))return!1;return!0};_.ByteBuffer.prototype.createLong=function(a,t){return _.Long.create(a,t)}});var W,tn=L(()=>{"use strict";Wn();(t=>{let a;(e=>{let o;(n=>{let r;(B=>(B[B.UNDEFINED=0]="UNDEFINED",B[B.FLOAT=1]="FLOAT",B[B.INT=2]="INT",B[B.STRING=3]="STRING",B[B.TENSOR=4]="TENSOR",B[B.GRAPH=5]="GRAPH",B[B.FLOATS=6]="FLOATS",B[B.INTS=7]="INTS",B[B.STRINGS=8]="STRINGS",B[B.TENSORS=9]="TENSORS",B[B.GRAPHS=10]="GRAPHS",B[B.SPARSE_TENSOR=11]="SPARSE_TENSOR",B[B.SPARSE_TENSORS=12]="SPARSE_TENSORS"))(r=n.AttributeType||={})})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{let r;(l=>(l[l.UNKNOWN=0]="UNKNOWN",l[l.VALUE=1]="VALUE",l[l.PARAM=2]="PARAM"))(r=n.DimensionValueType||={})})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{let r;(V=>(V[V.UNDEFINED=0]="UNDEFINED",V[V.FLOAT=1]="FLOAT",V[V.UINT8=2]="UINT8",V[V.INT8=3]="INT8",V[V.UINT16=4]="UINT16",V[V.INT16=5]="INT16",V[V.INT32=6]="INT32",V[V.INT64=7]="INT64",V[V.STRING=8]="STRING",V[V.BOOL=9]="BOOL",V[V.FLOAT16=10]="FLOAT16",V[V.DOUBLE=11]="DOUBLE",V[V.UINT32=12]="UINT32",V[V.UINT64=13]="UINT64",V[V.COMPLEX64=14]="COMPLEX64",V[V.COMPLEX128=15]="COMPLEX128",V[V.BFLOAT16=16]="BFLOAT16",V[V.FLOAT8E4M3FN=17]="FLOAT8E4M3FN",V[V.FLOAT8E4M3FNUZ=18]="FLOAT8E4M3FNUZ",V[V.FLOAT8E5M2=19]="FLOAT8E5M2",V[V.FLOAT8E5M2FNUZ=20]="FLOAT8E5M2FNUZ"))(r=n.TensorDataType||={})})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{let r;(u=>(u[u.Primitive=0]="Primitive",u[u.Fused=1]="Fused"))(r=n.NodeType||={})})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{let r;(f=>(f[f.NONE=0]="NONE",f[f.tensor_type=1]="tensor_type",f[f.sequence_type=2]="sequence_type",f[f.map_type=3]="map_type"))(r=n.TypeInfoValue||={})})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsShape(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsShape(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}dim(i,u){let l=this.bb.__offset(this.bb_pos,4);return l?(u||new t.experimental.fbs.Dimension).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}dimLength(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.__vector_len(this.bb_pos+i):0}static startShape(i){i.startObject(1)}static addDim(i,u){i.addFieldOffset(0,u,0)}static createDimVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startDimVector(i,u){i.startVector(4,u,4)}static endShape(i){return i.endObject()}static createShape(i,u){return r.startShape(i),r.addDim(i,u),r.endShape(i)}}n.Shape=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsDimension(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsDimension(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}value(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new t.experimental.fbs.DimensionValue).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}denotation(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}static startDimension(i){i.startObject(2)}static addValue(i,u){i.addFieldOffset(0,u,0)}static addDenotation(i,u){i.addFieldOffset(1,u,0)}static endDimension(i){return i.endObject()}static createDimension(i,u,l){return r.startDimension(i),r.addValue(i,u),r.addDenotation(i,l),r.endDimension(i)}}n.Dimension=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsDimensionValue(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsDimensionValue(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}dimType(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt8(this.bb_pos+i):0}dimValue(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}dimParam(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,i):null}static startDimensionValue(i){i.startObject(3)}static addDimType(i,u){i.addFieldInt8(0,u,0)}static addDimValue(i,u){i.addFieldInt64(1,u,i.createLong(0,0))}static addDimParam(i,u){i.addFieldOffset(2,u,0)}static endDimensionValue(i){return i.endObject()}static createDimensionValue(i,u,l,f){return r.startDimensionValue(i),r.addDimType(i,u),r.addDimValue(i,l),r.addDimParam(i,f),r.endDimensionValue(i)}}n.DimensionValue=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsTensorTypeAndShape(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsTensorTypeAndShape(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}elemType(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt32(this.bb_pos+i):0}shape(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new t.experimental.fbs.Shape).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startTensorTypeAndShape(i){i.startObject(2)}static addElemType(i,u){i.addFieldInt32(0,u,0)}static addShape(i,u){i.addFieldOffset(1,u,0)}static endTensorTypeAndShape(i){return i.endObject()}static createTensorTypeAndShape(i,u,l){return r.startTensorTypeAndShape(i),r.addElemType(i,u),r.addShape(i,l),r.endTensorTypeAndShape(i)}}n.TensorTypeAndShape=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsMapType(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsMapType(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}keyType(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt32(this.bb_pos+i):0}valueType(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new t.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startMapType(i){i.startObject(2)}static addKeyType(i,u){i.addFieldInt32(0,u,0)}static addValueType(i,u){i.addFieldOffset(1,u,0)}static endMapType(i){return i.endObject()}static createMapType(i,u,l){return r.startMapType(i),r.addKeyType(i,u),r.addValueType(i,l),r.endMapType(i)}}n.MapType=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSequenceType(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSequenceType(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}elemType(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new t.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startSequenceType(i){i.startObject(1)}static addElemType(i,u){i.addFieldOffset(0,u,0)}static endSequenceType(i){return i.endObject()}static createSequenceType(i,u){return r.startSequenceType(i),r.addElemType(i,u),r.endSequenceType(i)}}n.SequenceType=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}nodeIndex(){return this.bb.readUint32(this.bb_pos)}srcArgIndex(){return this.bb.readInt32(this.bb_pos+4)}dstArgIndex(){return this.bb.readInt32(this.bb_pos+8)}static createEdgeEnd(i,u,l,f){return i.prep(4,12),i.writeInt32(f),i.writeInt32(l),i.writeInt32(u),i.offset()}}n.EdgeEnd=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsNodeEdge(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsNodeEdge(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}nodeIndex(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readUint32(this.bb_pos+i):0}inputEdges(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new t.experimental.fbs.EdgeEnd).__init(this.bb.__vector(this.bb_pos+l)+i*12,this.bb):null}inputEdgesLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}outputEdges(i,u){let l=this.bb.__offset(this.bb_pos,8);return l?(u||new t.experimental.fbs.EdgeEnd).__init(this.bb.__vector(this.bb_pos+l)+i*12,this.bb):null}outputEdgesLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}static startNodeEdge(i){i.startObject(3)}static addNodeIndex(i,u){i.addFieldInt32(0,u,0)}static addInputEdges(i,u){i.addFieldOffset(1,u,0)}static startInputEdgesVector(i,u){i.startVector(12,u,4)}static addOutputEdges(i,u){i.addFieldOffset(2,u,0)}static startOutputEdgesVector(i,u){i.startVector(12,u,4)}static endNodeEdge(i){return i.endObject()}static createNodeEdge(i,u,l,f){return r.startNodeEdge(i),r.addNodeIndex(i,u),r.addInputEdges(i,l),r.addOutputEdges(i,f),r.endNodeEdge(i)}}n.NodeEdge=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsNode(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsNode(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}domain(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,i):null}sinceVersion(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readInt32(this.bb_pos+i):0}index(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.readUint32(this.bb_pos+i):0}opType(i){let u=this.bb.__offset(this.bb_pos,14);return u?this.bb.__string(this.bb_pos+u,i):null}type(){let i=this.bb.__offset(this.bb_pos,16);return i?this.bb.readInt32(this.bb_pos+i):0}executionProviderType(i){let u=this.bb.__offset(this.bb_pos,18);return u?this.bb.__string(this.bb_pos+u,i):null}inputs(i,u){let l=this.bb.__offset(this.bb_pos,20);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}inputsLength(){let i=this.bb.__offset(this.bb_pos,20);return i?this.bb.__vector_len(this.bb_pos+i):0}outputs(i,u){let l=this.bb.__offset(this.bb_pos,22);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}outputsLength(){let i=this.bb.__offset(this.bb_pos,22);return i?this.bb.__vector_len(this.bb_pos+i):0}attributes(i,u){let l=this.bb.__offset(this.bb_pos,24);return l?(u||new t.experimental.fbs.Attribute).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}attributesLength(){let i=this.bb.__offset(this.bb_pos,24);return i?this.bb.__vector_len(this.bb_pos+i):0}inputArgCounts(i){let u=this.bb.__offset(this.bb_pos,26);return u?this.bb.readInt32(this.bb.__vector(this.bb_pos+u)+i*4):0}inputArgCountsLength(){let i=this.bb.__offset(this.bb_pos,26);return i?this.bb.__vector_len(this.bb_pos+i):0}inputArgCountsArray(){let i=this.bb.__offset(this.bb_pos,26);return i?new Int32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}implicitInputs(i,u){let l=this.bb.__offset(this.bb_pos,28);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}implicitInputsLength(){let i=this.bb.__offset(this.bb_pos,28);return i?this.bb.__vector_len(this.bb_pos+i):0}static startNode(i){i.startObject(13)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addDomain(i,u){i.addFieldOffset(2,u,0)}static addSinceVersion(i,u){i.addFieldInt32(3,u,0)}static addIndex(i,u){i.addFieldInt32(4,u,0)}static addOpType(i,u){i.addFieldOffset(5,u,0)}static addType(i,u){i.addFieldInt32(6,u,0)}static addExecutionProviderType(i,u){i.addFieldOffset(7,u,0)}static addInputs(i,u){i.addFieldOffset(8,u,0)}static createInputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startInputsVector(i,u){i.startVector(4,u,4)}static addOutputs(i,u){i.addFieldOffset(9,u,0)}static createOutputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startOutputsVector(i,u){i.startVector(4,u,4)}static addAttributes(i,u){i.addFieldOffset(10,u,0)}static createAttributesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startAttributesVector(i,u){i.startVector(4,u,4)}static addInputArgCounts(i,u){i.addFieldOffset(11,u,0)}static createInputArgCountsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addInt32(u[l]);return i.endVector()}static startInputArgCountsVector(i,u){i.startVector(4,u,4)}static addImplicitInputs(i,u){i.addFieldOffset(12,u,0)}static createImplicitInputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startImplicitInputsVector(i,u){i.startVector(4,u,4)}static endNode(i){return i.endObject()}static createNode(i,u,l,f,p,d,T,O,v,S,E,F,B,K){return r.startNode(i),r.addName(i,u),r.addDocString(i,l),r.addDomain(i,f),r.addSinceVersion(i,p),r.addIndex(i,d),r.addOpType(i,T),r.addType(i,O),r.addExecutionProviderType(i,v),r.addInputs(i,S),r.addOutputs(i,E),r.addAttributes(i,F),r.addInputArgCounts(i,B),r.addImplicitInputs(i,K),r.endNode(i)}}n.Node=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsValueInfo(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsValueInfo(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}type(i){let u=this.bb.__offset(this.bb_pos,8);return u?(i||new t.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startValueInfo(i){i.startObject(3)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addType(i,u){i.addFieldOffset(2,u,0)}static endValueInfo(i){return i.endObject()}static createValueInfo(i,u,l,f){return r.startValueInfo(i),r.addName(i,u),r.addDocString(i,l),r.addType(i,f),r.endValueInfo(i)}}n.ValueInfo=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsTypeInfo(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsTypeInfo(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}denotation(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}valueType(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.readUint8(this.bb_pos+i):0}value(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__union(i,this.bb_pos+u):null}static startTypeInfo(i){i.startObject(3)}static addDenotation(i,u){i.addFieldOffset(0,u,0)}static addValueType(i,u){i.addFieldInt8(1,u,0)}static addValue(i,u){i.addFieldOffset(2,u,0)}static endTypeInfo(i){return i.endObject()}static createTypeInfo(i,u,l,f){return r.startTypeInfo(i),r.addDenotation(i,u),r.addValueType(i,l),r.addValue(i,f),r.endTypeInfo(i)}}n.TypeInfo=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsOperatorSetId(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsOperatorSetId(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}domain(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}version(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}static startOperatorSetId(i){i.startObject(2)}static addDomain(i,u){i.addFieldOffset(0,u,0)}static addVersion(i,u){i.addFieldInt64(1,u,i.createLong(0,0))}static endOperatorSetId(i){return i.endObject()}static createOperatorSetId(i,u,l){return r.startOperatorSetId(i),r.addDomain(i,u),r.addVersion(i,l),r.endOperatorSetId(i)}}n.OperatorSetId=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsTensor(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsTensor(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}dims(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}dimsLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}dataType(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readInt32(this.bb_pos+i):0}rawData(i){let u=this.bb.__offset(this.bb_pos,12);return u?this.bb.readUint8(this.bb.__vector(this.bb_pos+u)+i):0}rawDataLength(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.__vector_len(this.bb_pos+i):0}rawDataArray(){let i=this.bb.__offset(this.bb_pos,12);return i?new Uint8Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}stringData(i,u){let l=this.bb.__offset(this.bb_pos,14);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}stringDataLength(){let i=this.bb.__offset(this.bb_pos,14);return i?this.bb.__vector_len(this.bb_pos+i):0}static startTensor(i){i.startObject(6)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addDims(i,u){i.addFieldOffset(2,u,0)}static createDimsVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startDimsVector(i,u){i.startVector(8,u,8)}static addDataType(i,u){i.addFieldInt32(3,u,0)}static addRawData(i,u){i.addFieldOffset(4,u,0)}static createRawDataVector(i,u){i.startVector(1,u.length,1);for(let l=u.length-1;l>=0;l--)i.addInt8(u[l]);return i.endVector()}static startRawDataVector(i,u){i.startVector(1,u,1)}static addStringData(i,u){i.addFieldOffset(5,u,0)}static createStringDataVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startStringDataVector(i,u){i.startVector(4,u,4)}static endTensor(i){return i.endObject()}static createTensor(i,u,l,f,p,d,T){return r.startTensor(i),r.addName(i,u),r.addDocString(i,l),r.addDims(i,f),r.addDataType(i,p),r.addRawData(i,d),r.addStringData(i,T),r.endTensor(i)}}n.Tensor=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSparseTensor(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSparseTensor(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}values(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new t.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}indices(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new t.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}dims(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}dimsLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}static startSparseTensor(i){i.startObject(3)}static addValues(i,u){i.addFieldOffset(0,u,0)}static addIndices(i,u){i.addFieldOffset(1,u,0)}static addDims(i,u){i.addFieldOffset(2,u,0)}static createDimsVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startDimsVector(i,u){i.startVector(8,u,8)}static endSparseTensor(i){return i.endObject()}static createSparseTensor(i,u,l,f){return r.startSparseTensor(i),r.addValues(i,u),r.addIndices(i,l),r.addDims(i,f),r.endSparseTensor(i)}}n.SparseTensor=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsAttribute(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsAttribute(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}name(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}docString(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,i):null}type(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.readInt32(this.bb_pos+i):0}f(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readFloat32(this.bb_pos+i):0}i(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}s(i){let u=this.bb.__offset(this.bb_pos,14);return u?this.bb.__string(this.bb_pos+u,i):null}t(i){let u=this.bb.__offset(this.bb_pos,16);return u?(i||new t.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}g(i){let u=this.bb.__offset(this.bb_pos,18);return u?(i||new t.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}floats(i){let u=this.bb.__offset(this.bb_pos,20);return u?this.bb.readFloat32(this.bb.__vector(this.bb_pos+u)+i*4):0}floatsLength(){let i=this.bb.__offset(this.bb_pos,20);return i?this.bb.__vector_len(this.bb_pos+i):0}floatsArray(){let i=this.bb.__offset(this.bb_pos,20);return i?new Float32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}ints(i){let u=this.bb.__offset(this.bb_pos,22);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}intsLength(){let i=this.bb.__offset(this.bb_pos,22);return i?this.bb.__vector_len(this.bb_pos+i):0}strings(i,u){let l=this.bb.__offset(this.bb_pos,24);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}stringsLength(){let i=this.bb.__offset(this.bb_pos,24);return i?this.bb.__vector_len(this.bb_pos+i):0}tensors(i,u){let l=this.bb.__offset(this.bb_pos,26);return l?(u||new t.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}tensorsLength(){let i=this.bb.__offset(this.bb_pos,26);return i?this.bb.__vector_len(this.bb_pos+i):0}graphs(i,u){let l=this.bb.__offset(this.bb_pos,28);return l?(u||new t.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}graphsLength(){let i=this.bb.__offset(this.bb_pos,28);return i?this.bb.__vector_len(this.bb_pos+i):0}static startAttribute(i){i.startObject(13)}static addName(i,u){i.addFieldOffset(0,u,0)}static addDocString(i,u){i.addFieldOffset(1,u,0)}static addType(i,u){i.addFieldInt32(2,u,0)}static addF(i,u){i.addFieldFloat32(3,u,0)}static addI(i,u){i.addFieldInt64(4,u,i.createLong(0,0))}static addS(i,u){i.addFieldOffset(5,u,0)}static addT(i,u){i.addFieldOffset(6,u,0)}static addG(i,u){i.addFieldOffset(7,u,0)}static addFloats(i,u){i.addFieldOffset(8,u,0)}static createFloatsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addFloat32(u[l]);return i.endVector()}static startFloatsVector(i,u){i.startVector(4,u,4)}static addInts(i,u){i.addFieldOffset(9,u,0)}static createIntsVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startIntsVector(i,u){i.startVector(8,u,8)}static addStrings(i,u){i.addFieldOffset(10,u,0)}static createStringsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startStringsVector(i,u){i.startVector(4,u,4)}static addTensors(i,u){i.addFieldOffset(11,u,0)}static createTensorsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startTensorsVector(i,u){i.startVector(4,u,4)}static addGraphs(i,u){i.addFieldOffset(12,u,0)}static createGraphsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startGraphsVector(i,u){i.startVector(4,u,4)}static endAttribute(i){return i.endObject()}static createAttribute(i,u,l,f,p,d,T,O,v,S,E,F,B,K){return r.startAttribute(i),r.addName(i,u),r.addDocString(i,l),r.addType(i,f),r.addF(i,p),r.addI(i,d),r.addS(i,T),r.addT(i,O),r.addG(i,v),r.addFloats(i,S),r.addInts(i,E),r.addStrings(i,F),r.addTensors(i,B),r.addGraphs(i,K),r.endAttribute(i)}}n.Attribute=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsGraph(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsGraph(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}initializers(i,u){let l=this.bb.__offset(this.bb_pos,4);return l?(u||new t.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}initializersLength(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.__vector_len(this.bb_pos+i):0}nodeArgs(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new t.experimental.fbs.ValueInfo).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}nodeArgsLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}nodes(i,u){let l=this.bb.__offset(this.bb_pos,8);return l?(u||new t.experimental.fbs.Node).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}nodesLength(){let i=this.bb.__offset(this.bb_pos,8);return i?this.bb.__vector_len(this.bb_pos+i):0}maxNodeIndex(){let i=this.bb.__offset(this.bb_pos,10);return i?this.bb.readUint32(this.bb_pos+i):0}nodeEdges(i,u){let l=this.bb.__offset(this.bb_pos,12);return l?(u||new t.experimental.fbs.NodeEdge).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}nodeEdgesLength(){let i=this.bb.__offset(this.bb_pos,12);return i?this.bb.__vector_len(this.bb_pos+i):0}inputs(i,u){let l=this.bb.__offset(this.bb_pos,14);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}inputsLength(){let i=this.bb.__offset(this.bb_pos,14);return i?this.bb.__vector_len(this.bb_pos+i):0}outputs(i,u){let l=this.bb.__offset(this.bb_pos,16);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+i*4,u):null}outputsLength(){let i=this.bb.__offset(this.bb_pos,16);return i?this.bb.__vector_len(this.bb_pos+i):0}sparseInitializers(i,u){let l=this.bb.__offset(this.bb_pos,18);return l?(u||new t.experimental.fbs.SparseTensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}sparseInitializersLength(){let i=this.bb.__offset(this.bb_pos,18);return i?this.bb.__vector_len(this.bb_pos+i):0}static startGraph(i){i.startObject(8)}static addInitializers(i,u){i.addFieldOffset(0,u,0)}static createInitializersVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startInitializersVector(i,u){i.startVector(4,u,4)}static addNodeArgs(i,u){i.addFieldOffset(1,u,0)}static createNodeArgsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startNodeArgsVector(i,u){i.startVector(4,u,4)}static addNodes(i,u){i.addFieldOffset(2,u,0)}static createNodesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startNodesVector(i,u){i.startVector(4,u,4)}static addMaxNodeIndex(i,u){i.addFieldInt32(3,u,0)}static addNodeEdges(i,u){i.addFieldOffset(4,u,0)}static createNodeEdgesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startNodeEdgesVector(i,u){i.startVector(4,u,4)}static addInputs(i,u){i.addFieldOffset(5,u,0)}static createInputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startInputsVector(i,u){i.startVector(4,u,4)}static addOutputs(i,u){i.addFieldOffset(6,u,0)}static createOutputsVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startOutputsVector(i,u){i.startVector(4,u,4)}static addSparseInitializers(i,u){i.addFieldOffset(7,u,0)}static createSparseInitializersVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startSparseInitializersVector(i,u){i.startVector(4,u,4)}static endGraph(i){return i.endObject()}static createGraph(i,u,l,f,p,d,T,O,v){return r.startGraph(i),r.addInitializers(i,u),r.addNodeArgs(i,l),r.addNodes(i,f),r.addMaxNodeIndex(i,p),r.addNodeEdges(i,d),r.addInputs(i,T),r.addOutputs(i,O),r.addSparseInitializers(i,v),r.endGraph(i)}}n.Graph=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsModel(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsModel(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}irVersion(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}opsetImport(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new t.experimental.fbs.OperatorSetId).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}opsetImportLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}producerName(i){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,i):null}producerVersion(i){let u=this.bb.__offset(this.bb_pos,10);return u?this.bb.__string(this.bb_pos+u,i):null}domain(i){let u=this.bb.__offset(this.bb_pos,12);return u?this.bb.__string(this.bb_pos+u,i):null}modelVersion(){let i=this.bb.__offset(this.bb_pos,14);return i?this.bb.readInt64(this.bb_pos+i):this.bb.createLong(0,0)}docString(i){let u=this.bb.__offset(this.bb_pos,16);return u?this.bb.__string(this.bb_pos+u,i):null}graph(i){let u=this.bb.__offset(this.bb_pos,18);return u?(i||new t.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}graphDocString(i){let u=this.bb.__offset(this.bb_pos,20);return u?this.bb.__string(this.bb_pos+u,i):null}static startModel(i){i.startObject(9)}static addIrVersion(i,u){i.addFieldInt64(0,u,i.createLong(0,0))}static addOpsetImport(i,u){i.addFieldOffset(1,u,0)}static createOpsetImportVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startOpsetImportVector(i,u){i.startVector(4,u,4)}static addProducerName(i,u){i.addFieldOffset(2,u,0)}static addProducerVersion(i,u){i.addFieldOffset(3,u,0)}static addDomain(i,u){i.addFieldOffset(4,u,0)}static addModelVersion(i,u){i.addFieldInt64(5,u,i.createLong(0,0))}static addDocString(i,u){i.addFieldOffset(6,u,0)}static addGraph(i,u){i.addFieldOffset(7,u,0)}static addGraphDocString(i,u){i.addFieldOffset(8,u,0)}static endModel(i){return i.endObject()}static createModel(i,u,l,f,p,d,T,O,v,S){return r.startModel(i),r.addIrVersion(i,u),r.addOpsetImport(i,l),r.addProducerName(i,f),r.addProducerVersion(i,p),r.addDomain(i,d),r.addModelVersion(i,T),r.addDocString(i,O),r.addGraph(i,v),r.addGraphDocString(i,S),r.endModel(i)}}n.Model=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsKernelCreateInfos(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsKernelCreateInfos(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}nodeIndices(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.readUint32(this.bb.__vector(this.bb_pos+u)+i*4):0}nodeIndicesLength(){let i=this.bb.__offset(this.bb_pos,4);return i?this.bb.__vector_len(this.bb_pos+i):0}nodeIndicesArray(){let i=this.bb.__offset(this.bb_pos,4);return i?new Uint32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+i),this.bb.__vector_len(this.bb_pos+i)):null}kernelDefHashes(i){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.readUint64(this.bb.__vector(this.bb_pos+u)+i*8):this.bb.createLong(0,0)}kernelDefHashesLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}static startKernelCreateInfos(i){i.startObject(2)}static addNodeIndices(i,u){i.addFieldOffset(0,u,0)}static createNodeIndicesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addInt32(u[l]);return i.endVector()}static startNodeIndicesVector(i,u){i.startVector(4,u,4)}static addKernelDefHashes(i,u){i.addFieldOffset(1,u,0)}static createKernelDefHashesVector(i,u){i.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)i.addInt64(u[l]);return i.endVector()}static startKernelDefHashesVector(i,u){i.startVector(8,u,8)}static endKernelCreateInfos(i){return i.endObject()}static createKernelCreateInfos(i,u,l){return r.startKernelCreateInfos(i),r.addNodeIndices(i,u),r.addKernelDefHashes(i,l),r.endKernelCreateInfos(i)}}n.KernelCreateInfos=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSubGraphSessionState(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSubGraphSessionState(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}graphId(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}sessionState(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new t.experimental.fbs.SessionState).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startSubGraphSessionState(i){i.startObject(2)}static addGraphId(i,u){i.addFieldOffset(0,u,0)}static addSessionState(i,u){i.addFieldOffset(1,u,0)}static endSubGraphSessionState(i){let u=i.endObject();return i.requiredField(u,4),u}static createSubGraphSessionState(i,u,l){return r.startSubGraphSessionState(i),r.addGraphId(i,u),r.addSessionState(i,l),r.endSubGraphSessionState(i)}}n.SubGraphSessionState=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsSessionState(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsSessionState(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}kernels(i){let u=this.bb.__offset(this.bb_pos,4);return u?(i||new t.experimental.fbs.KernelCreateInfos).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}subGraphSessionStates(i,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new t.experimental.fbs.SubGraphSessionState).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+i*4),this.bb):null}subGraphSessionStatesLength(){let i=this.bb.__offset(this.bb_pos,6);return i?this.bb.__vector_len(this.bb_pos+i):0}static startSessionState(i){i.startObject(2)}static addKernels(i,u){i.addFieldOffset(0,u,0)}static addSubGraphSessionStates(i,u){i.addFieldOffset(1,u,0)}static createSubGraphSessionStatesVector(i,u){i.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)i.addOffset(u[l]);return i.endVector()}static startSubGraphSessionStatesVector(i,u){i.startVector(4,u,4)}static endSessionState(i){return i.endObject()}static createSessionState(i,u,l){return r.startSessionState(i),r.addKernels(i,u),r.addSubGraphSessionStates(i,l),r.endSessionState(i)}}n.SessionState=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={});(t=>{let a;(e=>{let o;(n=>{class r{constructor(){this.bb=null;this.bb_pos=0}__init(i,u){return this.bb_pos=i,this.bb=u,this}static getRootAsInferenceSession(i,u){return(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static getSizePrefixedRootAsInferenceSession(i,u){return i.setPosition(i.position()+_.SIZE_PREFIX_LENGTH),(u||new r).__init(i.readInt32(i.position())+i.position(),i)}static bufferHasIdentifier(i){return i.__has_identifier("ORTM")}ortVersion(i){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,i):null}model(i){let u=this.bb.__offset(this.bb_pos,6);return u?(i||new t.experimental.fbs.Model).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}sessionState(i){let u=this.bb.__offset(this.bb_pos,8);return u?(i||new t.experimental.fbs.SessionState).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startInferenceSession(i){i.startObject(3)}static addOrtVersion(i,u){i.addFieldOffset(0,u,0)}static addModel(i,u){i.addFieldOffset(1,u,0)}static addSessionState(i,u){i.addFieldOffset(2,u,0)}static endInferenceSession(i){return i.endObject()}static finishInferenceSessionBuffer(i,u){i.finish(u,"ORTM")}static finishSizePrefixedInferenceSessionBuffer(i,u){i.finish(u,"ORTM",!0)}static createInferenceSession(i,u,l,f){return r.startInferenceSession(i),r.addOrtVersion(i,u),r.addModel(i,l),r.addSessionState(i,f),r.endInferenceSession(i)}}n.InferenceSession=r})(o=e.fbs||={})})(a=t.experimental||={})})(W||={})});var Ns=me((Ty,Bs)=>{"use strict";Bs.exports=Cd;function Cd(a,t){for(var o=new Array(arguments.length-1),e=0,r=2,n=!0;r<arguments.length;)o[e++]=arguments[r++];return new Promise(function(i,u){o[e]=function(f){if(n)if(n=!1,f)u(f);else{for(var p=new Array(arguments.length-1),d=0;d<p.length;)p[d++]=arguments[d];i.apply(null,p)}};try{a.apply(t||null,o)}catch(l){n&&(n=!1,u(l))}})}});var Us=me(Gs=>{"use strict";var Hn=Gs;Hn.length=function(t){var o=t.length;if(!o)return 0;for(var e=0;--o%4>1&&t.charAt(o)==="=";)++e;return Math.ceil(t.length*3)/4-e};var Fr=new Array(64),Ms=new Array(123);for(Ot=0;Ot<64;)Ms[Fr[Ot]=Ot<26?Ot+65:Ot<52?Ot+71:Ot<62?Ot-4:Ot-59|43]=Ot++;var Ot;Hn.encode=function(t,o,e){for(var r=null,n=[],s=0,i=0,u;o<e;){var l=t[o++];switch(i){case 0:n[s++]=Fr[l>>2],u=(l&3)<<4,i=1;break;case 1:n[s++]=Fr[u|l>>4],u=(l&15)<<2,i=2;break;case 2:n[s++]=Fr[u|l>>6],n[s++]=Fr[l&63],i=0;break}s>8191&&((r||(r=[])).push(String.fromCharCode.apply(String,n)),s=0)}return i&&(n[s++]=Fr[u],n[s++]=61,i===1&&(n[s++]=61)),r?(s&&r.push(String.fromCharCode.apply(String,n.slice(0,s))),r.join("")):String.fromCharCode.apply(String,n.slice(0,s))};var Rs="invalid encoding";Hn.decode=function(t,o,e){for(var r=e,n=0,s,i=0;i<t.length;){var u=t.charCodeAt(i++);if(u===61&&n>1)break;if((u=Ms[u])===void 0)throw Error(Rs);switch(n){case 0:s=u,n=1;break;case 1:o[e++]=s<<2|(u&48)>>4,s=u,n=2;break;case 2:o[e++]=(s&15)<<4|(u&60)>>2,s=u,n=3;break;case 3:o[e++]=(s&3)<<6|u,n=0;break}}if(n===1)throw Error(Rs);return e-r};Hn.test=function(t){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(t)}});var Vs=me((vy,zs)=>{"use strict";zs.exports=qn;function qn(){this._listeners={}}qn.prototype.on=function(t,o,e){return(this._listeners[t]||(this._listeners[t]=[])).push({fn:o,ctx:e||this}),this};qn.prototype.off=function(t,o){if(t===void 0)this._listeners={};else if(o===void 0)this._listeners[t]=[];else for(var e=this._listeners[t],r=0;r<e.length;)e[r].fn===o?e.splice(r,1):++r;return this};qn.prototype.emit=function(t){var o=this._listeners[t];if(o){for(var e=[],r=1;r<arguments.length;)e.push(arguments[r++]);for(r=0;r<o.length;)o[r].fn.apply(o[r++].ctx,e)}return this}});var Ks=me((wy,Xs)=>{"use strict";Xs.exports=Ws(Ws);function Ws(a){return typeof Float32Array<"u"?function(){var t=new Float32Array([-0]),o=new Uint8Array(t.buffer),e=o[3]===128;function r(u,l,f){t[0]=u,l[f]=o[0],l[f+1]=o[1],l[f+2]=o[2],l[f+3]=o[3]}function n(u,l,f){t[0]=u,l[f]=o[3],l[f+1]=o[2],l[f+2]=o[1],l[f+3]=o[0]}a.writeFloatLE=e?r:n,a.writeFloatBE=e?n:r;function s(u,l){return o[0]=u[l],o[1]=u[l+1],o[2]=u[l+2],o[3]=u[l+3],t[0]}function i(u,l){return o[3]=u[l],o[2]=u[l+1],o[1]=u[l+2],o[0]=u[l+3],t[0]}a.readFloatLE=e?s:i,a.readFloatBE=e?i:s}():function(){function t(e,r,n,s){var i=r<0?1:0;if(i&&(r=-r),r===0)e(1/r>0?0:2147483648,n,s);else if(isNaN(r))e(2143289344,n,s);else if(r>34028234663852886e22)e((i<<31|2139095040)>>>0,n,s);else if(r<11754943508222875e-54)e((i<<31|Math.round(r/1401298464324817e-60))>>>0,n,s);else{var u=Math.floor(Math.log(r)/Math.LN2),l=Math.round(r*Math.pow(2,-u)*8388608)&8388607;e((i<<31|u+127<<23|l)>>>0,n,s)}}a.writeFloatLE=t.bind(null,Hs),a.writeFloatBE=t.bind(null,qs);function o(e,r,n){var s=e(r,n),i=(s>>31)*2+1,u=s>>>23&255,l=s&8388607;return u===255?l?NaN:i*(1/0):u===0?i*1401298464324817e-60*l:i*Math.pow(2,u-150)*(l+8388608)}a.readFloatLE=o.bind(null,js),a.readFloatBE=o.bind(null,Ys)}(),typeof Float64Array<"u"?function(){var t=new Float64Array([-0]),o=new Uint8Array(t.buffer),e=o[7]===128;function r(u,l,f){t[0]=u,l[f]=o[0],l[f+1]=o[1],l[f+2]=o[2],l[f+3]=o[3],l[f+4]=o[4],l[f+5]=o[5],l[f+6]=o[6],l[f+7]=o[7]}function n(u,l,f){t[0]=u,l[f]=o[7],l[f+1]=o[6],l[f+2]=o[5],l[f+3]=o[4],l[f+4]=o[3],l[f+5]=o[2],l[f+6]=o[1],l[f+7]=o[0]}a.writeDoubleLE=e?r:n,a.writeDoubleBE=e?n:r;function s(u,l){return o[0]=u[l],o[1]=u[l+1],o[2]=u[l+2],o[3]=u[l+3],o[4]=u[l+4],o[5]=u[l+5],o[6]=u[l+6],o[7]=u[l+7],t[0]}function i(u,l){return o[7]=u[l],o[6]=u[l+1],o[5]=u[l+2],o[4]=u[l+3],o[3]=u[l+4],o[2]=u[l+5],o[1]=u[l+6],o[0]=u[l+7],t[0]}a.readDoubleLE=e?s:i,a.readDoubleBE=e?i:s}():function(){function t(e,r,n,s,i,u){var l=s<0?1:0;if(l&&(s=-s),s===0)e(0,i,u+r),e(1/s>0?0:2147483648,i,u+n);else if(isNaN(s))e(0,i,u+r),e(2146959360,i,u+n);else if(s>17976931348623157e292)e(0,i,u+r),e((l<<31|2146435072)>>>0,i,u+n);else{var f;if(s<22250738585072014e-324)f=s/5e-324,e(f>>>0,i,u+r),e((l<<31|f/4294967296)>>>0,i,u+n);else{var p=Math.floor(Math.log(s)/Math.LN2);p===1024&&(p=1023),f=s*Math.pow(2,-p),e(f*4503599627370496>>>0,i,u+r),e((l<<31|p+1023<<20|f*1048576&1048575)>>>0,i,u+n)}}}a.writeDoubleLE=t.bind(null,Hs,0,4),a.writeDoubleBE=t.bind(null,qs,4,0);function o(e,r,n,s,i){var u=e(s,i+r),l=e(s,i+n),f=(l>>31)*2+1,p=l>>>20&2047,d=4294967296*(l&1048575)+u;return p===2047?d?NaN:f*(1/0):p===0?f*5e-324*d:f*Math.pow(2,p-1075)*(d+4503599627370496)}a.readDoubleLE=o.bind(null,js,0,4),a.readDoubleBE=o.bind(null,Ys,4,0)}(),a}function Hs(a,t,o){t[o]=a&255,t[o+1]=a>>>8&255,t[o+2]=a>>>16&255,t[o+3]=a>>>24}function qs(a,t,o){t[o]=a>>>24,t[o+1]=a>>>16&255,t[o+2]=a>>>8&255,t[o+3]=a&255}function js(a,t){return(a[t]|a[t+1]<<8|a[t+2]<<16|a[t+3]<<24)>>>0}function Ys(a,t){return(a[t]<<24|a[t+1]<<16|a[t+2]<<8|a[t+3])>>>0}});var Js=me((exports,module)=>{"use strict";module.exports=inquire;function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(a){}return null}});var Qs=me(Zs=>{"use strict";var ri=Zs;ri.length=function(t){for(var o=0,e=0,r=0;r<t.length;++r)e=t.charCodeAt(r),e<128?o+=1:e<2048?o+=2:(e&64512)===55296&&(t.charCodeAt(r+1)&64512)===56320?(++r,o+=4):o+=3;return o};ri.read=function(t,o,e){var r=e-o;if(r<1)return"";for(var n=null,s=[],i=0,u;o<e;)u=t[o++],u<128?s[i++]=u:u>191&&u<224?s[i++]=(u&31)<<6|t[o++]&63:u>239&&u<365?(u=((u&7)<<18|(t[o++]&63)<<12|(t[o++]&63)<<6|t[o++]&63)-65536,s[i++]=55296+(u>>10),s[i++]=56320+(u&1023)):s[i++]=(u&15)<<12|(t[o++]&63)<<6|t[o++]&63,i>8191&&((n||(n=[])).push(String.fromCharCode.apply(String,s)),i=0);return n?(i&&n.push(String.fromCharCode.apply(String,s.slice(0,i))),n.join("")):String.fromCharCode.apply(String,s.slice(0,i))};ri.write=function(t,o,e){for(var r=e,n,s,i=0;i<t.length;++i)n=t.charCodeAt(i),n<128?o[e++]=n:n<2048?(o[e++]=n>>6|192,o[e++]=n&63|128):(n&64512)===55296&&((s=t.charCodeAt(i+1))&64512)===56320?(n=65536+((n&1023)<<10)+(s&1023),++i,o[e++]=n>>18|240,o[e++]=n>>12&63|128,o[e++]=n>>6&63|128,o[e++]=n&63|128):(o[e++]=n>>12|224,o[e++]=n>>6&63|128,o[e++]=n&63|128);return e-r}});var tu=me((Oy,eu)=>{"use strict";eu.exports=kd;function kd(a,t,o){var e=o||8192,r=e>>>1,n=null,s=e;return function(u){if(u<1||u>r)return a(u);s+u>e&&(n=a(e),s=0);var l=t.call(n,s,s+=u);return s&7&&(s=(s|7)+1),l}}});var nu=me((Iy,ru)=>{"use strict";ru.exports=Me;var rn=Qt();function Me(a,t){this.lo=a>>>0,this.hi=t>>>0}var fr=Me.zero=new Me(0,0);fr.toNumber=function(){return 0};fr.zzEncode=fr.zzDecode=function(){return this};fr.length=function(){return 1};var Bd=Me.zeroHash="\0\0\0\0\0\0\0\0";Me.fromNumber=function(t){if(t===0)return fr;var o=t<0;o&&(t=-t);var e=t>>>0,r=(t-e)/4294967296>>>0;return o&&(r=~r>>>0,e=~e>>>0,++e>4294967295&&(e=0,++r>4294967295&&(r=0))),new Me(e,r)};Me.from=function(t){if(typeof t=="number")return Me.fromNumber(t);if(rn.isString(t))if(rn.Long)t=rn.Long.fromString(t);else return Me.fromNumber(parseInt(t,10));return t.low||t.high?new Me(t.low>>>0,t.high>>>0):fr};Me.prototype.toNumber=function(t){if(!t&&this.hi>>>31){var o=~this.lo+1>>>0,e=~this.hi>>>0;return o||(e=e+1>>>0),-(o+e*4294967296)}return this.lo+this.hi*4294967296};Me.prototype.toLong=function(t){return rn.Long?new rn.Long(this.lo|0,this.hi|0,!!t):{low:this.lo|0,high:this.hi|0,unsigned:!!t}};var Zt=String.prototype.charCodeAt;Me.fromHash=function(t){return t===Bd?fr:new Me((Zt.call(t,0)|Zt.call(t,1)<<8|Zt.call(t,2)<<16|Zt.call(t,3)<<24)>>>0,(Zt.call(t,4)|Zt.call(t,5)<<8|Zt.call(t,6)<<16|Zt.call(t,7)<<24)>>>0)};Me.prototype.toHash=function(){return String.fromCharCode(this.lo&255,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,this.hi&255,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)};Me.prototype.zzEncode=function(){var t=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^t)>>>0,this.lo=(this.lo<<1^t)>>>0,this};Me.prototype.zzDecode=function(){var t=-(this.lo&1);return this.lo=((this.lo>>>1|this.hi<<31)^t)>>>0,this.hi=(this.hi>>>1^t)>>>0,this};Me.prototype.length=function(){var t=this.lo,o=(this.lo>>>28|this.hi<<4)>>>0,e=this.hi>>>24;return e===0?o===0?t<16384?t<128?1:2:t<2097152?3:4:o<16384?o<128?5:6:o<2097152?7:8:e<128?9:10}});var Qt=me(ni=>{"use strict";var H=ni;H.asPromise=Ns();H.base64=Us();H.EventEmitter=Vs();H.float=Ks();H.inquire=Js();H.utf8=Qs();H.pool=tu();H.LongBits=nu();H.isNode=!!(typeof global<"u"&&global&&global.process&&global.process.versions&&global.process.versions.node);H.global=H.isNode&&global||typeof window<"u"&&window||typeof self<"u"&&self||ni;H.emptyArray=Object.freeze?Object.freeze([]):[];H.emptyObject=Object.freeze?Object.freeze({}):{};H.isInteger=Number.isInteger||function(t){return typeof t=="number"&&isFinite(t)&&Math.floor(t)===t};H.isString=function(t){return typeof t=="string"||t instanceof String};H.isObject=function(t){return t&&typeof t=="object"};H.isset=H.isSet=function(t,o){var e=t[o];return e!=null&&t.hasOwnProperty(o)?typeof e!="object"||(Array.isArray(e)?e.length:Object.keys(e).length)>0:!1};H.Buffer=function(){try{var a=H.inquire("buffer").Buffer;return a.prototype.utf8Write?a:null}catch{return null}}();H._Buffer_from=null;H._Buffer_allocUnsafe=null;H.newBuffer=function(t){return typeof t=="number"?H.Buffer?H._Buffer_allocUnsafe(t):new H.Array(t):H.Buffer?H._Buffer_from(t):typeof Uint8Array>"u"?t:new Uint8Array(t)};H.Array=typeof Uint8Array<"u"?Uint8Array:Array;H.Long=H.global.dcodeIO&&H.global.dcodeIO.Long||H.global.Long||H.inquire("long");H.key2Re=/^true|false|0|1$/;H.key32Re=/^-?(?:0|[1-9][0-9]*)$/;H.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;H.longToHash=function(t){return t?H.LongBits.from(t).toHash():H.LongBits.zeroHash};H.longFromHash=function(t,o){var e=H.LongBits.fromHash(t);return H.Long?H.Long.fromBits(e.lo,e.hi,o):e.toNumber(!!o)};function ou(a,t,o){for(var e=Object.keys(t),r=0;r<e.length;++r)(a[e[r]]===void 0||!o)&&(a[e[r]]=t[e[r]]);return a}H.merge=ou;H.lcFirst=function(t){return t.charAt(0).toLowerCase()+t.substring(1)};function iu(a){function t(o,e){if(!(this instanceof t))return new t(o,e);Object.defineProperty(this,"message",{get:function(){return o}}),Error.captureStackTrace?Error.captureStackTrace(this,t):Object.defineProperty(this,"stack",{value:new Error().stack||""}),e&&ou(this,e)}return t.prototype=Object.create(Error.prototype,{constructor:{value:t,writable:!0,enumerable:!1,configurable:!0},name:{get:function(){return a},set:void 0,enumerable:!1,configurable:!0},toString:{value:function(){return this.name+": "+this.message},writable:!0,enumerable:!1,configurable:!0}}),t}H.newError=iu;H.ProtocolError=iu("ProtocolError");H.oneOfGetter=function(t){for(var o={},e=0;e<t.length;++e)o[t[e]]=1;return function(){for(var r=Object.keys(this),n=r.length-1;n>-1;--n)if(o[r[n]]===1&&this[r[n]]!==void 0&&this[r[n]]!==null)return r[n]}};H.oneOfSetter=function(t){return function(o){for(var e=0;e<t.length;++e)t[e]!==o&&delete this[t[e]]}};H.toJSONOptions={longs:String,enums:String,bytes:String,json:!0};H._configure=function(){var a=H.Buffer;if(!a){H._Buffer_from=H._Buffer_allocUnsafe=null;return}H._Buffer_from=a.from!==Uint8Array.from&&a.from||function(o,e){return new a(o,e)},H._Buffer_allocUnsafe=a.allocUnsafe||function(o){return new a(o)}}});var fi=me((Ay,lu)=>{"use strict";lu.exports=se;var ct=Qt(),oi,jn=ct.LongBits,au=ct.base64,su=ct.utf8;function nn(a,t,o){this.fn=a,this.len=t,this.next=void 0,this.val=o}function ai(){}function Nd(a){this.head=a.head,this.tail=a.tail,this.len=a.len,this.next=a.states}function se(){this.len=0,this.head=new nn(ai,0,0),this.tail=this.head,this.states=null}var uu=function(){return ct.Buffer?function(){return(se.create=function(){return new oi})()}:function(){return new se}};se.create=uu();se.alloc=function(t){return new ct.Array(t)};ct.Array!==Array&&(se.alloc=ct.pool(se.alloc,ct.Array.prototype.subarray));se.prototype._push=function(t,o,e){return this.tail=this.tail.next=new nn(t,o,e),this.len+=o,this};function si(a,t,o){t[o]=a&255}function Rd(a,t,o){for(;a>127;)t[o++]=a&127|128,a>>>=7;t[o]=a}function ui(a,t){this.len=a,this.next=void 0,this.val=t}ui.prototype=Object.create(nn.prototype);ui.prototype.fn=Rd;se.prototype.uint32=function(t){return this.len+=(this.tail=this.tail.next=new ui((t=t>>>0)<128?1:t<16384?2:t<2097152?3:t<268435456?4:5,t)).len,this};se.prototype.int32=function(t){return t<0?this._push(li,10,jn.fromNumber(t)):this.uint32(t)};se.prototype.sint32=function(t){return this.uint32((t<<1^t>>31)>>>0)};function li(a,t,o){for(;a.hi;)t[o++]=a.lo&127|128,a.lo=(a.lo>>>7|a.hi<<25)>>>0,a.hi>>>=7;for(;a.lo>127;)t[o++]=a.lo&127|128,a.lo=a.lo>>>7;t[o++]=a.lo}se.prototype.uint64=function(t){var o=jn.from(t);return this._push(li,o.length(),o)};se.prototype.int64=se.prototype.uint64;se.prototype.sint64=function(t){var o=jn.from(t).zzEncode();return this._push(li,o.length(),o)};se.prototype.bool=function(t){return this._push(si,1,t?1:0)};function ii(a,t,o){t[o]=a&255,t[o+1]=a>>>8&255,t[o+2]=a>>>16&255,t[o+3]=a>>>24}se.prototype.fixed32=function(t){return this._push(ii,4,t>>>0)};se.prototype.sfixed32=se.prototype.fixed32;se.prototype.fixed64=function(t){var o=jn.from(t);return this._push(ii,4,o.lo)._push(ii,4,o.hi)};se.prototype.sfixed64=se.prototype.fixed64;se.prototype.float=function(t){return this._push(ct.float.writeFloatLE,4,t)};se.prototype.double=function(t){return this._push(ct.float.writeDoubleLE,8,t)};var Md=ct.Array.prototype.set?function(t,o,e){o.set(t,e)}:function(t,o,e){for(var r=0;r<t.length;++r)o[e+r]=t[r]};se.prototype.bytes=function(t){var o=t.length>>>0;if(!o)return this._push(si,1,0);if(ct.isString(t)){var e=se.alloc(o=au.length(t));au.decode(t,e,0),t=e}return this.uint32(o)._push(Md,o,t)};se.prototype.string=function(t){var o=su.length(t);return o?this.uint32(o)._push(su.write,o,t):this._push(si,1,0)};se.prototype.fork=function(){return this.states=new Nd(this),this.head=this.tail=new nn(ai,0,0),this.len=0,this};se.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new nn(ai,0,0),this.len=0),this};se.prototype.ldelim=function(){var t=this.head,o=this.tail,e=this.len;return this.reset().uint32(e),e&&(this.tail.next=t.next,this.tail=o,this.len+=e),this};se.prototype.finish=function(){for(var t=this.head.next,o=this.constructor.alloc(this.len),e=0;t;)t.fn(t.val,o,e),e+=t.len,t=t.next;return o};se._configure=function(a){oi=a,se.create=uu(),oi._configure()}});var pu=me((Py,cu)=>{"use strict";cu.exports=Dt;var fu=fi();(Dt.prototype=Object.create(fu.prototype)).constructor=Dt;var er=Qt();function Dt(){fu.call(this)}Dt._configure=function(){Dt.alloc=er._Buffer_allocUnsafe,Dt.writeBytesBuffer=er.Buffer&&er.Buffer.prototype instanceof Uint8Array&&er.Buffer.prototype.set.name==="set"?function(t,o,e){o.set(t,e)}:function(t,o,e){if(t.copy)t.copy(o,e,0,t.length);else for(var r=0;r<t.length;)o[e++]=t[r++]}};Dt.prototype.bytes=function(t){er.isString(t)&&(t=er._Buffer_from(t,"base64"));var o=t.length>>>0;return this.uint32(o),o&&this._push(Dt.writeBytesBuffer,o,t),this};function Gd(a,t,o){a.length<40?er.utf8.write(a,t,o):t.utf8Write?t.utf8Write(a,o):t.write(a,o)}Dt.prototype.string=function(t){var o=er.Buffer.byteLength(t);return this.uint32(o),o&&this._push(Gd,o,t),this};Dt._configure()});var di=me((Ey,gu)=>{"use strict";gu.exports=Se;var Lt=Qt(),pi,mu=Lt.LongBits,Ud=Lt.utf8;function It(a,t){return RangeError("index out of range: "+a.pos+" + "+(t||1)+" > "+a.len)}function Se(a){this.buf=a,this.pos=0,this.len=a.length}var du=typeof Uint8Array<"u"?function(t){if(t instanceof Uint8Array||Array.isArray(t))return new Se(t);throw Error("illegal buffer")}:function(t){if(Array.isArray(t))return new Se(t);throw Error("illegal buffer")},bu=function(){return Lt.Buffer?function(o){return(Se.create=function(r){return Lt.Buffer.isBuffer(r)?new pi(r):du(r)})(o)}:du};Se.create=bu();Se.prototype._slice=Lt.Array.prototype.subarray||Lt.Array.prototype.slice;Se.prototype.uint32=function(){var t=4294967295;return function(){if(t=(this.buf[this.pos]&127)>>>0,this.buf[this.pos++]<128||(t=(t|(this.buf[this.pos]&127)<<7)>>>0,this.buf[this.pos++]<128)||(t=(t|(this.buf[this.pos]&127)<<14)>>>0,this.buf[this.pos++]<128)||(t=(t|(this.buf[this.pos]&127)<<21)>>>0,this.buf[this.pos++]<128)||(t=(t|(this.buf[this.pos]&15)<<28)>>>0,this.buf[this.pos++]<128))return t;if((this.pos+=5)>this.len)throw this.pos=this.len,It(this,10);return t}}();Se.prototype.int32=function(){return this.uint32()|0};Se.prototype.sint32=function(){var t=this.uint32();return t>>>1^-(t&1)|0};function ci(){var a=new mu(0,0),t=0;if(this.len-this.pos>4){for(;t<4;++t)if(a.lo=(a.lo|(this.buf[this.pos]&127)<<t*7)>>>0,this.buf[this.pos++]<128)return a;if(a.lo=(a.lo|(this.buf[this.pos]&127)<<28)>>>0,a.hi=(a.hi|(this.buf[this.pos]&127)>>4)>>>0,this.buf[this.pos++]<128)return a;t=0}else{for(;t<3;++t){if(this.pos>=this.len)throw It(this);if(a.lo=(a.lo|(this.buf[this.pos]&127)<<t*7)>>>0,this.buf[this.pos++]<128)return a}return a.lo=(a.lo|(this.buf[this.pos++]&127)<<t*7)>>>0,a}if(this.len-this.pos>4){for(;t<5;++t)if(a.hi=(a.hi|(this.buf[this.pos]&127)<<t*7+3)>>>0,this.buf[this.pos++]<128)return a}else for(;t<5;++t){if(this.pos>=this.len)throw It(this);if(a.hi=(a.hi|(this.buf[this.pos]&127)<<t*7+3)>>>0,this.buf[this.pos++]<128)return a}throw Error("invalid varint encoding")}Se.prototype.bool=function(){return this.uint32()!==0};function Yn(a,t){return(a[t-4]|a[t-3]<<8|a[t-2]<<16|a[t-1]<<24)>>>0}Se.prototype.fixed32=function(){if(this.pos+4>this.len)throw It(this,4);return Yn(this.buf,this.pos+=4)};Se.prototype.sfixed32=function(){if(this.pos+4>this.len)throw It(this,4);return Yn(this.buf,this.pos+=4)|0};function hu(){if(this.pos+8>this.len)throw It(this,8);return new mu(Yn(this.buf,this.pos+=4),Yn(this.buf,this.pos+=4))}Se.prototype.float=function(){if(this.pos+4>this.len)throw It(this,4);var t=Lt.float.readFloatLE(this.buf,this.pos);return this.pos+=4,t};Se.prototype.double=function(){if(this.pos+8>this.len)throw It(this,4);var t=Lt.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,t};Se.prototype.bytes=function(){var t=this.uint32(),o=this.pos,e=this.pos+t;if(e>this.len)throw It(this,t);return this.pos+=t,Array.isArray(this.buf)?this.buf.slice(o,e):o===e?new this.buf.constructor(0):this._slice.call(this.buf,o,e)};Se.prototype.string=function(){var t=this.bytes();return Ud.read(t,0,t.length)};Se.prototype.skip=function(t){if(typeof t=="number"){if(this.pos+t>this.len)throw It(this,t);this.pos+=t}else do if(this.pos>=this.len)throw It(this);while(this.buf[this.pos++]&128);return this};Se.prototype.skipType=function(a){switch(a){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;(a=this.uint32()&7)!==4;)this.skipType(a);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+a+" at offset "+this.pos)}return this};Se._configure=function(a){pi=a,Se.create=bu(),pi._configure();var t=Lt.Long?"toLong":"toNumber";Lt.merge(Se.prototype,{int64:function(){return ci.call(this)[t](!1)},uint64:function(){return ci.call(this)[t](!0)},sint64:function(){return ci.call(this).zzDecode()[t](!1)},fixed64:function(){return hu.call(this)[t](!0)},sfixed64:function(){return hu.call(this)[t](!1)}})}});var vu=me((Dy,xu)=>{"use strict";xu.exports=cr;var Tu=di();(cr.prototype=Object.create(Tu.prototype)).constructor=cr;var yu=Qt();function cr(a){Tu.call(this,a)}cr._configure=function(){yu.Buffer&&(cr.prototype._slice=yu.Buffer.prototype.slice)};cr.prototype.string=function(){var t=this.uint32();return this.buf.utf8Slice?this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+t,this.len)):this.buf.toString("utf-8",this.pos,this.pos=Math.min(this.pos+t,this.len))};cr._configure()});var _u=me((Ly,wu)=>{"use strict";wu.exports=on;var hi=Qt();(on.prototype=Object.create(hi.EventEmitter.prototype)).constructor=on;function on(a,t,o){if(typeof a!="function")throw TypeError("rpcImpl must be a function");hi.EventEmitter.call(this),this.rpcImpl=a,this.requestDelimited=!!t,this.responseDelimited=!!o}on.prototype.rpcCall=function a(t,o,e,r,n){if(!r)throw TypeError("request must be specified");var s=this;if(!n)return hi.asPromise(a,s,t,o,e,r);if(!s.rpcImpl){setTimeout(function(){n(Error("already ended"))},0);return}try{return s.rpcImpl(t,o[s.requestDelimited?"encodeDelimited":"encode"](r).finish(),function(u,l){if(u)return s.emit("error",u,t),n(u);if(l===null){s.end(!0);return}if(!(l instanceof e))try{l=e[s.responseDelimited?"decodeDelimited":"decode"](l)}catch(f){return s.emit("error",f,t),n(f)}return s.emit("data",l,t),n(null,l)})}catch(i){s.emit("error",i,t),setTimeout(function(){n(i)},0);return}};on.prototype.end=function(t){return this.rpcImpl&&(t||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}});var Iu=me(Ou=>{"use strict";var zd=Ou;zd.Service=_u()});var Au=me(($y,Su)=>{"use strict";Su.exports={}});var Du=me(Eu=>{"use strict";var rt=Eu;rt.build="minimal";rt.Writer=fi();rt.BufferWriter=pu();rt.Reader=di();rt.BufferReader=vu();rt.util=Qt();rt.rpc=Iu();rt.roots=Au();rt.configure=Pu;function Pu(){rt.util._configure(),rt.Writer._configure(rt.BufferWriter),rt.Reader._configure(rt.BufferReader)}Pu()});var Fu=me((ky,Lu)=>{"use strict";Lu.exports=Du()});var $r=me((By,$u)=>{"use strict";var ge=Fu(),N=ge.Reader,Ae=ge.Writer,y=ge.util,m=ge.roots.default||(ge.roots.default={});m.onnx=function(){var a={};return a.Version=function(){var t={},o=Object.create(t);return o[t[0]="_START_VERSION"]=0,o[t[1]="IR_VERSION_2017_10_10"]=1,o[t[2]="IR_VERSION_2017_10_30"]=2,o[t[3]="IR_VERSION_2017_11_3"]=3,o[t[4]="IR_VERSION_2019_1_22"]=4,o[t[5]="IR_VERSION_2019_3_18"]=5,o[t[6]="IR_VERSION_2019_9_19"]=6,o[t[7]="IR_VERSION_2020_5_8"]=7,o[t[8]="IR_VERSION_2021_7_30"]=8,o[t[9]="IR_VERSION"]=9,o}(),a.AttributeProto=function(){function t(o){if(this.floats=[],this.ints=[],this.strings=[],this.tensors=[],this.graphs=[],this.sparseTensors=[],this.typeProtos=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.name="",t.prototype.refAttrName="",t.prototype.docString="",t.prototype.type=0,t.prototype.f=0,t.prototype.i=y.Long?y.Long.fromBits(0,0,!1):0,t.prototype.s=y.newBuffer([]),t.prototype.t=null,t.prototype.g=null,t.prototype.sparseTensor=null,t.prototype.tp=null,t.prototype.floats=y.emptyArray,t.prototype.ints=y.emptyArray,t.prototype.strings=y.emptyArray,t.prototype.tensors=y.emptyArray,t.prototype.graphs=y.emptyArray,t.prototype.sparseTensors=y.emptyArray,t.prototype.typeProtos=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.name!=null&&Object.hasOwnProperty.call(e,"name")&&r.uint32(10).string(e.name),e.f!=null&&Object.hasOwnProperty.call(e,"f")&&r.uint32(21).float(e.f),e.i!=null&&Object.hasOwnProperty.call(e,"i")&&r.uint32(24).int64(e.i),e.s!=null&&Object.hasOwnProperty.call(e,"s")&&r.uint32(34).bytes(e.s),e.t!=null&&Object.hasOwnProperty.call(e,"t")&&m.onnx.TensorProto.encode(e.t,r.uint32(42).fork()).ldelim(),e.g!=null&&Object.hasOwnProperty.call(e,"g")&&m.onnx.GraphProto.encode(e.g,r.uint32(50).fork()).ldelim(),e.floats!=null&&e.floats.length){r.uint32(58).fork();for(var n=0;n<e.floats.length;++n)r.float(e.floats[n]);r.ldelim()}if(e.ints!=null&&e.ints.length){r.uint32(66).fork();for(var n=0;n<e.ints.length;++n)r.int64(e.ints[n]);r.ldelim()}if(e.strings!=null&&e.strings.length)for(var n=0;n<e.strings.length;++n)r.uint32(74).bytes(e.strings[n]);if(e.tensors!=null&&e.tensors.length)for(var n=0;n<e.tensors.length;++n)m.onnx.TensorProto.encode(e.tensors[n],r.uint32(82).fork()).ldelim();if(e.graphs!=null&&e.graphs.length)for(var n=0;n<e.graphs.length;++n)m.onnx.GraphProto.encode(e.graphs[n],r.uint32(90).fork()).ldelim();if(e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(106).string(e.docString),e.tp!=null&&Object.hasOwnProperty.call(e,"tp")&&m.onnx.TypeProto.encode(e.tp,r.uint32(114).fork()).ldelim(),e.typeProtos!=null&&e.typeProtos.length)for(var n=0;n<e.typeProtos.length;++n)m.onnx.TypeProto.encode(e.typeProtos[n],r.uint32(122).fork()).ldelim();if(e.type!=null&&Object.hasOwnProperty.call(e,"type")&&r.uint32(160).int32(e.type),e.refAttrName!=null&&Object.hasOwnProperty.call(e,"refAttrName")&&r.uint32(170).string(e.refAttrName),e.sparseTensor!=null&&Object.hasOwnProperty.call(e,"sparseTensor")&&m.onnx.SparseTensorProto.encode(e.sparseTensor,r.uint32(178).fork()).ldelim(),e.sparseTensors!=null&&e.sparseTensors.length)for(var n=0;n<e.sparseTensors.length;++n)m.onnx.SparseTensorProto.encode(e.sparseTensors[n],r.uint32(186).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.AttributeProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.name=e.string();break}case 21:{s.refAttrName=e.string();break}case 13:{s.docString=e.string();break}case 20:{s.type=e.int32();break}case 2:{s.f=e.float();break}case 3:{s.i=e.int64();break}case 4:{s.s=e.bytes();break}case 5:{s.t=m.onnx.TensorProto.decode(e,e.uint32());break}case 6:{s.g=m.onnx.GraphProto.decode(e,e.uint32());break}case 22:{s.sparseTensor=m.onnx.SparseTensorProto.decode(e,e.uint32());break}case 14:{s.tp=m.onnx.TypeProto.decode(e,e.uint32());break}case 7:{if(s.floats&&s.floats.length||(s.floats=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.floats.push(e.float());else s.floats.push(e.float());break}case 8:{if(s.ints&&s.ints.length||(s.ints=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.ints.push(e.int64());else s.ints.push(e.int64());break}case 9:{s.strings&&s.strings.length||(s.strings=[]),s.strings.push(e.bytes());break}case 10:{s.tensors&&s.tensors.length||(s.tensors=[]),s.tensors.push(m.onnx.TensorProto.decode(e,e.uint32()));break}case 11:{s.graphs&&s.graphs.length||(s.graphs=[]),s.graphs.push(m.onnx.GraphProto.decode(e,e.uint32()));break}case 23:{s.sparseTensors&&s.sparseTensors.length||(s.sparseTensors=[]),s.sparseTensors.push(m.onnx.SparseTensorProto.decode(e,e.uint32()));break}case 15:{s.typeProtos&&s.typeProtos.length||(s.typeProtos=[]),s.typeProtos.push(m.onnx.TypeProto.decode(e,e.uint32()));break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.name!=null&&e.hasOwnProperty("name")&&!y.isString(e.name))return"name: string expected";if(e.refAttrName!=null&&e.hasOwnProperty("refAttrName")&&!y.isString(e.refAttrName))return"refAttrName: string expected";if(e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString))return"docString: string expected";if(e.type!=null&&e.hasOwnProperty("type"))switch(e.type){default:return"type: enum value expected";case 0:case 1:case 2:case 3:case 4:case 5:case 11:case 13:case 6:case 7:case 8:case 9:case 10:case 12:case 14:break}if(e.f!=null&&e.hasOwnProperty("f")&&typeof e.f!="number")return"f: number expected";if(e.i!=null&&e.hasOwnProperty("i")&&!y.isInteger(e.i)&&!(e.i&&y.isInteger(e.i.low)&&y.isInteger(e.i.high)))return"i: integer|Long expected";if(e.s!=null&&e.hasOwnProperty("s")&&!(e.s&&typeof e.s.length=="number"||y.isString(e.s)))return"s: buffer expected";if(e.t!=null&&e.hasOwnProperty("t")){var r=m.onnx.TensorProto.verify(e.t);if(r)return"t."+r}if(e.g!=null&&e.hasOwnProperty("g")){var r=m.onnx.GraphProto.verify(e.g);if(r)return"g."+r}if(e.sparseTensor!=null&&e.hasOwnProperty("sparseTensor")){var r=m.onnx.SparseTensorProto.verify(e.sparseTensor);if(r)return"sparseTensor."+r}if(e.tp!=null&&e.hasOwnProperty("tp")){var r=m.onnx.TypeProto.verify(e.tp);if(r)return"tp."+r}if(e.floats!=null&&e.hasOwnProperty("floats")){if(!Array.isArray(e.floats))return"floats: array expected";for(var n=0;n<e.floats.length;++n)if(typeof e.floats[n]!="number")return"floats: number[] expected"}if(e.ints!=null&&e.hasOwnProperty("ints")){if(!Array.isArray(e.ints))return"ints: array expected";for(var n=0;n<e.ints.length;++n)if(!y.isInteger(e.ints[n])&&!(e.ints[n]&&y.isInteger(e.ints[n].low)&&y.isInteger(e.ints[n].high)))return"ints: integer|Long[] expected"}if(e.strings!=null&&e.hasOwnProperty("strings")){if(!Array.isArray(e.strings))return"strings: array expected";for(var n=0;n<e.strings.length;++n)if(!(e.strings[n]&&typeof e.strings[n].length=="number"||y.isString(e.strings[n])))return"strings: buffer[] expected"}if(e.tensors!=null&&e.hasOwnProperty("tensors")){if(!Array.isArray(e.tensors))return"tensors: array expected";for(var n=0;n<e.tensors.length;++n){var r=m.onnx.TensorProto.verify(e.tensors[n]);if(r)return"tensors."+r}}if(e.graphs!=null&&e.hasOwnProperty("graphs")){if(!Array.isArray(e.graphs))return"graphs: array expected";for(var n=0;n<e.graphs.length;++n){var r=m.onnx.GraphProto.verify(e.graphs[n]);if(r)return"graphs."+r}}if(e.sparseTensors!=null&&e.hasOwnProperty("sparseTensors")){if(!Array.isArray(e.sparseTensors))return"sparseTensors: array expected";for(var n=0;n<e.sparseTensors.length;++n){var r=m.onnx.SparseTensorProto.verify(e.sparseTensors[n]);if(r)return"sparseTensors."+r}}if(e.typeProtos!=null&&e.hasOwnProperty("typeProtos")){if(!Array.isArray(e.typeProtos))return"typeProtos: array expected";for(var n=0;n<e.typeProtos.length;++n){var r=m.onnx.TypeProto.verify(e.typeProtos[n]);if(r)return"typeProtos."+r}}return null},t.fromObject=function(e){if(e instanceof m.onnx.AttributeProto)return e;var r=new m.onnx.AttributeProto;switch(e.name!=null&&(r.name=String(e.name)),e.refAttrName!=null&&(r.refAttrName=String(e.refAttrName)),e.docString!=null&&(r.docString=String(e.docString)),e.type){default:if(typeof e.type=="number"){r.type=e.type;break}break;case"UNDEFINED":case 0:r.type=0;break;case"FLOAT":case 1:r.type=1;break;case"INT":case 2:r.type=2;break;case"STRING":case 3:r.type=3;break;case"TENSOR":case 4:r.type=4;break;case"GRAPH":case 5:r.type=5;break;case"SPARSE_TENSOR":case 11:r.type=11;break;case"TYPE_PROTO":case 13:r.type=13;break;case"FLOATS":case 6:r.type=6;break;case"INTS":case 7:r.type=7;break;case"STRINGS":case 8:r.type=8;break;case"TENSORS":case 9:r.type=9;break;case"GRAPHS":case 10:r.type=10;break;case"SPARSE_TENSORS":case 12:r.type=12;break;case"TYPE_PROTOS":case 14:r.type=14;break}if(e.f!=null&&(r.f=Number(e.f)),e.i!=null&&(y.Long?(r.i=y.Long.fromValue(e.i)).unsigned=!1:typeof e.i=="string"?r.i=parseInt(e.i,10):typeof e.i=="number"?r.i=e.i:typeof e.i=="object"&&(r.i=new y.LongBits(e.i.low>>>0,e.i.high>>>0).toNumber())),e.s!=null&&(typeof e.s=="string"?y.base64.decode(e.s,r.s=y.newBuffer(y.base64.length(e.s)),0):e.s.length>=0&&(r.s=e.s)),e.t!=null){if(typeof e.t!="object")throw TypeError(".onnx.AttributeProto.t: object expected");r.t=m.onnx.TensorProto.fromObject(e.t)}if(e.g!=null){if(typeof e.g!="object")throw TypeError(".onnx.AttributeProto.g: object expected");r.g=m.onnx.GraphProto.fromObject(e.g)}if(e.sparseTensor!=null){if(typeof e.sparseTensor!="object")throw TypeError(".onnx.AttributeProto.sparseTensor: object expected");r.sparseTensor=m.onnx.SparseTensorProto.fromObject(e.sparseTensor)}if(e.tp!=null){if(typeof e.tp!="object")throw TypeError(".onnx.AttributeProto.tp: object expected");r.tp=m.onnx.TypeProto.fromObject(e.tp)}if(e.floats){if(!Array.isArray(e.floats))throw TypeError(".onnx.AttributeProto.floats: array expected");r.floats=[];for(var n=0;n<e.floats.length;++n)r.floats[n]=Number(e.floats[n])}if(e.ints){if(!Array.isArray(e.ints))throw TypeError(".onnx.AttributeProto.ints: array expected");r.ints=[];for(var n=0;n<e.ints.length;++n)y.Long?(r.ints[n]=y.Long.fromValue(e.ints[n])).unsigned=!1:typeof e.ints[n]=="string"?r.ints[n]=parseInt(e.ints[n],10):typeof e.ints[n]=="number"?r.ints[n]=e.ints[n]:typeof e.ints[n]=="object"&&(r.ints[n]=new y.LongBits(e.ints[n].low>>>0,e.ints[n].high>>>0).toNumber())}if(e.strings){if(!Array.isArray(e.strings))throw TypeError(".onnx.AttributeProto.strings: array expected");r.strings=[];for(var n=0;n<e.strings.length;++n)typeof e.strings[n]=="string"?y.base64.decode(e.strings[n],r.strings[n]=y.newBuffer(y.base64.length(e.strings[n])),0):e.strings[n].length>=0&&(r.strings[n]=e.strings[n])}if(e.tensors){if(!Array.isArray(e.tensors))throw TypeError(".onnx.AttributeProto.tensors: array expected");r.tensors=[];for(var n=0;n<e.tensors.length;++n){if(typeof e.tensors[n]!="object")throw TypeError(".onnx.AttributeProto.tensors: object expected");r.tensors[n]=m.onnx.TensorProto.fromObject(e.tensors[n])}}if(e.graphs){if(!Array.isArray(e.graphs))throw TypeError(".onnx.AttributeProto.graphs: array expected");r.graphs=[];for(var n=0;n<e.graphs.length;++n){if(typeof e.graphs[n]!="object")throw TypeError(".onnx.AttributeProto.graphs: object expected");r.graphs[n]=m.onnx.GraphProto.fromObject(e.graphs[n])}}if(e.sparseTensors){if(!Array.isArray(e.sparseTensors))throw TypeError(".onnx.AttributeProto.sparseTensors: array expected");r.sparseTensors=[];for(var n=0;n<e.sparseTensors.length;++n){if(typeof e.sparseTensors[n]!="object")throw TypeError(".onnx.AttributeProto.sparseTensors: object expected");r.sparseTensors[n]=m.onnx.SparseTensorProto.fromObject(e.sparseTensors[n])}}if(e.typeProtos){if(!Array.isArray(e.typeProtos))throw TypeError(".onnx.AttributeProto.typeProtos: array expected");r.typeProtos=[];for(var n=0;n<e.typeProtos.length;++n){if(typeof e.typeProtos[n]!="object")throw TypeError(".onnx.AttributeProto.typeProtos: object expected");r.typeProtos[n]=m.onnx.TypeProto.fromObject(e.typeProtos[n])}}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.floats=[],n.ints=[],n.strings=[],n.tensors=[],n.graphs=[],n.typeProtos=[],n.sparseTensors=[]),r.defaults){if(n.name="",n.f=0,y.Long){var s=new y.Long(0,0,!1);n.i=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.i=r.longs===String?"0":0;r.bytes===String?n.s="":(n.s=[],r.bytes!==Array&&(n.s=y.newBuffer(n.s))),n.t=null,n.g=null,n.docString="",n.tp=null,n.type=r.enums===String?"UNDEFINED":0,n.refAttrName="",n.sparseTensor=null}if(e.name!=null&&e.hasOwnProperty("name")&&(n.name=e.name),e.f!=null&&e.hasOwnProperty("f")&&(n.f=r.json&&!isFinite(e.f)?String(e.f):e.f),e.i!=null&&e.hasOwnProperty("i")&&(typeof e.i=="number"?n.i=r.longs===String?String(e.i):e.i:n.i=r.longs===String?y.Long.prototype.toString.call(e.i):r.longs===Number?new y.LongBits(e.i.low>>>0,e.i.high>>>0).toNumber():e.i),e.s!=null&&e.hasOwnProperty("s")&&(n.s=r.bytes===String?y.base64.encode(e.s,0,e.s.length):r.bytes===Array?Array.prototype.slice.call(e.s):e.s),e.t!=null&&e.hasOwnProperty("t")&&(n.t=m.onnx.TensorProto.toObject(e.t,r)),e.g!=null&&e.hasOwnProperty("g")&&(n.g=m.onnx.GraphProto.toObject(e.g,r)),e.floats&&e.floats.length){n.floats=[];for(var i=0;i<e.floats.length;++i)n.floats[i]=r.json&&!isFinite(e.floats[i])?String(e.floats[i]):e.floats[i]}if(e.ints&&e.ints.length){n.ints=[];for(var i=0;i<e.ints.length;++i)typeof e.ints[i]=="number"?n.ints[i]=r.longs===String?String(e.ints[i]):e.ints[i]:n.ints[i]=r.longs===String?y.Long.prototype.toString.call(e.ints[i]):r.longs===Number?new y.LongBits(e.ints[i].low>>>0,e.ints[i].high>>>0).toNumber():e.ints[i]}if(e.strings&&e.strings.length){n.strings=[];for(var i=0;i<e.strings.length;++i)n.strings[i]=r.bytes===String?y.base64.encode(e.strings[i],0,e.strings[i].length):r.bytes===Array?Array.prototype.slice.call(e.strings[i]):e.strings[i]}if(e.tensors&&e.tensors.length){n.tensors=[];for(var i=0;i<e.tensors.length;++i)n.tensors[i]=m.onnx.TensorProto.toObject(e.tensors[i],r)}if(e.graphs&&e.graphs.length){n.graphs=[];for(var i=0;i<e.graphs.length;++i)n.graphs[i]=m.onnx.GraphProto.toObject(e.graphs[i],r)}if(e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),e.tp!=null&&e.hasOwnProperty("tp")&&(n.tp=m.onnx.TypeProto.toObject(e.tp,r)),e.typeProtos&&e.typeProtos.length){n.typeProtos=[];for(var i=0;i<e.typeProtos.length;++i)n.typeProtos[i]=m.onnx.TypeProto.toObject(e.typeProtos[i],r)}if(e.type!=null&&e.hasOwnProperty("type")&&(n.type=r.enums===String?m.onnx.AttributeProto.AttributeType[e.type]===void 0?e.type:m.onnx.AttributeProto.AttributeType[e.type]:e.type),e.refAttrName!=null&&e.hasOwnProperty("refAttrName")&&(n.refAttrName=e.refAttrName),e.sparseTensor!=null&&e.hasOwnProperty("sparseTensor")&&(n.sparseTensor=m.onnx.SparseTensorProto.toObject(e.sparseTensor,r)),e.sparseTensors&&e.sparseTensors.length){n.sparseTensors=[];for(var i=0;i<e.sparseTensors.length;++i)n.sparseTensors[i]=m.onnx.SparseTensorProto.toObject(e.sparseTensors[i],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.AttributeProto"},t.AttributeType=function(){var o={},e=Object.create(o);return e[o[0]="UNDEFINED"]=0,e[o[1]="FLOAT"]=1,e[o[2]="INT"]=2,e[o[3]="STRING"]=3,e[o[4]="TENSOR"]=4,e[o[5]="GRAPH"]=5,e[o[11]="SPARSE_TENSOR"]=11,e[o[13]="TYPE_PROTO"]=13,e[o[6]="FLOATS"]=6,e[o[7]="INTS"]=7,e[o[8]="STRINGS"]=8,e[o[9]="TENSORS"]=9,e[o[10]="GRAPHS"]=10,e[o[12]="SPARSE_TENSORS"]=12,e[o[14]="TYPE_PROTOS"]=14,e}(),t}(),a.ValueInfoProto=function(){function t(o){if(o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.name="",t.prototype.type=null,t.prototype.docString="",t.create=function(e){return new t(e)},t.encode=function(e,r){return r||(r=Ae.create()),e.name!=null&&Object.hasOwnProperty.call(e,"name")&&r.uint32(10).string(e.name),e.type!=null&&Object.hasOwnProperty.call(e,"type")&&m.onnx.TypeProto.encode(e.type,r.uint32(18).fork()).ldelim(),e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(26).string(e.docString),r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.ValueInfoProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.name=e.string();break}case 2:{s.type=m.onnx.TypeProto.decode(e,e.uint32());break}case 3:{s.docString=e.string();break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.name!=null&&e.hasOwnProperty("name")&&!y.isString(e.name))return"name: string expected";if(e.type!=null&&e.hasOwnProperty("type")){var r=m.onnx.TypeProto.verify(e.type);if(r)return"type."+r}return e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString)?"docString: string expected":null},t.fromObject=function(e){if(e instanceof m.onnx.ValueInfoProto)return e;var r=new m.onnx.ValueInfoProto;if(e.name!=null&&(r.name=String(e.name)),e.type!=null){if(typeof e.type!="object")throw TypeError(".onnx.ValueInfoProto.type: object expected");r.type=m.onnx.TypeProto.fromObject(e.type)}return e.docString!=null&&(r.docString=String(e.docString)),r},t.toObject=function(e,r){r||(r={});var n={};return r.defaults&&(n.name="",n.type=null,n.docString=""),e.name!=null&&e.hasOwnProperty("name")&&(n.name=e.name),e.type!=null&&e.hasOwnProperty("type")&&(n.type=m.onnx.TypeProto.toObject(e.type,r)),e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.ValueInfoProto"},t}(),a.NodeProto=function(){function t(o){if(this.input=[],this.output=[],this.attribute=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.input=y.emptyArray,t.prototype.output=y.emptyArray,t.prototype.name="",t.prototype.opType="",t.prototype.domain="",t.prototype.attribute=y.emptyArray,t.prototype.docString="",t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.input!=null&&e.input.length)for(var n=0;n<e.input.length;++n)r.uint32(10).string(e.input[n]);if(e.output!=null&&e.output.length)for(var n=0;n<e.output.length;++n)r.uint32(18).string(e.output[n]);if(e.name!=null&&Object.hasOwnProperty.call(e,"name")&&r.uint32(26).string(e.name),e.opType!=null&&Object.hasOwnProperty.call(e,"opType")&&r.uint32(34).string(e.opType),e.attribute!=null&&e.attribute.length)for(var n=0;n<e.attribute.length;++n)m.onnx.AttributeProto.encode(e.attribute[n],r.uint32(42).fork()).ldelim();return e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(50).string(e.docString),e.domain!=null&&Object.hasOwnProperty.call(e,"domain")&&r.uint32(58).string(e.domain),r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.NodeProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.input&&s.input.length||(s.input=[]),s.input.push(e.string());break}case 2:{s.output&&s.output.length||(s.output=[]),s.output.push(e.string());break}case 3:{s.name=e.string();break}case 4:{s.opType=e.string();break}case 7:{s.domain=e.string();break}case 5:{s.attribute&&s.attribute.length||(s.attribute=[]),s.attribute.push(m.onnx.AttributeProto.decode(e,e.uint32()));break}case 6:{s.docString=e.string();break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.input!=null&&e.hasOwnProperty("input")){if(!Array.isArray(e.input))return"input: array expected";for(var r=0;r<e.input.length;++r)if(!y.isString(e.input[r]))return"input: string[] expected"}if(e.output!=null&&e.hasOwnProperty("output")){if(!Array.isArray(e.output))return"output: array expected";for(var r=0;r<e.output.length;++r)if(!y.isString(e.output[r]))return"output: string[] expected"}if(e.name!=null&&e.hasOwnProperty("name")&&!y.isString(e.name))return"name: string expected";if(e.opType!=null&&e.hasOwnProperty("opType")&&!y.isString(e.opType))return"opType: string expected";if(e.domain!=null&&e.hasOwnProperty("domain")&&!y.isString(e.domain))return"domain: string expected";if(e.attribute!=null&&e.hasOwnProperty("attribute")){if(!Array.isArray(e.attribute))return"attribute: array expected";for(var r=0;r<e.attribute.length;++r){var n=m.onnx.AttributeProto.verify(e.attribute[r]);if(n)return"attribute."+n}}return e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString)?"docString: string expected":null},t.fromObject=function(e){if(e instanceof m.onnx.NodeProto)return e;var r=new m.onnx.NodeProto;if(e.input){if(!Array.isArray(e.input))throw TypeError(".onnx.NodeProto.input: array expected");r.input=[];for(var n=0;n<e.input.length;++n)r.input[n]=String(e.input[n])}if(e.output){if(!Array.isArray(e.output))throw TypeError(".onnx.NodeProto.output: array expected");r.output=[];for(var n=0;n<e.output.length;++n)r.output[n]=String(e.output[n])}if(e.name!=null&&(r.name=String(e.name)),e.opType!=null&&(r.opType=String(e.opType)),e.domain!=null&&(r.domain=String(e.domain)),e.attribute){if(!Array.isArray(e.attribute))throw TypeError(".onnx.NodeProto.attribute: array expected");r.attribute=[];for(var n=0;n<e.attribute.length;++n){if(typeof e.attribute[n]!="object")throw TypeError(".onnx.NodeProto.attribute: object expected");r.attribute[n]=m.onnx.AttributeProto.fromObject(e.attribute[n])}}return e.docString!=null&&(r.docString=String(e.docString)),r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.input=[],n.output=[],n.attribute=[]),r.defaults&&(n.name="",n.opType="",n.docString="",n.domain=""),e.input&&e.input.length){n.input=[];for(var s=0;s<e.input.length;++s)n.input[s]=e.input[s]}if(e.output&&e.output.length){n.output=[];for(var s=0;s<e.output.length;++s)n.output[s]=e.output[s]}if(e.name!=null&&e.hasOwnProperty("name")&&(n.name=e.name),e.opType!=null&&e.hasOwnProperty("opType")&&(n.opType=e.opType),e.attribute&&e.attribute.length){n.attribute=[];for(var s=0;s<e.attribute.length;++s)n.attribute[s]=m.onnx.AttributeProto.toObject(e.attribute[s],r)}return e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),e.domain!=null&&e.hasOwnProperty("domain")&&(n.domain=e.domain),n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.NodeProto"},t}(),a.TrainingInfoProto=function(){function t(o){if(this.initializationBinding=[],this.updateBinding=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.initialization=null,t.prototype.algorithm=null,t.prototype.initializationBinding=y.emptyArray,t.prototype.updateBinding=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.initialization!=null&&Object.hasOwnProperty.call(e,"initialization")&&m.onnx.GraphProto.encode(e.initialization,r.uint32(10).fork()).ldelim(),e.algorithm!=null&&Object.hasOwnProperty.call(e,"algorithm")&&m.onnx.GraphProto.encode(e.algorithm,r.uint32(18).fork()).ldelim(),e.initializationBinding!=null&&e.initializationBinding.length)for(var n=0;n<e.initializationBinding.length;++n)m.onnx.StringStringEntryProto.encode(e.initializationBinding[n],r.uint32(26).fork()).ldelim();if(e.updateBinding!=null&&e.updateBinding.length)for(var n=0;n<e.updateBinding.length;++n)m.onnx.StringStringEntryProto.encode(e.updateBinding[n],r.uint32(34).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.TrainingInfoProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.initialization=m.onnx.GraphProto.decode(e,e.uint32());break}case 2:{s.algorithm=m.onnx.GraphProto.decode(e,e.uint32());break}case 3:{s.initializationBinding&&s.initializationBinding.length||(s.initializationBinding=[]),s.initializationBinding.push(m.onnx.StringStringEntryProto.decode(e,e.uint32()));break}case 4:{s.updateBinding&&s.updateBinding.length||(s.updateBinding=[]),s.updateBinding.push(m.onnx.StringStringEntryProto.decode(e,e.uint32()));break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.initialization!=null&&e.hasOwnProperty("initialization")){var r=m.onnx.GraphProto.verify(e.initialization);if(r)return"initialization."+r}if(e.algorithm!=null&&e.hasOwnProperty("algorithm")){var r=m.onnx.GraphProto.verify(e.algorithm);if(r)return"algorithm."+r}if(e.initializationBinding!=null&&e.hasOwnProperty("initializationBinding")){if(!Array.isArray(e.initializationBinding))return"initializationBinding: array expected";for(var n=0;n<e.initializationBinding.length;++n){var r=m.onnx.StringStringEntryProto.verify(e.initializationBinding[n]);if(r)return"initializationBinding."+r}}if(e.updateBinding!=null&&e.hasOwnProperty("updateBinding")){if(!Array.isArray(e.updateBinding))return"updateBinding: array expected";for(var n=0;n<e.updateBinding.length;++n){var r=m.onnx.StringStringEntryProto.verify(e.updateBinding[n]);if(r)return"updateBinding."+r}}return null},t.fromObject=function(e){if(e instanceof m.onnx.TrainingInfoProto)return e;var r=new m.onnx.TrainingInfoProto;if(e.initialization!=null){if(typeof e.initialization!="object")throw TypeError(".onnx.TrainingInfoProto.initialization: object expected");r.initialization=m.onnx.GraphProto.fromObject(e.initialization)}if(e.algorithm!=null){if(typeof e.algorithm!="object")throw TypeError(".onnx.TrainingInfoProto.algorithm: object expected");r.algorithm=m.onnx.GraphProto.fromObject(e.algorithm)}if(e.initializationBinding){if(!Array.isArray(e.initializationBinding))throw TypeError(".onnx.TrainingInfoProto.initializationBinding: array expected");r.initializationBinding=[];for(var n=0;n<e.initializationBinding.length;++n){if(typeof e.initializationBinding[n]!="object")throw TypeError(".onnx.TrainingInfoProto.initializationBinding: object expected");r.initializationBinding[n]=m.onnx.StringStringEntryProto.fromObject(e.initializationBinding[n])}}if(e.updateBinding){if(!Array.isArray(e.updateBinding))throw TypeError(".onnx.TrainingInfoProto.updateBinding: array expected");r.updateBinding=[];for(var n=0;n<e.updateBinding.length;++n){if(typeof e.updateBinding[n]!="object")throw TypeError(".onnx.TrainingInfoProto.updateBinding: object expected");r.updateBinding[n]=m.onnx.StringStringEntryProto.fromObject(e.updateBinding[n])}}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.initializationBinding=[],n.updateBinding=[]),r.defaults&&(n.initialization=null,n.algorithm=null),e.initialization!=null&&e.hasOwnProperty("initialization")&&(n.initialization=m.onnx.GraphProto.toObject(e.initialization,r)),e.algorithm!=null&&e.hasOwnProperty("algorithm")&&(n.algorithm=m.onnx.GraphProto.toObject(e.algorithm,r)),e.initializationBinding&&e.initializationBinding.length){n.initializationBinding=[];for(var s=0;s<e.initializationBinding.length;++s)n.initializationBinding[s]=m.onnx.StringStringEntryProto.toObject(e.initializationBinding[s],r)}if(e.updateBinding&&e.updateBinding.length){n.updateBinding=[];for(var s=0;s<e.updateBinding.length;++s)n.updateBinding[s]=m.onnx.StringStringEntryProto.toObject(e.updateBinding[s],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.TrainingInfoProto"},t}(),a.ModelProto=function(){function t(o){if(this.opsetImport=[],this.metadataProps=[],this.trainingInfo=[],this.functions=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.irVersion=y.Long?y.Long.fromBits(0,0,!1):0,t.prototype.opsetImport=y.emptyArray,t.prototype.producerName="",t.prototype.producerVersion="",t.prototype.domain="",t.prototype.modelVersion=y.Long?y.Long.fromBits(0,0,!1):0,t.prototype.docString="",t.prototype.graph=null,t.prototype.metadataProps=y.emptyArray,t.prototype.trainingInfo=y.emptyArray,t.prototype.functions=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.irVersion!=null&&Object.hasOwnProperty.call(e,"irVersion")&&r.uint32(8).int64(e.irVersion),e.producerName!=null&&Object.hasOwnProperty.call(e,"producerName")&&r.uint32(18).string(e.producerName),e.producerVersion!=null&&Object.hasOwnProperty.call(e,"producerVersion")&&r.uint32(26).string(e.producerVersion),e.domain!=null&&Object.hasOwnProperty.call(e,"domain")&&r.uint32(34).string(e.domain),e.modelVersion!=null&&Object.hasOwnProperty.call(e,"modelVersion")&&r.uint32(40).int64(e.modelVersion),e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(50).string(e.docString),e.graph!=null&&Object.hasOwnProperty.call(e,"graph")&&m.onnx.GraphProto.encode(e.graph,r.uint32(58).fork()).ldelim(),e.opsetImport!=null&&e.opsetImport.length)for(var n=0;n<e.opsetImport.length;++n)m.onnx.OperatorSetIdProto.encode(e.opsetImport[n],r.uint32(66).fork()).ldelim();if(e.metadataProps!=null&&e.metadataProps.length)for(var n=0;n<e.metadataProps.length;++n)m.onnx.StringStringEntryProto.encode(e.metadataProps[n],r.uint32(114).fork()).ldelim();if(e.trainingInfo!=null&&e.trainingInfo.length)for(var n=0;n<e.trainingInfo.length;++n)m.onnx.TrainingInfoProto.encode(e.trainingInfo[n],r.uint32(162).fork()).ldelim();if(e.functions!=null&&e.functions.length)for(var n=0;n<e.functions.length;++n)m.onnx.FunctionProto.encode(e.functions[n],r.uint32(202).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.ModelProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.irVersion=e.int64();break}case 8:{s.opsetImport&&s.opsetImport.length||(s.opsetImport=[]),s.opsetImport.push(m.onnx.OperatorSetIdProto.decode(e,e.uint32()));break}case 2:{s.producerName=e.string();break}case 3:{s.producerVersion=e.string();break}case 4:{s.domain=e.string();break}case 5:{s.modelVersion=e.int64();break}case 6:{s.docString=e.string();break}case 7:{s.graph=m.onnx.GraphProto.decode(e,e.uint32());break}case 14:{s.metadataProps&&s.metadataProps.length||(s.metadataProps=[]),s.metadataProps.push(m.onnx.StringStringEntryProto.decode(e,e.uint32()));break}case 20:{s.trainingInfo&&s.trainingInfo.length||(s.trainingInfo=[]),s.trainingInfo.push(m.onnx.TrainingInfoProto.decode(e,e.uint32()));break}case 25:{s.functions&&s.functions.length||(s.functions=[]),s.functions.push(m.onnx.FunctionProto.decode(e,e.uint32()));break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.irVersion!=null&&e.hasOwnProperty("irVersion")&&!y.isInteger(e.irVersion)&&!(e.irVersion&&y.isInteger(e.irVersion.low)&&y.isInteger(e.irVersion.high)))return"irVersion: integer|Long expected";if(e.opsetImport!=null&&e.hasOwnProperty("opsetImport")){if(!Array.isArray(e.opsetImport))return"opsetImport: array expected";for(var r=0;r<e.opsetImport.length;++r){var n=m.onnx.OperatorSetIdProto.verify(e.opsetImport[r]);if(n)return"opsetImport."+n}}if(e.producerName!=null&&e.hasOwnProperty("producerName")&&!y.isString(e.producerName))return"producerName: string expected";if(e.producerVersion!=null&&e.hasOwnProperty("producerVersion")&&!y.isString(e.producerVersion))return"producerVersion: string expected";if(e.domain!=null&&e.hasOwnProperty("domain")&&!y.isString(e.domain))return"domain: string expected";if(e.modelVersion!=null&&e.hasOwnProperty("modelVersion")&&!y.isInteger(e.modelVersion)&&!(e.modelVersion&&y.isInteger(e.modelVersion.low)&&y.isInteger(e.modelVersion.high)))return"modelVersion: integer|Long expected";if(e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString))return"docString: string expected";if(e.graph!=null&&e.hasOwnProperty("graph")){var n=m.onnx.GraphProto.verify(e.graph);if(n)return"graph."+n}if(e.metadataProps!=null&&e.hasOwnProperty("metadataProps")){if(!Array.isArray(e.metadataProps))return"metadataProps: array expected";for(var r=0;r<e.metadataProps.length;++r){var n=m.onnx.StringStringEntryProto.verify(e.metadataProps[r]);if(n)return"metadataProps."+n}}if(e.trainingInfo!=null&&e.hasOwnProperty("trainingInfo")){if(!Array.isArray(e.trainingInfo))return"trainingInfo: array expected";for(var r=0;r<e.trainingInfo.length;++r){var n=m.onnx.TrainingInfoProto.verify(e.trainingInfo[r]);if(n)return"trainingInfo."+n}}if(e.functions!=null&&e.hasOwnProperty("functions")){if(!Array.isArray(e.functions))return"functions: array expected";for(var r=0;r<e.functions.length;++r){var n=m.onnx.FunctionProto.verify(e.functions[r]);if(n)return"functions."+n}}return null},t.fromObject=function(e){if(e instanceof m.onnx.ModelProto)return e;var r=new m.onnx.ModelProto;if(e.irVersion!=null&&(y.Long?(r.irVersion=y.Long.fromValue(e.irVersion)).unsigned=!1:typeof e.irVersion=="string"?r.irVersion=parseInt(e.irVersion,10):typeof e.irVersion=="number"?r.irVersion=e.irVersion:typeof e.irVersion=="object"&&(r.irVersion=new y.LongBits(e.irVersion.low>>>0,e.irVersion.high>>>0).toNumber())),e.opsetImport){if(!Array.isArray(e.opsetImport))throw TypeError(".onnx.ModelProto.opsetImport: array expected");r.opsetImport=[];for(var n=0;n<e.opsetImport.length;++n){if(typeof e.opsetImport[n]!="object")throw TypeError(".onnx.ModelProto.opsetImport: object expected");r.opsetImport[n]=m.onnx.OperatorSetIdProto.fromObject(e.opsetImport[n])}}if(e.producerName!=null&&(r.producerName=String(e.producerName)),e.producerVersion!=null&&(r.producerVersion=String(e.producerVersion)),e.domain!=null&&(r.domain=String(e.domain)),e.modelVersion!=null&&(y.Long?(r.modelVersion=y.Long.fromValue(e.modelVersion)).unsigned=!1:typeof e.modelVersion=="string"?r.modelVersion=parseInt(e.modelVersion,10):typeof e.modelVersion=="number"?r.modelVersion=e.modelVersion:typeof e.modelVersion=="object"&&(r.modelVersion=new y.LongBits(e.modelVersion.low>>>0,e.modelVersion.high>>>0).toNumber())),e.docString!=null&&(r.docString=String(e.docString)),e.graph!=null){if(typeof e.graph!="object")throw TypeError(".onnx.ModelProto.graph: object expected");r.graph=m.onnx.GraphProto.fromObject(e.graph)}if(e.metadataProps){if(!Array.isArray(e.metadataProps))throw TypeError(".onnx.ModelProto.metadataProps: array expected");r.metadataProps=[];for(var n=0;n<e.metadataProps.length;++n){if(typeof e.metadataProps[n]!="object")throw TypeError(".onnx.ModelProto.metadataProps: object expected");r.metadataProps[n]=m.onnx.StringStringEntryProto.fromObject(e.metadataProps[n])}}if(e.trainingInfo){if(!Array.isArray(e.trainingInfo))throw TypeError(".onnx.ModelProto.trainingInfo: array expected");r.trainingInfo=[];for(var n=0;n<e.trainingInfo.length;++n){if(typeof e.trainingInfo[n]!="object")throw TypeError(".onnx.ModelProto.trainingInfo: object expected");r.trainingInfo[n]=m.onnx.TrainingInfoProto.fromObject(e.trainingInfo[n])}}if(e.functions){if(!Array.isArray(e.functions))throw TypeError(".onnx.ModelProto.functions: array expected");r.functions=[];for(var n=0;n<e.functions.length;++n){if(typeof e.functions[n]!="object")throw TypeError(".onnx.ModelProto.functions: object expected");r.functions[n]=m.onnx.FunctionProto.fromObject(e.functions[n])}}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.opsetImport=[],n.metadataProps=[],n.trainingInfo=[],n.functions=[]),r.defaults){if(y.Long){var s=new y.Long(0,0,!1);n.irVersion=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.irVersion=r.longs===String?"0":0;if(n.producerName="",n.producerVersion="",n.domain="",y.Long){var s=new y.Long(0,0,!1);n.modelVersion=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.modelVersion=r.longs===String?"0":0;n.docString="",n.graph=null}if(e.irVersion!=null&&e.hasOwnProperty("irVersion")&&(typeof e.irVersion=="number"?n.irVersion=r.longs===String?String(e.irVersion):e.irVersion:n.irVersion=r.longs===String?y.Long.prototype.toString.call(e.irVersion):r.longs===Number?new y.LongBits(e.irVersion.low>>>0,e.irVersion.high>>>0).toNumber():e.irVersion),e.producerName!=null&&e.hasOwnProperty("producerName")&&(n.producerName=e.producerName),e.producerVersion!=null&&e.hasOwnProperty("producerVersion")&&(n.producerVersion=e.producerVersion),e.domain!=null&&e.hasOwnProperty("domain")&&(n.domain=e.domain),e.modelVersion!=null&&e.hasOwnProperty("modelVersion")&&(typeof e.modelVersion=="number"?n.modelVersion=r.longs===String?String(e.modelVersion):e.modelVersion:n.modelVersion=r.longs===String?y.Long.prototype.toString.call(e.modelVersion):r.longs===Number?new y.LongBits(e.modelVersion.low>>>0,e.modelVersion.high>>>0).toNumber():e.modelVersion),e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),e.graph!=null&&e.hasOwnProperty("graph")&&(n.graph=m.onnx.GraphProto.toObject(e.graph,r)),e.opsetImport&&e.opsetImport.length){n.opsetImport=[];for(var i=0;i<e.opsetImport.length;++i)n.opsetImport[i]=m.onnx.OperatorSetIdProto.toObject(e.opsetImport[i],r)}if(e.metadataProps&&e.metadataProps.length){n.metadataProps=[];for(var i=0;i<e.metadataProps.length;++i)n.metadataProps[i]=m.onnx.StringStringEntryProto.toObject(e.metadataProps[i],r)}if(e.trainingInfo&&e.trainingInfo.length){n.trainingInfo=[];for(var i=0;i<e.trainingInfo.length;++i)n.trainingInfo[i]=m.onnx.TrainingInfoProto.toObject(e.trainingInfo[i],r)}if(e.functions&&e.functions.length){n.functions=[];for(var i=0;i<e.functions.length;++i)n.functions[i]=m.onnx.FunctionProto.toObject(e.functions[i],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.ModelProto"},t}(),a.StringStringEntryProto=function(){function t(o){if(o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.key="",t.prototype.value="",t.create=function(e){return new t(e)},t.encode=function(e,r){return r||(r=Ae.create()),e.key!=null&&Object.hasOwnProperty.call(e,"key")&&r.uint32(10).string(e.key),e.value!=null&&Object.hasOwnProperty.call(e,"value")&&r.uint32(18).string(e.value),r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.StringStringEntryProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.key=e.string();break}case 2:{s.value=e.string();break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){return typeof e!="object"||e===null?"object expected":e.key!=null&&e.hasOwnProperty("key")&&!y.isString(e.key)?"key: string expected":e.value!=null&&e.hasOwnProperty("value")&&!y.isString(e.value)?"value: string expected":null},t.fromObject=function(e){if(e instanceof m.onnx.StringStringEntryProto)return e;var r=new m.onnx.StringStringEntryProto;return e.key!=null&&(r.key=String(e.key)),e.value!=null&&(r.value=String(e.value)),r},t.toObject=function(e,r){r||(r={});var n={};return r.defaults&&(n.key="",n.value=""),e.key!=null&&e.hasOwnProperty("key")&&(n.key=e.key),e.value!=null&&e.hasOwnProperty("value")&&(n.value=e.value),n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.StringStringEntryProto"},t}(),a.TensorAnnotation=function(){function t(o){if(this.quantParameterTensorNames=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.tensorName="",t.prototype.quantParameterTensorNames=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.tensorName!=null&&Object.hasOwnProperty.call(e,"tensorName")&&r.uint32(10).string(e.tensorName),e.quantParameterTensorNames!=null&&e.quantParameterTensorNames.length)for(var n=0;n<e.quantParameterTensorNames.length;++n)m.onnx.StringStringEntryProto.encode(e.quantParameterTensorNames[n],r.uint32(18).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.TensorAnnotation;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.tensorName=e.string();break}case 2:{s.quantParameterTensorNames&&s.quantParameterTensorNames.length||(s.quantParameterTensorNames=[]),s.quantParameterTensorNames.push(m.onnx.StringStringEntryProto.decode(e,e.uint32()));break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.tensorName!=null&&e.hasOwnProperty("tensorName")&&!y.isString(e.tensorName))return"tensorName: string expected";if(e.quantParameterTensorNames!=null&&e.hasOwnProperty("quantParameterTensorNames")){if(!Array.isArray(e.quantParameterTensorNames))return"quantParameterTensorNames: array expected";for(var r=0;r<e.quantParameterTensorNames.length;++r){var n=m.onnx.StringStringEntryProto.verify(e.quantParameterTensorNames[r]);if(n)return"quantParameterTensorNames."+n}}return null},t.fromObject=function(e){if(e instanceof m.onnx.TensorAnnotation)return e;var r=new m.onnx.TensorAnnotation;if(e.tensorName!=null&&(r.tensorName=String(e.tensorName)),e.quantParameterTensorNames){if(!Array.isArray(e.quantParameterTensorNames))throw TypeError(".onnx.TensorAnnotation.quantParameterTensorNames: array expected");r.quantParameterTensorNames=[];for(var n=0;n<e.quantParameterTensorNames.length;++n){if(typeof e.quantParameterTensorNames[n]!="object")throw TypeError(".onnx.TensorAnnotation.quantParameterTensorNames: object expected");r.quantParameterTensorNames[n]=m.onnx.StringStringEntryProto.fromObject(e.quantParameterTensorNames[n])}}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.quantParameterTensorNames=[]),r.defaults&&(n.tensorName=""),e.tensorName!=null&&e.hasOwnProperty("tensorName")&&(n.tensorName=e.tensorName),e.quantParameterTensorNames&&e.quantParameterTensorNames.length){n.quantParameterTensorNames=[];for(var s=0;s<e.quantParameterTensorNames.length;++s)n.quantParameterTensorNames[s]=m.onnx.StringStringEntryProto.toObject(e.quantParameterTensorNames[s],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.TensorAnnotation"},t}(),a.GraphProto=function(){function t(o){if(this.node=[],this.initializer=[],this.sparseInitializer=[],this.input=[],this.output=[],this.valueInfo=[],this.quantizationAnnotation=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.node=y.emptyArray,t.prototype.name="",t.prototype.initializer=y.emptyArray,t.prototype.sparseInitializer=y.emptyArray,t.prototype.docString="",t.prototype.input=y.emptyArray,t.prototype.output=y.emptyArray,t.prototype.valueInfo=y.emptyArray,t.prototype.quantizationAnnotation=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.node!=null&&e.node.length)for(var n=0;n<e.node.length;++n)m.onnx.NodeProto.encode(e.node[n],r.uint32(10).fork()).ldelim();if(e.name!=null&&Object.hasOwnProperty.call(e,"name")&&r.uint32(18).string(e.name),e.initializer!=null&&e.initializer.length)for(var n=0;n<e.initializer.length;++n)m.onnx.TensorProto.encode(e.initializer[n],r.uint32(42).fork()).ldelim();if(e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(82).string(e.docString),e.input!=null&&e.input.length)for(var n=0;n<e.input.length;++n)m.onnx.ValueInfoProto.encode(e.input[n],r.uint32(90).fork()).ldelim();if(e.output!=null&&e.output.length)for(var n=0;n<e.output.length;++n)m.onnx.ValueInfoProto.encode(e.output[n],r.uint32(98).fork()).ldelim();if(e.valueInfo!=null&&e.valueInfo.length)for(var n=0;n<e.valueInfo.length;++n)m.onnx.ValueInfoProto.encode(e.valueInfo[n],r.uint32(106).fork()).ldelim();if(e.quantizationAnnotation!=null&&e.quantizationAnnotation.length)for(var n=0;n<e.quantizationAnnotation.length;++n)m.onnx.TensorAnnotation.encode(e.quantizationAnnotation[n],r.uint32(114).fork()).ldelim();if(e.sparseInitializer!=null&&e.sparseInitializer.length)for(var n=0;n<e.sparseInitializer.length;++n)m.onnx.SparseTensorProto.encode(e.sparseInitializer[n],r.uint32(122).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.GraphProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.node&&s.node.length||(s.node=[]),s.node.push(m.onnx.NodeProto.decode(e,e.uint32()));break}case 2:{s.name=e.string();break}case 5:{s.initializer&&s.initializer.length||(s.initializer=[]),s.initializer.push(m.onnx.TensorProto.decode(e,e.uint32()));break}case 15:{s.sparseInitializer&&s.sparseInitializer.length||(s.sparseInitializer=[]),s.sparseInitializer.push(m.onnx.SparseTensorProto.decode(e,e.uint32()));break}case 10:{s.docString=e.string();break}case 11:{s.input&&s.input.length||(s.input=[]),s.input.push(m.onnx.ValueInfoProto.decode(e,e.uint32()));break}case 12:{s.output&&s.output.length||(s.output=[]),s.output.push(m.onnx.ValueInfoProto.decode(e,e.uint32()));break}case 13:{s.valueInfo&&s.valueInfo.length||(s.valueInfo=[]),s.valueInfo.push(m.onnx.ValueInfoProto.decode(e,e.uint32()));break}case 14:{s.quantizationAnnotation&&s.quantizationAnnotation.length||(s.quantizationAnnotation=[]),s.quantizationAnnotation.push(m.onnx.TensorAnnotation.decode(e,e.uint32()));break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.node!=null&&e.hasOwnProperty("node")){if(!Array.isArray(e.node))return"node: array expected";for(var r=0;r<e.node.length;++r){var n=m.onnx.NodeProto.verify(e.node[r]);if(n)return"node."+n}}if(e.name!=null&&e.hasOwnProperty("name")&&!y.isString(e.name))return"name: string expected";if(e.initializer!=null&&e.hasOwnProperty("initializer")){if(!Array.isArray(e.initializer))return"initializer: array expected";for(var r=0;r<e.initializer.length;++r){var n=m.onnx.TensorProto.verify(e.initializer[r]);if(n)return"initializer."+n}}if(e.sparseInitializer!=null&&e.hasOwnProperty("sparseInitializer")){if(!Array.isArray(e.sparseInitializer))return"sparseInitializer: array expected";for(var r=0;r<e.sparseInitializer.length;++r){var n=m.onnx.SparseTensorProto.verify(e.sparseInitializer[r]);if(n)return"sparseInitializer."+n}}if(e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString))return"docString: string expected";if(e.input!=null&&e.hasOwnProperty("input")){if(!Array.isArray(e.input))return"input: array expected";for(var r=0;r<e.input.length;++r){var n=m.onnx.ValueInfoProto.verify(e.input[r]);if(n)return"input."+n}}if(e.output!=null&&e.hasOwnProperty("output")){if(!Array.isArray(e.output))return"output: array expected";for(var r=0;r<e.output.length;++r){var n=m.onnx.ValueInfoProto.verify(e.output[r]);if(n)return"output."+n}}if(e.valueInfo!=null&&e.hasOwnProperty("valueInfo")){if(!Array.isArray(e.valueInfo))return"valueInfo: array expected";for(var r=0;r<e.valueInfo.length;++r){var n=m.onnx.ValueInfoProto.verify(e.valueInfo[r]);if(n)return"valueInfo."+n}}if(e.quantizationAnnotation!=null&&e.hasOwnProperty("quantizationAnnotation")){if(!Array.isArray(e.quantizationAnnotation))return"quantizationAnnotation: array expected";for(var r=0;r<e.quantizationAnnotation.length;++r){var n=m.onnx.TensorAnnotation.verify(e.quantizationAnnotation[r]);if(n)return"quantizationAnnotation."+n}}return null},t.fromObject=function(e){if(e instanceof m.onnx.GraphProto)return e;var r=new m.onnx.GraphProto;if(e.node){if(!Array.isArray(e.node))throw TypeError(".onnx.GraphProto.node: array expected");r.node=[];for(var n=0;n<e.node.length;++n){if(typeof e.node[n]!="object")throw TypeError(".onnx.GraphProto.node: object expected");r.node[n]=m.onnx.NodeProto.fromObject(e.node[n])}}if(e.name!=null&&(r.name=String(e.name)),e.initializer){if(!Array.isArray(e.initializer))throw TypeError(".onnx.GraphProto.initializer: array expected");r.initializer=[];for(var n=0;n<e.initializer.length;++n){if(typeof e.initializer[n]!="object")throw TypeError(".onnx.GraphProto.initializer: object expected");r.initializer[n]=m.onnx.TensorProto.fromObject(e.initializer[n])}}if(e.sparseInitializer){if(!Array.isArray(e.sparseInitializer))throw TypeError(".onnx.GraphProto.sparseInitializer: array expected");r.sparseInitializer=[];for(var n=0;n<e.sparseInitializer.length;++n){if(typeof e.sparseInitializer[n]!="object")throw TypeError(".onnx.GraphProto.sparseInitializer: object expected");r.sparseInitializer[n]=m.onnx.SparseTensorProto.fromObject(e.sparseInitializer[n])}}if(e.docString!=null&&(r.docString=String(e.docString)),e.input){if(!Array.isArray(e.input))throw TypeError(".onnx.GraphProto.input: array expected");r.input=[];for(var n=0;n<e.input.length;++n){if(typeof e.input[n]!="object")throw TypeError(".onnx.GraphProto.input: object expected");r.input[n]=m.onnx.ValueInfoProto.fromObject(e.input[n])}}if(e.output){if(!Array.isArray(e.output))throw TypeError(".onnx.GraphProto.output: array expected");r.output=[];for(var n=0;n<e.output.length;++n){if(typeof e.output[n]!="object")throw TypeError(".onnx.GraphProto.output: object expected");r.output[n]=m.onnx.ValueInfoProto.fromObject(e.output[n])}}if(e.valueInfo){if(!Array.isArray(e.valueInfo))throw TypeError(".onnx.GraphProto.valueInfo: array expected");r.valueInfo=[];for(var n=0;n<e.valueInfo.length;++n){if(typeof e.valueInfo[n]!="object")throw TypeError(".onnx.GraphProto.valueInfo: object expected");r.valueInfo[n]=m.onnx.ValueInfoProto.fromObject(e.valueInfo[n])}}if(e.quantizationAnnotation){if(!Array.isArray(e.quantizationAnnotation))throw TypeError(".onnx.GraphProto.quantizationAnnotation: array expected");r.quantizationAnnotation=[];for(var n=0;n<e.quantizationAnnotation.length;++n){if(typeof e.quantizationAnnotation[n]!="object")throw TypeError(".onnx.GraphProto.quantizationAnnotation: object expected");r.quantizationAnnotation[n]=m.onnx.TensorAnnotation.fromObject(e.quantizationAnnotation[n])}}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.node=[],n.initializer=[],n.input=[],n.output=[],n.valueInfo=[],n.quantizationAnnotation=[],n.sparseInitializer=[]),r.defaults&&(n.name="",n.docString=""),e.node&&e.node.length){n.node=[];for(var s=0;s<e.node.length;++s)n.node[s]=m.onnx.NodeProto.toObject(e.node[s],r)}if(e.name!=null&&e.hasOwnProperty("name")&&(n.name=e.name),e.initializer&&e.initializer.length){n.initializer=[];for(var s=0;s<e.initializer.length;++s)n.initializer[s]=m.onnx.TensorProto.toObject(e.initializer[s],r)}if(e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),e.input&&e.input.length){n.input=[];for(var s=0;s<e.input.length;++s)n.input[s]=m.onnx.ValueInfoProto.toObject(e.input[s],r)}if(e.output&&e.output.length){n.output=[];for(var s=0;s<e.output.length;++s)n.output[s]=m.onnx.ValueInfoProto.toObject(e.output[s],r)}if(e.valueInfo&&e.valueInfo.length){n.valueInfo=[];for(var s=0;s<e.valueInfo.length;++s)n.valueInfo[s]=m.onnx.ValueInfoProto.toObject(e.valueInfo[s],r)}if(e.quantizationAnnotation&&e.quantizationAnnotation.length){n.quantizationAnnotation=[];for(var s=0;s<e.quantizationAnnotation.length;++s)n.quantizationAnnotation[s]=m.onnx.TensorAnnotation.toObject(e.quantizationAnnotation[s],r)}if(e.sparseInitializer&&e.sparseInitializer.length){n.sparseInitializer=[];for(var s=0;s<e.sparseInitializer.length;++s)n.sparseInitializer[s]=m.onnx.SparseTensorProto.toObject(e.sparseInitializer[s],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.GraphProto"},t}(),a.TensorProto=function(){function t(o){if(this.dims=[],this.floatData=[],this.int32Data=[],this.stringData=[],this.int64Data=[],this.externalData=[],this.doubleData=[],this.uint64Data=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.dims=y.emptyArray,t.prototype.dataType=0,t.prototype.segment=null,t.prototype.floatData=y.emptyArray,t.prototype.int32Data=y.emptyArray,t.prototype.stringData=y.emptyArray,t.prototype.int64Data=y.emptyArray,t.prototype.name="",t.prototype.docString="",t.prototype.rawData=y.newBuffer([]),t.prototype.externalData=y.emptyArray,t.prototype.dataLocation=0,t.prototype.doubleData=y.emptyArray,t.prototype.uint64Data=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.dims!=null&&e.dims.length){r.uint32(10).fork();for(var n=0;n<e.dims.length;++n)r.int64(e.dims[n]);r.ldelim()}if(e.dataType!=null&&Object.hasOwnProperty.call(e,"dataType")&&r.uint32(16).int32(e.dataType),e.segment!=null&&Object.hasOwnProperty.call(e,"segment")&&m.onnx.TensorProto.Segment.encode(e.segment,r.uint32(26).fork()).ldelim(),e.floatData!=null&&e.floatData.length){r.uint32(34).fork();for(var n=0;n<e.floatData.length;++n)r.float(e.floatData[n]);r.ldelim()}if(e.int32Data!=null&&e.int32Data.length){r.uint32(42).fork();for(var n=0;n<e.int32Data.length;++n)r.int32(e.int32Data[n]);r.ldelim()}if(e.stringData!=null&&e.stringData.length)for(var n=0;n<e.stringData.length;++n)r.uint32(50).bytes(e.stringData[n]);if(e.int64Data!=null&&e.int64Data.length){r.uint32(58).fork();for(var n=0;n<e.int64Data.length;++n)r.int64(e.int64Data[n]);r.ldelim()}if(e.name!=null&&Object.hasOwnProperty.call(e,"name")&&r.uint32(66).string(e.name),e.rawData!=null&&Object.hasOwnProperty.call(e,"rawData")&&r.uint32(74).bytes(e.rawData),e.doubleData!=null&&e.doubleData.length){r.uint32(82).fork();for(var n=0;n<e.doubleData.length;++n)r.double(e.doubleData[n]);r.ldelim()}if(e.uint64Data!=null&&e.uint64Data.length){r.uint32(90).fork();for(var n=0;n<e.uint64Data.length;++n)r.uint64(e.uint64Data[n]);r.ldelim()}if(e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(98).string(e.docString),e.externalData!=null&&e.externalData.length)for(var n=0;n<e.externalData.length;++n)m.onnx.StringStringEntryProto.encode(e.externalData[n],r.uint32(106).fork()).ldelim();return e.dataLocation!=null&&Object.hasOwnProperty.call(e,"dataLocation")&&r.uint32(112).int32(e.dataLocation),r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.TensorProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{if(s.dims&&s.dims.length||(s.dims=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.dims.push(e.int64());else s.dims.push(e.int64());break}case 2:{s.dataType=e.int32();break}case 3:{s.segment=m.onnx.TensorProto.Segment.decode(e,e.uint32());break}case 4:{if(s.floatData&&s.floatData.length||(s.floatData=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.floatData.push(e.float());else s.floatData.push(e.float());break}case 5:{if(s.int32Data&&s.int32Data.length||(s.int32Data=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.int32Data.push(e.int32());else s.int32Data.push(e.int32());break}case 6:{s.stringData&&s.stringData.length||(s.stringData=[]),s.stringData.push(e.bytes());break}case 7:{if(s.int64Data&&s.int64Data.length||(s.int64Data=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.int64Data.push(e.int64());else s.int64Data.push(e.int64());break}case 8:{s.name=e.string();break}case 12:{s.docString=e.string();break}case 9:{s.rawData=e.bytes();break}case 13:{s.externalData&&s.externalData.length||(s.externalData=[]),s.externalData.push(m.onnx.StringStringEntryProto.decode(e,e.uint32()));break}case 14:{s.dataLocation=e.int32();break}case 10:{if(s.doubleData&&s.doubleData.length||(s.doubleData=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.doubleData.push(e.double());else s.doubleData.push(e.double());break}case 11:{if(s.uint64Data&&s.uint64Data.length||(s.uint64Data=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.uint64Data.push(e.uint64());else s.uint64Data.push(e.uint64());break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.dims!=null&&e.hasOwnProperty("dims")){if(!Array.isArray(e.dims))return"dims: array expected";for(var r=0;r<e.dims.length;++r)if(!y.isInteger(e.dims[r])&&!(e.dims[r]&&y.isInteger(e.dims[r].low)&&y.isInteger(e.dims[r].high)))return"dims: integer|Long[] expected"}if(e.dataType!=null&&e.hasOwnProperty("dataType")&&!y.isInteger(e.dataType))return"dataType: integer expected";if(e.segment!=null&&e.hasOwnProperty("segment")){var n=m.onnx.TensorProto.Segment.verify(e.segment);if(n)return"segment."+n}if(e.floatData!=null&&e.hasOwnProperty("floatData")){if(!Array.isArray(e.floatData))return"floatData: array expected";for(var r=0;r<e.floatData.length;++r)if(typeof e.floatData[r]!="number")return"floatData: number[] expected"}if(e.int32Data!=null&&e.hasOwnProperty("int32Data")){if(!Array.isArray(e.int32Data))return"int32Data: array expected";for(var r=0;r<e.int32Data.length;++r)if(!y.isInteger(e.int32Data[r]))return"int32Data: integer[] expected"}if(e.stringData!=null&&e.hasOwnProperty("stringData")){if(!Array.isArray(e.stringData))return"stringData: array expected";for(var r=0;r<e.stringData.length;++r)if(!(e.stringData[r]&&typeof e.stringData[r].length=="number"||y.isString(e.stringData[r])))return"stringData: buffer[] expected"}if(e.int64Data!=null&&e.hasOwnProperty("int64Data")){if(!Array.isArray(e.int64Data))return"int64Data: array expected";for(var r=0;r<e.int64Data.length;++r)if(!y.isInteger(e.int64Data[r])&&!(e.int64Data[r]&&y.isInteger(e.int64Data[r].low)&&y.isInteger(e.int64Data[r].high)))return"int64Data: integer|Long[] expected"}if(e.name!=null&&e.hasOwnProperty("name")&&!y.isString(e.name))return"name: string expected";if(e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString))return"docString: string expected";if(e.rawData!=null&&e.hasOwnProperty("rawData")&&!(e.rawData&&typeof e.rawData.length=="number"||y.isString(e.rawData)))return"rawData: buffer expected";if(e.externalData!=null&&e.hasOwnProperty("externalData")){if(!Array.isArray(e.externalData))return"externalData: array expected";for(var r=0;r<e.externalData.length;++r){var n=m.onnx.StringStringEntryProto.verify(e.externalData[r]);if(n)return"externalData."+n}}if(e.dataLocation!=null&&e.hasOwnProperty("dataLocation"))switch(e.dataLocation){default:return"dataLocation: enum value expected";case 0:case 1:break}if(e.doubleData!=null&&e.hasOwnProperty("doubleData")){if(!Array.isArray(e.doubleData))return"doubleData: array expected";for(var r=0;r<e.doubleData.length;++r)if(typeof e.doubleData[r]!="number")return"doubleData: number[] expected"}if(e.uint64Data!=null&&e.hasOwnProperty("uint64Data")){if(!Array.isArray(e.uint64Data))return"uint64Data: array expected";for(var r=0;r<e.uint64Data.length;++r)if(!y.isInteger(e.uint64Data[r])&&!(e.uint64Data[r]&&y.isInteger(e.uint64Data[r].low)&&y.isInteger(e.uint64Data[r].high)))return"uint64Data: integer|Long[] expected"}return null},t.fromObject=function(e){if(e instanceof m.onnx.TensorProto)return e;var r=new m.onnx.TensorProto;if(e.dims){if(!Array.isArray(e.dims))throw TypeError(".onnx.TensorProto.dims: array expected");r.dims=[];for(var n=0;n<e.dims.length;++n)y.Long?(r.dims[n]=y.Long.fromValue(e.dims[n])).unsigned=!1:typeof e.dims[n]=="string"?r.dims[n]=parseInt(e.dims[n],10):typeof e.dims[n]=="number"?r.dims[n]=e.dims[n]:typeof e.dims[n]=="object"&&(r.dims[n]=new y.LongBits(e.dims[n].low>>>0,e.dims[n].high>>>0).toNumber())}if(e.dataType!=null&&(r.dataType=e.dataType|0),e.segment!=null){if(typeof e.segment!="object")throw TypeError(".onnx.TensorProto.segment: object expected");r.segment=m.onnx.TensorProto.Segment.fromObject(e.segment)}if(e.floatData){if(!Array.isArray(e.floatData))throw TypeError(".onnx.TensorProto.floatData: array expected");r.floatData=[];for(var n=0;n<e.floatData.length;++n)r.floatData[n]=Number(e.floatData[n])}if(e.int32Data){if(!Array.isArray(e.int32Data))throw TypeError(".onnx.TensorProto.int32Data: array expected");r.int32Data=[];for(var n=0;n<e.int32Data.length;++n)r.int32Data[n]=e.int32Data[n]|0}if(e.stringData){if(!Array.isArray(e.stringData))throw TypeError(".onnx.TensorProto.stringData: array expected");r.stringData=[];for(var n=0;n<e.stringData.length;++n)typeof e.stringData[n]=="string"?y.base64.decode(e.stringData[n],r.stringData[n]=y.newBuffer(y.base64.length(e.stringData[n])),0):e.stringData[n].length>=0&&(r.stringData[n]=e.stringData[n])}if(e.int64Data){if(!Array.isArray(e.int64Data))throw TypeError(".onnx.TensorProto.int64Data: array expected");r.int64Data=[];for(var n=0;n<e.int64Data.length;++n)y.Long?(r.int64Data[n]=y.Long.fromValue(e.int64Data[n])).unsigned=!1:typeof e.int64Data[n]=="string"?r.int64Data[n]=parseInt(e.int64Data[n],10):typeof e.int64Data[n]=="number"?r.int64Data[n]=e.int64Data[n]:typeof e.int64Data[n]=="object"&&(r.int64Data[n]=new y.LongBits(e.int64Data[n].low>>>0,e.int64Data[n].high>>>0).toNumber())}if(e.name!=null&&(r.name=String(e.name)),e.docString!=null&&(r.docString=String(e.docString)),e.rawData!=null&&(typeof e.rawData=="string"?y.base64.decode(e.rawData,r.rawData=y.newBuffer(y.base64.length(e.rawData)),0):e.rawData.length>=0&&(r.rawData=e.rawData)),e.externalData){if(!Array.isArray(e.externalData))throw TypeError(".onnx.TensorProto.externalData: array expected");r.externalData=[];for(var n=0;n<e.externalData.length;++n){if(typeof e.externalData[n]!="object")throw TypeError(".onnx.TensorProto.externalData: object expected");r.externalData[n]=m.onnx.StringStringEntryProto.fromObject(e.externalData[n])}}switch(e.dataLocation){default:if(typeof e.dataLocation=="number"){r.dataLocation=e.dataLocation;break}break;case"DEFAULT":case 0:r.dataLocation=0;break;case"EXTERNAL":case 1:r.dataLocation=1;break}if(e.doubleData){if(!Array.isArray(e.doubleData))throw TypeError(".onnx.TensorProto.doubleData: array expected");r.doubleData=[];for(var n=0;n<e.doubleData.length;++n)r.doubleData[n]=Number(e.doubleData[n])}if(e.uint64Data){if(!Array.isArray(e.uint64Data))throw TypeError(".onnx.TensorProto.uint64Data: array expected");r.uint64Data=[];for(var n=0;n<e.uint64Data.length;++n)y.Long?(r.uint64Data[n]=y.Long.fromValue(e.uint64Data[n])).unsigned=!0:typeof e.uint64Data[n]=="string"?r.uint64Data[n]=parseInt(e.uint64Data[n],10):typeof e.uint64Data[n]=="number"?r.uint64Data[n]=e.uint64Data[n]:typeof e.uint64Data[n]=="object"&&(r.uint64Data[n]=new y.LongBits(e.uint64Data[n].low>>>0,e.uint64Data[n].high>>>0).toNumber(!0))}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.dims=[],n.floatData=[],n.int32Data=[],n.stringData=[],n.int64Data=[],n.doubleData=[],n.uint64Data=[],n.externalData=[]),r.defaults&&(n.dataType=0,n.segment=null,n.name="",r.bytes===String?n.rawData="":(n.rawData=[],r.bytes!==Array&&(n.rawData=y.newBuffer(n.rawData))),n.docString="",n.dataLocation=r.enums===String?"DEFAULT":0),e.dims&&e.dims.length){n.dims=[];for(var s=0;s<e.dims.length;++s)typeof e.dims[s]=="number"?n.dims[s]=r.longs===String?String(e.dims[s]):e.dims[s]:n.dims[s]=r.longs===String?y.Long.prototype.toString.call(e.dims[s]):r.longs===Number?new y.LongBits(e.dims[s].low>>>0,e.dims[s].high>>>0).toNumber():e.dims[s]}if(e.dataType!=null&&e.hasOwnProperty("dataType")&&(n.dataType=e.dataType),e.segment!=null&&e.hasOwnProperty("segment")&&(n.segment=m.onnx.TensorProto.Segment.toObject(e.segment,r)),e.floatData&&e.floatData.length){n.floatData=[];for(var s=0;s<e.floatData.length;++s)n.floatData[s]=r.json&&!isFinite(e.floatData[s])?String(e.floatData[s]):e.floatData[s]}if(e.int32Data&&e.int32Data.length){n.int32Data=[];for(var s=0;s<e.int32Data.length;++s)n.int32Data[s]=e.int32Data[s]}if(e.stringData&&e.stringData.length){n.stringData=[];for(var s=0;s<e.stringData.length;++s)n.stringData[s]=r.bytes===String?y.base64.encode(e.stringData[s],0,e.stringData[s].length):r.bytes===Array?Array.prototype.slice.call(e.stringData[s]):e.stringData[s]}if(e.int64Data&&e.int64Data.length){n.int64Data=[];for(var s=0;s<e.int64Data.length;++s)typeof e.int64Data[s]=="number"?n.int64Data[s]=r.longs===String?String(e.int64Data[s]):e.int64Data[s]:n.int64Data[s]=r.longs===String?y.Long.prototype.toString.call(e.int64Data[s]):r.longs===Number?new y.LongBits(e.int64Data[s].low>>>0,e.int64Data[s].high>>>0).toNumber():e.int64Data[s]}if(e.name!=null&&e.hasOwnProperty("name")&&(n.name=e.name),e.rawData!=null&&e.hasOwnProperty("rawData")&&(n.rawData=r.bytes===String?y.base64.encode(e.rawData,0,e.rawData.length):r.bytes===Array?Array.prototype.slice.call(e.rawData):e.rawData),e.doubleData&&e.doubleData.length){n.doubleData=[];for(var s=0;s<e.doubleData.length;++s)n.doubleData[s]=r.json&&!isFinite(e.doubleData[s])?String(e.doubleData[s]):e.doubleData[s]}if(e.uint64Data&&e.uint64Data.length){n.uint64Data=[];for(var s=0;s<e.uint64Data.length;++s)typeof e.uint64Data[s]=="number"?n.uint64Data[s]=r.longs===String?String(e.uint64Data[s]):e.uint64Data[s]:n.uint64Data[s]=r.longs===String?y.Long.prototype.toString.call(e.uint64Data[s]):r.longs===Number?new y.LongBits(e.uint64Data[s].low>>>0,e.uint64Data[s].high>>>0).toNumber(!0):e.uint64Data[s]}if(e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),e.externalData&&e.externalData.length){n.externalData=[];for(var s=0;s<e.externalData.length;++s)n.externalData[s]=m.onnx.StringStringEntryProto.toObject(e.externalData[s],r)}return e.dataLocation!=null&&e.hasOwnProperty("dataLocation")&&(n.dataLocation=r.enums===String?m.onnx.TensorProto.DataLocation[e.dataLocation]===void 0?e.dataLocation:m.onnx.TensorProto.DataLocation[e.dataLocation]:e.dataLocation),n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.TensorProto"},t.DataType=function(){var o={},e=Object.create(o);return e[o[0]="UNDEFINED"]=0,e[o[1]="FLOAT"]=1,e[o[2]="UINT8"]=2,e[o[3]="INT8"]=3,e[o[4]="UINT16"]=4,e[o[5]="INT16"]=5,e[o[6]="INT32"]=6,e[o[7]="INT64"]=7,e[o[8]="STRING"]=8,e[o[9]="BOOL"]=9,e[o[10]="FLOAT16"]=10,e[o[11]="DOUBLE"]=11,e[o[12]="UINT32"]=12,e[o[13]="UINT64"]=13,e[o[14]="COMPLEX64"]=14,e[o[15]="COMPLEX128"]=15,e[o[16]="BFLOAT16"]=16,e[o[17]="FLOAT8E4M3FN"]=17,e[o[18]="FLOAT8E4M3FNUZ"]=18,e[o[19]="FLOAT8E5M2"]=19,e[o[20]="FLOAT8E5M2FNUZ"]=20,e}(),t.Segment=function(){function o(e){if(e)for(var r=Object.keys(e),n=0;n<r.length;++n)e[r[n]]!=null&&(this[r[n]]=e[r[n]])}return o.prototype.begin=y.Long?y.Long.fromBits(0,0,!1):0,o.prototype.end=y.Long?y.Long.fromBits(0,0,!1):0,o.create=function(r){return new o(r)},o.encode=function(r,n){return n||(n=Ae.create()),r.begin!=null&&Object.hasOwnProperty.call(r,"begin")&&n.uint32(8).int64(r.begin),r.end!=null&&Object.hasOwnProperty.call(r,"end")&&n.uint32(16).int64(r.end),n},o.encodeDelimited=function(r,n){return this.encode(r,n).ldelim()},o.decode=function(r,n){r instanceof N||(r=N.create(r));for(var s=n===void 0?r.len:r.pos+n,i=new m.onnx.TensorProto.Segment;r.pos<s;){var u=r.uint32();switch(u>>>3){case 1:{i.begin=r.int64();break}case 2:{i.end=r.int64();break}default:r.skipType(u&7);break}}return i},o.decodeDelimited=function(r){return r instanceof N||(r=new N(r)),this.decode(r,r.uint32())},o.verify=function(r){return typeof r!="object"||r===null?"object expected":r.begin!=null&&r.hasOwnProperty("begin")&&!y.isInteger(r.begin)&&!(r.begin&&y.isInteger(r.begin.low)&&y.isInteger(r.begin.high))?"begin: integer|Long expected":r.end!=null&&r.hasOwnProperty("end")&&!y.isInteger(r.end)&&!(r.end&&y.isInteger(r.end.low)&&y.isInteger(r.end.high))?"end: integer|Long expected":null},o.fromObject=function(r){if(r instanceof m.onnx.TensorProto.Segment)return r;var n=new m.onnx.TensorProto.Segment;return r.begin!=null&&(y.Long?(n.begin=y.Long.fromValue(r.begin)).unsigned=!1:typeof r.begin=="string"?n.begin=parseInt(r.begin,10):typeof r.begin=="number"?n.begin=r.begin:typeof r.begin=="object"&&(n.begin=new y.LongBits(r.begin.low>>>0,r.begin.high>>>0).toNumber())),r.end!=null&&(y.Long?(n.end=y.Long.fromValue(r.end)).unsigned=!1:typeof r.end=="string"?n.end=parseInt(r.end,10):typeof r.end=="number"?n.end=r.end:typeof r.end=="object"&&(n.end=new y.LongBits(r.end.low>>>0,r.end.high>>>0).toNumber())),n},o.toObject=function(r,n){n||(n={});var s={};if(n.defaults){if(y.Long){var i=new y.Long(0,0,!1);s.begin=n.longs===String?i.toString():n.longs===Number?i.toNumber():i}else s.begin=n.longs===String?"0":0;if(y.Long){var i=new y.Long(0,0,!1);s.end=n.longs===String?i.toString():n.longs===Number?i.toNumber():i}else s.end=n.longs===String?"0":0}return r.begin!=null&&r.hasOwnProperty("begin")&&(typeof r.begin=="number"?s.begin=n.longs===String?String(r.begin):r.begin:s.begin=n.longs===String?y.Long.prototype.toString.call(r.begin):n.longs===Number?new y.LongBits(r.begin.low>>>0,r.begin.high>>>0).toNumber():r.begin),r.end!=null&&r.hasOwnProperty("end")&&(typeof r.end=="number"?s.end=n.longs===String?String(r.end):r.end:s.end=n.longs===String?y.Long.prototype.toString.call(r.end):n.longs===Number?new y.LongBits(r.end.low>>>0,r.end.high>>>0).toNumber():r.end),s},o.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},o.getTypeUrl=function(r){return r===void 0&&(r="type.googleapis.com"),r+"/onnx.TensorProto.Segment"},o}(),t.DataLocation=function(){var o={},e=Object.create(o);return e[o[0]="DEFAULT"]=0,e[o[1]="EXTERNAL"]=1,e}(),t}(),a.SparseTensorProto=function(){function t(o){if(this.dims=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.values=null,t.prototype.indices=null,t.prototype.dims=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.values!=null&&Object.hasOwnProperty.call(e,"values")&&m.onnx.TensorProto.encode(e.values,r.uint32(10).fork()).ldelim(),e.indices!=null&&Object.hasOwnProperty.call(e,"indices")&&m.onnx.TensorProto.encode(e.indices,r.uint32(18).fork()).ldelim(),e.dims!=null&&e.dims.length){r.uint32(26).fork();for(var n=0;n<e.dims.length;++n)r.int64(e.dims[n]);r.ldelim()}return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.SparseTensorProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.values=m.onnx.TensorProto.decode(e,e.uint32());break}case 2:{s.indices=m.onnx.TensorProto.decode(e,e.uint32());break}case 3:{if(s.dims&&s.dims.length||(s.dims=[]),(i&7)===2)for(var u=e.uint32()+e.pos;e.pos<u;)s.dims.push(e.int64());else s.dims.push(e.int64());break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.values!=null&&e.hasOwnProperty("values")){var r=m.onnx.TensorProto.verify(e.values);if(r)return"values."+r}if(e.indices!=null&&e.hasOwnProperty("indices")){var r=m.onnx.TensorProto.verify(e.indices);if(r)return"indices."+r}if(e.dims!=null&&e.hasOwnProperty("dims")){if(!Array.isArray(e.dims))return"dims: array expected";for(var n=0;n<e.dims.length;++n)if(!y.isInteger(e.dims[n])&&!(e.dims[n]&&y.isInteger(e.dims[n].low)&&y.isInteger(e.dims[n].high)))return"dims: integer|Long[] expected"}return null},t.fromObject=function(e){if(e instanceof m.onnx.SparseTensorProto)return e;var r=new m.onnx.SparseTensorProto;if(e.values!=null){if(typeof e.values!="object")throw TypeError(".onnx.SparseTensorProto.values: object expected");r.values=m.onnx.TensorProto.fromObject(e.values)}if(e.indices!=null){if(typeof e.indices!="object")throw TypeError(".onnx.SparseTensorProto.indices: object expected");r.indices=m.onnx.TensorProto.fromObject(e.indices)}if(e.dims){if(!Array.isArray(e.dims))throw TypeError(".onnx.SparseTensorProto.dims: array expected");r.dims=[];for(var n=0;n<e.dims.length;++n)y.Long?(r.dims[n]=y.Long.fromValue(e.dims[n])).unsigned=!1:typeof e.dims[n]=="string"?r.dims[n]=parseInt(e.dims[n],10):typeof e.dims[n]=="number"?r.dims[n]=e.dims[n]:typeof e.dims[n]=="object"&&(r.dims[n]=new y.LongBits(e.dims[n].low>>>0,e.dims[n].high>>>0).toNumber())}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.dims=[]),r.defaults&&(n.values=null,n.indices=null),e.values!=null&&e.hasOwnProperty("values")&&(n.values=m.onnx.TensorProto.toObject(e.values,r)),e.indices!=null&&e.hasOwnProperty("indices")&&(n.indices=m.onnx.TensorProto.toObject(e.indices,r)),e.dims&&e.dims.length){n.dims=[];for(var s=0;s<e.dims.length;++s)typeof e.dims[s]=="number"?n.dims[s]=r.longs===String?String(e.dims[s]):e.dims[s]:n.dims[s]=r.longs===String?y.Long.prototype.toString.call(e.dims[s]):r.longs===Number?new y.LongBits(e.dims[s].low>>>0,e.dims[s].high>>>0).toNumber():e.dims[s]}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.SparseTensorProto"},t}(),a.TensorShapeProto=function(){function t(o){if(this.dim=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.dim=y.emptyArray,t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.dim!=null&&e.dim.length)for(var n=0;n<e.dim.length;++n)m.onnx.TensorShapeProto.Dimension.encode(e.dim[n],r.uint32(10).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.TensorShapeProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.dim&&s.dim.length||(s.dim=[]),s.dim.push(m.onnx.TensorShapeProto.Dimension.decode(e,e.uint32()));break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.dim!=null&&e.hasOwnProperty("dim")){if(!Array.isArray(e.dim))return"dim: array expected";for(var r=0;r<e.dim.length;++r){var n=m.onnx.TensorShapeProto.Dimension.verify(e.dim[r]);if(n)return"dim."+n}}return null},t.fromObject=function(e){if(e instanceof m.onnx.TensorShapeProto)return e;var r=new m.onnx.TensorShapeProto;if(e.dim){if(!Array.isArray(e.dim))throw TypeError(".onnx.TensorShapeProto.dim: array expected");r.dim=[];for(var n=0;n<e.dim.length;++n){if(typeof e.dim[n]!="object")throw TypeError(".onnx.TensorShapeProto.dim: object expected");r.dim[n]=m.onnx.TensorShapeProto.Dimension.fromObject(e.dim[n])}}return r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.dim=[]),e.dim&&e.dim.length){n.dim=[];for(var s=0;s<e.dim.length;++s)n.dim[s]=m.onnx.TensorShapeProto.Dimension.toObject(e.dim[s],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.TensorShapeProto"},t.Dimension=function(){function o(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}o.prototype.dimValue=null,o.prototype.dimParam=null,o.prototype.denotation="";var e;return Object.defineProperty(o.prototype,"value",{get:y.oneOfGetter(e=["dimValue","dimParam"]),set:y.oneOfSetter(e)}),o.create=function(n){return new o(n)},o.encode=function(n,s){return s||(s=Ae.create()),n.dimValue!=null&&Object.hasOwnProperty.call(n,"dimValue")&&s.uint32(8).int64(n.dimValue),n.dimParam!=null&&Object.hasOwnProperty.call(n,"dimParam")&&s.uint32(18).string(n.dimParam),n.denotation!=null&&Object.hasOwnProperty.call(n,"denotation")&&s.uint32(26).string(n.denotation),s},o.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},o.decode=function(n,s){n instanceof N||(n=N.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new m.onnx.TensorShapeProto.Dimension;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.dimValue=n.int64();break}case 2:{u.dimParam=n.string();break}case 3:{u.denotation=n.string();break}default:n.skipType(l&7);break}}return u},o.decodeDelimited=function(n){return n instanceof N||(n=new N(n)),this.decode(n,n.uint32())},o.verify=function(n){if(typeof n!="object"||n===null)return"object expected";var s={};if(n.dimValue!=null&&n.hasOwnProperty("dimValue")&&(s.value=1,!y.isInteger(n.dimValue)&&!(n.dimValue&&y.isInteger(n.dimValue.low)&&y.isInteger(n.dimValue.high))))return"dimValue: integer|Long expected";if(n.dimParam!=null&&n.hasOwnProperty("dimParam")){if(s.value===1)return"value: multiple values";if(s.value=1,!y.isString(n.dimParam))return"dimParam: string expected"}return n.denotation!=null&&n.hasOwnProperty("denotation")&&!y.isString(n.denotation)?"denotation: string expected":null},o.fromObject=function(n){if(n instanceof m.onnx.TensorShapeProto.Dimension)return n;var s=new m.onnx.TensorShapeProto.Dimension;return n.dimValue!=null&&(y.Long?(s.dimValue=y.Long.fromValue(n.dimValue)).unsigned=!1:typeof n.dimValue=="string"?s.dimValue=parseInt(n.dimValue,10):typeof n.dimValue=="number"?s.dimValue=n.dimValue:typeof n.dimValue=="object"&&(s.dimValue=new y.LongBits(n.dimValue.low>>>0,n.dimValue.high>>>0).toNumber())),n.dimParam!=null&&(s.dimParam=String(n.dimParam)),n.denotation!=null&&(s.denotation=String(n.denotation)),s},o.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.denotation=""),n.dimValue!=null&&n.hasOwnProperty("dimValue")&&(typeof n.dimValue=="number"?i.dimValue=s.longs===String?String(n.dimValue):n.dimValue:i.dimValue=s.longs===String?y.Long.prototype.toString.call(n.dimValue):s.longs===Number?new y.LongBits(n.dimValue.low>>>0,n.dimValue.high>>>0).toNumber():n.dimValue,s.oneofs&&(i.value="dimValue")),n.dimParam!=null&&n.hasOwnProperty("dimParam")&&(i.dimParam=n.dimParam,s.oneofs&&(i.value="dimParam")),n.denotation!=null&&n.hasOwnProperty("denotation")&&(i.denotation=n.denotation),i},o.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},o.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TensorShapeProto.Dimension"},o}(),t}(),a.TypeProto=function(){function t(e){if(e)for(var r=Object.keys(e),n=0;n<r.length;++n)e[r[n]]!=null&&(this[r[n]]=e[r[n]])}t.prototype.tensorType=null,t.prototype.sequenceType=null,t.prototype.mapType=null,t.prototype.optionalType=null,t.prototype.sparseTensorType=null,t.prototype.denotation="";var o;return Object.defineProperty(t.prototype,"value",{get:y.oneOfGetter(o=["tensorType","sequenceType","mapType","optionalType","sparseTensorType"]),set:y.oneOfSetter(o)}),t.create=function(r){return new t(r)},t.encode=function(r,n){return n||(n=Ae.create()),r.tensorType!=null&&Object.hasOwnProperty.call(r,"tensorType")&&m.onnx.TypeProto.Tensor.encode(r.tensorType,n.uint32(10).fork()).ldelim(),r.sequenceType!=null&&Object.hasOwnProperty.call(r,"sequenceType")&&m.onnx.TypeProto.Sequence.encode(r.sequenceType,n.uint32(34).fork()).ldelim(),r.mapType!=null&&Object.hasOwnProperty.call(r,"mapType")&&m.onnx.TypeProto.Map.encode(r.mapType,n.uint32(42).fork()).ldelim(),r.denotation!=null&&Object.hasOwnProperty.call(r,"denotation")&&n.uint32(50).string(r.denotation),r.sparseTensorType!=null&&Object.hasOwnProperty.call(r,"sparseTensorType")&&m.onnx.TypeProto.SparseTensor.encode(r.sparseTensorType,n.uint32(66).fork()).ldelim(),r.optionalType!=null&&Object.hasOwnProperty.call(r,"optionalType")&&m.onnx.TypeProto.Optional.encode(r.optionalType,n.uint32(74).fork()).ldelim(),n},t.encodeDelimited=function(r,n){return this.encode(r,n).ldelim()},t.decode=function(r,n){r instanceof N||(r=N.create(r));for(var s=n===void 0?r.len:r.pos+n,i=new m.onnx.TypeProto;r.pos<s;){var u=r.uint32();switch(u>>>3){case 1:{i.tensorType=m.onnx.TypeProto.Tensor.decode(r,r.uint32());break}case 4:{i.sequenceType=m.onnx.TypeProto.Sequence.decode(r,r.uint32());break}case 5:{i.mapType=m.onnx.TypeProto.Map.decode(r,r.uint32());break}case 9:{i.optionalType=m.onnx.TypeProto.Optional.decode(r,r.uint32());break}case 8:{i.sparseTensorType=m.onnx.TypeProto.SparseTensor.decode(r,r.uint32());break}case 6:{i.denotation=r.string();break}default:r.skipType(u&7);break}}return i},t.decodeDelimited=function(r){return r instanceof N||(r=new N(r)),this.decode(r,r.uint32())},t.verify=function(r){if(typeof r!="object"||r===null)return"object expected";var n={};if(r.tensorType!=null&&r.hasOwnProperty("tensorType")){n.value=1;{var s=m.onnx.TypeProto.Tensor.verify(r.tensorType);if(s)return"tensorType."+s}}if(r.sequenceType!=null&&r.hasOwnProperty("sequenceType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=m.onnx.TypeProto.Sequence.verify(r.sequenceType);if(s)return"sequenceType."+s}}if(r.mapType!=null&&r.hasOwnProperty("mapType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=m.onnx.TypeProto.Map.verify(r.mapType);if(s)return"mapType."+s}}if(r.optionalType!=null&&r.hasOwnProperty("optionalType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=m.onnx.TypeProto.Optional.verify(r.optionalType);if(s)return"optionalType."+s}}if(r.sparseTensorType!=null&&r.hasOwnProperty("sparseTensorType")){if(n.value===1)return"value: multiple values";n.value=1;{var s=m.onnx.TypeProto.SparseTensor.verify(r.sparseTensorType);if(s)return"sparseTensorType."+s}}return r.denotation!=null&&r.hasOwnProperty("denotation")&&!y.isString(r.denotation)?"denotation: string expected":null},t.fromObject=function(r){if(r instanceof m.onnx.TypeProto)return r;var n=new m.onnx.TypeProto;if(r.tensorType!=null){if(typeof r.tensorType!="object")throw TypeError(".onnx.TypeProto.tensorType: object expected");n.tensorType=m.onnx.TypeProto.Tensor.fromObject(r.tensorType)}if(r.sequenceType!=null){if(typeof r.sequenceType!="object")throw TypeError(".onnx.TypeProto.sequenceType: object expected");n.sequenceType=m.onnx.TypeProto.Sequence.fromObject(r.sequenceType)}if(r.mapType!=null){if(typeof r.mapType!="object")throw TypeError(".onnx.TypeProto.mapType: object expected");n.mapType=m.onnx.TypeProto.Map.fromObject(r.mapType)}if(r.optionalType!=null){if(typeof r.optionalType!="object")throw TypeError(".onnx.TypeProto.optionalType: object expected");n.optionalType=m.onnx.TypeProto.Optional.fromObject(r.optionalType)}if(r.sparseTensorType!=null){if(typeof r.sparseTensorType!="object")throw TypeError(".onnx.TypeProto.sparseTensorType: object expected");n.sparseTensorType=m.onnx.TypeProto.SparseTensor.fromObject(r.sparseTensorType)}return r.denotation!=null&&(n.denotation=String(r.denotation)),n},t.toObject=function(r,n){n||(n={});var s={};return n.defaults&&(s.denotation=""),r.tensorType!=null&&r.hasOwnProperty("tensorType")&&(s.tensorType=m.onnx.TypeProto.Tensor.toObject(r.tensorType,n),n.oneofs&&(s.value="tensorType")),r.sequenceType!=null&&r.hasOwnProperty("sequenceType")&&(s.sequenceType=m.onnx.TypeProto.Sequence.toObject(r.sequenceType,n),n.oneofs&&(s.value="sequenceType")),r.mapType!=null&&r.hasOwnProperty("mapType")&&(s.mapType=m.onnx.TypeProto.Map.toObject(r.mapType,n),n.oneofs&&(s.value="mapType")),r.denotation!=null&&r.hasOwnProperty("denotation")&&(s.denotation=r.denotation),r.sparseTensorType!=null&&r.hasOwnProperty("sparseTensorType")&&(s.sparseTensorType=m.onnx.TypeProto.SparseTensor.toObject(r.sparseTensorType,n),n.oneofs&&(s.value="sparseTensorType")),r.optionalType!=null&&r.hasOwnProperty("optionalType")&&(s.optionalType=m.onnx.TypeProto.Optional.toObject(r.optionalType,n),n.oneofs&&(s.value="optionalType")),s},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(r){return r===void 0&&(r="type.googleapis.com"),r+"/onnx.TypeProto"},t.Tensor=function(){function e(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return e.prototype.elemType=0,e.prototype.shape=null,e.create=function(n){return new e(n)},e.encode=function(n,s){return s||(s=Ae.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&s.uint32(8).int32(n.elemType),n.shape!=null&&Object.hasOwnProperty.call(n,"shape")&&m.onnx.TensorShapeProto.encode(n.shape,s.uint32(18).fork()).ldelim(),s},e.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},e.decode=function(n,s){n instanceof N||(n=N.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new m.onnx.TypeProto.Tensor;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=n.int32();break}case 2:{u.shape=m.onnx.TensorShapeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},e.decodeDelimited=function(n){return n instanceof N||(n=new N(n)),this.decode(n,n.uint32())},e.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")&&!y.isInteger(n.elemType))return"elemType: integer expected";if(n.shape!=null&&n.hasOwnProperty("shape")){var s=m.onnx.TensorShapeProto.verify(n.shape);if(s)return"shape."+s}return null},e.fromObject=function(n){if(n instanceof m.onnx.TypeProto.Tensor)return n;var s=new m.onnx.TypeProto.Tensor;if(n.elemType!=null&&(s.elemType=n.elemType|0),n.shape!=null){if(typeof n.shape!="object")throw TypeError(".onnx.TypeProto.Tensor.shape: object expected");s.shape=m.onnx.TensorShapeProto.fromObject(n.shape)}return s},e.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=0,i.shape=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=n.elemType),n.shape!=null&&n.hasOwnProperty("shape")&&(i.shape=m.onnx.TensorShapeProto.toObject(n.shape,s)),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},e.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Tensor"},e}(),t.Sequence=function(){function e(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return e.prototype.elemType=null,e.create=function(n){return new e(n)},e.encode=function(n,s){return s||(s=Ae.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&m.onnx.TypeProto.encode(n.elemType,s.uint32(10).fork()).ldelim(),s},e.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},e.decode=function(n,s){n instanceof N||(n=N.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new m.onnx.TypeProto.Sequence;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=m.onnx.TypeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},e.decodeDelimited=function(n){return n instanceof N||(n=new N(n)),this.decode(n,n.uint32())},e.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")){var s=m.onnx.TypeProto.verify(n.elemType);if(s)return"elemType."+s}return null},e.fromObject=function(n){if(n instanceof m.onnx.TypeProto.Sequence)return n;var s=new m.onnx.TypeProto.Sequence;if(n.elemType!=null){if(typeof n.elemType!="object")throw TypeError(".onnx.TypeProto.Sequence.elemType: object expected");s.elemType=m.onnx.TypeProto.fromObject(n.elemType)}return s},e.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=m.onnx.TypeProto.toObject(n.elemType,s)),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},e.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Sequence"},e}(),t.Map=function(){function e(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return e.prototype.keyType=0,e.prototype.valueType=null,e.create=function(n){return new e(n)},e.encode=function(n,s){return s||(s=Ae.create()),n.keyType!=null&&Object.hasOwnProperty.call(n,"keyType")&&s.uint32(8).int32(n.keyType),n.valueType!=null&&Object.hasOwnProperty.call(n,"valueType")&&m.onnx.TypeProto.encode(n.valueType,s.uint32(18).fork()).ldelim(),s},e.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},e.decode=function(n,s){n instanceof N||(n=N.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new m.onnx.TypeProto.Map;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.keyType=n.int32();break}case 2:{u.valueType=m.onnx.TypeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},e.decodeDelimited=function(n){return n instanceof N||(n=new N(n)),this.decode(n,n.uint32())},e.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.keyType!=null&&n.hasOwnProperty("keyType")&&!y.isInteger(n.keyType))return"keyType: integer expected";if(n.valueType!=null&&n.hasOwnProperty("valueType")){var s=m.onnx.TypeProto.verify(n.valueType);if(s)return"valueType."+s}return null},e.fromObject=function(n){if(n instanceof m.onnx.TypeProto.Map)return n;var s=new m.onnx.TypeProto.Map;if(n.keyType!=null&&(s.keyType=n.keyType|0),n.valueType!=null){if(typeof n.valueType!="object")throw TypeError(".onnx.TypeProto.Map.valueType: object expected");s.valueType=m.onnx.TypeProto.fromObject(n.valueType)}return s},e.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.keyType=0,i.valueType=null),n.keyType!=null&&n.hasOwnProperty("keyType")&&(i.keyType=n.keyType),n.valueType!=null&&n.hasOwnProperty("valueType")&&(i.valueType=m.onnx.TypeProto.toObject(n.valueType,s)),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},e.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Map"},e}(),t.Optional=function(){function e(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return e.prototype.elemType=null,e.create=function(n){return new e(n)},e.encode=function(n,s){return s||(s=Ae.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&m.onnx.TypeProto.encode(n.elemType,s.uint32(10).fork()).ldelim(),s},e.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},e.decode=function(n,s){n instanceof N||(n=N.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new m.onnx.TypeProto.Optional;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=m.onnx.TypeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},e.decodeDelimited=function(n){return n instanceof N||(n=new N(n)),this.decode(n,n.uint32())},e.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")){var s=m.onnx.TypeProto.verify(n.elemType);if(s)return"elemType."+s}return null},e.fromObject=function(n){if(n instanceof m.onnx.TypeProto.Optional)return n;var s=new m.onnx.TypeProto.Optional;if(n.elemType!=null){if(typeof n.elemType!="object")throw TypeError(".onnx.TypeProto.Optional.elemType: object expected");s.elemType=m.onnx.TypeProto.fromObject(n.elemType)}return s},e.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=m.onnx.TypeProto.toObject(n.elemType,s)),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},e.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.Optional"},e}(),t.SparseTensor=function(){function e(r){if(r)for(var n=Object.keys(r),s=0;s<n.length;++s)r[n[s]]!=null&&(this[n[s]]=r[n[s]])}return e.prototype.elemType=0,e.prototype.shape=null,e.create=function(n){return new e(n)},e.encode=function(n,s){return s||(s=Ae.create()),n.elemType!=null&&Object.hasOwnProperty.call(n,"elemType")&&s.uint32(8).int32(n.elemType),n.shape!=null&&Object.hasOwnProperty.call(n,"shape")&&m.onnx.TensorShapeProto.encode(n.shape,s.uint32(18).fork()).ldelim(),s},e.encodeDelimited=function(n,s){return this.encode(n,s).ldelim()},e.decode=function(n,s){n instanceof N||(n=N.create(n));for(var i=s===void 0?n.len:n.pos+s,u=new m.onnx.TypeProto.SparseTensor;n.pos<i;){var l=n.uint32();switch(l>>>3){case 1:{u.elemType=n.int32();break}case 2:{u.shape=m.onnx.TensorShapeProto.decode(n,n.uint32());break}default:n.skipType(l&7);break}}return u},e.decodeDelimited=function(n){return n instanceof N||(n=new N(n)),this.decode(n,n.uint32())},e.verify=function(n){if(typeof n!="object"||n===null)return"object expected";if(n.elemType!=null&&n.hasOwnProperty("elemType")&&!y.isInteger(n.elemType))return"elemType: integer expected";if(n.shape!=null&&n.hasOwnProperty("shape")){var s=m.onnx.TensorShapeProto.verify(n.shape);if(s)return"shape."+s}return null},e.fromObject=function(n){if(n instanceof m.onnx.TypeProto.SparseTensor)return n;var s=new m.onnx.TypeProto.SparseTensor;if(n.elemType!=null&&(s.elemType=n.elemType|0),n.shape!=null){if(typeof n.shape!="object")throw TypeError(".onnx.TypeProto.SparseTensor.shape: object expected");s.shape=m.onnx.TensorShapeProto.fromObject(n.shape)}return s},e.toObject=function(n,s){s||(s={});var i={};return s.defaults&&(i.elemType=0,i.shape=null),n.elemType!=null&&n.hasOwnProperty("elemType")&&(i.elemType=n.elemType),n.shape!=null&&n.hasOwnProperty("shape")&&(i.shape=m.onnx.TensorShapeProto.toObject(n.shape,s)),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},e.getTypeUrl=function(n){return n===void 0&&(n="type.googleapis.com"),n+"/onnx.TypeProto.SparseTensor"},e}(),t}(),a.OperatorSetIdProto=function(){function t(o){if(o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.domain="",t.prototype.version=y.Long?y.Long.fromBits(0,0,!1):0,t.create=function(e){return new t(e)},t.encode=function(e,r){return r||(r=Ae.create()),e.domain!=null&&Object.hasOwnProperty.call(e,"domain")&&r.uint32(10).string(e.domain),e.version!=null&&Object.hasOwnProperty.call(e,"version")&&r.uint32(16).int64(e.version),r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.OperatorSetIdProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.domain=e.string();break}case 2:{s.version=e.int64();break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){return typeof e!="object"||e===null?"object expected":e.domain!=null&&e.hasOwnProperty("domain")&&!y.isString(e.domain)?"domain: string expected":e.version!=null&&e.hasOwnProperty("version")&&!y.isInteger(e.version)&&!(e.version&&y.isInteger(e.version.low)&&y.isInteger(e.version.high))?"version: integer|Long expected":null},t.fromObject=function(e){if(e instanceof m.onnx.OperatorSetIdProto)return e;var r=new m.onnx.OperatorSetIdProto;return e.domain!=null&&(r.domain=String(e.domain)),e.version!=null&&(y.Long?(r.version=y.Long.fromValue(e.version)).unsigned=!1:typeof e.version=="string"?r.version=parseInt(e.version,10):typeof e.version=="number"?r.version=e.version:typeof e.version=="object"&&(r.version=new y.LongBits(e.version.low>>>0,e.version.high>>>0).toNumber())),r},t.toObject=function(e,r){r||(r={});var n={};if(r.defaults)if(n.domain="",y.Long){var s=new y.Long(0,0,!1);n.version=r.longs===String?s.toString():r.longs===Number?s.toNumber():s}else n.version=r.longs===String?"0":0;return e.domain!=null&&e.hasOwnProperty("domain")&&(n.domain=e.domain),e.version!=null&&e.hasOwnProperty("version")&&(typeof e.version=="number"?n.version=r.longs===String?String(e.version):e.version:n.version=r.longs===String?y.Long.prototype.toString.call(e.version):r.longs===Number?new y.LongBits(e.version.low>>>0,e.version.high>>>0).toNumber():e.version),n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.OperatorSetIdProto"},t}(),a.OperatorStatus=function(){var t={},o=Object.create(t);return o[t[0]="EXPERIMENTAL"]=0,o[t[1]="STABLE"]=1,o}(),a.FunctionProto=function(){function t(o){if(this.input=[],this.output=[],this.attribute=[],this.attributeProto=[],this.node=[],this.opsetImport=[],o)for(var e=Object.keys(o),r=0;r<e.length;++r)o[e[r]]!=null&&(this[e[r]]=o[e[r]])}return t.prototype.name="",t.prototype.input=y.emptyArray,t.prototype.output=y.emptyArray,t.prototype.attribute=y.emptyArray,t.prototype.attributeProto=y.emptyArray,t.prototype.node=y.emptyArray,t.prototype.docString="",t.prototype.opsetImport=y.emptyArray,t.prototype.domain="",t.create=function(e){return new t(e)},t.encode=function(e,r){if(r||(r=Ae.create()),e.name!=null&&Object.hasOwnProperty.call(e,"name")&&r.uint32(10).string(e.name),e.input!=null&&e.input.length)for(var n=0;n<e.input.length;++n)r.uint32(34).string(e.input[n]);if(e.output!=null&&e.output.length)for(var n=0;n<e.output.length;++n)r.uint32(42).string(e.output[n]);if(e.attribute!=null&&e.attribute.length)for(var n=0;n<e.attribute.length;++n)r.uint32(50).string(e.attribute[n]);if(e.node!=null&&e.node.length)for(var n=0;n<e.node.length;++n)m.onnx.NodeProto.encode(e.node[n],r.uint32(58).fork()).ldelim();if(e.docString!=null&&Object.hasOwnProperty.call(e,"docString")&&r.uint32(66).string(e.docString),e.opsetImport!=null&&e.opsetImport.length)for(var n=0;n<e.opsetImport.length;++n)m.onnx.OperatorSetIdProto.encode(e.opsetImport[n],r.uint32(74).fork()).ldelim();if(e.domain!=null&&Object.hasOwnProperty.call(e,"domain")&&r.uint32(82).string(e.domain),e.attributeProto!=null&&e.attributeProto.length)for(var n=0;n<e.attributeProto.length;++n)m.onnx.AttributeProto.encode(e.attributeProto[n],r.uint32(90).fork()).ldelim();return r},t.encodeDelimited=function(e,r){return this.encode(e,r).ldelim()},t.decode=function(e,r){e instanceof N||(e=N.create(e));for(var n=r===void 0?e.len:e.pos+r,s=new m.onnx.FunctionProto;e.pos<n;){var i=e.uint32();switch(i>>>3){case 1:{s.name=e.string();break}case 4:{s.input&&s.input.length||(s.input=[]),s.input.push(e.string());break}case 5:{s.output&&s.output.length||(s.output=[]),s.output.push(e.string());break}case 6:{s.attribute&&s.attribute.length||(s.attribute=[]),s.attribute.push(e.string());break}case 11:{s.attributeProto&&s.attributeProto.length||(s.attributeProto=[]),s.attributeProto.push(m.onnx.AttributeProto.decode(e,e.uint32()));break}case 7:{s.node&&s.node.length||(s.node=[]),s.node.push(m.onnx.NodeProto.decode(e,e.uint32()));break}case 8:{s.docString=e.string();break}case 9:{s.opsetImport&&s.opsetImport.length||(s.opsetImport=[]),s.opsetImport.push(m.onnx.OperatorSetIdProto.decode(e,e.uint32()));break}case 10:{s.domain=e.string();break}default:e.skipType(i&7);break}}return s},t.decodeDelimited=function(e){return e instanceof N||(e=new N(e)),this.decode(e,e.uint32())},t.verify=function(e){if(typeof e!="object"||e===null)return"object expected";if(e.name!=null&&e.hasOwnProperty("name")&&!y.isString(e.name))return"name: string expected";if(e.input!=null&&e.hasOwnProperty("input")){if(!Array.isArray(e.input))return"input: array expected";for(var r=0;r<e.input.length;++r)if(!y.isString(e.input[r]))return"input: string[] expected"}if(e.output!=null&&e.hasOwnProperty("output")){if(!Array.isArray(e.output))return"output: array expected";for(var r=0;r<e.output.length;++r)if(!y.isString(e.output[r]))return"output: string[] expected"}if(e.attribute!=null&&e.hasOwnProperty("attribute")){if(!Array.isArray(e.attribute))return"attribute: array expected";for(var r=0;r<e.attribute.length;++r)if(!y.isString(e.attribute[r]))return"attribute: string[] expected"}if(e.attributeProto!=null&&e.hasOwnProperty("attributeProto")){if(!Array.isArray(e.attributeProto))return"attributeProto: array expected";for(var r=0;r<e.attributeProto.length;++r){var n=m.onnx.AttributeProto.verify(e.attributeProto[r]);if(n)return"attributeProto."+n}}if(e.node!=null&&e.hasOwnProperty("node")){if(!Array.isArray(e.node))return"node: array expected";for(var r=0;r<e.node.length;++r){var n=m.onnx.NodeProto.verify(e.node[r]);if(n)return"node."+n}}if(e.docString!=null&&e.hasOwnProperty("docString")&&!y.isString(e.docString))return"docString: string expected";if(e.opsetImport!=null&&e.hasOwnProperty("opsetImport")){if(!Array.isArray(e.opsetImport))return"opsetImport: array expected";for(var r=0;r<e.opsetImport.length;++r){var n=m.onnx.OperatorSetIdProto.verify(e.opsetImport[r]);if(n)return"opsetImport."+n}}return e.domain!=null&&e.hasOwnProperty("domain")&&!y.isString(e.domain)?"domain: string expected":null},t.fromObject=function(e){if(e instanceof m.onnx.FunctionProto)return e;var r=new m.onnx.FunctionProto;if(e.name!=null&&(r.name=String(e.name)),e.input){if(!Array.isArray(e.input))throw TypeError(".onnx.FunctionProto.input: array expected");r.input=[];for(var n=0;n<e.input.length;++n)r.input[n]=String(e.input[n])}if(e.output){if(!Array.isArray(e.output))throw TypeError(".onnx.FunctionProto.output: array expected");r.output=[];for(var n=0;n<e.output.length;++n)r.output[n]=String(e.output[n])}if(e.attribute){if(!Array.isArray(e.attribute))throw TypeError(".onnx.FunctionProto.attribute: array expected");r.attribute=[];for(var n=0;n<e.attribute.length;++n)r.attribute[n]=String(e.attribute[n])}if(e.attributeProto){if(!Array.isArray(e.attributeProto))throw TypeError(".onnx.FunctionProto.attributeProto: array expected");r.attributeProto=[];for(var n=0;n<e.attributeProto.length;++n){if(typeof e.attributeProto[n]!="object")throw TypeError(".onnx.FunctionProto.attributeProto: object expected");r.attributeProto[n]=m.onnx.AttributeProto.fromObject(e.attributeProto[n])}}if(e.node){if(!Array.isArray(e.node))throw TypeError(".onnx.FunctionProto.node: array expected");r.node=[];for(var n=0;n<e.node.length;++n){if(typeof e.node[n]!="object")throw TypeError(".onnx.FunctionProto.node: object expected");r.node[n]=m.onnx.NodeProto.fromObject(e.node[n])}}if(e.docString!=null&&(r.docString=String(e.docString)),e.opsetImport){if(!Array.isArray(e.opsetImport))throw TypeError(".onnx.FunctionProto.opsetImport: array expected");r.opsetImport=[];for(var n=0;n<e.opsetImport.length;++n){if(typeof e.opsetImport[n]!="object")throw TypeError(".onnx.FunctionProto.opsetImport: object expected");r.opsetImport[n]=m.onnx.OperatorSetIdProto.fromObject(e.opsetImport[n])}}return e.domain!=null&&(r.domain=String(e.domain)),r},t.toObject=function(e,r){r||(r={});var n={};if((r.arrays||r.defaults)&&(n.input=[],n.output=[],n.attribute=[],n.node=[],n.opsetImport=[],n.attributeProto=[]),r.defaults&&(n.name="",n.docString="",n.domain=""),e.name!=null&&e.hasOwnProperty("name")&&(n.name=e.name),e.input&&e.input.length){n.input=[];for(var s=0;s<e.input.length;++s)n.input[s]=e.input[s]}if(e.output&&e.output.length){n.output=[];for(var s=0;s<e.output.length;++s)n.output[s]=e.output[s]}if(e.attribute&&e.attribute.length){n.attribute=[];for(var s=0;s<e.attribute.length;++s)n.attribute[s]=e.attribute[s]}if(e.node&&e.node.length){n.node=[];for(var s=0;s<e.node.length;++s)n.node[s]=m.onnx.NodeProto.toObject(e.node[s],r)}if(e.docString!=null&&e.hasOwnProperty("docString")&&(n.docString=e.docString),e.opsetImport&&e.opsetImport.length){n.opsetImport=[];for(var s=0;s<e.opsetImport.length;++s)n.opsetImport[s]=m.onnx.OperatorSetIdProto.toObject(e.opsetImport[s],r)}if(e.domain!=null&&e.hasOwnProperty("domain")&&(n.domain=e.domain),e.attributeProto&&e.attributeProto.length){n.attributeProto=[];for(var s=0;s<e.attributeProto.length;++s)n.attributeProto[s]=m.onnx.AttributeProto.toObject(e.attributeProto[s],r)}return n},t.prototype.toJSON=function(){return this.constructor.toObject(this,ge.util.toJSONOptions)},t.getTypeUrl=function(e){return e===void 0&&(e="type.googleapis.com"),e+"/onnx.FunctionProto"},t}(),a}();$u.exports=m});function Cr(a,t){if(!a)throw new Error(typeof t=="string"?t:t())}function sn(a){return new TextDecoder().decode(a)}var ye,pr,mi,Xe,Xn,Ve,nt,U,an,dr,hr,mr,fe=L(()=>{"use strict";Wn();ti();ye=Er($r());br();pr=class{static arraysEqual(t,o){if(t.length!==o.length)return!1;for(let e=0;e<t.length;e++)if(t[e]!==o[e])return!1;return!0}},mi=class{static preprocessInputShapes(t,o){let e=t.length===1?[1,t[0]]:t,r=o.length===1?[o[0],1]:o;return[e,r]}static postprocessOutputShape(t,o,e){o===1&&t.splice(t.length-2,1),e===1&&t.pop()}static calcMatMulShape(t,o){return t[1]!==o[0]?void 0:[t[0],o[1]]}},Xe=class a{static calcShape(t,o,e=!1){let r=t.length,n=o.length;if(r===0)return o;if(n===0)return t;let s=Math.max(t.length,o.length),i=new Array(s);if(e){if(r<2||n<2)return;let u=mi.calcMatMulShape([t[r-2],t[r-1]],[o[n-2],o[n-1]]);if(u===void 0)return;[i[s-2],i[s-1]]=u}for(let u=e?3:1;u<=s;u++){let l=r-u<0?1:t[r-u],f=n-u<0?1:o[n-u];if(l!==f&&l>1&&f>1)return;i[s-u]=Math.max(l,f)}return i}static index(t,o){let e=new Array(o.length);return a.fillIndex(t,o,e),e}static fillIndex(t,o,e){let r=t.length-o.length;for(let n=0;n<o.length;n++)e[n]=t[r+n]%o[n]}static calc(t,o,e,r,n){let s=a.calcShape(t.dims,o.dims);if(s){if(r&&!U.areEqual(s,t.dims))return;let i=U.size(s),u=r?t:new Fe(s,n||t.type);if(s.length===0)u.set([],e(t.get([]),o.get([])));else{let l=new Array(s.length),f=new Array(t.dims.length),p=new Array(o.dims.length),d=0,T=0,O=!1,v=!1;t.dims.length===0&&(d=t.get([]),O=!0),o.dims.length===0&&(T=o.get([]),v=!0);let S;for(let E=0;E<i;E++){S=E;for(let F=s.length-1;F>=0;F--)l[F]=S%s[F],S=Math.floor(S/s[F]);O||(a.fillIndex(l,t.dims,f),d=t.get(f)),v||(a.fillIndex(l,o.dims,p),T=o.get(p)),u.set(l,e(d,T))}}return u}}static isValidBroadcast(t,o){let e=t.length,r=o.length;if(e>r)return!1;for(let n=1;n<=e;n++)if(t[e-n]!==1&&t[e-n]!==o[r-n])return!1;return!0}static getBroadcastDims(t,o){let e=t.length,r=[];for(let n=0;n<e;n++){let s=e-1-n,i=t[s]||1;(o[o.length-1-n]||1)>1&&i===1&&r.unshift(s)}return r}},Xn=class{static getShapeOfGemmResult(t,o,e,r,n){if(t.length!==2||e.length!==2)throw new Error("shape need to be of size 2");let s,i,u;o?(s=t[1],i=t[0]):(s=t[0],i=t[1]);let l=-1;if(r?(u=e[0],l=1):(u=e[1],l=0),e[l]!==i)throw new Error("dimension mismatch");if(s<=0||u<=0||i<=0)throw new Error("invalid shape specified");if(n&&!Xe.isValidBroadcast(n,[s,u]))throw new Error("gemm: invalid bias shape for broadcast");return[s,u,i]}},Ve=class a{static tensorDataTypeFromProto(t){switch(t){case ye.onnx.TensorProto.DataType.INT8:return"int8";case ye.onnx.TensorProto.DataType.UINT8:return"uint8";case ye.onnx.TensorProto.DataType.BOOL:return"bool";case ye.onnx.TensorProto.DataType.INT16:return"int16";case ye.onnx.TensorProto.DataType.UINT16:return"uint16";case ye.onnx.TensorProto.DataType.INT32:return"int32";case ye.onnx.TensorProto.DataType.UINT32:return"uint32";case ye.onnx.TensorProto.DataType.FLOAT:return"float32";case ye.onnx.TensorProto.DataType.DOUBLE:return"float64";case ye.onnx.TensorProto.DataType.STRING:return"string";case ye.onnx.TensorProto.DataType.INT64:return"int32";case ye.onnx.TensorProto.DataType.UINT64:return"uint32";default:throw new Error(`unsupported data type: ${ye.onnx.TensorProto.DataType[t]}`)}}static tensorDataTypeStringToEnum(t){switch(t){case"int8":return ye.onnx.TensorProto.DataType.INT8;case"uint8":return ye.onnx.TensorProto.DataType.UINT8;case"bool":return ye.onnx.TensorProto.DataType.BOOL;case"int16":return ye.onnx.TensorProto.DataType.INT16;case"uint16":return ye.onnx.TensorProto.DataType.UINT16;case"int32":return ye.onnx.TensorProto.DataType.INT32;case"uint32":return ye.onnx.TensorProto.DataType.UINT32;case"float32":return ye.onnx.TensorProto.DataType.FLOAT;case"float64":return ye.onnx.TensorProto.DataType.DOUBLE;case"string":return ye.onnx.TensorProto.DataType.STRING;case"int64":return ye.onnx.TensorProto.DataType.INT64;case"uint64":return ye.onnx.TensorProto.DataType.UINT64;default:throw new Error(`unsupported data type: ${t}`)}}static tensorDimsFromProto(t){return t.map(o=>zt.isLong(o)?o.toNumber():o)}static tensorValueTypeFromProto(t){return{tensorType:a.tensorDataTypeFromProto(t.elemType),shape:{dims:a.tensorDimsFromProto(t.shape.dim.map(o=>o.dimValue))}}}static tensorDimsFromORTFormat(t){let o=[];for(let e=0;e<t.dimsLength();e++)o.push(nt.longToNumber(t.dims(e)));return o}static tensorAttributesFromORTFormat(t){let o=[];for(let e=0;e<t.attributesLength();e++)o.push(t.attributes(e));return o}},nt=class{static longToNumber(t,o){return zt.isLong(t)?t.toNumber():t instanceof _.Long?zt.fromValue({low:t.low,high:t.high,unsigned:o??!1}).toNumber():t}static isLong(t){return zt.isLong(t)||t instanceof _.Long}},U=class a{static size(t){return a.getSizeFromDimensionRange(t,0,t.length)}static sizeFromDimension(t,o){if(o<0||o>t.length)throw new Error(`invalid dimension of ${o} for sizeFromDimension as Tensor has ${t.length} dimensions.`);return a.getSizeFromDimensionRange(t,o,t.length)}static sizeToDimension(t,o){if(o<0||o>t.length)throw new Error(`invalid dimension of ${o} for sizeToDimension as Tensor has ${t.length} dimensions.`);return a.getSizeFromDimensionRange(t,0,o)}static getSizeFromDimensionRange(t,o,e){let r=1;for(let n=o;n<e;n++){if(t[n]<=0)throw new Error("cannot get valid size from specified dimension range. Most likely the range contains 0 or negative values in them.");r*=t[n]}return r}static computeStrides(t){let o=t.length;if(o===0)return[];if(o===1)return[1];let e=new Array(o);e[o-1]=1,e[o-2]=t[o-1];for(let r=o-3;r>=0;--r)e[r]=e[r+1]*t[r+1];return e}static transpose(t){return t.slice().reverse()}static indicesToOffset(t,o,e){e===void 0&&(e=t.length);let r=0;for(let n=0;n<e;++n)r+=o[n]*t[n];return r}static offsetToIndices(t,o){let e=o.length;if(e===0)return[];if(e===1)return[t*o[0]];let r=new Array(o.length);for(let n=0;n<r.length-1;++n)r[n]=Math.floor(t/o[n]),t-=r[n]*o[n];return r[r.length-1]=t,r}static normalizeAxis(t,o){if(t<-o&&t>=o)throw new Error("unsupported axis for this operation.");return t<0?t+o:t}static normalizeAxes(t,o){return t.map(e=>this.normalizeAxis(e,o))}static incrementIndex(t,o,e){if(o.length===0||t.length===0)throw new Error("Index incrementing unsupported for scalar Tensor");if(e===void 0)e=o.length;else if(e<=0||e>o.length)throw new Error("Incorrect axis to increment on");for(let r=e-1;r>=0&&(t[r]++,!(t[r]<o[r]));--r)t[r]=0}static calculateReshapedDims(t,o){if(o.length===0){if(t.length===0||a.size(t)===1)return[];throw new Error("cannot reshape to a scalar Tensor")}let e=o.length,r=new Array(e),n=-1,s=1;for(let u=0;u<e;u++){if(o[u]<-1)throw new Error("a dimension in shape hints cannot be less than -1");if(o[u]===-1){if(n!==-1)throw new Error("at most one dimension in shape hints can be -1");n=u}else{if(o[u]===0){if(u>=t.length)throw new Error("the dimension with value zero exceeds the dimension size of the input tensor");r[u]=t[u]}else r[u]=o[u];s*=r[u]}}let i=a.size(t);if(n!==-1){if(i%s!==0)throw new Error(`the input tensor cannot be reshaped to the requested shape. Input shape: [${t}] Output shape: [${o}]`);r[n]=i/s}else if(s!==i)throw new Error("reshapedDims and originalDims don't have matching sizes");return r}static sortBasedOnPerm(t,o){return o?o.map(e=>t[e]):t.slice().reverse()}static padShape(t,o){let e=t.length;return t.map((r,n)=>r+o[n]+o[n+e])}static areEqual(t,o){return t.length!==o.length?!1:t.every((e,r)=>e===o[r])}static validateDimsAndCalcSize(t){if(t.length>6)throw new TypeError("Only rank 0 to 6 is supported for tensor shape.");let o=1;for(let e of t){if(!Number.isInteger(e))throw new TypeError(`Invalid shape: ${e} is not an integer`);if(e<0||e>2147483647)throw new TypeError(`Invalid shape: length ${e} is not allowed`);o*=e}return o}static flattenShape(t,o){o<0&&(o+=t.length);let e=t.reduce((s,i)=>s*i,1),r=t.slice(o).reduce((s,i)=>s*i,1);return[e/r,r]}static squeezeShape(t,o){let e=new Array;o=a.normalizeAxes(o,t.length);for(let r=0;r<t.length;r++){let n=o.indexOf(r)>=0;if(n&&t[r]!==1)throw new Error("squeeze an axis of size different than 1");(o.length===0&&t[r]>1||o.length>0&&!n)&&e.push(t[r])}return e}static unsqueezeShape(t,o){let e=new Array(t.length+o.length);e.fill(0);for(let n=0;n<o.length;n++){let s=a.normalizeAxis(o[n],e.length);if(s>=e.length)throw new Error("'axes' has an out of range axis");if(e[s]!==0)throw new Error("'axes' has a duplicate axis");e[s]=1}let r=0;for(let n=0;n<e.length;n++)e[n]===0&&(e[n]=t[r++]);if(r!==t.length)throw new Error("the unsqueezed dimension could not be established");return e}},an=class a{static splitShape(t,o,e,r){if(e.length===0){if(!r)throw new Error("need to know number of outputs when the 'split' attribute is not specified");a.determineSplit(t[o],r,e)}let n=[],s=[0];for(let i=0;i<e.length;++i){i!==0&&s.push(s[i-1]+e[i-1]);let u=t.slice();u[o]=e[i],n.push(u)}return[n,s]}static determineSplit(t,o,e){if(t%o!==0)throw new Error("cannot split tensor to equal sized parts");for(let r=0;r<o;++r)e.push(t/o)}},dr=class a{static adjustPoolAttributes(t,o,e,r,n,s){if(!t&&e.length!==o.length-2)throw new Error("length of specified kernel shapes should be 2 less than length of input dimensions");if(t)for(let i=0;i<o.length-2;i++)i>=e.length?e.push(o[i+2]):e[i]=o[i+2];for(let i=0;i<e.length;i++)if(i<r.length){if(r[i]<0)throw new Error("strides should be greater than or equal to 1")}else r.push(1);for(let i=0;i<e.length;i++)if(i<n.length){if(n[i]<0)throw new Error("dilations should be greater than or equal to 1")}else n.push(1);for(let i=0;i<e.length*2;i++)if(i<s.length){if(s[i]<0)throw new Error("pad should be greater than or equal to 1")}else s.push(0);for(let i=0;i<e.length;i++){if(e[i]<=0)throw new Error("kernel shapes need to be greater than 0");if(s[i]>=e[i]||s[i+e.length]>=e[i])throw new Error("pads should be smaller than kernel")}}static adjustPadsBasedOnAutoPad(t,o,e,r,n,s){if(s){if(n.length!==2*(t.length-2))throw new Error("length of pads should be twice the length of data dimensions");if(o.length!==t.length-2)throw new Error("length of strides should be the length of data dimensions");if(r.length!==t.length-2)throw new Error("length of kernel shapes should be the length of data dimensions");for(let i=0;i<t.length-2;i++)a.adjustPadAndReturnShape(t[i+2],o[i],e[i],r[i],n,i,i+t.length-2,s)}}static computePoolOutputShape(t,o,e,r,n,s,i){if(o.length<=0)throw new Error("input shape must be of size greater than 0");let u=[o[0],o[1]];return a.computeShapeHelper(t,o,u,e,r,n,s,i),u}static computeConvOutputShape(t,o,e,r,n,s,i){if(t.length<=0||o.length<=0)throw new Error("invalid input tensor dims or invalid filter tensor dims");let u=[t[0],o[0]];return a.computeShapeHelper(!1,t,u,e,r,n,s,i),u}static computeShapeHelper(t,o,e,r,n,s,i,u){if(t)for(let l=0;l<o.length-2;l++)e.push(1);else for(let l=0;l<o.length-2;l++)e.push(a.adjustPadAndReturnShape(o[l+2],r[l],n[l],s[l],i,l,l+o.length-2,u))}static adjustPadAndReturnShape(t,o,e,r,n,s,i,u){let l=e*(r-1)+1;if(u&&u!=="NOTSET")switch(u){case"VALID":return n[s]=0,n[i]=0,Math.floor((t-l)/o+1);case"SAME_LOWER":case"SAME_UPPER":if(e!==1)throw new Error("Dilation not supported for SAME_UPPER or SAME_LOWER");{let p=((t+o-1)/o-1)*o+r-t;return n[s]=Math.floor(u==="SAME_LOWER"?(p+1)/2:p/2),n[i]=p-n[s],Math.floor((t+p-r)/o+1)}default:throw new Error("Unsupported AutoPad type")}else return Math.floor((t+n[s]+n[i]-l)/o+1)}},hr=-34028234663852886e22,mr=34028234663852886e22});function Vd(a){switch(a){case"bool":case"int8":case"uint8":return 1;case"int16":case"uint16":return 2;case"int32":case"uint32":case"float32":return 4;case"float64":return 8;default:throw new Error(`cannot calculate sizeof() on type ${a}`)}}function Cu(a){switch(a){case te.onnx.TensorProto.DataType.UINT8:case te.onnx.TensorProto.DataType.INT8:case te.onnx.TensorProto.DataType.BOOL:return 1;case te.onnx.TensorProto.DataType.UINT16:case te.onnx.TensorProto.DataType.INT16:return 2;case te.onnx.TensorProto.DataType.FLOAT:case te.onnx.TensorProto.DataType.INT32:case te.onnx.TensorProto.DataType.UINT32:return 4;case te.onnx.TensorProto.DataType.INT64:case te.onnx.TensorProto.DataType.DOUBLE:case te.onnx.TensorProto.DataType.UINT64:return 8;default:throw new Error(`cannot calculate sizeof() on type ${te.onnx.TensorProto.DataType[a]}`)}}function Wd(a,t){return new(Nu(t))(a)}function Nu(a){switch(a){case"bool":case"uint8":return Uint8Array;case"int8":return Int8Array;case"int16":return Int16Array;case"uint16":return Uint16Array;case"int32":return Int32Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"float32":return Float32Array;case"float64":return Float64Array;default:throw new Error("unspecified error")}}function gi(a,t){if(t===te.onnx.TensorProto.DataType.INT64||t===bi.TensorDataType.INT64){if(a.greaterThanOrEqual(2147483648)||a.lessThan(-2147483648))throw new TypeError("int64 is not supported")}else if(t===te.onnx.TensorProto.DataType.UINT32||t===bi.TensorDataType.UINT32||t===te.onnx.TensorProto.DataType.UINT64||t===bi.TensorDataType.UINT64){if(a.greaterThanOrEqual(4294967296)||a.lessThan(0))throw new TypeError("uint64 is not supported")}else throw new TypeError(`not a LONG type: ${te.onnx.TensorProto.DataType[t]}`);return a.toNumber()}function ku(a,t,o){switch(t){case te.onnx.TensorProto.DataType.BOOL:case te.onnx.TensorProto.DataType.UINT8:return a.getUint8(o);case te.onnx.TensorProto.DataType.INT8:return a.getInt8(o);case te.onnx.TensorProto.DataType.UINT16:return a.getUint16(o,!0);case te.onnx.TensorProto.DataType.INT16:return a.getInt16(o,!0);case te.onnx.TensorProto.DataType.FLOAT:return a.getFloat32(o,!0);case te.onnx.TensorProto.DataType.INT32:return a.getInt32(o,!0);case te.onnx.TensorProto.DataType.UINT32:return a.getUint32(o,!0);case te.onnx.TensorProto.DataType.INT64:return gi(zt.fromBits(a.getUint32(o,!0),a.getUint32(o+4,!0),!1),t);case te.onnx.TensorProto.DataType.DOUBLE:return a.getFloat64(o,!0);case te.onnx.TensorProto.DataType.UINT64:return gi(zt.fromBits(a.getUint32(o,!0),a.getUint32(o+4,!0),!0),t);default:throw new Error(`cannot read from DataView for type ${te.onnx.TensorProto.DataType[t]}`)}}var Bu,te,bi,Fe,br=L(()=>{"use strict";Bu=Er(Is());ti();tn();te=Er($r());fe();bi=W.experimental.fbs,Fe=class a{constructor(t,o,e,r,n,s=Bu.Guid.create()){this.dims=t;this.type=o;this.dataProvider=e;this.asyncDataProvider=r;this.cache=n;this.dataId=s;this.size=U.validateDimsAndCalcSize(t);let i=this.size,u=e===void 0&&r===void 0&&n===void 0;if(n!==void 0&&n.length!==i)throw new RangeError("Input dims doesn't match data length.");if(o==="string"){if(n!==void 0&&(!Array.isArray(n)||!n.every(l=>typeof l=="string")))throw new TypeError("cache should be a string array");u&&(this.cache=new Array(i))}else{if(n!==void 0){let l=Nu(o);if(!(n instanceof l))throw new TypeError(`cache should be type ${l.name}`)}if(u){let l=new ArrayBuffer(i*Vd(o));this.cache=Wd(l,o)}}}get data(){if(this.cache===void 0){let t=this.dataProvider(this.dataId);if(t.length!==this.size)throw new Error("Length of data provided by the Data Provider is inconsistent with the dims of this Tensor.");this.cache=t}return this.cache}get stringData(){if(this.type!=="string")throw new TypeError("data type is not string");return this.data}get integerData(){switch(this.type){case"uint8":case"int8":case"uint16":case"int16":case"int32":case"uint32":case"bool":return this.data;default:throw new TypeError("data type is not integer (uint8, int8, uint16, int16, int32, uint32, bool)")}}get floatData(){switch(this.type){case"float32":case"float64":return this.data;default:throw new TypeError("data type is not float (float32, float64)")}}get numberData(){if(this.type!=="string")return this.data;throw new TypeError("type cannot be non-number (string)")}get(t){return this.data[U.indicesToOffset(t,this.strides)]}set(t,o){this.data[U.indicesToOffset(t,this.strides)]=o}async getData(){return this.cache===void 0&&(this.cache=await this.asyncDataProvider(this.dataId)),this.cache}get strides(){return this._strides||(this._strides=U.computeStrides(this.dims)),this._strides}static fromProto(t){if(!t)throw new Error("cannot construct Value from an empty tensor");let o=Ve.tensorDataTypeFromProto(t.dataType),e=Ve.tensorDimsFromProto(t.dims),r=new a(e,o);if(o==="string")t.stringData.forEach((n,s)=>{r.data[s]=sn(n)});else if(t.rawData&&typeof t.rawData.byteLength=="number"&&t.rawData.byteLength>0){let n=r.data,s=new DataView(t.rawData.buffer,t.rawData.byteOffset,t.rawData.byteLength),i=Cu(t.dataType),u=t.rawData.byteLength/i;if(t.rawData.byteLength%i!==0)throw new Error("invalid buffer length");if(n.length!==u)throw new Error("buffer length mismatch");for(let l=0;l<u;l++){let f=ku(s,t.dataType,l*i);n[l]=f}}else{let n;switch(t.dataType){case te.onnx.TensorProto.DataType.FLOAT:n=t.floatData;break;case te.onnx.TensorProto.DataType.INT32:case te.onnx.TensorProto.DataType.INT16:case te.onnx.TensorProto.DataType.UINT16:case te.onnx.TensorProto.DataType.INT8:case te.onnx.TensorProto.DataType.UINT8:case te.onnx.TensorProto.DataType.BOOL:n=t.int32Data;break;case te.onnx.TensorProto.DataType.INT64:n=t.int64Data;break;case te.onnx.TensorProto.DataType.DOUBLE:n=t.doubleData;break;case te.onnx.TensorProto.DataType.UINT32:case te.onnx.TensorProto.DataType.UINT64:n=t.uint64Data;break;default:throw new Error("unspecific error")}if(n==null)throw new Error("failed to populate data from a tensorproto value");let s=r.data;if(s.length!==n.length)throw new Error("array length mismatch");for(let i=0;i<n.length;i++){let u=n[i];zt.isLong(u)?s[i]=gi(u,t.dataType):s[i]=u}}return r}static fromData(t,o,e){return new a(o,e,void 0,void 0,t)}static fromOrtTensor(t){if(!t)throw new Error("cannot construct Value from an empty tensor");let o=Ve.tensorDimsFromORTFormat(t),e=Ve.tensorDataTypeFromProto(t.dataType()),r=new a(o,e);if(e==="string")for(let n=0;n<t.stringDataLength();n++)r.data[n]=t.stringData(n);else if(t.rawDataArray()&&typeof t.rawDataLength()=="number"&&t.rawDataLength()>0){let n=r.data,s=new DataView(t.rawDataArray().buffer,t.rawDataArray().byteOffset,t.rawDataLength()),i=Cu(t.dataType()),u=t.rawDataLength()/i;if(t.rawDataLength()%i!==0)throw new Error("invalid buffer length");if(n.length!==u)throw new Error("buffer length mismatch");for(let l=0;l<u;l++){let f=ku(s,t.dataType(),l*i);n[l]=f}}return r}}});function q(a){return a===1?Hd:qd}function Ru(a){let t=q(a);return`${t.version}
      precision highp float;
      ${t.attribute} vec3 position;
      ${t.attribute} vec2 textureCoord;

      ${t.varyingVertex} vec2 TexCoords;

      void main()
      {
          gl_Position = vec4(position, 1.0);
          TexCoords = textureCoord;
      }`}function Mu(a){let t=q(a);return`${t.version}
    precision highp float;
    precision highp int;
    precision highp sampler2D;
    ${t.varyingFrag} vec2 TexCoords;
    ${t.outputDeclaration}
    const vec2 halfCR = vec2(0.5, 0.5);

    // Custom vector types to handle higher dimenalities.
    struct ivec5
    {
      int x;
      int y;
      int z;
      int w;
      int u;
    };

    struct ivec6
    {
      int x;
      int y;
      int z;
      int w;
      int u;
      int v;
    };

    int imod(int x, int y) {
      return x - y * (x / y);
    }

    `}function Gu(a,t){let o=q(a);return`
  void main() {
    int indices[${t}];
    toVec(TexCoords, indices);
    vec4 result = vec4(process(indices));
    ${o.output} = result;
  }
  `}var Hd,qd,xe=L(()=>{"use strict";Hd={version:"",attribute:"attribute",varyingVertex:"varying",varyingFrag:"varying",texture2D:"texture2D",output:"gl_FragColor",outputDeclaration:""},qd={version:"#version 300 es",attribute:"in",varyingVertex:"out",varyingFrag:"in",texture2D:"texture",output:"outputColor",outputDeclaration:"out vec4 outputColor;"}});var ae=L(()=>{"use strict"});async function yi(a,t=e=>0,o){return new Promise((e,r)=>{let n=0,s=()=>{if(a()){e();return}n++;let i=t(n);if(o!=null&&n>=o){r();return}setTimeout(s,i)};s()})}function Kn(a){return Cr(typeof a<"u"&&a.length!==0,()=>"empty string found for sampler name"),"get"+a.charAt(0).toUpperCase()+a.slice(1)}function Uu(a){return Cr(typeof a<"u"&&a.length!==0,()=>"empty string found for sampler name"),"get"+a.charAt(0).toUpperCase()+a.slice(1)+"AtOutCoords"}function kr(a,t){let o=JSON.parse(JSON.stringify(a));return o=t,o}function Br(a,t){return t.map(o=>a[o]).join(", ")}function Ke(a){if(a<=1)return"int";if(a===2)return"ivec2";if(a===3)return"ivec3";if(a===4)return"ivec4";if(a===5)return"ivec5";if(a===6)return"ivec6";throw Error(`GPU for rank ${a} is not yet supported`)}function St(a=6){return["x","y","z","w","u","v"].slice(0,a)}var Ft=L(()=>{"use strict";fe()});function jd(a,t){return St(t).map(o=>`${a}.${o}`)}function Nr(a,t){return t===1?[a]:jd(a,t)}function $t(){return`
    float getChannel(vec4 frag, int dim) {
      int modCoord = imod(dim, 2);
      return modCoord == 0 ? frag.r : frag.g;
    }

    float getChannel(vec4 frag, vec2 innerDims) {
      vec2 modCoord = mod(innerDims, 2.);
      return modCoord.x == 0. ?
        (modCoord.y == 0. ? frag.r : frag.g) :
        (modCoord.y == 0. ? frag.b : frag.a);
    }
  `}var gr=L(()=>{"use strict";Ft()});function Xd(a,t,o){if(a===0)return"false";if(a===1)return`rc > ${t[0]}`;let e="";for(let r=a-2;r<a;r++)e+=`${o[r]} >= ${t[r-a+2]}`,r<a-1&&(e+="||");return e}function Kd(a,t){let o=a.length;if(o===0)return"getA(), 0, 0, 0";if(o===1)return`getA(rc),
            rc + 1 >= ${a[0]} ? 0. : getA(rc + 1),
            0, 0`;let e="r, c",r="r, cp1",n="rp1, c",s="rp1, cp1",i="";if(o>2)for(let u=0;u<o-2;++u)i=i+`${t[u]},`;return`getA(${i}${e}),
          rEdge ? 0. : getA(${i}${n}),
          cEdge ? 0. : getA(${i}${r}),
          rEdge || cEdge ? 0. : getA(${i}${s})`}function Jd(a,t,o,e){return a===0||a===1?"":`
    int r = ${t[a-2]};
    int c = ${t[a-1]};
    int rp1 = ${t[a-2]} + 1;
    int cp1 = ${t[a-1]} + 1;
    bool rEdge = rp1 >= ${e};
    bool cEdge = cp1 >= ${o};
    `}var zu,Yd,Vu,Wu=L(()=>{"use strict";xe();ae();Ft();gr();zu={name:"pack",inputNames:["A"],inputTypes:[1]},Yd=(a,t)=>{let o=q(a.session.backend.glContext.version),e=t.dims,r=e.length,n=t.dims.length,s=Ke(n),i=Nr("rc",n),u=Jd(n,i,e[e.length-2],e[e.length-1]),l;r===0?l=[1,1]:r===1?l=[e[0],1]:l=[e[n-1],e[n-2]];let f=Xd(n,l,i),p=Kd(e,i),d=`
        void main() {
          ${s} rc = getOutputCoords();

          if(${f}) {
            ${o.output} = vec4(0);
          } else {
            ${u}

            ${o.output} = vec4(${p});
          }
        }
      `;return{...zu,hasMain:!0,output:{dims:t.dims,type:t.type,textureType:2},shaderSource:d}},Vu=(a,t)=>({...zu,get:()=>Yd(a,t)})});function Ti(a){if(a.length===0)return[1,1,1];let t=1;for(let o=0;o<a.length-2;++o)t*=a[o];return[t,a.length>1?a[a.length-2]:1,a[a.length-1]]}function qu(a,t){let o=!1;return a.length===0||t.length===0?o=!0:a.length<2||t.length<2?o=a[a.length-1]===t[t.length-1]:o=a[a.length-1]===t[t.length-1]&&a[a.length-2]===t[t.length-2],o}function eh(a){let t=U.computeStrides(a),o=["b","r","c"],e="index";return`
    ivec3 inputCoordsFromReshapedOutCoords(int index) {
      ${t.map((n,s)=>{let i=`int ${o[s]} = ${e} / ${n}`,u=s===t.length-1?`int ${o[s+1]} = ${e} - ${o[s]} * ${n}`:`index -= ${o[s]} * ${n}`;return`${i}; ${u};`}).join("")}
      return ivec3(b, r, c);
    }
  `}function th(a){let t=U.computeStrides(a);return`
  int getFlattenedIndex(ivec3 coords) {
    // reverse y, z order
    return coords.x * ${t[0]} + coords.z * ${t[1]} + coords.y;
  }
`}var Zd,Qd,Hu,ju=L(()=>{"use strict";fe();xe();ae();gr();Zd=a=>({name:"Reshape (packed)",inputTypes:[2],inputNames:["A"],cacheHint:`${a}`}),Qd=(a,t,o,e)=>{let r=t.dims,n=e,s="";for(let l=0;l<4;l++){let f="";switch(l){case 0:f="outputCoords = rc;";break;case 1:f="outputCoords = ivec3(rc.x, rc.y+1, rc.z);";break;case 2:f="outputCoords = ivec3(rc.x, rc.y, rc.z+1);";break;case 3:f="outputCoords = ivec3(rc.x, rc.y+1, rc.z+1);";break;default:throw new Error}s+=`
        ${f}
        ${l>0?"if(outputCoords.y < rows && outputCoords.z < cols){":""}
          int flattenedIndex = getFlattenedIndex(outputCoords);

          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flattenedIndex);
          vec2 innerDims = vec2(float(inputRC.y),float(inputRC.z));

          result[${l}] = getChannel(getA(inputRC.x, inputRC.y, inputRC.z), innerDims);

        ${l>0?"}":""}
      `}let i=q(a.session.backend.glContext.version),u=`
      ${eh(r)}
      ${th(n)}
      ${$t()}

      void main() {
        ivec3 rc = getOutputCoords();

        vec4 result = vec4(0.0);

        ivec3 outputCoords;
        int rows = ${n[2]};
        int cols = ${n[1]};

        ${s}
        ${i.output} = result;
      }
    `;return{...o,output:{dims:n,type:t.type,textureType:2},shaderSource:u,hasMain:!0}},Hu=(a,t,o)=>{let e=Zd(o);return{...e,get:()=>Qd(a,t,e,o)}}});var xi,Yu=L(()=>{"use strict";xe();ae();xi=(a,t)=>{let o=t.shape,e=q(a.session.backend.glContext.version),r=`
    const float FLOAT_MAX = 1.70141184e38;
    const float FLOAT_MIN = 1.17549435e-38;

    bool isNaN(float val) {
      return (val < 1.0 || 0.0 < val || val == 0.0) ? false : true;
    }

    highp vec4 encodeAsUint8(highp float v) {
      if (isNaN(v)) {
        return vec4(255, 255, 255, 255);
      }

      highp float av = abs(v);

      if(av < FLOAT_MIN) {
        return vec4(0.0, 0.0, 0.0, 0.0);
      } else if(v > FLOAT_MAX) {
        return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;
      } else if(v < -FLOAT_MAX) {
        return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;
      }

      highp vec4 c = vec4(0,0,0,0);

      highp float e = floor(log2(av));
      highp float m = exp2(fract(log2(av))) - 1.0;

      c[2] = floor(128.0 * m);
      m -= c[2] / 128.0;
      c[1] = floor(32768.0 * m);
      m -= c[1] / 32768.0;
      c[0] = floor(8388608.0 * m);

      highp float ebias = e + 127.0;
      c[3] = floor(ebias / 2.0);
      ebias -= c[3] * 2.0;
      c[2] += floor(ebias) * 128.0;

      c[3] += 128.0 * step(0.0, -v);

      return c / 255.0;
    }

    void main() {
      float value = ${e.texture2D}(X,TexCoords).r;
      ${e.output} = encodeAsUint8(value);
    }`,n={name:"Uint8Encode",inputTypes:[0],inputNames:["X"],output:{dims:o,type:t.tensor.type,textureType:3},shaderSource:r,hasMain:!0};return a.executeProgram(n,[t.tensor])}});function nh(a,t){if(a===1)return"rc";let o="";for(let e=0;e<a;e++)o+=t[e],e<a-1&&(o+=",");return o}var Xu,rh,Ku,Ju=L(()=>{"use strict";xe();ae();Ft();gr();Xu={name:"unpack",inputNames:["A"],inputTypes:[2]},rh=(a,t)=>{let o=t.dims.length,e=Nr("rc",o),r=e.slice(-2),n=Ke(o),s=$t(),u=t.dims.length===0?"":nh(o,e),l=o<=1?"rc":`vec2(${r.join(",")})`,f=q(a.session.backend.glContext.version),p=`
    ${s}
    void main() {
      ${n} rc = getOutputCoords();

       // Sample the texture with the coords to get the rgba channel value.
       vec4 packedInput = getA(${u});

       ${f.output} = vec4(getChannel(packedInput, ${l}), 0, 0, 0);
     }
   `;return{...Xu,hasMain:!0,output:{dims:t.dims,type:t.type,textureType:0},shaderSource:p}},Ku=(a,t)=>({...Xu,get:()=>rh(a,t)})});var Jn,un,Zn,ln=L(()=>{"use strict";ut();Jn=class{constructor(t,o=1){if(o===1)this.internalFormat=t.R32F,this.format=t.RED,this.textureType=t.FLOAT,this.channelSize=o;else if(o===4)this.internalFormat=t.RGBA32F,this.format=t.RGBA,this.textureType=t.FLOAT,this.channelSize=o;else throw new Error(`Invalid number of channels: ${o}`)}encode(t,o){let e,r;return t.constructor!==Float32Array&&(ce.warning("Encoder","data was not of type Float32; creating new Float32Array"),r=new Float32Array(t)),o*this.channelSize>t.length?(ce.warning("Encoder","Source data too small. Allocating larger array"),r=t,e=this.allocate(o*this.channelSize),r.forEach((n,s)=>e[s]=n)):(r=t,e=r),e}allocate(t){return new Float32Array(t*4)}decode(t,o){return this.channelSize===1?t.filter((r,n)=>n%4===0).subarray(0,o):t.subarray(0,o)}},un=class{constructor(t,o=1,e){if(o!==1&&o!==4)throw new Error(`Invalid number of channels: ${o}`);this.internalFormat=t.RGBA,this.format=t.RGBA,this.channelSize=o,this.textureType=e||t.FLOAT}encode(t,o){let e=t;return this.channelSize===1&&(ce.verbose("Encoder","Exploding into a larger array"),e=this.allocate(o),t.forEach((r,n)=>e[n*4]=r)),e}allocate(t){return new Float32Array(t*4)}decode(t,o){return this.channelSize===1?t.filter((r,n)=>n%4===0).subarray(0,o):t.subarray(0,o)}},Zn=class{constructor(t,o=1){this.channelSize=4;if(o===1)this.internalFormat=t.ALPHA,this.format=t.ALPHA,this.textureType=t.UNSIGNED_BYTE,this.channelSize=o;else if(o===4)this.internalFormat=t.RGBA,this.format=t.RGBA,this.textureType=t.UNSIGNED_BYTE,this.channelSize=o;else throw new Error(`Invalid number of channels: ${o}`)}encode(t,o){return new Uint8Array(t.buffer,t.byteOffset,t.byteLength)}allocate(t){return new Uint8Array(t*this.channelSize)}decode(t,o){if(t instanceof Uint8Array)return t.subarray(0,o);throw new Error(`Invalid array type: ${t.constructor}`)}}});var fn,Zu,vi,Qu=L(()=>{"use strict";fe();ae();fn=(a,t,o)=>{let e=o===0||o===1?1:4,r=o===2,n=o===1||o===2,s=o===4?t.length-1:void 0,i=o===4?t.map((u,l)=>l===t.length-1?u*4:u):void 0;return vi(a,t,e,i,{isPacked:r,reverseWH:n,breakAxis:s})},Zu=(a,t,o)=>{let e=fn(a,t,o);return[e.width,e.height]},vi=(a,t,o=1,e,r)=>{let n=!!(r&&r.isPacked),[s,i]=a.computeTextureWH(n&&e||t,r),u=t.length,l=t.slice(0);if(u===0&&(l=[1]),o===1)e=t;else if(n){if(o!==4)throw new Error("a packed texture must be 4-channel");e=t,u>0&&(l[u-1]=Math.ceil(l[u-1]/2)),u>1&&(l[u-2]=Math.ceil(l[u-2]/2))}else if(!e)throw new Error("Unpacked shape is needed when using channels > 1");return{width:s,height:i,channels:o,isPacked:n,shape:l,strides:U.computeStrides(l),unpackedShape:e,reversedWH:r&&r.reverseWH}}});var ih,Qn,tl=L(()=>{"use strict";ut();br();fe();Wu();ju();Yu();Ju();ln();Qu();ae();ih=(a,t)=>{let o=t.map(r=>`${r.unpackedShape.join(",")};${r.width}x${r.height}`).join("_"),e=a.name;return a.cacheHint&&(e+="["+a.cacheHint+"]"),e+=":"+o,e},Qn=class{constructor(t){this.session=t;this.packedTextureDataCache=new Map,this.unpackedTextureDataCache=new Map}calculateTextureWidthAndHeight(t,o){return Zu(this.session.layoutStrategy,t,o)}executeProgram(t,o){if(o.length<t.inputNames.length)throw new Error(`Input size mustn't be less than ${t.inputNames.length}.`);if(t.inputNames.length!==t.inputTypes.length)throw new Error("input names size does not match input types");let e=[];for(let l=0;l<t.inputNames.length;++l)e[l]=this.getOrCreateTextureData(o[l],t.inputTypes[l]);let r=ih(t,e),n=this.session.programManager.getArtifact(r),s=n?n.programInfo:typeof t.get=="function"?t.get():t,i=fn(this.session.layoutStrategy,s.output.dims,s.output.textureType),u=this.createTextureData(i,s.output.type);return n||(n=this.session.programManager.build(s,e,u),this.session.programManager.setArtifact(r,n)),this.runProgram(n,e,u),u}run(t,o){return this.executeProgram(t,o).tensor}runProgram(t,o,e){for(let r=0;r<o.length;++r)if(!!o[r].isPacked!=(t.programInfo.inputTypes[r]===2))throw new Error(`input[${r}] property packed inconsistent`);if(!!e.isPacked!=(t.programInfo.output.textureType===2))throw new Error("output property packed inconsistent");this.session.programManager.run(t,o,e)}getOrCreateTextureData(t,o){let e=this.getTextureData(t.dataId,o===2);if(!e&&(e=this.getTextureData(t.dataId,o!==2),e))return o===2?this.pack(e):this.unpack(e);if(!e){let r=fn(this.session.layoutStrategy,t.dims,o);if(o===4){let i=t.dims;if(i.length===4){let u=[i[0],Math.ceil(i[1]*i[2]*i[3]/4)],l=fn(this.session.layoutStrategy,u,o),f=t.numberData;if(i[1]*i[2]*i[3]%4!==0){let p=i[0],d=i[1]*i[2]*i[3],T=Math.ceil(d*1/4)*4,O=p*T;f=new Float32Array(O);for(let v=0;v<p;++v){let S=v*d,E=v*T+v%1*d;f.set(t.numberData.subarray(S,S+d),E)}}return this.createTextureData(l,t.type,f,t,1)}}if(o===2){let n=vi(this.session.layoutStrategy,t.dims,1,[],{reverseWH:!0}),s=this.createTextureData(n,t.type,t.numberData,t,1);e=this.pack(s)}else e=this.createTextureData(r,t.type,t.numberData,t,1)}return e}createTextureDataFromLayoutBindTensor(t,o,e,r){return this.createTextureData(t,o,e,r,1)}createTextureData(t,o,e,r,n){ce.verbose("InferenceHandler",`Creating TextureData: layout:[${JSON.stringify(t)}]`);let s=this.session.textureManager.createTextureFromLayout(o,t,e,n);return this.createTextureDataFromTexture(t,o,s,r)}reshapeUnpacked(t,o){let e=this.getOrCreateTextureData(t,0),r={channels:e.channels,height:e.height,width:e.width,shape:o.length!==0?o:[1],strides:U.computeStrides(o),unpackedShape:o};return this.createTextureDataFromTexture(r,t.type,e.texture).tensor}reshapePacked(t,o){let e=this.getOrCreateTextureData(t,2);if(qu(t.dims,o)){let l={channels:e.channels,height:e.height,width:e.width,shape:o.length!==0?o:[1],strides:U.computeStrides(o),unpackedShape:o,isPacked:!0};return this.createTextureDataFromTexture(l,t.type,e.texture).tensor}let r=Ti(t.dims),n=Ti(o),s=this.reshapePacked(t,r),i=this.run(Hu(this,s,n),[s]);return this.reshapePacked(i,o)}cast(t,o){let e=this.getOrCreateTextureData(t,0);return this.createTextureDataFromTexture(e,o,e.texture).tensor}createTextureDataFromTexture(t,o,e,r,n){let s={...t,tensor:r||new Fe(t.unpackedShape,o,i=>this.readTexture(s),async i=>this.readTextureAsync(s),void 0,n),texture:e};return this.setTextureData(s.tensor.dataId,s,t.isPacked),s}getTextureData(t,o=!1){return this.session.isInitializer(t)?this.session.getTextureData(t,o):o?this.packedTextureDataCache.get(t):this.unpackedTextureDataCache.get(t)}setTextureData(t,o,e=!1){this.session.isInitializer(t)?this.session.setTextureData(t,o,e):(e?this.packedTextureDataCache:this.unpackedTextureDataCache).set(t,o)}isTextureLayoutCached(t,o=!1){return!!this.getTextureData(t.dataId,o)}dispose(){this.session.textureManager.clearActiveTextures(),this.packedTextureDataCache.forEach(t=>this.session.textureManager.releaseTexture(t)),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache.forEach(t=>this.session.textureManager.releaseTexture(t)),this.unpackedTextureDataCache=new Map}readTexture(t){return t.isPacked?this.readTexture(this.unpack(t)):this.session.backend.glContext.isFloat32DownloadSupported?this.session.textureManager.readTexture(t,t.tensor.type,t.channels):this.session.textureManager.readUint8TextureAsFloat(xi(this,t))}async readTextureAsync(t){return t.isPacked?this.readTextureAsync(this.unpack(t)):this.session.backend.glContext.isFloat32DownloadSupported?this.session.textureManager.readTextureAsync(t,t.tensor.type,t.channels):this.session.textureManager.readUint8TextureAsFloat(xi(this,t))}pack(t){return this.executeProgram(Vu(this,t.tensor),[t.tensor])}unpack(t){return this.executeProgram(Ku(this,t.tensor),[t.tensor])}}});var wi,ee,Ge=L(()=>{"use strict";wi=class{constructor(t){Object.assign(this,t)}get cacheKey(){return this.key||(this.key=Object.getOwnPropertyNames(this).sort().map(t=>`${this[t]}`).join(";")),this.key}},ee=a=>new wi(a)});var rl,nl,ol,ah,sh,il=L(()=>{"use strict";Ge();xe();ae();rl={name:"BatchNormalization",inputNames:["A","Scale","B","Mean","Variance"],inputTypes:[0,0,0,0,0]},nl=(a,t,o)=>(sh(t),[a.run({...rl,cacheHint:o.cacheKey,get:()=>ah(a,t,o)},t)]),ol=a=>{let t=a.attributes.getFloat("epsilon",1e-5),o=a.attributes.getFloat("momentum",.9),e=a.attributes.getInt("spatial",1);return ee({epsilon:t,momentum:o,spatial:e})},ah=(a,t,o)=>{let e=q(a.session.backend.glContext.version),r=t[0].dims.length,[n,s]=a.calculateTextureWidthAndHeight(t[1].dims,0),i=`
  float process(int[${r}] indices) {
    vec2 position = offsetToCoords(indices[1], ${n}, ${s});
    float scale = getColorAsFloat(${e.texture2D}(Scale, position));
    float mean = getColorAsFloat(${e.texture2D}(Mean, position));
    float variance = getColorAsFloat(${e.texture2D}(Variance, position));
    float b = getColorAsFloat(${e.texture2D}(B, position));

    return scale * ( (_A(indices) - mean) / sqrt(variance + float(${o.epsilon})) ) + b;
  }`;return{...rl,output:{dims:t[0].dims,type:t[0].type,textureType:0},shaderSource:i}},sh=a=>{if(!a||a.length!==5)throw new Error("BatchNormalization requires 5 inputs.");let t=a[0],o=a[1],e=a[2],r=a[3],n=a[4];if(t.dims.length<3||o.dims.length!==1||e.dims.length!==1||r.dims.length!==1||n.dims.length!==1)throw new Error("invalid input shape.");if(o.dims[0]!==t.dims[1]||e.dims[0]!==t.dims[1]||r.dims[0]!==t.dims[1]||n.dims[0]!==t.dims[1])throw new Error("invalid input shape.");if(t.type!=="float32"&&t.type!=="float64"||o.type!=="float32"&&o.type!=="float64"||e.type!=="float32"&&e.type!=="float64"||r.type!=="float32"&&r.type!=="float64"||n.type!=="float32"&&n.type!=="float64")throw new Error("invalid input tensor types.")}});var eo,pt,R,cn,to,Vt=L(()=>{"use strict";eo=class{constructor(t,o,e,r){this.glContext=t;this.programInfo=o;this.inputTextureLayouts=e;this.outputTextureLayout=r}},pt=class{constructor(t){this.context=t}},R=class{constructor(t,o){this.routineBody=t;this.dependencies=o}},cn=class{constructor(t,o,e){this.name=t;e?this.dependencies=e:this.dependencies=[],o&&(this.routineBody=o)}addDependency(t){t&&this.dependencies.push(t)}},to=class{static returnOrderedNodes(t){if(!t||t.length===0)return[];if(t.length===1)return t;let o=new Set,e=new Set,r=new Array;return this.createOrderedNodes(t,o,e,r),r}static createOrderedNodes(t,o,e,r){for(let n=0;n<t.length;++n)this.dfsTraverse(t[n],o,e,r)}static dfsTraverse(t,o,e,r){if(!t||e.has(t.name))return;if(o.has(t.name))throw new Error("Cyclic dependency detected. Can't topologically sort routines needed for shader.");o.add(t.name);let n=t.dependencies;if(n&&n.length>0)for(let s=0;s<n.length;++s)this.dfsTraverse(n[s],o,e,r);r.push(t),e.add(t.name),o.delete(t.name)}}});function lh(){let a="add_";return{body:`
  float ${a}(float a, float b) {
    return a + b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 + v2;
  }
  `,name:a,type:0}}function fh(){let a="div_";return{body:`
  float ${a}(float a, float b) {
    return a / b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 / v2;
  }
  `,name:a,type:0}}function ch(){let a="mul_";return{body:`
  float ${a}(float a, float b) {
    return a * b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 * v2;
  }
  `,name:a,type:0}}function ph(){let a="sub_";return{body:`
  float ${a}(float a, float b) {
    return a - b;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return v1 - v2;
  }
  `,name:a,type:0}}function dh(){let a="equal_";return{body:`
  float ${a}(float a, float b) {
    return float(a == b);
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4(equal(v1, v2));
  }
  `,name:a,type:0}}function hh(){let a="greater_";return{body:`
  float ${a}(float a, float b) {
    return float(a > b);
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4( v1.r > v2.r ,
      v1.g > v2.g,
      v1.b > v2.b,
      v1.a > v2.a );
  }
  `,name:a,type:0}}function mh(){let a="less_";return{body:`
  float ${a}(float a, float b) {
    return float(a < b);
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4( v1.r < v2.r ,
                v1.g < v2.g,
                v1.b < v2.b,
                v1.a < v2.a );
  }
  `,name:a,type:0}}function bh(){let a="and_";return{body:`
  float ${a}(float a, float b) {
    return float( bool(a) && bool(b) );
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r && b2.r ,
                b1.g && b2.g,
                b1.b && b2.b,
                b1.a && b2.a );
  }
  `,name:a,type:0}}function gh(){let a="or_";return{body:`
  float ${a}(float a, float b) {
    return float( bool(a) || bool(b) );
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r || b2.r ,
                b1.g || b2.g,
                b1.b || b2.b,
                b1.a || b2.a );
  }
  `,name:a,type:0}}function yh(){let a="xor_";return{body:`
  float ${a}(float a, float b) {
    return float( bool(a) ^^ bool(b) );
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r ^^ b2.r ,
                b1.g ^^ b2.g,
                b1.b ^^ b2.b,
                b1.a ^^ b2.a );
  }
  `,name:a,type:0}}function Th(){return vh("pow")}function xh(){let a="prelu_";return{body:`
  float ${a}(float a, float b) {
    return a < 0.0 ? a * b: a;
  }
  vec4 ${a}(vec4 v1, vec4 v2) {
    return vec4(
      v1.r < 0.0 ? v1.r * v2.r: v1.r,
      v1.g < 0.0 ? v1.g * v2.g: v1.g,
      v1.b < 0.0 ? v1.b * v2.b: v1.b,
      v1.a < 0.0 ? v1.a * v2.a: v1.a
      );
  }
  `,name:a,type:0}}function vh(a){let t=`${a}_`;return{body:`
  float ${t}(float a, float b) {
    return ${a}(a, b);
  }
  vec4 ${t}(vec4 v1, vec4 v2) {
    return ${a}(v1, v2);
  }
  `,name:t,type:0}}var dt,wh,al,sl,ul,ll,fl,cl,pl,dl,hl,ml,bl,gl,yl=L(()=>{"use strict";fe();Vt();xe();ae();dt=(a,t,o,e=t[0].type,r)=>{let n=a.session.pack?2:0;return{name:o.name,inputNames:["A","B"],inputTypes:[n,n],cacheHint:r,get:()=>wh(a,t,o,e)}},wh=(a,t,o,e=t[0].type)=>{let r=a.session.pack?2:0,n=!U.areEqual(t[0].dims,t[1].dims),s=t[0].dims,i=a.session.pack;if(n){let f=Xe.calcShape(t[0].dims,t[1].dims,!1);if(!f)throw new Error("Can't perform binary op on the given tensors");s=f;let p=s.length,d=t[0].dims.length!==0?t[0].dims.length:1,T=t[1].dims.length!==0?t[1].dims.length:1,O=t[0].dims.length!==0?"bcastIndices_A(indices, aindices);":"aindices[0] = 0;",v=t[1].dims.length!==0?"bcastIndices_B(indices, bindices);":"bindices[0] = 0;",S=q(a.session.backend.glContext.version),E=i?`
      ${o.body}
      void main() {
        vec4 a = getAAtOutCoords();
        vec4 b = getBAtOutCoords();
        vec4 result = ${o.name}(a, b);
        ${S.output} = result;
      }`:`
      ${o.body}
      float process(int indices[${p}]) {
        int aindices[${d}];
        int bindices[${T}];
        ${O}
        ${v}
        return ${o.name}(_A(aindices), _B(bindices));
      }`;return{name:o.name,inputNames:["A","B"],inputTypes:[r,r],output:{dims:s,type:e,textureType:r},shaderSource:E,hasMain:i}}let u=q(a.session.backend.glContext.version),l=`
    ${o.body}
    void main() {
      vec4 v1 = ${u.texture2D}(A, TexCoords);
      vec4 v2 = ${u.texture2D}(B, TexCoords);
      vec4 result = ${o.name}(v1, v2);
      ${u.output} = result;
    }
    `;return{name:o.name,inputNames:["A","B"],inputTypes:[r,r],output:{dims:t[0].dims,type:e,textureType:r},shaderSource:l,hasMain:!0}},al=(a,t)=>[a.run(dt(a,t,lh()),t)],sl=(a,t)=>[a.run(dt(a,t,bh(),"bool"),t)],ul=(a,t)=>[a.run(dt(a,t,fh()),t)],ll=(a,t)=>[a.run(dt(a,t,dh(),"bool"),t)],fl=(a,t)=>[a.run(dt(a,t,hh(),"bool"),t)],cl=(a,t)=>[a.run(dt(a,t,mh(),"bool"),t)],pl=(a,t)=>[a.run(dt(a,t,ch()),t)],dl=(a,t)=>[a.run(dt(a,t,gh(),"bool"),t)],hl=(a,t)=>[a.run(dt(a,t,Th()),t)],ml=(a,t)=>[a.run(dt(a,t,xh()),t)],bl=(a,t)=>[a.run(dt(a,t,ph()),t)],gl=(a,t)=>[a.run(dt(a,t,yh(),"bool"),t)]});var Tl,xl,Oh,vl=L(()=>{"use strict";fe();Tl=(a,t,o)=>(Oh(t),[a.cast(t[0],o)]),xl=a=>Ve.tensorDataTypeFromProto(a.attributes.getInt("to")),Oh=a=>{if(!a||a.length!==1)throw new Error("Cast requires 1 input.");if(a[0].type==="string")throw new Error("Invalid input type.")}});var Ih,Sh,wl,ro,_l=L(()=>{"use strict";xe();ae();Ft();gr();Ih=(a,t)=>({name:"Concat (packed)",inputNames:Array.from({length:a},(o,e)=>`X${e}`),inputTypes:Array(a).fill(2),cacheHint:t}),Sh=(a,t,o,e)=>{let r=o[0].dims.slice();if(e>=r.length||e<-1*r.length)throw new Error("axis specified for concat doesn't match input dimensionality");e<0&&(e=r.length+e);let n=r.slice(0);for(let j=1;j<o.length;j++){let M=o[j].dims.slice();for(let ie=0;ie<r.length;ie++)if(ie===e)n[e]+=M[ie];else if(r[ie]!==M[ie])throw new Error("non concat dimensions must match")}let s=n.length,i=Nr("coords",s),u=Ke(s),l=$t(),f=o.map(j=>j.dims),p=St(s),d=new Array(f.length-1);d[0]=f[0][e];for(let j=1;j<d.length;j++)d[j]=d[j-1]+f[j][e];let T=p[e],O=p.slice(-2),v=p.join(),S=`if (${T} < ${d[0]}) {
        return getChannel(
            getX0(${v}), vec2(${O.join()}));
        }`;for(let j=1;j<d.length;j++){let M=d[j-1];S+=`
            if (${T} < ${d[j]}  && ${T} >= ${d[j-1]}) {
              return getChannel(
                getX${j}(${ro(p,T,M)}),
                vec2(${ro(O,T,M)}));
            }`}let E=d.length,F=d[d.length-1];S+=`
            return getChannel(
              getX${E}(${ro(p,T,F)}),
              vec2(${ro(O,T,F)}));`;let B=q(a.session.backend.glContext.version),K=`
          ${l}
          float getValue(${p.map(j=>"int "+j)}) {
            ${S}
          }

          void main() {
            ${u} coords = getOutputCoords();
            int lastDim = coords.${p[s-1]};
            coords.${p[s-1]} = coords.${p[s-2]};
            coords.${p[s-2]} = lastDim;

            vec4 result = vec4(getValue(${i}), 0., 0., 0.);

            ${i[s-1]} = ${i[s-1]} + 1;
            if (${i[s-1]} < ${n[s-1]}) {
              result.g = getValue(${i});
            }

            ${i[s-2]} = ${i[s-2]} + 1;
            if (${i[s-2]} < ${n[s-2]}) {
              result.a = getValue(${i});
            }

            ${i[s-1]} = ${i[s-1]} - 1;
            if (${i[s-2]} < ${n[s-2]} &&
                ${i[s-1]} < ${n[s-1]}) {
              result.b = getValue(${i});
            }
            ${B.output} = result;
          }
        `;return{...t,output:{dims:n,type:o[0].type,textureType:2},shaderSource:K,hasMain:!0}},wl=(a,t,o)=>{let e=Ih(t.length,o.cacheKey);return{...e,get:()=>Sh(a,e,t,o.axis)}},ro=(a,t,o)=>{let e=a.indexOf(t);return a.map((n,s)=>s===e?`${n} - ${o}`:n).join()}});var Ol,Ah,Ph,Eh,Il,Dh,Lh,Fh,Sl,$h,Al=L(()=>{"use strict";Ge();ae();_l();Ol=(a,t,o)=>($h(t),a.session.pack&&t[0].dims.length>1?[a.run(wl(a,t,o),t)]:[a.run(Eh(a,t,o),t)]),Ah=(a,t)=>({name:"Concat",inputNames:Array.from({length:a},(o,e)=>`X${e}`),inputTypes:Array(a).fill(0),cacheHint:t}),Ph=(a,t,o,e)=>{let r=o[0].dims.slice();if(e>=r.length||e<-1*r.length)throw new Error("axis specified for concat doesn't match input dimensionality");e<0&&(e=r.length+e);let n=r.slice(0);for(let T=1;T<o.length;T++){let O=o[T].dims.slice();for(let v=0;v<r.length;v++)if(v===e)n[e]+=O[v];else if(r[v]!==O[v])throw new Error("non concat dimensions must match")}let s=n.length,i=new Array(o.length),u=0;for(let T=0;T<i.length;++T)u+=o[T].dims[e],i[T]=u;let l="";o.length<5?l=Il(i):l=Dh(i);let f=Lh(o.length,s),p=Fh(i),d=`
        ${f}
        ${p}
        ${l}
        float process(int indices[${s}]) {
          int textureIndex = getTextureWhereDataResides (indices[${e}]);

          if(textureIndex != 0) {
            indices[${e}] = indices[${e}] - int(getSizeInConcatAxisValueFromIndex(textureIndex-int(1)));
          }

          return fetchDataFromCorrectTexture(textureIndex, indices);
        }`;return{...t,output:{dims:n,type:o[0].type,textureType:0},shaderSource:d}},Eh=(a,t,o)=>{let e=Ah(t.length,o.cacheKey);return{...e,get:()=>Ph(a,e,t,o.axis)}},Il=a=>`int getTextureWhereDataResides(int index) {
      ${a.map((o,e)=>`if(index<${o}) {return ${e};}
`).join("")}
    }`,Dh=a=>Il(a),Lh=(a,t)=>{let o=[`float fetchDataFromCorrectTexture(int textureIndex, int indices[${t}]) {`];for(let e=0;e<a;++e)e===0?o.push(`	if (textureIndex == ${e}) { return _X${e}(indices); }`):e===a-1?o.push(`	else { return _X${e}(indices); }`):o.push(`	else if (textureIndex == ${e}) { return _X${e}(indices); }`);return o.push("	}"),o.join(`
`)},Fh=a=>{let t=["int getSizeInConcatAxisValueFromIndex(int index) {"];for(let o=0;o<a.length;++o)o===0?t.push(`	if (index == ${o}) { return ${a[o]}; }`):o===a.length-1?t.push(`	else { return ${a[o]}; }`):t.push(`	else if (index == ${o}) { return ${a[o]}; }`);return t.push("	}"),t.join(`
`)},Sl=a=>ee({axis:a.attributes.getInt("axis")}),$h=a=>{if(!a||a.length<1)throw new Error("too few inputs");let t=a[0].type,o=a[0].dims.length;if(t==="string")throw new Error("string tensor is not supported yet");for(let e of a){if(e.type!==t)throw new Error("input tensors should be one type");if(e.dims.length!==o)throw new Error("input tensors should have the same shape")}}});function Ch(){return ht("abs")}function kh(){return ht("acos")}function Bh(){return ht("asin")}function Nh(){return ht("atan")}function Rh(){return ht("ceil")}function Mh(){return ht("cos")}function Gh(a){let t="elu";return{body:`
  const float alpha = float(${a});

  float ${t}_(float a) {
    return a >= 0.0 ? a: (exp(a) - 1.0) * alpha;
  }
  vec4 ${t}_(vec4 v) {
    return vec4(${t}_(v.x), ${t}_(v.y), ${t}_(v.z), ${t}_(v.w));
  }
  `,name:t,type:0}}function Uh(){return ht("exp")}function zh(){return ht("floor")}function _i(a,t){let o="clip";return{body:`
  const float min = float(${a});
  const float max = float(${t});

  float ${o}_(float a) {
    return clamp(a, min, max);
  }
  vec4 ${o}_(vec4 v) {
    return clamp(v, min, max);
  }
  `,name:o,type:0}}function Vh(){let a="indentity";return{body:`
  float ${a}_(float a) {
    return a;
  }
  vec4 ${a}_(vec4 v) {
    return v;
  }
  `,name:a,type:0}}function Wh(a){let t="leakyRelu";return{body:`
  const float alpha = float(${a});

  float ${t}_(float a) {
    return a < 0.0 ? a * alpha : a;
  }
  vec4 ${t}_(vec4 v) {
    return vec4(${t}_(v.x), ${t}_(v.y), ${t}_(v.z), ${t}_(v.w));
  }
  `,name:t,type:0}}function Hh(){return ht("log")}function qh(){let a="neg";return{body:`
  float ${a}_(float a) {
    return -a;
  }
  vec4 ${a}_(vec4 v) {
    return -v;
  }
  `,name:a,type:0}}function jh(){let a="not";return{body:`
  float ${a}_(float a) {
    return float( ! bool(a) );
  }
  bool ${a}_(bool a) {
    return !a;
  }
  vec4 ${a}_(vec4 v) {
    return vec4(!bool(v.x), !bool(v.y), !bool(v.z), !bool(v.w));
  }
  bvec4 ${a}_(bvec4 v) {
    return bvec4(!v.x, !v.y, !v.z, !v.w);
  }
  `,name:a,type:0}}function Yh(){return ht("sin")}function Oi(){let a="relu";return{body:`
  float ${a}_(float a) {
    return max( a, 0.0 );
  }
  vec4 ${a}_(vec4 v) {
    return max( v, 0.0 );
  }
  `,name:a,type:0}}function Ii(){let a="sigmoid";return{body:`
  float ${a}_(float a) {
    return 1.0 / (1.0 + exp(-a));
  }
  vec4 ${a}_(vec4 v) {
    return 1.0 / (1.0 + exp(-v));
  }
  `,name:a,type:0}}function Xh(){return ht("sqrt")}function Kh(){return ht("tan")}function Jh(){let a="tanh";return{body:`
  float ${a}_(float a) {
    a = clamp(a, -10., 10.);
    a = exp(2.*a);
    return (a - 1.) / (a + 1.);
  }
  vec4 ${a}_(vec4 v) {
    v = clamp(v, -10., 10.);
    v = exp(2.*v);
    return (v - 1.) / (v + 1.);
  }
  `,name:a,type:0}}function ht(a){return{body:`
  float ${a}_(float a) {
    return ${a}(a);
  }
  vec4 ${a}_(vec4 v) {
    return ${a}(v);
  }
  `,name:a,type:0}}var Zh,Pe,Pl,El,Dl,Ll,Si,Fl,$l,Qh,Cl,kl,Bl,Nl,Rl,Ml,Ai,Gl,Ul,zl,Vl,Wl,Hl,ql,jl,Yl,Xl,Kl,Pi=L(()=>{"use strict";Ge();fe();Vt();xe();ae();Zh=(a,t,o,e)=>{let r=a.session.pack?2:0,n=q(a.session.backend.glContext.version);return{...t,output:{dims:o.dims,type:o.type,textureType:r},shaderSource:`
     ${e.body}
     void main() {
       vec4 v = ${n.texture2D}(A, TexCoords);
       v = ${e.name}_(v);
       ${n.output} = v;
     }
     `,hasMain:!0}},Pe=(a,t,o,e)=>{let r=a.session.pack?2:0,n={name:o.name,inputTypes:[r],inputNames:["A"],cacheHint:e};return{...n,get:()=>Zh(a,n,t,o)}},Pl=(a,t)=>[a.run(Pe(a,t[0],Ch()),t)],El=(a,t)=>[a.run(Pe(a,t[0],kh()),t)],Dl=(a,t)=>[a.run(Pe(a,t[0],Bh()),t)],Ll=(a,t)=>[a.run(Pe(a,t[0],Nh()),t)],Si=(a,t,o)=>[a.run(Pe(a,t[0],_i(o.min,o.max),o.cacheKey),t)],Fl=a=>ee({min:a.attributes.getFloat("min",hr),max:a.attributes.getFloat("max",mr)}),$l=(a,t)=>{let o=Qh(a,t);return Si(a,[t[0]],o)},Qh=(a,t)=>{if(t.length>=3&&(!a.session.isInitializer(t[1].dataId)||!a.session.isInitializer(t[2].dataId)))throw new Error("dynamic clip attributes are not allowed");let o=t.length>=3?t[1].numberData[0]:hr,e=t.length>=3?t[2].numberData[0]:mr;return ee({min:o,max:e})},Cl=(a,t)=>[a.run(Pe(a,t[0],Rh()),t)],kl=(a,t)=>[a.run(Pe(a,t[0],Mh()),t)],Bl=(a,t,o)=>[a.run(Pe(a,t[0],Gh(o.alpha),o.cacheKey),t)],Nl=a=>ee({alpha:a.attributes.getFloat("alpha",1)}),Rl=(a,t)=>[a.run(Pe(a,t[0],Uh()),t)],Ml=(a,t)=>[a.run(Pe(a,t[0],zh()),t)],Ai=(a,t)=>[a.run(Pe(a,t[0],Vh()),t)],Gl=(a,t,o)=>[a.run(Pe(a,t[0],Wh(o.alpha),o.cacheKey),t)],Ul=a=>ee({alpha:a.attributes.getFloat("alpha",.01)}),zl=(a,t)=>[a.run(Pe(a,t[0],Hh()),t)],Vl=(a,t)=>[a.run(Pe(a,t[0],qh()),t)],Wl=(a,t)=>[a.run(Pe(a,t[0],jh()),t)],Hl=(a,t)=>[a.run(Pe(a,t[0],Oi()),t)],ql=(a,t)=>[a.run(Pe(a,t[0],Ii()),t)],jl=(a,t)=>[a.run(Pe(a,t[0],Yh()),t)],Yl=(a,t)=>[a.run(Pe(a,t[0],Xh()),t)],Xl=(a,t)=>[a.run(Pe(a,t[0],Kh()),t)],Kl=(a,t)=>[a.run(Pe(a,t[0],Jh()),t)]});function Ct(a){let t;switch(a.activation){case"Relu":t=Oi();break;case"Sigmoid":t=Ii();break;case"Clip":t=_i(a.clipMin,a.clipMax);break;default:return{activationFunction:"",applyActivation:""}}let o=t.name,e=t.body,r=`value = ${o}_(value);`;return{activationFunction:e,applyActivation:r}}var Rr,yr=L(()=>{"use strict";fe();Pi();Rr=a=>{let t=a.getString("activation","");if(t==="Clip"){let[o,e]=a.getFloats("activation_params",[hr,mr]);return{activation:t,clipMax:e,clipMin:o,activationCacheKey:`${t}:${o},${e}`}}return{activation:t,activationCacheKey:t}}});var tm,rm,Jl,Zl=L(()=>{"use strict";ut();xe();ae();no();yr();tm=(a,t)=>({name:"GroupedConv",inputNames:a?["X","W","Bias"]:["X","W"],inputTypes:a?[0,0,0]:[0,0],cacheHint:t}),rm=(a,t,o,e)=>{let n=t.length>2?"value += getBias(output_channel);":"",s=t[0].dims.slice(),i=t[1].dims.slice(),u=i[0]/e.group;ce.verbose("GroupedConv",`autpPad:${e.autoPad}, dilations:${e.dilations}, group:${e.group}, kernelShape:${e.kernelShape}, pads:${e.pads}, strides:${e.strides}`);let l=Mr(s,i,e.dilations,e.pads,e.strides),f=q(a.session.backend.glContext.version),{activationFunction:p,applyActivation:d}=Ct(e),T=`
  const ivec2 strides = ivec2(${e.strides[0]}, ${e.strides[1]});
  const ivec2 pads = ivec2(${e.pads[0]}, ${e.pads[1]});
  ${p}
  void main() {
    ivec4 coords = getOutputCoords();
    int batch = coords.x;
    int output_channel = coords.y;
    ivec2 xRCCorner = coords.zw * strides - pads;
    int group_id = output_channel / ${u};

    float value = 0.0;
    for (int wInChannel = 0; wInChannel < ${i[1]}; wInChannel++) {
      int input_channel = group_id * ${i[1]} + wInChannel;
      for (int wHeight = 0; wHeight < ${i[2]}; wHeight++) {
        int xHeight = xRCCorner.x + wHeight * ${e.dilations[0]};

        if (xHeight < 0 || xHeight >= ${s[2]}) {
          continue;
        }

        for (int wWidth = 0; wWidth < ${i[3]}; wWidth++) {
          int xWidth = xRCCorner.y + wWidth * ${e.dilations[1]};
          if (xWidth < 0 || xWidth >= ${s[3]}) {
            continue;
          }

          float xVal = getX(batch, input_channel, xWidth, xHeight);
          float wVal = getW(output_channel, wInChannel, wWidth, wHeight);
          value += xVal*wVal;
        }
      }
    }
    ${n}
    ${d}
    ${f.output} = vec4(value, .0, .0, .0);
  }
`;return{...o,output:{dims:l,type:t[0].type,textureType:0},shaderSource:T,hasMain:!0}},Jl=(a,t,o)=>{let e=tm(t.length>2,o.cacheKey);return{...e,get:()=>rm(a,t,e,o)}}});var nm,om,Ql,ef=L(()=>{"use strict";xe();ae();gr();nm=a=>({name:"Im2Col (packed)",inputNames:["A"],inputTypes:[2],cacheHint:a}),om=(a,t,o,e,r,n)=>{let s=o.dims,i=e.dims,u=2,l=3,f=r.length,p=[i[1]*i[2]*i[3],r[2]*r[3]],d=i[2]*i[3],T=$t(),O=q(a.session.backend.glContext.version),v="";for(let E=0;E<=1;E++)for(let F=0;F<=1;F++)v+=`
            blockIndex = rc.x + ${F};
            pos = rc.y + ${E};

            if(blockIndex < ${p[1]} && pos < ${p[0]}) {
              offsetY = int(blockIndex / (${r[f-1]})) * ${n.strides[0]} -
                ${n.pads[0]};
              d0 = offsetY + ${n.dilations[0]} * (imod(pos, ${d}) / ${i[2]});

              if(d0 < ${s[u]} && d0 >= 0) {
                offsetX = imod(blockIndex, ${r[f-1]}) * ${n.strides[1]} -
                  ${n.pads[1]};
                d1 = offsetX + ${n.dilations[1]} * imod(imod(pos, ${d}), ${i[2]});

                if(d1 < ${s[l]} && d1 >= 0) {

                  ch = int(float(pos)/ ${d}.);
                    innerDims = vec2(d0, d1);
                    result[${E*2+F}] = getChannel(
                      getA(0, ch, int(innerDims.x),
                      int(innerDims.y)), innerDims);
                }
              }
            }

          `;let S=`
      ${T}

      void main() {
        ivec2 rc = getOutputCoords();
          vec4 result = vec4(0.0);
          int blockIndex, pos, offsetY, d0, offsetX, d1, ch;
          vec2 innerDims;
          ${v}
          ${O.output} = result;
      }
            `;return{...t,output:{dims:p,type:o.type,textureType:2},shaderSource:S,hasMain:!0}},Ql=(a,t,o,e,r)=>{let n=nm(r.cacheKey);return{...n,get:()=>om(a,n,t,o,e,r)}}});function am(a,t,o){let e=t[0].dims,r=t[1].dims,n=Xe.calcShape(e,r,!0);if(!n)throw new Error("Can't use matmul on the given tensors");let s=Ke(n.length),i=St(),{activationFunction:u,applyActivation:l}=Ct(o),f=t.length>2,p=f?"value += getBiasForMatmul();":"",d=f?`${Di(s,i,t[2].dims,n,!1)}`:"",T=n.length,O=e.length,v=r.length,S=e[e.length-1],E=`
    ${u}
    ${d}
    float process(int indices[${T}]) {
        int a[${O}];
        int b[${v}];
        bcastMatmulIndices_A(indices, a);
        bcastMatmulIndices_B(indices, b);

        float value;
        for (int k=0; k<${S}; ++k) {
            a[${O-1}] = k;
            b[${v-2}] = k;
            value += _A(a) * _B(b);
        }
        ${p}
        ${l}
        return value;
    }`;return{...a,output:{dims:n,type:t[0].type,textureType:0},shaderSource:E}}function Ei(a,t){let o=im(a.length>2,t.activationCacheKey);return{...o,get:()=>am(o,a,t)}}function Di(a,t,o,e,r){let n="",s=o.length,i=e.length,u=i-s;i<2&&s>0?n="coords":n=o.map((v,S)=>`coords.${t[S+u]}`).join(", ");let f=Xe.getBroadcastDims(o,e).map(v=>`coords.${t[v+u]} = 0;`).join(`
`),d=U.size(o)===1,T="vec4(outputValue.xx, outputValue.yy)";return d&&(T="vec4(outputValue.x)"),r?`
vec4 getBiasForMatmul() {
  ${a} coords = getOutputCoords();
  ${f}
  vec4 outputValue = getBias(${n});
  return ${T};
}`:`
float getBiasForMatmul() {
  ${a} coords = getOutputCoords();
  ${f}
  return getBias(coords.x);
}`}var tf,rf,im,sm,oo=L(()=>{"use strict";fe();ae();Ft();yr();Li();tf=(a,t,o)=>(sm(t),a.session.pack?[a.run(io(a,t,o),t)]:[a.run(Ei(t,o),t)]),rf=a=>Rr(a.attributes),im=(a,t)=>({name:"MatMul",inputNames:a?["A","B","Bias"]:["A","B"],inputTypes:a?[0,0,0]:[0,0],cacheHint:t});sm=a=>{if(!a||a.length!==2)throw new Error("MatMul requires 2 inputs.");if(a[0].dims[a[0].dims.length-1]!==a[1].dims[a[1].dims.length-2])throw new Error("shared dimension does not match.");if(a[0].type!=="float32"&&a[0].type!=="float64"||a[1].type!=="float32"&&a[1].type!=="float64")throw new Error("inputs should be float type");if(a[0].type!==a[1].type)throw new Error("inputs types should match")}});function fm(a,t,o,e){let r=[],n=[],s=o[0].dims,i=o[1].dims,u=s.length,l=i.length,f=e.length,p=f-u,d=f-l;r=s.map((B,K)=>`coords.${t[K+p]}`),r[u-1]="i*2",r.join(", "),n=i.map((B,K)=>`coords.${t[K+d]}`),n[l-2]="i*2",n.join(", ");let T=Xe.getBroadcastDims(s,e),O=Xe.getBroadcastDims(i,e),v=T.map(B=>`coords.${t[B+p]} = 0;`).join(`
`),S=O.map(B=>`coords.${t[B+d]} = 0;`).join(`
`),E=`int lastDim = coords.${t[f-1]};
  coords.${t[f-1]} = coords.${t[f-2]};
  coords.${t[f-2]} = lastDim;`;return`
vec4 getAAtOutCoordsMatmul(int i) {
  ${a} coords = getOutputCoords();
  ${E}
  ${v}
  vec4 outputValue = getA(${r});
  return outputValue;
}

vec4 getBAtOutCoordsMatmul(int i) {
  ${a} coords = getOutputCoords();
  ${E}
  ${S}
  vec4 outputValue = getB(${n});
  return outputValue;
}`}function cm(a,t){let o="";for(let e=0;e<t-2;e++)o+=`rc.${a[e]}, `;return o+=`rc.${a[t-2]}, i*2`,o}function pm(a,t){let o="";for(let e=0;e<t-2;e++)o+=`rc.${a[e]}, `;return o+=`i*2, rc.${a[t-1]}`,o}var um,lm,io,Li=L(()=>{"use strict";fe();xe();ae();Ft();yr();oo();um=(a,t)=>({name:"MatMul (packed)",inputNames:a?["A","B","Bias"]:["A","B"],inputTypes:a?[2,2,2]:[2,2],cacheHint:t}),lm=(a,t,o,e)=>{let r=o.length>2,n=r?"value += getBiasForMatmul();":"",s=o[0].dims,i=o[1].dims,u=Xe.calcShape(s,i,!0),l=!U.areEqual(o[0].dims,o[1].dims);if(!u)throw new Error("Can't use matmul on the given tensors");let f=s[s.length-1],p=Math.ceil(f/2),d=s.length,T=i.length,O=q(a.session.backend.glContext.version),v=Ke(u.length),S=u.length,E=St(),{activationFunction:F,applyActivation:B}=Ct(e),K=r?`${Di(v,E,o[2].dims,u,!0)}`:"",j=l?`${fm(v,E,o,u)}`:"",M=l?"getAAtOutCoordsMatmul(i)":`getA(${cm(E,d)})`,ie=l?"getBAtOutCoordsMatmul(i)":`getB(${pm(E,T)})`,$e=l?"":`${v} rc =
          getOutputCoords(); int lastDim = rc.${E[S-1]}; rc.${E[S-1]} =
          rc.${E[S-2]}; rc.${E[S-2]} = lastDim;
      `,He=`
            ${j}
            ${K}
            ${F}
            void main() {
              ${$e}

              vec4 value = vec4(0);
              for (int i = 0; i < ${p}; i++) {
                vec4 a = ${M};
                vec4 b = ${ie};

                value += (a.rrbb * b.rgrg);
                value += (a.ggaa * b.baba);
              }
              ${n}
              ${B}
              ${O.output} = value;
            }`;return{...t,output:{dims:u,type:o[0].type,textureType:2},shaderSource:He,hasMain:!0}},io=(a,t,o)=>{let e=um(t.length>2,o.activationCacheKey);return{...e,get:()=>lm(a,e,t,o)}}});var nf,of=L(()=>{"use strict";no();ef();Li();nf=(a,t,o)=>{let e=t[0].dims,r=t[1].dims,n=Mr(e,r,o.dilations,o.pads,o.strides),s=a.run(Ql(a,t[0],t[1],n,o),[t[0]]),i=a.reshapePacked(t[1],[r[0],r[1]*r[2]*r[3]]),u=t.length===3?[i,s,t[2]]:[i,s],l=a.run(io(a,u,o),u);return a.reshapePacked(l,n)}});var dm,hm,af,Fi,$i=L(()=>{"use strict";ae();dm=a=>({name:"Im2Col",inputNames:["X"],inputTypes:[0],cacheHint:a}),hm=(a,t,o,e,r,n)=>{let s=o.dims,i=e.dims,u=r.length,l=Fi(s,i,r,4),f=`
        const int XC = ${s[1]};
        const int XH = ${s[2]};
        const int XW = ${s[3]};
        const int KH = ${n.kernelShape[0]};
        const int KW = ${n.kernelShape[1]};
        const int dilationH = ${n.dilations[0]};
        const int dilationW = ${n.dilations[1]};
        const int strideH = ${n.strides[0]};
        const int strideW = ${n.strides[1]};
        const int padH = ${n.pads[0]};
        const int padW = ${n.pads[1]};
        const int KHKW = KH*KW;
        const int XCKHKW = XC * KHKW;
        const int outputChannels = 4;
        vec4 process(int indices[${u}]) {
          int b  = indices[0]; // batch size
          int oh = indices[1] * strideH - padH; //output height
          int ow = indices[2] * strideW - padW; //output width
          int p = indices[3] * outputChannels; //patch
          vec4 value = vec4(0.0);
          for(int i=0; i < outputChannels; ++i) {
            if(p < XCKHKW) {
              int patchC = p / KHKW;
              int patchH = (p - patchC*KHKW) / KW;
              int patchW = (p - patchC*KHKW) - patchH * KW;
              int xh2 = oh + patchH * dilationH;
              int xw2 = ow + patchW * dilationW;
              int x[${s.length}];
              x[0] = b;
              x[1] = patchC;
              x[2] = xh2;
              x[3] = xw2;
              if(xh2 >= 0 &&
                  xh2 < XH &&
                  xw2 >= 0 &&
                  xw2 < XW) {
                value[i] = _X(x);
              }
            }
            ++p;
          }
          return value;
        }
        `;return{...t,output:{dims:l,type:o.type,textureType:4},shaderSource:f}},af=(a,t,o,e,r)=>{let n=dm(r.cacheKey);return{...n,get:()=>hm(a,n,t,o,e,r)}},Fi=(a,t,o,e=4)=>[o[0],o[2],o[3],Math.ceil(a[1]*t[2]*t[3]/e)]});var mm,bm,sf,uf=L(()=>{"use strict";fe();xe();ae();yr();$i();mm=(a,t)=>({name:"ConvDotProduct",inputNames:a?["Im2Col","K","B"]:["Im2Col","K"],inputTypes:a?[0,4,0]:[0,4],cacheKey:t.activationCacheKey}),bm=(a,t,o,e,r)=>{let n=o[0].dims,s=o[1].dims,i=[s[0],Math.ceil(n[1]*s[2]*s[3]/4)],u=Fi(n,s,e),[l,f]=a.calculateTextureWidthAndHeight(i,4),p=U.computeStrides(u),[d,T]=a.calculateTextureWidthAndHeight(u,4),O=e.length,v=o.length<3?"0.0":"_B(b)",S=Math.ceil(n[1]*s[2]*s[3]/4),{activationFunction:E,applyActivation:F}=Ct(r),B=q(a.session.backend.glContext.version),K=`
${E}
float process(int indices[${O}]) {
  int b[1];
  b[0] = indices[1];
  int im2col[4];
  im2col[0] = indices[0];
  im2col[1] = indices[2];
  im2col[2] = indices[3];
  int im2colOffset = im2col[0] * ${p[0]} + im2col[1] * ${p[1]} + im2col[2] * ${p[2]};
  int kernelOffset = indices[1] * ${i[1]};
  float value = ${v};
  for (int i = 0; i < ${S}; ++i) {
    vec2 im2colCoords = offsetToCoords(im2colOffset, ${d}, ${T});
    vec2 kernelCoords = offsetToCoords(kernelOffset, ${l}, ${f});
    value += dot(${B.texture2D}(Im2Col, im2colCoords), ${B.texture2D}(K, kernelCoords));
    ++im2colOffset;
    ++kernelOffset;
  }
  ${F}
  return value;
}`;return{...t,output:{dims:e,type:o[0].type,textureType:0},shaderSource:K}},sf=(a,t,o,e)=>{let r=mm(t.length>2,e);return{...r,get:()=>bm(a,r,t,o,e)}}});var Mr,Ci,gm,ym,Tm,xm,ki,vm,no=L(()=>{"use strict";Ge();fe();Zl();of();uf();yr();$i();oo();Mr=(a,t,o,e,r)=>{let n=a[0],s=a.slice(2),i=s.length,u=t[0],f=t.slice(2).map((O,v)=>O+(O-1)*(o[v]-1)),d=s.map((O,v)=>O+e[v]+e[v+i]).map((O,v)=>Math.floor((O-f[v]+r[v])/r[v]));return[n,u].concat(...d)},Ci=(a,t,o)=>(vm(t,o),gm(a,t,o)),gm=(a,t,o)=>{let e=xm(o,t),r=a.session.pack,n=e.kernelShape[0]===1&&e.kernelShape[1]===1;return e.group>1?[a.run(Jl(a,t,e),t)]:n&&r?[ym(a,t,e)]:r&&t[0].dims.length===4&&t[0].dims[0]===1&&!n?[nf(a,t,e)]:[Tm(a,t,e)]},ym=(a,t,o)=>{let e=t[0].dims,r=t[1].dims,n=Mr(e,r,o.dilations,o.pads,o.strides),s=a.reshapeUnpacked(t[0],[e[1],e[2]*e[3]]),i=a.reshapeUnpacked(t[1],[r[0],r[1]]),u=t.length>2?[i,s,t[2]]:[i,s],l=a.run(Ei(u,o),u);return a.reshapeUnpacked(l,n)},Tm=(a,t,o)=>{let e=t[0].dims,r=t[1].dims,n=Mr(e,r,o.dilations,o.pads,o.strides),s=a.run(af(a,t[0],t[1],n,o),[t[0]]),i=t.length===3?[s,t[1],t[2]]:[s,t[1]];return a.run(sf(a,t,n,o),i)},xm=(a,t)=>{let o=a.kernelShape.slice();if(a.kernelShape.length===0)for(let n=2;n<t[1].dims.length;++n)o.push(t[1].dims[n]);let e=a.pads.slice();dr.adjustPadsBasedOnAutoPad(t[0].dims,a.strides,a.dilations,o,e,a.autoPad);let r=Object.assign({},a);return Object.assign(r,{kernelShape:o,pads:e,cacheKey:a.cacheKey}),r},ki=a=>{let t=a.attributes,o=Rr(t),e=t.getString("auto_pad","NOTSET"),r=t.getInts("dilations",[1,1]),n=t.getInt("group",1),s=t.getInts("kernel_shape",[]),i=t.getInts("pads",[0,0,0,0]),u=t.getInts("strides",[1,1]);return ee({autoPad:e,dilations:r,group:n,kernelShape:s,pads:i,strides:u,...o})},vm=(a,t)=>{if(!a||a.length!==2&&a.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(a[0].dims.length!==4||a[1].dims.length!==4)throw new Error("currently only support 2-dimensional conv");let o=a[0].dims[1],e=a[1].dims[1]*t.group;if(o!==e)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");if(a.length===3&&(a[2].dims.length!==1||a[1].dims[0]!==a[2].dims[0]))throw new Error("invalid bias");let r=a[0].dims.length-2;if(t.dilations.length!==r)throw new Error(`dilations should be ${r}D`);if(t.strides.length!==r)throw new Error(`strides should be ${r}D`);if(t.pads.length!==r*2)throw new Error(`pads should be ${r*2}D`);if(t.kernelShape.length!==0&&t.kernelShape.length!==a[1].dims.length-2)throw new Error("invalid kernel shape");if(a[0].type!=="float32"||a[1].type!=="float32")throw new Error("Conv input(X,W) should be float tensor");if(a.length===3&&a[2].type!=="float32")throw new Error("Conv input(bias) should be float tensor")}});var wm,_m,Om,lf,Im,Sm,Am,Pm,Em,Dm,ff,Lm,cf=L(()=>{"use strict";Ge();xe();ae();yr();wm=(a,t,o,e,r,n)=>(a-1)*t+o+(e-1)*r+1-n,_m=(a,t,o,e,r)=>{let n=Math.floor(a/2);t==="SAME_UPPER"?(o[e]=n,o[r]=a-n):t==="SAME_LOWER"&&(o[e]=a-n,o[r]=n)},Om=(a,t,o,e,r,n,s,i)=>{let u=a.length-2,l=i.length===0;for(let f=0;f<u;++f){let p=l?a[f+2]*n[f]:i[f],d=wm(a[f+2],n[f],r[f],t[f],o[f],p);_m(d,e,r,f,f+u),l&&i.push(n[f]*(a[f+2]-1)+s[f]+(t[f]-1)*o[f]+1-r[f]-r[f+u])}},lf=(a,t,o)=>(Lm(t,o),Im(a,t,o)),Im=(a,t,o)=>{let e=Dm(o,t);return[Em(a,t,e)]},Sm=(a,t)=>({name:"ConvTranspose",inputNames:a?["X","W","B"]:["X","W"],inputTypes:a?[0,0,0]:[0,0],cacheHint:t}),Am=(a,t,o,e)=>{let n=t.length>2?"getB(output_channel)":"0.0",s=t[0].dims,i=t[1].dims,u=i[1],l=i[0]/e.group,f=[t[0].dims[0],t[1].dims[1]*e.group,...e.outputShape],p=q(a.session.backend.glContext.version),{activationFunction:d,applyActivation:T}=Ct(e),O=`
  const ivec2 strides = ivec2(${e.strides[0]}, ${e.strides[1]});
  const ivec2 pads = ivec2(${e.pads[0]}, ${e.pads[1]});
  ${d}
  void main() {
    ivec4 coords = getOutputCoords();
    int batch = coords.x;
    int output_channel = coords.y;

    ivec2 loc = coords.zw + pads;

    int group_id = output_channel / ${u};
    int wOutChannel = output_channel - group_id * ${u};

    float value = ${n};
    for (int inChannelOffset = 0; inChannelOffset < ${l}; inChannelOffset++) {
      int input_channel = group_id * ${l} + inChannelOffset;
      for (int wWOff = 0; wWOff < ${i[2]}; wWOff++) {
        for (int wHOff = 0; wHOff < ${i[3]}; wHOff++) {
          ivec2 wOff = ivec2(wWOff * ${e.dilations[0]}, wHOff * ${e.dilations[1]});
          ivec2 wLoc = loc - wOff;
          ivec2 wLocIn = wLoc / strides;
          if (
            wLocIn * strides == wLoc &&
            wLocIn.x >= 0 && wLocIn.x < ${s[2]} &&
            wLocIn.y >= 0 && wLocIn.y < ${s[3]}
          ) {
            float xVal = getX(batch, input_channel, wLocIn.y, wLocIn.x);
            float wVal = getW(input_channel, wOutChannel, wHOff, wWOff);
            value += xVal * wVal;
          }
        }
      }
    }
    ${T}
    ${p.output} = vec4(value, .0, .0, .0);
  }
`;return{...o,output:{dims:f,type:t[0].type,textureType:0},shaderSource:O,hasMain:!0}},Pm=(a,t,o)=>{let e=Sm(t.length>2,o.cacheKey);return{...e,get:()=>Am(a,t,e,o)}},Em=(a,t,o)=>a.run(Pm(a,t,o),t),Dm=(a,t)=>{let o=a.kernelShape.slice();if(a.kernelShape.length===0)for(let i=2;i<t[1].dims.length;++i)o.push(t[1].dims[i]);let e=a.pads.slice(),r=a.outputShape.slice(),n=t[0].dims;Om(n,o,a.dilations,a.autoPad,e,a.strides,a.outputPadding,r);let s=Object.assign({},a);return Object.assign(s,{kernelShape:o,pads:e,outputShape:r,cacheKey:a.cacheKey}),s},ff=a=>{let t=a.attributes,o=Rr(t),e=t.getString("auto_pad","NOTSET"),r=t.getInts("dilations",[1,1]),n=t.getInt("group",1),s=t.getInts("kernel_shape",[]),i=t.getInts("output_padding",[0,0]),u=t.getInts("output_shape",[]),l=t.getInts("pads",[0,0,0,0]),f=t.getInts("strides",[1,1]);return ee({autoPad:e,dilations:r,group:n,kernelShape:s,outputPadding:i,outputShape:u,pads:l,strides:f,...o})},Lm=(a,t)=>{if(!a||a.length!==2&&a.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(a[0].dims.length!==4||a[1].dims.length!==4)throw new Error("currently only support 2-dimensional conv");let o=a[0].dims[1],e=a[1].dims[0];if(o!==e)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");let r=a[1].dims[1]*t.group;if(a.length===3&&(a[2].dims.length!==1||a[2].dims[0]!==r))throw new Error("invalid bias");let n=a[0].dims.length-2;if(t.dilations.length!==n)throw new Error(`dilations should be ${n}D`);if(t.strides.length!==n)throw new Error(`strides should be ${n}D`);if(t.pads.length!==n*2)throw new Error(`pads should be ${n*2}D`);if(t.outputPadding.length!==n)throw new Error(`output_padding should be ${n}D`);if(t.kernelShape.length!==0&&t.kernelShape.length!==a[1].dims.length-2)throw new Error("invalid kernel shape");if(t.outputShape.length!==0&&t.outputShape.length!==a[0].dims.length-2)throw new Error("invalid output shape");if(a[0].type!=="float32"||a[1].type!=="float32")throw new Error("ConvTranspose input(X,W) should be float tensor");if(a.length===3&&a[2].type!=="float32")throw new Error("ConvTranspose input(bias) should be float tensor")}});var pf,Tr,df,Fm,hf,$m,Cm,km,ao=L(()=>{"use strict";Ge();fe();ae();pf={name:"Transpose",inputNames:["A"],inputTypes:[0]},Tr=(a,t,o)=>(km(t),[a.run({...pf,cacheHint:o.cacheKey,get:()=>Fm(a,t[0],o.perm)},t)]),df=a=>ee({perm:a.attributes.getInts("perm",[])}),Fm=(a,t,o)=>{let e=t.dims;o=hf(e,o);let r=$m(e,o),n=e.length,s=`
      ${Cm("perm",o,n)}
      float process(int indices[${n}]) {
        int a[${n}];
        perm(a, indices);
        return _A(a);
      }`;return{...pf,output:{dims:r,type:t.type,textureType:0},shaderSource:s}},hf=(a,t)=>(t&&t.length!==a.length&&(t=[...a.keys()].reverse()),t),$m=(a,t)=>(t=hf(a,t),U.sortBasedOnPerm(a,t)),Cm=(a,t,o)=>{let e=[];e.push(`void ${a}(out int a[${o}], int src[${o}]) {`);for(let r=0;r<o;++r)e.push(`	a[${t[r]}]=src[${r}];`);return e.push("	}"),e.join(`
`)},km=a=>{if(!a||a.length!==1)throw new Error("Transpose requires 1 input.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("input should be float tensor")}});var mf,bf,Bm,gf=L(()=>{"use strict";ao();mf=(a,t,o)=>{Bm(t);let e=o.blocksize,r=e*e,n=o.mode==="DCR"?[0,3,4,1,5,2]:[0,1,4,2,5,3],s=o.mode==="DCR"?[t[0].dims[0],e,e,t[0].dims[1]/r,t[0].dims[2],t[0].dims[3]]:[t[0].dims[0],t[0].dims[1]/r,e,e,t[0].dims[2],t[0].dims[3]],i=a.reshapeUnpacked(t[0],s),u={perm:n,cacheKey:`${n}`},[l]=Tr(a,[i],u),f=[t[0].dims[0],t[0].dims[1]/r,t[0].dims[2]*e,t[0].dims[3]*e];return[a.reshapeUnpacked(l,f)]},bf=a=>{let t=a.attributes.getInt("blocksize");if(t<1)throw new Error(`blocksize must be >= 1, but got : ${t} for DepthToSpace`);let o=a.attributes.getString("mode","DCR");if(o!=="DCR"&&o!=="CRD")throw new Error(`unrecognized mode: ${o} for DepthToSpace`);return{mode:o,blocksize:t}},Bm=a=>{if(a.length!==1)throw new Error(`DepthToSpace expect 1 inputs, but got ${a.length}`);if(a[0].type==="string"||a[0].dims.length!==4)throw new TypeError("DepthToSpace input should be a 4-D numeric tensor")}});var yf,Tf,Nm,xf=L(()=>{"use strict";fe();yf=(a,t,o)=>{Nm(t,o);let e=U.flattenShape(t[0].dims,o);return[a.reshapeUnpacked(t[0],e)]},Tf=a=>a.attributes.getInt("axis",1),Nm=(a,t)=>{if(!a||a.length!==1)throw new Error("Flatten requires 1 input.");let o=a[0].dims.length;if(o===0)throw new Error("scalar tensor is not supported.");if(t<-o||t>o)throw new Error("Invalid axis");if(a[0].type==="string")throw new Error("string tensor is not supported.")}});var tr,pn=L(()=>{"use strict";tr=["float32","float64","int32","int16","int8","uint16","uint32","uint8"]});var vf,wf,Rm,Mm,Gm,Um,_f=L(()=>{"use strict";Ge();pn();fe();ae();vf=(a,t,o)=>(Um(t,o.axis),[a.run(Gm(a,t,o),t)]),wf=a=>ee({axis:a.attributes.getInt("axis",0)}),Rm={name:"Gather",inputNames:["A","B"],inputTypes:[0,0]},Mm=(a,t,o,e)=>{let r=o[0].dims.slice(),n=o[1].dims.slice(),s=new Array(r.length+n.length-1);e=U.normalizeAxis(e,r.length);let i=[];for(let d=0;d<s.length;d++)d<e?(s[d]=r[d],i.push(`inputIdx[${d}] = outputIdx[${d}];`)):d<e+n.length?(s[d]=n[d-e],i.push(`indexDataIdx[${d-e}] = outputIdx[${d}];`)):(s[d]=r[d-n.length+1],i.push(`inputIdx[${d-n.length+1}] = outputIdx[${d}];`));let u=s.length||1,l=r.length,f=n.length||1,p=`
      float process(int outputIdx[${u}]) {
        int inputIdx[${l}];
        int indexDataIdx[${f}];
        indexDataIdx[0] = 0;
        ${i.join(`
        `)}
        int idx = int(_B(indexDataIdx));
        inputIdx[${e}] = idx < 0 ? idx + ${r[e]} : idx;
        return _A(inputIdx);
      }`;return{...t,output:{dims:s,type:o[0].type,textureType:0},shaderSource:p}},Gm=(a,t,o)=>{let e={...Rm,cacheHint:o.cacheKey};return{...e,get:()=>Mm(a,e,t,o.axis)}},Um=(a,t)=>{if(!a||a.length!==2)throw new Error("Gather requires 2 inputs.");let o=a[0].dims.length;if(o<1)throw new Error("Invalid input shape.");if(t<-o||t>o-1)throw new Error("Invalid axis.");if(tr.indexOf(a[0].type)===-1)throw new Error("Invaid input type.");if(a[1].type!=="int32"&&a[1].type!=="int16")throw new Error("Invaid input type.")}});var Bi,Of,If,Sf,zm,Vm,Wm,Af=L(()=>{"use strict";Ge();fe();ae();Bi=(a,t,o)=>(Wm(t,o),[a.run(zm(t,o),t)]),Of=(a,t)=>{let o=a.attributes.getInt("transA",0)!==0,e=a.attributes.getInt("transB",0)!==0,r=a.attributes.getFloat("alpha",1),n=a.attributes.getFloat("beta",1);return ee({transA:o,transB:e,alpha:r,beta:n,isOptionalC:t})},If=a=>Of(a,!1),Sf=a=>Of(a,!0),zm=(a,t)=>{let o={name:"Gemm",inputNames:a.length===3?["A","B","C"]:["A","B"],inputTypes:a.length===3?[0,0,0]:[0,0],key:t.cacheKey};return{...o,get:()=>Vm(o,a,t)}},Vm=(a,t,o)=>{let e=t[0].dims.slice(),r=t[1].dims.slice(),[n,s]=Xn.getShapeOfGemmResult(e,o.transA,r,o.transB,t.length===3?t[2].dims:void 0),i=[n,s];if(!i)throw new Error("Can't use gemm on the given tensors");let u=e[e.length-1],l="";o.transA&&(u=e[0]),o.transA&&o.transB?l="value += _A_T(a) * _B_T(b);":o.transA&&!o.transB?l="value += _A_T(a) * _B(b);":!o.transA&&o.transB?l="value += _A(a) * _B_T(b);":!o.transA&&!o.transB&&(l="value += _A(a) * _B(b);");let f=i.length,p=t.length===3?`int c[${t[2].dims.length}];`:"",d=t.length===3?"bcastIndices_C(indices, c);":"",T=t.length===3?"value += beta * _C(c);":"",O=`
      float process(int indices[${f}]) {
          int a[${f}];
          int b[${f}];
          ${p}

          copyVec(indices, a);
          copyVec(indices, b);
          ${d}

          float value = 0.0;
          for (int k=0; k<${u}; ++k) {
              a[${f-1}] = k;
              b[${f-2}] = k;
              ${l}
          }

          value = value * alpha;
          ${T}
          return value;
      }`;return{...a,output:{dims:i,type:t[0].type,textureType:0},variables:[{name:"alpha",type:"float",data:o.alpha},{name:"beta",type:"float",data:o.beta}],shaderSource:O}},Wm=(a,t)=>{if(!a)throw new Error("Input is missing");if(t.isOptionalC&&(a.length<2||a.length>3))throw new Error("Invaid input shape.");if(!t.isOptionalC&&a.length!==3)throw new Error("Gemm requires 3 inputs");if(a.length===3&&a[2].dims.length!==1&&a[2].dims.length!==2)throw new Error("Invalid input shape of C");if(a[0].type!=="float32"&&a[0].type!=="float64"||a[1].type!=="float32"&&a[1].type!=="float64"||a.length===3&&a[2].type!=="float32"&&a[2].type!=="float64")throw new Error("Invalid input type.");if(a[0].type!==a[1].type||a.length===3&&a[0].type!==a[2].type)throw new Error("Input types are mismatched")}});var Pf,Ef,Hm,qm,jm,Ym,Xm,Df=L(()=>{"use strict";Ge();ae();Pf=(a,t,o)=>(Xm(t),[a.run(jm(a,t,o),t)]),Ef=a=>{let t=a.attributes.getFloat("scale"),o=a.attributes.getFloats("bias");return ee({scale:t,bias:o})},Hm={name:"ImageScaler",inputNames:["X"],inputTypes:[0]},qm=(a,t,o,e)=>{let r=o[0].dims.slice(),n=r.length,i=`
      ${Ym(e.bias.length)}
      float process(int indices[${n}]) {
        return _X(indices) * scale + getBias(bias, indices[1]);
      }`;return{...t,output:{dims:r,type:o[0].type,textureType:0},variables:[{name:"bias",type:"float",arrayLength:e.bias.length,data:e.bias},{name:"scale",type:"float",data:e.scale}],shaderSource:i}},jm=(a,t,o)=>{let e={...Hm,cacheHint:o.cacheKey};return{...e,get:()=>qm(a,e,t,o)}},Ym=a=>{let t=[`float getBias(float bias[${a}], int channel) {`];for(let o=0;o<a;++o)o===0?t.push(`	if (channel == ${o}) { return bias[${o}]; }`):o===a-1?t.push(`	else { return bias[${o}]; }`):t.push(`	else if (channel == ${o}) { return bias[${o}]; }`);return t.push("	}"),t.join(`
`)},Xm=a=>{if(!a||a.length!==1)throw new Error("ImageScaler requires 1 input.");if(a[0].dims.length!==4)throw new Error("Invalid input shape.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.")}});var Ff,$f,Lf,Km,Jm,Zm,Qm,eb,tb,Cf=L(()=>{"use strict";xe();ae();Ff=(a,t,o)=>{tb(t);let e=a.run(Jm(t[0]),t);return[a.run(eb(a,t[0],o,e.dims),[t[0],e,t[1],t[2]])]},$f=a=>a.attributes.getFloat("epsilon",1e-5),Lf={name:"InstanceNormalization_MeanAndVariance",inputNames:["X"],inputTypes:[0]},Km=(a,t)=>{let o=t.dims.slice(),e=o[1],r=o[2]*o[3],n=[o[0],e],s=`
      vec4 process(int[2] indices) {
        vec4 v = vec4(0.0);
        int a[4];
        a[0] = indices[0];
        a[1] = indices[1];
        float temp = 0.0;
        for(int a2=0; a2<${o[2]}; a2++) {
          a[2] = a2;
          for(int a3=0; a3<${o[3]}; a3++) {
            a[3] = a3;
            float x = _X(a);
            temp += x;
          }
        }
        float mean = temp / float(${r});
        temp = 0.0;
        for(int a2=0; a2<${o[2]}; a2++) {
          a[2] = a2;
          for(int a3=0; a3<${o[3]}; a3++) {
            a[3] = a3;
            float x = _X(a);
            temp += (x - mean) * (x - mean);
          }
        }
        v.r = mean;
        v.g = temp / float(${r});

        return v;
      }`;return{...a,output:{dims:n,type:t.type,textureType:4},shaderSource:s}},Jm=a=>({...Lf,get:()=>Km(Lf,a)}),Zm={name:"InstanceNormalization_ComputeOutput",inputNames:["X","MeanAndVariance","Scale","B"],inputTypes:[0,4,0,0]},Qm=(a,t,o,e,r)=>{let n=q(a.session.backend.glContext.version),[s,i]=a.calculateTextureWidthAndHeight(r,4),[u,l]=[s/4,i],f=`
      vec4 get_MeanAndVariance(int[2] mv) {
        int offset = indicesToOffset_MeanAndVariance(mv);
        vec2 coords = offsetToCoords(offset, ${u}, ${l});
        return ${n.texture2D}(MeanAndVariance, coords);
      }

      float process(int[4] indices) {
        int mv[2];
        mv[0] = indices[0];
        mv[1] = indices[1];
        vec4 mean_and_variance = get_MeanAndVariance(mv);
        float mean = mean_and_variance.r;
        float variance = mean_and_variance.g;

        int sb[1];
        sb[0] = indices[1];
        float scale = _Scale(sb);
        float b = _B(sb);

        return scale * (_X(indices) - mean) / sqrt(variance + epsilon) + b;
      }`;return{...t,output:{dims:o.dims,type:o.type,textureType:0},variables:[{name:"epsilon",type:"float",data:e}],shaderSource:f}},eb=(a,t,o,e)=>{let r={...Zm,cacheHint:`${o}`};return{...r,get:()=>Qm(a,r,t,o,e)}},tb=a=>{if(!a||a.length!==3)throw new Error("InstanceNormalization requires 3 inputs.");let t=a[0],o=a[1],e=a[2];if(t.dims.length<3||o.dims.length!==1||e.dims.length!==1)throw new Error("Invalid input shape.");if(o.dims[0]!==t.dims[1]||e.dims[0]!==t.dims[1])throw new Error("Input shapes are mismatched.");if(t.type!=="float32"&&t.type!=="float64"||o.type!=="float32"&&o.type!=="float64"||e.type!=="float32"&&e.type!=="float64")throw new Error("Invalid input type.");if(a[0].dims.length!==4)throw new Error("Only support 4-D input shape.")}});function rb(a,t){let o=a[0].dims[1],e=a[0].dims.length,r=-Math.floor((t.size-1)/2),n=Math.ceil((t.size-1)/2),s=`float(${t.alpha}) / float(${t.size})`,i=`float(${t.bias})`,u=`float(${t.beta})`,l=`
    float process(int indices[${e}]) {
        int c = indices[1];
        float x = _X(indices);
        float square_sum = 0.0;

        for (int i = ${r}; i <= ${n}; i++) {
          int idx = c + i;
          if (c >= 0 && c < ${o}) {
            indices[1] = idx;
            float j = _X(indices);
            square_sum += j * j;
          }
        }
        return x / pow(${i} + ${s} * square_sum, ${u});
    }`;return{...Nf,cacheHint:t.cacheKey,output:{dims:a[0].dims,type:a[0].type,textureType:0},shaderSource:l}}function nb(a,t){return{...Nf,cacheHint:t.cacheKey,get:()=>rb(a,t)}}var kf,Bf,Nf,ob,Rf=L(()=>{"use strict";Ge();ae();kf=(a,t,o)=>(ob(t),[a.run(nb(t,o),t)]),Bf=a=>{let t=a.attributes.getFloat("alpha",1e-4),o=a.attributes.getFloat("beta",.75),e=a.attributes.getFloat("bias",1),r=a.attributes.getInt("size");return ee({alpha:t,beta:o,bias:e,size:r})},Nf={name:"LRN",inputNames:["X"],inputTypes:[0]};ob=a=>{if(!a||a.length!==1)throw new Error("LRN requires 1 input.");if(a[0].dims.length!==4)throw new Error('currently only support LRN for input with "NCHW" format');if(a[0].type!=="float32")throw new Error("input should be float type")}});var ib,Ni,Mf,Gf,Uf,ab,sb,ub,lb,fb,cb,pb,db,zf=L(()=>{"use strict";Ge();fe();xe();ae();ib={name:"Pad",inputNames:["A"],inputTypes:[0]},Ni=(a,t,o)=>(ub(t),[a.run({...ib,cacheHint:o.cacheKey,get:()=>sb(a,t[0],o)},t)]),Mf=a=>{let t=a.attributes.getString("mode","constant"),o=a.attributes.getFloat("value",0),e=a.attributes.getInts("pads");return ee({mode:t,value:o,pads:e})},Gf=(a,t,o)=>{lb(t);let e=ab(a,t,o);return Ni(a,[t[0]],e)},Uf=a=>a.attributes.getString("mode","constant"),ab=(a,t,o)=>{if(!a.session.isInitializer(t[1].dataId)||t.length>=3&&!a.session.isInitializer(t[2].dataId))throw new Error("dynamic pad attributes are not allowed");let e=Array.from(t[1].integerData),r=t.length>=3?t[2].floatData[0]:0;return ee({mode:o,pads:e,value:r})},sb=(a,t,o)=>{let e=U.padShape(t.dims.slice(),o.pads),r=e.length,s=`
      ${fb(a,t,o)}
      float process(int[${r}] indices) {
          return padA(indices);
      }`;return{name:"Pad",inputNames:["A"],inputTypes:[0],output:{dims:e,type:t.type,textureType:0},shaderSource:s}},ub=a=>{if(!a||a.length!==1)throw new Error("Pad requires 1 input");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.")},lb=a=>{if(!a||a.length!==2&&a.length!==3)throw new Error("Pad requires 2 or 3 inputs");if(a[1].type!=="int32")throw new Error("Invalid input type.");if(a.length>=3&&a[2].type==="string")throw new Error("Invalid input type.")},fb=(a,t,o)=>{let e=q(a.session.backend.glContext.version),[r,n]=a.calculateTextureWidthAndHeight(t.dims,0),s=U.computeStrides(t.dims);switch(o.mode){case"constant":return cb(e,t.dims,s,r,n,o.pads,o.value);case"reflect":return pb(e,t.dims,s,r,n,o.pads);case"edge":return db(e,t.dims,s,r,n,o.pads);default:throw new Error("Invalid mode")}},cb=(a,t,o,e,r,n,s)=>{let i=t.length,u="";for(let l=i-1;l>=0;--l)u+=`
        k = m[${l}] - ${n[l]};
        if (k < 0)  return constant;
        if (k >= ${t[l]}) return constant;
        offset += k * ${o[l]};
        `;return`
      float padA(int m[${i}]) {
        const float constant = float(${s});
        int offset = 0;
        int k = 0;
        ${u}
        vec2 coords = offsetToCoords(offset, ${e}, ${r});
        float value = getColorAsFloat(${a.texture2D}(A, coords));
        return value;
      }
      `},pb=(a,t,o,e,r,n)=>{let s=t.length,i="";for(let u=s-1;u>=0;--u)i+=`
        k = m[${u}] - ${n[u]};
        if (k < 0) { k = -k; }
        {
          const int _2n_1 = ${2*(t[u]-1)};
          k = int( mod( float(k), float(_2n_1) ) ) ;
          if(k >= ${t[u]}) { k = _2n_1 - k; }
        }
        offset += k * ${o[u]};
        `;return`
      float padA(int m[${s}]) {
        int offset = 0;
        int k = 0;
        ${i}
        vec2 coords = offsetToCoords(offset, ${e}, ${r});
        float value = getColorAsFloat(${a.texture2D}(A, coords));
        return value;
      }
      `},db=(a,t,o,e,r,n)=>{let s=t.length,i="";for(let u=s-1;u>=0;--u)i+=`
        k = m[${u}] - ${n[u]};
        if (k < 0)  k = 0;
        if (k >= ${t[u]}) k = ${t[u]-1};
        offset += k * ${o[u]};
      `;return`
      float padA(int m[${s}]) {
        int offset = 0;
        int k = 0;
        ${i}
        vec2 coords = offsetToCoords(offset, ${e}, ${r});
        float value = getColorAsFloat(${a.texture2D}(A, coords));
        return value;
      }
      `}});var Wf,Hf,qf,jf,Yf,Xf,Kf,Jf,Zf,hb,Vf,Qf,uo,ec,so,mb,tc=L(()=>{"use strict";Ge();fe();ae();Wf=(a,t,o)=>{uo(t);let e={name:"AveragePool",inputNames:["X"],inputTypes:[0],cacheHint:o.cacheKey};return[a.run({...e,get:()=>qf(t,e,!1,o)},t)]},Hf=a=>{let t=a.attributes.getString("auto_pad","NOTSET"),o=a.attributes.getInt("ceil_mode",0),e=a.attributes.getInt("count_include_pad",0)!==0,r=a.attributes.getInts("kernel_shape"),n=a.attributes.getInts("strides",[]),s=a.attributes.getInts("pads",[]);if(o!==0)throw new Error("using ceil() in shape computation is not yet supported for AveragePool");return ee({autoPad:t,ceilMode:o,countIncludePad:e,kernelShape:r,strides:n,pads:s})},qf=(a,t,o,e)=>{let[r,n]=Zf(a,e,o),s=U.size(r.kernelShape),i="value += _X(x);",u="";r.countIncludePad?u+=`value /= float(${s});`:u+=`value /= float(${s} - pad);`;let f=`
        ${ec(a[0].dims,r,i,u,"0.0")}
      `;return{...t,output:{dims:n,type:a[0].type,textureType:0},shaderSource:f}},jf=(a,t,o)=>{uo(t);let e={name:"GlobalAveragePool",inputNames:["X"],inputTypes:[0],cacheHint:`${o.countIncludePad}`};return[a.run({...e,get:()=>qf(t,e,!0,o)},t)]},Yf=a=>{let t=a.attributes.getInt("count_include_pad",0)!==0;return ee({autoPad:"",ceilMode:0,countIncludePad:t,kernelShape:[],strides:[],pads:[]})},Xf=(a,t,o)=>{uo(t);let e={name:"MaxPool",inputNames:["X"],inputTypes:[0],cacheHint:o.cacheKey};return[a.run({...e,get:()=>Jf(t,e,!1,o)},t)]},Kf=a=>{let t=a.attributes.getString("auto_pad","NOTSET"),o=a.attributes.getInt("ceil_mode",0),e=a.attributes.getInts("kernel_shape"),r=a.attributes.getInts("strides",[]),n=a.attributes.getInts("pads",[]),s=a.attributes.getInt("storage_order",0),i=a.attributes.getInts("dilations",[]);if(s!==0)throw new Error("column major storage order is not yet supported for MaxPool");if(o!==0)throw new Error("using ceil() in shape computation is not yet supported for MaxPool");return ee({autoPad:t,ceilMode:o,countIncludePad:!1,kernelShape:e,strides:r,pads:n,storageOrder:s,dilations:i})},Jf=(a,t,o,e)=>{let[r,n]=Zf(a,e,o),s=`
      value = max(_X(x), value);
    `,i="",l=`
      ${ec(a[0].dims,r,s,i,"-1e5")}
    `;return{...t,output:{dims:n,type:a[0].type,textureType:0},shaderSource:l}},Zf=(a,t,o)=>{let e=a[0].dims.slice(),r=Object.hasOwnProperty.call(t,"dilations"),n=t.kernelShape.slice(),s=t.strides.slice(),i=r?t.dilations.slice():[],u=t.pads.slice();dr.adjustPoolAttributes(o,e,n,s,i,u);let l=dr.computePoolOutputShape(o,e,s,i,n,u,t.autoPad),f=Object.assign({},t);return r?Object.assign(f,{kernelShape:n,strides:s,pads:u,dilations:i,cacheKey:t.cacheKey}):Object.assign(f,{kernelShape:n,strides:s,pads:u,cacheKey:t.cacheKey}),[f,l]},hb={autoPad:"",ceilMode:0,countIncludePad:!1,kernelShape:[],strides:[],pads:[],storageOrder:0,dilations:[],cacheKey:""},Vf={name:"GlobalMaxPool",inputNames:["X"],inputTypes:[0]},Qf=(a,t)=>(uo(t),[a.run({...Vf,get:()=>Jf(t,Vf,!0,hb)},t)]),uo=a=>{if(!a||a.length!==1)throw new Error("Pool ops requires 1 input.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.")},ec=(a,t,o,e,r)=>{let n=a.length;if(t.kernelShape.length<=2){let s=t.kernelShape[t.kernelShape.length-1],i=t.strides[t.strides.length-1],u=t.pads[t.pads.length/2-1],l=t.pads[t.pads.length-1],f=a[n-1],p="",d="",T="";if(u+l!==0?p=`
          for (int i = 0; i < ${s}; i++) {
            x[${n} - 1] = indices[${n} - 1] * ${i} - ${u} + i;
            if (x[${n} - 1] < 0 || x[${n} - 1] >= ${f}) {
              pad++;
              continue;
            }
            ${o}
          }`:p=`
          for (int i = 0; i < ${s}; i++) {
            x[${n} - 1] = indices[${n} - 1] * ${i} - ${u} + i;
            ${o}
          }`,t.kernelShape.length===2){let v=t.kernelShape[t.kernelShape.length-2],S=t.strides[t.strides.length-2],E=t.pads[t.pads.length/2-2],F=t.pads[t.pads.length-2],B=a[n-2];E+F!==0?d=`
            for (int j = 0; j < ${v}; j++) {
              x[${n} - 2] = indices[${n} - 2] * ${S} - ${E} + j;
              if (x[${n} - 2] < 0 || x[${n} - 2] >= ${B}) {
                pad+= ${s};
                continue;
              }
          `:d=`
            for (int j = 0; j < ${v}; j++) {
              x[${n} - 2] = indices[${n} - 2] * ${S} - ${E} + j;
            `,T=`
          }
        `}return`
        float process(int indices[${n}]) {
          int x[${n}];
          copyVec(indices, x);

          float value = ${r};
          int pad = 0;
          ${d}
          ${p}
          ${T}
          ${e}
          return value;
        }
      `}else{let s=U.size(t.kernelShape),i=U.computeStrides(t.kernelShape),u=i.length,l=t.pads.length,f=mb(u),p=so(a,"inputDims"),d=so(t.pads,"pads"),T=so(i,"kernelStrides"),O=so(t.strides,"strides"),v=t.pads.reduce((F,B)=>F+B),S="";return v?S=`
            if (x[j] >= inputDims[j] || x[j] < 0) {
              pad++;
              isPad = true;
              break;
            }
          }
          if (!isPad) {
            ${o}
          }`:S=`
          }
          ${o}
        `,`
        ${f}
        float process(int indices[${n}]) {
          int x[${n}];
          copyVec(indices, x);
          int offset[${u}];
          int pads[${l}];
          int inputDims[${n}];
          int kernelStrides[${u}];
          int strides[${u}];
          ${d}
          ${p}
          ${O}
          ${T}

          float value = ${r};
          int pad = 0;
          bool isPad = false;
          for (int i = 0; i < ${s}; i++) {
            offsetToIndices(i, kernelStrides, offset);
            isPad = false;
            for (int j = ${n} - ${u}; j < ${n}; j++) {
              x[j] = indices[j] * strides[j - ${n} + ${u}]
                + offset[j - ${n} + ${u}] - pads[j - 2];
              ${S}
          }
          ${e}

          return value;
        }
      `}},so=(a,t)=>{let o="";for(let e=0;e<a.length;e++)o+=`
      ${t}[${e}] = ${a[e]};
    `;return o},mb=a=>`
  void offsetToIndices(int offset, int[${a}] strides, out int[${a}] indices) {
    if (${a} == 0) {
      return;
    }
    for (int i = 0; i < ${a} - 1; ++i) {
      indices[i] = offset / strides[i];
      offset -= indices[i] * strides[i];
    }
    indices[${a} - 1] = offset;
  }`});var xr,rr,bb,gb,rc,nc,oc,ic,ac,sc,uc,lc=L(()=>{"use strict";Ge();pn();fe();ae();xr=(a,t,o,e,r)=>{gb(t);let n={name:e,inputNames:["A"],inputTypes:[0]};return[a.run({...n,cacheHint:o.cacheKey,get:()=>bb(a,t,o,e,r,n)},t)]},rr=a=>{let t=a.attributes.getInts("axes",[]),o=a.attributes.getInt("keepdims",1)===1;return ee({axes:t,keepDims:o})},bb=(a,t,o,e,r,n)=>{let s=[],i=t[0].dims.length||1,u=[],l=U.normalizeAxes(o.axes,t[0].dims.length),f=r(t,l),p=f[1];for(let O=0;O<t[0].dims.length;O++)l.indexOf(O)>=0||l.length===0?(o.keepDims&&s.push(1),p=`
          for(int j${O} = 0; j${O} < ${t[0].dims[O]}; j${O}++) {
            inputIdx[${O}] = j${O};
            ${p}
          }`):(u.push(`inputIdx[${O}] = outputIdx[${s.length}];`),s.push(t[0].dims[O]));let T=`
      float process(int outputIdx[${s.length||1}]) {
        float value;                 // final result
        int inputIdx[${i}];      // addressing input data
        ${u.join(`
`)}
        ${f[0]}       // init ops for reduce max/min
        ${p}
        ${f[2]}       // final computation for reduce mean
        return value;
      }`;return{...n,output:{dims:s,type:t[0].type,textureType:0},shaderSource:T}},gb=a=>{if(!a||a.length!==1)throw new Error("Reduce op requires 1 input.");if(tr.indexOf(a[0].type)===-1)throw new Error("Invalid input type.")},rc=(a,t,o)=>xr(a,t,o,"ReduceSum",()=>["value = 0.0;","value += _A(inputIdx);",""]),nc=(a,t,o)=>xr(a,t,o,"ReduceMean",(r,n)=>{let s=1;for(let i=0;i<r[0].dims.length;i++)(n.indexOf(i)>=0||n.length===0)&&(s*=r[0].dims[i]);return["value = 0.0;","value += _A(inputIdx);",`value /= ${s}.;`]}),oc=(a,t,o)=>xr(a,t,o,"ReduceMax",(r,n)=>{let s=[];for(let i=0;i<r[0].dims.length;i++)(n.indexOf(i)>=0||n.length===0)&&s.push(`inputIdx[${i}] = 0;`);return[`${s.join(`
`)}
value = _A(inputIdx);`,"value = max(value, _A(inputIdx));",""]}),ic=(a,t,o)=>xr(a,t,o,"ReduceMin",(r,n)=>{let s=[];for(let i=0;i<r[0].dims.length;i++)(n.indexOf(i)>=0||n.length===0)&&s.push(`inputIdx[${i}] = 0;`);return[`${s.join(`
`)}
value = _A(inputIdx);`,"value = min(value, _A(inputIdx));",""]}),ac=(a,t,o)=>xr(a,t,o,"ReduceProd",()=>["value = 1.0;","value *= _A(inputIdx);",""]),sc=(a,t,o)=>xr(a,t,o,"ReduceLogSum",()=>["value = 0.0;","value += _A(inputIdx);","value = log(value);"]),uc=(a,t,o)=>xr(a,t,o,"ReduceLogSumSquare",()=>["float t; value = 0.0;","t = _A(inputIdx); value += t * t;",""])});var fc,cc=L(()=>{"use strict";fe();fc=(a,t)=>{let o=U.calculateReshapedDims(t[0].dims,t[1].integerData);return a.session.pack?[a.reshapePacked(t[0],o)]:[a.reshapeUnpacked(t[0],o)]}});var pc,Ri,dc,hc,dn,yb,Mi,lo,Gi=L(()=>{"use strict";Ge();xe();ae();pc={name:"Upsample",inputNames:["X"],inputTypes:[0]},Ri=(a,t,o)=>(Mi(t,o),[a.run({...pc,cacheHint:o.cacheKey,get:()=>yb(a,t,o)},t)]),dc=a=>dn(a,7),hc=a=>dn(a,9),dn=(a,t)=>{let o=t>=10,e=a.attributes.getString("mode","nearest");if(e!=="nearest"&&e!=="linear"&&(t<11||e!=="cubic"))throw new Error(`unrecognized mode: ${e}`);let r=[];t<9&&(r=a.attributes.getFloats("scales"),lo(r,e,o));let n=a.attributes.getFloat("extrapolation_value",0),s=t>10?a.attributes.getString("coordinate_transformation_mode","half_pixel"):"asymmetric";if(["asymmetric","pytorch_half_pixel","tf_half_pixel_for_nn","align_corners","tf_crop_and_resize","half_pixel"].indexOf(s)===-1)throw new Error(`coordinate_transform_mode '${s}' is not supported`);let i=s==="tf_crop_and_resize",u=i,l=e==="nearest"&&t>=11?a.attributes.getString("nearest_mode","round_prefer_floor"):"";if(["round_prefer_floor","round_prefer_ceil","floor","ceil",""].indexOf(l)===-1)throw new Error(`nearest_mode '${l}' is not supported`);let f=a.attributes.getFloat("cubic_coeff_a",-.75),p=a.attributes.getInt("exclude_outside",0)!==0;if(p&&e!=="cubic")throw new Error("exclude_outside can be set to 1 only when mode is CUBIC.");let d=t<11?!0:e==="nearest"&&s==="asymmetric"&&l==="floor",T=0,O=0,v=0;return t>10?a.inputs.length>2?(T=1,O=2,v=3):(O=1,v=2):t===9&&(O=1),ee({opset:t,isResize:o,mode:e,scales:r,extrapolationValue:n,coordinateTransformMode:s,useExtrapolation:u,needRoiInput:i,nearestMode:l,cubicCoefficientA:f,excludeOutside:p,useNearest2xOptimization:d,roiInputIdx:T,scalesInputIdx:O,sizesInputIdx:v})},yb=(a,t,o)=>{let e=q(a.session.backend.glContext.version),[r,n]=a.calculateTextureWidthAndHeight(t[0].dims,0),s=t[0].dims.map((v,S)=>Math.floor(v*o.scales[S])),[i,u]=a.calculateTextureWidthAndHeight(s,0),l=s.length,f=new Array(l),p=new Array(l),d=`
      int output_pitches[${l}];
      int input_pitches[${l}];
      `;for(let v=l-1;v>=0;v--)f[v]=v===l-1?1:f[v+1]*s[v+1],p[v]=v===l-1?1:p[v+1]*t[0].dims[v+1],d+=`
        output_pitches[${v}] = ${f[v]};
        input_pitches[${v}] = ${p[v]};
        `;let T=`
      float getInputFloat(int index) {
        vec2 coords = offsetToCoords(index, ${r}, ${n});
        float value = getColorAsFloat(${e.texture2D}(X, coords));
        return value;
      }
      `,O=o.mode==="nearest"?`
    ${T}
    float process(int indices[${l}]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${i}, ${u});

      ${d}

      int d, m;
      for (int dim = 0; dim < ${l}; ++dim) {
        d = output_index / output_pitches[dim];
        m = output_index - d * output_pitches[dim];
        output_index = m;

        if (scales[dim] != 1 && d > 0) {
          int d2 = d / scales[dim];
          m = d - d2 * scales[dim];
          d = d2;
        }
        input_index += input_pitches[dim] * d;
      }

      return getInputFloat(input_index);
    }`:l===4?`
    ${T}
    float process(int indices[4]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${i}, ${u});

      ${d}

      int m;
      int index_of_dim0, index_of_dim1, index_of_dim2, index_of_dim3;
      index_of_dim0 = output_index / output_pitches[0];
      m = output_index - index_of_dim0 * output_pitches[0];
      index_of_dim1 = m / output_pitches[1];
      m = m - index_of_dim1 * output_pitches[1];
      index_of_dim2 = m / output_pitches[2];
      m = m - index_of_dim2 * output_pitches[2];
      index_of_dim3 = m;

      int index_of_input_dim2, index_of_input_dim3, x_offset, y_offset;
      index_of_input_dim2 = index_of_dim2 / scales[2];
      y_offset = index_of_dim2 - index_of_input_dim2 * scales[2];
      index_of_input_dim3 = index_of_dim3 / scales[3];
      x_offset = index_of_dim3 - index_of_input_dim3 * scales[3];

      input_index = index_of_dim0 * input_pitches[0] +
            index_of_dim1 * input_pitches[1] +
            index_of_input_dim2 * input_pitches[2] +
            index_of_input_dim3;

      float x00 = getInputFloat(input_index);
      float x10, x01, x11;

      bool end_of_dim2 = false;
      if (index_of_input_dim2 == (${t[0].dims[2]} - 1)) {
        // It's the end in dimension 2
        x01 = x00;
        end_of_dim2 = true;
      } else {
        x01 = getInputFloat(input_index + input_pitches[2]);
      }

      if (index_of_input_dim3 == (input_pitches[2] - 1)) {
        // It's the end in dimension 3
        x10 = x00;
        x11 = x01;
      }
      else {
        x10 = getInputFloat(input_index + 1);
        x11 = end_of_dim2 ? x10 : getInputFloat(input_index + input_pitches[2] + 1);
      }

      float y0 = x00 + float(y_offset) * (x01 - x00) / float(scales[2]);
      float y1 = x10 + float(y_offset) * (x11 - x10) / float(scales[2]);
      return y0 + float(x_offset) * (y1 - y0) / float(scales[3]);
    }`:`
    ${T}
    float process(int indices[2]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${i}, ${u});

      ${d}

      int m;
      int index_of_dim0, index_of_dim1;
      index_of_dim0 = output_index / output_pitches[0];
      m = output_index - index_of_dim0 * output_pitches[0];
      index_of_dim1 = m;

      int index_of_input_dim0, index_of_input_dim1, x_offset, y_offset;
      index_of_input_dim0 = index_of_dim0 / scales[0];
      y_offset = index_of_dim0 - index_of_input_dim0 * scales[0];
      index_of_input_dim1 = index_of_dim1 / scales[1];
      x_offset = index_of_dim1 - index_of_input_dim1 * scales[1];

      input_index = index_of_input_dim0 * input_pitches[0] + index_of_input_dim1;

      float x00 = getInputFloat(input_index);
      float x10, x01, x11;

      bool end_of_dim0 = false;
      if (index_of_input_dim0 == (${t[0].dims[0]} - 1)) {
        // It's the end in dimension 0
        x01 = x00;
        end_of_dim0 = true;
      } else {
        x01 = getInputFloat(input_index + input_pitches[0]);
      }

      if (index_of_input_dim1 == (input_pitches[0] - 1)) {
        // It's the end in dimension 1
        x10 = x00;
        x11 = x01;
      }
      else {
        x10 = getInputFloat(input_index + 1);
        x11 = end_of_dim0 ? x10 : getInputFloat(input_index + input_pitches[0] + 1);
      }

      float y0 = x00 + float(y_offset) * (x01 - x00) / float(scales[0]);
      float y1 = x10 + float(y_offset) * (x11 - x10) / float(scales[0]);
      return y0 + float(x_offset) * (y1 - y0) / float(scales[1]);
    }`;return{...pc,output:{dims:s,type:t[0].type,textureType:0},shaderSource:O,variables:[{name:"scales",type:"int",arrayLength:o.scales.length,data:o.scales.map(v=>Math.ceil(v))}]}},Mi=(a,t)=>{if(!a||t.opset<9&&a.length!==1||t.opset>=9&&t.opset<11&&a.length!==2||t.opset>=11&&a.length<2)throw new Error("invalid inputs.");if(t.scales.length>0&&a[0].dims.length!==t.scales.length)throw new Error("Invalid input shape.");if(a[0].type==="string")throw new Error("Invalid input tensor types.")},lo=(a,t,o)=>{if(o){for(let e of a)if(e<=0)throw new Error("Scale value should be greater than 0.")}else for(let e of a)if(e<1)throw new Error("Scale value should be greater than or equal to 1.");if((t==="linear"||t==="cubic")&&a.length!==2&&(a.length!==4||a[0]!==1||a[1]!==1))throw new Error(`'Linear' mode and 'Cubic' mode only support 2-D inputs ('Bilinear', 'Bicubic')         or 4-D inputs with the corresponding outermost 2 scale values being 1         in the ${o?"Resize":"Upsample"} opeartor.`)}});var Ui,zi,mc,bc,Tb,xb,vb,wb,gc=L(()=>{"use strict";xe();ae();Ft();gr();Gi();Ui={name:"Resize",inputNames:["A"],inputTypes:[2]},zi=(a,t,o)=>(Mi(t,o),[a.run({...Ui,cacheHint:o.cacheKey,get:()=>Tb(a,t,o)},t)]),mc=a=>dn(a,10),bc=a=>dn(a,11),Tb=(a,t,o)=>{let e=q(a.session.backend.glContext.version),[r,n]=xb(t,o);if(r.every(B=>B===1)&&o.coordinateTransformMode!=="tf_crop_and_resize")return{...Ui,output:{dims:n,type:t[0].type,textureType:2},hasMain:!0,shaderSource:`void main() {
                    vec4 v = ${e.texture2D}(X, TexCoords);
                    ${e.output} = v;
                }`};let i=n.length;if(i<2)throw new Error(`output dimension should be at least 2, but got ${i}`);let u=n[i-2],l=n[i-1],f=t[0].dims;if(i!==f.length)throw new Error(`output dimension should match input ${f.length}, but got ${i}`);let p=f[i-2],d=f[i-1],T=r[i-2],O=r[i-1],v="";if(o.mode!=="linear")throw new Error(`resize (packed) does not support mode: '${o.mode}'`);switch(o.coordinateTransformMode){case"asymmetric":v=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        return vec4(coords) / scaleWHWH;
                    }
                `;break;case"half_pixel":v=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        return (vec4(coords) + 0.5) / scaleWHWH - 0.5;
                    }
                `;break;case"pytorch_half_pixel":v=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        vec4 fcoords = vec4(coords);
                        return vec4(
                            ${l}.0 > 1.0 ? (fcoords.x + 0.5) / scaleWHWH.x - 0.5 : 0.0,
                            ${u}.0 > 1.0 ? (fcoords.y + 0.5) / scaleWHWH.y - 0.5 : 0.0,
                            ${l}.0 > 1.0 ? (fcoords.z + 0.5) / scaleWHWH.z - 0.5 : 0.0,
                            ${u}.0 > 1.0 ? (fcoords.w + 0.5) / scaleWHWH.w - 0.5 : 0.0
                          );
                    }
                `;break;case"align_corners":v=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        vec4 resized = vec4(${l}.0 - 1.0, ${u}.0 - 1.0, ${l}.0 - 1.0,
                            ${u}.0 - 1.0);
                        vec4 original = vec4(${d}.0 - 1.0, ${p}.0 - 1.0, ${d}.0 - 1.0,
                            ${p}.0 - 1.0);
                        vec4 new_scale = original / resized;
                        return vec4(coords) * new_scale;
                    }
                `;break;default:throw new Error(`resize (packed) does not support coordinateTransformMode:                                 '${o.coordinateTransformMode}'`)}let S=Ke(i),E=$t(),F=`
            const vec2 inputWH = vec2(${p}.0, ${d}.0);
            const vec4 scaleWHWH = vec4(float(${T}), float(${O}), float(${T}), float(${O}));
            ${E}
            ${v}
            float getAValue(int x10, int r, int c, int d) {
                return getChannel(getA(x10, r, c, d), vec2(c, d));
            }
            void main() {
                ${S} rc = getOutputCoords();

                int batch = rc[0];
                int depth = rc[1];

                // retrieve the 4 coordinates that is used in the 4 packed output values.
                ivec4 coords = ivec4(rc.wz, rc.w + 1, rc.z + 1);

                // calculate the source index in fraction
                vec4 sourceFrac = getSourceFracIndex(coords);

                // get the lower and upper bound of the 4 values that will be packed into one texel.
                ivec4 x00 = ivec4(max(sourceFrac.xy, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.xy)));
                ivec4 x01 = ivec4(max(sourceFrac.xw, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.xw)));
                ivec4 x10 = ivec4(max(sourceFrac.zy, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.zy)));
                ivec4 x11 = ivec4(max(sourceFrac.zw, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.zw)));

                bool hasNextRow = rc.w < ${u-1};
                bool hasNextCol = rc.z < ${l-1};

                // pack x00, x01, x10, x11's top-left corner into one vec4 structure
                vec4 topLeft = vec4(
                    getAValue(batch, depth, x00.x, x00.y),
                    hasNextCol ? getAValue(batch, depth, x01.x, x01.y) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.x, x10.y) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.x, x11.y) : 0.0);

                // pack x00, x01, x10, x11's top-right corner into one vec4 structure
                vec4 topRight = vec4(
                    getAValue(batch, depth, x00.x, x00.w),
                    hasNextCol ? getAValue(batch, depth, x01.x, x01.w) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.x, x10.w) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.x, x11.w) : 0.0);

                // pack x00, x01, x10, x11's bottom-left corner into one vec4 structure
                vec4 bottomLeft = vec4(
                    getAValue(batch, depth, x00.z, x00.y),
                    hasNextCol ? getAValue(batch, depth, x01.z, x01.y) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.z, x10.y) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.z, x11.y) : 0.0);

                // pack x00, x01, x10, x11's bottom-right corner into one vec4 structure
                vec4 bottomRight = vec4(
                    getAValue(batch, depth, x00.z, x00.w),
                    hasNextCol ? getAValue(batch, depth, x01.z, x01.w) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.z, x10.w) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.z, x11.w) : 0.0);

                // calculate the interpolation fraction on u and v direction
                vec4 frac = vec4(sourceFrac) - floor(sourceFrac);
                vec4 clampFrac = clamp(frac, vec4(0.0), vec4(1.0));

                vec4 top = mix(topLeft, topRight, clampFrac.ywyw);
                vec4 bottom = mix(bottomLeft, bottomRight, clampFrac.ywyw);
                vec4 newValue = mix(top, bottom, clampFrac.xxzz);

                ${e.output} = vec4(newValue);
            }
        `;return{...Ui,output:{dims:n,type:t[0].type,textureType:2},hasMain:!0,shaderSource:F}},xb=(a,t)=>{let e=a[0].dims,r=t.scales,n;if(r.length===0){let i=a[t.scalesInputIdx];if(i&&i.size!==0){if(a[t.sizesInputIdx])throw new Error("Only one of scales or sizes must be provided as input.");r=vb(i,t.mode,t.isResize)}else{let u=a[t.sizesInputIdx];if(!u||u.size===0)throw new Error("Either scales or sizes MUST be provided as input.");n=Array.from(u.integerData),r=wb(n,e,t.mode,t.isResize)}}else if(a[t.sizesInputIdx])throw new Error("Only one of scales or sizes must be provided as input.");let s=n||e.map((i,u)=>Math.floor(i*r[u]));return[r,s]},vb=(a,t,o)=>{let e=Array.from(a.floatData);return lo(e,t,o),e},wb=(a,t,o,e)=>{let r=t.length,n=new Array(r);for(let s=0,i=r;s<i;s++)if(t[s]===0){if(a[s]!==0)throw new Error("Input dim is zero but required output dim is non-zero.");n[s]=1}else n[s]=a[s]/t[s];return lo(n,o,e),n}});var yc,_b,Tc=L(()=>{"use strict";br();yc=(a,t)=>(_b(t),[new Fe([t[0].dims.length],"int32",void 0,void 0,new Int32Array(t[0].dims))]),_b=a=>{if(!a||a.length!==1)throw new Error("Shape requires 1 input.")}});var Vi,xc,vc,wc,Ob,_c,Ib,Sb,Oc=L(()=>{"use strict";Ge();pn();fe();ae();Vi={name:"Slice",inputNames:["A"],inputTypes:[0]},xc=(a,t,o)=>(Ob(t),[a.run({...Vi,cacheHint:o.cacheKey,get:()=>wc(a,t[0],o)},t)]),vc=a=>{let t=a.attributes.getInts("starts"),o=a.attributes.getInts("ends"),e=a.attributes.getInts("axes",[]);return ee({starts:t,ends:o,axes:e})},wc=(a,t,o)=>{let e=o.axes.length===0?t.dims.slice(0).map((p,d)=>d):o.axes,r=U.normalizeAxes(e,t.dims.length),n=o.starts.map((p,d)=>p>t.dims[r[d]]-1?t.dims[r[d]]:U.normalizeAxis(p,t.dims[r[d]])),s=o.ends.map((p,d)=>p>t.dims[r[d]]-1?t.dims[r[d]]:U.normalizeAxis(p,t.dims[r[d]])),i=t.dims.slice(),u=[];for(let p=0;p<r.length;p++)i[r[p]]=s[p]-n[p],n[p]>0&&u.push(`outputIdx[${r[p]}] += ${n[p]};`);let f=`
      float process(int outputIdx[${i.length}]) {
        ${u.join(`
      `)}
        return _A(outputIdx);
      }`;return{...Vi,output:{dims:i,type:t.type,textureType:0},shaderSource:f}},Ob=a=>{if(!a||a.length!==1)throw new Error("Slice requires 1 input.");if(tr.indexOf(a[0].type)===-1)throw new Error("Invalid input type.")},_c=(a,t)=>{Sb(t);let o=Ib(a,t);return[a.run({...Vi,cacheHint:o.cacheKey,get:()=>wc(a,t[0],o)},[t[0]])]},Ib=(a,t)=>{if(!a.session.isInitializer(t[1].dataId)||!a.session.isInitializer(t[2].dataId)||t.length>=4&&!a.session.isInitializer(t[3].dataId)||t.length>=5&&!a.session.isInitializer(t[4].dataId))throw new Error("dynamic slice attributes are not allowed");if(t.length>=5&&t[4].integerData.some(s=>s!==1))throw new Error("currently non-1 steps is not supported for Slice");let o=Array.from(t[1].integerData),e=Array.from(t[2].integerData),r=t.length>=4?Array.from(t[3].integerData):[],n=`${r};${o};${e}`;return{starts:o,ends:e,axes:r,cacheKey:n}},Sb=a=>{if(!a||a.length<3||a.length>5)throw new Error("Invalid input number.");if(a[1].type!=="int32"||a[1].dims.length!==1)throw new Error("Invalid input type.");if(a[2].type!=="int32"||a[2].dims.length!==1)throw new Error("Invalid input type.");if(a.length>=4&&(a[3].type!=="int32"||a[3].dims.length!==1))throw new Error("Invalid input type.");if(a.length>=5&&(a[4].type!=="int32"||a[4].dims.length!==1))throw new Error("Invalid input type.")}});var Ic,Sc,Ac,Pc,Ec,Dc,Lc,Fc,Ab,Pb,Eb,$c,Cc=L(()=>{"use strict";Ge();fe();xe();ae();ao();Ic={name:"SoftmaxComputeMax",inputNames:["A"],inputTypes:[0]},Sc={name:"SoftmaxComputeScale",inputNames:["A","Max"],inputTypes:[0,0]},Ac={name:"SoftMax",inputNames:["A","Max","Norm"],inputTypes:[0,0,0]},Pc=(a,t,o)=>{$c(t);let e=t[0].dims.slice(),r=U.normalizeAxis(o.axis,e.length),n=U.sizeToDimension(e,r),s=U.sizeFromDimension(e,r);return Fc(a,t,o,n,s)},Ec=a=>ee({axis:a.attributes.getInt("axis",1)}),Dc=a=>ee({axis:a.attributes.getInt("axis",-1)}),Lc=(a,t,o)=>{$c(t);let e=t[0].dims.slice(),r=U.normalizeAxis(o.axis,e.length),n=e.length,s=r!==n-1,i=[],u=[],l=[],f;s&&(u=Array.from({length:n}).map((O,v)=>v),u[r]=n-1,u[n-1]=r,u.map(O=>i.push(e[O])),f=ee({perm:u}),l=Tr(a,t,f));let p=s?U.sizeToDimension(i,n-1):U.sizeToDimension(e,n-1),d=s?U.sizeFromDimension(i,n-1):U.sizeFromDimension(e,n-1),T=Fc(a,s?l:t,o,p,d);return s?Tr(a,T,f):T},Fc=(a,t,o,e,r)=>{let n=Ab(a,t[0],e,r,[e]),s=a.run({...Ic,cacheHint:o.cacheKey,get:()=>n},t),i=Pb(a,t[0],e,r,n.output.dims,[e]),u=a.run({...Sc,cacheHint:o.cacheKey,get:()=>i},[t[0],s]),l=Eb(a,t[0],e,r,n.output.dims,i.output.dims);return[a.run({...Ac,cacheHint:o.cacheKey,get:()=>l},[t[0],s,u])]},Ab=(a,t,o,e,r)=>{let[n,s]=a.calculateTextureWidthAndHeight(t.dims,0),i=r.length;if(o<1||e<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(r.length!==1)throw new Error("Dimensionality of the output should be 1");if(r[0]!==o)throw new Error("Shape of the output should be equal to logical row count");let u=q(a.session.backend.glContext.version),l=`
      float process(int[${i}] indices) {
        int logical_row_start_offset = indices[0] * ${e};

        float max = getColorAsFloat(${u.texture2D}(A, offsetToCoords(logical_row_start_offset, ${n},
        ${s} )));
        for(int i=1; i<${e}; ++i)
        {
          float current = getColorAsFloat(${u.texture2D}(A, offsetToCoords(logical_row_start_offset + i,
            ${n}, ${s})));
          if(current > max)
          max = current;
        }

        return max;
      }`;return{...Ic,output:{dims:r,type:t.type,textureType:0},shaderSource:l}},Pb=(a,t,o,e,r,n)=>{let[s,i]=a.calculateTextureWidthAndHeight(t.dims,0),u=n.length;if(o<1||e<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(n.length!==1)throw new Error("Dimensionality of the output should be 1");if(n[0]!==o)throw new Error("Shape of the output should be equal to logical row count");if(r.length!==1)throw new Error("Dimensionality of the intermediate results should be 1");if(r[0]!==o)throw new Error("Shape of the intermediate results should be equal to logical row count");let l=q(a.session.backend.glContext.version),f=`
      float process(int[${u}] indices) {
        int logical_row_start_offset = indices[0] * ${e};

        float norm_factor = 0.0;
        float max = _Max(indices);
        for(int i=0; i<${e}; ++i)
        {
          norm_factor += exp(getColorAsFloat(${l.texture2D}(A, offsetToCoords(logical_row_start_offset + i,
            ${s}, ${i}))) - max);
        }

        return norm_factor;
      }`;return{...Sc,output:{dims:n,type:t.type,textureType:0},shaderSource:f}},Eb=(a,t,o,e,r,n)=>{let[s,i]=a.calculateTextureWidthAndHeight(t.dims,0),u=t.dims.length;if(o<1||e<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(r.length!==1||n.length!==1)throw new Error("Dimensionality of the intermediate results should be 1");if(r[0]!==o||n[0]!==o)throw new Error("Shape of the intermediate results should be equal to logical row count");let l=`
      float process(int[${u}] indices) {

      // get offset of current logical tensor index from the 2-D texture coordinates (TexCoords)
      int offset = coordsToOffset(TexCoords, ${s}, ${i});

      //determine the logical row for this index
      int logical_row_index[1];
      logical_row_index[0] = offset / ${e};

      float norm_factor = _Norm(logical_row_index);

      // avoid possible division by 0
      // if norm_facor is 0, all elements are zero
      // if so, return 0
      if(norm_factor == 0.0)
        return 0.0;

      return exp(_A(indices) - _Max(logical_row_index)) / norm_factor;
    }`;return{...Ac,output:{dims:t.dims,type:t.type,textureType:0},shaderSource:l}},$c=a=>{if(!a||a.length!==1)throw new Error("Softmax requires 1 input.");if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type")}});var kc,Bc,Nc,Db,Lb,Fb,Rc=L(()=>{"use strict";Ge();fe();ae();kc={name:"Split",inputNames:["A"],inputTypes:[0]},Bc=(a,t,o)=>{Fb(t);let e=U.normalizeAxis(o.axis,t[0].dims.length),r=Db(a,t,e,o),n=[];for(let s=0;s<r;++s)n.push(a.run({...kc,cacheHint:`${o.cacheKey};${s}`,get:()=>Lb(a,t[0],o,e,s)},t));return n},Nc=a=>{let t=a.attributes.getInt("axis",0),o=a.attributes.getInts("split",[]),e=a.outputs.length;return ee({axis:t,split:o,numOutputs:e})},Db=(a,t,o,e)=>{let[,r]=an.splitShape(t[0].dims,o,e.split,e.numOutputs);return r.length},Lb=(a,t,o,e,r)=>{let[n,s]=an.splitShape(t.dims,e,o.split,o.numOutputs),i=s[r],u=n[r],f=`
      float process(int indices[${u.length}]) {
        indices[${e}] += ${i};
        return _A(indices);
      }
    `;return{...kc,cacheHint:`${o.cacheKey}:${r}`,output:{dims:u,type:t.type,textureType:0},shaderSource:f}},Fb=a=>{if(!a||a.length!==1)throw new Error("Split requires one input.");if(a[0].type!=="int8"&&a[0].type!=="uint8"&&a[0].type!=="int16"&&a[0].type!=="uint16"&&a[0].type!=="int32"&&a[0].type!=="uint32"&&a[0].type!=="float32"&&a[0].type!=="float64"&&a[0].type!=="bool")throw new Error("Invalid input type.")}});var Wi,Mc,Gc,$b,Cb,Uc=L(()=>{"use strict";fe();Wi=(a,t,o)=>{$b(t);let e=U.squeezeShape(t[0].dims,o);return[a.reshapeUnpacked(t[0],e)]},Mc=(a,t)=>(Cb(t),Wi(a,[t[0]],Array.from(t[1].integerData))),Gc=a=>a.attributes.getInts("axes"),$b=a=>{if(!a||a.length!==1)throw new Error("Squeeze requires 1 input.");if(a[0].type==="string")throw new Error("invalid input tensor types.")},Cb=a=>{if(!a||a.length!==2)throw new Error("Squeeze requires 2 inputs.");if(a[1].type!=="int32")throw new Error("Invalid input type.")}});var zc,kb,Bb,Vc=L(()=>{"use strict";xe();ae();zc=(a,t)=>{Bb(t);let o={name:"Sum",inputNames:t.map((r,n)=>`X${n}`),inputTypes:new Array(t.length).fill(0)};return[a.run({...o,get:()=>kb(a,t,o)},t)]},kb=(a,t,o)=>{let e=q(a.session.backend.glContext.version),r=t[0].dims.slice(),s=`
      void main() {
        vec4 result = ${t.map((i,u)=>`${e.texture2D}(X${u},TexCoords)`).join(" + ")};
        ${e.output} = result;
      }
    `;return{...o,output:{dims:r,type:t[0].type,textureType:0},hasMain:!0,shaderSource:s}},Bb=a=>{if(!a||a.length===0)throw new Error("Sum requires inputs.");let t=a[0].dims.length;for(let o=1;o<a.length;o++){if(t!==a[o].dims.length)throw new Error("Input shapes are mismatched.");for(let e=0;e<t;e++)if(a[0].dims[e]!==a[o].dims[e])throw new Error("Input shapes are not matched.")}if(a[0].type!=="float32"&&a[0].type!=="float64")throw new Error("Invalid input type.");for(let o=1;o<a.length;o++)if(a[0].type!==a[o].type)throw new Error("Input types are not matched.")}});var Wc,Nb,Rb,Hc=L(()=>{"use strict";pn();ae();Wc=(a,t)=>{Rb(t);let o={name:"Tile",inputNames:["A"],inputTypes:[0]};return[a.run({...o,get:()=>Nb(a,t,o)},t)]},Nb=(a,t,o)=>{let e=t[0].dims.slice(),r=new Array(e.length),n=[];for(let u=0;u<e.length;u++)r[u]=e[u]*t[1].numberData[u],n.push(`inputIdx[${u}] = int(mod(float(outputIdx[${u}]), ${e[u]}.));`);let s=r.length,i=`
      float process(int outputIdx[${s}]) {
        int inputIdx[${s}];
        ${n.join(`
`)}
        return _A(inputIdx);
      }
    `;return{...o,output:{dims:r,type:t[0].type,textureType:0},shaderSource:i}},Rb=a=>{if(!a||a.length!==2)throw new Error("Tile requires 2 input.");if(a[1].dims.length!==1)throw new Error("The second input shape must 1 dimension.");if(a[1].dims[0]!==a[0].dims.length)throw new Error("Invalid input shape.");if(tr.indexOf(a[0].type)===-1)throw new Error("Invalid input type.");if(a[1].type!=="int32"&&a[1].type!=="int16")throw new Error("Invalid repeat type.")}});var Hi,qc,jc,Mb,Gb,Yc=L(()=>{"use strict";fe();Hi=(a,t,o)=>{Mb(t);let e=U.unsqueezeShape(t[0].dims,o);return[a.reshapeUnpacked(t[0],e)]},qc=(a,t)=>(Gb(t),Hi(a,[t[0]],Array.from(t[1].integerData))),jc=a=>a.attributes.getInts("axes"),Mb=a=>{if(!a||a.length!==1)throw new Error("Unsqueeze requires 1 input.");if(a[0].type==="string")throw new Error("invalid input tensor types.")},Gb=a=>{if(!a||a.length!==2)throw new Error("Unsqueeze requires 2 inputs.");if(a[1].type!=="int32")throw new Error("Invalid input type.")}});var Xc,Kc=L(()=>{"use strict";il();yl();vl();Al();no();cf();gf();xf();_f();Af();Df();Cf();Rf();oo();zf();tc();lc();cc();gc();Tc();Oc();Cc();Rc();Uc();Vc();Hc();ao();Pi();Yc();Gi();Xc=[["Abs","","6+",Pl],["Acos","","7+",El],["Add","","7+",al],["And","","7+",sl],["Asin","","7+",Dl],["Atan","","7+",Ll],["AveragePool","","7+",Wf,Hf],["BatchNormalization","","7+",nl,ol],["Cast","","6+",Tl,xl],["Ceil","","6+",Cl],["Clip","","6-10",Si,Fl],["Clip","","11+",$l],["Concat","","4+",Ol,Sl],["Conv","","1+",Ci,ki],["ConvTranspose","","1+",lf,ff],["Cos","","7+",kl],["Div","","7+",ul],["Dropout","","7+",Ai],["DepthToSpace","","1+",mf,bf],["Equal","","7+",ll],["Elu","","6+",Bl,Nl],["Exp","","6+",Rl],["Flatten","","1+",yf,Tf],["Floor","","6+",Ml],["FusedConv","com.microsoft","1+",Ci,ki],["Gather","","1+",vf,wf],["Gemm","","7-10",Bi,If],["Gemm","","11+",Bi,Sf],["GlobalAveragePool","","1+",jf,Yf],["GlobalMaxPool","","1+",Qf],["Greater","","7+",fl],["Identity","","1+",Ai],["ImageScaler","","1+",Pf,Ef],["InstanceNormalization","","6+",Ff,$f],["LeakyRelu","","6+",Gl,Ul],["Less","","7+",cl],["LRN","","1+",kf,Bf],["Log","","6+",zl],["MatMul","","1+",tf,rf],["MaxPool","","1+",Xf,Kf],["Mul","","7+",pl],["Neg","","6+",Vl],["Not","","1+",Wl],["Or","","7+",dl],["Pad","","2-10",Ni,Mf],["Pad","","11+",Gf,Uf],["Pow","","7+",hl],["PRelu","","7+",ml],["ReduceLogSum","","1+",sc,rr],["ReduceMax","","1+",oc,rr],["ReduceMean","","1+",nc,rr],["ReduceMin","","1+",ic,rr],["ReduceProd","","1+",ac,rr],["ReduceSum","","1-12",rc,rr],["ReduceSumSquare","","1+",uc,rr],["Relu","","6+",Hl],["Reshape","","5+",fc],["Resize","","10",zi,mc],["Resize","","11+",zi,bc],["Shape","","1+",yc],["Sigmoid","","6+",ql],["Sin","","7+",jl],["Slice","","10+",_c],["Slice","","1-9",xc,vc],["Softmax","","1-12",Pc,Ec],["Softmax","","13+",Lc,Dc],["Split","","2-12",Bc,Nc],["Sqrt","","6+",Yl],["Squeeze","","1-12",Wi,Gc],["Squeeze","","13+",Mc],["Sub","","7+",bl],["Sum","","6+",zc],["Tan","","7+",Xl],["Tanh","","6+",Kl],["Tile","","6+",Wc],["Transpose","","1+",Tr,df],["Upsample","","7-8",Ri,dc],["Upsample","","9",Ri,hc],["Unsqueeze","","1-12",Hi,jc],["Unsqueeze","","13+",qc],["Xor","","7+",gl]]});function Zc(a){let t={},o;for(;(o=Jc.exec(a))!==null;){let e=o[3].split(",").map(r=>{let n=r.trim().split(" ");return n&&n.length===2?{type:n[0],name:n[1]}:null}).filter(r=>r!==null);t[o[2]]={params:e,body:o[4]}}for(let e in t){let r=Ub.replace("__FUNC__",e),n=new RegExp(r,"gm");for(;(o=n.exec(a))!==null;){let s=o[1],i=o[2],u=o[3].split(","),l=s?`${s} ${i};`:"",f=t[e].body,p="";t[e].params.forEach((T,O)=>{T&&(p+=`${T.type} ${T.name} = ${u[O]};
`)}),f=`${p}
 ${f}`,f=f.replace("return",`${i} = `);let d=`
      ${l}
      {
        ${f}
      }
      `;a=a.replace(o[0],d)}}return a=a.replace(Jc,""),a}var Jc,Ub,Qc=L(()=>{"use strict";Jc=/@inline[\s\n\r]+(\w+)[\s\n\r]+([0-9a-zA-Z_]+)\s*\(([^)]*)\)\s*{(([^}]|[\n\r])*)}/gm,Ub="(\\w+)?\\s+([_0-9a-zA-Z]+)\\s+=\\s+__FUNC__\\((.*)\\)\\s*;"});function Gr(a,t){let o=[],e=[],r=t!=null&&Array.isArray(t)&&t.length===0,n=t==null||r?null:zb(t,a).sort(),s=0;for(let i=0;i<a.length;++i){if(n!=null){if(n[s]===i&&a[i]!==1)throw new Error(`Can't squeeze axis ${i} since its dim '${a[i]}' is not 1`);(n[s]==null||n[s]>i)&&a[i]===1&&(o.push(a[i]),e.push(i)),n[s]<=i&&s++}a[i]!==1&&(o.push(a[i]),e.push(i))}return{newShape:o,keptDims:e}}function zb(a,t){let o=t.length;return a=a==null?t.map((e,r)=>r):[].concat(a),Cr(a.every(e=>e>=-o&&e<o),()=>`All values in axis param must be in range [-${o}, ${o}) but got axis ${a}`),Cr(a.every(Vb),()=>`All values in axis param must be integers but got axis ${a}`),a.map(e=>e<0?o+e:e)}function Vb(a){return a%1===0}function Wb(a){if(a.length===0)return 1;let t=a[0];for(let o=1;o<a.length;o++)t*=a[o];return t}function ep(a){let t=Math.ceil(Math.sqrt(a));return[t,Math.ceil(a/t)]}var fo,qi=L(()=>{"use strict";ut();fe();fo=class{constructor(t){this.maxTextureSize=t}computeTextureWH(t,o){let e=this.computeTexture(t,o);return o&&o.isPacked&&(e[0]/=2,e[1]/=2),o&&o.reverseWH?[e[1],e[0]]:e}computeTexture(t,o){let e=o&&o.isPacked;if(t.length===0)return e?[2,2]:[1,1];let r=this.maxTextureSize;if(o&&o.breakAxis!==void 0){let i=o.breakAxis>=t.length?1:t.slice(o.breakAxis).reduce((l,f)=>l*f),u=o.breakAxis<=0?1:t.slice(0,o.breakAxis).reduce((l,f)=>l*f);if(i>r||u>r)ce.verbose("TextureLayout",`Given width/height preferences were unattainable: shape:${t}, breakAxis:${o.breakAxis}`);else return[i,u]}let n=t.slice(0);e&&(r=r*2,n=n.map((i,u)=>u>=n.length-2?n[u]%2===0?n[u]:n[u]+1:n[u]),n.length===1&&(n=[2,n[0]])),n.length!==2&&(n=Gr(n).newShape);let s=Wb(n);return n.length<=1&&s<=r?[1,s]:n.length===2&&n[0]<=r&&n[1]<=r?n:n.length===3&&n[0]*n[1]<=r&&n[2]<=r?[n[0]*n[1],n[2]]:n.length===3&&n[0]<=r&&n[1]*n[2]<=r?[n[0],n[1]*n[2]]:n.length===4&&n[0]*n[1]*n[2]<=r&&n[3]<=r?[n[0]*n[1]*n[2],n[3]]:n.length===4&&n[0]<=r&&n[1]*n[2]*n[3]<=r?[n[0],n[1]*n[2]*n[3]]:e?ep(s/4).map(i=>i*2):ep(s)}}});var co,tp=L(()=>{"use strict";fe();Vt();xe();qi();Ft();co=class extends pt{constructor(o){super(o)}getFunctions(){return{...this.offsetToCoords(),...this.coordsToOffset(),...this.toVec(),...this.valueFrom(),...this.getCommonUtilFuncs(),...this.getInputsSamplingSnippets(),...this.getOutputSamplingSnippet()}}getCustomTypes(){return{}}offsetToCoords(){let o="offsetToCoords";return{offsetToCoords:new R(`
      vec2 ${o}(int offset, int width, int height) {
        int t = offset / width;
        int s = offset - t*width;
        vec2 coords = (vec2(s,t) + vec2(0.5,0.5)) / vec2(width, height);
        return coords;
      }
      `)}}coordsToOffset(){let o="coordsToOffset";return{coordsToOffset:new R(`
      int ${o}(vec2 coords, int width, int height) {
        float s = coords.s * float(width);
        float t = coords.t * float(height);
        int offset = int(t) * width + int(s);
        return offset;
      }
      `)}}getOutputSamplingSnippet(){let o=this.context.outputTextureLayout;return o.isPacked?this.getPackedOutputSamplingSnippet(o):this.getUnpackedOutputSamplingSnippet(o)}getPackedOutputSamplingSnippet(o){let e=o.unpackedShape,r=[o.width,o.height],n={},s="getOutputCoords";switch(e.length){case 0:n[s]=this.getOutputScalarCoords();break;case 1:n[s]=this.getOutputPacked1DCoords(e,r);break;case 2:n[s]=this.getOutputPacked2DCoords(e,r);break;case 3:n[s]=this.getOutputPacked3DCoords(e,r);break;default:n[s]=this.getOutputPackedNDCoords(e,r)}let u=`
      void setOutput(vec4 val) {
        ${q(this.context.glContext.version).output} = val;
      }
    `,l="floatTextureSetRGBA";return n[l]=new R(u),n}getUnpackedOutputSamplingSnippet(o){let e=o.unpackedShape,r=[o.width,o.height],n={},s="getOutputCoords";switch(e.length){case 0:n[s]=this.getOutputScalarCoords();break;case 1:n[s]=this.getOutputUnpacked1DCoords(e,r);break;case 2:n[s]=this.getOutputUnpacked2DCoords(e,r);break;case 3:n[s]=this.getOutputUnpacked3DCoords(e,r);break;case 4:n[s]=this.getOutputUnpacked4DCoords(e,r);break;case 5:n[s]=this.getOutputUnpacked5DCoords(e,r);break;case 6:n[s]=this.getOutputUnpacked6DCoords(e,r);break;default:throw new Error(`Unsupported output dimensionality: ${e.length}`)}let u=`
        void setOutput(float val) {
          ${q(this.context.glContext.version).output} = vec4(val, 0, 0, 0);
        }
    `,l="floatTextureSetR";return n[l]=new R(u),n}getOutputScalarCoords(){return new R(`
      int getOutputCoords() {
        return 0;
      }
    `)}getOutputPacked1DCoords(o,e){let r=e,n="";return r[0]===1?(n=`
          int getOutputCoords() {
            return 2 * int(TexCoords.y * ${r[1]}.0);
          }
        `,new R(n)):r[1]===1?(n=`
          int getOutputCoords() {
            return 2 * int(TexCoords.x * ${r[0]}.0);
          }
        `,new R(n)):(n=`
        int getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                 vec2(${r[0]}, ${r[1]}));
          return 2 * (resTexRC.y * ${r[0]} + resTexRC.x);
        }
      `,new R(n))}getOutputPacked2DCoords(o,e){let r="";if(pr.arraysEqual(o,e))return r=`
        ivec2 getOutputCoords() {
          return 2 * ivec2(TexCoords.xy * vec2(${e[0]}, ${e[1]}));
        }
      `,new R(r);let n=e,s=Math.ceil(o[1]/2);return r=`
        ivec2 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${n[0]}, ${n[1]}));

          int index = resTexRC.y * ${n[0]} + resTexRC.x;

          // reverse r and c order for packed texture
          int r = imod(index, ${s}) * 2;
          int c = 2 * (index / ${s});

          return ivec2(r, c);
        }
      `,new R(r)}getOutputPacked3DCoords(o,e){let r=[e[0],e[1]],n=Math.ceil(o[2]/2),s=n*Math.ceil(o[1]/2),i=`
        ivec3 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${r[0]}, ${r[1]}));
          int index = resTexRC.y * ${r[0]} + resTexRC.x;

          int b = index / ${s};
          index -= b * ${s};

          // reverse r and c order for packed texture
          int r = imod(index, ${n}) * 2;
          int c = 2 * (index / ${n});

          return ivec3(b, r, c);
        }
      `;return new R(i)}getOutputPackedNDCoords(o,e){let r=[e[0],e[1]],n=Math.ceil(o[o.length-1]/2),s=n*Math.ceil(o[o.length-2]/2),i=s,u="",l="b, r, c";for(let p=2;p<o.length-1;p++)i*=o[o.length-p-1],u=`
      int b${p} = index / ${i};
      index -= b${p} * ${i};
    `+u,l=`b${p}, `+l;let f=`
      ivec${o.length} getOutputCoords() {
        ivec2 resTexRC = ivec2(TexCoords.xy *
                              vec2(${r[0]}, ${r[1]}));
        int index = resTexRC.y * ${r[0]} + resTexRC.x;

        ${u}

        int b = index / ${s};
        index -= b * ${s};

        // reverse r and c order for packed texture
        int r = imod(index, ${n}) * 2;
        int c = 2 * (index / ${n});

        return ivec${o.length}(${l});
      }
    `;return new R(f)}getOutputUnpacked1DCoords(o,e){let r=`
        int getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${e[0]}, ${e[1]}));
          return resTexRC.y * ${e[0]} + resTexRC.x;
        }
      `;return new R(r)}getOutputUnpacked2DCoords(o,e){let r=`
        ivec2 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${e[0]}, ${e[1]}));
          int index = resTexRC.y * ${e[0]} + resTexRC.x;
          int r = index / ${o[1]};
          int c = index - r * ${o[1]};
          return ivec2(r, c);
        }
      `;return new R(r)}getOutputUnpacked3DCoords(o,e){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
        ivec3 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${e[0]}, ${e[1]}));
          int index = resTexRC.y * ${e[0]} + resTexRC.x;
          ${u}
          return ivec3(r, c, d);
        }
      `,new R(r)}getOutputUnpacked4DCoords(o,e){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d","d2"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
      ivec4 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${e[0]}, ${e[1]}));
          int index = resTexRC.y * ${e[0]} + resTexRC.x;
          ${u}
          return ivec4(r, c, d, d2);
        }
      `,new R(r)}getOutputUnpacked5DCoords(o,e){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d","d2","d3"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
      ivec5 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${e[0]}, ${e[1]}));
          int index = resTexRC.y * ${e[0]} + resTexRC.x;
          ${u}
          return ivec5(r, c, d, d2, d3);
        }
      `,new R(r)}getOutputUnpacked6DCoords(o,e){let r="",n=o.length,s=null;n<2&&(s=[]),s=new Array(n-1),s[n-2]=o[n-1];for(let l=n-3;l>=0;--l)s[l]=s[l+1]*o[l+1];let i=["r","c","d","d2","d3","d4"],u=s.map((l,f)=>{let p=`int ${i[f]} = index / ${l}`,d=f===s.length-1?`int ${i[f+1]} = index - ${i[f]} * ${l}`:`index -= ${i[f]} * ${l}`;return`${p}; ${d};`}).join("");return r=`
     ivec6 getOutputCoords() {
         ivec2 resTexRC = ivec2(TexCoords.xy *
                               vec2(${e[0]}, ${e[1]}));
         int index = resTexRC.y * ${e[0]} + resTexRC.x;
         ${u}
         return ivec6(r, c, d, d2, d3, d4);
       }
     `,new R(r)}getCommonUtilFuncs(){let o={},e="uvFromFlat";o[e]=new R(`
    vec2 uvFromFlat(int texNumR, int texNumC, int index) {
      int texC = index / texNumR;
      int texR = index - texC * texNumR;
      // TODO: swap texR, texC order in following function so row is corresponding to u and column is corresponding to
      //       v.
      return (vec2(texR, texC) + halfCR) / vec2(texNumR, texNumC);
    }
    `),e="packedUVfrom1D",o[e]=new R(`
      vec2 packedUVfrom1D(int texNumR, int texNumC, int index) {
        int texelIndex = index / 2;
        int texR = texelIndex / texNumC;
        int texC = texelIndex - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),e="packedUVfrom2D",o[e]=new R(`
      vec2 packedUVfrom2D(int texNumR, int texNumC, int texelsInLogicalRow, int row, int col) {
        int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);
        int texR = texelIndex / texNumC;
        int texC = texelIndex - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),e="packedUVfrom3D",o[e]=new R(`
      vec2 packedUVfrom3D(int texNumR, int texNumC,
          int texelsInBatch, int texelsInLogicalRow, int b,
          int row, int col) {
        int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);
        int texR = index / texNumC;
        int texC = index - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),e="sampleTexture";let r=q(this.context.glContext.version);return o[e]=new R(`
        float sampleTexture(sampler2D textureSampler, vec2 uv) {
            return ${r.texture2D}(textureSampler, uv).r;
        }`),o}getInputsSamplingSnippets(){let o={},e=this.context.outputTextureLayout;return this.context.programInfo.inputNames.forEach((r,n)=>{let s=this.context.inputTextureLayouts[n],i=Kn(r);s.isPacked?o[i]=this.getPackedSamplerFromInput(i,r,s):o[i]=this.getUnpackedSamplerFromInput(i,r,s);let u=Uu(r);s.unpackedShape.length<=e.unpackedShape.length&&(s.isPacked?o[u]=this.getPackedSamplerAtOutputCoords(u,s,e,r):o[u]=this.getUnpackedSamplerAtOutputCoords(u,s,e,r))}),o}getPackedSamplerAtOutputCoords(o,e,r,n){let s=e.unpackedShape,i=r.unpackedShape,l=Kn(n),f=s.length,p=i.length,d=Xe.getBroadcastDims(s,i),T=Ke(p),O=p-f,v,S=St();f===0?v="":p<2&&d.length>=1?v="coords = 0;":v=d.map(He=>`coords.${S[He+O]} = 0;`).join(`
`);let E="";p<2&&f>0?E="coords":E=s.map((He,it)=>`coords.${S[it+O]}`).join(", ");let F="return outputValue;",K=U.size(s)===1,M=U.size(i)===1;if(f===1&&!K&&!M)F=`
        return vec4(outputValue.xy, outputValue.xy);
      `;else if(K&&!M)p===1?F=`
          return vec4(outputValue.x, outputValue.x, 0., 0.);
        `:F=`
          return vec4(outputValue.x);
        `;else if(d.length){let He=f-2,it=f-1;d.indexOf(He)>-1&&d.indexOf(it)>-1?F="return vec4(outputValue.x);":d.indexOf(He)>-1?F="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":d.indexOf(it)>-1&&(F="return vec4(outputValue.xx, outputValue.zz);")}let ie=`
        int lastDim = coords.${S[p-1]};
        coords.${S[p-1]} = coords.${S[p-2]};
        coords.${S[p-2]} = lastDim;
      `,$e=`
      vec4 ${o}() {
        ${T} coords = getOutputCoords();
        ${ie}
        ${v}
        vec4 outputValue = ${l}(${E});
        ${F}
      }
    `;return new R($e,["coordinates.getOutputCoords"])}getUnpackedSamplerAtOutputCoords(o,e,r,n){let s=[r.width,r.height],i=[e.width,e.height],u=e.unpackedShape.length,l=r.unpackedShape.length,f=e.unpackedShape,p=r.unpackedShape,d=Kn(n);if(u===l&&pr.arraysEqual(i,s)){let K=`
          float ${o}() {
            return sampleTexture(${n}, TexCoords);
          }
        `;return new R(K,["coordinates.sampleTexture"])}let T=Ke(l),O=Xe.getBroadcastDims(f,p),v=l-u,S,E=St();u===0?S="":l<2&&O.length>=1?S="coords = 0;":S=O.map(K=>`coords.${E[K+v]} = 0;`).join(`
`);let F="";l<2&&u>0?F="coords":F=e.unpackedShape.map((K,j)=>`coords.${E[j+v]}`).join(", ");let B=`
        float ${o}() {
          ${T} coords = getOutputCoords();
          ${S}
          return ${d}(${F});
        }
      `;return new R(B,["coordinates.getOutputCoords"])}getPackedSamplerFromInput(o,e,r){switch(r.unpackedShape.length){case 0:return this.getPackedSamplerScalar(o,e);case 1:return this.getPackedSampler1D(o,e,r);case 2:return this.getPackedSampler2D(o,e,r);case 3:return this.getPackedSampler3D(o,e,r);default:return this.getPackedSamplerND(o,e,r)}}getUnpackedSamplerFromInput(o,e,r){let n=r.unpackedShape;switch(n.length){case 0:return this.getUnpackedSamplerScalar(o,e,r);case 1:return this.getUnpackedSampler1D(o,e,r);case 2:return this.getUnpackedSampler2D(o,e,r);case 3:return this.getUnpackedSampler3D(o,e,r);case 4:return this.getUnpackedSampler4D(o,e,r);case 5:return this.getUnpackedSampler5D(o,e,r);case 6:return this.getUnpackedSampler6D(o,e,r);default:throw new Error(`Unsupported dimension ${n.length}-D`)}}getPackedSamplerScalar(o,e){let r=q(this.context.glContext.version),n=`
          vec4 ${o}() {
            return ${r.texture2D}(${e}, halfCR);
          }
        `;return new R(n)}getPackedSampler1D(o,e,r){let n=[r.width,r.height],s=[n[1],n[0]],i=q(this.context.glContext.version),l=`vec4 ${o}(int index) {
      vec2 uv = packedUVfrom1D(
      ${s[0]}, ${s[1]}, index);
      return ${i.texture2D}(${e}, uv);
    }`;return new R(l,["coordinates.packedUVfrom1D"])}getPackedSampler2D(o,e,r){let n=r.unpackedShape,s=[r.width,r.height],i=q(this.context.glContext.version),u=s[0],l=s[1];if(s!=null&&pr.arraysEqual(n,s)){let O=`vec4 ${o}(int row, int col) {
        vec2 uv = (vec2(col, row) + halfCR) / vec2(${l}.0, ${u}.0);
        return ${i.texture2D}(${e}, uv);
      }`;return new R(O)}let f=s,p=Math.ceil(n[1]/2),T=`vec4 ${o}(int row, int col) {
      vec2 uv = packedUVfrom2D(${f[1]}, ${f[0]}, ${p}, row, col);
      return ${i.texture2D}(${e}, uv);
    }`;return new R(T,["coordinates.packedUVfrom2D"])}getPackedSampler3D(o,e,r){let n=r.unpackedShape,s=[r.width,r.height],i=[s[0],s[1]],u=q(this.context.glContext.version);if(n[0]===1){let v=n.slice(1),S=[1,2],E=kr(n,v),F=["b","row","col"],B=JSON.parse(JSON.stringify(r));B.unpackedShape=E;let K=this.getPackedSamplerFromInput(o,e,B),M=`${K.routineBody}
      vec4 ${o}(int b, int row, int col) {
        return ${o}(${Br(F,S)});
      } `;return new R(M,K.dependencies)}let l=i[0],f=i[1],p=Math.ceil(n[2]/2),d=p*Math.ceil(n[1]/2),O=`vec4 ${o}(int b, int row, int col) {
      vec2 uv = packedUVfrom3D(
        ${f}, ${l}, ${d}, ${p}, b, row, col);
      return ${u.texture2D}(${e}, uv);}`;return new R(O,["coordinates.packedUVfrom3D"])}getPackedSamplerND(o,e,r){let n=r.unpackedShape,s=n.length,i=[r.width,r.height],u=q(this.context.glContext.version),l=[i[0],i[1]],f=l[1],p=l[0],d=Math.ceil(n[s-1]/2),T=d*Math.ceil(n[s-2]/2),O="int b, int row, int col",v=`b * ${T} + (row / 2) * ${d} + (col / 2)`;for(let F=2;F<s-1;F++)O=`int b${F}, `+O,T*=n[s-F-1],v=`b${F} * ${T} + `+v;let E=`vec4 ${o}(${O}) {
      int index = ${v};
      int texR = index / ${p};
      int texC = index - texR * ${p};
      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${p}, ${f});
      return ${u.texture2D}(${e}, uv);
    }`;return new R(E)}getUnpackedSamplerScalar(o,e,r){let[n,s]=[r.width,r.height];if(n===1&&s===1){let u=`
          float ${o}() {
            return sampleTexture(${e}, halfCR);
          }
        `;return new R(u,["coordinates.sampleTexture"])}let i=`
        float ${o}() {
          int offset_${e} = coordsToOffset(TexCoords, ${n}, ${s});
          vec2 uv = uvFromFlat(${n}, ${s}, offset_${e});
          return sampleTexture(${e}, uv);
        }
      `;return new R(i,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler1D(o,e,r){let n=r.width,s=r.height;if(s===1&&n===1){let u=`
        float ${o}(int index) {
          return sampleTexture(${e}, halfCR);
        }
      `;return new R(u,["coordinates.sampleTexture"])}if(s===1){let u=`
          float ${o}(int index) {
            vec2 uv = vec2((float(index) + 0.5) / ${n}.0, 0.5);
            return sampleTexture(${e}, uv);
          }
        `;return new R(u,["coordinates.sampleTexture"])}if(n===1){let u=`
          float ${o}(int index) {
            vec2 uv = vec2(0.5, (float(index) + 0.5) / ${s}.0);
            return sampleTexture(${e}, uv);
          }
        `;return new R(u,["coordinates.sampleTexture"])}let i=`
        float ${o}(int index) {
          vec2 uv = uvFromFlat(${n}, ${s}, index);
          return sampleTexture(${e}, uv);
        }
      `;return new R(i,["coordinates.uvFromFlat","coordinates.sampleTexture"])}getUnpackedSampler2D(o,e,r){let n=r.unpackedShape,s=[r.height,r.width];if(s!=null&&pr.arraysEqual(n,s)){let T=s[1],O=s[0],v=`
          float ${o}(int row, int col) {
            vec2 uv = (vec2(row, col) + halfCR) / vec2(${T}.0, ${O}.0);
            return sampleTexture(${e}, uv);
          }
        `;return new R(v,["coordinates.sampleTexture"])}let{newShape:i,keptDims:u}=Gr(n),l=i;if(l.length<n.length){let T=kr(n,l),O=JSON.parse(JSON.stringify(r));O.unpackedShape=T;let v=["col","row"],S=`
          ${this.getUnpackedSamplerFromInput(o,e,O).routineBody}
          float ${o}(int row, int col) {
            return ${o}(${Br(v,u)});
          }
        `;return new R(S,["coordinates.sampleTexture"])}let f=s[1],p=s[0];if(p===1){let T=`
          float ${o}(int row, int col) {
            int offset_${e} = coordsToOffset(TexCoords, ${f}, ${p});
            float index = dot(vec3(row, col, offset_${e}), vec3(${n[1]}, 1, 1));
            vec2 uv = vec2(0.5, (index + 0.5) / ${f}.0);
            return sampleTexture(${e}, uv);
          }
        `;return new R(T,["coordinates.sampleTexture","coordinates.coordsToOffset"])}if(f===1){let T=`
          float ${o}(int row, int col) {
            int offset_${e} = coordsToOffset(TexCoords, ${f}, ${p});
            float index = dot(vec3(row, col, offset_${e}), vec3(${n[1]}, 1, 1));
            vec2 uv = vec2((index + 0.5) / ${p}.0, 0.5);
            return sampleTexture(${e}, uv);
          }
        `;return new R(T,["coordinates.sampleTexture","coordinates.coordsToOffset"])}let d=`
        float ${o}(int row, int col) {
          int index = col * ${n[1]} + row;
          vec2 uv = uvFromFlat(${f}, ${p}, index);
          return sampleTexture(${e}, uv);
        }
      `;return new R(d,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler3D(o,e,r){let n=r.unpackedShape,s=n[1]*n[2],i=n[2],{newShape:u,keptDims:l}=Gr(n),f=u;if(f.length<n.length){let O=kr(n,f),v=["batch","col","row"],S=JSON.parse(JSON.stringify(r));S.unpackedShape=O;let E=this.getUnpackedSamplerFromInput(o,e,S),F=l.reverse(),B=`
          ${E.routineBody}
          float ${o}(int batch, int row, int col) {
            return ${o}(${Br(v,F)});
          }
        `;return new R(B,E.dependencies)}let p=r.width,d=r.height,T=`
          float ${o}(int depth, int row, int col) {
            // Explicitly use integer operations as dot() only works on floats.
            int index = depth * ${s} + col * ${i} + row;
            vec2 uv = uvFromFlat(${p}, ${d}, index);
            return sampleTexture(${e}, uv);
          }
      `;return new R(T,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler4D(o,e,r){let n=r.unpackedShape,s=n[3],i=n[2]*s,u=n[1]*i,l=r.width,f=r.height,p=`
        float ${o}(int row, int col, int depth, int depth2) {
          int index = row * ${u} + col * ${i} +
              depth2 * ${s} + depth;
          vec2 uv = uvFromFlat(${l}, ${f}, index);
          return sampleTexture(${e}, uv);
        }
      `;return new R(p,["coordinates.uvFromFlat","coordinates.sampleTexture"])}getUnpackedSampler5D(o,e,r){let n=r.unpackedShape,s=n[4],i=n[3]*s,u=n[2]*i,l=n[1]*u,{newShape:f,keptDims:p}=Gr(n);if(f.length<n.length){let v=kr(n,f),S=["row","col","depth","depth2","depth3"],E=JSON.parse(JSON.stringify(r));E.unpackedShape=v;let F=`
          ${this.getUnpackedSamplerFromInput(o,e,E).routineBody}
          float ${o}(int row, int col, int depth, int depth2, int depth3) {
            return ${o}(${Br(S,p)});
          }
        `;return new R(F,["coordinates.sampleTexture","coordinates.uvFromFlat"])}let d=r.width,T=r.height,O=`
        float ${o}(int row, int col, int depth, int depth2, int depth3) {
          int index = row * ${l} + col * ${u} + depth * ${i} +
          depth3 * ${s} + depth2;
          vec2 uv = uvFromFlat(${d}, ${T}, index);
          return sampleTexture(${e}, uv);
        }
      `;return new R(O,["coordinates.sampleTexture","coordinates.uvFromFlat"])}getUnpackedSampler6D(o,e,r){let n=r.unpackedShape,s=n[5],i=n[4]*s,u=n[3]*i,l=n[2]*u,f=n[1]*l,{newShape:p,keptDims:d}=Gr(n);if(p.length<n.length){let S=kr(n,p),E=["row","col","depth","depth2","depth3","depth4"],F=JSON.parse(JSON.stringify(r));F.unpackedShape=S;let B=`
            ${this.getUnpackedSamplerFromInput(o,e,F).routineBody}
            float ${o}(int row, int col, int depth,
              int depth2, int depth3, int depth4) {
              return ${o}(${Br(E,d)});
            }
          `;return new R(B,["coordinates.sampleTexture","coordinates.uvFromFlat"])}let T=r.width,O=r.height,v=`
          float ${o}(int row, int col, int depth,
            int depth2, int depth3, int depth4) {
            int index = row * ${f} + col * ${l} + depth * ${u} +
            depth2 * ${i} + depth3 * ${s} + depth4;
            vec2 uv = uvFromFlat(${T}, ${O}, index);
            return sampleTexture(${e}, uv);
          }
        `;return new R(v,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}toVec(){let o=this.context.outputTextureLayout,e=o.shape.length,r=o.strides,n=o.width,s=o.height,i=[];for(let l=0;l<e-1;++l)i.push(`
        c[${l}] = offset / ${r[l]};`),i.push(`
        offset -= c[${l}] * ${r[l]};`);i.push(`
        c[${e-1}] = offset;`);let u=`
      void toVec(vec2 texCoords, out int c[${e}]) {
        int offset = coordsToOffset(texCoords, ${n}, ${s});
        ${i.join("")}
      }
      void toVec(int offset, out int c[${e}]) {
        ${i.join("")}
      }
    `;return{toVec:new R(u,["coordinates.coordsToOffset"])}}valueFrom(){let o={};return this.context.programInfo.inputNames.forEach((e,r)=>{let n=this.context.inputTextureLayouts[r],i=(n.unpackedShape.length>0?n.unpackedShape:n.shape).length,u=`_${e}`;o[u]=new R(this.getValueFromSingle(e,i,n.width,n.height,!1),[`shapeUtils.indicesToOffset${u}`,"coordinates.offsetToCoords","fragcolor.getColorAsFloat"]),u=u+"_T",o[u]=new R(this.getValueFromSingle(e,i,n.width,n.height,!0),[`shapeUtils.indicesToOffset${u}`,"coordinates.offsetToCoords","fragcolor.getColorAsFloat"])}),o}getValueFromSingle(o,e,r,n,s){let i=`_${o}`;s&&(i=i+"_T");let u=q(this.context.glContext.version);return`
        float ${i}(int m[${e}]) {
          int offset = indicesToOffset${i}(m);
          vec2 coords = offsetToCoords(offset, ${r}, ${n});
          float value = getColorAsFloat(${u.texture2D}(${o}, coords));
          return value;
        }
        `}getPackedValueFrom(o,e,r,n,s){let i=`_${o}_Pack`;s&&(i=i+"_T");let u=q(this.context.glContext.version);return`
        vec4 ${i}(int m[${e}]) {
          int offset = indicesToOffset_${o}(m);
          vec2 coords = offsetToCoords(offset, ${r}, ${n});
          return ${u.texture2D}(${o}, coords);
        }
        `}}});var po,rp=L(()=>{"use strict";Vt();po=class a extends pt{constructor(t){super(t)}getFunctions(){return{...this.encodeFloat32(),...this.decodeFloat32()}}getCustomTypes(){return{}}encodeFloat32(){return{encode:new R(`highp vec4 encode(highp float f) {
        return vec4(f, 0.0, 0.0, 0.0);
      }
        `)}}decodeFloat32(){return{decode:new R(`highp float decode(highp vec4 rgba) {
        return rgba.r;
      }
        `)}}encodeUint8(){let t=a.isLittleEndian()?"rgba.rgba=rgba.abgr;":"";return{encode:new R(`
      highp vec4 encode(highp float f) {
        highp float F = abs(f);
        highp float Sign = step(0.0,-f);
        highp float Exponent = floor(log2(F));
        highp float Mantissa = (exp2(- Exponent) * F);
        Exponent = floor(log2(F) + 127.0) + floor(log2(Mantissa));
        highp vec4 rgba;
        rgba[0] = 128.0 * Sign  + floor(Exponent*exp2(-1.0));
        rgba[1] = 128.0 * mod(Exponent,2.0) + mod(floor(Mantissa*128.0),128.0);
        rgba[2] = floor(mod(floor(Mantissa*exp2(23.0 -8.0)),exp2(8.0)));
        rgba[3] = floor(exp2(23.0)*mod(Mantissa,exp2(-15.0)));
        ${t}
        rgba = rgba / 255.0; // values need to be normalized to [0,1]
        return rgba;
    }
        `)}}decodeUint8(){let t=a.isLittleEndian()?"rgba.rgba=rgba.abgr;":"";return{decode:new R(`
        highp float decode(highp vec4 rgba) {
          rgba = rgba * 255.0; // values need to be de-normalized from [0,1] to [0,255]
          ${t}
          highp float Sign = 1.0 - step(128.0,rgba[0])*2.0;
          highp float Exponent = 2.0 * mod(rgba[0],128.0) + step(128.0,rgba[1]) - 127.0;
          highp float Mantissa = mod(rgba[1],128.0)*65536.0 + rgba[2]*256.0 +rgba[3] + float(0x800000);
          highp float Result =  Sign * exp2(Exponent) * (Mantissa * exp2(-23.0 ));
          return Result;
      }
        `)}}static isLittleEndian(){let t=new ArrayBuffer(4),o=new Uint32Array(t),e=new Uint8Array(t);if(o[0]=3735928559,e[0]===239)return!0;if(e[0]===222)return!1;throw new Error("unknown endianness")}}});var ho,np=L(()=>{"use strict";Vt();xe();ho=class extends pt{constructor(t){super(t)}getFunctions(){return{...this.setFragColor(),...this.getColorAsFloat()}}getCustomTypes(){return{}}setFragColor(){let t=q(this.context.glContext.version);return{setFragColor:new R(`
        void setFragColor(float value) {
            ${t.output} = encode(value);
        }
        `,["encoding.encode"])}}getColorAsFloat(){return{getColorAsFloat:new R(`
        float getColorAsFloat(vec4 color) {
            return decode(color);
        }
        `,["encoding.decode"])}}}});var mo,op=L(()=>{"use strict";Vt();mo=class a extends pt{constructor(t){super(t)}getFunctions(){return{...this.bcastIndex(),...this.bcastMatmulIndex(),...this.offsetToIndices(),...this.indicesToOffset(),...this.incrementIndices()}}getCustomTypes(){return{}}bcastIndex(){let t=this.context.outputTextureLayout.shape.length,o={};return this.context.programInfo.inputNames.forEach((e,r)=>{let n=this.context.inputTextureLayouts[r].unpackedShape;if(n.length<=t){let s=n.length,i=t-s,u=`bcastIndices_${e}`,l="";for(let p=0;p<s;++p)l+=`
          realIndices[${p}] = int( mod(float(bcastedIndices[${i+p}]), ${n[p]}.0) );
          `;let f=`
        void ${u} (int bcastedIndices[${t}], out int realIndices[${s}]) {
          ${l}
        }
        `;o[u]=new R(f)}}),o}bcastMatmulIndex(){let t=this.context.outputTextureLayout.shape.length,o={};return this.context.programInfo.inputNames.forEach((e,r)=>{let n=this.context.inputTextureLayouts[r].shape;if(!(n.length<2||n.length>t)){let s=n.length,i=t-s,u=`bcastMatmulIndices_${e}`,l="";for(let p=0;p<s-2;++p)l+=`
          realIndices[${p}] = int( mod(float(bcastedIndices[${i+p}]), ${n[p]}.0) );
          `;let f=`
        void ${u}(int bcastedIndices[${t}], out int realIndices[${s}]) {
          ${l}
          realIndices[${s-1}] = bcastedIndices[${t-1}];
          realIndices[${s-2}] = bcastedIndices[${t-2}];
        }
        `;o[u]=new R(f)}}),o}indicesToOffset(){let t={};return this.context.programInfo.inputNames.forEach((o,e)=>{let r=this.context.inputTextureLayouts[e].shape,n=this.context.inputTextureLayouts[e].strides,s=r.length,i=`indicesToOffset_${o}`;t[i]=new R(a.indexToOffsetSingle(i,s,n)),i=`indicesToOffset_${o}_T`,t[i]=new R(a.indexToOffsetSingle(i,s,n.slice().reverse()))}),t}static indexToOffsetSingle(t,o,e){let r="";for(let n=o-1;n>=0;--n)r+=`
        offset += indices[${n}] * ${e[n]};
        `;return`
      int ${t}(int indices[${o}]) {
        int offset = 0;
        ${r}
        return offset;
      }
      `}offsetToIndices(){let t={};return this.context.programInfo.inputNames.forEach((o,e)=>{let r=this.context.inputTextureLayouts[e].shape,n=this.context.inputTextureLayouts[e].strides,s=r.length,i=`offsetToIndices_${o}`;t[i]=new R(a.offsetToIndicesSingle(i,s,n)),i=`offsetToIndices_${o}_T`,t[i]=new R(a.offsetToIndicesSingle(i,s,n.slice().reverse()))}),t}static offsetToIndicesSingle(t,o,e){let r=[];for(let n=0;n<o-1;++n)r.push(`
      indices[${n}] = offset / ${e[n]};`),r.push(`
        offset -= indices[${n}] * ${e[n]};`);return r.push(`
      indices[${o-1}] = offset;`),`
      void ${t}(int offset, out int indices[${o}]) {
        ${r.join("")}
      }
      `}incrementIndices(){let t={};return this.context.programInfo.inputNames.forEach((o,e)=>{let r=this.context.inputTextureLayouts[e].shape,n=r.length,s=`incrementIndices_${o}`,i="";for(let l=0;l<n;++l)i+=`
        shape[${l}] = ${r[l]};`;let u=`
        void ${s}(int axis, out int indices[${n}]) {
          int shape[${n}];
          ${i};
          for(int i = ${n} -1 ; i >= 0; --i) {
            if(i > axis) continue;
            indices[i] += 1;
            if(indices[i] < shape[i]) {
              break;
            }
            indices[i] = 0;
          }
        }
        `;t[s]=new R(u)}),t}}});var bo,ip=L(()=>{"use strict";Vt();bo=class extends pt{constructor(t){super(t)}getCustomTypes(){return{}}getFunctions(){return{...this.binaryVecFunctions(),...this.copyVec(),...this.setVecItem(),...this.getVecItem()}}binaryVecFunctions(){let o=this.context.outputTextureLayout.shape.length,e={add:"+=",sub:"-=",mul:"*=",div:"/="},r={};for(let n in e){let s=`${n}Vec`,i="";for(let l=0;l<o;++l)i+=`
          dest[${l}] ${e[n]} src[${l}];
          `;let u=`
        void ${s}(int src[${o}], out int dest[${o}]) {
          ${i}
        }
        `;r[s]=new R(u)}return r}copyVec(){let o=this.context.outputTextureLayout.shape.length,e="";for(let n=0;n<o;++n)e+=`
        dest[${n}] = src[${n}];
        `;let r=`
      void copyVec(int src[${o}], out int dest[${o}]) {
        ${e}
      }
      `;return{copyVec:new R(r)}}setVecItem(){let o=this.context.outputTextureLayout.shape.length,e=`
        if(index < 0)
            index =${o} + index;
        if (index == 0)
            m[0] = value;
        `;for(let n=1;n<o-1;++n)e+=`
        else if (index == ${n})
            m[${n}] = value;
            `;e+=`
        else
            m[${o-1}] = value;
        `;let r=`
      void setVecItem(out int m[${o}], int index, int value) {
        ${e}
      }
        `;return{setVecItem:new R(r)}}getVecItem(){let o=this.context.outputTextureLayout.shape.length,e=`
        if(index < 0)
            index = ${o} + index;
        if (index == 0)
            return m[0];
      `;for(let n=1;n<o-1;++n)e+=`
        else if (index == ${n})
            return m[${n}];
      `;e+=`
        else
            return m[${o-1}];
        `;let r=`
      int getVecItem(int m[${o}], int index) {
        ${e}
      }
    `;return{getVecItem:new R(r)}}}});var ji,ap=L(()=>{"use strict";tp();rp();np();op();ip();ji={encoding:po,fragcolor:ho,vec:bo,shapeUtils:mo,coordinates:co}});var go,sp=L(()=>{"use strict";Vt();Qc();ap();xe();go=class{constructor(t,o,e,r){this.libs={};this.glslLibRoutineDependencyGraph={};this.context=new eo(t,o,e,r),Object.keys(ji).forEach(s=>{let i=new ji[s](this.context);this.libs[s]=i});let n=this.glslLibRoutineDependencyGraph;for(let s in this.libs){let u=this.libs[s].getFunctions();for(let l in u){let f=s+"."+l,p;n[f]?(p=n[f],p.routineBody=u[l].routineBody):(p=new cn(f,u[l].routineBody),n[f]=p);let d=u[l].dependencies;if(d)for(let T=0;T<d.length;++T)if(n[d[T]])p.addDependency(n[d[T]]);else{let O=new cn(d[T]);n[d[T]]=O,p.addDependency(O)}}}}preprocess(){let t=this.context.programInfo,o=t.shaderSource;return this.context.programInfo.hasMain||(o=`${o}
      ${Gu(this.context.glContext.version,this.context.outputTextureLayout.shape.length)}`),o=Zc(o),`${Mu(this.context.glContext.version)}
    ${this.getUniforms(t.inputNames,t.variables)}
    ${this.getImports(o)}
    ${o}`}getImports(t){let o=this.selectGlslLibRoutinesToBeIncluded(t);if(o.length===0)return"";let e="";for(let r=0;r<o.length;++r)if(o[r].routineBody)e+=o[r].routineBody+`
`;else throw new Error(`Missing body for the Glsl Library routine: ${o[r].name}`);return e}selectGlslLibRoutinesToBeIncluded(t){let o=[];return Object.keys(this.glslLibRoutineDependencyGraph).forEach(e=>{let r=e.split(".")[1];t.indexOf(r)!==-1&&o.push(this.glslLibRoutineDependencyGraph[e])}),to.returnOrderedNodes(o)}getUniforms(t,o){let e=[];if(t)for(let r of t)e.push(`uniform sampler2D ${r};`);if(o)for(let r of o)e.push(`uniform ${r.type} ${r.name}${r.arrayLength?`[${r.arrayLength}]`:""};`);return e.join(`
`)}}});var yo,up=L(()=>{"use strict";vt();ut();sp();xe();yo=class{constructor(t,o,e){this.profiler=t;this.glContext=o;this.textureLayoutStrategy=e;this.repo=new Map,this.attributesBound=!1}getArtifact(t){return this.repo.get(t)}setArtifact(t,o){this.repo.set(t,o)}run(t,o,e){this.profiler.event("op",`ProgramManager.run ${t.programInfo.name??"unknown kernel"}`,()=>{let r=this.glContext.gl,n=t.program;r.useProgram(n);try{this.bindOutput(e),this.attributesBound||this.bindAttributes(t.attribLocations),this.bindUniforms(t.uniformLocations,t.programInfo.variables??[],o)}catch(s){throw ce.error("ProgramManager",t.programInfo.shaderSource),s}this.profiler.event("backend","GlContext.draw()",()=>{this.glContext.draw()})},this.glContext)}dispose(){this.vertexShader&&this.glContext.deleteShader(this.vertexShader),this.repo.forEach(t=>this.glContext.deleteProgram(t.program))}build(t,o,e){return this.profiler.event("backend","ProgramManager.build",()=>{let r=new go(this.glContext,t,o,e),n=r.preprocess(),s=this.compile(n);return{programInfo:t,program:s,uniformLocations:this.getUniformLocations(s,r.context.programInfo.inputNames,r.context.programInfo.variables),attribLocations:this.getAttribLocations(s)}})}compile(t){if(!this.vertexShader){ce.verbose("ProrgramManager","Compiling and caching Vertex shader for the first time");let r=Ru(this.glContext.version);this.vertexShader=this.glContext.compileShader(r,this.glContext.gl.VERTEX_SHADER)}Z.debug&&ce.verbose("ProrgramManager",`FragShader:
${t}
`);let o=this.glContext.compileShader(t,this.glContext.gl.FRAGMENT_SHADER),e=this.glContext.createProgram(this.vertexShader,o);return this.glContext.deleteShader(o),e}bindOutput(t){let o=t.width,e=t.height;ce.verbose("ProrgramManager",`Binding output texture to Framebuffer: w/h=${o}/${e}, shape=${t.shape}, type=${t.tensor.type}`),this.glContext.attachFramebuffer(t.texture,o,e)}bindAttributes(t){let o=t.position,e=t.textureCoord;this.glContext.setVertexAttributes(o,e),this.attributesBound=!0}bindUniforms(t,o,e){let r=this.glContext.gl,n=0;for(let{name:s,type:i,location:u,arrayLength:l}of t){let f=o.find(p=>p.name===s)?.data;if(i!=="sampler2D"&&!f)throw new Error(`variable '${s}' does not have data defined in program info`);switch(i){case"sampler2D":this.bindTexture(e[n],u,n),n++;break;case"float":l?r.uniform1fv(u,f):r.uniform1f(u,f);break;case"int":l?r.uniform1iv(u,f):r.uniform1i(u,f);break;default:throw new Error(`Uniform not implemented: ${i}`)}}}bindTexture(t,o,e){this.glContext.bindTextureToUniform(t.texture,e,o)}getAttribLocations(t){return{position:this.getAttribLocation(t,"position"),textureCoord:this.getAttribLocation(t,"textureCoord")}}getUniformLocations(t,o,e){let r=[];if(o)for(let n of o)r.push({name:n,type:"sampler2D",location:this.getUniformLocation(t,n)});if(e)for(let n of e)r.push({...n,location:this.getUniformLocation(t,n.name)});return r}getUniformLocation(t,o){let r=this.glContext.gl.getUniformLocation(t,o);if(r===null)throw new Error(`Uniform ${o} not found.`);return r}getAttribLocation(t,o){return this.glContext.gl.getAttribLocation(t,o)}}});var To,lp=L(()=>{"use strict";ut();ln();To=class{constructor(t,o,e,r){this.glContext=t;this.layoutStrategy=o;this.profiler=e;this.config=r;this.pendingRead=new Map;r.reuseTextures&&(this.inUseTextures=new Map,this.idleTextures=new Map,this.textureLookup=new Map)}createTextureFromLayout(t,o,e,r){let n=this.toEncoderType(t),s=this.glContext.getEncoder(n,o.channels||1,r);if(o.isPacked&&r===1)throw new Error("not implemented");let i=o.width,u=o.height,l,f;if(this.config.reuseTextures){l=`${i}x${u}_${s.format}_${s.internalFormat}_${s.textureType}`,f=this.inUseTextures.get(l),f||(f=[],this.inUseTextures.set(l,f));let d=this.idleTextures.get(l);if(d&&d.length>0){let T=d.pop();return f.push(T),r===1&&this.glContext.updateTexture(T,i,u,s,this.toTextureData(t,e)),T}}ce.verbose("TextureManager",`Creating new texture of size ${o.width}x${o.height}`);let p=this.glContext.allocateTexture(i,u,s,this.toTextureData(t,e));return this.config.reuseTextures&&(f.push(p),this.textureLookup.set(p,l)),p}readTexture(t,o,e){return e||(e=1),this.profiler.event("backend","TextureManager.readTexture",()=>{let r=t.shape.reduce((s,i)=>s*i)*e,n=this.glContext.readTexture(t.texture,t.width,t.height,r,this.toEncoderType(o),e);return this.toTensorData(o,n)})}async readTextureAsync(t,o,e){let r=t.tensor.dataId;if(e||(e=1),this.pendingRead.has(r)){let n=this.pendingRead.get(r);return new Promise(s=>n?.push(s))}return this.profiler.event("backend","TextureManager.readTextureAsync",async()=>{this.pendingRead.set(r,[]);let n=t.shape.reduce((l,f)=>l*f)*e;await this.glContext.createAndWaitForFence();let s=this.glContext.readTexture(t.texture,t.width,t.height,n,this.toEncoderType(o),e),i=this.toTensorData(o,s),u=this.pendingRead.get(r);return this.pendingRead.delete(r),u?.forEach(l=>l(i)),i})}readUint8TextureAsFloat(t){return this.profiler.event("backend","TextureManager.readUint8TextureAsFloat",()=>{let o=t.shape.reduce((r,n)=>r*n),e=this.glContext.readTexture(t.texture,t.width,t.height,o*4,"byte",4);return new Float32Array(e.buffer,e.byteOffset,o)})}releaseTexture(t,o){let e;if(this.config.reuseTextures&&(e=this.textureLookup.get(t.texture),e)){o&&this.textureLookup.delete(e);let r=this.inUseTextures.get(e);if(r){let n=r.indexOf(t.texture);if(n!==-1){r.splice(n,1);let s=this.idleTextures.get(e);s||(s=[],this.idleTextures.set(e,s)),s.push(t.texture)}}}(!e||o)&&(ce.verbose("TextureManager",`Deleting texture of size ${t.width}x${t.height}`),this.glContext.deleteTexture(t.texture))}toTensorData(t,o){switch(t){case"int16":return o instanceof Int16Array?o:Int16Array.from(o);case"int32":return o instanceof Int32Array?o:Int32Array.from(o);case"int8":return o instanceof Int8Array?o:Int8Array.from(o);case"uint16":return o instanceof Uint16Array?o:Uint16Array.from(o);case"uint32":return o instanceof Uint32Array?o:Uint32Array.from(o);case"uint8":case"bool":return o instanceof Uint8Array?o:Uint8Array.from(o);case"float32":return o instanceof Float32Array?o:Float32Array.from(o);case"float64":return o instanceof Float64Array?o:Float64Array.from(o);default:throw new Error(`TensorData type ${t} is not supported`)}}toTextureData(t,o){if(o)return o instanceof Float32Array?o:new Float32Array(o)}toEncoderType(t){return"float"}clearActiveTextures(){this.glContext.clearActiveTextures()}}});var xo,fp=L(()=>{"use strict";ut();Os();tl();Kc();up();qi();lp();xo=class{constructor(t,o){this.backend=t;this.context=o;this.layoutStrategy=new fo(t.glContext.maxTextureSize),this.programManager=new yo(this.context.profiler,t.glContext,this.layoutStrategy),this.textureManager=new To(t.glContext,this.layoutStrategy,this.context.profiler,{reuseTextures:t.textureCacheMode==="full"}),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache=new Map,this.pack=t.pack,this.pack2unpackMap=new Map,this.unpack2packMap=new Map}createInferenceHandler(){return new Qn(this)}onGraphInitialized(t){let o=t.getValues().filter(e=>e.from===-1&&e.tensor).map(e=>e.tensor.dataId);this.initializers=new Set(o)}isInitializer(t){return this.initializers?this.initializers.has(t):!1}addInitializer(t){this.initializers.add(t)}getTextureData(t,o){return o?this.packedTextureDataCache.get(t):this.unpackedTextureDataCache.get(t)}setTextureData(t,o,e=!1){ce.verbose("WebGLSessionHandler","Storing Texture data in cache"),e?this.packedTextureDataCache.set(t,o):this.unpackedTextureDataCache.set(t,o)}dispose(){this.programManager.dispose(),this.textureManager.clearActiveTextures(),this.packedTextureDataCache.forEach(t=>this.textureManager.releaseTexture(t,!0)),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache.forEach(t=>this.textureManager.releaseTexture(t,!0)),this.unpackedTextureDataCache=new Map}resolve(t,o,e){let r=_s(t,o,Xc);return{impl:r.opImpl,context:r.opInit?r.opInit(t,e):t}}}});function Hb(a){let t=0;for(;t<a.length&&a[t]();++t);return t-1}var hn,cp=L(()=>{"use strict";vt();ln();ln();Ft();hn=class{constructor(t,o){this.frameBufferBound=!1;this.itemsToPoll=[];this.gl=t,this.version=o,this.getExtensions(),this.vertexbuffer=this.createVertexbuffer(),this.framebuffer=this.createFramebuffer(),this.queryVitalParameters()}allocateTexture(t,o,e,r){let n=this.gl,s=n.createTexture();n.bindTexture(n.TEXTURE_2D,s),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,n.NEAREST),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,n.NEAREST),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE);let i=r?e.encode(r,t*o):null;return n.texImage2D(n.TEXTURE_2D,0,e.internalFormat,t,o,0,e.format,e.textureType,i),this.checkError(),s}updateTexture(t,o,e,r,n){let s=this.gl;s.bindTexture(s.TEXTURE_2D,t);let i=r.encode(n,o*e);s.texSubImage2D(s.TEXTURE_2D,0,0,0,o,e,r.format,r.textureType,i),this.checkError()}attachFramebuffer(t,o,e){let r=this.gl;r.bindTexture(r.TEXTURE_2D,t),r.bindFramebuffer(r.FRAMEBUFFER,this.framebuffer),r.framebufferTexture2D(r.FRAMEBUFFER,r.COLOR_ATTACHMENT0,r.TEXTURE_2D,t,0),this.checkError(),r.viewport(0,0,o,e),r.scissor(0,0,o,e)}readTexture(t,o,e,r,n,s){let i=this.gl;s||(s=1),this.frameBufferBound||this.attachFramebuffer(t,o,e);let u=this.getEncoder(n,s),l=u.allocate(o*e);return i.bindTexture(i.TEXTURE_2D,t),i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,t,0),i.readPixels(0,0,o,e,i.RGBA,u.textureType,l),this.checkError(),u.decode(l,r)}isFramebufferReady(){return!0}getActiveTexture(){let t=this.gl;return`TEXTURE${t.getParameter(this.gl.ACTIVE_TEXTURE)-t.TEXTURE0}`}getTextureBinding(){return this.gl.getParameter(this.gl.TEXTURE_BINDING_2D)}getFramebufferBinding(){return this.gl.getParameter(this.gl.FRAMEBUFFER_BINDING)}setVertexAttributes(t,o){let e=this.gl;e.vertexAttribPointer(t,3,e.FLOAT,!1,20,0),e.enableVertexAttribArray(t),o!==-1&&(e.vertexAttribPointer(o,2,e.FLOAT,!1,20,12),e.enableVertexAttribArray(o)),this.checkError()}createProgram(t,o){let e=this.gl,r=e.createProgram();return e.attachShader(r,t),e.attachShader(r,o),e.linkProgram(r),r}compileShader(t,o){let e=this.gl,r=e.createShader(o);if(!r)throw new Error(`createShader() returned null with type ${o}`);if(e.shaderSource(r,t),e.compileShader(r),e.getShaderParameter(r,e.COMPILE_STATUS)===!1)throw new Error(`Failed to compile shader: ${e.getShaderInfoLog(r)}
Shader source:
${t}`);return r}deleteShader(t){this.gl.deleteShader(t)}bindTextureToUniform(t,o,e){let r=this.gl;r.activeTexture(r.TEXTURE0+o),this.checkError(),r.bindTexture(r.TEXTURE_2D,t),this.checkError(),r.uniform1i(e,o),this.checkError()}draw(){this.gl.drawArrays(this.gl.TRIANGLE_STRIP,0,4),this.checkError()}checkError(){if(Z.debug){let t=this.gl,o=t.getError(),e="";switch(o){case t.NO_ERROR:return;case t.INVALID_ENUM:e="INVALID_ENUM";break;case t.INVALID_VALUE:e="INVALID_VALUE";break;case t.INVALID_OPERATION:e="INVALID_OPERATION";break;case t.INVALID_FRAMEBUFFER_OPERATION:e="INVALID_FRAMEBUFFER_OPERATION";break;case t.OUT_OF_MEMORY:e="OUT_OF_MEMORY";break;case t.CONTEXT_LOST_WEBGL:e="CONTEXT_LOST_WEBGL";break;default:e=`Unknown WebGL Error: ${o.toString(16)}`}throw new Error(e)}}deleteTexture(t){this.gl.deleteTexture(t)}deleteProgram(t){this.gl.deleteProgram(t)}getEncoder(t,o,e=0){if(this.version===2)return new Jn(this.gl,o);switch(t){case"float":return e===1||this.isRenderFloat32Supported?new un(this.gl,o):new un(this.gl,o,this.textureHalfFloatExtension.HALF_FLOAT_OES);case"int":throw new Error("not implemented");case"byte":return new Zn(this.gl,o);default:throw new Error(`Invalid dataType: ${t}`)}}clearActiveTextures(){let t=this.gl;for(let o=0;o<this.maxTextureImageUnits;++o)t.activeTexture(t.TEXTURE0+o),t.bindTexture(t.TEXTURE_2D,null)}dispose(){if(this.disposed)return;let t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,null),t.deleteFramebuffer(this.framebuffer),t.bindBuffer(t.ARRAY_BUFFER,null),t.deleteBuffer(this.vertexbuffer),t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null),t.finish(),this.disposed=!0}createDefaultGeometry(){return new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0])}createVertexbuffer(){let t=this.gl,o=t.createBuffer();if(!o)throw new Error("createBuffer() returned null");let e=this.createDefaultGeometry();return t.bindBuffer(t.ARRAY_BUFFER,o),t.bufferData(t.ARRAY_BUFFER,e,t.STATIC_DRAW),this.checkError(),o}createFramebuffer(){let t=this.gl.createFramebuffer();if(!t)throw new Error("createFramebuffer returned null");return t}queryVitalParameters(){let t=this.gl;if(this.isFloatTextureAttachableToFrameBuffer=this.checkFloatTextureAttachableToFrameBuffer(),this.isRenderFloat32Supported=this.checkRenderFloat32(),this.isFloat32DownloadSupported=this.checkFloat32Download(),this.version===1&&!this.textureHalfFloatExtension&&!this.isRenderFloat32Supported)throw new Error("both float32 and float16 TextureType are not supported");this.isBlendSupported=!this.isRenderFloat32Supported||this.checkFloat32Blend(),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),this.maxTextureImageUnits=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),this.version}getExtensions(){this.version===2?(this.colorBufferFloatExtension=this.gl.getExtension("EXT_color_buffer_float"),this.disjointTimerQueryWebgl2Extension=this.gl.getExtension("EXT_disjoint_timer_query_webgl2")):(this.textureFloatExtension=this.gl.getExtension("OES_texture_float"),this.textureHalfFloatExtension=this.gl.getExtension("OES_texture_half_float"))}checkFloatTextureAttachableToFrameBuffer(){let t=this.gl,o=t.createTexture();t.bindTexture(t.TEXTURE_2D,o);let e=this.version===2?t.RGBA32F:t.RGBA;t.texImage2D(t.TEXTURE_2D,0,e,1,1,0,t.RGBA,t.FLOAT,null);let r=t.createFramebuffer();t.bindFramebuffer(t.FRAMEBUFFER,r),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,o,0);let n=t.checkFramebufferStatus(t.FRAMEBUFFER)===t.FRAMEBUFFER_COMPLETE;return t.bindTexture(t.TEXTURE_2D,null),t.bindFramebuffer(t.FRAMEBUFFER,null),t.deleteTexture(o),t.deleteFramebuffer(r),n}checkRenderFloat32(){if(this.version===2){if(!this.colorBufferFloatExtension)return!1}else if(!this.textureFloatExtension)return!1;return this.isFloatTextureAttachableToFrameBuffer}checkFloat32Download(){if(this.version===2){if(!this.colorBufferFloatExtension)return!1}else if(!this.textureFloatExtension||!this.gl.getExtension("WEBGL_color_buffer_float"))return!1;return this.isFloatTextureAttachableToFrameBuffer}checkFloat32Blend(){let t=this.gl,o,e,r,n,s;try{o=t.createTexture(),e=t.createFramebuffer(),t.bindTexture(t.TEXTURE_2D,o);let i=this.version===2?t.RGBA32F:t.RGBA;return t.texImage2D(t.TEXTURE_2D,0,i,1,1,0,t.RGBA,t.FLOAT,null),t.bindFramebuffer(t.FRAMEBUFFER,e),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,o,0),t.enable(t.BLEND),r=t.createShader(t.VERTEX_SHADER),!r||(t.shaderSource(r,"void main(){}"),t.compileShader(r),n=t.createShader(t.FRAGMENT_SHADER),!n)||(t.shaderSource(n,"precision highp float;void main(){gl_FragColor=vec4(0.5);}"),t.compileShader(n),s=t.createProgram(),!s)?!1:(t.attachShader(s,r),t.attachShader(s,n),t.linkProgram(s),t.useProgram(s),t.drawArrays(t.POINTS,0,1),t.getError()===t.NO_ERROR)}finally{t.disable(t.BLEND),s&&t.deleteProgram(s),r&&t.deleteShader(r),n&&t.deleteShader(n),e&&(t.bindFramebuffer(t.FRAMEBUFFER,null),t.deleteFramebuffer(e)),o&&(t.bindTexture(t.TEXTURE_2D,null),t.deleteTexture(o))}}beginTimer(){if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let t=this.gl,o=this.disjointTimerQueryWebgl2Extension,e=t.createQuery();return t.beginQuery(o.TIME_ELAPSED_EXT,e),e}else throw new Error("WebGL1 profiling currently not supported.")}endTimer(){if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let t=this.gl,o=this.disjointTimerQueryWebgl2Extension;t.endQuery(o.TIME_ELAPSED_EXT);return}else throw new Error("WebGL1 profiling currently not supported")}isTimerResultAvailable(t){let o=!1,e=!1;if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let r=this.gl,n=this.disjointTimerQueryWebgl2Extension;o=r.getQueryParameter(t,r.QUERY_RESULT_AVAILABLE),e=r.getParameter(n.GPU_DISJOINT_EXT)}else throw new Error("WebGL1 profiling currently not supported");return o&&!e}getTimerResult(t){let o=0;if(this.version===2){let e=this.gl;o=e.getQueryParameter(t,e.QUERY_RESULT),e.deleteQuery(t)}else throw new Error("WebGL1 profiling currently not supported");return o/1e6}async waitForQueryAndGetTime(t){return await yi(()=>this.isTimerResultAvailable(t)),this.getTimerResult(t)}async createAndWaitForFence(){let t=this.createFence(this.gl);return this.pollFence(t)}createFence(t){let o,e=t,r=e.fenceSync(e.SYNC_GPU_COMMANDS_COMPLETE,0);return t.flush(),r===null?o=()=>!0:o=()=>{let n=e.clientWaitSync(r,0,0);return n===e.ALREADY_SIGNALED||n===e.CONDITION_SATISFIED},{query:r,isFencePassed:o}}async pollFence(t){return new Promise(o=>{this.addItemToPoll(()=>t.isFencePassed(),()=>o())})}pollItems(){let t=Hb(this.itemsToPoll.map(o=>o.isDoneFn));for(let o=0;o<=t;++o){let{resolveFn:e}=this.itemsToPoll[o];e()}this.itemsToPoll=this.itemsToPoll.slice(t+1)}async addItemToPoll(t,o){this.itemsToPoll.push({isDoneFn:t,resolveFn:o}),!(this.itemsToPoll.length>1)&&await yi(()=>(this.pollItems(),this.itemsToPoll.length===0))}}});function Yi(a){let t;if((!a||a==="webgl2")&&"webgl2"in Ur?t=Ur.webgl2:(!a||a==="webgl")&&"webgl"in Ur&&(t=Ur.webgl),!t)try{let e=jb();t=pp(e,a)}catch{let r=qb();t=pp(r,a)}a=a||t.version===1?"webgl":"webgl2";let o=t.gl;return Ur[a]=t,o.isContextLost()?(delete Ur[a],Yi(a)):(o.disable(o.DEPTH_TEST),o.disable(o.STENCIL_TEST),o.disable(o.BLEND),o.disable(o.DITHER),o.disable(o.POLYGON_OFFSET_FILL),o.disable(o.SAMPLE_COVERAGE),o.enable(o.SCISSOR_TEST),o.enable(o.CULL_FACE),o.cullFace(o.BACK),t)}function pp(a,t){let o={alpha:!1,depth:!1,antialias:!1,stencil:!1,preserveDrawingBuffer:!1,premultipliedAlpha:!1,failIfMajorPerformanceCaveat:!1},e,r=o;if((!t||t==="webgl2")&&(e=a.getContext("webgl2",r),e))try{return new hn(e,2)}catch(n){ce.warning("GlContextFactory",`failed to create WebGLContext using contextId 'webgl2'. Error: ${n}`)}if((!t||t==="webgl")&&(e=a.getContext("webgl",r)||a.getContext("experimental-webgl",r),e))try{return new hn(e,1)}catch(n){ce.warning("GlContextFactory",`failed to create WebGLContext using contextId 'webgl' or 'experimental-webgl'. Error: ${n}`)}throw new Error("WebGL is not supported")}function qb(){if(typeof document>"u")throw new TypeError("failed to create canvas: document is not supported");let a=document.createElement("canvas");return a.width=1,a.height=1,a}function jb(){if(typeof OffscreenCanvas>"u")throw new TypeError("failed to create offscreen canvas: OffscreenCanvas is not supported");return new OffscreenCanvas(1,1)}var Ur,dp=L(()=>{"use strict";ut();cp();Ur={}});var vo,hp=L(()=>{"use strict";vt();ut();fp();dp();vo=class{get contextId(){return Z.webgl.contextId}set contextId(t){Z.webgl.contextId=t}get matmulMaxBatchSize(){return Z.webgl.matmulMaxBatchSize}set matmulMaxBatchSize(t){Z.webgl.matmulMaxBatchSize=t}get textureCacheMode(){return Z.webgl.textureCacheMode}set textureCacheMode(t){Z.webgl.textureCacheMode=t}get pack(){return Z.webgl.pack}set pack(t){Z.webgl.pack=t}get async(){return Z.webgl.async}set async(t){Z.webgl.async=t}initialize(){try{return this.glContext=Yi(this.contextId),typeof this.matmulMaxBatchSize!="number"&&(this.matmulMaxBatchSize=16),typeof this.textureCacheMode!="string"&&(this.textureCacheMode="full"),typeof this.pack!="boolean"&&(this.pack=!1),typeof this.async!="boolean"&&(this.async=!1),ce.setWithEnv(Z),Z.webgl.context||Object.defineProperty(Z.webgl,"context",{value:this.glContext.gl}),ce.verbose("WebGLBackend",`Created WebGLContext: ${typeof this.glContext} with matmulMaxBatchSize: ${this.matmulMaxBatchSize}; textureCacheMode: ${this.textureCacheMode}; pack: ${this.pack}; async: ${this.async}.`),!0}catch(t){return ce.warning("WebGLBackend",`Unable to initialize WebGLBackend. ${t}`),!1}}createSessionHandler(t){return new xo(this,t)}dispose(){this.glContext.dispose()}}});async function Xi(a){if(a){let t=typeof a=="string"?[a]:a;for(let o of t){let e=mp.get(o);if(e)return e;let r=await Xb(o);if(r)return r}}else return Xi(["webgl"]);throw new Error("no available backend to use")}async function Xb(a){let t=Yb;if(typeof t[a]<"u"&&Kb(t[a])){let o=t[a],e=o.initialize();if(typeof e=="object"&&"then"in e&&(e=await e),e)return mp.set(a,o),o}}function Kb(a){let t=a;return"initialize"in t&&typeof t.initialize=="function"&&"createSessionHandler"in t&&typeof t.createSessionHandler=="function"&&"dispose"in t&&typeof t.dispose=="function"}var mp,Yb,bp=L(()=>{"use strict";hp();mp=new Map,Yb={webgl:new vo}});var Ki,wo,gp=L(()=>{"use strict";ut();Ki=class{constructor(t,o){this.op=t;this.node=o}},wo=class{constructor(t,o,e){this.graph=t;this.profiler=e;this.initialize(o)}initialize(t){this.profiler.event("session","ExecutionPlan.initialize",()=>{let o=this.graph.getNodes();if(o.length!==t.length)throw new Error("The size of nodes and OPs do not match.");this._ops=t.map((e,r)=>new Ki(e,o[r])),this.reset(),this._starter=[],this._ops.forEach((e,r)=>{let n=!0;for(let s of e.node.inputs)if(!this._values[s]&&this.graph.getInputIndices().indexOf(s)===-1){n=!1;break}n&&this._starter.push(r)})})}reset(){this._values=this.graph.getValues().map(t=>t.tensor)}async execute(t,o){return this.profiler.event("session","ExecutionPlan.execute",async()=>{this.reset();let e=t.createInferenceHandler(),r=this.graph.getInputIndices();if(o.length!==r.length)throw new Error(`number of input tensors don't match the number of inputs to the model: actual: ${o.length} expected: ${r.length}`);o.forEach((f,p)=>{let d=r[p];this._values[d]=f});let n=this._starter.slice(0),s=this.graph.getValues(),i=this.graph.getNodes(),u=0;for(;u<n.length;){let f=n[u++],p=this._ops[f],d=p.node.inputs.map(S=>this._values[S]);if(d.indexOf(void 0)!==-1)throw new Error(`unresolved input detected: op: ${p.node}`);let T=d;ce.verbose("ExecPlan",`Runing op:${p.node.name} (${T.map((S,E)=>`'${p.node.inputs[E]}': ${S.type}[${S.dims.join(",")}]`).join(", ")})`);let O=await this.profiler.event("node",p.node.name,async()=>p.op.impl(e,T,p.op.context));if(O.length!==p.node.outputs.length)throw new Error("the size of output does not match model definition.");O.forEach((S,E)=>{let F=p.node.outputs[E];if(this._values[F])throw new Error(`output [${F}] already has value: op:${p.node.name}`);this._values[F]=S});let v=new Set;O.forEach((S,E)=>{let F=p.node.outputs[E];for(let B of s[F].to){let K=i[B],j=!0;for(let M of K.inputs)if(!this._values[M]){j=!1;break}j&&v.add(B)}}),n.push(...v)}let l=[];for(let f=0;f<this.graph.getOutputIndices().length;f++){let p=this.graph.getOutputIndices()[f],d=this._values[p];if(d===void 0)throw new Error(`required output [${p}] does not have value`);p===0?await d.getData():d.data,l.push(d)}return ce.verbose("ExecPlan","disposing of inferenceHandler"),e.dispose(),l})}}});var oe,mt,mn,yp=L(()=>{"use strict";tn();oe=Er($r());br();fe();mt=W.experimental.fbs,mn=class a{constructor(t){if(this._attributes=new Map,t!=null){for(let o of t)o instanceof oe.onnx.AttributeProto?this._attributes.set(o.name,[a.getValue(o),a.getType(o)]):o instanceof mt.Attribute&&this._attributes.set(o.name(),[a.getValue(o),a.getType(o)]);if(this._attributes.size<t.length)throw new Error("duplicated attribute names")}}set(t,o,e){this._attributes.set(t,[e,o])}delete(t){this._attributes.delete(t)}getFloat(t,o){return this.get(t,"float",o)}getInt(t,o){return this.get(t,"int",o)}getString(t,o){return this.get(t,"string",o)}getTensor(t,o){return this.get(t,"tensor",o)}getFloats(t,o){return this.get(t,"floats",o)}getInts(t,o){return this.get(t,"ints",o)}getStrings(t,o){return this.get(t,"strings",o)}getTensors(t,o){return this.get(t,"tensors",o)}get(t,o,e){let r=this._attributes.get(t);if(r===void 0){if(e!==void 0)return e;throw new Error(`required attribute not found: ${t}`)}if(r[1]!==o)throw new Error(`type mismatch: expected ${o} but got ${r[1]}`);return r[0]}static getType(t){let o=t instanceof oe.onnx.AttributeProto?t.type:t.type();switch(o){case oe.onnx.AttributeProto.AttributeType.FLOAT:return"float";case oe.onnx.AttributeProto.AttributeType.INT:return"int";case oe.onnx.AttributeProto.AttributeType.STRING:return"string";case oe.onnx.AttributeProto.AttributeType.TENSOR:return"tensor";case oe.onnx.AttributeProto.AttributeType.FLOATS:return"floats";case oe.onnx.AttributeProto.AttributeType.INTS:return"ints";case oe.onnx.AttributeProto.AttributeType.STRINGS:return"strings";case oe.onnx.AttributeProto.AttributeType.TENSORS:return"tensors";default:throw new Error(`attribute type is not supported yet: ${oe.onnx.AttributeProto.AttributeType[o]}`)}}static getValue(t){let o=t instanceof oe.onnx.AttributeProto?t.type:t.type();if(o===oe.onnx.AttributeProto.AttributeType.GRAPH||o===oe.onnx.AttributeProto.AttributeType.GRAPHS)throw new Error("graph attribute is not supported yet");let e=this.getValueNoCheck(t);if(o===oe.onnx.AttributeProto.AttributeType.INT&&nt.isLong(e))return nt.longToNumber(e);if(o===oe.onnx.AttributeProto.AttributeType.INTS){let r=e,n=new Array(r.length);for(let s=0;s<r.length;s++){let i=r[s];n[s]=nt.longToNumber(i)}return n}if(o===oe.onnx.AttributeProto.AttributeType.TENSOR)return t instanceof oe.onnx.AttributeProto?Fe.fromProto(e):Fe.fromOrtTensor(e);if(o===oe.onnx.AttributeProto.AttributeType.TENSORS){if(t instanceof oe.onnx.AttributeProto)return e.map(n=>Fe.fromProto(n));if(t instanceof mt.Attribute)return e.map(n=>Fe.fromOrtTensor(n))}return o===oe.onnx.AttributeProto.AttributeType.STRING&&t instanceof oe.onnx.AttributeProto?sn(e):o===oe.onnx.AttributeProto.AttributeType.STRINGS&&t instanceof oe.onnx.AttributeProto?e.map(sn):e}static getValueNoCheck(t){return t instanceof oe.onnx.AttributeProto?this.getValueNoCheckFromOnnxFormat(t):this.getValueNoCheckFromOrtFormat(t)}static getValueNoCheckFromOnnxFormat(t){switch(t.type){case oe.onnx.AttributeProto.AttributeType.FLOAT:return t.f;case oe.onnx.AttributeProto.AttributeType.INT:return t.i;case oe.onnx.AttributeProto.AttributeType.STRING:return t.s;case oe.onnx.AttributeProto.AttributeType.TENSOR:return t.t;case oe.onnx.AttributeProto.AttributeType.GRAPH:return t.g;case oe.onnx.AttributeProto.AttributeType.FLOATS:return t.floats;case oe.onnx.AttributeProto.AttributeType.INTS:return t.ints;case oe.onnx.AttributeProto.AttributeType.STRINGS:return t.strings;case oe.onnx.AttributeProto.AttributeType.TENSORS:return t.tensors;case oe.onnx.AttributeProto.AttributeType.GRAPHS:return t.graphs;default:throw new Error(`unsupported attribute type: ${oe.onnx.AttributeProto.AttributeType[t.type]}`)}}static getValueNoCheckFromOrtFormat(t){switch(t.type()){case mt.AttributeType.FLOAT:return t.f();case mt.AttributeType.INT:return t.i();case mt.AttributeType.STRING:return t.s();case mt.AttributeType.TENSOR:return t.t();case mt.AttributeType.GRAPH:return t.g();case mt.AttributeType.FLOATS:return t.floatsArray();case mt.AttributeType.INTS:{let o=[];for(let e=0;e<t.intsLength();e++)o.push(t.ints(e));return o}case mt.AttributeType.STRINGS:{let o=[];for(let e=0;e<t.stringsLength();e++)o.push(t.strings(e));return o}case mt.AttributeType.TENSORS:{let o=[];for(let e=0;e<t.tensorsLength();e++)o.push(t.tensors(e));return o}default:throw new Error(`unsupported attribute type: ${mt.AttributeType[t.type()]}`)}}}});var Zi,_o,Qi,kt,Oo,Ji,Tp=L(()=>{"use strict";yp();tn();Zi=Er($r());br();fe();_o=W.experimental.fbs,Qi={from:(a,t)=>new Ji(a,t)},kt=class{constructor(t){this._from=void 0,this._to=[],this.tensor=void 0,this.type=void 0,t&&(this.type=Ve.tensorValueTypeFromProto(t.type.tensorType))}get from(){return this._from}get to(){return this._to}},Oo=class{constructor(t,o){t instanceof Zi.onnx.NodeProto?(this.name=t.name,this.opType=t.opType,this.attributes=new mn(t.attribute)):t instanceof _o.Node&&(this.name=o??t.name(),this.opType=t.opType(),this.attributes=new mn(Ve.tensorAttributesFromORTFormat(t))),this.inputs=[],this.outputs=[],this.executeNode=!0}},Ji=class{constructor(t,o){if(!t)throw new TypeError("graph is empty");this.buildGraph(t),this.transformGraph(o),this.checkIsAcyclic()}getInputIndices(){return this._allInputIndices}getInputNames(){return this._allInputNames}getOutputIndices(){return this._allOutputIndices}getOutputNames(){return this._allOutputNames}getValues(){return this._allData}getNodes(){return this._nodes}buildGraph(t){if(t instanceof Zi.onnx.GraphProto)this.buildGraphFromOnnxFormat(t);else if(t instanceof _o.Graph)this.buildGraphFromOrtFormat(t);else throw new TypeError("Graph type is not supported.")}buildGraphFromOnnxFormat(t){let o=new Map;this._allData=[],this._allInputIndices=[],this._allInputNames=[],this._allOutputIndices=[],this._allOutputNames=[],this._nodes=[];let e=new Map;if(!t.input)throw new Error("missing information in graph: input");let r=[];for(let n of t.input){if(o.has(n.name))throw new Error(`duplicated input name: ${n.name}`);let s=this._allData.push(new kt(n))-1;o.set(n.name,s),r.push(n.name)}if(!t.initializer)throw new Error("missing information in graph: initializer");for(let n of t.initializer){let s=o.get(n.name);if(s===void 0){let i=new kt;i.type={shape:{dims:Ve.tensorDimsFromProto(n.dims)},tensorType:Ve.tensorDataTypeFromProto(n.dataType)},s=this._allData.push(i)-1,o.set(n.name,s)}this._allData[s]._from=-1,this._allData[s].tensor=Fe.fromProto(n)}for(let n=0;n<this._allData.length;n++)this._allData[n].tensor||(this._allInputIndices.push(n),this._allInputNames.push(r[n]));if(!t.output)throw new Error("missing information in graph: output");for(let n of t.output){if(o.has(n.name))throw new Error(`duplicated output name: ${n.name}`);let s=this._allData.push(new kt(n))-1;o.set(n.name,s),this._allOutputIndices.push(s),this._allOutputNames.push(n.name)}if(!t.node)throw new Error("missing information in graph: node");for(let n of t.node){if(!n.name)for(let i=0;;i++){let u=`unnamed_${n.opType}_${i}`;if(!e.has(u)){n.name=u;break}}if(e.has(n.name))throw new Error(`duplicated node name: ${n.name}`);let s=this._nodes.push(new Oo(n))-1;e.set(n.name,s)}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=t.node[n];if(!i.output)throw new Error(`missing output for node: ${i.name}`);for(let u of i.output){let l=o.get(u);if(typeof l>"u"&&(l=this._allData.push(new kt)-1,o.set(u,l)),s.outputs.push(l),this._allData[l]._from!==void 0)throw new Error(`multiple nodes output to one data value: ${l}`);if(this._allData[l]._from=n,i.opType==="Constant"){if(!i.attribute||i.attribute.length!==1||!i.attribute[0].t)throw new Error("missing attributes or missing tensor value in attributes for this Constant operator");if(!i.output||i.output.length!==1)throw new Error("missing output or incorrect number of outputs for this Constant operator");s.outputs.pop(),s.executeNode=!1,this._allData[l]._from=-1,this._allData[l].tensor=Fe.fromProto(i.attribute[0].t)}}}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=t.node[n];if(!i.input)throw new Error(`missing input for node: ${i.name}`);for(let u of i.input){let l=o.get(u);if(typeof l>"u"){if(u===""&&(i.input.length===3||i.input.length===4)&&i.opType==="Resize")continue;throw new Error(`unrecognized input '${u}' for node: ${i.name}`)}s.inputs.push(l),this._allData[l]._to.push(n)}}return!0}buildGraphFromOrtFormat(t){let o=new Map;this._allData=[],this._allInputIndices=[],this._allInputNames=[],this._allOutputIndices=[],this._allOutputNames=[],this._nodes=[];let e=new Map,r=[];for(let n=0;n<t.inputsLength();n++){let s=t.inputs(n);if(o.has(s))throw new Error(`duplicated input name: ${s}`);for(let i=0;i<t.nodeArgsLength();i++)if(t.nodeArgs(i)?.name()===s){let u=new kt;if(t.nodeArgs(i)?.type()?.valueType()!==_o.TypeInfoValue.tensor_type)throw new Error("Unexpected value type for the nodeArg.");let f=t.nodeArgs(i).type().value(new _o.TensorTypeAndShape),p=Ve.tensorDataTypeFromProto(f.elemType()),d=f.shape(),T=[];for(let v=0;v<d.dimLength();v++)T.push(nt.longToNumber(d.dim(v).value().dimValue()));u.type={shape:{dims:T},tensorType:p};let O=this._allData.push(u)-1;o.set(s,O),r.push(s)}}for(let n=0;n<t.initializersLength();n++){let s=t.initializers(n),i=o.get(s.name());if(i===void 0){let u=new kt,l=Ve.tensorDimsFromORTFormat(s),f=Ve.tensorDataTypeFromProto(s.dataType());u.type={shape:{dims:l},tensorType:f},i=this._allData.push(u)-1,o.set(s.name(),i)}this._allData[i]._from=-1,this._allData[i].tensor=Fe.fromOrtTensor(s)}for(let n=0;n<this._allData.length;n++)this._allData[n].tensor||(this._allInputIndices.push(n),this._allInputNames.push(r[n]));for(let n=0;n<t.outputsLength();n++){let s=t.outputs(n);if(o.has(s))throw new Error(`duplicated output name: ${s}`);let i=this._allData.push(new kt)-1;o.set(s,i),this._allOutputIndices.push(i),this._allOutputNames.push(s)}if(!t.nodes)throw new Error("missing information in graph: node");for(let n=0;n<t.nodesLength();n++){let s=t.nodes(n),i=s.name();if(!i)for(let l=0;i=`unnamed_${s.opType()}_${l}`,!!e.has(i);l++);if(e.has(i))throw new Error(`duplicated node name: ${i}`);let u=this._nodes.push(new Oo(s,i))-1;e.set(i,u)}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=t.nodes(n);if(i==null)throw new Error(`No node exists at index ${n}`);if(i?.outputsLength()===0)throw new Error(`missing output for node: ${i.name}`);for(let u=0;u<i?.outputsLength();u++){let l=i?.outputs(u),f=o.get(l);if(typeof f>"u"&&(f=this._allData.push(new kt)-1,o.set(l,f)),s.outputs.push(f),this._allData[f]._from!==void 0)throw new Error(`multiple nodes output to one data value: ${f}`);if(this._allData[f]._from=n,i.opType()==="Constant"){if(i.attributesLength()!==1||!i.attributes(0).t())throw new Error("missing attributes or missing tensor value in attributes for this Constant operator");if(i.outputsLength()!==1)throw new Error("missing output or incorrect number of outputs for this Constant operator");s.outputs.pop(),s.executeNode=!1,this._allData[f]._from=-1,this._allData[f].tensor=Fe.fromOrtTensor(i.attributes(0).t())}}}for(let n=0;n<this._nodes.length;n++){let s=this._nodes[n],i=t.nodes(n);if(i.inputsLength()===0)throw new Error(`missing input for node: ${i.name}`);for(let u=0;u<i.inputsLength();u++){let l=i.inputs(u),f=o.get(l);if(typeof f>"u")throw new Error(`unrecognized input '${l}' for node: ${i.name()}`);s.inputs.push(f),this._allData[f]._to.push(n)}}}checkIsAcyclic(){let t=new Set;this._allInputIndices.forEach(r=>{this._allData[r]._to.forEach(s=>{t.add(s)})});let o=Array.from(t),e=new Array(this._nodes.length).fill("white");for(;o.length>0;){let r=o.pop();e[r]==="gray"?e[r]="black":(o.push(r),e[r]="gray",this._nodes[r].outputs.forEach(n=>{let s=this._allData[n];if(typeof s.tensor<"u")throw new Error("node outputs should not be initialized");if(s._from!==r)throw new Error("from property of the Value object doesn't match index of Node being processed");s._to.forEach(i=>{if(e[i]==="gray")throw new Error("model graph is cyclic");e[i]==="white"&&o.push(i)})}))}}transformGraph(t){this.removeAllIdentityNodes(),this.removeAllDropoutNodes(),this.fuseConvActivationNodes(),t&&t.transformGraph(this),this.finalizeGraph()}finalizeGraph(){let t=0,o=new Array(this._nodes.length,0),e=0;for(let r=0;r<this._nodes.length;r++)o[r]=e,this._nodes[r].executeNode?(e!==r&&(this._nodes[e]=this._nodes[r]),e++):this._nodes[r].outputs.forEach(n=>{this._allData[n]._from=-2});this._nodes.splice(e,this._nodes.length-e);for(let r=0;r<this._allData.length;r++){let n=this._allData[r];n._from!==void 0&&n._from!==-1&&n._from!==-2&&(n._from=o[n._from]);for(let s=0;s<n._to.length;s++)if(n._to[s]>=0)n._to[s]=o[n._to[s]];else throw new Error("Trying to update a removed node")}t=0;for(let r=0;r<this._allData.length;r++){if(this._allData[r].from===-2&&this._allOutputIndices.indexOf(r+t)===-1){t++,this._allData.splice(r,1),r--;continue}if(t>0){let n=-1;this._allData[r].from!==void 0&&this._allData[r].from!==-1?(n=this._nodes[this._allData[r].from].outputs.indexOf(r+t),n!==-1&&(this._nodes[this._allData[r].from].outputs[n]=r)):(n=this._allInputIndices.indexOf(r+t),n!==-1&&(this._allInputIndices[n]=r)),this._allData[r].to.forEach(s=>{n=this._nodes[s].inputs.indexOf(r+t),n!==-1&&(this._nodes[s].inputs[n]=r)}),this._allData[r].to.length===0&&(n=this._allOutputIndices.indexOf(r+t),n!==-1&&(this._allOutputIndices[n]=r))}}}deleteNode(t){let o=this._nodes[t];if(o.outputs.length>1){for(let i=1;i<o.outputs.length;i++)if(this._allData[o.outputs[i]].to.length>0)throw new Error("Node deletion with more than one output connected to other nodes is not supported. ")}o.executeNode=!1;let e=o.inputs[0],r=o.outputs[0],n=this._allData[r].to;for(let i=0;i<o.inputs.length;i++){let u=this._allData[o.inputs[i]].to.indexOf(t);if(u===-1)throw new Error("The Value object doesn't have the current Node in it's 'to' property ");this._allData[o.inputs[i]].to.splice(u,1)}this._allData[r]._to=[];let s=this._allOutputIndices.indexOf(r);if(s!==-1&&(this._allOutputIndices[s]=e),n&&n.length>0)for(let i of n){let u=this._nodes[i].inputs.indexOf(r);if(u===-1)throw new Error("The Node object doesn't have the output Value in it's 'inputs' property ");this._nodes[i].inputs[u]=e,this._allData[e].to.push(i)}}removeAllDropoutNodes(){let t=0;for(let o of this._nodes){if(o.opType==="Dropout"){if(o.inputs.length!==1)throw new Error("Dropout nodes should only contain one input. ");if(o.outputs.length!==1&&o.outputs.length!==2)throw new Error("Dropout nodes should contain either 1 or 2 output(s)");if(o.outputs.length===2&&this._allData[o.outputs[1]]._to.length!==0)throw new Error("Dropout nodes's second output should not be referenced by other nodes");this.deleteNode(t)}t++}}removeAllIdentityNodes(){let t=0;for(let o of this._nodes)o.opType==="Identity"&&this.deleteNode(t),t++}isActivation(t){switch(t.opType){case"Relu":case"Sigmoid":case"Clip":return!0;default:return!1}}fuseConvActivationNodes(){for(let t of this._nodes)if(t.opType==="Conv"){let o=this._allData[t.outputs[0]]._to;if(o.length===1&&this.isActivation(this._nodes[o[0]])){let e=this._nodes[o[0]];if(e.opType==="Clip")if(e.inputs.length===1)try{t.attributes.set("activation_params","floats",[e.attributes.getFloat("min"),e.attributes.getFloat("max")])}catch{t.attributes.set("activation_params","floats",[hr,mr])}else if(e.inputs.length>=3&&this._allData[e.inputs[1]].tensor!==void 0&&this._allData[e.inputs[2]].tensor!==void 0)t.attributes.set("activation_params","floats",[this._allData[e.inputs[1]].tensor.floatData[0],this._allData[e.inputs[2]].tensor.floatData[0]]);else continue;t.attributes.set("activation","string",e.opType),this.deleteNode(o[0])}}}}});var xp,Jb,Io,vp=L(()=>{"use strict";Wn();Tp();tn();xp=Er($r());fe();Jb=W.experimental.fbs,Io=class{constructor(){}load(t,o,e){if(!e)try{this.loadFromOnnxFormat(t,o);return}catch(r){if(e!==void 0)throw r}this.loadFromOrtFormat(t,o)}loadFromOnnxFormat(t,o){let e=xp.onnx.ModelProto.decode(t);if(nt.longToNumber(e.irVersion)<3)throw new Error("only support ONNX model with IR_VERSION>=3");this._opsets=e.opsetImport.map(n=>({domain:n.domain,version:nt.longToNumber(n.version)})),this._graph=Qi.from(e.graph,o)}loadFromOrtFormat(t,o){let e=new _.ByteBuffer(t),r=Jb.InferenceSession.getRootAsInferenceSession(e).model();if(nt.longToNumber(r.irVersion())<3)throw new Error("only support ONNX model with IR_VERSION>=3");this._opsets=[];for(let s=0;s<r.opsetImportLength();s++){let i=r.opsetImport(s);this._opsets.push({domain:i?.domain(),version:nt.longToNumber(i.version())})}this._graph=Qi.from(r.graph(),o)}get graph(){return this._graph}get opsets(){return this._opsets}}});var So,wp=L(()=>{"use strict";bp();gp();ut();vp();So=class{constructor(t={}){this._initialized=!1,this.backendHint=t.backendHint,this.profiler=zn.create(t.profiler),this.context={profiler:this.profiler,graphInputTypes:[],graphInputDims:[]}}get inputNames(){return this._model.graph.getInputNames()}get outputNames(){return this._model.graph.getOutputNames()}startProfiling(){this.profiler.start()}endProfiling(){this.profiler.stop()}async loadModel(t,o,e){await this.profiler.event("session","Session.loadModel",async()=>{let r=await Xi(this.backendHint);if(this.sessionHandler=r.createSessionHandler(this.context),this._model=new Io,typeof t=="string"){let n=t.endsWith(".ort");if(typeof process<"u"&&process.versions&&process.versions.node){let s=await(void 0)(t);this.initialize(s,n)}else{let i=await(await fetch(t)).arrayBuffer();this.initialize(new Uint8Array(i),n)}}else if(ArrayBuffer.isView(t))this.initialize(t);else{let n=new Uint8Array(t,o||0,e||t.byteLength);this.initialize(n)}})}initialize(t,o){if(this._initialized)throw new Error("already initialized");this.profiler.event("session","Session.initialize",()=>{let e=this.sessionHandler.transformGraph?this.sessionHandler:void 0;this._model.load(t,e,o),this.sessionHandler.onGraphInitialized&&this.sessionHandler.onGraphInitialized(this._model.graph),this.initializeOps(this._model.graph),this._executionPlan=new wo(this._model.graph,this._ops,this.profiler)}),this._initialized=!0}async run(t){if(!this._initialized)throw new Error("session not initialized yet");return this.profiler.event("session","Session.run",async()=>{let o=this.normalizeAndValidateInputs(t),e=await this._executionPlan.execute(this.sessionHandler,o);return this.createOutput(e)})}normalizeAndValidateInputs(t){let o=this._model.graph.getInputNames();if(Array.isArray(t)){if(t.length!==o.length)throw new Error(`incorrect input array length: expected ${o.length} but got ${t.length}`)}else{if(t.size!==o.length)throw new Error(`incorrect input map size: expected ${o.length} but got ${t.size}`);let e=new Array(t.size),r=0;for(let n=0;n<o.length;++n){let s=t.get(o[n]);if(!s)throw new Error(`missing input tensor for: '${name}'`);e[r++]=s}t=e}if(!this.context.graphInputTypes||this.context.graphInputTypes.length===0||!this.context.graphInputDims||this.context.graphInputDims.length===0){let e=this._model.graph.getInputIndices(),r=this._model.graph.getValues(),n=new Array(e.length);for(let s=0;s<e.length;++s){let i=r[e[s]];n[s]=i.type.shape.dims,this.context.graphInputTypes.push(i.type.tensorType),this.context.graphInputDims.push(t[s].dims)}this.validateInputTensorDims(n,t,!0)}else this.validateInputTensorDims(this.context.graphInputDims,t,!1);return this.validateInputTensorTypes(this.context.graphInputTypes,t),t}validateInputTensorTypes(t,o){for(let e=0;e<o.length;e++){let r=t[e],n=o[e].type;if(r!==n)throw new Error(`input tensor[${e}] check failed: expected type '${r}' but got ${n}`)}}validateInputTensorDims(t,o,e){for(let r=0;r<o.length;r++){let n=t[r],s=o[r].dims;if(!this.compareTensorDims(n,s,e))throw new Error(`input tensor[${r}] check failed: expected shape '[${n.join(",")}]' but got [${s.join(",")}]`)}}compareTensorDims(t,o,e){if(t.length!==o.length)return!1;for(let r=0;r<t.length;++r)if(t[r]!==o[r]&&(!e||t[r]!==0))return!1;return!0}createOutput(t){let o=this._model.graph.getOutputNames();if(t.length!==o.length)throw new Error("expected number of outputs do not match number of generated outputs");let e=new Map;for(let r=0;r<o.length;++r)e.set(o[r],t[r]);return e}initializeOps(t){let o=t.getNodes();this._ops=new Array(o.length);for(let e=0;e<o.length;e++)this._ops[e]=this.sessionHandler.resolve(o[e],this._model.opsets,t)}}});var Ao,_p=L(()=>{"use strict";vt();br();Ao=class{constructor(t){this.session=t;this.inputNames=this.session.inputNames,this.outputNames=this.session.outputNames}async dispose(){}async run(t,o,e){let r=new Map;for(let i in t)if(Object.hasOwnProperty.call(t,i)){let u=t[i];r.set(i,new Fe(u.dims,u.type,void 0,void 0,u.data))}let n=await this.session.run(r),s={};return n.forEach((i,u)=>{s[u]=new ke(i.type,i.data,i.dims)}),s}startProfiling(){this.session.startProfiling()}endProfiling(){this.session.endProfiling()}}});var Op={};ar(Op,{onnxjsBackend:()=>Qb});var ea,Qb,Ip=L(()=>{"use strict";wp();_p();ea=class{async init(){}async createInferenceSessionHandler(t,o){let e=new So(o);return typeof t=="string"?await e.loadModel(t):await e.loadModel(t),new Ao(e)}},Qb=new ea});var ta={};ar(ta,{createReadStream:()=>Sp,readFile:()=>eg,readFileSync:()=>tg});var eg,tg,Sp,ra=L(()=>{eg=void 0,tg=void 0,Sp=void 0});var na={};ar(na,{join:()=>rg});var rg,oa=L(()=>{rg=void 0});var Ep=me((Pp,ia)=>{"use strict";var Ap=(()=>{var a=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(a=a||__filename),function(t={}){var o=t,e,r;o.ready=new Promise((b,x)=>{e=b,r=x});var n=Object.assign({},o),s="./this.program",i=typeof window=="object",u=typeof importScripts=="function",l=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",f="",p,d,T;if(l){var O=(ra(),jt(ta)),v=(oa(),jt(na));f=u?v.dirname(f)+"/":__dirname+"/",p=(b,x)=>(b=at(b)?new URL(b):v.normalize(b),O.readFileSync(b,x?void 0:"utf8")),T=b=>(b=p(b,!0),b.buffer||(b=new Uint8Array(b)),b),d=(b,x,w,D=!0)=>{b=at(b)?new URL(b):v.normalize(b),O.readFile(b,D?void 0:"utf8",(G,Y)=>{G?w(G):x(D?Y.buffer:Y)})},!o.thisProgram&&1<process.argv.length&&(s=process.argv[1].replace(/\\/g,"/")),process.argv.slice(2),o.inspect=()=>"[Emscripten Module object]"}else(i||u)&&(u?f=self.location.href:typeof document<"u"&&document.currentScript&&(f=document.currentScript.src),a&&(f=a),f.indexOf("blob:")!==0?f=f.substr(0,f.replace(/[?#].*/,"").lastIndexOf("/")+1):f="",p=b=>{var x=new XMLHttpRequest;return x.open("GET",b,!1),x.send(null),x.responseText},u&&(T=b=>{var x=new XMLHttpRequest;return x.open("GET",b,!1),x.responseType="arraybuffer",x.send(null),new Uint8Array(x.response)}),d=(b,x,w)=>{var D=new XMLHttpRequest;D.open("GET",b,!0),D.responseType="arraybuffer",D.onload=()=>{D.status==200||D.status==0&&D.response?x(D.response):w()},D.onerror=w,D.send(null)});var S=console.log.bind(console),E=console.error.bind(console);Object.assign(o,n),n=null,typeof WebAssembly!="object"&&Ze("no native wasm support detected");var F,B=!1,K,j,M,ie,$e;function He(){var b=F.buffer;o.HEAP8=K=new Int8Array(b),o.HEAP16=new Int16Array(b),o.HEAPU8=j=new Uint8Array(b),o.HEAPU16=new Uint16Array(b),o.HEAP32=M=new Int32Array(b),o.HEAPU32=ie=new Uint32Array(b),o.HEAPF32=new Float32Array(b),o.HEAPF64=$e=new Float64Array(b)}var it=[],V=[],ve=[],Je=0,re=null,Be=null;function Ze(b){throw b="Aborted("+b+")",E(b),B=!0,b=new WebAssembly.RuntimeError(b+". Build with -sASSERTIONS for more info."),r(b),b}var ot=b=>b.startsWith("data:application/octet-stream;base64,"),at=b=>b.startsWith("file://"),Ie;if(Ie="ort-wasm.wasm",!ot(Ie)){var qe=Ie;Ie=o.locateFile?o.locateFile(qe,f):f+qe}function gt(b){if(T)return T(b);throw"both async and sync fetching of the wasm failed"}function Bt(b){if(i||u){if(typeof fetch=="function"&&!at(b))return fetch(b,{credentials:"same-origin"}).then(x=>{if(!x.ok)throw"failed to load wasm binary file at '"+b+"'";return x.arrayBuffer()}).catch(()=>gt(b));if(d)return new Promise((x,w)=>{d(b,D=>x(new Uint8Array(D)),w)})}return Promise.resolve().then(()=>gt(b))}function Nt(b,x,w){return Bt(b).then(D=>WebAssembly.instantiate(D,x)).then(D=>D).then(w,D=>{E(`failed to asynchronously prepare wasm: ${D}`),Ze(D)})}function Wt(b,x){var w=Ie;return typeof WebAssembly.instantiateStreaming!="function"||ot(w)||at(w)||l||typeof fetch!="function"?Nt(w,b,x):fetch(w,{credentials:"same-origin"}).then(D=>WebAssembly.instantiateStreaming(D,b).then(x,function(G){return E(`wasm streaming compile failed: ${G}`),E("falling back to ArrayBuffer instantiation"),Nt(w,b,x)}))}var At,Qe={919888:(b,x,w,D)=>{if(typeof o>"u"||!o.za)return 1;if(b=st(b>>>0),b.startsWith("./")&&(b=b.substring(2)),b=o.za.get(b),!b)return 2;if(x>>>=0,w>>>=0,x+w>b.byteLength)return 3;try{return j.set(b.subarray(x,x+w),D>>>0>>>0),0}catch{return 4}}};function yt(b){this.xa=b-24,this.Ha=function(x){ie[this.xa+4>>>2>>>0]=x},this.Ga=function(x){ie[this.xa+8>>>2>>>0]=x},this.Aa=function(x,w){this.Fa(),this.Ha(x),this.Ga(w)},this.Fa=function(){ie[this.xa+16>>>2>>>0]=0}}var Tt=0,Ne=0,Le=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,Rt=(b,x,w)=>{x>>>=0;var D=x+w;for(w=x;b[w]&&!(w>=D);)++w;if(16<w-x&&b.buffer&&Le)return Le.decode(b.subarray(x,w));for(D="";x<w;){var G=b[x++];if(G&128){var Y=b[x++]&63;if((G&224)==192)D+=String.fromCharCode((G&31)<<6|Y);else{var ne=b[x++]&63;G=(G&240)==224?(G&15)<<12|Y<<6|ne:(G&7)<<18|Y<<12|ne<<6|b[x++]&63,65536>G?D+=String.fromCharCode(G):(G-=65536,D+=String.fromCharCode(55296|G>>10,56320|G&1023))}}else D+=String.fromCharCode(G)}return D},st=(b,x)=>(b>>>=0)?Rt(j,b,x):"",xt=b=>{for(var x=0,w=0;w<b.length;++w){var D=b.charCodeAt(w);127>=D?x++:2047>=D?x+=2:55296<=D&&57343>=D?(x+=4,++w):x+=3}return x},wr=(b,x,w,D)=>{if(w>>>=0,!(0<D))return 0;var G=w;D=w+D-1;for(var Y=0;Y<b.length;++Y){var ne=b.charCodeAt(Y);if(55296<=ne&&57343>=ne){var Ce=b.charCodeAt(++Y);ne=65536+((ne&1023)<<10)|Ce&1023}if(127>=ne){if(w>=D)break;x[w++>>>0]=ne}else{if(2047>=ne){if(w+1>=D)break;x[w++>>>0]=192|ne>>6}else{if(65535>=ne){if(w+2>=D)break;x[w++>>>0]=224|ne>>12}else{if(w+3>=D)break;x[w++>>>0]=240|ne>>18,x[w++>>>0]=128|ne>>12&63}x[w++>>>0]=128|ne>>6&63}x[w++>>>0]=128|ne&63}}return x[w>>>0]=0,w-G},Ht=b=>b%4===0&&(b%100!==0||b%400===0),Hr=[0,31,60,91,121,152,182,213,244,274,305,335],xn=[0,31,59,90,120,151,181,212,243,273,304,334],Mt=b=>{var x=xt(b)+1,w=wn(x);return w&&wr(b,j,w,x),w},_r=[],qt={},Or=()=>{if(!Ir){var b={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:s||"./this.program"},x;for(x in qt)qt[x]===void 0?delete b[x]:b[x]=qt[x];var w=[];for(x in b)w.push(`${x}=${b[x]}`);Ir=w}return Ir},Ir,nr=[null,[],[]],qr=[31,29,31,30,31,30,31,31,30,31,30,31],jr=[31,28,31,30,31,30,31,31,30,31,30,31];function Sr(b){var x=Array(xt(b)+1);return wr(b,x,0,x.length),x}function vn(b,x,w,D){function G(A,pe,Te){for(A=typeof A=="number"?A.toString():A||"";A.length<pe;)A=Te[0]+A;return A}function Y(A,pe){return G(A,pe,"0")}function ne(A,pe){function Te(Zr){return 0>Zr?-1:0<Zr?1:0}var Pt;return(Pt=Te(A.getFullYear()-pe.getFullYear()))===0&&(Pt=Te(A.getMonth()-pe.getMonth()))===0&&(Pt=Te(A.getDate()-pe.getDate())),Pt}function Ce(A){switch(A.getDay()){case 0:return new Date(A.getFullYear()-1,11,29);case 1:return A;case 2:return new Date(A.getFullYear(),0,3);case 3:return new Date(A.getFullYear(),0,2);case 4:return new Date(A.getFullYear(),0,1);case 5:return new Date(A.getFullYear()-1,11,31);case 6:return new Date(A.getFullYear()-1,11,30)}}function je(A){var pe=A.ta;for(A=new Date(new Date(A.ua+1900,0,1).getTime());0<pe;){var Te=A.getMonth(),Pt=(Ht(A.getFullYear())?qr:jr)[Te];if(pe>Pt-A.getDate())pe-=Pt-A.getDate()+1,A.setDate(1),11>Te?A.setMonth(Te+1):(A.setMonth(0),A.setFullYear(A.getFullYear()+1));else{A.setDate(A.getDate()+pe);break}}return Te=new Date(A.getFullYear()+1,0,4),pe=Ce(new Date(A.getFullYear(),0,4)),Te=Ce(Te),0>=ne(pe,A)?0>=ne(Te,A)?A.getFullYear()+1:A.getFullYear():A.getFullYear()-1}b>>>=0,x>>>=0,w>>>=0,D>>>=0;var Ue=ie[D+40>>>2>>>0];D={Da:M[D>>>2>>>0],Ca:M[D+4>>>2>>>0],va:M[D+8>>>2>>>0],ya:M[D+12>>>2>>>0],wa:M[D+16>>>2>>>0],ua:M[D+20>>>2>>>0],oa:M[D+24>>>2>>>0],ta:M[D+28>>>2>>>0],Ia:M[D+32>>>2>>>0],Ba:M[D+36>>>2>>>0],Ea:Ue?st(Ue):""},w=st(w),Ue={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var ze in Ue)w=w.replace(new RegExp(ze,"g"),Ue[ze]);var Kr="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),Jr="January February March April May June July August September October November December".split(" ");Ue={"%a":A=>Kr[A.oa].substring(0,3),"%A":A=>Kr[A.oa],"%b":A=>Jr[A.wa].substring(0,3),"%B":A=>Jr[A.wa],"%C":A=>Y((A.ua+1900)/100|0,2),"%d":A=>Y(A.ya,2),"%e":A=>G(A.ya,2," "),"%g":A=>je(A).toString().substring(2),"%G":A=>je(A),"%H":A=>Y(A.va,2),"%I":A=>(A=A.va,A==0?A=12:12<A&&(A-=12),Y(A,2)),"%j":A=>{for(var pe=0,Te=0;Te<=A.wa-1;pe+=(Ht(A.ua+1900)?qr:jr)[Te++]);return Y(A.ya+pe,3)},"%m":A=>Y(A.wa+1,2),"%M":A=>Y(A.Ca,2),"%n":()=>`
`,"%p":A=>0<=A.va&&12>A.va?"AM":"PM","%S":A=>Y(A.Da,2),"%t":()=>"	","%u":A=>A.oa||7,"%U":A=>Y(Math.floor((A.ta+7-A.oa)/7),2),"%V":A=>{var pe=Math.floor((A.ta+7-(A.oa+6)%7)/7);if(2>=(A.oa+371-A.ta-2)%7&&pe++,pe)pe==53&&(Te=(A.oa+371-A.ta)%7,Te==4||Te==3&&Ht(A.ua)||(pe=1));else{pe=52;var Te=(A.oa+7-A.ta-1)%7;(Te==4||Te==5&&Ht(A.ua%400-1))&&pe++}return Y(pe,2)},"%w":A=>A.oa,"%W":A=>Y(Math.floor((A.ta+7-(A.oa+6)%7)/7),2),"%y":A=>(A.ua+1900).toString().substring(2),"%Y":A=>A.ua+1900,"%z":A=>{A=A.Ba;var pe=0<=A;return A=Math.abs(A)/60,(pe?"+":"-")+("0000"+(A/60*100+A%60)).slice(-4)},"%Z":A=>A.Ea,"%%":()=>"%"},w=w.replace(/%%/g,"\0\0");for(ze in Ue)w.includes(ze)&&(w=w.replace(new RegExp(ze,"g"),Ue[ze](D)));return w=w.replace(/\0\0/g,"%"),ze=Sr(w),ze.length>x?0:(K.set(ze,b>>>0),ze.length-1)}var he={a:function(b,x,w){throw b>>>=0,new yt(b).Aa(x>>>0,w>>>0),Tt=b,Ne++,Tt},e:function(){return 0},H:function(){},x:function(){},z:function(){},J:function(){return 0},F:function(){},A:function(){},E:function(){},g:function(){},y:function(){},v:function(){},G:function(){},w:function(){},k:()=>1,n:function(b,x,w){b=x+2097152>>>0<4194305-!!b?(b>>>0)+4294967296*x:NaN,w>>>=0,b=new Date(1e3*b),M[w>>>2>>>0]=b.getUTCSeconds(),M[w+4>>>2>>>0]=b.getUTCMinutes(),M[w+8>>>2>>>0]=b.getUTCHours(),M[w+12>>>2>>>0]=b.getUTCDate(),M[w+16>>>2>>>0]=b.getUTCMonth(),M[w+20>>>2>>>0]=b.getUTCFullYear()-1900,M[w+24>>>2>>>0]=b.getUTCDay(),M[w+28>>>2>>>0]=(b.getTime()-Date.UTC(b.getUTCFullYear(),0,1,0,0,0,0))/864e5|0},o:function(b,x,w){b=x+2097152>>>0<4194305-!!b?(b>>>0)+4294967296*x:NaN,w>>>=0,b=new Date(1e3*b),M[w>>>2>>>0]=b.getSeconds(),M[w+4>>>2>>>0]=b.getMinutes(),M[w+8>>>2>>>0]=b.getHours(),M[w+12>>>2>>>0]=b.getDate(),M[w+16>>>2>>>0]=b.getMonth(),M[w+20>>>2>>>0]=b.getFullYear()-1900,M[w+24>>>2>>>0]=b.getDay(),M[w+28>>>2>>>0]=(Ht(b.getFullYear())?Hr:xn)[b.getMonth()]+b.getDate()-1|0,M[w+36>>>2>>>0]=-(60*b.getTimezoneOffset()),x=new Date(b.getFullYear(),6,1).getTimezoneOffset();var D=new Date(b.getFullYear(),0,1).getTimezoneOffset();M[w+32>>>2>>>0]=(x!=D&&b.getTimezoneOffset()==Math.min(D,x))|0},p:function(b){b>>>=0;var x=new Date(M[b+20>>>2>>>0]+1900,M[b+16>>>2>>>0],M[b+12>>>2>>>0],M[b+8>>>2>>>0],M[b+4>>>2>>>0],M[b>>>2>>>0],0),w=M[b+32>>>2>>>0],D=x.getTimezoneOffset(),G=new Date(x.getFullYear(),6,1).getTimezoneOffset(),Y=new Date(x.getFullYear(),0,1).getTimezoneOffset(),ne=Math.min(Y,G);return 0>w?M[b+32>>>2>>>0]=+(G!=Y&&ne==D):0<w!=(ne==D)&&(G=Math.max(Y,G),x.setTime(x.getTime()+6e4*((0<w?ne:G)-D))),M[b+24>>>2>>>0]=x.getDay(),M[b+28>>>2>>>0]=(Ht(x.getFullYear())?Hr:xn)[x.getMonth()]+x.getDate()-1|0,M[b>>>2>>>0]=x.getSeconds(),M[b+4>>>2>>>0]=x.getMinutes(),M[b+8>>>2>>>0]=x.getHours(),M[b+12>>>2>>>0]=x.getDate(),M[b+16>>>2>>>0]=x.getMonth(),M[b+20>>>2>>>0]=x.getYear(),b=x.getTime(),isNaN(b)?(M[Ar()>>>2>>>0]=61,b=-1):b/=1e3,Yr((At=b,1<=+Math.abs(At)?0<At?+Math.floor(At/4294967296)>>>0:~~+Math.ceil((At-+(~~At>>>0))/4294967296)>>>0:0)),b>>>0},l:function(){return-52},m:function(){},t:function(b,x,w){function D(je){return(je=je.toTimeString().match(/\(([A-Za-z ]+)\)$/))?je[1]:"GMT"}w>>>=0;var G=new Date().getFullYear(),Y=new Date(G,0,1),ne=new Date(G,6,1);G=Y.getTimezoneOffset();var Ce=ne.getTimezoneOffset();ie[b>>>0>>>2>>>0]=60*Math.max(G,Ce),M[x>>>0>>>2>>>0]=+(G!=Ce),b=D(Y),x=D(ne),b=Mt(b),x=Mt(x),Ce<G?(ie[w>>>2>>>0]=b,ie[w+4>>>2>>>0]=x):(ie[w>>>2>>>0]=x,ie[w+4>>>2>>>0]=b)},d:()=>{Ze("")},B:function(b,x,w){b>>>=0,x>>>=0,w>>>=0,_r.length=0;for(var D;D=j[x++>>>0];){var G=D!=105;G&=D!=112,w+=G&&w%8?4:0,_r.push(D==112?ie[w>>>2>>>0]:D==105?M[w>>>2>>>0]:$e[w>>>3>>>0]),w+=G?8:4}return Qe[b].apply(null,_r)},h:()=>Date.now(),u:function(){return 4294901760},b:()=>performance.now(),I:function(b,x,w){return x>>>=0,j.copyWithin(b>>>0>>>0,x>>>0,x+(w>>>0)>>>0)},s:function(b){b>>>=0;var x=j.length;if(4294901760<b)return!1;for(var w=1;4>=w;w*=2){var D=x*(1+.2/w);D=Math.min(D,b+100663296);var G=Math;D=Math.max(b,D);e:{G=(G.min.call(G,4294901760,D+(65536-D%65536)%65536)-F.buffer.byteLength+65535)/65536;try{F.grow(G),He();var Y=1;break e}catch{}Y=void 0}if(Y)return!0}return!1},C:function(b,x){b>>>=0,x>>>=0;var w=0;return Or().forEach((D,G)=>{var Y=x+w;for(G=ie[b+4*G>>>2>>>0]=Y,Y=0;Y<D.length;++Y)K[G++>>>0>>>0]=D.charCodeAt(Y);K[G>>>0>>>0]=0,w+=D.length+1}),0},D:function(b,x){b>>>=0,x>>>=0;var w=Or();ie[b>>>2>>>0]=w.length;var D=0;return w.forEach(G=>D+=G.length+1),ie[x>>>2>>>0]=D,0},f:()=>52,j:function(){return 52},q:function(){return 70},i:function(b,x,w,D){x>>>=0,w>>>=0,D>>>=0;for(var G=0,Y=0;Y<w;Y++){var ne=ie[x>>>2>>>0],Ce=ie[x+4>>>2>>>0];x+=8;for(var je=0;je<Ce;je++){var Ue=j[ne+je>>>0],ze=nr[b];Ue===0||Ue===10?((b===1?S:E)(Rt(ze,0)),ze.length=0):ze.push(Ue)}G+=Ce}return ie[D>>>2>>>0]=G,0},r:vn,c:function(b,x,w,D){return vn(b>>>0,x>>>0,w>>>0,D>>>0)}},Q=function(){function b(w){return Q=w.exports,Q=On(),F=Q.K,He(),V.unshift(Q.L),Je--,Je==0&&(re!==null&&(clearInterval(re),re=null),Be&&(w=Be,Be=null,w())),Q}var x={a:he};if(Je++,o.instantiateWasm)try{return o.instantiateWasm(x,b)}catch(w){E(`Module.instantiateWasm callback failed with error: ${w}`),r(w)}return Wt(x,function(w){b(w.instance)}).catch(r),{}}();o._OrtInit=(b,x)=>(o._OrtInit=Q.M)(b,x),o._OrtGetLastError=(b,x)=>(o._OrtGetLastError=Q.N)(b,x),o._OrtCreateSessionOptions=(b,x,w,D,G,Y,ne,Ce,je,Ue)=>(o._OrtCreateSessionOptions=Q.O)(b,x,w,D,G,Y,ne,Ce,je,Ue),o._OrtAppendExecutionProvider=(b,x)=>(o._OrtAppendExecutionProvider=Q.P)(b,x),o._OrtAddFreeDimensionOverride=(b,x,w)=>(o._OrtAddFreeDimensionOverride=Q.Q)(b,x,w),o._OrtAddSessionConfigEntry=(b,x,w)=>(o._OrtAddSessionConfigEntry=Q.R)(b,x,w),o._OrtReleaseSessionOptions=b=>(o._OrtReleaseSessionOptions=Q.S)(b),o._OrtCreateSession=(b,x,w)=>(o._OrtCreateSession=Q.T)(b,x,w),o._OrtReleaseSession=b=>(o._OrtReleaseSession=Q.U)(b),o._OrtGetInputOutputCount=(b,x,w)=>(o._OrtGetInputOutputCount=Q.V)(b,x,w),o._OrtGetInputName=(b,x)=>(o._OrtGetInputName=Q.W)(b,x),o._OrtGetOutputName=(b,x)=>(o._OrtGetOutputName=Q.X)(b,x),o._OrtFree=b=>(o._OrtFree=Q.Y)(b),o._OrtCreateTensor=(b,x,w,D,G,Y)=>(o._OrtCreateTensor=Q.Z)(b,x,w,D,G,Y),o._OrtGetTensorData=(b,x,w,D,G)=>(o._OrtGetTensorData=Q._)(b,x,w,D,G),o._OrtReleaseTensor=b=>(o._OrtReleaseTensor=Q.$)(b),o._OrtCreateRunOptions=(b,x,w,D)=>(o._OrtCreateRunOptions=Q.aa)(b,x,w,D),o._OrtAddRunConfigEntry=(b,x,w)=>(o._OrtAddRunConfigEntry=Q.ba)(b,x,w),o._OrtReleaseRunOptions=b=>(o._OrtReleaseRunOptions=Q.ca)(b),o._OrtCreateBinding=b=>(o._OrtCreateBinding=Q.da)(b),o._OrtBindInput=(b,x,w)=>(o._OrtBindInput=Q.ea)(b,x,w),o._OrtBindOutput=(b,x,w,D)=>(o._OrtBindOutput=Q.fa)(b,x,w,D),o._OrtClearBoundOutputs=b=>(o._OrtClearBoundOutputs=Q.ga)(b),o._OrtReleaseBinding=b=>(o._OrtReleaseBinding=Q.ha)(b),o._OrtRunWithBinding=(b,x,w,D,G)=>(o._OrtRunWithBinding=Q.ia)(b,x,w,D,G),o._OrtRun=(b,x,w,D,G,Y,ne,Ce)=>(o._OrtRun=Q.ja)(b,x,w,D,G,Y,ne,Ce),o._OrtEndProfiling=b=>(o._OrtEndProfiling=Q.ka)(b);var Ar=()=>(Ar=Q.la)(),wn=o._malloc=b=>(wn=o._malloc=Q.ma)(b);o._free=b=>(o._free=Q.na)(b);var Yr=b=>(Yr=Q.pa)(b),_n=()=>(_n=Q.qa)(),J=b=>(J=Q.ra)(b),or=b=>(or=Q.sa)(b);function On(){var b=Q;b=Object.assign({},b);var x=D=>()=>D()>>>0,w=D=>G=>D(G)>>>0;return b.la=x(b.la),b.ma=w(b.ma),b.qa=x(b.qa),b.sa=w(b.sa),b}o.stackAlloc=or,o.stackSave=_n,o.stackRestore=J,o.UTF8ToString=st,o.stringToUTF8=(b,x,w)=>wr(b,j,x,w),o.lengthBytesUTF8=xt;var Gt;Be=function b(){Gt||Xr(),Gt||(Be=b)};function Xr(){if(!(0<Je)){if(o.preRun)for(typeof o.preRun=="function"&&(o.preRun=[o.preRun]);o.preRun.length;){var b=o.preRun.shift();it.unshift(b)}for(;0<it.length;)it.shift()(o);if(!(0<Je||Gt||(Gt=!0,o.calledRun=!0,B))){for(;0<V.length;)V.shift()(o);for(e(o);0<ve.length;)ve.shift()(o)}}}return Xr(),t.ready}})();typeof Pp=="object"&&typeof ia=="object"?ia.exports=Ap:typeof define=="function"&&define.amd&&define([],()=>Ap)});var Dp=me(()=>{});var Lp=me(()=>{});var Fp={};ar(Fp,{cpus:()=>ng});var ng,$p=L(()=>{ng=void 0});var Bp=me((kp,aa)=>{"use strict";var Cp=(()=>{var a=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(a=a||__filename),function(t={}){function o(){return ve.buffer!=Ze.buffer&&gt(),Ze}function e(){return ve.buffer!=Ze.buffer&&gt(),ot}function r(){return ve.buffer!=Ze.buffer&&gt(),at}function n(){return ve.buffer!=Ze.buffer&&gt(),Ie}function s(){return ve.buffer!=Ze.buffer&&gt(),qe}var i=t,u,l;i.ready=new Promise((c,h)=>{u=c,l=h});var f=Object.assign({},i),p="./this.program",d=(c,h)=>{throw h},T=typeof window=="object",O=typeof importScripts=="function",v=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",S=i.ENVIRONMENT_IS_PTHREAD||!1,E="";function F(c){return i.locateFile?i.locateFile(c,E):E+c}var B,K,j;if(v){var M=(ra(),jt(ta)),ie=(oa(),jt(na));E=O?ie.dirname(E)+"/":__dirname+"/",B=(h,g)=>(h=st(h)?new URL(h):ie.normalize(h),M.readFileSync(h,g?void 0:"utf8")),j=h=>(h=B(h,!0),h.buffer||(h=new Uint8Array(h)),h),K=(h,g,I,C=!0)=>{h=st(h)?new URL(h):ie.normalize(h),M.readFile(h,C?void 0:"utf8",(k,z)=>{k?I(k):g(C?z.buffer:z)})},!i.thisProgram&&1<process.argv.length&&(p=process.argv[1].replace(/\\/g,"/")),process.argv.slice(2),d=(h,g)=>{throw process.exitCode=h,g},i.inspect=()=>"[Emscripten Module object]";let c;try{c=Dp()}catch(h){throw console.error('The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?'),h}global.Worker=c.Worker}else(T||O)&&(O?E=self.location.href:typeof document<"u"&&document.currentScript&&(E=document.currentScript.src),typeof a<"u"&&a&&(E=a),E.indexOf("blob:")!==0?E=E.substr(0,E.replace(/[?#].*/,"").lastIndexOf("/")+1):E="",v||(B=c=>{var h=new XMLHttpRequest;return h.open("GET",c,!1),h.send(null),h.responseText},O&&(j=c=>{var h=new XMLHttpRequest;return h.open("GET",c,!1),h.responseType="arraybuffer",h.send(null),new Uint8Array(h.response)}),K=(c,h,g)=>{var I=new XMLHttpRequest;I.open("GET",c,!0),I.responseType="arraybuffer",I.onload=()=>{I.status==200||I.status==0&&I.response?h(I.response):g()},I.onerror=g,I.send(null)}));v&&typeof performance>"u"&&(global.performance=Lp().performance);var $e=console.log.bind(console),He=console.error.bind(console);v&&($e=(...c)=>M.writeSync(1,c.join(" ")+`
`),He=(...c)=>M.writeSync(2,c.join(" ")+`
`));var it=$e,V=He;Object.assign(i,f),f=null,typeof WebAssembly!="object"&&Le("no native wasm support detected");var ve,Je,re=!1,Be,Ze,ot,at,Ie,qe;function gt(){var c=ve.buffer;i.HEAP8=Ze=new Int8Array(c),i.HEAP16=new Int16Array(c),i.HEAPU8=ot=new Uint8Array(c),i.HEAPU16=new Uint16Array(c),i.HEAP32=at=new Int32Array(c),i.HEAPU32=Ie=new Uint32Array(c),i.HEAPF32=new Float32Array(c),i.HEAPF64=qe=new Float64Array(c)}var Bt=16777216;if(S)ve=i.wasmMemory;else if(i.wasmMemory)ve=i.wasmMemory;else if(ve=new WebAssembly.Memory({initial:Bt/65536,maximum:65536,shared:!0}),!(ve.buffer instanceof SharedArrayBuffer))throw V("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"),v&&V("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and/or recent version)"),Error("bad memory");gt(),Bt=ve.buffer.byteLength;var Nt=[],Wt=[],At=[],Qe=0,yt=null,Tt=null;function Ne(){if(Qe--,Qe==0&&(yt!==null&&(clearInterval(yt),yt=null),Tt)){var c=Tt;Tt=null,c()}}function Le(c){throw c="Aborted("+c+")",V(c),re=!0,Be=1,c=new WebAssembly.RuntimeError(c+". Build with -sASSERTIONS for more info."),l(c),c}var Rt=c=>c.startsWith("data:application/octet-stream;base64,"),st=c=>c.startsWith("file://"),xt;xt="ort-wasm-threaded.wasm",Rt(xt)||(xt=F(xt));function wr(c){if(j)return j(c);throw"both async and sync fetching of the wasm failed"}function Ht(c){if(T||O){if(typeof fetch=="function"&&!st(c))return fetch(c,{credentials:"same-origin"}).then(h=>{if(!h.ok)throw"failed to load wasm binary file at '"+c+"'";return h.arrayBuffer()}).catch(()=>wr(c));if(K)return new Promise((h,g)=>{K(c,I=>h(new Uint8Array(I)),g)})}return Promise.resolve().then(()=>wr(c))}function Hr(c,h,g){return Ht(c).then(I=>WebAssembly.instantiate(I,h)).then(I=>I).then(g,I=>{V(`failed to asynchronously prepare wasm: ${I}`),Le(I)})}function xn(c,h){var g=xt;return typeof WebAssembly.instantiateStreaming!="function"||Rt(g)||st(g)||v||typeof fetch!="function"?Hr(g,c,h):fetch(g,{credentials:"same-origin"}).then(I=>WebAssembly.instantiateStreaming(I,c).then(h,function(C){return V(`wasm streaming compile failed: ${C}`),V("falling back to ArrayBuffer instantiation"),Hr(g,c,h)}))}var Mt,_r={921276:(c,h,g,I)=>{if(typeof i>"u"||!i.cb)return 1;if(c=Sr(c>>>0),c.startsWith("./")&&(c=c.substring(2)),c=i.cb.get(c),!c)return 2;if(h>>>=0,g>>>=0,I>>>=0,h+g>c.byteLength)return 3;try{return e().set(c.subarray(h,h+g),I>>>0),0}catch{return 4}}};function qt(c){this.name="ExitStatus",this.message=`Program terminated with exit(${c})`,this.status=c}var Or=c=>{c.terminate(),c.onmessage=()=>{}},Ir=c=>{J.Pa.length==0&&(Yr(),J.Ya(J.Pa[0]));var h=J.Pa.pop();if(!h)return 6;J.Qa.push(h),J.Ma[c.Oa]=h,h.Oa=c.Oa;var g={cmd:"run",start_routine:c.kb,arg:c.hb,pthread_ptr:c.Oa};return v&&h.unref(),h.postMessage(g,c.qb),0},nr=0,qr=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,jr=(c,h,g)=>{h>>>=0;var I=h+g;for(g=h;c[g]&&!(g>=I);)++g;if(16<g-h&&c.buffer&&qr)return qr.decode(c.buffer instanceof SharedArrayBuffer?c.slice(h,g):c.subarray(h,g));for(I="";h<g;){var C=c[h++];if(C&128){var k=c[h++]&63;if((C&224)==192)I+=String.fromCharCode((C&31)<<6|k);else{var z=c[h++]&63;C=(C&240)==224?(C&15)<<12|k<<6|z:(C&7)<<18|k<<12|z<<6|c[h++]&63,65536>C?I+=String.fromCharCode(C):(C-=65536,I+=String.fromCharCode(55296|C>>10,56320|C&1023))}}else I+=String.fromCharCode(C)}return I},Sr=(c,h)=>(c>>>=0)?jr(e(),c,h):"",vn=c=>{var h=Vo();return c=c(),An(h),c};function he(c,h){var g=arguments.length-2,I=arguments;return vn(()=>{for(var C=Wo(8*g),k=C>>>3,z=0;z<g;z++){var we=I[2+z];s()[k+z>>>0]=we}return Ra(c,g,C,h)})}function Q(c){if(S)return he(0,1,c);Be=c,0<nr||(J.lb(),i.onExit?.(c),re=!0),d(c,new qt(c))}var Ar=c=>{if(Be=c,S)throw On(c),"unwind";Q(c)};function wn(){for(var c=i.numThreads;c--;)Yr();Nt.unshift(()=>{Qe++,_n(()=>Ne())})}function Yr(){var c=F("ort-wasm-threaded.worker.js");c=new Worker(c),J.Pa.push(c)}function _n(c){S?c():Promise.all(J.Pa.map(J.Ya)).then(c)}var J={Pa:[],Qa:[],bb:[],Ma:{},Wa(){S?(J.receiveObjectTransfer=J.jb,J.threadInitTLS=J.ab,J.setExitStatus=J.$a):wn()},$a:c=>Be=c,tb:["$terminateWorker"],lb:()=>{for(var c of J.Qa)Or(c);for(c of J.Pa)Or(c);J.Pa=[],J.Qa=[],J.Ma=[]},Za:c=>{var h=c.Oa;delete J.Ma[h],J.Pa.push(c),J.Qa.splice(J.Qa.indexOf(c),1),c.Oa=0,Uo(h)},jb(){},ab(){J.bb.forEach(c=>c())},Ya:c=>new Promise(h=>{c.onmessage=k=>{k=k.data;var z=k.cmd;if(k.targetThread&&k.targetThread!=Sn()){var we=J.Ma[k.targetThread];we?we.postMessage(k,k.transferList):V(`Internal error! Worker sent a message "${z}" to target pthread ${k.targetThread}, but that thread no longer exists!`)}else z==="checkMailbox"?In():z==="spawnThread"?Ir(k):z==="cleanupThread"?J.Za(J.Ma[k.thread]):z==="killThread"?(k=k.thread,z=J.Ma[k],delete J.Ma[k],Or(z),Uo(k),J.Qa.splice(J.Qa.indexOf(z),1),z.Oa=0):z==="cancelThread"?J.Ma[k.thread].postMessage({cmd:"cancel"}):z==="loaded"?(c.loaded=!0,v&&!c.Oa&&c.unref(),h(c)):z==="alert"?alert(`Thread ${k.threadId}: ${k.text}`):k.target==="setimmediate"?c.postMessage(k):z==="callHandler"?i[k.handler](...k.args):z&&V(`worker sent an unknown command ${z}`)},c.onerror=k=>{throw V(`worker sent an error! ${k.filename}:${k.lineno}: ${k.message}`),k},v&&(c.on("message",k=>c.onmessage({data:k})),c.on("error",k=>c.onerror(k)));var g=[],I=["onExit"],C;for(C of I)i.hasOwnProperty(C)&&g.push(C);c.postMessage({cmd:"load",handlers:g,urlOrBlob:i.mainScriptUrlOrBlob||a,wasmMemory:ve,wasmModule:Je})})};i.PThread=J;var or=c=>{for(;0<c.length;)c.shift()(i)};i.establishStackSpace=()=>{var c=Sn(),h=n()[c+52>>>2>>>0];c=n()[c+56>>>2>>>0],Ua(h,h-c),An(h)};function On(c){if(S)return he(1,0,c);Ar(c)}var Gt=[],Xr;i.invokeEntryPoint=(c,h)=>{var g=Gt[c];g||(c>=Gt.length&&(Gt.length=c+1),Gt[c]=g=Xr.get(c)),c=g(h),0<nr?J.$a(c):zo(c)};function b(c){this.Va=c-24,this.gb=function(h){n()[this.Va+4>>>2>>>0]=h},this.fb=function(h){n()[this.Va+8>>>2>>>0]=h},this.Wa=function(h,g){this.eb(),this.gb(h),this.fb(g)},this.eb=function(){n()[this.Va+16>>>2>>>0]=0}}var x=0,w=0;function D(c,h,g,I){return S?he(2,1,c,h,g,I):G(c,h,g,I)}function G(c,h,g,I){if(c>>>=0,h>>>=0,g>>>=0,I>>>=0,typeof SharedArrayBuffer>"u")return V("Current environment does not support SharedArrayBuffer, pthreads are not available!"),6;var C=[];return S&&C.length===0?D(c,h,g,I):(c={kb:g,Oa:c,hb:I,qb:C},S?(c.sb="spawnThread",postMessage(c,C),0):Ir(c))}function Y(c,h,g){return S?he(3,1,c,h,g):0}function ne(c,h){if(S)return he(4,1,c,h)}var Ce=c=>{for(var h=0,g=0;g<c.length;++g){var I=c.charCodeAt(g);127>=I?h++:2047>=I?h+=2:55296<=I&&57343>=I?(h+=4,++g):h+=3}return h},je=(c,h,g,I)=>{if(g>>>=0,!(0<I))return 0;var C=g;I=g+I-1;for(var k=0;k<c.length;++k){var z=c.charCodeAt(k);if(55296<=z&&57343>=z){var we=c.charCodeAt(++k);z=65536+((z&1023)<<10)|we&1023}if(127>=z){if(g>=I)break;h[g++>>>0]=z}else{if(2047>=z){if(g+1>=I)break;h[g++>>>0]=192|z>>6}else{if(65535>=z){if(g+2>=I)break;h[g++>>>0]=224|z>>12}else{if(g+3>=I)break;h[g++>>>0]=240|z>>18,h[g++>>>0]=128|z>>12&63}h[g++>>>0]=128|z>>6&63}h[g++>>>0]=128|z&63}}return h[g>>>0]=0,g-C},Ue=(c,h,g)=>je(c,e(),h,g);function ze(c,h){if(S)return he(5,1,c,h)}function Kr(c,h,g){if(S)return he(6,1,c,h,g)}function Jr(c,h,g){return S?he(7,1,c,h,g):0}function A(c,h){if(S)return he(8,1,c,h)}function pe(c,h,g){if(S)return he(9,1,c,h,g)}function Te(c,h,g,I){if(S)return he(10,1,c,h,g,I)}function Pt(c,h,g,I){if(S)return he(11,1,c,h,g,I)}function Zr(c,h,g,I){if(S)return he(12,1,c,h,g,I)}function ga(c){if(S)return he(13,1,c)}function ya(c,h){if(S)return he(14,1,c,h)}function Ta(c,h,g){if(S)return he(15,1,c,h,g)}function Bo(c){c>>>=0,typeof Atomics.rb=="function"&&(Atomics.rb(r(),c>>>2,c).value.then(In),c+=128,Atomics.store(r(),c>>>2,1))}i.__emscripten_thread_mailbox_await=Bo;var In=()=>{var c=Sn();if(c&&(Bo(c),c=Ma,!re))try{if(c(),!(0<nr))try{S?zo(Be):Ar(Be)}catch(h){h instanceof qt||h=="unwind"||d(1,h)}}catch(h){h instanceof qt||h=="unwind"||d(1,h)}};i.checkMailbox=In;var No=[],Pr=c=>c%4===0&&(c%100!==0||c%400===0),xa=[0,31,60,91,121,152,182,213,244,274,305,335],va=[0,31,59,90,120,151,181,212,243,273,304,334];function wa(c,h,g,I,C,k,z,we){return S?he(16,1,c,h,g,I,C,k,z,we):-52}function _a(c,h,g,I,C,k,z){if(S)return he(17,1,c,h,g,I,C,k,z)}var Oa=c=>{var h=Ce(c)+1,g=Ba(h);return g&&Ue(c,g,h),g},Ro=[],Mo={},Ia=()=>{if(!Go){var c={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:p||"./this.program"},h;for(h in Mo)Mo[h]===void 0?delete c[h]:c[h]=Mo[h];var g=[];for(h in c)g.push(`${h}=${c[h]}`);Go=g}return Go},Go;function Sa(c,h){if(S)return he(18,1,c,h);c>>>=0,h>>>=0;var g=0;return Ia().forEach((I,C)=>{var k=h+g;for(C=n()[c+4*C>>>2>>>0]=k,k=0;k<I.length;++k)o()[C++>>>0>>>0]=I.charCodeAt(k);o()[C>>>0>>>0]=0,g+=I.length+1}),0}function Aa(c,h){if(S)return he(19,1,c,h);c>>>=0,h>>>=0;var g=Ia();n()[c>>>2>>>0]=g.length;var I=0;return g.forEach(C=>I+=C.length+1),n()[h>>>2>>>0]=I,0}function Pa(c){return S?he(20,1,c):52}function Ea(c,h,g,I){return S?he(21,1,c,h,g,I):52}function Da(c,h,g,I,C){return S?he(22,1,c,h,g,I,C):70}var gd=[null,[],[]];function La(c,h,g,I){if(S)return he(23,1,c,h,g,I);h>>>=0,g>>>=0,I>>>=0;for(var C=0,k=0;k<g;k++){var z=n()[h>>>2>>>0],we=n()[h+4>>>2>>>0];h+=8;for(var Et=0;Et<we;Et++){var Re=e()[z+Et>>>0],et=gd[c];Re===0||Re===10?((c===1?it:V)(jr(et,0)),et.length=0):et.push(Re)}C+=we}return n()[I>>>2>>>0]=C,0}var Fa=[31,29,31,30,31,30,31,31,30,31,30,31],$a=[31,28,31,30,31,30,31,31,30,31,30,31];function yd(c){var h=Array(Ce(c)+1);return je(c,h,0,h.length),h}var Td=(c,h)=>{o().set(c,h>>>0)};function Ca(c,h,g,I){function C(P,de,_e){for(P=typeof P=="number"?P.toString():P||"";P.length<de;)P=_e[0]+P;return P}function k(P,de){return C(P,de,"0")}function z(P,de){function _e(Ha){return 0>Ha?-1:0<Ha?1:0}var ir;return(ir=_e(P.getFullYear()-de.getFullYear()))===0&&(ir=_e(P.getMonth()-de.getMonth()))===0&&(ir=_e(P.getDate()-de.getDate())),ir}function we(P){switch(P.getDay()){case 0:return new Date(P.getFullYear()-1,11,29);case 1:return P;case 2:return new Date(P.getFullYear(),0,3);case 3:return new Date(P.getFullYear(),0,2);case 4:return new Date(P.getFullYear(),0,1);case 5:return new Date(P.getFullYear()-1,11,31);case 6:return new Date(P.getFullYear()-1,11,30)}}function Et(P){var de=P.Ra;for(P=new Date(new Date(P.Sa+1900,0,1).getTime());0<de;){var _e=P.getMonth(),ir=(Pr(P.getFullYear())?Fa:$a)[_e];if(de>ir-P.getDate())de-=ir-P.getDate()+1,P.setDate(1),11>_e?P.setMonth(_e+1):(P.setMonth(0),P.setFullYear(P.getFullYear()+1));else{P.setDate(P.getDate()+de);break}}return _e=new Date(P.getFullYear()+1,0,4),de=we(new Date(P.getFullYear(),0,4)),_e=we(_e),0>=z(de,P)?0>=z(_e,P)?P.getFullYear()+1:P.getFullYear():P.getFullYear()-1}c>>>=0,h>>>=0,g>>>=0,I>>>=0;var Re=n()[I+40>>>2>>>0];I={ob:r()[I>>>2>>>0],nb:r()[I+4>>>2>>>0],Ta:r()[I+8>>>2>>>0],Xa:r()[I+12>>>2>>>0],Ua:r()[I+16>>>2>>>0],Sa:r()[I+20>>>2>>>0],Na:r()[I+24>>>2>>>0],Ra:r()[I+28>>>2>>>0],ub:r()[I+32>>>2>>>0],mb:r()[I+36>>>2>>>0],pb:Re?Sr(Re):""},g=Sr(g),Re={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var et in Re)g=g.replace(new RegExp(et,"g"),Re[et]);var Va="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),Wa="January February March April May June July August September October November December".split(" ");Re={"%a":P=>Va[P.Na].substring(0,3),"%A":P=>Va[P.Na],"%b":P=>Wa[P.Ua].substring(0,3),"%B":P=>Wa[P.Ua],"%C":P=>k((P.Sa+1900)/100|0,2),"%d":P=>k(P.Xa,2),"%e":P=>C(P.Xa,2," "),"%g":P=>Et(P).toString().substring(2),"%G":P=>Et(P),"%H":P=>k(P.Ta,2),"%I":P=>(P=P.Ta,P==0?P=12:12<P&&(P-=12),k(P,2)),"%j":P=>{for(var de=0,_e=0;_e<=P.Ua-1;de+=(Pr(P.Sa+1900)?Fa:$a)[_e++]);return k(P.Xa+de,3)},"%m":P=>k(P.Ua+1,2),"%M":P=>k(P.nb,2),"%n":()=>`
`,"%p":P=>0<=P.Ta&&12>P.Ta?"AM":"PM","%S":P=>k(P.ob,2),"%t":()=>"	","%u":P=>P.Na||7,"%U":P=>k(Math.floor((P.Ra+7-P.Na)/7),2),"%V":P=>{var de=Math.floor((P.Ra+7-(P.Na+6)%7)/7);if(2>=(P.Na+371-P.Ra-2)%7&&de++,de)de==53&&(_e=(P.Na+371-P.Ra)%7,_e==4||_e==3&&Pr(P.Sa)||(de=1));else{de=52;var _e=(P.Na+7-P.Ra-1)%7;(_e==4||_e==5&&Pr(P.Sa%400-1))&&de++}return k(de,2)},"%w":P=>P.Na,"%W":P=>k(Math.floor((P.Ra+7-(P.Na+6)%7)/7),2),"%y":P=>(P.Sa+1900).toString().substring(2),"%Y":P=>P.Sa+1900,"%z":P=>{P=P.mb;var de=0<=P;return P=Math.abs(P)/60,(de?"+":"-")+("0000"+(P/60*100+P%60)).slice(-4)},"%Z":P=>P.pb,"%%":()=>"%"},g=g.replace(/%%/g,"\0\0");for(et in Re)g.includes(et)&&(g=g.replace(new RegExp(et,"g"),Re[et](I)));return g=g.replace(/\0\0/g,"%"),et=yd(g),et.length>h?0:(Td(et,c),et.length-1)}J.Wa();var xd=[Q,On,D,Y,ne,ze,Kr,Jr,A,pe,Te,Pt,Zr,ga,ya,Ta,wa,_a,Sa,Aa,Pa,Ea,Da,La],vd={b:function(c,h,g){throw c>>>=0,new b(c).Wa(h>>>0,g>>>0),x=c,w++,x},L:function(c){Na(c>>>0,!O,1,!T,131072,!1),J.ab()},j:function(c){c>>>=0,S?postMessage({cmd:"cleanupThread",thread:c}):J.Za(J.Ma[c])},H:G,h:Y,S:ne,D:ze,F:Kr,T:Jr,Q:A,J:pe,P:Te,n:Pt,E:Zr,B:ga,R:ya,C:Ta,p:()=>1,z:function(c,h){c>>>=0,c==h>>>0?setTimeout(()=>In()):S?postMessage({targetThread:c,cmd:"checkMailbox"}):(c=J.Ma[c])&&c.postMessage({cmd:"checkMailbox"})},I:function(c,h,g,I){h>>>=0,No.length=g,I=I>>>0>>>3;for(var C=0;C<g;C++)No[C]=s()[I+C>>>0];return c=0>c?_r[-c-1]:xd[c],J.ib=h,h=c.apply(null,No),J.ib=0,h},K:Bo,o:function(c){v&&J.Ma[c>>>0].ref()},s:function(c,h,g){c=h+2097152>>>0<4194305-!!c?(c>>>0)+4294967296*h:NaN,g>>>=0,c=new Date(1e3*c),r()[g>>>2>>>0]=c.getUTCSeconds(),r()[g+4>>>2>>>0]=c.getUTCMinutes(),r()[g+8>>>2>>>0]=c.getUTCHours(),r()[g+12>>>2>>>0]=c.getUTCDate(),r()[g+16>>>2>>>0]=c.getUTCMonth(),r()[g+20>>>2>>>0]=c.getUTCFullYear()-1900,r()[g+24>>>2>>>0]=c.getUTCDay(),c=(c.getTime()-Date.UTC(c.getUTCFullYear(),0,1,0,0,0,0))/864e5|0,r()[g+28>>>2>>>0]=c},t:function(c,h,g){c=h+2097152>>>0<4194305-!!c?(c>>>0)+4294967296*h:NaN,g>>>=0,c=new Date(1e3*c),r()[g>>>2>>>0]=c.getSeconds(),r()[g+4>>>2>>>0]=c.getMinutes(),r()[g+8>>>2>>>0]=c.getHours(),r()[g+12>>>2>>>0]=c.getDate(),r()[g+16>>>2>>>0]=c.getMonth(),r()[g+20>>>2>>>0]=c.getFullYear()-1900,r()[g+24>>>2>>>0]=c.getDay(),h=(Pr(c.getFullYear())?xa:va)[c.getMonth()]+c.getDate()-1|0,r()[g+28>>>2>>>0]=h,r()[g+36>>>2>>>0]=-(60*c.getTimezoneOffset()),h=new Date(c.getFullYear(),6,1).getTimezoneOffset();var I=new Date(c.getFullYear(),0,1).getTimezoneOffset();c=(h!=I&&c.getTimezoneOffset()==Math.min(I,h))|0,r()[g+32>>>2>>>0]=c},u:function(c){c>>>=0;var h=new Date(r()[c+20>>>2>>>0]+1900,r()[c+16>>>2>>>0],r()[c+12>>>2>>>0],r()[c+8>>>2>>>0],r()[c+4>>>2>>>0],r()[c>>>2>>>0],0),g=r()[c+32>>>2>>>0],I=h.getTimezoneOffset(),C=new Date(h.getFullYear(),6,1).getTimezoneOffset(),k=new Date(h.getFullYear(),0,1).getTimezoneOffset(),z=Math.min(k,C);return 0>g?r()[c+32>>>2>>>0]=+(C!=k&&z==I):0<g!=(z==I)&&(C=Math.max(k,C),h.setTime(h.getTime()+6e4*((0<g?z:C)-I))),r()[c+24>>>2>>>0]=h.getDay(),g=(Pr(h.getFullYear())?xa:va)[h.getMonth()]+h.getDate()-1|0,r()[c+28>>>2>>>0]=g,r()[c>>>2>>>0]=h.getSeconds(),r()[c+4>>>2>>>0]=h.getMinutes(),r()[c+8>>>2>>>0]=h.getHours(),r()[c+12>>>2>>>0]=h.getDate(),r()[c+16>>>2>>>0]=h.getMonth(),r()[c+20>>>2>>>0]=h.getYear(),c=h.getTime(),isNaN(c)?(r()[ka()>>>2>>>0]=61,c=-1):c/=1e3,Ga((Mt=c,1<=+Math.abs(Mt)?0<Mt?+Math.floor(Mt/4294967296)>>>0:~~+Math.ceil((Mt-+(~~Mt>>>0))/4294967296)>>>0:0)),c>>>0},q:wa,r:_a,y:function(c,h,g){function I(Re){return(Re=Re.toTimeString().match(/\(([A-Za-z ]+)\)$/))?Re[1]:"GMT"}c>>>=0,h>>>=0,g>>>=0;var C=new Date().getFullYear(),k=new Date(C,0,1),z=new Date(C,6,1);C=k.getTimezoneOffset();var we=z.getTimezoneOffset(),Et=Math.max(C,we);n()[c>>>2>>>0]=60*Et,r()[h>>>2>>>0]=+(C!=we),c=I(k),h=I(z),c=Oa(c),h=Oa(h),we<C?(n()[g>>>2>>>0]=c,n()[g+4>>>2>>>0]=h):(n()[g>>>2>>>0]=h,n()[g+4>>>2>>>0]=c)},c:()=>{Le("")},O:function(c,h,g){c>>>=0,h>>>=0,g>>>=0,Ro.length=0;for(var I;I=e()[h++>>>0];){var C=I!=105;C&=I!=112,g+=C&&g%8?4:0,Ro.push(I==112?n()[g>>>2>>>0]:I==105?r()[g>>>2>>>0]:s()[g>>>3>>>0]),g+=C?8:4}return _r[c].apply(null,Ro)},k:()=>{},i:()=>Date.now(),U:()=>{throw nr+=1,"unwind"},A:function(){return 4294901760},e:()=>performance.timeOrigin+performance.now(),f:()=>v?($p(),jt(Fp)).cpus().length:navigator.hardwareConcurrency,x:function(c){c>>>=0;var h=e().length;if(c<=h||4294901760<c)return!1;for(var g=1;4>=g;g*=2){var I=h*(1+.2/g);I=Math.min(I,c+100663296);var C=Math;I=Math.max(c,I);e:{C=(C.min.call(C,4294901760,I+(65536-I%65536)%65536)-ve.buffer.byteLength+65535)/65536;try{ve.grow(C),gt();var k=1;break e}catch{}k=void 0}if(k)return!0}return!1},M:Sa,N:Aa,G:Ar,g:Pa,m:Ea,v:Da,l:La,a:ve||i.wasmMemory,w:Ca,d:function(c,h,g,I){return Ca(c>>>0,h>>>0,g>>>0,I>>>0)}},X=function(){function c(g,I){return X=g.exports,X=wd(),J.bb.push(X.za),Xr=X.Aa,Wt.unshift(X.V),Je=I,Ne(),X}var h={a:vd};if(Qe++,i.instantiateWasm)try{return i.instantiateWasm(h,c)}catch(g){V(`Module.instantiateWasm callback failed with error: ${g}`),l(g)}return xn(h,function(g){c(g.instance,g.module)}).catch(l),{}}();i._OrtInit=(c,h)=>(i._OrtInit=X.W)(c,h),i._OrtGetLastError=(c,h)=>(i._OrtGetLastError=X.X)(c,h),i._OrtCreateSessionOptions=(c,h,g,I,C,k,z,we,Et,Re)=>(i._OrtCreateSessionOptions=X.Y)(c,h,g,I,C,k,z,we,Et,Re),i._OrtAppendExecutionProvider=(c,h)=>(i._OrtAppendExecutionProvider=X.Z)(c,h),i._OrtAddFreeDimensionOverride=(c,h,g)=>(i._OrtAddFreeDimensionOverride=X._)(c,h,g),i._OrtAddSessionConfigEntry=(c,h,g)=>(i._OrtAddSessionConfigEntry=X.$)(c,h,g),i._OrtReleaseSessionOptions=c=>(i._OrtReleaseSessionOptions=X.aa)(c),i._OrtCreateSession=(c,h,g)=>(i._OrtCreateSession=X.ba)(c,h,g),i._OrtReleaseSession=c=>(i._OrtReleaseSession=X.ca)(c),i._OrtGetInputOutputCount=(c,h,g)=>(i._OrtGetInputOutputCount=X.da)(c,h,g),i._OrtGetInputName=(c,h)=>(i._OrtGetInputName=X.ea)(c,h),i._OrtGetOutputName=(c,h)=>(i._OrtGetOutputName=X.fa)(c,h),i._OrtFree=c=>(i._OrtFree=X.ga)(c),i._OrtCreateTensor=(c,h,g,I,C,k)=>(i._OrtCreateTensor=X.ha)(c,h,g,I,C,k),i._OrtGetTensorData=(c,h,g,I,C)=>(i._OrtGetTensorData=X.ia)(c,h,g,I,C),i._OrtReleaseTensor=c=>(i._OrtReleaseTensor=X.ja)(c),i._OrtCreateRunOptions=(c,h,g,I)=>(i._OrtCreateRunOptions=X.ka)(c,h,g,I),i._OrtAddRunConfigEntry=(c,h,g)=>(i._OrtAddRunConfigEntry=X.la)(c,h,g),i._OrtReleaseRunOptions=c=>(i._OrtReleaseRunOptions=X.ma)(c),i._OrtCreateBinding=c=>(i._OrtCreateBinding=X.na)(c),i._OrtBindInput=(c,h,g)=>(i._OrtBindInput=X.oa)(c,h,g),i._OrtBindOutput=(c,h,g,I)=>(i._OrtBindOutput=X.pa)(c,h,g,I),i._OrtClearBoundOutputs=c=>(i._OrtClearBoundOutputs=X.qa)(c),i._OrtReleaseBinding=c=>(i._OrtReleaseBinding=X.ra)(c),i._OrtRunWithBinding=(c,h,g,I,C)=>(i._OrtRunWithBinding=X.sa)(c,h,g,I,C),i._OrtRun=(c,h,g,I,C,k,z,we)=>(i._OrtRun=X.ta)(c,h,g,I,C,k,z,we),i._OrtEndProfiling=c=>(i._OrtEndProfiling=X.ua)(c);var ka=()=>(ka=X.va)(),Sn=i._pthread_self=()=>(Sn=i._pthread_self=X.wa)(),Ba=i._malloc=c=>(Ba=i._malloc=X.xa)(c);i._free=c=>(i._free=X.ya)(c),i.__emscripten_tls_init=()=>(i.__emscripten_tls_init=X.za)();var Na=i.__emscripten_thread_init=(c,h,g,I,C,k)=>(Na=i.__emscripten_thread_init=X.Ba)(c,h,g,I,C,k);i.__emscripten_thread_crashed=()=>(i.__emscripten_thread_crashed=X.Ca)();var Ra=(c,h,g,I)=>(Ra=X.Da)(c,h,g,I),Uo=c=>(Uo=X.Ea)(c),zo=i.__emscripten_thread_exit=c=>(zo=i.__emscripten_thread_exit=X.Fa)(c),Ma=()=>(Ma=X.Ga)(),Ga=c=>(Ga=X.Ha)(c),Ua=(c,h)=>(Ua=X.Ia)(c,h),Vo=()=>(Vo=X.Ja)(),An=c=>(An=X.Ka)(c),Wo=c=>(Wo=X.La)(c);function wd(){var c=X;c=Object.assign({},c);var h=I=>()=>I()>>>0,g=I=>C=>I(C)>>>0;return c.va=h(c.va),c.wa=h(c.wa),c.xa=g(c.xa),c.emscripten_main_runtime_thread_id=h(c.emscripten_main_runtime_thread_id),c.Ja=h(c.Ja),c.La=g(c.La),c}i.wasmMemory=ve,i.stackAlloc=Wo,i.stackSave=Vo,i.stackRestore=An,i.keepRuntimeAlive=()=>0<nr,i.UTF8ToString=Sr,i.stringToUTF8=Ue,i.lengthBytesUTF8=Ce,i.ExitStatus=qt,i.PThread=J;var Pn;Tt=function c(){Pn||za(),Pn||(Tt=c)};function za(){if(!(0<Qe))if(S)u(i),S||or(Wt),startWorker(i);else{if(i.preRun)for(typeof i.preRun=="function"&&(i.preRun=[i.preRun]);i.preRun.length;)Nt.unshift(i.preRun.shift());or(Nt),0<Qe||Pn||(Pn=!0,i.calledRun=!0,re||(S||or(Wt),u(i),S||or(At)))}}return za(),t.ready}})();typeof kp=="object"&&typeof aa=="object"?aa.exports=Cp:typeof define=="function"&&define.amd&&define([],()=>Cp)});var Np=me((nO,og)=>{og.exports='"use strict";var Module={},ENVIRONMENT_IS_NODE=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string";if(ENVIRONMENT_IS_NODE){var nodeWorkerThreads=require("worker_threads"),parentPort=nodeWorkerThreads.parentPort;parentPort.on("message",e=>onmessage({data:e}));var fs=require("fs"),vm=require("vm");Object.assign(global,{self:global,require,Module,location:{href:__filename},Worker:nodeWorkerThreads.Worker,importScripts:e=>vm.runInThisContext(fs.readFileSync(e,"utf8"),{filename:e}),postMessage:e=>parentPort.postMessage(e),performance:global.performance||{now:Date.now}})}var initializedJS=!1;function threadPrintErr(){var e=Array.prototype.slice.call(arguments).join(" ");if(ENVIRONMENT_IS_NODE){fs.writeSync(2,e+`\n`);return}console.error(e)}function threadAlert(){var e=Array.prototype.slice.call(arguments).join(" ");postMessage({cmd:"alert",text:e,threadId:Module._pthread_self()})}var err=threadPrintErr;self.alert=threadAlert,Module.instantiateWasm=(e,t)=>{var a=Module.wasmModule;Module.wasmModule=null;var r=new WebAssembly.Instance(a,e);return t(r)},self.onunhandledrejection=e=>{throw e.reason||e};function handleMessage(e){try{if(e.data.cmd==="load"){let a=[];self.onmessage=r=>a.push(r),self.startWorker=r=>{Module=r,postMessage({cmd:"loaded"});for(let s of a)handleMessage(s);self.onmessage=handleMessage},Module.wasmModule=e.data.wasmModule;for(const r of e.data.handlers)Module[r]=(...s)=>{postMessage({cmd:"callHandler",handler:r,args:s})};if(Module.wasmMemory=e.data.wasmMemory,Module.buffer=Module.wasmMemory.buffer,Module.ENVIRONMENT_IS_PTHREAD=!0,typeof e.data.urlOrBlob=="string")importScripts(e.data.urlOrBlob);else{var t=URL.createObjectURL(e.data.urlOrBlob);importScripts(t),URL.revokeObjectURL(t)}ortWasmThreaded(Module)}else if(e.data.cmd==="run"){Module.__emscripten_thread_init(e.data.pthread_ptr,0,0,1),Module.__emscripten_thread_mailbox_await(e.data.pthread_ptr),Module.establishStackSpace(),Module.PThread.receiveObjectTransfer(e.data),Module.PThread.threadInitTLS(),initializedJS||(initializedJS=!0);try{Module.invokeEntryPoint(e.data.start_routine,e.data.arg)}catch(a){if(a!="unwind")throw a}}else e.data.cmd==="cancel"?Module._pthread_self()&&Module.__emscripten_thread_exit(-1):e.data.target==="setimmediate"||(e.data.cmd==="checkMailbox"?initializedJS&&Module.checkMailbox():e.data.cmd&&(err(`worker.js received unknown command ${e.data.cmd}`),err(e.data)))}catch(a){throw Module.__emscripten_thread_crashed?.(),a}}self.onmessage=handleMessage;\n'});var Mp,ig,sa,ua,Po,Rp,ag,sg,ug,Gp,Ee,zr=L(()=>{"use strict";Mp=Ep();ig=Bp(),ua=!1,Po=!1,Rp=!1,ag=a=>{if(a===1)return!1;if(typeof SharedArrayBuffer>"u")return typeof self<"u"&&!self.crossOriginIsolated&&console.warn("env.wasm.numThreads is set to "+a+", but this will not work unless you enable crossOriginIsolated mode. See https://web.dev/cross-origin-isolation-guide/ for more info."),!1;typeof process<"u"&&process.versions&&process.versions.node&&console.warn("env.wasm.numThreads is set to "+a+", however, currently onnxruntime-web does not support multi-threads in Node.js. Please consider using onnxruntime-node for performance critical scenarios.");try{return typeof MessageChannel<"u"&&new MessageChannel().port1.postMessage(new SharedArrayBuffer(1)),WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,5,4,1,3,1,1,10,11,1,9,0,65,0,254,16,2,0,26,11]))}catch{return!1}},sg=()=>{try{return WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,10,30,1,28,0,65,0,253,15,253,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,186,1,26,11]))}catch{return!1}},ug=(a,t)=>a?t?"ort-wasm-simd-threaded.wasm":"ort-wasm-simd.wasm":t?"ort-wasm-threaded.wasm":"ort-wasm.wasm",Gp=async a=>{if(ua)return Promise.resolve();if(Po)throw new Error("multiple calls to 'initializeWebAssembly()' detected.");if(Rp)throw new Error("previous call to 'initializeWebAssembly()' failed.");Po=!0;let t=a.initTimeout,o=a.numThreads,e=a.simd,r=ag(o),n=e&&sg(),s=a.wasmPaths,i=typeof s=="string"?s:void 0,u=ug(n,r),l=typeof s=="object"?s[u]:void 0,f=!1,p=[];if(t>0&&p.push(new Promise(d=>{setTimeout(()=>{f=!0,d()},t)})),p.push(new Promise((d,T)=>{let O=r?ig:Mp,v={locateFile:(S,E)=>r&&S.endsWith(".worker.js")&&typeof Blob<"u"?URL.createObjectURL(new Blob([Np()],{type:"text/javascript"})):S.endsWith(".wasm")?l||(i??E)+u:E+S};if(r)if(v.numThreads=o,typeof Blob>"u")v.mainScriptUrlOrBlob=(void 0)(__dirname,"ort-wasm-threaded.js");else{let S=`var ortWasmThreaded=${O.toString()};`;v.mainScriptUrlOrBlob=new Blob([S],{type:"text/javascript"})}O(v).then(S=>{Po=!1,ua=!0,sa=S,d()},S=>{Po=!1,Rp=!0,T(S)})})),await Promise.race(p),f)throw new Error(`WebAssembly backend initializing failed due to timeout: ${t}ms`)},Ee=()=>{if(ua&&sa)return sa;throw new Error("WebAssembly is not initialized yet.")}});var De,bn,Oe,Eo=L(()=>{"use strict";zr();De=(a,t)=>{let o=Ee(),e=o.lengthBytesUTF8(a)+1,r=o._malloc(e);return o.stringToUTF8(a,r,e),t.push(r),r},bn=(a,t,o,e)=>{if(typeof a=="object"&&a!==null){if(o.has(a))throw new Error("Circular reference in options");o.add(a)}Object.entries(a).forEach(([r,n])=>{let s=t?t+r:r;if(typeof n=="object")bn(n,s+".",o,e);else if(typeof n=="string"||typeof n=="number")e(s,n.toString());else if(typeof n=="boolean")e(s,n?"1":"0");else throw new Error(`Can't handle extra config type: ${typeof n}`)})},Oe=a=>{let t=Ee(),o=t.stackSave();try{let e=t.stackAlloc(8);t._OrtGetLastError(e,e+4);let r=t.HEAP32[e/4],n=t.HEAPU32[e/4+1],s=n?t.UTF8ToString(n):"";throw new Error(`${a} ERROR_CODE: ${r}, ERROR_MESSAGE: ${s}`)}finally{t.stackRestore(o)}}});var Up,zp=L(()=>{"use strict";zr();Eo();Up=a=>{let t=Ee(),o=0,e=[],r=a||{};try{if(a?.logSeverityLevel===void 0)r.logSeverityLevel=2;else if(typeof a.logSeverityLevel!="number"||!Number.isInteger(a.logSeverityLevel)||a.logSeverityLevel<0||a.logSeverityLevel>4)throw new Error(`log serverity level is not valid: ${a.logSeverityLevel}`);if(a?.logVerbosityLevel===void 0)r.logVerbosityLevel=0;else if(typeof a.logVerbosityLevel!="number"||!Number.isInteger(a.logVerbosityLevel))throw new Error(`log verbosity level is not valid: ${a.logVerbosityLevel}`);a?.terminate===void 0&&(r.terminate=!1);let n=0;return a?.tag!==void 0&&(n=De(a.tag,e)),o=t._OrtCreateRunOptions(r.logSeverityLevel,r.logVerbosityLevel,!!r.terminate,n),o===0&&Oe("Can't create run options."),a?.extra!==void 0&&bn(a.extra,"",new WeakSet,(s,i)=>{let u=De(s,e),l=De(i,e);t._OrtAddRunConfigEntry(o,u,l)!==0&&Oe(`Can't set a run config entry: ${s} - ${i}.`)}),[o,e]}catch(n){throw o!==0&&t._OrtReleaseRunOptions(o),e.forEach(s=>t._free(s)),n}}});var lg,fg,cg,pg,Vp,Wp=L(()=>{"use strict";zr();Eo();lg=a=>{switch(a){case"disabled":return 0;case"basic":return 1;case"extended":return 2;case"all":return 99;default:throw new Error(`unsupported graph optimization level: ${a}`)}},fg=a=>{switch(a){case"sequential":return 0;case"parallel":return 1;default:throw new Error(`unsupported execution mode: ${a}`)}},cg=a=>{a.extra||(a.extra={}),a.extra.session||(a.extra.session={});let t=a.extra.session;t.use_ort_model_bytes_directly||(t.use_ort_model_bytes_directly="1"),a.executionProviders&&a.executionProviders.some(o=>(typeof o=="string"?o:o.name)==="webgpu")&&(a.enableMemPattern=!1)},pg=(a,t,o)=>{for(let e of t){let r=typeof e=="string"?e:e.name;switch(r){case"webnn":if(r="WEBNN",typeof e!="string"){let s=e;if(s?.deviceType){let i=De("deviceType",o),u=De(s.deviceType,o);Ee()._OrtAddSessionConfigEntry(a,i,u)!==0&&Oe(`Can't set a session config entry: 'deviceType' - ${s.deviceType}.`)}if(s?.numThreads){let i=s.numThreads;(typeof i!="number"||!Number.isInteger(i)||i<0)&&(i=0);let u=De("numThreads",o),l=De(i.toString(),o);Ee()._OrtAddSessionConfigEntry(a,u,l)!==0&&Oe(`Can't set a session config entry: 'numThreads' - ${s.numThreads}.`)}if(s?.powerPreference){let i=De("powerPreference",o),u=De(s.powerPreference,o);Ee()._OrtAddSessionConfigEntry(a,i,u)!==0&&Oe(`Can't set a session config entry: 'powerPreference' - ${s.powerPreference}.`)}}break;case"webgpu":if(r="JS",typeof e!="string"){let s=e;if(s?.preferredLayout){if(s.preferredLayout!=="NCHW"&&s.preferredLayout!=="NHWC")throw new Error(`preferredLayout must be either 'NCHW' or 'NHWC': ${s.preferredLayout}`);let i=De("preferredLayout",o),u=De(s.preferredLayout,o);Ee()._OrtAddSessionConfigEntry(a,i,u)!==0&&Oe(`Can't set a session config entry: 'preferredLayout' - ${s.preferredLayout}.`)}}break;case"wasm":case"cpu":continue;default:throw new Error(`not supported execution provider: ${r}`)}let n=De(r,o);Ee()._OrtAppendExecutionProvider(a,n)!==0&&Oe(`Can't append execution provider: ${r}.`)}},Vp=a=>{let t=Ee(),o=0,e=[],r=a||{};cg(r);try{let n=lg(r.graphOptimizationLevel??"all"),s=fg(r.executionMode??"sequential"),i=typeof r.logId=="string"?De(r.logId,e):0,u=r.logSeverityLevel??2;if(!Number.isInteger(u)||u<0||u>4)throw new Error(`log serverity level is not valid: ${u}`);let l=r.logVerbosityLevel??0;if(!Number.isInteger(l)||l<0||l>4)throw new Error(`log verbosity level is not valid: ${l}`);let f=typeof r.optimizedModelFilePath=="string"?De(r.optimizedModelFilePath,e):0;if(o=t._OrtCreateSessionOptions(n,!!r.enableCpuMemArena,!!r.enableMemPattern,s,!!r.enableProfiling,0,i,u,l,f),o===0&&Oe("Can't create session options."),r.executionProviders&&pg(o,r.executionProviders,e),r.freeDimensionOverrides)for(let[p,d]of Object.entries(r.freeDimensionOverrides)){if(typeof p!="string")throw new Error(`free dimension override name must be a string: ${p}`);if(typeof d!="number"||!Number.isInteger(d)||d<0)throw new Error(`free dimension override value must be a non-negative integer: ${d}`);let T=De(p,e);t._OrtAddFreeDimensionOverride(o,T,d)!==0&&Oe(`Can't set a free dimension override: ${p} - ${d}.`)}return r.extra!==void 0&&bn(r.extra,"",new WeakSet,(p,d)=>{let T=De(p,e),O=De(d,e);t._OrtAddSessionConfigEntry(o,T,O)!==0&&Oe(`Can't set a session config entry: ${p} - ${d}.`)}),[o,e]}catch(n){throw o!==0&&t._OrtReleaseSessionOptions(o),e.forEach(s=>t._free(s)),n}}});var la,Hp,fa,qp,jp,Do,Yp,ca=L(()=>{"use strict";la=a=>{switch(a){case"int8":return 3;case"uint8":return 2;case"bool":return 9;case"int16":return 5;case"uint16":return 4;case"int32":return 6;case"uint32":return 12;case"float16":return 10;case"float32":return 1;case"float64":return 11;case"string":return 8;case"int64":return 7;case"uint64":return 13;default:throw new Error(`unsupported data type: ${a}`)}},Hp=a=>{switch(a){case 3:return"int8";case 2:return"uint8";case 9:return"bool";case 5:return"int16";case 4:return"uint16";case 6:return"int32";case 12:return"uint32";case 10:return"float16";case 1:return"float32";case 11:return"float64";case 8:return"string";case 7:return"int64";case 13:return"uint64";default:throw new Error(`unsupported data type: ${a}`)}},fa=a=>[void 0,4,1,1,2,2,4,8,void 0,1,2,8,4,8,void 0,void 0,void 0][a],qp=a=>{switch(a){case"float16":return Uint16Array;case"float32":return Float32Array;case"uint8":return Uint8Array;case"int8":return Int8Array;case"uint16":return Uint16Array;case"int16":return Int16Array;case"int32":return Int32Array;case"bool":return Uint8Array;case"float64":return Float64Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"uint64":return BigUint64Array;default:throw new Error(`unsupported type: ${a}`)}},jp=a=>{switch(a){case"verbose":return 0;case"info":return 1;case"warning":return 2;case"error":return 3;case"fatal":return 4;default:throw new Error(`unsupported logging level: ${a}`)}},Do=a=>a==="float32"||a==="int32"||a==="int64"||a==="bool"||a==="float16"||a==="uint32",Yp=a=>{switch(a){case"none":return 0;case"cpu":return 1;case"cpu-pinned":return 2;case"texture":return 3;case"gpu-buffer":return 4;default:throw new Error(`unsupported data location: ${a}`)}}});var gn,pa=L(()=>{"use strict";gn=async a=>{if(typeof a=="string")if(typeof process<"u"&&process.versions&&process.versions.node)try{return new Uint8Array(await(void 0)(a))}catch(t){if(t.code==="ERR_FS_FILE_TOO_LARGE"){let o=(void 0)(a),e=[];for await(let r of o)e.push(r);return new Uint8Array(Buffer.concat(e))}throw t}else{let t=await fetch(a);if(!t.ok)throw new Error(`failed to load external data file: ${a}`);let o=t.headers.get("Content-Length"),e=o?parseInt(o,10):0;if(e<1073741824)return new Uint8Array(await t.arrayBuffer());{if(!t.body)throw new Error(`failed to load external data file: ${a}, no response body.`);let r=t.body.getReader(),n;try{n=new ArrayBuffer(e)}catch(i){if(i instanceof RangeError){let u=Math.ceil(e/65536);n=new WebAssembly.Memory({initial:u,maximum:u}).buffer}else throw i}let s=0;for(;;){let{done:i,value:u}=await r.read();if(i)break;let l=u.byteLength;new Uint8Array(n,s,l).set(u),s+=l}return new Uint8Array(n,0,e)}}else return a instanceof Blob?new Uint8Array(await a.arrayBuffer()):a instanceof Uint8Array?a:new Uint8Array(a)}});var dg,Kp,Jp,yn,hg,da,Zp,Qp,Xp,ed,td,rd,nd=L(()=>{"use strict";zp();Wp();ca();zr();Eo();pa();dg=(a,t)=>{Ee()._OrtInit(a,t)!==0&&Oe("Can't initialize onnxruntime.")},Kp=async a=>{dg(a.wasm.numThreads,jp(a.logLevel))},Jp=async(a,t)=>{},yn=new Map,hg=a=>{let t=Ee(),o=t.stackSave();try{let e=t.stackAlloc(8);return t._OrtGetInputOutputCount(a,e,e+4)!==0&&Oe("Can't get session input/output count."),[t.HEAP32[e/4],t.HEAP32[e/4+1]]}finally{t.stackRestore(o)}},da=a=>{let t=Ee(),o=t._malloc(a.byteLength);if(o===0)throw new Error(`Can't create a session. failed to allocate a buffer of size ${a.byteLength}.`);return t.HEAPU8.set(a,o),[o,a.byteLength]},Zp=async(a,t)=>{let o,e,r=Ee();Array.isArray(a)?[o,e]=a:a.buffer===r.HEAPU8.buffer?[o,e]=[a.byteOffset,a.byteLength]:[o,e]=da(a);let n=0,s=0,i=0,u=[],l=[],f=[];try{if([s,u]=Vp(t),t?.externalData&&r.mountExternalData){let E=[];for(let F of t.externalData){let B=typeof F=="string"?F:F.path;E.push(gn(typeof F=="string"?F:F.data).then(K=>{r.mountExternalData(B,K)}))}await Promise.all(E)}n=r._OrtCreateSession(o,e,s),n===0&&Oe("Can't create a session.");let[p,d]=hg(n),T=[],O=[],v=[];for(let E=0;E<p;E++){let F=r._OrtGetInputName(n,E);F===0&&Oe("Can't get an input name."),l.push(F),T.push(r.UTF8ToString(F))}for(let E=0;E<d;E++){let F=r._OrtGetOutputName(n,E);F===0&&Oe("Can't get an output name."),f.push(F);let B=r.UTF8ToString(F);O.push(B)}let S=null;return yn.set(n,[n,l,f,S]),[n,T,O]}catch(p){throw l.forEach(d=>r._OrtFree(d)),f.forEach(d=>r._OrtFree(d)),i!==0&&r._OrtReleaseBinding(i),n!==0&&r._OrtReleaseSession(n),p}finally{r._free(o),s!==0&&r._OrtReleaseSessionOptions(s),u.forEach(p=>r._free(p)),r.unmountExternalData?.()}},Qp=a=>{let t=Ee(),o=yn.get(a);if(!o)throw new Error(`cannot release session. invalid session id: ${a}`);let[e,r,n,s]=o;s&&t._OrtReleaseBinding(s.handle),t.jsepUnregisterBuffers?.(a),r.forEach(i=>t._OrtFree(i)),n.forEach(i=>t._OrtFree(i)),t._OrtReleaseSession(e),yn.delete(a)},Xp=(a,t,o,e,r)=>{if(!a){t.push(0);return}let n=Ee(),s=a[0],i=a[1],u=a[3],l,f;if(s==="string"&&u==="gpu-buffer")throw new Error("String tensor is not supported on GPU.");if(u==="gpu-buffer"){let T=a[2].gpuBuffer,O=fa(la(s));f=i.reduce((v,S)=>v*S,1)*O,l=n.jsepRegisterBuffer(e,r,T,f)}else{let T=a[2];if(Array.isArray(T)){f=4*T.length,l=n._malloc(f),o.push(l);let O=l/4;for(let v=0;v<T.length;v++){if(typeof T[v]!="string")throw new TypeError(`tensor data at index ${v} is not a string`);n.HEAPU32[O++]=De(T[v],o)}}else f=T.byteLength,l=n._malloc(f),o.push(l),n.HEAPU8.set(new Uint8Array(T.buffer,T.byteOffset,f),l)}let p=n.stackSave(),d=n.stackAlloc(4*i.length);try{let T=d/4;i.forEach(v=>n.HEAP32[T++]=v);let O=n._OrtCreateTensor(la(s),l,f,d,i.length,Yp(u));O===0&&Oe(`Can't create tensor for input/output. session=${e}, index=${r}.`),t.push(O)}finally{n.stackRestore(p)}},ed=async(a,t,o,e,r,n)=>{let s=Ee(),i=yn.get(a);if(!i)throw new Error(`cannot run inference. invalid session id: ${a}`);let[u,l,f,p]=i,d=t.length,T=e.length,O=0,v=[],S=[],E=[],F=[],B=s.stackSave(),K=s.stackAlloc(d*4),j=s.stackAlloc(d*4),M=s.stackAlloc(T*4),ie=s.stackAlloc(T*4);try{[O,v]=Up(n);for(let re=0;re<d;re++)Xp(o[re],S,F,a,t[re]);for(let re=0;re<T;re++)Xp(r[re],E,F,a,d+e[re]);let $e=K/4,He=j/4,it=M/4,V=ie/4;for(let re=0;re<d;re++)s.HEAPU32[$e++]=S[re],s.HEAPU32[He++]=l[t[re]];for(let re=0;re<T;re++)s.HEAPU32[it++]=E[re],s.HEAPU32[V++]=f[e[re]];let ve;ve=await s._OrtRun(u,j,K,d,ie,T,M,O),ve!==0&&Oe("failed to call OrtRun().");let Je=[];for(let re=0;re<T;re++){let Be=s.HEAPU32[M/4+re];if(Be===E[re]){Je.push(r[re]);continue}let Ze=s.stackSave(),ot=s.stackAlloc(4*4),at=!1,Ie,qe=0;try{s._OrtGetTensorData(Be,ot,ot+4,ot+8,ot+12)!==0&&Oe(`Can't access output tensor data on index ${re}.`);let Bt=ot/4,Nt=s.HEAPU32[Bt++];qe=s.HEAPU32[Bt++];let Wt=s.HEAPU32[Bt++],At=s.HEAPU32[Bt++],Qe=[];for(let Ne=0;Ne<At;Ne++)Qe.push(s.HEAPU32[Wt/4+Ne]);s._OrtFree(Wt);let yt=Qe.reduce((Ne,Le)=>Ne*Le,1);Ie=Hp(Nt);let Tt=p?.outputPreferredLocations[e[re]];if(Ie==="string"){if(Tt==="gpu-buffer")throw new Error("String tensor is not supported on GPU.");let Ne=[],Le=qe/4;for(let Rt=0;Rt<yt;Rt++){let st=s.HEAPU32[Le++],xt=Rt===yt-1?void 0:s.HEAPU32[Le]-st;Ne.push(s.UTF8ToString(st,xt))}Je.push([Ie,Qe,Ne,"cpu"])}else if(Tt==="gpu-buffer"&&yt>0){let Ne=s.jsepGetBuffer(qe),Le=fa(Nt);if(Le===void 0||!Do(Ie))throw new Error(`Unsupported data type: ${Ie}`);at=!0,Je.push([Ie,Qe,{gpuBuffer:Ne,download:s.jsepCreateDownloader(Ne,yt*Le,Ie),dispose:()=>{s._OrtReleaseTensor(Be)}},"gpu-buffer"])}else{let Ne=qp(Ie),Le=new Ne(yt);new Uint8Array(Le.buffer,Le.byteOffset,Le.byteLength).set(s.HEAPU8.subarray(qe,qe+Le.byteLength)),Je.push([Ie,Qe,Le,"cpu"])}}finally{s.stackRestore(Ze),Ie==="string"&&qe&&s._free(qe),at||s._OrtReleaseTensor(Be)}}return p&&s._OrtClearBoundOutputs(p.handle),Je}finally{s.stackRestore(B),S.forEach($e=>s._OrtReleaseTensor($e)),E.forEach($e=>s._OrtReleaseTensor($e)),F.forEach($e=>s._free($e)),O!==0&&s._OrtReleaseRunOptions(O),v.forEach($e=>s._free($e))}},td=a=>{let t=Ee(),o=yn.get(a);if(!o)throw new Error("invalid session id");let e=o[0],r=t._OrtEndProfiling(e);r===0&&Oe("Can't get an profile file name."),t._OrtFree(r)},rd=a=>{let t=[];for(let o of a){let e=o[2];!Array.isArray(e)&&"buffer"in e&&t.push(e.buffer)}return t}});var od=me((wO,bg)=>{bg.exports='/*!\n * ONNX Runtime Web v1.17.1\n * Copyright (c) Microsoft Corporation. All rights reserved.\n * Licensed under the MIT License.\n */\n"use strict";(()=>{var Et=Object.defineProperty;var Jr=Object.getOwnPropertyDescriptor;var Xr=Object.getOwnPropertyNames;var Qr=Object.prototype.hasOwnProperty;var St=(u,d)=>()=>(u&&(d=u(u=0)),d);var et=(u,d)=>()=>(d||u((d={exports:{}}).exports,d),d.exports),Tt=(u,d)=>{for(var a in d)Et(u,a,{get:d[a],enumerable:!0})},Zr=(u,d,a,h)=>{if(d&&typeof d=="object"||typeof d=="function")for(let l of Xr(d))!Qr.call(u,l)&&l!==a&&Et(u,l,{get:()=>d[l],enumerable:!(h=Jr(d,l))||h.enumerable});return u};var tt=u=>Zr(Et({},"__esModule",{value:!0}),u);var At={};Tt(At,{createReadStream:()=>dr,readFile:()=>Kr,readFileSync:()=>en});var Kr,en,dr,Mt=St(()=>{Kr=void 0,en=void 0,dr=void 0});var Ct={};Tt(Ct,{join:()=>tn});var tn,Dt=St(()=>{tn=void 0});var gr=et((mr,xt)=>{"use strict";var pr=(()=>{var u=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(u=u||__filename),function(d={}){var a=d,h,l;a.ready=new Promise((r,o)=>{h=r,l=o});var w=Object.assign({},a),g="./this.program",i=typeof window=="object",A=typeof importScripts=="function",D=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",I="",B,F,U;if(D){var k=(Mt(),tt(At)),L=(Dt(),tt(Ct));I=A?L.dirname(I)+"/":__dirname+"/",B=(r,o)=>(r=ye(r)?new URL(r):L.normalize(r),k.readFileSync(r,o?void 0:"utf8")),U=r=>(r=B(r,!0),r.buffer||(r=new Uint8Array(r)),r),F=(r,o,s,m=!0)=>{r=ye(r)?new URL(r):L.normalize(r),k.readFile(r,m?void 0:"utf8",(O,S)=>{O?s(O):o(m?S.buffer:S)})},!a.thisProgram&&1<process.argv.length&&(g=process.argv[1].replace(/\\\\/g,"/")),process.argv.slice(2),a.inspect=()=>"[Emscripten Module object]"}else(i||A)&&(A?I=self.location.href:typeof document<"u"&&document.currentScript&&(I=document.currentScript.src),u&&(I=u),I.indexOf("blob:")!==0?I=I.substr(0,I.replace(/[?#].*/,"").lastIndexOf("/")+1):I="",B=r=>{var o=new XMLHttpRequest;return o.open("GET",r,!1),o.send(null),o.responseText},A&&(U=r=>{var o=new XMLHttpRequest;return o.open("GET",r,!1),o.responseType="arraybuffer",o.send(null),new Uint8Array(o.response)}),F=(r,o,s)=>{var m=new XMLHttpRequest;m.open("GET",r,!0),m.responseType="arraybuffer",m.onload=()=>{m.status==200||m.status==0&&m.response?o(m.response):s()},m.onerror=s,m.send(null)});var _=console.log.bind(console),x=console.error.bind(console);Object.assign(a,w),w=null,typeof WebAssembly!="object"&&de("no native wasm support detected");var N,he=!1,ie,ae,E,Y,ue;function Re(){var r=N.buffer;a.HEAP8=ie=new Int8Array(r),a.HEAP16=new Int16Array(r),a.HEAPU8=ae=new Uint8Array(r),a.HEAPU16=new Uint16Array(r),a.HEAP32=E=new Int32Array(r),a.HEAPU32=Y=new Uint32Array(r),a.HEAPF32=new Float32Array(r),a.HEAPF64=ue=new Float64Array(r)}var Ie=[],ee=[],j=[],ce=0,P=null,te=null;function de(r){throw r="Aborted("+r+")",x(r),he=!0,r=new WebAssembly.RuntimeError(r+". Build with -sASSERTIONS for more info."),l(r),r}var ge=r=>r.startsWith("data:application/octet-stream;base64,"),ye=r=>r.startsWith("file://"),J;if(J="ort-wasm.wasm",!ge(J)){var fe=J;J=a.locateFile?a.locateFile(fe,I):I+fe}function we(r){if(U)return U(r);throw"both async and sync fetching of the wasm failed"}function Ae(r){if(i||A){if(typeof fetch=="function"&&!ye(r))return fetch(r,{credentials:"same-origin"}).then(o=>{if(!o.ok)throw"failed to load wasm binary file at \'"+r+"\'";return o.arrayBuffer()}).catch(()=>we(r));if(F)return new Promise((o,s)=>{F(r,m=>o(new Uint8Array(m)),s)})}return Promise.resolve().then(()=>we(r))}function Me(r,o,s){return Ae(r).then(m=>WebAssembly.instantiate(m,o)).then(m=>m).then(s,m=>{x(`failed to asynchronously prepare wasm: ${m}`),de(m)})}function Fe(r,o){var s=J;return typeof WebAssembly.instantiateStreaming!="function"||ge(s)||ye(s)||D||typeof fetch!="function"?Me(s,r,o):fetch(s,{credentials:"same-origin"}).then(m=>WebAssembly.instantiateStreaming(m,r).then(o,function(O){return x(`wasm streaming compile failed: ${O}`),x("falling back to ArrayBuffer instantiation"),Me(s,r,o)}))}var Ee,pe={919888:(r,o,s,m)=>{if(typeof a>"u"||!a.za)return 1;if(r=be(r>>>0),r.startsWith("./")&&(r=r.substring(2)),r=a.za.get(r),!r)return 2;if(o>>>=0,s>>>=0,o+s>r.byteLength)return 3;try{return ae.set(r.subarray(o,o+s),m>>>0>>>0),0}catch{return 4}}};function Oe(r){this.xa=r-24,this.Ha=function(o){Y[this.xa+4>>>2>>>0]=o},this.Ga=function(o){Y[this.xa+8>>>2>>>0]=o},this.Aa=function(o,s){this.Fa(),this.Ha(o),this.Ga(s)},this.Fa=function(){Y[this.xa+16>>>2>>>0]=0}}var ve=0,re=0,Z=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,Ce=(r,o,s)=>{o>>>=0;var m=o+s;for(s=o;r[s]&&!(s>=m);)++s;if(16<s-o&&r.buffer&&Z)return Z.decode(r.subarray(o,s));for(m="";o<s;){var O=r[o++];if(O&128){var S=r[o++]&63;if((O&224)==192)m+=String.fromCharCode((O&31)<<6|S);else{var R=r[o++]&63;O=(O&240)==224?(O&15)<<12|S<<6|R:(O&7)<<18|S<<12|R<<6|r[o++]&63,65536>O?m+=String.fromCharCode(O):(O-=65536,m+=String.fromCharCode(55296|O>>10,56320|O&1023))}}else m+=String.fromCharCode(O)}return m},be=(r,o)=>(r>>>=0)?Ce(ae,r,o):"",_e=r=>{for(var o=0,s=0;s<r.length;++s){var m=r.charCodeAt(s);127>=m?o++:2047>=m?o+=2:55296<=m&&57343>=m?(o+=4,++s):o+=3}return o},ke=(r,o,s,m)=>{if(s>>>=0,!(0<m))return 0;var O=s;m=s+m-1;for(var S=0;S<r.length;++S){var R=r.charCodeAt(S);if(55296<=R&&57343>=R){var K=r.charCodeAt(++S);R=65536+((R&1023)<<10)|K&1023}if(127>=R){if(s>=m)break;o[s++>>>0]=R}else{if(2047>=R){if(s+1>=m)break;o[s++>>>0]=192|R>>6}else{if(65535>=R){if(s+2>=m)break;o[s++>>>0]=224|R>>12}else{if(s+3>=m)break;o[s++>>>0]=240|R>>18,o[s++>>>0]=128|R>>12&63}o[s++>>>0]=128|R>>6&63}o[s++>>>0]=128|R&63}}return o[s>>>0]=0,s-O},Ue=r=>r%4===0&&(r%100!==0||r%400===0),ze=[0,31,60,91,121,152,182,213,244,274,305,335],at=[0,31,59,90,120,151,181,212,243,273,304,334],De=r=>{var o=_e(r)+1,s=st(o);return s&&ke(r,ae,s,o),s},Ne=[],Pe={},He=()=>{if(!$e){var r={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:g||"./this.program"},o;for(o in Pe)Pe[o]===void 0?delete r[o]:r[o]=Pe[o];var s=[];for(o in r)s.push(`${o}=${r[o]}`);$e=s}return $e},$e,Le=[null,[],[]],qe=[31,29,31,30,31,30,31,31,30,31,30,31],Ve=[31,28,31,30,31,30,31,31,30,31,30,31];function Ge(r){var o=Array(_e(r)+1);return ke(r,o,0,o.length),o}function ot(r,o,s,m){function O(c,W,G){for(c=typeof c=="number"?c.toString():c||"";c.length<W;)c=G[0]+c;return c}function S(c,W){return O(c,W,"0")}function R(c,W){function G(Ke){return 0>Ke?-1:0<Ke?1:0}var Se;return(Se=G(c.getFullYear()-W.getFullYear()))===0&&(Se=G(c.getMonth()-W.getMonth()))===0&&(Se=G(c.getDate()-W.getDate())),Se}function K(c){switch(c.getDay()){case 0:return new Date(c.getFullYear()-1,11,29);case 1:return c;case 2:return new Date(c.getFullYear(),0,3);case 3:return new Date(c.getFullYear(),0,2);case 4:return new Date(c.getFullYear(),0,1);case 5:return new Date(c.getFullYear()-1,11,31);case 6:return new Date(c.getFullYear()-1,11,30)}}function le(c){var W=c.ta;for(c=new Date(new Date(c.ua+1900,0,1).getTime());0<W;){var G=c.getMonth(),Se=(Ue(c.getFullYear())?qe:Ve)[G];if(W>Se-c.getDate())W-=Se-c.getDate()+1,c.setDate(1),11>G?c.setMonth(G+1):(c.setMonth(0),c.setFullYear(c.getFullYear()+1));else{c.setDate(c.getDate()+W);break}}return G=new Date(c.getFullYear()+1,0,4),W=K(new Date(c.getFullYear(),0,4)),G=K(G),0>=R(W,c)?0>=R(G,c)?c.getFullYear()+1:c.getFullYear():c.getFullYear()-1}r>>>=0,o>>>=0,s>>>=0,m>>>=0;var oe=Y[m+40>>>2>>>0];m={Da:E[m>>>2>>>0],Ca:E[m+4>>>2>>>0],va:E[m+8>>>2>>>0],ya:E[m+12>>>2>>>0],wa:E[m+16>>>2>>>0],ua:E[m+20>>>2>>>0],oa:E[m+24>>>2>>>0],ta:E[m+28>>>2>>>0],Ia:E[m+32>>>2>>>0],Ba:E[m+36>>>2>>>0],Ea:oe?be(oe):""},s=be(s),oe={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var se in oe)s=s.replace(new RegExp(se,"g"),oe[se]);var Qe="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),Ze="January February March April May June July August September October November December".split(" ");oe={"%a":c=>Qe[c.oa].substring(0,3),"%A":c=>Qe[c.oa],"%b":c=>Ze[c.wa].substring(0,3),"%B":c=>Ze[c.wa],"%C":c=>S((c.ua+1900)/100|0,2),"%d":c=>S(c.ya,2),"%e":c=>O(c.ya,2," "),"%g":c=>le(c).toString().substring(2),"%G":c=>le(c),"%H":c=>S(c.va,2),"%I":c=>(c=c.va,c==0?c=12:12<c&&(c-=12),S(c,2)),"%j":c=>{for(var W=0,G=0;G<=c.wa-1;W+=(Ue(c.ua+1900)?qe:Ve)[G++]);return S(c.ya+W,3)},"%m":c=>S(c.wa+1,2),"%M":c=>S(c.Ca,2),"%n":()=>`\n`,"%p":c=>0<=c.va&&12>c.va?"AM":"PM","%S":c=>S(c.Da,2),"%t":()=>"	","%u":c=>c.oa||7,"%U":c=>S(Math.floor((c.ta+7-c.oa)/7),2),"%V":c=>{var W=Math.floor((c.ta+7-(c.oa+6)%7)/7);if(2>=(c.oa+371-c.ta-2)%7&&W++,W)W==53&&(G=(c.oa+371-c.ta)%7,G==4||G==3&&Ue(c.ua)||(W=1));else{W=52;var G=(c.oa+7-c.ta-1)%7;(G==4||G==5&&Ue(c.ua%400-1))&&W++}return S(W,2)},"%w":c=>c.oa,"%W":c=>S(Math.floor((c.ta+7-(c.oa+6)%7)/7),2),"%y":c=>(c.ua+1900).toString().substring(2),"%Y":c=>c.ua+1900,"%z":c=>{c=c.Ba;var W=0<=c;return c=Math.abs(c)/60,(W?"+":"-")+("0000"+(c/60*100+c%60)).slice(-4)},"%Z":c=>c.Ea,"%%":()=>"%"},s=s.replace(/%%/g,"\\0\\0");for(se in oe)s.includes(se)&&(s=s.replace(new RegExp(se,"g"),oe[se](m)));return s=s.replace(/\\0\\0/g,"%"),se=Ge(s),se.length>o?0:(ie.set(se,r>>>0),se.length-1)}var $={a:function(r,o,s){throw r>>>=0,new Oe(r).Aa(o>>>0,s>>>0),ve=r,re++,ve},e:function(){return 0},H:function(){},x:function(){},z:function(){},J:function(){return 0},F:function(){},A:function(){},E:function(){},g:function(){},y:function(){},v:function(){},G:function(){},w:function(){},k:()=>1,n:function(r,o,s){r=o+2097152>>>0<4194305-!!r?(r>>>0)+4294967296*o:NaN,s>>>=0,r=new Date(1e3*r),E[s>>>2>>>0]=r.getUTCSeconds(),E[s+4>>>2>>>0]=r.getUTCMinutes(),E[s+8>>>2>>>0]=r.getUTCHours(),E[s+12>>>2>>>0]=r.getUTCDate(),E[s+16>>>2>>>0]=r.getUTCMonth(),E[s+20>>>2>>>0]=r.getUTCFullYear()-1900,E[s+24>>>2>>>0]=r.getUTCDay(),E[s+28>>>2>>>0]=(r.getTime()-Date.UTC(r.getUTCFullYear(),0,1,0,0,0,0))/864e5|0},o:function(r,o,s){r=o+2097152>>>0<4194305-!!r?(r>>>0)+4294967296*o:NaN,s>>>=0,r=new Date(1e3*r),E[s>>>2>>>0]=r.getSeconds(),E[s+4>>>2>>>0]=r.getMinutes(),E[s+8>>>2>>>0]=r.getHours(),E[s+12>>>2>>>0]=r.getDate(),E[s+16>>>2>>>0]=r.getMonth(),E[s+20>>>2>>>0]=r.getFullYear()-1900,E[s+24>>>2>>>0]=r.getDay(),E[s+28>>>2>>>0]=(Ue(r.getFullYear())?ze:at)[r.getMonth()]+r.getDate()-1|0,E[s+36>>>2>>>0]=-(60*r.getTimezoneOffset()),o=new Date(r.getFullYear(),6,1).getTimezoneOffset();var m=new Date(r.getFullYear(),0,1).getTimezoneOffset();E[s+32>>>2>>>0]=(o!=m&&r.getTimezoneOffset()==Math.min(m,o))|0},p:function(r){r>>>=0;var o=new Date(E[r+20>>>2>>>0]+1900,E[r+16>>>2>>>0],E[r+12>>>2>>>0],E[r+8>>>2>>>0],E[r+4>>>2>>>0],E[r>>>2>>>0],0),s=E[r+32>>>2>>>0],m=o.getTimezoneOffset(),O=new Date(o.getFullYear(),6,1).getTimezoneOffset(),S=new Date(o.getFullYear(),0,1).getTimezoneOffset(),R=Math.min(S,O);return 0>s?E[r+32>>>2>>>0]=+(O!=S&&R==m):0<s!=(R==m)&&(O=Math.max(S,O),o.setTime(o.getTime()+6e4*((0<s?R:O)-m))),E[r+24>>>2>>>0]=o.getDay(),E[r+28>>>2>>>0]=(Ue(o.getFullYear())?ze:at)[o.getMonth()]+o.getDate()-1|0,E[r>>>2>>>0]=o.getSeconds(),E[r+4>>>2>>>0]=o.getMinutes(),E[r+8>>>2>>>0]=o.getHours(),E[r+12>>>2>>>0]=o.getDate(),E[r+16>>>2>>>0]=o.getMonth(),E[r+20>>>2>>>0]=o.getYear(),r=o.getTime(),isNaN(r)?(E[Ye()>>>2>>>0]=61,r=-1):r/=1e3,Je((Ee=r,1<=+Math.abs(Ee)?0<Ee?+Math.floor(Ee/4294967296)>>>0:~~+Math.ceil((Ee-+(~~Ee>>>0))/4294967296)>>>0:0)),r>>>0},l:function(){return-52},m:function(){},t:function(r,o,s){function m(le){return(le=le.toTimeString().match(/\\(([A-Za-z ]+)\\)$/))?le[1]:"GMT"}s>>>=0;var O=new Date().getFullYear(),S=new Date(O,0,1),R=new Date(O,6,1);O=S.getTimezoneOffset();var K=R.getTimezoneOffset();Y[r>>>0>>>2>>>0]=60*Math.max(O,K),E[o>>>0>>>2>>>0]=+(O!=K),r=m(S),o=m(R),r=De(r),o=De(o),K<O?(Y[s>>>2>>>0]=r,Y[s+4>>>2>>>0]=o):(Y[s>>>2>>>0]=o,Y[s+4>>>2>>>0]=r)},d:()=>{de("")},B:function(r,o,s){r>>>=0,o>>>=0,s>>>=0,Ne.length=0;for(var m;m=ae[o++>>>0];){var O=m!=105;O&=m!=112,s+=O&&s%8?4:0,Ne.push(m==112?Y[s>>>2>>>0]:m==105?E[s>>>2>>>0]:ue[s>>>3>>>0]),s+=O?8:4}return pe[r].apply(null,Ne)},h:()=>Date.now(),u:function(){return 4294901760},b:()=>performance.now(),I:function(r,o,s){return o>>>=0,ae.copyWithin(r>>>0>>>0,o>>>0,o+(s>>>0)>>>0)},s:function(r){r>>>=0;var o=ae.length;if(4294901760<r)return!1;for(var s=1;4>=s;s*=2){var m=o*(1+.2/s);m=Math.min(m,r+100663296);var O=Math;m=Math.max(r,m);e:{O=(O.min.call(O,4294901760,m+(65536-m%65536)%65536)-N.buffer.byteLength+65535)/65536;try{N.grow(O),Re();var S=1;break e}catch{}S=void 0}if(S)return!0}return!1},C:function(r,o){r>>>=0,o>>>=0;var s=0;return He().forEach((m,O)=>{var S=o+s;for(O=Y[r+4*O>>>2>>>0]=S,S=0;S<m.length;++S)ie[O++>>>0>>>0]=m.charCodeAt(S);ie[O>>>0>>>0]=0,s+=m.length+1}),0},D:function(r,o){r>>>=0,o>>>=0;var s=He();Y[r>>>2>>>0]=s.length;var m=0;return s.forEach(O=>m+=O.length+1),Y[o>>>2>>>0]=m,0},f:()=>52,j:function(){return 52},q:function(){return 70},i:function(r,o,s,m){o>>>=0,s>>>=0,m>>>=0;for(var O=0,S=0;S<s;S++){var R=Y[o>>>2>>>0],K=Y[o+4>>>2>>>0];o+=8;for(var le=0;le<K;le++){var oe=ae[R+le>>>0],se=Le[r];oe===0||oe===10?((r===1?_:x)(Ce(se,0)),se.length=0):se.push(oe)}O+=K}return Y[m>>>2>>>0]=O,0},r:ot,c:function(r,o,s,m){return ot(r>>>0,o>>>0,s>>>0,m>>>0)}},C=function(){function r(s){return C=s.exports,C=ut(),N=C.K,Re(),ee.unshift(C.L),ce--,ce==0&&(P!==null&&(clearInterval(P),P=null),te&&(s=te,te=null,s())),C}var o={a:$};if(ce++,a.instantiateWasm)try{return a.instantiateWasm(o,r)}catch(s){x(`Module.instantiateWasm callback failed with error: ${s}`),l(s)}return Fe(o,function(s){r(s.instance)}).catch(l),{}}();a._OrtInit=(r,o)=>(a._OrtInit=C.M)(r,o),a._OrtGetLastError=(r,o)=>(a._OrtGetLastError=C.N)(r,o),a._OrtCreateSessionOptions=(r,o,s,m,O,S,R,K,le,oe)=>(a._OrtCreateSessionOptions=C.O)(r,o,s,m,O,S,R,K,le,oe),a._OrtAppendExecutionProvider=(r,o)=>(a._OrtAppendExecutionProvider=C.P)(r,o),a._OrtAddFreeDimensionOverride=(r,o,s)=>(a._OrtAddFreeDimensionOverride=C.Q)(r,o,s),a._OrtAddSessionConfigEntry=(r,o,s)=>(a._OrtAddSessionConfigEntry=C.R)(r,o,s),a._OrtReleaseSessionOptions=r=>(a._OrtReleaseSessionOptions=C.S)(r),a._OrtCreateSession=(r,o,s)=>(a._OrtCreateSession=C.T)(r,o,s),a._OrtReleaseSession=r=>(a._OrtReleaseSession=C.U)(r),a._OrtGetInputOutputCount=(r,o,s)=>(a._OrtGetInputOutputCount=C.V)(r,o,s),a._OrtGetInputName=(r,o)=>(a._OrtGetInputName=C.W)(r,o),a._OrtGetOutputName=(r,o)=>(a._OrtGetOutputName=C.X)(r,o),a._OrtFree=r=>(a._OrtFree=C.Y)(r),a._OrtCreateTensor=(r,o,s,m,O,S)=>(a._OrtCreateTensor=C.Z)(r,o,s,m,O,S),a._OrtGetTensorData=(r,o,s,m,O)=>(a._OrtGetTensorData=C._)(r,o,s,m,O),a._OrtReleaseTensor=r=>(a._OrtReleaseTensor=C.$)(r),a._OrtCreateRunOptions=(r,o,s,m)=>(a._OrtCreateRunOptions=C.aa)(r,o,s,m),a._OrtAddRunConfigEntry=(r,o,s)=>(a._OrtAddRunConfigEntry=C.ba)(r,o,s),a._OrtReleaseRunOptions=r=>(a._OrtReleaseRunOptions=C.ca)(r),a._OrtCreateBinding=r=>(a._OrtCreateBinding=C.da)(r),a._OrtBindInput=(r,o,s)=>(a._OrtBindInput=C.ea)(r,o,s),a._OrtBindOutput=(r,o,s,m)=>(a._OrtBindOutput=C.fa)(r,o,s,m),a._OrtClearBoundOutputs=r=>(a._OrtClearBoundOutputs=C.ga)(r),a._OrtReleaseBinding=r=>(a._OrtReleaseBinding=C.ha)(r),a._OrtRunWithBinding=(r,o,s,m,O)=>(a._OrtRunWithBinding=C.ia)(r,o,s,m,O),a._OrtRun=(r,o,s,m,O,S,R,K)=>(a._OrtRun=C.ja)(r,o,s,m,O,S,R,K),a._OrtEndProfiling=r=>(a._OrtEndProfiling=C.ka)(r);var Ye=()=>(Ye=C.la)(),st=a._malloc=r=>(st=a._malloc=C.ma)(r);a._free=r=>(a._free=C.na)(r);var Je=r=>(Je=C.pa)(r),it=()=>(it=C.qa)(),M=r=>(M=C.ra)(r),Be=r=>(Be=C.sa)(r);function ut(){var r=C;r=Object.assign({},r);var o=m=>()=>m()>>>0,s=m=>O=>m(O)>>>0;return r.la=o(r.la),r.ma=s(r.ma),r.qa=o(r.qa),r.sa=s(r.sa),r}a.stackAlloc=Be,a.stackSave=it,a.stackRestore=M,a.UTF8ToString=be,a.stringToUTF8=(r,o,s)=>ke(r,ae,o,s),a.lengthBytesUTF8=_e;var xe;te=function r(){xe||Xe(),xe||(te=r)};function Xe(){if(!(0<ce)){if(a.preRun)for(typeof a.preRun=="function"&&(a.preRun=[a.preRun]);a.preRun.length;){var r=a.preRun.shift();Ie.unshift(r)}for(;0<Ie.length;)Ie.shift()(a);if(!(0<ce||xe||(xe=!0,a.calledRun=!0,he))){for(;0<ee.length;)ee.shift()(a);for(h(a);0<j.length;)j.shift()(a)}}}return Xe(),d.ready}})();typeof mr=="object"&&typeof xt=="object"?xt.exports=pr:typeof define=="function"&&define.amd&&define([],()=>pr)});var hr=et(()=>{});var yr=et(()=>{});var br={};Tt(br,{cpus:()=>rn});var rn,wr=St(()=>{rn=void 0});var _r=et((vr,Ft)=>{"use strict";var Or=(()=>{var u=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(u=u||__filename),function(d={}){function a(){return j.buffer!=de.buffer&&we(),de}function h(){return j.buffer!=de.buffer&&we(),ge}function l(){return j.buffer!=de.buffer&&we(),ye}function w(){return j.buffer!=de.buffer&&we(),J}function g(){return j.buffer!=de.buffer&&we(),fe}var i=d,A,D;i.ready=new Promise((e,t)=>{A=e,D=t});var I=Object.assign({},i),B="./this.program",F=(e,t)=>{throw t},U=typeof window=="object",k=typeof importScripts=="function",L=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",_=i.ENVIRONMENT_IS_PTHREAD||!1,x="";function N(e){return i.locateFile?i.locateFile(e,x):x+e}var he,ie,ae;if(L){var E=(Mt(),tt(At)),Y=(Dt(),tt(Ct));x=k?Y.dirname(x)+"/":__dirname+"/",he=(t,n)=>(t=be(t)?new URL(t):Y.normalize(t),E.readFileSync(t,n?void 0:"utf8")),ae=t=>(t=he(t,!0),t.buffer||(t=new Uint8Array(t)),t),ie=(t,n,f,y=!0)=>{t=be(t)?new URL(t):Y.normalize(t),E.readFile(t,y?void 0:"utf8",(b,v)=>{b?f(b):n(y?v.buffer:v)})},!i.thisProgram&&1<process.argv.length&&(B=process.argv[1].replace(/\\\\/g,"/")),process.argv.slice(2),F=(t,n)=>{throw process.exitCode=t,n},i.inspect=()=>"[Emscripten Module object]";let e;try{e=hr()}catch(t){throw console.error(\'The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?\'),t}global.Worker=e.Worker}else(U||k)&&(k?x=self.location.href:typeof document<"u"&&document.currentScript&&(x=document.currentScript.src),typeof u<"u"&&u&&(x=u),x.indexOf("blob:")!==0?x=x.substr(0,x.replace(/[?#].*/,"").lastIndexOf("/")+1):x="",L||(he=e=>{var t=new XMLHttpRequest;return t.open("GET",e,!1),t.send(null),t.responseText},k&&(ae=e=>{var t=new XMLHttpRequest;return t.open("GET",e,!1),t.responseType="arraybuffer",t.send(null),new Uint8Array(t.response)}),ie=(e,t,n)=>{var f=new XMLHttpRequest;f.open("GET",e,!0),f.responseType="arraybuffer",f.onload=()=>{f.status==200||f.status==0&&f.response?t(f.response):n()},f.onerror=n,f.send(null)}));L&&typeof performance>"u"&&(global.performance=yr().performance);var ue=console.log.bind(console),Re=console.error.bind(console);L&&(ue=(...e)=>E.writeSync(1,e.join(" ")+`\n`),Re=(...e)=>E.writeSync(2,e.join(" ")+`\n`));var Ie=ue,ee=Re;Object.assign(i,I),I=null,typeof WebAssembly!="object"&&Z("no native wasm support detected");var j,ce,P=!1,te,de,ge,ye,J,fe;function we(){var e=j.buffer;i.HEAP8=de=new Int8Array(e),i.HEAP16=new Int16Array(e),i.HEAPU8=ge=new Uint8Array(e),i.HEAPU16=new Uint16Array(e),i.HEAP32=ye=new Int32Array(e),i.HEAPU32=J=new Uint32Array(e),i.HEAPF32=new Float32Array(e),i.HEAPF64=fe=new Float64Array(e)}var Ae=16777216;if(_)j=i.wasmMemory;else if(i.wasmMemory)j=i.wasmMemory;else if(j=new WebAssembly.Memory({initial:Ae/65536,maximum:65536,shared:!0}),!(j.buffer instanceof SharedArrayBuffer))throw ee("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"),L&&ee("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and/or recent version)"),Error("bad memory");we(),Ae=j.buffer.byteLength;var Me=[],Fe=[],Ee=[],pe=0,Oe=null,ve=null;function re(){if(pe--,pe==0&&(Oe!==null&&(clearInterval(Oe),Oe=null),ve)){var e=ve;ve=null,e()}}function Z(e){throw e="Aborted("+e+")",ee(e),P=!0,te=1,e=new WebAssembly.RuntimeError(e+". Build with -sASSERTIONS for more info."),D(e),e}var Ce=e=>e.startsWith("data:application/octet-stream;base64,"),be=e=>e.startsWith("file://"),_e;_e="ort-wasm-threaded.wasm",Ce(_e)||(_e=N(_e));function ke(e){if(ae)return ae(e);throw"both async and sync fetching of the wasm failed"}function Ue(e){if(U||k){if(typeof fetch=="function"&&!be(e))return fetch(e,{credentials:"same-origin"}).then(t=>{if(!t.ok)throw"failed to load wasm binary file at \'"+e+"\'";return t.arrayBuffer()}).catch(()=>ke(e));if(ie)return new Promise((t,n)=>{ie(e,f=>t(new Uint8Array(f)),n)})}return Promise.resolve().then(()=>ke(e))}function ze(e,t,n){return Ue(e).then(f=>WebAssembly.instantiate(f,t)).then(f=>f).then(n,f=>{ee(`failed to asynchronously prepare wasm: ${f}`),Z(f)})}function at(e,t){var n=_e;return typeof WebAssembly.instantiateStreaming!="function"||Ce(n)||be(n)||L||typeof fetch!="function"?ze(n,e,t):fetch(n,{credentials:"same-origin"}).then(f=>WebAssembly.instantiateStreaming(f,e).then(t,function(y){return ee(`wasm streaming compile failed: ${y}`),ee("falling back to ArrayBuffer instantiation"),ze(n,e,t)}))}var De,Ne={921276:(e,t,n,f)=>{if(typeof i>"u"||!i.cb)return 1;if(e=Ge(e>>>0),e.startsWith("./")&&(e=e.substring(2)),e=i.cb.get(e),!e)return 2;if(t>>>=0,n>>>=0,f>>>=0,t+n>e.byteLength)return 3;try{return h().set(e.subarray(t,t+n),f>>>0),0}catch{return 4}}};function Pe(e){this.name="ExitStatus",this.message=`Program terminated with exit(${e})`,this.status=e}var He=e=>{e.terminate(),e.onmessage=()=>{}},$e=e=>{M.Pa.length==0&&(Je(),M.Ya(M.Pa[0]));var t=M.Pa.pop();if(!t)return 6;M.Qa.push(t),M.Ma[e.Oa]=t,t.Oa=e.Oa;var n={cmd:"run",start_routine:e.kb,arg:e.hb,pthread_ptr:e.Oa};return L&&t.unref(),t.postMessage(n,e.qb),0},Le=0,qe=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,Ve=(e,t,n)=>{t>>>=0;var f=t+n;for(n=t;e[n]&&!(n>=f);)++n;if(16<n-t&&e.buffer&&qe)return qe.decode(e.buffer instanceof SharedArrayBuffer?e.slice(t,n):e.subarray(t,n));for(f="";t<n;){var y=e[t++];if(y&128){var b=e[t++]&63;if((y&224)==192)f+=String.fromCharCode((y&31)<<6|b);else{var v=e[t++]&63;y=(y&240)==224?(y&15)<<12|b<<6|v:(y&7)<<18|b<<12|v<<6|e[t++]&63,65536>y?f+=String.fromCharCode(y):(y-=65536,f+=String.fromCharCode(55296|y>>10,56320|y&1023))}}else f+=String.fromCharCode(y)}return f},Ge=(e,t)=>(e>>>=0)?Ve(h(),e,t):"",ot=e=>{var t=vt();return e=e(),ct(t),e};function $(e,t){var n=arguments.length-2,f=arguments;return ot(()=>{for(var y=_t(8*n),b=y>>>3,v=0;v<n;v++){var z=f[2+v];g()[b+v>>>0]=z}return ar(e,n,y,t)})}function C(e){if(_)return $(0,1,e);te=e,0<Le||(M.lb(),i.onExit?.(e),P=!0),F(e,new Pe(e))}var Ye=e=>{if(te=e,_)throw ut(e),"unwind";C(e)};function st(){for(var e=i.numThreads;e--;)Je();Me.unshift(()=>{pe++,it(()=>re())})}function Je(){var e=N("ort-wasm-threaded.worker.js");e=new Worker(e),M.Pa.push(e)}function it(e){_?e():Promise.all(M.Pa.map(M.Ya)).then(e)}var M={Pa:[],Qa:[],bb:[],Ma:{},Wa(){_?(M.receiveObjectTransfer=M.jb,M.threadInitTLS=M.ab,M.setExitStatus=M.$a):st()},$a:e=>te=e,tb:["$terminateWorker"],lb:()=>{for(var e of M.Qa)He(e);for(e of M.Pa)He(e);M.Pa=[],M.Qa=[],M.Ma=[]},Za:e=>{var t=e.Oa;delete M.Ma[t],M.Pa.push(e),M.Qa.splice(M.Qa.indexOf(e),1),e.Oa=0,wt(t)},jb(){},ab(){M.bb.forEach(e=>e())},Ya:e=>new Promise(t=>{e.onmessage=b=>{b=b.data;var v=b.cmd;if(b.targetThread&&b.targetThread!=lt()){var z=M.Ma[b.targetThread];z?z.postMessage(b,b.transferList):ee(`Internal error! Worker sent a message "${v}" to target pthread ${b.targetThread}, but that thread no longer exists!`)}else v==="checkMailbox"?ft():v==="spawnThread"?$e(b):v==="cleanupThread"?M.Za(M.Ma[b.thread]):v==="killThread"?(b=b.thread,v=M.Ma[b],delete M.Ma[b],He(v),wt(b),M.Qa.splice(M.Qa.indexOf(v),1),v.Oa=0):v==="cancelThread"?M.Ma[b.thread].postMessage({cmd:"cancel"}):v==="loaded"?(e.loaded=!0,L&&!e.Oa&&e.unref(),t(e)):v==="alert"?alert(`Thread ${b.threadId}: ${b.text}`):b.target==="setimmediate"?e.postMessage(b):v==="callHandler"?i[b.handler](...b.args):v&&ee(`worker sent an unknown command ${v}`)},e.onerror=b=>{throw ee(`worker sent an error! ${b.filename}:${b.lineno}: ${b.message}`),b},L&&(e.on("message",b=>e.onmessage({data:b})),e.on("error",b=>e.onerror(b)));var n=[],f=["onExit"],y;for(y of f)i.hasOwnProperty(y)&&n.push(y);e.postMessage({cmd:"load",handlers:n,urlOrBlob:i.mainScriptUrlOrBlob||u,wasmMemory:j,wasmModule:ce})})};i.PThread=M;var Be=e=>{for(;0<e.length;)e.shift()(i)};i.establishStackSpace=()=>{var e=lt(),t=w()[e+52>>>2>>>0];e=w()[e+56>>>2>>>0],ir(t,t-e),ct(t)};function ut(e){if(_)return $(1,0,e);Ye(e)}var xe=[],Xe;i.invokeEntryPoint=(e,t)=>{var n=xe[e];n||(e>=xe.length&&(xe.length=e+1),xe[e]=n=Xe.get(e)),e=n(t),0<Le?M.$a(e):Ot(e)};function r(e){this.Va=e-24,this.gb=function(t){w()[this.Va+4>>>2>>>0]=t},this.fb=function(t){w()[this.Va+8>>>2>>>0]=t},this.Wa=function(t,n){this.eb(),this.gb(t),this.fb(n)},this.eb=function(){w()[this.Va+16>>>2>>>0]=0}}var o=0,s=0;function m(e,t,n,f){return _?$(2,1,e,t,n,f):O(e,t,n,f)}function O(e,t,n,f){if(e>>>=0,t>>>=0,n>>>=0,f>>>=0,typeof SharedArrayBuffer>"u")return ee("Current environment does not support SharedArrayBuffer, pthreads are not available!"),6;var y=[];return _&&y.length===0?m(e,t,n,f):(e={kb:n,Oa:e,hb:f,qb:y},_?(e.sb="spawnThread",postMessage(e,y),0):$e(e))}function S(e,t,n){return _?$(3,1,e,t,n):0}function R(e,t){if(_)return $(4,1,e,t)}var K=e=>{for(var t=0,n=0;n<e.length;++n){var f=e.charCodeAt(n);127>=f?t++:2047>=f?t+=2:55296<=f&&57343>=f?(t+=4,++n):t+=3}return t},le=(e,t,n,f)=>{if(n>>>=0,!(0<f))return 0;var y=n;f=n+f-1;for(var b=0;b<e.length;++b){var v=e.charCodeAt(b);if(55296<=v&&57343>=v){var z=e.charCodeAt(++b);v=65536+((v&1023)<<10)|z&1023}if(127>=v){if(n>=f)break;t[n++>>>0]=v}else{if(2047>=v){if(n+1>=f)break;t[n++>>>0]=192|v>>6}else{if(65535>=v){if(n+2>=f)break;t[n++>>>0]=224|v>>12}else{if(n+3>=f)break;t[n++>>>0]=240|v>>18,t[n++>>>0]=128|v>>12&63}t[n++>>>0]=128|v>>6&63}t[n++>>>0]=128|v&63}}return t[n>>>0]=0,n-y},oe=(e,t,n)=>le(e,h(),t,n);function se(e,t){if(_)return $(5,1,e,t)}function Qe(e,t,n){if(_)return $(6,1,e,t,n)}function Ze(e,t,n){return _?$(7,1,e,t,n):0}function c(e,t){if(_)return $(8,1,e,t)}function W(e,t,n){if(_)return $(9,1,e,t,n)}function G(e,t,n,f){if(_)return $(10,1,e,t,n,f)}function Se(e,t,n,f){if(_)return $(11,1,e,t,n,f)}function Ke(e,t,n,f){if(_)return $(12,1,e,t,n,f)}function Bt(e){if(_)return $(13,1,e)}function Wt(e,t){if(_)return $(14,1,e,t)}function kt(e,t,n){if(_)return $(15,1,e,t,n)}function mt(e){e>>>=0,typeof Atomics.rb=="function"&&(Atomics.rb(l(),e>>>2,e).value.then(ft),e+=128,Atomics.store(l(),e>>>2,1))}i.__emscripten_thread_mailbox_await=mt;var ft=()=>{var e=lt();if(e&&(mt(e),e=or,!P))try{if(e(),!(0<Le))try{_?Ot(te):Ye(te)}catch(t){t instanceof Pe||t=="unwind"||F(1,t)}}catch(t){t instanceof Pe||t=="unwind"||F(1,t)}};i.checkMailbox=ft;var gt=[],je=e=>e%4===0&&(e%100!==0||e%400===0),Nt=[0,31,60,91,121,152,182,213,244,274,305,335],Ht=[0,31,59,90,120,151,181,212,243,273,304,334];function $t(e,t,n,f,y,b,v,z){return _?$(16,1,e,t,n,f,y,b,v,z):-52}function Gt(e,t,n,f,y,b,v){if(_)return $(17,1,e,t,n,f,y,b,v)}var Yt=e=>{var t=K(e)+1,n=rr(t);return n&&oe(e,n,t),n},ht=[],yt={},jt=()=>{if(!bt){var e={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:B||"./this.program"},t;for(t in yt)yt[t]===void 0?delete e[t]:e[t]=yt[t];var n=[];for(t in e)n.push(`${t}=${e[t]}`);bt=n}return bt},bt;function zt(e,t){if(_)return $(18,1,e,t);e>>>=0,t>>>=0;var n=0;return jt().forEach((f,y)=>{var b=t+n;for(y=w()[e+4*y>>>2>>>0]=b,b=0;b<f.length;++b)a()[y++>>>0>>>0]=f.charCodeAt(b);a()[y>>>0>>>0]=0,n+=f.length+1}),0}function qt(e,t){if(_)return $(19,1,e,t);e>>>=0,t>>>=0;var n=jt();w()[e>>>2>>>0]=n.length;var f=0;return n.forEach(y=>f+=y.length+1),w()[t>>>2>>>0]=f,0}function Vt(e){return _?$(20,1,e):52}function Jt(e,t,n,f){return _?$(21,1,e,t,n,f):52}function Xt(e,t,n,f,y){return _?$(22,1,e,t,n,f,y):70}var Gr=[null,[],[]];function Qt(e,t,n,f){if(_)return $(23,1,e,t,n,f);t>>>=0,n>>>=0,f>>>=0;for(var y=0,b=0;b<n;b++){var v=w()[t>>>2>>>0],z=w()[t+4>>>2>>>0];t+=8;for(var Te=0;Te<z;Te++){var ne=h()[v+Te>>>0],me=Gr[e];ne===0||ne===10?((e===1?Ie:ee)(Ve(me,0)),me.length=0):me.push(ne)}y+=z}return w()[f>>>2>>>0]=y,0}var Zt=[31,29,31,30,31,30,31,31,30,31,30,31],Kt=[31,28,31,30,31,30,31,31,30,31,30,31];function Yr(e){var t=Array(K(e)+1);return le(e,t,0,t.length),t}var jr=(e,t)=>{a().set(e,t>>>0)};function er(e,t,n,f){function y(p,H,q){for(p=typeof p=="number"?p.toString():p||"";p.length<H;)p=q[0]+p;return p}function b(p,H){return y(p,H,"0")}function v(p,H){function q(cr){return 0>cr?-1:0<cr?1:0}var We;return(We=q(p.getFullYear()-H.getFullYear()))===0&&(We=q(p.getMonth()-H.getMonth()))===0&&(We=q(p.getDate()-H.getDate())),We}function z(p){switch(p.getDay()){case 0:return new Date(p.getFullYear()-1,11,29);case 1:return p;case 2:return new Date(p.getFullYear(),0,3);case 3:return new Date(p.getFullYear(),0,2);case 4:return new Date(p.getFullYear(),0,1);case 5:return new Date(p.getFullYear()-1,11,31);case 6:return new Date(p.getFullYear()-1,11,30)}}function Te(p){var H=p.Ra;for(p=new Date(new Date(p.Sa+1900,0,1).getTime());0<H;){var q=p.getMonth(),We=(je(p.getFullYear())?Zt:Kt)[q];if(H>We-p.getDate())H-=We-p.getDate()+1,p.setDate(1),11>q?p.setMonth(q+1):(p.setMonth(0),p.setFullYear(p.getFullYear()+1));else{p.setDate(p.getDate()+H);break}}return q=new Date(p.getFullYear()+1,0,4),H=z(new Date(p.getFullYear(),0,4)),q=z(q),0>=v(H,p)?0>=v(q,p)?p.getFullYear()+1:p.getFullYear():p.getFullYear()-1}e>>>=0,t>>>=0,n>>>=0,f>>>=0;var ne=w()[f+40>>>2>>>0];f={ob:l()[f>>>2>>>0],nb:l()[f+4>>>2>>>0],Ta:l()[f+8>>>2>>>0],Xa:l()[f+12>>>2>>>0],Ua:l()[f+16>>>2>>>0],Sa:l()[f+20>>>2>>>0],Na:l()[f+24>>>2>>>0],Ra:l()[f+28>>>2>>>0],ub:l()[f+32>>>2>>>0],mb:l()[f+36>>>2>>>0],pb:ne?Ge(ne):""},n=Ge(n),ne={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var me in ne)n=n.replace(new RegExp(me,"g"),ne[me]);var fr="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),lr="January February March April May June July August September October November December".split(" ");ne={"%a":p=>fr[p.Na].substring(0,3),"%A":p=>fr[p.Na],"%b":p=>lr[p.Ua].substring(0,3),"%B":p=>lr[p.Ua],"%C":p=>b((p.Sa+1900)/100|0,2),"%d":p=>b(p.Xa,2),"%e":p=>y(p.Xa,2," "),"%g":p=>Te(p).toString().substring(2),"%G":p=>Te(p),"%H":p=>b(p.Ta,2),"%I":p=>(p=p.Ta,p==0?p=12:12<p&&(p-=12),b(p,2)),"%j":p=>{for(var H=0,q=0;q<=p.Ua-1;H+=(je(p.Sa+1900)?Zt:Kt)[q++]);return b(p.Xa+H,3)},"%m":p=>b(p.Ua+1,2),"%M":p=>b(p.nb,2),"%n":()=>`\n`,"%p":p=>0<=p.Ta&&12>p.Ta?"AM":"PM","%S":p=>b(p.ob,2),"%t":()=>"	","%u":p=>p.Na||7,"%U":p=>b(Math.floor((p.Ra+7-p.Na)/7),2),"%V":p=>{var H=Math.floor((p.Ra+7-(p.Na+6)%7)/7);if(2>=(p.Na+371-p.Ra-2)%7&&H++,H)H==53&&(q=(p.Na+371-p.Ra)%7,q==4||q==3&&je(p.Sa)||(H=1));else{H=52;var q=(p.Na+7-p.Ra-1)%7;(q==4||q==5&&je(p.Sa%400-1))&&H++}return b(H,2)},"%w":p=>p.Na,"%W":p=>b(Math.floor((p.Ra+7-(p.Na+6)%7)/7),2),"%y":p=>(p.Sa+1900).toString().substring(2),"%Y":p=>p.Sa+1900,"%z":p=>{p=p.mb;var H=0<=p;return p=Math.abs(p)/60,(H?"+":"-")+("0000"+(p/60*100+p%60)).slice(-4)},"%Z":p=>p.pb,"%%":()=>"%"},n=n.replace(/%%/g,"\\0\\0");for(me in ne)n.includes(me)&&(n=n.replace(new RegExp(me,"g"),ne[me](f)));return n=n.replace(/\\0\\0/g,"%"),me=Yr(n),me.length>t?0:(jr(me,e),me.length-1)}M.Wa();var zr=[C,ut,m,S,R,se,Qe,Ze,c,W,G,Se,Ke,Bt,Wt,kt,$t,Gt,zt,qt,Vt,Jt,Xt,Qt],qr={b:function(e,t,n){throw e>>>=0,new r(e).Wa(t>>>0,n>>>0),o=e,s++,o},L:function(e){nr(e>>>0,!k,1,!U,131072,!1),M.ab()},j:function(e){e>>>=0,_?postMessage({cmd:"cleanupThread",thread:e}):M.Za(M.Ma[e])},H:O,h:S,S:R,D:se,F:Qe,T:Ze,Q:c,J:W,P:G,n:Se,E:Ke,B:Bt,R:Wt,C:kt,p:()=>1,z:function(e,t){e>>>=0,e==t>>>0?setTimeout(()=>ft()):_?postMessage({targetThread:e,cmd:"checkMailbox"}):(e=M.Ma[e])&&e.postMessage({cmd:"checkMailbox"})},I:function(e,t,n,f){t>>>=0,gt.length=n,f=f>>>0>>>3;for(var y=0;y<n;y++)gt[y]=g()[f+y>>>0];return e=0>e?Ne[-e-1]:zr[e],M.ib=t,t=e.apply(null,gt),M.ib=0,t},K:mt,o:function(e){L&&M.Ma[e>>>0].ref()},s:function(e,t,n){e=t+2097152>>>0<4194305-!!e?(e>>>0)+4294967296*t:NaN,n>>>=0,e=new Date(1e3*e),l()[n>>>2>>>0]=e.getUTCSeconds(),l()[n+4>>>2>>>0]=e.getUTCMinutes(),l()[n+8>>>2>>>0]=e.getUTCHours(),l()[n+12>>>2>>>0]=e.getUTCDate(),l()[n+16>>>2>>>0]=e.getUTCMonth(),l()[n+20>>>2>>>0]=e.getUTCFullYear()-1900,l()[n+24>>>2>>>0]=e.getUTCDay(),e=(e.getTime()-Date.UTC(e.getUTCFullYear(),0,1,0,0,0,0))/864e5|0,l()[n+28>>>2>>>0]=e},t:function(e,t,n){e=t+2097152>>>0<4194305-!!e?(e>>>0)+4294967296*t:NaN,n>>>=0,e=new Date(1e3*e),l()[n>>>2>>>0]=e.getSeconds(),l()[n+4>>>2>>>0]=e.getMinutes(),l()[n+8>>>2>>>0]=e.getHours(),l()[n+12>>>2>>>0]=e.getDate(),l()[n+16>>>2>>>0]=e.getMonth(),l()[n+20>>>2>>>0]=e.getFullYear()-1900,l()[n+24>>>2>>>0]=e.getDay(),t=(je(e.getFullYear())?Nt:Ht)[e.getMonth()]+e.getDate()-1|0,l()[n+28>>>2>>>0]=t,l()[n+36>>>2>>>0]=-(60*e.getTimezoneOffset()),t=new Date(e.getFullYear(),6,1).getTimezoneOffset();var f=new Date(e.getFullYear(),0,1).getTimezoneOffset();e=(t!=f&&e.getTimezoneOffset()==Math.min(f,t))|0,l()[n+32>>>2>>>0]=e},u:function(e){e>>>=0;var t=new Date(l()[e+20>>>2>>>0]+1900,l()[e+16>>>2>>>0],l()[e+12>>>2>>>0],l()[e+8>>>2>>>0],l()[e+4>>>2>>>0],l()[e>>>2>>>0],0),n=l()[e+32>>>2>>>0],f=t.getTimezoneOffset(),y=new Date(t.getFullYear(),6,1).getTimezoneOffset(),b=new Date(t.getFullYear(),0,1).getTimezoneOffset(),v=Math.min(b,y);return 0>n?l()[e+32>>>2>>>0]=+(y!=b&&v==f):0<n!=(v==f)&&(y=Math.max(b,y),t.setTime(t.getTime()+6e4*((0<n?v:y)-f))),l()[e+24>>>2>>>0]=t.getDay(),n=(je(t.getFullYear())?Nt:Ht)[t.getMonth()]+t.getDate()-1|0,l()[e+28>>>2>>>0]=n,l()[e>>>2>>>0]=t.getSeconds(),l()[e+4>>>2>>>0]=t.getMinutes(),l()[e+8>>>2>>>0]=t.getHours(),l()[e+12>>>2>>>0]=t.getDate(),l()[e+16>>>2>>>0]=t.getMonth(),l()[e+20>>>2>>>0]=t.getYear(),e=t.getTime(),isNaN(e)?(l()[tr()>>>2>>>0]=61,e=-1):e/=1e3,sr((De=e,1<=+Math.abs(De)?0<De?+Math.floor(De/4294967296)>>>0:~~+Math.ceil((De-+(~~De>>>0))/4294967296)>>>0:0)),e>>>0},q:$t,r:Gt,y:function(e,t,n){function f(ne){return(ne=ne.toTimeString().match(/\\(([A-Za-z ]+)\\)$/))?ne[1]:"GMT"}e>>>=0,t>>>=0,n>>>=0;var y=new Date().getFullYear(),b=new Date(y,0,1),v=new Date(y,6,1);y=b.getTimezoneOffset();var z=v.getTimezoneOffset(),Te=Math.max(y,z);w()[e>>>2>>>0]=60*Te,l()[t>>>2>>>0]=+(y!=z),e=f(b),t=f(v),e=Yt(e),t=Yt(t),z<y?(w()[n>>>2>>>0]=e,w()[n+4>>>2>>>0]=t):(w()[n>>>2>>>0]=t,w()[n+4>>>2>>>0]=e)},c:()=>{Z("")},O:function(e,t,n){e>>>=0,t>>>=0,n>>>=0,ht.length=0;for(var f;f=h()[t++>>>0];){var y=f!=105;y&=f!=112,n+=y&&n%8?4:0,ht.push(f==112?w()[n>>>2>>>0]:f==105?l()[n>>>2>>>0]:g()[n>>>3>>>0]),n+=y?8:4}return Ne[e].apply(null,ht)},k:()=>{},i:()=>Date.now(),U:()=>{throw Le+=1,"unwind"},A:function(){return 4294901760},e:()=>performance.timeOrigin+performance.now(),f:()=>L?(wr(),tt(br)).cpus().length:navigator.hardwareConcurrency,x:function(e){e>>>=0;var t=h().length;if(e<=t||4294901760<e)return!1;for(var n=1;4>=n;n*=2){var f=t*(1+.2/n);f=Math.min(f,e+100663296);var y=Math;f=Math.max(e,f);e:{y=(y.min.call(y,4294901760,f+(65536-f%65536)%65536)-j.buffer.byteLength+65535)/65536;try{j.grow(y),we();var b=1;break e}catch{}b=void 0}if(b)return!0}return!1},M:zt,N:qt,G:Ye,g:Vt,m:Jt,v:Xt,l:Qt,a:j||i.wasmMemory,w:er,d:function(e,t,n,f){return er(e>>>0,t>>>0,n>>>0,f>>>0)}},T=function(){function e(n,f){return T=n.exports,T=Vr(),M.bb.push(T.za),Xe=T.Aa,Fe.unshift(T.V),ce=f,re(),T}var t={a:qr};if(pe++,i.instantiateWasm)try{return i.instantiateWasm(t,e)}catch(n){ee(`Module.instantiateWasm callback failed with error: ${n}`),D(n)}return at(t,function(n){e(n.instance,n.module)}).catch(D),{}}();i._OrtInit=(e,t)=>(i._OrtInit=T.W)(e,t),i._OrtGetLastError=(e,t)=>(i._OrtGetLastError=T.X)(e,t),i._OrtCreateSessionOptions=(e,t,n,f,y,b,v,z,Te,ne)=>(i._OrtCreateSessionOptions=T.Y)(e,t,n,f,y,b,v,z,Te,ne),i._OrtAppendExecutionProvider=(e,t)=>(i._OrtAppendExecutionProvider=T.Z)(e,t),i._OrtAddFreeDimensionOverride=(e,t,n)=>(i._OrtAddFreeDimensionOverride=T._)(e,t,n),i._OrtAddSessionConfigEntry=(e,t,n)=>(i._OrtAddSessionConfigEntry=T.$)(e,t,n),i._OrtReleaseSessionOptions=e=>(i._OrtReleaseSessionOptions=T.aa)(e),i._OrtCreateSession=(e,t,n)=>(i._OrtCreateSession=T.ba)(e,t,n),i._OrtReleaseSession=e=>(i._OrtReleaseSession=T.ca)(e),i._OrtGetInputOutputCount=(e,t,n)=>(i._OrtGetInputOutputCount=T.da)(e,t,n),i._OrtGetInputName=(e,t)=>(i._OrtGetInputName=T.ea)(e,t),i._OrtGetOutputName=(e,t)=>(i._OrtGetOutputName=T.fa)(e,t),i._OrtFree=e=>(i._OrtFree=T.ga)(e),i._OrtCreateTensor=(e,t,n,f,y,b)=>(i._OrtCreateTensor=T.ha)(e,t,n,f,y,b),i._OrtGetTensorData=(e,t,n,f,y)=>(i._OrtGetTensorData=T.ia)(e,t,n,f,y),i._OrtReleaseTensor=e=>(i._OrtReleaseTensor=T.ja)(e),i._OrtCreateRunOptions=(e,t,n,f)=>(i._OrtCreateRunOptions=T.ka)(e,t,n,f),i._OrtAddRunConfigEntry=(e,t,n)=>(i._OrtAddRunConfigEntry=T.la)(e,t,n),i._OrtReleaseRunOptions=e=>(i._OrtReleaseRunOptions=T.ma)(e),i._OrtCreateBinding=e=>(i._OrtCreateBinding=T.na)(e),i._OrtBindInput=(e,t,n)=>(i._OrtBindInput=T.oa)(e,t,n),i._OrtBindOutput=(e,t,n,f)=>(i._OrtBindOutput=T.pa)(e,t,n,f),i._OrtClearBoundOutputs=e=>(i._OrtClearBoundOutputs=T.qa)(e),i._OrtReleaseBinding=e=>(i._OrtReleaseBinding=T.ra)(e),i._OrtRunWithBinding=(e,t,n,f,y)=>(i._OrtRunWithBinding=T.sa)(e,t,n,f,y),i._OrtRun=(e,t,n,f,y,b,v,z)=>(i._OrtRun=T.ta)(e,t,n,f,y,b,v,z),i._OrtEndProfiling=e=>(i._OrtEndProfiling=T.ua)(e);var tr=()=>(tr=T.va)(),lt=i._pthread_self=()=>(lt=i._pthread_self=T.wa)(),rr=i._malloc=e=>(rr=i._malloc=T.xa)(e);i._free=e=>(i._free=T.ya)(e),i.__emscripten_tls_init=()=>(i.__emscripten_tls_init=T.za)();var nr=i.__emscripten_thread_init=(e,t,n,f,y,b)=>(nr=i.__emscripten_thread_init=T.Ba)(e,t,n,f,y,b);i.__emscripten_thread_crashed=()=>(i.__emscripten_thread_crashed=T.Ca)();var ar=(e,t,n,f)=>(ar=T.Da)(e,t,n,f),wt=e=>(wt=T.Ea)(e),Ot=i.__emscripten_thread_exit=e=>(Ot=i.__emscripten_thread_exit=T.Fa)(e),or=()=>(or=T.Ga)(),sr=e=>(sr=T.Ha)(e),ir=(e,t)=>(ir=T.Ia)(e,t),vt=()=>(vt=T.Ja)(),ct=e=>(ct=T.Ka)(e),_t=e=>(_t=T.La)(e);function Vr(){var e=T;e=Object.assign({},e);var t=f=>()=>f()>>>0,n=f=>y=>f(y)>>>0;return e.va=t(e.va),e.wa=t(e.wa),e.xa=n(e.xa),e.emscripten_main_runtime_thread_id=t(e.emscripten_main_runtime_thread_id),e.Ja=t(e.Ja),e.La=n(e.La),e}i.wasmMemory=j,i.stackAlloc=_t,i.stackSave=vt,i.stackRestore=ct,i.keepRuntimeAlive=()=>0<Le,i.UTF8ToString=Ge,i.stringToUTF8=oe,i.lengthBytesUTF8=K,i.ExitStatus=Pe,i.PThread=M;var dt;ve=function e(){dt||ur(),dt||(ve=e)};function ur(){if(!(0<pe))if(_)A(i),_||Be(Fe),startWorker(i);else{if(i.preRun)for(typeof i.preRun=="function"&&(i.preRun=[i.preRun]);i.preRun.length;)Me.unshift(i.preRun.shift());Be(Me),0<pe||dt||(dt=!0,i.calledRun=!0,P||(_||Be(Fe),A(i),_||Be(Ee)))}}return ur(),d.ready}})();typeof vr=="object"&&typeof Ft=="object"?Ft.exports=Or:typeof define=="function"&&define.amd&&define([],()=>Or)});var Er=et((On,nn)=>{nn.exports=\'"use strict";var Module={},ENVIRONMENT_IS_NODE=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string";if(ENVIRONMENT_IS_NODE){var nodeWorkerThreads=require("worker_threads"),parentPort=nodeWorkerThreads.parentPort;parentPort.on("message",e=>onmessage({data:e}));var fs=require("fs"),vm=require("vm");Object.assign(global,{self:global,require,Module,location:{href:__filename},Worker:nodeWorkerThreads.Worker,importScripts:e=>vm.runInThisContext(fs.readFileSync(e,"utf8"),{filename:e}),postMessage:e=>parentPort.postMessage(e),performance:global.performance||{now:Date.now}})}var initializedJS=!1;function threadPrintErr(){var e=Array.prototype.slice.call(arguments).join(" ");if(ENVIRONMENT_IS_NODE){fs.writeSync(2,e+`\\n`);return}console.error(e)}function threadAlert(){var e=Array.prototype.slice.call(arguments).join(" ");postMessage({cmd:"alert",text:e,threadId:Module._pthread_self()})}var err=threadPrintErr;self.alert=threadAlert,Module.instantiateWasm=(e,t)=>{var a=Module.wasmModule;Module.wasmModule=null;var r=new WebAssembly.Instance(a,e);return t(r)},self.onunhandledrejection=e=>{throw e.reason||e};function handleMessage(e){try{if(e.data.cmd==="load"){let a=[];self.onmessage=r=>a.push(r),self.startWorker=r=>{Module=r,postMessage({cmd:"loaded"});for(let s of a)handleMessage(s);self.onmessage=handleMessage},Module.wasmModule=e.data.wasmModule;for(const r of e.data.handlers)Module[r]=(...s)=>{postMessage({cmd:"callHandler",handler:r,args:s})};if(Module.wasmMemory=e.data.wasmMemory,Module.buffer=Module.wasmMemory.buffer,Module.ENVIRONMENT_IS_PTHREAD=!0,typeof e.data.urlOrBlob=="string")importScripts(e.data.urlOrBlob);else{var t=URL.createObjectURL(e.data.urlOrBlob);importScripts(t),URL.revokeObjectURL(t)}ortWasmThreaded(Module)}else if(e.data.cmd==="run"){Module.__emscripten_thread_init(e.data.pthread_ptr,0,0,1),Module.__emscripten_thread_mailbox_await(e.data.pthread_ptr),Module.establishStackSpace(),Module.PThread.receiveObjectTransfer(e.data),Module.PThread.threadInitTLS(),initializedJS||(initializedJS=!0);try{Module.invokeEntryPoint(e.data.start_routine,e.data.arg)}catch(a){if(a!="unwind")throw a}}else e.data.cmd==="cancel"?Module._pthread_self()&&Module.__emscripten_thread_exit(-1):e.data.target==="setimmediate"||(e.data.cmd==="checkMailbox"?initializedJS&&Module.checkMailbox():e.data.cmd&&(err(`worker.js received unknown command ${e.data.cmd}`),err(e.data)))}catch(a){throw Module.__emscripten_thread_crashed?.(),a}}self.onmessage=handleMessage;\\n\'});var Tr;Tr=gr();var an=_r(),Ut,Pt=!1,pt=!1,Sr=!1,on=u=>{if(u===1)return!1;if(typeof SharedArrayBuffer>"u")return typeof self<"u"&&!self.crossOriginIsolated&&console.warn("env.wasm.numThreads is set to "+u+", but this will not work unless you enable crossOriginIsolated mode. See https://web.dev/cross-origin-isolation-guide/ for more info."),!1;typeof process<"u"&&process.versions&&process.versions.node&&console.warn("env.wasm.numThreads is set to "+u+", however, currently onnxruntime-web does not support multi-threads in Node.js. Please consider using onnxruntime-node for performance critical scenarios.");try{return typeof MessageChannel<"u"&&new MessageChannel().port1.postMessage(new SharedArrayBuffer(1)),WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,5,4,1,3,1,1,10,11,1,9,0,65,0,254,16,2,0,26,11]))}catch{return!1}},sn=()=>{try{return WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,10,30,1,28,0,65,0,253,15,253,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,186,1,26,11]))}catch{return!1}},un=(u,d)=>u?d?"ort-wasm-simd-threaded.wasm":"ort-wasm-simd.wasm":d?"ort-wasm-threaded.wasm":"ort-wasm.wasm",Ar=async u=>{if(Pt)return Promise.resolve();if(pt)throw new Error("multiple calls to \'initializeWebAssembly()\' detected.");if(Sr)throw new Error("previous call to \'initializeWebAssembly()\' failed.");pt=!0;let d=u.initTimeout,a=u.numThreads,h=u.simd,l=on(a),w=h&&sn(),g=u.wasmPaths,i=typeof g=="string"?g:void 0,A=un(w,l),D=typeof g=="object"?g[A]:void 0,I=!1,B=[];if(d>0&&B.push(new Promise(F=>{setTimeout(()=>{I=!0,F()},d)})),B.push(new Promise((F,U)=>{let k=l?an:Tr,L={locateFile:(_,x)=>l&&_.endsWith(".worker.js")&&typeof Blob<"u"?URL.createObjectURL(new Blob([Er()],{type:"text/javascript"})):_.endsWith(".wasm")?D||(i??x)+A:x+_};if(l)if(L.numThreads=a,typeof Blob>"u")L.mainScriptUrlOrBlob=(void 0)(__dirname,"ort-wasm-threaded.js");else{let _=`var ortWasmThreaded=${k.toString()};`;L.mainScriptUrlOrBlob=new Blob([_],{type:"text/javascript"})}k(L).then(_=>{pt=!1,Pt=!0,Ut=_,F()},_=>{pt=!1,Sr=!0,U(_)})})),await Promise.race(B),I)throw new Error(`WebAssembly backend initializing failed due to timeout: ${d}ms`)},X=()=>{if(Pt&&Ut)return Ut;throw new Error("WebAssembly is not initialized yet.")};var Q=(u,d)=>{let a=X(),h=a.lengthBytesUTF8(u)+1,l=a._malloc(h);return a.stringToUTF8(u,l,h),d.push(l),l},rt=(u,d,a,h)=>{if(typeof u=="object"&&u!==null){if(a.has(u))throw new Error("Circular reference in options");a.add(u)}Object.entries(u).forEach(([l,w])=>{let g=d?d+l:l;if(typeof w=="object")rt(w,g+".",a,h);else if(typeof w=="string"||typeof w=="number")h(g,w.toString());else if(typeof w=="boolean")h(g,w?"1":"0");else throw new Error(`Can\'t handle extra config type: ${typeof w}`)})},V=u=>{let d=X(),a=d.stackSave();try{let h=d.stackAlloc(8);d._OrtGetLastError(h,h+4);let l=d.HEAP32[h/4],w=d.HEAPU32[h/4+1],g=w?d.UTF8ToString(w):"";throw new Error(`${u} ERROR_CODE: ${l}, ERROR_MESSAGE: ${g}`)}finally{d.stackRestore(a)}};var Mr=u=>{let d=X(),a=0,h=[],l=u||{};try{if(u?.logSeverityLevel===void 0)l.logSeverityLevel=2;else if(typeof u.logSeverityLevel!="number"||!Number.isInteger(u.logSeverityLevel)||u.logSeverityLevel<0||u.logSeverityLevel>4)throw new Error(`log serverity level is not valid: ${u.logSeverityLevel}`);if(u?.logVerbosityLevel===void 0)l.logVerbosityLevel=0;else if(typeof u.logVerbosityLevel!="number"||!Number.isInteger(u.logVerbosityLevel))throw new Error(`log verbosity level is not valid: ${u.logVerbosityLevel}`);u?.terminate===void 0&&(l.terminate=!1);let w=0;return u?.tag!==void 0&&(w=Q(u.tag,h)),a=d._OrtCreateRunOptions(l.logSeverityLevel,l.logVerbosityLevel,!!l.terminate,w),a===0&&V("Can\'t create run options."),u?.extra!==void 0&&rt(u.extra,"",new WeakSet,(g,i)=>{let A=Q(g,h),D=Q(i,h);d._OrtAddRunConfigEntry(a,A,D)!==0&&V(`Can\'t set a run config entry: ${g} - ${i}.`)}),[a,h]}catch(w){throw a!==0&&d._OrtReleaseRunOptions(a),h.forEach(g=>d._free(g)),w}};var fn=u=>{switch(u){case"disabled":return 0;case"basic":return 1;case"extended":return 2;case"all":return 99;default:throw new Error(`unsupported graph optimization level: ${u}`)}},ln=u=>{switch(u){case"sequential":return 0;case"parallel":return 1;default:throw new Error(`unsupported execution mode: ${u}`)}},cn=u=>{u.extra||(u.extra={}),u.extra.session||(u.extra.session={});let d=u.extra.session;d.use_ort_model_bytes_directly||(d.use_ort_model_bytes_directly="1"),u.executionProviders&&u.executionProviders.some(a=>(typeof a=="string"?a:a.name)==="webgpu")&&(u.enableMemPattern=!1)},dn=(u,d,a)=>{for(let h of d){let l=typeof h=="string"?h:h.name;switch(l){case"webnn":if(l="WEBNN",typeof h!="string"){let g=h;if(g?.deviceType){let i=Q("deviceType",a),A=Q(g.deviceType,a);X()._OrtAddSessionConfigEntry(u,i,A)!==0&&V(`Can\'t set a session config entry: \'deviceType\' - ${g.deviceType}.`)}if(g?.numThreads){let i=g.numThreads;(typeof i!="number"||!Number.isInteger(i)||i<0)&&(i=0);let A=Q("numThreads",a),D=Q(i.toString(),a);X()._OrtAddSessionConfigEntry(u,A,D)!==0&&V(`Can\'t set a session config entry: \'numThreads\' - ${g.numThreads}.`)}if(g?.powerPreference){let i=Q("powerPreference",a),A=Q(g.powerPreference,a);X()._OrtAddSessionConfigEntry(u,i,A)!==0&&V(`Can\'t set a session config entry: \'powerPreference\' - ${g.powerPreference}.`)}}break;case"webgpu":if(l="JS",typeof h!="string"){let g=h;if(g?.preferredLayout){if(g.preferredLayout!=="NCHW"&&g.preferredLayout!=="NHWC")throw new Error(`preferredLayout must be either \'NCHW\' or \'NHWC\': ${g.preferredLayout}`);let i=Q("preferredLayout",a),A=Q(g.preferredLayout,a);X()._OrtAddSessionConfigEntry(u,i,A)!==0&&V(`Can\'t set a session config entry: \'preferredLayout\' - ${g.preferredLayout}.`)}}break;case"wasm":case"cpu":continue;default:throw new Error(`not supported execution provider: ${l}`)}let w=Q(l,a);X()._OrtAppendExecutionProvider(u,w)!==0&&V(`Can\'t append execution provider: ${l}.`)}},Cr=u=>{let d=X(),a=0,h=[],l=u||{};cn(l);try{let w=fn(l.graphOptimizationLevel??"all"),g=ln(l.executionMode??"sequential"),i=typeof l.logId=="string"?Q(l.logId,h):0,A=l.logSeverityLevel??2;if(!Number.isInteger(A)||A<0||A>4)throw new Error(`log serverity level is not valid: ${A}`);let D=l.logVerbosityLevel??0;if(!Number.isInteger(D)||D<0||D>4)throw new Error(`log verbosity level is not valid: ${D}`);let I=typeof l.optimizedModelFilePath=="string"?Q(l.optimizedModelFilePath,h):0;if(a=d._OrtCreateSessionOptions(w,!!l.enableCpuMemArena,!!l.enableMemPattern,g,!!l.enableProfiling,0,i,A,D,I),a===0&&V("Can\'t create session options."),l.executionProviders&&dn(a,l.executionProviders,h),l.freeDimensionOverrides)for(let[B,F]of Object.entries(l.freeDimensionOverrides)){if(typeof B!="string")throw new Error(`free dimension override name must be a string: ${B}`);if(typeof F!="number"||!Number.isInteger(F)||F<0)throw new Error(`free dimension override value must be a non-negative integer: ${F}`);let U=Q(B,h);d._OrtAddFreeDimensionOverride(a,U,F)!==0&&V(`Can\'t set a free dimension override: ${B} - ${F}.`)}return l.extra!==void 0&&rt(l.extra,"",new WeakSet,(B,F)=>{let U=Q(B,h),k=Q(F,h);d._OrtAddSessionConfigEntry(a,U,k)!==0&&V(`Can\'t set a session config entry: ${B} - ${F}.`)}),[a,h]}catch(w){throw a!==0&&d._OrtReleaseSessionOptions(a),h.forEach(g=>d._free(g)),w}};var Rt=u=>{switch(u){case"int8":return 3;case"uint8":return 2;case"bool":return 9;case"int16":return 5;case"uint16":return 4;case"int32":return 6;case"uint32":return 12;case"float16":return 10;case"float32":return 1;case"float64":return 11;case"string":return 8;case"int64":return 7;case"uint64":return 13;default:throw new Error(`unsupported data type: ${u}`)}},Dr=u=>{switch(u){case 3:return"int8";case 2:return"uint8";case 9:return"bool";case 5:return"int16";case 4:return"uint16";case 6:return"int32";case 12:return"uint32";case 10:return"float16";case 1:return"float32";case 11:return"float64";case 8:return"string";case 7:return"int64";case 13:return"uint64";default:throw new Error(`unsupported data type: ${u}`)}},It=u=>[void 0,4,1,1,2,2,4,8,void 0,1,2,8,4,8,void 0,void 0,void 0][u],xr=u=>{switch(u){case"float16":return Uint16Array;case"float32":return Float32Array;case"uint8":return Uint8Array;case"int8":return Int8Array;case"uint16":return Uint16Array;case"int16":return Int16Array;case"int32":return Int32Array;case"bool":return Uint8Array;case"float64":return Float64Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"uint64":return BigUint64Array;default:throw new Error(`unsupported type: ${u}`)}},Fr=u=>{switch(u){case"verbose":return 0;case"info":return 1;case"warning":return 2;case"error":return 3;case"fatal":return 4;default:throw new Error(`unsupported logging level: ${u}`)}},Ur=u=>u==="float32"||u==="int32"||u==="int64"||u==="bool"||u==="float16"||u==="uint32",Pr=u=>{switch(u){case"none":return 0;case"cpu":return 1;case"cpu-pinned":return 2;case"texture":return 3;case"gpu-buffer":return 4;default:throw new Error(`unsupported data location: ${u}`)}};var Rr=async u=>{if(typeof u=="string")if(typeof process<"u"&&process.versions&&process.versions.node)try{return new Uint8Array(await(void 0)(u))}catch(d){if(d.code==="ERR_FS_FILE_TOO_LARGE"){let a=(void 0)(u),h=[];for await(let l of a)h.push(l);return new Uint8Array(Buffer.concat(h))}throw d}else{let d=await fetch(u);if(!d.ok)throw new Error(`failed to load external data file: ${u}`);let a=d.headers.get("Content-Length"),h=a?parseInt(a,10):0;if(h<1073741824)return new Uint8Array(await d.arrayBuffer());{if(!d.body)throw new Error(`failed to load external data file: ${u}, no response body.`);let l=d.body.getReader(),w;try{w=new ArrayBuffer(h)}catch(i){if(i instanceof RangeError){let A=Math.ceil(h/65536);w=new WebAssembly.Memory({initial:A,maximum:A}).buffer}else throw i}let g=0;for(;;){let{done:i,value:A}=await l.read();if(i)break;let D=A.byteLength;new Uint8Array(w,g,D).set(A),g+=D}return new Uint8Array(w,0,h)}}else return u instanceof Blob?new Uint8Array(await u.arrayBuffer()):u instanceof Uint8Array?u:new Uint8Array(u)};var pn=(u,d)=>{X()._OrtInit(u,d)!==0&&V("Can\'t initialize onnxruntime.")},Lr=async u=>{pn(u.wasm.numThreads,Fr(u.logLevel))},Br=async(u,d)=>{},nt=new Map,mn=u=>{let d=X(),a=d.stackSave();try{let h=d.stackAlloc(8);return d._OrtGetInputOutputCount(u,h,h+4)!==0&&V("Can\'t get session input/output count."),[d.HEAP32[h/4],d.HEAP32[h/4+1]]}finally{d.stackRestore(a)}},Lt=u=>{let d=X(),a=d._malloc(u.byteLength);if(a===0)throw new Error(`Can\'t create a session. failed to allocate a buffer of size ${u.byteLength}.`);return d.HEAPU8.set(u,a),[a,u.byteLength]},Wr=async(u,d)=>{let a,h,l=X();Array.isArray(u)?[a,h]=u:u.buffer===l.HEAPU8.buffer?[a,h]=[u.byteOffset,u.byteLength]:[a,h]=Lt(u);let w=0,g=0,i=0,A=[],D=[],I=[];try{if([g,A]=Cr(d),d?.externalData&&l.mountExternalData){let x=[];for(let N of d.externalData){let he=typeof N=="string"?N:N.path;x.push(Rr(typeof N=="string"?N:N.data).then(ie=>{l.mountExternalData(he,ie)}))}await Promise.all(x)}w=l._OrtCreateSession(a,h,g),w===0&&V("Can\'t create a session.");let[B,F]=mn(w),U=[],k=[],L=[];for(let x=0;x<B;x++){let N=l._OrtGetInputName(w,x);N===0&&V("Can\'t get an input name."),D.push(N),U.push(l.UTF8ToString(N))}for(let x=0;x<F;x++){let N=l._OrtGetOutputName(w,x);N===0&&V("Can\'t get an output name."),I.push(N);let he=l.UTF8ToString(N);k.push(he)}let _=null;return nt.set(w,[w,D,I,_]),[w,U,k]}catch(B){throw D.forEach(F=>l._OrtFree(F)),I.forEach(F=>l._OrtFree(F)),i!==0&&l._OrtReleaseBinding(i),w!==0&&l._OrtReleaseSession(w),B}finally{l._free(a),g!==0&&l._OrtReleaseSessionOptions(g),A.forEach(B=>l._free(B)),l.unmountExternalData?.()}},kr=u=>{let d=X(),a=nt.get(u);if(!a)throw new Error(`cannot release session. invalid session id: ${u}`);let[h,l,w,g]=a;g&&d._OrtReleaseBinding(g.handle),d.jsepUnregisterBuffers?.(u),l.forEach(i=>d._OrtFree(i)),w.forEach(i=>d._OrtFree(i)),d._OrtReleaseSession(h),nt.delete(u)},Ir=(u,d,a,h,l)=>{if(!u){d.push(0);return}let w=X(),g=u[0],i=u[1],A=u[3],D,I;if(g==="string"&&A==="gpu-buffer")throw new Error("String tensor is not supported on GPU.");if(A==="gpu-buffer"){let U=u[2].gpuBuffer,k=It(Rt(g));I=i.reduce((L,_)=>L*_,1)*k,D=w.jsepRegisterBuffer(h,l,U,I)}else{let U=u[2];if(Array.isArray(U)){I=4*U.length,D=w._malloc(I),a.push(D);let k=D/4;for(let L=0;L<U.length;L++){if(typeof U[L]!="string")throw new TypeError(`tensor data at index ${L} is not a string`);w.HEAPU32[k++]=Q(U[L],a)}}else I=U.byteLength,D=w._malloc(I),a.push(D),w.HEAPU8.set(new Uint8Array(U.buffer,U.byteOffset,I),D)}let B=w.stackSave(),F=w.stackAlloc(4*i.length);try{let U=F/4;i.forEach(L=>w.HEAP32[U++]=L);let k=w._OrtCreateTensor(Rt(g),D,I,F,i.length,Pr(A));k===0&&V(`Can\'t create tensor for input/output. session=${h}, index=${l}.`),d.push(k)}finally{w.stackRestore(B)}},Nr=async(u,d,a,h,l,w)=>{let g=X(),i=nt.get(u);if(!i)throw new Error(`cannot run inference. invalid session id: ${u}`);let[A,D,I,B]=i,F=d.length,U=h.length,k=0,L=[],_=[],x=[],N=[],he=g.stackSave(),ie=g.stackAlloc(F*4),ae=g.stackAlloc(F*4),E=g.stackAlloc(U*4),Y=g.stackAlloc(U*4);try{[k,L]=Mr(w);for(let P=0;P<F;P++)Ir(a[P],_,N,u,d[P]);for(let P=0;P<U;P++)Ir(l[P],x,N,u,F+h[P]);let ue=ie/4,Re=ae/4,Ie=E/4,ee=Y/4;for(let P=0;P<F;P++)g.HEAPU32[ue++]=_[P],g.HEAPU32[Re++]=D[d[P]];for(let P=0;P<U;P++)g.HEAPU32[Ie++]=x[P],g.HEAPU32[ee++]=I[h[P]];let j;j=await g._OrtRun(A,ae,ie,F,Y,U,E,k),j!==0&&V("failed to call OrtRun().");let ce=[];for(let P=0;P<U;P++){let te=g.HEAPU32[E/4+P];if(te===x[P]){ce.push(l[P]);continue}let de=g.stackSave(),ge=g.stackAlloc(4*4),ye=!1,J,fe=0;try{g._OrtGetTensorData(te,ge,ge+4,ge+8,ge+12)!==0&&V(`Can\'t access output tensor data on index ${P}.`);let Ae=ge/4,Me=g.HEAPU32[Ae++];fe=g.HEAPU32[Ae++];let Fe=g.HEAPU32[Ae++],Ee=g.HEAPU32[Ae++],pe=[];for(let re=0;re<Ee;re++)pe.push(g.HEAPU32[Fe/4+re]);g._OrtFree(Fe);let Oe=pe.reduce((re,Z)=>re*Z,1);J=Dr(Me);let ve=B?.outputPreferredLocations[h[P]];if(J==="string"){if(ve==="gpu-buffer")throw new Error("String tensor is not supported on GPU.");let re=[],Z=fe/4;for(let Ce=0;Ce<Oe;Ce++){let be=g.HEAPU32[Z++],_e=Ce===Oe-1?void 0:g.HEAPU32[Z]-be;re.push(g.UTF8ToString(be,_e))}ce.push([J,pe,re,"cpu"])}else if(ve==="gpu-buffer"&&Oe>0){let re=g.jsepGetBuffer(fe),Z=It(Me);if(Z===void 0||!Ur(J))throw new Error(`Unsupported data type: ${J}`);ye=!0,ce.push([J,pe,{gpuBuffer:re,download:g.jsepCreateDownloader(re,Oe*Z,J),dispose:()=>{g._OrtReleaseTensor(te)}},"gpu-buffer"])}else{let re=xr(J),Z=new re(Oe);new Uint8Array(Z.buffer,Z.byteOffset,Z.byteLength).set(g.HEAPU8.subarray(fe,fe+Z.byteLength)),ce.push([J,pe,Z,"cpu"])}}finally{g.stackRestore(de),J==="string"&&fe&&g._free(fe),ye||g._OrtReleaseTensor(te)}}return B&&g._OrtClearBoundOutputs(B.handle),ce}finally{g.stackRestore(he),_.forEach(ue=>g._OrtReleaseTensor(ue)),x.forEach(ue=>g._OrtReleaseTensor(ue)),N.forEach(ue=>g._free(ue)),k!==0&&g._OrtReleaseRunOptions(k),L.forEach(ue=>g._free(ue))}},Hr=u=>{let d=X(),a=nt.get(u);if(!a)throw new Error("invalid session id");let h=a[0],l=d._OrtEndProfiling(h);l===0&&V("Can\'t get an profile file name."),d._OrtFree(l)},$r=u=>{let d=[];for(let a of u){let h=a[2];!Array.isArray(h)&&"buffer"in h&&d.push(h.buffer)}return d};self.onmessage=u=>{let{type:d,in:a}=u.data;try{switch(d){case"init-wasm":Ar(a.wasm).then(()=>{Lr(a).then(()=>{postMessage({type:d})},h=>{postMessage({type:d,err:h})})},h=>{postMessage({type:d,err:h})});break;case"init-ep":{let{epName:h,env:l}=a;Br(l,h).then(()=>{postMessage({type:d})},w=>{postMessage({type:d,err:w})});break}case"copy-from":{let{buffer:h}=a,l=Lt(h);postMessage({type:d,out:l});break}case"create":{let{model:h,options:l}=a;Wr(h,l).then(w=>{postMessage({type:d,out:w})},w=>{postMessage({type:d,err:w})});break}case"release":kr(a),postMessage({type:d});break;case"run":{let{sessionId:h,inputIndices:l,inputs:w,outputIndices:g,options:i}=a;Nr(h,l,w,g,new Array(g.length).fill(null),i).then(A=>{A.some(D=>D[3]!=="cpu")?postMessage({type:d,err:"Proxy does not support non-cpu tensor location."}):postMessage({type:d,out:A},$r(A))},A=>{postMessage({type:d,err:A})});break}case"end-profiling":Hr(a),postMessage({type:d});break;default:}}catch(h){postMessage({type:d,err:h})}};})();\n'});var vr,bt,Tn,Fo,$o,ha,ma,Vr,Wr,gg,Lo,id,ad,sd,ud,ld,fd,cd,ba=L(()=>{"use strict";vt();nd();zr();vr=()=>!!Z.wasm.proxy&&typeof document<"u",Tn=!1,Fo=!1,$o=!1,ma=new Map,Vr=(a,t)=>{let o=ma.get(a);o?o.push(t):ma.set(a,[t])},Wr=()=>{if(Tn||!Fo||$o||!bt)throw new Error("worker not ready")},gg=a=>{switch(a.data.type){case"init-wasm":Tn=!1,a.data.err?($o=!0,ha[1](a.data.err)):(Fo=!0,ha[0]());break;case"init-ep":case"copy-from":case"create":case"release":case"run":case"end-profiling":{let t=ma.get(a.data.type);a.data.err?t.shift()[1](a.data.err):t.shift()[0](a.data.out);break}default:}},Lo=typeof document<"u"?document?.currentScript?.src:void 0,id=async()=>{if(!Fo){if(Tn)throw new Error("multiple calls to 'initWasm()' detected.");if($o)throw new Error("previous call to 'initWasm()' failed.");if(Tn=!0,vr())return Z.wasm.wasmPaths===void 0&&Lo&&Lo.indexOf("blob:")!==0&&(Z.wasm.wasmPaths=Lo.substr(0,+Lo.lastIndexOf("/")+1)),new Promise((a,t)=>{bt?.terminate();let o=URL.createObjectURL(new Blob([od()],{type:"text/javascript"}));bt=new Worker(o,{name:"ort-wasm-proxy-worker"}),bt.onerror=r=>t(r),bt.onmessage=gg,URL.revokeObjectURL(o),ha=[a,t];let e={type:"init-wasm",in:Z};bt.postMessage(e)});try{await Gp(Z.wasm),await Kp(Z),Fo=!0}catch(a){throw $o=!0,a}finally{Tn=!1}}},ad=async a=>{if(vr())return Wr(),new Promise((t,o)=>{Vr("init-ep",[t,o]);let e={type:"init-ep",in:{epName:a,env:Z}};bt.postMessage(e)});await Jp(Z,a)},sd=async a=>vr()?(Wr(),new Promise((t,o)=>{Vr("copy-from",[t,o]);let e={type:"copy-from",in:{buffer:a}};bt.postMessage(e,[a.buffer])})):da(a),ud=async(a,t)=>{if(vr()){if(t?.preferredOutputLocation)throw new Error('session option "preferredOutputLocation" is not supported for proxy.');return Wr(),new Promise((o,e)=>{Vr("create",[o,e]);let r={type:"create",in:{model:a,options:t}},n=[];a instanceof Uint8Array&&n.push(a.buffer),bt.postMessage(r,n)})}else return Zp(a,t)},ld=async a=>{if(vr())return Wr(),new Promise((t,o)=>{Vr("release",[t,o]);let e={type:"release",in:a};bt.postMessage(e)});Qp(a)},fd=async(a,t,o,e,r,n)=>{if(vr()){if(o.some(s=>s[3]!=="cpu"))throw new Error("input tensor on GPU is not supported for proxy.");if(r.some(s=>s))throw new Error("pre-allocated output tensor is not supported for proxy.");return Wr(),new Promise((s,i)=>{Vr("run",[s,i]);let u=o,l={type:"run",in:{sessionId:a,inputIndices:t,inputs:u,outputIndices:e,options:n}};bt.postMessage(l,rd(u))})}else return ed(a,t,o,e,r,n)},cd=async a=>{if(vr())return Wr(),new Promise((t,o)=>{Vr("end-profiling",[t,o]);let e={type:"end-profiling",in:a};bt.postMessage(e)});td(a)}});var pd,yg,Co,dd=L(()=>{"use strict";vt();ba();ca();pa();pd=(a,t)=>{switch(a.location){case"cpu":return[a.type,a.dims,a.data,"cpu"];case"gpu-buffer":return[a.type,a.dims,{gpuBuffer:a.gpuBuffer},"gpu-buffer"];default:throw new Error(`invalid data location: ${a.location} for ${t()}`)}},yg=a=>{switch(a[3]){case"cpu":return new ke(a[0],a[2],a[1]);case"gpu-buffer":{let t=a[0];if(!Do(t))throw new Error(`not supported data type: ${t} for deserializing GPU tensor`);let{gpuBuffer:o,download:e,dispose:r}=a[2];return ke.fromGpuBuffer(o,{dataType:t,dims:a[1],download:e,dispose:r})}default:throw new Error(`invalid data location: ${a[3]}`)}},Co=class{async fetchModelAndCopyToWasmMemory(t){return sd(await gn(t))}async loadModel(t,o){Xt();let e;typeof t=="string"?typeof process<"u"&&process.versions&&process.versions.node?e=await gn(t):e=await this.fetchModelAndCopyToWasmMemory(t):e=t,[this.sessionId,this.inputNames,this.outputNames]=await ud(e,o),Kt()}async dispose(){return ld(this.sessionId)}async run(t,o,e){Xt();let r=[],n=[];Object.entries(t).forEach(d=>{let T=d[0],O=d[1],v=this.inputNames.indexOf(T);if(v===-1)throw new Error(`invalid input '${T}'`);r.push(O),n.push(v)});let s=[],i=[];Object.entries(o).forEach(d=>{let T=d[0],O=d[1],v=this.outputNames.indexOf(T);if(v===-1)throw new Error(`invalid output '${T}'`);s.push(O),i.push(v)});let u=r.map((d,T)=>pd(d,()=>`input "${this.inputNames[n[T]]}"`)),l=s.map((d,T)=>d?pd(d,()=>`output "${this.outputNames[i[T]]}"`):null),f=await fd(this.sessionId,n,u,i,l,e),p={};for(let d=0;d<f.length;d++)p[this.outputNames[i[d]]]=s[d]??yg(f[d]);return Kt(),p}startProfiling(){}endProfiling(){cd(this.sessionId)}}});var Tg,ko,hd=L(()=>{"use strict";vt();ba();dd();Tg=()=>{if((typeof Z.wasm.initTimeout!="number"||Z.wasm.initTimeout<0)&&(Z.wasm.initTimeout=0),typeof Z.wasm.simd!="boolean"&&(Z.wasm.simd=!0),typeof Z.wasm.proxy!="boolean"&&(Z.wasm.proxy=!1),typeof Z.wasm.trace!="boolean"&&(Z.wasm.trace=!1),typeof Z.wasm.numThreads!="number"||!Number.isInteger(Z.wasm.numThreads)||Z.wasm.numThreads<=0){(typeof self<"u"&&!self.crossOriginIsolated||typeof process<"u"&&process.versions&&process.versions.node)&&(Z.wasm.numThreads=1);let a=typeof navigator>"u"?(void 0)().length:navigator.hardwareConcurrency;Z.wasm.numThreads=Math.min(4,Math.ceil((a||1)/2))}},ko=class{async init(t){Tg(),await id(),await ad(t)}async createInferenceSessionHandler(t,o){let e=new Co;return await e.loadModel(t,o),Promise.resolve(e)}}});var md={};ar(md,{wasmBackend:()=>xg});var xg,bd=L(()=>{"use strict";hd();xg=new ko});var wg={};ar(wg,{InferenceSession:()=>hs,TRACE:()=>jo,TRACE_FUNC_BEGIN:()=>Xt,TRACE_FUNC_END:()=>Kt,Tensor:()=>ke,TrainingSession:()=>ys,default:()=>vg,env:()=>Z,registerBackend:()=>Yt});vt();vt();vt();var xs="1.17.1";var vg=Xo;{let a=(Ip(),jt(Op)).onnxjsBackend;Yt("webgl",a,-10)}{let a=(bd(),jt(md)).wasmBackend;Yt("cpu",a,10),Yt("wasm",a,10),Yt("webnn",a,9)}Object.defineProperty(Z.versions,"web",{value:xs,enumerable:!0});return jt(wg);})();
/*! Bundled license information:

long/index.js:
  (**
   * @license
   * Copyright 2009 The Closure Library Authors
   * Copyright 2020 Daniel Wirtz / The long.js Authors.
   *
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   *
   * SPDX-License-Identifier: Apache-2.0
   *)
*/
//# sourceMappingURL=ort.min.js.map
