/*!
 * ONNX Runtime Web v1.17.1
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
"use strict";var ort=(()=>{var Uy=Object.create;var qo=Object.defineProperty;var Gy=Object.getOwnPropertyDescriptor;var Wy=Object.getOwnPropertyNames;var Hy=Object.getPrototypeOf,qy=Object.prototype.hasOwnProperty;var D=(r,e)=>()=>(r&&(e=r(r=0)),e);var Je=(r,e)=>()=>(e||r((e={exports:{}}).exports,e),e.exports),Mr=(r,e)=>{for(var n in e)qo(r,n,{get:e[n],enumerable:!0})},Gu=(r,e,n,t)=>{if(e&&typeof e=="object"||typeof e=="function")for(let o of Wy(e))!qy.call(r,o)&&o!==n&&qo(r,o,{get:()=>e[o],enumerable:!(t=Gy(e,o))||t.enumerable});return r};var Tn=(r,e,n)=>(n=r!=null?Uy(Hy(r)):{},Gu(e||!r||!r.__esModule?qo(n,"default",{value:r,enumerable:!0}):n,r)),Or=r=>Gu(qo({},"__esModule",{value:!0}),r);var jo,Jr,Er,Ko,Yo=D(()=>{"use strict";jo=new Map,Jr=[],Er=(r,e,n)=>{if(e&&typeof e.init=="function"&&typeof e.createInferenceSessionHandler=="function"){let t=jo.get(r);if(t===void 0)jo.set(r,{backend:e,priority:n});else{if(t.priority>n)return;if(t.priority===n&&t.backend!==e)throw new Error(`cannot register backend "${r}" using priority ${n}`)}if(n>=0){let o=Jr.indexOf(r);o!==-1&&Jr.splice(o,1);for(let i=0;i<Jr.length;i++)if(jo.get(Jr[i]).priority<=n){Jr.splice(i,0,r);return}Jr.push(r)}return}throw new TypeError("not a valid backend")},Ko=async r=>{let e=r.length===0?Jr:r,n=[];for(let t of e){let o=jo.get(t);if(o){if(o.initialized)return o.backend;if(o.aborted)continue;let i=!!o.initPromise;try{return i||(o.initPromise=o.backend.init(t)),await o.initPromise,o.initialized=!0,o.backend}catch(s){i||n.push({name:t,err:s}),o.aborted=!0}finally{delete o.initPromise}}}throw new Error(`no available backend found. ERR: ${n.map(t=>`[${t.name}] ${t.err}`).join(", ")}`)}});var Wu=D(()=>{"use strict";Yo()});var Hu,qu=D(()=>{"use strict";Hu="1.17.1"});var ju,Qr,Aa=D(()=>{"use strict";qu();ju="warning",Qr={wasm:{},webgl:{},webgpu:{},versions:{common:Hu},set logLevel(r){if(r!==void 0){if(typeof r!="string"||["verbose","info","warning","error","fatal"].indexOf(r)===-1)throw new Error(`Unsupported logging level: ${r}`);ju=r}},get logLevel(){return ju}};Object.defineProperty(Qr,"logLevel",{enumerable:!0})});var be,Ku=D(()=>{"use strict";Aa();be=Qr});var Yu,Xu,Zu=D(()=>{"use strict";Yu=(r,e)=>{let n=typeof document<"u"?document.createElement("canvas"):new OffscreenCanvas(1,1);n.width=r.dims[3],n.height=r.dims[2];let t=n.getContext("2d");if(t!=null){let o,i;e?.tensorLayout!==void 0&&e.tensorLayout==="NHWC"?(o=r.dims[2],i=r.dims[3]):(o=r.dims[3],i=r.dims[2]);let s=e?.format!==void 0?e.format:"RGB",a=e?.norm,u,l;a===void 0||a.mean===void 0?u=[255,255,255,255]:typeof a.mean=="number"?u=[a.mean,a.mean,a.mean,a.mean]:(u=[a.mean[0],a.mean[1],a.mean[2],0],a.mean[3]!==void 0&&(u[3]=a.mean[3])),a===void 0||a.bias===void 0?l=[0,0,0,0]:typeof a.bias=="number"?l=[a.bias,a.bias,a.bias,a.bias]:(l=[a.bias[0],a.bias[1],a.bias[2],0],a.bias[3]!==void 0&&(l[3]=a.bias[3]));let d=i*o,f=0,p=d,m=d*2,b=-1;s==="RGBA"?(f=0,p=d,m=d*2,b=d*3):s==="RGB"?(f=0,p=d,m=d*2):s==="RBG"&&(f=0,m=d,p=d*2);for(let y=0;y<i;y++)for(let $=0;$<o;$++){let x=(r.data[f++]-l[0])*u[0],T=(r.data[p++]-l[1])*u[1],A=(r.data[m++]-l[2])*u[2],E=b===-1?255:(r.data[b++]-l[3])*u[3];t.fillStyle="rgba("+x+","+T+","+A+","+E+")",t.fillRect($,y,1,1)}if("toDataURL"in n)return n.toDataURL();throw new Error("toDataURL is not supported")}else throw new Error("Can not access image data")},Xu=(r,e)=>{let n=typeof document<"u"?document.createElement("canvas").getContext("2d"):new OffscreenCanvas(1,1).getContext("2d"),t;if(n!=null){let o,i,s;e?.tensorLayout!==void 0&&e.tensorLayout==="NHWC"?(o=r.dims[2],i=r.dims[1],s=r.dims[3]):(o=r.dims[3],i=r.dims[2],s=r.dims[1]);let a=e!==void 0&&e.format!==void 0?e.format:"RGB",u=e?.norm,l,d;u===void 0||u.mean===void 0?l=[255,255,255,255]:typeof u.mean=="number"?l=[u.mean,u.mean,u.mean,u.mean]:(l=[u.mean[0],u.mean[1],u.mean[2],255],u.mean[3]!==void 0&&(l[3]=u.mean[3])),u===void 0||u.bias===void 0?d=[0,0,0,0]:typeof u.bias=="number"?d=[u.bias,u.bias,u.bias,u.bias]:(d=[u.bias[0],u.bias[1],u.bias[2],0],u.bias[3]!==void 0&&(d[3]=u.bias[3]));let f=i*o;if(e!==void 0&&(e.format!==void 0&&s===4&&e.format!=="RGBA"||s===3&&e.format!=="RGB"&&e.format!=="BGR"))throw new Error("Tensor format doesn't match input tensor dims");let p=4,m=0,b=1,y=2,$=3,x=0,T=f,A=f*2,E=-1;a==="RGBA"?(x=0,T=f,A=f*2,E=f*3):a==="RGB"?(x=0,T=f,A=f*2):a==="RBG"&&(x=0,A=f,T=f*2),t=n.createImageData(o,i);for(let N=0;N<i*o;m+=p,b+=p,y+=p,$+=p,N++)t.data[m]=(r.data[x++]-d[0])*l[0],t.data[b]=(r.data[T++]-d[1])*l[1],t.data[y]=(r.data[A++]-d[2])*l[2],t.data[$]=E===-1?255:(r.data[E++]-d[3])*l[3]}else throw new Error("Can not access image data");return t}});var Oa,Ju,Qu,el,tl,rl=D(()=>{"use strict";Xo();Oa=(r,e)=>{if(r===void 0)throw new Error("Image buffer must be defined");if(e.height===void 0||e.width===void 0)throw new Error("Image height and width must be defined");if(e.tensorLayout==="NHWC")throw new Error("NHWC Tensor layout is not supported yet");let{height:n,width:t}=e,o=e.norm??{mean:255,bias:0},i,s;typeof o.mean=="number"?i=[o.mean,o.mean,o.mean,o.mean]:i=[o.mean[0],o.mean[1],o.mean[2],o.mean[3]??255],typeof o.bias=="number"?s=[o.bias,o.bias,o.bias,o.bias]:s=[o.bias[0],o.bias[1],o.bias[2],o.bias[3]??0];let a=e.format!==void 0?e.format:"RGBA",u=e.tensorFormat!==void 0&&e.tensorFormat!==void 0?e.tensorFormat:"RGB",l=n*t,d=u==="RGBA"?new Float32Array(l*4):new Float32Array(l*3),f=4,p=0,m=1,b=2,y=3,$=0,x=l,T=l*2,A=-1;a==="RGB"&&(f=3,p=0,m=1,b=2,y=-1),u==="RGBA"?A=l*3:u==="RBG"?($=0,T=l,x=l*2):u==="BGR"&&(T=0,x=l,$=l*2);for(let N=0;N<l;N++,p+=f,b+=f,m+=f,y+=f)d[$++]=(r[p]+s[0])/i[0],d[x++]=(r[m]+s[1])/i[1],d[T++]=(r[b]+s[2])/i[2],A!==-1&&y!==-1&&(d[A++]=(r[y]+s[3])/i[3]);return u==="RGBA"?new kt("float32",d,[1,4,n,t]):new kt("float32",d,[1,3,n,t])},Ju=async(r,e)=>{let n=typeof HTMLImageElement<"u"&&r instanceof HTMLImageElement,t=typeof ImageData<"u"&&r instanceof ImageData,o=typeof ImageBitmap<"u"&&r instanceof ImageBitmap,i=typeof r=="string",s,a=e??{},u=()=>{if(typeof document<"u")return document.createElement("canvas");if(typeof OffscreenCanvas<"u")return new OffscreenCanvas(1,1);throw new Error("Canvas is not supported")},l=d=>d instanceof HTMLCanvasElement||d instanceof OffscreenCanvas?d.getContext("2d"):null;if(n){let d=u();d.width=r.width,d.height=r.height;let f=l(d);if(f!=null){let p=r.height,m=r.width;if(e!==void 0&&e.resizedHeight!==void 0&&e.resizedWidth!==void 0&&(p=e.resizedHeight,m=e.resizedWidth),e!==void 0){if(a=e,e.tensorFormat!==void 0)throw new Error("Image input config format must be RGBA for HTMLImageElement");a.tensorFormat="RGBA",a.height=p,a.width=m}else a.tensorFormat="RGBA",a.height=p,a.width=m;f.drawImage(r,0,0),s=f.getImageData(0,0,m,p).data}else throw new Error("Can not access image data")}else if(t){let d,f;if(e!==void 0&&e.resizedWidth!==void 0&&e.resizedHeight!==void 0?(d=e.resizedHeight,f=e.resizedWidth):(d=r.height,f=r.width),e!==void 0&&(a=e),a.format="RGBA",a.height=d,a.width=f,e!==void 0){let p=u();p.width=f,p.height=d;let m=l(p);if(m!=null)m.putImageData(r,0,0),s=m.getImageData(0,0,f,d).data;else throw new Error("Can not access image data")}else s=r.data}else if(o){if(e===void 0)throw new Error("Please provide image config with format for Imagebitmap");let d=u();d.width=r.width,d.height=r.height;let f=l(d);if(f!=null){let p=r.height,m=r.width;return f.drawImage(r,0,0,m,p),s=f.getImageData(0,0,m,p).data,a.height=p,a.width=m,Oa(s,a)}else throw new Error("Can not access image data")}else{if(i)return new Promise((d,f)=>{let p=u(),m=l(p);if(!r||!m)return f();let b=new Image;b.crossOrigin="Anonymous",b.src=r,b.onload=()=>{p.width=b.width,p.height=b.height,m.drawImage(b,0,0,p.width,p.height);let y=m.getImageData(0,0,p.width,p.height);a.height=p.height,a.width=p.width,d(Oa(y.data,a))}});throw new Error("Input data provided is not supported - aborted tensor creation")}if(s!==void 0)return Oa(s,a);throw new Error("Input data provided is not supported - aborted tensor creation")},Qu=(r,e)=>{let{width:n,height:t,download:o,dispose:i}=e,s=[1,t,n,4];return new kt({location:"texture",type:"float32",texture:r,dims:s,download:o,dispose:i})},el=(r,e)=>{let{dataType:n,dims:t,download:o,dispose:i}=e;return new kt({location:"gpu-buffer",type:n??"float32",gpuBuffer:r,dims:t,download:o,dispose:i})},tl=(r,e,n)=>new kt({location:"cpu-pinned",type:r,data:e,dims:n??[e.length]})});var ro,Zo,nl,ol,il=D(()=>{"use strict";ro=new Map([["float32",Float32Array],["uint8",Uint8Array],["int8",Int8Array],["uint16",Uint16Array],["float16",Uint16Array],["int16",Int16Array],["int32",Int32Array],["bool",Uint8Array],["float64",Float64Array],["uint32",Uint32Array]]),Zo=new Map([[Float32Array,"float32"],[Uint8Array,"uint8"],[Int8Array,"int8"],[Uint16Array,"uint16"],[Int16Array,"int16"],[Int32Array,"int32"],[Float64Array,"float64"],[Uint32Array,"uint32"]]),nl=!1,ol=()=>{if(!nl){nl=!0;let r=typeof BigInt64Array<"u"&&typeof BigInt64Array.from=="function",e=typeof BigUint64Array<"u"&&typeof BigUint64Array.from=="function";r&&(ro.set("int64",BigInt64Array),Zo.set(BigInt64Array,"int64")),e&&(ro.set("uint64",BigUint64Array),Zo.set(BigUint64Array,"uint64"))}}});var al,sl,ul=D(()=>{"use strict";Xo();al=r=>{let e=1;for(let n=0;n<r.length;n++){let t=r[n];if(typeof t!="number"||!Number.isSafeInteger(t))throw new TypeError(`dims[${n}] must be an integer, got: ${t}`);if(t<0)throw new RangeError(`dims[${n}] must be a non-negative integer, got: ${t}`);e*=t}return e},sl=(r,e)=>{switch(r.location){case"cpu":return new kt(r.type,r.data,e);case"cpu-pinned":return new kt({location:"cpu-pinned",data:r.data,type:r.type,dims:e});case"texture":return new kt({location:"texture",texture:r.texture,type:r.type,dims:e});case"gpu-buffer":return new kt({location:"gpu-buffer",gpuBuffer:r.gpuBuffer,type:r.type,dims:e});default:throw new Error(`tensorReshape: tensor location ${r.location} is not supported`)}}});var kt,Xo=D(()=>{"use strict";Zu();rl();il();ul();kt=class{constructor(e,n,t){ol();let o,i;if(typeof e=="object"&&"location"in e)switch(this.dataLocation=e.location,o=e.type,i=e.dims,e.location){case"cpu-pinned":{let a=ro.get(o);if(!a)throw new TypeError(`unsupported type "${o}" to create tensor from pinned buffer`);if(!(e.data instanceof a))throw new TypeError(`buffer should be of type ${a.name}`);this.cpuData=e.data;break}case"texture":{if(o!=="float32")throw new TypeError(`unsupported type "${o}" to create tensor from texture`);this.gpuTextureData=e.texture,this.downloader=e.download,this.disposer=e.dispose;break}case"gpu-buffer":{if(o!=="float32"&&o!=="float16"&&o!=="int32"&&o!=="int64"&&o!=="uint32"&&o!=="bool")throw new TypeError(`unsupported type "${o}" to create tensor from gpu buffer`);this.gpuBufferData=e.gpuBuffer,this.downloader=e.download,this.disposer=e.dispose;break}default:throw new Error(`Tensor constructor: unsupported location '${this.dataLocation}'`)}else{let a,u;if(typeof e=="string")if(o=e,u=t,e==="string"){if(!Array.isArray(n))throw new TypeError("A string tensor's data must be a string array.");a=n}else{let l=ro.get(e);if(l===void 0)throw new TypeError(`Unsupported tensor type: ${e}.`);if(Array.isArray(n)){if(e==="float16")throw new TypeError("Creating a float16 tensor from number array is not supported. Please use Uint16Array as data.");e==="uint64"||e==="int64"?a=l.from(n,BigInt):a=l.from(n)}else if(n instanceof l)a=n;else throw new TypeError(`A ${o} tensor's data must be type of ${l}`)}else if(u=n,Array.isArray(e)){if(e.length===0)throw new TypeError("Tensor type cannot be inferred from an empty array.");let l=typeof e[0];if(l==="string")o="string",a=e;else if(l==="boolean")o="bool",a=Uint8Array.from(e);else throw new TypeError(`Invalid element type of data array: ${l}.`)}else{let l=Zo.get(e.constructor);if(l===void 0)throw new TypeError(`Unsupported type for tensor data: ${e.constructor}.`);o=l,a=e}if(u===void 0)u=[a.length];else if(!Array.isArray(u))throw new TypeError("A tensor's dims must be a number array");i=u,this.cpuData=a,this.dataLocation="cpu"}let s=al(i);if(this.cpuData&&s!==this.cpuData.length)throw new Error(`Tensor's size(${s}) does not match data length(${this.cpuData.length}).`);this.type=o,this.dims=i,this.size=s}static async fromImage(e,n){return Ju(e,n)}static fromTexture(e,n){return Qu(e,n)}static fromGpuBuffer(e,n){return el(e,n)}static fromPinnedBuffer(e,n,t){return tl(e,n,t)}toDataURL(e){return Yu(this,e)}toImageData(e){return Xu(this,e)}get data(){if(this.ensureValid(),!this.cpuData)throw new Error("The data is not on CPU. Use `getData()` to download GPU data to CPU, or use `texture` or `gpuBuffer` property to access the GPU data directly.");return this.cpuData}get location(){return this.dataLocation}get texture(){if(this.ensureValid(),!this.gpuTextureData)throw new Error("The data is not stored as a WebGL texture.");return this.gpuTextureData}get gpuBuffer(){if(this.ensureValid(),!this.gpuBufferData)throw new Error("The data is not stored as a WebGPU buffer.");return this.gpuBufferData}async getData(e){switch(this.ensureValid(),this.dataLocation){case"cpu":case"cpu-pinned":return this.data;case"texture":case"gpu-buffer":{if(!this.downloader)throw new Error("The current tensor is not created with a specified data downloader.");if(this.isDownloading)throw new Error("The current tensor is being downloaded.");try{this.isDownloading=!0;let n=await this.downloader();return this.downloader=void 0,this.dataLocation="cpu",this.cpuData=n,e&&this.disposer&&(this.disposer(),this.disposer=void 0),n}finally{this.isDownloading=!1}}default:throw new Error(`cannot get data from location: ${this.dataLocation}`)}}dispose(){if(this.isDownloading)throw new Error("The current tensor is being downloaded.");this.disposer&&(this.disposer(),this.disposer=void 0),this.cpuData=void 0,this.gpuTextureData=void 0,this.gpuBufferData=void 0,this.downloader=void 0,this.isDownloading=void 0,this.dataLocation="none"}ensureValid(){if(this.dataLocation==="none")throw new Error("The tensor is disposed.")}reshape(e){if(this.ensureValid(),this.downloader||this.disposer)throw new Error("Cannot reshape a tensor that owns GPU resource.");return sl(this,e)}}});var xt,Jo=D(()=>{"use strict";Xo();xt=kt});var no,ll,zt,Nt,Ea=D(()=>{"use strict";Aa();no=(r,e)=>{Qr.wasm.trace&&console.timeStamp(`${r}::ORT::${e}`)},ll=(r,e)=>{let n=new Error().stack?.split(/\r\n|\r|\n/g)||[],t=!1;for(let o=0;o<n.length;o++){if(t&&!n[o].includes("TRACE_FUNC")){let i=`FUNC_${r}::${n[o].trim().split(" ")[1]}`;e&&(i+=`::${e}`),no("CPU",i);return}n[o].includes("TRACE_FUNC")&&(t=!0)}},zt=r=>{Qr.wasm.trace&&ll("BEGIN",r)},Nt=r=>{Qr.wasm.trace&&ll("END",r)}});var Qo,dl=D(()=>{"use strict";Yo();Jo();Ea();Qo=class r{constructor(e){this.handler=e}async run(e,n,t){zt();let o={},i={};if(typeof e!="object"||e===null||e instanceof xt||Array.isArray(e))throw new TypeError("'feeds' must be an object that use input names as keys and OnnxValue as corresponding values.");let s=!0;if(typeof n=="object"){if(n===null)throw new TypeError("Unexpected argument[1]: cannot be null.");if(n instanceof xt)throw new TypeError("'fetches' cannot be a Tensor");if(Array.isArray(n)){if(n.length===0)throw new TypeError("'fetches' cannot be an empty array.");s=!1;for(let l of n){if(typeof l!="string")throw new TypeError("'fetches' must be a string array or an object.");if(this.outputNames.indexOf(l)===-1)throw new RangeError(`'fetches' contains invalid output name: ${l}.`);o[l]=null}if(typeof t=="object"&&t!==null)i=t;else if(typeof t<"u")throw new TypeError("'options' must be an object.")}else{let l=!1,d=Object.getOwnPropertyNames(n);for(let f of this.outputNames)if(d.indexOf(f)!==-1){let p=n[f];(p===null||p instanceof xt)&&(l=!0,s=!1,o[f]=p)}if(l){if(typeof t=="object"&&t!==null)i=t;else if(typeof t<"u")throw new TypeError("'options' must be an object.")}else i=n}}else if(typeof n<"u")throw new TypeError("Unexpected argument[1]: must be 'fetches' or 'options'.");for(let l of this.inputNames)if(typeof e[l]>"u")throw new Error(`input '${l}' is missing in 'feeds'.`);if(s)for(let l of this.outputNames)o[l]=null;let a=await this.handler.run(e,o,i),u={};for(let l in a)if(Object.hasOwnProperty.call(a,l)){let d=a[l];d instanceof xt?u[l]=d:u[l]=new xt(d.type,d.data,d.dims)}return Nt(),u}async release(){return this.handler.dispose()}static async create(e,n,t,o){zt();let i,s={};if(typeof e=="string"){if(i=e,typeof n=="object"&&n!==null)s=n;else if(typeof n<"u")throw new TypeError("'options' must be an object.")}else if(e instanceof Uint8Array){if(i=e,typeof n=="object"&&n!==null)s=n;else if(typeof n<"u")throw new TypeError("'options' must be an object.")}else if(e instanceof ArrayBuffer||typeof SharedArrayBuffer<"u"&&e instanceof SharedArrayBuffer){let f=e,p=0,m=e.byteLength;if(typeof n=="object"&&n!==null)s=n;else if(typeof n=="number"){if(p=n,!Number.isSafeInteger(p))throw new RangeError("'byteOffset' must be an integer.");if(p<0||p>=f.byteLength)throw new RangeError(`'byteOffset' is out of range [0, ${f.byteLength}).`);if(m=e.byteLength-p,typeof t=="number"){if(m=t,!Number.isSafeInteger(m))throw new RangeError("'byteLength' must be an integer.");if(m<=0||p+m>f.byteLength)throw new RangeError(`'byteLength' is out of range (0, ${f.byteLength-p}].`);if(typeof o=="object"&&o!==null)s=o;else if(typeof o<"u")throw new TypeError("'options' must be an object.")}else if(typeof t<"u")throw new TypeError("'byteLength' must be a number.")}else if(typeof n<"u")throw new TypeError("'options' must be an object.");i=new Uint8Array(f,p,m)}else throw new TypeError("Unexpected argument[0]: must be 'path' or 'buffer'.");let u=(s.executionProviders||[]).map(f=>typeof f=="string"?f:f.name),d=await(await Ko(u)).createInferenceSessionHandler(i,s);return Nt(),new r(d)}startProfiling(){this.handler.startProfiling()}endProfiling(){this.handler.endProfiling()}get inputNames(){return this.handler.inputNames}get outputNames(){return this.handler.outputNames}}});var cl,fl=D(()=>{"use strict";dl();cl=Qo});var pl=D(()=>{"use strict"});var jy,ei,hl=D(()=>{"use strict";Yo();Jo();jy="Training backend could not be resolved. Make sure you're using the correct configuration & WebAssembly files.",ei=class r{constructor(e,n,t){this.handler=e,this.hasOptimizerModel=n,this.hasEvalModel=t}get trainingInputNames(){return this.handler.inputNames}get trainingOutputNames(){return this.handler.outputNames}get evalInputNames(){if(this.hasEvalModel)return this.handler.evalInputNames;throw new Error("This training session has no evalModel loaded.")}get evalOutputNames(){if(this.hasEvalModel)return this.handler.evalOutputNames;throw new Error("This training session has no evalModel loaded.")}static async create(e,n){let t=e.evalModel||"",o=e.optimizerModel||"",i=n||{},a=(i.executionProviders||[]).map(l=>typeof l=="string"?l:l.name),u=await Ko(a);if(u.createTrainingSessionHandler){let l=await u.createTrainingSessionHandler(e.checkpointState,e.trainModel,t,o,i);return new r(l,!!e.optimizerModel,!!e.evalModel)}else throw new Error(jy)}typeNarrowingForRunStep(e,n,t,o,i){let s={},a={};if(typeof t!="object"||t===null||t instanceof xt||Array.isArray(t))throw new TypeError("'feeds' must be an object that use input names as keys and OnnxValue as corresponding values.");let u=!0;if(typeof o=="object"){if(o===null)throw new TypeError("Unexpected argument[1]: cannot be null.");if(o instanceof xt)throw new TypeError("'fetches' cannot be a Tensor");if(Array.isArray(o)){if(o.length===0)throw new TypeError("'fetches' cannot be an empty array.");u=!1;for(let l of o){if(typeof l!="string")throw new TypeError("'fetches' must be a string array or an object.");if(n.indexOf(l)===-1)throw new RangeError(`'fetches' contains invalid output name: ${l}.`);s[l]=null}if(typeof i=="object"&&i!==null)a=i;else if(typeof i<"u")throw new TypeError("'options' must be an object.")}else{let l=!1,d=Object.getOwnPropertyNames(o);for(let f of n)if(d.indexOf(f)!==-1){let p=o[f];(p===null||p instanceof xt)&&(l=!0,u=!1,s[f]=p)}if(l){if(typeof i=="object"&&i!==null)a=i;else if(typeof i<"u")throw new TypeError("'options' must be an object.")}else a=o}}else if(typeof o<"u")throw new TypeError("Unexpected argument[1]: must be 'fetches' or 'options'.");for(let l of e)if(typeof t[l]>"u")throw new Error(`input '${l}' is missing in 'feeds'.`);if(u)for(let l of n)s[l]=null;return[s,a]}convertHandlerReturnTypeToMapOfTensors(e){let n={};for(let t in e)if(Object.hasOwnProperty.call(e,t)){let o=e[t];o instanceof xt?n[t]=o:n[t]=new xt(o.type,o.data,o.dims)}return n}async lazyResetGrad(){await this.handler.lazyResetGrad()}async runTrainStep(e,n,t){let[o,i]=this.typeNarrowingForRunStep(this.trainingInputNames,this.trainingOutputNames,e,n,t),s=await this.handler.runTrainStep(e,o,i);return this.convertHandlerReturnTypeToMapOfTensors(s)}async runOptimizerStep(e){if(this.hasOptimizerModel)await this.handler.runOptimizerStep(e||{});else throw new Error("This TrainingSession has no OptimizerModel loaded.")}async runEvalStep(e,n,t){if(this.hasEvalModel){let[o,i]=this.typeNarrowingForRunStep(this.evalInputNames,this.evalOutputNames,e,n,t),s=await this.handler.runEvalStep(e,o,i);return this.convertHandlerReturnTypeToMapOfTensors(s)}else throw new Error("This TrainingSession has no EvalModel loaded.")}async getParametersSize(e=!0){return this.handler.getParametersSize(e)}async loadParametersBuffer(e,n=!0){let t=await this.getParametersSize(n);if(e.length!==4*t)throw new Error("Size of the buffer passed into loadParametersBuffer must match the number of parameters in the model. Please use getParametersSize method to check.");return this.handler.loadParametersBuffer(e,n)}async getContiguousParameters(e=!0){return this.handler.getContiguousParameters(e)}async release(){return this.handler.dispose()}}});var ml,gl=D(()=>{"use strict";hl();ml=ei});var Ca={};Mr(Ca,{InferenceSession:()=>cl,TRACE:()=>no,TRACE_FUNC_BEGIN:()=>zt,TRACE_FUNC_END:()=>Nt,Tensor:()=>xt,TrainingSession:()=>ml,env:()=>be,registerBackend:()=>Er});var Et=D(()=>{"use strict";Wu();Ku();fl();Jo();Ea();pl();gl()});function Vr(r,e,n,t){if(e===void 0)return Yy(r);if(n===void 0)ti(r,e,1);else if(typeof n=="number"&&t===void 0)ti(r,e,n);else if(typeof n=="string"&&t===void 0)ti(r,n,1,e);else if(typeof n=="string"&&typeof t=="number")ti(r,n,t,e);else throw new TypeError("input is valid")}function Yy(r){return{verbose:Vr.verbose.bind(null,r),info:Vr.info.bind(null,r),warning:Vr.warning.bind(null,r),error:Vr.error.bind(null,r),fatal:Vr.fatal.bind(null,r)}}function ti(r,e,n,t){let o=oo[t||""]||oo[""];yl[r]<yl[o.minimalSeverity]||(o.logDateTime&&(e=`${new Date().toISOString()}|${e}`),o.logSourceLocation,Ky[o.provider].log(r,e,t))}var Pa,ka,yl,Ky,vl,oo,qe,ni,oi,ii,ri,Ht=D(()=>{"use strict";Pa=class{log(e,n,t){}},ka=class{log(e,n,t){console.log(`${this.color(e)} ${t?"\x1B[35m"+t+"\x1B[0m ":""}${n}`)}color(e){switch(e){case"verbose":return"\x1B[34;40mv\x1B[0m";case"info":return"\x1B[32mi\x1B[0m";case"warning":return"\x1B[30;43mw\x1B[0m";case"error":return"\x1B[31;40me\x1B[0m";case"fatal":return"\x1B[101mf\x1B[0m";default:throw new Error(`unsupported severity: ${e}`)}}},yl={verbose:1e3,info:2e3,warning:4e3,error:5e3,fatal:6e3},Ky={none:new Pa,console:new ka},vl={provider:"console",minimalSeverity:"warning",logDateTime:!0,logSourceLocation:!1},oo={"":vl};(u=>{function r(l,d){u("verbose",l,d)}u.verbose=r;function e(l,d){u("info",l,d)}u.info=e;function n(l,d){u("warning",l,d)}u.warning=n;function t(l,d){u("error",l,d)}u.error=t;function o(l,d){u("fatal",l,d)}u.fatal=o;function i(l){oo={},s("",l||{})}u.reset=i;function s(l,d){if(l==="*")i(d);else{let f=oo[l]||vl;oo[l]={provider:d.provider||f.provider,minimalSeverity:d.minimalSeverity||f.minimalSeverity,logDateTime:d.logDateTime===void 0?f.logDateTime:d.logDateTime,logSourceLocation:d.logSourceLocation===void 0?f.logSourceLocation:d.logSourceLocation}}}u.set=s;function a(l){let d={};l.logLevel&&(d.minimalSeverity=l.logLevel),s("",d)}u.setWithEnv=a})(Vr||={});qe=Vr,ni=class{constructor(e,n,t,o,i,s){this.category=e;this.name=n;this.startTime=t;this.endCallback=o;this.timer=i;this.ctx=s}async end(){return this.endCallback(this)}async checkTimer(){if(this.ctx===void 0||this.timer===void 0)throw new Error("No webgl timer found");return this.ctx.endTimer(),this.ctx.waitForQueryAndGetTime(this.timer)}},oi=class{constructor(e,n,t,o){this.category=e;this.name=n;this.startTime=t;this.endTime=o}},ii=class{constructor(e,n,t){this._started=!1;this._flushPointer=0;this._started=!1,this._maxNumberEvents=e===void 0?1e4:e,this._flushBatchSize=n===void 0?10:n,this._flushIntervalInMilliseconds=t===void 0?5e3:t}static create(e){return e===void 0?new this:new this(e.maxNumberEvents,e.flushBatchSize,e.flushIntervalInMilliseconds)}start(){this._started=!0,this._timingEvents=[],this._flushTime=ri(),this._flushPointer=0}stop(){for(this._started=!1;this._flushPointer<this._timingEvents.length;this._flushPointer++)this.logOneEvent(this._timingEvents[this._flushPointer])}event(e,n,t,o){let i=this._started?this.begin(e,n,o):void 0,s=!1,a=t();if(a&&typeof a.then=="function")return s=!0,new Promise((u,l)=>{a.then(async d=>{i&&await i.end(),u(d)},async d=>{i&&await i.end(),l(d)})});if(!s&&i){let u=i.end();if(u&&typeof u.then=="function")return new Promise((l,d)=>{u.then(()=>{l(a)},f=>{d(f)})})}return a}begin(e,n,t){if(!this._started)throw new Error("profiler is not started yet");if(t===void 0){let o=ri();return this.flush(o),new ni(e,n,o,i=>this.endSync(i))}else{let o=t.beginTimer();return new ni(e,n,0,async i=>this.end(i),o,t)}}async end(e){let n=await e.checkTimer();this._timingEvents.length<this._maxNumberEvents&&(this._timingEvents.push(new oi(e.category,e.name,e.startTime,n)),this.flush(n))}endSync(e){let n=ri();this._timingEvents.length<this._maxNumberEvents&&(this._timingEvents.push(new oi(e.category,e.name,e.startTime,n)),this.flush(n))}logOneEvent(e){qe.verbose(`Profiler.${e.category}`,`${(e.endTime-e.startTime).toFixed(2)}ms on event '${e.name}' at ${e.endTime.toFixed(2)}`)}flush(e){if(this._timingEvents.length-this._flushPointer>=this._flushBatchSize||e-this._flushTime>=this._flushIntervalInMilliseconds){for(let n=this._flushPointer;this._flushPointer<n+this._flushBatchSize&&this._flushPointer<this._timingEvents.length;this._flushPointer++)this.logOneEvent(this._timingEvents[this._flushPointer]);this._flushTime=ri()}}get started(){return this._started}},ri=typeof performance<"u"&&performance.now?()=>performance.now():Date.now});function wl(r,e,n){for(let t of n){let o=t[0],i=t[1],s=t[2],a=t[3],u=t[4];if(r.opType===o){for(let l of e)if((l.domain===i||l.domain==="ai.onnx"&&i==="")&&Xy(l.version,s))return{opImpl:a,opInit:u}}}throw new TypeError(`cannot resolve operator '${r.opType}' with opsets: ${e.map(t=>`${t.domain||"ai.onnx"} v${t.version}`).join(", ")}`)}function Xy(r,e){if(e.endsWith("+")){let n=Number.parseInt(e.substring(0,e.length-1),10);return!isNaN(n)&&n<=r}else if(e.split("-").length===2){let n=e.split("-"),t=Number.parseInt(n[0],10),o=Number.parseInt(n[1],10);return!isNaN(t)&&!isNaN(o)&&t<=r&&r<=o}else return Number.parseInt(e,10)===r}var xl=D(()=>{"use strict"});var Tl=Je(Da=>{"use strict";Da.__esModule=!0;var Zy=function(){function r(e){if(!e)throw new TypeError("Invalid argument; `value` has no value.");this.value=r.EMPTY,e&&r.isGuid(e)&&(this.value=e)}return r.isGuid=function(e){var n=e.toString();return e&&(e instanceof r||r.validator.test(n))},r.create=function(){return new r([r.gen(2),r.gen(1),r.gen(1),r.gen(1),r.gen(3)].join("-"))},r.createEmpty=function(){return new r("emptyguid")},r.parse=function(e){return new r(e)},r.raw=function(){return[r.gen(2),r.gen(1),r.gen(1),r.gen(1),r.gen(3)].join("-")},r.gen=function(e){for(var n="",t=0;t<e;t++)n+=((1+Math.random())*65536|0).toString(16).substring(1);return n},r.prototype.equals=function(e){return r.isGuid(e)&&this.value===e.toString()},r.prototype.isEmpty=function(){return this.value===r.EMPTY},r.prototype.toString=function(){return this.value},r.prototype.toJSON=function(){return{value:this.value}},r.validator=new RegExp("^[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}$","i"),r.EMPTY="00000000-0000-0000-0000-000000000000",r}();Da.Guid=Zy});function Qe(r,e,n){this.low=r|0,this.high=e|0,this.unsigned=!!n}function Ct(r){return(r&&r.__isLong__)===!0}function _l(r){var e=Math.clz32(r&-r);return r?31-e:e}function en(r,e){var n,t,o;return e?(r>>>=0,(o=0<=r&&r<256)&&(t=Sl[r],t)?t:(n=Ge(r,0,!0),o&&(Sl[r]=n),n)):(r|=0,(o=-128<=r&&r<128)&&(t=$l[r],t)?t:(n=Ge(r,r<0?-1:0,!1),o&&($l[r]=n),n))}function jt(r,e){if(isNaN(r))return e?Cr:nr;if(e){if(r<0)return Cr;if(r>=El)return kl}else{if(r<=-Al)return Lt;if(r+1>=Al)return Pl}return r<0?jt(-r,e).neg():Ge(r%$n|0,r/$n|0,e)}function Ge(r,e,n){return new Qe(r,e,n)}function Ra(r,e,n){if(r.length===0)throw Error("empty string");if(typeof e=="number"?(n=e,e=!1):e=!!e,r==="NaN"||r==="Infinity"||r==="+Infinity"||r==="-Infinity")return e?Cr:nr;if(n=n||10,n<2||36<n)throw RangeError("radix");var t;if((t=r.indexOf("-"))>0)throw Error("interior hyphen");if(t===0)return Ra(r.substring(1),e,n).neg();for(var o=jt(ai(n,8)),i=nr,s=0;s<r.length;s+=8){var a=Math.min(8,r.length-s),u=parseInt(r.substring(s,s+a),n);if(a<8){var l=jt(ai(n,a));i=i.mul(l).add(jt(u))}else i=i.mul(o),i=i.add(jt(u))}return i.unsigned=e,i}function or(r,e){return typeof r=="number"?jt(r,e):typeof r=="string"?Ra(r,e):Ge(r.low,r.high,typeof e=="boolean"?e:r.unsigned)}var qt,$l,Sl,ai,Il,Jy,$n,El,Al,Ol,nr,Cr,_n,Cl,Ba,Pl,kl,Lt,K,Pr,za=D(()=>{qt=null;try{qt=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch{}Qe.prototype.__isLong__;Object.defineProperty(Qe.prototype,"__isLong__",{value:!0});Qe.isLong=Ct;$l={},Sl={};Qe.fromInt=en;Qe.fromNumber=jt;Qe.fromBits=Ge;ai=Math.pow;Qe.fromString=Ra;Qe.fromValue=or;Il=65536,Jy=1<<24,$n=Il*Il,El=$n*$n,Al=El/2,Ol=en(Jy),nr=en(0);Qe.ZERO=nr;Cr=en(0,!0);Qe.UZERO=Cr;_n=en(1);Qe.ONE=_n;Cl=en(1,!0);Qe.UONE=Cl;Ba=en(-1);Qe.NEG_ONE=Ba;Pl=Ge(-1,2147483647,!1);Qe.MAX_VALUE=Pl;kl=Ge(-1,-1,!0);Qe.MAX_UNSIGNED_VALUE=kl;Lt=Ge(0,-2147483648,!1);Qe.MIN_VALUE=Lt;K=Qe.prototype;K.toInt=function(){return this.unsigned?this.low>>>0:this.low};K.toNumber=function(){return this.unsigned?(this.high>>>0)*$n+(this.low>>>0):this.high*$n+(this.low>>>0)};K.toString=function(e){if(e=e||10,e<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative())if(this.eq(Lt)){var n=jt(e),t=this.div(n),o=t.mul(n).sub(this);return t.toString(e)+o.toInt().toString(e)}else return"-"+this.neg().toString(e);for(var i=jt(ai(e,6),this.unsigned),s=this,a="";;){var u=s.div(i),l=s.sub(u.mul(i)).toInt()>>>0,d=l.toString(e);if(s=u,s.isZero())return d+a;for(;d.length<6;)d="0"+d;a=""+d+a}};K.getHighBits=function(){return this.high};K.getHighBitsUnsigned=function(){return this.high>>>0};K.getLowBits=function(){return this.low};K.getLowBitsUnsigned=function(){return this.low>>>0};K.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Lt)?64:this.neg().getNumBitsAbs();for(var e=this.high!=0?this.high:this.low,n=31;n>0&&!(e&1<<n);n--);return this.high!=0?n+33:n+1};K.isZero=function(){return this.high===0&&this.low===0};K.eqz=K.isZero;K.isNegative=function(){return!this.unsigned&&this.high<0};K.isPositive=function(){return this.unsigned||this.high>=0};K.isOdd=function(){return(this.low&1)===1};K.isEven=function(){return(this.low&1)===0};K.equals=function(e){return Ct(e)||(e=or(e)),this.unsigned!==e.unsigned&&this.high>>>31===1&&e.high>>>31===1?!1:this.high===e.high&&this.low===e.low};K.eq=K.equals;K.notEquals=function(e){return!this.eq(e)};K.neq=K.notEquals;K.ne=K.notEquals;K.lessThan=function(e){return this.comp(e)<0};K.lt=K.lessThan;K.lessThanOrEqual=function(e){return this.comp(e)<=0};K.lte=K.lessThanOrEqual;K.le=K.lessThanOrEqual;K.greaterThan=function(e){return this.comp(e)>0};K.gt=K.greaterThan;K.greaterThanOrEqual=function(e){return this.comp(e)>=0};K.gte=K.greaterThanOrEqual;K.ge=K.greaterThanOrEqual;K.compare=function(e){if(Ct(e)||(e=or(e)),this.eq(e))return 0;var n=this.isNegative(),t=e.isNegative();return n&&!t?-1:!n&&t?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1};K.comp=K.compare;K.negate=function(){return!this.unsigned&&this.eq(Lt)?Lt:this.not().add(_n)};K.neg=K.negate;K.add=function(e){Ct(e)||(e=or(e));var n=this.high>>>16,t=this.high&65535,o=this.low>>>16,i=this.low&65535,s=e.high>>>16,a=e.high&65535,u=e.low>>>16,l=e.low&65535,d=0,f=0,p=0,m=0;return m+=i+l,p+=m>>>16,m&=65535,p+=o+u,f+=p>>>16,p&=65535,f+=t+a,d+=f>>>16,f&=65535,d+=n+s,d&=65535,Ge(p<<16|m,d<<16|f,this.unsigned)};K.subtract=function(e){return Ct(e)||(e=or(e)),this.add(e.neg())};K.sub=K.subtract;K.multiply=function(e){if(this.isZero())return this;if(Ct(e)||(e=or(e)),qt){var n=qt.mul(this.low,this.high,e.low,e.high);return Ge(n,qt.get_high(),this.unsigned)}if(e.isZero())return this.unsigned?Cr:nr;if(this.eq(Lt))return e.isOdd()?Lt:nr;if(e.eq(Lt))return this.isOdd()?Lt:nr;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(Ol)&&e.lt(Ol))return jt(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,o=this.high&65535,i=this.low>>>16,s=this.low&65535,a=e.high>>>16,u=e.high&65535,l=e.low>>>16,d=e.low&65535,f=0,p=0,m=0,b=0;return b+=s*d,m+=b>>>16,b&=65535,m+=i*d,p+=m>>>16,m&=65535,m+=s*l,p+=m>>>16,m&=65535,p+=o*d,f+=p>>>16,p&=65535,p+=i*l,f+=p>>>16,p&=65535,p+=s*u,f+=p>>>16,p&=65535,f+=t*d+o*l+i*u+s*a,f&=65535,Ge(m<<16|b,f<<16|p,this.unsigned)};K.mul=K.multiply;K.divide=function(e){if(Ct(e)||(e=or(e)),e.isZero())throw Error("division by zero");if(qt){if(!this.unsigned&&this.high===-2147483648&&e.low===-1&&e.high===-1)return this;var n=(this.unsigned?qt.div_u:qt.div_s)(this.low,this.high,e.low,e.high);return Ge(n,qt.get_high(),this.unsigned)}if(this.isZero())return this.unsigned?Cr:nr;var t,o,i;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return Cr;if(e.gt(this.shru(1)))return Cl;i=Cr}else{if(this.eq(Lt)){if(e.eq(_n)||e.eq(Ba))return Lt;if(e.eq(Lt))return _n;var s=this.shr(1);return t=s.div(e).shl(1),t.eq(nr)?e.isNegative()?_n:Ba:(o=this.sub(e.mul(t)),i=t.add(o.div(e)),i)}else if(e.eq(Lt))return this.unsigned?Cr:nr;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();i=nr}for(o=this;o.gte(e);){t=Math.max(1,Math.floor(o.toNumber()/e.toNumber()));for(var a=Math.ceil(Math.log(t)/Math.LN2),u=a<=48?1:ai(2,a-48),l=jt(t),d=l.mul(e);d.isNegative()||d.gt(o);)t-=u,l=jt(t,this.unsigned),d=l.mul(e);l.isZero()&&(l=_n),i=i.add(l),o=o.sub(d)}return i};K.div=K.divide;K.modulo=function(e){if(Ct(e)||(e=or(e)),qt){var n=(this.unsigned?qt.rem_u:qt.rem_s)(this.low,this.high,e.low,e.high);return Ge(n,qt.get_high(),this.unsigned)}return this.sub(this.div(e).mul(e))};K.mod=K.modulo;K.rem=K.modulo;K.not=function(){return Ge(~this.low,~this.high,this.unsigned)};K.countLeadingZeros=function(){return this.high?Math.clz32(this.high):Math.clz32(this.low)+32};K.clz=K.countLeadingZeros;K.countTrailingZeros=function(){return this.low?_l(this.low):_l(this.high)+32};K.ctz=K.countTrailingZeros;K.and=function(e){return Ct(e)||(e=or(e)),Ge(this.low&e.low,this.high&e.high,this.unsigned)};K.or=function(e){return Ct(e)||(e=or(e)),Ge(this.low|e.low,this.high|e.high,this.unsigned)};K.xor=function(e){return Ct(e)||(e=or(e)),Ge(this.low^e.low,this.high^e.high,this.unsigned)};K.shiftLeft=function(e){return Ct(e)&&(e=e.toInt()),(e&=63)===0?this:e<32?Ge(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):Ge(0,this.low<<e-32,this.unsigned)};K.shl=K.shiftLeft;K.shiftRight=function(e){return Ct(e)&&(e=e.toInt()),(e&=63)===0?this:e<32?Ge(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):Ge(this.high>>e-32,this.high>=0?0:-1,this.unsigned)};K.shr=K.shiftRight;K.shiftRightUnsigned=function(e){return Ct(e)&&(e=e.toInt()),(e&=63)===0?this:e<32?Ge(this.low>>>e|this.high<<32-e,this.high>>>e,this.unsigned):e===32?Ge(this.high,0,this.unsigned):Ge(this.high>>>e-32,0,this.unsigned)};K.shru=K.shiftRightUnsigned;K.shr_u=K.shiftRightUnsigned;K.rotateLeft=function(e){var n;return Ct(e)&&(e=e.toInt()),(e&=63)===0?this:e===32?Ge(this.high,this.low,this.unsigned):e<32?(n=32-e,Ge(this.low<<e|this.high>>>n,this.high<<e|this.low>>>n,this.unsigned)):(e-=32,n=32-e,Ge(this.high<<e|this.low>>>n,this.low<<e|this.high>>>n,this.unsigned))};K.rotl=K.rotateLeft;K.rotateRight=function(e){var n;return Ct(e)&&(e=e.toInt()),(e&=63)===0?this:e===32?Ge(this.high,this.low,this.unsigned):e<32?(n=32-e,Ge(this.high<<n|this.low>>>e,this.low<<n|this.high>>>e,this.unsigned)):(e-=32,n=32-e,Ge(this.low<<n|this.high>>>e,this.high<<n|this.low>>>e,this.unsigned))};K.rotr=K.rotateRight;K.toSigned=function(){return this.unsigned?Ge(this.low,this.high,!1):this};K.toUnsigned=function(){return this.unsigned?this:Ge(this.low,this.high,!0)};K.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()};K.toBytesLE=function(){var e=this.high,n=this.low;return[n&255,n>>>8&255,n>>>16&255,n>>>24,e&255,e>>>8&255,e>>>16&255,e>>>24]};K.toBytesBE=function(){var e=this.high,n=this.low;return[e>>>24,e>>>16&255,e>>>8&255,e&255,n>>>24,n>>>16&255,n>>>8&255,n&255]};Qe.fromBytes=function(e,n,t){return t?Qe.fromBytesLE(e,n):Qe.fromBytesBE(e,n)};Qe.fromBytesLE=function(e,n){return new Qe(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,n)};Qe.fromBytesBE=function(e,n){return new Qe(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],n)};Pr=Qe});var k,si=D(()=>{k={};k.Offset;k.Table;k.SIZEOF_SHORT=2;k.SIZEOF_INT=4;k.FILE_IDENTIFIER_LENGTH=4;k.SIZE_PREFIX_LENGTH=4;k.Encoding={UTF8_BYTES:1,UTF16_STRING:2};k.int32=new Int32Array(2);k.float32=new Float32Array(k.int32.buffer);k.float64=new Float64Array(k.int32.buffer);k.isLittleEndian=new Uint16Array(new Uint8Array([1,0]).buffer)[0]===1;k.Long=function(r,e){this.low=r|0,this.high=e|0};k.Long.create=function(r,e){return r==0&&e==0?k.Long.ZERO:new k.Long(r,e)};k.Long.prototype.toFloat64=function(){return(this.low>>>0)+this.high*4294967296};k.Long.prototype.equals=function(r){return this.low==r.low&&this.high==r.high};k.Long.ZERO=new k.Long(0,0);k.Builder=function(r){if(r)var e=r;else var e=1024;this.bb=k.ByteBuffer.allocate(e),this.space=e,this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1};k.Builder.prototype.clear=function(){this.bb.clear(),this.space=this.bb.capacity(),this.minalign=1,this.vtable=null,this.vtable_in_use=0,this.isNested=!1,this.object_start=0,this.vtables=[],this.vector_num_elems=0,this.force_defaults=!1};k.Builder.prototype.forceDefaults=function(r){this.force_defaults=r};k.Builder.prototype.dataBuffer=function(){return this.bb};k.Builder.prototype.asUint8Array=function(){return this.bb.bytes().subarray(this.bb.position(),this.bb.position()+this.offset())};k.Builder.prototype.prep=function(r,e){r>this.minalign&&(this.minalign=r);for(var n=~(this.bb.capacity()-this.space+e)+1&r-1;this.space<n+r+e;){var t=this.bb.capacity();this.bb=k.Builder.growByteBuffer(this.bb),this.space+=this.bb.capacity()-t}this.pad(n)};k.Builder.prototype.pad=function(r){for(var e=0;e<r;e++)this.bb.writeInt8(--this.space,0)};k.Builder.prototype.writeInt8=function(r){this.bb.writeInt8(this.space-=1,r)};k.Builder.prototype.writeInt16=function(r){this.bb.writeInt16(this.space-=2,r)};k.Builder.prototype.writeInt32=function(r){this.bb.writeInt32(this.space-=4,r)};k.Builder.prototype.writeInt64=function(r){this.bb.writeInt64(this.space-=8,r)};k.Builder.prototype.writeFloat32=function(r){this.bb.writeFloat32(this.space-=4,r)};k.Builder.prototype.writeFloat64=function(r){this.bb.writeFloat64(this.space-=8,r)};k.Builder.prototype.addInt8=function(r){this.prep(1,0),this.writeInt8(r)};k.Builder.prototype.addInt16=function(r){this.prep(2,0),this.writeInt16(r)};k.Builder.prototype.addInt32=function(r){this.prep(4,0),this.writeInt32(r)};k.Builder.prototype.addInt64=function(r){this.prep(8,0),this.writeInt64(r)};k.Builder.prototype.addFloat32=function(r){this.prep(4,0),this.writeFloat32(r)};k.Builder.prototype.addFloat64=function(r){this.prep(8,0),this.writeFloat64(r)};k.Builder.prototype.addFieldInt8=function(r,e,n){(this.force_defaults||e!=n)&&(this.addInt8(e),this.slot(r))};k.Builder.prototype.addFieldInt16=function(r,e,n){(this.force_defaults||e!=n)&&(this.addInt16(e),this.slot(r))};k.Builder.prototype.addFieldInt32=function(r,e,n){(this.force_defaults||e!=n)&&(this.addInt32(e),this.slot(r))};k.Builder.prototype.addFieldInt64=function(r,e,n){(this.force_defaults||!e.equals(n))&&(this.addInt64(e),this.slot(r))};k.Builder.prototype.addFieldFloat32=function(r,e,n){(this.force_defaults||e!=n)&&(this.addFloat32(e),this.slot(r))};k.Builder.prototype.addFieldFloat64=function(r,e,n){(this.force_defaults||e!=n)&&(this.addFloat64(e),this.slot(r))};k.Builder.prototype.addFieldOffset=function(r,e,n){(this.force_defaults||e!=n)&&(this.addOffset(e),this.slot(r))};k.Builder.prototype.addFieldStruct=function(r,e,n){e!=n&&(this.nested(e),this.slot(r))};k.Builder.prototype.nested=function(r){if(r!=this.offset())throw new Error("FlatBuffers: struct must be serialized inline.")};k.Builder.prototype.notNested=function(){if(this.isNested)throw new Error("FlatBuffers: object serialization must not be nested.")};k.Builder.prototype.slot=function(r){this.vtable[r]=this.offset()};k.Builder.prototype.offset=function(){return this.bb.capacity()-this.space};k.Builder.growByteBuffer=function(r){var e=r.capacity();if(e&3221225472)throw new Error("FlatBuffers: cannot grow buffer beyond 2 gigabytes.");var n=e<<1,t=k.ByteBuffer.allocate(n);return t.setPosition(n-e),t.bytes().set(r.bytes(),n-e),t};k.Builder.prototype.addOffset=function(r){this.prep(k.SIZEOF_INT,0),this.writeInt32(this.offset()-r+k.SIZEOF_INT)};k.Builder.prototype.startObject=function(r){this.notNested(),this.vtable==null&&(this.vtable=[]),this.vtable_in_use=r;for(var e=0;e<r;e++)this.vtable[e]=0;this.isNested=!0,this.object_start=this.offset()};k.Builder.prototype.endObject=function(){if(this.vtable==null||!this.isNested)throw new Error("FlatBuffers: endObject called without startObject");this.addInt32(0);for(var r=this.offset(),e=this.vtable_in_use-1;e>=0&&this.vtable[e]==0;e--);for(var n=e+1;e>=0;e--)this.addInt16(this.vtable[e]!=0?r-this.vtable[e]:0);var t=2;this.addInt16(r-this.object_start);var o=(n+t)*k.SIZEOF_SHORT;this.addInt16(o);var i=0,s=this.space;e:for(e=0;e<this.vtables.length;e++){var a=this.bb.capacity()-this.vtables[e];if(o==this.bb.readInt16(a)){for(var u=k.SIZEOF_SHORT;u<o;u+=k.SIZEOF_SHORT)if(this.bb.readInt16(s+u)!=this.bb.readInt16(a+u))continue e;i=this.vtables[e];break}}return i?(this.space=this.bb.capacity()-r,this.bb.writeInt32(this.space,i-r)):(this.vtables.push(this.offset()),this.bb.writeInt32(this.bb.capacity()-r,this.offset()-r)),this.isNested=!1,r};k.Builder.prototype.finish=function(r,e,n){var t=n?k.SIZE_PREFIX_LENGTH:0;if(e){var o=e;if(this.prep(this.minalign,k.SIZEOF_INT+k.FILE_IDENTIFIER_LENGTH+t),o.length!=k.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+k.FILE_IDENTIFIER_LENGTH);for(var i=k.FILE_IDENTIFIER_LENGTH-1;i>=0;i--)this.writeInt8(o.charCodeAt(i))}this.prep(this.minalign,k.SIZEOF_INT+t),this.addOffset(r),t&&this.addInt32(this.bb.capacity()-this.space),this.bb.setPosition(this.space)};k.Builder.prototype.finishSizePrefixed=function(r,e){this.finish(r,e,!0)};k.Builder.prototype.requiredField=function(r,e){var n=this.bb.capacity()-r,t=n-this.bb.readInt32(n),o=this.bb.readInt16(t+e)!=0;if(!o)throw new Error("FlatBuffers: field "+e+" must be set")};k.Builder.prototype.startVector=function(r,e,n){this.notNested(),this.vector_num_elems=e,this.prep(k.SIZEOF_INT,r*e),this.prep(n,r*e)};k.Builder.prototype.endVector=function(){return this.writeInt32(this.vector_num_elems),this.offset()};k.Builder.prototype.createString=function(r){if(r instanceof Uint8Array)var e=r;else for(var e=[],n=0;n<r.length;){var t,o=r.charCodeAt(n++);if(o<55296||o>=56320)t=o;else{var i=r.charCodeAt(n++);t=(o<<10)+i+(65536-56623104-56320)}t<128?e.push(t):(t<2048?e.push(t>>6&31|192):(t<65536?e.push(t>>12&15|224):e.push(t>>18&7|240,t>>12&63|128),e.push(t>>6&63|128)),e.push(t&63|128))}this.addInt8(0),this.startVector(1,e.length,1),this.bb.setPosition(this.space-=e.length);for(var n=0,s=this.space,a=this.bb.bytes();n<e.length;n++)a[s++]=e[n];return this.endVector()};k.Builder.prototype.createLong=function(r,e){return k.Long.create(r,e)};k.ByteBuffer=function(r){this.bytes_=r,this.position_=0};k.ByteBuffer.allocate=function(r){return new k.ByteBuffer(new Uint8Array(r))};k.ByteBuffer.prototype.clear=function(){this.position_=0};k.ByteBuffer.prototype.bytes=function(){return this.bytes_};k.ByteBuffer.prototype.position=function(){return this.position_};k.ByteBuffer.prototype.setPosition=function(r){this.position_=r};k.ByteBuffer.prototype.capacity=function(){return this.bytes_.length};k.ByteBuffer.prototype.readInt8=function(r){return this.readUint8(r)<<24>>24};k.ByteBuffer.prototype.readUint8=function(r){return this.bytes_[r]};k.ByteBuffer.prototype.readInt16=function(r){return this.readUint16(r)<<16>>16};k.ByteBuffer.prototype.readUint16=function(r){return this.bytes_[r]|this.bytes_[r+1]<<8};k.ByteBuffer.prototype.readInt32=function(r){return this.bytes_[r]|this.bytes_[r+1]<<8|this.bytes_[r+2]<<16|this.bytes_[r+3]<<24};k.ByteBuffer.prototype.readUint32=function(r){return this.readInt32(r)>>>0};k.ByteBuffer.prototype.readInt64=function(r){return new k.Long(this.readInt32(r),this.readInt32(r+4))};k.ByteBuffer.prototype.readUint64=function(r){return new k.Long(this.readUint32(r),this.readUint32(r+4))};k.ByteBuffer.prototype.readFloat32=function(r){return k.int32[0]=this.readInt32(r),k.float32[0]};k.ByteBuffer.prototype.readFloat64=function(r){return k.int32[k.isLittleEndian?0:1]=this.readInt32(r),k.int32[k.isLittleEndian?1:0]=this.readInt32(r+4),k.float64[0]};k.ByteBuffer.prototype.writeInt8=function(r,e){this.bytes_[r]=e};k.ByteBuffer.prototype.writeUint8=function(r,e){this.bytes_[r]=e};k.ByteBuffer.prototype.writeInt16=function(r,e){this.bytes_[r]=e,this.bytes_[r+1]=e>>8};k.ByteBuffer.prototype.writeUint16=function(r,e){this.bytes_[r]=e,this.bytes_[r+1]=e>>8};k.ByteBuffer.prototype.writeInt32=function(r,e){this.bytes_[r]=e,this.bytes_[r+1]=e>>8,this.bytes_[r+2]=e>>16,this.bytes_[r+3]=e>>24};k.ByteBuffer.prototype.writeUint32=function(r,e){this.bytes_[r]=e,this.bytes_[r+1]=e>>8,this.bytes_[r+2]=e>>16,this.bytes_[r+3]=e>>24};k.ByteBuffer.prototype.writeInt64=function(r,e){this.writeInt32(r,e.low),this.writeInt32(r+4,e.high)};k.ByteBuffer.prototype.writeUint64=function(r,e){this.writeUint32(r,e.low),this.writeUint32(r+4,e.high)};k.ByteBuffer.prototype.writeFloat32=function(r,e){k.float32[0]=e,this.writeInt32(r,k.int32[0])};k.ByteBuffer.prototype.writeFloat64=function(r,e){k.float64[0]=e,this.writeInt32(r,k.int32[k.isLittleEndian?0:1]),this.writeInt32(r+4,k.int32[k.isLittleEndian?1:0])};k.ByteBuffer.prototype.getBufferIdentifier=function(){if(this.bytes_.length<this.position_+k.SIZEOF_INT+k.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: ByteBuffer is too short to contain an identifier.");for(var r="",e=0;e<k.FILE_IDENTIFIER_LENGTH;e++)r+=String.fromCharCode(this.readInt8(this.position_+k.SIZEOF_INT+e));return r};k.ByteBuffer.prototype.__offset=function(r,e){var n=r-this.readInt32(r);return e<this.readInt16(n)?this.readInt16(n+e):0};k.ByteBuffer.prototype.__union=function(r,e){return r.bb_pos=e+this.readInt32(e),r.bb=this,r};k.ByteBuffer.prototype.__string=function(r,e){r+=this.readInt32(r);var n=this.readInt32(r),t="",o=0;if(r+=k.SIZEOF_INT,e===k.Encoding.UTF8_BYTES)return this.bytes_.subarray(r,r+n);for(;o<n;){var i,s=this.readUint8(r+o++);if(s<192)i=s;else{var a=this.readUint8(r+o++);if(s<224)i=(s&31)<<6|a&63;else{var u=this.readUint8(r+o++);if(s<240)i=(s&15)<<12|(a&63)<<6|u&63;else{var l=this.readUint8(r+o++);i=(s&7)<<18|(a&63)<<12|(u&63)<<6|l&63}}}i<65536?t+=String.fromCharCode(i):(i-=65536,t+=String.fromCharCode((i>>10)+55296,(i&1024-1)+56320))}return t};k.ByteBuffer.prototype.__indirect=function(r){return r+this.readInt32(r)};k.ByteBuffer.prototype.__vector=function(r){return r+this.readInt32(r)+k.SIZEOF_INT};k.ByteBuffer.prototype.__vector_len=function(r){return this.readInt32(r+this.readInt32(r))};k.ByteBuffer.prototype.__has_identifier=function(r){if(r.length!=k.FILE_IDENTIFIER_LENGTH)throw new Error("FlatBuffers: file identifier must be length "+k.FILE_IDENTIFIER_LENGTH);for(var e=0;e<k.FILE_IDENTIFIER_LENGTH;e++)if(r.charCodeAt(e)!=this.readInt8(this.position_+k.SIZEOF_INT+e))return!1;return!0};k.ByteBuffer.prototype.createLong=function(r,e){return k.Long.create(r,e)}});var se,io=D(()=>{"use strict";si();(e=>{let r;(t=>{let n;(i=>{let o;(A=>(A[A.UNDEFINED=0]="UNDEFINED",A[A.FLOAT=1]="FLOAT",A[A.INT=2]="INT",A[A.STRING=3]="STRING",A[A.TENSOR=4]="TENSOR",A[A.GRAPH=5]="GRAPH",A[A.FLOATS=6]="FLOATS",A[A.INTS=7]="INTS",A[A.STRINGS=8]="STRINGS",A[A.TENSORS=9]="TENSORS",A[A.GRAPHS=10]="GRAPHS",A[A.SPARSE_TENSOR=11]="SPARSE_TENSOR",A[A.SPARSE_TENSORS=12]="SPARSE_TENSORS"))(o=i.AttributeType||={})})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{let o;(l=>(l[l.UNKNOWN=0]="UNKNOWN",l[l.VALUE=1]="VALUE",l[l.PARAM=2]="PARAM"))(o=i.DimensionValueType||={})})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{let o;(H=>(H[H.UNDEFINED=0]="UNDEFINED",H[H.FLOAT=1]="FLOAT",H[H.UINT8=2]="UINT8",H[H.INT8=3]="INT8",H[H.UINT16=4]="UINT16",H[H.INT16=5]="INT16",H[H.INT32=6]="INT32",H[H.INT64=7]="INT64",H[H.STRING=8]="STRING",H[H.BOOL=9]="BOOL",H[H.FLOAT16=10]="FLOAT16",H[H.DOUBLE=11]="DOUBLE",H[H.UINT32=12]="UINT32",H[H.UINT64=13]="UINT64",H[H.COMPLEX64=14]="COMPLEX64",H[H.COMPLEX128=15]="COMPLEX128",H[H.BFLOAT16=16]="BFLOAT16",H[H.FLOAT8E4M3FN=17]="FLOAT8E4M3FN",H[H.FLOAT8E4M3FNUZ=18]="FLOAT8E4M3FNUZ",H[H.FLOAT8E5M2=19]="FLOAT8E5M2",H[H.FLOAT8E5M2FNUZ=20]="FLOAT8E5M2FNUZ"))(o=i.TensorDataType||={})})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{let o;(u=>(u[u.Primitive=0]="Primitive",u[u.Fused=1]="Fused"))(o=i.NodeType||={})})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{let o;(d=>(d[d.NONE=0]="NONE",d[d.tensor_type=1]="tensor_type",d[d.sequence_type=2]="sequence_type",d[d.map_type=3]="map_type"))(o=i.TypeInfoValue||={})})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsShape(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsShape(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}dim(a,u){let l=this.bb.__offset(this.bb_pos,4);return l?(u||new e.experimental.fbs.Dimension).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}dimLength(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.__vector_len(this.bb_pos+a):0}static startShape(a){a.startObject(1)}static addDim(a,u){a.addFieldOffset(0,u,0)}static createDimVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startDimVector(a,u){a.startVector(4,u,4)}static endShape(a){return a.endObject()}static createShape(a,u){return o.startShape(a),o.addDim(a,u),o.endShape(a)}}i.Shape=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsDimension(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsDimension(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}value(a){let u=this.bb.__offset(this.bb_pos,4);return u?(a||new e.experimental.fbs.DimensionValue).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}denotation(a){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,a):null}static startDimension(a){a.startObject(2)}static addValue(a,u){a.addFieldOffset(0,u,0)}static addDenotation(a,u){a.addFieldOffset(1,u,0)}static endDimension(a){return a.endObject()}static createDimension(a,u,l){return o.startDimension(a),o.addValue(a,u),o.addDenotation(a,l),o.endDimension(a)}}i.Dimension=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsDimensionValue(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsDimensionValue(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}dimType(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.readInt8(this.bb_pos+a):0}dimValue(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.readInt64(this.bb_pos+a):this.bb.createLong(0,0)}dimParam(a){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,a):null}static startDimensionValue(a){a.startObject(3)}static addDimType(a,u){a.addFieldInt8(0,u,0)}static addDimValue(a,u){a.addFieldInt64(1,u,a.createLong(0,0))}static addDimParam(a,u){a.addFieldOffset(2,u,0)}static endDimensionValue(a){return a.endObject()}static createDimensionValue(a,u,l,d){return o.startDimensionValue(a),o.addDimType(a,u),o.addDimValue(a,l),o.addDimParam(a,d),o.endDimensionValue(a)}}i.DimensionValue=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsTensorTypeAndShape(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsTensorTypeAndShape(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}elemType(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.readInt32(this.bb_pos+a):0}shape(a){let u=this.bb.__offset(this.bb_pos,6);return u?(a||new e.experimental.fbs.Shape).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startTensorTypeAndShape(a){a.startObject(2)}static addElemType(a,u){a.addFieldInt32(0,u,0)}static addShape(a,u){a.addFieldOffset(1,u,0)}static endTensorTypeAndShape(a){return a.endObject()}static createTensorTypeAndShape(a,u,l){return o.startTensorTypeAndShape(a),o.addElemType(a,u),o.addShape(a,l),o.endTensorTypeAndShape(a)}}i.TensorTypeAndShape=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsMapType(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsMapType(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}keyType(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.readInt32(this.bb_pos+a):0}valueType(a){let u=this.bb.__offset(this.bb_pos,6);return u?(a||new e.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startMapType(a){a.startObject(2)}static addKeyType(a,u){a.addFieldInt32(0,u,0)}static addValueType(a,u){a.addFieldOffset(1,u,0)}static endMapType(a){return a.endObject()}static createMapType(a,u,l){return o.startMapType(a),o.addKeyType(a,u),o.addValueType(a,l),o.endMapType(a)}}i.MapType=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsSequenceType(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsSequenceType(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}elemType(a){let u=this.bb.__offset(this.bb_pos,4);return u?(a||new e.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startSequenceType(a){a.startObject(1)}static addElemType(a,u){a.addFieldOffset(0,u,0)}static endSequenceType(a){return a.endObject()}static createSequenceType(a,u){return o.startSequenceType(a),o.addElemType(a,u),o.endSequenceType(a)}}i.SequenceType=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}nodeIndex(){return this.bb.readUint32(this.bb_pos)}srcArgIndex(){return this.bb.readInt32(this.bb_pos+4)}dstArgIndex(){return this.bb.readInt32(this.bb_pos+8)}static createEdgeEnd(a,u,l,d){return a.prep(4,12),a.writeInt32(d),a.writeInt32(l),a.writeInt32(u),a.offset()}}i.EdgeEnd=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsNodeEdge(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsNodeEdge(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}nodeIndex(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.readUint32(this.bb_pos+a):0}inputEdges(a,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.EdgeEnd).__init(this.bb.__vector(this.bb_pos+l)+a*12,this.bb):null}inputEdgesLength(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.__vector_len(this.bb_pos+a):0}outputEdges(a,u){let l=this.bb.__offset(this.bb_pos,8);return l?(u||new e.experimental.fbs.EdgeEnd).__init(this.bb.__vector(this.bb_pos+l)+a*12,this.bb):null}outputEdgesLength(){let a=this.bb.__offset(this.bb_pos,8);return a?this.bb.__vector_len(this.bb_pos+a):0}static startNodeEdge(a){a.startObject(3)}static addNodeIndex(a,u){a.addFieldInt32(0,u,0)}static addInputEdges(a,u){a.addFieldOffset(1,u,0)}static startInputEdgesVector(a,u){a.startVector(12,u,4)}static addOutputEdges(a,u){a.addFieldOffset(2,u,0)}static startOutputEdgesVector(a,u){a.startVector(12,u,4)}static endNodeEdge(a){return a.endObject()}static createNodeEdge(a,u,l,d){return o.startNodeEdge(a),o.addNodeIndex(a,u),o.addInputEdges(a,l),o.addOutputEdges(a,d),o.endNodeEdge(a)}}i.NodeEdge=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsNode(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsNode(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}name(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}docString(a){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,a):null}domain(a){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,a):null}sinceVersion(){let a=this.bb.__offset(this.bb_pos,10);return a?this.bb.readInt32(this.bb_pos+a):0}index(){let a=this.bb.__offset(this.bb_pos,12);return a?this.bb.readUint32(this.bb_pos+a):0}opType(a){let u=this.bb.__offset(this.bb_pos,14);return u?this.bb.__string(this.bb_pos+u,a):null}type(){let a=this.bb.__offset(this.bb_pos,16);return a?this.bb.readInt32(this.bb_pos+a):0}executionProviderType(a){let u=this.bb.__offset(this.bb_pos,18);return u?this.bb.__string(this.bb_pos+u,a):null}inputs(a,u){let l=this.bb.__offset(this.bb_pos,20);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}inputsLength(){let a=this.bb.__offset(this.bb_pos,20);return a?this.bb.__vector_len(this.bb_pos+a):0}outputs(a,u){let l=this.bb.__offset(this.bb_pos,22);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}outputsLength(){let a=this.bb.__offset(this.bb_pos,22);return a?this.bb.__vector_len(this.bb_pos+a):0}attributes(a,u){let l=this.bb.__offset(this.bb_pos,24);return l?(u||new e.experimental.fbs.Attribute).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}attributesLength(){let a=this.bb.__offset(this.bb_pos,24);return a?this.bb.__vector_len(this.bb_pos+a):0}inputArgCounts(a){let u=this.bb.__offset(this.bb_pos,26);return u?this.bb.readInt32(this.bb.__vector(this.bb_pos+u)+a*4):0}inputArgCountsLength(){let a=this.bb.__offset(this.bb_pos,26);return a?this.bb.__vector_len(this.bb_pos+a):0}inputArgCountsArray(){let a=this.bb.__offset(this.bb_pos,26);return a?new Int32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+a),this.bb.__vector_len(this.bb_pos+a)):null}implicitInputs(a,u){let l=this.bb.__offset(this.bb_pos,28);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}implicitInputsLength(){let a=this.bb.__offset(this.bb_pos,28);return a?this.bb.__vector_len(this.bb_pos+a):0}static startNode(a){a.startObject(13)}static addName(a,u){a.addFieldOffset(0,u,0)}static addDocString(a,u){a.addFieldOffset(1,u,0)}static addDomain(a,u){a.addFieldOffset(2,u,0)}static addSinceVersion(a,u){a.addFieldInt32(3,u,0)}static addIndex(a,u){a.addFieldInt32(4,u,0)}static addOpType(a,u){a.addFieldOffset(5,u,0)}static addType(a,u){a.addFieldInt32(6,u,0)}static addExecutionProviderType(a,u){a.addFieldOffset(7,u,0)}static addInputs(a,u){a.addFieldOffset(8,u,0)}static createInputsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startInputsVector(a,u){a.startVector(4,u,4)}static addOutputs(a,u){a.addFieldOffset(9,u,0)}static createOutputsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startOutputsVector(a,u){a.startVector(4,u,4)}static addAttributes(a,u){a.addFieldOffset(10,u,0)}static createAttributesVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startAttributesVector(a,u){a.startVector(4,u,4)}static addInputArgCounts(a,u){a.addFieldOffset(11,u,0)}static createInputArgCountsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addInt32(u[l]);return a.endVector()}static startInputArgCountsVector(a,u){a.startVector(4,u,4)}static addImplicitInputs(a,u){a.addFieldOffset(12,u,0)}static createImplicitInputsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startImplicitInputsVector(a,u){a.startVector(4,u,4)}static endNode(a){return a.endObject()}static createNode(a,u,l,d,f,p,m,b,y,$,x,T,A,E){return o.startNode(a),o.addName(a,u),o.addDocString(a,l),o.addDomain(a,d),o.addSinceVersion(a,f),o.addIndex(a,p),o.addOpType(a,m),o.addType(a,b),o.addExecutionProviderType(a,y),o.addInputs(a,$),o.addOutputs(a,x),o.addAttributes(a,T),o.addInputArgCounts(a,A),o.addImplicitInputs(a,E),o.endNode(a)}}i.Node=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsValueInfo(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsValueInfo(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}name(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}docString(a){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,a):null}type(a){let u=this.bb.__offset(this.bb_pos,8);return u?(a||new e.experimental.fbs.TypeInfo).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startValueInfo(a){a.startObject(3)}static addName(a,u){a.addFieldOffset(0,u,0)}static addDocString(a,u){a.addFieldOffset(1,u,0)}static addType(a,u){a.addFieldOffset(2,u,0)}static endValueInfo(a){return a.endObject()}static createValueInfo(a,u,l,d){return o.startValueInfo(a),o.addName(a,u),o.addDocString(a,l),o.addType(a,d),o.endValueInfo(a)}}i.ValueInfo=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsTypeInfo(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsTypeInfo(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}denotation(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}valueType(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.readUint8(this.bb_pos+a):0}value(a){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__union(a,this.bb_pos+u):null}static startTypeInfo(a){a.startObject(3)}static addDenotation(a,u){a.addFieldOffset(0,u,0)}static addValueType(a,u){a.addFieldInt8(1,u,0)}static addValue(a,u){a.addFieldOffset(2,u,0)}static endTypeInfo(a){return a.endObject()}static createTypeInfo(a,u,l,d){return o.startTypeInfo(a),o.addDenotation(a,u),o.addValueType(a,l),o.addValue(a,d),o.endTypeInfo(a)}}i.TypeInfo=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsOperatorSetId(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsOperatorSetId(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}domain(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}version(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.readInt64(this.bb_pos+a):this.bb.createLong(0,0)}static startOperatorSetId(a){a.startObject(2)}static addDomain(a,u){a.addFieldOffset(0,u,0)}static addVersion(a,u){a.addFieldInt64(1,u,a.createLong(0,0))}static endOperatorSetId(a){return a.endObject()}static createOperatorSetId(a,u,l){return o.startOperatorSetId(a),o.addDomain(a,u),o.addVersion(a,l),o.endOperatorSetId(a)}}i.OperatorSetId=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsTensor(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsTensor(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}name(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}docString(a){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,a):null}dims(a){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+a*8):this.bb.createLong(0,0)}dimsLength(){let a=this.bb.__offset(this.bb_pos,8);return a?this.bb.__vector_len(this.bb_pos+a):0}dataType(){let a=this.bb.__offset(this.bb_pos,10);return a?this.bb.readInt32(this.bb_pos+a):0}rawData(a){let u=this.bb.__offset(this.bb_pos,12);return u?this.bb.readUint8(this.bb.__vector(this.bb_pos+u)+a):0}rawDataLength(){let a=this.bb.__offset(this.bb_pos,12);return a?this.bb.__vector_len(this.bb_pos+a):0}rawDataArray(){let a=this.bb.__offset(this.bb_pos,12);return a?new Uint8Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+a),this.bb.__vector_len(this.bb_pos+a)):null}stringData(a,u){let l=this.bb.__offset(this.bb_pos,14);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}stringDataLength(){let a=this.bb.__offset(this.bb_pos,14);return a?this.bb.__vector_len(this.bb_pos+a):0}static startTensor(a){a.startObject(6)}static addName(a,u){a.addFieldOffset(0,u,0)}static addDocString(a,u){a.addFieldOffset(1,u,0)}static addDims(a,u){a.addFieldOffset(2,u,0)}static createDimsVector(a,u){a.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)a.addInt64(u[l]);return a.endVector()}static startDimsVector(a,u){a.startVector(8,u,8)}static addDataType(a,u){a.addFieldInt32(3,u,0)}static addRawData(a,u){a.addFieldOffset(4,u,0)}static createRawDataVector(a,u){a.startVector(1,u.length,1);for(let l=u.length-1;l>=0;l--)a.addInt8(u[l]);return a.endVector()}static startRawDataVector(a,u){a.startVector(1,u,1)}static addStringData(a,u){a.addFieldOffset(5,u,0)}static createStringDataVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startStringDataVector(a,u){a.startVector(4,u,4)}static endTensor(a){return a.endObject()}static createTensor(a,u,l,d,f,p,m){return o.startTensor(a),o.addName(a,u),o.addDocString(a,l),o.addDims(a,d),o.addDataType(a,f),o.addRawData(a,p),o.addStringData(a,m),o.endTensor(a)}}i.Tensor=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsSparseTensor(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsSparseTensor(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}values(a){let u=this.bb.__offset(this.bb_pos,4);return u?(a||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}indices(a){let u=this.bb.__offset(this.bb_pos,6);return u?(a||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}dims(a){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+a*8):this.bb.createLong(0,0)}dimsLength(){let a=this.bb.__offset(this.bb_pos,8);return a?this.bb.__vector_len(this.bb_pos+a):0}static startSparseTensor(a){a.startObject(3)}static addValues(a,u){a.addFieldOffset(0,u,0)}static addIndices(a,u){a.addFieldOffset(1,u,0)}static addDims(a,u){a.addFieldOffset(2,u,0)}static createDimsVector(a,u){a.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)a.addInt64(u[l]);return a.endVector()}static startDimsVector(a,u){a.startVector(8,u,8)}static endSparseTensor(a){return a.endObject()}static createSparseTensor(a,u,l,d){return o.startSparseTensor(a),o.addValues(a,u),o.addIndices(a,l),o.addDims(a,d),o.endSparseTensor(a)}}i.SparseTensor=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsAttribute(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsAttribute(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}name(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}docString(a){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.__string(this.bb_pos+u,a):null}type(){let a=this.bb.__offset(this.bb_pos,8);return a?this.bb.readInt32(this.bb_pos+a):0}f(){let a=this.bb.__offset(this.bb_pos,10);return a?this.bb.readFloat32(this.bb_pos+a):0}i(){let a=this.bb.__offset(this.bb_pos,12);return a?this.bb.readInt64(this.bb_pos+a):this.bb.createLong(0,0)}s(a){let u=this.bb.__offset(this.bb_pos,14);return u?this.bb.__string(this.bb_pos+u,a):null}t(a){let u=this.bb.__offset(this.bb_pos,16);return u?(a||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}g(a){let u=this.bb.__offset(this.bb_pos,18);return u?(a||new e.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}floats(a){let u=this.bb.__offset(this.bb_pos,20);return u?this.bb.readFloat32(this.bb.__vector(this.bb_pos+u)+a*4):0}floatsLength(){let a=this.bb.__offset(this.bb_pos,20);return a?this.bb.__vector_len(this.bb_pos+a):0}floatsArray(){let a=this.bb.__offset(this.bb_pos,20);return a?new Float32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+a),this.bb.__vector_len(this.bb_pos+a)):null}ints(a){let u=this.bb.__offset(this.bb_pos,22);return u?this.bb.readInt64(this.bb.__vector(this.bb_pos+u)+a*8):this.bb.createLong(0,0)}intsLength(){let a=this.bb.__offset(this.bb_pos,22);return a?this.bb.__vector_len(this.bb_pos+a):0}strings(a,u){let l=this.bb.__offset(this.bb_pos,24);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}stringsLength(){let a=this.bb.__offset(this.bb_pos,24);return a?this.bb.__vector_len(this.bb_pos+a):0}tensors(a,u){let l=this.bb.__offset(this.bb_pos,26);return l?(u||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}tensorsLength(){let a=this.bb.__offset(this.bb_pos,26);return a?this.bb.__vector_len(this.bb_pos+a):0}graphs(a,u){let l=this.bb.__offset(this.bb_pos,28);return l?(u||new e.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}graphsLength(){let a=this.bb.__offset(this.bb_pos,28);return a?this.bb.__vector_len(this.bb_pos+a):0}static startAttribute(a){a.startObject(13)}static addName(a,u){a.addFieldOffset(0,u,0)}static addDocString(a,u){a.addFieldOffset(1,u,0)}static addType(a,u){a.addFieldInt32(2,u,0)}static addF(a,u){a.addFieldFloat32(3,u,0)}static addI(a,u){a.addFieldInt64(4,u,a.createLong(0,0))}static addS(a,u){a.addFieldOffset(5,u,0)}static addT(a,u){a.addFieldOffset(6,u,0)}static addG(a,u){a.addFieldOffset(7,u,0)}static addFloats(a,u){a.addFieldOffset(8,u,0)}static createFloatsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addFloat32(u[l]);return a.endVector()}static startFloatsVector(a,u){a.startVector(4,u,4)}static addInts(a,u){a.addFieldOffset(9,u,0)}static createIntsVector(a,u){a.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)a.addInt64(u[l]);return a.endVector()}static startIntsVector(a,u){a.startVector(8,u,8)}static addStrings(a,u){a.addFieldOffset(10,u,0)}static createStringsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startStringsVector(a,u){a.startVector(4,u,4)}static addTensors(a,u){a.addFieldOffset(11,u,0)}static createTensorsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startTensorsVector(a,u){a.startVector(4,u,4)}static addGraphs(a,u){a.addFieldOffset(12,u,0)}static createGraphsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startGraphsVector(a,u){a.startVector(4,u,4)}static endAttribute(a){return a.endObject()}static createAttribute(a,u,l,d,f,p,m,b,y,$,x,T,A,E){return o.startAttribute(a),o.addName(a,u),o.addDocString(a,l),o.addType(a,d),o.addF(a,f),o.addI(a,p),o.addS(a,m),o.addT(a,b),o.addG(a,y),o.addFloats(a,$),o.addInts(a,x),o.addStrings(a,T),o.addTensors(a,A),o.addGraphs(a,E),o.endAttribute(a)}}i.Attribute=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsGraph(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsGraph(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}initializers(a,u){let l=this.bb.__offset(this.bb_pos,4);return l?(u||new e.experimental.fbs.Tensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}initializersLength(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.__vector_len(this.bb_pos+a):0}nodeArgs(a,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.ValueInfo).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}nodeArgsLength(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.__vector_len(this.bb_pos+a):0}nodes(a,u){let l=this.bb.__offset(this.bb_pos,8);return l?(u||new e.experimental.fbs.Node).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}nodesLength(){let a=this.bb.__offset(this.bb_pos,8);return a?this.bb.__vector_len(this.bb_pos+a):0}maxNodeIndex(){let a=this.bb.__offset(this.bb_pos,10);return a?this.bb.readUint32(this.bb_pos+a):0}nodeEdges(a,u){let l=this.bb.__offset(this.bb_pos,12);return l?(u||new e.experimental.fbs.NodeEdge).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}nodeEdgesLength(){let a=this.bb.__offset(this.bb_pos,12);return a?this.bb.__vector_len(this.bb_pos+a):0}inputs(a,u){let l=this.bb.__offset(this.bb_pos,14);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}inputsLength(){let a=this.bb.__offset(this.bb_pos,14);return a?this.bb.__vector_len(this.bb_pos+a):0}outputs(a,u){let l=this.bb.__offset(this.bb_pos,16);return l?this.bb.__string(this.bb.__vector(this.bb_pos+l)+a*4,u):null}outputsLength(){let a=this.bb.__offset(this.bb_pos,16);return a?this.bb.__vector_len(this.bb_pos+a):0}sparseInitializers(a,u){let l=this.bb.__offset(this.bb_pos,18);return l?(u||new e.experimental.fbs.SparseTensor).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}sparseInitializersLength(){let a=this.bb.__offset(this.bb_pos,18);return a?this.bb.__vector_len(this.bb_pos+a):0}static startGraph(a){a.startObject(8)}static addInitializers(a,u){a.addFieldOffset(0,u,0)}static createInitializersVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startInitializersVector(a,u){a.startVector(4,u,4)}static addNodeArgs(a,u){a.addFieldOffset(1,u,0)}static createNodeArgsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startNodeArgsVector(a,u){a.startVector(4,u,4)}static addNodes(a,u){a.addFieldOffset(2,u,0)}static createNodesVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startNodesVector(a,u){a.startVector(4,u,4)}static addMaxNodeIndex(a,u){a.addFieldInt32(3,u,0)}static addNodeEdges(a,u){a.addFieldOffset(4,u,0)}static createNodeEdgesVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startNodeEdgesVector(a,u){a.startVector(4,u,4)}static addInputs(a,u){a.addFieldOffset(5,u,0)}static createInputsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startInputsVector(a,u){a.startVector(4,u,4)}static addOutputs(a,u){a.addFieldOffset(6,u,0)}static createOutputsVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startOutputsVector(a,u){a.startVector(4,u,4)}static addSparseInitializers(a,u){a.addFieldOffset(7,u,0)}static createSparseInitializersVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startSparseInitializersVector(a,u){a.startVector(4,u,4)}static endGraph(a){return a.endObject()}static createGraph(a,u,l,d,f,p,m,b,y){return o.startGraph(a),o.addInitializers(a,u),o.addNodeArgs(a,l),o.addNodes(a,d),o.addMaxNodeIndex(a,f),o.addNodeEdges(a,p),o.addInputs(a,m),o.addOutputs(a,b),o.addSparseInitializers(a,y),o.endGraph(a)}}i.Graph=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsModel(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsModel(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}irVersion(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.readInt64(this.bb_pos+a):this.bb.createLong(0,0)}opsetImport(a,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.OperatorSetId).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}opsetImportLength(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.__vector_len(this.bb_pos+a):0}producerName(a){let u=this.bb.__offset(this.bb_pos,8);return u?this.bb.__string(this.bb_pos+u,a):null}producerVersion(a){let u=this.bb.__offset(this.bb_pos,10);return u?this.bb.__string(this.bb_pos+u,a):null}domain(a){let u=this.bb.__offset(this.bb_pos,12);return u?this.bb.__string(this.bb_pos+u,a):null}modelVersion(){let a=this.bb.__offset(this.bb_pos,14);return a?this.bb.readInt64(this.bb_pos+a):this.bb.createLong(0,0)}docString(a){let u=this.bb.__offset(this.bb_pos,16);return u?this.bb.__string(this.bb_pos+u,a):null}graph(a){let u=this.bb.__offset(this.bb_pos,18);return u?(a||new e.experimental.fbs.Graph).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}graphDocString(a){let u=this.bb.__offset(this.bb_pos,20);return u?this.bb.__string(this.bb_pos+u,a):null}static startModel(a){a.startObject(9)}static addIrVersion(a,u){a.addFieldInt64(0,u,a.createLong(0,0))}static addOpsetImport(a,u){a.addFieldOffset(1,u,0)}static createOpsetImportVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startOpsetImportVector(a,u){a.startVector(4,u,4)}static addProducerName(a,u){a.addFieldOffset(2,u,0)}static addProducerVersion(a,u){a.addFieldOffset(3,u,0)}static addDomain(a,u){a.addFieldOffset(4,u,0)}static addModelVersion(a,u){a.addFieldInt64(5,u,a.createLong(0,0))}static addDocString(a,u){a.addFieldOffset(6,u,0)}static addGraph(a,u){a.addFieldOffset(7,u,0)}static addGraphDocString(a,u){a.addFieldOffset(8,u,0)}static endModel(a){return a.endObject()}static createModel(a,u,l,d,f,p,m,b,y,$){return o.startModel(a),o.addIrVersion(a,u),o.addOpsetImport(a,l),o.addProducerName(a,d),o.addProducerVersion(a,f),o.addDomain(a,p),o.addModelVersion(a,m),o.addDocString(a,b),o.addGraph(a,y),o.addGraphDocString(a,$),o.endModel(a)}}i.Model=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsKernelCreateInfos(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsKernelCreateInfos(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}nodeIndices(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.readUint32(this.bb.__vector(this.bb_pos+u)+a*4):0}nodeIndicesLength(){let a=this.bb.__offset(this.bb_pos,4);return a?this.bb.__vector_len(this.bb_pos+a):0}nodeIndicesArray(){let a=this.bb.__offset(this.bb_pos,4);return a?new Uint32Array(this.bb.bytes().buffer,this.bb.bytes().byteOffset+this.bb.__vector(this.bb_pos+a),this.bb.__vector_len(this.bb_pos+a)):null}kernelDefHashes(a){let u=this.bb.__offset(this.bb_pos,6);return u?this.bb.readUint64(this.bb.__vector(this.bb_pos+u)+a*8):this.bb.createLong(0,0)}kernelDefHashesLength(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.__vector_len(this.bb_pos+a):0}static startKernelCreateInfos(a){a.startObject(2)}static addNodeIndices(a,u){a.addFieldOffset(0,u,0)}static createNodeIndicesVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addInt32(u[l]);return a.endVector()}static startNodeIndicesVector(a,u){a.startVector(4,u,4)}static addKernelDefHashes(a,u){a.addFieldOffset(1,u,0)}static createKernelDefHashesVector(a,u){a.startVector(8,u.length,8);for(let l=u.length-1;l>=0;l--)a.addInt64(u[l]);return a.endVector()}static startKernelDefHashesVector(a,u){a.startVector(8,u,8)}static endKernelCreateInfos(a){return a.endObject()}static createKernelCreateInfos(a,u,l){return o.startKernelCreateInfos(a),o.addNodeIndices(a,u),o.addKernelDefHashes(a,l),o.endKernelCreateInfos(a)}}i.KernelCreateInfos=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsSubGraphSessionState(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsSubGraphSessionState(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}graphId(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}sessionState(a){let u=this.bb.__offset(this.bb_pos,6);return u?(a||new e.experimental.fbs.SessionState).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startSubGraphSessionState(a){a.startObject(2)}static addGraphId(a,u){a.addFieldOffset(0,u,0)}static addSessionState(a,u){a.addFieldOffset(1,u,0)}static endSubGraphSessionState(a){let u=a.endObject();return a.requiredField(u,4),u}static createSubGraphSessionState(a,u,l){return o.startSubGraphSessionState(a),o.addGraphId(a,u),o.addSessionState(a,l),o.endSubGraphSessionState(a)}}i.SubGraphSessionState=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsSessionState(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsSessionState(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}kernels(a){let u=this.bb.__offset(this.bb_pos,4);return u?(a||new e.experimental.fbs.KernelCreateInfos).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}subGraphSessionStates(a,u){let l=this.bb.__offset(this.bb_pos,6);return l?(u||new e.experimental.fbs.SubGraphSessionState).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos+l)+a*4),this.bb):null}subGraphSessionStatesLength(){let a=this.bb.__offset(this.bb_pos,6);return a?this.bb.__vector_len(this.bb_pos+a):0}static startSessionState(a){a.startObject(2)}static addKernels(a,u){a.addFieldOffset(0,u,0)}static addSubGraphSessionStates(a,u){a.addFieldOffset(1,u,0)}static createSubGraphSessionStatesVector(a,u){a.startVector(4,u.length,4);for(let l=u.length-1;l>=0;l--)a.addOffset(u[l]);return a.endVector()}static startSubGraphSessionStatesVector(a,u){a.startVector(4,u,4)}static endSessionState(a){return a.endObject()}static createSessionState(a,u,l){return o.startSessionState(a),o.addKernels(a,u),o.addSubGraphSessionStates(a,l),o.endSessionState(a)}}i.SessionState=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={});(e=>{let r;(t=>{let n;(i=>{class o{constructor(){this.bb=null;this.bb_pos=0}__init(a,u){return this.bb_pos=a,this.bb=u,this}static getRootAsInferenceSession(a,u){return(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static getSizePrefixedRootAsInferenceSession(a,u){return a.setPosition(a.position()+k.SIZE_PREFIX_LENGTH),(u||new o).__init(a.readInt32(a.position())+a.position(),a)}static bufferHasIdentifier(a){return a.__has_identifier("ORTM")}ortVersion(a){let u=this.bb.__offset(this.bb_pos,4);return u?this.bb.__string(this.bb_pos+u,a):null}model(a){let u=this.bb.__offset(this.bb_pos,6);return u?(a||new e.experimental.fbs.Model).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}sessionState(a){let u=this.bb.__offset(this.bb_pos,8);return u?(a||new e.experimental.fbs.SessionState).__init(this.bb.__indirect(this.bb_pos+u),this.bb):null}static startInferenceSession(a){a.startObject(3)}static addOrtVersion(a,u){a.addFieldOffset(0,u,0)}static addModel(a,u){a.addFieldOffset(1,u,0)}static addSessionState(a,u){a.addFieldOffset(2,u,0)}static endInferenceSession(a){return a.endObject()}static finishInferenceSessionBuffer(a,u){a.finish(u,"ORTM")}static finishSizePrefixedInferenceSessionBuffer(a,u){a.finish(u,"ORTM",!0)}static createInferenceSession(a,u,l,d){return o.startInferenceSession(a),o.addOrtVersion(a,u),o.addModel(a,l),o.addSessionState(a,d),o.endInferenceSession(a)}}i.InferenceSession=o})(n=t.fbs||={})})(r=e.experimental||={})})(se||={})});var Bl=Je((m_,Dl)=>{"use strict";Dl.exports=Qy;function Qy(r,e){for(var n=new Array(arguments.length-1),t=0,o=2,i=!0;o<arguments.length;)n[t++]=arguments[o++];return new Promise(function(a,u){n[t]=function(d){if(i)if(i=!1,d)u(d);else{for(var f=new Array(arguments.length-1),p=0;p<f.length;)f[p++]=arguments[p];a.apply(null,f)}};try{r.apply(e||null,n)}catch(l){i&&(i=!1,u(l))}})}});var Ll=Je(Nl=>{"use strict";var ui=Nl;ui.length=function(e){var n=e.length;if(!n)return 0;for(var t=0;--n%4>1&&e.charAt(n)==="=";)++t;return Math.ceil(e.length*3)/4-t};var Sn=new Array(64),zl=new Array(123);for(ir=0;ir<64;)zl[Sn[ir]=ir<26?ir+65:ir<52?ir+71:ir<62?ir-4:ir-59|43]=ir++;var ir;ui.encode=function(e,n,t){for(var o=null,i=[],s=0,a=0,u;n<t;){var l=e[n++];switch(a){case 0:i[s++]=Sn[l>>2],u=(l&3)<<4,a=1;break;case 1:i[s++]=Sn[u|l>>4],u=(l&15)<<2,a=2;break;case 2:i[s++]=Sn[u|l>>6],i[s++]=Sn[l&63],a=0;break}s>8191&&((o||(o=[])).push(String.fromCharCode.apply(String,i)),s=0)}return a&&(i[s++]=Sn[u],i[s++]=61,a===1&&(i[s++]=61)),o?(s&&o.push(String.fromCharCode.apply(String,i.slice(0,s))),o.join("")):String.fromCharCode.apply(String,i.slice(0,s))};var Rl="invalid encoding";ui.decode=function(e,n,t){for(var o=t,i=0,s,a=0;a<e.length;){var u=e.charCodeAt(a++);if(u===61&&i>1)break;if((u=zl[u])===void 0)throw Error(Rl);switch(i){case 0:s=u,i=1;break;case 1:n[t++]=s<<2|(u&48)>>4,s=u,i=2;break;case 2:n[t++]=(s&15)<<4|(u&60)>>2,s=u,i=3;break;case 3:n[t++]=(s&3)<<6|u,i=0;break}}if(i===1)throw Error(Rl);return t-o};ui.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}});var Vl=Je((b_,Ml)=>{"use strict";Ml.exports=li;function li(){this._listeners={}}li.prototype.on=function(e,n,t){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:n,ctx:t||this}),this};li.prototype.off=function(e,n){if(e===void 0)this._listeners={};else if(n===void 0)this._listeners[e]=[];else for(var t=this._listeners[e],o=0;o<t.length;)t[o].fn===n?t.splice(o,1):++o;return this};li.prototype.emit=function(e){var n=this._listeners[e];if(n){for(var t=[],o=1;o<arguments.length;)t.push(arguments[o++]);for(o=0;o<n.length;)n[o].fn.apply(n[o++].ctx,t)}return this}});var jl=Je((y_,ql)=>{"use strict";ql.exports=Fl(Fl);function Fl(r){return typeof Float32Array<"u"?function(){var e=new Float32Array([-0]),n=new Uint8Array(e.buffer),t=n[3]===128;function o(u,l,d){e[0]=u,l[d]=n[0],l[d+1]=n[1],l[d+2]=n[2],l[d+3]=n[3]}function i(u,l,d){e[0]=u,l[d]=n[3],l[d+1]=n[2],l[d+2]=n[1],l[d+3]=n[0]}r.writeFloatLE=t?o:i,r.writeFloatBE=t?i:o;function s(u,l){return n[0]=u[l],n[1]=u[l+1],n[2]=u[l+2],n[3]=u[l+3],e[0]}function a(u,l){return n[3]=u[l],n[2]=u[l+1],n[1]=u[l+2],n[0]=u[l+3],e[0]}r.readFloatLE=t?s:a,r.readFloatBE=t?a:s}():function(){function e(t,o,i,s){var a=o<0?1:0;if(a&&(o=-o),o===0)t(1/o>0?0:2147483648,i,s);else if(isNaN(o))t(2143289344,i,s);else if(o>34028234663852886e22)t((a<<31|2139095040)>>>0,i,s);else if(o<11754943508222875e-54)t((a<<31|Math.round(o/1401298464324817e-60))>>>0,i,s);else{var u=Math.floor(Math.log(o)/Math.LN2),l=Math.round(o*Math.pow(2,-u)*8388608)&8388607;t((a<<31|u+127<<23|l)>>>0,i,s)}}r.writeFloatLE=e.bind(null,Ul),r.writeFloatBE=e.bind(null,Gl);function n(t,o,i){var s=t(o,i),a=(s>>31)*2+1,u=s>>>23&255,l=s&8388607;return u===255?l?NaN:a*(1/0):u===0?a*1401298464324817e-60*l:a*Math.pow(2,u-150)*(l+8388608)}r.readFloatLE=n.bind(null,Wl),r.readFloatBE=n.bind(null,Hl)}(),typeof Float64Array<"u"?function(){var e=new Float64Array([-0]),n=new Uint8Array(e.buffer),t=n[7]===128;function o(u,l,d){e[0]=u,l[d]=n[0],l[d+1]=n[1],l[d+2]=n[2],l[d+3]=n[3],l[d+4]=n[4],l[d+5]=n[5],l[d+6]=n[6],l[d+7]=n[7]}function i(u,l,d){e[0]=u,l[d]=n[7],l[d+1]=n[6],l[d+2]=n[5],l[d+3]=n[4],l[d+4]=n[3],l[d+5]=n[2],l[d+6]=n[1],l[d+7]=n[0]}r.writeDoubleLE=t?o:i,r.writeDoubleBE=t?i:o;function s(u,l){return n[0]=u[l],n[1]=u[l+1],n[2]=u[l+2],n[3]=u[l+3],n[4]=u[l+4],n[5]=u[l+5],n[6]=u[l+6],n[7]=u[l+7],e[0]}function a(u,l){return n[7]=u[l],n[6]=u[l+1],n[5]=u[l+2],n[4]=u[l+3],n[3]=u[l+4],n[2]=u[l+5],n[1]=u[l+6],n[0]=u[l+7],e[0]}r.readDoubleLE=t?s:a,r.readDoubleBE=t?a:s}():function(){function e(t,o,i,s,a,u){var l=s<0?1:0;if(l&&(s=-s),s===0)t(0,a,u+o),t(1/s>0?0:2147483648,a,u+i);else if(isNaN(s))t(0,a,u+o),t(2146959360,a,u+i);else if(s>17976931348623157e292)t(0,a,u+o),t((l<<31|2146435072)>>>0,a,u+i);else{var d;if(s<22250738585072014e-324)d=s/5e-324,t(d>>>0,a,u+o),t((l<<31|d/4294967296)>>>0,a,u+i);else{var f=Math.floor(Math.log(s)/Math.LN2);f===1024&&(f=1023),d=s*Math.pow(2,-f),t(d*4503599627370496>>>0,a,u+o),t((l<<31|f+1023<<20|d*1048576&1048575)>>>0,a,u+i)}}}r.writeDoubleLE=e.bind(null,Ul,0,4),r.writeDoubleBE=e.bind(null,Gl,4,0);function n(t,o,i,s,a){var u=t(s,a+o),l=t(s,a+i),d=(l>>31)*2+1,f=l>>>20&2047,p=4294967296*(l&1048575)+u;return f===2047?p?NaN:d*(1/0):f===0?d*5e-324*p:d*Math.pow(2,f-1075)*(p+4503599627370496)}r.readDoubleLE=n.bind(null,Wl,0,4),r.readDoubleBE=n.bind(null,Hl,4,0)}(),r}function Ul(r,e,n){e[n]=r&255,e[n+1]=r>>>8&255,e[n+2]=r>>>16&255,e[n+3]=r>>>24}function Gl(r,e,n){e[n]=r>>>24,e[n+1]=r>>>16&255,e[n+2]=r>>>8&255,e[n+3]=r&255}function Wl(r,e){return(r[e]|r[e+1]<<8|r[e+2]<<16|r[e+3]<<24)>>>0}function Hl(r,e){return(r[e]<<24|r[e+1]<<16|r[e+2]<<8|r[e+3])>>>0}});var Kl=Je((exports,module)=>{"use strict";module.exports=inquire;function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(r){}return null}});var Xl=Je(Yl=>{"use strict";var Na=Yl;Na.length=function(e){for(var n=0,t=0,o=0;o<e.length;++o)t=e.charCodeAt(o),t<128?n+=1:t<2048?n+=2:(t&64512)===55296&&(e.charCodeAt(o+1)&64512)===56320?(++o,n+=4):n+=3;return n};Na.read=function(e,n,t){var o=t-n;if(o<1)return"";for(var i=null,s=[],a=0,u;n<t;)u=e[n++],u<128?s[a++]=u:u>191&&u<224?s[a++]=(u&31)<<6|e[n++]&63:u>239&&u<365?(u=((u&7)<<18|(e[n++]&63)<<12|(e[n++]&63)<<6|e[n++]&63)-65536,s[a++]=55296+(u>>10),s[a++]=56320+(u&1023)):s[a++]=(u&15)<<12|(e[n++]&63)<<6|e[n++]&63,a>8191&&((i||(i=[])).push(String.fromCharCode.apply(String,s)),a=0);return i?(a&&i.push(String.fromCharCode.apply(String,s.slice(0,a))),i.join("")):String.fromCharCode.apply(String,s.slice(0,a))};Na.write=function(e,n,t){for(var o=t,i,s,a=0;a<e.length;++a)i=e.charCodeAt(a),i<128?n[t++]=i:i<2048?(n[t++]=i>>6|192,n[t++]=i&63|128):(i&64512)===55296&&((s=e.charCodeAt(a+1))&64512)===56320?(i=65536+((i&1023)<<10)+(s&1023),++a,n[t++]=i>>18|240,n[t++]=i>>12&63|128,n[t++]=i>>6&63|128,n[t++]=i&63|128):(n[t++]=i>>12|224,n[t++]=i>>6&63|128,n[t++]=i&63|128);return t-o}});var Jl=Je((w_,Zl)=>{"use strict";Zl.exports=e0;function e0(r,e,n){var t=n||8192,o=t>>>1,i=null,s=t;return function(u){if(u<1||u>o)return r(u);s+u>t&&(i=r(t),s=0);var l=e.call(i,s,s+=u);return s&7&&(s=(s|7)+1),l}}});var ed=Je((x_,Ql)=>{"use strict";Ql.exports=$t;var ao=Ur();function $t(r,e){this.lo=r>>>0,this.hi=e>>>0}var tn=$t.zero=new $t(0,0);tn.toNumber=function(){return 0};tn.zzEncode=tn.zzDecode=function(){return this};tn.length=function(){return 1};var t0=$t.zeroHash="\0\0\0\0\0\0\0\0";$t.fromNumber=function(e){if(e===0)return tn;var n=e<0;n&&(e=-e);var t=e>>>0,o=(e-t)/4294967296>>>0;return n&&(o=~o>>>0,t=~t>>>0,++t>4294967295&&(t=0,++o>4294967295&&(o=0))),new $t(t,o)};$t.from=function(e){if(typeof e=="number")return $t.fromNumber(e);if(ao.isString(e))if(ao.Long)e=ao.Long.fromString(e);else return $t.fromNumber(parseInt(e,10));return e.low||e.high?new $t(e.low>>>0,e.high>>>0):tn};$t.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var n=~this.lo+1>>>0,t=~this.hi>>>0;return n||(t=t+1>>>0),-(n+t*4294967296)}return this.lo+this.hi*4294967296};$t.prototype.toLong=function(e){return ao.Long?new ao.Long(this.lo|0,this.hi|0,!!e):{low:this.lo|0,high:this.hi|0,unsigned:!!e}};var Fr=String.prototype.charCodeAt;$t.fromHash=function(e){return e===t0?tn:new $t((Fr.call(e,0)|Fr.call(e,1)<<8|Fr.call(e,2)<<16|Fr.call(e,3)<<24)>>>0,(Fr.call(e,4)|Fr.call(e,5)<<8|Fr.call(e,6)<<16|Fr.call(e,7)<<24)>>>0)};$t.prototype.toHash=function(){return String.fromCharCode(this.lo&255,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,this.hi&255,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)};$t.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this};$t.prototype.zzDecode=function(){var e=-(this.lo&1);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this};$t.prototype.length=function(){var e=this.lo,n=(this.lo>>>28|this.hi<<4)>>>0,t=this.hi>>>24;return t===0?n===0?e<16384?e<128?1:2:e<2097152?3:4:n<16384?n<128?5:6:n<2097152?7:8:t<128?9:10}});var Ur=Je(La=>{"use strict";var le=La;le.asPromise=Bl();le.base64=Ll();le.EventEmitter=Vl();le.float=jl();le.inquire=Kl();le.utf8=Xl();le.pool=Jl();le.LongBits=ed();le.isNode=!!(typeof global<"u"&&global&&global.process&&global.process.versions&&global.process.versions.node);le.global=le.isNode&&global||typeof window<"u"&&window||typeof self<"u"&&self||La;le.emptyArray=Object.freeze?Object.freeze([]):[];le.emptyObject=Object.freeze?Object.freeze({}):{};le.isInteger=Number.isInteger||function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e};le.isString=function(e){return typeof e=="string"||e instanceof String};le.isObject=function(e){return e&&typeof e=="object"};le.isset=le.isSet=function(e,n){var t=e[n];return t!=null&&e.hasOwnProperty(n)?typeof t!="object"||(Array.isArray(t)?t.length:Object.keys(t).length)>0:!1};le.Buffer=function(){try{var r=le.inquire("buffer").Buffer;return r.prototype.utf8Write?r:null}catch{return null}}();le._Buffer_from=null;le._Buffer_allocUnsafe=null;le.newBuffer=function(e){return typeof e=="number"?le.Buffer?le._Buffer_allocUnsafe(e):new le.Array(e):le.Buffer?le._Buffer_from(e):typeof Uint8Array>"u"?e:new Uint8Array(e)};le.Array=typeof Uint8Array<"u"?Uint8Array:Array;le.Long=le.global.dcodeIO&&le.global.dcodeIO.Long||le.global.Long||le.inquire("long");le.key2Re=/^true|false|0|1$/;le.key32Re=/^-?(?:0|[1-9][0-9]*)$/;le.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;le.longToHash=function(e){return e?le.LongBits.from(e).toHash():le.LongBits.zeroHash};le.longFromHash=function(e,n){var t=le.LongBits.fromHash(e);return le.Long?le.Long.fromBits(t.lo,t.hi,n):t.toNumber(!!n)};function td(r,e,n){for(var t=Object.keys(e),o=0;o<t.length;++o)(r[t[o]]===void 0||!n)&&(r[t[o]]=e[t[o]]);return r}le.merge=td;le.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)};function rd(r){function e(n,t){if(!(this instanceof e))return new e(n,t);Object.defineProperty(this,"message",{get:function(){return n}}),Error.captureStackTrace?Error.captureStackTrace(this,e):Object.defineProperty(this,"stack",{value:new Error().stack||""}),t&&td(this,t)}return e.prototype=Object.create(Error.prototype,{constructor:{value:e,writable:!0,enumerable:!1,configurable:!0},name:{get:function(){return r},set:void 0,enumerable:!1,configurable:!0},toString:{value:function(){return this.name+": "+this.message},writable:!0,enumerable:!1,configurable:!0}}),e}le.newError=rd;le.ProtocolError=rd("ProtocolError");le.oneOfGetter=function(e){for(var n={},t=0;t<e.length;++t)n[e[t]]=1;return function(){for(var o=Object.keys(this),i=o.length-1;i>-1;--i)if(n[o[i]]===1&&this[o[i]]!==void 0&&this[o[i]]!==null)return o[i]}};le.oneOfSetter=function(e){return function(n){for(var t=0;t<e.length;++t)e[t]!==n&&delete this[e[t]]}};le.toJSONOptions={longs:String,enums:String,bytes:String,json:!0};le._configure=function(){var r=le.Buffer;if(!r){le._Buffer_from=le._Buffer_allocUnsafe=null;return}le._Buffer_from=r.from!==Uint8Array.from&&r.from||function(n,t){return new r(n,t)},le._Buffer_allocUnsafe=r.allocUnsafe||function(n){return new r(n)}}});var Ha=Je((__,ad)=>{"use strict";ad.exports=Me;var Kt=Ur(),Ma,di=Kt.LongBits,nd=Kt.base64,od=Kt.utf8;function so(r,e,n){this.fn=r,this.len=e,this.next=void 0,this.val=n}function Fa(){}function r0(r){this.head=r.head,this.tail=r.tail,this.len=r.len,this.next=r.states}function Me(){this.len=0,this.head=new so(Fa,0,0),this.tail=this.head,this.states=null}var id=function(){return Kt.Buffer?function(){return(Me.create=function(){return new Ma})()}:function(){return new Me}};Me.create=id();Me.alloc=function(e){return new Kt.Array(e)};Kt.Array!==Array&&(Me.alloc=Kt.pool(Me.alloc,Kt.Array.prototype.subarray));Me.prototype._push=function(e,n,t){return this.tail=this.tail.next=new so(e,n,t),this.len+=n,this};function Ua(r,e,n){e[n]=r&255}function n0(r,e,n){for(;r>127;)e[n++]=r&127|128,r>>>=7;e[n]=r}function Ga(r,e){this.len=r,this.next=void 0,this.val=e}Ga.prototype=Object.create(so.prototype);Ga.prototype.fn=n0;Me.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new Ga((e=e>>>0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this};Me.prototype.int32=function(e){return e<0?this._push(Wa,10,di.fromNumber(e)):this.uint32(e)};Me.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)};function Wa(r,e,n){for(;r.hi;)e[n++]=r.lo&127|128,r.lo=(r.lo>>>7|r.hi<<25)>>>0,r.hi>>>=7;for(;r.lo>127;)e[n++]=r.lo&127|128,r.lo=r.lo>>>7;e[n++]=r.lo}Me.prototype.uint64=function(e){var n=di.from(e);return this._push(Wa,n.length(),n)};Me.prototype.int64=Me.prototype.uint64;Me.prototype.sint64=function(e){var n=di.from(e).zzEncode();return this._push(Wa,n.length(),n)};Me.prototype.bool=function(e){return this._push(Ua,1,e?1:0)};function Va(r,e,n){e[n]=r&255,e[n+1]=r>>>8&255,e[n+2]=r>>>16&255,e[n+3]=r>>>24}Me.prototype.fixed32=function(e){return this._push(Va,4,e>>>0)};Me.prototype.sfixed32=Me.prototype.fixed32;Me.prototype.fixed64=function(e){var n=di.from(e);return this._push(Va,4,n.lo)._push(Va,4,n.hi)};Me.prototype.sfixed64=Me.prototype.fixed64;Me.prototype.float=function(e){return this._push(Kt.float.writeFloatLE,4,e)};Me.prototype.double=function(e){return this._push(Kt.float.writeDoubleLE,8,e)};var o0=Kt.Array.prototype.set?function(e,n,t){n.set(e,t)}:function(e,n,t){for(var o=0;o<e.length;++o)n[t+o]=e[o]};Me.prototype.bytes=function(e){var n=e.length>>>0;if(!n)return this._push(Ua,1,0);if(Kt.isString(e)){var t=Me.alloc(n=nd.length(e));nd.decode(e,t,0),e=t}return this.uint32(n)._push(o0,n,e)};Me.prototype.string=function(e){var n=od.length(e);return n?this.uint32(n)._push(od.write,n,e):this._push(Ua,1,0)};Me.prototype.fork=function(){return this.states=new r0(this),this.head=this.tail=new so(Fa,0,0),this.len=0,this};Me.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new so(Fa,0,0),this.len=0),this};Me.prototype.ldelim=function(){var e=this.head,n=this.tail,t=this.len;return this.reset().uint32(t),t&&(this.tail.next=e.next,this.tail=n,this.len+=t),this};Me.prototype.finish=function(){for(var e=this.head.next,n=this.constructor.alloc(this.len),t=0;e;)e.fn(e.val,n,t),t+=e.len,e=e.next;return n};Me._configure=function(r){Ma=r,Me.create=id(),Ma._configure()}});var ld=Je(($_,ud)=>{"use strict";ud.exports=fr;var sd=Ha();(fr.prototype=Object.create(sd.prototype)).constructor=fr;var Gr=Ur();function fr(){sd.call(this)}fr._configure=function(){fr.alloc=Gr._Buffer_allocUnsafe,fr.writeBytesBuffer=Gr.Buffer&&Gr.Buffer.prototype instanceof Uint8Array&&Gr.Buffer.prototype.set.name==="set"?function(e,n,t){n.set(e,t)}:function(e,n,t){if(e.copy)e.copy(n,t,0,e.length);else for(var o=0;o<e.length;)n[t++]=e[o++]}};fr.prototype.bytes=function(e){Gr.isString(e)&&(e=Gr._Buffer_from(e,"base64"));var n=e.length>>>0;return this.uint32(n),n&&this._push(fr.writeBytesBuffer,n,e),this};function i0(r,e,n){r.length<40?Gr.utf8.write(r,e,n):e.utf8Write?e.utf8Write(r,n):e.write(r,n)}fr.prototype.string=function(e){var n=Gr.Buffer.byteLength(e);return this.uint32(n),n&&this._push(i0,n,e),this};fr._configure()});var Ka=Je((S_,hd)=>{"use strict";hd.exports=pt;var pr=Ur(),ja,fd=pr.LongBits,a0=pr.utf8;function ar(r,e){return RangeError("index out of range: "+r.pos+" + "+(e||1)+" > "+r.len)}function pt(r){this.buf=r,this.pos=0,this.len=r.length}var dd=typeof Uint8Array<"u"?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new pt(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new pt(e);throw Error("illegal buffer")},pd=function(){return pr.Buffer?function(n){return(pt.create=function(o){return pr.Buffer.isBuffer(o)?new ja(o):dd(o)})(n)}:dd};pt.create=pd();pt.prototype._slice=pr.Array.prototype.subarray||pr.Array.prototype.slice;pt.prototype.uint32=function(){var e=4294967295;return function(){if(e=(this.buf[this.pos]&127)>>>0,this.buf[this.pos++]<128||(e=(e|(this.buf[this.pos]&127)<<7)>>>0,this.buf[this.pos++]<128)||(e=(e|(this.buf[this.pos]&127)<<14)>>>0,this.buf[this.pos++]<128)||(e=(e|(this.buf[this.pos]&127)<<21)>>>0,this.buf[this.pos++]<128)||(e=(e|(this.buf[this.pos]&15)<<28)>>>0,this.buf[this.pos++]<128))return e;if((this.pos+=5)>this.len)throw this.pos=this.len,ar(this,10);return e}}();pt.prototype.int32=function(){return this.uint32()|0};pt.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(e&1)|0};function qa(){var r=new fd(0,0),e=0;if(this.len-this.pos>4){for(;e<4;++e)if(r.lo=(r.lo|(this.buf[this.pos]&127)<<e*7)>>>0,this.buf[this.pos++]<128)return r;if(r.lo=(r.lo|(this.buf[this.pos]&127)<<28)>>>0,r.hi=(r.hi|(this.buf[this.pos]&127)>>4)>>>0,this.buf[this.pos++]<128)return r;e=0}else{for(;e<3;++e){if(this.pos>=this.len)throw ar(this);if(r.lo=(r.lo|(this.buf[this.pos]&127)<<e*7)>>>0,this.buf[this.pos++]<128)return r}return r.lo=(r.lo|(this.buf[this.pos++]&127)<<e*7)>>>0,r}if(this.len-this.pos>4){for(;e<5;++e)if(r.hi=(r.hi|(this.buf[this.pos]&127)<<e*7+3)>>>0,this.buf[this.pos++]<128)return r}else for(;e<5;++e){if(this.pos>=this.len)throw ar(this);if(r.hi=(r.hi|(this.buf[this.pos]&127)<<e*7+3)>>>0,this.buf[this.pos++]<128)return r}throw Error("invalid varint encoding")}pt.prototype.bool=function(){return this.uint32()!==0};function ci(r,e){return(r[e-4]|r[e-3]<<8|r[e-2]<<16|r[e-1]<<24)>>>0}pt.prototype.fixed32=function(){if(this.pos+4>this.len)throw ar(this,4);return ci(this.buf,this.pos+=4)};pt.prototype.sfixed32=function(){if(this.pos+4>this.len)throw ar(this,4);return ci(this.buf,this.pos+=4)|0};function cd(){if(this.pos+8>this.len)throw ar(this,8);return new fd(ci(this.buf,this.pos+=4),ci(this.buf,this.pos+=4))}pt.prototype.float=function(){if(this.pos+4>this.len)throw ar(this,4);var e=pr.float.readFloatLE(this.buf,this.pos);return this.pos+=4,e};pt.prototype.double=function(){if(this.pos+8>this.len)throw ar(this,4);var e=pr.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,e};pt.prototype.bytes=function(){var e=this.uint32(),n=this.pos,t=this.pos+e;if(t>this.len)throw ar(this,e);return this.pos+=e,Array.isArray(this.buf)?this.buf.slice(n,t):n===t?new this.buf.constructor(0):this._slice.call(this.buf,n,t)};pt.prototype.string=function(){var e=this.bytes();return a0.read(e,0,e.length)};pt.prototype.skip=function(e){if(typeof e=="number"){if(this.pos+e>this.len)throw ar(this,e);this.pos+=e}else do if(this.pos>=this.len)throw ar(this);while(this.buf[this.pos++]&128);return this};pt.prototype.skipType=function(r){switch(r){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;(r=this.uint32()&7)!==4;)this.skipType(r);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+r+" at offset "+this.pos)}return this};pt._configure=function(r){ja=r,pt.create=pd(),ja._configure();var e=pr.Long?"toLong":"toNumber";pr.merge(pt.prototype,{int64:function(){return qa.call(this)[e](!1)},uint64:function(){return qa.call(this)[e](!0)},sint64:function(){return qa.call(this).zzDecode()[e](!1)},fixed64:function(){return cd.call(this)[e](!0)},sfixed64:function(){return cd.call(this)[e](!1)}})}});var yd=Je((I_,bd)=>{"use strict";bd.exports=rn;var gd=Ka();(rn.prototype=Object.create(gd.prototype)).constructor=rn;var md=Ur();function rn(r){gd.call(this,r)}rn._configure=function(){md.Buffer&&(rn.prototype._slice=md.Buffer.prototype.slice)};rn.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice?this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len)):this.buf.toString("utf-8",this.pos,this.pos=Math.min(this.pos+e,this.len))};rn._configure()});var wd=Je((A_,vd)=>{"use strict";vd.exports=uo;var Ya=Ur();(uo.prototype=Object.create(Ya.EventEmitter.prototype)).constructor=uo;function uo(r,e,n){if(typeof r!="function")throw TypeError("rpcImpl must be a function");Ya.EventEmitter.call(this),this.rpcImpl=r,this.requestDelimited=!!e,this.responseDelimited=!!n}uo.prototype.rpcCall=function r(e,n,t,o,i){if(!o)throw TypeError("request must be specified");var s=this;if(!i)return Ya.asPromise(r,s,e,n,t,o);if(!s.rpcImpl){setTimeout(function(){i(Error("already ended"))},0);return}try{return s.rpcImpl(e,n[s.requestDelimited?"encodeDelimited":"encode"](o).finish(),function(u,l){if(u)return s.emit("error",u,e),i(u);if(l===null){s.end(!0);return}if(!(l instanceof t))try{l=t[s.responseDelimited?"decodeDelimited":"decode"](l)}catch(d){return s.emit("error",d,e),i(d)}return s.emit("data",l,e),i(null,l)})}catch(a){s.emit("error",a,e),setTimeout(function(){i(a)},0);return}};uo.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}});var Td=Je(xd=>{"use strict";var s0=xd;s0.Service=wd()});var $d=Je((E_,_d)=>{"use strict";_d.exports={}});var Ad=Je(Id=>{"use strict";var Mt=Id;Mt.build="minimal";Mt.Writer=Ha();Mt.BufferWriter=ld();Mt.Reader=Ka();Mt.BufferReader=yd();Mt.util=Ur();Mt.rpc=Td();Mt.roots=$d();Mt.configure=Sd;function Sd(){Mt.util._configure(),Mt.Writer._configure(Mt.BufferWriter),Mt.Reader._configure(Mt.BufferReader)}Sd()});var Ed=Je((P_,Od)=>{"use strict";Od.exports=Ad()});var In=Je((k_,Cd)=>{"use strict";var et=Ed(),Z=et.Reader,ht=et.Writer,O=et.util,_=et.roots.default||(et.roots.default={});_.onnx=function(){var r={};return r.Version=function(){var e={},n=Object.create(e);return n[e[0]="_START_VERSION"]=0,n[e[1]="IR_VERSION_2017_10_10"]=1,n[e[2]="IR_VERSION_2017_10_30"]=2,n[e[3]="IR_VERSION_2017_11_3"]=3,n[e[4]="IR_VERSION_2019_1_22"]=4,n[e[5]="IR_VERSION_2019_3_18"]=5,n[e[6]="IR_VERSION_2019_9_19"]=6,n[e[7]="IR_VERSION_2020_5_8"]=7,n[e[8]="IR_VERSION_2021_7_30"]=8,n[e[9]="IR_VERSION"]=9,n}(),r.AttributeProto=function(){function e(n){if(this.floats=[],this.ints=[],this.strings=[],this.tensors=[],this.graphs=[],this.sparseTensors=[],this.typeProtos=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.name="",e.prototype.refAttrName="",e.prototype.docString="",e.prototype.type=0,e.prototype.f=0,e.prototype.i=O.Long?O.Long.fromBits(0,0,!1):0,e.prototype.s=O.newBuffer([]),e.prototype.t=null,e.prototype.g=null,e.prototype.sparseTensor=null,e.prototype.tp=null,e.prototype.floats=O.emptyArray,e.prototype.ints=O.emptyArray,e.prototype.strings=O.emptyArray,e.prototype.tensors=O.emptyArray,e.prototype.graphs=O.emptyArray,e.prototype.sparseTensors=O.emptyArray,e.prototype.typeProtos=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.name!=null&&Object.hasOwnProperty.call(t,"name")&&o.uint32(10).string(t.name),t.f!=null&&Object.hasOwnProperty.call(t,"f")&&o.uint32(21).float(t.f),t.i!=null&&Object.hasOwnProperty.call(t,"i")&&o.uint32(24).int64(t.i),t.s!=null&&Object.hasOwnProperty.call(t,"s")&&o.uint32(34).bytes(t.s),t.t!=null&&Object.hasOwnProperty.call(t,"t")&&_.onnx.TensorProto.encode(t.t,o.uint32(42).fork()).ldelim(),t.g!=null&&Object.hasOwnProperty.call(t,"g")&&_.onnx.GraphProto.encode(t.g,o.uint32(50).fork()).ldelim(),t.floats!=null&&t.floats.length){o.uint32(58).fork();for(var i=0;i<t.floats.length;++i)o.float(t.floats[i]);o.ldelim()}if(t.ints!=null&&t.ints.length){o.uint32(66).fork();for(var i=0;i<t.ints.length;++i)o.int64(t.ints[i]);o.ldelim()}if(t.strings!=null&&t.strings.length)for(var i=0;i<t.strings.length;++i)o.uint32(74).bytes(t.strings[i]);if(t.tensors!=null&&t.tensors.length)for(var i=0;i<t.tensors.length;++i)_.onnx.TensorProto.encode(t.tensors[i],o.uint32(82).fork()).ldelim();if(t.graphs!=null&&t.graphs.length)for(var i=0;i<t.graphs.length;++i)_.onnx.GraphProto.encode(t.graphs[i],o.uint32(90).fork()).ldelim();if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(106).string(t.docString),t.tp!=null&&Object.hasOwnProperty.call(t,"tp")&&_.onnx.TypeProto.encode(t.tp,o.uint32(114).fork()).ldelim(),t.typeProtos!=null&&t.typeProtos.length)for(var i=0;i<t.typeProtos.length;++i)_.onnx.TypeProto.encode(t.typeProtos[i],o.uint32(122).fork()).ldelim();if(t.type!=null&&Object.hasOwnProperty.call(t,"type")&&o.uint32(160).int32(t.type),t.refAttrName!=null&&Object.hasOwnProperty.call(t,"refAttrName")&&o.uint32(170).string(t.refAttrName),t.sparseTensor!=null&&Object.hasOwnProperty.call(t,"sparseTensor")&&_.onnx.SparseTensorProto.encode(t.sparseTensor,o.uint32(178).fork()).ldelim(),t.sparseTensors!=null&&t.sparseTensors.length)for(var i=0;i<t.sparseTensors.length;++i)_.onnx.SparseTensorProto.encode(t.sparseTensors[i],o.uint32(186).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.AttributeProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.name=t.string();break}case 21:{s.refAttrName=t.string();break}case 13:{s.docString=t.string();break}case 20:{s.type=t.int32();break}case 2:{s.f=t.float();break}case 3:{s.i=t.int64();break}case 4:{s.s=t.bytes();break}case 5:{s.t=_.onnx.TensorProto.decode(t,t.uint32());break}case 6:{s.g=_.onnx.GraphProto.decode(t,t.uint32());break}case 22:{s.sparseTensor=_.onnx.SparseTensorProto.decode(t,t.uint32());break}case 14:{s.tp=_.onnx.TypeProto.decode(t,t.uint32());break}case 7:{if(s.floats&&s.floats.length||(s.floats=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.floats.push(t.float());else s.floats.push(t.float());break}case 8:{if(s.ints&&s.ints.length||(s.ints=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.ints.push(t.int64());else s.ints.push(t.int64());break}case 9:{s.strings&&s.strings.length||(s.strings=[]),s.strings.push(t.bytes());break}case 10:{s.tensors&&s.tensors.length||(s.tensors=[]),s.tensors.push(_.onnx.TensorProto.decode(t,t.uint32()));break}case 11:{s.graphs&&s.graphs.length||(s.graphs=[]),s.graphs.push(_.onnx.GraphProto.decode(t,t.uint32()));break}case 23:{s.sparseTensors&&s.sparseTensors.length||(s.sparseTensors=[]),s.sparseTensors.push(_.onnx.SparseTensorProto.decode(t,t.uint32()));break}case 15:{s.typeProtos&&s.typeProtos.length||(s.typeProtos=[]),s.typeProtos.push(_.onnx.TypeProto.decode(t,t.uint32()));break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.name!=null&&t.hasOwnProperty("name")&&!O.isString(t.name))return"name: string expected";if(t.refAttrName!=null&&t.hasOwnProperty("refAttrName")&&!O.isString(t.refAttrName))return"refAttrName: string expected";if(t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString))return"docString: string expected";if(t.type!=null&&t.hasOwnProperty("type"))switch(t.type){default:return"type: enum value expected";case 0:case 1:case 2:case 3:case 4:case 5:case 11:case 13:case 6:case 7:case 8:case 9:case 10:case 12:case 14:break}if(t.f!=null&&t.hasOwnProperty("f")&&typeof t.f!="number")return"f: number expected";if(t.i!=null&&t.hasOwnProperty("i")&&!O.isInteger(t.i)&&!(t.i&&O.isInteger(t.i.low)&&O.isInteger(t.i.high)))return"i: integer|Long expected";if(t.s!=null&&t.hasOwnProperty("s")&&!(t.s&&typeof t.s.length=="number"||O.isString(t.s)))return"s: buffer expected";if(t.t!=null&&t.hasOwnProperty("t")){var o=_.onnx.TensorProto.verify(t.t);if(o)return"t."+o}if(t.g!=null&&t.hasOwnProperty("g")){var o=_.onnx.GraphProto.verify(t.g);if(o)return"g."+o}if(t.sparseTensor!=null&&t.hasOwnProperty("sparseTensor")){var o=_.onnx.SparseTensorProto.verify(t.sparseTensor);if(o)return"sparseTensor."+o}if(t.tp!=null&&t.hasOwnProperty("tp")){var o=_.onnx.TypeProto.verify(t.tp);if(o)return"tp."+o}if(t.floats!=null&&t.hasOwnProperty("floats")){if(!Array.isArray(t.floats))return"floats: array expected";for(var i=0;i<t.floats.length;++i)if(typeof t.floats[i]!="number")return"floats: number[] expected"}if(t.ints!=null&&t.hasOwnProperty("ints")){if(!Array.isArray(t.ints))return"ints: array expected";for(var i=0;i<t.ints.length;++i)if(!O.isInteger(t.ints[i])&&!(t.ints[i]&&O.isInteger(t.ints[i].low)&&O.isInteger(t.ints[i].high)))return"ints: integer|Long[] expected"}if(t.strings!=null&&t.hasOwnProperty("strings")){if(!Array.isArray(t.strings))return"strings: array expected";for(var i=0;i<t.strings.length;++i)if(!(t.strings[i]&&typeof t.strings[i].length=="number"||O.isString(t.strings[i])))return"strings: buffer[] expected"}if(t.tensors!=null&&t.hasOwnProperty("tensors")){if(!Array.isArray(t.tensors))return"tensors: array expected";for(var i=0;i<t.tensors.length;++i){var o=_.onnx.TensorProto.verify(t.tensors[i]);if(o)return"tensors."+o}}if(t.graphs!=null&&t.hasOwnProperty("graphs")){if(!Array.isArray(t.graphs))return"graphs: array expected";for(var i=0;i<t.graphs.length;++i){var o=_.onnx.GraphProto.verify(t.graphs[i]);if(o)return"graphs."+o}}if(t.sparseTensors!=null&&t.hasOwnProperty("sparseTensors")){if(!Array.isArray(t.sparseTensors))return"sparseTensors: array expected";for(var i=0;i<t.sparseTensors.length;++i){var o=_.onnx.SparseTensorProto.verify(t.sparseTensors[i]);if(o)return"sparseTensors."+o}}if(t.typeProtos!=null&&t.hasOwnProperty("typeProtos")){if(!Array.isArray(t.typeProtos))return"typeProtos: array expected";for(var i=0;i<t.typeProtos.length;++i){var o=_.onnx.TypeProto.verify(t.typeProtos[i]);if(o)return"typeProtos."+o}}return null},e.fromObject=function(t){if(t instanceof _.onnx.AttributeProto)return t;var o=new _.onnx.AttributeProto;switch(t.name!=null&&(o.name=String(t.name)),t.refAttrName!=null&&(o.refAttrName=String(t.refAttrName)),t.docString!=null&&(o.docString=String(t.docString)),t.type){default:if(typeof t.type=="number"){o.type=t.type;break}break;case"UNDEFINED":case 0:o.type=0;break;case"FLOAT":case 1:o.type=1;break;case"INT":case 2:o.type=2;break;case"STRING":case 3:o.type=3;break;case"TENSOR":case 4:o.type=4;break;case"GRAPH":case 5:o.type=5;break;case"SPARSE_TENSOR":case 11:o.type=11;break;case"TYPE_PROTO":case 13:o.type=13;break;case"FLOATS":case 6:o.type=6;break;case"INTS":case 7:o.type=7;break;case"STRINGS":case 8:o.type=8;break;case"TENSORS":case 9:o.type=9;break;case"GRAPHS":case 10:o.type=10;break;case"SPARSE_TENSORS":case 12:o.type=12;break;case"TYPE_PROTOS":case 14:o.type=14;break}if(t.f!=null&&(o.f=Number(t.f)),t.i!=null&&(O.Long?(o.i=O.Long.fromValue(t.i)).unsigned=!1:typeof t.i=="string"?o.i=parseInt(t.i,10):typeof t.i=="number"?o.i=t.i:typeof t.i=="object"&&(o.i=new O.LongBits(t.i.low>>>0,t.i.high>>>0).toNumber())),t.s!=null&&(typeof t.s=="string"?O.base64.decode(t.s,o.s=O.newBuffer(O.base64.length(t.s)),0):t.s.length>=0&&(o.s=t.s)),t.t!=null){if(typeof t.t!="object")throw TypeError(".onnx.AttributeProto.t: object expected");o.t=_.onnx.TensorProto.fromObject(t.t)}if(t.g!=null){if(typeof t.g!="object")throw TypeError(".onnx.AttributeProto.g: object expected");o.g=_.onnx.GraphProto.fromObject(t.g)}if(t.sparseTensor!=null){if(typeof t.sparseTensor!="object")throw TypeError(".onnx.AttributeProto.sparseTensor: object expected");o.sparseTensor=_.onnx.SparseTensorProto.fromObject(t.sparseTensor)}if(t.tp!=null){if(typeof t.tp!="object")throw TypeError(".onnx.AttributeProto.tp: object expected");o.tp=_.onnx.TypeProto.fromObject(t.tp)}if(t.floats){if(!Array.isArray(t.floats))throw TypeError(".onnx.AttributeProto.floats: array expected");o.floats=[];for(var i=0;i<t.floats.length;++i)o.floats[i]=Number(t.floats[i])}if(t.ints){if(!Array.isArray(t.ints))throw TypeError(".onnx.AttributeProto.ints: array expected");o.ints=[];for(var i=0;i<t.ints.length;++i)O.Long?(o.ints[i]=O.Long.fromValue(t.ints[i])).unsigned=!1:typeof t.ints[i]=="string"?o.ints[i]=parseInt(t.ints[i],10):typeof t.ints[i]=="number"?o.ints[i]=t.ints[i]:typeof t.ints[i]=="object"&&(o.ints[i]=new O.LongBits(t.ints[i].low>>>0,t.ints[i].high>>>0).toNumber())}if(t.strings){if(!Array.isArray(t.strings))throw TypeError(".onnx.AttributeProto.strings: array expected");o.strings=[];for(var i=0;i<t.strings.length;++i)typeof t.strings[i]=="string"?O.base64.decode(t.strings[i],o.strings[i]=O.newBuffer(O.base64.length(t.strings[i])),0):t.strings[i].length>=0&&(o.strings[i]=t.strings[i])}if(t.tensors){if(!Array.isArray(t.tensors))throw TypeError(".onnx.AttributeProto.tensors: array expected");o.tensors=[];for(var i=0;i<t.tensors.length;++i){if(typeof t.tensors[i]!="object")throw TypeError(".onnx.AttributeProto.tensors: object expected");o.tensors[i]=_.onnx.TensorProto.fromObject(t.tensors[i])}}if(t.graphs){if(!Array.isArray(t.graphs))throw TypeError(".onnx.AttributeProto.graphs: array expected");o.graphs=[];for(var i=0;i<t.graphs.length;++i){if(typeof t.graphs[i]!="object")throw TypeError(".onnx.AttributeProto.graphs: object expected");o.graphs[i]=_.onnx.GraphProto.fromObject(t.graphs[i])}}if(t.sparseTensors){if(!Array.isArray(t.sparseTensors))throw TypeError(".onnx.AttributeProto.sparseTensors: array expected");o.sparseTensors=[];for(var i=0;i<t.sparseTensors.length;++i){if(typeof t.sparseTensors[i]!="object")throw TypeError(".onnx.AttributeProto.sparseTensors: object expected");o.sparseTensors[i]=_.onnx.SparseTensorProto.fromObject(t.sparseTensors[i])}}if(t.typeProtos){if(!Array.isArray(t.typeProtos))throw TypeError(".onnx.AttributeProto.typeProtos: array expected");o.typeProtos=[];for(var i=0;i<t.typeProtos.length;++i){if(typeof t.typeProtos[i]!="object")throw TypeError(".onnx.AttributeProto.typeProtos: object expected");o.typeProtos[i]=_.onnx.TypeProto.fromObject(t.typeProtos[i])}}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.floats=[],i.ints=[],i.strings=[],i.tensors=[],i.graphs=[],i.typeProtos=[],i.sparseTensors=[]),o.defaults){if(i.name="",i.f=0,O.Long){var s=new O.Long(0,0,!1);i.i=o.longs===String?s.toString():o.longs===Number?s.toNumber():s}else i.i=o.longs===String?"0":0;o.bytes===String?i.s="":(i.s=[],o.bytes!==Array&&(i.s=O.newBuffer(i.s))),i.t=null,i.g=null,i.docString="",i.tp=null,i.type=o.enums===String?"UNDEFINED":0,i.refAttrName="",i.sparseTensor=null}if(t.name!=null&&t.hasOwnProperty("name")&&(i.name=t.name),t.f!=null&&t.hasOwnProperty("f")&&(i.f=o.json&&!isFinite(t.f)?String(t.f):t.f),t.i!=null&&t.hasOwnProperty("i")&&(typeof t.i=="number"?i.i=o.longs===String?String(t.i):t.i:i.i=o.longs===String?O.Long.prototype.toString.call(t.i):o.longs===Number?new O.LongBits(t.i.low>>>0,t.i.high>>>0).toNumber():t.i),t.s!=null&&t.hasOwnProperty("s")&&(i.s=o.bytes===String?O.base64.encode(t.s,0,t.s.length):o.bytes===Array?Array.prototype.slice.call(t.s):t.s),t.t!=null&&t.hasOwnProperty("t")&&(i.t=_.onnx.TensorProto.toObject(t.t,o)),t.g!=null&&t.hasOwnProperty("g")&&(i.g=_.onnx.GraphProto.toObject(t.g,o)),t.floats&&t.floats.length){i.floats=[];for(var a=0;a<t.floats.length;++a)i.floats[a]=o.json&&!isFinite(t.floats[a])?String(t.floats[a]):t.floats[a]}if(t.ints&&t.ints.length){i.ints=[];for(var a=0;a<t.ints.length;++a)typeof t.ints[a]=="number"?i.ints[a]=o.longs===String?String(t.ints[a]):t.ints[a]:i.ints[a]=o.longs===String?O.Long.prototype.toString.call(t.ints[a]):o.longs===Number?new O.LongBits(t.ints[a].low>>>0,t.ints[a].high>>>0).toNumber():t.ints[a]}if(t.strings&&t.strings.length){i.strings=[];for(var a=0;a<t.strings.length;++a)i.strings[a]=o.bytes===String?O.base64.encode(t.strings[a],0,t.strings[a].length):o.bytes===Array?Array.prototype.slice.call(t.strings[a]):t.strings[a]}if(t.tensors&&t.tensors.length){i.tensors=[];for(var a=0;a<t.tensors.length;++a)i.tensors[a]=_.onnx.TensorProto.toObject(t.tensors[a],o)}if(t.graphs&&t.graphs.length){i.graphs=[];for(var a=0;a<t.graphs.length;++a)i.graphs[a]=_.onnx.GraphProto.toObject(t.graphs[a],o)}if(t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),t.tp!=null&&t.hasOwnProperty("tp")&&(i.tp=_.onnx.TypeProto.toObject(t.tp,o)),t.typeProtos&&t.typeProtos.length){i.typeProtos=[];for(var a=0;a<t.typeProtos.length;++a)i.typeProtos[a]=_.onnx.TypeProto.toObject(t.typeProtos[a],o)}if(t.type!=null&&t.hasOwnProperty("type")&&(i.type=o.enums===String?_.onnx.AttributeProto.AttributeType[t.type]===void 0?t.type:_.onnx.AttributeProto.AttributeType[t.type]:t.type),t.refAttrName!=null&&t.hasOwnProperty("refAttrName")&&(i.refAttrName=t.refAttrName),t.sparseTensor!=null&&t.hasOwnProperty("sparseTensor")&&(i.sparseTensor=_.onnx.SparseTensorProto.toObject(t.sparseTensor,o)),t.sparseTensors&&t.sparseTensors.length){i.sparseTensors=[];for(var a=0;a<t.sparseTensors.length;++a)i.sparseTensors[a]=_.onnx.SparseTensorProto.toObject(t.sparseTensors[a],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.AttributeProto"},e.AttributeType=function(){var n={},t=Object.create(n);return t[n[0]="UNDEFINED"]=0,t[n[1]="FLOAT"]=1,t[n[2]="INT"]=2,t[n[3]="STRING"]=3,t[n[4]="TENSOR"]=4,t[n[5]="GRAPH"]=5,t[n[11]="SPARSE_TENSOR"]=11,t[n[13]="TYPE_PROTO"]=13,t[n[6]="FLOATS"]=6,t[n[7]="INTS"]=7,t[n[8]="STRINGS"]=8,t[n[9]="TENSORS"]=9,t[n[10]="GRAPHS"]=10,t[n[12]="SPARSE_TENSORS"]=12,t[n[14]="TYPE_PROTOS"]=14,t}(),e}(),r.ValueInfoProto=function(){function e(n){if(n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.name="",e.prototype.type=null,e.prototype.docString="",e.create=function(t){return new e(t)},e.encode=function(t,o){return o||(o=ht.create()),t.name!=null&&Object.hasOwnProperty.call(t,"name")&&o.uint32(10).string(t.name),t.type!=null&&Object.hasOwnProperty.call(t,"type")&&_.onnx.TypeProto.encode(t.type,o.uint32(18).fork()).ldelim(),t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(26).string(t.docString),o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.ValueInfoProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.name=t.string();break}case 2:{s.type=_.onnx.TypeProto.decode(t,t.uint32());break}case 3:{s.docString=t.string();break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.name!=null&&t.hasOwnProperty("name")&&!O.isString(t.name))return"name: string expected";if(t.type!=null&&t.hasOwnProperty("type")){var o=_.onnx.TypeProto.verify(t.type);if(o)return"type."+o}return t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString)?"docString: string expected":null},e.fromObject=function(t){if(t instanceof _.onnx.ValueInfoProto)return t;var o=new _.onnx.ValueInfoProto;if(t.name!=null&&(o.name=String(t.name)),t.type!=null){if(typeof t.type!="object")throw TypeError(".onnx.ValueInfoProto.type: object expected");o.type=_.onnx.TypeProto.fromObject(t.type)}return t.docString!=null&&(o.docString=String(t.docString)),o},e.toObject=function(t,o){o||(o={});var i={};return o.defaults&&(i.name="",i.type=null,i.docString=""),t.name!=null&&t.hasOwnProperty("name")&&(i.name=t.name),t.type!=null&&t.hasOwnProperty("type")&&(i.type=_.onnx.TypeProto.toObject(t.type,o)),t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.ValueInfoProto"},e}(),r.NodeProto=function(){function e(n){if(this.input=[],this.output=[],this.attribute=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.input=O.emptyArray,e.prototype.output=O.emptyArray,e.prototype.name="",e.prototype.opType="",e.prototype.domain="",e.prototype.attribute=O.emptyArray,e.prototype.docString="",e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.input!=null&&t.input.length)for(var i=0;i<t.input.length;++i)o.uint32(10).string(t.input[i]);if(t.output!=null&&t.output.length)for(var i=0;i<t.output.length;++i)o.uint32(18).string(t.output[i]);if(t.name!=null&&Object.hasOwnProperty.call(t,"name")&&o.uint32(26).string(t.name),t.opType!=null&&Object.hasOwnProperty.call(t,"opType")&&o.uint32(34).string(t.opType),t.attribute!=null&&t.attribute.length)for(var i=0;i<t.attribute.length;++i)_.onnx.AttributeProto.encode(t.attribute[i],o.uint32(42).fork()).ldelim();return t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(50).string(t.docString),t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&o.uint32(58).string(t.domain),o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.NodeProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.input&&s.input.length||(s.input=[]),s.input.push(t.string());break}case 2:{s.output&&s.output.length||(s.output=[]),s.output.push(t.string());break}case 3:{s.name=t.string();break}case 4:{s.opType=t.string();break}case 7:{s.domain=t.string();break}case 5:{s.attribute&&s.attribute.length||(s.attribute=[]),s.attribute.push(_.onnx.AttributeProto.decode(t,t.uint32()));break}case 6:{s.docString=t.string();break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.input!=null&&t.hasOwnProperty("input")){if(!Array.isArray(t.input))return"input: array expected";for(var o=0;o<t.input.length;++o)if(!O.isString(t.input[o]))return"input: string[] expected"}if(t.output!=null&&t.hasOwnProperty("output")){if(!Array.isArray(t.output))return"output: array expected";for(var o=0;o<t.output.length;++o)if(!O.isString(t.output[o]))return"output: string[] expected"}if(t.name!=null&&t.hasOwnProperty("name")&&!O.isString(t.name))return"name: string expected";if(t.opType!=null&&t.hasOwnProperty("opType")&&!O.isString(t.opType))return"opType: string expected";if(t.domain!=null&&t.hasOwnProperty("domain")&&!O.isString(t.domain))return"domain: string expected";if(t.attribute!=null&&t.hasOwnProperty("attribute")){if(!Array.isArray(t.attribute))return"attribute: array expected";for(var o=0;o<t.attribute.length;++o){var i=_.onnx.AttributeProto.verify(t.attribute[o]);if(i)return"attribute."+i}}return t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString)?"docString: string expected":null},e.fromObject=function(t){if(t instanceof _.onnx.NodeProto)return t;var o=new _.onnx.NodeProto;if(t.input){if(!Array.isArray(t.input))throw TypeError(".onnx.NodeProto.input: array expected");o.input=[];for(var i=0;i<t.input.length;++i)o.input[i]=String(t.input[i])}if(t.output){if(!Array.isArray(t.output))throw TypeError(".onnx.NodeProto.output: array expected");o.output=[];for(var i=0;i<t.output.length;++i)o.output[i]=String(t.output[i])}if(t.name!=null&&(o.name=String(t.name)),t.opType!=null&&(o.opType=String(t.opType)),t.domain!=null&&(o.domain=String(t.domain)),t.attribute){if(!Array.isArray(t.attribute))throw TypeError(".onnx.NodeProto.attribute: array expected");o.attribute=[];for(var i=0;i<t.attribute.length;++i){if(typeof t.attribute[i]!="object")throw TypeError(".onnx.NodeProto.attribute: object expected");o.attribute[i]=_.onnx.AttributeProto.fromObject(t.attribute[i])}}return t.docString!=null&&(o.docString=String(t.docString)),o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.input=[],i.output=[],i.attribute=[]),o.defaults&&(i.name="",i.opType="",i.docString="",i.domain=""),t.input&&t.input.length){i.input=[];for(var s=0;s<t.input.length;++s)i.input[s]=t.input[s]}if(t.output&&t.output.length){i.output=[];for(var s=0;s<t.output.length;++s)i.output[s]=t.output[s]}if(t.name!=null&&t.hasOwnProperty("name")&&(i.name=t.name),t.opType!=null&&t.hasOwnProperty("opType")&&(i.opType=t.opType),t.attribute&&t.attribute.length){i.attribute=[];for(var s=0;s<t.attribute.length;++s)i.attribute[s]=_.onnx.AttributeProto.toObject(t.attribute[s],o)}return t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),t.domain!=null&&t.hasOwnProperty("domain")&&(i.domain=t.domain),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.NodeProto"},e}(),r.TrainingInfoProto=function(){function e(n){if(this.initializationBinding=[],this.updateBinding=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.initialization=null,e.prototype.algorithm=null,e.prototype.initializationBinding=O.emptyArray,e.prototype.updateBinding=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.initialization!=null&&Object.hasOwnProperty.call(t,"initialization")&&_.onnx.GraphProto.encode(t.initialization,o.uint32(10).fork()).ldelim(),t.algorithm!=null&&Object.hasOwnProperty.call(t,"algorithm")&&_.onnx.GraphProto.encode(t.algorithm,o.uint32(18).fork()).ldelim(),t.initializationBinding!=null&&t.initializationBinding.length)for(var i=0;i<t.initializationBinding.length;++i)_.onnx.StringStringEntryProto.encode(t.initializationBinding[i],o.uint32(26).fork()).ldelim();if(t.updateBinding!=null&&t.updateBinding.length)for(var i=0;i<t.updateBinding.length;++i)_.onnx.StringStringEntryProto.encode(t.updateBinding[i],o.uint32(34).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.TrainingInfoProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.initialization=_.onnx.GraphProto.decode(t,t.uint32());break}case 2:{s.algorithm=_.onnx.GraphProto.decode(t,t.uint32());break}case 3:{s.initializationBinding&&s.initializationBinding.length||(s.initializationBinding=[]),s.initializationBinding.push(_.onnx.StringStringEntryProto.decode(t,t.uint32()));break}case 4:{s.updateBinding&&s.updateBinding.length||(s.updateBinding=[]),s.updateBinding.push(_.onnx.StringStringEntryProto.decode(t,t.uint32()));break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.initialization!=null&&t.hasOwnProperty("initialization")){var o=_.onnx.GraphProto.verify(t.initialization);if(o)return"initialization."+o}if(t.algorithm!=null&&t.hasOwnProperty("algorithm")){var o=_.onnx.GraphProto.verify(t.algorithm);if(o)return"algorithm."+o}if(t.initializationBinding!=null&&t.hasOwnProperty("initializationBinding")){if(!Array.isArray(t.initializationBinding))return"initializationBinding: array expected";for(var i=0;i<t.initializationBinding.length;++i){var o=_.onnx.StringStringEntryProto.verify(t.initializationBinding[i]);if(o)return"initializationBinding."+o}}if(t.updateBinding!=null&&t.hasOwnProperty("updateBinding")){if(!Array.isArray(t.updateBinding))return"updateBinding: array expected";for(var i=0;i<t.updateBinding.length;++i){var o=_.onnx.StringStringEntryProto.verify(t.updateBinding[i]);if(o)return"updateBinding."+o}}return null},e.fromObject=function(t){if(t instanceof _.onnx.TrainingInfoProto)return t;var o=new _.onnx.TrainingInfoProto;if(t.initialization!=null){if(typeof t.initialization!="object")throw TypeError(".onnx.TrainingInfoProto.initialization: object expected");o.initialization=_.onnx.GraphProto.fromObject(t.initialization)}if(t.algorithm!=null){if(typeof t.algorithm!="object")throw TypeError(".onnx.TrainingInfoProto.algorithm: object expected");o.algorithm=_.onnx.GraphProto.fromObject(t.algorithm)}if(t.initializationBinding){if(!Array.isArray(t.initializationBinding))throw TypeError(".onnx.TrainingInfoProto.initializationBinding: array expected");o.initializationBinding=[];for(var i=0;i<t.initializationBinding.length;++i){if(typeof t.initializationBinding[i]!="object")throw TypeError(".onnx.TrainingInfoProto.initializationBinding: object expected");o.initializationBinding[i]=_.onnx.StringStringEntryProto.fromObject(t.initializationBinding[i])}}if(t.updateBinding){if(!Array.isArray(t.updateBinding))throw TypeError(".onnx.TrainingInfoProto.updateBinding: array expected");o.updateBinding=[];for(var i=0;i<t.updateBinding.length;++i){if(typeof t.updateBinding[i]!="object")throw TypeError(".onnx.TrainingInfoProto.updateBinding: object expected");o.updateBinding[i]=_.onnx.StringStringEntryProto.fromObject(t.updateBinding[i])}}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.initializationBinding=[],i.updateBinding=[]),o.defaults&&(i.initialization=null,i.algorithm=null),t.initialization!=null&&t.hasOwnProperty("initialization")&&(i.initialization=_.onnx.GraphProto.toObject(t.initialization,o)),t.algorithm!=null&&t.hasOwnProperty("algorithm")&&(i.algorithm=_.onnx.GraphProto.toObject(t.algorithm,o)),t.initializationBinding&&t.initializationBinding.length){i.initializationBinding=[];for(var s=0;s<t.initializationBinding.length;++s)i.initializationBinding[s]=_.onnx.StringStringEntryProto.toObject(t.initializationBinding[s],o)}if(t.updateBinding&&t.updateBinding.length){i.updateBinding=[];for(var s=0;s<t.updateBinding.length;++s)i.updateBinding[s]=_.onnx.StringStringEntryProto.toObject(t.updateBinding[s],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TrainingInfoProto"},e}(),r.ModelProto=function(){function e(n){if(this.opsetImport=[],this.metadataProps=[],this.trainingInfo=[],this.functions=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.irVersion=O.Long?O.Long.fromBits(0,0,!1):0,e.prototype.opsetImport=O.emptyArray,e.prototype.producerName="",e.prototype.producerVersion="",e.prototype.domain="",e.prototype.modelVersion=O.Long?O.Long.fromBits(0,0,!1):0,e.prototype.docString="",e.prototype.graph=null,e.prototype.metadataProps=O.emptyArray,e.prototype.trainingInfo=O.emptyArray,e.prototype.functions=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.irVersion!=null&&Object.hasOwnProperty.call(t,"irVersion")&&o.uint32(8).int64(t.irVersion),t.producerName!=null&&Object.hasOwnProperty.call(t,"producerName")&&o.uint32(18).string(t.producerName),t.producerVersion!=null&&Object.hasOwnProperty.call(t,"producerVersion")&&o.uint32(26).string(t.producerVersion),t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&o.uint32(34).string(t.domain),t.modelVersion!=null&&Object.hasOwnProperty.call(t,"modelVersion")&&o.uint32(40).int64(t.modelVersion),t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(50).string(t.docString),t.graph!=null&&Object.hasOwnProperty.call(t,"graph")&&_.onnx.GraphProto.encode(t.graph,o.uint32(58).fork()).ldelim(),t.opsetImport!=null&&t.opsetImport.length)for(var i=0;i<t.opsetImport.length;++i)_.onnx.OperatorSetIdProto.encode(t.opsetImport[i],o.uint32(66).fork()).ldelim();if(t.metadataProps!=null&&t.metadataProps.length)for(var i=0;i<t.metadataProps.length;++i)_.onnx.StringStringEntryProto.encode(t.metadataProps[i],o.uint32(114).fork()).ldelim();if(t.trainingInfo!=null&&t.trainingInfo.length)for(var i=0;i<t.trainingInfo.length;++i)_.onnx.TrainingInfoProto.encode(t.trainingInfo[i],o.uint32(162).fork()).ldelim();if(t.functions!=null&&t.functions.length)for(var i=0;i<t.functions.length;++i)_.onnx.FunctionProto.encode(t.functions[i],o.uint32(202).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.ModelProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.irVersion=t.int64();break}case 8:{s.opsetImport&&s.opsetImport.length||(s.opsetImport=[]),s.opsetImport.push(_.onnx.OperatorSetIdProto.decode(t,t.uint32()));break}case 2:{s.producerName=t.string();break}case 3:{s.producerVersion=t.string();break}case 4:{s.domain=t.string();break}case 5:{s.modelVersion=t.int64();break}case 6:{s.docString=t.string();break}case 7:{s.graph=_.onnx.GraphProto.decode(t,t.uint32());break}case 14:{s.metadataProps&&s.metadataProps.length||(s.metadataProps=[]),s.metadataProps.push(_.onnx.StringStringEntryProto.decode(t,t.uint32()));break}case 20:{s.trainingInfo&&s.trainingInfo.length||(s.trainingInfo=[]),s.trainingInfo.push(_.onnx.TrainingInfoProto.decode(t,t.uint32()));break}case 25:{s.functions&&s.functions.length||(s.functions=[]),s.functions.push(_.onnx.FunctionProto.decode(t,t.uint32()));break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.irVersion!=null&&t.hasOwnProperty("irVersion")&&!O.isInteger(t.irVersion)&&!(t.irVersion&&O.isInteger(t.irVersion.low)&&O.isInteger(t.irVersion.high)))return"irVersion: integer|Long expected";if(t.opsetImport!=null&&t.hasOwnProperty("opsetImport")){if(!Array.isArray(t.opsetImport))return"opsetImport: array expected";for(var o=0;o<t.opsetImport.length;++o){var i=_.onnx.OperatorSetIdProto.verify(t.opsetImport[o]);if(i)return"opsetImport."+i}}if(t.producerName!=null&&t.hasOwnProperty("producerName")&&!O.isString(t.producerName))return"producerName: string expected";if(t.producerVersion!=null&&t.hasOwnProperty("producerVersion")&&!O.isString(t.producerVersion))return"producerVersion: string expected";if(t.domain!=null&&t.hasOwnProperty("domain")&&!O.isString(t.domain))return"domain: string expected";if(t.modelVersion!=null&&t.hasOwnProperty("modelVersion")&&!O.isInteger(t.modelVersion)&&!(t.modelVersion&&O.isInteger(t.modelVersion.low)&&O.isInteger(t.modelVersion.high)))return"modelVersion: integer|Long expected";if(t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString))return"docString: string expected";if(t.graph!=null&&t.hasOwnProperty("graph")){var i=_.onnx.GraphProto.verify(t.graph);if(i)return"graph."+i}if(t.metadataProps!=null&&t.hasOwnProperty("metadataProps")){if(!Array.isArray(t.metadataProps))return"metadataProps: array expected";for(var o=0;o<t.metadataProps.length;++o){var i=_.onnx.StringStringEntryProto.verify(t.metadataProps[o]);if(i)return"metadataProps."+i}}if(t.trainingInfo!=null&&t.hasOwnProperty("trainingInfo")){if(!Array.isArray(t.trainingInfo))return"trainingInfo: array expected";for(var o=0;o<t.trainingInfo.length;++o){var i=_.onnx.TrainingInfoProto.verify(t.trainingInfo[o]);if(i)return"trainingInfo."+i}}if(t.functions!=null&&t.hasOwnProperty("functions")){if(!Array.isArray(t.functions))return"functions: array expected";for(var o=0;o<t.functions.length;++o){var i=_.onnx.FunctionProto.verify(t.functions[o]);if(i)return"functions."+i}}return null},e.fromObject=function(t){if(t instanceof _.onnx.ModelProto)return t;var o=new _.onnx.ModelProto;if(t.irVersion!=null&&(O.Long?(o.irVersion=O.Long.fromValue(t.irVersion)).unsigned=!1:typeof t.irVersion=="string"?o.irVersion=parseInt(t.irVersion,10):typeof t.irVersion=="number"?o.irVersion=t.irVersion:typeof t.irVersion=="object"&&(o.irVersion=new O.LongBits(t.irVersion.low>>>0,t.irVersion.high>>>0).toNumber())),t.opsetImport){if(!Array.isArray(t.opsetImport))throw TypeError(".onnx.ModelProto.opsetImport: array expected");o.opsetImport=[];for(var i=0;i<t.opsetImport.length;++i){if(typeof t.opsetImport[i]!="object")throw TypeError(".onnx.ModelProto.opsetImport: object expected");o.opsetImport[i]=_.onnx.OperatorSetIdProto.fromObject(t.opsetImport[i])}}if(t.producerName!=null&&(o.producerName=String(t.producerName)),t.producerVersion!=null&&(o.producerVersion=String(t.producerVersion)),t.domain!=null&&(o.domain=String(t.domain)),t.modelVersion!=null&&(O.Long?(o.modelVersion=O.Long.fromValue(t.modelVersion)).unsigned=!1:typeof t.modelVersion=="string"?o.modelVersion=parseInt(t.modelVersion,10):typeof t.modelVersion=="number"?o.modelVersion=t.modelVersion:typeof t.modelVersion=="object"&&(o.modelVersion=new O.LongBits(t.modelVersion.low>>>0,t.modelVersion.high>>>0).toNumber())),t.docString!=null&&(o.docString=String(t.docString)),t.graph!=null){if(typeof t.graph!="object")throw TypeError(".onnx.ModelProto.graph: object expected");o.graph=_.onnx.GraphProto.fromObject(t.graph)}if(t.metadataProps){if(!Array.isArray(t.metadataProps))throw TypeError(".onnx.ModelProto.metadataProps: array expected");o.metadataProps=[];for(var i=0;i<t.metadataProps.length;++i){if(typeof t.metadataProps[i]!="object")throw TypeError(".onnx.ModelProto.metadataProps: object expected");o.metadataProps[i]=_.onnx.StringStringEntryProto.fromObject(t.metadataProps[i])}}if(t.trainingInfo){if(!Array.isArray(t.trainingInfo))throw TypeError(".onnx.ModelProto.trainingInfo: array expected");o.trainingInfo=[];for(var i=0;i<t.trainingInfo.length;++i){if(typeof t.trainingInfo[i]!="object")throw TypeError(".onnx.ModelProto.trainingInfo: object expected");o.trainingInfo[i]=_.onnx.TrainingInfoProto.fromObject(t.trainingInfo[i])}}if(t.functions){if(!Array.isArray(t.functions))throw TypeError(".onnx.ModelProto.functions: array expected");o.functions=[];for(var i=0;i<t.functions.length;++i){if(typeof t.functions[i]!="object")throw TypeError(".onnx.ModelProto.functions: object expected");o.functions[i]=_.onnx.FunctionProto.fromObject(t.functions[i])}}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.opsetImport=[],i.metadataProps=[],i.trainingInfo=[],i.functions=[]),o.defaults){if(O.Long){var s=new O.Long(0,0,!1);i.irVersion=o.longs===String?s.toString():o.longs===Number?s.toNumber():s}else i.irVersion=o.longs===String?"0":0;if(i.producerName="",i.producerVersion="",i.domain="",O.Long){var s=new O.Long(0,0,!1);i.modelVersion=o.longs===String?s.toString():o.longs===Number?s.toNumber():s}else i.modelVersion=o.longs===String?"0":0;i.docString="",i.graph=null}if(t.irVersion!=null&&t.hasOwnProperty("irVersion")&&(typeof t.irVersion=="number"?i.irVersion=o.longs===String?String(t.irVersion):t.irVersion:i.irVersion=o.longs===String?O.Long.prototype.toString.call(t.irVersion):o.longs===Number?new O.LongBits(t.irVersion.low>>>0,t.irVersion.high>>>0).toNumber():t.irVersion),t.producerName!=null&&t.hasOwnProperty("producerName")&&(i.producerName=t.producerName),t.producerVersion!=null&&t.hasOwnProperty("producerVersion")&&(i.producerVersion=t.producerVersion),t.domain!=null&&t.hasOwnProperty("domain")&&(i.domain=t.domain),t.modelVersion!=null&&t.hasOwnProperty("modelVersion")&&(typeof t.modelVersion=="number"?i.modelVersion=o.longs===String?String(t.modelVersion):t.modelVersion:i.modelVersion=o.longs===String?O.Long.prototype.toString.call(t.modelVersion):o.longs===Number?new O.LongBits(t.modelVersion.low>>>0,t.modelVersion.high>>>0).toNumber():t.modelVersion),t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),t.graph!=null&&t.hasOwnProperty("graph")&&(i.graph=_.onnx.GraphProto.toObject(t.graph,o)),t.opsetImport&&t.opsetImport.length){i.opsetImport=[];for(var a=0;a<t.opsetImport.length;++a)i.opsetImport[a]=_.onnx.OperatorSetIdProto.toObject(t.opsetImport[a],o)}if(t.metadataProps&&t.metadataProps.length){i.metadataProps=[];for(var a=0;a<t.metadataProps.length;++a)i.metadataProps[a]=_.onnx.StringStringEntryProto.toObject(t.metadataProps[a],o)}if(t.trainingInfo&&t.trainingInfo.length){i.trainingInfo=[];for(var a=0;a<t.trainingInfo.length;++a)i.trainingInfo[a]=_.onnx.TrainingInfoProto.toObject(t.trainingInfo[a],o)}if(t.functions&&t.functions.length){i.functions=[];for(var a=0;a<t.functions.length;++a)i.functions[a]=_.onnx.FunctionProto.toObject(t.functions[a],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.ModelProto"},e}(),r.StringStringEntryProto=function(){function e(n){if(n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.key="",e.prototype.value="",e.create=function(t){return new e(t)},e.encode=function(t,o){return o||(o=ht.create()),t.key!=null&&Object.hasOwnProperty.call(t,"key")&&o.uint32(10).string(t.key),t.value!=null&&Object.hasOwnProperty.call(t,"value")&&o.uint32(18).string(t.value),o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.StringStringEntryProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.key=t.string();break}case 2:{s.value=t.string();break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){return typeof t!="object"||t===null?"object expected":t.key!=null&&t.hasOwnProperty("key")&&!O.isString(t.key)?"key: string expected":t.value!=null&&t.hasOwnProperty("value")&&!O.isString(t.value)?"value: string expected":null},e.fromObject=function(t){if(t instanceof _.onnx.StringStringEntryProto)return t;var o=new _.onnx.StringStringEntryProto;return t.key!=null&&(o.key=String(t.key)),t.value!=null&&(o.value=String(t.value)),o},e.toObject=function(t,o){o||(o={});var i={};return o.defaults&&(i.key="",i.value=""),t.key!=null&&t.hasOwnProperty("key")&&(i.key=t.key),t.value!=null&&t.hasOwnProperty("value")&&(i.value=t.value),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.StringStringEntryProto"},e}(),r.TensorAnnotation=function(){function e(n){if(this.quantParameterTensorNames=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.tensorName="",e.prototype.quantParameterTensorNames=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.tensorName!=null&&Object.hasOwnProperty.call(t,"tensorName")&&o.uint32(10).string(t.tensorName),t.quantParameterTensorNames!=null&&t.quantParameterTensorNames.length)for(var i=0;i<t.quantParameterTensorNames.length;++i)_.onnx.StringStringEntryProto.encode(t.quantParameterTensorNames[i],o.uint32(18).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.TensorAnnotation;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.tensorName=t.string();break}case 2:{s.quantParameterTensorNames&&s.quantParameterTensorNames.length||(s.quantParameterTensorNames=[]),s.quantParameterTensorNames.push(_.onnx.StringStringEntryProto.decode(t,t.uint32()));break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.tensorName!=null&&t.hasOwnProperty("tensorName")&&!O.isString(t.tensorName))return"tensorName: string expected";if(t.quantParameterTensorNames!=null&&t.hasOwnProperty("quantParameterTensorNames")){if(!Array.isArray(t.quantParameterTensorNames))return"quantParameterTensorNames: array expected";for(var o=0;o<t.quantParameterTensorNames.length;++o){var i=_.onnx.StringStringEntryProto.verify(t.quantParameterTensorNames[o]);if(i)return"quantParameterTensorNames."+i}}return null},e.fromObject=function(t){if(t instanceof _.onnx.TensorAnnotation)return t;var o=new _.onnx.TensorAnnotation;if(t.tensorName!=null&&(o.tensorName=String(t.tensorName)),t.quantParameterTensorNames){if(!Array.isArray(t.quantParameterTensorNames))throw TypeError(".onnx.TensorAnnotation.quantParameterTensorNames: array expected");o.quantParameterTensorNames=[];for(var i=0;i<t.quantParameterTensorNames.length;++i){if(typeof t.quantParameterTensorNames[i]!="object")throw TypeError(".onnx.TensorAnnotation.quantParameterTensorNames: object expected");o.quantParameterTensorNames[i]=_.onnx.StringStringEntryProto.fromObject(t.quantParameterTensorNames[i])}}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.quantParameterTensorNames=[]),o.defaults&&(i.tensorName=""),t.tensorName!=null&&t.hasOwnProperty("tensorName")&&(i.tensorName=t.tensorName),t.quantParameterTensorNames&&t.quantParameterTensorNames.length){i.quantParameterTensorNames=[];for(var s=0;s<t.quantParameterTensorNames.length;++s)i.quantParameterTensorNames[s]=_.onnx.StringStringEntryProto.toObject(t.quantParameterTensorNames[s],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TensorAnnotation"},e}(),r.GraphProto=function(){function e(n){if(this.node=[],this.initializer=[],this.sparseInitializer=[],this.input=[],this.output=[],this.valueInfo=[],this.quantizationAnnotation=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.node=O.emptyArray,e.prototype.name="",e.prototype.initializer=O.emptyArray,e.prototype.sparseInitializer=O.emptyArray,e.prototype.docString="",e.prototype.input=O.emptyArray,e.prototype.output=O.emptyArray,e.prototype.valueInfo=O.emptyArray,e.prototype.quantizationAnnotation=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.node!=null&&t.node.length)for(var i=0;i<t.node.length;++i)_.onnx.NodeProto.encode(t.node[i],o.uint32(10).fork()).ldelim();if(t.name!=null&&Object.hasOwnProperty.call(t,"name")&&o.uint32(18).string(t.name),t.initializer!=null&&t.initializer.length)for(var i=0;i<t.initializer.length;++i)_.onnx.TensorProto.encode(t.initializer[i],o.uint32(42).fork()).ldelim();if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(82).string(t.docString),t.input!=null&&t.input.length)for(var i=0;i<t.input.length;++i)_.onnx.ValueInfoProto.encode(t.input[i],o.uint32(90).fork()).ldelim();if(t.output!=null&&t.output.length)for(var i=0;i<t.output.length;++i)_.onnx.ValueInfoProto.encode(t.output[i],o.uint32(98).fork()).ldelim();if(t.valueInfo!=null&&t.valueInfo.length)for(var i=0;i<t.valueInfo.length;++i)_.onnx.ValueInfoProto.encode(t.valueInfo[i],o.uint32(106).fork()).ldelim();if(t.quantizationAnnotation!=null&&t.quantizationAnnotation.length)for(var i=0;i<t.quantizationAnnotation.length;++i)_.onnx.TensorAnnotation.encode(t.quantizationAnnotation[i],o.uint32(114).fork()).ldelim();if(t.sparseInitializer!=null&&t.sparseInitializer.length)for(var i=0;i<t.sparseInitializer.length;++i)_.onnx.SparseTensorProto.encode(t.sparseInitializer[i],o.uint32(122).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.GraphProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.node&&s.node.length||(s.node=[]),s.node.push(_.onnx.NodeProto.decode(t,t.uint32()));break}case 2:{s.name=t.string();break}case 5:{s.initializer&&s.initializer.length||(s.initializer=[]),s.initializer.push(_.onnx.TensorProto.decode(t,t.uint32()));break}case 15:{s.sparseInitializer&&s.sparseInitializer.length||(s.sparseInitializer=[]),s.sparseInitializer.push(_.onnx.SparseTensorProto.decode(t,t.uint32()));break}case 10:{s.docString=t.string();break}case 11:{s.input&&s.input.length||(s.input=[]),s.input.push(_.onnx.ValueInfoProto.decode(t,t.uint32()));break}case 12:{s.output&&s.output.length||(s.output=[]),s.output.push(_.onnx.ValueInfoProto.decode(t,t.uint32()));break}case 13:{s.valueInfo&&s.valueInfo.length||(s.valueInfo=[]),s.valueInfo.push(_.onnx.ValueInfoProto.decode(t,t.uint32()));break}case 14:{s.quantizationAnnotation&&s.quantizationAnnotation.length||(s.quantizationAnnotation=[]),s.quantizationAnnotation.push(_.onnx.TensorAnnotation.decode(t,t.uint32()));break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.node!=null&&t.hasOwnProperty("node")){if(!Array.isArray(t.node))return"node: array expected";for(var o=0;o<t.node.length;++o){var i=_.onnx.NodeProto.verify(t.node[o]);if(i)return"node."+i}}if(t.name!=null&&t.hasOwnProperty("name")&&!O.isString(t.name))return"name: string expected";if(t.initializer!=null&&t.hasOwnProperty("initializer")){if(!Array.isArray(t.initializer))return"initializer: array expected";for(var o=0;o<t.initializer.length;++o){var i=_.onnx.TensorProto.verify(t.initializer[o]);if(i)return"initializer."+i}}if(t.sparseInitializer!=null&&t.hasOwnProperty("sparseInitializer")){if(!Array.isArray(t.sparseInitializer))return"sparseInitializer: array expected";for(var o=0;o<t.sparseInitializer.length;++o){var i=_.onnx.SparseTensorProto.verify(t.sparseInitializer[o]);if(i)return"sparseInitializer."+i}}if(t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString))return"docString: string expected";if(t.input!=null&&t.hasOwnProperty("input")){if(!Array.isArray(t.input))return"input: array expected";for(var o=0;o<t.input.length;++o){var i=_.onnx.ValueInfoProto.verify(t.input[o]);if(i)return"input."+i}}if(t.output!=null&&t.hasOwnProperty("output")){if(!Array.isArray(t.output))return"output: array expected";for(var o=0;o<t.output.length;++o){var i=_.onnx.ValueInfoProto.verify(t.output[o]);if(i)return"output."+i}}if(t.valueInfo!=null&&t.hasOwnProperty("valueInfo")){if(!Array.isArray(t.valueInfo))return"valueInfo: array expected";for(var o=0;o<t.valueInfo.length;++o){var i=_.onnx.ValueInfoProto.verify(t.valueInfo[o]);if(i)return"valueInfo."+i}}if(t.quantizationAnnotation!=null&&t.hasOwnProperty("quantizationAnnotation")){if(!Array.isArray(t.quantizationAnnotation))return"quantizationAnnotation: array expected";for(var o=0;o<t.quantizationAnnotation.length;++o){var i=_.onnx.TensorAnnotation.verify(t.quantizationAnnotation[o]);if(i)return"quantizationAnnotation."+i}}return null},e.fromObject=function(t){if(t instanceof _.onnx.GraphProto)return t;var o=new _.onnx.GraphProto;if(t.node){if(!Array.isArray(t.node))throw TypeError(".onnx.GraphProto.node: array expected");o.node=[];for(var i=0;i<t.node.length;++i){if(typeof t.node[i]!="object")throw TypeError(".onnx.GraphProto.node: object expected");o.node[i]=_.onnx.NodeProto.fromObject(t.node[i])}}if(t.name!=null&&(o.name=String(t.name)),t.initializer){if(!Array.isArray(t.initializer))throw TypeError(".onnx.GraphProto.initializer: array expected");o.initializer=[];for(var i=0;i<t.initializer.length;++i){if(typeof t.initializer[i]!="object")throw TypeError(".onnx.GraphProto.initializer: object expected");o.initializer[i]=_.onnx.TensorProto.fromObject(t.initializer[i])}}if(t.sparseInitializer){if(!Array.isArray(t.sparseInitializer))throw TypeError(".onnx.GraphProto.sparseInitializer: array expected");o.sparseInitializer=[];for(var i=0;i<t.sparseInitializer.length;++i){if(typeof t.sparseInitializer[i]!="object")throw TypeError(".onnx.GraphProto.sparseInitializer: object expected");o.sparseInitializer[i]=_.onnx.SparseTensorProto.fromObject(t.sparseInitializer[i])}}if(t.docString!=null&&(o.docString=String(t.docString)),t.input){if(!Array.isArray(t.input))throw TypeError(".onnx.GraphProto.input: array expected");o.input=[];for(var i=0;i<t.input.length;++i){if(typeof t.input[i]!="object")throw TypeError(".onnx.GraphProto.input: object expected");o.input[i]=_.onnx.ValueInfoProto.fromObject(t.input[i])}}if(t.output){if(!Array.isArray(t.output))throw TypeError(".onnx.GraphProto.output: array expected");o.output=[];for(var i=0;i<t.output.length;++i){if(typeof t.output[i]!="object")throw TypeError(".onnx.GraphProto.output: object expected");o.output[i]=_.onnx.ValueInfoProto.fromObject(t.output[i])}}if(t.valueInfo){if(!Array.isArray(t.valueInfo))throw TypeError(".onnx.GraphProto.valueInfo: array expected");o.valueInfo=[];for(var i=0;i<t.valueInfo.length;++i){if(typeof t.valueInfo[i]!="object")throw TypeError(".onnx.GraphProto.valueInfo: object expected");o.valueInfo[i]=_.onnx.ValueInfoProto.fromObject(t.valueInfo[i])}}if(t.quantizationAnnotation){if(!Array.isArray(t.quantizationAnnotation))throw TypeError(".onnx.GraphProto.quantizationAnnotation: array expected");o.quantizationAnnotation=[];for(var i=0;i<t.quantizationAnnotation.length;++i){if(typeof t.quantizationAnnotation[i]!="object")throw TypeError(".onnx.GraphProto.quantizationAnnotation: object expected");o.quantizationAnnotation[i]=_.onnx.TensorAnnotation.fromObject(t.quantizationAnnotation[i])}}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.node=[],i.initializer=[],i.input=[],i.output=[],i.valueInfo=[],i.quantizationAnnotation=[],i.sparseInitializer=[]),o.defaults&&(i.name="",i.docString=""),t.node&&t.node.length){i.node=[];for(var s=0;s<t.node.length;++s)i.node[s]=_.onnx.NodeProto.toObject(t.node[s],o)}if(t.name!=null&&t.hasOwnProperty("name")&&(i.name=t.name),t.initializer&&t.initializer.length){i.initializer=[];for(var s=0;s<t.initializer.length;++s)i.initializer[s]=_.onnx.TensorProto.toObject(t.initializer[s],o)}if(t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),t.input&&t.input.length){i.input=[];for(var s=0;s<t.input.length;++s)i.input[s]=_.onnx.ValueInfoProto.toObject(t.input[s],o)}if(t.output&&t.output.length){i.output=[];for(var s=0;s<t.output.length;++s)i.output[s]=_.onnx.ValueInfoProto.toObject(t.output[s],o)}if(t.valueInfo&&t.valueInfo.length){i.valueInfo=[];for(var s=0;s<t.valueInfo.length;++s)i.valueInfo[s]=_.onnx.ValueInfoProto.toObject(t.valueInfo[s],o)}if(t.quantizationAnnotation&&t.quantizationAnnotation.length){i.quantizationAnnotation=[];for(var s=0;s<t.quantizationAnnotation.length;++s)i.quantizationAnnotation[s]=_.onnx.TensorAnnotation.toObject(t.quantizationAnnotation[s],o)}if(t.sparseInitializer&&t.sparseInitializer.length){i.sparseInitializer=[];for(var s=0;s<t.sparseInitializer.length;++s)i.sparseInitializer[s]=_.onnx.SparseTensorProto.toObject(t.sparseInitializer[s],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.GraphProto"},e}(),r.TensorProto=function(){function e(n){if(this.dims=[],this.floatData=[],this.int32Data=[],this.stringData=[],this.int64Data=[],this.externalData=[],this.doubleData=[],this.uint64Data=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.dims=O.emptyArray,e.prototype.dataType=0,e.prototype.segment=null,e.prototype.floatData=O.emptyArray,e.prototype.int32Data=O.emptyArray,e.prototype.stringData=O.emptyArray,e.prototype.int64Data=O.emptyArray,e.prototype.name="",e.prototype.docString="",e.prototype.rawData=O.newBuffer([]),e.prototype.externalData=O.emptyArray,e.prototype.dataLocation=0,e.prototype.doubleData=O.emptyArray,e.prototype.uint64Data=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.dims!=null&&t.dims.length){o.uint32(10).fork();for(var i=0;i<t.dims.length;++i)o.int64(t.dims[i]);o.ldelim()}if(t.dataType!=null&&Object.hasOwnProperty.call(t,"dataType")&&o.uint32(16).int32(t.dataType),t.segment!=null&&Object.hasOwnProperty.call(t,"segment")&&_.onnx.TensorProto.Segment.encode(t.segment,o.uint32(26).fork()).ldelim(),t.floatData!=null&&t.floatData.length){o.uint32(34).fork();for(var i=0;i<t.floatData.length;++i)o.float(t.floatData[i]);o.ldelim()}if(t.int32Data!=null&&t.int32Data.length){o.uint32(42).fork();for(var i=0;i<t.int32Data.length;++i)o.int32(t.int32Data[i]);o.ldelim()}if(t.stringData!=null&&t.stringData.length)for(var i=0;i<t.stringData.length;++i)o.uint32(50).bytes(t.stringData[i]);if(t.int64Data!=null&&t.int64Data.length){o.uint32(58).fork();for(var i=0;i<t.int64Data.length;++i)o.int64(t.int64Data[i]);o.ldelim()}if(t.name!=null&&Object.hasOwnProperty.call(t,"name")&&o.uint32(66).string(t.name),t.rawData!=null&&Object.hasOwnProperty.call(t,"rawData")&&o.uint32(74).bytes(t.rawData),t.doubleData!=null&&t.doubleData.length){o.uint32(82).fork();for(var i=0;i<t.doubleData.length;++i)o.double(t.doubleData[i]);o.ldelim()}if(t.uint64Data!=null&&t.uint64Data.length){o.uint32(90).fork();for(var i=0;i<t.uint64Data.length;++i)o.uint64(t.uint64Data[i]);o.ldelim()}if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(98).string(t.docString),t.externalData!=null&&t.externalData.length)for(var i=0;i<t.externalData.length;++i)_.onnx.StringStringEntryProto.encode(t.externalData[i],o.uint32(106).fork()).ldelim();return t.dataLocation!=null&&Object.hasOwnProperty.call(t,"dataLocation")&&o.uint32(112).int32(t.dataLocation),o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.TensorProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{if(s.dims&&s.dims.length||(s.dims=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.dims.push(t.int64());else s.dims.push(t.int64());break}case 2:{s.dataType=t.int32();break}case 3:{s.segment=_.onnx.TensorProto.Segment.decode(t,t.uint32());break}case 4:{if(s.floatData&&s.floatData.length||(s.floatData=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.floatData.push(t.float());else s.floatData.push(t.float());break}case 5:{if(s.int32Data&&s.int32Data.length||(s.int32Data=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.int32Data.push(t.int32());else s.int32Data.push(t.int32());break}case 6:{s.stringData&&s.stringData.length||(s.stringData=[]),s.stringData.push(t.bytes());break}case 7:{if(s.int64Data&&s.int64Data.length||(s.int64Data=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.int64Data.push(t.int64());else s.int64Data.push(t.int64());break}case 8:{s.name=t.string();break}case 12:{s.docString=t.string();break}case 9:{s.rawData=t.bytes();break}case 13:{s.externalData&&s.externalData.length||(s.externalData=[]),s.externalData.push(_.onnx.StringStringEntryProto.decode(t,t.uint32()));break}case 14:{s.dataLocation=t.int32();break}case 10:{if(s.doubleData&&s.doubleData.length||(s.doubleData=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.doubleData.push(t.double());else s.doubleData.push(t.double());break}case 11:{if(s.uint64Data&&s.uint64Data.length||(s.uint64Data=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.uint64Data.push(t.uint64());else s.uint64Data.push(t.uint64());break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.dims!=null&&t.hasOwnProperty("dims")){if(!Array.isArray(t.dims))return"dims: array expected";for(var o=0;o<t.dims.length;++o)if(!O.isInteger(t.dims[o])&&!(t.dims[o]&&O.isInteger(t.dims[o].low)&&O.isInteger(t.dims[o].high)))return"dims: integer|Long[] expected"}if(t.dataType!=null&&t.hasOwnProperty("dataType")&&!O.isInteger(t.dataType))return"dataType: integer expected";if(t.segment!=null&&t.hasOwnProperty("segment")){var i=_.onnx.TensorProto.Segment.verify(t.segment);if(i)return"segment."+i}if(t.floatData!=null&&t.hasOwnProperty("floatData")){if(!Array.isArray(t.floatData))return"floatData: array expected";for(var o=0;o<t.floatData.length;++o)if(typeof t.floatData[o]!="number")return"floatData: number[] expected"}if(t.int32Data!=null&&t.hasOwnProperty("int32Data")){if(!Array.isArray(t.int32Data))return"int32Data: array expected";for(var o=0;o<t.int32Data.length;++o)if(!O.isInteger(t.int32Data[o]))return"int32Data: integer[] expected"}if(t.stringData!=null&&t.hasOwnProperty("stringData")){if(!Array.isArray(t.stringData))return"stringData: array expected";for(var o=0;o<t.stringData.length;++o)if(!(t.stringData[o]&&typeof t.stringData[o].length=="number"||O.isString(t.stringData[o])))return"stringData: buffer[] expected"}if(t.int64Data!=null&&t.hasOwnProperty("int64Data")){if(!Array.isArray(t.int64Data))return"int64Data: array expected";for(var o=0;o<t.int64Data.length;++o)if(!O.isInteger(t.int64Data[o])&&!(t.int64Data[o]&&O.isInteger(t.int64Data[o].low)&&O.isInteger(t.int64Data[o].high)))return"int64Data: integer|Long[] expected"}if(t.name!=null&&t.hasOwnProperty("name")&&!O.isString(t.name))return"name: string expected";if(t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString))return"docString: string expected";if(t.rawData!=null&&t.hasOwnProperty("rawData")&&!(t.rawData&&typeof t.rawData.length=="number"||O.isString(t.rawData)))return"rawData: buffer expected";if(t.externalData!=null&&t.hasOwnProperty("externalData")){if(!Array.isArray(t.externalData))return"externalData: array expected";for(var o=0;o<t.externalData.length;++o){var i=_.onnx.StringStringEntryProto.verify(t.externalData[o]);if(i)return"externalData."+i}}if(t.dataLocation!=null&&t.hasOwnProperty("dataLocation"))switch(t.dataLocation){default:return"dataLocation: enum value expected";case 0:case 1:break}if(t.doubleData!=null&&t.hasOwnProperty("doubleData")){if(!Array.isArray(t.doubleData))return"doubleData: array expected";for(var o=0;o<t.doubleData.length;++o)if(typeof t.doubleData[o]!="number")return"doubleData: number[] expected"}if(t.uint64Data!=null&&t.hasOwnProperty("uint64Data")){if(!Array.isArray(t.uint64Data))return"uint64Data: array expected";for(var o=0;o<t.uint64Data.length;++o)if(!O.isInteger(t.uint64Data[o])&&!(t.uint64Data[o]&&O.isInteger(t.uint64Data[o].low)&&O.isInteger(t.uint64Data[o].high)))return"uint64Data: integer|Long[] expected"}return null},e.fromObject=function(t){if(t instanceof _.onnx.TensorProto)return t;var o=new _.onnx.TensorProto;if(t.dims){if(!Array.isArray(t.dims))throw TypeError(".onnx.TensorProto.dims: array expected");o.dims=[];for(var i=0;i<t.dims.length;++i)O.Long?(o.dims[i]=O.Long.fromValue(t.dims[i])).unsigned=!1:typeof t.dims[i]=="string"?o.dims[i]=parseInt(t.dims[i],10):typeof t.dims[i]=="number"?o.dims[i]=t.dims[i]:typeof t.dims[i]=="object"&&(o.dims[i]=new O.LongBits(t.dims[i].low>>>0,t.dims[i].high>>>0).toNumber())}if(t.dataType!=null&&(o.dataType=t.dataType|0),t.segment!=null){if(typeof t.segment!="object")throw TypeError(".onnx.TensorProto.segment: object expected");o.segment=_.onnx.TensorProto.Segment.fromObject(t.segment)}if(t.floatData){if(!Array.isArray(t.floatData))throw TypeError(".onnx.TensorProto.floatData: array expected");o.floatData=[];for(var i=0;i<t.floatData.length;++i)o.floatData[i]=Number(t.floatData[i])}if(t.int32Data){if(!Array.isArray(t.int32Data))throw TypeError(".onnx.TensorProto.int32Data: array expected");o.int32Data=[];for(var i=0;i<t.int32Data.length;++i)o.int32Data[i]=t.int32Data[i]|0}if(t.stringData){if(!Array.isArray(t.stringData))throw TypeError(".onnx.TensorProto.stringData: array expected");o.stringData=[];for(var i=0;i<t.stringData.length;++i)typeof t.stringData[i]=="string"?O.base64.decode(t.stringData[i],o.stringData[i]=O.newBuffer(O.base64.length(t.stringData[i])),0):t.stringData[i].length>=0&&(o.stringData[i]=t.stringData[i])}if(t.int64Data){if(!Array.isArray(t.int64Data))throw TypeError(".onnx.TensorProto.int64Data: array expected");o.int64Data=[];for(var i=0;i<t.int64Data.length;++i)O.Long?(o.int64Data[i]=O.Long.fromValue(t.int64Data[i])).unsigned=!1:typeof t.int64Data[i]=="string"?o.int64Data[i]=parseInt(t.int64Data[i],10):typeof t.int64Data[i]=="number"?o.int64Data[i]=t.int64Data[i]:typeof t.int64Data[i]=="object"&&(o.int64Data[i]=new O.LongBits(t.int64Data[i].low>>>0,t.int64Data[i].high>>>0).toNumber())}if(t.name!=null&&(o.name=String(t.name)),t.docString!=null&&(o.docString=String(t.docString)),t.rawData!=null&&(typeof t.rawData=="string"?O.base64.decode(t.rawData,o.rawData=O.newBuffer(O.base64.length(t.rawData)),0):t.rawData.length>=0&&(o.rawData=t.rawData)),t.externalData){if(!Array.isArray(t.externalData))throw TypeError(".onnx.TensorProto.externalData: array expected");o.externalData=[];for(var i=0;i<t.externalData.length;++i){if(typeof t.externalData[i]!="object")throw TypeError(".onnx.TensorProto.externalData: object expected");o.externalData[i]=_.onnx.StringStringEntryProto.fromObject(t.externalData[i])}}switch(t.dataLocation){default:if(typeof t.dataLocation=="number"){o.dataLocation=t.dataLocation;break}break;case"DEFAULT":case 0:o.dataLocation=0;break;case"EXTERNAL":case 1:o.dataLocation=1;break}if(t.doubleData){if(!Array.isArray(t.doubleData))throw TypeError(".onnx.TensorProto.doubleData: array expected");o.doubleData=[];for(var i=0;i<t.doubleData.length;++i)o.doubleData[i]=Number(t.doubleData[i])}if(t.uint64Data){if(!Array.isArray(t.uint64Data))throw TypeError(".onnx.TensorProto.uint64Data: array expected");o.uint64Data=[];for(var i=0;i<t.uint64Data.length;++i)O.Long?(o.uint64Data[i]=O.Long.fromValue(t.uint64Data[i])).unsigned=!0:typeof t.uint64Data[i]=="string"?o.uint64Data[i]=parseInt(t.uint64Data[i],10):typeof t.uint64Data[i]=="number"?o.uint64Data[i]=t.uint64Data[i]:typeof t.uint64Data[i]=="object"&&(o.uint64Data[i]=new O.LongBits(t.uint64Data[i].low>>>0,t.uint64Data[i].high>>>0).toNumber(!0))}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.dims=[],i.floatData=[],i.int32Data=[],i.stringData=[],i.int64Data=[],i.doubleData=[],i.uint64Data=[],i.externalData=[]),o.defaults&&(i.dataType=0,i.segment=null,i.name="",o.bytes===String?i.rawData="":(i.rawData=[],o.bytes!==Array&&(i.rawData=O.newBuffer(i.rawData))),i.docString="",i.dataLocation=o.enums===String?"DEFAULT":0),t.dims&&t.dims.length){i.dims=[];for(var s=0;s<t.dims.length;++s)typeof t.dims[s]=="number"?i.dims[s]=o.longs===String?String(t.dims[s]):t.dims[s]:i.dims[s]=o.longs===String?O.Long.prototype.toString.call(t.dims[s]):o.longs===Number?new O.LongBits(t.dims[s].low>>>0,t.dims[s].high>>>0).toNumber():t.dims[s]}if(t.dataType!=null&&t.hasOwnProperty("dataType")&&(i.dataType=t.dataType),t.segment!=null&&t.hasOwnProperty("segment")&&(i.segment=_.onnx.TensorProto.Segment.toObject(t.segment,o)),t.floatData&&t.floatData.length){i.floatData=[];for(var s=0;s<t.floatData.length;++s)i.floatData[s]=o.json&&!isFinite(t.floatData[s])?String(t.floatData[s]):t.floatData[s]}if(t.int32Data&&t.int32Data.length){i.int32Data=[];for(var s=0;s<t.int32Data.length;++s)i.int32Data[s]=t.int32Data[s]}if(t.stringData&&t.stringData.length){i.stringData=[];for(var s=0;s<t.stringData.length;++s)i.stringData[s]=o.bytes===String?O.base64.encode(t.stringData[s],0,t.stringData[s].length):o.bytes===Array?Array.prototype.slice.call(t.stringData[s]):t.stringData[s]}if(t.int64Data&&t.int64Data.length){i.int64Data=[];for(var s=0;s<t.int64Data.length;++s)typeof t.int64Data[s]=="number"?i.int64Data[s]=o.longs===String?String(t.int64Data[s]):t.int64Data[s]:i.int64Data[s]=o.longs===String?O.Long.prototype.toString.call(t.int64Data[s]):o.longs===Number?new O.LongBits(t.int64Data[s].low>>>0,t.int64Data[s].high>>>0).toNumber():t.int64Data[s]}if(t.name!=null&&t.hasOwnProperty("name")&&(i.name=t.name),t.rawData!=null&&t.hasOwnProperty("rawData")&&(i.rawData=o.bytes===String?O.base64.encode(t.rawData,0,t.rawData.length):o.bytes===Array?Array.prototype.slice.call(t.rawData):t.rawData),t.doubleData&&t.doubleData.length){i.doubleData=[];for(var s=0;s<t.doubleData.length;++s)i.doubleData[s]=o.json&&!isFinite(t.doubleData[s])?String(t.doubleData[s]):t.doubleData[s]}if(t.uint64Data&&t.uint64Data.length){i.uint64Data=[];for(var s=0;s<t.uint64Data.length;++s)typeof t.uint64Data[s]=="number"?i.uint64Data[s]=o.longs===String?String(t.uint64Data[s]):t.uint64Data[s]:i.uint64Data[s]=o.longs===String?O.Long.prototype.toString.call(t.uint64Data[s]):o.longs===Number?new O.LongBits(t.uint64Data[s].low>>>0,t.uint64Data[s].high>>>0).toNumber(!0):t.uint64Data[s]}if(t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),t.externalData&&t.externalData.length){i.externalData=[];for(var s=0;s<t.externalData.length;++s)i.externalData[s]=_.onnx.StringStringEntryProto.toObject(t.externalData[s],o)}return t.dataLocation!=null&&t.hasOwnProperty("dataLocation")&&(i.dataLocation=o.enums===String?_.onnx.TensorProto.DataLocation[t.dataLocation]===void 0?t.dataLocation:_.onnx.TensorProto.DataLocation[t.dataLocation]:t.dataLocation),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TensorProto"},e.DataType=function(){var n={},t=Object.create(n);return t[n[0]="UNDEFINED"]=0,t[n[1]="FLOAT"]=1,t[n[2]="UINT8"]=2,t[n[3]="INT8"]=3,t[n[4]="UINT16"]=4,t[n[5]="INT16"]=5,t[n[6]="INT32"]=6,t[n[7]="INT64"]=7,t[n[8]="STRING"]=8,t[n[9]="BOOL"]=9,t[n[10]="FLOAT16"]=10,t[n[11]="DOUBLE"]=11,t[n[12]="UINT32"]=12,t[n[13]="UINT64"]=13,t[n[14]="COMPLEX64"]=14,t[n[15]="COMPLEX128"]=15,t[n[16]="BFLOAT16"]=16,t[n[17]="FLOAT8E4M3FN"]=17,t[n[18]="FLOAT8E4M3FNUZ"]=18,t[n[19]="FLOAT8E5M2"]=19,t[n[20]="FLOAT8E5M2FNUZ"]=20,t}(),e.Segment=function(){function n(t){if(t)for(var o=Object.keys(t),i=0;i<o.length;++i)t[o[i]]!=null&&(this[o[i]]=t[o[i]])}return n.prototype.begin=O.Long?O.Long.fromBits(0,0,!1):0,n.prototype.end=O.Long?O.Long.fromBits(0,0,!1):0,n.create=function(o){return new n(o)},n.encode=function(o,i){return i||(i=ht.create()),o.begin!=null&&Object.hasOwnProperty.call(o,"begin")&&i.uint32(8).int64(o.begin),o.end!=null&&Object.hasOwnProperty.call(o,"end")&&i.uint32(16).int64(o.end),i},n.encodeDelimited=function(o,i){return this.encode(o,i).ldelim()},n.decode=function(o,i){o instanceof Z||(o=Z.create(o));for(var s=i===void 0?o.len:o.pos+i,a=new _.onnx.TensorProto.Segment;o.pos<s;){var u=o.uint32();switch(u>>>3){case 1:{a.begin=o.int64();break}case 2:{a.end=o.int64();break}default:o.skipType(u&7);break}}return a},n.decodeDelimited=function(o){return o instanceof Z||(o=new Z(o)),this.decode(o,o.uint32())},n.verify=function(o){return typeof o!="object"||o===null?"object expected":o.begin!=null&&o.hasOwnProperty("begin")&&!O.isInteger(o.begin)&&!(o.begin&&O.isInteger(o.begin.low)&&O.isInteger(o.begin.high))?"begin: integer|Long expected":o.end!=null&&o.hasOwnProperty("end")&&!O.isInteger(o.end)&&!(o.end&&O.isInteger(o.end.low)&&O.isInteger(o.end.high))?"end: integer|Long expected":null},n.fromObject=function(o){if(o instanceof _.onnx.TensorProto.Segment)return o;var i=new _.onnx.TensorProto.Segment;return o.begin!=null&&(O.Long?(i.begin=O.Long.fromValue(o.begin)).unsigned=!1:typeof o.begin=="string"?i.begin=parseInt(o.begin,10):typeof o.begin=="number"?i.begin=o.begin:typeof o.begin=="object"&&(i.begin=new O.LongBits(o.begin.low>>>0,o.begin.high>>>0).toNumber())),o.end!=null&&(O.Long?(i.end=O.Long.fromValue(o.end)).unsigned=!1:typeof o.end=="string"?i.end=parseInt(o.end,10):typeof o.end=="number"?i.end=o.end:typeof o.end=="object"&&(i.end=new O.LongBits(o.end.low>>>0,o.end.high>>>0).toNumber())),i},n.toObject=function(o,i){i||(i={});var s={};if(i.defaults){if(O.Long){var a=new O.Long(0,0,!1);s.begin=i.longs===String?a.toString():i.longs===Number?a.toNumber():a}else s.begin=i.longs===String?"0":0;if(O.Long){var a=new O.Long(0,0,!1);s.end=i.longs===String?a.toString():i.longs===Number?a.toNumber():a}else s.end=i.longs===String?"0":0}return o.begin!=null&&o.hasOwnProperty("begin")&&(typeof o.begin=="number"?s.begin=i.longs===String?String(o.begin):o.begin:s.begin=i.longs===String?O.Long.prototype.toString.call(o.begin):i.longs===Number?new O.LongBits(o.begin.low>>>0,o.begin.high>>>0).toNumber():o.begin),o.end!=null&&o.hasOwnProperty("end")&&(typeof o.end=="number"?s.end=i.longs===String?String(o.end):o.end:s.end=i.longs===String?O.Long.prototype.toString.call(o.end):i.longs===Number?new O.LongBits(o.end.low>>>0,o.end.high>>>0).toNumber():o.end),s},n.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},n.getTypeUrl=function(o){return o===void 0&&(o="type.googleapis.com"),o+"/onnx.TensorProto.Segment"},n}(),e.DataLocation=function(){var n={},t=Object.create(n);return t[n[0]="DEFAULT"]=0,t[n[1]="EXTERNAL"]=1,t}(),e}(),r.SparseTensorProto=function(){function e(n){if(this.dims=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.values=null,e.prototype.indices=null,e.prototype.dims=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.values!=null&&Object.hasOwnProperty.call(t,"values")&&_.onnx.TensorProto.encode(t.values,o.uint32(10).fork()).ldelim(),t.indices!=null&&Object.hasOwnProperty.call(t,"indices")&&_.onnx.TensorProto.encode(t.indices,o.uint32(18).fork()).ldelim(),t.dims!=null&&t.dims.length){o.uint32(26).fork();for(var i=0;i<t.dims.length;++i)o.int64(t.dims[i]);o.ldelim()}return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.SparseTensorProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.values=_.onnx.TensorProto.decode(t,t.uint32());break}case 2:{s.indices=_.onnx.TensorProto.decode(t,t.uint32());break}case 3:{if(s.dims&&s.dims.length||(s.dims=[]),(a&7)===2)for(var u=t.uint32()+t.pos;t.pos<u;)s.dims.push(t.int64());else s.dims.push(t.int64());break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.values!=null&&t.hasOwnProperty("values")){var o=_.onnx.TensorProto.verify(t.values);if(o)return"values."+o}if(t.indices!=null&&t.hasOwnProperty("indices")){var o=_.onnx.TensorProto.verify(t.indices);if(o)return"indices."+o}if(t.dims!=null&&t.hasOwnProperty("dims")){if(!Array.isArray(t.dims))return"dims: array expected";for(var i=0;i<t.dims.length;++i)if(!O.isInteger(t.dims[i])&&!(t.dims[i]&&O.isInteger(t.dims[i].low)&&O.isInteger(t.dims[i].high)))return"dims: integer|Long[] expected"}return null},e.fromObject=function(t){if(t instanceof _.onnx.SparseTensorProto)return t;var o=new _.onnx.SparseTensorProto;if(t.values!=null){if(typeof t.values!="object")throw TypeError(".onnx.SparseTensorProto.values: object expected");o.values=_.onnx.TensorProto.fromObject(t.values)}if(t.indices!=null){if(typeof t.indices!="object")throw TypeError(".onnx.SparseTensorProto.indices: object expected");o.indices=_.onnx.TensorProto.fromObject(t.indices)}if(t.dims){if(!Array.isArray(t.dims))throw TypeError(".onnx.SparseTensorProto.dims: array expected");o.dims=[];for(var i=0;i<t.dims.length;++i)O.Long?(o.dims[i]=O.Long.fromValue(t.dims[i])).unsigned=!1:typeof t.dims[i]=="string"?o.dims[i]=parseInt(t.dims[i],10):typeof t.dims[i]=="number"?o.dims[i]=t.dims[i]:typeof t.dims[i]=="object"&&(o.dims[i]=new O.LongBits(t.dims[i].low>>>0,t.dims[i].high>>>0).toNumber())}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.dims=[]),o.defaults&&(i.values=null,i.indices=null),t.values!=null&&t.hasOwnProperty("values")&&(i.values=_.onnx.TensorProto.toObject(t.values,o)),t.indices!=null&&t.hasOwnProperty("indices")&&(i.indices=_.onnx.TensorProto.toObject(t.indices,o)),t.dims&&t.dims.length){i.dims=[];for(var s=0;s<t.dims.length;++s)typeof t.dims[s]=="number"?i.dims[s]=o.longs===String?String(t.dims[s]):t.dims[s]:i.dims[s]=o.longs===String?O.Long.prototype.toString.call(t.dims[s]):o.longs===Number?new O.LongBits(t.dims[s].low>>>0,t.dims[s].high>>>0).toNumber():t.dims[s]}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.SparseTensorProto"},e}(),r.TensorShapeProto=function(){function e(n){if(this.dim=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.dim=O.emptyArray,e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.dim!=null&&t.dim.length)for(var i=0;i<t.dim.length;++i)_.onnx.TensorShapeProto.Dimension.encode(t.dim[i],o.uint32(10).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.TensorShapeProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.dim&&s.dim.length||(s.dim=[]),s.dim.push(_.onnx.TensorShapeProto.Dimension.decode(t,t.uint32()));break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.dim!=null&&t.hasOwnProperty("dim")){if(!Array.isArray(t.dim))return"dim: array expected";for(var o=0;o<t.dim.length;++o){var i=_.onnx.TensorShapeProto.Dimension.verify(t.dim[o]);if(i)return"dim."+i}}return null},e.fromObject=function(t){if(t instanceof _.onnx.TensorShapeProto)return t;var o=new _.onnx.TensorShapeProto;if(t.dim){if(!Array.isArray(t.dim))throw TypeError(".onnx.TensorShapeProto.dim: array expected");o.dim=[];for(var i=0;i<t.dim.length;++i){if(typeof t.dim[i]!="object")throw TypeError(".onnx.TensorShapeProto.dim: object expected");o.dim[i]=_.onnx.TensorShapeProto.Dimension.fromObject(t.dim[i])}}return o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.dim=[]),t.dim&&t.dim.length){i.dim=[];for(var s=0;s<t.dim.length;++s)i.dim[s]=_.onnx.TensorShapeProto.Dimension.toObject(t.dim[s],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.TensorShapeProto"},e.Dimension=function(){function n(o){if(o)for(var i=Object.keys(o),s=0;s<i.length;++s)o[i[s]]!=null&&(this[i[s]]=o[i[s]])}n.prototype.dimValue=null,n.prototype.dimParam=null,n.prototype.denotation="";var t;return Object.defineProperty(n.prototype,"value",{get:O.oneOfGetter(t=["dimValue","dimParam"]),set:O.oneOfSetter(t)}),n.create=function(i){return new n(i)},n.encode=function(i,s){return s||(s=ht.create()),i.dimValue!=null&&Object.hasOwnProperty.call(i,"dimValue")&&s.uint32(8).int64(i.dimValue),i.dimParam!=null&&Object.hasOwnProperty.call(i,"dimParam")&&s.uint32(18).string(i.dimParam),i.denotation!=null&&Object.hasOwnProperty.call(i,"denotation")&&s.uint32(26).string(i.denotation),s},n.encodeDelimited=function(i,s){return this.encode(i,s).ldelim()},n.decode=function(i,s){i instanceof Z||(i=Z.create(i));for(var a=s===void 0?i.len:i.pos+s,u=new _.onnx.TensorShapeProto.Dimension;i.pos<a;){var l=i.uint32();switch(l>>>3){case 1:{u.dimValue=i.int64();break}case 2:{u.dimParam=i.string();break}case 3:{u.denotation=i.string();break}default:i.skipType(l&7);break}}return u},n.decodeDelimited=function(i){return i instanceof Z||(i=new Z(i)),this.decode(i,i.uint32())},n.verify=function(i){if(typeof i!="object"||i===null)return"object expected";var s={};if(i.dimValue!=null&&i.hasOwnProperty("dimValue")&&(s.value=1,!O.isInteger(i.dimValue)&&!(i.dimValue&&O.isInteger(i.dimValue.low)&&O.isInteger(i.dimValue.high))))return"dimValue: integer|Long expected";if(i.dimParam!=null&&i.hasOwnProperty("dimParam")){if(s.value===1)return"value: multiple values";if(s.value=1,!O.isString(i.dimParam))return"dimParam: string expected"}return i.denotation!=null&&i.hasOwnProperty("denotation")&&!O.isString(i.denotation)?"denotation: string expected":null},n.fromObject=function(i){if(i instanceof _.onnx.TensorShapeProto.Dimension)return i;var s=new _.onnx.TensorShapeProto.Dimension;return i.dimValue!=null&&(O.Long?(s.dimValue=O.Long.fromValue(i.dimValue)).unsigned=!1:typeof i.dimValue=="string"?s.dimValue=parseInt(i.dimValue,10):typeof i.dimValue=="number"?s.dimValue=i.dimValue:typeof i.dimValue=="object"&&(s.dimValue=new O.LongBits(i.dimValue.low>>>0,i.dimValue.high>>>0).toNumber())),i.dimParam!=null&&(s.dimParam=String(i.dimParam)),i.denotation!=null&&(s.denotation=String(i.denotation)),s},n.toObject=function(i,s){s||(s={});var a={};return s.defaults&&(a.denotation=""),i.dimValue!=null&&i.hasOwnProperty("dimValue")&&(typeof i.dimValue=="number"?a.dimValue=s.longs===String?String(i.dimValue):i.dimValue:a.dimValue=s.longs===String?O.Long.prototype.toString.call(i.dimValue):s.longs===Number?new O.LongBits(i.dimValue.low>>>0,i.dimValue.high>>>0).toNumber():i.dimValue,s.oneofs&&(a.value="dimValue")),i.dimParam!=null&&i.hasOwnProperty("dimParam")&&(a.dimParam=i.dimParam,s.oneofs&&(a.value="dimParam")),i.denotation!=null&&i.hasOwnProperty("denotation")&&(a.denotation=i.denotation),a},n.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},n.getTypeUrl=function(i){return i===void 0&&(i="type.googleapis.com"),i+"/onnx.TensorShapeProto.Dimension"},n}(),e}(),r.TypeProto=function(){function e(t){if(t)for(var o=Object.keys(t),i=0;i<o.length;++i)t[o[i]]!=null&&(this[o[i]]=t[o[i]])}e.prototype.tensorType=null,e.prototype.sequenceType=null,e.prototype.mapType=null,e.prototype.optionalType=null,e.prototype.sparseTensorType=null,e.prototype.denotation="";var n;return Object.defineProperty(e.prototype,"value",{get:O.oneOfGetter(n=["tensorType","sequenceType","mapType","optionalType","sparseTensorType"]),set:O.oneOfSetter(n)}),e.create=function(o){return new e(o)},e.encode=function(o,i){return i||(i=ht.create()),o.tensorType!=null&&Object.hasOwnProperty.call(o,"tensorType")&&_.onnx.TypeProto.Tensor.encode(o.tensorType,i.uint32(10).fork()).ldelim(),o.sequenceType!=null&&Object.hasOwnProperty.call(o,"sequenceType")&&_.onnx.TypeProto.Sequence.encode(o.sequenceType,i.uint32(34).fork()).ldelim(),o.mapType!=null&&Object.hasOwnProperty.call(o,"mapType")&&_.onnx.TypeProto.Map.encode(o.mapType,i.uint32(42).fork()).ldelim(),o.denotation!=null&&Object.hasOwnProperty.call(o,"denotation")&&i.uint32(50).string(o.denotation),o.sparseTensorType!=null&&Object.hasOwnProperty.call(o,"sparseTensorType")&&_.onnx.TypeProto.SparseTensor.encode(o.sparseTensorType,i.uint32(66).fork()).ldelim(),o.optionalType!=null&&Object.hasOwnProperty.call(o,"optionalType")&&_.onnx.TypeProto.Optional.encode(o.optionalType,i.uint32(74).fork()).ldelim(),i},e.encodeDelimited=function(o,i){return this.encode(o,i).ldelim()},e.decode=function(o,i){o instanceof Z||(o=Z.create(o));for(var s=i===void 0?o.len:o.pos+i,a=new _.onnx.TypeProto;o.pos<s;){var u=o.uint32();switch(u>>>3){case 1:{a.tensorType=_.onnx.TypeProto.Tensor.decode(o,o.uint32());break}case 4:{a.sequenceType=_.onnx.TypeProto.Sequence.decode(o,o.uint32());break}case 5:{a.mapType=_.onnx.TypeProto.Map.decode(o,o.uint32());break}case 9:{a.optionalType=_.onnx.TypeProto.Optional.decode(o,o.uint32());break}case 8:{a.sparseTensorType=_.onnx.TypeProto.SparseTensor.decode(o,o.uint32());break}case 6:{a.denotation=o.string();break}default:o.skipType(u&7);break}}return a},e.decodeDelimited=function(o){return o instanceof Z||(o=new Z(o)),this.decode(o,o.uint32())},e.verify=function(o){if(typeof o!="object"||o===null)return"object expected";var i={};if(o.tensorType!=null&&o.hasOwnProperty("tensorType")){i.value=1;{var s=_.onnx.TypeProto.Tensor.verify(o.tensorType);if(s)return"tensorType."+s}}if(o.sequenceType!=null&&o.hasOwnProperty("sequenceType")){if(i.value===1)return"value: multiple values";i.value=1;{var s=_.onnx.TypeProto.Sequence.verify(o.sequenceType);if(s)return"sequenceType."+s}}if(o.mapType!=null&&o.hasOwnProperty("mapType")){if(i.value===1)return"value: multiple values";i.value=1;{var s=_.onnx.TypeProto.Map.verify(o.mapType);if(s)return"mapType."+s}}if(o.optionalType!=null&&o.hasOwnProperty("optionalType")){if(i.value===1)return"value: multiple values";i.value=1;{var s=_.onnx.TypeProto.Optional.verify(o.optionalType);if(s)return"optionalType."+s}}if(o.sparseTensorType!=null&&o.hasOwnProperty("sparseTensorType")){if(i.value===1)return"value: multiple values";i.value=1;{var s=_.onnx.TypeProto.SparseTensor.verify(o.sparseTensorType);if(s)return"sparseTensorType."+s}}return o.denotation!=null&&o.hasOwnProperty("denotation")&&!O.isString(o.denotation)?"denotation: string expected":null},e.fromObject=function(o){if(o instanceof _.onnx.TypeProto)return o;var i=new _.onnx.TypeProto;if(o.tensorType!=null){if(typeof o.tensorType!="object")throw TypeError(".onnx.TypeProto.tensorType: object expected");i.tensorType=_.onnx.TypeProto.Tensor.fromObject(o.tensorType)}if(o.sequenceType!=null){if(typeof o.sequenceType!="object")throw TypeError(".onnx.TypeProto.sequenceType: object expected");i.sequenceType=_.onnx.TypeProto.Sequence.fromObject(o.sequenceType)}if(o.mapType!=null){if(typeof o.mapType!="object")throw TypeError(".onnx.TypeProto.mapType: object expected");i.mapType=_.onnx.TypeProto.Map.fromObject(o.mapType)}if(o.optionalType!=null){if(typeof o.optionalType!="object")throw TypeError(".onnx.TypeProto.optionalType: object expected");i.optionalType=_.onnx.TypeProto.Optional.fromObject(o.optionalType)}if(o.sparseTensorType!=null){if(typeof o.sparseTensorType!="object")throw TypeError(".onnx.TypeProto.sparseTensorType: object expected");i.sparseTensorType=_.onnx.TypeProto.SparseTensor.fromObject(o.sparseTensorType)}return o.denotation!=null&&(i.denotation=String(o.denotation)),i},e.toObject=function(o,i){i||(i={});var s={};return i.defaults&&(s.denotation=""),o.tensorType!=null&&o.hasOwnProperty("tensorType")&&(s.tensorType=_.onnx.TypeProto.Tensor.toObject(o.tensorType,i),i.oneofs&&(s.value="tensorType")),o.sequenceType!=null&&o.hasOwnProperty("sequenceType")&&(s.sequenceType=_.onnx.TypeProto.Sequence.toObject(o.sequenceType,i),i.oneofs&&(s.value="sequenceType")),o.mapType!=null&&o.hasOwnProperty("mapType")&&(s.mapType=_.onnx.TypeProto.Map.toObject(o.mapType,i),i.oneofs&&(s.value="mapType")),o.denotation!=null&&o.hasOwnProperty("denotation")&&(s.denotation=o.denotation),o.sparseTensorType!=null&&o.hasOwnProperty("sparseTensorType")&&(s.sparseTensorType=_.onnx.TypeProto.SparseTensor.toObject(o.sparseTensorType,i),i.oneofs&&(s.value="sparseTensorType")),o.optionalType!=null&&o.hasOwnProperty("optionalType")&&(s.optionalType=_.onnx.TypeProto.Optional.toObject(o.optionalType,i),i.oneofs&&(s.value="optionalType")),s},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(o){return o===void 0&&(o="type.googleapis.com"),o+"/onnx.TypeProto"},e.Tensor=function(){function t(o){if(o)for(var i=Object.keys(o),s=0;s<i.length;++s)o[i[s]]!=null&&(this[i[s]]=o[i[s]])}return t.prototype.elemType=0,t.prototype.shape=null,t.create=function(i){return new t(i)},t.encode=function(i,s){return s||(s=ht.create()),i.elemType!=null&&Object.hasOwnProperty.call(i,"elemType")&&s.uint32(8).int32(i.elemType),i.shape!=null&&Object.hasOwnProperty.call(i,"shape")&&_.onnx.TensorShapeProto.encode(i.shape,s.uint32(18).fork()).ldelim(),s},t.encodeDelimited=function(i,s){return this.encode(i,s).ldelim()},t.decode=function(i,s){i instanceof Z||(i=Z.create(i));for(var a=s===void 0?i.len:i.pos+s,u=new _.onnx.TypeProto.Tensor;i.pos<a;){var l=i.uint32();switch(l>>>3){case 1:{u.elemType=i.int32();break}case 2:{u.shape=_.onnx.TensorShapeProto.decode(i,i.uint32());break}default:i.skipType(l&7);break}}return u},t.decodeDelimited=function(i){return i instanceof Z||(i=new Z(i)),this.decode(i,i.uint32())},t.verify=function(i){if(typeof i!="object"||i===null)return"object expected";if(i.elemType!=null&&i.hasOwnProperty("elemType")&&!O.isInteger(i.elemType))return"elemType: integer expected";if(i.shape!=null&&i.hasOwnProperty("shape")){var s=_.onnx.TensorShapeProto.verify(i.shape);if(s)return"shape."+s}return null},t.fromObject=function(i){if(i instanceof _.onnx.TypeProto.Tensor)return i;var s=new _.onnx.TypeProto.Tensor;if(i.elemType!=null&&(s.elemType=i.elemType|0),i.shape!=null){if(typeof i.shape!="object")throw TypeError(".onnx.TypeProto.Tensor.shape: object expected");s.shape=_.onnx.TensorShapeProto.fromObject(i.shape)}return s},t.toObject=function(i,s){s||(s={});var a={};return s.defaults&&(a.elemType=0,a.shape=null),i.elemType!=null&&i.hasOwnProperty("elemType")&&(a.elemType=i.elemType),i.shape!=null&&i.hasOwnProperty("shape")&&(a.shape=_.onnx.TensorShapeProto.toObject(i.shape,s)),a},t.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},t.getTypeUrl=function(i){return i===void 0&&(i="type.googleapis.com"),i+"/onnx.TypeProto.Tensor"},t}(),e.Sequence=function(){function t(o){if(o)for(var i=Object.keys(o),s=0;s<i.length;++s)o[i[s]]!=null&&(this[i[s]]=o[i[s]])}return t.prototype.elemType=null,t.create=function(i){return new t(i)},t.encode=function(i,s){return s||(s=ht.create()),i.elemType!=null&&Object.hasOwnProperty.call(i,"elemType")&&_.onnx.TypeProto.encode(i.elemType,s.uint32(10).fork()).ldelim(),s},t.encodeDelimited=function(i,s){return this.encode(i,s).ldelim()},t.decode=function(i,s){i instanceof Z||(i=Z.create(i));for(var a=s===void 0?i.len:i.pos+s,u=new _.onnx.TypeProto.Sequence;i.pos<a;){var l=i.uint32();switch(l>>>3){case 1:{u.elemType=_.onnx.TypeProto.decode(i,i.uint32());break}default:i.skipType(l&7);break}}return u},t.decodeDelimited=function(i){return i instanceof Z||(i=new Z(i)),this.decode(i,i.uint32())},t.verify=function(i){if(typeof i!="object"||i===null)return"object expected";if(i.elemType!=null&&i.hasOwnProperty("elemType")){var s=_.onnx.TypeProto.verify(i.elemType);if(s)return"elemType."+s}return null},t.fromObject=function(i){if(i instanceof _.onnx.TypeProto.Sequence)return i;var s=new _.onnx.TypeProto.Sequence;if(i.elemType!=null){if(typeof i.elemType!="object")throw TypeError(".onnx.TypeProto.Sequence.elemType: object expected");s.elemType=_.onnx.TypeProto.fromObject(i.elemType)}return s},t.toObject=function(i,s){s||(s={});var a={};return s.defaults&&(a.elemType=null),i.elemType!=null&&i.hasOwnProperty("elemType")&&(a.elemType=_.onnx.TypeProto.toObject(i.elemType,s)),a},t.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},t.getTypeUrl=function(i){return i===void 0&&(i="type.googleapis.com"),i+"/onnx.TypeProto.Sequence"},t}(),e.Map=function(){function t(o){if(o)for(var i=Object.keys(o),s=0;s<i.length;++s)o[i[s]]!=null&&(this[i[s]]=o[i[s]])}return t.prototype.keyType=0,t.prototype.valueType=null,t.create=function(i){return new t(i)},t.encode=function(i,s){return s||(s=ht.create()),i.keyType!=null&&Object.hasOwnProperty.call(i,"keyType")&&s.uint32(8).int32(i.keyType),i.valueType!=null&&Object.hasOwnProperty.call(i,"valueType")&&_.onnx.TypeProto.encode(i.valueType,s.uint32(18).fork()).ldelim(),s},t.encodeDelimited=function(i,s){return this.encode(i,s).ldelim()},t.decode=function(i,s){i instanceof Z||(i=Z.create(i));for(var a=s===void 0?i.len:i.pos+s,u=new _.onnx.TypeProto.Map;i.pos<a;){var l=i.uint32();switch(l>>>3){case 1:{u.keyType=i.int32();break}case 2:{u.valueType=_.onnx.TypeProto.decode(i,i.uint32());break}default:i.skipType(l&7);break}}return u},t.decodeDelimited=function(i){return i instanceof Z||(i=new Z(i)),this.decode(i,i.uint32())},t.verify=function(i){if(typeof i!="object"||i===null)return"object expected";if(i.keyType!=null&&i.hasOwnProperty("keyType")&&!O.isInteger(i.keyType))return"keyType: integer expected";if(i.valueType!=null&&i.hasOwnProperty("valueType")){var s=_.onnx.TypeProto.verify(i.valueType);if(s)return"valueType."+s}return null},t.fromObject=function(i){if(i instanceof _.onnx.TypeProto.Map)return i;var s=new _.onnx.TypeProto.Map;if(i.keyType!=null&&(s.keyType=i.keyType|0),i.valueType!=null){if(typeof i.valueType!="object")throw TypeError(".onnx.TypeProto.Map.valueType: object expected");s.valueType=_.onnx.TypeProto.fromObject(i.valueType)}return s},t.toObject=function(i,s){s||(s={});var a={};return s.defaults&&(a.keyType=0,a.valueType=null),i.keyType!=null&&i.hasOwnProperty("keyType")&&(a.keyType=i.keyType),i.valueType!=null&&i.hasOwnProperty("valueType")&&(a.valueType=_.onnx.TypeProto.toObject(i.valueType,s)),a},t.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},t.getTypeUrl=function(i){return i===void 0&&(i="type.googleapis.com"),i+"/onnx.TypeProto.Map"},t}(),e.Optional=function(){function t(o){if(o)for(var i=Object.keys(o),s=0;s<i.length;++s)o[i[s]]!=null&&(this[i[s]]=o[i[s]])}return t.prototype.elemType=null,t.create=function(i){return new t(i)},t.encode=function(i,s){return s||(s=ht.create()),i.elemType!=null&&Object.hasOwnProperty.call(i,"elemType")&&_.onnx.TypeProto.encode(i.elemType,s.uint32(10).fork()).ldelim(),s},t.encodeDelimited=function(i,s){return this.encode(i,s).ldelim()},t.decode=function(i,s){i instanceof Z||(i=Z.create(i));for(var a=s===void 0?i.len:i.pos+s,u=new _.onnx.TypeProto.Optional;i.pos<a;){var l=i.uint32();switch(l>>>3){case 1:{u.elemType=_.onnx.TypeProto.decode(i,i.uint32());break}default:i.skipType(l&7);break}}return u},t.decodeDelimited=function(i){return i instanceof Z||(i=new Z(i)),this.decode(i,i.uint32())},t.verify=function(i){if(typeof i!="object"||i===null)return"object expected";if(i.elemType!=null&&i.hasOwnProperty("elemType")){var s=_.onnx.TypeProto.verify(i.elemType);if(s)return"elemType."+s}return null},t.fromObject=function(i){if(i instanceof _.onnx.TypeProto.Optional)return i;var s=new _.onnx.TypeProto.Optional;if(i.elemType!=null){if(typeof i.elemType!="object")throw TypeError(".onnx.TypeProto.Optional.elemType: object expected");s.elemType=_.onnx.TypeProto.fromObject(i.elemType)}return s},t.toObject=function(i,s){s||(s={});var a={};return s.defaults&&(a.elemType=null),i.elemType!=null&&i.hasOwnProperty("elemType")&&(a.elemType=_.onnx.TypeProto.toObject(i.elemType,s)),a},t.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},t.getTypeUrl=function(i){return i===void 0&&(i="type.googleapis.com"),i+"/onnx.TypeProto.Optional"},t}(),e.SparseTensor=function(){function t(o){if(o)for(var i=Object.keys(o),s=0;s<i.length;++s)o[i[s]]!=null&&(this[i[s]]=o[i[s]])}return t.prototype.elemType=0,t.prototype.shape=null,t.create=function(i){return new t(i)},t.encode=function(i,s){return s||(s=ht.create()),i.elemType!=null&&Object.hasOwnProperty.call(i,"elemType")&&s.uint32(8).int32(i.elemType),i.shape!=null&&Object.hasOwnProperty.call(i,"shape")&&_.onnx.TensorShapeProto.encode(i.shape,s.uint32(18).fork()).ldelim(),s},t.encodeDelimited=function(i,s){return this.encode(i,s).ldelim()},t.decode=function(i,s){i instanceof Z||(i=Z.create(i));for(var a=s===void 0?i.len:i.pos+s,u=new _.onnx.TypeProto.SparseTensor;i.pos<a;){var l=i.uint32();switch(l>>>3){case 1:{u.elemType=i.int32();break}case 2:{u.shape=_.onnx.TensorShapeProto.decode(i,i.uint32());break}default:i.skipType(l&7);break}}return u},t.decodeDelimited=function(i){return i instanceof Z||(i=new Z(i)),this.decode(i,i.uint32())},t.verify=function(i){if(typeof i!="object"||i===null)return"object expected";if(i.elemType!=null&&i.hasOwnProperty("elemType")&&!O.isInteger(i.elemType))return"elemType: integer expected";if(i.shape!=null&&i.hasOwnProperty("shape")){var s=_.onnx.TensorShapeProto.verify(i.shape);if(s)return"shape."+s}return null},t.fromObject=function(i){if(i instanceof _.onnx.TypeProto.SparseTensor)return i;var s=new _.onnx.TypeProto.SparseTensor;if(i.elemType!=null&&(s.elemType=i.elemType|0),i.shape!=null){if(typeof i.shape!="object")throw TypeError(".onnx.TypeProto.SparseTensor.shape: object expected");s.shape=_.onnx.TensorShapeProto.fromObject(i.shape)}return s},t.toObject=function(i,s){s||(s={});var a={};return s.defaults&&(a.elemType=0,a.shape=null),i.elemType!=null&&i.hasOwnProperty("elemType")&&(a.elemType=i.elemType),i.shape!=null&&i.hasOwnProperty("shape")&&(a.shape=_.onnx.TensorShapeProto.toObject(i.shape,s)),a},t.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},t.getTypeUrl=function(i){return i===void 0&&(i="type.googleapis.com"),i+"/onnx.TypeProto.SparseTensor"},t}(),e}(),r.OperatorSetIdProto=function(){function e(n){if(n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.domain="",e.prototype.version=O.Long?O.Long.fromBits(0,0,!1):0,e.create=function(t){return new e(t)},e.encode=function(t,o){return o||(o=ht.create()),t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&o.uint32(10).string(t.domain),t.version!=null&&Object.hasOwnProperty.call(t,"version")&&o.uint32(16).int64(t.version),o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.OperatorSetIdProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.domain=t.string();break}case 2:{s.version=t.int64();break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){return typeof t!="object"||t===null?"object expected":t.domain!=null&&t.hasOwnProperty("domain")&&!O.isString(t.domain)?"domain: string expected":t.version!=null&&t.hasOwnProperty("version")&&!O.isInteger(t.version)&&!(t.version&&O.isInteger(t.version.low)&&O.isInteger(t.version.high))?"version: integer|Long expected":null},e.fromObject=function(t){if(t instanceof _.onnx.OperatorSetIdProto)return t;var o=new _.onnx.OperatorSetIdProto;return t.domain!=null&&(o.domain=String(t.domain)),t.version!=null&&(O.Long?(o.version=O.Long.fromValue(t.version)).unsigned=!1:typeof t.version=="string"?o.version=parseInt(t.version,10):typeof t.version=="number"?o.version=t.version:typeof t.version=="object"&&(o.version=new O.LongBits(t.version.low>>>0,t.version.high>>>0).toNumber())),o},e.toObject=function(t,o){o||(o={});var i={};if(o.defaults)if(i.domain="",O.Long){var s=new O.Long(0,0,!1);i.version=o.longs===String?s.toString():o.longs===Number?s.toNumber():s}else i.version=o.longs===String?"0":0;return t.domain!=null&&t.hasOwnProperty("domain")&&(i.domain=t.domain),t.version!=null&&t.hasOwnProperty("version")&&(typeof t.version=="number"?i.version=o.longs===String?String(t.version):t.version:i.version=o.longs===String?O.Long.prototype.toString.call(t.version):o.longs===Number?new O.LongBits(t.version.low>>>0,t.version.high>>>0).toNumber():t.version),i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.OperatorSetIdProto"},e}(),r.OperatorStatus=function(){var e={},n=Object.create(e);return n[e[0]="EXPERIMENTAL"]=0,n[e[1]="STABLE"]=1,n}(),r.FunctionProto=function(){function e(n){if(this.input=[],this.output=[],this.attribute=[],this.attributeProto=[],this.node=[],this.opsetImport=[],n)for(var t=Object.keys(n),o=0;o<t.length;++o)n[t[o]]!=null&&(this[t[o]]=n[t[o]])}return e.prototype.name="",e.prototype.input=O.emptyArray,e.prototype.output=O.emptyArray,e.prototype.attribute=O.emptyArray,e.prototype.attributeProto=O.emptyArray,e.prototype.node=O.emptyArray,e.prototype.docString="",e.prototype.opsetImport=O.emptyArray,e.prototype.domain="",e.create=function(t){return new e(t)},e.encode=function(t,o){if(o||(o=ht.create()),t.name!=null&&Object.hasOwnProperty.call(t,"name")&&o.uint32(10).string(t.name),t.input!=null&&t.input.length)for(var i=0;i<t.input.length;++i)o.uint32(34).string(t.input[i]);if(t.output!=null&&t.output.length)for(var i=0;i<t.output.length;++i)o.uint32(42).string(t.output[i]);if(t.attribute!=null&&t.attribute.length)for(var i=0;i<t.attribute.length;++i)o.uint32(50).string(t.attribute[i]);if(t.node!=null&&t.node.length)for(var i=0;i<t.node.length;++i)_.onnx.NodeProto.encode(t.node[i],o.uint32(58).fork()).ldelim();if(t.docString!=null&&Object.hasOwnProperty.call(t,"docString")&&o.uint32(66).string(t.docString),t.opsetImport!=null&&t.opsetImport.length)for(var i=0;i<t.opsetImport.length;++i)_.onnx.OperatorSetIdProto.encode(t.opsetImport[i],o.uint32(74).fork()).ldelim();if(t.domain!=null&&Object.hasOwnProperty.call(t,"domain")&&o.uint32(82).string(t.domain),t.attributeProto!=null&&t.attributeProto.length)for(var i=0;i<t.attributeProto.length;++i)_.onnx.AttributeProto.encode(t.attributeProto[i],o.uint32(90).fork()).ldelim();return o},e.encodeDelimited=function(t,o){return this.encode(t,o).ldelim()},e.decode=function(t,o){t instanceof Z||(t=Z.create(t));for(var i=o===void 0?t.len:t.pos+o,s=new _.onnx.FunctionProto;t.pos<i;){var a=t.uint32();switch(a>>>3){case 1:{s.name=t.string();break}case 4:{s.input&&s.input.length||(s.input=[]),s.input.push(t.string());break}case 5:{s.output&&s.output.length||(s.output=[]),s.output.push(t.string());break}case 6:{s.attribute&&s.attribute.length||(s.attribute=[]),s.attribute.push(t.string());break}case 11:{s.attributeProto&&s.attributeProto.length||(s.attributeProto=[]),s.attributeProto.push(_.onnx.AttributeProto.decode(t,t.uint32()));break}case 7:{s.node&&s.node.length||(s.node=[]),s.node.push(_.onnx.NodeProto.decode(t,t.uint32()));break}case 8:{s.docString=t.string();break}case 9:{s.opsetImport&&s.opsetImport.length||(s.opsetImport=[]),s.opsetImport.push(_.onnx.OperatorSetIdProto.decode(t,t.uint32()));break}case 10:{s.domain=t.string();break}default:t.skipType(a&7);break}}return s},e.decodeDelimited=function(t){return t instanceof Z||(t=new Z(t)),this.decode(t,t.uint32())},e.verify=function(t){if(typeof t!="object"||t===null)return"object expected";if(t.name!=null&&t.hasOwnProperty("name")&&!O.isString(t.name))return"name: string expected";if(t.input!=null&&t.hasOwnProperty("input")){if(!Array.isArray(t.input))return"input: array expected";for(var o=0;o<t.input.length;++o)if(!O.isString(t.input[o]))return"input: string[] expected"}if(t.output!=null&&t.hasOwnProperty("output")){if(!Array.isArray(t.output))return"output: array expected";for(var o=0;o<t.output.length;++o)if(!O.isString(t.output[o]))return"output: string[] expected"}if(t.attribute!=null&&t.hasOwnProperty("attribute")){if(!Array.isArray(t.attribute))return"attribute: array expected";for(var o=0;o<t.attribute.length;++o)if(!O.isString(t.attribute[o]))return"attribute: string[] expected"}if(t.attributeProto!=null&&t.hasOwnProperty("attributeProto")){if(!Array.isArray(t.attributeProto))return"attributeProto: array expected";for(var o=0;o<t.attributeProto.length;++o){var i=_.onnx.AttributeProto.verify(t.attributeProto[o]);if(i)return"attributeProto."+i}}if(t.node!=null&&t.hasOwnProperty("node")){if(!Array.isArray(t.node))return"node: array expected";for(var o=0;o<t.node.length;++o){var i=_.onnx.NodeProto.verify(t.node[o]);if(i)return"node."+i}}if(t.docString!=null&&t.hasOwnProperty("docString")&&!O.isString(t.docString))return"docString: string expected";if(t.opsetImport!=null&&t.hasOwnProperty("opsetImport")){if(!Array.isArray(t.opsetImport))return"opsetImport: array expected";for(var o=0;o<t.opsetImport.length;++o){var i=_.onnx.OperatorSetIdProto.verify(t.opsetImport[o]);if(i)return"opsetImport."+i}}return t.domain!=null&&t.hasOwnProperty("domain")&&!O.isString(t.domain)?"domain: string expected":null},e.fromObject=function(t){if(t instanceof _.onnx.FunctionProto)return t;var o=new _.onnx.FunctionProto;if(t.name!=null&&(o.name=String(t.name)),t.input){if(!Array.isArray(t.input))throw TypeError(".onnx.FunctionProto.input: array expected");o.input=[];for(var i=0;i<t.input.length;++i)o.input[i]=String(t.input[i])}if(t.output){if(!Array.isArray(t.output))throw TypeError(".onnx.FunctionProto.output: array expected");o.output=[];for(var i=0;i<t.output.length;++i)o.output[i]=String(t.output[i])}if(t.attribute){if(!Array.isArray(t.attribute))throw TypeError(".onnx.FunctionProto.attribute: array expected");o.attribute=[];for(var i=0;i<t.attribute.length;++i)o.attribute[i]=String(t.attribute[i])}if(t.attributeProto){if(!Array.isArray(t.attributeProto))throw TypeError(".onnx.FunctionProto.attributeProto: array expected");o.attributeProto=[];for(var i=0;i<t.attributeProto.length;++i){if(typeof t.attributeProto[i]!="object")throw TypeError(".onnx.FunctionProto.attributeProto: object expected");o.attributeProto[i]=_.onnx.AttributeProto.fromObject(t.attributeProto[i])}}if(t.node){if(!Array.isArray(t.node))throw TypeError(".onnx.FunctionProto.node: array expected");o.node=[];for(var i=0;i<t.node.length;++i){if(typeof t.node[i]!="object")throw TypeError(".onnx.FunctionProto.node: object expected");o.node[i]=_.onnx.NodeProto.fromObject(t.node[i])}}if(t.docString!=null&&(o.docString=String(t.docString)),t.opsetImport){if(!Array.isArray(t.opsetImport))throw TypeError(".onnx.FunctionProto.opsetImport: array expected");o.opsetImport=[];for(var i=0;i<t.opsetImport.length;++i){if(typeof t.opsetImport[i]!="object")throw TypeError(".onnx.FunctionProto.opsetImport: object expected");o.opsetImport[i]=_.onnx.OperatorSetIdProto.fromObject(t.opsetImport[i])}}return t.domain!=null&&(o.domain=String(t.domain)),o},e.toObject=function(t,o){o||(o={});var i={};if((o.arrays||o.defaults)&&(i.input=[],i.output=[],i.attribute=[],i.node=[],i.opsetImport=[],i.attributeProto=[]),o.defaults&&(i.name="",i.docString="",i.domain=""),t.name!=null&&t.hasOwnProperty("name")&&(i.name=t.name),t.input&&t.input.length){i.input=[];for(var s=0;s<t.input.length;++s)i.input[s]=t.input[s]}if(t.output&&t.output.length){i.output=[];for(var s=0;s<t.output.length;++s)i.output[s]=t.output[s]}if(t.attribute&&t.attribute.length){i.attribute=[];for(var s=0;s<t.attribute.length;++s)i.attribute[s]=t.attribute[s]}if(t.node&&t.node.length){i.node=[];for(var s=0;s<t.node.length;++s)i.node[s]=_.onnx.NodeProto.toObject(t.node[s],o)}if(t.docString!=null&&t.hasOwnProperty("docString")&&(i.docString=t.docString),t.opsetImport&&t.opsetImport.length){i.opsetImport=[];for(var s=0;s<t.opsetImport.length;++s)i.opsetImport[s]=_.onnx.OperatorSetIdProto.toObject(t.opsetImport[s],o)}if(t.domain!=null&&t.hasOwnProperty("domain")&&(i.domain=t.domain),t.attributeProto&&t.attributeProto.length){i.attributeProto=[];for(var s=0;s<t.attributeProto.length;++s)i.attributeProto[s]=_.onnx.AttributeProto.toObject(t.attributeProto[s],o)}return i},e.prototype.toJSON=function(){return this.constructor.toObject(this,et.util.toJSONOptions)},e.getTypeUrl=function(t){return t===void 0&&(t="type.googleapis.com"),t+"/onnx.FunctionProto"},e}(),r}();Cd.exports=_});function An(r,e){if(!r)throw new Error(typeof e=="string"?e:e())}function co(r){return new TextDecoder().decode(r)}var tt,nn,Xa,Dt,fi,Ot,Vt,te,lo,on,an,sn,We=D(()=>{"use strict";si();za();tt=Tn(In());un();nn=class{static arraysEqual(e,n){if(e.length!==n.length)return!1;for(let t=0;t<e.length;t++)if(e[t]!==n[t])return!1;return!0}},Xa=class{static preprocessInputShapes(e,n){let t=e.length===1?[1,e[0]]:e,o=n.length===1?[n[0],1]:n;return[t,o]}static postprocessOutputShape(e,n,t){n===1&&e.splice(e.length-2,1),t===1&&e.pop()}static calcMatMulShape(e,n){return e[1]!==n[0]?void 0:[e[0],n[1]]}},Dt=class r{static calcShape(e,n,t=!1){let o=e.length,i=n.length;if(o===0)return n;if(i===0)return e;let s=Math.max(e.length,n.length),a=new Array(s);if(t){if(o<2||i<2)return;let u=Xa.calcMatMulShape([e[o-2],e[o-1]],[n[i-2],n[i-1]]);if(u===void 0)return;[a[s-2],a[s-1]]=u}for(let u=t?3:1;u<=s;u++){let l=o-u<0?1:e[o-u],d=i-u<0?1:n[i-u];if(l!==d&&l>1&&d>1)return;a[s-u]=Math.max(l,d)}return a}static index(e,n){let t=new Array(n.length);return r.fillIndex(e,n,t),t}static fillIndex(e,n,t){let o=e.length-n.length;for(let i=0;i<n.length;i++)t[i]=e[o+i]%n[i]}static calc(e,n,t,o,i){let s=r.calcShape(e.dims,n.dims);if(s){if(o&&!te.areEqual(s,e.dims))return;let a=te.size(s),u=o?e:new yt(s,i||e.type);if(s.length===0)u.set([],t(e.get([]),n.get([])));else{let l=new Array(s.length),d=new Array(e.dims.length),f=new Array(n.dims.length),p=0,m=0,b=!1,y=!1;e.dims.length===0&&(p=e.get([]),b=!0),n.dims.length===0&&(m=n.get([]),y=!0);let $;for(let x=0;x<a;x++){$=x;for(let T=s.length-1;T>=0;T--)l[T]=$%s[T],$=Math.floor($/s[T]);b||(r.fillIndex(l,e.dims,d),p=e.get(d)),y||(r.fillIndex(l,n.dims,f),m=n.get(f)),u.set(l,t(p,m))}}return u}}static isValidBroadcast(e,n){let t=e.length,o=n.length;if(t>o)return!1;for(let i=1;i<=t;i++)if(e[t-i]!==1&&e[t-i]!==n[o-i])return!1;return!0}static getBroadcastDims(e,n){let t=e.length,o=[];for(let i=0;i<t;i++){let s=t-1-i,a=e[s]||1;(n[n.length-1-i]||1)>1&&a===1&&o.unshift(s)}return o}},fi=class{static getShapeOfGemmResult(e,n,t,o,i){if(e.length!==2||t.length!==2)throw new Error("shape need to be of size 2");let s,a,u;n?(s=e[1],a=e[0]):(s=e[0],a=e[1]);let l=-1;if(o?(u=t[0],l=1):(u=t[1],l=0),t[l]!==a)throw new Error("dimension mismatch");if(s<=0||u<=0||a<=0)throw new Error("invalid shape specified");if(i&&!Dt.isValidBroadcast(i,[s,u]))throw new Error("gemm: invalid bias shape for broadcast");return[s,u,a]}},Ot=class r{static tensorDataTypeFromProto(e){switch(e){case tt.onnx.TensorProto.DataType.INT8:return"int8";case tt.onnx.TensorProto.DataType.UINT8:return"uint8";case tt.onnx.TensorProto.DataType.BOOL:return"bool";case tt.onnx.TensorProto.DataType.INT16:return"int16";case tt.onnx.TensorProto.DataType.UINT16:return"uint16";case tt.onnx.TensorProto.DataType.INT32:return"int32";case tt.onnx.TensorProto.DataType.UINT32:return"uint32";case tt.onnx.TensorProto.DataType.FLOAT:return"float32";case tt.onnx.TensorProto.DataType.DOUBLE:return"float64";case tt.onnx.TensorProto.DataType.STRING:return"string";case tt.onnx.TensorProto.DataType.INT64:return"int32";case tt.onnx.TensorProto.DataType.UINT64:return"uint32";default:throw new Error(`unsupported data type: ${tt.onnx.TensorProto.DataType[e]}`)}}static tensorDataTypeStringToEnum(e){switch(e){case"int8":return tt.onnx.TensorProto.DataType.INT8;case"uint8":return tt.onnx.TensorProto.DataType.UINT8;case"bool":return tt.onnx.TensorProto.DataType.BOOL;case"int16":return tt.onnx.TensorProto.DataType.INT16;case"uint16":return tt.onnx.TensorProto.DataType.UINT16;case"int32":return tt.onnx.TensorProto.DataType.INT32;case"uint32":return tt.onnx.TensorProto.DataType.UINT32;case"float32":return tt.onnx.TensorProto.DataType.FLOAT;case"float64":return tt.onnx.TensorProto.DataType.DOUBLE;case"string":return tt.onnx.TensorProto.DataType.STRING;case"int64":return tt.onnx.TensorProto.DataType.INT64;case"uint64":return tt.onnx.TensorProto.DataType.UINT64;default:throw new Error(`unsupported data type: ${e}`)}}static tensorDimsFromProto(e){return e.map(n=>Pr.isLong(n)?n.toNumber():n)}static tensorValueTypeFromProto(e){return{tensorType:r.tensorDataTypeFromProto(e.elemType),shape:{dims:r.tensorDimsFromProto(e.shape.dim.map(n=>n.dimValue))}}}static tensorDimsFromORTFormat(e){let n=[];for(let t=0;t<e.dimsLength();t++)n.push(Vt.longToNumber(e.dims(t)));return n}static tensorAttributesFromORTFormat(e){let n=[];for(let t=0;t<e.attributesLength();t++)n.push(e.attributes(t));return n}},Vt=class{static longToNumber(e,n){return Pr.isLong(e)?e.toNumber():e instanceof k.Long?Pr.fromValue({low:e.low,high:e.high,unsigned:n??!1}).toNumber():e}static isLong(e){return Pr.isLong(e)||e instanceof k.Long}},te=class r{static size(e){return r.getSizeFromDimensionRange(e,0,e.length)}static sizeFromDimension(e,n){if(n<0||n>e.length)throw new Error(`invalid dimension of ${n} for sizeFromDimension as Tensor has ${e.length} dimensions.`);return r.getSizeFromDimensionRange(e,n,e.length)}static sizeToDimension(e,n){if(n<0||n>e.length)throw new Error(`invalid dimension of ${n} for sizeToDimension as Tensor has ${e.length} dimensions.`);return r.getSizeFromDimensionRange(e,0,n)}static getSizeFromDimensionRange(e,n,t){let o=1;for(let i=n;i<t;i++){if(e[i]<=0)throw new Error("cannot get valid size from specified dimension range. Most likely the range contains 0 or negative values in them.");o*=e[i]}return o}static computeStrides(e){let n=e.length;if(n===0)return[];if(n===1)return[1];let t=new Array(n);t[n-1]=1,t[n-2]=e[n-1];for(let o=n-3;o>=0;--o)t[o]=t[o+1]*e[o+1];return t}static transpose(e){return e.slice().reverse()}static indicesToOffset(e,n,t){t===void 0&&(t=e.length);let o=0;for(let i=0;i<t;++i)o+=n[i]*e[i];return o}static offsetToIndices(e,n){let t=n.length;if(t===0)return[];if(t===1)return[e*n[0]];let o=new Array(n.length);for(let i=0;i<o.length-1;++i)o[i]=Math.floor(e/n[i]),e-=o[i]*n[i];return o[o.length-1]=e,o}static normalizeAxis(e,n){if(e<-n&&e>=n)throw new Error("unsupported axis for this operation.");return e<0?e+n:e}static normalizeAxes(e,n){return e.map(t=>this.normalizeAxis(t,n))}static incrementIndex(e,n,t){if(n.length===0||e.length===0)throw new Error("Index incrementing unsupported for scalar Tensor");if(t===void 0)t=n.length;else if(t<=0||t>n.length)throw new Error("Incorrect axis to increment on");for(let o=t-1;o>=0&&(e[o]++,!(e[o]<n[o]));--o)e[o]=0}static calculateReshapedDims(e,n){if(n.length===0){if(e.length===0||r.size(e)===1)return[];throw new Error("cannot reshape to a scalar Tensor")}let t=n.length,o=new Array(t),i=-1,s=1;for(let u=0;u<t;u++){if(n[u]<-1)throw new Error("a dimension in shape hints cannot be less than -1");if(n[u]===-1){if(i!==-1)throw new Error("at most one dimension in shape hints can be -1");i=u}else{if(n[u]===0){if(u>=e.length)throw new Error("the dimension with value zero exceeds the dimension size of the input tensor");o[u]=e[u]}else o[u]=n[u];s*=o[u]}}let a=r.size(e);if(i!==-1){if(a%s!==0)throw new Error(`the input tensor cannot be reshaped to the requested shape. Input shape: [${e}] Output shape: [${n}]`);o[i]=a/s}else if(s!==a)throw new Error("reshapedDims and originalDims don't have matching sizes");return o}static sortBasedOnPerm(e,n){return n?n.map(t=>e[t]):e.slice().reverse()}static padShape(e,n){let t=e.length;return e.map((o,i)=>o+n[i]+n[i+t])}static areEqual(e,n){return e.length!==n.length?!1:e.every((t,o)=>t===n[o])}static validateDimsAndCalcSize(e){if(e.length>6)throw new TypeError("Only rank 0 to 6 is supported for tensor shape.");let n=1;for(let t of e){if(!Number.isInteger(t))throw new TypeError(`Invalid shape: ${t} is not an integer`);if(t<0||t>2147483647)throw new TypeError(`Invalid shape: length ${t} is not allowed`);n*=t}return n}static flattenShape(e,n){n<0&&(n+=e.length);let t=e.reduce((s,a)=>s*a,1),o=e.slice(n).reduce((s,a)=>s*a,1);return[t/o,o]}static squeezeShape(e,n){let t=new Array;n=r.normalizeAxes(n,e.length);for(let o=0;o<e.length;o++){let i=n.indexOf(o)>=0;if(i&&e[o]!==1)throw new Error("squeeze an axis of size different than 1");(n.length===0&&e[o]>1||n.length>0&&!i)&&t.push(e[o])}return t}static unsqueezeShape(e,n){let t=new Array(e.length+n.length);t.fill(0);for(let i=0;i<n.length;i++){let s=r.normalizeAxis(n[i],t.length);if(s>=t.length)throw new Error("'axes' has an out of range axis");if(t[s]!==0)throw new Error("'axes' has a duplicate axis");t[s]=1}let o=0;for(let i=0;i<t.length;i++)t[i]===0&&(t[i]=e[o++]);if(o!==e.length)throw new Error("the unsqueezed dimension could not be established");return t}},lo=class r{static splitShape(e,n,t,o){if(t.length===0){if(!o)throw new Error("need to know number of outputs when the 'split' attribute is not specified");r.determineSplit(e[n],o,t)}let i=[],s=[0];for(let a=0;a<t.length;++a){a!==0&&s.push(s[a-1]+t[a-1]);let u=e.slice();u[n]=t[a],i.push(u)}return[i,s]}static determineSplit(e,n,t){if(e%n!==0)throw new Error("cannot split tensor to equal sized parts");for(let o=0;o<n;++o)t.push(e/n)}},on=class r{static adjustPoolAttributes(e,n,t,o,i,s){if(!e&&t.length!==n.length-2)throw new Error("length of specified kernel shapes should be 2 less than length of input dimensions");if(e)for(let a=0;a<n.length-2;a++)a>=t.length?t.push(n[a+2]):t[a]=n[a+2];for(let a=0;a<t.length;a++)if(a<o.length){if(o[a]<0)throw new Error("strides should be greater than or equal to 1")}else o.push(1);for(let a=0;a<t.length;a++)if(a<i.length){if(i[a]<0)throw new Error("dilations should be greater than or equal to 1")}else i.push(1);for(let a=0;a<t.length*2;a++)if(a<s.length){if(s[a]<0)throw new Error("pad should be greater than or equal to 1")}else s.push(0);for(let a=0;a<t.length;a++){if(t[a]<=0)throw new Error("kernel shapes need to be greater than 0");if(s[a]>=t[a]||s[a+t.length]>=t[a])throw new Error("pads should be smaller than kernel")}}static adjustPadsBasedOnAutoPad(e,n,t,o,i,s){if(s){if(i.length!==2*(e.length-2))throw new Error("length of pads should be twice the length of data dimensions");if(n.length!==e.length-2)throw new Error("length of strides should be the length of data dimensions");if(o.length!==e.length-2)throw new Error("length of kernel shapes should be the length of data dimensions");for(let a=0;a<e.length-2;a++)r.adjustPadAndReturnShape(e[a+2],n[a],t[a],o[a],i,a,a+e.length-2,s)}}static computePoolOutputShape(e,n,t,o,i,s,a){if(n.length<=0)throw new Error("input shape must be of size greater than 0");let u=[n[0],n[1]];return r.computeShapeHelper(e,n,u,t,o,i,s,a),u}static computeConvOutputShape(e,n,t,o,i,s,a){if(e.length<=0||n.length<=0)throw new Error("invalid input tensor dims or invalid filter tensor dims");let u=[e[0],n[0]];return r.computeShapeHelper(!1,e,u,t,o,i,s,a),u}static computeShapeHelper(e,n,t,o,i,s,a,u){if(e)for(let l=0;l<n.length-2;l++)t.push(1);else for(let l=0;l<n.length-2;l++)t.push(r.adjustPadAndReturnShape(n[l+2],o[l],i[l],s[l],a,l,l+n.length-2,u))}static adjustPadAndReturnShape(e,n,t,o,i,s,a,u){let l=t*(o-1)+1;if(u&&u!=="NOTSET")switch(u){case"VALID":return i[s]=0,i[a]=0,Math.floor((e-l)/n+1);case"SAME_LOWER":case"SAME_UPPER":if(t!==1)throw new Error("Dilation not supported for SAME_UPPER or SAME_LOWER");{let f=((e+n-1)/n-1)*n+o-e;return i[s]=Math.floor(u==="SAME_LOWER"?(f+1)/2:f/2),i[a]=f-i[s],Math.floor((e+f-o)/n+1)}default:throw new Error("Unsupported AutoPad type")}else return Math.floor((e+i[s]+i[a]-l)/n+1)}},an=-34028234663852886e22,sn=34028234663852886e22});function u0(r){switch(r){case"bool":case"int8":case"uint8":return 1;case"int16":case"uint16":return 2;case"int32":case"uint32":case"float32":return 4;case"float64":return 8;default:throw new Error(`cannot calculate sizeof() on type ${r}`)}}function Pd(r){switch(r){case Ee.onnx.TensorProto.DataType.UINT8:case Ee.onnx.TensorProto.DataType.INT8:case Ee.onnx.TensorProto.DataType.BOOL:return 1;case Ee.onnx.TensorProto.DataType.UINT16:case Ee.onnx.TensorProto.DataType.INT16:return 2;case Ee.onnx.TensorProto.DataType.FLOAT:case Ee.onnx.TensorProto.DataType.INT32:case Ee.onnx.TensorProto.DataType.UINT32:return 4;case Ee.onnx.TensorProto.DataType.INT64:case Ee.onnx.TensorProto.DataType.DOUBLE:case Ee.onnx.TensorProto.DataType.UINT64:return 8;default:throw new Error(`cannot calculate sizeof() on type ${Ee.onnx.TensorProto.DataType[r]}`)}}function l0(r,e){return new(Bd(e))(r)}function Bd(r){switch(r){case"bool":case"uint8":return Uint8Array;case"int8":return Int8Array;case"int16":return Int16Array;case"uint16":return Uint16Array;case"int32":return Int32Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"float32":return Float32Array;case"float64":return Float64Array;default:throw new Error("unspecified error")}}function Ja(r,e){if(e===Ee.onnx.TensorProto.DataType.INT64||e===Za.TensorDataType.INT64){if(r.greaterThanOrEqual(2147483648)||r.lessThan(-2147483648))throw new TypeError("int64 is not supported")}else if(e===Ee.onnx.TensorProto.DataType.UINT32||e===Za.TensorDataType.UINT32||e===Ee.onnx.TensorProto.DataType.UINT64||e===Za.TensorDataType.UINT64){if(r.greaterThanOrEqual(4294967296)||r.lessThan(0))throw new TypeError("uint64 is not supported")}else throw new TypeError(`not a LONG type: ${Ee.onnx.TensorProto.DataType[e]}`);return r.toNumber()}function kd(r,e,n){switch(e){case Ee.onnx.TensorProto.DataType.BOOL:case Ee.onnx.TensorProto.DataType.UINT8:return r.getUint8(n);case Ee.onnx.TensorProto.DataType.INT8:return r.getInt8(n);case Ee.onnx.TensorProto.DataType.UINT16:return r.getUint16(n,!0);case Ee.onnx.TensorProto.DataType.INT16:return r.getInt16(n,!0);case Ee.onnx.TensorProto.DataType.FLOAT:return r.getFloat32(n,!0);case Ee.onnx.TensorProto.DataType.INT32:return r.getInt32(n,!0);case Ee.onnx.TensorProto.DataType.UINT32:return r.getUint32(n,!0);case Ee.onnx.TensorProto.DataType.INT64:return Ja(Pr.fromBits(r.getUint32(n,!0),r.getUint32(n+4,!0),!1),e);case Ee.onnx.TensorProto.DataType.DOUBLE:return r.getFloat64(n,!0);case Ee.onnx.TensorProto.DataType.UINT64:return Ja(Pr.fromBits(r.getUint32(n,!0),r.getUint32(n+4,!0),!0),e);default:throw new Error(`cannot read from DataView for type ${Ee.onnx.TensorProto.DataType[e]}`)}}var Dd,Ee,Za,yt,un=D(()=>{"use strict";Dd=Tn(Tl());za();io();Ee=Tn(In());We();Za=se.experimental.fbs,yt=class r{constructor(e,n,t,o,i,s=Dd.Guid.create()){this.dims=e;this.type=n;this.dataProvider=t;this.asyncDataProvider=o;this.cache=i;this.dataId=s;this.size=te.validateDimsAndCalcSize(e);let a=this.size,u=t===void 0&&o===void 0&&i===void 0;if(i!==void 0&&i.length!==a)throw new RangeError("Input dims doesn't match data length.");if(n==="string"){if(i!==void 0&&(!Array.isArray(i)||!i.every(l=>typeof l=="string")))throw new TypeError("cache should be a string array");u&&(this.cache=new Array(a))}else{if(i!==void 0){let l=Bd(n);if(!(i instanceof l))throw new TypeError(`cache should be type ${l.name}`)}if(u){let l=new ArrayBuffer(a*u0(n));this.cache=l0(l,n)}}}get data(){if(this.cache===void 0){let e=this.dataProvider(this.dataId);if(e.length!==this.size)throw new Error("Length of data provided by the Data Provider is inconsistent with the dims of this Tensor.");this.cache=e}return this.cache}get stringData(){if(this.type!=="string")throw new TypeError("data type is not string");return this.data}get integerData(){switch(this.type){case"uint8":case"int8":case"uint16":case"int16":case"int32":case"uint32":case"bool":return this.data;default:throw new TypeError("data type is not integer (uint8, int8, uint16, int16, int32, uint32, bool)")}}get floatData(){switch(this.type){case"float32":case"float64":return this.data;default:throw new TypeError("data type is not float (float32, float64)")}}get numberData(){if(this.type!=="string")return this.data;throw new TypeError("type cannot be non-number (string)")}get(e){return this.data[te.indicesToOffset(e,this.strides)]}set(e,n){this.data[te.indicesToOffset(e,this.strides)]=n}async getData(){return this.cache===void 0&&(this.cache=await this.asyncDataProvider(this.dataId)),this.cache}get strides(){return this._strides||(this._strides=te.computeStrides(this.dims)),this._strides}static fromProto(e){if(!e)throw new Error("cannot construct Value from an empty tensor");let n=Ot.tensorDataTypeFromProto(e.dataType),t=Ot.tensorDimsFromProto(e.dims),o=new r(t,n);if(n==="string")e.stringData.forEach((i,s)=>{o.data[s]=co(i)});else if(e.rawData&&typeof e.rawData.byteLength=="number"&&e.rawData.byteLength>0){let i=o.data,s=new DataView(e.rawData.buffer,e.rawData.byteOffset,e.rawData.byteLength),a=Pd(e.dataType),u=e.rawData.byteLength/a;if(e.rawData.byteLength%a!==0)throw new Error("invalid buffer length");if(i.length!==u)throw new Error("buffer length mismatch");for(let l=0;l<u;l++){let d=kd(s,e.dataType,l*a);i[l]=d}}else{let i;switch(e.dataType){case Ee.onnx.TensorProto.DataType.FLOAT:i=e.floatData;break;case Ee.onnx.TensorProto.DataType.INT32:case Ee.onnx.TensorProto.DataType.INT16:case Ee.onnx.TensorProto.DataType.UINT16:case Ee.onnx.TensorProto.DataType.INT8:case Ee.onnx.TensorProto.DataType.UINT8:case Ee.onnx.TensorProto.DataType.BOOL:i=e.int32Data;break;case Ee.onnx.TensorProto.DataType.INT64:i=e.int64Data;break;case Ee.onnx.TensorProto.DataType.DOUBLE:i=e.doubleData;break;case Ee.onnx.TensorProto.DataType.UINT32:case Ee.onnx.TensorProto.DataType.UINT64:i=e.uint64Data;break;default:throw new Error("unspecific error")}if(i==null)throw new Error("failed to populate data from a tensorproto value");let s=o.data;if(s.length!==i.length)throw new Error("array length mismatch");for(let a=0;a<i.length;a++){let u=i[a];Pr.isLong(u)?s[a]=Ja(u,e.dataType):s[a]=u}}return o}static fromData(e,n,t){return new r(n,t,void 0,void 0,e)}static fromOrtTensor(e){if(!e)throw new Error("cannot construct Value from an empty tensor");let n=Ot.tensorDimsFromORTFormat(e),t=Ot.tensorDataTypeFromProto(e.dataType()),o=new r(n,t);if(t==="string")for(let i=0;i<e.stringDataLength();i++)o.data[i]=e.stringData(i);else if(e.rawDataArray()&&typeof e.rawDataLength()=="number"&&e.rawDataLength()>0){let i=o.data,s=new DataView(e.rawDataArray().buffer,e.rawDataArray().byteOffset,e.rawDataLength()),a=Pd(e.dataType()),u=e.rawDataLength()/a;if(e.rawDataLength()%a!==0)throw new Error("invalid buffer length");if(i.length!==u)throw new Error("buffer length mismatch");for(let l=0;l<u;l++){let d=kd(s,e.dataType(),l*a);i[l]=d}}return o}}});function ce(r){return r===1?d0:c0}function Rd(r){let e=ce(r);return`${e.version}
      precision highp float;
      ${e.attribute} vec3 position;
      ${e.attribute} vec2 textureCoord;

      ${e.varyingVertex} vec2 TexCoords;

      void main()
      {
          gl_Position = vec4(position, 1.0);
          TexCoords = textureCoord;
      }`}function zd(r){let e=ce(r);return`${e.version}
    precision highp float;
    precision highp int;
    precision highp sampler2D;
    ${e.varyingFrag} vec2 TexCoords;
    ${e.outputDeclaration}
    const vec2 halfCR = vec2(0.5, 0.5);

    // Custom vector types to handle higher dimenalities.
    struct ivec5
    {
      int x;
      int y;
      int z;
      int w;
      int u;
    };

    struct ivec6
    {
      int x;
      int y;
      int z;
      int w;
      int u;
      int v;
    };

    int imod(int x, int y) {
      return x - y * (x / y);
    }

    `}function Nd(r,e){let n=ce(r);return`
  void main() {
    int indices[${e}];
    toVec(TexCoords, indices);
    vec4 result = vec4(process(indices));
    ${n.output} = result;
  }
  `}var d0,c0,ot=D(()=>{"use strict";d0={version:"",attribute:"attribute",varyingVertex:"varying",varyingFrag:"varying",texture2D:"texture2D",output:"gl_FragColor",outputDeclaration:""},c0={version:"#version 300 es",attribute:"in",varyingVertex:"out",varyingFrag:"in",texture2D:"texture",output:"outputColor",outputDeclaration:"out vec4 outputColor;"}});var Ne=D(()=>{"use strict"});async function Qa(r,e=t=>0,n){return new Promise((t,o)=>{let i=0,s=()=>{if(r()){t();return}i++;let a=e(i);if(n!=null&&i>=n){o();return}setTimeout(s,a)};s()})}function pi(r){return An(typeof r<"u"&&r.length!==0,()=>"empty string found for sampler name"),"get"+r.charAt(0).toUpperCase()+r.slice(1)}function Ld(r){return An(typeof r<"u"&&r.length!==0,()=>"empty string found for sampler name"),"get"+r.charAt(0).toUpperCase()+r.slice(1)+"AtOutCoords"}function On(r,e){let n=JSON.parse(JSON.stringify(r));return n=e,n}function En(r,e){return e.map(n=>r[n]).join(", ")}function Bt(r){if(r<=1)return"int";if(r===2)return"ivec2";if(r===3)return"ivec3";if(r===4)return"ivec4";if(r===5)return"ivec5";if(r===6)return"ivec6";throw Error(`GPU for rank ${r} is not yet supported`)}function sr(r=6){return["x","y","z","w","u","v"].slice(0,r)}var hr=D(()=>{"use strict";We()});function f0(r,e){return sr(e).map(n=>`${r}.${n}`)}function Cn(r,e){return e===1?[r]:f0(r,e)}function mr(){return`
    float getChannel(vec4 frag, int dim) {
      int modCoord = imod(dim, 2);
      return modCoord == 0 ? frag.r : frag.g;
    }

    float getChannel(vec4 frag, vec2 innerDims) {
      vec2 modCoord = mod(innerDims, 2.);
      return modCoord.x == 0. ?
        (modCoord.y == 0. ? frag.r : frag.g) :
        (modCoord.y == 0. ? frag.b : frag.a);
    }
  `}var ln=D(()=>{"use strict";hr()});function h0(r,e,n){if(r===0)return"false";if(r===1)return`rc > ${e[0]}`;let t="";for(let o=r-2;o<r;o++)t+=`${n[o]} >= ${e[o-r+2]}`,o<r-1&&(t+="||");return t}function m0(r,e){let n=r.length;if(n===0)return"getA(), 0, 0, 0";if(n===1)return`getA(rc),
            rc + 1 >= ${r[0]} ? 0. : getA(rc + 1),
            0, 0`;let t="r, c",o="r, cp1",i="rp1, c",s="rp1, cp1",a="";if(n>2)for(let u=0;u<n-2;++u)a=a+`${e[u]},`;return`getA(${a}${t}),
          rEdge ? 0. : getA(${a}${i}),
          cEdge ? 0. : getA(${a}${o}),
          rEdge || cEdge ? 0. : getA(${a}${s})`}function g0(r,e,n,t){return r===0||r===1?"":`
    int r = ${e[r-2]};
    int c = ${e[r-1]};
    int rp1 = ${e[r-2]} + 1;
    int cp1 = ${e[r-1]} + 1;
    bool rEdge = rp1 >= ${t};
    bool cEdge = cp1 >= ${n};
    `}var Md,p0,Vd,Fd=D(()=>{"use strict";ot();Ne();hr();ln();Md={name:"pack",inputNames:["A"],inputTypes:[1]},p0=(r,e)=>{let n=ce(r.session.backend.glContext.version),t=e.dims,o=t.length,i=e.dims.length,s=Bt(i),a=Cn("rc",i),u=g0(i,a,t[t.length-2],t[t.length-1]),l;o===0?l=[1,1]:o===1?l=[t[0],1]:l=[t[i-1],t[i-2]];let d=h0(i,l,a),f=m0(t,a),p=`
        void main() {
          ${s} rc = getOutputCoords();

          if(${d}) {
            ${n.output} = vec4(0);
          } else {
            ${u}

            ${n.output} = vec4(${f});
          }
        }
      `;return{...Md,hasMain:!0,output:{dims:e.dims,type:e.type,textureType:2},shaderSource:p}},Vd=(r,e)=>({...Md,get:()=>p0(r,e)})});function es(r){if(r.length===0)return[1,1,1];let e=1;for(let n=0;n<r.length-2;++n)e*=r[n];return[e,r.length>1?r[r.length-2]:1,r[r.length-1]]}function Gd(r,e){let n=!1;return r.length===0||e.length===0?n=!0:r.length<2||e.length<2?n=r[r.length-1]===e[e.length-1]:n=r[r.length-1]===e[e.length-1]&&r[r.length-2]===e[e.length-2],n}function v0(r){let e=te.computeStrides(r),n=["b","r","c"],t="index";return`
    ivec3 inputCoordsFromReshapedOutCoords(int index) {
      ${e.map((i,s)=>{let a=`int ${n[s]} = ${t} / ${i}`,u=s===e.length-1?`int ${n[s+1]} = ${t} - ${n[s]} * ${i}`:`index -= ${n[s]} * ${i}`;return`${a}; ${u};`}).join("")}
      return ivec3(b, r, c);
    }
  `}function w0(r){let e=te.computeStrides(r);return`
  int getFlattenedIndex(ivec3 coords) {
    // reverse y, z order
    return coords.x * ${e[0]} + coords.z * ${e[1]} + coords.y;
  }
`}var b0,y0,Ud,Wd=D(()=>{"use strict";We();ot();Ne();ln();b0=r=>({name:"Reshape (packed)",inputTypes:[2],inputNames:["A"],cacheHint:`${r}`}),y0=(r,e,n,t)=>{let o=e.dims,i=t,s="";for(let l=0;l<4;l++){let d="";switch(l){case 0:d="outputCoords = rc;";break;case 1:d="outputCoords = ivec3(rc.x, rc.y+1, rc.z);";break;case 2:d="outputCoords = ivec3(rc.x, rc.y, rc.z+1);";break;case 3:d="outputCoords = ivec3(rc.x, rc.y+1, rc.z+1);";break;default:throw new Error}s+=`
        ${d}
        ${l>0?"if(outputCoords.y < rows && outputCoords.z < cols){":""}
          int flattenedIndex = getFlattenedIndex(outputCoords);

          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flattenedIndex);
          vec2 innerDims = vec2(float(inputRC.y),float(inputRC.z));

          result[${l}] = getChannel(getA(inputRC.x, inputRC.y, inputRC.z), innerDims);

        ${l>0?"}":""}
      `}let a=ce(r.session.backend.glContext.version),u=`
      ${v0(o)}
      ${w0(i)}
      ${mr()}

      void main() {
        ivec3 rc = getOutputCoords();

        vec4 result = vec4(0.0);

        ivec3 outputCoords;
        int rows = ${i[2]};
        int cols = ${i[1]};

        ${s}
        ${a.output} = result;
      }
    `;return{...n,output:{dims:i,type:e.type,textureType:2},shaderSource:u,hasMain:!0}},Ud=(r,e,n)=>{let t=b0(n);return{...t,get:()=>y0(r,e,t,n)}}});var ts,Hd=D(()=>{"use strict";ot();Ne();ts=(r,e)=>{let n=e.shape,t=ce(r.session.backend.glContext.version),o=`
    const float FLOAT_MAX = 1.70141184e38;
    const float FLOAT_MIN = 1.17549435e-38;

    bool isNaN(float val) {
      return (val < 1.0 || 0.0 < val || val == 0.0) ? false : true;
    }

    highp vec4 encodeAsUint8(highp float v) {
      if (isNaN(v)) {
        return vec4(255, 255, 255, 255);
      }

      highp float av = abs(v);

      if(av < FLOAT_MIN) {
        return vec4(0.0, 0.0, 0.0, 0.0);
      } else if(v > FLOAT_MAX) {
        return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;
      } else if(v < -FLOAT_MAX) {
        return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;
      }

      highp vec4 c = vec4(0,0,0,0);

      highp float e = floor(log2(av));
      highp float m = exp2(fract(log2(av))) - 1.0;

      c[2] = floor(128.0 * m);
      m -= c[2] / 128.0;
      c[1] = floor(32768.0 * m);
      m -= c[1] / 32768.0;
      c[0] = floor(8388608.0 * m);

      highp float ebias = e + 127.0;
      c[3] = floor(ebias / 2.0);
      ebias -= c[3] * 2.0;
      c[2] += floor(ebias) * 128.0;

      c[3] += 128.0 * step(0.0, -v);

      return c / 255.0;
    }

    void main() {
      float value = ${t.texture2D}(X,TexCoords).r;
      ${t.output} = encodeAsUint8(value);
    }`,i={name:"Uint8Encode",inputTypes:[0],inputNames:["X"],output:{dims:n,type:e.tensor.type,textureType:3},shaderSource:o,hasMain:!0};return r.executeProgram(i,[e.tensor])}});function T0(r,e){if(r===1)return"rc";let n="";for(let t=0;t<r;t++)n+=e[t],t<r-1&&(n+=",");return n}var qd,x0,jd,Kd=D(()=>{"use strict";ot();Ne();hr();ln();qd={name:"unpack",inputNames:["A"],inputTypes:[2]},x0=(r,e)=>{let n=e.dims.length,t=Cn("rc",n),o=t.slice(-2),i=Bt(n),s=mr(),u=e.dims.length===0?"":T0(n,t),l=n<=1?"rc":`vec2(${o.join(",")})`,d=ce(r.session.backend.glContext.version),f=`
    ${s}
    void main() {
      ${i} rc = getOutputCoords();

       // Sample the texture with the coords to get the rgba channel value.
       vec4 packedInput = getA(${u});

       ${d.output} = vec4(getChannel(packedInput, ${l}), 0, 0, 0);
     }
   `;return{...qd,hasMain:!0,output:{dims:e.dims,type:e.type,textureType:0},shaderSource:f}},jd=(r,e)=>({...qd,get:()=>x0(r,e)})});var hi,fo,mi,po=D(()=>{"use strict";Ht();hi=class{constructor(e,n=1){if(n===1)this.internalFormat=e.R32F,this.format=e.RED,this.textureType=e.FLOAT,this.channelSize=n;else if(n===4)this.internalFormat=e.RGBA32F,this.format=e.RGBA,this.textureType=e.FLOAT,this.channelSize=n;else throw new Error(`Invalid number of channels: ${n}`)}encode(e,n){let t,o;return e.constructor!==Float32Array&&(qe.warning("Encoder","data was not of type Float32; creating new Float32Array"),o=new Float32Array(e)),n*this.channelSize>e.length?(qe.warning("Encoder","Source data too small. Allocating larger array"),o=e,t=this.allocate(n*this.channelSize),o.forEach((i,s)=>t[s]=i)):(o=e,t=o),t}allocate(e){return new Float32Array(e*4)}decode(e,n){return this.channelSize===1?e.filter((o,i)=>i%4===0).subarray(0,n):e.subarray(0,n)}},fo=class{constructor(e,n=1,t){if(n!==1&&n!==4)throw new Error(`Invalid number of channels: ${n}`);this.internalFormat=e.RGBA,this.format=e.RGBA,this.channelSize=n,this.textureType=t||e.FLOAT}encode(e,n){let t=e;return this.channelSize===1&&(qe.verbose("Encoder","Exploding into a larger array"),t=this.allocate(n),e.forEach((o,i)=>t[i*4]=o)),t}allocate(e){return new Float32Array(e*4)}decode(e,n){return this.channelSize===1?e.filter((o,i)=>i%4===0).subarray(0,n):e.subarray(0,n)}},mi=class{constructor(e,n=1){this.channelSize=4;if(n===1)this.internalFormat=e.ALPHA,this.format=e.ALPHA,this.textureType=e.UNSIGNED_BYTE,this.channelSize=n;else if(n===4)this.internalFormat=e.RGBA,this.format=e.RGBA,this.textureType=e.UNSIGNED_BYTE,this.channelSize=n;else throw new Error(`Invalid number of channels: ${n}`)}encode(e,n){return new Uint8Array(e.buffer,e.byteOffset,e.byteLength)}allocate(e){return new Uint8Array(e*this.channelSize)}decode(e,n){if(e instanceof Uint8Array)return e.subarray(0,n);throw new Error(`Invalid array type: ${e.constructor}`)}}});var ho,Yd,rs,Xd=D(()=>{"use strict";We();Ne();ho=(r,e,n)=>{let t=n===0||n===1?1:4,o=n===2,i=n===1||n===2,s=n===4?e.length-1:void 0,a=n===4?e.map((u,l)=>l===e.length-1?u*4:u):void 0;return rs(r,e,t,a,{isPacked:o,reverseWH:i,breakAxis:s})},Yd=(r,e,n)=>{let t=ho(r,e,n);return[t.width,t.height]},rs=(r,e,n=1,t,o)=>{let i=!!(o&&o.isPacked),[s,a]=r.computeTextureWH(i&&t||e,o),u=e.length,l=e.slice(0);if(u===0&&(l=[1]),n===1)t=e;else if(i){if(n!==4)throw new Error("a packed texture must be 4-channel");t=e,u>0&&(l[u-1]=Math.ceil(l[u-1]/2)),u>1&&(l[u-2]=Math.ceil(l[u-2]/2))}else if(!t)throw new Error("Unpacked shape is needed when using channels > 1");return{width:s,height:a,channels:n,isPacked:i,shape:l,strides:te.computeStrides(l),unpackedShape:t,reversedWH:o&&o.reverseWH}}});var $0,gi,Jd=D(()=>{"use strict";Ht();un();We();Fd();Wd();Hd();Kd();po();Xd();Ne();$0=(r,e)=>{let n=e.map(o=>`${o.unpackedShape.join(",")};${o.width}x${o.height}`).join("_"),t=r.name;return r.cacheHint&&(t+="["+r.cacheHint+"]"),t+=":"+n,t},gi=class{constructor(e){this.session=e;this.packedTextureDataCache=new Map,this.unpackedTextureDataCache=new Map}calculateTextureWidthAndHeight(e,n){return Yd(this.session.layoutStrategy,e,n)}executeProgram(e,n){if(n.length<e.inputNames.length)throw new Error(`Input size mustn't be less than ${e.inputNames.length}.`);if(e.inputNames.length!==e.inputTypes.length)throw new Error("input names size does not match input types");let t=[];for(let l=0;l<e.inputNames.length;++l)t[l]=this.getOrCreateTextureData(n[l],e.inputTypes[l]);let o=$0(e,t),i=this.session.programManager.getArtifact(o),s=i?i.programInfo:typeof e.get=="function"?e.get():e,a=ho(this.session.layoutStrategy,s.output.dims,s.output.textureType),u=this.createTextureData(a,s.output.type);return i||(i=this.session.programManager.build(s,t,u),this.session.programManager.setArtifact(o,i)),this.runProgram(i,t,u),u}run(e,n){return this.executeProgram(e,n).tensor}runProgram(e,n,t){for(let o=0;o<n.length;++o)if(!!n[o].isPacked!=(e.programInfo.inputTypes[o]===2))throw new Error(`input[${o}] property packed inconsistent`);if(!!t.isPacked!=(e.programInfo.output.textureType===2))throw new Error("output property packed inconsistent");this.session.programManager.run(e,n,t)}getOrCreateTextureData(e,n){let t=this.getTextureData(e.dataId,n===2);if(!t&&(t=this.getTextureData(e.dataId,n!==2),t))return n===2?this.pack(t):this.unpack(t);if(!t){let o=ho(this.session.layoutStrategy,e.dims,n);if(n===4){let a=e.dims;if(a.length===4){let u=[a[0],Math.ceil(a[1]*a[2]*a[3]/4)],l=ho(this.session.layoutStrategy,u,n),d=e.numberData;if(a[1]*a[2]*a[3]%4!==0){let f=a[0],p=a[1]*a[2]*a[3],m=Math.ceil(p*1/4)*4,b=f*m;d=new Float32Array(b);for(let y=0;y<f;++y){let $=y*p,x=y*m+y%1*p;d.set(e.numberData.subarray($,$+p),x)}}return this.createTextureData(l,e.type,d,e,1)}}if(n===2){let i=rs(this.session.layoutStrategy,e.dims,1,[],{reverseWH:!0}),s=this.createTextureData(i,e.type,e.numberData,e,1);t=this.pack(s)}else t=this.createTextureData(o,e.type,e.numberData,e,1)}return t}createTextureDataFromLayoutBindTensor(e,n,t,o){return this.createTextureData(e,n,t,o,1)}createTextureData(e,n,t,o,i){qe.verbose("InferenceHandler",`Creating TextureData: layout:[${JSON.stringify(e)}]`);let s=this.session.textureManager.createTextureFromLayout(n,e,t,i);return this.createTextureDataFromTexture(e,n,s,o)}reshapeUnpacked(e,n){let t=this.getOrCreateTextureData(e,0),o={channels:t.channels,height:t.height,width:t.width,shape:n.length!==0?n:[1],strides:te.computeStrides(n),unpackedShape:n};return this.createTextureDataFromTexture(o,e.type,t.texture).tensor}reshapePacked(e,n){let t=this.getOrCreateTextureData(e,2);if(Gd(e.dims,n)){let l={channels:t.channels,height:t.height,width:t.width,shape:n.length!==0?n:[1],strides:te.computeStrides(n),unpackedShape:n,isPacked:!0};return this.createTextureDataFromTexture(l,e.type,t.texture).tensor}let o=es(e.dims),i=es(n),s=this.reshapePacked(e,o),a=this.run(Ud(this,s,i),[s]);return this.reshapePacked(a,n)}cast(e,n){let t=this.getOrCreateTextureData(e,0);return this.createTextureDataFromTexture(t,n,t.texture).tensor}createTextureDataFromTexture(e,n,t,o,i){let s={...e,tensor:o||new yt(e.unpackedShape,n,a=>this.readTexture(s),async a=>this.readTextureAsync(s),void 0,i),texture:t};return this.setTextureData(s.tensor.dataId,s,e.isPacked),s}getTextureData(e,n=!1){return this.session.isInitializer(e)?this.session.getTextureData(e,n):n?this.packedTextureDataCache.get(e):this.unpackedTextureDataCache.get(e)}setTextureData(e,n,t=!1){this.session.isInitializer(e)?this.session.setTextureData(e,n,t):(t?this.packedTextureDataCache:this.unpackedTextureDataCache).set(e,n)}isTextureLayoutCached(e,n=!1){return!!this.getTextureData(e.dataId,n)}dispose(){this.session.textureManager.clearActiveTextures(),this.packedTextureDataCache.forEach(e=>this.session.textureManager.releaseTexture(e)),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache.forEach(e=>this.session.textureManager.releaseTexture(e)),this.unpackedTextureDataCache=new Map}readTexture(e){return e.isPacked?this.readTexture(this.unpack(e)):this.session.backend.glContext.isFloat32DownloadSupported?this.session.textureManager.readTexture(e,e.tensor.type,e.channels):this.session.textureManager.readUint8TextureAsFloat(ts(this,e))}async readTextureAsync(e){return e.isPacked?this.readTextureAsync(this.unpack(e)):this.session.backend.glContext.isFloat32DownloadSupported?this.session.textureManager.readTextureAsync(e,e.tensor.type,e.channels):this.session.textureManager.readUint8TextureAsFloat(ts(this,e))}pack(e){return this.executeProgram(Vd(this,e.tensor),[e.tensor])}unpack(e){return this.executeProgram(jd(this,e.tensor),[e.tensor])}}});var ns,Ae,St=D(()=>{"use strict";ns=class{constructor(e){Object.assign(this,e)}get cacheKey(){return this.key||(this.key=Object.getOwnPropertyNames(this).sort().map(e=>`${this[e]}`).join(";")),this.key}},Ae=r=>new ns(r)});var Qd,ec,tc,S0,I0,rc=D(()=>{"use strict";St();ot();Ne();Qd={name:"BatchNormalization",inputNames:["A","Scale","B","Mean","Variance"],inputTypes:[0,0,0,0,0]},ec=(r,e,n)=>(I0(e),[r.run({...Qd,cacheHint:n.cacheKey,get:()=>S0(r,e,n)},e)]),tc=r=>{let e=r.attributes.getFloat("epsilon",1e-5),n=r.attributes.getFloat("momentum",.9),t=r.attributes.getInt("spatial",1);return Ae({epsilon:e,momentum:n,spatial:t})},S0=(r,e,n)=>{let t=ce(r.session.backend.glContext.version),o=e[0].dims.length,[i,s]=r.calculateTextureWidthAndHeight(e[1].dims,0),a=`
  float process(int[${o}] indices) {
    vec2 position = offsetToCoords(indices[1], ${i}, ${s});
    float scale = getColorAsFloat(${t.texture2D}(Scale, position));
    float mean = getColorAsFloat(${t.texture2D}(Mean, position));
    float variance = getColorAsFloat(${t.texture2D}(Variance, position));
    float b = getColorAsFloat(${t.texture2D}(B, position));

    return scale * ( (_A(indices) - mean) / sqrt(variance + float(${n.epsilon})) ) + b;
  }`;return{...Qd,output:{dims:e[0].dims,type:e[0].type,textureType:0},shaderSource:a}},I0=r=>{if(!r||r.length!==5)throw new Error("BatchNormalization requires 5 inputs.");let e=r[0],n=r[1],t=r[2],o=r[3],i=r[4];if(e.dims.length<3||n.dims.length!==1||t.dims.length!==1||o.dims.length!==1||i.dims.length!==1)throw new Error("invalid input shape.");if(n.dims[0]!==e.dims[1]||t.dims[0]!==e.dims[1]||o.dims[0]!==e.dims[1]||i.dims[0]!==e.dims[1])throw new Error("invalid input shape.");if(e.type!=="float32"&&e.type!=="float64"||n.type!=="float32"&&n.type!=="float64"||t.type!=="float32"&&t.type!=="float64"||o.type!=="float32"&&o.type!=="float64"||i.type!=="float32"&&i.type!=="float64")throw new Error("invalid input tensor types.")}});var bi,Yt,Q,mo,yi,kr=D(()=>{"use strict";bi=class{constructor(e,n,t,o){this.glContext=e;this.programInfo=n;this.inputTextureLayouts=t;this.outputTextureLayout=o}},Yt=class{constructor(e){this.context=e}},Q=class{constructor(e,n){this.routineBody=e;this.dependencies=n}},mo=class{constructor(e,n,t){this.name=e;t?this.dependencies=t:this.dependencies=[],n&&(this.routineBody=n)}addDependency(e){e&&this.dependencies.push(e)}},yi=class{static returnOrderedNodes(e){if(!e||e.length===0)return[];if(e.length===1)return e;let n=new Set,t=new Set,o=new Array;return this.createOrderedNodes(e,n,t,o),o}static createOrderedNodes(e,n,t,o){for(let i=0;i<e.length;++i)this.dfsTraverse(e[i],n,t,o)}static dfsTraverse(e,n,t,o){if(!e||t.has(e.name))return;if(n.has(e.name))throw new Error("Cyclic dependency detected. Can't topologically sort routines needed for shader.");n.add(e.name);let i=e.dependencies;if(i&&i.length>0)for(let s=0;s<i.length;++s)this.dfsTraverse(i[s],n,t,o);o.push(e),t.add(e.name),n.delete(e.name)}}});function O0(){let r="add_";return{body:`
  float ${r}(float a, float b) {
    return a + b;
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return v1 + v2;
  }
  `,name:r,type:0}}function E0(){let r="div_";return{body:`
  float ${r}(float a, float b) {
    return a / b;
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return v1 / v2;
  }
  `,name:r,type:0}}function C0(){let r="mul_";return{body:`
  float ${r}(float a, float b) {
    return a * b;
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return v1 * v2;
  }
  `,name:r,type:0}}function P0(){let r="sub_";return{body:`
  float ${r}(float a, float b) {
    return a - b;
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return v1 - v2;
  }
  `,name:r,type:0}}function k0(){let r="equal_";return{body:`
  float ${r}(float a, float b) {
    return float(a == b);
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return vec4(equal(v1, v2));
  }
  `,name:r,type:0}}function D0(){let r="greater_";return{body:`
  float ${r}(float a, float b) {
    return float(a > b);
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return vec4( v1.r > v2.r ,
      v1.g > v2.g,
      v1.b > v2.b,
      v1.a > v2.a );
  }
  `,name:r,type:0}}function B0(){let r="less_";return{body:`
  float ${r}(float a, float b) {
    return float(a < b);
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return vec4( v1.r < v2.r ,
                v1.g < v2.g,
                v1.b < v2.b,
                v1.a < v2.a );
  }
  `,name:r,type:0}}function R0(){let r="and_";return{body:`
  float ${r}(float a, float b) {
    return float( bool(a) && bool(b) );
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r && b2.r ,
                b1.g && b2.g,
                b1.b && b2.b,
                b1.a && b2.a );
  }
  `,name:r,type:0}}function z0(){let r="or_";return{body:`
  float ${r}(float a, float b) {
    return float( bool(a) || bool(b) );
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r || b2.r ,
                b1.g || b2.g,
                b1.b || b2.b,
                b1.a || b2.a );
  }
  `,name:r,type:0}}function N0(){let r="xor_";return{body:`
  float ${r}(float a, float b) {
    return float( bool(a) ^^ bool(b) );
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    bvec4 b1 = bvec4(v1);
    bvec4 b2 = bvec4(v2);
    return vec4( b1.r ^^ b2.r ,
                b1.g ^^ b2.g,
                b1.b ^^ b2.b,
                b1.a ^^ b2.a );
  }
  `,name:r,type:0}}function L0(){return V0("pow")}function M0(){let r="prelu_";return{body:`
  float ${r}(float a, float b) {
    return a < 0.0 ? a * b: a;
  }
  vec4 ${r}(vec4 v1, vec4 v2) {
    return vec4(
      v1.r < 0.0 ? v1.r * v2.r: v1.r,
      v1.g < 0.0 ? v1.g * v2.g: v1.g,
      v1.b < 0.0 ? v1.b * v2.b: v1.b,
      v1.a < 0.0 ? v1.a * v2.a: v1.a
      );
  }
  `,name:r,type:0}}function V0(r){let e=`${r}_`;return{body:`
  float ${e}(float a, float b) {
    return ${r}(a, b);
  }
  vec4 ${e}(vec4 v1, vec4 v2) {
    return ${r}(v1, v2);
  }
  `,name:e,type:0}}var Xt,F0,nc,oc,ic,ac,sc,uc,lc,dc,cc,fc,pc,hc,mc=D(()=>{"use strict";We();kr();ot();Ne();Xt=(r,e,n,t=e[0].type,o)=>{let i=r.session.pack?2:0;return{name:n.name,inputNames:["A","B"],inputTypes:[i,i],cacheHint:o,get:()=>F0(r,e,n,t)}},F0=(r,e,n,t=e[0].type)=>{let o=r.session.pack?2:0,i=!te.areEqual(e[0].dims,e[1].dims),s=e[0].dims,a=r.session.pack;if(i){let d=Dt.calcShape(e[0].dims,e[1].dims,!1);if(!d)throw new Error("Can't perform binary op on the given tensors");s=d;let f=s.length,p=e[0].dims.length!==0?e[0].dims.length:1,m=e[1].dims.length!==0?e[1].dims.length:1,b=e[0].dims.length!==0?"bcastIndices_A(indices, aindices);":"aindices[0] = 0;",y=e[1].dims.length!==0?"bcastIndices_B(indices, bindices);":"bindices[0] = 0;",$=ce(r.session.backend.glContext.version),x=a?`
      ${n.body}
      void main() {
        vec4 a = getAAtOutCoords();
        vec4 b = getBAtOutCoords();
        vec4 result = ${n.name}(a, b);
        ${$.output} = result;
      }`:`
      ${n.body}
      float process(int indices[${f}]) {
        int aindices[${p}];
        int bindices[${m}];
        ${b}
        ${y}
        return ${n.name}(_A(aindices), _B(bindices));
      }`;return{name:n.name,inputNames:["A","B"],inputTypes:[o,o],output:{dims:s,type:t,textureType:o},shaderSource:x,hasMain:a}}let u=ce(r.session.backend.glContext.version),l=`
    ${n.body}
    void main() {
      vec4 v1 = ${u.texture2D}(A, TexCoords);
      vec4 v2 = ${u.texture2D}(B, TexCoords);
      vec4 result = ${n.name}(v1, v2);
      ${u.output} = result;
    }
    `;return{name:n.name,inputNames:["A","B"],inputTypes:[o,o],output:{dims:e[0].dims,type:t,textureType:o},shaderSource:l,hasMain:!0}},nc=(r,e)=>[r.run(Xt(r,e,O0()),e)],oc=(r,e)=>[r.run(Xt(r,e,R0(),"bool"),e)],ic=(r,e)=>[r.run(Xt(r,e,E0()),e)],ac=(r,e)=>[r.run(Xt(r,e,k0(),"bool"),e)],sc=(r,e)=>[r.run(Xt(r,e,D0(),"bool"),e)],uc=(r,e)=>[r.run(Xt(r,e,B0(),"bool"),e)],lc=(r,e)=>[r.run(Xt(r,e,C0()),e)],dc=(r,e)=>[r.run(Xt(r,e,z0(),"bool"),e)],cc=(r,e)=>[r.run(Xt(r,e,L0()),e)],fc=(r,e)=>[r.run(Xt(r,e,M0()),e)],pc=(r,e)=>[r.run(Xt(r,e,P0()),e)],hc=(r,e)=>[r.run(Xt(r,e,N0(),"bool"),e)]});var gc,bc,G0,yc=D(()=>{"use strict";We();gc=(r,e,n)=>(G0(e),[r.cast(e[0],n)]),bc=r=>Ot.tensorDataTypeFromProto(r.attributes.getInt("to")),G0=r=>{if(!r||r.length!==1)throw new Error("Cast requires 1 input.");if(r[0].type==="string")throw new Error("Invalid input type.")}});var W0,H0,vc,vi,wc=D(()=>{"use strict";ot();Ne();hr();ln();W0=(r,e)=>({name:"Concat (packed)",inputNames:Array.from({length:r},(n,t)=>`X${t}`),inputTypes:Array(r).fill(2),cacheHint:e}),H0=(r,e,n,t)=>{let o=n[0].dims.slice();if(t>=o.length||t<-1*o.length)throw new Error("axis specified for concat doesn't match input dimensionality");t<0&&(t=o.length+t);let i=o.slice(0);for(let N=1;N<n.length;N++){let B=n[N].dims.slice();for(let F=0;F<o.length;F++)if(F===t)i[t]+=B[F];else if(o[F]!==B[F])throw new Error("non concat dimensions must match")}let s=i.length,a=Cn("coords",s),u=Bt(s),l=mr(),d=n.map(N=>N.dims),f=sr(s),p=new Array(d.length-1);p[0]=d[0][t];for(let N=1;N<p.length;N++)p[N]=p[N-1]+d[N][t];let m=f[t],b=f.slice(-2),y=f.join(),$=`if (${m} < ${p[0]}) {
        return getChannel(
            getX0(${y}), vec2(${b.join()}));
        }`;for(let N=1;N<p.length;N++){let B=p[N-1];$+=`
            if (${m} < ${p[N]}  && ${m} >= ${p[N-1]}) {
              return getChannel(
                getX${N}(${vi(f,m,B)}),
                vec2(${vi(b,m,B)}));
            }`}let x=p.length,T=p[p.length-1];$+=`
            return getChannel(
              getX${x}(${vi(f,m,T)}),
              vec2(${vi(b,m,T)}));`;let A=ce(r.session.backend.glContext.version),E=`
          ${l}
          float getValue(${f.map(N=>"int "+N)}) {
            ${$}
          }

          void main() {
            ${u} coords = getOutputCoords();
            int lastDim = coords.${f[s-1]};
            coords.${f[s-1]} = coords.${f[s-2]};
            coords.${f[s-2]} = lastDim;

            vec4 result = vec4(getValue(${a}), 0., 0., 0.);

            ${a[s-1]} = ${a[s-1]} + 1;
            if (${a[s-1]} < ${i[s-1]}) {
              result.g = getValue(${a});
            }

            ${a[s-2]} = ${a[s-2]} + 1;
            if (${a[s-2]} < ${i[s-2]}) {
              result.a = getValue(${a});
            }

            ${a[s-1]} = ${a[s-1]} - 1;
            if (${a[s-2]} < ${i[s-2]} &&
                ${a[s-1]} < ${i[s-1]}) {
              result.b = getValue(${a});
            }
            ${A.output} = result;
          }
        `;return{...e,output:{dims:i,type:n[0].type,textureType:2},shaderSource:E,hasMain:!0}},vc=(r,e,n)=>{let t=W0(e.length,n.cacheKey);return{...t,get:()=>H0(r,t,e,n.axis)}},vi=(r,e,n)=>{let t=r.indexOf(e);return r.map((i,s)=>s===t?`${i} - ${n}`:i).join()}});var xc,q0,j0,K0,Tc,Y0,X0,Z0,_c,J0,$c=D(()=>{"use strict";St();Ne();wc();xc=(r,e,n)=>(J0(e),r.session.pack&&e[0].dims.length>1?[r.run(vc(r,e,n),e)]:[r.run(K0(r,e,n),e)]),q0=(r,e)=>({name:"Concat",inputNames:Array.from({length:r},(n,t)=>`X${t}`),inputTypes:Array(r).fill(0),cacheHint:e}),j0=(r,e,n,t)=>{let o=n[0].dims.slice();if(t>=o.length||t<-1*o.length)throw new Error("axis specified for concat doesn't match input dimensionality");t<0&&(t=o.length+t);let i=o.slice(0);for(let m=1;m<n.length;m++){let b=n[m].dims.slice();for(let y=0;y<o.length;y++)if(y===t)i[t]+=b[y];else if(o[y]!==b[y])throw new Error("non concat dimensions must match")}let s=i.length,a=new Array(n.length),u=0;for(let m=0;m<a.length;++m)u+=n[m].dims[t],a[m]=u;let l="";n.length<5?l=Tc(a):l=Y0(a);let d=X0(n.length,s),f=Z0(a),p=`
        ${d}
        ${f}
        ${l}
        float process(int indices[${s}]) {
          int textureIndex = getTextureWhereDataResides (indices[${t}]);

          if(textureIndex != 0) {
            indices[${t}] = indices[${t}] - int(getSizeInConcatAxisValueFromIndex(textureIndex-int(1)));
          }

          return fetchDataFromCorrectTexture(textureIndex, indices);
        }`;return{...e,output:{dims:i,type:n[0].type,textureType:0},shaderSource:p}},K0=(r,e,n)=>{let t=q0(e.length,n.cacheKey);return{...t,get:()=>j0(r,t,e,n.axis)}},Tc=r=>`int getTextureWhereDataResides(int index) {
      ${r.map((n,t)=>`if(index<${n}) {return ${t};}
`).join("")}
    }`,Y0=r=>Tc(r),X0=(r,e)=>{let n=[`float fetchDataFromCorrectTexture(int textureIndex, int indices[${e}]) {`];for(let t=0;t<r;++t)t===0?n.push(`	if (textureIndex == ${t}) { return _X${t}(indices); }`):t===r-1?n.push(`	else { return _X${t}(indices); }`):n.push(`	else if (textureIndex == ${t}) { return _X${t}(indices); }`);return n.push("	}"),n.join(`
`)},Z0=r=>{let e=["int getSizeInConcatAxisValueFromIndex(int index) {"];for(let n=0;n<r.length;++n)n===0?e.push(`	if (index == ${n}) { return ${r[n]}; }`):n===r.length-1?e.push(`	else { return ${r[n]}; }`):e.push(`	else if (index == ${n}) { return ${r[n]}; }`);return e.push("	}"),e.join(`
`)},_c=r=>Ae({axis:r.attributes.getInt("axis")}),J0=r=>{if(!r||r.length<1)throw new Error("too few inputs");let e=r[0].type,n=r[0].dims.length;if(e==="string")throw new Error("string tensor is not supported yet");for(let t of r){if(t.type!==e)throw new Error("input tensors should be one type");if(t.dims.length!==n)throw new Error("input tensors should have the same shape")}}});function Q0(){return Zt("abs")}function ev(){return Zt("acos")}function tv(){return Zt("asin")}function rv(){return Zt("atan")}function nv(){return Zt("ceil")}function ov(){return Zt("cos")}function iv(r){let e="elu";return{body:`
  const float alpha = float(${r});

  float ${e}_(float a) {
    return a >= 0.0 ? a: (exp(a) - 1.0) * alpha;
  }
  vec4 ${e}_(vec4 v) {
    return vec4(${e}_(v.x), ${e}_(v.y), ${e}_(v.z), ${e}_(v.w));
  }
  `,name:e,type:0}}function av(){return Zt("exp")}function sv(){return Zt("floor")}function os(r,e){let n="clip";return{body:`
  const float min = float(${r});
  const float max = float(${e});

  float ${n}_(float a) {
    return clamp(a, min, max);
  }
  vec4 ${n}_(vec4 v) {
    return clamp(v, min, max);
  }
  `,name:n,type:0}}function uv(){let r="indentity";return{body:`
  float ${r}_(float a) {
    return a;
  }
  vec4 ${r}_(vec4 v) {
    return v;
  }
  `,name:r,type:0}}function lv(r){let e="leakyRelu";return{body:`
  const float alpha = float(${r});

  float ${e}_(float a) {
    return a < 0.0 ? a * alpha : a;
  }
  vec4 ${e}_(vec4 v) {
    return vec4(${e}_(v.x), ${e}_(v.y), ${e}_(v.z), ${e}_(v.w));
  }
  `,name:e,type:0}}function dv(){return Zt("log")}function cv(){let r="neg";return{body:`
  float ${r}_(float a) {
    return -a;
  }
  vec4 ${r}_(vec4 v) {
    return -v;
  }
  `,name:r,type:0}}function fv(){let r="not";return{body:`
  float ${r}_(float a) {
    return float( ! bool(a) );
  }
  bool ${r}_(bool a) {
    return !a;
  }
  vec4 ${r}_(vec4 v) {
    return vec4(!bool(v.x), !bool(v.y), !bool(v.z), !bool(v.w));
  }
  bvec4 ${r}_(bvec4 v) {
    return bvec4(!v.x, !v.y, !v.z, !v.w);
  }
  `,name:r,type:0}}function pv(){return Zt("sin")}function is(){let r="relu";return{body:`
  float ${r}_(float a) {
    return max( a, 0.0 );
  }
  vec4 ${r}_(vec4 v) {
    return max( v, 0.0 );
  }
  `,name:r,type:0}}function as(){let r="sigmoid";return{body:`
  float ${r}_(float a) {
    return 1.0 / (1.0 + exp(-a));
  }
  vec4 ${r}_(vec4 v) {
    return 1.0 / (1.0 + exp(-v));
  }
  `,name:r,type:0}}function hv(){return Zt("sqrt")}function mv(){return Zt("tan")}function gv(){let r="tanh";return{body:`
  float ${r}_(float a) {
    a = clamp(a, -10., 10.);
    a = exp(2.*a);
    return (a - 1.) / (a + 1.);
  }
  vec4 ${r}_(vec4 v) {
    v = clamp(v, -10., 10.);
    v = exp(2.*v);
    return (v - 1.) / (v + 1.);
  }
  `,name:r,type:0}}function Zt(r){return{body:`
  float ${r}_(float a) {
    return ${r}(a);
  }
  vec4 ${r}_(vec4 v) {
    return ${r}(v);
  }
  `,name:r,type:0}}var bv,mt,Sc,Ic,Ac,Oc,ss,Ec,Cc,yv,Pc,kc,Dc,Bc,Rc,zc,us,Nc,Lc,Mc,Vc,Fc,Uc,Gc,Wc,Hc,qc,jc,ls=D(()=>{"use strict";St();We();kr();ot();Ne();bv=(r,e,n,t)=>{let o=r.session.pack?2:0,i=ce(r.session.backend.glContext.version);return{...e,output:{dims:n.dims,type:n.type,textureType:o},shaderSource:`
     ${t.body}
     void main() {
       vec4 v = ${i.texture2D}(A, TexCoords);
       v = ${t.name}_(v);
       ${i.output} = v;
     }
     `,hasMain:!0}},mt=(r,e,n,t)=>{let o=r.session.pack?2:0,i={name:n.name,inputTypes:[o],inputNames:["A"],cacheHint:t};return{...i,get:()=>bv(r,i,e,n)}},Sc=(r,e)=>[r.run(mt(r,e[0],Q0()),e)],Ic=(r,e)=>[r.run(mt(r,e[0],ev()),e)],Ac=(r,e)=>[r.run(mt(r,e[0],tv()),e)],Oc=(r,e)=>[r.run(mt(r,e[0],rv()),e)],ss=(r,e,n)=>[r.run(mt(r,e[0],os(n.min,n.max),n.cacheKey),e)],Ec=r=>Ae({min:r.attributes.getFloat("min",an),max:r.attributes.getFloat("max",sn)}),Cc=(r,e)=>{let n=yv(r,e);return ss(r,[e[0]],n)},yv=(r,e)=>{if(e.length>=3&&(!r.session.isInitializer(e[1].dataId)||!r.session.isInitializer(e[2].dataId)))throw new Error("dynamic clip attributes are not allowed");let n=e.length>=3?e[1].numberData[0]:an,t=e.length>=3?e[2].numberData[0]:sn;return Ae({min:n,max:t})},Pc=(r,e)=>[r.run(mt(r,e[0],nv()),e)],kc=(r,e)=>[r.run(mt(r,e[0],ov()),e)],Dc=(r,e,n)=>[r.run(mt(r,e[0],iv(n.alpha),n.cacheKey),e)],Bc=r=>Ae({alpha:r.attributes.getFloat("alpha",1)}),Rc=(r,e)=>[r.run(mt(r,e[0],av()),e)],zc=(r,e)=>[r.run(mt(r,e[0],sv()),e)],us=(r,e)=>[r.run(mt(r,e[0],uv()),e)],Nc=(r,e,n)=>[r.run(mt(r,e[0],lv(n.alpha),n.cacheKey),e)],Lc=r=>Ae({alpha:r.attributes.getFloat("alpha",.01)}),Mc=(r,e)=>[r.run(mt(r,e[0],dv()),e)],Vc=(r,e)=>[r.run(mt(r,e[0],cv()),e)],Fc=(r,e)=>[r.run(mt(r,e[0],fv()),e)],Uc=(r,e)=>[r.run(mt(r,e[0],is()),e)],Gc=(r,e)=>[r.run(mt(r,e[0],as()),e)],Wc=(r,e)=>[r.run(mt(r,e[0],pv()),e)],Hc=(r,e)=>[r.run(mt(r,e[0],hv()),e)],qc=(r,e)=>[r.run(mt(r,e[0],mv()),e)],jc=(r,e)=>[r.run(mt(r,e[0],gv()),e)]});function gr(r){let e;switch(r.activation){case"Relu":e=is();break;case"Sigmoid":e=as();break;case"Clip":e=os(r.clipMin,r.clipMax);break;default:return{activationFunction:"",applyActivation:""}}let n=e.name,t=e.body,o=`value = ${n}_(value);`;return{activationFunction:t,applyActivation:o}}var Pn,dn=D(()=>{"use strict";We();ls();Pn=r=>{let e=r.getString("activation","");if(e==="Clip"){let[n,t]=r.getFloats("activation_params",[an,sn]);return{activation:e,clipMax:t,clipMin:n,activationCacheKey:`${e}:${n},${t}`}}return{activation:e,activationCacheKey:e}}});var wv,xv,Kc,Yc=D(()=>{"use strict";Ht();ot();Ne();wi();dn();wv=(r,e)=>({name:"GroupedConv",inputNames:r?["X","W","Bias"]:["X","W"],inputTypes:r?[0,0,0]:[0,0],cacheHint:e}),xv=(r,e,n,t)=>{let i=e.length>2?"value += getBias(output_channel);":"",s=e[0].dims.slice(),a=e[1].dims.slice(),u=a[0]/t.group;qe.verbose("GroupedConv",`autpPad:${t.autoPad}, dilations:${t.dilations}, group:${t.group}, kernelShape:${t.kernelShape}, pads:${t.pads}, strides:${t.strides}`);let l=kn(s,a,t.dilations,t.pads,t.strides),d=ce(r.session.backend.glContext.version),{activationFunction:f,applyActivation:p}=gr(t),m=`
  const ivec2 strides = ivec2(${t.strides[0]}, ${t.strides[1]});
  const ivec2 pads = ivec2(${t.pads[0]}, ${t.pads[1]});
  ${f}
  void main() {
    ivec4 coords = getOutputCoords();
    int batch = coords.x;
    int output_channel = coords.y;
    ivec2 xRCCorner = coords.zw * strides - pads;
    int group_id = output_channel / ${u};

    float value = 0.0;
    for (int wInChannel = 0; wInChannel < ${a[1]}; wInChannel++) {
      int input_channel = group_id * ${a[1]} + wInChannel;
      for (int wHeight = 0; wHeight < ${a[2]}; wHeight++) {
        int xHeight = xRCCorner.x + wHeight * ${t.dilations[0]};

        if (xHeight < 0 || xHeight >= ${s[2]}) {
          continue;
        }

        for (int wWidth = 0; wWidth < ${a[3]}; wWidth++) {
          int xWidth = xRCCorner.y + wWidth * ${t.dilations[1]};
          if (xWidth < 0 || xWidth >= ${s[3]}) {
            continue;
          }

          float xVal = getX(batch, input_channel, xWidth, xHeight);
          float wVal = getW(output_channel, wInChannel, wWidth, wHeight);
          value += xVal*wVal;
        }
      }
    }
    ${i}
    ${p}
    ${d.output} = vec4(value, .0, .0, .0);
  }
`;return{...n,output:{dims:l,type:e[0].type,textureType:0},shaderSource:m,hasMain:!0}},Kc=(r,e,n)=>{let t=wv(e.length>2,n.cacheKey);return{...t,get:()=>xv(r,e,t,n)}}});var Tv,_v,Xc,Zc=D(()=>{"use strict";ot();Ne();ln();Tv=r=>({name:"Im2Col (packed)",inputNames:["A"],inputTypes:[2],cacheHint:r}),_v=(r,e,n,t,o,i)=>{let s=n.dims,a=t.dims,u=2,l=3,d=o.length,f=[a[1]*a[2]*a[3],o[2]*o[3]],p=a[2]*a[3],m=mr(),b=ce(r.session.backend.glContext.version),y="";for(let x=0;x<=1;x++)for(let T=0;T<=1;T++)y+=`
            blockIndex = rc.x + ${T};
            pos = rc.y + ${x};

            if(blockIndex < ${f[1]} && pos < ${f[0]}) {
              offsetY = int(blockIndex / (${o[d-1]})) * ${i.strides[0]} -
                ${i.pads[0]};
              d0 = offsetY + ${i.dilations[0]} * (imod(pos, ${p}) / ${a[2]});

              if(d0 < ${s[u]} && d0 >= 0) {
                offsetX = imod(blockIndex, ${o[d-1]}) * ${i.strides[1]} -
                  ${i.pads[1]};
                d1 = offsetX + ${i.dilations[1]} * imod(imod(pos, ${p}), ${a[2]});

                if(d1 < ${s[l]} && d1 >= 0) {

                  ch = int(float(pos)/ ${p}.);
                    innerDims = vec2(d0, d1);
                    result[${x*2+T}] = getChannel(
                      getA(0, ch, int(innerDims.x),
                      int(innerDims.y)), innerDims);
                }
              }
            }

          `;let $=`
      ${m}

      void main() {
        ivec2 rc = getOutputCoords();
          vec4 result = vec4(0.0);
          int blockIndex, pos, offsetY, d0, offsetX, d1, ch;
          vec2 innerDims;
          ${y}
          ${b.output} = result;
      }
            `;return{...e,output:{dims:f,type:n.type,textureType:2},shaderSource:$,hasMain:!0}},Xc=(r,e,n,t,o)=>{let i=Tv(o.cacheKey);return{...i,get:()=>_v(r,i,e,n,t,o)}}});function Sv(r,e,n){let t=e[0].dims,o=e[1].dims,i=Dt.calcShape(t,o,!0);if(!i)throw new Error("Can't use matmul on the given tensors");let s=Bt(i.length),a=sr(),{activationFunction:u,applyActivation:l}=gr(n),d=e.length>2,f=d?"value += getBiasForMatmul();":"",p=d?`${cs(s,a,e[2].dims,i,!1)}`:"",m=i.length,b=t.length,y=o.length,$=t[t.length-1],x=`
    ${u}
    ${p}
    float process(int indices[${m}]) {
        int a[${b}];
        int b[${y}];
        bcastMatmulIndices_A(indices, a);
        bcastMatmulIndices_B(indices, b);

        float value;
        for (int k=0; k<${$}; ++k) {
            a[${b-1}] = k;
            b[${y-2}] = k;
            value += _A(a) * _B(b);
        }
        ${f}
        ${l}
        return value;
    }`;return{...r,output:{dims:i,type:e[0].type,textureType:0},shaderSource:x}}function ds(r,e){let n=$v(r.length>2,e.activationCacheKey);return{...n,get:()=>Sv(n,r,e)}}function cs(r,e,n,t,o){let i="",s=n.length,a=t.length,u=a-s;a<2&&s>0?i="coords":i=n.map((y,$)=>`coords.${e[$+u]}`).join(", ");let d=Dt.getBroadcastDims(n,t).map(y=>`coords.${e[y+u]} = 0;`).join(`
`),p=te.size(n)===1,m="vec4(outputValue.xx, outputValue.yy)";return p&&(m="vec4(outputValue.x)"),o?`
vec4 getBiasForMatmul() {
  ${r} coords = getOutputCoords();
  ${d}
  vec4 outputValue = getBias(${i});
  return ${m};
}`:`
float getBiasForMatmul() {
  ${r} coords = getOutputCoords();
  ${d}
  return getBias(coords.x);
}`}var Jc,Qc,$v,Iv,xi=D(()=>{"use strict";We();Ne();hr();dn();fs();Jc=(r,e,n)=>(Iv(e),r.session.pack?[r.run(Ti(r,e,n),e)]:[r.run(ds(e,n),e)]),Qc=r=>Pn(r.attributes),$v=(r,e)=>({name:"MatMul",inputNames:r?["A","B","Bias"]:["A","B"],inputTypes:r?[0,0,0]:[0,0],cacheHint:e});Iv=r=>{if(!r||r.length!==2)throw new Error("MatMul requires 2 inputs.");if(r[0].dims[r[0].dims.length-1]!==r[1].dims[r[1].dims.length-2])throw new Error("shared dimension does not match.");if(r[0].type!=="float32"&&r[0].type!=="float64"||r[1].type!=="float32"&&r[1].type!=="float64")throw new Error("inputs should be float type");if(r[0].type!==r[1].type)throw new Error("inputs types should match")}});function Ev(r,e,n,t){let o=[],i=[],s=n[0].dims,a=n[1].dims,u=s.length,l=a.length,d=t.length,f=d-u,p=d-l;o=s.map((A,E)=>`coords.${e[E+f]}`),o[u-1]="i*2",o.join(", "),i=a.map((A,E)=>`coords.${e[E+p]}`),i[l-2]="i*2",i.join(", ");let m=Dt.getBroadcastDims(s,t),b=Dt.getBroadcastDims(a,t),y=m.map(A=>`coords.${e[A+f]} = 0;`).join(`
`),$=b.map(A=>`coords.${e[A+p]} = 0;`).join(`
`),x=`int lastDim = coords.${e[d-1]};
  coords.${e[d-1]} = coords.${e[d-2]};
  coords.${e[d-2]} = lastDim;`;return`
vec4 getAAtOutCoordsMatmul(int i) {
  ${r} coords = getOutputCoords();
  ${x}
  ${y}
  vec4 outputValue = getA(${o});
  return outputValue;
}

vec4 getBAtOutCoordsMatmul(int i) {
  ${r} coords = getOutputCoords();
  ${x}
  ${$}
  vec4 outputValue = getB(${i});
  return outputValue;
}`}function Cv(r,e){let n="";for(let t=0;t<e-2;t++)n+=`rc.${r[t]}, `;return n+=`rc.${r[e-2]}, i*2`,n}function Pv(r,e){let n="";for(let t=0;t<e-2;t++)n+=`rc.${r[t]}, `;return n+=`i*2, rc.${r[e-1]}`,n}var Av,Ov,Ti,fs=D(()=>{"use strict";We();ot();Ne();hr();dn();xi();Av=(r,e)=>({name:"MatMul (packed)",inputNames:r?["A","B","Bias"]:["A","B"],inputTypes:r?[2,2,2]:[2,2],cacheHint:e}),Ov=(r,e,n,t)=>{let o=n.length>2,i=o?"value += getBiasForMatmul();":"",s=n[0].dims,a=n[1].dims,u=Dt.calcShape(s,a,!0),l=!te.areEqual(n[0].dims,n[1].dims);if(!u)throw new Error("Can't use matmul on the given tensors");let d=s[s.length-1],f=Math.ceil(d/2),p=s.length,m=a.length,b=ce(r.session.backend.glContext.version),y=Bt(u.length),$=u.length,x=sr(),{activationFunction:T,applyActivation:A}=gr(t),E=o?`${cs(y,x,n[2].dims,u,!0)}`:"",N=l?`${Ev(y,x,n,u)}`:"",B=l?"getAAtOutCoordsMatmul(i)":`getA(${Cv(x,p)})`,F=l?"getBAtOutCoordsMatmul(i)":`getB(${Pv(x,m)})`,P=l?"":`${y} rc =
          getOutputCoords(); int lastDim = rc.${x[$-1]}; rc.${x[$-1]} =
          rc.${x[$-2]}; rc.${x[$-2]} = lastDim;
      `,W=`
            ${N}
            ${E}
            ${T}
            void main() {
              ${P}

              vec4 value = vec4(0);
              for (int i = 0; i < ${f}; i++) {
                vec4 a = ${B};
                vec4 b = ${F};

                value += (a.rrbb * b.rgrg);
                value += (a.ggaa * b.baba);
              }
              ${i}
              ${A}
              ${b.output} = value;
            }`;return{...e,output:{dims:u,type:n[0].type,textureType:2},shaderSource:W,hasMain:!0}},Ti=(r,e,n)=>{let t=Av(e.length>2,n.activationCacheKey);return{...t,get:()=>Ov(r,t,e,n)}}});var ef,tf=D(()=>{"use strict";wi();Zc();fs();ef=(r,e,n)=>{let t=e[0].dims,o=e[1].dims,i=kn(t,o,n.dilations,n.pads,n.strides),s=r.run(Xc(r,e[0],e[1],i,n),[e[0]]),a=r.reshapePacked(e[1],[o[0],o[1]*o[2]*o[3]]),u=e.length===3?[a,s,e[2]]:[a,s],l=r.run(Ti(r,u,n),u);return r.reshapePacked(l,i)}});var kv,Dv,rf,ps,hs=D(()=>{"use strict";Ne();kv=r=>({name:"Im2Col",inputNames:["X"],inputTypes:[0],cacheHint:r}),Dv=(r,e,n,t,o,i)=>{let s=n.dims,a=t.dims,u=o.length,l=ps(s,a,o,4),d=`
        const int XC = ${s[1]};
        const int XH = ${s[2]};
        const int XW = ${s[3]};
        const int KH = ${i.kernelShape[0]};
        const int KW = ${i.kernelShape[1]};
        const int dilationH = ${i.dilations[0]};
        const int dilationW = ${i.dilations[1]};
        const int strideH = ${i.strides[0]};
        const int strideW = ${i.strides[1]};
        const int padH = ${i.pads[0]};
        const int padW = ${i.pads[1]};
        const int KHKW = KH*KW;
        const int XCKHKW = XC * KHKW;
        const int outputChannels = 4;
        vec4 process(int indices[${u}]) {
          int b  = indices[0]; // batch size
          int oh = indices[1] * strideH - padH; //output height
          int ow = indices[2] * strideW - padW; //output width
          int p = indices[3] * outputChannels; //patch
          vec4 value = vec4(0.0);
          for(int i=0; i < outputChannels; ++i) {
            if(p < XCKHKW) {
              int patchC = p / KHKW;
              int patchH = (p - patchC*KHKW) / KW;
              int patchW = (p - patchC*KHKW) - patchH * KW;
              int xh2 = oh + patchH * dilationH;
              int xw2 = ow + patchW * dilationW;
              int x[${s.length}];
              x[0] = b;
              x[1] = patchC;
              x[2] = xh2;
              x[3] = xw2;
              if(xh2 >= 0 &&
                  xh2 < XH &&
                  xw2 >= 0 &&
                  xw2 < XW) {
                value[i] = _X(x);
              }
            }
            ++p;
          }
          return value;
        }
        `;return{...e,output:{dims:l,type:n.type,textureType:4},shaderSource:d}},rf=(r,e,n,t,o)=>{let i=kv(o.cacheKey);return{...i,get:()=>Dv(r,i,e,n,t,o)}},ps=(r,e,n,t=4)=>[n[0],n[2],n[3],Math.ceil(r[1]*e[2]*e[3]/t)]});var Bv,Rv,nf,of=D(()=>{"use strict";We();ot();Ne();dn();hs();Bv=(r,e)=>({name:"ConvDotProduct",inputNames:r?["Im2Col","K","B"]:["Im2Col","K"],inputTypes:r?[0,4,0]:[0,4],cacheKey:e.activationCacheKey}),Rv=(r,e,n,t,o)=>{let i=n[0].dims,s=n[1].dims,a=[s[0],Math.ceil(i[1]*s[2]*s[3]/4)],u=ps(i,s,t),[l,d]=r.calculateTextureWidthAndHeight(a,4),f=te.computeStrides(u),[p,m]=r.calculateTextureWidthAndHeight(u,4),b=t.length,y=n.length<3?"0.0":"_B(b)",$=Math.ceil(i[1]*s[2]*s[3]/4),{activationFunction:x,applyActivation:T}=gr(o),A=ce(r.session.backend.glContext.version),E=`
${x}
float process(int indices[${b}]) {
  int b[1];
  b[0] = indices[1];
  int im2col[4];
  im2col[0] = indices[0];
  im2col[1] = indices[2];
  im2col[2] = indices[3];
  int im2colOffset = im2col[0] * ${f[0]} + im2col[1] * ${f[1]} + im2col[2] * ${f[2]};
  int kernelOffset = indices[1] * ${a[1]};
  float value = ${y};
  for (int i = 0; i < ${$}; ++i) {
    vec2 im2colCoords = offsetToCoords(im2colOffset, ${p}, ${m});
    vec2 kernelCoords = offsetToCoords(kernelOffset, ${l}, ${d});
    value += dot(${A.texture2D}(Im2Col, im2colCoords), ${A.texture2D}(K, kernelCoords));
    ++im2colOffset;
    ++kernelOffset;
  }
  ${T}
  return value;
}`;return{...e,output:{dims:t,type:n[0].type,textureType:0},shaderSource:E}},nf=(r,e,n,t)=>{let o=Bv(e.length>2,t);return{...o,get:()=>Rv(r,o,e,n,t)}}});var kn,ms,zv,Nv,Lv,Mv,gs,Vv,wi=D(()=>{"use strict";St();We();Yc();tf();of();dn();hs();xi();kn=(r,e,n,t,o)=>{let i=r[0],s=r.slice(2),a=s.length,u=e[0],d=e.slice(2).map((b,y)=>b+(b-1)*(n[y]-1)),p=s.map((b,y)=>b+t[y]+t[y+a]).map((b,y)=>Math.floor((b-d[y]+o[y])/o[y]));return[i,u].concat(...p)},ms=(r,e,n)=>(Vv(e,n),zv(r,e,n)),zv=(r,e,n)=>{let t=Mv(n,e),o=r.session.pack,i=t.kernelShape[0]===1&&t.kernelShape[1]===1;return t.group>1?[r.run(Kc(r,e,t),e)]:i&&o?[Nv(r,e,t)]:o&&e[0].dims.length===4&&e[0].dims[0]===1&&!i?[ef(r,e,t)]:[Lv(r,e,t)]},Nv=(r,e,n)=>{let t=e[0].dims,o=e[1].dims,i=kn(t,o,n.dilations,n.pads,n.strides),s=r.reshapeUnpacked(e[0],[t[1],t[2]*t[3]]),a=r.reshapeUnpacked(e[1],[o[0],o[1]]),u=e.length>2?[a,s,e[2]]:[a,s],l=r.run(ds(u,n),u);return r.reshapeUnpacked(l,i)},Lv=(r,e,n)=>{let t=e[0].dims,o=e[1].dims,i=kn(t,o,n.dilations,n.pads,n.strides),s=r.run(rf(r,e[0],e[1],i,n),[e[0]]),a=e.length===3?[s,e[1],e[2]]:[s,e[1]];return r.run(nf(r,e,i,n),a)},Mv=(r,e)=>{let n=r.kernelShape.slice();if(r.kernelShape.length===0)for(let i=2;i<e[1].dims.length;++i)n.push(e[1].dims[i]);let t=r.pads.slice();on.adjustPadsBasedOnAutoPad(e[0].dims,r.strides,r.dilations,n,t,r.autoPad);let o=Object.assign({},r);return Object.assign(o,{kernelShape:n,pads:t,cacheKey:r.cacheKey}),o},gs=r=>{let e=r.attributes,n=Pn(e),t=e.getString("auto_pad","NOTSET"),o=e.getInts("dilations",[1,1]),i=e.getInt("group",1),s=e.getInts("kernel_shape",[]),a=e.getInts("pads",[0,0,0,0]),u=e.getInts("strides",[1,1]);return Ae({autoPad:t,dilations:o,group:i,kernelShape:s,pads:a,strides:u,...n})},Vv=(r,e)=>{if(!r||r.length!==2&&r.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(r[0].dims.length!==4||r[1].dims.length!==4)throw new Error("currently only support 2-dimensional conv");let n=r[0].dims[1],t=r[1].dims[1]*e.group;if(n!==t)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");if(r.length===3&&(r[2].dims.length!==1||r[1].dims[0]!==r[2].dims[0]))throw new Error("invalid bias");let o=r[0].dims.length-2;if(e.dilations.length!==o)throw new Error(`dilations should be ${o}D`);if(e.strides.length!==o)throw new Error(`strides should be ${o}D`);if(e.pads.length!==o*2)throw new Error(`pads should be ${o*2}D`);if(e.kernelShape.length!==0&&e.kernelShape.length!==r[1].dims.length-2)throw new Error("invalid kernel shape");if(r[0].type!=="float32"||r[1].type!=="float32")throw new Error("Conv input(X,W) should be float tensor");if(r.length===3&&r[2].type!=="float32")throw new Error("Conv input(bias) should be float tensor")}});var Fv,Uv,Gv,af,Wv,Hv,qv,jv,Kv,Yv,sf,Xv,uf=D(()=>{"use strict";St();ot();Ne();dn();Fv=(r,e,n,t,o,i)=>(r-1)*e+n+(t-1)*o+1-i,Uv=(r,e,n,t,o)=>{let i=Math.floor(r/2);e==="SAME_UPPER"?(n[t]=i,n[o]=r-i):e==="SAME_LOWER"&&(n[t]=r-i,n[o]=i)},Gv=(r,e,n,t,o,i,s,a)=>{let u=r.length-2,l=a.length===0;for(let d=0;d<u;++d){let f=l?r[d+2]*i[d]:a[d],p=Fv(r[d+2],i[d],o[d],e[d],n[d],f);Uv(p,t,o,d,d+u),l&&a.push(i[d]*(r[d+2]-1)+s[d]+(e[d]-1)*n[d]+1-o[d]-o[d+u])}},af=(r,e,n)=>(Xv(e,n),Wv(r,e,n)),Wv=(r,e,n)=>{let t=Yv(n,e);return[Kv(r,e,t)]},Hv=(r,e)=>({name:"ConvTranspose",inputNames:r?["X","W","B"]:["X","W"],inputTypes:r?[0,0,0]:[0,0],cacheHint:e}),qv=(r,e,n,t)=>{let i=e.length>2?"getB(output_channel)":"0.0",s=e[0].dims,a=e[1].dims,u=a[1],l=a[0]/t.group,d=[e[0].dims[0],e[1].dims[1]*t.group,...t.outputShape],f=ce(r.session.backend.glContext.version),{activationFunction:p,applyActivation:m}=gr(t),b=`
  const ivec2 strides = ivec2(${t.strides[0]}, ${t.strides[1]});
  const ivec2 pads = ivec2(${t.pads[0]}, ${t.pads[1]});
  ${p}
  void main() {
    ivec4 coords = getOutputCoords();
    int batch = coords.x;
    int output_channel = coords.y;

    ivec2 loc = coords.zw + pads;

    int group_id = output_channel / ${u};
    int wOutChannel = output_channel - group_id * ${u};

    float value = ${i};
    for (int inChannelOffset = 0; inChannelOffset < ${l}; inChannelOffset++) {
      int input_channel = group_id * ${l} + inChannelOffset;
      for (int wWOff = 0; wWOff < ${a[2]}; wWOff++) {
        for (int wHOff = 0; wHOff < ${a[3]}; wHOff++) {
          ivec2 wOff = ivec2(wWOff * ${t.dilations[0]}, wHOff * ${t.dilations[1]});
          ivec2 wLoc = loc - wOff;
          ivec2 wLocIn = wLoc / strides;
          if (
            wLocIn * strides == wLoc &&
            wLocIn.x >= 0 && wLocIn.x < ${s[2]} &&
            wLocIn.y >= 0 && wLocIn.y < ${s[3]}
          ) {
            float xVal = getX(batch, input_channel, wLocIn.y, wLocIn.x);
            float wVal = getW(input_channel, wOutChannel, wHOff, wWOff);
            value += xVal * wVal;
          }
        }
      }
    }
    ${m}
    ${f.output} = vec4(value, .0, .0, .0);
  }
`;return{...n,output:{dims:d,type:e[0].type,textureType:0},shaderSource:b,hasMain:!0}},jv=(r,e,n)=>{let t=Hv(e.length>2,n.cacheKey);return{...t,get:()=>qv(r,e,t,n)}},Kv=(r,e,n)=>r.run(jv(r,e,n),e),Yv=(r,e)=>{let n=r.kernelShape.slice();if(r.kernelShape.length===0)for(let a=2;a<e[1].dims.length;++a)n.push(e[1].dims[a]);let t=r.pads.slice(),o=r.outputShape.slice(),i=e[0].dims;Gv(i,n,r.dilations,r.autoPad,t,r.strides,r.outputPadding,o);let s=Object.assign({},r);return Object.assign(s,{kernelShape:n,pads:t,outputShape:o,cacheKey:r.cacheKey}),s},sf=r=>{let e=r.attributes,n=Pn(e),t=e.getString("auto_pad","NOTSET"),o=e.getInts("dilations",[1,1]),i=e.getInt("group",1),s=e.getInts("kernel_shape",[]),a=e.getInts("output_padding",[0,0]),u=e.getInts("output_shape",[]),l=e.getInts("pads",[0,0,0,0]),d=e.getInts("strides",[1,1]);return Ae({autoPad:t,dilations:o,group:i,kernelShape:s,outputPadding:a,outputShape:u,pads:l,strides:d,...n})},Xv=(r,e)=>{if(!r||r.length!==2&&r.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(r[0].dims.length!==4||r[1].dims.length!==4)throw new Error("currently only support 2-dimensional conv");let n=r[0].dims[1],t=r[1].dims[0];if(n!==t)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");let o=r[1].dims[1]*e.group;if(r.length===3&&(r[2].dims.length!==1||r[2].dims[0]!==o))throw new Error("invalid bias");let i=r[0].dims.length-2;if(e.dilations.length!==i)throw new Error(`dilations should be ${i}D`);if(e.strides.length!==i)throw new Error(`strides should be ${i}D`);if(e.pads.length!==i*2)throw new Error(`pads should be ${i*2}D`);if(e.outputPadding.length!==i)throw new Error(`output_padding should be ${i}D`);if(e.kernelShape.length!==0&&e.kernelShape.length!==r[1].dims.length-2)throw new Error("invalid kernel shape");if(e.outputShape.length!==0&&e.outputShape.length!==r[0].dims.length-2)throw new Error("invalid output shape");if(r[0].type!=="float32"||r[1].type!=="float32")throw new Error("ConvTranspose input(X,W) should be float tensor");if(r.length===3&&r[2].type!=="float32")throw new Error("ConvTranspose input(bias) should be float tensor")}});var lf,cn,df,Zv,cf,Jv,Qv,ew,_i=D(()=>{"use strict";St();We();Ne();lf={name:"Transpose",inputNames:["A"],inputTypes:[0]},cn=(r,e,n)=>(ew(e),[r.run({...lf,cacheHint:n.cacheKey,get:()=>Zv(r,e[0],n.perm)},e)]),df=r=>Ae({perm:r.attributes.getInts("perm",[])}),Zv=(r,e,n)=>{let t=e.dims;n=cf(t,n);let o=Jv(t,n),i=t.length,s=`
      ${Qv("perm",n,i)}
      float process(int indices[${i}]) {
        int a[${i}];
        perm(a, indices);
        return _A(a);
      }`;return{...lf,output:{dims:o,type:e.type,textureType:0},shaderSource:s}},cf=(r,e)=>(e&&e.length!==r.length&&(e=[...r.keys()].reverse()),e),Jv=(r,e)=>(e=cf(r,e),te.sortBasedOnPerm(r,e)),Qv=(r,e,n)=>{let t=[];t.push(`void ${r}(out int a[${n}], int src[${n}]) {`);for(let o=0;o<n;++o)t.push(`	a[${e[o]}]=src[${o}];`);return t.push("	}"),t.join(`
`)},ew=r=>{if(!r||r.length!==1)throw new Error("Transpose requires 1 input.");if(r[0].type!=="float32"&&r[0].type!=="float64")throw new Error("input should be float tensor")}});var ff,pf,tw,hf=D(()=>{"use strict";_i();ff=(r,e,n)=>{tw(e);let t=n.blocksize,o=t*t,i=n.mode==="DCR"?[0,3,4,1,5,2]:[0,1,4,2,5,3],s=n.mode==="DCR"?[e[0].dims[0],t,t,e[0].dims[1]/o,e[0].dims[2],e[0].dims[3]]:[e[0].dims[0],e[0].dims[1]/o,t,t,e[0].dims[2],e[0].dims[3]],a=r.reshapeUnpacked(e[0],s),u={perm:i,cacheKey:`${i}`},[l]=cn(r,[a],u),d=[e[0].dims[0],e[0].dims[1]/o,e[0].dims[2]*t,e[0].dims[3]*t];return[r.reshapeUnpacked(l,d)]},pf=r=>{let e=r.attributes.getInt("blocksize");if(e<1)throw new Error(`blocksize must be >= 1, but got : ${e} for DepthToSpace`);let n=r.attributes.getString("mode","DCR");if(n!=="DCR"&&n!=="CRD")throw new Error(`unrecognized mode: ${n} for DepthToSpace`);return{mode:n,blocksize:e}},tw=r=>{if(r.length!==1)throw new Error(`DepthToSpace expect 1 inputs, but got ${r.length}`);if(r[0].type==="string"||r[0].dims.length!==4)throw new TypeError("DepthToSpace input should be a 4-D numeric tensor")}});var mf,gf,rw,bf=D(()=>{"use strict";We();mf=(r,e,n)=>{rw(e,n);let t=te.flattenShape(e[0].dims,n);return[r.reshapeUnpacked(e[0],t)]},gf=r=>r.attributes.getInt("axis",1),rw=(r,e)=>{if(!r||r.length!==1)throw new Error("Flatten requires 1 input.");let n=r[0].dims.length;if(n===0)throw new Error("scalar tensor is not supported.");if(e<-n||e>n)throw new Error("Invalid axis");if(r[0].type==="string")throw new Error("string tensor is not supported.")}});var Wr,go=D(()=>{"use strict";Wr=["float32","float64","int32","int16","int8","uint16","uint32","uint8"]});var yf,vf,nw,ow,iw,aw,wf=D(()=>{"use strict";St();go();We();Ne();yf=(r,e,n)=>(aw(e,n.axis),[r.run(iw(r,e,n),e)]),vf=r=>Ae({axis:r.attributes.getInt("axis",0)}),nw={name:"Gather",inputNames:["A","B"],inputTypes:[0,0]},ow=(r,e,n,t)=>{let o=n[0].dims.slice(),i=n[1].dims.slice(),s=new Array(o.length+i.length-1);t=te.normalizeAxis(t,o.length);let a=[];for(let p=0;p<s.length;p++)p<t?(s[p]=o[p],a.push(`inputIdx[${p}] = outputIdx[${p}];`)):p<t+i.length?(s[p]=i[p-t],a.push(`indexDataIdx[${p-t}] = outputIdx[${p}];`)):(s[p]=o[p-i.length+1],a.push(`inputIdx[${p-i.length+1}] = outputIdx[${p}];`));let u=s.length||1,l=o.length,d=i.length||1,f=`
      float process(int outputIdx[${u}]) {
        int inputIdx[${l}];
        int indexDataIdx[${d}];
        indexDataIdx[0] = 0;
        ${a.join(`
        `)}
        int idx = int(_B(indexDataIdx));
        inputIdx[${t}] = idx < 0 ? idx + ${o[t]} : idx;
        return _A(inputIdx);
      }`;return{...e,output:{dims:s,type:n[0].type,textureType:0},shaderSource:f}},iw=(r,e,n)=>{let t={...nw,cacheHint:n.cacheKey};return{...t,get:()=>ow(r,t,e,n.axis)}},aw=(r,e)=>{if(!r||r.length!==2)throw new Error("Gather requires 2 inputs.");let n=r[0].dims.length;if(n<1)throw new Error("Invalid input shape.");if(e<-n||e>n-1)throw new Error("Invalid axis.");if(Wr.indexOf(r[0].type)===-1)throw new Error("Invaid input type.");if(r[1].type!=="int32"&&r[1].type!=="int16")throw new Error("Invaid input type.")}});var bs,xf,Tf,_f,sw,uw,lw,$f=D(()=>{"use strict";St();We();Ne();bs=(r,e,n)=>(lw(e,n),[r.run(sw(e,n),e)]),xf=(r,e)=>{let n=r.attributes.getInt("transA",0)!==0,t=r.attributes.getInt("transB",0)!==0,o=r.attributes.getFloat("alpha",1),i=r.attributes.getFloat("beta",1);return Ae({transA:n,transB:t,alpha:o,beta:i,isOptionalC:e})},Tf=r=>xf(r,!1),_f=r=>xf(r,!0),sw=(r,e)=>{let n={name:"Gemm",inputNames:r.length===3?["A","B","C"]:["A","B"],inputTypes:r.length===3?[0,0,0]:[0,0],key:e.cacheKey};return{...n,get:()=>uw(n,r,e)}},uw=(r,e,n)=>{let t=e[0].dims.slice(),o=e[1].dims.slice(),[i,s]=fi.getShapeOfGemmResult(t,n.transA,o,n.transB,e.length===3?e[2].dims:void 0),a=[i,s];if(!a)throw new Error("Can't use gemm on the given tensors");let u=t[t.length-1],l="";n.transA&&(u=t[0]),n.transA&&n.transB?l="value += _A_T(a) * _B_T(b);":n.transA&&!n.transB?l="value += _A_T(a) * _B(b);":!n.transA&&n.transB?l="value += _A(a) * _B_T(b);":!n.transA&&!n.transB&&(l="value += _A(a) * _B(b);");let d=a.length,f=e.length===3?`int c[${e[2].dims.length}];`:"",p=e.length===3?"bcastIndices_C(indices, c);":"",m=e.length===3?"value += beta * _C(c);":"",b=`
      float process(int indices[${d}]) {
          int a[${d}];
          int b[${d}];
          ${f}

          copyVec(indices, a);
          copyVec(indices, b);
          ${p}

          float value = 0.0;
          for (int k=0; k<${u}; ++k) {
              a[${d-1}] = k;
              b[${d-2}] = k;
              ${l}
          }

          value = value * alpha;
          ${m}
          return value;
      }`;return{...r,output:{dims:a,type:e[0].type,textureType:0},variables:[{name:"alpha",type:"float",data:n.alpha},{name:"beta",type:"float",data:n.beta}],shaderSource:b}},lw=(r,e)=>{if(!r)throw new Error("Input is missing");if(e.isOptionalC&&(r.length<2||r.length>3))throw new Error("Invaid input shape.");if(!e.isOptionalC&&r.length!==3)throw new Error("Gemm requires 3 inputs");if(r.length===3&&r[2].dims.length!==1&&r[2].dims.length!==2)throw new Error("Invalid input shape of C");if(r[0].type!=="float32"&&r[0].type!=="float64"||r[1].type!=="float32"&&r[1].type!=="float64"||r.length===3&&r[2].type!=="float32"&&r[2].type!=="float64")throw new Error("Invalid input type.");if(r[0].type!==r[1].type||r.length===3&&r[0].type!==r[2].type)throw new Error("Input types are mismatched")}});var Sf,If,dw,cw,fw,pw,hw,Af=D(()=>{"use strict";St();Ne();Sf=(r,e,n)=>(hw(e),[r.run(fw(r,e,n),e)]),If=r=>{let e=r.attributes.getFloat("scale"),n=r.attributes.getFloats("bias");return Ae({scale:e,bias:n})},dw={name:"ImageScaler",inputNames:["X"],inputTypes:[0]},cw=(r,e,n,t)=>{let o=n[0].dims.slice(),i=o.length,a=`
      ${pw(t.bias.length)}
      float process(int indices[${i}]) {
        return _X(indices) * scale + getBias(bias, indices[1]);
      }`;return{...e,output:{dims:o,type:n[0].type,textureType:0},variables:[{name:"bias",type:"float",arrayLength:t.bias.length,data:t.bias},{name:"scale",type:"float",data:t.scale}],shaderSource:a}},fw=(r,e,n)=>{let t={...dw,cacheHint:n.cacheKey};return{...t,get:()=>cw(r,t,e,n)}},pw=r=>{let e=[`float getBias(float bias[${r}], int channel) {`];for(let n=0;n<r;++n)n===0?e.push(`	if (channel == ${n}) { return bias[${n}]; }`):n===r-1?e.push(`	else { return bias[${n}]; }`):e.push(`	else if (channel == ${n}) { return bias[${n}]; }`);return e.push("	}"),e.join(`
`)},hw=r=>{if(!r||r.length!==1)throw new Error("ImageScaler requires 1 input.");if(r[0].dims.length!==4)throw new Error("Invalid input shape.");if(r[0].type!=="float32"&&r[0].type!=="float64")throw new Error("Invalid input type.")}});var Ef,Cf,Of,mw,gw,bw,yw,vw,ww,Pf=D(()=>{"use strict";ot();Ne();Ef=(r,e,n)=>{ww(e);let t=r.run(gw(e[0]),e);return[r.run(vw(r,e[0],n,t.dims),[e[0],t,e[1],e[2]])]},Cf=r=>r.attributes.getFloat("epsilon",1e-5),Of={name:"InstanceNormalization_MeanAndVariance",inputNames:["X"],inputTypes:[0]},mw=(r,e)=>{let n=e.dims.slice(),t=n[1],o=n[2]*n[3],i=[n[0],t],s=`
      vec4 process(int[2] indices) {
        vec4 v = vec4(0.0);
        int a[4];
        a[0] = indices[0];
        a[1] = indices[1];
        float temp = 0.0;
        for(int a2=0; a2<${n[2]}; a2++) {
          a[2] = a2;
          for(int a3=0; a3<${n[3]}; a3++) {
            a[3] = a3;
            float x = _X(a);
            temp += x;
          }
        }
        float mean = temp / float(${o});
        temp = 0.0;
        for(int a2=0; a2<${n[2]}; a2++) {
          a[2] = a2;
          for(int a3=0; a3<${n[3]}; a3++) {
            a[3] = a3;
            float x = _X(a);
            temp += (x - mean) * (x - mean);
          }
        }
        v.r = mean;
        v.g = temp / float(${o});

        return v;
      }`;return{...r,output:{dims:i,type:e.type,textureType:4},shaderSource:s}},gw=r=>({...Of,get:()=>mw(Of,r)}),bw={name:"InstanceNormalization_ComputeOutput",inputNames:["X","MeanAndVariance","Scale","B"],inputTypes:[0,4,0,0]},yw=(r,e,n,t,o)=>{let i=ce(r.session.backend.glContext.version),[s,a]=r.calculateTextureWidthAndHeight(o,4),[u,l]=[s/4,a],d=`
      vec4 get_MeanAndVariance(int[2] mv) {
        int offset = indicesToOffset_MeanAndVariance(mv);
        vec2 coords = offsetToCoords(offset, ${u}, ${l});
        return ${i.texture2D}(MeanAndVariance, coords);
      }

      float process(int[4] indices) {
        int mv[2];
        mv[0] = indices[0];
        mv[1] = indices[1];
        vec4 mean_and_variance = get_MeanAndVariance(mv);
        float mean = mean_and_variance.r;
        float variance = mean_and_variance.g;

        int sb[1];
        sb[0] = indices[1];
        float scale = _Scale(sb);
        float b = _B(sb);

        return scale * (_X(indices) - mean) / sqrt(variance + epsilon) + b;
      }`;return{...e,output:{dims:n.dims,type:n.type,textureType:0},variables:[{name:"epsilon",type:"float",data:t}],shaderSource:d}},vw=(r,e,n,t)=>{let o={...bw,cacheHint:`${n}`};return{...o,get:()=>yw(r,o,e,n,t)}},ww=r=>{if(!r||r.length!==3)throw new Error("InstanceNormalization requires 3 inputs.");let e=r[0],n=r[1],t=r[2];if(e.dims.length<3||n.dims.length!==1||t.dims.length!==1)throw new Error("Invalid input shape.");if(n.dims[0]!==e.dims[1]||t.dims[0]!==e.dims[1])throw new Error("Input shapes are mismatched.");if(e.type!=="float32"&&e.type!=="float64"||n.type!=="float32"&&n.type!=="float64"||t.type!=="float32"&&t.type!=="float64")throw new Error("Invalid input type.");if(r[0].dims.length!==4)throw new Error("Only support 4-D input shape.")}});function xw(r,e){let n=r[0].dims[1],t=r[0].dims.length,o=-Math.floor((e.size-1)/2),i=Math.ceil((e.size-1)/2),s=`float(${e.alpha}) / float(${e.size})`,a=`float(${e.bias})`,u=`float(${e.beta})`,l=`
    float process(int indices[${t}]) {
        int c = indices[1];
        float x = _X(indices);
        float square_sum = 0.0;

        for (int i = ${o}; i <= ${i}; i++) {
          int idx = c + i;
          if (c >= 0 && c < ${n}) {
            indices[1] = idx;
            float j = _X(indices);
            square_sum += j * j;
          }
        }
        return x / pow(${a} + ${s} * square_sum, ${u});
    }`;return{...Bf,cacheHint:e.cacheKey,output:{dims:r[0].dims,type:r[0].type,textureType:0},shaderSource:l}}function Tw(r,e){return{...Bf,cacheHint:e.cacheKey,get:()=>xw(r,e)}}var kf,Df,Bf,_w,Rf=D(()=>{"use strict";St();Ne();kf=(r,e,n)=>(_w(e),[r.run(Tw(e,n),e)]),Df=r=>{let e=r.attributes.getFloat("alpha",1e-4),n=r.attributes.getFloat("beta",.75),t=r.attributes.getFloat("bias",1),o=r.attributes.getInt("size");return Ae({alpha:e,beta:n,bias:t,size:o})},Bf={name:"LRN",inputNames:["X"],inputTypes:[0]};_w=r=>{if(!r||r.length!==1)throw new Error("LRN requires 1 input.");if(r[0].dims.length!==4)throw new Error('currently only support LRN for input with "NCHW" format');if(r[0].type!=="float32")throw new Error("input should be float type")}});var $w,ys,zf,Nf,Lf,Sw,Iw,Aw,Ow,Ew,Cw,Pw,kw,Mf=D(()=>{"use strict";St();We();ot();Ne();$w={name:"Pad",inputNames:["A"],inputTypes:[0]},ys=(r,e,n)=>(Aw(e),[r.run({...$w,cacheHint:n.cacheKey,get:()=>Iw(r,e[0],n)},e)]),zf=r=>{let e=r.attributes.getString("mode","constant"),n=r.attributes.getFloat("value",0),t=r.attributes.getInts("pads");return Ae({mode:e,value:n,pads:t})},Nf=(r,e,n)=>{Ow(e);let t=Sw(r,e,n);return ys(r,[e[0]],t)},Lf=r=>r.attributes.getString("mode","constant"),Sw=(r,e,n)=>{if(!r.session.isInitializer(e[1].dataId)||e.length>=3&&!r.session.isInitializer(e[2].dataId))throw new Error("dynamic pad attributes are not allowed");let t=Array.from(e[1].integerData),o=e.length>=3?e[2].floatData[0]:0;return Ae({mode:n,pads:t,value:o})},Iw=(r,e,n)=>{let t=te.padShape(e.dims.slice(),n.pads),o=t.length,s=`
      ${Ew(r,e,n)}
      float process(int[${o}] indices) {
          return padA(indices);
      }`;return{name:"Pad",inputNames:["A"],inputTypes:[0],output:{dims:t,type:e.type,textureType:0},shaderSource:s}},Aw=r=>{if(!r||r.length!==1)throw new Error("Pad requires 1 input");if(r[0].type!=="float32"&&r[0].type!=="float64")throw new Error("Invalid input type.")},Ow=r=>{if(!r||r.length!==2&&r.length!==3)throw new Error("Pad requires 2 or 3 inputs");if(r[1].type!=="int32")throw new Error("Invalid input type.");if(r.length>=3&&r[2].type==="string")throw new Error("Invalid input type.")},Ew=(r,e,n)=>{let t=ce(r.session.backend.glContext.version),[o,i]=r.calculateTextureWidthAndHeight(e.dims,0),s=te.computeStrides(e.dims);switch(n.mode){case"constant":return Cw(t,e.dims,s,o,i,n.pads,n.value);case"reflect":return Pw(t,e.dims,s,o,i,n.pads);case"edge":return kw(t,e.dims,s,o,i,n.pads);default:throw new Error("Invalid mode")}},Cw=(r,e,n,t,o,i,s)=>{let a=e.length,u="";for(let l=a-1;l>=0;--l)u+=`
        k = m[${l}] - ${i[l]};
        if (k < 0)  return constant;
        if (k >= ${e[l]}) return constant;
        offset += k * ${n[l]};
        `;return`
      float padA(int m[${a}]) {
        const float constant = float(${s});
        int offset = 0;
        int k = 0;
        ${u}
        vec2 coords = offsetToCoords(offset, ${t}, ${o});
        float value = getColorAsFloat(${r.texture2D}(A, coords));
        return value;
      }
      `},Pw=(r,e,n,t,o,i)=>{let s=e.length,a="";for(let u=s-1;u>=0;--u)a+=`
        k = m[${u}] - ${i[u]};
        if (k < 0) { k = -k; }
        {
          const int _2n_1 = ${2*(e[u]-1)};
          k = int( mod( float(k), float(_2n_1) ) ) ;
          if(k >= ${e[u]}) { k = _2n_1 - k; }
        }
        offset += k * ${n[u]};
        `;return`
      float padA(int m[${s}]) {
        int offset = 0;
        int k = 0;
        ${a}
        vec2 coords = offsetToCoords(offset, ${t}, ${o});
        float value = getColorAsFloat(${r.texture2D}(A, coords));
        return value;
      }
      `},kw=(r,e,n,t,o,i)=>{let s=e.length,a="";for(let u=s-1;u>=0;--u)a+=`
        k = m[${u}] - ${i[u]};
        if (k < 0)  k = 0;
        if (k >= ${e[u]}) k = ${e[u]-1};
        offset += k * ${n[u]};
      `;return`
      float padA(int m[${s}]) {
        int offset = 0;
        int k = 0;
        ${a}
        vec2 coords = offsetToCoords(offset, ${t}, ${o});
        float value = getColorAsFloat(${r.texture2D}(A, coords));
        return value;
      }
      `}});var Ff,Uf,Gf,Wf,Hf,qf,jf,Kf,Yf,Dw,Vf,Xf,Si,Zf,$i,Bw,Jf=D(()=>{"use strict";St();We();Ne();Ff=(r,e,n)=>{Si(e);let t={name:"AveragePool",inputNames:["X"],inputTypes:[0],cacheHint:n.cacheKey};return[r.run({...t,get:()=>Gf(e,t,!1,n)},e)]},Uf=r=>{let e=r.attributes.getString("auto_pad","NOTSET"),n=r.attributes.getInt("ceil_mode",0),t=r.attributes.getInt("count_include_pad",0)!==0,o=r.attributes.getInts("kernel_shape"),i=r.attributes.getInts("strides",[]),s=r.attributes.getInts("pads",[]);if(n!==0)throw new Error("using ceil() in shape computation is not yet supported for AveragePool");return Ae({autoPad:e,ceilMode:n,countIncludePad:t,kernelShape:o,strides:i,pads:s})},Gf=(r,e,n,t)=>{let[o,i]=Yf(r,t,n),s=te.size(o.kernelShape),a="value += _X(x);",u="";o.countIncludePad?u+=`value /= float(${s});`:u+=`value /= float(${s} - pad);`;let d=`
        ${Zf(r[0].dims,o,a,u,"0.0")}
      `;return{...e,output:{dims:i,type:r[0].type,textureType:0},shaderSource:d}},Wf=(r,e,n)=>{Si(e);let t={name:"GlobalAveragePool",inputNames:["X"],inputTypes:[0],cacheHint:`${n.countIncludePad}`};return[r.run({...t,get:()=>Gf(e,t,!0,n)},e)]},Hf=r=>{let e=r.attributes.getInt("count_include_pad",0)!==0;return Ae({autoPad:"",ceilMode:0,countIncludePad:e,kernelShape:[],strides:[],pads:[]})},qf=(r,e,n)=>{Si(e);let t={name:"MaxPool",inputNames:["X"],inputTypes:[0],cacheHint:n.cacheKey};return[r.run({...t,get:()=>Kf(e,t,!1,n)},e)]},jf=r=>{let e=r.attributes.getString("auto_pad","NOTSET"),n=r.attributes.getInt("ceil_mode",0),t=r.attributes.getInts("kernel_shape"),o=r.attributes.getInts("strides",[]),i=r.attributes.getInts("pads",[]),s=r.attributes.getInt("storage_order",0),a=r.attributes.getInts("dilations",[]);if(s!==0)throw new Error("column major storage order is not yet supported for MaxPool");if(n!==0)throw new Error("using ceil() in shape computation is not yet supported for MaxPool");return Ae({autoPad:e,ceilMode:n,countIncludePad:!1,kernelShape:t,strides:o,pads:i,storageOrder:s,dilations:a})},Kf=(r,e,n,t)=>{let[o,i]=Yf(r,t,n),s=`
      value = max(_X(x), value);
    `,a="",l=`
      ${Zf(r[0].dims,o,s,a,"-1e5")}
    `;return{...e,output:{dims:i,type:r[0].type,textureType:0},shaderSource:l}},Yf=(r,e,n)=>{let t=r[0].dims.slice(),o=Object.hasOwnProperty.call(e,"dilations"),i=e.kernelShape.slice(),s=e.strides.slice(),a=o?e.dilations.slice():[],u=e.pads.slice();on.adjustPoolAttributes(n,t,i,s,a,u);let l=on.computePoolOutputShape(n,t,s,a,i,u,e.autoPad),d=Object.assign({},e);return o?Object.assign(d,{kernelShape:i,strides:s,pads:u,dilations:a,cacheKey:e.cacheKey}):Object.assign(d,{kernelShape:i,strides:s,pads:u,cacheKey:e.cacheKey}),[d,l]},Dw={autoPad:"",ceilMode:0,countIncludePad:!1,kernelShape:[],strides:[],pads:[],storageOrder:0,dilations:[],cacheKey:""},Vf={name:"GlobalMaxPool",inputNames:["X"],inputTypes:[0]},Xf=(r,e)=>(Si(e),[r.run({...Vf,get:()=>Kf(e,Vf,!0,Dw)},e)]),Si=r=>{if(!r||r.length!==1)throw new Error("Pool ops requires 1 input.");if(r[0].type!=="float32"&&r[0].type!=="float64")throw new Error("Invalid input type.")},Zf=(r,e,n,t,o)=>{let i=r.length;if(e.kernelShape.length<=2){let s=e.kernelShape[e.kernelShape.length-1],a=e.strides[e.strides.length-1],u=e.pads[e.pads.length/2-1],l=e.pads[e.pads.length-1],d=r[i-1],f="",p="",m="";if(u+l!==0?f=`
          for (int i = 0; i < ${s}; i++) {
            x[${i} - 1] = indices[${i} - 1] * ${a} - ${u} + i;
            if (x[${i} - 1] < 0 || x[${i} - 1] >= ${d}) {
              pad++;
              continue;
            }
            ${n}
          }`:f=`
          for (int i = 0; i < ${s}; i++) {
            x[${i} - 1] = indices[${i} - 1] * ${a} - ${u} + i;
            ${n}
          }`,e.kernelShape.length===2){let y=e.kernelShape[e.kernelShape.length-2],$=e.strides[e.strides.length-2],x=e.pads[e.pads.length/2-2],T=e.pads[e.pads.length-2],A=r[i-2];x+T!==0?p=`
            for (int j = 0; j < ${y}; j++) {
              x[${i} - 2] = indices[${i} - 2] * ${$} - ${x} + j;
              if (x[${i} - 2] < 0 || x[${i} - 2] >= ${A}) {
                pad+= ${s};
                continue;
              }
          `:p=`
            for (int j = 0; j < ${y}; j++) {
              x[${i} - 2] = indices[${i} - 2] * ${$} - ${x} + j;
            `,m=`
          }
        `}return`
        float process(int indices[${i}]) {
          int x[${i}];
          copyVec(indices, x);

          float value = ${o};
          int pad = 0;
          ${p}
          ${f}
          ${m}
          ${t}
          return value;
        }
      `}else{let s=te.size(e.kernelShape),a=te.computeStrides(e.kernelShape),u=a.length,l=e.pads.length,d=Bw(u),f=$i(r,"inputDims"),p=$i(e.pads,"pads"),m=$i(a,"kernelStrides"),b=$i(e.strides,"strides"),y=e.pads.reduce((T,A)=>T+A),$="";return y?$=`
            if (x[j] >= inputDims[j] || x[j] < 0) {
              pad++;
              isPad = true;
              break;
            }
          }
          if (!isPad) {
            ${n}
          }`:$=`
          }
          ${n}
        `,`
        ${d}
        float process(int indices[${i}]) {
          int x[${i}];
          copyVec(indices, x);
          int offset[${u}];
          int pads[${l}];
          int inputDims[${i}];
          int kernelStrides[${u}];
          int strides[${u}];
          ${p}
          ${f}
          ${b}
          ${m}

          float value = ${o};
          int pad = 0;
          bool isPad = false;
          for (int i = 0; i < ${s}; i++) {
            offsetToIndices(i, kernelStrides, offset);
            isPad = false;
            for (int j = ${i} - ${u}; j < ${i}; j++) {
              x[j] = indices[j] * strides[j - ${i} + ${u}]
                + offset[j - ${i} + ${u}] - pads[j - 2];
              ${$}
          }
          ${t}

          return value;
        }
      `}},$i=(r,e)=>{let n="";for(let t=0;t<r.length;t++)n+=`
      ${e}[${t}] = ${r[t]};
    `;return n},Bw=r=>`
  void offsetToIndices(int offset, int[${r}] strides, out int[${r}] indices) {
    if (${r} == 0) {
      return;
    }
    for (int i = 0; i < ${r} - 1; ++i) {
      indices[i] = offset / strides[i];
      offset -= indices[i] * strides[i];
    }
    indices[${r} - 1] = offset;
  }`});var fn,Hr,Rw,zw,Qf,ep,tp,rp,np,op,ip,ap=D(()=>{"use strict";St();go();We();Ne();fn=(r,e,n,t,o)=>{zw(e);let i={name:t,inputNames:["A"],inputTypes:[0]};return[r.run({...i,cacheHint:n.cacheKey,get:()=>Rw(r,e,n,t,o,i)},e)]},Hr=r=>{let e=r.attributes.getInts("axes",[]),n=r.attributes.getInt("keepdims",1)===1;return Ae({axes:e,keepDims:n})},Rw=(r,e,n,t,o,i)=>{let s=[],a=e[0].dims.length||1,u=[],l=te.normalizeAxes(n.axes,e[0].dims.length),d=o(e,l),f=d[1];for(let b=0;b<e[0].dims.length;b++)l.indexOf(b)>=0||l.length===0?(n.keepDims&&s.push(1),f=`
          for(int j${b} = 0; j${b} < ${e[0].dims[b]}; j${b}++) {
            inputIdx[${b}] = j${b};
            ${f}
          }`):(u.push(`inputIdx[${b}] = outputIdx[${s.length}];`),s.push(e[0].dims[b]));let m=`
      float process(int outputIdx[${s.length||1}]) {
        float value;                 // final result
        int inputIdx[${a}];      // addressing input data
        ${u.join(`
`)}
        ${d[0]}       // init ops for reduce max/min
        ${f}
        ${d[2]}       // final computation for reduce mean
        return value;
      }`;return{...i,output:{dims:s,type:e[0].type,textureType:0},shaderSource:m}},zw=r=>{if(!r||r.length!==1)throw new Error("Reduce op requires 1 input.");if(Wr.indexOf(r[0].type)===-1)throw new Error("Invalid input type.")},Qf=(r,e,n)=>fn(r,e,n,"ReduceSum",()=>["value = 0.0;","value += _A(inputIdx);",""]),ep=(r,e,n)=>fn(r,e,n,"ReduceMean",(o,i)=>{let s=1;for(let a=0;a<o[0].dims.length;a++)(i.indexOf(a)>=0||i.length===0)&&(s*=o[0].dims[a]);return["value = 0.0;","value += _A(inputIdx);",`value /= ${s}.;`]}),tp=(r,e,n)=>fn(r,e,n,"ReduceMax",(o,i)=>{let s=[];for(let a=0;a<o[0].dims.length;a++)(i.indexOf(a)>=0||i.length===0)&&s.push(`inputIdx[${a}] = 0;`);return[`${s.join(`
`)}
value = _A(inputIdx);`,"value = max(value, _A(inputIdx));",""]}),rp=(r,e,n)=>fn(r,e,n,"ReduceMin",(o,i)=>{let s=[];for(let a=0;a<o[0].dims.length;a++)(i.indexOf(a)>=0||i.length===0)&&s.push(`inputIdx[${a}] = 0;`);return[`${s.join(`
`)}
value = _A(inputIdx);`,"value = min(value, _A(inputIdx));",""]}),np=(r,e,n)=>fn(r,e,n,"ReduceProd",()=>["value = 1.0;","value *= _A(inputIdx);",""]),op=(r,e,n)=>fn(r,e,n,"ReduceLogSum",()=>["value = 0.0;","value += _A(inputIdx);","value = log(value);"]),ip=(r,e,n)=>fn(r,e,n,"ReduceLogSumSquare",()=>["float t; value = 0.0;","t = _A(inputIdx); value += t * t;",""])});var sp,up=D(()=>{"use strict";We();sp=(r,e)=>{let n=te.calculateReshapedDims(e[0].dims,e[1].integerData);return r.session.pack?[r.reshapePacked(e[0],n)]:[r.reshapeUnpacked(e[0],n)]}});var lp,vs,dp,cp,bo,Nw,ws,Ii,xs=D(()=>{"use strict";St();ot();Ne();lp={name:"Upsample",inputNames:["X"],inputTypes:[0]},vs=(r,e,n)=>(ws(e,n),[r.run({...lp,cacheHint:n.cacheKey,get:()=>Nw(r,e,n)},e)]),dp=r=>bo(r,7),cp=r=>bo(r,9),bo=(r,e)=>{let n=e>=10,t=r.attributes.getString("mode","nearest");if(t!=="nearest"&&t!=="linear"&&(e<11||t!=="cubic"))throw new Error(`unrecognized mode: ${t}`);let o=[];e<9&&(o=r.attributes.getFloats("scales"),Ii(o,t,n));let i=r.attributes.getFloat("extrapolation_value",0),s=e>10?r.attributes.getString("coordinate_transformation_mode","half_pixel"):"asymmetric";if(["asymmetric","pytorch_half_pixel","tf_half_pixel_for_nn","align_corners","tf_crop_and_resize","half_pixel"].indexOf(s)===-1)throw new Error(`coordinate_transform_mode '${s}' is not supported`);let a=s==="tf_crop_and_resize",u=a,l=t==="nearest"&&e>=11?r.attributes.getString("nearest_mode","round_prefer_floor"):"";if(["round_prefer_floor","round_prefer_ceil","floor","ceil",""].indexOf(l)===-1)throw new Error(`nearest_mode '${l}' is not supported`);let d=r.attributes.getFloat("cubic_coeff_a",-.75),f=r.attributes.getInt("exclude_outside",0)!==0;if(f&&t!=="cubic")throw new Error("exclude_outside can be set to 1 only when mode is CUBIC.");let p=e<11?!0:t==="nearest"&&s==="asymmetric"&&l==="floor",m=0,b=0,y=0;return e>10?r.inputs.length>2?(m=1,b=2,y=3):(b=1,y=2):e===9&&(b=1),Ae({opset:e,isResize:n,mode:t,scales:o,extrapolationValue:i,coordinateTransformMode:s,useExtrapolation:u,needRoiInput:a,nearestMode:l,cubicCoefficientA:d,excludeOutside:f,useNearest2xOptimization:p,roiInputIdx:m,scalesInputIdx:b,sizesInputIdx:y})},Nw=(r,e,n)=>{let t=ce(r.session.backend.glContext.version),[o,i]=r.calculateTextureWidthAndHeight(e[0].dims,0),s=e[0].dims.map((y,$)=>Math.floor(y*n.scales[$])),[a,u]=r.calculateTextureWidthAndHeight(s,0),l=s.length,d=new Array(l),f=new Array(l),p=`
      int output_pitches[${l}];
      int input_pitches[${l}];
      `;for(let y=l-1;y>=0;y--)d[y]=y===l-1?1:d[y+1]*s[y+1],f[y]=y===l-1?1:f[y+1]*e[0].dims[y+1],p+=`
        output_pitches[${y}] = ${d[y]};
        input_pitches[${y}] = ${f[y]};
        `;let m=`
      float getInputFloat(int index) {
        vec2 coords = offsetToCoords(index, ${o}, ${i});
        float value = getColorAsFloat(${t.texture2D}(X, coords));
        return value;
      }
      `,b=n.mode==="nearest"?`
    ${m}
    float process(int indices[${l}]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${a}, ${u});

      ${p}

      int d, m;
      for (int dim = 0; dim < ${l}; ++dim) {
        d = output_index / output_pitches[dim];
        m = output_index - d * output_pitches[dim];
        output_index = m;

        if (scales[dim] != 1 && d > 0) {
          int d2 = d / scales[dim];
          m = d - d2 * scales[dim];
          d = d2;
        }
        input_index += input_pitches[dim] * d;
      }

      return getInputFloat(input_index);
    }`:l===4?`
    ${m}
    float process(int indices[4]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${a}, ${u});

      ${p}

      int m;
      int index_of_dim0, index_of_dim1, index_of_dim2, index_of_dim3;
      index_of_dim0 = output_index / output_pitches[0];
      m = output_index - index_of_dim0 * output_pitches[0];
      index_of_dim1 = m / output_pitches[1];
      m = m - index_of_dim1 * output_pitches[1];
      index_of_dim2 = m / output_pitches[2];
      m = m - index_of_dim2 * output_pitches[2];
      index_of_dim3 = m;

      int index_of_input_dim2, index_of_input_dim3, x_offset, y_offset;
      index_of_input_dim2 = index_of_dim2 / scales[2];
      y_offset = index_of_dim2 - index_of_input_dim2 * scales[2];
      index_of_input_dim3 = index_of_dim3 / scales[3];
      x_offset = index_of_dim3 - index_of_input_dim3 * scales[3];

      input_index = index_of_dim0 * input_pitches[0] +
            index_of_dim1 * input_pitches[1] +
            index_of_input_dim2 * input_pitches[2] +
            index_of_input_dim3;

      float x00 = getInputFloat(input_index);
      float x10, x01, x11;

      bool end_of_dim2 = false;
      if (index_of_input_dim2 == (${e[0].dims[2]} - 1)) {
        // It's the end in dimension 2
        x01 = x00;
        end_of_dim2 = true;
      } else {
        x01 = getInputFloat(input_index + input_pitches[2]);
      }

      if (index_of_input_dim3 == (input_pitches[2] - 1)) {
        // It's the end in dimension 3
        x10 = x00;
        x11 = x01;
      }
      else {
        x10 = getInputFloat(input_index + 1);
        x11 = end_of_dim2 ? x10 : getInputFloat(input_index + input_pitches[2] + 1);
      }

      float y0 = x00 + float(y_offset) * (x01 - x00) / float(scales[2]);
      float y1 = x10 + float(y_offset) * (x11 - x10) / float(scales[2]);
      return y0 + float(x_offset) * (y1 - y0) / float(scales[3]);
    }`:`
    ${m}
    float process(int indices[2]) {
      int input_index = 0;
      int output_index = coordsToOffset(TexCoords, ${a}, ${u});

      ${p}

      int m;
      int index_of_dim0, index_of_dim1;
      index_of_dim0 = output_index / output_pitches[0];
      m = output_index - index_of_dim0 * output_pitches[0];
      index_of_dim1 = m;

      int index_of_input_dim0, index_of_input_dim1, x_offset, y_offset;
      index_of_input_dim0 = index_of_dim0 / scales[0];
      y_offset = index_of_dim0 - index_of_input_dim0 * scales[0];
      index_of_input_dim1 = index_of_dim1 / scales[1];
      x_offset = index_of_dim1 - index_of_input_dim1 * scales[1];

      input_index = index_of_input_dim0 * input_pitches[0] + index_of_input_dim1;

      float x00 = getInputFloat(input_index);
      float x10, x01, x11;

      bool end_of_dim0 = false;
      if (index_of_input_dim0 == (${e[0].dims[0]} - 1)) {
        // It's the end in dimension 0
        x01 = x00;
        end_of_dim0 = true;
      } else {
        x01 = getInputFloat(input_index + input_pitches[0]);
      }

      if (index_of_input_dim1 == (input_pitches[0] - 1)) {
        // It's the end in dimension 1
        x10 = x00;
        x11 = x01;
      }
      else {
        x10 = getInputFloat(input_index + 1);
        x11 = end_of_dim0 ? x10 : getInputFloat(input_index + input_pitches[0] + 1);
      }

      float y0 = x00 + float(y_offset) * (x01 - x00) / float(scales[0]);
      float y1 = x10 + float(y_offset) * (x11 - x10) / float(scales[0]);
      return y0 + float(x_offset) * (y1 - y0) / float(scales[1]);
    }`;return{...lp,output:{dims:s,type:e[0].type,textureType:0},shaderSource:b,variables:[{name:"scales",type:"int",arrayLength:n.scales.length,data:n.scales.map(y=>Math.ceil(y))}]}},ws=(r,e)=>{if(!r||e.opset<9&&r.length!==1||e.opset>=9&&e.opset<11&&r.length!==2||e.opset>=11&&r.length<2)throw new Error("invalid inputs.");if(e.scales.length>0&&r[0].dims.length!==e.scales.length)throw new Error("Invalid input shape.");if(r[0].type==="string")throw new Error("Invalid input tensor types.")},Ii=(r,e,n)=>{if(n){for(let t of r)if(t<=0)throw new Error("Scale value should be greater than 0.")}else for(let t of r)if(t<1)throw new Error("Scale value should be greater than or equal to 1.");if((e==="linear"||e==="cubic")&&r.length!==2&&(r.length!==4||r[0]!==1||r[1]!==1))throw new Error(`'Linear' mode and 'Cubic' mode only support 2-D inputs ('Bilinear', 'Bicubic')         or 4-D inputs with the corresponding outermost 2 scale values being 1         in the ${n?"Resize":"Upsample"} opeartor.`)}});var Ts,_s,fp,pp,Lw,Mw,Vw,Fw,hp=D(()=>{"use strict";ot();Ne();hr();ln();xs();Ts={name:"Resize",inputNames:["A"],inputTypes:[2]},_s=(r,e,n)=>(ws(e,n),[r.run({...Ts,cacheHint:n.cacheKey,get:()=>Lw(r,e,n)},e)]),fp=r=>bo(r,10),pp=r=>bo(r,11),Lw=(r,e,n)=>{let t=ce(r.session.backend.glContext.version),[o,i]=Mw(e,n);if(o.every(A=>A===1)&&n.coordinateTransformMode!=="tf_crop_and_resize")return{...Ts,output:{dims:i,type:e[0].type,textureType:2},hasMain:!0,shaderSource:`void main() {
                    vec4 v = ${t.texture2D}(X, TexCoords);
                    ${t.output} = v;
                }`};let a=i.length;if(a<2)throw new Error(`output dimension should be at least 2, but got ${a}`);let u=i[a-2],l=i[a-1],d=e[0].dims;if(a!==d.length)throw new Error(`output dimension should match input ${d.length}, but got ${a}`);let f=d[a-2],p=d[a-1],m=o[a-2],b=o[a-1],y="";if(n.mode!=="linear")throw new Error(`resize (packed) does not support mode: '${n.mode}'`);switch(n.coordinateTransformMode){case"asymmetric":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        return vec4(coords) / scaleWHWH;
                    }
                `;break;case"half_pixel":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        return (vec4(coords) + 0.5) / scaleWHWH - 0.5;
                    }
                `;break;case"pytorch_half_pixel":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        vec4 fcoords = vec4(coords);
                        return vec4(
                            ${l}.0 > 1.0 ? (fcoords.x + 0.5) / scaleWHWH.x - 0.5 : 0.0,
                            ${u}.0 > 1.0 ? (fcoords.y + 0.5) / scaleWHWH.y - 0.5 : 0.0,
                            ${l}.0 > 1.0 ? (fcoords.z + 0.5) / scaleWHWH.z - 0.5 : 0.0,
                            ${u}.0 > 1.0 ? (fcoords.w + 0.5) / scaleWHWH.w - 0.5 : 0.0
                          );
                    }
                `;break;case"align_corners":y=`
                    vec4 getSourceFracIndex(ivec4 coords) {
                        vec4 resized = vec4(${l}.0 - 1.0, ${u}.0 - 1.0, ${l}.0 - 1.0,
                            ${u}.0 - 1.0);
                        vec4 original = vec4(${p}.0 - 1.0, ${f}.0 - 1.0, ${p}.0 - 1.0,
                            ${f}.0 - 1.0);
                        vec4 new_scale = original / resized;
                        return vec4(coords) * new_scale;
                    }
                `;break;default:throw new Error(`resize (packed) does not support coordinateTransformMode:                                 '${n.coordinateTransformMode}'`)}let $=Bt(a),x=mr(),T=`
            const vec2 inputWH = vec2(${f}.0, ${p}.0);
            const vec4 scaleWHWH = vec4(float(${m}), float(${b}), float(${m}), float(${b}));
            ${x}
            ${y}
            float getAValue(int x10, int r, int c, int d) {
                return getChannel(getA(x10, r, c, d), vec2(c, d));
            }
            void main() {
                ${$} rc = getOutputCoords();

                int batch = rc[0];
                int depth = rc[1];

                // retrieve the 4 coordinates that is used in the 4 packed output values.
                ivec4 coords = ivec4(rc.wz, rc.w + 1, rc.z + 1);

                // calculate the source index in fraction
                vec4 sourceFrac = getSourceFracIndex(coords);

                // get the lower and upper bound of the 4 values that will be packed into one texel.
                ivec4 x00 = ivec4(max(sourceFrac.xy, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.xy)));
                ivec4 x01 = ivec4(max(sourceFrac.xw, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.xw)));
                ivec4 x10 = ivec4(max(sourceFrac.zy, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.zy)));
                ivec4 x11 = ivec4(max(sourceFrac.zw, vec2(0.0)), min(inputWH - 1.0, ceil(sourceFrac.zw)));

                bool hasNextRow = rc.w < ${u-1};
                bool hasNextCol = rc.z < ${l-1};

                // pack x00, x01, x10, x11's top-left corner into one vec4 structure
                vec4 topLeft = vec4(
                    getAValue(batch, depth, x00.x, x00.y),
                    hasNextCol ? getAValue(batch, depth, x01.x, x01.y) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.x, x10.y) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.x, x11.y) : 0.0);

                // pack x00, x01, x10, x11's top-right corner into one vec4 structure
                vec4 topRight = vec4(
                    getAValue(batch, depth, x00.x, x00.w),
                    hasNextCol ? getAValue(batch, depth, x01.x, x01.w) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.x, x10.w) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.x, x11.w) : 0.0);

                // pack x00, x01, x10, x11's bottom-left corner into one vec4 structure
                vec4 bottomLeft = vec4(
                    getAValue(batch, depth, x00.z, x00.y),
                    hasNextCol ? getAValue(batch, depth, x01.z, x01.y) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.z, x10.y) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.z, x11.y) : 0.0);

                // pack x00, x01, x10, x11's bottom-right corner into one vec4 structure
                vec4 bottomRight = vec4(
                    getAValue(batch, depth, x00.z, x00.w),
                    hasNextCol ? getAValue(batch, depth, x01.z, x01.w) : 0.0,
                    hasNextRow ? getAValue(batch, depth, x10.z, x10.w) : 0.0,
                    (hasNextRow && hasNextCol) ? getAValue(batch, depth, x11.z, x11.w) : 0.0);

                // calculate the interpolation fraction on u and v direction
                vec4 frac = vec4(sourceFrac) - floor(sourceFrac);
                vec4 clampFrac = clamp(frac, vec4(0.0), vec4(1.0));

                vec4 top = mix(topLeft, topRight, clampFrac.ywyw);
                vec4 bottom = mix(bottomLeft, bottomRight, clampFrac.ywyw);
                vec4 newValue = mix(top, bottom, clampFrac.xxzz);

                ${t.output} = vec4(newValue);
            }
        `;return{...Ts,output:{dims:i,type:e[0].type,textureType:2},hasMain:!0,shaderSource:T}},Mw=(r,e)=>{let t=r[0].dims,o=e.scales,i;if(o.length===0){let a=r[e.scalesInputIdx];if(a&&a.size!==0){if(r[e.sizesInputIdx])throw new Error("Only one of scales or sizes must be provided as input.");o=Vw(a,e.mode,e.isResize)}else{let u=r[e.sizesInputIdx];if(!u||u.size===0)throw new Error("Either scales or sizes MUST be provided as input.");i=Array.from(u.integerData),o=Fw(i,t,e.mode,e.isResize)}}else if(r[e.sizesInputIdx])throw new Error("Only one of scales or sizes must be provided as input.");let s=i||t.map((a,u)=>Math.floor(a*o[u]));return[o,s]},Vw=(r,e,n)=>{let t=Array.from(r.floatData);return Ii(t,e,n),t},Fw=(r,e,n,t)=>{let o=e.length,i=new Array(o);for(let s=0,a=o;s<a;s++)if(e[s]===0){if(r[s]!==0)throw new Error("Input dim is zero but required output dim is non-zero.");i[s]=1}else i[s]=r[s]/e[s];return Ii(i,n,t),i}});var mp,Uw,gp=D(()=>{"use strict";un();mp=(r,e)=>(Uw(e),[new yt([e[0].dims.length],"int32",void 0,void 0,new Int32Array(e[0].dims))]),Uw=r=>{if(!r||r.length!==1)throw new Error("Shape requires 1 input.")}});var $s,bp,yp,vp,Gw,wp,Ww,Hw,xp=D(()=>{"use strict";St();go();We();Ne();$s={name:"Slice",inputNames:["A"],inputTypes:[0]},bp=(r,e,n)=>(Gw(e),[r.run({...$s,cacheHint:n.cacheKey,get:()=>vp(r,e[0],n)},e)]),yp=r=>{let e=r.attributes.getInts("starts"),n=r.attributes.getInts("ends"),t=r.attributes.getInts("axes",[]);return Ae({starts:e,ends:n,axes:t})},vp=(r,e,n)=>{let t=n.axes.length===0?e.dims.slice(0).map((f,p)=>p):n.axes,o=te.normalizeAxes(t,e.dims.length),i=n.starts.map((f,p)=>f>e.dims[o[p]]-1?e.dims[o[p]]:te.normalizeAxis(f,e.dims[o[p]])),s=n.ends.map((f,p)=>f>e.dims[o[p]]-1?e.dims[o[p]]:te.normalizeAxis(f,e.dims[o[p]])),a=e.dims.slice(),u=[];for(let f=0;f<o.length;f++)a[o[f]]=s[f]-i[f],i[f]>0&&u.push(`outputIdx[${o[f]}] += ${i[f]};`);let d=`
      float process(int outputIdx[${a.length}]) {
        ${u.join(`
      `)}
        return _A(outputIdx);
      }`;return{...$s,output:{dims:a,type:e.type,textureType:0},shaderSource:d}},Gw=r=>{if(!r||r.length!==1)throw new Error("Slice requires 1 input.");if(Wr.indexOf(r[0].type)===-1)throw new Error("Invalid input type.")},wp=(r,e)=>{Hw(e);let n=Ww(r,e);return[r.run({...$s,cacheHint:n.cacheKey,get:()=>vp(r,e[0],n)},[e[0]])]},Ww=(r,e)=>{if(!r.session.isInitializer(e[1].dataId)||!r.session.isInitializer(e[2].dataId)||e.length>=4&&!r.session.isInitializer(e[3].dataId)||e.length>=5&&!r.session.isInitializer(e[4].dataId))throw new Error("dynamic slice attributes are not allowed");if(e.length>=5&&e[4].integerData.some(s=>s!==1))throw new Error("currently non-1 steps is not supported for Slice");let n=Array.from(e[1].integerData),t=Array.from(e[2].integerData),o=e.length>=4?Array.from(e[3].integerData):[],i=`${o};${n};${t}`;return{starts:n,ends:t,axes:o,cacheKey:i}},Hw=r=>{if(!r||r.length<3||r.length>5)throw new Error("Invalid input number.");if(r[1].type!=="int32"||r[1].dims.length!==1)throw new Error("Invalid input type.");if(r[2].type!=="int32"||r[2].dims.length!==1)throw new Error("Invalid input type.");if(r.length>=4&&(r[3].type!=="int32"||r[3].dims.length!==1))throw new Error("Invalid input type.");if(r.length>=5&&(r[4].type!=="int32"||r[4].dims.length!==1))throw new Error("Invalid input type.")}});var Tp,_p,$p,Sp,Ip,Ap,Op,Ep,qw,jw,Kw,Cp,Pp=D(()=>{"use strict";St();We();ot();Ne();_i();Tp={name:"SoftmaxComputeMax",inputNames:["A"],inputTypes:[0]},_p={name:"SoftmaxComputeScale",inputNames:["A","Max"],inputTypes:[0,0]},$p={name:"SoftMax",inputNames:["A","Max","Norm"],inputTypes:[0,0,0]},Sp=(r,e,n)=>{Cp(e);let t=e[0].dims.slice(),o=te.normalizeAxis(n.axis,t.length),i=te.sizeToDimension(t,o),s=te.sizeFromDimension(t,o);return Ep(r,e,n,i,s)},Ip=r=>Ae({axis:r.attributes.getInt("axis",1)}),Ap=r=>Ae({axis:r.attributes.getInt("axis",-1)}),Op=(r,e,n)=>{Cp(e);let t=e[0].dims.slice(),o=te.normalizeAxis(n.axis,t.length),i=t.length,s=o!==i-1,a=[],u=[],l=[],d;s&&(u=Array.from({length:i}).map((b,y)=>y),u[o]=i-1,u[i-1]=o,u.map(b=>a.push(t[b])),d=Ae({perm:u}),l=cn(r,e,d));let f=s?te.sizeToDimension(a,i-1):te.sizeToDimension(t,i-1),p=s?te.sizeFromDimension(a,i-1):te.sizeFromDimension(t,i-1),m=Ep(r,s?l:e,n,f,p);return s?cn(r,m,d):m},Ep=(r,e,n,t,o)=>{let i=qw(r,e[0],t,o,[t]),s=r.run({...Tp,cacheHint:n.cacheKey,get:()=>i},e),a=jw(r,e[0],t,o,i.output.dims,[t]),u=r.run({..._p,cacheHint:n.cacheKey,get:()=>a},[e[0],s]),l=Kw(r,e[0],t,o,i.output.dims,a.output.dims);return[r.run({...$p,cacheHint:n.cacheKey,get:()=>l},[e[0],s,u])]},qw=(r,e,n,t,o)=>{let[i,s]=r.calculateTextureWidthAndHeight(e.dims,0),a=o.length;if(n<1||t<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(o.length!==1)throw new Error("Dimensionality of the output should be 1");if(o[0]!==n)throw new Error("Shape of the output should be equal to logical row count");let u=ce(r.session.backend.glContext.version),l=`
      float process(int[${a}] indices) {
        int logical_row_start_offset = indices[0] * ${t};

        float max = getColorAsFloat(${u.texture2D}(A, offsetToCoords(logical_row_start_offset, ${i},
        ${s} )));
        for(int i=1; i<${t}; ++i)
        {
          float current = getColorAsFloat(${u.texture2D}(A, offsetToCoords(logical_row_start_offset + i,
            ${i}, ${s})));
          if(current > max)
          max = current;
        }

        return max;
      }`;return{...Tp,output:{dims:o,type:e.type,textureType:0},shaderSource:l}},jw=(r,e,n,t,o,i)=>{let[s,a]=r.calculateTextureWidthAndHeight(e.dims,0),u=i.length;if(n<1||t<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(i.length!==1)throw new Error("Dimensionality of the output should be 1");if(i[0]!==n)throw new Error("Shape of the output should be equal to logical row count");if(o.length!==1)throw new Error("Dimensionality of the intermediate results should be 1");if(o[0]!==n)throw new Error("Shape of the intermediate results should be equal to logical row count");let l=ce(r.session.backend.glContext.version),d=`
      float process(int[${u}] indices) {
        int logical_row_start_offset = indices[0] * ${t};

        float norm_factor = 0.0;
        float max = _Max(indices);
        for(int i=0; i<${t}; ++i)
        {
          norm_factor += exp(getColorAsFloat(${l.texture2D}(A, offsetToCoords(logical_row_start_offset + i,
            ${s}, ${a}))) - max);
        }

        return norm_factor;
      }`;return{..._p,output:{dims:i,type:e.type,textureType:0},shaderSource:d}},Kw=(r,e,n,t,o,i)=>{let[s,a]=r.calculateTextureWidthAndHeight(e.dims,0),u=e.dims.length;if(n<1||t<1)throw new Error("Logical row count N and feature count D must be greater than or equal to 1");if(o.length!==1||i.length!==1)throw new Error("Dimensionality of the intermediate results should be 1");if(o[0]!==n||i[0]!==n)throw new Error("Shape of the intermediate results should be equal to logical row count");let l=`
      float process(int[${u}] indices) {

      // get offset of current logical tensor index from the 2-D texture coordinates (TexCoords)
      int offset = coordsToOffset(TexCoords, ${s}, ${a});

      //determine the logical row for this index
      int logical_row_index[1];
      logical_row_index[0] = offset / ${t};

      float norm_factor = _Norm(logical_row_index);

      // avoid possible division by 0
      // if norm_facor is 0, all elements are zero
      // if so, return 0
      if(norm_factor == 0.0)
        return 0.0;

      return exp(_A(indices) - _Max(logical_row_index)) / norm_factor;
    }`;return{...$p,output:{dims:e.dims,type:e.type,textureType:0},shaderSource:l}},Cp=r=>{if(!r||r.length!==1)throw new Error("Softmax requires 1 input.");if(r[0].type!=="float32"&&r[0].type!=="float64")throw new Error("Invalid input type")}});var kp,Dp,Bp,Yw,Xw,Zw,Rp=D(()=>{"use strict";St();We();Ne();kp={name:"Split",inputNames:["A"],inputTypes:[0]},Dp=(r,e,n)=>{Zw(e);let t=te.normalizeAxis(n.axis,e[0].dims.length),o=Yw(r,e,t,n),i=[];for(let s=0;s<o;++s)i.push(r.run({...kp,cacheHint:`${n.cacheKey};${s}`,get:()=>Xw(r,e[0],n,t,s)},e));return i},Bp=r=>{let e=r.attributes.getInt("axis",0),n=r.attributes.getInts("split",[]),t=r.outputs.length;return Ae({axis:e,split:n,numOutputs:t})},Yw=(r,e,n,t)=>{let[,o]=lo.splitShape(e[0].dims,n,t.split,t.numOutputs);return o.length},Xw=(r,e,n,t,o)=>{let[i,s]=lo.splitShape(e.dims,t,n.split,n.numOutputs),a=s[o],u=i[o],d=`
      float process(int indices[${u.length}]) {
        indices[${t}] += ${a};
        return _A(indices);
      }
    `;return{...kp,cacheHint:`${n.cacheKey}:${o}`,output:{dims:u,type:e.type,textureType:0},shaderSource:d}},Zw=r=>{if(!r||r.length!==1)throw new Error("Split requires one input.");if(r[0].type!=="int8"&&r[0].type!=="uint8"&&r[0].type!=="int16"&&r[0].type!=="uint16"&&r[0].type!=="int32"&&r[0].type!=="uint32"&&r[0].type!=="float32"&&r[0].type!=="float64"&&r[0].type!=="bool")throw new Error("Invalid input type.")}});var Ss,zp,Np,Jw,Qw,Lp=D(()=>{"use strict";We();Ss=(r,e,n)=>{Jw(e);let t=te.squeezeShape(e[0].dims,n);return[r.reshapeUnpacked(e[0],t)]},zp=(r,e)=>(Qw(e),Ss(r,[e[0]],Array.from(e[1].integerData))),Np=r=>r.attributes.getInts("axes"),Jw=r=>{if(!r||r.length!==1)throw new Error("Squeeze requires 1 input.");if(r[0].type==="string")throw new Error("invalid input tensor types.")},Qw=r=>{if(!r||r.length!==2)throw new Error("Squeeze requires 2 inputs.");if(r[1].type!=="int32")throw new Error("Invalid input type.")}});var Mp,ex,tx,Vp=D(()=>{"use strict";ot();Ne();Mp=(r,e)=>{tx(e);let n={name:"Sum",inputNames:e.map((o,i)=>`X${i}`),inputTypes:new Array(e.length).fill(0)};return[r.run({...n,get:()=>ex(r,e,n)},e)]},ex=(r,e,n)=>{let t=ce(r.session.backend.glContext.version),o=e[0].dims.slice(),s=`
      void main() {
        vec4 result = ${e.map((a,u)=>`${t.texture2D}(X${u},TexCoords)`).join(" + ")};
        ${t.output} = result;
      }
    `;return{...n,output:{dims:o,type:e[0].type,textureType:0},hasMain:!0,shaderSource:s}},tx=r=>{if(!r||r.length===0)throw new Error("Sum requires inputs.");let e=r[0].dims.length;for(let n=1;n<r.length;n++){if(e!==r[n].dims.length)throw new Error("Input shapes are mismatched.");for(let t=0;t<e;t++)if(r[0].dims[t]!==r[n].dims[t])throw new Error("Input shapes are not matched.")}if(r[0].type!=="float32"&&r[0].type!=="float64")throw new Error("Invalid input type.");for(let n=1;n<r.length;n++)if(r[0].type!==r[n].type)throw new Error("Input types are not matched.")}});var Fp,rx,nx,Up=D(()=>{"use strict";go();Ne();Fp=(r,e)=>{nx(e);let n={name:"Tile",inputNames:["A"],inputTypes:[0]};return[r.run({...n,get:()=>rx(r,e,n)},e)]},rx=(r,e,n)=>{let t=e[0].dims.slice(),o=new Array(t.length),i=[];for(let u=0;u<t.length;u++)o[u]=t[u]*e[1].numberData[u],i.push(`inputIdx[${u}] = int(mod(float(outputIdx[${u}]), ${t[u]}.));`);let s=o.length,a=`
      float process(int outputIdx[${s}]) {
        int inputIdx[${s}];
        ${i.join(`
`)}
        return _A(inputIdx);
      }
    `;return{...n,output:{dims:o,type:e[0].type,textureType:0},shaderSource:a}},nx=r=>{if(!r||r.length!==2)throw new Error("Tile requires 2 input.");if(r[1].dims.length!==1)throw new Error("The second input shape must 1 dimension.");if(r[1].dims[0]!==r[0].dims.length)throw new Error("Invalid input shape.");if(Wr.indexOf(r[0].type)===-1)throw new Error("Invalid input type.");if(r[1].type!=="int32"&&r[1].type!=="int16")throw new Error("Invalid repeat type.")}});var Is,Gp,Wp,ox,ix,Hp=D(()=>{"use strict";We();Is=(r,e,n)=>{ox(e);let t=te.unsqueezeShape(e[0].dims,n);return[r.reshapeUnpacked(e[0],t)]},Gp=(r,e)=>(ix(e),Is(r,[e[0]],Array.from(e[1].integerData))),Wp=r=>r.attributes.getInts("axes"),ox=r=>{if(!r||r.length!==1)throw new Error("Unsqueeze requires 1 input.");if(r[0].type==="string")throw new Error("invalid input tensor types.")},ix=r=>{if(!r||r.length!==2)throw new Error("Unsqueeze requires 2 inputs.");if(r[1].type!=="int32")throw new Error("Invalid input type.")}});var qp,jp=D(()=>{"use strict";rc();mc();yc();$c();wi();uf();hf();bf();wf();$f();Af();Pf();Rf();xi();Mf();Jf();ap();up();hp();gp();xp();Pp();Rp();Lp();Vp();Up();_i();ls();Hp();xs();qp=[["Abs","","6+",Sc],["Acos","","7+",Ic],["Add","","7+",nc],["And","","7+",oc],["Asin","","7+",Ac],["Atan","","7+",Oc],["AveragePool","","7+",Ff,Uf],["BatchNormalization","","7+",ec,tc],["Cast","","6+",gc,bc],["Ceil","","6+",Pc],["Clip","","6-10",ss,Ec],["Clip","","11+",Cc],["Concat","","4+",xc,_c],["Conv","","1+",ms,gs],["ConvTranspose","","1+",af,sf],["Cos","","7+",kc],["Div","","7+",ic],["Dropout","","7+",us],["DepthToSpace","","1+",ff,pf],["Equal","","7+",ac],["Elu","","6+",Dc,Bc],["Exp","","6+",Rc],["Flatten","","1+",mf,gf],["Floor","","6+",zc],["FusedConv","com.microsoft","1+",ms,gs],["Gather","","1+",yf,vf],["Gemm","","7-10",bs,Tf],["Gemm","","11+",bs,_f],["GlobalAveragePool","","1+",Wf,Hf],["GlobalMaxPool","","1+",Xf],["Greater","","7+",sc],["Identity","","1+",us],["ImageScaler","","1+",Sf,If],["InstanceNormalization","","6+",Ef,Cf],["LeakyRelu","","6+",Nc,Lc],["Less","","7+",uc],["LRN","","1+",kf,Df],["Log","","6+",Mc],["MatMul","","1+",Jc,Qc],["MaxPool","","1+",qf,jf],["Mul","","7+",lc],["Neg","","6+",Vc],["Not","","1+",Fc],["Or","","7+",dc],["Pad","","2-10",ys,zf],["Pad","","11+",Nf,Lf],["Pow","","7+",cc],["PRelu","","7+",fc],["ReduceLogSum","","1+",op,Hr],["ReduceMax","","1+",tp,Hr],["ReduceMean","","1+",ep,Hr],["ReduceMin","","1+",rp,Hr],["ReduceProd","","1+",np,Hr],["ReduceSum","","1-12",Qf,Hr],["ReduceSumSquare","","1+",ip,Hr],["Relu","","6+",Uc],["Reshape","","5+",sp],["Resize","","10",_s,fp],["Resize","","11+",_s,pp],["Shape","","1+",mp],["Sigmoid","","6+",Gc],["Sin","","7+",Wc],["Slice","","10+",wp],["Slice","","1-9",bp,yp],["Softmax","","1-12",Sp,Ip],["Softmax","","13+",Op,Ap],["Split","","2-12",Dp,Bp],["Sqrt","","6+",Hc],["Squeeze","","1-12",Ss,Np],["Squeeze","","13+",zp],["Sub","","7+",pc],["Sum","","6+",Mp],["Tan","","7+",qc],["Tanh","","6+",jc],["Tile","","6+",Fp],["Transpose","","1+",cn,df],["Upsample","","7-8",vs,dp],["Upsample","","9",vs,cp],["Unsqueeze","","1-12",Is,Wp],["Unsqueeze","","13+",Gp],["Xor","","7+",hc]]});function Yp(r){let e={},n;for(;(n=Kp.exec(r))!==null;){let t=n[3].split(",").map(o=>{let i=o.trim().split(" ");return i&&i.length===2?{type:i[0],name:i[1]}:null}).filter(o=>o!==null);e[n[2]]={params:t,body:n[4]}}for(let t in e){let o=ax.replace("__FUNC__",t),i=new RegExp(o,"gm");for(;(n=i.exec(r))!==null;){let s=n[1],a=n[2],u=n[3].split(","),l=s?`${s} ${a};`:"",d=e[t].body,f="";e[t].params.forEach((m,b)=>{m&&(f+=`${m.type} ${m.name} = ${u[b]};
`)}),d=`${f}
 ${d}`,d=d.replace("return",`${a} = `);let p=`
      ${l}
      {
        ${d}
      }
      `;r=r.replace(n[0],p)}}return r=r.replace(Kp,""),r}var Kp,ax,Xp=D(()=>{"use strict";Kp=/@inline[\s\n\r]+(\w+)[\s\n\r]+([0-9a-zA-Z_]+)\s*\(([^)]*)\)\s*{(([^}]|[\n\r])*)}/gm,ax="(\\w+)?\\s+([_0-9a-zA-Z]+)\\s+=\\s+__FUNC__\\((.*)\\)\\s*;"});function Dn(r,e){let n=[],t=[],o=e!=null&&Array.isArray(e)&&e.length===0,i=e==null||o?null:sx(e,r).sort(),s=0;for(let a=0;a<r.length;++a){if(i!=null){if(i[s]===a&&r[a]!==1)throw new Error(`Can't squeeze axis ${a} since its dim '${r[a]}' is not 1`);(i[s]==null||i[s]>a)&&r[a]===1&&(n.push(r[a]),t.push(a)),i[s]<=a&&s++}r[a]!==1&&(n.push(r[a]),t.push(a))}return{newShape:n,keptDims:t}}function sx(r,e){let n=e.length;return r=r==null?e.map((t,o)=>o):[].concat(r),An(r.every(t=>t>=-n&&t<n),()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${r}`),An(r.every(ux),()=>`All values in axis param must be integers but got axis ${r}`),r.map(t=>t<0?n+t:t)}function ux(r){return r%1===0}function lx(r){if(r.length===0)return 1;let e=r[0];for(let n=1;n<r.length;n++)e*=r[n];return e}function Zp(r){let e=Math.ceil(Math.sqrt(r));return[e,Math.ceil(r/e)]}var Ai,As=D(()=>{"use strict";Ht();We();Ai=class{constructor(e){this.maxTextureSize=e}computeTextureWH(e,n){let t=this.computeTexture(e,n);return n&&n.isPacked&&(t[0]/=2,t[1]/=2),n&&n.reverseWH?[t[1],t[0]]:t}computeTexture(e,n){let t=n&&n.isPacked;if(e.length===0)return t?[2,2]:[1,1];let o=this.maxTextureSize;if(n&&n.breakAxis!==void 0){let a=n.breakAxis>=e.length?1:e.slice(n.breakAxis).reduce((l,d)=>l*d),u=n.breakAxis<=0?1:e.slice(0,n.breakAxis).reduce((l,d)=>l*d);if(a>o||u>o)qe.verbose("TextureLayout",`Given width/height preferences were unattainable: shape:${e}, breakAxis:${n.breakAxis}`);else return[a,u]}let i=e.slice(0);t&&(o=o*2,i=i.map((a,u)=>u>=i.length-2?i[u]%2===0?i[u]:i[u]+1:i[u]),i.length===1&&(i=[2,i[0]])),i.length!==2&&(i=Dn(i).newShape);let s=lx(i);return i.length<=1&&s<=o?[1,s]:i.length===2&&i[0]<=o&&i[1]<=o?i:i.length===3&&i[0]*i[1]<=o&&i[2]<=o?[i[0]*i[1],i[2]]:i.length===3&&i[0]<=o&&i[1]*i[2]<=o?[i[0],i[1]*i[2]]:i.length===4&&i[0]*i[1]*i[2]<=o&&i[3]<=o?[i[0]*i[1]*i[2],i[3]]:i.length===4&&i[0]<=o&&i[1]*i[2]*i[3]<=o?[i[0],i[1]*i[2]*i[3]]:t?Zp(s/4).map(a=>a*2):Zp(s)}}});var Oi,Jp=D(()=>{"use strict";We();kr();ot();As();hr();Oi=class extends Yt{constructor(n){super(n)}getFunctions(){return{...this.offsetToCoords(),...this.coordsToOffset(),...this.toVec(),...this.valueFrom(),...this.getCommonUtilFuncs(),...this.getInputsSamplingSnippets(),...this.getOutputSamplingSnippet()}}getCustomTypes(){return{}}offsetToCoords(){let n="offsetToCoords";return{offsetToCoords:new Q(`
      vec2 ${n}(int offset, int width, int height) {
        int t = offset / width;
        int s = offset - t*width;
        vec2 coords = (vec2(s,t) + vec2(0.5,0.5)) / vec2(width, height);
        return coords;
      }
      `)}}coordsToOffset(){let n="coordsToOffset";return{coordsToOffset:new Q(`
      int ${n}(vec2 coords, int width, int height) {
        float s = coords.s * float(width);
        float t = coords.t * float(height);
        int offset = int(t) * width + int(s);
        return offset;
      }
      `)}}getOutputSamplingSnippet(){let n=this.context.outputTextureLayout;return n.isPacked?this.getPackedOutputSamplingSnippet(n):this.getUnpackedOutputSamplingSnippet(n)}getPackedOutputSamplingSnippet(n){let t=n.unpackedShape,o=[n.width,n.height],i={},s="getOutputCoords";switch(t.length){case 0:i[s]=this.getOutputScalarCoords();break;case 1:i[s]=this.getOutputPacked1DCoords(t,o);break;case 2:i[s]=this.getOutputPacked2DCoords(t,o);break;case 3:i[s]=this.getOutputPacked3DCoords(t,o);break;default:i[s]=this.getOutputPackedNDCoords(t,o)}let u=`
      void setOutput(vec4 val) {
        ${ce(this.context.glContext.version).output} = val;
      }
    `,l="floatTextureSetRGBA";return i[l]=new Q(u),i}getUnpackedOutputSamplingSnippet(n){let t=n.unpackedShape,o=[n.width,n.height],i={},s="getOutputCoords";switch(t.length){case 0:i[s]=this.getOutputScalarCoords();break;case 1:i[s]=this.getOutputUnpacked1DCoords(t,o);break;case 2:i[s]=this.getOutputUnpacked2DCoords(t,o);break;case 3:i[s]=this.getOutputUnpacked3DCoords(t,o);break;case 4:i[s]=this.getOutputUnpacked4DCoords(t,o);break;case 5:i[s]=this.getOutputUnpacked5DCoords(t,o);break;case 6:i[s]=this.getOutputUnpacked6DCoords(t,o);break;default:throw new Error(`Unsupported output dimensionality: ${t.length}`)}let u=`
        void setOutput(float val) {
          ${ce(this.context.glContext.version).output} = vec4(val, 0, 0, 0);
        }
    `,l="floatTextureSetR";return i[l]=new Q(u),i}getOutputScalarCoords(){return new Q(`
      int getOutputCoords() {
        return 0;
      }
    `)}getOutputPacked1DCoords(n,t){let o=t,i="";return o[0]===1?(i=`
          int getOutputCoords() {
            return 2 * int(TexCoords.y * ${o[1]}.0);
          }
        `,new Q(i)):o[1]===1?(i=`
          int getOutputCoords() {
            return 2 * int(TexCoords.x * ${o[0]}.0);
          }
        `,new Q(i)):(i=`
        int getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                 vec2(${o[0]}, ${o[1]}));
          return 2 * (resTexRC.y * ${o[0]} + resTexRC.x);
        }
      `,new Q(i))}getOutputPacked2DCoords(n,t){let o="";if(nn.arraysEqual(n,t))return o=`
        ivec2 getOutputCoords() {
          return 2 * ivec2(TexCoords.xy * vec2(${t[0]}, ${t[1]}));
        }
      `,new Q(o);let i=t,s=Math.ceil(n[1]/2);return o=`
        ivec2 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${i[0]}, ${i[1]}));

          int index = resTexRC.y * ${i[0]} + resTexRC.x;

          // reverse r and c order for packed texture
          int r = imod(index, ${s}) * 2;
          int c = 2 * (index / ${s});

          return ivec2(r, c);
        }
      `,new Q(o)}getOutputPacked3DCoords(n,t){let o=[t[0],t[1]],i=Math.ceil(n[2]/2),s=i*Math.ceil(n[1]/2),a=`
        ivec3 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${o[0]}, ${o[1]}));
          int index = resTexRC.y * ${o[0]} + resTexRC.x;

          int b = index / ${s};
          index -= b * ${s};

          // reverse r and c order for packed texture
          int r = imod(index, ${i}) * 2;
          int c = 2 * (index / ${i});

          return ivec3(b, r, c);
        }
      `;return new Q(a)}getOutputPackedNDCoords(n,t){let o=[t[0],t[1]],i=Math.ceil(n[n.length-1]/2),s=i*Math.ceil(n[n.length-2]/2),a=s,u="",l="b, r, c";for(let f=2;f<n.length-1;f++)a*=n[n.length-f-1],u=`
      int b${f} = index / ${a};
      index -= b${f} * ${a};
    `+u,l=`b${f}, `+l;let d=`
      ivec${n.length} getOutputCoords() {
        ivec2 resTexRC = ivec2(TexCoords.xy *
                              vec2(${o[0]}, ${o[1]}));
        int index = resTexRC.y * ${o[0]} + resTexRC.x;

        ${u}

        int b = index / ${s};
        index -= b * ${s};

        // reverse r and c order for packed texture
        int r = imod(index, ${i}) * 2;
        int c = 2 * (index / ${i});

        return ivec${n.length}(${l});
      }
    `;return new Q(d)}getOutputUnpacked1DCoords(n,t){let o=`
        int getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          return resTexRC.y * ${t[0]} + resTexRC.x;
        }
      `;return new Q(o)}getOutputUnpacked2DCoords(n,t){let o=`
        ivec2 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          int r = index / ${n[1]};
          int c = index - r * ${n[1]};
          return ivec2(r, c);
        }
      `;return new Q(o)}getOutputUnpacked3DCoords(n,t){let o="",i=n.length,s=null;i<2&&(s=[]),s=new Array(i-1),s[i-2]=n[i-1];for(let l=i-3;l>=0;--l)s[l]=s[l+1]*n[l+1];let a=["r","c","d"],u=s.map((l,d)=>{let f=`int ${a[d]} = index / ${l}`,p=d===s.length-1?`int ${a[d+1]} = index - ${a[d]} * ${l}`:`index -= ${a[d]} * ${l}`;return`${f}; ${p};`}).join("");return o=`
        ivec3 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          ${u}
          return ivec3(r, c, d);
        }
      `,new Q(o)}getOutputUnpacked4DCoords(n,t){let o="",i=n.length,s=null;i<2&&(s=[]),s=new Array(i-1),s[i-2]=n[i-1];for(let l=i-3;l>=0;--l)s[l]=s[l+1]*n[l+1];let a=["r","c","d","d2"],u=s.map((l,d)=>{let f=`int ${a[d]} = index / ${l}`,p=d===s.length-1?`int ${a[d+1]} = index - ${a[d]} * ${l}`:`index -= ${a[d]} * ${l}`;return`${f}; ${p};`}).join("");return o=`
      ivec4 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          ${u}
          return ivec4(r, c, d, d2);
        }
      `,new Q(o)}getOutputUnpacked5DCoords(n,t){let o="",i=n.length,s=null;i<2&&(s=[]),s=new Array(i-1),s[i-2]=n[i-1];for(let l=i-3;l>=0;--l)s[l]=s[l+1]*n[l+1];let a=["r","c","d","d2","d3"],u=s.map((l,d)=>{let f=`int ${a[d]} = index / ${l}`,p=d===s.length-1?`int ${a[d+1]} = index - ${a[d]} * ${l}`:`index -= ${a[d]} * ${l}`;return`${f}; ${p};`}).join("");return o=`
      ivec5 getOutputCoords() {
          ivec2 resTexRC = ivec2(TexCoords.xy *
                                vec2(${t[0]}, ${t[1]}));
          int index = resTexRC.y * ${t[0]} + resTexRC.x;
          ${u}
          return ivec5(r, c, d, d2, d3);
        }
      `,new Q(o)}getOutputUnpacked6DCoords(n,t){let o="",i=n.length,s=null;i<2&&(s=[]),s=new Array(i-1),s[i-2]=n[i-1];for(let l=i-3;l>=0;--l)s[l]=s[l+1]*n[l+1];let a=["r","c","d","d2","d3","d4"],u=s.map((l,d)=>{let f=`int ${a[d]} = index / ${l}`,p=d===s.length-1?`int ${a[d+1]} = index - ${a[d]} * ${l}`:`index -= ${a[d]} * ${l}`;return`${f}; ${p};`}).join("");return o=`
     ivec6 getOutputCoords() {
         ivec2 resTexRC = ivec2(TexCoords.xy *
                               vec2(${t[0]}, ${t[1]}));
         int index = resTexRC.y * ${t[0]} + resTexRC.x;
         ${u}
         return ivec6(r, c, d, d2, d3, d4);
       }
     `,new Q(o)}getCommonUtilFuncs(){let n={},t="uvFromFlat";n[t]=new Q(`
    vec2 uvFromFlat(int texNumR, int texNumC, int index) {
      int texC = index / texNumR;
      int texR = index - texC * texNumR;
      // TODO: swap texR, texC order in following function so row is corresponding to u and column is corresponding to
      //       v.
      return (vec2(texR, texC) + halfCR) / vec2(texNumR, texNumC);
    }
    `),t="packedUVfrom1D",n[t]=new Q(`
      vec2 packedUVfrom1D(int texNumR, int texNumC, int index) {
        int texelIndex = index / 2;
        int texR = texelIndex / texNumC;
        int texC = texelIndex - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),t="packedUVfrom2D",n[t]=new Q(`
      vec2 packedUVfrom2D(int texNumR, int texNumC, int texelsInLogicalRow, int row, int col) {
        int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);
        int texR = texelIndex / texNumC;
        int texC = texelIndex - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),t="packedUVfrom3D",n[t]=new Q(`
      vec2 packedUVfrom3D(int texNumR, int texNumC,
          int texelsInBatch, int texelsInLogicalRow, int b,
          int row, int col) {
        int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);
        int texR = index / texNumC;
        int texC = index - texR * texNumC;
        return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);
      }
      `),t="sampleTexture";let o=ce(this.context.glContext.version);return n[t]=new Q(`
        float sampleTexture(sampler2D textureSampler, vec2 uv) {
            return ${o.texture2D}(textureSampler, uv).r;
        }`),n}getInputsSamplingSnippets(){let n={},t=this.context.outputTextureLayout;return this.context.programInfo.inputNames.forEach((o,i)=>{let s=this.context.inputTextureLayouts[i],a=pi(o);s.isPacked?n[a]=this.getPackedSamplerFromInput(a,o,s):n[a]=this.getUnpackedSamplerFromInput(a,o,s);let u=Ld(o);s.unpackedShape.length<=t.unpackedShape.length&&(s.isPacked?n[u]=this.getPackedSamplerAtOutputCoords(u,s,t,o):n[u]=this.getUnpackedSamplerAtOutputCoords(u,s,t,o))}),n}getPackedSamplerAtOutputCoords(n,t,o,i){let s=t.unpackedShape,a=o.unpackedShape,l=pi(i),d=s.length,f=a.length,p=Dt.getBroadcastDims(s,a),m=Bt(f),b=f-d,y,$=sr();d===0?y="":f<2&&p.length>=1?y="coords = 0;":y=p.map(W=>`coords.${$[W+b]} = 0;`).join(`
`);let x="";f<2&&d>0?x="coords":x=s.map((W,oe)=>`coords.${$[oe+b]}`).join(", ");let T="return outputValue;",E=te.size(s)===1,B=te.size(a)===1;if(d===1&&!E&&!B)T=`
        return vec4(outputValue.xy, outputValue.xy);
      `;else if(E&&!B)f===1?T=`
          return vec4(outputValue.x, outputValue.x, 0., 0.);
        `:T=`
          return vec4(outputValue.x);
        `;else if(p.length){let W=d-2,oe=d-1;p.indexOf(W)>-1&&p.indexOf(oe)>-1?T="return vec4(outputValue.x);":p.indexOf(W)>-1?T="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":p.indexOf(oe)>-1&&(T="return vec4(outputValue.xx, outputValue.zz);")}let F=`
        int lastDim = coords.${$[f-1]};
        coords.${$[f-1]} = coords.${$[f-2]};
        coords.${$[f-2]} = lastDim;
      `,P=`
      vec4 ${n}() {
        ${m} coords = getOutputCoords();
        ${F}
        ${y}
        vec4 outputValue = ${l}(${x});
        ${T}
      }
    `;return new Q(P,["coordinates.getOutputCoords"])}getUnpackedSamplerAtOutputCoords(n,t,o,i){let s=[o.width,o.height],a=[t.width,t.height],u=t.unpackedShape.length,l=o.unpackedShape.length,d=t.unpackedShape,f=o.unpackedShape,p=pi(i);if(u===l&&nn.arraysEqual(a,s)){let E=`
          float ${n}() {
            return sampleTexture(${i}, TexCoords);
          }
        `;return new Q(E,["coordinates.sampleTexture"])}let m=Bt(l),b=Dt.getBroadcastDims(d,f),y=l-u,$,x=sr();u===0?$="":l<2&&b.length>=1?$="coords = 0;":$=b.map(E=>`coords.${x[E+y]} = 0;`).join(`
`);let T="";l<2&&u>0?T="coords":T=t.unpackedShape.map((E,N)=>`coords.${x[N+y]}`).join(", ");let A=`
        float ${n}() {
          ${m} coords = getOutputCoords();
          ${$}
          return ${p}(${T});
        }
      `;return new Q(A,["coordinates.getOutputCoords"])}getPackedSamplerFromInput(n,t,o){switch(o.unpackedShape.length){case 0:return this.getPackedSamplerScalar(n,t);case 1:return this.getPackedSampler1D(n,t,o);case 2:return this.getPackedSampler2D(n,t,o);case 3:return this.getPackedSampler3D(n,t,o);default:return this.getPackedSamplerND(n,t,o)}}getUnpackedSamplerFromInput(n,t,o){let i=o.unpackedShape;switch(i.length){case 0:return this.getUnpackedSamplerScalar(n,t,o);case 1:return this.getUnpackedSampler1D(n,t,o);case 2:return this.getUnpackedSampler2D(n,t,o);case 3:return this.getUnpackedSampler3D(n,t,o);case 4:return this.getUnpackedSampler4D(n,t,o);case 5:return this.getUnpackedSampler5D(n,t,o);case 6:return this.getUnpackedSampler6D(n,t,o);default:throw new Error(`Unsupported dimension ${i.length}-D`)}}getPackedSamplerScalar(n,t){let o=ce(this.context.glContext.version),i=`
          vec4 ${n}() {
            return ${o.texture2D}(${t}, halfCR);
          }
        `;return new Q(i)}getPackedSampler1D(n,t,o){let i=[o.width,o.height],s=[i[1],i[0]],a=ce(this.context.glContext.version),l=`vec4 ${n}(int index) {
      vec2 uv = packedUVfrom1D(
      ${s[0]}, ${s[1]}, index);
      return ${a.texture2D}(${t}, uv);
    }`;return new Q(l,["coordinates.packedUVfrom1D"])}getPackedSampler2D(n,t,o){let i=o.unpackedShape,s=[o.width,o.height],a=ce(this.context.glContext.version),u=s[0],l=s[1];if(s!=null&&nn.arraysEqual(i,s)){let b=`vec4 ${n}(int row, int col) {
        vec2 uv = (vec2(col, row) + halfCR) / vec2(${l}.0, ${u}.0);
        return ${a.texture2D}(${t}, uv);
      }`;return new Q(b)}let d=s,f=Math.ceil(i[1]/2),m=`vec4 ${n}(int row, int col) {
      vec2 uv = packedUVfrom2D(${d[1]}, ${d[0]}, ${f}, row, col);
      return ${a.texture2D}(${t}, uv);
    }`;return new Q(m,["coordinates.packedUVfrom2D"])}getPackedSampler3D(n,t,o){let i=o.unpackedShape,s=[o.width,o.height],a=[s[0],s[1]],u=ce(this.context.glContext.version);if(i[0]===1){let y=i.slice(1),$=[1,2],x=On(i,y),T=["b","row","col"],A=JSON.parse(JSON.stringify(o));A.unpackedShape=x;let E=this.getPackedSamplerFromInput(n,t,A),B=`${E.routineBody}
      vec4 ${n}(int b, int row, int col) {
        return ${n}(${En(T,$)});
      } `;return new Q(B,E.dependencies)}let l=a[0],d=a[1],f=Math.ceil(i[2]/2),p=f*Math.ceil(i[1]/2),b=`vec4 ${n}(int b, int row, int col) {
      vec2 uv = packedUVfrom3D(
        ${d}, ${l}, ${p}, ${f}, b, row, col);
      return ${u.texture2D}(${t}, uv);}`;return new Q(b,["coordinates.packedUVfrom3D"])}getPackedSamplerND(n,t,o){let i=o.unpackedShape,s=i.length,a=[o.width,o.height],u=ce(this.context.glContext.version),l=[a[0],a[1]],d=l[1],f=l[0],p=Math.ceil(i[s-1]/2),m=p*Math.ceil(i[s-2]/2),b="int b, int row, int col",y=`b * ${m} + (row / 2) * ${p} + (col / 2)`;for(let T=2;T<s-1;T++)b=`int b${T}, `+b,m*=i[s-T-1],y=`b${T} * ${m} + `+y;let x=`vec4 ${n}(${b}) {
      int index = ${y};
      int texR = index / ${f};
      int texC = index - texR * ${f};
      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${f}, ${d});
      return ${u.texture2D}(${t}, uv);
    }`;return new Q(x)}getUnpackedSamplerScalar(n,t,o){let[i,s]=[o.width,o.height];if(i===1&&s===1){let u=`
          float ${n}() {
            return sampleTexture(${t}, halfCR);
          }
        `;return new Q(u,["coordinates.sampleTexture"])}let a=`
        float ${n}() {
          int offset_${t} = coordsToOffset(TexCoords, ${i}, ${s});
          vec2 uv = uvFromFlat(${i}, ${s}, offset_${t});
          return sampleTexture(${t}, uv);
        }
      `;return new Q(a,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler1D(n,t,o){let i=o.width,s=o.height;if(s===1&&i===1){let u=`
        float ${n}(int index) {
          return sampleTexture(${t}, halfCR);
        }
      `;return new Q(u,["coordinates.sampleTexture"])}if(s===1){let u=`
          float ${n}(int index) {
            vec2 uv = vec2((float(index) + 0.5) / ${i}.0, 0.5);
            return sampleTexture(${t}, uv);
          }
        `;return new Q(u,["coordinates.sampleTexture"])}if(i===1){let u=`
          float ${n}(int index) {
            vec2 uv = vec2(0.5, (float(index) + 0.5) / ${s}.0);
            return sampleTexture(${t}, uv);
          }
        `;return new Q(u,["coordinates.sampleTexture"])}let a=`
        float ${n}(int index) {
          vec2 uv = uvFromFlat(${i}, ${s}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new Q(a,["coordinates.uvFromFlat","coordinates.sampleTexture"])}getUnpackedSampler2D(n,t,o){let i=o.unpackedShape,s=[o.height,o.width];if(s!=null&&nn.arraysEqual(i,s)){let m=s[1],b=s[0],y=`
          float ${n}(int row, int col) {
            vec2 uv = (vec2(row, col) + halfCR) / vec2(${m}.0, ${b}.0);
            return sampleTexture(${t}, uv);
          }
        `;return new Q(y,["coordinates.sampleTexture"])}let{newShape:a,keptDims:u}=Dn(i),l=a;if(l.length<i.length){let m=On(i,l),b=JSON.parse(JSON.stringify(o));b.unpackedShape=m;let y=["col","row"],$=`
          ${this.getUnpackedSamplerFromInput(n,t,b).routineBody}
          float ${n}(int row, int col) {
            return ${n}(${En(y,u)});
          }
        `;return new Q($,["coordinates.sampleTexture"])}let d=s[1],f=s[0];if(f===1){let m=`
          float ${n}(int row, int col) {
            int offset_${t} = coordsToOffset(TexCoords, ${d}, ${f});
            float index = dot(vec3(row, col, offset_${t}), vec3(${i[1]}, 1, 1));
            vec2 uv = vec2(0.5, (index + 0.5) / ${d}.0);
            return sampleTexture(${t}, uv);
          }
        `;return new Q(m,["coordinates.sampleTexture","coordinates.coordsToOffset"])}if(d===1){let m=`
          float ${n}(int row, int col) {
            int offset_${t} = coordsToOffset(TexCoords, ${d}, ${f});
            float index = dot(vec3(row, col, offset_${t}), vec3(${i[1]}, 1, 1));
            vec2 uv = vec2((index + 0.5) / ${f}.0, 0.5);
            return sampleTexture(${t}, uv);
          }
        `;return new Q(m,["coordinates.sampleTexture","coordinates.coordsToOffset"])}let p=`
        float ${n}(int row, int col) {
          int index = col * ${i[1]} + row;
          vec2 uv = uvFromFlat(${d}, ${f}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new Q(p,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler3D(n,t,o){let i=o.unpackedShape,s=i[1]*i[2],a=i[2],{newShape:u,keptDims:l}=Dn(i),d=u;if(d.length<i.length){let b=On(i,d),y=["batch","col","row"],$=JSON.parse(JSON.stringify(o));$.unpackedShape=b;let x=this.getUnpackedSamplerFromInput(n,t,$),T=l.reverse(),A=`
          ${x.routineBody}
          float ${n}(int batch, int row, int col) {
            return ${n}(${En(y,T)});
          }
        `;return new Q(A,x.dependencies)}let f=o.width,p=o.height,m=`
          float ${n}(int depth, int row, int col) {
            // Explicitly use integer operations as dot() only works on floats.
            int index = depth * ${s} + col * ${a} + row;
            vec2 uv = uvFromFlat(${f}, ${p}, index);
            return sampleTexture(${t}, uv);
          }
      `;return new Q(m,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}getUnpackedSampler4D(n,t,o){let i=o.unpackedShape,s=i[3],a=i[2]*s,u=i[1]*a,l=o.width,d=o.height,f=`
        float ${n}(int row, int col, int depth, int depth2) {
          int index = row * ${u} + col * ${a} +
              depth2 * ${s} + depth;
          vec2 uv = uvFromFlat(${l}, ${d}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new Q(f,["coordinates.uvFromFlat","coordinates.sampleTexture"])}getUnpackedSampler5D(n,t,o){let i=o.unpackedShape,s=i[4],a=i[3]*s,u=i[2]*a,l=i[1]*u,{newShape:d,keptDims:f}=Dn(i);if(d.length<i.length){let y=On(i,d),$=["row","col","depth","depth2","depth3"],x=JSON.parse(JSON.stringify(o));x.unpackedShape=y;let T=`
          ${this.getUnpackedSamplerFromInput(n,t,x).routineBody}
          float ${n}(int row, int col, int depth, int depth2, int depth3) {
            return ${n}(${En($,f)});
          }
        `;return new Q(T,["coordinates.sampleTexture","coordinates.uvFromFlat"])}let p=o.width,m=o.height,b=`
        float ${n}(int row, int col, int depth, int depth2, int depth3) {
          int index = row * ${l} + col * ${u} + depth * ${a} +
          depth3 * ${s} + depth2;
          vec2 uv = uvFromFlat(${p}, ${m}, index);
          return sampleTexture(${t}, uv);
        }
      `;return new Q(b,["coordinates.sampleTexture","coordinates.uvFromFlat"])}getUnpackedSampler6D(n,t,o){let i=o.unpackedShape,s=i[5],a=i[4]*s,u=i[3]*a,l=i[2]*u,d=i[1]*l,{newShape:f,keptDims:p}=Dn(i);if(f.length<i.length){let $=On(i,f),x=["row","col","depth","depth2","depth3","depth4"],T=JSON.parse(JSON.stringify(o));T.unpackedShape=$;let A=`
            ${this.getUnpackedSamplerFromInput(n,t,T).routineBody}
            float ${n}(int row, int col, int depth,
              int depth2, int depth3, int depth4) {
              return ${n}(${En(x,p)});
            }
          `;return new Q(A,["coordinates.sampleTexture","coordinates.uvFromFlat"])}let m=o.width,b=o.height,y=`
          float ${n}(int row, int col, int depth,
            int depth2, int depth3, int depth4) {
            int index = row * ${d} + col * ${l} + depth * ${u} +
            depth2 * ${a} + depth3 * ${s} + depth4;
            vec2 uv = uvFromFlat(${m}, ${b}, index);
            return sampleTexture(${t}, uv);
          }
        `;return new Q(y,["coordinates.uvFromFlat","coordinates.sampleTexture","coordinates.coordsToOffset"])}toVec(){let n=this.context.outputTextureLayout,t=n.shape.length,o=n.strides,i=n.width,s=n.height,a=[];for(let l=0;l<t-1;++l)a.push(`
        c[${l}] = offset / ${o[l]};`),a.push(`
        offset -= c[${l}] * ${o[l]};`);a.push(`
        c[${t-1}] = offset;`);let u=`
      void toVec(vec2 texCoords, out int c[${t}]) {
        int offset = coordsToOffset(texCoords, ${i}, ${s});
        ${a.join("")}
      }
      void toVec(int offset, out int c[${t}]) {
        ${a.join("")}
      }
    `;return{toVec:new Q(u,["coordinates.coordsToOffset"])}}valueFrom(){let n={};return this.context.programInfo.inputNames.forEach((t,o)=>{let i=this.context.inputTextureLayouts[o],a=(i.unpackedShape.length>0?i.unpackedShape:i.shape).length,u=`_${t}`;n[u]=new Q(this.getValueFromSingle(t,a,i.width,i.height,!1),[`shapeUtils.indicesToOffset${u}`,"coordinates.offsetToCoords","fragcolor.getColorAsFloat"]),u=u+"_T",n[u]=new Q(this.getValueFromSingle(t,a,i.width,i.height,!0),[`shapeUtils.indicesToOffset${u}`,"coordinates.offsetToCoords","fragcolor.getColorAsFloat"])}),n}getValueFromSingle(n,t,o,i,s){let a=`_${n}`;s&&(a=a+"_T");let u=ce(this.context.glContext.version);return`
        float ${a}(int m[${t}]) {
          int offset = indicesToOffset${a}(m);
          vec2 coords = offsetToCoords(offset, ${o}, ${i});
          float value = getColorAsFloat(${u.texture2D}(${n}, coords));
          return value;
        }
        `}getPackedValueFrom(n,t,o,i,s){let a=`_${n}_Pack`;s&&(a=a+"_T");let u=ce(this.context.glContext.version);return`
        vec4 ${a}(int m[${t}]) {
          int offset = indicesToOffset_${n}(m);
          vec2 coords = offsetToCoords(offset, ${o}, ${i});
          return ${u.texture2D}(${n}, coords);
        }
        `}}});var Ei,Qp=D(()=>{"use strict";kr();Ei=class r extends Yt{constructor(e){super(e)}getFunctions(){return{...this.encodeFloat32(),...this.decodeFloat32()}}getCustomTypes(){return{}}encodeFloat32(){return{encode:new Q(`highp vec4 encode(highp float f) {
        return vec4(f, 0.0, 0.0, 0.0);
      }
        `)}}decodeFloat32(){return{decode:new Q(`highp float decode(highp vec4 rgba) {
        return rgba.r;
      }
        `)}}encodeUint8(){let e=r.isLittleEndian()?"rgba.rgba=rgba.abgr;":"";return{encode:new Q(`
      highp vec4 encode(highp float f) {
        highp float F = abs(f);
        highp float Sign = step(0.0,-f);
        highp float Exponent = floor(log2(F));
        highp float Mantissa = (exp2(- Exponent) * F);
        Exponent = floor(log2(F) + 127.0) + floor(log2(Mantissa));
        highp vec4 rgba;
        rgba[0] = 128.0 * Sign  + floor(Exponent*exp2(-1.0));
        rgba[1] = 128.0 * mod(Exponent,2.0) + mod(floor(Mantissa*128.0),128.0);
        rgba[2] = floor(mod(floor(Mantissa*exp2(23.0 -8.0)),exp2(8.0)));
        rgba[3] = floor(exp2(23.0)*mod(Mantissa,exp2(-15.0)));
        ${e}
        rgba = rgba / 255.0; // values need to be normalized to [0,1]
        return rgba;
    }
        `)}}decodeUint8(){let e=r.isLittleEndian()?"rgba.rgba=rgba.abgr;":"";return{decode:new Q(`
        highp float decode(highp vec4 rgba) {
          rgba = rgba * 255.0; // values need to be de-normalized from [0,1] to [0,255]
          ${e}
          highp float Sign = 1.0 - step(128.0,rgba[0])*2.0;
          highp float Exponent = 2.0 * mod(rgba[0],128.0) + step(128.0,rgba[1]) - 127.0;
          highp float Mantissa = mod(rgba[1],128.0)*65536.0 + rgba[2]*256.0 +rgba[3] + float(0x800000);
          highp float Result =  Sign * exp2(Exponent) * (Mantissa * exp2(-23.0 ));
          return Result;
      }
        `)}}static isLittleEndian(){let e=new ArrayBuffer(4),n=new Uint32Array(e),t=new Uint8Array(e);if(n[0]=3735928559,t[0]===239)return!0;if(t[0]===222)return!1;throw new Error("unknown endianness")}}});var Ci,eh=D(()=>{"use strict";kr();ot();Ci=class extends Yt{constructor(e){super(e)}getFunctions(){return{...this.setFragColor(),...this.getColorAsFloat()}}getCustomTypes(){return{}}setFragColor(){let e=ce(this.context.glContext.version);return{setFragColor:new Q(`
        void setFragColor(float value) {
            ${e.output} = encode(value);
        }
        `,["encoding.encode"])}}getColorAsFloat(){return{getColorAsFloat:new Q(`
        float getColorAsFloat(vec4 color) {
            return decode(color);
        }
        `,["encoding.decode"])}}}});var Pi,th=D(()=>{"use strict";kr();Pi=class r extends Yt{constructor(e){super(e)}getFunctions(){return{...this.bcastIndex(),...this.bcastMatmulIndex(),...this.offsetToIndices(),...this.indicesToOffset(),...this.incrementIndices()}}getCustomTypes(){return{}}bcastIndex(){let e=this.context.outputTextureLayout.shape.length,n={};return this.context.programInfo.inputNames.forEach((t,o)=>{let i=this.context.inputTextureLayouts[o].unpackedShape;if(i.length<=e){let s=i.length,a=e-s,u=`bcastIndices_${t}`,l="";for(let f=0;f<s;++f)l+=`
          realIndices[${f}] = int( mod(float(bcastedIndices[${a+f}]), ${i[f]}.0) );
          `;let d=`
        void ${u} (int bcastedIndices[${e}], out int realIndices[${s}]) {
          ${l}
        }
        `;n[u]=new Q(d)}}),n}bcastMatmulIndex(){let e=this.context.outputTextureLayout.shape.length,n={};return this.context.programInfo.inputNames.forEach((t,o)=>{let i=this.context.inputTextureLayouts[o].shape;if(!(i.length<2||i.length>e)){let s=i.length,a=e-s,u=`bcastMatmulIndices_${t}`,l="";for(let f=0;f<s-2;++f)l+=`
          realIndices[${f}] = int( mod(float(bcastedIndices[${a+f}]), ${i[f]}.0) );
          `;let d=`
        void ${u}(int bcastedIndices[${e}], out int realIndices[${s}]) {
          ${l}
          realIndices[${s-1}] = bcastedIndices[${e-1}];
          realIndices[${s-2}] = bcastedIndices[${e-2}];
        }
        `;n[u]=new Q(d)}}),n}indicesToOffset(){let e={};return this.context.programInfo.inputNames.forEach((n,t)=>{let o=this.context.inputTextureLayouts[t].shape,i=this.context.inputTextureLayouts[t].strides,s=o.length,a=`indicesToOffset_${n}`;e[a]=new Q(r.indexToOffsetSingle(a,s,i)),a=`indicesToOffset_${n}_T`,e[a]=new Q(r.indexToOffsetSingle(a,s,i.slice().reverse()))}),e}static indexToOffsetSingle(e,n,t){let o="";for(let i=n-1;i>=0;--i)o+=`
        offset += indices[${i}] * ${t[i]};
        `;return`
      int ${e}(int indices[${n}]) {
        int offset = 0;
        ${o}
        return offset;
      }
      `}offsetToIndices(){let e={};return this.context.programInfo.inputNames.forEach((n,t)=>{let o=this.context.inputTextureLayouts[t].shape,i=this.context.inputTextureLayouts[t].strides,s=o.length,a=`offsetToIndices_${n}`;e[a]=new Q(r.offsetToIndicesSingle(a,s,i)),a=`offsetToIndices_${n}_T`,e[a]=new Q(r.offsetToIndicesSingle(a,s,i.slice().reverse()))}),e}static offsetToIndicesSingle(e,n,t){let o=[];for(let i=0;i<n-1;++i)o.push(`
      indices[${i}] = offset / ${t[i]};`),o.push(`
        offset -= indices[${i}] * ${t[i]};`);return o.push(`
      indices[${n-1}] = offset;`),`
      void ${e}(int offset, out int indices[${n}]) {
        ${o.join("")}
      }
      `}incrementIndices(){let e={};return this.context.programInfo.inputNames.forEach((n,t)=>{let o=this.context.inputTextureLayouts[t].shape,i=o.length,s=`incrementIndices_${n}`,a="";for(let l=0;l<i;++l)a+=`
        shape[${l}] = ${o[l]};`;let u=`
        void ${s}(int axis, out int indices[${i}]) {
          int shape[${i}];
          ${a};
          for(int i = ${i} -1 ; i >= 0; --i) {
            if(i > axis) continue;
            indices[i] += 1;
            if(indices[i] < shape[i]) {
              break;
            }
            indices[i] = 0;
          }
        }
        `;e[s]=new Q(u)}),e}}});var ki,rh=D(()=>{"use strict";kr();ki=class extends Yt{constructor(e){super(e)}getCustomTypes(){return{}}getFunctions(){return{...this.binaryVecFunctions(),...this.copyVec(),...this.setVecItem(),...this.getVecItem()}}binaryVecFunctions(){let n=this.context.outputTextureLayout.shape.length,t={add:"+=",sub:"-=",mul:"*=",div:"/="},o={};for(let i in t){let s=`${i}Vec`,a="";for(let l=0;l<n;++l)a+=`
          dest[${l}] ${t[i]} src[${l}];
          `;let u=`
        void ${s}(int src[${n}], out int dest[${n}]) {
          ${a}
        }
        `;o[s]=new Q(u)}return o}copyVec(){let n=this.context.outputTextureLayout.shape.length,t="";for(let i=0;i<n;++i)t+=`
        dest[${i}] = src[${i}];
        `;let o=`
      void copyVec(int src[${n}], out int dest[${n}]) {
        ${t}
      }
      `;return{copyVec:new Q(o)}}setVecItem(){let n=this.context.outputTextureLayout.shape.length,t=`
        if(index < 0)
            index =${n} + index;
        if (index == 0)
            m[0] = value;
        `;for(let i=1;i<n-1;++i)t+=`
        else if (index == ${i})
            m[${i}] = value;
            `;t+=`
        else
            m[${n-1}] = value;
        `;let o=`
      void setVecItem(out int m[${n}], int index, int value) {
        ${t}
      }
        `;return{setVecItem:new Q(o)}}getVecItem(){let n=this.context.outputTextureLayout.shape.length,t=`
        if(index < 0)
            index = ${n} + index;
        if (index == 0)
            return m[0];
      `;for(let i=1;i<n-1;++i)t+=`
        else if (index == ${i})
            return m[${i}];
      `;t+=`
        else
            return m[${n-1}];
        `;let o=`
      int getVecItem(int m[${n}], int index) {
        ${t}
      }
    `;return{getVecItem:new Q(o)}}}});var Os,nh=D(()=>{"use strict";Jp();Qp();eh();th();rh();Os={encoding:Ei,fragcolor:Ci,vec:ki,shapeUtils:Pi,coordinates:Oi}});var Di,oh=D(()=>{"use strict";kr();Xp();nh();ot();Di=class{constructor(e,n,t,o){this.libs={};this.glslLibRoutineDependencyGraph={};this.context=new bi(e,n,t,o),Object.keys(Os).forEach(s=>{let a=new Os[s](this.context);this.libs[s]=a});let i=this.glslLibRoutineDependencyGraph;for(let s in this.libs){let u=this.libs[s].getFunctions();for(let l in u){let d=s+"."+l,f;i[d]?(f=i[d],f.routineBody=u[l].routineBody):(f=new mo(d,u[l].routineBody),i[d]=f);let p=u[l].dependencies;if(p)for(let m=0;m<p.length;++m)if(i[p[m]])f.addDependency(i[p[m]]);else{let b=new mo(p[m]);i[p[m]]=b,f.addDependency(b)}}}}preprocess(){let e=this.context.programInfo,n=e.shaderSource;return this.context.programInfo.hasMain||(n=`${n}
      ${Nd(this.context.glContext.version,this.context.outputTextureLayout.shape.length)}`),n=Yp(n),`${zd(this.context.glContext.version)}
    ${this.getUniforms(e.inputNames,e.variables)}
    ${this.getImports(n)}
    ${n}`}getImports(e){let n=this.selectGlslLibRoutinesToBeIncluded(e);if(n.length===0)return"";let t="";for(let o=0;o<n.length;++o)if(n[o].routineBody)t+=n[o].routineBody+`
`;else throw new Error(`Missing body for the Glsl Library routine: ${n[o].name}`);return t}selectGlslLibRoutinesToBeIncluded(e){let n=[];return Object.keys(this.glslLibRoutineDependencyGraph).forEach(t=>{let o=t.split(".")[1];e.indexOf(o)!==-1&&n.push(this.glslLibRoutineDependencyGraph[t])}),yi.returnOrderedNodes(n)}getUniforms(e,n){let t=[];if(e)for(let o of e)t.push(`uniform sampler2D ${o};`);if(n)for(let o of n)t.push(`uniform ${o.type} ${o.name}${o.arrayLength?`[${o.arrayLength}]`:""};`);return t.join(`
`)}}});var Bi,ih=D(()=>{"use strict";Et();Ht();oh();ot();Bi=class{constructor(e,n,t){this.profiler=e;this.glContext=n;this.textureLayoutStrategy=t;this.repo=new Map,this.attributesBound=!1}getArtifact(e){return this.repo.get(e)}setArtifact(e,n){this.repo.set(e,n)}run(e,n,t){this.profiler.event("op",`ProgramManager.run ${e.programInfo.name??"unknown kernel"}`,()=>{let o=this.glContext.gl,i=e.program;o.useProgram(i);try{this.bindOutput(t),this.attributesBound||this.bindAttributes(e.attribLocations),this.bindUniforms(e.uniformLocations,e.programInfo.variables??[],n)}catch(s){throw qe.error("ProgramManager",e.programInfo.shaderSource),s}this.profiler.event("backend","GlContext.draw()",()=>{this.glContext.draw()})},this.glContext)}dispose(){this.vertexShader&&this.glContext.deleteShader(this.vertexShader),this.repo.forEach(e=>this.glContext.deleteProgram(e.program))}build(e,n,t){return this.profiler.event("backend","ProgramManager.build",()=>{let o=new Di(this.glContext,e,n,t),i=o.preprocess(),s=this.compile(i);return{programInfo:e,program:s,uniformLocations:this.getUniformLocations(s,o.context.programInfo.inputNames,o.context.programInfo.variables),attribLocations:this.getAttribLocations(s)}})}compile(e){if(!this.vertexShader){qe.verbose("ProrgramManager","Compiling and caching Vertex shader for the first time");let o=Rd(this.glContext.version);this.vertexShader=this.glContext.compileShader(o,this.glContext.gl.VERTEX_SHADER)}be.debug&&qe.verbose("ProrgramManager",`FragShader:
${e}
`);let n=this.glContext.compileShader(e,this.glContext.gl.FRAGMENT_SHADER),t=this.glContext.createProgram(this.vertexShader,n);return this.glContext.deleteShader(n),t}bindOutput(e){let n=e.width,t=e.height;qe.verbose("ProrgramManager",`Binding output texture to Framebuffer: w/h=${n}/${t}, shape=${e.shape}, type=${e.tensor.type}`),this.glContext.attachFramebuffer(e.texture,n,t)}bindAttributes(e){let n=e.position,t=e.textureCoord;this.glContext.setVertexAttributes(n,t),this.attributesBound=!0}bindUniforms(e,n,t){let o=this.glContext.gl,i=0;for(let{name:s,type:a,location:u,arrayLength:l}of e){let d=n.find(f=>f.name===s)?.data;if(a!=="sampler2D"&&!d)throw new Error(`variable '${s}' does not have data defined in program info`);switch(a){case"sampler2D":this.bindTexture(t[i],u,i),i++;break;case"float":l?o.uniform1fv(u,d):o.uniform1f(u,d);break;case"int":l?o.uniform1iv(u,d):o.uniform1i(u,d);break;default:throw new Error(`Uniform not implemented: ${a}`)}}}bindTexture(e,n,t){this.glContext.bindTextureToUniform(e.texture,t,n)}getAttribLocations(e){return{position:this.getAttribLocation(e,"position"),textureCoord:this.getAttribLocation(e,"textureCoord")}}getUniformLocations(e,n,t){let o=[];if(n)for(let i of n)o.push({name:i,type:"sampler2D",location:this.getUniformLocation(e,i)});if(t)for(let i of t)o.push({...i,location:this.getUniformLocation(e,i.name)});return o}getUniformLocation(e,n){let o=this.glContext.gl.getUniformLocation(e,n);if(o===null)throw new Error(`Uniform ${n} not found.`);return o}getAttribLocation(e,n){return this.glContext.gl.getAttribLocation(e,n)}}});var Ri,ah=D(()=>{"use strict";Ht();po();Ri=class{constructor(e,n,t,o){this.glContext=e;this.layoutStrategy=n;this.profiler=t;this.config=o;this.pendingRead=new Map;o.reuseTextures&&(this.inUseTextures=new Map,this.idleTextures=new Map,this.textureLookup=new Map)}createTextureFromLayout(e,n,t,o){let i=this.toEncoderType(e),s=this.glContext.getEncoder(i,n.channels||1,o);if(n.isPacked&&o===1)throw new Error("not implemented");let a=n.width,u=n.height,l,d;if(this.config.reuseTextures){l=`${a}x${u}_${s.format}_${s.internalFormat}_${s.textureType}`,d=this.inUseTextures.get(l),d||(d=[],this.inUseTextures.set(l,d));let p=this.idleTextures.get(l);if(p&&p.length>0){let m=p.pop();return d.push(m),o===1&&this.glContext.updateTexture(m,a,u,s,this.toTextureData(e,t)),m}}qe.verbose("TextureManager",`Creating new texture of size ${n.width}x${n.height}`);let f=this.glContext.allocateTexture(a,u,s,this.toTextureData(e,t));return this.config.reuseTextures&&(d.push(f),this.textureLookup.set(f,l)),f}readTexture(e,n,t){return t||(t=1),this.profiler.event("backend","TextureManager.readTexture",()=>{let o=e.shape.reduce((s,a)=>s*a)*t,i=this.glContext.readTexture(e.texture,e.width,e.height,o,this.toEncoderType(n),t);return this.toTensorData(n,i)})}async readTextureAsync(e,n,t){let o=e.tensor.dataId;if(t||(t=1),this.pendingRead.has(o)){let i=this.pendingRead.get(o);return new Promise(s=>i?.push(s))}return this.profiler.event("backend","TextureManager.readTextureAsync",async()=>{this.pendingRead.set(o,[]);let i=e.shape.reduce((l,d)=>l*d)*t;await this.glContext.createAndWaitForFence();let s=this.glContext.readTexture(e.texture,e.width,e.height,i,this.toEncoderType(n),t),a=this.toTensorData(n,s),u=this.pendingRead.get(o);return this.pendingRead.delete(o),u?.forEach(l=>l(a)),a})}readUint8TextureAsFloat(e){return this.profiler.event("backend","TextureManager.readUint8TextureAsFloat",()=>{let n=e.shape.reduce((o,i)=>o*i),t=this.glContext.readTexture(e.texture,e.width,e.height,n*4,"byte",4);return new Float32Array(t.buffer,t.byteOffset,n)})}releaseTexture(e,n){let t;if(this.config.reuseTextures&&(t=this.textureLookup.get(e.texture),t)){n&&this.textureLookup.delete(t);let o=this.inUseTextures.get(t);if(o){let i=o.indexOf(e.texture);if(i!==-1){o.splice(i,1);let s=this.idleTextures.get(t);s||(s=[],this.idleTextures.set(t,s)),s.push(e.texture)}}}(!t||n)&&(qe.verbose("TextureManager",`Deleting texture of size ${e.width}x${e.height}`),this.glContext.deleteTexture(e.texture))}toTensorData(e,n){switch(e){case"int16":return n instanceof Int16Array?n:Int16Array.from(n);case"int32":return n instanceof Int32Array?n:Int32Array.from(n);case"int8":return n instanceof Int8Array?n:Int8Array.from(n);case"uint16":return n instanceof Uint16Array?n:Uint16Array.from(n);case"uint32":return n instanceof Uint32Array?n:Uint32Array.from(n);case"uint8":case"bool":return n instanceof Uint8Array?n:Uint8Array.from(n);case"float32":return n instanceof Float32Array?n:Float32Array.from(n);case"float64":return n instanceof Float64Array?n:Float64Array.from(n);default:throw new Error(`TensorData type ${e} is not supported`)}}toTextureData(e,n){if(n)return n instanceof Float32Array?n:new Float32Array(n)}toEncoderType(e){return"float"}clearActiveTextures(){this.glContext.clearActiveTextures()}}});var zi,sh=D(()=>{"use strict";Ht();xl();Jd();jp();ih();As();ah();zi=class{constructor(e,n){this.backend=e;this.context=n;this.layoutStrategy=new Ai(e.glContext.maxTextureSize),this.programManager=new Bi(this.context.profiler,e.glContext,this.layoutStrategy),this.textureManager=new Ri(e.glContext,this.layoutStrategy,this.context.profiler,{reuseTextures:e.textureCacheMode==="full"}),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache=new Map,this.pack=e.pack,this.pack2unpackMap=new Map,this.unpack2packMap=new Map}createInferenceHandler(){return new gi(this)}onGraphInitialized(e){let n=e.getValues().filter(t=>t.from===-1&&t.tensor).map(t=>t.tensor.dataId);this.initializers=new Set(n)}isInitializer(e){return this.initializers?this.initializers.has(e):!1}addInitializer(e){this.initializers.add(e)}getTextureData(e,n){return n?this.packedTextureDataCache.get(e):this.unpackedTextureDataCache.get(e)}setTextureData(e,n,t=!1){qe.verbose("WebGLSessionHandler","Storing Texture data in cache"),t?this.packedTextureDataCache.set(e,n):this.unpackedTextureDataCache.set(e,n)}dispose(){this.programManager.dispose(),this.textureManager.clearActiveTextures(),this.packedTextureDataCache.forEach(e=>this.textureManager.releaseTexture(e,!0)),this.packedTextureDataCache=new Map,this.unpackedTextureDataCache.forEach(e=>this.textureManager.releaseTexture(e,!0)),this.unpackedTextureDataCache=new Map}resolve(e,n,t){let o=wl(e,n,qp);return{impl:o.opImpl,context:o.opInit?o.opInit(e,t):e}}}});function dx(r){let e=0;for(;e<r.length&&r[e]();++e);return e-1}var yo,uh=D(()=>{"use strict";Et();po();po();hr();yo=class{constructor(e,n){this.frameBufferBound=!1;this.itemsToPoll=[];this.gl=e,this.version=n,this.getExtensions(),this.vertexbuffer=this.createVertexbuffer(),this.framebuffer=this.createFramebuffer(),this.queryVitalParameters()}allocateTexture(e,n,t,o){let i=this.gl,s=i.createTexture();i.bindTexture(i.TEXTURE_2D,s),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE);let a=o?t.encode(o,e*n):null;return i.texImage2D(i.TEXTURE_2D,0,t.internalFormat,e,n,0,t.format,t.textureType,a),this.checkError(),s}updateTexture(e,n,t,o,i){let s=this.gl;s.bindTexture(s.TEXTURE_2D,e);let a=o.encode(i,n*t);s.texSubImage2D(s.TEXTURE_2D,0,0,0,n,t,o.format,o.textureType,a),this.checkError()}attachFramebuffer(e,n,t){let o=this.gl;o.bindTexture(o.TEXTURE_2D,e),o.bindFramebuffer(o.FRAMEBUFFER,this.framebuffer),o.framebufferTexture2D(o.FRAMEBUFFER,o.COLOR_ATTACHMENT0,o.TEXTURE_2D,e,0),this.checkError(),o.viewport(0,0,n,t),o.scissor(0,0,n,t)}readTexture(e,n,t,o,i,s){let a=this.gl;s||(s=1),this.frameBufferBound||this.attachFramebuffer(e,n,t);let u=this.getEncoder(i,s),l=u.allocate(n*t);return a.bindTexture(a.TEXTURE_2D,e),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,e,0),a.readPixels(0,0,n,t,a.RGBA,u.textureType,l),this.checkError(),u.decode(l,o)}isFramebufferReady(){return!0}getActiveTexture(){let e=this.gl;return`TEXTURE${e.getParameter(this.gl.ACTIVE_TEXTURE)-e.TEXTURE0}`}getTextureBinding(){return this.gl.getParameter(this.gl.TEXTURE_BINDING_2D)}getFramebufferBinding(){return this.gl.getParameter(this.gl.FRAMEBUFFER_BINDING)}setVertexAttributes(e,n){let t=this.gl;t.vertexAttribPointer(e,3,t.FLOAT,!1,20,0),t.enableVertexAttribArray(e),n!==-1&&(t.vertexAttribPointer(n,2,t.FLOAT,!1,20,12),t.enableVertexAttribArray(n)),this.checkError()}createProgram(e,n){let t=this.gl,o=t.createProgram();return t.attachShader(o,e),t.attachShader(o,n),t.linkProgram(o),o}compileShader(e,n){let t=this.gl,o=t.createShader(n);if(!o)throw new Error(`createShader() returned null with type ${n}`);if(t.shaderSource(o,e),t.compileShader(o),t.getShaderParameter(o,t.COMPILE_STATUS)===!1)throw new Error(`Failed to compile shader: ${t.getShaderInfoLog(o)}
Shader source:
${e}`);return o}deleteShader(e){this.gl.deleteShader(e)}bindTextureToUniform(e,n,t){let o=this.gl;o.activeTexture(o.TEXTURE0+n),this.checkError(),o.bindTexture(o.TEXTURE_2D,e),this.checkError(),o.uniform1i(t,n),this.checkError()}draw(){this.gl.drawArrays(this.gl.TRIANGLE_STRIP,0,4),this.checkError()}checkError(){if(be.debug){let e=this.gl,n=e.getError(),t="";switch(n){case e.NO_ERROR:return;case e.INVALID_ENUM:t="INVALID_ENUM";break;case e.INVALID_VALUE:t="INVALID_VALUE";break;case e.INVALID_OPERATION:t="INVALID_OPERATION";break;case e.INVALID_FRAMEBUFFER_OPERATION:t="INVALID_FRAMEBUFFER_OPERATION";break;case e.OUT_OF_MEMORY:t="OUT_OF_MEMORY";break;case e.CONTEXT_LOST_WEBGL:t="CONTEXT_LOST_WEBGL";break;default:t=`Unknown WebGL Error: ${n.toString(16)}`}throw new Error(t)}}deleteTexture(e){this.gl.deleteTexture(e)}deleteProgram(e){this.gl.deleteProgram(e)}getEncoder(e,n,t=0){if(this.version===2)return new hi(this.gl,n);switch(e){case"float":return t===1||this.isRenderFloat32Supported?new fo(this.gl,n):new fo(this.gl,n,this.textureHalfFloatExtension.HALF_FLOAT_OES);case"int":throw new Error("not implemented");case"byte":return new mi(this.gl,n);default:throw new Error(`Invalid dataType: ${e}`)}}clearActiveTextures(){let e=this.gl;for(let n=0;n<this.maxTextureImageUnits;++n)e.activeTexture(e.TEXTURE0+n),e.bindTexture(e.TEXTURE_2D,null)}dispose(){if(this.disposed)return;let e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteFramebuffer(this.framebuffer),e.bindBuffer(e.ARRAY_BUFFER,null),e.deleteBuffer(this.vertexbuffer),e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null),e.finish(),this.disposed=!0}createDefaultGeometry(){return new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0])}createVertexbuffer(){let e=this.gl,n=e.createBuffer();if(!n)throw new Error("createBuffer() returned null");let t=this.createDefaultGeometry();return e.bindBuffer(e.ARRAY_BUFFER,n),e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW),this.checkError(),n}createFramebuffer(){let e=this.gl.createFramebuffer();if(!e)throw new Error("createFramebuffer returned null");return e}queryVitalParameters(){let e=this.gl;if(this.isFloatTextureAttachableToFrameBuffer=this.checkFloatTextureAttachableToFrameBuffer(),this.isRenderFloat32Supported=this.checkRenderFloat32(),this.isFloat32DownloadSupported=this.checkFloat32Download(),this.version===1&&!this.textureHalfFloatExtension&&!this.isRenderFloat32Supported)throw new Error("both float32 and float16 TextureType are not supported");this.isBlendSupported=!this.isRenderFloat32Supported||this.checkFloat32Blend(),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),this.maxTextureImageUnits=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS),this.version}getExtensions(){this.version===2?(this.colorBufferFloatExtension=this.gl.getExtension("EXT_color_buffer_float"),this.disjointTimerQueryWebgl2Extension=this.gl.getExtension("EXT_disjoint_timer_query_webgl2")):(this.textureFloatExtension=this.gl.getExtension("OES_texture_float"),this.textureHalfFloatExtension=this.gl.getExtension("OES_texture_half_float"))}checkFloatTextureAttachableToFrameBuffer(){let e=this.gl,n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);let t=this.version===2?e.RGBA32F:e.RGBA;e.texImage2D(e.TEXTURE_2D,0,t,1,1,0,e.RGBA,e.FLOAT,null);let o=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,o),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);let i=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(o),i}checkRenderFloat32(){if(this.version===2){if(!this.colorBufferFloatExtension)return!1}else if(!this.textureFloatExtension)return!1;return this.isFloatTextureAttachableToFrameBuffer}checkFloat32Download(){if(this.version===2){if(!this.colorBufferFloatExtension)return!1}else if(!this.textureFloatExtension||!this.gl.getExtension("WEBGL_color_buffer_float"))return!1;return this.isFloatTextureAttachableToFrameBuffer}checkFloat32Blend(){let e=this.gl,n,t,o,i,s;try{n=e.createTexture(),t=e.createFramebuffer(),e.bindTexture(e.TEXTURE_2D,n);let a=this.version===2?e.RGBA32F:e.RGBA;return e.texImage2D(e.TEXTURE_2D,0,a,1,1,0,e.RGBA,e.FLOAT,null),e.bindFramebuffer(e.FRAMEBUFFER,t),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0),e.enable(e.BLEND),o=e.createShader(e.VERTEX_SHADER),!o||(e.shaderSource(o,"void main(){}"),e.compileShader(o),i=e.createShader(e.FRAGMENT_SHADER),!i)||(e.shaderSource(i,"precision highp float;void main(){gl_FragColor=vec4(0.5);}"),e.compileShader(i),s=e.createProgram(),!s)?!1:(e.attachShader(s,o),e.attachShader(s,i),e.linkProgram(s),e.useProgram(s),e.drawArrays(e.POINTS,0,1),e.getError()===e.NO_ERROR)}finally{e.disable(e.BLEND),s&&e.deleteProgram(s),o&&e.deleteShader(o),i&&e.deleteShader(i),t&&(e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteFramebuffer(t)),n&&(e.bindTexture(e.TEXTURE_2D,null),e.deleteTexture(n))}}beginTimer(){if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let e=this.gl,n=this.disjointTimerQueryWebgl2Extension,t=e.createQuery();return e.beginQuery(n.TIME_ELAPSED_EXT,t),t}else throw new Error("WebGL1 profiling currently not supported.")}endTimer(){if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let e=this.gl,n=this.disjointTimerQueryWebgl2Extension;e.endQuery(n.TIME_ELAPSED_EXT);return}else throw new Error("WebGL1 profiling currently not supported")}isTimerResultAvailable(e){let n=!1,t=!1;if(this.version===2&&this.disjointTimerQueryWebgl2Extension){let o=this.gl,i=this.disjointTimerQueryWebgl2Extension;n=o.getQueryParameter(e,o.QUERY_RESULT_AVAILABLE),t=o.getParameter(i.GPU_DISJOINT_EXT)}else throw new Error("WebGL1 profiling currently not supported");return n&&!t}getTimerResult(e){let n=0;if(this.version===2){let t=this.gl;n=t.getQueryParameter(e,t.QUERY_RESULT),t.deleteQuery(e)}else throw new Error("WebGL1 profiling currently not supported");return n/1e6}async waitForQueryAndGetTime(e){return await Qa(()=>this.isTimerResultAvailable(e)),this.getTimerResult(e)}async createAndWaitForFence(){let e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let n,t=e,o=t.fenceSync(t.SYNC_GPU_COMMANDS_COMPLETE,0);return e.flush(),o===null?n=()=>!0:n=()=>{let i=t.clientWaitSync(o,0,0);return i===t.ALREADY_SIGNALED||i===t.CONDITION_SATISFIED},{query:o,isFencePassed:n}}async pollFence(e){return new Promise(n=>{this.addItemToPoll(()=>e.isFencePassed(),()=>n())})}pollItems(){let e=dx(this.itemsToPoll.map(n=>n.isDoneFn));for(let n=0;n<=e;++n){let{resolveFn:t}=this.itemsToPoll[n];t()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}async addItemToPoll(e,n){this.itemsToPoll.push({isDoneFn:e,resolveFn:n}),!(this.itemsToPoll.length>1)&&await Qa(()=>(this.pollItems(),this.itemsToPoll.length===0))}}});function Es(r){let e;if((!r||r==="webgl2")&&"webgl2"in Bn?e=Bn.webgl2:(!r||r==="webgl")&&"webgl"in Bn&&(e=Bn.webgl),!e)try{let t=fx();e=lh(t,r)}catch{let o=cx();e=lh(o,r)}r=r||e.version===1?"webgl":"webgl2";let n=e.gl;return Bn[r]=e,n.isContextLost()?(delete Bn[r],Es(r)):(n.disable(n.DEPTH_TEST),n.disable(n.STENCIL_TEST),n.disable(n.BLEND),n.disable(n.DITHER),n.disable(n.POLYGON_OFFSET_FILL),n.disable(n.SAMPLE_COVERAGE),n.enable(n.SCISSOR_TEST),n.enable(n.CULL_FACE),n.cullFace(n.BACK),e)}function lh(r,e){let n={alpha:!1,depth:!1,antialias:!1,stencil:!1,preserveDrawingBuffer:!1,premultipliedAlpha:!1,failIfMajorPerformanceCaveat:!1},t,o=n;if((!e||e==="webgl2")&&(t=r.getContext("webgl2",o),t))try{return new yo(t,2)}catch(i){qe.warning("GlContextFactory",`failed to create WebGLContext using contextId 'webgl2'. Error: ${i}`)}if((!e||e==="webgl")&&(t=r.getContext("webgl",o)||r.getContext("experimental-webgl",o),t))try{return new yo(t,1)}catch(i){qe.warning("GlContextFactory",`failed to create WebGLContext using contextId 'webgl' or 'experimental-webgl'. Error: ${i}`)}throw new Error("WebGL is not supported")}function cx(){if(typeof document>"u")throw new TypeError("failed to create canvas: document is not supported");let r=document.createElement("canvas");return r.width=1,r.height=1,r}function fx(){if(typeof OffscreenCanvas>"u")throw new TypeError("failed to create offscreen canvas: OffscreenCanvas is not supported");return new OffscreenCanvas(1,1)}var Bn,dh=D(()=>{"use strict";Ht();uh();Bn={}});var Ni,ch=D(()=>{"use strict";Et();Ht();sh();dh();Ni=class{get contextId(){return be.webgl.contextId}set contextId(e){be.webgl.contextId=e}get matmulMaxBatchSize(){return be.webgl.matmulMaxBatchSize}set matmulMaxBatchSize(e){be.webgl.matmulMaxBatchSize=e}get textureCacheMode(){return be.webgl.textureCacheMode}set textureCacheMode(e){be.webgl.textureCacheMode=e}get pack(){return be.webgl.pack}set pack(e){be.webgl.pack=e}get async(){return be.webgl.async}set async(e){be.webgl.async=e}initialize(){try{return this.glContext=Es(this.contextId),typeof this.matmulMaxBatchSize!="number"&&(this.matmulMaxBatchSize=16),typeof this.textureCacheMode!="string"&&(this.textureCacheMode="full"),typeof this.pack!="boolean"&&(this.pack=!1),typeof this.async!="boolean"&&(this.async=!1),qe.setWithEnv(be),be.webgl.context||Object.defineProperty(be.webgl,"context",{value:this.glContext.gl}),qe.verbose("WebGLBackend",`Created WebGLContext: ${typeof this.glContext} with matmulMaxBatchSize: ${this.matmulMaxBatchSize}; textureCacheMode: ${this.textureCacheMode}; pack: ${this.pack}; async: ${this.async}.`),!0}catch(e){return qe.warning("WebGLBackend",`Unable to initialize WebGLBackend. ${e}`),!1}}createSessionHandler(e){return new zi(this,e)}dispose(){this.glContext.dispose()}}});async function Cs(r){if(r){let e=typeof r=="string"?[r]:r;for(let n of e){let t=fh.get(n);if(t)return t;let o=await hx(n);if(o)return o}}else return Cs(["webgl"]);throw new Error("no available backend to use")}async function hx(r){let e=px;if(typeof e[r]<"u"&&mx(e[r])){let n=e[r],t=n.initialize();if(typeof t=="object"&&"then"in t&&(t=await t),t)return fh.set(r,n),n}}function mx(r){let e=r;return"initialize"in e&&typeof e.initialize=="function"&&"createSessionHandler"in e&&typeof e.createSessionHandler=="function"&&"dispose"in e&&typeof e.dispose=="function"}var fh,px,ph=D(()=>{"use strict";ch();fh=new Map,px={webgl:new Ni}});var Ps,Li,hh=D(()=>{"use strict";Ht();Ps=class{constructor(e,n){this.op=e;this.node=n}},Li=class{constructor(e,n,t){this.graph=e;this.profiler=t;this.initialize(n)}initialize(e){this.profiler.event("session","ExecutionPlan.initialize",()=>{let n=this.graph.getNodes();if(n.length!==e.length)throw new Error("The size of nodes and OPs do not match.");this._ops=e.map((t,o)=>new Ps(t,n[o])),this.reset(),this._starter=[],this._ops.forEach((t,o)=>{let i=!0;for(let s of t.node.inputs)if(!this._values[s]&&this.graph.getInputIndices().indexOf(s)===-1){i=!1;break}i&&this._starter.push(o)})})}reset(){this._values=this.graph.getValues().map(e=>e.tensor)}async execute(e,n){return this.profiler.event("session","ExecutionPlan.execute",async()=>{this.reset();let t=e.createInferenceHandler(),o=this.graph.getInputIndices();if(n.length!==o.length)throw new Error(`number of input tensors don't match the number of inputs to the model: actual: ${n.length} expected: ${o.length}`);n.forEach((d,f)=>{let p=o[f];this._values[p]=d});let i=this._starter.slice(0),s=this.graph.getValues(),a=this.graph.getNodes(),u=0;for(;u<i.length;){let d=i[u++],f=this._ops[d],p=f.node.inputs.map($=>this._values[$]);if(p.indexOf(void 0)!==-1)throw new Error(`unresolved input detected: op: ${f.node}`);let m=p;qe.verbose("ExecPlan",`Runing op:${f.node.name} (${m.map(($,x)=>`'${f.node.inputs[x]}': ${$.type}[${$.dims.join(",")}]`).join(", ")})`);let b=await this.profiler.event("node",f.node.name,async()=>f.op.impl(t,m,f.op.context));if(b.length!==f.node.outputs.length)throw new Error("the size of output does not match model definition.");b.forEach(($,x)=>{let T=f.node.outputs[x];if(this._values[T])throw new Error(`output [${T}] already has value: op:${f.node.name}`);this._values[T]=$});let y=new Set;b.forEach(($,x)=>{let T=f.node.outputs[x];for(let A of s[T].to){let E=a[A],N=!0;for(let B of E.inputs)if(!this._values[B]){N=!1;break}N&&y.add(A)}}),i.push(...y)}let l=[];for(let d=0;d<this.graph.getOutputIndices().length;d++){let f=this.graph.getOutputIndices()[d],p=this._values[f];if(p===void 0)throw new Error(`required output [${f}] does not have value`);f===0?await p.getData():p.data,l.push(p)}return qe.verbose("ExecPlan","disposing of inferenceHandler"),t.dispose(),l})}}});var De,Jt,vo,mh=D(()=>{"use strict";io();De=Tn(In());un();We();Jt=se.experimental.fbs,vo=class r{constructor(e){if(this._attributes=new Map,e!=null){for(let n of e)n instanceof De.onnx.AttributeProto?this._attributes.set(n.name,[r.getValue(n),r.getType(n)]):n instanceof Jt.Attribute&&this._attributes.set(n.name(),[r.getValue(n),r.getType(n)]);if(this._attributes.size<e.length)throw new Error("duplicated attribute names")}}set(e,n,t){this._attributes.set(e,[t,n])}delete(e){this._attributes.delete(e)}getFloat(e,n){return this.get(e,"float",n)}getInt(e,n){return this.get(e,"int",n)}getString(e,n){return this.get(e,"string",n)}getTensor(e,n){return this.get(e,"tensor",n)}getFloats(e,n){return this.get(e,"floats",n)}getInts(e,n){return this.get(e,"ints",n)}getStrings(e,n){return this.get(e,"strings",n)}getTensors(e,n){return this.get(e,"tensors",n)}get(e,n,t){let o=this._attributes.get(e);if(o===void 0){if(t!==void 0)return t;throw new Error(`required attribute not found: ${e}`)}if(o[1]!==n)throw new Error(`type mismatch: expected ${n} but got ${o[1]}`);return o[0]}static getType(e){let n=e instanceof De.onnx.AttributeProto?e.type:e.type();switch(n){case De.onnx.AttributeProto.AttributeType.FLOAT:return"float";case De.onnx.AttributeProto.AttributeType.INT:return"int";case De.onnx.AttributeProto.AttributeType.STRING:return"string";case De.onnx.AttributeProto.AttributeType.TENSOR:return"tensor";case De.onnx.AttributeProto.AttributeType.FLOATS:return"floats";case De.onnx.AttributeProto.AttributeType.INTS:return"ints";case De.onnx.AttributeProto.AttributeType.STRINGS:return"strings";case De.onnx.AttributeProto.AttributeType.TENSORS:return"tensors";default:throw new Error(`attribute type is not supported yet: ${De.onnx.AttributeProto.AttributeType[n]}`)}}static getValue(e){let n=e instanceof De.onnx.AttributeProto?e.type:e.type();if(n===De.onnx.AttributeProto.AttributeType.GRAPH||n===De.onnx.AttributeProto.AttributeType.GRAPHS)throw new Error("graph attribute is not supported yet");let t=this.getValueNoCheck(e);if(n===De.onnx.AttributeProto.AttributeType.INT&&Vt.isLong(t))return Vt.longToNumber(t);if(n===De.onnx.AttributeProto.AttributeType.INTS){let o=t,i=new Array(o.length);for(let s=0;s<o.length;s++){let a=o[s];i[s]=Vt.longToNumber(a)}return i}if(n===De.onnx.AttributeProto.AttributeType.TENSOR)return e instanceof De.onnx.AttributeProto?yt.fromProto(t):yt.fromOrtTensor(t);if(n===De.onnx.AttributeProto.AttributeType.TENSORS){if(e instanceof De.onnx.AttributeProto)return t.map(i=>yt.fromProto(i));if(e instanceof Jt.Attribute)return t.map(i=>yt.fromOrtTensor(i))}return n===De.onnx.AttributeProto.AttributeType.STRING&&e instanceof De.onnx.AttributeProto?co(t):n===De.onnx.AttributeProto.AttributeType.STRINGS&&e instanceof De.onnx.AttributeProto?t.map(co):t}static getValueNoCheck(e){return e instanceof De.onnx.AttributeProto?this.getValueNoCheckFromOnnxFormat(e):this.getValueNoCheckFromOrtFormat(e)}static getValueNoCheckFromOnnxFormat(e){switch(e.type){case De.onnx.AttributeProto.AttributeType.FLOAT:return e.f;case De.onnx.AttributeProto.AttributeType.INT:return e.i;case De.onnx.AttributeProto.AttributeType.STRING:return e.s;case De.onnx.AttributeProto.AttributeType.TENSOR:return e.t;case De.onnx.AttributeProto.AttributeType.GRAPH:return e.g;case De.onnx.AttributeProto.AttributeType.FLOATS:return e.floats;case De.onnx.AttributeProto.AttributeType.INTS:return e.ints;case De.onnx.AttributeProto.AttributeType.STRINGS:return e.strings;case De.onnx.AttributeProto.AttributeType.TENSORS:return e.tensors;case De.onnx.AttributeProto.AttributeType.GRAPHS:return e.graphs;default:throw new Error(`unsupported attribute type: ${De.onnx.AttributeProto.AttributeType[e.type]}`)}}static getValueNoCheckFromOrtFormat(e){switch(e.type()){case Jt.AttributeType.FLOAT:return e.f();case Jt.AttributeType.INT:return e.i();case Jt.AttributeType.STRING:return e.s();case Jt.AttributeType.TENSOR:return e.t();case Jt.AttributeType.GRAPH:return e.g();case Jt.AttributeType.FLOATS:return e.floatsArray();case Jt.AttributeType.INTS:{let n=[];for(let t=0;t<e.intsLength();t++)n.push(e.ints(t));return n}case Jt.AttributeType.STRINGS:{let n=[];for(let t=0;t<e.stringsLength();t++)n.push(e.strings(t));return n}case Jt.AttributeType.TENSORS:{let n=[];for(let t=0;t<e.tensorsLength();t++)n.push(e.tensors(t));return n}default:throw new Error(`unsupported attribute type: ${Jt.AttributeType[e.type()]}`)}}}});var Ds,Mi,Bs,br,Vi,ks,gh=D(()=>{"use strict";mh();io();Ds=Tn(In());un();We();Mi=se.experimental.fbs,Bs={from:(r,e)=>new ks(r,e)},br=class{constructor(e){this._from=void 0,this._to=[],this.tensor=void 0,this.type=void 0,e&&(this.type=Ot.tensorValueTypeFromProto(e.type.tensorType))}get from(){return this._from}get to(){return this._to}},Vi=class{constructor(e,n){e instanceof Ds.onnx.NodeProto?(this.name=e.name,this.opType=e.opType,this.attributes=new vo(e.attribute)):e instanceof Mi.Node&&(this.name=n??e.name(),this.opType=e.opType(),this.attributes=new vo(Ot.tensorAttributesFromORTFormat(e))),this.inputs=[],this.outputs=[],this.executeNode=!0}},ks=class{constructor(e,n){if(!e)throw new TypeError("graph is empty");this.buildGraph(e),this.transformGraph(n),this.checkIsAcyclic()}getInputIndices(){return this._allInputIndices}getInputNames(){return this._allInputNames}getOutputIndices(){return this._allOutputIndices}getOutputNames(){return this._allOutputNames}getValues(){return this._allData}getNodes(){return this._nodes}buildGraph(e){if(e instanceof Ds.onnx.GraphProto)this.buildGraphFromOnnxFormat(e);else if(e instanceof Mi.Graph)this.buildGraphFromOrtFormat(e);else throw new TypeError("Graph type is not supported.")}buildGraphFromOnnxFormat(e){let n=new Map;this._allData=[],this._allInputIndices=[],this._allInputNames=[],this._allOutputIndices=[],this._allOutputNames=[],this._nodes=[];let t=new Map;if(!e.input)throw new Error("missing information in graph: input");let o=[];for(let i of e.input){if(n.has(i.name))throw new Error(`duplicated input name: ${i.name}`);let s=this._allData.push(new br(i))-1;n.set(i.name,s),o.push(i.name)}if(!e.initializer)throw new Error("missing information in graph: initializer");for(let i of e.initializer){let s=n.get(i.name);if(s===void 0){let a=new br;a.type={shape:{dims:Ot.tensorDimsFromProto(i.dims)},tensorType:Ot.tensorDataTypeFromProto(i.dataType)},s=this._allData.push(a)-1,n.set(i.name,s)}this._allData[s]._from=-1,this._allData[s].tensor=yt.fromProto(i)}for(let i=0;i<this._allData.length;i++)this._allData[i].tensor||(this._allInputIndices.push(i),this._allInputNames.push(o[i]));if(!e.output)throw new Error("missing information in graph: output");for(let i of e.output){if(n.has(i.name))throw new Error(`duplicated output name: ${i.name}`);let s=this._allData.push(new br(i))-1;n.set(i.name,s),this._allOutputIndices.push(s),this._allOutputNames.push(i.name)}if(!e.node)throw new Error("missing information in graph: node");for(let i of e.node){if(!i.name)for(let a=0;;a++){let u=`unnamed_${i.opType}_${a}`;if(!t.has(u)){i.name=u;break}}if(t.has(i.name))throw new Error(`duplicated node name: ${i.name}`);let s=this._nodes.push(new Vi(i))-1;t.set(i.name,s)}for(let i=0;i<this._nodes.length;i++){let s=this._nodes[i],a=e.node[i];if(!a.output)throw new Error(`missing output for node: ${a.name}`);for(let u of a.output){let l=n.get(u);if(typeof l>"u"&&(l=this._allData.push(new br)-1,n.set(u,l)),s.outputs.push(l),this._allData[l]._from!==void 0)throw new Error(`multiple nodes output to one data value: ${l}`);if(this._allData[l]._from=i,a.opType==="Constant"){if(!a.attribute||a.attribute.length!==1||!a.attribute[0].t)throw new Error("missing attributes or missing tensor value in attributes for this Constant operator");if(!a.output||a.output.length!==1)throw new Error("missing output or incorrect number of outputs for this Constant operator");s.outputs.pop(),s.executeNode=!1,this._allData[l]._from=-1,this._allData[l].tensor=yt.fromProto(a.attribute[0].t)}}}for(let i=0;i<this._nodes.length;i++){let s=this._nodes[i],a=e.node[i];if(!a.input)throw new Error(`missing input for node: ${a.name}`);for(let u of a.input){let l=n.get(u);if(typeof l>"u"){if(u===""&&(a.input.length===3||a.input.length===4)&&a.opType==="Resize")continue;throw new Error(`unrecognized input '${u}' for node: ${a.name}`)}s.inputs.push(l),this._allData[l]._to.push(i)}}return!0}buildGraphFromOrtFormat(e){let n=new Map;this._allData=[],this._allInputIndices=[],this._allInputNames=[],this._allOutputIndices=[],this._allOutputNames=[],this._nodes=[];let t=new Map,o=[];for(let i=0;i<e.inputsLength();i++){let s=e.inputs(i);if(n.has(s))throw new Error(`duplicated input name: ${s}`);for(let a=0;a<e.nodeArgsLength();a++)if(e.nodeArgs(a)?.name()===s){let u=new br;if(e.nodeArgs(a)?.type()?.valueType()!==Mi.TypeInfoValue.tensor_type)throw new Error("Unexpected value type for the nodeArg.");let d=e.nodeArgs(a).type().value(new Mi.TensorTypeAndShape),f=Ot.tensorDataTypeFromProto(d.elemType()),p=d.shape(),m=[];for(let y=0;y<p.dimLength();y++)m.push(Vt.longToNumber(p.dim(y).value().dimValue()));u.type={shape:{dims:m},tensorType:f};let b=this._allData.push(u)-1;n.set(s,b),o.push(s)}}for(let i=0;i<e.initializersLength();i++){let s=e.initializers(i),a=n.get(s.name());if(a===void 0){let u=new br,l=Ot.tensorDimsFromORTFormat(s),d=Ot.tensorDataTypeFromProto(s.dataType());u.type={shape:{dims:l},tensorType:d},a=this._allData.push(u)-1,n.set(s.name(),a)}this._allData[a]._from=-1,this._allData[a].tensor=yt.fromOrtTensor(s)}for(let i=0;i<this._allData.length;i++)this._allData[i].tensor||(this._allInputIndices.push(i),this._allInputNames.push(o[i]));for(let i=0;i<e.outputsLength();i++){let s=e.outputs(i);if(n.has(s))throw new Error(`duplicated output name: ${s}`);let a=this._allData.push(new br)-1;n.set(s,a),this._allOutputIndices.push(a),this._allOutputNames.push(s)}if(!e.nodes)throw new Error("missing information in graph: node");for(let i=0;i<e.nodesLength();i++){let s=e.nodes(i),a=s.name();if(!a)for(let l=0;a=`unnamed_${s.opType()}_${l}`,!!t.has(a);l++);if(t.has(a))throw new Error(`duplicated node name: ${a}`);let u=this._nodes.push(new Vi(s,a))-1;t.set(a,u)}for(let i=0;i<this._nodes.length;i++){let s=this._nodes[i],a=e.nodes(i);if(a==null)throw new Error(`No node exists at index ${i}`);if(a?.outputsLength()===0)throw new Error(`missing output for node: ${a.name}`);for(let u=0;u<a?.outputsLength();u++){let l=a?.outputs(u),d=n.get(l);if(typeof d>"u"&&(d=this._allData.push(new br)-1,n.set(l,d)),s.outputs.push(d),this._allData[d]._from!==void 0)throw new Error(`multiple nodes output to one data value: ${d}`);if(this._allData[d]._from=i,a.opType()==="Constant"){if(a.attributesLength()!==1||!a.attributes(0).t())throw new Error("missing attributes or missing tensor value in attributes for this Constant operator");if(a.outputsLength()!==1)throw new Error("missing output or incorrect number of outputs for this Constant operator");s.outputs.pop(),s.executeNode=!1,this._allData[d]._from=-1,this._allData[d].tensor=yt.fromOrtTensor(a.attributes(0).t())}}}for(let i=0;i<this._nodes.length;i++){let s=this._nodes[i],a=e.nodes(i);if(a.inputsLength()===0)throw new Error(`missing input for node: ${a.name}`);for(let u=0;u<a.inputsLength();u++){let l=a.inputs(u),d=n.get(l);if(typeof d>"u")throw new Error(`unrecognized input '${l}' for node: ${a.name()}`);s.inputs.push(d),this._allData[d]._to.push(i)}}}checkIsAcyclic(){let e=new Set;this._allInputIndices.forEach(o=>{this._allData[o]._to.forEach(s=>{e.add(s)})});let n=Array.from(e),t=new Array(this._nodes.length).fill("white");for(;n.length>0;){let o=n.pop();t[o]==="gray"?t[o]="black":(n.push(o),t[o]="gray",this._nodes[o].outputs.forEach(i=>{let s=this._allData[i];if(typeof s.tensor<"u")throw new Error("node outputs should not be initialized");if(s._from!==o)throw new Error("from property of the Value object doesn't match index of Node being processed");s._to.forEach(a=>{if(t[a]==="gray")throw new Error("model graph is cyclic");t[a]==="white"&&n.push(a)})}))}}transformGraph(e){this.removeAllIdentityNodes(),this.removeAllDropoutNodes(),this.fuseConvActivationNodes(),e&&e.transformGraph(this),this.finalizeGraph()}finalizeGraph(){let e=0,n=new Array(this._nodes.length,0),t=0;for(let o=0;o<this._nodes.length;o++)n[o]=t,this._nodes[o].executeNode?(t!==o&&(this._nodes[t]=this._nodes[o]),t++):this._nodes[o].outputs.forEach(i=>{this._allData[i]._from=-2});this._nodes.splice(t,this._nodes.length-t);for(let o=0;o<this._allData.length;o++){let i=this._allData[o];i._from!==void 0&&i._from!==-1&&i._from!==-2&&(i._from=n[i._from]);for(let s=0;s<i._to.length;s++)if(i._to[s]>=0)i._to[s]=n[i._to[s]];else throw new Error("Trying to update a removed node")}e=0;for(let o=0;o<this._allData.length;o++){if(this._allData[o].from===-2&&this._allOutputIndices.indexOf(o+e)===-1){e++,this._allData.splice(o,1),o--;continue}if(e>0){let i=-1;this._allData[o].from!==void 0&&this._allData[o].from!==-1?(i=this._nodes[this._allData[o].from].outputs.indexOf(o+e),i!==-1&&(this._nodes[this._allData[o].from].outputs[i]=o)):(i=this._allInputIndices.indexOf(o+e),i!==-1&&(this._allInputIndices[i]=o)),this._allData[o].to.forEach(s=>{i=this._nodes[s].inputs.indexOf(o+e),i!==-1&&(this._nodes[s].inputs[i]=o)}),this._allData[o].to.length===0&&(i=this._allOutputIndices.indexOf(o+e),i!==-1&&(this._allOutputIndices[i]=o))}}}deleteNode(e){let n=this._nodes[e];if(n.outputs.length>1){for(let a=1;a<n.outputs.length;a++)if(this._allData[n.outputs[a]].to.length>0)throw new Error("Node deletion with more than one output connected to other nodes is not supported. ")}n.executeNode=!1;let t=n.inputs[0],o=n.outputs[0],i=this._allData[o].to;for(let a=0;a<n.inputs.length;a++){let u=this._allData[n.inputs[a]].to.indexOf(e);if(u===-1)throw new Error("The Value object doesn't have the current Node in it's 'to' property ");this._allData[n.inputs[a]].to.splice(u,1)}this._allData[o]._to=[];let s=this._allOutputIndices.indexOf(o);if(s!==-1&&(this._allOutputIndices[s]=t),i&&i.length>0)for(let a of i){let u=this._nodes[a].inputs.indexOf(o);if(u===-1)throw new Error("The Node object doesn't have the output Value in it's 'inputs' property ");this._nodes[a].inputs[u]=t,this._allData[t].to.push(a)}}removeAllDropoutNodes(){let e=0;for(let n of this._nodes){if(n.opType==="Dropout"){if(n.inputs.length!==1)throw new Error("Dropout nodes should only contain one input. ");if(n.outputs.length!==1&&n.outputs.length!==2)throw new Error("Dropout nodes should contain either 1 or 2 output(s)");if(n.outputs.length===2&&this._allData[n.outputs[1]]._to.length!==0)throw new Error("Dropout nodes's second output should not be referenced by other nodes");this.deleteNode(e)}e++}}removeAllIdentityNodes(){let e=0;for(let n of this._nodes)n.opType==="Identity"&&this.deleteNode(e),e++}isActivation(e){switch(e.opType){case"Relu":case"Sigmoid":case"Clip":return!0;default:return!1}}fuseConvActivationNodes(){for(let e of this._nodes)if(e.opType==="Conv"){let n=this._allData[e.outputs[0]]._to;if(n.length===1&&this.isActivation(this._nodes[n[0]])){let t=this._nodes[n[0]];if(t.opType==="Clip")if(t.inputs.length===1)try{e.attributes.set("activation_params","floats",[t.attributes.getFloat("min"),t.attributes.getFloat("max")])}catch{e.attributes.set("activation_params","floats",[an,sn])}else if(t.inputs.length>=3&&this._allData[t.inputs[1]].tensor!==void 0&&this._allData[t.inputs[2]].tensor!==void 0)e.attributes.set("activation_params","floats",[this._allData[t.inputs[1]].tensor.floatData[0],this._allData[t.inputs[2]].tensor.floatData[0]]);else continue;e.attributes.set("activation","string",t.opType),this.deleteNode(n[0])}}}}});var bh,gx,Fi,yh=D(()=>{"use strict";si();gh();io();bh=Tn(In());We();gx=se.experimental.fbs,Fi=class{constructor(){}load(e,n,t){if(!t)try{this.loadFromOnnxFormat(e,n);return}catch(o){if(t!==void 0)throw o}this.loadFromOrtFormat(e,n)}loadFromOnnxFormat(e,n){let t=bh.onnx.ModelProto.decode(e);if(Vt.longToNumber(t.irVersion)<3)throw new Error("only support ONNX model with IR_VERSION>=3");this._opsets=t.opsetImport.map(i=>({domain:i.domain,version:Vt.longToNumber(i.version)})),this._graph=Bs.from(t.graph,n)}loadFromOrtFormat(e,n){let t=new k.ByteBuffer(e),o=gx.InferenceSession.getRootAsInferenceSession(t).model();if(Vt.longToNumber(o.irVersion())<3)throw new Error("only support ONNX model with IR_VERSION>=3");this._opsets=[];for(let s=0;s<o.opsetImportLength();s++){let a=o.opsetImport(s);this._opsets.push({domain:a?.domain(),version:Vt.longToNumber(a.version())})}this._graph=Bs.from(o.graph(),n)}get graph(){return this._graph}get opsets(){return this._opsets}}});var Ui,vh=D(()=>{"use strict";ph();hh();Ht();yh();Ui=class{constructor(e={}){this._initialized=!1,this.backendHint=e.backendHint,this.profiler=ii.create(e.profiler),this.context={profiler:this.profiler,graphInputTypes:[],graphInputDims:[]}}get inputNames(){return this._model.graph.getInputNames()}get outputNames(){return this._model.graph.getOutputNames()}startProfiling(){this.profiler.start()}endProfiling(){this.profiler.stop()}async loadModel(e,n,t){await this.profiler.event("session","Session.loadModel",async()=>{let o=await Cs(this.backendHint);if(this.sessionHandler=o.createSessionHandler(this.context),this._model=new Fi,typeof e=="string"){let i=e.endsWith(".ort");if(typeof process<"u"&&process.versions&&process.versions.node){let s=await(void 0)(e);this.initialize(s,i)}else{let a=await(await fetch(e)).arrayBuffer();this.initialize(new Uint8Array(a),i)}}else if(ArrayBuffer.isView(e))this.initialize(e);else{let i=new Uint8Array(e,n||0,t||e.byteLength);this.initialize(i)}})}initialize(e,n){if(this._initialized)throw new Error("already initialized");this.profiler.event("session","Session.initialize",()=>{let t=this.sessionHandler.transformGraph?this.sessionHandler:void 0;this._model.load(e,t,n),this.sessionHandler.onGraphInitialized&&this.sessionHandler.onGraphInitialized(this._model.graph),this.initializeOps(this._model.graph),this._executionPlan=new Li(this._model.graph,this._ops,this.profiler)}),this._initialized=!0}async run(e){if(!this._initialized)throw new Error("session not initialized yet");return this.profiler.event("session","Session.run",async()=>{let n=this.normalizeAndValidateInputs(e),t=await this._executionPlan.execute(this.sessionHandler,n);return this.createOutput(t)})}normalizeAndValidateInputs(e){let n=this._model.graph.getInputNames();if(Array.isArray(e)){if(e.length!==n.length)throw new Error(`incorrect input array length: expected ${n.length} but got ${e.length}`)}else{if(e.size!==n.length)throw new Error(`incorrect input map size: expected ${n.length} but got ${e.size}`);let t=new Array(e.size),o=0;for(let i=0;i<n.length;++i){let s=e.get(n[i]);if(!s)throw new Error(`missing input tensor for: '${name}'`);t[o++]=s}e=t}if(!this.context.graphInputTypes||this.context.graphInputTypes.length===0||!this.context.graphInputDims||this.context.graphInputDims.length===0){let t=this._model.graph.getInputIndices(),o=this._model.graph.getValues(),i=new Array(t.length);for(let s=0;s<t.length;++s){let a=o[t[s]];i[s]=a.type.shape.dims,this.context.graphInputTypes.push(a.type.tensorType),this.context.graphInputDims.push(e[s].dims)}this.validateInputTensorDims(i,e,!0)}else this.validateInputTensorDims(this.context.graphInputDims,e,!1);return this.validateInputTensorTypes(this.context.graphInputTypes,e),e}validateInputTensorTypes(e,n){for(let t=0;t<n.length;t++){let o=e[t],i=n[t].type;if(o!==i)throw new Error(`input tensor[${t}] check failed: expected type '${o}' but got ${i}`)}}validateInputTensorDims(e,n,t){for(let o=0;o<n.length;o++){let i=e[o],s=n[o].dims;if(!this.compareTensorDims(i,s,t))throw new Error(`input tensor[${o}] check failed: expected shape '[${i.join(",")}]' but got [${s.join(",")}]`)}}compareTensorDims(e,n,t){if(e.length!==n.length)return!1;for(let o=0;o<e.length;++o)if(e[o]!==n[o]&&(!t||e[o]!==0))return!1;return!0}createOutput(e){let n=this._model.graph.getOutputNames();if(e.length!==n.length)throw new Error("expected number of outputs do not match number of generated outputs");let t=new Map;for(let o=0;o<n.length;++o)t.set(n[o],e[o]);return t}initializeOps(e){let n=e.getNodes();this._ops=new Array(n.length);for(let t=0;t<n.length;t++)this._ops[t]=this.sessionHandler.resolve(n[t],this._model.opsets,e)}}});var Gi,wh=D(()=>{"use strict";Et();un();Gi=class{constructor(e){this.session=e;this.inputNames=this.session.inputNames,this.outputNames=this.session.outputNames}async dispose(){}async run(e,n,t){let o=new Map;for(let a in e)if(Object.hasOwnProperty.call(e,a)){let u=e[a];o.set(a,new yt(u.dims,u.type,void 0,void 0,u.data))}let i=await this.session.run(o),s={};return i.forEach((a,u)=>{s[u]=new xt(a.type,a.data,a.dims)}),s}startProfiling(){this.session.startProfiling()}endProfiling(){this.session.endProfiling()}}});var xh={};Mr(xh,{onnxjsBackend:()=>yx});var Rs,yx,Th=D(()=>{"use strict";vh();wh();Rs=class{async init(){}async createInferenceSessionHandler(e,n){let t=new Ui(n);return typeof e=="string"?await t.loadModel(e):await t.loadModel(e),new Gi(t)}},yx=new Rs});var zs={};Mr(zs,{createReadStream:()=>_h,readFile:()=>vx,readFileSync:()=>wx});var vx,wx,_h,Ns=D(()=>{vx=void 0,wx=void 0,_h=void 0});var Ls={};Mr(Ls,{join:()=>xx});var xx,Ms=D(()=>{xx=void 0});var Ih=Je((Sh,Vs)=>{"use strict";var $h=(()=>{var r=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(r=r||__filename),function(e={}){var n=e,t,o;n.ready=new Promise((h,v)=>{t=h,o=v}),n.mountExternalData=(h,v)=>{(n.Fa||(n.Fa=new Map)).set(h,v)},n.unmountExternalData=()=>{delete n.Fa},n.jsepInit=(h,v,S,C,M,j,ee,xe)=>{n.ab=h,n.Qa=v,n.Sa=S,n.La=C,n.Ra=M,n.sa=j,n.Ta=ee,n.Ua=xe,v=(ue,fe,ye)=>(...ke)=>{let Fe=Wt,z=fe?.();ke=ue(...ke);let ve=fe?.();return z!==ve&&(ue=ve,ye(z),fe=ye=null),Wt!=Fe?Ro():ke},S=ue=>async(...fe)=>{try{if(n.Ea)throw Error("Session already started");let ye=n.Ea={Va:fe[0],errors:[]},ke=await ue(...fe);if(n.Ea!==ye)throw Error("Session mismatch");h.flush();let Fe=ye.errors;if(0<Fe.length){let z=await Promise.all(Fe);if(z=z.filter(ve=>ve),0<z.length)throw Error(z.join(`
`))}return ke}finally{n.Ea=null}},n._OrtRun=S(v(n._OrtRun,()=>n._OrtRun,ue=>n._OrtRun=ue)),n._OrtRunWithBinding=S(v(n._OrtRunWithBinding,()=>n._OrtRunWithBinding,ue=>n._OrtRunWithBinding=ue)),n._OrtBindInput=v(n._OrtBindInput,()=>n._OrtBindInput,ue=>n._OrtBindInput=ue),n.jsepRegisterBuffer=(ue,fe,ye,ke)=>h.registerBuffer(ue,fe,ye,ke),n.jsepUnregisterBuffers=ue=>{h.unregisterBuffers(ue)},n.jsepGetBuffer=ue=>h.getBuffer(ue),n.jsepCreateDownloader=(ue,fe,ye)=>h.createDownloader(ue,fe,ye)};var i=Object.assign({},n),s="./this.program",a=(h,v)=>{throw v},u=typeof window=="object",l=typeof importScripts=="function",d=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",f="",p,m,b;if(d){var y=(Ns(),Or(zs)),$=(Ms(),Or(Ls));f=l?$.dirname(f)+"/":__dirname+"/",p=(h,v)=>(h=ft(h)?new URL(h):$.normalize(h),y.readFileSync(h,v?void 0:"utf8")),b=h=>(h=p(h,!0),h.buffer||(h=new Uint8Array(h)),h),m=(h,v,S,C=!0)=>{h=ft(h)?new URL(h):$.normalize(h),y.readFile(h,C?void 0:"utf8",(M,j)=>{M?S(M):v(C?j.buffer:j)})},!n.thisProgram&&1<process.argv.length&&(s=process.argv[1].replace(/\\/g,"/")),process.argv.slice(2),a=(h,v)=>{throw process.exitCode=h,v},n.inspect=()=>"[Emscripten Module object]"}else(u||l)&&(l?f=self.location.href:typeof document<"u"&&document.currentScript&&(f=document.currentScript.src),r&&(f=r),f.indexOf("blob:")!==0?f=f.substr(0,f.replace(/[?#].*/,"").lastIndexOf("/")+1):f="",p=h=>{var v=new XMLHttpRequest;return v.open("GET",h,!1),v.send(null),v.responseText},l&&(b=h=>{var v=new XMLHttpRequest;return v.open("GET",h,!1),v.responseType="arraybuffer",v.send(null),new Uint8Array(v.response)}),m=(h,v,S)=>{var C=new XMLHttpRequest;C.open("GET",h,!0),C.responseType="arraybuffer",C.onload=()=>{C.status==200||C.status==0&&C.response?v(C.response):S()},C.onerror=S,C.send(null)});var x=console.log.bind(console),T=console.error.bind(console);Object.assign(n,i),i=null,typeof WebAssembly!="object"&&Ie("no native wasm support detected");var A,E=!1,N,B,F,P,W,oe,H;function re(){var h=A.buffer;n.HEAP8=B=new Int8Array(h),n.HEAP16=new Int16Array(h),n.HEAPU8=F=new Uint8Array(h),n.HEAPU16=new Uint16Array(h),n.HEAP32=P=new Int32Array(h),n.HEAPU32=W=new Uint32Array(h),n.HEAPF32=oe=new Float32Array(h),n.HEAPF64=H=new Float64Array(h)}var ie=[],ne=[],Ye=[],Ze=0,Se=null,He=null;function Ie(h){throw h="Aborted("+h+")",T(h),E=!0,N=1,h=new WebAssembly.RuntimeError(h+". Build with -sASSERTIONS for more info."),o(h),h}var Ce=h=>h.startsWith("data:application/octet-stream;base64,"),ft=h=>h.startsWith("file://"),at;if(at="ort-wasm-simd.wasm",!Ce(at)){var bt=at;at=n.locateFile?n.locateFile(bt,f):f+bt}function Y(h){if(b)return b(h);throw"both async and sync fetching of the wasm failed"}function de(h){if(u||l){if(typeof fetch=="function"&&!ft(h))return fetch(h,{credentials:"same-origin"}).then(v=>{if(!v.ok)throw"failed to load wasm binary file at '"+h+"'";return v.arrayBuffer()}).catch(()=>Y(h));if(m)return new Promise((v,S)=>{m(h,C=>v(new Uint8Array(C)),S)})}return Promise.resolve().then(()=>Y(h))}function Pe(h,v,S){return de(h).then(C=>WebAssembly.instantiate(C,v)).then(C=>C).then(S,C=>{T(`failed to asynchronously prepare wasm: ${C}`),Ie(C)})}function Gt(h,v){var S=at;return typeof WebAssembly.instantiateStreaming!="function"||Ce(S)||ft(S)||d||typeof fetch!="function"?Pe(S,h,v):fetch(S,{credentials:"same-origin"}).then(C=>WebAssembly.instantiateStreaming(C,h).then(v,function(M){return T(`wasm streaming compile failed: ${M}`),T("falling back to ArrayBuffer instantiation"),Pe(S,h,v)}))}var lt,dt={931056:(h,v,S,C)=>{if(typeof n>"u"||!n.Fa)return 1;if(h=_t(h>>>0),h.startsWith("./")&&(h=h.substring(2)),h=n.Fa.get(h),!h)return 2;if(v>>>=0,S>>>=0,v+S>h.byteLength)return 3;try{return F.set(h.subarray(v,v+S),C>>>0>>>0),0}catch{return 4}},931557:h=>n.Qa(h),931590:h=>n.Sa(h),931622:(h,v,S)=>{n.La(h,v,S,!0)},931661:(h,v,S)=>{n.La(h,v,S)},931694:h=>{n.sa("Abs",h,void 0)},931745:h=>{n.sa("Neg",h,void 0)},931796:h=>{n.sa("Floor",h,void 0)},931849:h=>{n.sa("Ceil",h,void 0)},931901:h=>{n.sa("Reciprocal",h,void 0)},931959:h=>{n.sa("Sqrt",h,void 0)},932011:h=>{n.sa("Exp",h,void 0)},932062:h=>{n.sa("Erf",h,void 0)},932113:h=>{n.sa("Sigmoid",h,void 0)},932168:h=>{n.sa("Log",h,void 0)},932219:h=>{n.sa("Sin",h,void 0)},932270:h=>{n.sa("Cos",h,void 0)},932321:h=>{n.sa("Tan",h,void 0)},932372:h=>{n.sa("Asin",h,void 0)},932424:h=>{n.sa("Acos",h,void 0)},932476:h=>{n.sa("Atan",h,void 0)},932528:h=>{n.sa("Sinh",h,void 0)},932580:h=>{n.sa("Cosh",h,void 0)},932632:h=>{n.sa("Asinh",h,void 0)},932685:h=>{n.sa("Acosh",h,void 0)},932738:h=>{n.sa("Atanh",h,void 0)},932791:h=>{n.sa("Tanh",h,void 0)},932843:h=>{n.sa("Not",h,void 0)},932894:(h,v,S)=>{n.sa("Clip",h,{min:v,max:S})},932963:h=>{n.sa("Clip",h,void 0)},933015:(h,v)=>{n.sa("Elu",h,{alpha:v})},933073:h=>{n.sa("Relu",h,void 0)},933125:(h,v)=>{n.sa("LeakyRelu",h,{alpha:v})},933189:(h,v)=>{n.sa("ThresholdedRelu",h,{alpha:v})},933259:(h,v)=>{n.sa("Cast",h,{to:v})},933317:h=>{n.sa("Add",h,void 0)},933368:h=>{n.sa("Sub",h,void 0)},933419:h=>{n.sa("Mul",h,void 0)},933470:h=>{n.sa("Div",h,void 0)},933521:h=>{n.sa("Pow",h,void 0)},933572:h=>{n.sa("Equal",h,void 0)},933625:h=>{n.sa("Greater",h,void 0)},933680:h=>{n.sa("GreaterOrEqual",h,void 0)},933742:h=>{n.sa("Less",h,void 0)},933794:h=>{n.sa("LessOrEqual",h,void 0)},933853:(h,v,S,C,M)=>{n.sa("ReduceMean",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934012:(h,v,S,C,M)=>{n.sa("ReduceMax",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934170:(h,v,S,C,M)=>{n.sa("ReduceMin",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934328:(h,v,S,C,M)=>{n.sa("ReduceProd",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934487:(h,v,S,C,M)=>{n.sa("ReduceSum",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934645:(h,v,S,C,M)=>{n.sa("ReduceL1",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934802:(h,v,S,C,M)=>{n.sa("ReduceL2",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},934959:(h,v,S,C,M)=>{n.sa("ReduceLogSum",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},935120:(h,v,S,C,M)=>{n.sa("ReduceSumSquare",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},935284:(h,v,S,C,M)=>{n.sa("ReduceLogSumExp",h,{keepDims:!!v,noopWithEmptyAxes:!!S,axes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},935448:h=>{n.sa("Where",h,void 0)},935501:(h,v,S)=>{n.sa("Transpose",h,{perm:v?Array.from(P.subarray(v>>>0,S>>>0)):[]})},935609:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve)=>{n.sa("ConvTranspose",h,{format:ue?"NHWC":"NCHW",autoPad:v,dilations:[S],group:C,kernel_shape:[M],pads:[j,ee],strides:[xe],wIsConst:()=>!!B[fe>>>0],outputPadding:ye?Array.from(P.subarray(ye>>>0,ke>>>0)):[],outputShape:Fe?Array.from(P.subarray(Fe>>>0,z>>>0)):[],activation:_t(ve)})},936011:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z)=>{n.sa("ConvTranspose",h,{format:xe?"NHWC":"NCHW",autoPad:v,dilations:Array.from(P.subarray(S>>>0,(S>>>0)+2>>>0)),group:C,kernelShape:Array.from(P.subarray(M>>>0,(M>>>0)+2>>>0)),pads:Array.from(P.subarray(j>>>0,(j>>>0)+4>>>0)),strides:Array.from(P.subarray(ee>>>0,(ee>>>0)+2>>>0)),wIsConst:()=>!!B[ue>>>0],outputPadding:fe?Array.from(P.subarray(fe>>>0,ye>>>0)):[],outputShape:ke?Array.from(P.subarray(ke>>>0,Fe>>>0)):[],activation:_t(z)})},936576:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve)=>{n.sa("ConvTranspose",h,{format:ue?"NHWC":"NCHW",autoPad:v,dilations:[S],group:C,kernel_shape:[M],pads:[j,ee],strides:[xe],wIsConst:()=>!!B[fe>>>0],outputPadding:ye?Array.from(P.subarray(ye>>>0,ke>>>0)):[],outputShape:Fe?Array.from(P.subarray(Fe>>>0,z>>>0)):[],activation:_t(ve)})},936978:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z)=>{n.sa("ConvTranspose",h,{format:xe?"NHWC":"NCHW",autoPad:v,dilations:Array.from(P.subarray(S>>>0,(S>>>0)+2>>>0)),group:C,kernelShape:Array.from(P.subarray(M>>>0,(M>>>0)+2>>>0)),pads:Array.from(P.subarray(j>>>0,(j>>>0)+4>>>0)),strides:Array.from(P.subarray(ee>>>0,(ee>>>0)+2>>>0)),wIsConst:()=>!!B[ue>>>0],outputPadding:fe?Array.from(P.subarray(fe>>>0,ye>>>0)):[],outputShape:ke?Array.from(P.subarray(ke>>>0,Fe>>>0)):[],activation:_t(z)})},937543:(h,v)=>{n.sa("GlobalAveragePool",h,{format:v?"NHWC":"NCHW"})},937634:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve,ze)=>{n.sa("AveragePool",h,{format:ze?"NHWC":"NCHW",auto_pad:v,ceil_mode:S,count_include_pad:C,storage_order:M,dilations:[j,ee],kernel_shape:[xe,ue],pads:[fe,ye,ke,Fe],strides:[z,ve]})},937918:(h,v)=>{n.sa("GlobalAveragePool",h,{format:v?"NHWC":"NCHW"})},938009:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve,ze)=>{n.sa("AveragePool",h,{format:ze?"NHWC":"NCHW",auto_pad:v,ceil_mode:S,count_include_pad:C,storage_order:M,dilations:[j,ee],kernel_shape:[xe,ue],pads:[fe,ye,ke,Fe],strides:[z,ve]})},938293:(h,v)=>{n.sa("GlobalMaxPool",h,{format:v?"NHWC":"NCHW"})},938380:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve,ze)=>{n.sa("MaxPool",h,{format:ze?"NHWC":"NCHW",auto_pad:v,ceil_mode:S,count_include_pad:C,storage_order:M,dilations:[j,ee],kernel_shape:[xe,ue],pads:[fe,ye,ke,Fe],strides:[z,ve]})},938660:(h,v)=>{n.sa("GlobalMaxPool",h,{format:v?"NHWC":"NCHW"})},938747:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve,ze)=>{n.sa("MaxPool",h,{format:ze?"NHWC":"NCHW",auto_pad:v,ceil_mode:S,count_include_pad:C,storage_order:M,dilations:[j,ee],kernel_shape:[xe,ue],pads:[fe,ye,ke,Fe],strides:[z,ve]})},939027:(h,v,S,C,M)=>{n.sa("Gemm",h,{alpha:v,beta:S,transA:C,transB:M})},939131:h=>{n.sa("MatMul",h,void 0)},939185:(h,v,S,C)=>{n.sa("ArgMax",h,{keepDims:!!v,selectLastIndex:!!S,axis:C})},939293:(h,v,S,C)=>{n.sa("ArgMin",h,{keepDims:!!v,selectLastIndex:!!S,axis:C})},939401:(h,v)=>{n.sa("Softmax",h,{axis:v})},939464:(h,v)=>{n.sa("Concat",h,{axis:v})},939524:(h,v,S,C,M)=>{n.sa("Split",h,{axis:v,numOutputs:S,splitSizes:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},939664:h=>{n.sa("Expand",h,void 0)},939718:(h,v)=>{n.sa("Gather",h,{axis:Number(v)})},939789:(h,v)=>{n.sa("GatherElements",h,{axis:Number(v)})},939868:(h,v,S,C,M,j,ee,xe,ue,fe,ye)=>{n.sa("Resize",h,{antialias:v,axes:S?Array.from(P.subarray(S>>>0,C>>>0)):[],coordinateTransformMode:_t(M),cubicCoeffA:j,excludeOutside:ee,extrapolationValue:xe,keepAspectRatioPolicy:_t(ue),mode:_t(fe),nearestMode:_t(ye)})},940214:(h,v,S,C,M,j,ee)=>{n.sa("Slice",h,{starts:v?Array.from(P.subarray(v>>>0,S>>>0)):[],ends:C?Array.from(P.subarray(C>>>0,M>>>0)):[],axes:j?Array.from(P.subarray(j>>>0,ee>>>0)):[]})},940430:h=>{n.sa("Tile",h,void 0)},940482:(h,v,S)=>{n.sa("LayerNormalization",h,{axis:Number(v),epsilon:Number(S)})},940589:(h,v,S)=>{n.sa("InstanceNormalization",h,{epsilon:v,format:S?"NHWC":"NCHW"})},940703:(h,v,S)=>{n.sa("InstanceNormalization",h,{epsilon:v,format:S?"NHWC":"NCHW"})},940817:h=>{n.sa("Range",h,void 0)},940870:(h,v)=>{n.sa("Einsum",h,{equation:_t(v)})},940951:(h,v,S,C,M)=>{n.sa("Pad",h,{mode:v,value:S,pads:C?Array.from(P.subarray(C>>>0,M>>>0)):[]})},941078:(h,v,S,C,M,j)=>{n.sa("BatchNormalization",h,{epsilon:v,momentum:S,spatial:!!M,trainingMode:!!C,format:j?"NHWC":"NCHW"})},941247:(h,v,S,C,M,j)=>{n.sa("BatchNormalization",h,{epsilon:v,momentum:S,spatial:!!M,trainingMode:!!C,format:j?"NHWC":"NCHW"})},941416:(h,v,S)=>{n.sa("CumSum",h,{exclusive:Number(v),reverse:Number(S)})},941513:(h,v,S,C,M,j,ee,xe,ue)=>{n.sa("Attention",h,{numHeads:v,isUnidirectional:S,maskFilterValue:C,scale:M,doRotary:j,qkvHiddenSizes:ee?Array.from(P.subarray(Number(xe)>>>0,Number(xe)+ee>>>0)):[],pastPresentShareBuffer:!!ue})},941785:h=>{n.sa("Gelu",h,void 0)},941837:(h,v,S,C,M,j)=>{n.sa("MultiHeadAttention",h,{numHeads:v,isUnidirectional:S,maskFilterValue:C,scale:M,doRotary:j})},941996:h=>{n.sa("BiasAdd",h,void 0)},942051:h=>{n.sa("BiasSplitGelu",h,void 0)},942112:(h,v)=>{n.sa("SkipLayerNormalization",h,{epsilon:v})},942193:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe)=>{n.sa("Conv",h,{format:ue?"NHWC":"NCHW",auto_pad:v,dilations:[S],group:C,kernel_shape:[M],pads:j?Array.from(P.subarray(j>>>0,ee>>>0)):[],strides:[xe],w_is_const:()=>!!B[fe>>>0],activation:_t(ye),activation_params:ke?Array.from(oe.subarray(ke>>>0,Fe>>>0)):[]})},942563:(h,v,S,C,M,j,ee,xe,ue,fe,ye,ke,Fe,z,ve,ze)=>{n.sa("Conv",h,{format:ke?"NHWC":"NCHW",auto_pad:v,dilations:[S,C],group:M,kernel_shape:[j,ee],pads:xe?Array.from(P.subarray(xe>>>0,ue>>>0)):[],strides:[fe,ye],w_is_const:()=>!!B[Fe>>>0],activation:_t(z),activation_params:ve?Array.from(oe.subarray(ve>>>0,ze>>>0)):[]})},942954:h=>{n.Ta(h)},942988:(h,v)=>n.Ua(h,v,n.Ea.Va,n.Ea.errors)};function st(h){this.name="ExitStatus",this.message=`Program terminated with exit(${h})`,this.status=h}function Dr(h){this.Ja=h-24,this.Oa=function(v){W[this.Ja+4>>>2>>>0]=v},this.Na=function(v){W[this.Ja+8>>>2>>>0]=v},this.$a=function(v,S){this.Ma(),this.Oa(v),this.Na(S)},this.Ma=function(){W[this.Ja+16>>>2>>>0]=0}}var er=0,mn=0,Kr=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,Br=(h,v,S)=>{v>>>=0;var C=v+S;for(S=v;h[S]&&!(S>=C);)++S;if(16<S-v&&h.buffer&&Kr)return Kr.decode(h.subarray(v,S));for(C="";v<S;){var M=h[v++];if(M&128){var j=h[v++]&63;if((M&224)==192)C+=String.fromCharCode((M&31)<<6|j);else{var ee=h[v++]&63;M=(M&240)==224?(M&15)<<12|j<<6|ee:(M&7)<<18|j<<12|ee<<6|h[v++]&63,65536>M?C+=String.fromCharCode(M):(M-=65536,C+=String.fromCharCode(55296|M>>10,56320|M&1023))}}else C+=String.fromCharCode(M)}return C},_t=(h,v)=>(h>>>=0)?Br(F,h,v):"",Vn=h=>{for(var v=0,S=0;S<h.length;++S){var C=h.charCodeAt(S);127>=C?v++:2047>=C?v+=2:55296<=C&&57343>=C?(v+=4,++S):v+=3}return v},gn=(h,v,S,C)=>{if(S>>>=0,!(0<C))return 0;var M=S;C=S+C-1;for(var j=0;j<h.length;++j){var ee=h.charCodeAt(j);if(55296<=ee&&57343>=ee){var xe=h.charCodeAt(++j);ee=65536+((ee&1023)<<10)|xe&1023}if(127>=ee){if(S>=C)break;v[S++>>>0]=ee}else{if(2047>=ee){if(S+1>=C)break;v[S++>>>0]=192|ee>>6}else{if(65535>=ee){if(S+2>=C)break;v[S++>>>0]=224|ee>>12}else{if(S+3>=C)break;v[S++>>>0]=240|ee>>18,v[S++>>>0]=128|ee>>12&63}v[S++>>>0]=128|ee>>6&63}v[S++>>>0]=128|ee&63}}return v[S>>>0]=0,S-M},Rr=h=>h%4===0&&(h%100!==0||h%400===0),Ir=[0,31,60,91,121,152,182,213,244,274,305,335],bn=[0,31,59,90,120,151,181,212,243,273,304,334],yn=h=>{var v=Vn(h)+1,S=xn(v);return S&&gn(h,F,S,v),S},Yr=[],Fn=(h,v)=>{Yr.length=0;for(var S;S=F[h++>>>0];){var C=S!=105;C&=S!=112,v+=C&&v%8?4:0,Yr.push(S==112?W[v>>>2>>>0]:S==105?P[v>>>2>>>0]:H[v>>>3>>>0]),v+=C?8:4}return Yr},tr={},Un=()=>{if(!vn){var h={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:s||"./this.program"},v;for(v in tr)tr[v]===void 0?delete h[v]:h[v]=tr[v];var S=[];for(v in h)S.push(`${v}=${h[v]}`);vn=S}return vn},vn,At=[null,[],[]],Co=[31,29,31,30,31,30,31,31,30,31,30,31],Xe=[31,28,31,30,31,30,31,31,30,31,30,31];function Po(h){var v=Array(Vn(h)+1);return gn(h,v,0,v.length),v}function wn(h,v,S,C){function M(z,ve,ze){for(z=typeof z=="number"?z.toString():z||"";z.length<ve;)z=ze[0]+z;return z}function j(z,ve){return M(z,ve,"0")}function ee(z,ve){function ze(Vo){return 0>Vo?-1:0<Vo?1:0}var dr;return(dr=ze(z.getFullYear()-ve.getFullYear()))===0&&(dr=ze(z.getMonth()-ve.getMonth()))===0&&(dr=ze(z.getDate()-ve.getDate())),dr}function xe(z){switch(z.getDay()){case 0:return new Date(z.getFullYear()-1,11,29);case 1:return z;case 2:return new Date(z.getFullYear(),0,3);case 3:return new Date(z.getFullYear(),0,2);case 4:return new Date(z.getFullYear(),0,1);case 5:return new Date(z.getFullYear()-1,11,31);case 6:return new Date(z.getFullYear()-1,11,30)}}function ue(z){var ve=z.Ca;for(z=new Date(new Date(z.Da+1900,0,1).getTime());0<ve;){var ze=z.getMonth(),dr=(Rr(z.getFullYear())?Co:Xe)[ze];if(ve>dr-z.getDate())ve-=dr-z.getDate()+1,z.setDate(1),11>ze?z.setMonth(ze+1):(z.setMonth(0),z.setFullYear(z.getFullYear()+1));else{z.setDate(z.getDate()+ve);break}}return ze=new Date(z.getFullYear()+1,0,4),ve=xe(new Date(z.getFullYear(),0,4)),ze=xe(ze),0>=ee(ve,z)?0>=ee(ze,z)?z.getFullYear()+1:z.getFullYear():z.getFullYear()-1}h>>>=0,v>>>=0,S>>>=0,C>>>=0;var fe=W[C+40>>>2>>>0];C={Ya:P[C>>>2>>>0],Xa:P[C+4>>>2>>>0],Ga:P[C+8>>>2>>>0],Ka:P[C+12>>>2>>>0],Ha:P[C+16>>>2>>>0],Da:P[C+20>>>2>>>0],xa:P[C+24>>>2>>>0],Ca:P[C+28>>>2>>>0],bb:P[C+32>>>2>>>0],Wa:P[C+36>>>2>>>0],Za:fe?_t(fe):""},S=_t(S),fe={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var ye in fe)S=S.replace(new RegExp(ye,"g"),fe[ye]);var ke="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),Fe="January February March April May June July August September October November December".split(" ");fe={"%a":z=>ke[z.xa].substring(0,3),"%A":z=>ke[z.xa],"%b":z=>Fe[z.Ha].substring(0,3),"%B":z=>Fe[z.Ha],"%C":z=>j((z.Da+1900)/100|0,2),"%d":z=>j(z.Ka,2),"%e":z=>M(z.Ka,2," "),"%g":z=>ue(z).toString().substring(2),"%G":z=>ue(z),"%H":z=>j(z.Ga,2),"%I":z=>(z=z.Ga,z==0?z=12:12<z&&(z-=12),j(z,2)),"%j":z=>{for(var ve=0,ze=0;ze<=z.Ha-1;ve+=(Rr(z.Da+1900)?Co:Xe)[ze++]);return j(z.Ka+ve,3)},"%m":z=>j(z.Ha+1,2),"%M":z=>j(z.Xa,2),"%n":()=>`
`,"%p":z=>0<=z.Ga&&12>z.Ga?"AM":"PM","%S":z=>j(z.Ya,2),"%t":()=>"	","%u":z=>z.xa||7,"%U":z=>j(Math.floor((z.Ca+7-z.xa)/7),2),"%V":z=>{var ve=Math.floor((z.Ca+7-(z.xa+6)%7)/7);if(2>=(z.xa+371-z.Ca-2)%7&&ve++,ve)ve==53&&(ze=(z.xa+371-z.Ca)%7,ze==4||ze==3&&Rr(z.Da)||(ve=1));else{ve=52;var ze=(z.xa+7-z.Ca-1)%7;(ze==4||ze==5&&Rr(z.Da%400-1))&&ve++}return j(ve,2)},"%w":z=>z.xa,"%W":z=>j(Math.floor((z.Ca+7-(z.xa+6)%7)/7),2),"%y":z=>(z.Da+1900).toString().substring(2),"%Y":z=>z.Da+1900,"%z":z=>{z=z.Wa;var ve=0<=z;return z=Math.abs(z)/60,(ve?"+":"-")+("0000"+(z/60*100+z%60)).slice(-4)},"%Z":z=>z.Za,"%%":()=>"%"},S=S.replace(/%%/g,"\0\0");for(ye in fe)S.includes(ye)&&(S=S.replace(new RegExp(ye,"g"),fe[ye](C)));return S=S.replace(/\0\0/g,"%"),ye=Po(S),ye.length>v?0:(B.set(ye,h>>>0),ye.length-1)}var zr=h=>{try{h()}catch(v){Ie(v)}};function wa(){var h=me,v={};for(let[S,C]of Object.entries(h))v[S]=typeof C=="function"?function(){Ar.push(S);try{return C.apply(null,arguments)}finally{E||(Ar.pop(),Wt&&rr===1&&Ar.length===0&&(rr=0,zr(Qn),typeof Fibers<"u"&&Fibers.cb()))}}:C;return v}var rr=0,Wt=null,we=0,Ar=[],Gn={},ko={},Do=0,Wn=null,Bo=[];function Ro(){return new Promise((h,v)=>{Wn={resolve:h,reject:v}})}function zo(){var h=xn(65548),v=h+12;W[h>>>2>>>0]=v,W[h+4>>>2>>>0]=v+65536,v=Ar[0];var S=Gn[v];return S===void 0&&(S=Do++,Gn[v]=S,ko[S]=v),P[h+8>>>2>>>0]=S,h}function No(h){if(!E){if(rr===0){var v=!1,S=!1;h((C=0)=>{if(!E&&(we=C,v=!0,S)){rr=2,zr(()=>eo(Wt)),typeof Browser<"u"&&Browser.Ia.Pa&&Browser.Ia.resume(),C=!1;try{var M=(0,me[ko[P[Wt+8>>>2>>>0]]])()}catch(xe){M=xe,C=!0}var j=!1;if(!Wt){var ee=Wn;ee&&(Wn=null,(C?ee.reject:ee.resolve)(M),j=!0)}if(C&&!j)throw M}}),S=!0,v||(rr=1,Wt=zo(),typeof Browser<"u"&&Browser.Ia.Pa&&Browser.Ia.pause(),zr(()=>Jn(Wt)))}else rr===2?(rr=0,zr(to),jn(Wt),Wt=null,Bo.forEach(C=>{if(!E)try{C();try{N=N=C=N,n.onExit?.(C),E=!0,a(C,new st(C))}catch(M){M instanceof st||M=="unwind"||a(1,M)}}catch(M){M instanceof st||M=="unwind"||a(1,M)}})):Ie(`invalid state: ${rr}`);return we}}function Hn(h){return No(v=>{h().then(v)})}var Lo={n:function(h,v,S){return Hn(async()=>{await n.Ra(h,v,S)})},a:function(h,v,S){throw h>>>=0,new Dr(h).$a(v>>>0,S>>>0),er=h,mn++,er},g:function(){return 0},J:function(){},A:function(){},C:function(){},L:function(){return 0},H:function(){},D:function(){},G:function(){},l:function(){},B:function(){},y:function(){},I:function(){},z:function(){},m:()=>1,q:function(h,v,S){h=v+2097152>>>0<4194305-!!h?(h>>>0)+4294967296*v:NaN,S>>>=0,h=new Date(1e3*h),P[S>>>2>>>0]=h.getUTCSeconds(),P[S+4>>>2>>>0]=h.getUTCMinutes(),P[S+8>>>2>>>0]=h.getUTCHours(),P[S+12>>>2>>>0]=h.getUTCDate(),P[S+16>>>2>>>0]=h.getUTCMonth(),P[S+20>>>2>>>0]=h.getUTCFullYear()-1900,P[S+24>>>2>>>0]=h.getUTCDay(),P[S+28>>>2>>>0]=(h.getTime()-Date.UTC(h.getUTCFullYear(),0,1,0,0,0,0))/864e5|0},r:function(h,v,S){h=v+2097152>>>0<4194305-!!h?(h>>>0)+4294967296*v:NaN,S>>>=0,h=new Date(1e3*h),P[S>>>2>>>0]=h.getSeconds(),P[S+4>>>2>>>0]=h.getMinutes(),P[S+8>>>2>>>0]=h.getHours(),P[S+12>>>2>>>0]=h.getDate(),P[S+16>>>2>>>0]=h.getMonth(),P[S+20>>>2>>>0]=h.getFullYear()-1900,P[S+24>>>2>>>0]=h.getDay(),P[S+28>>>2>>>0]=(Rr(h.getFullYear())?Ir:bn)[h.getMonth()]+h.getDate()-1|0,P[S+36>>>2>>>0]=-(60*h.getTimezoneOffset()),v=new Date(h.getFullYear(),6,1).getTimezoneOffset();var C=new Date(h.getFullYear(),0,1).getTimezoneOffset();P[S+32>>>2>>>0]=(v!=C&&h.getTimezoneOffset()==Math.min(C,v))|0},s:function(h){h>>>=0;var v=new Date(P[h+20>>>2>>>0]+1900,P[h+16>>>2>>>0],P[h+12>>>2>>>0],P[h+8>>>2>>>0],P[h+4>>>2>>>0],P[h>>>2>>>0],0),S=P[h+32>>>2>>>0],C=v.getTimezoneOffset(),M=new Date(v.getFullYear(),6,1).getTimezoneOffset(),j=new Date(v.getFullYear(),0,1).getTimezoneOffset(),ee=Math.min(j,M);return 0>S?P[h+32>>>2>>>0]=+(M!=j&&ee==C):0<S!=(ee==C)&&(M=Math.max(j,M),v.setTime(v.getTime()+6e4*((0<S?ee:M)-C))),P[h+24>>>2>>>0]=v.getDay(),P[h+28>>>2>>>0]=(Rr(v.getFullYear())?Ir:bn)[v.getMonth()]+v.getDate()-1|0,P[h>>>2>>>0]=v.getSeconds(),P[h+4>>>2>>>0]=v.getMinutes(),P[h+8>>>2>>>0]=v.getHours(),P[h+12>>>2>>>0]=v.getDate(),P[h+16>>>2>>>0]=v.getMonth(),P[h+20>>>2>>>0]=v.getYear(),h=v.getTime(),isNaN(h)?(P[qn()>>>2>>>0]=61,h=-1):h/=1e3,Kn((lt=h,1<=+Math.abs(lt)?0<lt?+Math.floor(lt/4294967296)>>>0:~~+Math.ceil((lt-+(~~lt>>>0))/4294967296)>>>0:0)),h>>>0},o:function(){return-52},p:function(){},w:function(h,v,S){function C(ue){return(ue=ue.toTimeString().match(/\(([A-Za-z ]+)\)$/))?ue[1]:"GMT"}S>>>=0;var M=new Date().getFullYear(),j=new Date(M,0,1),ee=new Date(M,6,1);M=j.getTimezoneOffset();var xe=ee.getTimezoneOffset();W[h>>>0>>>2>>>0]=60*Math.max(M,xe),P[v>>>0>>>2>>>0]=+(M!=xe),h=C(j),v=C(ee),h=yn(h),v=yn(v),xe<M?(W[S>>>2>>>0]=h,W[S+4>>>2>>>0]=v):(W[S>>>2>>>0]=v,W[S+4>>>2>>>0]=h)},e:()=>{Ie("")},b:function(h,v,S){return h>>>=0,v=Fn(v>>>0,S>>>0),dt[h].apply(null,v)},i:function(h,v,S){return h>>>=0,v=Fn(v>>>0,S>>>0),dt[h].apply(null,v)},h:()=>Date.now(),x:function(){return 4294901760},c:()=>performance.now(),K:function(h,v,S){return v>>>=0,F.copyWithin(h>>>0>>>0,v>>>0,v+(S>>>0)>>>0)},u:function(h){h>>>=0;var v=F.length;if(4294901760<h)return!1;for(var S=1;4>=S;S*=2){var C=v*(1+.2/S);C=Math.min(C,h+100663296);var M=Math;C=Math.max(h,C);e:{M=(M.min.call(M,4294901760,C+(65536-C%65536)%65536)-A.buffer.byteLength+65535)/65536;try{A.grow(M),re();var j=1;break e}catch{}j=void 0}if(j)return!0}return!1},E:function(h,v){h>>>=0,v>>>=0;var S=0;return Un().forEach((C,M)=>{var j=v+S;for(M=W[h+4*M>>>2>>>0]=j,j=0;j<C.length;++j)B[M++>>>0>>>0]=C.charCodeAt(j);B[M>>>0>>>0]=0,S+=C.length+1}),0},F:function(h,v){h>>>=0,v>>>=0;var S=Un();W[h>>>2>>>0]=S.length;var C=0;return S.forEach(M=>C+=M.length+1),W[v>>>2>>>0]=C,0},f:()=>52,k:function(){return 52},t:function(){return 70},j:function(h,v,S,C){v>>>=0,S>>>=0,C>>>=0;for(var M=0,j=0;j<S;j++){var ee=W[v>>>2>>>0],xe=W[v+4>>>2>>>0];v+=8;for(var ue=0;ue<xe;ue++){var fe=F[ee+ue>>>0],ye=At[h];fe===0||fe===10?((h===1?x:T)(Br(ye,0)),ye.length=0):ye.push(fe)}M+=xe}return W[C>>>2>>>0]=M,0},v:wn,d:function(h,v,S,C){return wn(h>>>0,v>>>0,S>>>0,C>>>0)}},me=function(){function h(S){return me=S.exports,me=wa(),me=Mo(),A=me.M,re(),ne.unshift(me.N),Ze--,Ze==0&&(Se!==null&&(clearInterval(Se),Se=null),He&&(S=He,He=null,S())),me}var v={a:Lo};if(Ze++,n.instantiateWasm)try{return n.instantiateWasm(v,h)}catch(S){T(`Module.instantiateWasm callback failed with error: ${S}`),o(S)}return Gt(v,function(S){h(S.instance)}).catch(o),{}}();n._OrtInit=(h,v)=>(n._OrtInit=me.O)(h,v),n._OrtGetLastError=(h,v)=>(n._OrtGetLastError=me.P)(h,v),n._OrtCreateSessionOptions=(h,v,S,C,M,j,ee,xe,ue,fe)=>(n._OrtCreateSessionOptions=me.Q)(h,v,S,C,M,j,ee,xe,ue,fe),n._OrtAppendExecutionProvider=(h,v)=>(n._OrtAppendExecutionProvider=me.R)(h,v),n._OrtAddFreeDimensionOverride=(h,v,S)=>(n._OrtAddFreeDimensionOverride=me.S)(h,v,S),n._OrtAddSessionConfigEntry=(h,v,S)=>(n._OrtAddSessionConfigEntry=me.T)(h,v,S),n._OrtReleaseSessionOptions=h=>(n._OrtReleaseSessionOptions=me.U)(h),n._OrtCreateSession=(h,v,S)=>(n._OrtCreateSession=me.V)(h,v,S),n._OrtReleaseSession=h=>(n._OrtReleaseSession=me.W)(h),n._OrtGetInputOutputCount=(h,v,S)=>(n._OrtGetInputOutputCount=me.X)(h,v,S),n._OrtGetInputName=(h,v)=>(n._OrtGetInputName=me.Y)(h,v),n._OrtGetOutputName=(h,v)=>(n._OrtGetOutputName=me.Z)(h,v),n._OrtFree=h=>(n._OrtFree=me._)(h),n._OrtCreateTensor=(h,v,S,C,M,j)=>(n._OrtCreateTensor=me.$)(h,v,S,C,M,j),n._OrtGetTensorData=(h,v,S,C,M)=>(n._OrtGetTensorData=me.aa)(h,v,S,C,M),n._OrtReleaseTensor=h=>(n._OrtReleaseTensor=me.ba)(h),n._OrtCreateRunOptions=(h,v,S,C)=>(n._OrtCreateRunOptions=me.ca)(h,v,S,C),n._OrtAddRunConfigEntry=(h,v,S)=>(n._OrtAddRunConfigEntry=me.da)(h,v,S),n._OrtReleaseRunOptions=h=>(n._OrtReleaseRunOptions=me.ea)(h),n._OrtCreateBinding=h=>(n._OrtCreateBinding=me.fa)(h),n._OrtBindInput=(h,v,S)=>(n._OrtBindInput=me.ga)(h,v,S),n._OrtBindOutput=(h,v,S,C)=>(n._OrtBindOutput=me.ha)(h,v,S,C),n._OrtClearBoundOutputs=h=>(n._OrtClearBoundOutputs=me.ia)(h),n._OrtReleaseBinding=h=>(n._OrtReleaseBinding=me.ja)(h),n._OrtRunWithBinding=(h,v,S,C,M)=>(n._OrtRunWithBinding=me.ka)(h,v,S,C,M),n._OrtRun=(h,v,S,C,M,j,ee,xe)=>(n._OrtRun=me.la)(h,v,S,C,M,j,ee,xe),n._OrtEndProfiling=h=>(n._OrtEndProfiling=me.ma)(h),n._JsepOutput=(h,v,S)=>(n._JsepOutput=me.na)(h,v,S),n._JsepGetNodeName=h=>(n._JsepGetNodeName=me.oa)(h);var qn=()=>(qn=me.pa)(),xn=n._malloc=h=>(xn=n._malloc=me.qa)(h),jn=n._free=h=>(jn=n._free=me.ra)(h),Kn=h=>(Kn=me.ta)(h),Yn=()=>(Yn=me.ua)(),Xn=h=>(Xn=me.va)(h),Zn=h=>(Zn=me.wa)(h),Jn=h=>(Jn=me.ya)(h),Qn=()=>(Qn=me.za)(),eo=h=>(eo=me.Aa)(h),to=()=>(to=me.Ba)();n.___start_em_js=943100,n.___stop_em_js=943261;function Mo(){var h=me;h=Object.assign({},h);var v=C=>()=>C()>>>0,S=C=>M=>C(M)>>>0;return h.pa=v(h.pa),h.qa=S(h.qa),h.ua=v(h.ua),h.wa=S(h.wa),h}n.stackAlloc=Zn,n.stackSave=Yn,n.stackRestore=Xn,n.UTF8ToString=_t,n.stringToUTF8=(h,v,S)=>gn(h,F,v,S),n.lengthBytesUTF8=Vn;var Nr;He=function h(){Nr||Xr(),Nr||(He=h)};function Xr(){if(!(0<Ze)){if(n.preRun)for(typeof n.preRun=="function"&&(n.preRun=[n.preRun]);n.preRun.length;){var h=n.preRun.shift();ie.unshift(h)}for(;0<ie.length;)ie.shift()(n);if(!(0<Ze||Nr||(Nr=!0,n.calledRun=!0,E))){for(;0<ne.length;)ne.shift()(n);for(t(n);0<Ye.length;)Ye.shift()(n)}}}return Xr(),e.ready}})();typeof Sh=="object"&&typeof Vs=="object"?Vs.exports=$h:typeof define=="function"&&define.amd&&define([],()=>$h)});var Ah=Je(()=>{});var Oh=Je(()=>{});var Eh={};Mr(Eh,{cpus:()=>Tx});var Tx,Ch=D(()=>{Tx=void 0});var Dh=Je((kh,Fs)=>{"use strict";var Ph=(()=>{var r=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(r=r||__filename),function(e={}){function n(){return ie.buffer!=Se.buffer&&bt(),Se}function t(){return ie.buffer!=Se.buffer&&bt(),He}function o(){return ie.buffer!=Se.buffer&&bt(),Ie}function i(){return ie.buffer!=Se.buffer&&bt(),Ce}function s(){return ie.buffer!=Se.buffer&&bt(),ft}function a(){return ie.buffer!=Se.buffer&&bt(),at}var u=e,l,d;u.ready=new Promise((c,g)=>{l=c,d=g}),u.mountExternalData=(c,g)=>{(u.cb||(u.cb=new Map)).set(c,g)},u.unmountExternalData=()=>{delete u.cb},u.jsepInit=(c,g,w,I,R,V,q,ge)=>{u.Mb=c,u.wb=g,u.yb=w,u.kb=I,u.xb=R,u.Ea=V,u.zb=q,u.Ab=ge,g=(pe,he,_e)=>(...Le)=>{let Ke=cr,L=he?.();Le=pe(...Le);let $e=he?.();return L!==$e&&(pe=$e,_e(L),he=_e=null),cr!=Ke?By():Le},w=pe=>async(...he)=>{try{if(u.bb)throw Error("Session already started");let _e=u.bb={Cb:he[0],errors:[]},Le=await pe(...he);if(u.bb!==_e)throw Error("Session mismatch");c.flush();let Ke=_e.errors;if(0<Ke.length){let L=await Promise.all(Ke);if(L=L.filter($e=>$e),0<L.length)throw Error(L.join(`
`))}return Le}finally{u.bb=null}},u._OrtRun=w(g(u._OrtRun,()=>u._OrtRun,pe=>u._OrtRun=pe)),u._OrtRunWithBinding=w(g(u._OrtRunWithBinding,()=>u._OrtRunWithBinding,pe=>u._OrtRunWithBinding=pe)),u._OrtBindInput=g(u._OrtBindInput,()=>u._OrtBindInput,pe=>u._OrtBindInput=pe),u.jsepRegisterBuffer=(pe,he,_e,Le)=>c.registerBuffer(pe,he,_e,Le),u.jsepUnregisterBuffers=pe=>{c.unregisterBuffers(pe)},u.jsepGetBuffer=pe=>c.getBuffer(pe),u.jsepCreateDownloader=(pe,he,_e)=>c.createDownloader(pe,he,_e)};var f=Object.assign({},u),p="./this.program",m=(c,g)=>{throw g},b=typeof window=="object",y=typeof importScripts=="function",$=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",x=u.ENVIRONMENT_IS_PTHREAD||!1,T="";function A(c){return u.locateFile?u.locateFile(c,T):T+c}var E,N,B;if($){var F=(Ns(),Or(zs)),P=(Ms(),Or(Ls));T=y?P.dirname(T)+"/":__dirname+"/",E=(g,w)=>(g=Kr(g)?new URL(g):P.normalize(g),F.readFileSync(g,w?void 0:"utf8")),B=g=>(g=E(g,!0),g.buffer||(g=new Uint8Array(g)),g),N=(g,w,I,R=!0)=>{g=Kr(g)?new URL(g):P.normalize(g),F.readFile(g,R?void 0:"utf8",(V,q)=>{V?I(V):w(R?q.buffer:q)})},!u.thisProgram&&1<process.argv.length&&(p=process.argv[1].replace(/\\/g,"/")),process.argv.slice(2),m=(g,w)=>{throw process.exitCode=g,w},u.inspect=()=>"[Emscripten Module object]";let c;try{c=Ah()}catch(g){throw console.error('The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?'),g}global.Worker=c.Worker}else(b||y)&&(y?T=self.location.href:typeof document<"u"&&document.currentScript&&(T=document.currentScript.src),typeof r<"u"&&r&&(T=r),T.indexOf("blob:")!==0?T=T.substr(0,T.replace(/[?#].*/,"").lastIndexOf("/")+1):T="",$||(E=c=>{var g=new XMLHttpRequest;return g.open("GET",c,!1),g.send(null),g.responseText},y&&(B=c=>{var g=new XMLHttpRequest;return g.open("GET",c,!1),g.responseType="arraybuffer",g.send(null),new Uint8Array(g.response)}),N=(c,g,w)=>{var I=new XMLHttpRequest;I.open("GET",c,!0),I.responseType="arraybuffer",I.onload=()=>{I.status==200||I.status==0&&I.response?g(I.response):w()},I.onerror=w,I.send(null)}));$&&typeof performance>"u"&&(global.performance=Oh().performance);var W=console.log.bind(console),oe=console.error.bind(console);$&&(W=(...c)=>F.writeSync(1,c.join(" ")+`
`),oe=(...c)=>F.writeSync(2,c.join(" ")+`
`));var H=W,re=oe;Object.assign(u,f),f=null,typeof WebAssembly!="object"&&er("no native wasm support detected");var ie,ne,Ye=!1,Ze,Se,He,Ie,Ce,ft,at;function bt(){var c=ie.buffer;u.HEAP8=Se=new Int8Array(c),u.HEAP16=new Int16Array(c),u.HEAPU8=He=new Uint8Array(c),u.HEAPU16=new Uint16Array(c),u.HEAP32=Ie=new Int32Array(c),u.HEAPU32=Ce=new Uint32Array(c),u.HEAPF32=ft=new Float32Array(c),u.HEAPF64=at=new Float64Array(c)}var Y=16777216;if(x)ie=u.wasmMemory;else if(u.wasmMemory)ie=u.wasmMemory;else if(ie=new WebAssembly.Memory({initial:Y/65536,maximum:65536,shared:!0}),!(ie.buffer instanceof SharedArrayBuffer))throw re("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"),$&&re("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and/or recent version)"),Error("bad memory");bt(),Y=ie.buffer.byteLength;var de=[],Pe=[],Gt=[],lt=0,dt=null,st=null;function Dr(){if(lt--,lt==0&&(dt!==null&&(clearInterval(dt),dt=null),st)){var c=st;st=null,c()}}function er(c){throw c="Aborted("+c+")",re(c),Ye=!0,Ze=1,c=new WebAssembly.RuntimeError(c+". Build with -sASSERTIONS for more info."),d(c),c}var mn=c=>c.startsWith("data:application/octet-stream;base64,"),Kr=c=>c.startsWith("file://"),Br;Br="ort-wasm-simd-threaded.wasm",mn(Br)||(Br=A(Br));function _t(c){if(B)return B(c);throw"both async and sync fetching of the wasm failed"}function Vn(c){if(b||y){if(typeof fetch=="function"&&!Kr(c))return fetch(c,{credentials:"same-origin"}).then(g=>{if(!g.ok)throw"failed to load wasm binary file at '"+c+"'";return g.arrayBuffer()}).catch(()=>_t(c));if(N)return new Promise((g,w)=>{N(c,I=>g(new Uint8Array(I)),w)})}return Promise.resolve().then(()=>_t(c))}function gn(c,g,w){return Vn(c).then(I=>WebAssembly.instantiate(I,g)).then(I=>I).then(w,I=>{re(`failed to asynchronously prepare wasm: ${I}`),er(I)})}function Rr(c,g){var w=Br;return typeof WebAssembly.instantiateStreaming!="function"||mn(w)||Kr(w)||$||typeof fetch!="function"?gn(w,c,g):fetch(w,{credentials:"same-origin"}).then(I=>WebAssembly.instantiateStreaming(I,c).then(g,function(R){return re(`wasm streaming compile failed: ${R}`),re("falling back to ArrayBuffer instantiation"),gn(w,c,g)}))}var Ir,bn={932428:(c,g,w,I)=>{if(typeof u>"u"||!u.cb)return 1;if(c=At(c>>>0),c.startsWith("./")&&(c=c.substring(2)),c=u.cb.get(c),!c)return 2;if(g>>>=0,w>>>=0,I>>>=0,g+w>c.byteLength)return 3;try{return t().set(c.subarray(g,g+w),I>>>0),0}catch{return 4}},932929:c=>u.wb(c),932962:c=>u.yb(c),932994:(c,g,w)=>{u.kb(c,g,w,!0)},933033:(c,g,w)=>{u.kb(c,g,w)},933066:c=>{u.Ea("Abs",c,void 0)},933117:c=>{u.Ea("Neg",c,void 0)},933168:c=>{u.Ea("Floor",c,void 0)},933221:c=>{u.Ea("Ceil",c,void 0)},933273:c=>{u.Ea("Reciprocal",c,void 0)},933331:c=>{u.Ea("Sqrt",c,void 0)},933383:c=>{u.Ea("Exp",c,void 0)},933434:c=>{u.Ea("Erf",c,void 0)},933485:c=>{u.Ea("Sigmoid",c,void 0)},933540:c=>{u.Ea("Log",c,void 0)},933591:c=>{u.Ea("Sin",c,void 0)},933642:c=>{u.Ea("Cos",c,void 0)},933693:c=>{u.Ea("Tan",c,void 0)},933744:c=>{u.Ea("Asin",c,void 0)},933796:c=>{u.Ea("Acos",c,void 0)},933848:c=>{u.Ea("Atan",c,void 0)},933900:c=>{u.Ea("Sinh",c,void 0)},933952:c=>{u.Ea("Cosh",c,void 0)},934004:c=>{u.Ea("Asinh",c,void 0)},934057:c=>{u.Ea("Acosh",c,void 0)},934110:c=>{u.Ea("Atanh",c,void 0)},934163:c=>{u.Ea("Tanh",c,void 0)},934215:c=>{u.Ea("Not",c,void 0)},934266:(c,g,w)=>{u.Ea("Clip",c,{min:g,max:w})},934335:c=>{u.Ea("Clip",c,void 0)},934387:(c,g)=>{u.Ea("Elu",c,{alpha:g})},934445:c=>{u.Ea("Relu",c,void 0)},934497:(c,g)=>{u.Ea("LeakyRelu",c,{alpha:g})},934561:(c,g)=>{u.Ea("ThresholdedRelu",c,{alpha:g})},934631:(c,g)=>{u.Ea("Cast",c,{to:g})},934689:c=>{u.Ea("Add",c,void 0)},934740:c=>{u.Ea("Sub",c,void 0)},934791:c=>{u.Ea("Mul",c,void 0)},934842:c=>{u.Ea("Div",c,void 0)},934893:c=>{u.Ea("Pow",c,void 0)},934944:c=>{u.Ea("Equal",c,void 0)},934997:c=>{u.Ea("Greater",c,void 0)},935052:c=>{u.Ea("GreaterOrEqual",c,void 0)},935114:c=>{u.Ea("Less",c,void 0)},935166:c=>{u.Ea("LessOrEqual",c,void 0)},935225:(c,g,w,I,R)=>{u.Ea("ReduceMean",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},935384:(c,g,w,I,R)=>{u.Ea("ReduceMax",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},935542:(c,g,w,I,R)=>{u.Ea("ReduceMin",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},935700:(c,g,w,I,R)=>{u.Ea("ReduceProd",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},935859:(c,g,w,I,R)=>{u.Ea("ReduceSum",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},936017:(c,g,w,I,R)=>{u.Ea("ReduceL1",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},936174:(c,g,w,I,R)=>{u.Ea("ReduceL2",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},936331:(c,g,w,I,R)=>{u.Ea("ReduceLogSum",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},936492:(c,g,w,I,R)=>{u.Ea("ReduceSumSquare",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},936656:(c,g,w,I,R)=>{u.Ea("ReduceLogSumExp",c,{keepDims:!!g,noopWithEmptyAxes:!!w,axes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},936820:c=>{u.Ea("Where",c,void 0)},936873:(c,g,w)=>{u.Ea("Transpose",c,{perm:g?Array.from(o().subarray(g>>>0,w>>>0)):[]})},936981:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e)=>{u.Ea("ConvTranspose",c,{format:pe?"NHWC":"NCHW",autoPad:g,dilations:[w],group:I,kernel_shape:[R],pads:[V,q],strides:[ge],wIsConst:()=>!!n()[he>>>0],outputPadding:_e?Array.from(o().subarray(_e>>>0,Le>>>0)):[],outputShape:Ke?Array.from(o().subarray(Ke>>>0,L>>>0)):[],activation:At($e)})},937383:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L)=>{u.Ea("ConvTranspose",c,{format:ge?"NHWC":"NCHW",autoPad:g,dilations:Array.from(o().subarray(w>>>0,(w>>>0)+2>>>0)),group:I,kernelShape:Array.from(o().subarray(R>>>0,(R>>>0)+2>>>0)),pads:Array.from(o().subarray(V>>>0,(V>>>0)+4>>>0)),strides:Array.from(o().subarray(q>>>0,(q>>>0)+2>>>0)),wIsConst:()=>!!n()[pe>>>0],outputPadding:he?Array.from(o().subarray(he>>>0,_e>>>0)):[],outputShape:Le?Array.from(o().subarray(Le>>>0,Ke>>>0)):[],activation:At(L)})},937948:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e)=>{u.Ea("ConvTranspose",c,{format:pe?"NHWC":"NCHW",autoPad:g,dilations:[w],group:I,kernel_shape:[R],pads:[V,q],strides:[ge],wIsConst:()=>!!n()[he>>>0],outputPadding:_e?Array.from(o().subarray(_e>>>0,Le>>>0)):[],outputShape:Ke?Array.from(o().subarray(Ke>>>0,L>>>0)):[],activation:At($e)})},938350:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L)=>{u.Ea("ConvTranspose",c,{format:ge?"NHWC":"NCHW",autoPad:g,dilations:Array.from(o().subarray(w>>>0,(w>>>0)+2>>>0)),group:I,kernelShape:Array.from(o().subarray(R>>>0,(R>>>0)+2>>>0)),pads:Array.from(o().subarray(V>>>0,(V>>>0)+4>>>0)),strides:Array.from(o().subarray(q>>>0,(q>>>0)+2>>>0)),wIsConst:()=>!!n()[pe>>>0],outputPadding:he?Array.from(o().subarray(he>>>0,_e>>>0)):[],outputShape:Le?Array.from(o().subarray(Le>>>0,Ke>>>0)):[],activation:At(L)})},938915:(c,g)=>{u.Ea("GlobalAveragePool",c,{format:g?"NHWC":"NCHW"})},939006:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e,Ue)=>{u.Ea("AveragePool",c,{format:Ue?"NHWC":"NCHW",auto_pad:g,ceil_mode:w,count_include_pad:I,storage_order:R,dilations:[V,q],kernel_shape:[ge,pe],pads:[he,_e,Le,Ke],strides:[L,$e]})},939290:(c,g)=>{u.Ea("GlobalAveragePool",c,{format:g?"NHWC":"NCHW"})},939381:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e,Ue)=>{u.Ea("AveragePool",c,{format:Ue?"NHWC":"NCHW",auto_pad:g,ceil_mode:w,count_include_pad:I,storage_order:R,dilations:[V,q],kernel_shape:[ge,pe],pads:[he,_e,Le,Ke],strides:[L,$e]})},939665:(c,g)=>{u.Ea("GlobalMaxPool",c,{format:g?"NHWC":"NCHW"})},939752:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e,Ue)=>{u.Ea("MaxPool",c,{format:Ue?"NHWC":"NCHW",auto_pad:g,ceil_mode:w,count_include_pad:I,storage_order:R,dilations:[V,q],kernel_shape:[ge,pe],pads:[he,_e,Le,Ke],strides:[L,$e]})},940032:(c,g)=>{u.Ea("GlobalMaxPool",c,{format:g?"NHWC":"NCHW"})},940119:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e,Ue)=>{u.Ea("MaxPool",c,{format:Ue?"NHWC":"NCHW",auto_pad:g,ceil_mode:w,count_include_pad:I,storage_order:R,dilations:[V,q],kernel_shape:[ge,pe],pads:[he,_e,Le,Ke],strides:[L,$e]})},940399:(c,g,w,I,R)=>{u.Ea("Gemm",c,{alpha:g,beta:w,transA:I,transB:R})},940503:c=>{u.Ea("MatMul",c,void 0)},940557:(c,g,w,I)=>{u.Ea("ArgMax",c,{keepDims:!!g,selectLastIndex:!!w,axis:I})},940665:(c,g,w,I)=>{u.Ea("ArgMin",c,{keepDims:!!g,selectLastIndex:!!w,axis:I})},940773:(c,g)=>{u.Ea("Softmax",c,{axis:g})},940836:(c,g)=>{u.Ea("Concat",c,{axis:g})},940896:(c,g,w,I,R)=>{u.Ea("Split",c,{axis:g,numOutputs:w,splitSizes:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},941036:c=>{u.Ea("Expand",c,void 0)},941090:(c,g)=>{u.Ea("Gather",c,{axis:Number(g)})},941161:(c,g)=>{u.Ea("GatherElements",c,{axis:Number(g)})},941240:(c,g,w,I,R,V,q,ge,pe,he,_e)=>{u.Ea("Resize",c,{antialias:g,axes:w?Array.from(o().subarray(w>>>0,I>>>0)):[],coordinateTransformMode:At(R),cubicCoeffA:V,excludeOutside:q,extrapolationValue:ge,keepAspectRatioPolicy:At(pe),mode:At(he),nearestMode:At(_e)})},941586:(c,g,w,I,R,V,q)=>{u.Ea("Slice",c,{starts:g?Array.from(o().subarray(g>>>0,w>>>0)):[],ends:I?Array.from(o().subarray(I>>>0,R>>>0)):[],axes:V?Array.from(o().subarray(V>>>0,q>>>0)):[]})},941802:c=>{u.Ea("Tile",c,void 0)},941854:(c,g,w)=>{u.Ea("LayerNormalization",c,{axis:Number(g),epsilon:Number(w)})},941961:(c,g,w)=>{u.Ea("InstanceNormalization",c,{epsilon:g,format:w?"NHWC":"NCHW"})},942075:(c,g,w)=>{u.Ea("InstanceNormalization",c,{epsilon:g,format:w?"NHWC":"NCHW"})},942189:c=>{u.Ea("Range",c,void 0)},942242:(c,g)=>{u.Ea("Einsum",c,{equation:At(g)})},942323:(c,g,w,I,R)=>{u.Ea("Pad",c,{mode:g,value:w,pads:I?Array.from(o().subarray(I>>>0,R>>>0)):[]})},942450:(c,g,w,I,R,V)=>{u.Ea("BatchNormalization",c,{epsilon:g,momentum:w,spatial:!!R,trainingMode:!!I,format:V?"NHWC":"NCHW"})},942619:(c,g,w,I,R,V)=>{u.Ea("BatchNormalization",c,{epsilon:g,momentum:w,spatial:!!R,trainingMode:!!I,format:V?"NHWC":"NCHW"})},942788:(c,g,w)=>{u.Ea("CumSum",c,{exclusive:Number(g),reverse:Number(w)})},942885:(c,g,w,I,R,V,q,ge,pe)=>{u.Ea("Attention",c,{numHeads:g,isUnidirectional:w,maskFilterValue:I,scale:R,doRotary:V,qkvHiddenSizes:q?Array.from(o().subarray(Number(ge)>>>0,Number(ge)+q>>>0)):[],pastPresentShareBuffer:!!pe})},943157:c=>{u.Ea("Gelu",c,void 0)},943209:(c,g,w,I,R,V)=>{u.Ea("MultiHeadAttention",c,{numHeads:g,isUnidirectional:w,maskFilterValue:I,scale:R,doRotary:V})},943368:c=>{u.Ea("BiasAdd",c,void 0)},943423:c=>{u.Ea("BiasSplitGelu",c,void 0)},943484:(c,g)=>{u.Ea("SkipLayerNormalization",c,{epsilon:g})},943565:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke)=>{u.Ea("Conv",c,{format:pe?"NHWC":"NCHW",auto_pad:g,dilations:[w],group:I,kernel_shape:[R],pads:V?Array.from(o().subarray(V>>>0,q>>>0)):[],strides:[ge],w_is_const:()=>!!n()[he>>>0],activation:At(_e),activation_params:Le?Array.from(s().subarray(Le>>>0,Ke>>>0)):[]})},943935:(c,g,w,I,R,V,q,ge,pe,he,_e,Le,Ke,L,$e,Ue)=>{u.Ea("Conv",c,{format:Le?"NHWC":"NCHW",auto_pad:g,dilations:[w,I],group:R,kernel_shape:[V,q],pads:ge?Array.from(o().subarray(ge>>>0,pe>>>0)):[],strides:[he,_e],w_is_const:()=>!!n()[Ke>>>0],activation:At(L),activation_params:$e?Array.from(s().subarray($e>>>0,Ue>>>0)):[]})},944326:c=>{u.zb(c)},944360:(c,g)=>u.Ab(c,g,u.bb.Cb,u.bb.errors)};function yn(c){this.name="ExitStatus",this.message=`Program terminated with exit(${c})`,this.status=c}var Yr=c=>{c.terminate(),c.onmessage=()=>{}},Fn=c=>{we.Ya.length==0&&(rr(),we.lb(we.Ya[0]));var g=we.Ya.pop();if(!g)return 6;we.Za.push(g),we.Qa[c.Xa]=g,g.Xa=c.Xa;var w={cmd:"run",start_routine:c.Db,arg:c.tb,pthread_ptr:c.Xa};return $&&g.unref(),g.postMessage(w,c.Jb),0},tr=0,Un=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,vn=(c,g,w)=>{g>>>=0;var I=g+w;for(w=g;c[w]&&!(w>=I);)++w;if(16<w-g&&c.buffer&&Un)return Un.decode(c.buffer instanceof SharedArrayBuffer?c.slice(g,w):c.subarray(g,w));for(I="";g<w;){var R=c[g++];if(R&128){var V=c[g++]&63;if((R&224)==192)I+=String.fromCharCode((R&31)<<6|V);else{var q=c[g++]&63;R=(R&240)==224?(R&15)<<12|V<<6|q:(R&7)<<18|V<<12|q<<6|c[g++]&63,65536>R?I+=String.fromCharCode(R):(R-=65536,I+=String.fromCharCode(55296|R>>10,56320|R&1023))}}else I+=String.fromCharCode(R)}return I},At=(c,g)=>(c>>>=0)?vn(t(),c,g):"",Co=c=>{var g=Sa();return c=c(),Wo(g),c};function Xe(c,g){var w=arguments.length-2,I=arguments;return Co(()=>{for(var R=Ia(8*w),V=R>>>3,q=0;q<w;q++){var ge=I[2+q];a()[V+q>>>0]=ge}return ku(c,w,R,g)})}function Po(c){if(x)return Xe(0,1,c);Ze=c,0<tr||(we.Eb(),u.onExit?.(c),Ye=!0),m(c,new yn(c))}var wn=c=>{if(Ze=c,x)throw Gn(c),"unwind";Po(c)},zr=c=>{c instanceof yn||c=="unwind"||m(1,c)};function wa(){for(var c=u.numThreads;c--;)rr();de.unshift(()=>{lt++,Wt(()=>Dr())})}function rr(){var c=A("ort-wasm-simd-threaded.worker.js");c=new Worker(c),we.Ya.push(c)}function Wt(c){x?c():Promise.all(we.Ya.map(we.lb)).then(c)}var we={Ya:[],Za:[],pb:[],Qa:{},hb(){x?(we.receiveObjectTransfer=we.Bb,we.threadInitTLS=we.ob,we.setExitStatus=we.nb):wa()},nb:c=>Ze=c,Nb:["$terminateWorker"],Eb:()=>{for(var c of we.Za)Yr(c);for(c of we.Ya)Yr(c);we.Ya=[],we.Za=[],we.Qa=[]},mb:c=>{var g=c.Xa;delete we.Qa[g],we.Ya.push(c),we.Za.splice(we.Za.indexOf(c),1),c.Xa=0,_a(g)},Bb(){},ob(){we.pb.forEach(c=>c())},lb:c=>new Promise(g=>{c.onmessage=V=>{V=V.data;var q=V.cmd;if(V.targetThread&&V.targetThread!=Go()){var ge=we.Qa[V.targetThread];ge?ge.postMessage(V,V.transferList):re(`Internal error! Worker sent a message "${q}" to target pthread ${V.targetThread}, but that thread no longer exists!`)}else q==="checkMailbox"?Xr():q==="spawnThread"?Fn(V):q==="cleanupThread"?we.mb(we.Qa[V.thread]):q==="killThread"?(V=V.thread,q=we.Qa[V],delete we.Qa[V],Yr(q),_a(V),we.Za.splice(we.Za.indexOf(q),1),q.Xa=0):q==="cancelThread"?we.Qa[V.thread].postMessage({cmd:"cancel"}):q==="loaded"?(c.loaded=!0,$&&!c.Xa&&c.unref(),g(c)):q==="alert"?alert(`Thread ${V.threadId}: ${V.text}`):V.target==="setimmediate"?c.postMessage(V):q==="callHandler"?u[V.handler](...V.args):q&&re(`worker sent an unknown command ${q}`)},c.onerror=V=>{throw re(`worker sent an error! ${V.filename}:${V.lineno}: ${V.message}`),V},$&&(c.on("message",V=>c.onmessage({data:V})),c.on("error",V=>c.onerror(V)));var w=[],I=["onExit"],R;for(R of I)u.hasOwnProperty(R)&&w.push(R);c.postMessage({cmd:"load",handlers:w,urlOrBlob:u.mainScriptUrlOrBlob||r,wasmMemory:ie,wasmModule:ne})})};u.PThread=we;var Ar=c=>{for(;0<c.length;)c.shift()(u)};u.establishStackSpace=()=>{var c=Go(),g=i()[c+52>>>2>>>0];c=i()[c+56>>>2>>>0],Ru(g,g-c),Wo(g)};function Gn(c){if(x)return Xe(1,0,c);wn(c)}u.invokeEntryPoint=(c,g)=>{c=zu.apply(null,[c,g]),0<tr?we.nb(c):$a(c)};function ko(c){this.gb=c-24,this.sb=function(g){i()[this.gb+4>>>2>>>0]=g},this.rb=function(g){i()[this.gb+8>>>2>>>0]=g},this.hb=function(g,w){this.qb(),this.sb(g),this.rb(w)},this.qb=function(){i()[this.gb+16>>>2>>>0]=0}}var Do=0,Wn=0;function Bo(c,g,w,I){return x?Xe(2,1,c,g,w,I):Ro(c,g,w,I)}function Ro(c,g,w,I){if(c>>>=0,g>>>=0,w>>>=0,I>>>=0,typeof SharedArrayBuffer>"u")return re("Current environment does not support SharedArrayBuffer, pthreads are not available!"),6;var R=[];return x&&R.length===0?Bo(c,g,w,I):(c={Db:w,Xa:c,tb:I,Jb:R},x?(c.Lb="spawnThread",postMessage(c,R),0):Fn(c))}function zo(c,g,w){return x?Xe(3,1,c,g,w):0}function No(c,g){if(x)return Xe(4,1,c,g)}var Hn=c=>{for(var g=0,w=0;w<c.length;++w){var I=c.charCodeAt(w);127>=I?g++:2047>=I?g+=2:55296<=I&&57343>=I?(g+=4,++w):g+=3}return g},Lo=(c,g,w,I)=>{if(w>>>=0,!(0<I))return 0;var R=w;I=w+I-1;for(var V=0;V<c.length;++V){var q=c.charCodeAt(V);if(55296<=q&&57343>=q){var ge=c.charCodeAt(++V);q=65536+((q&1023)<<10)|ge&1023}if(127>=q){if(w>=I)break;g[w++>>>0]=q}else{if(2047>=q){if(w+1>=I)break;g[w++>>>0]=192|q>>6}else{if(65535>=q){if(w+2>=I)break;g[w++>>>0]=224|q>>12}else{if(w+3>=I)break;g[w++>>>0]=240|q>>18,g[w++>>>0]=128|q>>12&63}g[w++>>>0]=128|q>>6&63}g[w++>>>0]=128|q&63}}return g[w>>>0]=0,w-R},me=(c,g,w)=>Lo(c,t(),g,w);function qn(c,g){if(x)return Xe(5,1,c,g)}function xn(c,g,w){if(x)return Xe(6,1,c,g,w)}function jn(c,g,w){return x?Xe(7,1,c,g,w):0}function Kn(c,g){if(x)return Xe(8,1,c,g)}function Yn(c,g,w){if(x)return Xe(9,1,c,g,w)}function Xn(c,g,w,I){if(x)return Xe(10,1,c,g,w,I)}function Zn(c,g,w,I){if(x)return Xe(11,1,c,g,w,I)}function Jn(c,g,w,I){if(x)return Xe(12,1,c,g,w,I)}function Qn(c){if(x)return Xe(13,1,c)}function eo(c,g){if(x)return Xe(14,1,c,g)}function to(c,g,w){if(x)return Xe(15,1,c,g,w)}var Mo=()=>{if(!(0<tr))try{x?$a(Ze):wn(Ze)}catch(c){zr(c)}};function Nr(c){c>>>=0,typeof Atomics.Kb=="function"&&(Atomics.Kb(o(),c>>>2,c).value.then(Xr),c+=128,Atomics.store(o(),c>>>2,1))}u.__emscripten_thread_mailbox_await=Nr;var Xr=()=>{var c=Go();if(c&&(Nr(c),!Ye))try{Du(),Mo()}catch(g){zr(g)}};u.checkMailbox=Xr;var h=[],v=c=>c%4===0&&(c%100!==0||c%400===0),S=[0,31,60,91,121,152,182,213,244,274,305,335],C=[0,31,59,90,120,151,181,212,243,273,304,334];function M(c,g,w,I,R,V,q,ge){return x?Xe(16,1,c,g,w,I,R,V,q,ge):-52}function j(c,g,w,I,R,V,q){if(x)return Xe(17,1,c,g,w,I,R,V,q)}var ee=c=>{var g=Hn(c)+1,w=Ta(g);return w&&me(c,w,g),w},xe=[],ue=(c,g)=>{xe.length=0;for(var w;w=t()[c++>>>0];){var I=w!=105;I&=w!=112,g+=I&&g%8?4:0,xe.push(w==112?i()[g>>>2>>>0]:w==105?o()[g>>>2>>>0]:a()[g>>>3>>>0]),g+=I?8:4}return xe},fe={},ye=()=>{if(!ke){var c={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:p||"./this.program"},g;for(g in fe)fe[g]===void 0?delete c[g]:c[g]=fe[g];var w=[];for(g in c)w.push(`${g}=${c[g]}`);ke=w}return ke},ke;function Fe(c,g){if(x)return Xe(18,1,c,g);c>>>=0,g>>>=0;var w=0;return ye().forEach((I,R)=>{var V=g+w;for(R=i()[c+4*R>>>2>>>0]=V,V=0;V<I.length;++V)n()[R++>>>0>>>0]=I.charCodeAt(V);n()[R>>>0>>>0]=0,w+=I.length+1}),0}function z(c,g){if(x)return Xe(19,1,c,g);c>>>=0,g>>>=0;var w=ye();i()[c>>>2>>>0]=w.length;var I=0;return w.forEach(R=>I+=R.length+1),i()[g>>>2>>>0]=I,0}function ve(c){return x?Xe(20,1,c):52}function ze(c,g,w,I){return x?Xe(21,1,c,g,w,I):52}function dr(c,g,w,I,R){return x?Xe(22,1,c,g,w,I,R):70}var Vo=[null,[],[]];function Tu(c,g,w,I){if(x)return Xe(23,1,c,g,w,I);g>>>=0,w>>>=0,I>>>=0;for(var R=0,V=0;V<w;V++){var q=i()[g>>>2>>>0],ge=i()[g+4>>>2>>>0];g+=8;for(var pe=0;pe<ge;pe++){var he=t()[q+pe>>>0],_e=Vo[c];he===0||he===10?((c===1?H:re)(vn(_e,0)),_e.length=0):_e.push(he)}R+=ge}return i()[I>>>2>>>0]=R,0}var _u=[31,29,31,30,31,30,31,31,30,31,30,31],$u=[31,28,31,30,31,30,31,31,30,31,30,31];function Ey(c){var g=Array(Hn(c)+1);return Lo(c,g,0,g.length),g}var Cy=(c,g)=>{n().set(c,g>>>0)};function Su(c,g,w,I){function R(L,$e,Ue){for(L=typeof L=="number"?L.toString():L||"";L.length<$e;)L=Ue[0]+L;return L}function V(L,$e){return R(L,$e,"0")}function q(L,$e){function Ue(Uu){return 0>Uu?-1:0<Uu?1:0}var Zr;return(Zr=Ue(L.getFullYear()-$e.getFullYear()))===0&&(Zr=Ue(L.getMonth()-$e.getMonth()))===0&&(Zr=Ue(L.getDate()-$e.getDate())),Zr}function ge(L){switch(L.getDay()){case 0:return new Date(L.getFullYear()-1,11,29);case 1:return L;case 2:return new Date(L.getFullYear(),0,3);case 3:return new Date(L.getFullYear(),0,2);case 4:return new Date(L.getFullYear(),0,1);case 5:return new Date(L.getFullYear()-1,11,31);case 6:return new Date(L.getFullYear()-1,11,30)}}function pe(L){var $e=L.$a;for(L=new Date(new Date(L.ab+1900,0,1).getTime());0<$e;){var Ue=L.getMonth(),Zr=(v(L.getFullYear())?_u:$u)[Ue];if($e>Zr-L.getDate())$e-=Zr-L.getDate()+1,L.setDate(1),11>Ue?L.setMonth(Ue+1):(L.setMonth(0),L.setFullYear(L.getFullYear()+1));else{L.setDate(L.getDate()+$e);break}}return Ue=new Date(L.getFullYear()+1,0,4),$e=ge(new Date(L.getFullYear(),0,4)),Ue=ge(Ue),0>=q($e,L)?0>=q(Ue,L)?L.getFullYear()+1:L.getFullYear():L.getFullYear()-1}c>>>=0,g>>>=0,w>>>=0,I>>>=0;var he=i()[I+40>>>2>>>0];I={Hb:o()[I>>>2>>>0],Gb:o()[I+4>>>2>>>0],eb:o()[I+8>>>2>>>0],jb:o()[I+12>>>2>>>0],fb:o()[I+16>>>2>>>0],ab:o()[I+20>>>2>>>0],Wa:o()[I+24>>>2>>>0],$a:o()[I+28>>>2>>>0],Ob:o()[I+32>>>2>>>0],Fb:o()[I+36>>>2>>>0],Ib:he?At(he):""},w=At(w),he={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var _e in he)w=w.replace(new RegExp(_e,"g"),he[_e]);var Le="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),Ke="January February March April May June July August September October November December".split(" ");he={"%a":L=>Le[L.Wa].substring(0,3),"%A":L=>Le[L.Wa],"%b":L=>Ke[L.fb].substring(0,3),"%B":L=>Ke[L.fb],"%C":L=>V((L.ab+1900)/100|0,2),"%d":L=>V(L.jb,2),"%e":L=>R(L.jb,2," "),"%g":L=>pe(L).toString().substring(2),"%G":L=>pe(L),"%H":L=>V(L.eb,2),"%I":L=>(L=L.eb,L==0?L=12:12<L&&(L-=12),V(L,2)),"%j":L=>{for(var $e=0,Ue=0;Ue<=L.fb-1;$e+=(v(L.ab+1900)?_u:$u)[Ue++]);return V(L.jb+$e,3)},"%m":L=>V(L.fb+1,2),"%M":L=>V(L.Gb,2),"%n":()=>`
`,"%p":L=>0<=L.eb&&12>L.eb?"AM":"PM","%S":L=>V(L.Hb,2),"%t":()=>"	","%u":L=>L.Wa||7,"%U":L=>V(Math.floor((L.$a+7-L.Wa)/7),2),"%V":L=>{var $e=Math.floor((L.$a+7-(L.Wa+6)%7)/7);if(2>=(L.Wa+371-L.$a-2)%7&&$e++,$e)$e==53&&(Ue=(L.Wa+371-L.$a)%7,Ue==4||Ue==3&&v(L.ab)||($e=1));else{$e=52;var Ue=(L.Wa+7-L.$a-1)%7;(Ue==4||Ue==5&&v(L.ab%400-1))&&$e++}return V($e,2)},"%w":L=>L.Wa,"%W":L=>V(Math.floor((L.$a+7-(L.Wa+6)%7)/7),2),"%y":L=>(L.ab+1900).toString().substring(2),"%Y":L=>L.ab+1900,"%z":L=>{L=L.Fb;var $e=0<=L;return L=Math.abs(L)/60,($e?"+":"-")+("0000"+(L/60*100+L%60)).slice(-4)},"%Z":L=>L.Ib,"%%":()=>"%"},w=w.replace(/%%/g,"\0\0");for(_e in he)w.includes(_e)&&(w=w.replace(new RegExp(_e,"g"),he[_e](I)));return w=w.replace(/\0\0/g,"%"),_e=Ey(w),_e.length>g?0:(Cy(_e,c),_e.length-1)}var Fo=c=>{try{c()}catch(g){er(g)}};function Py(){var c=ae,g={};for(let[w,I]of Object.entries(c))g[w]=typeof I=="function"?function(){Uo.push(w);try{return I.apply(null,arguments)}finally{Ye||(Uo.pop(),cr&&Lr===1&&Uo.length===0&&(Lr=0,tr+=1,Fo(Lu),typeof Fibers<"u"&&Fibers.Pb()))}}:I;return g}var Lr=0,cr=null,Iu=0,Uo=[],Au={},Ou={},ky=0,xa=null,Dy=[];function By(){return new Promise((c,g)=>{xa={resolve:c,reject:g}})}function Ry(){var c=Ta(65548),g=c+12;i()[c>>>2>>>0]=g,i()[c+4>>>2>>>0]=g+65536,g=Uo[0];var w=Au[g];return w===void 0&&(w=ky++,Au[g]=w,Ou[w]=g),g=w,o()[c+8>>>2>>>0]=g,c}function zy(){var c=o()[cr+8>>>2>>>0];return c=ae[Ou[c]],--tr,c()}function Ny(c){if(!Ye){if(Lr===0){var g=!1,w=!1;c((I=0)=>{if(!Ye&&(Iu=I,g=!0,w)){Lr=2,Fo(()=>Mu(cr)),typeof Browser<"u"&&Browser.ib.vb&&Browser.ib.resume(),I=!1;try{var R=zy()}catch(ge){R=ge,I=!0}var V=!1;if(!cr){var q=xa;q&&(xa=null,(I?q.reject:q.resolve)(R),V=!0)}if(I&&!V)throw R}}),w=!0,g||(Lr=1,cr=Ry(),typeof Browser<"u"&&Browser.ib.vb&&Browser.ib.pause(),Fo(()=>Nu(cr)))}else Lr===2?(Lr=0,Fo(Vu),Cu(cr),cr=null,Dy.forEach(I=>{if(!Ye)try{I(),Mo()}catch(R){zr(R)}})):er(`invalid state: ${Lr}`);return Iu}}function Ly(c){return Ny(g=>{c().then(g)})}we.hb();var My=[Po,Gn,Bo,zo,No,qn,xn,jn,Kn,Yn,Xn,Zn,Jn,Qn,eo,to,M,j,Fe,z,ve,ze,dr,Tu],Vy={r:function(c,g,w){return Ly(async()=>{await u.xb(c,g,w)})},b:function(c,g,w){throw c>>>=0,new ko(c).hb(g>>>0,w>>>0),Do=c,Wn++,Do},N:function(c){Pu(c>>>0,!y,1,!b,131072,!1),we.ob()},l:function(c){c>>>=0,x?postMessage({cmd:"cleanupThread",thread:c}):we.mb(we.Qa[c])},J:Ro,i:zo,T:No,F:qn,H:xn,U:jn,R:Kn,L:Yn,Q:Xn,p:Zn,G:Jn,D:Qn,S:eo,E:to,q:()=>1,B:function(c,g){c>>>=0,c==g>>>0?setTimeout(()=>Xr()):x?postMessage({targetThread:c,cmd:"checkMailbox"}):(c=we.Qa[c])&&c.postMessage({cmd:"checkMailbox"})},K:function(c,g,w,I){g>>>=0,h.length=w,I=I>>>0>>>3;for(var R=0;R<w;R++)h[R]=a()[I+R>>>0];return c=0>c?bn[-c-1]:My[c],we.ub=g,g=c.apply(null,h),we.ub=0,g},M:Nr,W:function(c){$&&we.Qa[c>>>0].ref()},u:function(c,g,w){c=g+2097152>>>0<4194305-!!c?(c>>>0)+4294967296*g:NaN,w>>>=0,c=new Date(1e3*c),o()[w>>>2>>>0]=c.getUTCSeconds(),o()[w+4>>>2>>>0]=c.getUTCMinutes(),o()[w+8>>>2>>>0]=c.getUTCHours(),o()[w+12>>>2>>>0]=c.getUTCDate(),o()[w+16>>>2>>>0]=c.getUTCMonth(),o()[w+20>>>2>>>0]=c.getUTCFullYear()-1900,o()[w+24>>>2>>>0]=c.getUTCDay(),c=(c.getTime()-Date.UTC(c.getUTCFullYear(),0,1,0,0,0,0))/864e5|0,o()[w+28>>>2>>>0]=c},v:function(c,g,w){c=g+2097152>>>0<4194305-!!c?(c>>>0)+4294967296*g:NaN,w>>>=0,c=new Date(1e3*c),o()[w>>>2>>>0]=c.getSeconds(),o()[w+4>>>2>>>0]=c.getMinutes(),o()[w+8>>>2>>>0]=c.getHours(),o()[w+12>>>2>>>0]=c.getDate(),o()[w+16>>>2>>>0]=c.getMonth(),o()[w+20>>>2>>>0]=c.getFullYear()-1900,o()[w+24>>>2>>>0]=c.getDay(),g=(v(c.getFullYear())?S:C)[c.getMonth()]+c.getDate()-1|0,o()[w+28>>>2>>>0]=g,o()[w+36>>>2>>>0]=-(60*c.getTimezoneOffset()),g=new Date(c.getFullYear(),6,1).getTimezoneOffset();var I=new Date(c.getFullYear(),0,1).getTimezoneOffset();c=(g!=I&&c.getTimezoneOffset()==Math.min(I,g))|0,o()[w+32>>>2>>>0]=c},w:function(c){c>>>=0;var g=new Date(o()[c+20>>>2>>>0]+1900,o()[c+16>>>2>>>0],o()[c+12>>>2>>>0],o()[c+8>>>2>>>0],o()[c+4>>>2>>>0],o()[c>>>2>>>0],0),w=o()[c+32>>>2>>>0],I=g.getTimezoneOffset(),R=new Date(g.getFullYear(),6,1).getTimezoneOffset(),V=new Date(g.getFullYear(),0,1).getTimezoneOffset(),q=Math.min(V,R);return 0>w?o()[c+32>>>2>>>0]=+(R!=V&&q==I):0<w!=(q==I)&&(R=Math.max(V,R),g.setTime(g.getTime()+6e4*((0<w?q:R)-I))),o()[c+24>>>2>>>0]=g.getDay(),w=(v(g.getFullYear())?S:C)[g.getMonth()]+g.getDate()-1|0,o()[c+28>>>2>>>0]=w,o()[c>>>2>>>0]=g.getSeconds(),o()[c+4>>>2>>>0]=g.getMinutes(),o()[c+8>>>2>>>0]=g.getHours(),o()[c+12>>>2>>>0]=g.getDate(),o()[c+16>>>2>>>0]=g.getMonth(),o()[c+20>>>2>>>0]=g.getYear(),c=g.getTime(),isNaN(c)?(o()[Eu()>>>2>>>0]=61,c=-1):c/=1e3,Bu((Ir=c,1<=+Math.abs(Ir)?0<Ir?+Math.floor(Ir/4294967296)>>>0:~~+Math.ceil((Ir-+(~~Ir>>>0))/4294967296)>>>0:0)),c>>>0},s:M,t:j,A:function(c,g,w){function I(he){return(he=he.toTimeString().match(/\(([A-Za-z ]+)\)$/))?he[1]:"GMT"}c>>>=0,g>>>=0,w>>>=0;var R=new Date().getFullYear(),V=new Date(R,0,1),q=new Date(R,6,1);R=V.getTimezoneOffset();var ge=q.getTimezoneOffset(),pe=Math.max(R,ge);i()[c>>>2>>>0]=60*pe,o()[g>>>2>>>0]=+(R!=ge),c=I(V),g=I(q),c=ee(c),g=ee(g),ge<R?(i()[w>>>2>>>0]=c,i()[w+4>>>2>>>0]=g):(i()[w>>>2>>>0]=g,i()[w+4>>>2>>>0]=c)},d:()=>{er("")},c:function(c,g,w){return c>>>=0,g=ue(g>>>0,w>>>0),bn[c].apply(null,g)},k:function(c,g,w){return c>>>=0,g=ue(g>>>0,w>>>0),bn[c].apply(null,g)},m:()=>{},j:()=>Date.now(),V:()=>{throw tr+=1,"unwind"},C:function(){return 4294901760},f:()=>performance.timeOrigin+performance.now(),g:()=>$?(Ch(),Or(Eh)).cpus().length:navigator.hardwareConcurrency,y:function(c){c>>>=0;var g=t().length;if(c<=g||4294901760<c)return!1;for(var w=1;4>=w;w*=2){var I=g*(1+.2/w);I=Math.min(I,c+100663296);var R=Math;I=Math.max(c,I);e:{R=(R.min.call(R,4294901760,I+(65536-I%65536)%65536)-ie.buffer.byteLength+65535)/65536;try{ie.grow(R),bt();var V=1;break e}catch{}V=void 0}if(V)return!0}return!1},O:Fe,P:z,I:wn,h:ve,o:ze,x:dr,n:Tu,a:ie||u.wasmMemory,z:Su,e:function(c,g,w,I){return Su(c>>>0,g>>>0,w>>>0,I>>>0)}},ae=function(){function c(w,I){return ae=w.exports,ae=Py(),ae=Fy(),we.pb.push(ae.Da),Pe.unshift(ae.X),ne=I,Dr(),ae}var g={a:Vy};if(lt++,u.instantiateWasm)try{return u.instantiateWasm(g,c)}catch(w){re(`Module.instantiateWasm callback failed with error: ${w}`),d(w)}return Rr(g,function(w){c(w.instance,w.module)}).catch(d),{}}();u._OrtInit=(c,g)=>(u._OrtInit=ae.Y)(c,g),u._OrtGetLastError=(c,g)=>(u._OrtGetLastError=ae.Z)(c,g),u._OrtCreateSessionOptions=(c,g,w,I,R,V,q,ge,pe,he)=>(u._OrtCreateSessionOptions=ae._)(c,g,w,I,R,V,q,ge,pe,he),u._OrtAppendExecutionProvider=(c,g)=>(u._OrtAppendExecutionProvider=ae.$)(c,g),u._OrtAddFreeDimensionOverride=(c,g,w)=>(u._OrtAddFreeDimensionOverride=ae.aa)(c,g,w),u._OrtAddSessionConfigEntry=(c,g,w)=>(u._OrtAddSessionConfigEntry=ae.ba)(c,g,w),u._OrtReleaseSessionOptions=c=>(u._OrtReleaseSessionOptions=ae.ca)(c),u._OrtCreateSession=(c,g,w)=>(u._OrtCreateSession=ae.da)(c,g,w),u._OrtReleaseSession=c=>(u._OrtReleaseSession=ae.ea)(c),u._OrtGetInputOutputCount=(c,g,w)=>(u._OrtGetInputOutputCount=ae.fa)(c,g,w),u._OrtGetInputName=(c,g)=>(u._OrtGetInputName=ae.ga)(c,g),u._OrtGetOutputName=(c,g)=>(u._OrtGetOutputName=ae.ha)(c,g),u._OrtFree=c=>(u._OrtFree=ae.ia)(c),u._OrtCreateTensor=(c,g,w,I,R,V)=>(u._OrtCreateTensor=ae.ja)(c,g,w,I,R,V),u._OrtGetTensorData=(c,g,w,I,R)=>(u._OrtGetTensorData=ae.ka)(c,g,w,I,R),u._OrtReleaseTensor=c=>(u._OrtReleaseTensor=ae.la)(c),u._OrtCreateRunOptions=(c,g,w,I)=>(u._OrtCreateRunOptions=ae.ma)(c,g,w,I),u._OrtAddRunConfigEntry=(c,g,w)=>(u._OrtAddRunConfigEntry=ae.na)(c,g,w),u._OrtReleaseRunOptions=c=>(u._OrtReleaseRunOptions=ae.oa)(c),u._OrtCreateBinding=c=>(u._OrtCreateBinding=ae.pa)(c),u._OrtBindInput=(c,g,w)=>(u._OrtBindInput=ae.qa)(c,g,w),u._OrtBindOutput=(c,g,w,I)=>(u._OrtBindOutput=ae.ra)(c,g,w,I),u._OrtClearBoundOutputs=c=>(u._OrtClearBoundOutputs=ae.sa)(c),u._OrtReleaseBinding=c=>(u._OrtReleaseBinding=ae.ta)(c),u._OrtRunWithBinding=(c,g,w,I,R)=>(u._OrtRunWithBinding=ae.ua)(c,g,w,I,R),u._OrtRun=(c,g,w,I,R,V,q,ge)=>(u._OrtRun=ae.va)(c,g,w,I,R,V,q,ge),u._OrtEndProfiling=c=>(u._OrtEndProfiling=ae.wa)(c),u._JsepOutput=(c,g,w)=>(u._JsepOutput=ae.xa)(c,g,w),u._JsepGetNodeName=c=>(u._JsepGetNodeName=ae.ya)(c);var Eu=()=>(Eu=ae.za)(),Go=u._pthread_self=()=>(Go=u._pthread_self=ae.Aa)(),Ta=u._malloc=c=>(Ta=u._malloc=ae.Ba)(c),Cu=u._free=c=>(Cu=u._free=ae.Ca)(c);u.__emscripten_tls_init=()=>(u.__emscripten_tls_init=ae.Da)();var Pu=u.__emscripten_thread_init=(c,g,w,I,R,V)=>(Pu=u.__emscripten_thread_init=ae.Fa)(c,g,w,I,R,V);u.__emscripten_thread_crashed=()=>(u.__emscripten_thread_crashed=ae.Ga)();var ku=(c,g,w,I)=>(ku=ae.Ha)(c,g,w,I),_a=c=>(_a=ae.Ia)(c),$a=u.__emscripten_thread_exit=c=>($a=u.__emscripten_thread_exit=ae.Ja)(c),Du=()=>(Du=ae.Ka)(),Bu=c=>(Bu=ae.La)(c),Ru=(c,g)=>(Ru=ae.Ma)(c,g),Sa=()=>(Sa=ae.Na)(),Wo=c=>(Wo=ae.Oa)(c),Ia=c=>(Ia=ae.Pa)(c),zu=u.dynCall_ii=(c,g)=>(zu=u.dynCall_ii=ae.Ra)(c,g),Nu=c=>(Nu=ae.Sa)(c),Lu=()=>(Lu=ae.Ta)(),Mu=c=>(Mu=ae.Ua)(c),Vu=()=>(Vu=ae.Va)();u.___start_em_js=944472,u.___stop_em_js=944633;function Fy(){var c=ae;c=Object.assign({},c);var g=I=>()=>I()>>>0,w=I=>R=>I(R)>>>0;return c.za=g(c.za),c.Aa=g(c.Aa),c.Ba=w(c.Ba),c.emscripten_main_runtime_thread_id=g(c.emscripten_main_runtime_thread_id),c.Na=g(c.Na),c.Pa=w(c.Pa),c}u.wasmMemory=ie,u.stackAlloc=Ia,u.stackSave=Sa,u.stackRestore=Wo,u.keepRuntimeAlive=()=>0<tr,u.UTF8ToString=At,u.stringToUTF8=me,u.lengthBytesUTF8=Hn,u.ExitStatus=yn,u.PThread=we;var Ho;st=function c(){Ho||Fu(),Ho||(st=c)};function Fu(){if(!(0<lt))if(x)l(u),x||Ar(Pe),startWorker(u);else{if(u.preRun)for(typeof u.preRun=="function"&&(u.preRun=[u.preRun]);u.preRun.length;)de.unshift(u.preRun.shift());Ar(de),0<lt||Ho||(Ho=!0,u.calledRun=!0,Ye||(x||Ar(Pe),l(u),x||Ar(Gt)))}}return Fu(),e.ready}})();typeof kh=="object"&&typeof Fs=="object"?Fs.exports=Ph:typeof define=="function"&&define.amd&&define([],()=>Ph)});var Bh=Je((QC,_x)=>{_x.exports='"use strict";var Module={},ENVIRONMENT_IS_NODE=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string";if(ENVIRONMENT_IS_NODE){var nodeWorkerThreads=require("worker_threads"),parentPort=nodeWorkerThreads.parentPort;parentPort.on("message",e=>onmessage({data:e}));var fs=require("fs"),vm=require("vm");Object.assign(global,{self:global,require,Module,location:{href:__filename},Worker:nodeWorkerThreads.Worker,importScripts:e=>vm.runInThisContext(fs.readFileSync(e,"utf8"),{filename:e}),postMessage:e=>parentPort.postMessage(e),performance:global.performance||{now:Date.now}})}var initializedJS=!1;function threadPrintErr(){var e=Array.prototype.slice.call(arguments).join(" ");if(ENVIRONMENT_IS_NODE){fs.writeSync(2,e+`\n`);return}console.error(e)}function threadAlert(){var e=Array.prototype.slice.call(arguments).join(" ");postMessage({cmd:"alert",text:e,threadId:Module._pthread_self()})}var err=threadPrintErr;self.alert=threadAlert,Module.instantiateWasm=(e,t)=>{var a=Module.wasmModule;Module.wasmModule=null;var r=new WebAssembly.Instance(a,e);return t(r)},self.onunhandledrejection=e=>{throw e.reason||e};function handleMessage(e){try{if(e.data.cmd==="load"){let a=[];self.onmessage=r=>a.push(r),self.startWorker=r=>{Module=r,postMessage({cmd:"loaded"});for(let s of a)handleMessage(s);self.onmessage=handleMessage},Module.wasmModule=e.data.wasmModule;for(const r of e.data.handlers)Module[r]=(...s)=>{postMessage({cmd:"callHandler",handler:r,args:s})};if(Module.wasmMemory=e.data.wasmMemory,Module.buffer=Module.wasmMemory.buffer,Module.ENVIRONMENT_IS_PTHREAD=!0,typeof e.data.urlOrBlob=="string")importScripts(e.data.urlOrBlob);else{var t=URL.createObjectURL(e.data.urlOrBlob);importScripts(t),URL.revokeObjectURL(t)}ortWasmThreaded(Module)}else if(e.data.cmd==="run"){Module.__emscripten_thread_init(e.data.pthread_ptr,0,0,1),Module.__emscripten_thread_mailbox_await(e.data.pthread_ptr),Module.establishStackSpace(),Module.PThread.receiveObjectTransfer(e.data),Module.PThread.threadInitTLS(),initializedJS||(initializedJS=!0);try{Module.invokeEntryPoint(e.data.start_routine,e.data.arg)}catch(a){if(a!="unwind")throw a}}else e.data.cmd==="cancel"?Module._pthread_self()&&Module.__emscripten_thread_exit(-1):e.data.target==="setimmediate"||(e.data.cmd==="checkMailbox"?initializedJS&&Module.checkMailbox():e.data.cmd&&(err(`worker.js received unknown command ${e.data.cmd}`),err(e.data)))}catch(a){throw Module.__emscripten_thread_crashed?.(),a}}self.onmessage=handleMessage;\n'});var zh,$x,Us,Gs,Wi,Rh,Sx,Ix,Ax,Nh,ct,Rn=D(()=>{"use strict";zh=Ih();$x=Dh(),Gs=!1,Wi=!1,Rh=!1,Sx=r=>{if(r===1)return!1;if(typeof SharedArrayBuffer>"u")return typeof self<"u"&&!self.crossOriginIsolated&&console.warn("env.wasm.numThreads is set to "+r+", but this will not work unless you enable crossOriginIsolated mode. See https://web.dev/cross-origin-isolation-guide/ for more info."),!1;typeof process<"u"&&process.versions&&process.versions.node&&console.warn("env.wasm.numThreads is set to "+r+", however, currently onnxruntime-web does not support multi-threads in Node.js. Please consider using onnxruntime-node for performance critical scenarios.");try{return typeof MessageChannel<"u"&&new MessageChannel().port1.postMessage(new SharedArrayBuffer(1)),WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,5,4,1,3,1,1,10,11,1,9,0,65,0,254,16,2,0,26,11]))}catch{return!1}},Ix=()=>{try{return WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,10,30,1,28,0,65,0,253,15,253,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,186,1,26,11]))}catch{return!1}},Ax=(r,e)=>r?e?"ort-wasm-simd-threaded.wasm":"ort-wasm-simd.wasm":e?"ort-wasm-threaded.wasm":"ort-wasm.wasm",Nh=async r=>{if(Gs)return Promise.resolve();if(Wi)throw new Error("multiple calls to 'initializeWebAssembly()' detected.");if(Rh)throw new Error("previous call to 'initializeWebAssembly()' failed.");Wi=!0;let e=r.initTimeout,n=r.numThreads,t=r.simd,o=Sx(n),i=t&&Ix(),s=r.wasmPaths,a=typeof s=="string"?s:void 0,u=Ax(i,o),l=typeof s=="object"?s[u]:void 0,d=!1,f=[];if(e>0&&f.push(new Promise(p=>{setTimeout(()=>{d=!0,p()},e)})),f.push(new Promise((p,m)=>{let b=o?$x:zh,y={locateFile:($,x)=>{if(o&&$.endsWith(".worker.js")&&typeof Blob<"u")return URL.createObjectURL(new Blob([Bh()],{type:"text/javascript"}));if($.endsWith(".wasm")){if(l)return l;let T=a??x;return u==="ort-wasm-simd.wasm"?T+"ort-wasm-simd.jsep.wasm":u==="ort-wasm-simd-threaded.wasm"?T+"ort-wasm-simd-threaded.jsep.wasm":T+u}return x+$}};if(o)if(y.numThreads=n,typeof Blob>"u")y.mainScriptUrlOrBlob=(void 0)(__dirname,"ort-wasm-threaded.js");else{let $=`var ortWasmThreaded=${b.toString()};`;y.mainScriptUrlOrBlob=new Blob([$],{type:"text/javascript"})}b(y).then($=>{Wi=!1,Gs=!0,Us=$,p()},$=>{Wi=!1,Rh=!0,m($)})})),await Promise.race(f),d)throw new Error(`WebAssembly backend initializing failed due to timeout: ${e}ms`)},ct=()=>{if(Gs&&Us)return Us;throw new Error("WebAssembly is not initialized yet.")}});var gt,wo,rt,Hi=D(()=>{"use strict";Rn();gt=(r,e)=>{let n=ct(),t=n.lengthBytesUTF8(r)+1,o=n._malloc(t);return n.stringToUTF8(r,o,t),e.push(o),o},wo=(r,e,n,t)=>{if(typeof r=="object"&&r!==null){if(n.has(r))throw new Error("Circular reference in options");n.add(r)}Object.entries(r).forEach(([o,i])=>{let s=e?e+o:o;if(typeof i=="object")wo(i,s+".",n,t);else if(typeof i=="string"||typeof i=="number")t(s,i.toString());else if(typeof i=="boolean")t(s,i?"1":"0");else throw new Error(`Can't handle extra config type: ${typeof i}`)})},rt=r=>{let e=ct(),n=e.stackSave();try{let t=e.stackAlloc(8);e._OrtGetLastError(t,t+4);let o=e.HEAP32[t/4],i=e.HEAPU32[t/4+1],s=i?e.UTF8ToString(i):"";throw new Error(`${r} ERROR_CODE: ${o}, ERROR_MESSAGE: ${s}`)}finally{e.stackRestore(n)}}});var Lh,Mh=D(()=>{"use strict";Rn();Hi();Lh=r=>{let e=ct(),n=0,t=[],o=r||{};try{if(r?.logSeverityLevel===void 0)o.logSeverityLevel=2;else if(typeof r.logSeverityLevel!="number"||!Number.isInteger(r.logSeverityLevel)||r.logSeverityLevel<0||r.logSeverityLevel>4)throw new Error(`log serverity level is not valid: ${r.logSeverityLevel}`);if(r?.logVerbosityLevel===void 0)o.logVerbosityLevel=0;else if(typeof r.logVerbosityLevel!="number"||!Number.isInteger(r.logVerbosityLevel))throw new Error(`log verbosity level is not valid: ${r.logVerbosityLevel}`);r?.terminate===void 0&&(o.terminate=!1);let i=0;return r?.tag!==void 0&&(i=gt(r.tag,t)),n=e._OrtCreateRunOptions(o.logSeverityLevel,o.logVerbosityLevel,!!o.terminate,i),n===0&&rt("Can't create run options."),r?.extra!==void 0&&wo(r.extra,"",new WeakSet,(s,a)=>{let u=gt(s,t),l=gt(a,t);e._OrtAddRunConfigEntry(n,u,l)!==0&&rt(`Can't set a run config entry: ${s} - ${a}.`)}),[n,t]}catch(i){throw n!==0&&e._OrtReleaseRunOptions(n),t.forEach(s=>e._free(s)),i}}});var Ox,Ex,Cx,Px,Vh,Fh=D(()=>{"use strict";Rn();Hi();Ox=r=>{switch(r){case"disabled":return 0;case"basic":return 1;case"extended":return 2;case"all":return 99;default:throw new Error(`unsupported graph optimization level: ${r}`)}},Ex=r=>{switch(r){case"sequential":return 0;case"parallel":return 1;default:throw new Error(`unsupported execution mode: ${r}`)}},Cx=r=>{r.extra||(r.extra={}),r.extra.session||(r.extra.session={});let e=r.extra.session;e.use_ort_model_bytes_directly||(e.use_ort_model_bytes_directly="1"),r.executionProviders&&r.executionProviders.some(n=>(typeof n=="string"?n:n.name)==="webgpu")&&(r.enableMemPattern=!1)},Px=(r,e,n)=>{for(let t of e){let o=typeof t=="string"?t:t.name;switch(o){case"webnn":if(o="WEBNN",typeof t!="string"){let s=t;if(s?.deviceType){let a=gt("deviceType",n),u=gt(s.deviceType,n);ct()._OrtAddSessionConfigEntry(r,a,u)!==0&&rt(`Can't set a session config entry: 'deviceType' - ${s.deviceType}.`)}if(s?.numThreads){let a=s.numThreads;(typeof a!="number"||!Number.isInteger(a)||a<0)&&(a=0);let u=gt("numThreads",n),l=gt(a.toString(),n);ct()._OrtAddSessionConfigEntry(r,u,l)!==0&&rt(`Can't set a session config entry: 'numThreads' - ${s.numThreads}.`)}if(s?.powerPreference){let a=gt("powerPreference",n),u=gt(s.powerPreference,n);ct()._OrtAddSessionConfigEntry(r,a,u)!==0&&rt(`Can't set a session config entry: 'powerPreference' - ${s.powerPreference}.`)}}break;case"webgpu":if(o="JS",typeof t!="string"){let s=t;if(s?.preferredLayout){if(s.preferredLayout!=="NCHW"&&s.preferredLayout!=="NHWC")throw new Error(`preferredLayout must be either 'NCHW' or 'NHWC': ${s.preferredLayout}`);let a=gt("preferredLayout",n),u=gt(s.preferredLayout,n);ct()._OrtAddSessionConfigEntry(r,a,u)!==0&&rt(`Can't set a session config entry: 'preferredLayout' - ${s.preferredLayout}.`)}}break;case"wasm":case"cpu":continue;default:throw new Error(`not supported execution provider: ${o}`)}let i=gt(o,n);ct()._OrtAppendExecutionProvider(r,i)!==0&&rt(`Can't append execution provider: ${o}.`)}},Vh=r=>{let e=ct(),n=0,t=[],o=r||{};Cx(o);try{let i=Ox(o.graphOptimizationLevel??"all"),s=Ex(o.executionMode??"sequential"),a=typeof o.logId=="string"?gt(o.logId,t):0,u=o.logSeverityLevel??2;if(!Number.isInteger(u)||u<0||u>4)throw new Error(`log serverity level is not valid: ${u}`);let l=o.logVerbosityLevel??0;if(!Number.isInteger(l)||l<0||l>4)throw new Error(`log verbosity level is not valid: ${l}`);let d=typeof o.optimizedModelFilePath=="string"?gt(o.optimizedModelFilePath,t):0;if(n=e._OrtCreateSessionOptions(i,!!o.enableCpuMemArena,!!o.enableMemPattern,s,!!o.enableProfiling,0,a,u,l,d),n===0&&rt("Can't create session options."),o.executionProviders&&Px(n,o.executionProviders,t),o.freeDimensionOverrides)for(let[f,p]of Object.entries(o.freeDimensionOverrides)){if(typeof f!="string")throw new Error(`free dimension override name must be a string: ${f}`);if(typeof p!="number"||!Number.isInteger(p)||p<0)throw new Error(`free dimension override value must be a non-negative integer: ${p}`);let m=gt(f,t);e._OrtAddFreeDimensionOverride(n,m,p)!==0&&rt(`Can't set a free dimension override: ${f} - ${p}.`)}return o.extra!==void 0&&wo(o.extra,"",new WeakSet,(f,p)=>{let m=gt(f,t),b=gt(p,t);e._OrtAddSessionConfigEntry(n,m,b)!==0&&rt(`Can't set a session config entry: ${f} - ${p}.`)}),[n,t]}catch(i){throw n!==0&&e._OrtReleaseSessionOptions(n),t.forEach(s=>e._free(s)),i}}});var Ws,Ft,xo,qi,To,ji,Hs,ut=D(()=>{"use strict";Ws=r=>{switch(r){case"int8":return 3;case"uint8":return 2;case"bool":return 9;case"int16":return 5;case"uint16":return 4;case"int32":return 6;case"uint32":return 12;case"float16":return 10;case"float32":return 1;case"float64":return 11;case"string":return 8;case"int64":return 7;case"uint64":return 13;default:throw new Error(`unsupported data type: ${r}`)}},Ft=r=>{switch(r){case 3:return"int8";case 2:return"uint8";case 9:return"bool";case 5:return"int16";case 4:return"uint16";case 6:return"int32";case 12:return"uint32";case 10:return"float16";case 1:return"float32";case 11:return"float64";case 8:return"string";case 7:return"int64";case 13:return"uint64";default:throw new Error(`unsupported data type: ${r}`)}},xo=r=>[void 0,4,1,1,2,2,4,8,void 0,1,2,8,4,8,void 0,void 0,void 0][r],qi=r=>{switch(r){case"float16":return Uint16Array;case"float32":return Float32Array;case"uint8":return Uint8Array;case"int8":return Int8Array;case"uint16":return Uint16Array;case"int16":return Int16Array;case"int32":return Int32Array;case"bool":return Uint8Array;case"float64":return Float64Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"uint64":return BigUint64Array;default:throw new Error(`unsupported type: ${r}`)}},To=r=>{switch(r){case"verbose":return 0;case"info":return 1;case"warning":return 2;case"error":return 3;case"fatal":return 4;default:throw new Error(`unsupported logging level: ${r}`)}},ji=r=>r==="float32"||r==="int32"||r==="int64"||r==="bool"||r==="float16"||r==="uint32",Hs=r=>{switch(r){case"none":return 0;case"cpu":return 1;case"cpu-pinned":return 2;case"texture":return 3;case"gpu-buffer":return 4;default:throw new Error(`unsupported data location: ${r}`)}}});var _o,qs=D(()=>{"use strict";_o=async r=>{if(typeof r=="string")if(typeof process<"u"&&process.versions&&process.versions.node)try{return new Uint8Array(await(void 0)(r))}catch(e){if(e.code==="ERR_FS_FILE_TOO_LARGE"){let n=(void 0)(r),t=[];for await(let o of n)t.push(o);return new Uint8Array(Buffer.concat(t))}throw e}else{let e=await fetch(r);if(!e.ok)throw new Error(`failed to load external data file: ${r}`);let n=e.headers.get("Content-Length"),t=n?parseInt(n,10):0;if(t<1073741824)return new Uint8Array(await e.arrayBuffer());{if(!e.body)throw new Error(`failed to load external data file: ${r}, no response body.`);let o=e.body.getReader(),i;try{i=new ArrayBuffer(t)}catch(a){if(a instanceof RangeError){let u=Math.ceil(t/65536);i=new WebAssembly.Memory({initial:u,maximum:u}).buffer}else throw a}let s=0;for(;;){let{done:a,value:u}=await o.read();if(a)break;let l=u.byteLength;new Uint8Array(i,s,l).set(u),s+=l}return new Uint8Array(i,0,t)}}else return r instanceof Blob?new Uint8Array(await r.arrayBuffer()):r instanceof Uint8Array?r:new Uint8Array(r)}});var kx,Dx,Uh,Gh,Wh,Bx,it,qr=D(()=>{"use strict";ut();kx=["V","I","W","E","F"],Dx=(r,e)=>{console.log(`[${kx[r]},${new Date().toISOString()}]${e}`)},Wh=(r,e)=>{Uh=r,Gh=e},Bx=(r,e)=>{let n=To(r),t=To(Uh);n>=t&&Dx(n,typeof e=="function"?e():e)},it=(...r)=>{Gh&&Bx(...r)}});var Hh,qh=D(()=>{"use strict";ut();Hh=(r,e)=>new(qi(e))(r)});var Ki=D(()=>{"use strict"});var Yi,Rx,jh,Ks,js,Yh,Xh=D(()=>{"use strict";qr();Ki();Yi=r=>Math.ceil(r/16)*16,Rx=1,jh=()=>Rx++,Ks=async(r,e,n,t)=>{let o=Yi(n),i=r.device.createBuffer({size:o,usage:GPUBufferUsage.COPY_DST|GPUBufferUsage.MAP_READ});try{let s=r.getCommandEncoder();r.endComputePass(),s.copyBufferToBuffer(e,0,i,0,o),r.flush(),await i.mapAsync(GPUMapMode.READ);let a=i.getMappedRange();if(t){let u=t();return u.set(new Uint8Array(a,0,n)),u}else return new Uint8Array(a.slice(0,n))}finally{i.destroy()}},js=class{constructor(e){this.backend=e;this.storageCache=new Map,this.freeBuffers=new Map,this.freeUniformBuffers=new Map,this.buffersForUploadingPending=[],this.buffersPending=[],this.externalBuffers=new Map}upload(e,n){let t=n.buffer,o=n.byteOffset,i=n.byteLength,s=Yi(i),a=this.storageCache.get(e);if(!a)throw new Error("gpu data for uploading does not exist");if(a.originalSize!==i)throw new Error(`inconsistent data size. gpu data size=${a.originalSize}, data size=${i}`);let u=this.backend.device.createBuffer({mappedAtCreation:!0,size:s,usage:GPUBufferUsage.MAP_WRITE|GPUBufferUsage.COPY_SRC}),l=u.getMappedRange();new Uint8Array(l).set(new Uint8Array(t,o,i)),u.unmap();let d=this.backend.getCommandEncoder();this.backend.endComputePass(),d.copyBufferToBuffer(u,0,a.gpuData.buffer,0,s),it("verbose",()=>`[WebGPU] GpuDataManager.upload(id=${e})`),this.buffersForUploadingPending.push(u)}memcpy(e,n){let t=this.storageCache.get(e);if(!t)throw new Error("source gpu data for memcpy does not exist");let o=this.storageCache.get(n);if(!o)throw new Error("destination gpu data for memcpy does not exist");if(t.originalSize!==o.originalSize)throw new Error("inconsistent source and destination gpu data size");let i=Yi(t.originalSize),s=this.backend.getCommandEncoder();this.backend.endComputePass(),s.copyBufferToBuffer(t.gpuData.buffer,0,o.gpuData.buffer,0,i)}registerExternalBuffer(e,n,t){let o;if(t){if(o=this.externalBuffers.get(t),o===void 0)throw new Error("previous buffer is not registered");if(e===t)return it("verbose",()=>`[WebGPU] GpuDataManager.registerExternalBuffer(size=${n}) => id=${o}, buffer is the same, skip.`),o;this.externalBuffers.delete(t)}else o=jh();return this.storageCache.set(o,{gpuData:{id:o,type:0,buffer:e},originalSize:n}),this.externalBuffers.set(e,o),it("verbose",()=>`[WebGPU] GpuDataManager.registerExternalBuffer(size=${n}) => id=${o}, registered.`),o}unregisterExternalBuffer(e){let n=this.externalBuffers.get(e);n!==void 0&&(this.storageCache.delete(n),this.externalBuffers.delete(e),it("verbose",()=>`[WebGPU] GpuDataManager.unregisterExternalBuffer() => id=${n}`))}create(e,n=GPUBufferUsage.STORAGE|GPUBufferUsage.COPY_SRC|GPUBufferUsage.COPY_DST){let t=Yi(e),o,i=(n&GPUBufferUsage.STORAGE)===GPUBufferUsage.STORAGE,s=(n&GPUBufferUsage.UNIFORM)===GPUBufferUsage.UNIFORM;if(i||s){let u=i?this.freeBuffers:this.freeUniformBuffers,l=u.get(t);l||(l=[],u.set(t,l)),l.length>0?o=l.pop():o=this.backend.device.createBuffer({size:t,usage:n})}else o=this.backend.device.createBuffer({size:t,usage:n});let a={id:jh(),type:0,buffer:o};return this.storageCache.set(a.id,{gpuData:a,originalSize:e}),it("verbose",()=>`[WebGPU] GpuDataManager.create(size=${e}) => id=${a.id}`),a}get(e){return this.storageCache.get(e)?.gpuData}release(e){let n=this.storageCache.get(e);if(!n)throw new Error("releasing data does not exist");return it("verbose",()=>`[WebGPU] GpuDataManager.release(id=${e}), gpuDataId=${n.gpuData.id}`),this.storageCache.delete(e),this.buffersPending.push(n.gpuData.buffer),n.originalSize}async download(e,n){let t=this.storageCache.get(e);if(!t)throw new Error("data does not exist");await Ks(this.backend,t.gpuData.buffer,t.originalSize,n)}refreshPendingBuffers(){for(let e of this.buffersForUploadingPending)e.destroy();this.buffersForUploadingPending=[];for(let e of this.buffersPending)(e.usage&GPUBufferUsage.STORAGE)===GPUBufferUsage.STORAGE?this.freeBuffers.get(e.size).push(e):(e.usage&GPUBufferUsage.UNIFORM)===GPUBufferUsage.UNIFORM?this.freeUniformBuffers.get(e.size).push(e):e.destroy();this.buffersPending=[]}dispose(){this.freeBuffers.forEach(e=>{e.forEach(n=>{n.destroy()})}),this.freeUniformBuffers.forEach(e=>{e.forEach(n=>{n.destroy()})}),this.storageCache.forEach(e=>{e.gpuData.buffer.destroy()}),this.storageCache=new Map,this.freeBuffers=new Map,this.freeUniformBuffers=new Map}},Yh=(...r)=>new js(...r)});var Ys,Oe,Tt=D(()=>{"use strict";Ys=class{constructor(e){Object.assign(this,e)}get cacheKey(){return this.key||(this.key=Object.getOwnPropertyNames(this).sort().map(e=>`${this[e]}`).join(";")),this.key}},Oe=r=>new Ys(r)});var Xs,yr,G,pn,Xi,Zi,Ji,Re=D(()=>{"use strict";Xs=class{static calcMatMulShape(e,n){return e[1]!==n[0]?void 0:[e[0],n[1]]}},yr=class{static calcShape(e,n,t=!1){let o=e.length,i=n.length;if(o===0)return n;if(i===0)return e;let s=Math.max(e.length,n.length),a=new Array(s);if(t){if(o<2||i<2)return;let u=Xs.calcMatMulShape([e[o-2],e[o-1]],[n[i-2],n[i-1]]);if(u===void 0)return;[a[s-2],a[s-1]]=u}for(let u=t?3:1;u<=s;u++){let l=o-u<0?1:e[o-u],d=i-u<0?1:n[i-u];if(l!==d&&l>1&&d>1)return;a[s-u]=Math.max(l,d)}return a}static isValidBroadcast(e,n){let t=e.length,o=n.length;if(t>o)return!1;for(let i=1;i<=t;i++)if(e[t-i]!==1&&e[t-i]!==n[o-i])return!1;return!0}},G=class r{static size(e){return r.getSizeFromDimensionRange(e,0,e.length)}static sizeFromDimension(e,n){if(n<0||n>e.length)throw new Error(`invalid dimension of ${n} for sizeFromDimension as Tensor has ${e.length} dimensions.`);return r.getSizeFromDimensionRange(e,n,e.length)}static sizeToDimension(e,n){if(n<0||n>e.length)throw new Error(`invalid dimension of ${n} for sizeToDimension as Tensor has ${e.length} dimensions.`);return r.getSizeFromDimensionRange(e,0,n)}static getSizeFromDimensionRange(e,n,t){let o=1;for(let i=n;i<t;i++){if(e[i]<0)throw new Error("cannot get valid size from specified dimension range. Most likely the range contains negative values in them.");o*=e[i]}return o}static computeStrides(e){let n=e.length;if(n===0)return[];if(n===1)return[1];let t=new Array(n);t[n-1]=1,t[n-2]=e[n-1];for(let o=n-3;o>=0;--o)t[o]=t[o+1]*e[o+1];return t}static normalizeAxis(e,n){if(e<-n&&e>=n)throw new Error("unsupported axis for this operation.");return e<0?e+n:e}static normalizeAxes(e,n){return e.map(t=>this.normalizeAxis(t,n??e.length))}static sortBasedOnPerm(e,n){return n?n.map(t=>e[t]):e.slice().reverse()}static padShape(e,n){let t=e.length;return e.map((o,i)=>o+n[i]+n[i+t])}static areEqual(e,n){return e.length!==n.length?!1:e.every((t,o)=>t===n[o])}},pn=class r{static adjustPoolAttributes(e,n,t,o,i,s){if(!e&&t.length!==n.length-2)throw new Error("length of specified kernel shapes should be 2 less than length of input dimensions");if(e)for(let a=0;a<n.length-2;a++)a>=t.length?t.push(n[a+2]):t[a]=n[a+2];for(let a=0;a<t.length;a++)if(a<o.length){if(o[a]<0)throw new Error("strides should be greater than or equal to 1")}else o.push(1);for(let a=0;a<t.length;a++)if(a<i.length){if(i[a]<0)throw new Error("dilations should be greater than or equal to 1")}else i.push(1);for(let a=0;a<t.length*2;a++)if(a<s.length){if(s[a]<0)throw new Error("pad should be greater than or equal to 1")}else s.push(0);for(let a=0;a<t.length;a++){if(t[a]<=0)throw new Error("kernel shapes need to be greater than 0");if(s[a]>=t[a]||s[a+t.length]>=t[a])throw new Error("pads should be smaller than kernel")}}static adjustPadsBasedOnAutoPad(e,n,t,o,i,s,a){if(a){if(i.length!==2*(e.length-2))throw new Error("length of pads should be twice the length of data dimensions");if(n.length!==e.length-2)throw new Error("length of strides should be the length of data dimensions");if(o.length!==e.length-2)throw new Error("length of kernel shapes should be the length of data dimensions");for(let u=0;u<e.length-2;u++)r.adjustPadAndReturnShape(e[u+(s?1:2)],n[u],t[u],o[u],i,u,u+e.length-2,a)}}static computePoolOutputShape(e,n,t,o,i,s,a){if(n.length<=0)throw new Error("input shape must be of size greater than 0");let u=[n[0],n[1]];return r.computeShapeHelper(e,n,u,t,o,i,s,a),u}static computeConvOutputShape(e,n,t,o,i,s,a){if(e.length<=0||n.length<=0)throw new Error("invalid input tensor dims or invalid filter tensor dims");let u=[e[0],n[0]];return r.computeShapeHelper(!1,e,u,t,o,i,s,a),u}static computeShapeHelper(e,n,t,o,i,s,a,u){if(e)for(let l=0;l<n.length-2;l++)t.push(1);else for(let l=0;l<n.length-2;l++)t.push(r.adjustPadAndReturnShape(n[l+2],o[l],i[l],s[l],a,l,l+n.length-2,u))}static adjustPadAndReturnShape(e,n,t,o,i,s,a,u){let l=t*(o-1)+1;if(u&&u!=="NOTSET")switch(u){case"VALID":return i[s]=0,i[a]=0,Math.floor((e-l)/n+1);case"SAME_LOWER":case"SAME_UPPER":if(t!==1)throw new Error("Dilation not supported for SAME_UPPER or SAME_LOWER");{let f=((e+n-1)/n-1)*n+o-e;return i[s]=Math.floor(u==="SAME_LOWER"?(f+1)/2:f/2),i[a]=f-i[s],Math.floor((e+f-o)/n+1)}default:throw new Error("Unsupported AutoPad type")}else return Math.floor((e+i[s]+i[a]-l)/n+1)}},Xi=class{static getShapeOfGemmResult(e,n,t,o,i){if(e.length!==2||t.length!==2)throw new Error("shape need to be of size 2");let s,a,u;n?(s=e[1],a=e[0]):(s=e[0],a=e[1]);let l=-1;if(o?(u=t[0],l=1):(u=t[1],l=0),t[l]!==a)throw new Error("dimension mismatch");if(s<=0||u<=0||a<=0)throw new Error("invalid shape specified");if(i&&!yr.isValidBroadcast(i,[s,u]))throw new Error("gemm: invalid bias shape for broadcast");return[s,u,a]}},Zi=-34028234663852886e22,Ji=34028234663852886e22});var zx,Js,vt,vr,X,wt,Pt,ur,Ut,Te,Qs,U,J,Qi,Zs,Zh,zn,nt,Be=D(()=>{"use strict";ut();Re();zx=64,Js=(r,e)=>{if(e===3)throw new Error("vec3 has same alignment as vec4, use vec4 instead");switch(r){case 10:return e>1?`vec${e}<f16>`:"f16";case 1:return e>1?`vec${e}<f32>`:"f32";case 6:return e>1?`vec${e}<i32>`:"i32";case 12:return e>1?`vec${e}<u32>`:"u32";case 7:if(e>1)throw new Error("currently not supported vecX of uint64 yet");return["vec2<u32>","i32"];case 13:if(e>1)throw new Error("currently not supported vecX of uint64 yet");return["vec2<u32>","u32"];case 9:if(e!==4)throw new Error("bool must be vec4");return["u32","vec4<bool>"];default:throw new Error(`Unknown data type: ${r}`)}},vt=(r,e=1)=>{let n=Js(r,e);return typeof n=="string"?n:n[0]},vr=(r,e=1)=>{let n=Js(r,e);return typeof n=="string"?n:n[1]},X=r=>r.length===0?[]:[{type:"uint32",data:r},{type:"uint32",data:G.computeStrides(r)}],wt=r=>r%4===0?4:r%2===0?2:1,Pt=(r="f32",e,n="0")=>!e||e===1?`${r}(${n})`:`vec${e}<${r}>(${n})`,ur=(r,e,n)=>r==="f32"?n:e===1?`f32(${n})`:`vec${e}f(${n})`,Ut=(r,e)=>e===4?`(${r}.x + ${r}.y + ${r}.z + ${r}.w)`:e===2?`(${r}.x + ${r}.y)`:e===3?`(${r}.x + ${r}.y + ${r}.z)`:r,Te=(r,e,n)=>r.startsWith("uniforms.")&&n>4?typeof e=="string"?`${r}[(${e}) / 4][(${e}) % 4]`:`${r}[${Math.floor(e/4)}][${e%4}]`:n>1?`${r}[${e}]`:r,Qs=(r,e,n,t,o)=>{let i=typeof n=="number",s=i?n:n.length,a=[...new Array(s).keys()],u=s<2?"u32":s<=4?`vec${s}<u32>`:`array<u32, ${s}>`,l=Js(e,o),d=typeof l=="string"?l:l[1],f=typeof l=="string"?l:l[0],p={indices:u,value:d,storage:f,tensor:e},m=Y=>typeof Y=="string"?Y:`${Y}u`,b={offsetToIndices:!1,indicesToOffset:!1,broadcastedIndicesToOffset:!1,set:!1,setByIndices:!1,get:!1,getByIndices:!1},y=i?"uniforms.":"",$=`${y}${r}_shape`,x=`${y}${r}_strides`,T="";for(let Y=0;Y<s-1;Y++)T+=`
    let dim${Y} = current / ${Te(x,Y,s)};
    let rest${Y} = current % ${Te(x,Y,s)};
    indices[${Y}] = dim${Y};
    current = rest${Y};
    `;T+=`indices[${s-1}] = current;`;let A=s<2?"":`
  fn o2i_${r}(offset: u32) -> ${p.indices} {
    var indices: ${p.indices};
    var current = offset;
    ${T}
    return indices;
  }`,E=Y=>(b.offsetToIndices=!0,s<2?Y:`o2i_${r}(${Y})`),N=[];if(s>=2)for(let Y=s-1;Y>=0;Y--)N.push(`${Te(x,Y,s)} * (indices[${Y}])`);let B=s<2?"":`
  fn i2o_${r}(indices: ${p.indices}) -> u32 {
    return ${N.join("+")};
  }`,F=Y=>(b.indicesToOffset=!0,s<2?Y:`i2o_${r}(${Y})`),P=(...Y)=>s===0?"0u":`${p.indices}(${Y.map(m).join(",")})`,W=(Y,de)=>s<2?`${Y}`:`${Te(Y,de,s)}`,oe=(Y,de,Pe)=>s<2?`${Y}=${Pe};`:`${Te(Y,de,s)}=${Pe};`,H={},re=(Y,de)=>{b.broadcastedIndicesToOffset=!0;let Pe=`${de.name}broadcastedIndicesTo${r}Offset`;if(Pe in H)return`${Pe}(${Y})`;let Gt=[];for(let lt=s-1;lt>=0;lt--){let dt=de.indicesGet("outputIndices",lt+de.rank-s);Gt.push(`${W(x,lt)} * (${dt} % ${W($,lt)})`)}return H[Pe]=`fn ${Pe}(outputIndices: ${de.type.indices}) -> u32 {
             return ${Gt.length>0?Gt.join("+"):"0u"};
           }`,`${Pe}(${Y})`},ie=(Y,de)=>(()=>{if(p.storage===p.value)return`${r}[${Y}]=${de};`;if(p.storage==="vec2<u32>"&&p.value==="i32")return`${r}[${Y}]=vec2<u32>(u32(${de}), select(0u, 0xFFFFFFFFu, ${de} < 0));`;if(p.storage==="vec2<u32>"&&p.value==="u32")return`${r}[${Y}]=vec2<u32>(u32(${de}), 0u);`;if(p.storage==="u32"&&p.value==="vec4<bool>")return`${r}[${Y}]=dot(vec4<u32>(0x1, 0x100, 0x10000, 0x1000000), vec4<u32>(${de}));`;throw new Error(`not supported combination of storage type ${p.storage} and value type ${p.value} yet`)})(),ne=Y=>(()=>{if(p.storage===p.value)return`${r}[${Y}]`;if(p.storage==="vec2<u32>"&&p.value==="i32")return`i32(${r}[${Y}].x)`;if(p.storage==="vec2<u32>"&&p.value==="u32")return`u32(${r}[${Y}].x)`;if(p.storage==="u32"&&p.value==="vec4<bool>")return`vec4<bool>(bool(${r}[${Y}] & 0xFFu), bool(${r}[${Y}] & 0xFF00u), bool(${r}[${Y}] & 0xFF0000u), bool(${r}[${Y}] & 0xFF000000u))`;throw new Error(`not supported combination of storage type ${p.storage} and value type ${p.value} yet`)})(),Ye=s<2?"":`
  fn get_${r}ByIndices(indices: ${p.indices}) -> ${d} {
    return ${ne(`i2o_${r}(indices)`)};
  }`,Ze=s<2?"":(()=>{let Y=a.map(Pe=>`d${Pe}: u32`).join(", "),de=a.map(Pe=>`d${Pe}`).join(", ");return`
  fn get_${r}(${Y}) -> ${d} {
    return get_${r}ByIndices(${P(de)});
  }`})(),Se=(...Y)=>{if(Y.length!==s)throw new Error(`indices length must be ${s}`);let de=Y.map(m).join(",");return s===0?ne("0u"):s===1?ne(de[0]):(b.get=!0,b.getByIndices=!0,b.indicesToOffset=!0,`get_${r}(${de})`)},He=Y=>s<2?ne(Y):(b.getByIndices=!0,b.indicesToOffset=!0,`get_${r}ByIndices(${Y})`),Ie=s<2?"":`
  fn set_${r}ByIndices(indices: ${p.indices}, value: ${d}) {
    ${ie(`i2o_${r}(indices)`,"value")}
  }`,Ce=s<2?"":(()=>{let Y=a.map(Pe=>`d${Pe}: u32`).join(", "),de=a.map(Pe=>`d${Pe}`).join(", ");return`
  fn set_${r}(${Y}, value: ${d}) {
    set_${r}ByIndices(${P(de)}, value);
  }`})();return{impl:()=>{let Y=[],de=!1;return b.offsetToIndices&&(Y.push(A),de=!0),b.indicesToOffset&&(Y.push(B),de=!0),b.broadcastedIndicesToOffset&&(Object.values(H).forEach(Pe=>Y.push(Pe)),de=!0),b.set&&(Y.push(Ce),de=!0),b.setByIndices&&(Y.push(Ie),de=!0),b.get&&(Y.push(Ze),de=!0),b.getByIndices&&(Y.push(Ye),de=!0),!i&&de&&Y.unshift(`const ${$} = ${p.indices}(${n.join(",")});`,`const ${x} = ${p.indices}(${G.computeStrides(n).join(",")});`),Y.join(`
`)},type:p,offsetToIndices:E,indicesToOffset:F,broadcastedIndicesToOffset:re,indices:P,indicesGet:W,indicesSet:oe,set:(...Y)=>{if(Y.length!==s+1)throw new Error(`indices length must be ${s}`);let de=Y[s];if(typeof de!="string")throw new Error("value must be string");let Pe=Y.slice(0,s).map(m).join(",");return s===0?ie("0u",de):s===1?ie(Pe[0],de):(b.set=!0,b.setByIndices=!0,b.indicesToOffset=!0,`set_${r}(${Pe}, ${de})`)},setByOffset:ie,setByIndices:(Y,de)=>s<2?ie(Y,de):(b.setByIndices=!0,b.indicesToOffset=!0,`set_${r}ByIndices(${Y}, ${de});`),get:Se,getByOffset:ne,getByIndices:He,usage:t,name:r,strides:x,shape:$,rank:s}},U=(r,e,n,t=1)=>Qs(r,e,n,"input",t),J=(r,e,n,t=1)=>Qs(r,e,n,"output",t),Qi=(r,e,n,t=1)=>Qs(r,e,n,"internal",t),Zs=class{constructor(e){this.normalizedDispatchGroup=e;this.internalVariables=[];this.variables=[];this.uniforms=[];this.variableIndex=0}guardAgainstOutOfBoundsWorkgroupSizes(e){return`if (global_idx >= ${typeof e=="number"?`${e}u`:e}) { return; }`}mainStart(e=zx){let n=typeof e=="number"?e:e[0],t=typeof e=="number"?1:e[1],o=typeof e=="number"?1:e[2],i=this.normalizedDispatchGroup[1]===1&&this.normalizedDispatchGroup[2]===1,s=i?`@builtin(global_invocation_id) global_id : vec3<u32>,
    @builtin(workgroup_id) workgroup_id : vec3<u32>,
    @builtin(local_invocation_id) local_id : vec3<u32>`:`@builtin(local_invocation_id) local_id : vec3<u32>,
    @builtin(local_invocation_index) local_idx : u32,
    @builtin(workgroup_id) workgroup_id : vec3<u32>,
    @builtin(num_workgroups) num_workgroups : vec3<u32>`,a=i?"let global_idx = global_id.x; let local_idx = local_id.x;":`let global_idx = (workgroup_id.z * num_workgroups[0] * num_workgroups[1] +
          workgroup_id.y * num_workgroups[0] + workgroup_id.x) * ${n*t*o}u + local_idx;`;return`@compute @workgroup_size(${n}, ${t}, ${o})
  fn main(${s}) {
    ${a}
  `}appendVariableUniforms(e){e.rank!==0&&(e.shape.startsWith("uniforms.")&&this.uniforms.push({name:e.shape.replace("uniforms.",""),type:"u32",length:e.rank}),e.strides.startsWith("uniforms.")&&this.uniforms.push({name:e.strides.replace("uniforms.",""),type:"u32",length:e.rank}))}declareVariable(e,n){if(e.usage==="internal")throw new Error("cannot use internal variable with declareVariable(). use registerInternalVariables() instead.");this.variables.push(e),this.appendVariableUniforms(e);let t=e.usage==="input"?"read":"read_write",o=e.type.storage;return`@group(0) @binding(${n}) var<storage, ${t}> ${e.name}: array<${o}>;`}declareVariables(...e){return e.map(n=>this.declareVariable(n,this.variableIndex++)).join(`
`)}registerInternalVariable(e){if(e.usage!=="internal")throw new Error("cannot use input or output variable with registerInternalVariable(). use declareVariables() instead.");this.internalVariables.push(e),this.appendVariableUniforms(e)}registerInternalVariables(...e){return e.forEach(n=>this.registerInternalVariable(n)),this}registerUniform(e,n,t=1){return this.uniforms.push({name:e,type:n,length:t}),this}registerUniforms(e){return this.uniforms=this.uniforms.concat(e),this}uniformDeclaration(){if(this.uniforms.length===0)return"";let e=[];for(let{name:n,type:t,length:o}of this.uniforms)if(o&&o>4)e.push(`${n}:array<vec4<${t}>, ${Math.ceil(o/4)}>`);else{let i=o==null||o===1?t:`vec${o}<${t}>`;e.push(`${n}:${i}`)}return`
      struct Uniforms { ${e.join(", ")} };
      @group(0) @binding(${this.variableIndex}) var<uniform> uniforms: Uniforms;`}get additionalImplementations(){return this.uniformDeclaration()+this.variables.map(e=>e.impl()).join(`
`)+this.internalVariables.map(e=>e.impl()).join(`
`)}},Zh=r=>new Zs(r),zn=(r,e)=>{let n=r.length,t=[];for(let o=0;o<n;o++){let i=n-1-o,s=r[i]||1;(e[e.length-1-o]||1)>1&&s===1&&t.unshift(i)}return t},nt=r=>!0});var Nx,Jh,Lx,Mx,lr,Qh,em,Nn=D(()=>{"use strict";Re();Tt();Be();Nx=r=>{if(!r||r.length!==1)throw new Error("Transpose requires 1 input.")},Jh=(r,e)=>e&&e.length!==r?[...new Array(r).keys()].reverse():e,Lx=(r,e)=>G.sortBasedOnPerm(r,Jh(r.length,e)),Mx=(r,e,n,t)=>{let o=[];o.push(`fn perm(i: ${t.type.indices}) -> ${n.type.indices} {
    var a: ${n.type.indices};`);for(let i=0;i<e;++i)o.push(n.indicesSet("a",r[i],`i[${i}]`));return o.push("return a;}"),o.join(`
`)},lr=(r,e)=>{let n=r.dataType,t=r.dims.length,o=Jh(t,e),i=nt(t),s=Lx(r.dims,o),a=i?s.length:s,u=i?t:r.dims,l=J("output",n,a),d=U("a",n,u),f=p=>`
  ${p.registerUniform("output_size","u32").declareVariables(d,l)}

  ${Mx(o,t,d,l)}

  ${p.mainStart()}
    ${p.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}

    let indices = ${l.offsetToIndices("global_idx")};
    let aIndices = perm(indices);

    ${l.setByOffset("global_idx",d.getByIndices("aIndices"))}
  }`;return{name:"Transpose",shaderCache:{hint:`${e}`,inputDependencies:i?["rank"]:["dims"]},getRunData:p=>{let m=G.size(s);return{outputs:[{dims:s,dataType:p[0].dataType}],dispatchGroup:{x:Math.ceil(m/64)},programUniforms:i?[{type:"uint32",data:m},...X(p[0].dims),...X(s)]:[{type:"uint32",data:m}]}},getShaderSource:f}},Qh=(r,e)=>{Nx(r.inputs),r.compute(lr(r.inputs[0],e.perm))},em=r=>Oe({perm:r.perm})});var Vx,Fx,Ux,Gx,Wx,Hx,qx,jx,Kx,Yx,wr,tm,rm,nm,om,im,am,sm,um,lm,dm,cm=D(()=>{"use strict";Re();Be();ea();Nn();Vx={max:"select(bestValue, candidate, candidate > bestValue)",min:"select(bestValue, candidate, candidate < bestValue)",mean:"bestValue + candidate",sum:"bestValue + candidate",prod:"bestValue * candidate",sumSquare:"bestValue + candidate * candidate",logSumExp:"bestValue + exp(candidate)",l1:"bestValue + abs(candidate)",l2:"bestValue + candidate * candidate",logSum:"bestValue + candidate"},Fx={max:"select(bestValue, candidate, candidate > bestValue)",min:"select(bestValue, candidate, candidate < bestValue)",mean:"bestValue + candidate",sum:"bestValue + candidate",prod:"bestValue * candidate",sumSquare:"bestValue + candidate",logSumExp:"bestValue + candidate",l1:"bestValue + candidate",l2:"bestValue + candidate",logSum:"bestValue + candidate"},Ux={max:"_A[offset]",min:"_A[offset]",mean:"0",sum:"0",prod:"1",sumSquare:"0",logSumExp:"0",l1:"0",l2:"0",logSum:"0"},Gx={max:"bestValue",min:"bestValue",sum:"bestValue",prod:"bestValue",sumSquare:"bestValue",logSumExp:"log(bestValue)",l1:"bestValue",l2:"sqrt(bestValue)",logSum:"log(bestValue)"},Wx=(r,e)=>{let n=[];for(let t=e-r;t<e;++t)n.push(t);return n},Hx=(r,e)=>{let n=[],t=r.length;for(let i=0;i<t;i++)e.indexOf(i)===-1&&n.push(r[i]);let o=e.map(i=>r[i]);return[n,o]},qx=(r,e)=>{let n=r.length+e.length,t=[],o=0;for(let i=0;i<n;i++)e.indexOf(i)===-1?t.push(r[o++]):t.push(1);return t},jx=(r,e)=>{for(let n=0;n<r.length;++n)if(r[r.length-n-1]!==e-1-n)return!1;return!0},Kx=(r,e)=>{let n=[];if(!jx(r,e)){for(let t=0;t<e;++t)r.indexOf(t)===-1&&n.push(t);r.forEach(t=>n.push(t))}return n},Yx=(r,e,n,t,o,i,s)=>{let a=n[0].dims,u=G.size(i),l=G.size(s),d=U("_A",n[0].dataType,a),f=J("output",o,i),p=32,m=`
          var<workgroup> aBestValues : array<${f.type.storage}, ${p}>;
       `;return{name:r,shaderCache:e,getShaderSource:y=>`
        ${y.registerUniform("reduceSize","u32").declareVariables(d,f)}
        ${m}
        fn DIV_CEIL(a : u32, b : u32) -> u32 {
          return ((a - 1u) / b + 1u);
         }
         ${y.mainStart(p)}

          let outputIndex = global_idx / ${p};
          let offset = outputIndex * uniforms.reduceSize;

          var bestValue = ${f.type.storage}(${Ux[t]});
          let Length = uniforms.reduceSize;
          for (var k = local_idx; k < Length; k = k + ${p}) {
           let candidate = ${f.type.storage}(${d.getByOffset("offset + k")});
           bestValue = ${Vx[t]};
          }
          aBestValues[local_idx] = bestValue;
          workgroupBarrier();

         var reduceSize = min(Length, ${p}u);
         for (var currentSize = reduceSize / 2u; reduceSize > 1u;
             currentSize = reduceSize / 2u) {
           let interval = DIV_CEIL(reduceSize, 2u);
           if (local_idx < currentSize) {
            let candidate = aBestValues[local_idx + interval];
            bestValue = ${Fx[t]};
            aBestValues[local_idx] = bestValue;
           }
           reduceSize = interval;
           workgroupBarrier();
         }

         if (local_idx == 0u) {
          ${f.setByOffset("outputIndex",`${t==="mean"?`bestValue / ${f.type.storage}(uniforms.reduceSize)`:`${Gx[t]}`}`)};
         }
        }`,getRunData:()=>({outputs:[{dims:i,dataType:o}],dispatchGroup:{x:u},programUniforms:[{type:"uint32",data:l}]})}},wr=(r,e,n,t)=>{let o=r.inputs.length===1?n:eu(r.inputs,n),i=o.axes;i.length===0&&!o.noopWithEmptyAxes&&(i=r.inputs[0].dims.map((m,b)=>b));let s=G.normalizeAxes(i,r.inputs[0].dims.length),a=s,u=r.inputs[0],l=Kx(a,r.inputs[0].dims.length);l.length>0&&(u=r.compute(lr(r.inputs[0],l),{inputs:[0],outputs:[-1]})[0],a=Wx(a.length,u.dims.length));let[d,f]=Hx(u.dims,a),p=d;o.keepDims&&(p=qx(d,s)),r.compute(Yx(e,{hint:o.cacheKey,inputDependencies:["type"]},[u],t,r.inputs[0].dataType,p,f),{inputs:[u]})},tm=(r,e)=>{wr(r,"ReduceMeanShared",e,"mean")},rm=(r,e)=>{wr(r,"ReduceL1Shared",e,"l1")},nm=(r,e)=>{wr(r,"ReduceL2Shared",e,"l2")},om=(r,e)=>{wr(r,"ReduceLogSumExpShared",e,"logSumExp")},im=(r,e)=>{wr(r,"ReduceMaxShared",e,"max")},am=(r,e)=>{wr(r,"ReduceMinShared",e,"min")},sm=(r,e)=>{wr(r,"ReduceProdShared",e,"prod")},um=(r,e)=>{wr(r,"ReduceSumShared",e,"sum")},lm=(r,e)=>{wr(r,"ReduceSumSquareShared",e,"sumSquare")},dm=(r,e)=>{wr(r,"ReduceLogSumShared",e,"logSum")}});var xr,Xx,ta,eu,Tr,Zx,Jx,Qx,e2,t2,r2,n2,o2,i2,a2,_r,fm,pm,hm,mm,gm,bm,ym,vm,wm,xm,ea=D(()=>{"use strict";Re();Tt();Be();cm();xr=r=>{if(!r||r.length===0||r.length>2)throw new Error("Reduce op requires 1 or 2 inputs.");if(r.length===2&&r[1].dims.length!==1)throw new Error("Invalid axes input dims.")},Xx=r=>["","",`var value = ${r.getByIndices("input_indices")};`,""],ta=(r,e,n,t,o,i,s=!1,a=!1)=>{let u=[],l=n[0].dims,d=l.length,f=G.normalizeAxes(o,d),p=!a&&f.length===0;l.forEach(($,x)=>{p||f.indexOf(x)>=0?s&&u.push(1):u.push($)});let m=u.length,b=G.size(u);return{name:r,shaderCache:e,getShaderSource:$=>{let x=[],T=U("_A",n[0].dataType,d),A=J("output",i,m),E=t(T,A,f),N=E[2];for(let B=0,F=0;B<d;B++)p||f.indexOf(B)>=0?(s&&F++,N=`for(var j${B}: u32 = 0; j${B} < ${l[B]}; j${B}++) {
                  ${E[2].includes("last_index")?`let last_index = j${B};`:""}
                  ${T.indicesSet("input_indices",B,`j${B}`)}
                  ${N}
                }`):(x.push(`${T.indicesSet("input_indices",B,A.indicesGet("output_indices",F))};`),F++);return`

        ${$.registerUniform("output_size","u32").declareVariables(T,A)}

        ${$.mainStart()}
          ${$.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}
          var input_indices: ${T.type.indices};
          let output_indices = ${A.offsetToIndices("global_idx")};

          ${x.join(`
`)}
          ${E[0]}       // init ops for reduce max/min
          ${E[1]}
          ${N}
          ${E[3]}
          ${E.length===4?A.setByOffset("global_idx","value"):E.slice(4).join(`
`)}
        }`},getRunData:()=>({outputs:[{dims:u,dataType:i}],dispatchGroup:{x:Math.ceil(b/64)},programUniforms:[{type:"uint32",data:b},...X(l),...X(u)]})}},eu=(r,e)=>{let n=[];return r[1].dims[0]>0&&r[1].getBigInt64Array().forEach(t=>n.push(Number(t))),Oe({axes:n,keepDims:e.keepDims,noopWithEmptyAxes:e.noopWithEmptyAxes})},Tr=(r,e,n,t)=>{let o=r.inputs,i=o.length===1?n:eu(o,n);r.compute(ta(e,{hint:i.cacheKey,inputDependencies:["rank"]},[o[0]],i.noopWithEmptyAxes&&i.axes.length===0?Xx:t,i.axes,o[0].dataType,i.keepDims,i.noopWithEmptyAxes),{inputs:[0]})},Zx=(r,e)=>{xr(r.inputs),Tr(r,"ReduceLogSum",e,(t,o)=>[`var value = ${o.type.storage}(0);`,"",`value += ${t.getByIndices("input_indices")};`,"value = log(value);"])},Jx=(r,e)=>{xr(r.inputs),Tr(r,"ReduceL1",e,(t,o)=>[`var value = ${o.type.storage}(0);`,"",`value += abs(${t.getByIndices("input_indices")});`,""])},Qx=(r,e)=>{xr(r.inputs),Tr(r,"ReduceL2",e,(t,o)=>[`var t = ${o.type.value}(0); var value = ${o.type.value}(0);`,"",`t = ${t.getByIndices("input_indices")}; value += (t * t);`,"value = sqrt(value);"])},e2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceLogSumExp",e,(t,o)=>[`var value = ${o.type.storage}(0);`,"",`value += exp(${t.getByIndices("input_indices")});`,"value = log(value);"])},t2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceMax",e,(t,o,i)=>{let s=[];for(let a=0;a<t.rank;a++)(i.indexOf(a)>=0||i.length===0)&&s.push(t.indicesSet("input_indices",a,0));return[`${s.join(`
`)}`,`var value = ${t.getByIndices("input_indices")};`,`value = max(value, ${t.getByIndices("input_indices")});`,""]})},r2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceMean",e,(t,o,i)=>{let s=1;for(let a=0;a<t.rank;a++)(i.indexOf(a)>=0||i.length===0)&&(s*=r.inputs[0].dims[a]);return["var sum = f32(0);","",`sum += f32(${t.getByIndices("input_indices")});`,`let value = ${o.type.value}(sum / ${s});`]})},n2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceMin",e,(t,o,i)=>{let s=[];for(let a=0;a<t.rank;a++)(i.indexOf(a)>=0||i.length===0)&&s.push(`input_indices[${a}] = 0;`);return[`${s.join(`
`)}`,`var value = ${t.getByIndices("input_indices")};`,`value = min(value, ${t.getByIndices("input_indices")});`,""]})},o2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceProd",e,(t,o)=>[`var value = ${o.type.storage}(1);`,"",`value *= ${t.getByIndices("input_indices")};`,""])},i2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceSum",e,(t,o)=>[`var value = ${o.type.storage}(0);`,"",`value += ${t.getByIndices("input_indices")};`,""])},a2=(r,e)=>{xr(r.inputs),Tr(r,"ReduceSumSquare",e,(t,o)=>[`var t = ${o.type.value}(0); var value = ${o.type.value}(0);`,"",`t = ${t.getByIndices("input_indices")}; value += t * t;`,""])},_r=(r,e,n)=>{if(e.length===0)return n;let t=1,o=1;for(let i=0;i<e.length;i++)e.indexOf(i)===-1?t*=r[i]:o*=r[i];return o<32&&t>1024},fm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?r2(r,e):tm(r,e)},pm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?Jx(r,e):rm(r,e)},hm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?Qx(r,e):nm(r,e)},mm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?e2(r,e):om(r,e)},gm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?t2(r,e):im(r,e)},bm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?n2(r,e):am(r,e)},ym=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?o2(r,e):sm(r,e)},vm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?i2(r,e):um(r,e)},wm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?a2(r,e):lm(r,e)},xm=(r,e)=>{_r(r.inputs[0].dims,e.axes,e.noopWithEmptyAxes)?Zx(r,e):dm(r,e)}});var Tm,_m,$m,tu,Sm=D(()=>{"use strict";ut();Tt();ea();Tm=r=>{if(!r||r.length===0||r.length>2)throw new Error("ArgMinMaxOp op requires 1 or 2 inputs.");if(r[0].dataType!==1)throw new Error("Invalid input type.")},_m=(r,e)=>{Tm(r.inputs);let n=(t,o,i)=>{let s=[];for(let a=0;a<t.rank;a++)(i.indexOf(a)>=0||i.length===0)&&s.push(`input_indices[${a}] = 0;`);return[`${s.join(`
`)}`,`var value = ${t.getByIndices("input_indices")};
var best_index : i32 = 0;`,`if (${t.getByIndices("input_indices")} ${e.selectLastIndex>0?"<=":"<"} value) {
         value = ${t.getByIndices("input_indices")};
         best_index = i32(last_index);
       }`,"",o.setByOffset("global_idx","best_index")]};r.compute(ta("ArgMin",{hint:e.cacheKey,inputDependencies:["rank"]},[r.inputs[0]],n,[e.axis],7,e.keepDims),{inputs:[0]})},$m=(r,e)=>{Tm(r.inputs);let n=(t,o,i)=>{let s=[];for(let a=0;a<t.rank;a++)(i.indexOf(a)>=0||i.length===0)&&s.push(`input_indices[${a}] = 0;`);return[`${s.join(`
`)}`,`var value = ${t.getByIndices("input_indices")};
var best_index : i32 = 0;`,`if (${t.getByIndices("input_indices")} ${e.selectLastIndex>0?">=":">"} value) {
         value = ${t.getByIndices("input_indices")};
         best_index = i32(last_index);
       }`,"",o.setByOffset("global_idx","best_index")]};r.compute(ta("argMax",{hint:e.cacheKey,inputDependencies:["rank"]},[r.inputs[0]],n,[e.axis],7,e.keepDims),{inputs:[0]})},tu=r=>Oe(r)});var s2,u2,l2,d2,ra,c2,Im,ru=D(()=>{"use strict";ut();Ki();Be();s2=(r,e)=>{let n=r[0],t=r[1],o=r[2],i=r[3],s=r[4],a=r[5];if(s&&a)throw new Error("Attention cannot have both past and relative_position_bias");if(n.dims.length!==3)throw new Error('Input "input" must have 3 dimensions');let u=n.dims[0],l=n.dims[1],d=n.dims[2];if(o.dims.length!==1)throw new Error('Input "bias" is expected to have 1 dimensions');if(t.dims.length!==2)throw new Error('Input "weights" is expected to have 2 dimensions');if(t.dims[0]!==d)throw new Error("Input 1 dimension 0 should have same length as dimension 2 of input 0");if(o.dims[0]!==t.dims[1])throw new Error('Input "bias" dimension 0 should have same length as dimension 1 of input "weights"');let f=o.dims[0]/3,p=f,m=p;if(e.qkvHiddenSizes.length>0){if(e.qkvHiddenSizes.length!==3)throw new Error("qkv_hidden_sizes attribute should have 3 elements");for(let A of e.qkvHiddenSizes)if(A%e.numHeads!==0)throw new Error("qkv_hidden_sizes should be divisible by num_heads");f=e.qkvHiddenSizes[0],p=e.qkvHiddenSizes[1],m=e.qkvHiddenSizes[2]}let b=l;if(f!==p)throw new Error("qkv_hidden_sizes first element should be same as the second");if(o.dims[0]!==f+p+m)throw new Error('Input "bias" dimension 0 should have same length as sum of Q/K/V hidden sizes');let y=0;if(s){if(p!==m)throw new Error('Input "past" expect k_hidden_size == v_hidden_size');if(s.dims.length!==5)throw new Error('Input "past" must have 5 dimensions');if(s.dims[0]!==2)throw new Error('Input "past" first dimension must be 2');if(s.dims[1]!==u)throw new Error('Input "past" second dimension must be batch_size');if(s.dims[2]!==e.numHeads)throw new Error('Input "past" third dimension must be num_heads');if(s.dims[4]!==p/e.numHeads)throw new Error('Input "past" fifth dimension must be k_hidden_size / num_heads');e.pastPresentShareBuffer||(y=s.dims[3])}let $=b+y,x=-1,T=0;if(i)throw new Error("Mask not supported");if(s)throw new Error("past is not supported");if(a)throw new Error("relativePositionBias is not supported");return{batchSize:u,sequenceLength:l,pastSequenceLength:y,kvSequenceLength:b,totalSequenceLength:$,maxSequenceLength:x,inputHiddenSize:d,hiddenSize:f,vHiddenSize:m,headSize:Math.floor(f/e.numHeads),vHeadSize:Math.floor(m/e.numHeads),numHeads:e.numHeads,isUnidirectional:!1,pastPresentShareBuffer:!1,maskFilterValue:e.maskFilterValue,maskType:T,scale:e.scale,broadcastResPosBias:!1,passPastInKv:!1,qkvFormat:1}},u2=(r,e,n,t)=>{let o=wt(t),i=64,s=t/o;s<i?i=1:s/8<64&&(i=Math.ceil(s/8));let a=Math.ceil(t/o/i),l=[{type:Ft(e.dataType),data:1/t},{type:"uint32",data:s},{type:"uint32",data:a}],d=vt(e.dataType,o),f=p=>{let m=J("x",e.dataType,e.dims,o),b="thread_max_vector";o===2?b="max(thread_max_vector.x, thread_max_vector.y)":o===4&&(b="max(max(thread_max_vector.x, thread_max_vector.y), max(thread_max_vector.z, thread_max_vector.w))");let y=vr(e.dataType),$=[{name:"d_inv",type:y},{name:"d_comp",type:"u32"},{name:"elements_per_wg",type:"u32"}];return`
  var<workgroup> wgMax: array<f32, ${i}>;
  var<workgroup> wgSum: array<f32, ${i}>;
  ${p.registerUniforms($).declareVariables(m)}
  ${p.mainStart([i,1,1])}
    let localOffset = local_idx * uniforms.elements_per_wg;
    let offset: u32 = workgroup_id.x * uniforms.d_comp + localOffset;

    var thread_max_vector = ${Pt("f32",o,"-3.402823e+38f")};
    for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {
      thread_max_vector = max(${ur(y,o,"x[offset + i]")}, thread_max_vector);
    }
    wgMax[local_idx] = ${b};
    workgroupBarrier();

    var maxValue = -3.402823e+38f;
    for (var i = 0u; i < ${i}; i++) {
      maxValue = max(wgMax[i], maxValue);
    }

    var sumVector = ${Pt("f32",o,"0")};
    for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {
      sumVector += exp(${ur(y,o,"x[offset + i]")} - maxValue);
    }
    wgSum[local_idx] = ${Ut("sumVector",o)};
    workgroupBarrier();

    var sum: f32 = 0;
    for (var i = 0u; i < ${i}; i++) {
      sum += wgSum[i];
    }

    if (sum == 0) {
      for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {
        x[offset + i] = ${Pt("f32",o,"uniforms.d_inv")};
      }
    } else {
      for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {
        let f32input = ${ur(y,o,"x[offset + i]")};
        x[offset + i] = ${m.type.value}(exp(f32input - maxValue) / sum);
      }
    }
  }`};r.compute({name:"AttentionProbsSoftmax",shaderCache:{hint:`${i};${d};${o}`},getShaderSource:f,getRunData:()=>({outputs:[],dispatchGroup:{x:n},programUniforms:l})},{inputs:[e],outputs:[]})},l2=(r,e,n,t,o,i)=>{let s=[o.batchSize,o.numHeads,o.sequenceLength,o.kvSequenceLength+o.pastSequenceLength],a=i.scale===0?1/Math.sqrt(o.headSize):i.scale,u=wt(o.headSize),l=o.headSize/u,d=12,f={x:Math.ceil(o.totalSequenceLength/d),y:Math.ceil(o.sequenceLength/d),z:o.batchSize*o.numHeads},p=Ft(e.dataType),m=[{type:"uint32",data:o.sequenceLength},{type:"uint32",data:l},{type:"uint32",data:o.totalSequenceLength},{type:"uint32",data:o.kvSequenceLength},{type:p,data:a}],b=[e,n],y=x=>{let T=U("q",e.dataType,e.dims,u),A=U("key",n.dataType,n.dims,u),E=J("output",e.dataType,s),N=vt(e.dataType),B=[{name:"M",type:"u32"},{name:"K",type:"u32"},{name:"N",type:"u32"},{name:"kv_sequence_length",type:"u32"},{name:"alpha",type:N}];return`
  const beta: ${N} = 1.0;
  const TILE_SIZE = ${d}u;

  var<workgroup> tileQ: array<${T.type.storage}, ${d*d}>;
  var<workgroup> tileK: array<${T.type.storage}, ${d*d}>;
  ${x.registerUniforms(B).declareVariables(T,A,E)}
  ${x.mainStart([d,d,1])}
    // x holds the N and y holds the M
    let headIdx = workgroup_id.z;
    let m = workgroup_id.y * TILE_SIZE;
    let n = workgroup_id.x * TILE_SIZE;
    let lm = m + local_id.y;
    let ln = n + local_id.x;

    let qOffset = uniforms.M * uniforms.K * headIdx + m * uniforms.K;
    let kOffset = uniforms.kv_sequence_length * uniforms.K * headIdx + n * uniforms.K;

    var value = ${Pt(N,u)};
    for (var w: u32 = 0u; w < uniforms.K; w += TILE_SIZE) {
      if (m + local_id.y < uniforms.M && w + local_id.x < uniforms.K) {
        tileQ[TILE_SIZE * local_id.y + local_id.x] = q[qOffset + local_id.y * uniforms.K + w + local_id.x];
      }
      if (n + local_id.y < uniforms.N && w + local_id.x < uniforms.K) {
        tileK[TILE_SIZE * local_id.y + local_id.x] = key[kOffset + local_id.y * uniforms.K + w + local_id.x];
      }
      workgroupBarrier();

      for (var k: u32 = 0u; k<TILE_SIZE && w+k < uniforms.K; k++) {
        value += tileQ[TILE_SIZE * local_id.y + k] * tileK[TILE_SIZE * local_id.x + k];
      }

      workgroupBarrier();
    }

    let headOffset = headIdx * uniforms.M * uniforms.N;
    if (lm < uniforms.M && ln < uniforms.N) {
      let outputIdx = headOffset + lm * uniforms.N + ln;
      output[outputIdx] = ${Ut("value",u)} * uniforms.alpha;
    }
  }`},$=r.compute({name:"AttentionProbs",shaderCache:{hint:`${u}`,inputDependencies:["type","type"]},getRunData:()=>({outputs:[{dims:s,dataType:e.dataType,gpuDataType:0}],dispatchGroup:f,programUniforms:m}),getShaderSource:y},{inputs:b,outputs:[-1]})[0];return u2(r,$,o.batchSize*o.numHeads*o.sequenceLength,o.totalSequenceLength),$},d2=(r,e,n,t)=>{let o=[t.batchSize,t.sequenceLength,t.vHiddenSize],i=12,s={x:Math.ceil(t.vHeadSize/i),y:Math.ceil(t.sequenceLength/i),z:t.batchSize*t.numHeads},a=[{type:"uint32",data:t.sequenceLength},{type:"uint32",data:t.totalSequenceLength},{type:"uint32",data:t.vHeadSize},{type:"uint32",data:t.numHeads},{type:"uint32",data:t.vHiddenSize}],u=l=>{let d=U("probs",e.dataType,e.dims),f=U("v",n.dataType,n.dims),p=J("output",e.dataType,o),m=[{name:"M",type:"u32"},{name:"K",type:"u32"},{name:"N",type:"u32"},{name:"num_heads",type:"u32"},{name:"v_hidden_size",type:"u32"}];return`
  const TILE_SIZE = ${i}u;
  var<workgroup> tileQ: array<${d.type.value}, ${i*i}>;
  var<workgroup> tileK: array<${d.type.value}, ${i*i}>;
  ${l.registerUniforms(m).declareVariables(d,f,p)}
  ${l.mainStart([i,i,1])}
   let headIdx = workgroup_id.z;
   let m = workgroup_id.y * TILE_SIZE + local_id.y;
   let n = workgroup_id.x * TILE_SIZE + local_id.x;

   let offsetA = headIdx * (uniforms.M * uniforms.K) + m * uniforms.K;
   let offsetB = headIdx * (uniforms.N * uniforms.K) + n;

   var value = ${d.type.storage}(0);
   for (var w: u32 = 0u; w < uniforms.K; w += TILE_SIZE) {
     if (m < uniforms.M && w + local_id.x < uniforms.K) {
       tileQ[TILE_SIZE * local_id.y + local_id.x] = probs[offsetA + w + local_id.x];
     }
     if (n < uniforms.N && w + local_id.y < uniforms.K) {
       tileK[TILE_SIZE * local_id.y + local_id.x] = v[offsetB + (w + local_id.y) * uniforms.N];
     }
     workgroupBarrier();
     for (var k: u32 = 0u; k<TILE_SIZE && w+k < uniforms.K; k++) {
       value += tileQ[TILE_SIZE * local_id.y + k] * tileK[TILE_SIZE * k + local_id.x];
     }
     workgroupBarrier();
   }

   // we need to transpose output from BNSH_v to BSND_v
   let batchIdx = workgroup_id.z / uniforms.num_heads;
   let currentBatchHeadNumber = workgroup_id.z % uniforms.num_heads;
   let headOffset = (batchIdx * uniforms.M * uniforms.num_heads + currentBatchHeadNumber) * uniforms.N;
   if (m < uniforms.M && n < uniforms.N) {
     let outputIdx = batchIdx * uniforms.M *uniforms.v_hidden_size + m * uniforms.v_hidden_size
       + currentBatchHeadNumber * uniforms.N + n;
     output[outputIdx] = value;
   }
  }`};return r.compute({name:"AttentionScore",shaderCache:{inputDependencies:["type","type"]},getRunData:()=>({outputs:[{dims:o,dataType:e.dataType,gpuDataType:0}],dispatchGroup:s,programUniforms:a}),getShaderSource:u},{inputs:[e,n],outputs:[0]})[0]},ra=(r,e,n,t,o,i,s,a,u,l,d)=>{let f=l2(r,e,n,u,l,d);d2(r,f,t,l)},c2=(r,e)=>{let n=[e.batchSize,e.numHeads,e.sequenceLength,e.headSize],t=e.sequenceLength,o=e.inputHiddenSize,i=e.headSize,s=12,a={x:Math.ceil(e.headSize/s),y:Math.ceil(e.sequenceLength/s),z:e.batchSize*e.numHeads},u=[r.inputs[0],r.inputs[1],r.inputs[2]],l=[{type:"uint32",data:t},{type:"uint32",data:o},{type:"uint32",data:i},{type:"uint32",data:e.numHeads},{type:"uint32",data:e.headSize},{type:"uint32",data:e.hiddenSize},{type:"uint32",data:e.hiddenSize+e.hiddenSize+e.vHiddenSize}],d=f=>{let p=J("output_q",u[0].dataType,n),m=J("output_k",u[0].dataType,n),b=J("output_v",u[0].dataType,n),y=U("input",u[0].dataType,u[0].dims),$=U("weight",u[1].dataType,u[1].dims),x=U("bias",u[2].dataType,u[2].dims),T=y.type.storage,A=[{name:"M",type:"u32"},{name:"K",type:"u32"},{name:"N",type:"u32"},{name:"num_heads",type:"u32"},{name:"head_size",type:"u32"},{name:"hidden_size",type:"u32"},{name:"ldb",type:"u32"}];return`
  const TILE_SIZE = ${s}u;
  var<workgroup> tileInput: array<${T}, ${s*s}>;
  var<workgroup> tileWeightQ: array<${T}, ${s*s}>;
  var<workgroup> tileWeightK: array<${T}, ${s*s}>;
  var<workgroup> tileWeightV: array<${T}, ${s*s}>;
  ${f.registerUniforms(A).declareVariables(y,$,x,p,m,b)}
  ${f.mainStart([s,s,1])}
    let batchIndex = workgroup_id.z / uniforms.num_heads;
    let headNumber = workgroup_id.z % uniforms.num_heads;
    let m = workgroup_id.y * TILE_SIZE + local_id.y;
    let n = workgroup_id.x * TILE_SIZE + local_id.x;

    let inputOffset = batchIndex * (uniforms.M * uniforms.K) + m * uniforms.K;
    let biasOffsetQ = headNumber * uniforms.head_size;
    let biasOffsetK = uniforms.hidden_size + biasOffsetQ;
    let biasOffsetV = uniforms.hidden_size + biasOffsetK;

    var valueQ = ${T}(0);
    var valueK = ${T}(0);
    var valueV = ${T}(0);
    for (var w: u32 = 0u; w < uniforms.K; w += TILE_SIZE) {
      if (m < uniforms.M && w + local_id.x < uniforms.K) {
        tileInput[TILE_SIZE * local_id.y + local_id.x] = input[inputOffset + w + local_id.x];
      }
      if (n < uniforms.N && w + local_id.y < uniforms.K) {
        let offset = n + (w + local_id.y) * uniforms.ldb;
        tileWeightQ[TILE_SIZE * local_id.y + local_id.x] = weight[biasOffsetQ + offset];
        tileWeightK[TILE_SIZE * local_id.y + local_id.x] = weight[biasOffsetK + offset];
        tileWeightV[TILE_SIZE * local_id.y + local_id.x] = weight[biasOffsetV + offset];
      }
      workgroupBarrier();
      for (var k: u32 = 0u; k<TILE_SIZE && w+k < uniforms.K; k++) {
        let inputTileOffset = TILE_SIZE * local_id.y + k;
        let weightTileOffset = TILE_SIZE * k + local_id.x;
        valueQ += tileInput[inputTileOffset] * tileWeightQ[weightTileOffset];
        valueK += tileInput[inputTileOffset] * tileWeightK[weightTileOffset];
        valueV += tileInput[inputTileOffset] * tileWeightV[weightTileOffset];
      }

      workgroupBarrier();
    }

    let headOffset = (m * uniforms.N + n) % uniforms.head_size;
    valueQ += bias[headOffset + biasOffsetQ];
    valueK += bias[headOffset + biasOffsetK];
    valueV += bias[headOffset + biasOffsetV];

    let offset = workgroup_id.z * uniforms.M * uniforms.N;
    if (m < uniforms.M && n < uniforms.N) {
      let outputIdx = offset + m * uniforms.N + n;
      output_q[outputIdx] = valueQ;
      output_k[outputIdx] = valueK;
      output_v[outputIdx] = valueV;
    }
  }`};return r.compute({name:"AttentionPrepare",shaderCache:{inputDependencies:["type","type","type"]},getRunData:()=>({outputs:[{dims:n,dataType:r.inputs[0].dataType,gpuDataType:0},{dims:n,dataType:r.inputs[0].dataType,gpuDataType:0},{dims:n,dataType:r.inputs[0].dataType,gpuDataType:0}],dispatchGroup:a,programUniforms:l}),getShaderSource:d},{inputs:u,outputs:[-1,-1,-1]})},Im=(r,e)=>{let n=s2(r.inputs,e),[t,o,i]=c2(r,n);return ra(r,t,o,i,r.inputs[4],void 0,void 0,void 0,r.inputs[5],n,e)}});var f2,p2,h2,Am,Om=D(()=>{"use strict";Et();Re();Tt();Be();f2=(r,e)=>{if(!r||r.length!==5)throw new Error("BatchNormalization requires 5 inputs");let n=(t,o,i)=>{let s=o.length;if(s!==t.length)throw new Error(`${i}: num dimensions != ${s}`);o.forEach((a,u)=>{if(a!==t[u])throw new Error(`${i}: dim[${u}] do not match`)})};if(r[0].dims.length>1){let t=e.format==="NHWC"?e.spatial?r[0].dims.slice(-1):r[0].dims.slice(-1).concat(r[0].dims.slice(1,r[0].dims.length-1)):r[0].dims.slice(1,e.spatial?2:void 0);n(r[1].dims,t,"Invalid input scale"),n(r[2].dims,t,"Invalid input B"),n(r[3].dims,t,"Invalid input mean"),n(r[4].dims,t,"Invalid input var")}else n(r[1].dims,[1],"Invalid input scale"),n(r[2].dims,[1],"Invalid input B"),n(r[3].dims,[1],"Invalid input mean"),n(r[4].dims,[1],"Invalid input var")},p2=(r,e)=>{let{epsilon:n,spatial:t,format:o}=e,i=r[0].dims,s=t?wt(i[i.length-1]):1,a=o==="NHWC"&&i.length>1?s:1,u=G.size(i)/s,l=nt(i.length)&&t,d=l?i.length:i,f=U("x",r[0].dataType,r[0].dims,s),p=U("scale",r[1].dataType,r[1].dims,a),m=U("bias",r[2].dataType,r[2].dims,a),b=U("inputMean",r[3].dataType,r[3].dims,a),y=U("inputVar",r[4].dataType,r[4].dims,a),$=J("y",r[0].dataType,d,s),x=()=>{let A="";if(t)A=`let cOffset = ${i.length===1?"0u":o==="NHWC"?`outputIndices[${i.length-1}] / ${s}`:"outputIndices[1]"};`;else if(o==="NCHW")A=`
            ${$.indicesSet("outputIndices","0","0")}
            let cOffset = ${$.indicesToOffset("outputIndices")};`;else{A=`var cIndices = ${p.type.indices}(0);
                       cIndices[0] = outputIndices[${i.length-1}];`;for(let E=1;E<p.rank;E++)A+=`cIndices[${E}] = outputIndices[${E}];`;A+=`let cOffset = ${p.indicesToOffset("cIndices")};`}return A},T=A=>`
  const epsilon = ${n};
  ${A.registerUniform("outputSize","u32").declareVariables(f,p,m,b,y,$)}
  ${A.mainStart()}
  ${A.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
    var outputIndices = ${$.offsetToIndices(`global_idx * ${s}`)};
    ${x()}
    let scale = ${p.getByOffset("cOffset")};
    let bias = ${m.getByOffset("cOffset")};
    let inputMean = ${b.getByOffset("cOffset")};
    let inputVar = ${y.getByOffset("cOffset")};
    let x = ${f.getByOffset("global_idx")};
    let value = (x - inputMean) * inverseSqrt(inputVar + epsilon) * scale + bias;
    ${$.setByOffset("global_idx","value")}
  }`;return{name:"BatchNormalization",shaderCache:{hint:`${e.epsilon}_${e.format}_${t}_${s}`,inputDependencies:l?["rank","type","type","type","type"]:void 0},getShaderSource:T,getRunData:()=>({outputs:[{dims:r[0].dims,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(u/64)},programUniforms:l?[{type:"uint32",data:u},...X(i)]:[{type:"uint32",data:u}]})}},h2=r=>Oe(r),Am=(r,e)=>{let{inputs:n,outputCount:t}=r,o=h2({...e,outputCount:t});if(be.webgpu.validateInputContent&&f2(n,o),e.trainingMode)throw new Error("BatchNormalization trainingMode is not supported yet.");r.compute(p2(n,o))}});var m2,g2,Em,Cm=D(()=>{"use strict";Re();Be();m2=r=>{if(r[0].dims.length!==3)throw new Error("input should have 3 dimensions");if(![320,640,1280].includes(r[0].dims[2]))throw new Error("number of channels should be 320, 640 or 1280");if(r[1].dims.length!==1)throw new Error("bias is expected to have 1 dimensions");if(r[0].dims[2]!==r[1].dims[0])throw new Error("last dimension of input and bias are not the same")},g2=r=>{let e=r[0].dims,n=r[0].dims[2],t=G.size(e)/4,o=r[0].dataType,i=U("input",o,e,4),s=U("bias",o,[n],4),a=U("residual",o,e,4),u=J("output",o,e,4);return{name:"BiasAdd",getRunData:()=>({outputs:[{dims:e,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(t/64)}}),getShaderSource:d=>`
  const channels = ${n}u / 4;
  ${d.declareVariables(i,s,a,u)}

  ${d.mainStart()}
    ${d.guardAgainstOutOfBoundsWorkgroupSizes(t)}
    let value = ${i.getByOffset("global_idx")}
      + ${s.getByOffset("global_idx % channels")} + ${a.getByOffset("global_idx")};
    ${u.setByOffset("global_idx","value")}
  }`}},Em=r=>{m2(r.inputs),r.compute(g2(r.inputs))}});var b2,je,Pm,km,Dm,Bm,Rm,zm,Nm,Lm,Mm,y2,Vm,Fm,Um,Gm,na,Wm,oa,Hm,qm,jm,Km,Ym,Xm,Zm,Jm,Qm,eg,tg,rg,ng,og,ig,ag,sg,nu=D(()=>{"use strict";ut();Re();Tt();Be();b2=(r,e,n,t,o,i)=>{let s=Math.ceil(e/4),a="";typeof o=="string"?a=`${o}(a)`:a=o("a");let u=U("inputData",n,[s],4),l=J("outputData",t,[s],4);return`
      ${r.registerUniform("vec_size","u32").declareVariables(u,l)}

  ${i??""}

  ${r.mainStart()}
    ${r.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}

    let a = ${u.getByOffset("global_idx")};
    ${l.setByOffset("global_idx",a)}
  }`},je=(r,e,n,t,o,i=r.dataType)=>({name:e,shaderCache:{hint:o,inputDependencies:["type"]},getShaderSource:s=>b2(s,G.size(r.dims),r.dataType,i,n,t),getRunData:s=>({outputs:[{dims:r.dims,dataType:i}],dispatchGroup:{x:Math.ceil(G.size(s[0].dims)/64/4)},programUniforms:[{type:"uint32",data:Math.ceil(G.size(r.dims)/4)}]})}),Pm=r=>{r.compute(je(r.inputs[0],"Abs","abs"))},km=r=>{r.compute(je(r.inputs[0],"Acos","acos"))},Dm=r=>{r.compute(je(r.inputs[0],"Acosh","acosh"))},Bm=r=>{r.compute(je(r.inputs[0],"Asin","asin"))},Rm=r=>{r.compute(je(r.inputs[0],"Asinh","asinh"))},zm=r=>{r.compute(je(r.inputs[0],"Atan","atan"))},Nm=r=>{r.compute(je(r.inputs[0],"Atanh","atanh"))},Lm=r=>Oe(r),Mm=(r,e)=>{let n;switch(e.to){case 10:n="vec4<f16>";break;case 1:n="vec4<f32>";break;case 12:n="vec4<u32>";break;case 6:n="vec4<i32>";break;case 9:n="vec4<bool>";break;default:throw new RangeError(`not supported type (specified in attribute 'to' from 'Cast' operator): ${e.to}`)}r.compute(je(r.inputs[0],"Cast",n,void 0,e.cacheKey,e.to))},y2=r=>{let e=r.length>=2&&r[1].data!==0?r[1].getFloat32Array()[0]:Zi,n=r.length>=3&&r[2].data!==0?r[2].getFloat32Array()[0]:Ji;return Oe({min:e,max:n})},Vm=(r,e)=>{let n=r.inputs.length===1?e:y2(r.inputs),t=vr(r.inputs[0].dataType);r.compute(je(r.inputs[0],"Clip",o=>`clamp(${o}, clip_min_, clip_max_)`,`
    const clip_min_: vec4<${t}> = vec4(${t}(${n.min}));
    const clip_max_: vec4<${t}> = vec4(${t}(${n.max}));
`,n.cacheKey),{inputs:[0]})},Fm=r=>{r.compute(je(r.inputs[0],"Ceil","ceil"))},Um=r=>{r.compute(je(r.inputs[0],"Cos","cos"))},Gm=r=>{r.compute(je(r.inputs[0],"Cosh","cosh"))},na=r=>Oe(r),Wm=(r,e)=>{let n=vr(r.inputs[0].dataType);r.compute(je(r.inputs[0],"Elu",t=>`elu_vf32(${t})`,`
  const elu_alpha_ = ${n}(${e.alpha});

  fn elu_f32(a: ${n}) -> ${n} {
  return select((exp(a) - 1.0) * elu_alpha_, a, a >= 0.0);
  }

  fn elu_vf32(v: vec4<${n}>) -> vec4<${n}> {
  return vec4(elu_f32(v.x), elu_f32(v.y), elu_f32(v.z), elu_f32(v.w));
  }`,e.cacheKey))},oa=(r,e="f32")=>`
const r0: ${e} = 0.3275911;
const r1: ${e} = 0.254829592;
const r2: ${e} = -0.284496736;
const r3: ${e} = 1.421413741;
const r4: ${e} = -1.453152027;
const r5: ${e} = 1.061405429;

fn erf_vf32(v: ${r}) -> ${r} {
  let absv = abs(v);
  let x = 1.0 / (1.0 + r0 * absv);
  return sign(v) * (1.0 - ((((r5 * x + r4) * x + r3) * x + r2) * x + r1) * x * exp(-absv * absv));
}`,Hm=r=>{let e=vr(r.inputs[0].dataType);r.compute(je(r.inputs[0],"Erf",n=>`erf_vf32(${n})`,oa(`vec4<${e}>`,e)))},qm=r=>{r.compute(je(r.inputs[0],"Exp","exp"))},jm=r=>{r.compute(je(r.inputs[0],"Floor","floor"))},Km=r=>{let e=vr(r.inputs[0].dataType);r.compute(je(r.inputs[0],"Gelu",n=>`0.5 * ${n} * (1.0 + erf_vf32(${n} * 0.7071067811865475))`,oa(`vec4<${e}>`,e)))},Ym=(r,e)=>{let n=vr(r.inputs[0].dataType);r.compute(je(r.inputs[0],"LeakyRelu",t=>`select(leaky_relu_alpha_ * ${t}, ${t}, ${t} >= vec4<${n}>(0.0))`,`const leaky_relu_alpha_ = ${n}(${e.alpha});`,e.cacheKey))},Xm=r=>{r.compute(je(r.inputs[0],"Not",e=>`!${e}`))},Zm=r=>{r.compute(je(r.inputs[0],"Neg",e=>`-${e}`))},Jm=r=>{r.compute(je(r.inputs[0],"Reciprocal",e=>`1.0/${e}`))},Qm=r=>{let e=vr(r.inputs[0].dataType);r.compute(je(r.inputs[0],"Relu",n=>`select(vec4<${e}>(0.0), ${n}, ${n} > vec4<${e}>(0.0))`))},eg=r=>{r.compute(je(r.inputs[0],"Sigmoid",e=>`(1.0 / (1.0 + exp(-${e})))`))},tg=r=>{r.compute(je(r.inputs[0],"Sin","sin"))},rg=r=>{r.compute(je(r.inputs[0],"Sinh","sinh"))},ng=r=>{r.compute(je(r.inputs[0],"Sqrt","sqrt"))},og=r=>{r.compute(je(r.inputs[0],"Tan","tan"))},ig=r=>{r.compute(je(r.inputs[0],"Tanh","tanh"))},ag=(r,e)=>{let n=vr(r.inputs[0].dataType);return r.compute(je(r.inputs[0],"ThresholdedRelu",t=>`select(vec4<${n}>(0.0), ${t}, ${t} > thresholded_relu_alpha_)`,`const thresholded_relu_alpha_ = vec4<${n}>(${e.alpha});`,e.cacheKey)),0},sg=r=>{r.compute(je(r.inputs[0],"Log","log"))}});var w2,x2,ug,lg=D(()=>{"use strict";Re();Be();nu();w2=r=>{if(r[0].dims.length!==3)throw new Error("input should have 3 dimensions");if(![2560,5120,10240].includes(r[0].dims[2]))throw new Error("hidden state should be 2560, 5120 or 10240");if(r[1].dims.length!==1)throw new Error("bias is expected to have 1 dimensions");if(r[0].dims[2]!==r[1].dims[0])throw new Error("last dimension of input and bias are not the same")},x2=r=>{let e=r[0].dims.slice();e[2]=e[2]/2;let n=U("input",r[0].dataType,r[0].dims,4),t=U("bias",r[0].dataType,[r[0].dims[2]],4),o=J("output",r[0].dataType,e,4),i=G.size(e)/4,s=vt(r[0].dataType);return{name:"BiasSplitGelu",getRunData:()=>({outputs:[{dims:e,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(i/64)}}),getShaderSource:u=>`
  const M_SQRT2 = sqrt(2.0);
  const halfChannels = ${r[0].dims[2]/4/2}u;

  ${u.declareVariables(n,t,o)}

  ${oa(`vec4<${s}>`,s)}

  ${u.mainStart()}
    ${u.guardAgainstOutOfBoundsWorkgroupSizes(i)}
    let biasIdx = global_idx % halfChannels;
    let batchIndex = global_idx / halfChannels;
    let inputOffset = biasIdx + batchIndex * halfChannels * 2;
    let valueLeft = input[inputOffset] + bias[biasIdx];
    let valueRight = input[inputOffset + halfChannels] + bias[biasIdx + halfChannels];
    let geluRight = valueRight * 0.5 * (erf_vf32(valueRight / M_SQRT2) + 1);

    ${o.setByOffset("global_idx","valueLeft * geluRight")}
  }`}},ug=r=>{w2(r.inputs),r.compute(x2(r.inputs))}});var T2,_2,$r,dg,cg,fg,pg,hg,mg,gg,bg,yg,vg,wg=D(()=>{"use strict";ut();Re();Be();T2=(r,e,n,t,o,i,s,a,u,l,d,f,p)=>{let m,b;typeof a=="string"?m=b=(B,F)=>`${a}((${B}),(${F}))`:typeof a=="function"?m=b=a:(m=a.scalar,b=a.vector);let y=f?e.length:e,$=f?n.length:n,x=f?t.length:t,T=J("outputData",d,x,4),A=U("aData",u,y,4),E=U("bData",l,$,4),N;if(o)if(i){let B=G.size(e)===1,F=G.size(n)===1,P=e.length>0&&e[e.length-1]%4===0,W=n.length>0&&n[n.length-1]%4===0;B||F?N=T.setByOffset("global_idx",b(B?`${A.type.value}(${A.getByOffset("0")}.x)`:A.getByOffset("global_idx"),F?`${E.type.value}(${E.getByOffset("0")}.x)`:E.getByOffset("global_idx"))):N=`
            let outputIndices = ${T.offsetToIndices("global_idx * 4u")};
            let offsetA = ${A.broadcastedIndicesToOffset("outputIndices",T)};
            let offsetB = ${E.broadcastedIndicesToOffset("outputIndices",T)};
            ${T.setByOffset("global_idx",b(s||P?A.getByOffset("offsetA / 4u"):`${A.type.value}(${A.getByOffset("offsetA / 4u")}[offsetA % 4u])`,s||W?E.getByOffset("offsetB / 4u"):`${E.type.value}(${E.getByOffset("offsetB / 4u")}[offsetB % 4u])`))}
          `}else N=T.setByOffset("global_idx",b(A.getByOffset("global_idx"),E.getByOffset("global_idx")));else{if(!i)throw new Error("no necessary to use scalar implementation for element-wise binary op implementation.");let B=(F,P,W="")=>{let oe=`aData[indexA${P}][componentA${P}]`,H=`bData[indexB${P}][componentB${P}]`;return`
            let outputIndices${P} = ${T.offsetToIndices(`global_idx * 4u + ${P}u`)};
            let offsetA${P} = ${A.broadcastedIndicesToOffset(`outputIndices${P}`,T)};
            let offsetB${P} = ${E.broadcastedIndicesToOffset(`outputIndices${P}`,T)};
            let indexA${P} = offsetA${P} / 4u;
            let indexB${P} = offsetB${P} / 4u;
            let componentA${P} = offsetA${P} % 4u;
            let componentB${P} = offsetB${P} % 4u;
            ${F}[${P}] = ${W}(${m(oe,H)});
          `};d===9?N=`
            var data = vec4<u32>(0);
            ${B("data",0,"u32")}
            ${B("data",1,"u32")}
            ${B("data",2,"u32")}
            ${B("data",3,"u32")}
            outputData[global_idx] = dot(vec4<u32>(0x1, 0x100, 0x10000, 0x1000000), vec4<u32>(data));`:N=`
            ${B("outputData[global_idx]",0)}
            ${B("outputData[global_idx]",1)}
            ${B("outputData[global_idx]",2)}
            ${B("outputData[global_idx]",3)}
          `}return`
        ${r.registerUniform("vec_size","u32").declareVariables(A,E,T)}

        ${p??""}

        ${r.mainStart()}
        ${r.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}
        ${N}
      }`},_2=(r,e,n,t,o,i,s=n.dataType)=>{let a=!G.areEqual(n.dims,t.dims),u=n.dims,l=G.size(n.dims),d=!1,f=!1,p=[a];if(a){let b=yr.calcShape(n.dims,t.dims,!1);if(!b)throw new Error("Can't perform binary op on the given tensors");u=b,l=G.size(u);let y=G.size(n.dims)===1,$=G.size(t.dims)===1,x=n.dims.length>0&&n.dims[n.dims.length-1]%4===0,T=t.dims.length>0&&t.dims[t.dims.length-1]%4===0;p.push(y),p.push($),p.push(x),p.push(T);let A=1;for(let E=1;E<u.length;E++){let N=n.dims[n.dims.length-E]??1,B=t.dims[t.dims.length-E]??1;if(N===B)A*=N;else break}A%4===0?(f=!0,d=!0):(y||$||x||T)&&(d=!0)}else d=!0;p.push(d);let m=nt(n.dims.length)&&nt(t.dims.length)&&nt(u.length);return{name:r,shaderCache:{hint:e+p.map(b=>b.toString()).join("_"),inputDependencies:m?["rank","rank"]:["dims","dims"]},getShaderSource:b=>T2(b,n.dims,t.dims,u,d,a,f,o,n.dataType,t.dataType,s,m,i),getRunData:()=>({outputs:[{dims:u,dataType:s}],dispatchGroup:{x:Math.ceil(l/64/4)},programUniforms:m?[{type:"uint32",data:Math.ceil(G.size(u)/4)},...X(n.dims),...X(t.dims),...X(u)]:[{type:"uint32",data:Math.ceil(G.size(u)/4)}]})}},$r=(r,e,n,t,o,i)=>{r.compute(_2(e,o??"",r.inputs[0],r.inputs[1],n,t,i))},dg=r=>{$r(r,"Add",(e,n)=>`${e}+${n}`)},cg=r=>{$r(r,"Div",(e,n)=>`${e}/${n}`)},fg=r=>{$r(r,"Equal",{scalar:(e,n)=>`u32(${e}==${n})`,vector:(e,n)=>`vec4<u32>(${e}==${n})`},void 0,void 0,9)},pg=r=>{$r(r,"Mul",(e,n)=>`${e}*${n}`)},hg=r=>{let e=U("input",r.inputs[0].dataType,r.inputs[0].dims).type.value;$r(r,"Pow",{scalar:(t,o)=>`pow_custom(${t},${o})`,vector:(t,o)=>`pow_vector_custom(${t},${o})`},`
    fn pow_custom(a : ${e}, b : ${e}) -> ${e} {
      if (b == ${e}(0.0)) {
        return ${e}(1.0);
      } else if (a < ${e}(0.0) && f32(b) != floor(f32(b))) {
        return ${e}(pow(f32(a), f32(b))); // NaN
      }
      return select(sign(a), ${e}(1.0), round(f32(abs(b) % ${e}(2.0))) != 1.0) * ${e}(${e==="i32"?"round":""}(pow(f32(abs(a)), f32(b))));
    }
    fn pow_vector_custom(a : vec4<${e}>, b : vec4<${e}>) -> vec4<${e}> {
      // TODO: implement vectorized pow
      return vec4<${e}>(pow_custom(a.x, b.x), pow_custom(a.y, b.y), pow_custom(a.z, b.z), pow_custom(a.w, b.w));
    }
      `)},mg=r=>{$r(r,"Sub",(e,n)=>`${e}-${n}`)},gg=r=>{$r(r,"Greater",{scalar:(e,n)=>`u32(${e}>${n})`,vector:(e,n)=>`vec4<u32>(${e}>${n})`},void 0,void 0,9)},bg=r=>{$r(r,"Less",{scalar:(e,n)=>`u32(${e}<${n})`,vector:(e,n)=>`vec4<u32>(${e}<${n})`},void 0,void 0,9)},yg=r=>{$r(r,"GreaterOrEqual",{scalar:(e,n)=>`u32(${e}>=${n})`,vector:(e,n)=>`vec4<u32>(${e}>=${n})`},void 0,void 0,9)},vg=r=>{$r(r,"LessOrEqual",{scalar:(e,n)=>`u32(${e}<=${n})`,vector:(e,n)=>`vec4<u32>(${e}<=${n})`},void 0,void 0,9)}});var S2,I2,A2,O2,xg,Tg,_g=D(()=>{"use strict";Re();Tt();Be();S2=r=>{if(!r||r.length<1)throw new Error("too few inputs");let e=r[0].dataType,n=r[0].dims.length;for(let t of r){if(t.dataType!==e)throw new Error("input tensors should be one type");if(t.dims.length!==n)throw new Error("input tensors should have the same shape")}},I2=(r,e)=>`
  fn calculateInputIndex(index: u32) -> u32 {
    let sizeInConcatAxis = array<u32, ${r}u>(${e});
    for (var i: u32 = 0u; i < ${r}; i += 1u ) {
      if (index < sizeInConcatAxis[i]) {
        return i;
      }
    }
    return ${r}u;
  }`,A2=(r,e)=>{let n=r.length,t=[];for(let o=0;o<n;++o){let i=e.setByOffset("global_idx",r[o].getByIndices("indices"));n===1?t.push(i):o===0?t.push(`if (inputIndex == ${o}u) { ${i} }`):o===n-1?t.push(`else { ${i} }`):t.push(`else if (inputIndex == ${o}) { ${i} }`)}return t.join(`
`)},O2=(r,e)=>{let n=r[0].dims.slice();if(e>=n.length||e<-1*n.length)throw new Error("axis specified for concat doesn't match input dimensionality");let t=e<0?n.length+e:e,o=n.slice(0);for(let E=1;E<r.length;E++){let N=r[E].dims.slice();for(let B=0;B<n.length;B++)if(B===t)o[t]+=N[B];else if(n[B]!==N[B])throw new Error("non concat dimensions must match")}let i=G.size(o),s=new Array(r.length),a=new Array(r.length),u=r[0].dataType,l=0,d=[],f=[],p=[],m=[{type:"uint32",data:i}];for(let E=0;E<r.length;++E)l+=r[E].dims[t],s[E]=l,p.push(nt(r[E].dims.length)),f.push(p[E]?r[E].dims.length:r[E].dims),a[E]=U(`input${E}`,u,f[E]),d.push(p[E]?"rank":"dims"),m.push({type:"uint32",data:s[E]});for(let E=0;E<r.length;++E)p[E]&&m.push(...X(r[E].dims));let b=nt(o.length);b&&m.push(...X(o));let y=b?o.length:o,$=J("output",u,y),x=$.indicesGet("indices",t),T=Array.from(Array(s.length).keys()).map(E=>`uniforms.sizeInConcatAxis${E}`).join(","),A=E=>`

  ${(()=>{E.registerUniform("outputSize","u32");for(let N=0;N<r.length;N++)E.registerUniform(`sizeInConcatAxis${N}`,"u32");return E.declareVariables(...a,$)})()}

  ${I2(s.length,T)}

  ${E.mainStart()}
    ${E.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}

    var indices = ${$.offsetToIndices("global_idx")};

    let inputIndex = calculateInputIndex(${x});
    if (inputIndex != 0u) {
      let sizeInConcatAxis = array<u32, ${s.length}u>(${T});
      ${x} -= sizeInConcatAxis[inputIndex - 1u];
    }

    ${A2(a,$)}
  }`;return{name:"Concat",shaderCache:{hint:`${e}`,inputDependencies:d},getRunData:()=>({outputs:[{dims:o,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(i/64)},programUniforms:m}),getShaderSource:A}},xg=(r,e)=>{S2(r.inputs),r.compute(O2(r.inputs,e.axis))},Tg=r=>Oe({axis:r.axis})});var Sr,ia,jr=D(()=>{"use strict";Re();Sr=(r,e)=>{switch(r.activation){case"Relu":return{activationFunction:"",applyActivation:`value = max(value, ${e}(0.0));`};case"Sigmoid":return{activationFunction:"",applyActivation:`value = (${e}(1.0) / (${e}(1.0) + exp(-value)));`};case"Clip":return{activationFunction:`const clip_min_=${e}(${r.clipMin});const clip_max_=${e}(${r.clipMax});`,applyActivation:"value = clamp(value, clip_min_, clip_max_);"};default:return{activationFunction:"",applyActivation:""}}},ia=r=>{let e=r?.activation||"";if(e==="Clip"){let[n,t]=r?.activation_params||[Zi,Ji];return{activation:e,clipMax:t,clipMin:n,activationCacheKey:`${e}:${n},${t}`}}return{activation:e,activationCacheKey:e}}});var It,aa,sa=D(()=>{"use strict";It=(r,e)=>{switch(r){case 1:return e;case 2:return`vec2<${e}>`;case 3:return`vec3<${e}>`;case 4:return`vec4<${e}>`;default:throw new Error(`${r}-component is not supported.`)}},aa=r=>`
      ${r?"value = value + getBiasByOutputCoords(coords);":""}
      `});var ua,ou=D(()=>{"use strict";ua=r=>`
fn getIndexFromCoords4D(coords : vec4<i32>, shape : vec4<i32>) -> i32 {
  return dot(coords, vec4<i32>(
      shape.y * shape.z * shape.w, shape.z * shape.w, shape.w, 1));
}
fn getOutputIndexFromCoords(coords : vec4<i32>) -> i32 {
  return dot(coords, vec4<i32>(
    i32(${r}.x), i32(${r}.y), i32(${r}.z), 1));
}
`});var E2,C2,$o,$g,P2,So,k2,la,Io=D(()=>{"use strict";Re();Be();jr();sa();E2=(r,e)=>r?`
        mm_Asub[inputRow][inputCol] = mm_readA(batch,
          kStart + inputRow,
          globalRowStart / innerElementSize + inputCol${e?", batchIndices":""});
        `:`
        mm_Asub[inputRow][inputCol] = mm_readA(batch,
          globalRow + innerRow,
          kStart / innerElementSize + inputCol${e?", batchIndices":""});
        `,C2=(r,e)=>r?`
        let ACached0 = mm_Asub[k * innerElementSize][localRow];
        let ACached1 = mm_Asub[k * innerElementSize + 1][localRow];
        let ACached2 = mm_Asub[k * innerElementSize + 2][localRow];
        ${e===3?"":"let ACached3 = mm_Asub[k * innerElementSize + 3][localRow];"}
        for (var i = 0; i < rowPerThread; i = i + 1) {
          acc[i] = BCached0 * ACached0[i] + acc[i];
          acc[i] = BCached1 * ACached1[i] + acc[i];
          acc[i] = BCached2 * ACached2[i] + acc[i];
          ${e===3?"":"acc[i] = BCached3 * ACached3[i] + acc[i];"}
        }`:`
        for (var i = 0; i < rowPerThread; i = i + 1) {
          let ACached = mm_Asub[tileRow + i][k];
          acc[i] = BCached0 * ACached.x + acc[i];
          acc[i] = BCached1 * ACached.y + acc[i];
          acc[i] = BCached2 * ACached.z + acc[i];
          ${e===3?"":"acc[i] = BCached3 * ACached.w + acc[i];"}
        }`,$o=(r,e,n="f32",t,o=!1,i=32,s=!1,a=32)=>{let u=e[1]*r[1],l=e[0]*r[0],d=o?u:i,f=o?i:u,p=d/e[0],m=i/e[1];if(!((o&&p===4&&r[1]===4||!o&&(p===3||p===4))&&d%e[0]===0&&i%e[1]===0&&r[0]===4))throw new Error(`If transposeA ${o} is true, innerElementSize ${p} and workPerThread[1] ${r[1]} must be 4.
      Otherwise, innerElementSize ${p} must be 3 or 4.
  tileAWidth ${d} must be divisible by workgroupSize[0]${e[0]}. tileInner ${i} must be divisible by workgroupSize[1] ${e[1]}. colPerThread ${r[0]} must be 4.`);return`
var<workgroup> mm_Asub: array<array<vec${p}<${n}>, ${d/p}>, ${f}>;
var<workgroup> mm_Bsub: array<array<vec4<${n}>, ${l/r[0]}>, ${i}>;

const rowPerThread = ${r[1]};
const colPerThread = ${r[0]};
const innerElementSize = ${p};
const tileInner = ${i};

@compute @workgroup_size(${e[0]}, ${e[1]}, ${e[2]})
fn main(@builtin(local_invocation_id) localId : vec3<u32>,
        @builtin(global_invocation_id) globalId : vec3<u32>,
        @builtin(workgroup_id) workgroupId : vec3<u32>) {
  let localRow = i32(localId.y);
  let tileRow = localRow * rowPerThread;
  let tileCol = i32(localId.x);

  let globalRow =i32(globalId.y) * rowPerThread;
  let globalCol = i32(globalId.x);
  let batch = ${s?"0":"i32(globalId.z)"};
  ${t?`let batchIndices = ${t.offsetToIndices("u32(batch)")};`:""}
  let globalRowStart = i32(workgroupId.y) * ${u};

  let numTiles = ${s?`${Math.ceil(a/i)}`:"(uniforms.dimInner - 1) / tileInner + 1"};
  var kStart = ${s?`i32(globalId.z) * ${a}`:"0"};

  var acc: array<vec4<${n}>, rowPerThread>;

  // Loop over shared dimension.
  let tileRowB = localRow * ${m};
  for (var t = 0; t < numTiles; t = t + 1) {
      // Load one tile of A into local memory.
      for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
          let inputRow = tileRow + innerRow;
          let inputCol = tileCol;
          ${E2(o,t)}
      }

      // Load one tile of B into local memory.
      for (var innerRow = 0; innerRow < ${m}; innerRow = innerRow + 1) {
          let inputRow = tileRowB + innerRow;
          let inputCol = tileCol;
          mm_Bsub[inputRow][inputCol] = mm_readB(batch, kStart + inputRow, globalCol${t?", batchIndices":""});
      }
      kStart = kStart + tileInner;
      workgroupBarrier();

      // Compute acc values for a single thread.
      for (var k = 0; k < tileInner / innerElementSize; k = k + 1) {
          let BCached0 = mm_Bsub[k * innerElementSize][tileCol];
          let BCached1 = mm_Bsub[k * innerElementSize + 1][tileCol];
          let BCached2 = mm_Bsub[k * innerElementSize + 2][tileCol];
          ${p===3?"":"let BCached3 = mm_Bsub[k * innerElementSize + 3][tileCol];"}

          ${C2(o,p)}
      }

      workgroupBarrier();
  }

  for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
      mm_write(batch, globalRow + innerRow, globalCol, acc[innerRow]);
  }
}`},$g=(r,e)=>r?`
            mm_Asub[inputRow][inputCol] = mm_readA(batch,
              kStart + inputRow,
              globalRowStart + inputCol${e?", batchIndices":""});
            `:`
            mm_Asub[inputRow][inputCol] = mm_readA(batch,
              globalRowStart + inputRow,
              kStart + inputCol${e?", batchIndices":""});
            `,P2=r=>r?"let ACached = mm_Asub[k][tileRow + innerRow];":"let ACached = mm_Asub[tileRow + innerRow][k];",So=(r,e,n="f32",t,o=!1,i=32,s=!1,a=32,u=!1)=>{let l=r[1]*e[1],d=r[0]*e[0],f=o?l:i,p=o?i:l;if(!(p%e[1]===0&&f%e[0]===0&&i%e[1]===0))throw new Error(`tileAHight ${p} must be divisible by workgroupSize[1]${e[1]}, tileAWidth ${f} must be divisible by workgroupSize[0]${e[0]}, tileInner ${i} must be divisible by workgroupSize[1]${e[1]}`);let m=p/e[1],b=f/e[0],y=i/e[1],$=u?`
    let localRow = i32(localId.y);
    let localCol = i32(localId.x);
    let globalRowStart = i32(workgroupId.y) * ${l};
    let globalColStart = i32(workgroupId.x) * ${d};

    // Loop over shared dimension.
    for (var t = 0; t < numTiles; t = t + 1) {
      // Load one tile of A into local memory.
      for (var inputRow = localRow; inputRow < ${p}; inputRow = inputRow + ${e[1]}) {
        for (var inputCol = localCol; inputCol < ${f}; inputCol = inputCol + ${e[0]}) {
          ${$g(o,t)}
        }
      }
      // Load one tile of B into local memory.
      for (var inputRow = localRow; inputRow < ${i}; inputRow = inputRow + ${e[1]}) {
            for (var inputCol = localCol; inputCol < ${d}; inputCol = inputCol + ${e[0]}) {
          mm_Bsub[inputRow][inputCol] = mm_readB(batch,
            kStart + inputRow,
            globalColStart + inputCol${t?", batchIndices":""});
        }
      }
      kStart = kStart + tileInner;
      workgroupBarrier();

      // Compute acc values for a single thread.
      var BCached : array<${n}, colPerThread>;
      for (var k = 0; k < tileInner; k = k + 1) {
        for (var inner = 0; inner < colPerThread; inner = inner + 1) {
          BCached[inner] = mm_Bsub[k][localCol + inner * ${e[0]}];
        }
        for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
          let ACached = ${o?`mm_Asub[k][localRow + innerRow * ${e[1]}];`:`mm_Asub[localRow + innerRow * ${e[1]}][k];`}
          for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {
            acc[innerRow][innerCol] = acc[innerRow][innerCol] +
                ACached * BCached[innerCol];
          }
        }
      }
      workgroupBarrier();
    }
    for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
      let gRow = globalRowStart + localRow + innerRow * ${e[1]};
      for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {
        let gCol = globalColStart + localCol + innerCol * ${e[0]};
        mm_write(batch, gRow, gCol, acc[innerRow][innerCol]);
      }
    }
    `:`
let tileRow = i32(localId.y) * rowPerThread;
let tileCol = i32(localId.x) * colPerThread;

let globalRow = i32(globalId.y) * rowPerThread;
let globalCol = i32(globalId.x) * colPerThread;
let globalRowStart = i32(workgroupId.y) * ${l};

let tileRowA = i32(localId.y) * ${m};
let tileColA = i32(localId.x) * ${b};
let tileRowB = i32(localId.y) * ${y};
// Loop over shared dimension.
for (var t = 0; t < numTiles; t = t + 1) {
  // Load one tile of A into local memory.
  for (var innerRow = 0; innerRow < ${m}; innerRow = innerRow + 1) {
    for (var innerCol = 0; innerCol < ${b}; innerCol = innerCol + 1) {
      let inputRow = tileRowA + innerRow;
      let inputCol = tileColA + innerCol;
      ${$g(o,t)}
    }
  }

  // Load one tile of B into local memory.
  for (var innerRow = 0; innerRow < ${y}; innerRow = innerRow + 1) {
    for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {
      let inputRow = tileRowB + innerRow;
      let inputCol = tileCol + innerCol;
      mm_Bsub[inputRow][inputCol] = mm_readB(batch,
        kStart + inputRow,
        globalCol + innerCol${t?", batchIndices":""});
    }
  }
  kStart = kStart + tileInner;
  workgroupBarrier();

  // Compute acc values for a single thread.
  var BCached : array<${n}, colPerThread>;
  for (var k = 0; k < tileInner; k = k + 1) {
    for (var inner = 0; inner < colPerThread; inner = inner + 1) {
      BCached[inner] = mm_Bsub[k][tileCol + inner];
    }

    for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
      ${P2(o)}
      for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {
        acc[innerRow][innerCol] = acc[innerRow][innerCol] + ACached * BCached[innerCol];
      }
    }
  }

  workgroupBarrier();
}

for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
  for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {
    mm_write(batch, globalRow + innerRow, globalCol + innerCol,
        acc[innerRow][innerCol]);
  }
}
`;return`
  var<workgroup> mm_Asub : array<array<${n}, ${f}>, ${p}>;
  var<workgroup> mm_Bsub : array<array<${n}, ${d}>, ${i}>;
  const rowPerThread = ${r[1]};
  const colPerThread = ${r[0]};
  const tileInner = ${i};

@compute @workgroup_size(${e[0]}, ${e[1]}, ${e[2]})
fn main(@builtin(local_invocation_id) localId : vec3<u32>,
        @builtin(global_invocation_id) globalId : vec3<u32>,
        @builtin(workgroup_id) workgroupId : vec3<u32>) {
    let batch = ${s?"0":"i32(globalId.z)"};
    ${t?`let batchIndices = ${t.offsetToIndices("u32(batch)")};`:""}
    let numTiles = ${s?`${Math.ceil(a/i)}`:"(uniforms.dimInner - 1) / tileInner + 1"};
    var kStart = ${s?`i32(globalId.z) * ${a}`:"0"};

    var acc : array<array<${n}, colPerThread>, rowPerThread>;

    // Without this initialization strange values show up in acc.
    for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {
      for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {
        acc[innerRow][innerCol] = 0.0;
      }
    }
    ${$}
  }
`},k2=(r,e,n,t,o,i=!1)=>{let[s,a,u]=o,[l,d,f,p]=t,m=zn(s,u),b=zn(a,u),y=vt(t[0].type.tensor),$=()=>{let A=d.rank,E=l.rank,N=`var aIndices: ${d.type.indices};`;for(let B=A-2-1,F=E-1;B>=0;B--,F--)N+=`
aIndices[${B}] = ${E>1?`batchIndices[${F}]`:"batchIndices"};`;return m.forEach(B=>{N+=`
aIndices[${B}] = 0;`}),N+=`
aIndices[${A-2}] = u32(row);
                   aIndices[${A-1}] = u32(colIn);`,N},x=()=>{let A=f.rank,E=l.rank,N=`var bIndices: ${f.type.indices};`;for(let B=A-2-1,F=E-1;B>=0;B--,F--)N+=`
bIndices[${B}] = ${E>1?`batchIndices[${F}]`:"batchIndices"};`;return b.forEach(B=>{N+=`
bIndices[${B}] = 0;`}),N+=`
bIndices[${A-2}] = u32(row);
                   bIndices[${A-1}] = u32(colIn);`,N};return`
    fn mm_readA(batch: i32, row: i32, colIn: i32, batchIndices: ${l.type.indices}) -> ${It(r,y)} {
      var value = ${It(r,y)}(0.0);
      let col = colIn * ${r};
      if(row < uniforms.dimAOuter && col < uniforms.dimInner)
      {
        ${$()}
        value = ${d.getByIndices("aIndices")};
      }
      return value;
    }

    fn mm_readB(batch: i32, row: i32, colIn: i32, batchIndices: ${l.type.indices}) -> ${It(r,y)} {
      var value = ${It(r,y)}(0.0);
      let col = colIn * ${r};
      if(row < uniforms.dimInner && col < uniforms.dimBOuter)
      {
        ${x()}
        value = ${f.getByIndices("bIndices")};
      }
      return value;
    }

    fn mm_write(batch: i32, row: i32, colIn: i32, valueIn: ${It(r,y)}) {
      let col = colIn * ${r};
      if (row < uniforms.dimAOuter && col < uniforms.dimBOuter) {
        var value = valueIn;
        let coords = vec3<i32>(batch, row, colIn);
        ${e?`value = value + ${i?"bias[colIn]":`${It(r,y)}(bias[row])`};`:""}
        ${n}
        ${p.setByIndices("vec3<u32>(coords)","value")}
      }
    }
    `},la=(r,e,n,t,o=!1)=>{let i=r[0].dims,s=r[1].dims,a=i.slice(0,-2),u=s.slice(0,-2),l=t?t.slice(0,-2):n.slice(0,-2),d=nt(l.length),f=d?l.length:l,p=Qi("batchDims",r[0].dataType,f,1),m=G.size(l),b=i[i.length-2],y=i[i.length-1],$=s[s.length-1],x=y%4===0&&$%4===0,T=b<=8?[4,1,1]:[4,4,1],A=[8,8,1],E=[Math.ceil($/A[0]/T[0]),Math.ceil(b/A[1]/T[1]),Math.ceil(m/A[2]/T[2])],N=vt(r[0].dataType),B=x?4:1,F=[...a,b,y/B],P=nt(F.length),W=P?F.length:F,oe=[...u,y,$/B],H=nt(oe.length),re=H?oe.length:oe,ie=[m,b,$/B],ne=U("a",r[0].dataType,W,B),Ye=U("b",r[1].dataType,re,B),Ze=J("result",r[0].dataType,ie.length,B),Se=[ne,Ye],He=[{type:"int32",data:b},{type:"int32",data:$},{type:"int32",data:y}];d&&He.push(...X(l)),P&&He.push(...X(F)),H&&He.push(...X(oe));let Ie=[];Ie.push(P?"rank":"dims"),Ie.push(H?"rank":"dims");let Ce=r.length>2,{activationFunction:ft,applyActivation:at}=Sr(e,Ze.type.value),bt=k2(B,Ce,at,[p,ne,Ye,Ze],[a,u,l],o);if(Ce){let de=o?B:1;Se.push(U("bias",r[2].dataType,r[2].dims.length,de)),He.push(...X(r[2].dims)),Ie.push("rank")}He.push(...X(ie));let Y=de=>`
  ${de.registerUniform("dimAOuter","i32").registerUniform("dimBOuter","i32").registerUniform("dimInner","i32").registerInternalVariables(p).declareVariables(...Se,Ze)}
  ${ft}
  ${bt}
  ${x?$o(T,A,N,p):So(T,A,N,p)}
                   `;return{name:"MatMul",shaderCache:{hint:e.activationCacheKey+`${T}${x}${o}`,inputDependencies:Ie},getRunData:()=>({outputs:[{dims:n,dataType:r[0].dataType}],dispatchGroup:{x:E[0],y:E[1],z:E[2]},programUniforms:He}),getShaderSource:Y}}});var D2,Sg,Ig=D(()=>{"use strict";qr();Be();jr();sa();ou();Io();D2=(r,e,n,t,o=!1,i,s=4,a=4,u=4,l="f32")=>{let d=H=>{switch(H){case 1:return"resData = x[xIndex];";case 3:return`resData = vec3<${l}>(x[xIndex], x[xIndex + 1], x[xIndex + 2]);`;case 4:return"resData = x[xIndex / 4];";default:throw new Error(`innerElementSize ${H} is not supported.`)}},f=H=>{switch(H){case 1:return"return w[row * i32(uniforms.w_shape[3]) + colIn];";case 4:return"return w[row * i32(uniforms.w_shape[3]) / 4 + colIn];";default:throw new Error(`innerElementSize ${H} is not supported.`)}},p=r?`
    let coord = vec4<i32>(batch, xRow, xCol, xCh);
    `:`
    let coord = vec4<i32>(batch, xCh, xRow, xCol);
    `,m=r?`
    let coords = vec4<i32>(
      batch,
      row / outWidth,
      row % outWidth,
      col);
    `:`
    let coords = vec4<i32>(
      batch,
      row,
      col / outWidth,
      col % outWidth);
    `,b=r?"i32(uniforms.x_shape[1])":"i32(uniforms.x_shape[2])",y=r?"i32(uniforms.x_shape[2])":"i32(uniforms.x_shape[3])",$=r?"row":"col",x=r?"col":"row",T=`
    let inChannels = i32(uniforms.w_shape[2]);
    let outWidth = ${r?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};
    let outRow = ${$} / outWidth;
    let outCol = ${$} % outWidth;

    let WRow = ${x} / (filterDims[1] * inChannels);
    let WCol = ${x} / inChannels % filterDims[1];
    let xRow = outRow * stride[0] + dilation[0] * WRow - pad[0];
    let xCol = outCol * stride[1] + dilation[1] * WCol - pad[1];
    let xCh = ${x} % inChannels;
    var resData = ${It(s,l)}(0.0);
    // The bounds checking is always needed since we use it to pad zero for
    // the 'same' padding type.
    if (xRow >= 0 && xRow < ${b} && xCol >= 0 && xCol < ${y}) {
      ${p}
      let xIndex = getIndexFromCoords4D(coord, vec4<i32>(uniforms.x_shape));
      ${d(s)}
    }
    return resData;`,A=r?e&&t?`
    let col = colIn * ${s};
    ${T}`:`
    let col = colIn * ${s};
    if (row < uniforms.dimAOuter && col < uniforms.dimInner) {
      ${T}
    }
    return ${It(s,l)}(0.0);`:t&&n?`
    let col = colIn * ${s};
    ${T}`:`
    let col = colIn * ${s};
    if (row < uniforms.dimInner && col < uniforms.dimBOuter) {
      ${T}
    }
    return ${It(s,l)}(0.0);`,E=`${f(a)}`,N=It(u,l),B=r?It(s,l):It(a,l),F=r?It(a,l):It(s,l),{activationFunction:P,applyActivation:W}=Sr(i,N);return`
    ${P}
    fn mm_readA(batch: i32, row : i32, colIn : i32) -> ${B} {
      ${r?A:E}
    }

    fn mm_readB(batch: i32, row : i32, colIn : i32) -> ${F} {
      ${r?E:A}
    }

    fn mm_write(batch: i32, row : i32, colIn : i32, valueIn : ${N}) {
      let col = colIn * ${u};
      if (row < uniforms.dimAOuter && col < uniforms.dimBOuter)
      {
      var value = valueIn;
      let outWidth = ${r?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};
      ${m}
      ${aa(o)}
      ${W}
      setOutputAtCoords(coords[0], coords[1], coords[2], coords[3], value);
      }
    }`},Sg=(r,e,n,t,o,i,s,a)=>{let u=e.format==="NHWC",l=u?r[0].dims[3]:r[0].dims[1],d=n[0],f=u?n[2]:n[3],p=u?n[1]:n[2],m=u?n[3]:n[1],b=u&&(l%4===0||l%3===0)&&m%4===0,y=u?m:f*p,$=u?f*p:m,x=[8,8,1],T=t<=8?[4,1,1]:[4,4,1],A=[Math.ceil(y/x[0]/T[0]),Math.ceil($/x[1]/T[1]),Math.ceil(d/x[2]/T[2])];it("verbose",()=>`[conv2d_mm_webgpu] dispatch = ${A}`);let E=b?u&&l%4!==0?3:4:1,N=x[1]*T[1],B=x[0]*T[0],F=Math.max(x[0]*E,x[1]),P=t%N===0,W=o%B===0,oe=i%F===0,H=b?[E,4,4]:[1,1,1],re=vt(r[0].dataType),ie=b?4:1,ne=[{type:"int32",data:t},{type:"int32",data:o},{type:"int32",data:i}],Ye=U("x",r[0].dataType,r[0].dims.length,E===3?1:E),Ze=U("w",r[1].dataType,r[1].dims.length,ie),Se=[Ye,Ze];ne.push(...X(r[0].dims)),ne.push(...X(r[1].dims));let He=`
      fn setOutputAtIndex(flatIndex : i32, value : ${b?`vec4<${re}>`:re}) {
        result[flatIndex] = ${b?`vec4<${re}>`:re}(value);
      }
      fn setOutputAtCoords(d0 : i32, d1 : i32, d2 : i32, d3 : i32, value : ${b?`vec4<${re}>`:re}) {
        let flatIndex = getOutputIndexFromCoords(vec4<i32>(d0, d1, d2, d3));
        setOutputAtIndex(flatIndex ${b?"/ 4":""}, value);
      }`;if(s){let Ce=U("bias",r[2].dataType,r[2].dims.length,ie);Se.push(Ce),ne.push(...X(r[2].dims)),He+=`
        fn getBiasByOutputCoords(coords : vec4<i32>) -> ${b?`vec4<${re}>`:re} {
          return bias[coords.${u?"w":"y"}${b?"/ 4":""}];
        }`}let Ie=J("result",r[0].dataType,n.length,ie);return ne.push(...X(n)),{name:"Conv2DMatMul",shaderCache:{hint:e.cacheKey},getRunData:()=>({outputs:[{dims:n,dataType:r[0].dataType}],dispatchGroup:{x:A[0],y:A[1],z:A[2]},programUniforms:ne}),getShaderSource:Ce=>`
        ${ua("uniforms.result_strides")}
        //struct Uniforms { xShape : vec4<i32>, wShape : vec4<i32>, outShape : vec4<i32>,
        //  outShapeStrides: vec3<i32>, filterDims : vec2<i32>, pad : vec2<i32>, stride : vec2<i32>,
        //  dilation : vec2<i32>, dimAOuter : i32, dimBOuter : i32, dimInner : i32 };
        ${Ce.registerUniform("dimAOuter","i32").registerUniform("dimBOuter","i32").registerUniform("dimInner","i32").declareVariables(...Se,Ie)}
        const filterDims : vec2<i32> = vec2<i32>(${e.kernelShape[0]}, ${e.kernelShape[1]});
        const pad : vec2<i32> = vec2<i32>(${e.pads[0]}, ${e.pads[1]});
        const stride : vec2<i32> = vec2<i32>(${e.strides[0]}, ${e.strides[1]});
        const dilation : vec2<i32> = vec2<i32>(${e.dilations[0]}, ${e.dilations[1]});
        ${He}
        ${D2(u,P,W,oe,s,e,H[0],H[1],H[2],re)}
            ${b?$o(T,x,re,void 0,!u,F):So(T,x,re,void 0,!u,F,!1,void 0,a)}`}}});var iu,Ag=D(()=>{"use strict";Re();Be();su();jr();iu=(r,e,n)=>{let t=r.length>2,o=t?"value += b[output_channel];":"",i=r[0].dims,s=r[1].dims,a=s[0]/e.group,u=e.format==="NHWC",l=au(i,s,e.dilations,e.pads,e.strides,u),d=G.size(l),f=J("output",r[0].dataType,l),{activationFunction:p,applyActivation:m}=Sr(e,f.type.value),b=U("x",r[0].dataType,i),y=U("w",r[1].dataType,s),$=[b,y];t&&$.push(U("b",r[2].dataType,r[2].dims));let x=T=>`
  const strides: vec2<u32> = vec2(${e.strides[0]}u, ${e.strides[1]}u);
  const pads: vec2<u32> = vec2(${e.pads[0]}u, ${e.pads[1]}u);

  ${T.declareVariables(...$,f)}

  ${p}

  ${T.mainStart()}
    ${T.guardAgainstOutOfBoundsWorkgroupSizes(d)}

    let outputIndices = ${f.offsetToIndices("global_idx")};
    let batch: u32 = outputIndices[0];
    let output_channel: u32 = outputIndices[${u?3:1}];
    let xRCCorner: vec2<u32> = vec2<u32>(outputIndices[${u?1:2}], outputIndices[${u?2:3}]) * strides - pads;
    let group_id: u32 = output_channel / ${a}u;

    var value: ${f.type.value} = ${f.type.value}(0);
    for (var wInChannel: u32 = 0u; wInChannel < ${s[1]}u; wInChannel++) {
      let input_channel = group_id * ${s[1]}u + wInChannel;
      for (var wHeight: u32 = 0u; wHeight < ${s[2]}u; wHeight++) {
        let xHeight = xRCCorner.x + wHeight * ${e.dilations[0]}u;

        if (xHeight < 0u || xHeight >= ${i[u?1:2]}u) {
          continue;
        }

        for (var wWidth: u32 = 0u; wWidth < ${s[3]}u; wWidth++) {
          let xWidth = xRCCorner.y + wWidth * ${e.dilations[1]}u;
          if (xWidth < 0u || xWidth >= ${i[u?2:3]}u) {
            continue;
          }

          let xVal = ${u?b.get("batch","xHeight","xWidth","input_channel"):b.get("batch","input_channel","xHeight","xWidth")};
          let wVal = ${y.get("output_channel","wInChannel","wHeight","wWidth")};
          value += xVal*wVal;
        }
      }
    }
    ${o}
    ${m}
    ${f.setByOffset("global_idx","value")}
  }`;return{name:"GroupedConv",shaderCache:{hint:e.cacheKey},getRunData:()=>({outputs:[{dims:n?n(l):l,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(d/64)}}),getShaderSource:x}}});var uu,B2,Og,lu=D(()=>{"use strict";Re();Io();Be();jr();uu=(r,e,n,t,o=!1)=>{let i=r[0].dims,s=r[1].dims,a=i[i.length-2],u=s[s.length-1],l=i[i.length-1],d=wt(u),f=wt(l),p=wt(a),m=G.size(n)/d/p,b=r.length>2,y=t?t.slice(0,-2):n.slice(0,-2),x=[G.size(y),a,u],T=[{type:"uint32",data:m},{type:"uint32",data:a},{type:"uint32",data:u},{type:"uint32",data:l},...X(y),...X(i),...X(s)];b&&T.push(...X(r[2].dims)),T.push(...X(x));let A=E=>{let N=Qi("batch_dims",r[0].dataType,y.length),B=U("a",r[0].dataType,i.length,f),F=U("b",r[1].dataType,s.length,d),P=J("output",r[0].dataType,x.length,d),{activationFunction:W,applyActivation:oe}=Sr(e,P.type.value),H=[B,F],re="";if(b){let Ie=o?d:1;H.push(U("bias",r[2].dataType,r[2].dims.length,Ie)),re=`${o?`value += bias[col / ${Ie}];`:`value += ${P.type.value}(bias[row + i]);`}`}let ie=i.slice(0,-2),ne=s.slice(0,-2),Ye=zn(ie,y),Ze=zn(ne,y),Se=(Ie,Ce)=>{let ft=Ie.rank,at=Ie.name;if(ft===2)return`var ${at}_indices = ${Ie.type.indices}(0u, 0u);`;let bt=N.rank,Y=`var ${at}_indices: ${Ie.type.indices};`;for(let de=ft-2-1,Pe=bt-1;de>=0;de--,Pe--)Y+=`
${at}_indices[${de}] = ${bt>1?`batch_indices[${Pe}]`:"batch_indices"};`;return Ce.forEach(de=>{Y+=`
${at}_indices[${de}] = 0;`}),Y+=`${at}_indices[${ft-2}] = 0u;
                     ${at}_indices[${ft-1}] = 0u;`,Y},He=()=>{let Ie=`var a_data: ${B.type.value};`;for(let Ce=0;Ce<f;Ce++)Ie+=`
              let b_data${Ce} = b[(b_offset + (k + ${Ce}) * uniforms.N + col) / ${d}];`;for(let Ce=0;Ce<p;Ce++){Ie+=`a_data = a[(a_offset + (row + ${Ce}) * uniforms.K + k) / ${f}];`;for(let ft=0;ft<f;ft++)Ie+=`
            values[${Ce}] = fma(${F.type.value}(a_data${f===1?"":`[${ft}]`}), b_data${ft}, values[${Ce}]);
`}return Ie};return`
  ${E.registerUniform("outputSize","u32").registerUniform("M","u32").registerUniform("N","u32").registerUniform("K","u32").registerInternalVariables(N).declareVariables(...H,P)}
  ${W}
  ${E.mainStart()}
    ${E.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
    let col = (global_idx % (uniforms.N / ${d})) * ${d};
    var index1 = global_idx / (uniforms.N / ${d});
    let stride1 = uniforms.M / ${p};
    let row = (index1 % stride1) * ${p};
    let batch = index1 / stride1;

    ${n.length===2?"":`let batch_indices = ${N.offsetToIndices("batch")};`}
    ${Se(B,Ye)}
    let a_offset = ${B.indicesToOffset("a_indices")};
    ${Se(F,Ze)}
    let b_offset = ${F.indicesToOffset("b_indices")};
    var values: array<${P.type.value}, ${p}>;
    for (var k: u32 = 0u; k < uniforms.K; k = k + ${f}) {
      ${He()}
    }
    for (var i = 0u; i < ${p}u; i++) {
      var value = values[i];
      ${re}
      ${oe}
      let cur_indices = ${P.type.indices}(batch, row + i, col);
      let offset = ${P.indicesToOffset("cur_indices")};
      ${P.setByOffset(`offset / ${d}`,"value")};
    }
  }
  `};return{name:"MatMulNaive",shaderCache:{hint:`${e.activationCacheKey}_${d}_${f}_${p}_${o}`,inputDependencies:b?["rank","rank","rank"]:["rank","rank"]},getRunData:()=>({outputs:[{dims:n,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(m/64)},programUniforms:T}),getShaderSource:A}},B2=r=>{if(!r||r.length!==2)throw new Error("MatMul requires 2 inputs.");if(r[0].dims[r[0].dims.length-1]!==r[1].dims[r[1].dims.length-2])throw new Error("shared dimension does not match.")},Og=r=>{B2(r.inputs);let e=yr.calcShape(r.inputs[0].dims,r.inputs[1].dims,!0);if(!e)throw new Error("Can't use matmul on the given tensors");let n=e[e.length-1],t=r.inputs[0].dims[r.inputs[0].dims.length-1];n<8&&t<8?r.compute(uu(r.inputs,{activation:"",activationCacheKey:""},e)):r.compute(la(r.inputs,{activation:"",activationCacheKey:""},e))}});var au,Eg,R2,Cg,du,z2,N2,cu,su=D(()=>{"use strict";Re();Tt();Ig();Io();Ag();jr();lu();Nn();au=(r,e,n,t,o,i)=>{let s=r[0],a=r.slice(i?1:2,i?3:4),u=a.length,l=e[0],f=e.slice(2).map((b,y)=>b+(b-1)*(n[y]-1)),m=a.map((b,y)=>b+t[y]+t[y+u]).map((b,y)=>Math.floor((b-f[y]+o[y])/o[y]));return m.splice(0,0,s),m.splice(i?3:1,0,l),m},Eg=[2,3,1,0],R2=(r,e)=>{if(!r||r.length!==2&&r.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(r[0].dims.length!==4&&r[0].dims.length!==3)throw new Error("currently only support conv 1D and 2D");if(r[0].dims.length!==r[1].dims.length)throw new Error("filter does not have same dimension as input");let n=r[0].dims[e.format==="NHWC"?r[0].dims.length-1:1],t=r[1].dims[1]*e.group;if(n!==t)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");if(r.length===3&&(r[2].dims.length!==1||r[1].dims[0]!==r[2].dims[0]))throw new Error("invalid bias");let o=r[0].dims.length-2;if(e.dilations.length!==o)throw new Error(`dilations should be ${o}D`);if(e.strides.length!==o)throw new Error(`strides should be ${o}D`);if(e.pads.length!==o*2)throw new Error(`pads should be ${o*2}D`);if(e.kernelShape.length!==0&&e.kernelShape.length!==r[1].dims.length-2)throw new Error("invalid kernel shape")},Cg=(r,e)=>{let n=r.kernelShape.slice();for(let i=2;i<e[1].dims.length;++i)n[i-2]===0&&(n[i-2]=e[1].dims[i]);let t=r.pads.slice();pn.adjustPadsBasedOnAutoPad(e[0].dims,r.strides,r.dilations,n,t,r.format==="NHWC",r.autoPad);let o=Object.assign({},r);return Object.assign(o,{kernelShape:n,pads:t,cacheKey:r.cacheKey}),o},du=r=>{let e=ia(r),n=r.format,t=["NOTSET","VALID","SAME_UPPER","SAME_LOWER"][r.auto_pad],o=r.dilations,i=r.group,s=r.kernel_shape,a=r.pads,u=r.strides,l=r.w_is_const();return Oe({autoPad:t,format:n,dilations:o,group:i,kernelShape:s,pads:a,strides:u,wIsConst:l,...e})},z2=(r,e,n)=>{let t=Cg(n,e),o=n.format==="NHWC";if(n.group!==1){r.compute(iu(e,t));return}let i=e.length===3,s=e[0].dims[o?1:2],a=e[0].dims[o?2:3],u=e[0].dims[o?3:1],l=e[1].dims[2],d=e[1].dims[3],f=au(e[0].dims,e[1].dims,n.dilations,t.pads,n.strides,o),p=f[o?1:2],m=f[o?2:3],b=f[o?3:1],y=o&&l===s&&d===a&&n.pads[0]===0&&n.pads[1]===0;if(y||l===1&&d===1&&n.dilations[0]===1&&n.dilations[1]===1&&n.strides[0]===1&&n.strides[1]===1&&n.pads[0]===0&&n.pads[1]===0){let B=f[0],F,P,W,oe=[];if(o){let ie=r.kernelCustomData.wT??r.compute(lr(e[1],Eg),{inputs:[1],outputs:[n.wIsConst?-2:-1]})[0];if(n.wIsConst&&!r.kernelCustomData.wT&&(r.kernelCustomData.wT=ie),y){let ne=s*a*u;F=e[0].reshape([1,B,ne]),P=ie.reshape([1,ne,b]),W=[1,B,b]}else F=e[0].reshape([B,s*a,u]),P=ie.reshape([1,u,b]),W=[B,p*m,b];oe.push(F),oe.push(P)}else F=e[0].reshape([B,u,s*a]),P=e[1].reshape([1,b,u]),W=[B,b,p*m],oe.push(P),oe.push(F);i&&oe.push(e[2]);let H=W[2],re=oe[0].dims[oe[0].dims.length-1];H<8&&re<8?r.compute(uu(oe,t,f,W,o),{inputs:oe}):r.compute(la(oe,t,f,W,o),{inputs:oe});return}let $=!0,x=r.kernelCustomData.wT??r.compute(lr(e[1],Eg),{inputs:[1],outputs:[n.wIsConst?-2:-1]})[0];n.wIsConst&&!r.kernelCustomData.wT&&(r.kernelCustomData.wT=x);let T=[e[0],x];i&&T.push(e[2]);let A=o?p*m:b,E=o?b:p*m,N=l*d*u;r.compute(Sg(T,t,f,A,E,N,i,$),{inputs:T})},N2=(r,e)=>{let n=e.format==="NHWC",t=[r.inputs[0].reshape(n?[r.inputs[0].dims[0],1,r.inputs[0].dims[1],r.inputs[0].dims[2]]:[r.inputs[0].dims[0],r.inputs[0].dims[1],1,r.inputs[0].dims[2]]),r.inputs[1].reshape([r.inputs[1].dims[0],r.inputs[1].dims[1],1,r.inputs[1].dims[2]])];r.inputs.length===3&&t.push(r.inputs[2]);let o=[0,e.pads[0],0,e.pads[1]],i=[1].concat(e.strides),s=[1].concat(e.dilations),a=[1].concat(e.kernelShape),u=Cg({...e,pads:o,strides:i,dilations:s,kernelShape:a},t);r.compute(iu(t,u,l=>n?[l[0],l[2],l[3]]:[]))},cu=(r,e)=>{R2(r.inputs,e),r.inputs[0].dims.length===3?N2(r,e):z2(r,r.inputs,e)}});var L2,Pg,kg=D(()=>{"use strict";qr();Be();jr();sa();ou();Io();L2=(r,e=!1,n,t=4)=>{let o=It(t,"f32"),i=T=>{switch(T){case 1:return"return w[getIndexFromCoords4D(coord, vec4<i32>(uniforms.w_shape))];";case 4:return`
            let coord1 = vec4<i32>(coordX, coordY, col + 1, rowInner);
            let coord2 = vec4<i32>(coordX, coordY, col + 2, rowInner);
            let coord3 = vec4<i32>(coordX, coordY, col + 3, rowInner);
            let v0 = w[getIndexFromCoords4D(coord, vec4<i32>(uniforms.w_shape))];
            let v1 = w[getIndexFromCoords4D(coord1, vec4<i32>(uniforms.w_shape))];
            let v2 = w[getIndexFromCoords4D(coord2, vec4<i32>(uniforms.w_shape))];
            let v3 = w[getIndexFromCoords4D(coord3, vec4<i32>(uniforms.w_shape))];
            return vec4<f32>(v0, v1, v2, v3);
            `;default:throw new Error(`innerElementSize ${T} is not supported.`)}},s=r?`
      let coord = vec4<i32>(batch, iXR, iXC, xCh);
      `:`
      let coord = vec4<i32>(batch, xCh, iXR, iXC);
      `,a=r?`
    let coords = vec4<i32>(
      batch,
      row / outWidth,
      row % outWidth,
      col);
    `:`
    let coords = vec4<i32>(
      batch,
      row,
      col / outWidth,
      col % outWidth);
    `,u=r?"outBackprop[1]":"outBackprop[2]",l=r?"outBackprop[2]":"outBackprop[3]",d=r?"row":"col",f=r?"col":"row",p=`
      let inChannels = ${r?"outBackprop[3]":"outBackprop[1]"};
      let outWidth = ${r?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};
      let outRow = ${d} / outWidth;
      let outCol = ${d} % outWidth;

      let WRow = ${f} / (filterDims[1] * inChannels);
      let WCol = ${f} / inChannels % filterDims[1];
      let xR = f32(outRow - pads[0] + dilation[0] * WRow) / f32(strides[0]);
      let xC = f32(outCol - pads[1] + dilation[1] * WCol) / f32(strides[1]);
      if (xR < 0.0 || xR >= f32(${u}) || fract(xR) > 0.0) {
        return ${o}(0.0);
      }
      if (xC < 0.0 || xC >= f32(${l}) || fract(xC) > 0.0) {
        return ${o}(0.0);
      }
      let iXR = i32(xR);
      let iXC = i32(xC);
      let xCh = ${f} % inChannels;
      ${s}
      return x[getIndexFromCoords4D(coord, vec4<i32>(uniforms.x_shape))/${t}];`,m=r?`
      let col = colIn * ${t};
      if (row < uniforms.dimAOuter && col < uniforms.dimInner) {
        ${p}
      }
      return ${o}(0.0);`:`
      let col = colIn * ${t};
      if (row < uniforms.dimInner && col < uniforms.dimBOuter) {
        ${p}
      }
      return ${o}(0.0);`,b=`
      let col = colIn * ${t};
      let inChannels = ${r?"outBackprop[3]":"outBackprop[1]"};
      let coordX = filterDims.x - 1 - row / (filterDims[1] * inChannels);
      let coordY = filterDims.y - 1 - (row / inChannels) % filterDims[1];
      if (${r?"row < uniforms.dimInner && col < uniforms.dimBOuter":"row < uniforms.dimInner && col < uniforms.dimAOuter"}  && coordX >= 0 && coordY >= 0) {
        let rowInner = row % inChannels;
        let coord = vec4<i32>(coordX, coordY, col, rowInner);
        ${i(t)}
      }
      return ${o}(0.0);
      `,{activationFunction:y,applyActivation:$}=Sr(n,o);return`
      ${y}
  fn mm_readA(batch: i32, row : i32, colIn : i32) -> ${o} {
    ${r?m:b}
  }

  fn mm_readB(batch: i32, row : i32, colIn : i32) -> ${o} {
    ${r?b:m}
  }

  fn mm_write(batch: i32, row : i32, colIn : i32, valueInput : ${o}) {
    let col = colIn * ${t};
    if (row < uniforms.dimAOuter && col < uniforms.dimBOuter) {
      var value = valueInput;
      let outWidth = ${r?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};
      ${a}
      ${aa(e)}
      ${$}
      result[getIndexFromCoords4D(coords, vec4<i32>(uniforms.result_shape))/${t}] = value;
    }
  }`},Pg=(r,e,n,t,o,i,s,a)=>{let u=e.format==="NHWC",l=u?r[0].dims[3]:r[0].dims[1],d=n[0],f=u?n[2]:n[3],p=u?n[1]:n[2],m=u?n[3]:n[1],b=u?l%4===0&&m%4===0:f%4===0&&m%4===0,y=u?m:f*p,$=u?f*p:m,x=b?[8,8,1]:[y<=4||$<=4?4:16,y>4&&$<=4?4:16,1],T=b?[4,4,1]:[y<=4?1:4,y>4&&$<=4?1:4,1],A=[Math.ceil(y/x[0]/T[0]),Math.ceil($/x[1]/T[1]),Math.ceil(d/x[2]/T[2])];it("verbose",()=>`[conv_backprop_mm_webgpu] dispatch = ${A}`);let E=b?4:1,N=Math.max(x[0]*E,x[1]),B=b?4:1,F=[{type:"int32",data:t},{type:"int32",data:o},{type:"int32",data:i}],P=U("x",r[0].dataType,r[0].dims.length,B),W=U("w",r[1].dataType,r[1].dims.length,1),oe=J("result",r[0].dataType,n.length,B),H=[P,W];F.push(...X(r[0].dims)),F.push(...X(r[1].dims));let re="";if(s){let ie=U("bias",r[2].dataType,r[2].dims.length,B);H.push(ie),F.push(...X(r[2].dims)),re+=`
        fn getBiasByOutputCoords(coords : vec4<i32>) -> ${b?"vec4<f32>":"f32"} {
          return bias[coords.${u?"w":"y"}${b?"/ 4":""}];
        }`}return F.push(...X(n)),{name:"Conv2DTransposeMatMul",shaderCache:{hint:e.cacheKey},getRunData:()=>({outputs:[{dims:n,dataType:r[0].dataType}],dispatchGroup:{x:A[0],y:A[1],z:A[2]},programUniforms:F}),getShaderSource:ie=>`
        ${ua("uniforms.result_strides")}
        ${ie.registerUniform("dimAOuter","i32").registerUniform("dimBOuter","i32").registerUniform("dimInner","i32").declareVariables(...H,oe)};
        const outBackprop : vec4<i32> = vec4<i32>(${r[0].dims.join(",")});
        const filterDims : vec2<i32> = vec2<i32>(${e.kernelShape[u?1:2]}, ${e.kernelShape[u?2:3]});
        const effectiveFilterDims : vec2<i32> = filterDims + vec2<i32>(
              ${e.dilations[0]<=1?0:(e.kernelShape[u?1:2]-1)*(e.dilations[0]-1)},
              ${e.dilations[1]<=1?0:(e.kernelShape[u?2:3]-1)*(e.dilations[1]-1)});
        const pads : vec2<i32> = vec2<i32>(i32(effectiveFilterDims[0]) - 1 - (${e.pads[0]+e.pads[2]})/2,
                                         i32(effectiveFilterDims[1]) - 1 - (${e.pads[1]+e.pads[3]})/2);
        const strides : vec2<i32> = vec2<i32>(${e.strides[0]}, ${e.strides[1]});
        const dilation : vec2<i32> = vec2<i32>(${e.dilations[0]}, ${e.dilations[1]});
        const dimAOuter : i32 = ${t};
        const dimBOuter : i32 = ${o};
        const dimInner : i32 = ${i};
        ${re}
        ${L2(u,s,e,E)}
        ${b?$o(T,x,"f32",void 0,!u,N):So(T,x,"f32",void 0,!u,N,!1,void 0,a)}`}}});var M2,fu,Dg=D(()=>{"use strict";qr();Re();Be();M2=(r,e,n,t,o,i,s=!1,a)=>{let u=n.format==="NHWC",l=u?1:2,d=u?2:3,f=u?3:1,p=G.size(t),m=s?2:1,b=n.group,y=e[1].dims,$=y[0]/b,x=y[1],T=`
  fn setOutputAtIndex(flatIndex : u32, value : ${s?`vec4<${a}>`:a}) {
    result[flatIndex] = ${s?`vec4<${a}>`:a}(value);
  }`;o&&(T+=`
    fn getBiasByOutputCoords(coords : vec4<u32>) -> ${s?`vec4<${a}>`:a} {
      return bias[coords.${u?"w":"y"}${s?"/ 4":""}];
    }`);let A=s?4:1,E=U("W",e[1].dataType,e[1].dims,A),N=U("Dy",e[0].dataType,e[0].dims,A),B=[N,E];o&&B.push(U("bias",e[2].dataType,[t[f]],A));let F=J("result",e[0].dataType,t,A),P=`{
        let batch: u32 = ${i?"global_id.z":"workgroup_id.z"} / outShape[1];
        let r = ${i?"global_id.z":"workgroup_id.z"} % outShape[1];
        let c = ${i?"global_id.y":"workgroup_id.y"} * ${m};
        let d1: u32 = ${i?"global_id.x":"workgroup_id.x"} * 4;

        let dyCorner = vec2<i32>(i32(r), i32(c)) - vec2<i32>(pads);

        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).
        // ? = to be determined. : = across all values in that axis.
        var dotProd: array<vec4<${a}>, ${m}>;
        for (var i = 0; i < ${m}; i++) {
          dotProd[i] = vec4<${a}>(0.0);
        }
        for (var wR: u32 = 0; wR < filterDims[0]; wR = wR + 1) {
          var dyR = (${a}(dyCorner.x) + ${a}(wR)) / ${a}(strides.x);
          let wRPerm = filterDims[0] - 1 - wR;
          if (dyR < 0.0 || dyR >= ${a}(outBackprop[1]) ||
              fract(dyR) > 0.0 || wRPerm < 0) {
            continue;
          }
          let idyR: u32 = u32(dyR);

          for (var wC: u32 = 0; wC < filterDims[1]; wC = wC + 1) {
            let dyC = (${a}(dyCorner.y) + ${a}(wC)) / ${a}(strides.y);
            let dyC2 = (${a}(dyCorner.y) + 1.0 + ${a}(wC)) / ${a}(strides.y);
            let wCPerm = filterDims[1] - 1 - wC;
            if (wCPerm < 0) {
              continue;
            }
            var bDyCVal = true;
            var bDyCVal2 = true;
            if (dyC < 0.0 || dyC >= ${a}(outBackprop[2]) ||
                fract(dyC) > 0.0) {
              bDyCVal = false;
            }
            if (dyC2 < 0.0 || dyC2 >= ${a}(outBackprop[2]) ||
                fract(dyC2) > 0.0) {
              bDyCVal2 = false;
            }

            let idyC: u32 = u32(dyC);
            let idyC2: u32 = u32(dyC2);
            if (bDyCVal && bDyCVal2) {
              let d2Length = outBackprop[3];
              for (var d2 :u32 = 0; d2 < d2Length; d2 = d2 + 4) {
                let wValue0 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1","d2")};
                let wValue1 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 1","d2")};
                let wValue2 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 2","d2")};
                let wValue3 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 3","d2")};

                var xValue = ${N.get("batch","idyR","idyC","d2")};
                let tmpval = vec4<${a}>(dot(xValue, wValue0),
                                      dot(xValue, wValue1),
                                      dot(xValue, wValue2),
                                      dot(xValue, wValue3));
                dotProd[0] = dotProd[0] + tmpval;

                xValue =  ${N.get("batch","idyR","idyC2","d2")};

                dotProd[1] = dotProd[1] + vec4<${a}>(dot(xValue, wValue0),
                                                    dot(xValue, wValue1),
                                                    dot(xValue, wValue2),
                                                    dot(xValue, wValue3));
              }
            } else if (bDyCVal) {
              let d2Length = outBackprop[${f}];
              for (var d2: u32 = 0; d2 < d2Length; d2 = d2 + 4) {
                let wValue0 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1","d2")};
                let wValue1 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 1","d2")};
                let wValue2 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 2","d2")};
                let wValue3 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 3","d2")};

                var xValue = ${N.get("batch","idyR","idyC","d2")};
                let tmpval = vec4<${a}>(dot(xValue, wValue0),
                                      dot(xValue, wValue1),
                                      dot(xValue, wValue2),
                                      dot(xValue, wValue3));
                dotProd[0] = dotProd[0] + tmpval;
              }
            } else if (bDyCVal2) {
              let d2Length = outBackprop[3];
              for (var d2: u32 = 0; d2 < d2Length; d2 = d2 + 4) {
                let wValue0 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1","d2")};
                let wValue1 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 1","d2")};
                let wValue2 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 2","d2")};
                let wValue3 = ${E.get("u32(wRPerm)","u32(wCPerm)","d1 + 3","d2")};

                var xValue = ${N.get("batch","idyR","idyC2","d2")};
                let tmpval = vec4<${a}>(dot(xValue, wValue0),
                                      dot(xValue, wValue1),
                                      dot(xValue, wValue2),
                                      dot(xValue, wValue3));
                dotProd[1] = dotProd[1] + tmpval;
              }
            }
          }
        }

        for (var i: u32 = 0; i < ${m}; i = i + 1) {
          let value = dotProd[i] + ${o?"bias[c+i]":`vec4<${a}>(0.0)`};
          ${F.set("batch","r","c + i","d1","value")};
        }
      }`,W=`
          let outputIndices = ${F.offsetToIndices("global_idx")};
          let batch = ${F.indicesGet("outputIndices",0)};
          let d1 = ${F.indicesGet("outputIndices",f)};
          let r = ${F.indicesGet("outputIndices",l)};
          let c = ${F.indicesGet("outputIndices",d)};
          let dyCorner = vec2<i32>(i32(r), i32(c)) - pads;
          let dyRCorner = dyCorner.x;
          let dyCCorner = dyCorner.y;
          let groupId = d1 / ${x};
          let wOutChannel = d1 - groupId * ${x};
          // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).
          // ? = to be determined. : = across all values in that axis.
          var dotProd = ${a}(0.0);
          for (var wR: u32 = 0; wR < effectiveFilterDims.x; wR = wR + 1) {
            if (wR % dilations.x != 0) {
              continue;
            }
            let dyR = (${a}(dyRCorner) + ${a}(wR)) / ${a}(strides[0]);
            let wRPerm = filterDims.x - 1 - wR / dilations.x;
            if (dyR < 0.0 || dyR >= ${a}(outBackprop[${l}]) || fract(dyR) > 0.0 ||
                wRPerm < 0) {
              continue;
            }
            let idyR: u32 = u32(dyR);

            for (var wC: u32 = 0; wC < effectiveFilterDims.y; wC = wC + 1) {
              if (wC % dilations.y != 0) {
                continue;
              }
              let dyC = (${a}(dyCCorner) + ${a}(wC)) / ${a}(strides.y);
              let wCPerm = filterDims.y - 1 - wC / dilations.y;
              if (dyC < 0.0 || dyC >= ${a}(outBackprop[${d}]) ||
                  fract(dyC) > 0.0 || wCPerm < 0) {
                continue;
              }
              let idyC: u32 = u32(dyC);
              var inputChannel = groupId * ${$};
              for (var d2: u32 = 0; d2 < ${$}; d2 = d2 + 1) {
                let xValue = ${u?N.get("batch","idyR","idyC","inputChannel"):N.get("batch","inputChannel","idyR","idyC")};
                let wValue = ${E.get("inputChannel","wOutChannel","u32(wRPerm)","u32(wCPerm)")};
                dotProd = dotProd + xValue * wValue;
                inputChannel = inputChannel + 1;
              }
            }
          }
          let value = dotProd + ${o?"bias[d1]":`${a}(0.0)`};
          ${F.setByOffset("global_idx","value")};
        `;return`
  ${r.declareVariables(...B,F)}
  ${T}
  const outShape : vec4<u32> = vec4<u32>(${t.join(",")});
  const outBackprop : vec4<u32> = vec4<u32>(${e[0].dims.join(",")});
  const strides : vec2<u32> = vec2<u32>(${n.strides[0]}, ${n.strides[1]});
  const filterDims : vec2<u32> = vec2<u32>(${n.kernelShape[u?1:2]}, ${n.kernelShape[u?2:3]});
  const dilations : vec2<u32> = vec2<u32>(${n.dilations[0]}, ${n.dilations[1]});
  const effectiveFilterDims : vec2<u32> = filterDims + vec2<u32>(
          ${n.dilations[0]<=1?0:(n.kernelShape[u?1:2]-1)*(n.dilations[0]-1)},
          ${n.dilations[1]<=1?0:(n.kernelShape[u?2:3]-1)*(n.dilations[1]-1)});
  const pads : vec2<i32> = vec2<i32>(i32(effectiveFilterDims[0]) - 1 - (${n.pads[0]+n.pads[2]})/2,
                                     i32(effectiveFilterDims[1]) - 1 - (${n.pads[1]+n.pads[3]})/2);
    ${r.mainStart()}
    ${r.guardAgainstOutOfBoundsWorkgroupSizes(p)};
  ${s?P:W}}`},fu=(r,e,n)=>{let t=r.length>2,o=e.outputShape,i=G.size(o),s=[Math.ceil(i/64),1,1];it("verbose",()=>`[conv2d_backprop_webgpu] dispatch = ${s}`);let a=vt(r[0].dataType);return{name:"ConvTranspose2D",shaderCache:{hint:e.cacheKey},getRunData:()=>({dispatchGroup:{x:s[0],y:s[1],z:s[2]},outputs:[{dims:n?n(o):o,dataType:r[0].dataType}]}),getShaderSource:u=>M2(u,r,e,o,t,s[1]===1&&s[2]===1,!1,a)}}});var V2,F2,U2,Bg,Rg,G2,W2,H2,q2,zg,Ng=D(()=>{"use strict";Tt();kg();Dg();jr();Nn();V2=(r,e,n,t,o,i)=>(r-1)*e+n+(t-1)*o+1-i,F2=(r,e,n,t,o)=>{let i=Math.floor(r/2);e==="SAME_UPPER"?(n[t]=i,n[o]=r-i):e==="SAME_LOWER"&&(n[t]=r-i,n[o]=i)},U2=(r,e,n,t,o,i,s,a,u,l)=>{let d=r.length-2,f=l.length===0;if(u.length===0)for(let b=0;b<d;++b)u.push(0);let p=r[0],m=e[a?3:1]*o;for(let b=0,y=r.length-d-(a?1:0);b<d;++b,++y){let $=r[y],x=f?$*s[b]:l[b],T=V2($,s[b],i[b],e[y],n[b],x);F2(T,t,i,b,b+d),f&&l.push(s[b]*($-1)+u[b]+(e[y]-1)*n[b]+1-i[b]-i[b+d])}l.splice(0,0,p),l.splice(a?3:1,0,m)},Bg=(r,e)=>{let n=r.kernelShape.slice();if(r.kernelShape.length===0||r.kernelShape.reduce((p,m)=>p*m,1)===0){n.length=0;for(let p=2;p<e[1].dims.length;++p)n.push(e[1].dims[p])}let t=r.format==="NHWC";n.splice(0,0,e[1].dims[0]),n.splice(t?3:1,0,e[1].dims[1]);let o=r.pads.slice(),i=r.outputShape.slice(),s=r.outputPadding.slice(),a=e[0].dims,u=r.dilations.slice();if(u.reduce((p,m)=>p+m,0)===0){let p=e[0].dims.length-2;u=new Array(p).fill(1)}let l=r.strides.slice();if(l.reduce((p,m)=>p+m,0)===0){let p=e[0].dims.length-2;l=new Array(p).fill(1)}U2(a,n,u,r.autoPad,r.group,o,l,t,s,i);let d=Object.assign({},r),f=r.cacheKey+[n.join("n,"),o.join(","),l.join(","),s.join(","),i.join(","),u.join(",")].join("_");return Object.assign(d,{kernelShape:n,pads:o,outputPadding:s,outputShape:i,dilations:u,strides:l,cacheKey:f}),d},Rg=r=>{let e=ia(r),n=r.format,t=["NOTSET","VALID","SAME_UPPER","SAME_LOWER"][typeof r.autoPad>"u"?0:r.autoPad],o=r.dilations,i=r.group,s=r.kernelShape,a=r.pads,u=r.strides,l=r.wIsConst(),d=r.outputPadding,f=r.outputShape;return Oe({autoPad:t,format:n,dilations:o,group:i,kernelShape:s,outputPadding:d,outputShape:f,pads:a,strides:u,wIsConst:l,...e})},G2=(r,e)=>{if(!r||r.length!==2&&r.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(r[0].dims.length!==4&&r[0].dims.length!==3)throw new Error("currently only support 2-dimensional conv");if(r[0].dims.length!==r[1].dims.length)throw new Error("filter does not have same dimension as input");let n=r[0].dims[e.format==="NHWC"?r[0].dims.length-1:1],t=r[1].dims[0];if(n!==t)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");let o=r[1].dims[1]*e.group;if(r.length===3&&(r[2].dims.length!==1||r[2].dims[0]!==o))throw new Error("invalid bias");let i=r[0].dims.length-2;if(e.dilations.reduce((d,f)=>d+f,0)>0&&e.dilations.length!==i)throw new Error(`dilations should be ${i}D`);if(e.strides.reduce((d,f)=>d+f,0)>0&&e.strides.length!==i)throw new Error(`strides should be ${i}D`);if(e.pads.reduce((d,f)=>d+f,0)>0&&e.pads.length!==i*2)throw new Error(`pads should be ${i*2}D`);if(e.outputPadding.length!==i&&e.outputPadding.length!==0)throw new Error(`output_padding should be ${i}D`);if(e.kernelShape.reduce((d,f)=>d+f,0)>0&&e.kernelShape.length!==0&&e.kernelShape.length!==r[1].dims.length-2)throw new Error("invalid kernel shape");if(e.outputShape.length!==0&&e.outputShape.length!==r[0].dims.length-2)throw new Error("invalid output shape")},W2=[2,3,1,0],H2=(r,e,n)=>{let t=Bg(n,e),o=n.format==="NHWC",i=t.outputShape,s=i[o?3:1],a=e[0].dims[o?3:1];if(t.group!==1||s===1&&a===1){r.compute(fu(e,t));return}let u=i[o?1:2],l=i[o?2:3],d=e[1].dims[2],f=e[1].dims[3],p=o?u*l:s,m=o?s:u*l,b=d*f*a,y=!0,$=r.kernelCustomData.wT??r.compute(lr(e[1],W2),{inputs:[1],outputs:[n.wIsConst?-2:-1]})[0];n.wIsConst&&!r.kernelCustomData.wT&&(r.kernelCustomData.wT=$);let x=[e[0],$],T=e.length===3;T&&(!o&&e[2].dims.length===1?x.push(e[2].reshape([e[2].dims[0],1,1])):x.push(e[2])),r.compute(Pg(x,t,i,p,m,b,T,y),{inputs:x})},q2=(r,e)=>{let n=e.format==="NHWC",t=[r.inputs[0].reshape(n?[r.inputs[0].dims[0],1,r.inputs[0].dims[1],r.inputs[0].dims[2]]:[r.inputs[0].dims[0],r.inputs[0].dims[1],1,r.inputs[0].dims[2]]),r.inputs[1].reshape([r.inputs[1].dims[0],r.inputs[1].dims[1],1,r.inputs[1].dims[2]])];t.length===3&&t.push(r.inputs[2]);let o=e.kernelShape;(o.length===0||o[0]===0)&&(o=[r.inputs[1].dims[2]]);let i=e.dilations;(i.length===0||i[0]===0)&&(i=[1]);let s=e.strides;(s.length===0||s[0]===0)&&(s=[1]);let a=e.pads;a.length===0&&(a=[0,0]),a=[0,a[0],0,a[1]],s=[1].concat(s),i=[1].concat(i),o=[1].concat(o);let u=Bg({...e,pads:a,strides:s,dilations:i,kernelShape:o},t);r.compute(fu(t,u,l=>n?[l[0],l[2],l[3]]:[l[0],l[1],l[3]]))},zg=(r,e)=>{G2(r.inputs,e),r.inputs[0].dims.length===3?q2(r,e):H2(r,r.inputs,e)}});var j2,Lg,Mg,Vg=D(()=>{"use strict";ut();Re();Tt();Be();j2=(r,e,n,t)=>{let o=G.size(e),i=e.length,s=U("input",r,i),a=J("output",r,i),u=n.dataType===6?n.getInt32Array()[0]:Number(n.getBigInt64Array()[0]),l=G.normalizeAxis(u,i),d=f=>{let p=` i32(${s.indicesGet("inputIndices","uniforms.axis")}) `,m=Te("uniforms.input_shape","uniforms.axis",i),b=t.reverse?p+(t.exclusive?" + 1":""):"0",y=t.reverse?m:p+(t.exclusive?"":" + 1");return`
                ${f.registerUniform("outputSize","u32").registerUniform("axis","u32").declareVariables(s,a)}
                ${f.mainStart()}
                  ${f.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
                  var inputIndices = ${a.offsetToIndices("global_idx")};
                  var sum = ${a.type.value}(0);
                  let first : i32 = ${b};
                  let last : i32 = ${y};
                  for (var i : i32 = first; i < last; i++) {
                    ${s.indicesSet("inputIndices","uniforms.axis","u32(i)")};
                    sum = sum + ${s.getByIndices("inputIndices")};
                  }
                  ${a.setByOffset("global_idx","sum")};
                }`};return{name:"CumSum",shaderCache:{hint:t.cacheKey,inputDependencies:["rank"]},getRunData:()=>({outputs:[{dims:e,dataType:r}],dispatchGroup:{x:Math.ceil(o/64)},programUniforms:[{type:"uint32",data:o},{type:"int32",data:l},...X(e),...X(e)]}),getShaderSource:d}},Lg=(r,e)=>{let n=r.inputs[0].dims,t=r.inputs[0].dataType,o=r.inputs[1];r.compute(j2(t,n,o,e),{inputs:[0]})},Mg=r=>{let e=r.exclusive===1,n=r.reverse===1;return Oe({exclusive:e,reverse:n})}});var pu,da,Fg,K2,Y2,hu,mu,Ug,X2,Gg,Wg,Hg=D(()=>{"use strict";Re();Tt();Be();pu="[a-zA-Z]|\\.\\.\\.",da="("+pu+")+",Fg="^"+da+"$",K2="("+da+",)*"+da,Y2="^"+K2+"$",hu=class{constructor(e=-1){this.symbolToIndices=new Map,this.inputIndex=e}addSymbol(e,n){let t=this.symbolToIndices.get(e);t===void 0?t=[n]:t.push(n),this.symbolToIndices.set(e,t)}},mu=class{constructor(e,n){this.equation=n;this.hasEllipsis=!1,this.symbolToInfo=new Map,this.lhs=new Array,this.outputDims=[];let[t,o]=n.includes("->")?n.split("->",2):[n,""];if(!t.match(RegExp(Y2)))throw new Error("Invalid LHS term");if(t.split(",").forEach((a,u)=>{let l=e[u].dims.slice();if(!a.match(RegExp(Fg)))throw new Error("Invalid LHS term");let d=this.processTerm(a,!0,l,u);this.lhs.push(d)}),o==="")o+=[...this.symbolToInfo.entries()].filter(([a,u])=>u.count===1||a==="...").map(([a])=>a).join("");else if(!o.match(RegExp(da)))throw new Error("Invalid RHS");o.match(RegExp(pu,"g"))?.forEach(a=>{if(a==="...")this.outputDims=this.outputDims.concat(this.ellipsisDims);else{let u=this.symbolToInfo.get(a);if(u===void 0)throw new Error("Invalid RHS symbol");this.outputDims.push(u.dimValue)}}),this.rhs=this.processTerm(o,!1,this.outputDims)}addSymbol(e,n,t){let o=this.symbolToInfo.get(e);if(o!==void 0){if(o.dimValue!==n&&o.count!==1)throw new Error("Dimension mismatch");o.count++,o.inputIndices.push(t)}else o={count:1,dimValue:n,inputIndices:[t]};this.symbolToInfo.set(e,o)}processTerm(e,n,t,o=-1){let i=t.length,s=!1,a=[],u=0;if(!e.match(RegExp(Fg))&&!n&&e!=="")throw new Error("Invalid LHS term");let l=e.match(RegExp(pu,"g")),d=new hu(o);return l?.forEach((f,p)=>{if(f==="..."){if(s)throw new Error("Only one ellipsis is allowed per input term");s=!0;let m=i-l.length+1;if(m<0)throw new Error("Ellipsis out of bounds");if(a=t.slice(u,u+m),this.hasEllipsis){if(this.ellipsisDims.length!==a.length||this.ellipsisDims.toString()!==a.toString())throw new Error("Ellipsis dimensions mismatch")}else if(n)this.hasEllipsis=!0,this.ellipsisDims=a;else throw new Error("Ellipsis must be specified in the LHS");for(let b=0;b<a.length;b++){let y=String.fromCharCode("0".charCodeAt(0)+b);d.addSymbol(y,p+b),this.addSymbol(y,t[u++],o)}}else d.addSymbol(f,p+(this.hasEllipsis?this.ellipsisDims.length-1:0)),this.addSymbol(f,t[u++],o)}),d}},Ug=r=>r+"_max",X2=(r,e,n,t,o)=>{let s=e.map((m,b)=>r[b]?m.length:m).map((m,b)=>U(`input${b}`,n,m)),a=G.size(o),u=nt(o.length),l=u?o.length:o,d=J("output",n,l),f=[...t.symbolToInfo.keys()].filter(m=>!t.rhs.symbolToIndices.has(m)),p=m=>{let b=[],y="var prod = 1.0;",$="var sum = 0.0;",x="sum += prod;",T=[],A=[],E=[],N=[],B=t.symbolToInfo.size===t.rhs.symbolToIndices.size;t.symbolToInfo.forEach((P,W)=>{if(t.rhs.symbolToIndices.has(W)){let oe=t.rhs.symbolToIndices.get(W)?.[0];oe!==void 0&&t.lhs.forEach((H,re)=>{if(P.inputIndices.includes(re)){let ie=H.symbolToIndices.get(W);if(ie===void 0)throw new Error("Invalid symbol error");ie.forEach(ne=>{b.push(`${s[re].indicesSet(`input${re}Indices`,ne,d.indicesGet("outputIndices",oe))}`)})}})}else t.lhs.forEach((oe,H)=>{if(P.inputIndices.includes(H)){let re=oe.symbolToIndices.get(W);if(re===void 0)throw new Error("Invalid symbol error");re.forEach(ie=>{T.push(`${s[H].indicesSet(`input${H}Indices`,ie,`${W}`)}`)}),N.push(`prod *= ${s[H].getByIndices(`input${H}Indices`)};`)}}),A.push(`for(var ${W}: u32 = 0; ${W} < uniforms.${Ug(W)}; ${W}++) {`),E.push("}")});let F=B?[...b,`let sum = ${s.map((P,W)=>P.getByIndices(`input${W}Indices`)).join(" * ")};`]:[...b,$,...A,...T,y,...N,x,...E];return`
            ${m.registerUniforms(f.map(P=>({name:`${Ug(P)}`,type:"u32"}))).registerUniform("outputSize","u32").declareVariables(...s,d)}

            ${m.mainStart()}
            ${m.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
            var outputIndices = ${d.offsetToIndices("global_idx")};
            ${s.map((P,W)=>`var input${W}Indices: ${s[W].type.indices};`).join(`
`)}
            ${F.join(`
`)};
            ${d.setByOffset("global_idx","sum")};
          }`};return{name:"Einsum",shaderCache:{hint:t.equation,inputDependencies:r.map(m=>m?"rank":"dims")},getRunData:()=>{let m=f.filter(y=>t.symbolToInfo.has(y)).map(y=>({type:"uint32",data:t.symbolToInfo.get(y)?.dimValue||0}));m.push({type:"uint32",data:a});let b=e.filter((y,$)=>r[$]).map((y,$)=>[...X(y)]).reduce((y,$)=>y.concat($),m);return u&&b.push(...X(o)),{outputs:[{dims:o,dataType:n}],dispatchGroup:{x:Math.ceil(a/64)},programUniforms:b}},getShaderSource:p}},Gg=(r,e)=>{let n=new mu(r.inputs,e.equation),t=r.inputs.map((s,a)=>nt(s.dims.length)),o=n.outputDims,i=r.inputs.map((s,a)=>s.dims);r.compute(X2(t,i,r.inputs[0].dataType,n,o))},Wg=r=>{let e=r.equation.replace(/\s+/g,"");return Oe({equation:e})}});var Z2,qg,J2,Q2,jg,Kg=D(()=>{"use strict";ut();Re();Be();Z2=r=>{if(!r||r.length!==2)throw new Error("Expand requires 2 input.");let e=r[0].dims,n=Array.from(r[1].getBigInt64Array(),Number),t=n.length<e.length?0:n.length-e.length,o=e.length<n.length?0:e.length-n.length;for(;t<n.length&&o<e.length;++t,++o)if(n[t]!==e[o]&&n[t]!==1&&e[o]!==1)throw new Error("Expand requires shape to be broadcastable to input")},qg=(r,e)=>{let n=r.length-e.length,t=[];for(let o=0;o<n;++o)t.push(r[o]);for(let o=0;o<e.length;++o)t.push(e[o]===1?r[o+n]:e[o]);return t},J2=(r,e)=>r.length>e.length?qg(r,e):qg(e,r),Q2=r=>{let e=r[0].dims,n=Array.from(r[1].getBigInt64Array(),Number),t=J2(e,n),o=r[0].dataType,i=o===9?4:1,s=Math.ceil(G.size(t)/i),a=nt(e.length),u=nt(t.length),l=f=>{let p=a?e.length:e,m=u?t.length:t,b=U("input",o,p,i),y=J("output",o,m,i),$;if(o===9){let x=(T,A,E="")=>`
          let outputIndices${A} = ${y.offsetToIndices(`outputOffset + ${A}u`)};
          let offset${A} = ${b.broadcastedIndicesToOffset(`outputIndices${A}`,y)};
          let index${A} = offset${A} / 4u;
          let component${A} = offset${A} % 4u;
          ${T}[${A}] = ${E}(${b.getByOffset(`index${A}`)}[component${A}]);
        `;$=`
        let outputOffset = global_idx * ${i};
        var data = vec4<u32>(0);
        ${x("data",0,"u32")}
        ${x("data",1,"u32")}
        ${x("data",2,"u32")}
        ${x("data",3,"u32")}
        ${y.setByOffset("global_idx","data")}
      }`}else $=`
        let outputIndices = ${y.offsetToIndices("global_idx")};
        let inputOffset = ${b.broadcastedIndicesToOffset("outputIndices",y)};
        ${y.setByOffset("global_idx",b.getByOffset("inputOffset"))}
      }`;return`
    ${f.registerUniform("vec_size","u32").declareVariables(b,y)}
    ${f.mainStart()}
    ${f.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}
    ${$}`},d=[{type:"uint32",data:s}];return a&&d.push(...X(e)),u&&d.push(...X(t)),{name:"Expand",shaderCache:{hint:`${t.length}`,inputDependencies:[a?"rank":"dims"]},getShaderSource:l,getRunData:()=>({outputs:[{dims:t,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(s/64)},programUniforms:d})}},jg=r=>{Z2(r.inputs),r.compute(Q2(r.inputs),{inputs:[0]})}});var e1,t1,Yg,Xg,Zg=D(()=>{"use strict";ut();Re();Tt();Be();e1=r=>{if(!r||r.length!==2)throw new Error("Gather requires 2 inputs.")},t1=(r,e)=>{let n=r[0].dims,t=r[1].dims,o=n.length,i=G.normalizeAxis(e.axis,o),s=n.slice(0);s.splice(i,1,...t);let a=n[i],u=r[0].dataType===9?4:1,l=Math.ceil(G.size(s)/u),d=nt(r[0].dims.length),f=d?r[0].dims.length:r[0].dims,p=nt(r[1].dims.length),m=p?r[1].dims.length:r[1].dims,b=nt(s.length),y=b?s.length:s,$=[{type:"uint32",data:l},{type:"int32",data:a},{type:"uint32",data:i}];d&&$.push(...X(r[0].dims)),p&&$.push(...X(r[1].dims)),b&&$.push(...X(s));let x=[];x.push(d?"rank":"dims"),x.push(p?"rank":"dims");let T=A=>{let E=U("data",r[0].dataType,f,u),N=U("inputIndices",r[1].dataType,m),B=J("output",r[0].dataType,y,u),F=W=>{let oe=t.length,H=`var indicesIndices${W}  = ${N.type.indices}(0);`;for(let re=0;re<oe;re++)H+=`${oe>1?`indicesIndices${W}[${re}]`:`indicesIndices${W}`} = ${s.length>1?`outputIndices${W}[uniforms.axis + ${re}]`:`outputIndices${W}`};`;H+=`
          var idx${W} = ${N.getByIndices(`indicesIndices${W}`)};
          if (idx${W} < 0) {
            idx${W} = idx${W} + uniforms.axisDimLimit;
          }
          var dataIndices${W} = ${E.type.indices}(0);
        `;for(let re=0,ie=0;re<o;re++)re===i?(H+=`${o>1?`dataIndices${W}[${re}]`:`dataIndices${W}`} = u32(idx${W});`,ie+=oe):(H+=`${o>1?`dataIndices${W}[${re}]`:`dataIndices${W}`} = ${s.length>1?`outputIndices${W}[${ie}]`:`outputIndices${W}`};`,ie++);return H},P;if(r[0].dataType===9){let W=(oe,H,re="")=>`
          let outputIndices${H} = ${B.offsetToIndices(`outputOffset + ${H}u`)};
          ${F(H)};
          let offset${H} = ${E.indicesToOffset(`dataIndices${H}`)};
          let index${H} = offset${H} / 4u;
          let component${H} = offset${H} % 4u;
          ${oe}[${H}] = ${re}(${E.getByOffset(`index${H}`)}[component${H}]);
        `;P=`
        let outputOffset = global_idx * ${u};
        var value = vec4<u32>(0);
        ${W("value",0,"u32")}
        ${W("value",1,"u32")}
        ${W("value",2,"u32")}
        ${W("value",3,"u32")}
        ${B.setByOffset("global_idx","value")}
      `}else P=`
      let outputIndices = ${B.offsetToIndices("global_idx")};
      ${F("")};
      let value = ${E.getByIndices("dataIndices")};
      ${B.setByOffset("global_idx","value")};
      `;return`
      ${A.registerUniform("outputSize","u32").registerUniform("axisDimLimit","i32").registerUniform("axis","u32").declareVariables(E,N,B)}
      ${A.mainStart()}
        ${A.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
        ${P}
      }`};return{name:"Gather",shaderCache:{hint:e.cacheKey,inputDependencies:x},getRunData:()=>({outputs:[{dims:s,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(l/64)},programUniforms:$}),getShaderSource:T}},Yg=r=>Oe({axis:r.axis}),Xg=(r,e)=>{let n=r.inputs;e1(n),r.compute(t1(r.inputs,e))}});var r1,n1,Jg,Qg,eb=D(()=>{"use strict";Re();Tt();Be();r1=r=>{if(!r||r.length!==2)throw new Error("GatherElements requires 2 inputs.");if(r[0].dims.length<1)throw new Error("GatherElements requires that the data input be rank >= 1.");if(r[0].dims.length!==r[1].dims.length)throw new Error(`GatherElements requires that the data input and
                     indices input tensors be of same rank.`)},n1=(r,e)=>{let n=r[0].dims,t=r[0].dataType,o=n.length,i=r[1].dims,s=r[1].dataType,a=G.normalizeAxis(e.axis,o),u=n[a],l=i.slice(0),d=G.size(l),f=U("input",t,o),p=U("indicesInput",s,i.length),m=J("output",t,l.length),b=[{type:"uint32",data:d},{type:"int32",data:u},{type:"uint32",data:a}];return b.push(...X(n)),b.push(...X(i)),b.push(...X(l)),{name:"GatherElements",shaderCache:{inputDependencies:["rank","rank"]},getRunData:()=>({outputs:[{dims:l,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(d/64)},programUniforms:b}),getShaderSource:x=>`
      ${x.registerUniform("outputSize","u32").registerUniform("axisDimLimit","i32").registerUniform("axis","u32").declareVariables(f,p,m)}
      ${x.mainStart()}
      ${x.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}

      let outputIndices = ${m.offsetToIndices("global_idx")};

      var idx = ${p.getByOffset("global_idx")};
      if (idx < 0) {
        idx = idx + uniforms.axisDimLimit;
      }
      var inputIndices = ${f.type.indices}(outputIndices);
      ${f.indicesSet("inputIndices","uniforms.axis","u32(idx)")};
      let value = ${f.getByIndices("inputIndices")};

      ${m.setByOffset("global_idx","value")};
  }`}},Jg=r=>Oe({axis:r.axis}),Qg=(r,e)=>{let n=r.inputs;r1(n),r.compute(n1(r.inputs,e))}});var o1,i1,tb,rb,nb=D(()=>{"use strict";Re();Be();o1=r=>{if(!r)throw new Error("Input is missing");if(r.length<2||r.length>3)throw new Error("Invaid input number.");if(r.length===3&&r[2].dims.length>2)throw new Error("Invalid input shape of C");if(r[0].dataType!==r[1].dataType||r.length===3&&r[0].dataType!==r[2].dataType)throw new Error("Input types are mismatched")},i1=(r,e)=>{let n=r[0].dims.slice(),t=r[1].dims.slice(),[o,i,s]=Xi.getShapeOfGemmResult(n,e.transA,t,e.transB,r.length===3?r[2].dims:void 0),a=[o,i];if(!a)throw new Error("Can't use gemm on the given tensors");let u=G.size(a),l=[{type:"uint32",data:u},{type:"uint32",data:o},{type:"uint32",data:i},{type:"uint32",data:s},{type:"float32",data:e.alpha},{type:"float32",data:e.beta}],d=["type","type"];r.length===3&&(l.push(...X(r[2].dims)),d.push("rank")),l.push(...X(a));let f=p=>{let m="";e.transA&&e.transB?m="value += a[k * uniforms.M + m] * b[n * uniforms.K + k];":e.transA&&!e.transB?m="value += a[k * uniforms.M + m] * b[k * uniforms.N + n];":!e.transA&&e.transB?m="value += a[m * uniforms.K + k] * b[n * uniforms.K + k];":!e.transA&&!e.transB&&(m="value += a[m * uniforms.K + k] * b[k * uniforms.N + n];");let b=e.alpha===1?"":"value *= uniforms.alpha;",y=U("a",r[0].dataType,r[0].dims),$=U("b",r[1].dataType,r[1].dims),x=y.type.value,T=null,A=[y,$];r.length===3&&(T=U("c",r[2].dataType,r[2].dims.length),A.push(T));let E=J("output",r[0].dataType,a.length);A.push(E);let N=[{name:"output_size",type:"u32"},{name:"M",type:"u32"},{name:"N",type:"u32"},{name:"K",type:"u32"},{name:"alpha",type:"f32"},{name:"beta",type:"f32"}];return`
  ${p.registerUniforms(N).declareVariables(...A)}

  ${p.mainStart()}
    ${p.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}

    let m = global_idx / uniforms.N;
    let n = global_idx % uniforms.N;

    var value = ${x}(0);
    for (var k: u32 = 0u; k < uniforms.K; k++) {
      ${m}
    }

    ${b}
    ${(()=>T!=null?`let cOffset = ${T.broadcastedIndicesToOffset("vec2(m, n)",E)}; value += ${x}(uniforms.beta) * ${T.getByOffset("cOffset")};`:"")()}
    output[global_idx] = value;
  }`};return{name:"Gemm",shaderCache:{hint:`${e.cacheKey}`,inputDependencies:d},getRunData:()=>({outputs:[{dims:a,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(u/64)},programUniforms:l}),getShaderSource:f}},tb=r=>{let e=r.transA,n=r.transB,t=r.alpha,o=r.beta;return{transA:e,transB:n,alpha:t,beta:o,cacheKey:`${r.transA};${r.transB};${r.alpha===1}`}},rb=(r,e)=>{o1(r.inputs),r.compute(i1(r.inputs,e))}});var a1,s1,u1,ob,ib=D(()=>{"use strict";ut();Re();Be();a1=(r,e)=>{let n=r[0].dims,t=n,o=2,i=G.sizeToDimension(n,o),s=G.sizeFromDimension(n,o),a=wt(s),u=s/a,l=[n[0],n[1],u],d=["rank","type","type"],f=[{type:"uint32",data:s},{type:"uint32",data:u}];f.push(...X(l),...X(l));let p=m=>{let b=U("x",r[0].dataType,l.length,a),y=U("scale",r[1].dataType,r[1].dims),$=U("bias",r[2].dataType,r[2].dims),x=J("output",r[0].dataType,l.length,a),T=[b,y,$,x],A=b.type.value,E=a===1?"f32":`vec${a}<f32>`,N=64,B=[{name:"normSize",type:"u32"},{name:"normPackedSize",type:"u32"}];return`
  var<workgroup> meanShared : f32;
  var<workgroup> squaredNormShared : f32;
  var<workgroup> workgroupShared : array<${E}, ${N}>;
  const workgroupSize = ${N}u;
  ${m.registerUniforms(B).declareVariables(...T)}
  ${m.mainStart(N)}
    let norm = global_idx / workgroupSize;
    let batch = norm / uniforms.x_shape[1];
    let channel = norm % uniforms.x_shape[1];
    let localIndex = local_id.x;

    // initialize workgroup memory
    var initial = ${E}(0);
    for (var h = localIndex; h < uniforms.normPackedSize; h += workgroupSize) {
      initial = initial + ${E}(${b.get("batch","channel","h")});
    }
    workgroupShared[localIndex] = initial;
    workgroupBarrier();

    // Calculate the mean of current channel data.
    for (var currSize = workgroupSize >> 1;  currSize > 0; currSize = currSize >> 1) {
      if (localIndex < currSize) {
        workgroupShared[localIndex] = workgroupShared[localIndex] + workgroupShared[localIndex + currSize];
      }
      workgroupBarrier();
    }
    if (localIndex == 0) {
      meanShared = ${Ut("workgroupShared[0]",a)} / f32(uniforms.normSize);
    }
    workgroupBarrier();

    // reinitialize workgroup memory.
    initial = ${E}(0);
    for (var h = localIndex; h < uniforms.normPackedSize; h += workgroupSize) {
      let deviation =  ${E}(${b.get("batch","channel","h")}) - ${E}(meanShared);
      initial = initial + deviation * deviation;
    }
    workgroupShared[localIndex] = initial;
    workgroupBarrier();

    // Calculate the sum of square of deviation of current channel data.
    for (var currSize = workgroupSize >> 1;  currSize > 0; currSize = currSize >> 1) {
      if (localIndex < currSize) {
        workgroupShared[localIndex] = workgroupShared[localIndex] + workgroupShared[localIndex + currSize];
      }
      workgroupBarrier();
    }
    if (localIndex == 0) {
      squaredNormShared = ${Ut("workgroupShared[0]",a)};
    }
    workgroupBarrier();

    let invStdDev = inverseSqrt(squaredNormShared / f32(uniforms.normSize) + f32(${e.epsilon}));
    let channelScale = invStdDev * f32(${y.getByOffset("channel")});
    let channelShift = f32(${$.getByOffset("channel")}) - meanShared * channelScale;
    for (var h = localIndex; h < uniforms.normPackedSize; h += workgroupSize) {
      let value = ${b.get("batch","channel","h")} * ${A}(${E}(channelScale)) + ${A}(${E}(channelShift));
      ${x.set("batch","channel","h","value")};
    }
  }`};return{name:"InstanceNormalization",shaderCache:{hint:`${e.epsilon};${a}`,inputDependencies:d},getRunData:()=>({outputs:[{dims:t,dataType:r[0].dataType}],dispatchGroup:{x:i},programUniforms:f}),getShaderSource:p}},s1=(r,e,n,t,o,i,s,a)=>{let u=wt(s),l=64,d=u===1?"vec2f":`mat2x${u}f`,f=u===1?"f32":`vec${u}f`,p=(B,F)=>`${d}(${B}, ${F})`,m=o*s/u,b=Math.ceil(i/l),y=["type"],$=[{type:"uint32",data:b},{type:"uint32",data:i},{type:"uint32",data:Math.floor(s/u)},{type:"uint32",data:Math.floor(i*s/u)}],x=B=>{let F=U("input",e.dataType,e.dims,u);return`
  ${B.declareVariables(F)}
  @group(0) @binding(1) var<storage, read_write> output : array<${d}>;
  struct Uniforms {wg_size:u32, H:u32, C:u32, image_size:u32};
  @group(0) @binding(2) var<uniform> uniforms: Uniforms;

  ${B.mainStart(l)}
    let currentImageNumber = global_idx / ${l} / uniforms.C;
    let currentChannelNumber = (global_idx / ${l}) % uniforms.C;
    let wgId = global_idx % ${l};
    let wgOffset = wgId * uniforms.wg_size;
    if (wgOffset >= uniforms.H) {
        return;
    }
    let wgMax = min(wgOffset + uniforms.wg_size, uniforms.H);

    let offset = currentImageNumber * uniforms.image_size + currentChannelNumber;
    var sum = ${Pt("f32",u)};
    var squaredSum = ${Pt("f32",u)};
    for (var i: u32 = wgOffset; i < wgMax; i++) {
        let value = ${f}(input[offset + i * uniforms.C]);
        sum += value;
        squaredSum += value * value;
    }
    output[global_idx] = ${p("sum","squaredSum")};
  }`},T=r.compute({name:"InstanceNormComputeMean",shaderCache:{hint:`${u}`,inputDependencies:y},getRunData:()=>({outputs:[{dims:[o,s,l,2],dataType:1}],dispatchGroup:{x:o*s/u},programUniforms:$}),getShaderSource:x},{inputs:[e],outputs:[-1]})[0],A=[{type:"uint32",data:m},{type:"uint32",data:i},{type:"uint32",data:Math.floor(s/u)},{type:"uint32",data:Math.floor(l*s/u)}],E=["type","type","type"],N=B=>{let F=U("scale",n.dataType,n.dims,u),P=U("bias",t.dataType,t.dims,u);return`
  @group(0) @binding(0) var<storage, read> input : array<${d}>;
  @group(0) @binding(1) var<storage, read> scale : array<${F.type.storage}>;
  @group(0) @binding(2) var<storage, read> bias : array<${P.type.storage}>;
  @group(0) @binding(3) var<storage, read_write> output : array<${d}>;
  struct Uniforms {units_of_work : u32, H: u32, C : u32, image_size : u32};
  @group(0) @binding(4) var<uniform> uniforms: Uniforms;

  ${B.mainStart()}
    ${B.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.units_of_work")}
    let currentImageNumber = global_idx / uniforms.C;
    let currentChannelNumber = global_idx % uniforms.C;

    let offset = currentImageNumber * uniforms.image_size;
    var sum = ${Pt("f32",u)};
    var squaredSum = ${Pt("f32",u)};
    for (var i: u32 = 0; i < ${l}; i++) {
        let value = input[offset + i + currentChannelNumber * ${l}];
        sum += value[0];
        squaredSum += value[1];
    }
    sum = sum / f32(uniforms.H);
    squaredSum = squaredSum / f32(uniforms.H);
    let invStdDev = inverseSqrt(squaredSum - sum * sum + f32(${a}));
    let channelScale = invStdDev * ${f}(scale[currentChannelNumber]);
    let channelShift = ${f}(bias[currentChannelNumber]) - sum * channelScale;

    output[global_idx] = ${p("channelScale","channelShift")};
  }`};return r.compute({name:"InstanceNormComputeChannelScaleShift",shaderCache:{hint:`${u};${a}`,inputDependencies:E},getRunData:()=>({outputs:[{dims:[o,s,2],dataType:1}],dispatchGroup:{x:Math.ceil(m/64)},programUniforms:A}),getShaderSource:N},{inputs:[T,n,t],outputs:[-1]})[0]},u1=(r,e,n)=>{let t=e[0].dims,o=t,i=t[0],s=t[t.length-1],a=G.sizeFromDimension(t,1)/s,u=wt(s),l=G.size(o)/u,d=[{type:"uint32",data:a},{type:"uint32",data:Math.floor(s/u)}],f=["type","type"],p=s1(r,e[0],e[1],e[2],i,a,s,n.epsilon),m=b=>{let y=vt(e[0].dataType),$=u===1?"vec2f":`mat2x${u}f`,x=u===1?y:`vec${u}<${y}>`,T=U("input",e[0].dataType,e[0].dims,u),A=J("output",e[0].dataType,o,u);return`
  @group(0) @binding(0) var<storage, read> input : array<${T.type.storage}>;
  @group(0) @binding(1) var<storage, read> scaleInput : array<${$}>;
  @group(0) @binding(2) var<storage, read_write> output : array<${A.type.storage}>;
  struct Uniforms {H: u32, C : u32};
  @group(0) @binding(3) var<uniform> uniforms: Uniforms;

  ${b.mainStart()}
    let currentImageNumber = global_idx / (uniforms.C * uniforms.H);
    let currentChannelNumber = global_idx % uniforms.C;

    let scaleOffset = currentImageNumber * uniforms.C + currentChannelNumber;
    let scale = scaleInput[scaleOffset];
    output[global_idx] = fma(input[global_idx], ${x}(scale[0]), ${x}(scale[1]));
  }`};r.compute({name:"InstanceNormalizationNHWC",shaderCache:{hint:`${u}`,inputDependencies:f},getRunData:()=>({outputs:[{dims:o,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(l/64)},programUniforms:d}),getShaderSource:m},{inputs:[e[0],p]})},ob=(r,e)=>{e.format==="NHWC"?u1(r,r.inputs,e):r.compute(a1(r.inputs,e))}});var l1,d1,ab,sb=D(()=>{"use strict";ut();Re();Be();l1=r=>{if(!r||r.length<2)throw new Error("layerNorm requires at least 2 inputs.")},d1=(r,e,n)=>{let t=r[0].dims,o=r[1],i=r[2],s=t,a=G.normalizeAxis(e.axis,t.length),u=G.sizeToDimension(t,a),l=G.sizeFromDimension(t,a),d=G.size(o.dims),f=i?G.size(i.dims):0;if(d!==l||i&&f!==l)throw new Error(`Size of X.shape()[axis:] == ${l}.
       Size of scale and bias (if provided) must match this.
       Got scale size of ${d} and bias size of ${f}`);let p=[];for(let E=0;E<t.length;++E)E<a?p.push(t[E]):p.push(1);let m=wt(l),b=["type","type"],y=[{type:"uint32",data:u},{type:"float32",data:l},{type:"uint32",data:Math.floor(l/m)},{type:"float32",data:e.epsilon}];i&&b.push("type");let $=n>1,x=n>2,T=E=>{let N=vt(r[0].dataType),B=[U("x",r[0].dataType,r[0].dims,m),U("scale",o.dataType,o.dims,m)];i&&B.push(U("bias",i.dataType,i.dims,m)),B.push(J("output",r[0].dataType,s,m)),$&&B.push(J("mean_data_output",1,p)),x&&B.push(J("inv_std_output",1,p));let F=[{name:"norm_count",type:"u32"},{name:"norm_size",type:"f32"},{name:"norm_size_vectorized",type:"u32"},{name:"epsilon",type:"f32"}];return`
  ${E.registerUniforms(F).declareVariables(...B)}
  ${E.mainStart()}
    ${E.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.norm_count")}
    let offset = global_idx * uniforms.norm_size_vectorized;
    var meanVector = ${Pt("f32",m)};
    var meanSquareVector = ${Pt("f32",m)};

    for (var h: u32 = 0u; h < uniforms.norm_size_vectorized; h++) {
      let value = ${ur(N,m,"x[h + offset]")};
      meanVector += value;
      meanSquareVector += value * value;
    }
    let mean = ${Ut("meanVector",m)} / uniforms.norm_size;
    let invStdDev =
        inverseSqrt(${Ut("meanSquareVector",m)} / uniforms.norm_size - mean * mean + uniforms.epsilon);

    for (var j: u32 = 0; j < uniforms.norm_size_vectorized; j++) {
      let f32input = ${ur(N,m,"x[j + offset]")};
      let f32scale = ${ur(N,m,"scale[j]")};
      output[j + offset] = ${B[0].type.value}((f32input - mean) * invStdDev * f32scale
        ${i?`+ ${ur(N,m,"bias[j]")}`:""}
      );
    }

    ${$?"mean_data_output[global_idx] = mean":""};
    ${x?"inv_std_output[global_idx] = invStdDev":""};
  }`},A=[{dims:s,dataType:r[0].dataType}];return $&&A.push({dims:p,dataType:1}),x&&A.push({dims:p,dataType:1}),{name:"LayerNormalization",shaderCache:{hint:`${m};${n}`,inputDependencies:b},getRunData:()=>({outputs:A,dispatchGroup:{x:Math.ceil(u/64)},programUniforms:y}),getShaderSource:T}},ab=(r,e)=>{l1(r.inputs),r.compute(d1(r.inputs,e,r.outputCount))}});var c1,lb,ub,f1,gu,db,cb=D(()=>{"use strict";Re();Tt();Ki();ru();Be();Nn();c1=(r,e)=>{let n=r[0],t=r[1],o=r[2],i=r[3],s=r[4],a=r[5],u=r[6],l=r[7];if(n.dims.length!==3&&n.dims.length!==5)throw new Error("Input query is expected to have 3 or 5 dimensions");let d=!1,f=n.dims[0],p=n.dims[1],m=n.dims.length===3?d?n.dims[2]/3:n.dims[2]:e.numHeads*n.dims[4],b=p,y=0,$=0,x=Math.floor(m/e.numHeads);if(u&&l){if(u.dims.length!==4)throw new Error('Input "past_key" is expected to have 4 dimensions');if(l.dims.length!==4)throw new Error('Input "past_value" is expected to have 4 dimensions');y=u.dims[2],$=u.dims[2]}else if(u||l)throw new Error('Input "past_key" and "past_value" shall be both present or both absent');let T;if(t){if(n.dims.length!==3)throw new Error('Input "query" is expected to have 3 dimensions when key is given');if(t.dims.length<3||t.dims.length>5)throw new Error('Input "key" is expected to have 3, 4, or 5 dimensions');if(n.dims[0]!==t.dims[0])throw new Error('Input "query" and "key" shall have same dim 0 (batch size)');if(t.dims.length===3){if(t.dims[2]!==n.dims[2])throw new Error('Input "query" and "key" shall have same dim 2 (hidden_size)');T=2,b=t.dims[1]}else if(t.dims.length===5){if(t.dims[2]!==e.numHeads||t.dims[3]!==2||t.dims[4]!==x)throw new Error('Expect "key" shape (batch_size, kv_sequence_length, num_heads, 2, head_size) for packed kv');if(o)throw new Error('Expect "value" be none when "key" has packed kv format.');T=5,b=t.dims[1]}else{if(t.dims[1]!==e.numHeads||t.dims[3]!==x)throw new Error('Expect "key" shape (batch_size, num_heads, kv_sequence_length, head_size) for past_key');T=0,b=t.dims[2]}}else{if(n.dims.length!==3&&n.dims.length!==5)throw new Error('Input "query" is expected to have 3 or 5 dimensions when key is empty');if(n.dims.length===5&&(n.dims[2]!==e.numHeads||n.dims[3]!==3))throw new Error('Expect "query" shape (batch_size, kv_sequence_length, num_heads, 3, head_size) for packed kv');T=3}if(i){if(i.dims.length!==1)throw new Error('Input "bias" is expected to have 1 dimension');if(o&&n.dims.length===5&&n.dims[3]===2)throw new Error("bias is not allowed for packed kv.")}let A=0;if(s){A=8;let P=s.dims;throw P.length===1?P[0]===f?A=1:P[0]===3*f+2&&(A=3):P.length===2&&P[0]===f&&P[1]===b&&(A=5),A===8?new Error('Input "key_padding_mask" shape shall be (batch_size) or (batch_size, kv_sequence_length)'):new Error("Mask not supported")}let E=!1,N=m;if(o){if(o.dims.length!==3&&o.dims.length!==4)throw new Error('Input "value" is expected to have 3 or 4 dimensions');if(n.dims[0]!==o.dims[0])throw new Error('Input "query" and "value" shall have same dim 0 (batch_size)');if(o.dims.length===3){if(b!==o.dims[1])throw new Error('Input "key" and "value" shall have the same dim 1 (kv_sequence_length)');N=o.dims[2]}else{if(b!==o.dims[2])throw new Error('Input "past_key" and "past_value" shall have the same dim 2 (kv_sequence_length)');N=o.dims[1]*o.dims[3],E=!0}}let B=y+b,F=!1;if(s)throw new Error("Key padding mask is not supported");if(a)throw new Error("extraAddQk is not supported");if(u)throw new Error("pastKey is not supported");if(l)throw new Error("pastValue is not supported");return{batchSize:f,sequenceLength:p,pastSequenceLength:y,kvSequenceLength:b,totalSequenceLength:B,maxSequenceLength:$,inputHiddenSize:0,hiddenSize:m,vHiddenSize:N,headSize:x,vHeadSize:Math.floor(N/e.numHeads),numHeads:e.numHeads,isUnidirectional:!1,pastPresentShareBuffer:!1,maskFilterValue:e.maskFilterValue,maskType:A,scale:e.scale,broadcastResPosBias:F,passPastInKv:E,qkvFormat:T}},lb=r=>Oe({...r}),ub=Oe({perm:[0,2,1,3]}),f1=(r,e,n,t,o,i,s)=>{let a=[t,o,i],u=G.size(a),l=[{type:"uint32",data:u},{type:"uint32",data:s},{type:"uint32",data:i}],d=f=>{let p=J("qkv_with_bias",e.dataType,a),m=U("qkv",e.dataType,a),b=U("bias",n.dataType,a),y=[{name:"output_size",type:"u32"},{name:"bias_offset",type:"u32"},{name:"hidden_size",type:"u32"}];return`
  ${f.registerUniforms(y).declareVariables(m,b,p)}
  ${f.mainStart()}
    ${f.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}
    let bias_offset_idx = (global_idx % uniforms.hidden_size) + uniforms.bias_offset;

    qkv_with_bias[global_idx] = qkv[global_idx] + bias[bias_offset_idx];
  }`};return r.compute({name:"MultiHeadAttentionAddBias",shaderCache:{inputDependencies:["type","type"]},getRunData:()=>({outputs:[{dims:a,dataType:e.dataType,gpuDataType:0}],dispatchGroup:{x:Math.ceil(u/64)},programUniforms:l}),getShaderSource:d},{inputs:[e,n],outputs:[-1]})[0]},gu=(r,e,n,t,o,i,s,a)=>{let u=i;if(s){if(t===1)throw new Error("AddBiasReshape is not implemented. Please export your model with packed QKV or KV");return u=f1(r,i,s,e,t,n*o,a),u=u.reshape([e,t,n,o]),r.compute(lr(u,ub.perm),{inputs:[u],outputs:[-1]})[0]}else return i.dims.length===3&&(u=i.reshape([e,t,n,o])),r.compute(lr(u,ub.perm),{inputs:[u],outputs:[-1]})[0]},db=(r,e)=>{let n=c1(r.inputs,e);if(r.inputs[0].dims.length===5)throw new Error("Packed QKV is not implemented");if(r.inputs[1]?.dims.length===5)throw new Error("Packed KV is not implemented");let t=r.inputs[1]&&r.inputs[2]&&r.inputs[1].dims.length===4&&r.inputs[2].dims.length===4,o=gu(r,n.batchSize,n.numHeads,n.sequenceLength,n.headSize,r.inputs[0],r.inputs[3],0);if(t)return ra(r,o,r.inputs[1],r.inputs[2],r.inputs[4],void 0,void 0,void 0,r.inputs[5],n,e);let i=gu(r,n.batchSize,n.numHeads,n.kvSequenceLength,n.headSize,r.inputs[1],r.inputs[3],n.hiddenSize),s=gu(r,n.batchSize,n.numHeads,n.kvSequenceLength,n.vHeadSize,r.inputs[2],r.inputs[3],2*n.hiddenSize);ra(r,o,i,s,r.inputs[4],void 0,r.inputs[6],r.inputs[7],r.inputs[5],n,e)}});var p1,h1,m1,g1,b1,y1,v1,w1,fb,pb=D(()=>{"use strict";ut();Re();Be();p1=r=>{if(!r||r.length<1)throw new Error("Too few inputs");if(r[0].dataType!==1)throw new Error("Input type must be float.");if(r.length>=2){let e=r[0].dims.length*2===r[1].dims[0];if(r.length===4&&(e=r[3].dims[0]*2===r[1].dims[0]),!e)throw new Error("The pads should be a 1D tensor of shape [2 * input_rank] or [2 * num_axes].")}},h1=(r,e,n)=>{let t="";for(let o=e-1;o>=0;--o)t+=`
            k = i32(${r.indicesGet("indices",o)}) - ${Te("uniforms.pads",o,n)};
            if (k < 0) {
              break;
            }
            if (k >= i32(${Te("uniforms.x_shape",o,e)})) {
              break;
            }
            offset += k * i32(${Te("uniforms.x_strides",o,e)});
        `;return`
          value = ${r.type.value}(uniforms.constant_value);
          for (var i = 0; i < 1; i++) {
            var offset = 0;
            var k = 0;
            ${t}
            value = x[offset];
          }
      `},m1=(r,e,n)=>{let t="";for(let o=e-1;o>=0;--o)t+=`
                k = i32(${r.indicesGet("indices",o)}) - ${Te("uniforms.pads",o,n)};
                if (k < 0) {
                  k = -k;
                }
                {
                  let _2n_1 = 2 * (i32(${Te("uniforms.x_shape",o,e)}) - 1);
                  k = k % _2n_1;
                  if(k >= i32(${Te("uniforms.x_shape",o,e)})) {
                    k = _2n_1 - k;
                  }
                }
                offset += k * i32(${Te("uniforms.x_strides",o,e)});
            `;return`
              var offset = 0;
              var k = 0;
              ${t}
              value = x[offset];
          `},g1=(r,e,n)=>{let t="";for(let o=e-1;o>=0;--o)t+=`
                k = i32(${r.indicesGet("indices",o)}) - ${Te("uniforms.pads",o,n)};
                if (k < 0) {
                  k = 0;
                }
                if (k >= i32(${Te("uniforms.x_shape",o,e)})) {
                  k = i32(${Te("uniforms.x_shape",o,e)}) - 1;
                }
                offset += k * i32(${Te("uniforms.x_strides",o,e)});
            `;return`
              var offset = 0;
              var k = 0;
              ${t}
              value = x[offset];
          `},b1=(r,e,n)=>{let t="";for(let o=e-1;o>=0;--o)t+=`
                k = i32(${r.indicesGet("indices",o)}) - ${Te("uniforms.pads",o,n)};
                if (k < 0)  {
                  k += i32(${Te("uniforms.x_shape",o,e)}]);
                }
                if (k >= i32(${Te("uniforms.x_shape",o,e)})) {
                  k -= i32(${Te("uniforms.x_shape",o,e)});
                }
                offset += k * i32(${Te("uniforms.x_strides",o,e)});
            `;return`
              var offset = 0;
              var k = 0;
              ${t}
              value = x[offset];
          `},y1=(r,e,n)=>{switch(n.mode){case 0:return h1(r,e,n.pads.length);case 1:return m1(r,e,n.pads.length);case 2:return g1(r,e,n.pads.length);case 3:return b1(r,e,n.pads.length);default:throw new Error("Invalid mode")}},v1=(r,e)=>{let n=G.padShape(r[0].dims.slice(),e.pads),t=r[0].dims,i=[{type:"uint32",data:G.size(n)},{type:"uint32",data:e.pads}];if(e.mode===0){let u=Ft(r[0].dataType);i.push({type:u,data:e.value})}i.push(...X(r[0].dims),...X(n));let s=["rank"],a=u=>{let l=J("output",r[0].dataType,n.length),d=U("x",r[0].dataType,t.length),f=d.type.value,p=y1(l,t.length,e),m=[{name:"output_size",type:"u32"},{name:"pads",type:"i32",length:e.pads.length}];return e.mode===0&&m.push({name:"constant_value",type:f}),`
            ${u.registerUniforms(m).declareVariables(d,l)}
            ${u.mainStart()}
            ${u.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}

            let indices = ${l.offsetToIndices("global_idx")};

            var value = ${f}(0);
            ${p}
            output[global_idx] = value;
        }`};return{name:"Pad",shaderCache:{hint:`${e.mode}`,inputDependencies:s},getRunData:()=>({outputs:[{dims:n,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(G.size(n)/64)},programUniforms:i}),getShaderSource:a}},w1=(r,e)=>{if(r.length>1){let n=r[1].getBigInt64Array(),t=r.length>=3&&r[2].data?r[2].getFloat32Array()[0]:0,o=r[0].dims.length,i=new Int32Array(2*o).fill(0);if(r.length>=4){let a=r[3].getBigInt64Array();for(let u=0;u<a.length;u++)i[Number(a[u])]=Number(n[u]),i[Number(a[u])+o]=Number(n[u+a.length])}else n.forEach((a,u)=>i[Number(u)]=Number(a));let s=[];return i.forEach(a=>s.push(a)),{mode:e.mode,value:t,pads:s}}else return e},fb=(r,e)=>{p1(r.inputs);let n=w1(r.inputs,e);r.compute(v1(r.inputs,n),{inputs:[0]})}});var ca,hb,mb,gb,bb,x1,T1,yb,vb,wb,xb,Tb,_b,$b,Sb,Ib,Ab,Ob,Eb,Cb=D(()=>{"use strict";Et();Re();Be();ca=r=>{if(be.webgpu.validateInputContent&&(!r||r.length!==1))throw new Error("Pool ops requires 1 input.")},hb=(r,e,n)=>{let t=e.format==="NHWC",o=r.dims.slice();t&&o.splice(1,0,o.pop());let i=Object.hasOwnProperty.call(e,"dilations"),s=e.kernelShape.slice(),a=e.strides.slice(),u=i?e.dilations.slice():[],l=e.pads.slice();pn.adjustPoolAttributes(n,o,s,a,u,l);let d=pn.computePoolOutputShape(n,o,a,u,s,l,e.autoPad),f=Object.assign({},e);i?Object.assign(f,{kernelShape:s,strides:a,pads:l,dilations:u,cacheKey:e.cacheKey}):Object.assign(f,{kernelShape:s,strides:a,pads:l,cacheKey:e.cacheKey});let p=d.slice();return p.push(p.splice(1,1)[0]),[f,t?p:d]},mb=(r,e)=>{let n=e.format==="NHWC",t=G.size(r),o=G.size(e.kernelShape),i=[{type:"uint32",data:t},{type:"uint32",data:o}],s=[{name:"outputSize",type:"u32"},{name:"kernelSize",type:"u32"}];if(e.kernelShape.length<=2){let a=e.kernelShape[e.kernelShape.length-1],u=e.strides[e.strides.length-1],l=e.pads[e.pads.length/2-1],d=e.pads[e.pads.length-1],f=!!(l+d);i.push({type:"uint32",data:a},{type:"uint32",data:u},{type:"uint32",data:l},{type:"uint32",data:d}),s.push({name:"kw",type:"u32"},{name:"sw",type:"u32"},{name:"pwStart",type:"u32"},{name:"pwEnd",type:"u32"});let p=!1;if(e.kernelShape.length===2){let m=e.kernelShape[e.kernelShape.length-2],b=e.strides[e.strides.length-2],y=e.pads[e.pads.length/2-2],$=e.pads[e.pads.length-2];p=!!(y+$),i.push({type:"uint32",data:m},{type:"uint32",data:b},{type:"uint32",data:y},{type:"uint32",data:$}),s.push({name:"kh",type:"u32"},{name:"sh",type:"u32"},{name:"phStart",type:"u32"},{name:"phEnd",type:"u32"})}return[i,s,!0,f,p]}else{if(n)throw new Error("Pooling with kernelShape.length > 2 is not supported for NHWC format.");let a=G.computeStrides(e.kernelShape);i.push({type:"uint32",data:a},{type:"uint32",data:e.pads},{type:"uint32",data:e.strides}),s.push({name:"kernelStrides",type:"u32",length:a.length},{name:"pads",type:"u32",length:e.pads.length},{name:"strides",type:"u32",length:e.strides.length});let u=e.pads.reduce((l,d)=>l+d);return[i,s,!!u,!1,!1]}},gb=(r,e,n,t,o,i,s,a,u,l,d,f)=>{let p=o.format==="NHWC",m=e.type.value,b=J("output",e.type.tensor,t);if(o.kernelShape.length<=2){let y="",$="",x="",T=n-(p?2:1);if(d?y=`
                for (var i: u32 = 0u; i < uniforms.kw; i++) {
                  xIndices[${T}] = indices[${T}] * uniforms.sw - uniforms.pwStart + i;
                  if (xIndices[${T}] < 0 || xIndices[${T}]
                      >= uniforms.x_shape[${T}]) {
                    pad++;
                    continue;
                  }
                  let x_val = x[${e.indicesToOffset("xIndices")}];
                  ${i}
                }`:y=`
                for (var i: u32 = 0u; i < uniforms.kw; i++) {
                  xIndices[${T}] = indices[${T}] * uniforms.sw - uniforms.pwStart + i;
                  let x_val = x[${e.indicesToOffset("xIndices")}];
                  ${i}
                }`,o.kernelShape.length===2){let E=n-(p?3:2);f?$=`
                for (var j: u32 = 0u; j < uniforms.kh; j++) {
                  xIndices[${E}] = indices[${E}] * uniforms.sh - uniforms.phStart + j;
                  if (xIndices[${E}] < 0 || xIndices[${E}] >= uniforms.x_shape[${E}]) {
                    pad += i32(uniforms.kw);
                    continue;
                  }
              `:$=`
                for (var j: u32 = 0u; j < uniforms.kh; j++) {
                  xIndices[${E}] = indices[${E}] * uniforms.sh - uniforms.phStart + j;
                `,x=`
              }
            `}return`
            ${r.registerUniforms(u).declareVariables(e,b)}

            ${r.mainStart()}
              ${r.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}

              let indices = ${b.offsetToIndices("global_idx")};
              var xIndices = ${b.offsetToIndices("global_idx")};

              var value = ${m}(${a});
              var pad = 0;
              ${$}
              ${y}
              ${x}
              ${s}

              output[global_idx] = value;
            }`}else{if(p)throw new Error("Pooling with kernelShape.length > 2 is not supported for NHWC format.");let y=o.kernelShape.length,$=o.pads.length,x="";return l?x=`
                if (xIndices[j] >= uniforms.x_shape[j]) {
                  pad++;
                  isPad = true;
                  break;
                }
              }
              if (!isPad) {
                let x_val = x[${e.indicesToOffset("xIndices")}];
                ${i}
              }`:x=`
              }
              let x_val = x[${e.indicesToOffset("xIndices")}];
              ${i}
            `,`
            ${r.registerUniforms(u).declareVariables(e,b)}

            ${r.mainStart()}
              ${r.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
              let indices = ${b.offsetToIndices("global_idx")};
              var xIndices = ${b.offsetToIndices("global_idx")};

              var offsets: array<u32, ${y}>;

              var value = ${m}(${a});
              var pad = 0;
              var isPad = false;

              for (var i: u32 = 0u; i < uniforms.kernelSize; i++) {
                var offset = i;
                for (var j = 0u; j < ${y-1}u; j++) {
                  offsets[j] = offset / ${Te("uniforms.kernelStrides","j",y)};
                  offset -= offsets[j] * ${Te("uniforms.kernelStrides","j",y)};
                }
                offsets[${y-1}] = offset;

                isPad = false;
                for (var j = ${n-y}u; j < ${n}u; j++) {
                  xIndices[j] = indices[j] * ${Te("uniforms.strides",`j - ${n-y}u`,y)}
                    + offsets[j - ${n-y}u] - ${Te("uniforms.pads","j - 2u",$)};
                  ${x}
              }
              ${s}

              output[global_idx] = value;
            }`}},bb=r=>`${r.format};${r.ceilMode};${r.autoPad};${r.kernelShape.length}`,x1=r=>`${bb(r)};${r.countIncludePad}`,T1=r=>`${bb(r)};${r.storageOrder};${r.dilations}`,yb=r=>({format:r.format,autoPad:["NOTSET","VALID","SAME_UPPER","SAME_LOWER"][r.auto_pad],ceilMode:r.ceil_mode,kernelShape:r.kernel_shape,strides:r.strides,pads:r.pads}),vb=(r,e,n,t)=>{let[o,i]=hb(e,t,n),s=U("x",e.dataType,e.dims.length),a=s.type.value,u="value += x_val;",l="";o.countIncludePad?l+=`value /= ${a}(uniforms.kernelSize);`:l+=`value /= ${a}(i32(uniforms.kernelSize) - pad);`;let[d,f,p,m,b]=mb(i,o);d.push(...X(e.dims),...X(i));let y=["rank"];return{name:r,shaderCache:{hint:`${t.cacheKey};${p};${m};${b}`,inputDependencies:y},getRunData:()=>({outputs:[{dims:i,dataType:e.dataType}],dispatchGroup:{x:Math.ceil(G.size(i)/64)},programUniforms:d}),getShaderSource:$=>gb($,s,e.dims.length,i.length,o,u,l,0,f,p,m,b)}},wb=r=>{let e=r.count_include_pad!==0,n=yb(r);if(n.ceilMode!==0)throw new Error("using ceil() in shape computation is not yet supported for AveragePool");let t={countIncludePad:e,...n,cacheKey:""};return{...t,cacheKey:x1(t)}},xb=(r,e)=>{ca(r.inputs),r.compute(vb("AveragePool",r.inputs[0],!1,e))},Tb={autoPad:"",ceilMode:0,countIncludePad:!1,kernelShape:[],strides:[],pads:[],storageOrder:0,dilations:[]},_b=r=>{let e=r.format;return{format:e,...Tb,cacheKey:e}},$b=(r,e)=>{ca(r.inputs),r.compute(vb("GlobalAveragePool",r.inputs[0],!0,e))},Sb=(r,e,n,t)=>{let[o,i]=hb(e,t,n),s=`
      value = max(x_val, value);
    `,a="",u=U("x",e.dataType,e.dims.length),l=["rank"],[d,f,p,m,b]=mb(i,o);return d.push(...X(e.dims),...X(i)),{name:r,shaderCache:{hint:`${t.cacheKey};${p};${m};${b}`,inputDependencies:l},getRunData:()=>({outputs:[{dims:i,dataType:e.dataType}],dispatchGroup:{x:Math.ceil(G.size(i)/64)},programUniforms:d}),getShaderSource:y=>gb(y,u,e.dims.length,i.length,o,s,a,-1e5,f,p,m,b)}},Ib=(r,e)=>{ca(r.inputs),r.compute(Sb("MaxPool",r.inputs[0],!1,e))},Ab=r=>{let e=r.storage_order,n=r.dilations,t=yb(r);if(e!==0)throw new Error("column major storage order is not yet supported for MaxPool");if(t.ceilMode!==0)throw new Error("using ceil() in shape computation is not yet supported for MaxPool");let o={storageOrder:e,dilations:n,...t,cacheKey:""};return{...o,cacheKey:T1(o)}},Ob=r=>{let e=r.format;return{format:e,...Tb,cacheKey:e}},Eb=(r,e)=>{ca(r.inputs),r.compute(Sb("GlobalMaxPool",r.inputs[0],!0,e))}});var $1,S1,Pb,kb=D(()=>{"use strict";Et();ut();Be();$1=(r,e,n)=>{let t=r===e,o=r<e&&n<0,i=r>e&&n>0;if(t||o||i)throw new Error("Range these inputs' contents are invalid.")},S1=(r,e,n,t)=>{let o=Math.abs(Math.ceil((e-r)/n)),i=[o],s=o,a=Ft(t),u=[{type:"uint32",data:s},{type:a,data:r},{type:a,data:n},...X(i)],l=d=>{let f=J("output",t,i.length),p=f.type.value,m=[{name:"outputSize",type:"u32"},{name:"start",type:p},{name:"delta",type:p}];return`
        ${d.registerUniforms(m).declareVariables(f)}
        ${d.mainStart()}
        ${d.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
        output[global_idx] = uniforms.start + ${p}(global_idx) * uniforms.delta;
      }`};return{name:"Range",shaderCache:{hint:`${t}`},getShaderSource:l,getRunData:()=>({outputs:[{dims:i,dataType:t}],dispatchGroup:{x:Math.ceil(s/64)},programUniforms:u})}},Pb=r=>{let e=0,n=0,t=0;r.inputs[0].dataType===6?(e=r.inputs[0].getInt32Array()[0],n=r.inputs[1].getInt32Array()[0],t=r.inputs[2].getInt32Array()[0]):r.inputs[0].dataType===1&&(e=r.inputs[0].getFloat32Array()[0],n=r.inputs[1].getFloat32Array()[0],t=r.inputs[2].getFloat32Array()[0]),be.webgpu.validateInputContent&&$1(e,n,t),r.compute(S1(e,n,t,r.inputs[0].dataType),{inputs:[]})}});var I1,A1,O1,E1,C1,P1,k1,D1,B1,R1,z1,Db,N1,L1,M1,V1,F1,Bb,Rb,zb=D(()=>{"use strict";Re();Tt();Be();I1=(r,e)=>{if(r.every(n=>n>0||(()=>{throw new Error("Resize requires scales input values to be positive")})),r.length>0){if(e.mode==="linear"){if(!(r.length===2||r.length===3||r.length===4&&r[0]===1&&r[1]===1||r.length===4&&r[0]===1&&r[3]===1||r.length===5&&r[0]===1&&r[1]===1))throw new Error(`For linear mode, Resize requires scales to be 2D, 3D, 4D with either two outermost or one innermost and
            one outermost scale values equal to 1, or 5D with two outermost scale values equal to 1`)}else if(e.mode==="cubic"&&!(r.length===2||r.length===4&&r[0]===1&&r[1]===1||r.length===4&&r[0]===1&&r[3]===1))throw new Error("Resize requires scales input size to be 2 or 4 for cubic mode")}},A1=(r,e,n)=>{e.every(o=>o>=0&&o<n||(()=>{throw new Error("Resize requires axes input values to be positive and less than rank")}));let t=new Array(n).fill(1);return e.forEach((o,i)=>t[o]=r[i]),t},O1=(r,e,n,t,o,i)=>{let[s,a,u]=n>10?[1,2,3]:[-1,r.length>1?1:-1,-1],l=r[0].dims.length;if(s>0&&r.length>s&&r[s].dims.length>0)r[s].getFloat32Array().forEach(d=>i.push(d));else if(e.coordinateTransformMode==="tf_crop_and_resize")throw new Error("Resize requires RoI input to be specified when coordinateTransformMode is tfCropAndResize");if(a>0&&r.length>a&&r[a].dims.length>0){if(r[a].getFloat32Array().forEach(d=>t.push(d)),t.length!==0&&t.length!==l&&n>=18&&t.length!==e.axes.length)throw new Error("Resize requires scales input size to be same as input rank or axes size for opset 18 and up");I1(t,e),e.axes.length>0&&A1(t,e.axes,l).forEach((d,f)=>t[f]=d)}if(u>0&&r.length>u&&(r[u].getBigInt64Array().forEach(d=>o.push(Number(d))),o.length!==l||n>=18&&o.length===e.axes.length))throw new Error("Resize requires sizes input size to be same as input rank or axes size for opset 18 and up");if(e.axes.length>0){if(t.length!==e.axes.length)throw new Error('Resize requires "scales" input size to be of axes rank when axes attributes is specified');if(o.length!==e.axes.length)throw new Error('Resize requires "sizes" input size to be of rank axes rank when axes attributes is specified')}if(typeof t<"u"&&typeof o<"u"&&t.length>0&&o.length>l)throw new Error("Resize requires only of scales or sizes to be specified")},E1=(r,e)=>`fn getOriginalCoordinateFromResizedCoordinate(xResized: u32, xScale: f32, lengthResized: u32,
     lengthOriginal: u32, roiStart: f32, roiEnd: f32) -> ${e} { `+(()=>{switch(r){case"asymmetric":return`return ${e}(xResized) / ${e}(xScale);`;case"pytorch_half_pixel":return`if (lengthResized > 1) {
                    return (${e}(xResized) + 0.5) / ${e}(xScale) - 0.5;
                  } else {
                    return 0.0;
                  }`;case"tf_half_pixel_for_nn":return`return (${e}(xResized) + 0.5) / ${e}(xScale);`;case"align_corners":return`if (lengthResized == 1) {
                    return 0.0;
                  } else {
                    // The whole part and the fractional part are calculated separately due to inaccuracy of floating
                    // point division. As an example, f32(21) / f32(7) may evaluate to 2.99... instead of 3, causing an
                    // offset-by-one error later in floor().
                    let whole = ${e}(xResized * (lengthOriginal - 1) / (lengthResized - 1));
                    let fract =
                        ${e}(xResized * (lengthOriginal - 1) % (lengthResized - 1)) / ${e}(lengthResized - 1);
                    return whole + fract;
                  }`;case"tf_crop_and_resize":return`if (lengthResized > 1) {
                    return ${e}(roiStart) * ${e}(lengthOriginal - 1) +
                        (${e}(xResized) * ${e}(roiEnd - roiStart) * ${e}(lengthOriginal - 1)) /
                        ${e}(lengthResized - 1);
                  } else {
                    return 0.5 * ${e}(roiStart + roiEnd) * ${e}(lengthOriginal - 1);
                  }`;case"half_pixel_symmetric":return`const outputWidth = ${e}xScale * ${e}(lengthResized);
                  const adjustment = ${e}(lengthResized) / outputWidth;
                  const center = ${e}(lengthOriginal) / 2;
                  const offset = center * (1 - adjustment);
                  return offset + ((${e}(xResized) + 0.5) / ${e}(xScale)) - 0.5;`;case"half_pixel":return`return ((${e}(xResized) + 0.5) / ${e}(xScale)) - 0.5;`;default:throw new Error(`Coordinate transform mode ${r} is not supported`)}})()+"}",C1=(r,e,n)=>`fn getNearestPixelFromOriginal(xOriginal: ${n}, isDownSample: bool) -> ${n} {`+(()=>{switch(r){case"round_prefer_ceil":return"if (fract(xOriginal) == 0.5) {             return ceil(xOriginal);           } else {             return round(xOriginal);           }";case"floor":return"return floor(xOriginal);";case"ceil":return"return ceil(xOriginal);";case"round_prefer_floor":return"if (fract(xOriginal) == 0.5) {                     return floor(xOriginal);                   } else {                     return round(xOriginal);                   }";case"simple":default:if(e<11)return"if (isDownSample)                     {                       return ceil(xOriginal);                     } else {                       return xOriginal;                     }";throw new Error(`Nearest mode ${r} is not supported`)}})()+"}",P1=(r,e,n)=>{let t=new Array(n).fill(0).concat(new Array(n).fill(1)),o=r.length===0?t:r.slice();return e.length>0?(e.forEach((i,s)=>{t[i]=o[s],t[s+n]=o[e.length+s]}),t):o},k1=(r,e,n,t)=>{let o=[];if(n.length>0)if(t.length>0){if(r.forEach(i=>o.push(i)),Math.max(...t)>r.length)throw new Error("axes is out of bound");t.forEach((i,s)=>o[i]=n[s])}else n.forEach(i=>o.push(i));else{if(e.length===0)throw new Error("Resize requires either scales or sizes.");o=r.map((i,s)=>Math.round(i*e[s]))}return o},D1=(r,e,n)=>{let t=(()=>{switch(n.keepAspectRatioPolicy){case"not_larger":return n.axes.length>0?Math.min(...n.axes.map(i=>e[i]),Number.MAX_VALUE):Math.min(...e,Number.MAX_VALUE);case"not_smaller":return n.axes.length>0?Math.max(...n.axes.map(i=>e[i]),Number.MIN_VALUE):Math.max(...e,Number.MIN_VALUE);default:throw new Error(`Keep aspect ratio policy ${n.keepAspectRatioPolicy} is not supported`)}})();e.fill(1,0,e.length);let o=r.slice();return n.axes.length>0?(n.axes.forEach(i=>e[i]=t),n.axes.forEach(i=>o[i]=Math.round(r[i]*e[i]))):(e.fill(t,0,e.length),o.forEach((i,s)=>o[s]=Math.round(i*e[s]))),o},B1=(r,e,n,t,o)=>`
    fn calculateOriginalIndicesFromOutputIndices(output_indices: ${r.type.indices}) -> array<${r.type.value}, ${n.length}> {
      var original_indices: array<${r.type.value}, ${n.length}>;
      for (var i:u32 = 0; i < ${n.length}; i++) {
        var output_index = ${r.indicesGet("output_indices","i")};
        var scale = ${Te("uniforms.scales","i",t)};
        var roi_low = ${Te("uniforms.roi","i",o)};
        var roi_hi = ${Te("uniforms.roi",`i + ${e.length}`,o)};
        if (scale == 1.0) {
          original_indices[i] = ${r.type.value}(output_index);
        } else {
          var input_shape_i = ${Te("uniforms.input_shape","i",e.length)};
          var output_shape_i = ${Te("uniforms.output_shape","i",n.length)};
          original_indices[i] = getOriginalCoordinateFromResizedCoordinate(output_index, scale, output_shape_i,
                                                                           input_shape_i, roi_low, roi_hi);
        }
      }
      return original_indices;
    }`,R1=(r,e,n,t,o,i,s)=>`
    fn calculateInputIndicesFromOutputIndices(output_indices: ${e.type.indices}) -> ${r.type.indices} {
      var input_indices: ${r.type.indices};
      for (var i:u32 = 0; i < ${t.length}; i++) {
        var output_index = ${e.indicesGet("output_indices","i")};
        var input_index: u32;
        var scale = ${Te("uniforms.scales","i",o)};
        if (scale == 1.0) {
          input_index = output_index;
        } else {
          var roi_low = ${Te("uniforms.roi","i",i)};
          var roi_hi = ${Te("uniforms.roi",`i + ${n.length}`,i)};
          var input_shape_i = ${Te("uniforms.input_shape","i",n.length)};
          var output_shape_i = ${Te("uniforms.output_shape","i",t.length)};
          var original_idx = getOriginalCoordinateFromResizedCoordinate(output_index, scale, output_shape_i,
                                                                        input_shape_i, roi_low, roi_hi);
          if (!${s} || (original_idx >= 0 && original_idx < ${e.type.value}(input_shape_i))) {
            if (original_idx < 0) {
              input_index = 0;
            } else if (original_idx > ${e.type.value}(input_shape_i - 1)) {
              input_index = input_shape_i - 1;
            } else {
              input_index = u32(getNearestPixelFromOriginal(original_idx, scale < 1));
            }
          } else {
            input_index = u32(original_idx);
          }
        }
        ${r.indicesSet("input_indices","i"," input_index")}
      }
      return input_indices;
    }`,z1=(r,e)=>`
    fn checkInputIndices(input_indices: ${r.type.indices}) -> bool {
      for (var i:u32 = 0; i < ${e.length}; i++) {
        var input_index = ${r.indicesGet("input_indices","i")};
        if (input_index < 0 || input_index >= ${Te("uniforms.input_shape","i",e.length)}) {
          return false;
        }
      }
      return true;
    }`,Db=(r,e,n,t)=>r.rank>t?`
    ${r.indicesSet("input_indices",e,"channel")};
    ${r.indicesSet("input_indices",n,"batch")};
`:"",N1=(r,e,n,t,o)=>{let[s,a,u,l]=n.length===2?[-1,0,1,-1]:[0,2,3,1],d=r.type.value;return`
    fn getInputValue(batch: u32, channel: u32, row: u32, col: u32) -> ${d} {
      var input_indices: ${r.type.indices};
      ${r.indicesSet("input_indices",a,`max(0, min(row, ${n[a]} - 1))`)};
      ${r.indicesSet("input_indices",u,`max(0, min(col, ${n[u]} - 1))`)};
      ${Db(r,l,s,2)}
      return ${r.getByIndices("input_indices")};
    }

    fn bilinearInterpolation(output_indices: ${e.type.indices}) -> ${d} {
      var originalIndices = calculateOriginalIndicesFromOutputIndices(output_indices);
      var row:${d} = originalIndices[${a}];
      var col:${d} = originalIndices[${u}];
      ${t?`if (row < 0 || row > (${n[a]} - 1) || col < 0 || col > (${n[u]} - 1)) {
        return ${o};
      }`:""};
      row = max(0, min(row, ${n[a]} - 1));
      col = max(0, min(col, ${n[u]} - 1));
      var row1: u32 = u32(row);
      var col1: u32 = u32(col);
      var row2: u32 = u32(row + 1);
      var col2: u32 = u32(col + 1);
      var channel: u32 = ${n.length>2?`u32(originalIndices[${l}])`:"0"};
      var batch: u32 =  ${n.length>2?`u32(originalIndices[${s}])`:"0"};
      var x11: ${d} = getInputValue(batch, channel, row1, col1);
      var x12: ${d} = getInputValue(batch, channel, row1, col2);
      var x21: ${d} = getInputValue(batch, channel, row2, col1);
      var x22: ${d} = getInputValue(batch, channel, row2, col2);
      var dx1: ${d} = abs(row - ${d}(row1));
      var dx2: ${d} = abs(${d}(row2) - row);
      var dy1: ${d} = abs(col - ${d}(col1));
      var dy2: ${d} = abs(${d}(col2) - col);
      if (row1 == row2) {
        dx1 = 0.5;
        dx2 = 0.5;
      }
      if (col1 == col2) {
        dy1 = 0.5;
        dy2 = 0.5;
      }
      return (x11 * dx2 * dy2 + x12 * dx2 * dy1 + x21 * dx1 * dy2 + x22 * dx1 * dy1);
    }`},L1=(r,e,n,t,o,i,s,a,u,l)=>{let d=n.length===2,f=!0,[p,m]=d?[0,1]:f?[2,3]:[1,2],b=r.type.value,y=$=>{let x=$===p?"row":"col";return`
      fn ${x}CubicInterpolation(input_indices: ${r.type.indices}, output_indices: ${e.type.indices}) -> ${b} {
        var output_index = ${e.indicesGet("output_indices",$)};
        var originalIdx: ${b} = getOriginalCoordinateFromResizedCoordinate(output_index, ${o[$]},
        ${t[$]}, ${n[$]}, ${i[$]}, ${i[$]} + ${n.length});
        var fractOriginalIdx: ${b} = originalIdx - floor(originalIdx);
        var coefs = getCubicInterpolationCoefs(fractOriginalIdx);

        if (${a} && (originalIdx < 0 || originalIdx > (${n[$]} - 1))) {
          return ${u};
        }
        var data: array<${b}, 4> = array<${b}, 4>(0.0, 0.0, 0.0, 0.0);
        for (var i: i32 = -1; i < 3; i++) {
          var ${x}: ${b} = originalIdx + ${b}(i);
          if (${x} < 0 || ${x} >= ${n[$]}) {
            ${(()=>l?`coefs[i + 1] = 0.0;
                        continue;`:a?`return ${u};`:`${x} = max(0, min(${x}, ${n[$]} - 1));`)()};
          }
        var input_indices_copy: ${r.type.indices} = input_indices;
          ${r.indicesSet("input_indices_copy",$,`u32(${x})`)};
          data[i + 1] = ${$===p?r.getByIndices("input_indices_copy"):"rowCubicInterpolation(input_indices_copy, output_indices)"};
        }
        return cubicInterpolation1D(data, coefs);
      }`};return`
    ${y(p)};
    ${y(m)};
  fn getCubicInterpolationCoefs(s: ${b}) -> array<${b}, 4> {
    var absS = abs(s);
    var coeffs: array<${b}, 4> = array<${b}, 4>(0.0, 0.0, 0.0, 0.0);
    var oneMinusAbsS: ${b} = 1.0 - absS;
    var twoMinusAbsS: ${b} = 2.0 - absS;
    var onePlusAbsS: ${b} = 1.0 + absS;
    coeffs[0] = ((${s} * onePlusAbsS - 5 * ${s}) * onePlusAbsS + 8 * ${s}) * onePlusAbsS - 4 * ${s};
    coeffs[1] = ((${s} + 2) * absS - (${s} + 3)) * absS * absS + 1;
    coeffs[2] = ((${s} + 2) * oneMinusAbsS - (${s} + 3)) * oneMinusAbsS * oneMinusAbsS + 1;
    coeffs[3] = ((${s} * twoMinusAbsS - 5 * ${s}) * twoMinusAbsS + 8 * ${s}) * twoMinusAbsS - 4 * ${s};
    return coeffs;
  }

  fn cubicInterpolation1D(x: array<${b}, 4>, coefs: array<${b}, 4>) -> ${b} {
    var coefsSum: ${b} = coefs[0] + coefs[1] + coefs[2] + coefs[3];
    return (x[0] * coefs[0] + x[1] * coefs[1]+ x[2] * coefs[2]+ x[3] * coefs[3]) / coefsSum;
  }

  fn bicubicInterpolation(output_indices: ${e.type.indices}) -> ${b} {
    var input_indices: ${r.type.indices} = output_indices;
    return colCubicInterpolation(input_indices, output_indices);
  }
    `},M1=(r,e,n,t,o)=>{let[s,a,u,l,d]=n.length===3?[-1,0,1,2,-1]:[0,2,3,4,1],f=r.type.value;return`
    fn getInputValue(batch: u32, channel: u32, depth:u32, height: u32, width: u32) -> ${f} {
      var input_indices: ${r.type.indices};
      ${r.indicesSet("input_indices",a,`max(0, min(depth, ${n[a]} - 1))`)};
      ${r.indicesSet("input_indices",u,`max(0, min(height, ${n[u]} - 1))`)};
      ${r.indicesSet("input_indices",l,`max(0, min(width, ${n[l]} - 1))`)};
      ${Db(r,d,s,3)}
      return ${r.getByIndices("input_indices")};
    }

    fn trilinearInterpolation(output_indices: ${e.type.indices}) -> ${f} {
      var originalIndices = calculateOriginalIndicesFromOutputIndices(output_indices);
      var depth:${f} = originalIndices[${a}];
      var height:${f} = originalIndices[${u}];
      var width:${f} = originalIndices[${l}];
      ${t?`if (depth < 0 || depth > (${n[a]} - 1) || height < 0 || height > (${n[u]} - 1) || width < 0 || (width > ${n[l]} - 1)) {
      return ${o};
        }`:""};

    depth = max(0, min(depth, ${n[a]} - 1));
      height = max(0, min(height, ${n[u]} - 1));
      width = max(0, min(width, ${n[l]} - 1));
      var depth1: u32 = u32(depth);
      var height1: u32 = u32(height);
      var width1: u32 = u32(width);
      var depth2: u32 = u32(depth + 1);
      var height2: u32 = u32(height + 1);
      var width2: u32 = u32(width + 1);
      var channel: u32 = ${n.length>3?`u32(originalIndices[${d}])`:"0"};
      var batch: u32 =  ${n.length>3?`u32(originalIndices[${s}])`:"0"};

      var x111: ${f} = getInputValue(batch, channel, depth1, height1, width1);
      var x112: ${f} = getInputValue(batch, channel, depth1, height1, width2);
      var x121: ${f} = getInputValue(batch, channel, depth1, height2, width1);
      var x122: ${f} = getInputValue(batch, channel, depth1, height2, width2);
      var x211: ${f} = getInputValue(batch, channel, depth2, height1, width1);
      var x212: ${f} = getInputValue(batch, channel, depth2, height1, width2);
      var x221: ${f} = getInputValue(batch, channel, depth2, height2, width1);
      var x222: ${f} = getInputValue(batch, channel, depth2, height2, width2);
      var dx1: ${f} = abs(depth - ${f}(depth1));
      var dx2: ${f} = abs(${f}(depth2) - depth);
      var dy1: ${f} = abs(height - ${f}(height1));
      var dy2: ${f} = abs(${f}(height2) - height);
      var dz1: ${f} = abs(width - ${f}(width1));
      var dz2: ${f} = abs(${f}(width2) - width);
      if (depth1 == depth2) {
        dx1 = 0.5;
        dx2 = 0.5;
      }
      if (height1 == height2) {
        dy1 = 0.5;
        dy2 = 0.5;
      }
      if (width1 == width2) {
        dz1 = 0.5;
        dz2 = 0.5;
      }
      return (x111 * dx2 * dy2 * dz2 + x112 * dx2 * dy2 * dz1 + x121 * dx2 * dy1 *dz2 + x122 * dx2 * dy1 * dz1 +
              x211 * dx1 * dy2 * dz2 + x212 * dx1 * dy2 * dz1 + x221 * dx1 * dy1 *dz2 + x222 * dx1 * dy1 * dz1);
    }`},V1=(r,e,n,t,o,i)=>{let s=r.dims,a=P1(i,e.axes,s.length),u=k1(s,t,o,e.axes),l=t.slice();t.length===0&&(l=s.map((T,A)=>T===0?1:u[A]/T),e.keepAspectRatioPolicy!=="stretch"&&(u=D1(s,l,e)));let d=J("output",r.dataType,u.length),f=U("input",r.dataType,s.length),p=G.size(u),m=s.length===u.length&&s.every((T,A)=>T===u[A]),b=e.coordinateTransformMode==="tf_crop_and_resize",y=e.extrapolationValue,$=f.type.value,x=T=>`
      ${m?"":`
      ${E1(e.coordinateTransformMode,$)};
      ${(()=>{switch(e.mode){case"nearest":return`
              ${z1(f,s)};
              ${C1(e.nearestMode,n,$)};
              ${R1(f,d,s,u,l.length,a.length,b)};
              `;case"linear":return`
              ${B1(d,s,u,l.length,a.length)};
              ${(()=>{if(s.length===2||s.length===4)return`${N1(f,d,s,b,y)}`;if(s.length===3||s.length===5)return`${M1(f,d,s,b,y)}`;throw Error("Linear mode only supports input dims 2, 3, 4 and 5 are supported in linear mode.")})()};
            `;case"cubic":return`
            ${(()=>{if(s.length===2||s.length===4)return`${L1(f,d,s,u,l,a,e.cubicCoeffA,b,e.extrapolationValue,e.excludeOutside)}`;throw Error("Cubic mode only supports input dims 2 and 4 are supported in linear mode.")})()};
            `;default:throw Error("Invalid resize mode")}})()};
      `}
      ${T.registerUniform("output_size","u32").registerUniform("scales","f32",l.length).registerUniform("roi","f32",a.length).declareVariables(f,d)}
      ${T.mainStart()}
        ${T.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}
        ${m?"output[global_idx] = input[global_idx];":`
        let output_indices = ${d.offsetToIndices("global_idx")};
        var input_indices: ${f.type.indices};
        ${(()=>{switch(e.mode){case"nearest":return`input_indices = calculateInputIndicesFromOutputIndices(output_indices);
                if (checkInputIndices(input_indices)) {
                  output[global_idx] = ${f.getByIndices("input_indices")};
                } else {
                  output[global_idx] = ${e.extrapolationValue};
                }`;case"linear":return`output[global_idx] = ${s.length===2||s.length===4?"bilinearInterpolation":"trilinearInterpolation"}(output_indices);`;case"cubic":return"output[global_idx] = bicubicInterpolation(output_indices);";default:throw Error(`Unsupported resize mode: ${e.mode}`)}})()};
`}
      }`;return{name:"Resize",shaderCache:{hint:`${e.cacheKey}|${n}|${l.length>0?l:""}|${o.length>0?o:""}|${a.length>0?a:""}|${m}|${s}`,inputDependencies:["rank"]},getShaderSource:x,getRunData:()=>({outputs:[{dims:u,dataType:r.dataType}],dispatchGroup:{x:Math.ceil(p/64)},programUniforms:[{type:"uint32",data:p},{type:"float32",data:l},{type:"float32",data:a},...X(s),...X(u)]})}},F1=r=>{let e=r.customDataBuffer;return new Uint32Array(e,e.byteOffset,1)[0]},Bb=(r,e)=>{let n=[],t=[],o=[],i=F1(r);if(e.antialias!==0)throw Error("Only default value (0) for Antialias attribute is supported");O1(r.inputs,e,i,n,t,o),r.compute(V1(r.inputs[0],e,i,n,t,o),{inputs:[0]})},Rb=r=>{let e=r.antialias,n=r.axes,t=r.coordinateTransformMode,o=r.cubicCoeffA,i=r.excludeOutside!==0,s=r.extrapolationValue,a=r.keepAspectRatioPolicy,u=r.mode,l=r.nearestMode===""?"simple":r.nearestMode;return Oe({antialias:e,axes:n,coordinateTransformMode:t,cubicCoeffA:o,excludeOutside:i,extrapolationValue:s,keepAspectRatioPolicy:a,mode:u,nearestMode:l})}});var U1,G1,Nb,Lb,Mb=D(()=>{"use strict";ut();Re();Tt();Be();U1=r=>{if(!r||r.length<3)throw new Error("layerNorm requires at least 3 inputs.");let e=r[0],n=r[1],t=r[2];if(e.dataType!==n.dataType||e.dataType!==t.dataType)throw new Error("All inputs must have the same data type");if(e.dims.length!==3&&e.dims.length!==2)throw new Error("Input must be 2D or 3D");if(n.dims.length!==3&&n.dims.length!==2)throw new Error("Skip must be 2D or 3D");let o=e.dims[e.dims.length-1],i=e.dims[e.dims.length-2];if(n.dims[n.dims.length-1]!==o)throw new Error("Skip must have the same hidden size as input");if(n.dims[n.dims.length-2]!==i)throw new Error("Skip must have the same sequence length as input");if(t.dims.length!==1)throw new Error("Gamma must be 1D");if(t.dims[t.dims.length-1]!==o)throw new Error("Gamma must have the same hidden size as input");if(r.length>3){let s=r[3];if(s.dims.length!==1)throw new Error("Beta must be 1D");if(s.dims[s.dims.length-1]!==o)throw new Error("Beta must have the same hidden size as input")}if(r.length>4){let s=r[4];if(s.dims.length!==1)throw new Error("Bias must be 1D");if(s.dims[s.dims.length-1]!==o)throw new Error("Bias must have the same hidden size as input")}},G1=(r,e,n,t)=>{let o=r[0].dims,i=G.size(o),s=o,a=i,u=o.slice(-1)[0],l=t?o.slice(0,-1).concat(1):[],d=r.length>3,f=r.length>4,p=t&&n>1,m=t&&n>2,b=n>3,y=wt(u),$=[U("x",r[0].dataType,r[0].dims,y),U("skip",r[1].dataType,r[1].dims,y),U("gamma",r[2].dataType,r[2].dims,y)];d&&$.push(U("beta",r[3].dataType,r[3].dims,y)),f&&$.push(U("bias",r[4].dataType,r[4].dims,y)),$.push(J("output",r[0].dataType,s,y)),p&&$.push(J("meanOutput",1,l)),m&&$.push(J("invStdOutput",1,l)),b&&$.push(J("inputSkipBiasSum",r[0].dataType,s,y));let x=vt(r[0].dataType),T=E=>`
      const hiddenSize: f32 = ${u};
      const hiddenSizeVectorized: u32 = ${u/y};
      const epsilon: f32 = ${e.epsilon};

      ${E.declareVariables(...$)}

      ${E.mainStart()}
        ${E.guardAgainstOutOfBoundsWorkgroupSizes(a/u)}
        let offset = global_idx * hiddenSizeVectorized;
        var sum = ${Pt("f32",y)};
        var squareSum = ${Pt("f32",y)};
        for (var i: u32 = 0; i < hiddenSizeVectorized; i++) {
          let skipValue = skip[offset + i];
          let biasValue = ${f?"bias[i]":"0.0"};
          let inputValue = x[offset + i];
          let value = inputValue + skipValue + biasValue;
          ${b?"inputSkipBiasSum[offset + i] = value;":""}
          output[offset + i] = value;
          let f32Value = ${ur(x,y,"value")};
          sum += f32Value;
          squareSum += f32Value * f32Value;
        }
        let mean = ${Ut("sum",y)} / hiddenSize;
        let invStdDev = inverseSqrt(${Ut("squareSum",y)} / hiddenSize - mean * mean + epsilon);
        ${p?"meanOutput[global_idx] = mean;":""}
        ${m?"invStdOutput[global_idx] = invStdDev;":""}
        for (var i: u32 = 0; i < hiddenSizeVectorized; i++) {
          output[offset + i] = (output[offset + i] - ${x}(mean)) * ${x}(invStdDev) * gamma[i]
           + ${d?"beta[i]":"0.0"};
        }
      }`,A=[{dims:s,dataType:r[0].dataType}];return n>1&&A.push({dims:l,dataType:1}),n>2&&A.push({dims:l,dataType:1}),n>3&&A.push({dims:o,dataType:r[0].dataType}),{name:"SkipLayerNormalization",shaderCache:{hint:e.cacheKey},getShaderSource:T,getRunData:()=>({outputs:A,dispatchGroup:{x:Math.ceil(a/u/64)}})}},Nb=(r,e)=>{U1(r.inputs);let t=[0];r.outputCount>1&&t.push(-3),r.outputCount>2&&t.push(-3),r.outputCount>3&&t.push(3),r.compute(G1(r.inputs,e,r.outputCount,!1),{outputs:t})},Lb=r=>{let e=r.epsilon;return Oe({epsilon:e})}});var W1,fa,H1,Vb,q1,j1,Fb,Ub,Gb=D(()=>{"use strict";ut();Re();Tt();Be();W1=(r,e)=>{if(!r||r.length<1)throw new Error("too few inputs");if(e.axes.length!==0){if(e.axes.length!==e.starts.length||e.axes.length!==e.ends.length)throw new Error("axes, starts and ends must have the same length")}else if(e.starts.length!==e.ends.length)throw new Error("starts and ends must have the same length");r.slice(1).forEach((n,t)=>{if(r[t+1].dataType!==6&&r[t+1].dataType!==7)throw new Error(`Input ${t} must be an array of int32 or int64`)})},fa=(r,e)=>{let n=[];if(r.length>e)if(r[e].dataType===7)r[e].getBigInt64Array().forEach(t=>n.push(Number(t)));else if(r[e].dataType===6)r[e].getInt32Array().forEach(t=>n.push(Number(t)));else throw new Error(`Input ${e} must be an array of int32 or int64`);return n},H1=(r,e)=>{if(r.length>1){let n=fa(r,1),t=fa(r,2),o=fa(r,3);return o.length===0&&(o=[...Array(r[0].dims.length).keys()]),Oe({starts:n,ends:t,axes:o})}else return e},Vb=(r,e,n,t,o)=>{let i=r;return r<0&&(i+=n[t[e]]),o[e]<0?Math.max(0,Math.min(i,n[t[e]]-1)):Math.max(0,Math.min(i,n[t[e]]))},q1=(r,e,n)=>`fn calculateInputIndices(output_indices: ${e.type.indices}) -> ${r.type.indices} {
          var input_indices: ${r.type.indices};
          var carry = 0u;
          for (var i = ${n.length}; i >= 0; i--) {
            let input_shape_i = ${Te("uniforms.input_shape","i",n.length)};
            let steps_i = ${Te("uniforms.steps","i",n.length)};
            let signs_i = ${Te("uniforms.signs","i",n.length)};
            let starts_i = ${Te("uniforms.starts","i",n.length)};
            var output_index = ${e.indicesGet("output_indices","i")};
            var input_index = output_index * steps_i + starts_i + carry;
            carry = input_index / input_shape_i;
            input_index = input_index % input_shape_i;
            if (signs_i < 0) {
              input_index = input_shape_i - input_index - 1u + starts_i;
            }
            ${r.indicesSet("input_indices","i","input_index")};
          }
          return input_indices;
      }`,j1=(r,e)=>{let n=r[0].dims,t=G.size(n),o=e.axes.length>0?G.normalizeAxes(e.axes,n.length):[...Array(n.length).keys()],i=fa(r,4);i.forEach(x=>x!==0||(()=>{throw new Error("step cannot be 0")})),i.length===0&&(i=Array(o.length).fill(1));let s=e.starts.map((x,T)=>Vb(x,T,n,o,i)),a=e.ends.map((x,T)=>Vb(x,T,n,o,i));if(o.length!==s.length||o.length!==a.length)throw new Error("start, ends and axes should have the same number of elements");if(o.length!==n.length)for(let x=0;x<n.length;++x)o.includes(x)||(s.splice(x,0,0),a.splice(x,0,n[x]),i.splice(x,0,1));let u=i.map(x=>Math.sign(x));i.forEach((x,T,A)=>{if(x<0){let E=(a[T]-s[T])/x,N=s[T],B=N+E*i[T];s[T]=B,a[T]=N,A[T]=-x}});let l=n.slice(0);o.forEach((x,T)=>{l[x]=Math.ceil((a[x]-s[x])/i[x])});let d={dims:l,dataType:r[0].dataType},f=J("output",r[0].dataType,l.length),p=U("input",r[0].dataType,r[0].dims.length),m=G.size(l),b=[{name:"outputSize",type:"u32"},{name:"starts",type:"u32",length:s.length},{name:"signs",type:"i32",length:u.length},{name:"steps",type:"u32",length:i.length}],y=[{type:"uint32",data:m},{type:"uint32",data:s},{type:"int32",data:u},{type:"uint32",data:i},...X(r[0].dims),...X(l)],$=x=>`
      ${x.registerUniforms(b).declareVariables(p,f)}
        ${q1(p,f,n)}
        ${x.mainStart()}
          ${x.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}
          let output_indices = ${f.offsetToIndices("global_idx")};
          let input_indices = calculateInputIndices(output_indices);
          ${f.setByOffset("global_idx",p.getByIndices("input_indices"))}
      }`;return{name:"Slice",shaderCache:{hint:`${u.length}_${s.length}_${i.length}`,inputDependencies:["rank"]},getShaderSource:$,getRunData:()=>({outputs:[d],dispatchGroup:{x:Math.ceil(t/64)},programUniforms:y})}},Fb=(r,e)=>{W1(r.inputs,e);let n=H1(r.inputs,e);r.compute(j1(r.inputs,n),{inputs:[0]})},Ub=r=>{let e=r.starts,n=r.ends,t=r.axes;return Oe({starts:e,ends:n,axes:t})}});var K1,Y1,Wb,Hb,qb=D(()=>{"use strict";Re();Tt();Be();K1=r=>{if(!r||r.length!==1)throw new Error("Softmax op requires 1 input.")},Y1=(r,e)=>{let n=r.dims,t=G.size(n),o=64,i=e.axis;if(i<0&&(i=n.length+i),i<n.length-1)throw new Error("softmax only supports last axis for now.");let s=n[i],a=t/s,u=wt(s),l=s/u,d=($,x)=>x===4?`max(max(${$}.x, ${$}.y), max(${$}.z, ${$}.w))`:x===2?`max(${$}.x, ${$}.y)`:x===3?`max(max(${$}.x, ${$}.y), ${$}.z)`:$,f=U("x",r.dataType,r.dims,u),p=J("result",r.dataType,r.dims,u),m=f.type.value,b=vt(r.dataType)==="f32"?`var threadMax = ${m}(-3.402823e+38f);`:`var threadMax = ${m}(-65504.0h);`,y=$=>`
      var<workgroup> rowMaxShared : ${m};
      var<workgroup> rowSumShared : ${m};
      var<workgroup> threadShared : array<${m}, ${o}>;

      fn getValue(row: i32, col: i32, row_stride: i32) -> ${m} {
        let index = row * row_stride + col;
        return x[index];
      }

      fn setValue(row: i32, col: i32, row_stride: i32, value: ${m}) {
        let index = row * row_stride + col;
        result[index] = value;
      }
      ${$.registerUniform("packedCols","i32").declareVariables(f,p)}
      ${$.mainStart()}
        let gindex = i32(global_idx);
        let lindex = i32(local_idx);
        const wg = ${o};
        let row = gindex / wg;
        let cols = uniforms.packedCols;
        let row_stride : i32 = uniforms.packedCols;

        // find the rows max
        ${b}
        for (var col = lindex; col < cols; col += wg) {
          let value = getValue(row, col, row_stride);
          threadMax = max(threadMax, value);
        }
        if (lindex < cols) {
          threadShared[lindex] = threadMax;
        }
        workgroupBarrier();

        var reduceSize = min(cols, wg);
        for (var currSize = reduceSize >> 1;  currSize > 0; currSize = reduceSize >> 1) {
          reduceSize = currSize + (reduceSize & 1);
          if (lindex < currSize) {
            threadShared[lindex] = max(threadShared[lindex], threadShared[lindex + reduceSize]);
          }
          workgroupBarrier();
        }
        if (lindex == 0) {
          rowMaxShared = ${m}(${d("threadShared[0]",u)});
        }
        workgroupBarrier();

        // find the rows sum
        var threadSum = ${m}(0.0);
        for (var col = lindex; col < cols; col += wg) {
          let subExp = exp(getValue(row, col, row_stride) - rowMaxShared);
          threadSum += subExp;
        }
        threadShared[lindex] = threadSum;
        workgroupBarrier();

        for (var currSize = wg >> 1;  currSize > 0; currSize = currSize >> 1) {
          if (lindex < currSize) {
            threadShared[lindex] = threadShared[lindex] + threadShared[lindex + currSize];
          }
          workgroupBarrier();
        }
        if (lindex == 0) {
          rowSumShared = ${m}(${Ut("threadShared[0]",u)});
        }
        workgroupBarrier();

        // calculate final value for each element in the row
        for (var col = lindex; col < cols; col += wg) {
          let value = exp(getValue(row, col, row_stride) - rowMaxShared) / rowSumShared;
          setValue(row, col, row_stride, value);
        }
      }`;return{name:"Softmax",shaderCache:{hint:`${u}`,inputDependencies:["type"]},getRunData:()=>({outputs:[{dims:n,dataType:r.dataType}],dispatchGroup:{x:a},programUniforms:[{type:"uint32",data:l}]}),getShaderSource:y}},Wb=(r,e)=>{K1(r.inputs),r.compute(Y1(r.inputs[0],e))},Hb=r=>Oe({axis:r.axis})});var X1,Z1,J1,Q1,eT,jb,Kb,Yb=D(()=>{"use strict";Re();Tt();Be();X1=r=>{if(!r||r.length<1)throw new Error("too few inputs")},Z1=(r,e)=>{let n=[],t=e.numOutputs;return r[1].dims[0]>0&&(r[1].getBigInt64Array().forEach(o=>n.push(Number(o))),t=n.length),Oe({numOutputs:t,axis:e.axis,splitSizes:n})},J1=r=>`
fn calculateOutputIndex(index: u32) -> u32 {
    for (var i: u32 = 0u; i < ${r}u; i += 1u ) {
    if (index < ${Te("uniforms.size_in_split_axis","i",r)}) {
        return i;
    }
    }
    return ${r}u;
}`,Q1=r=>{let e=r.length,n=[];for(let t=0;t<e;++t){let o=r[t].setByIndices("indices","input[global_idx]");e===1?n.push(o):t===0?n.push(`if (output_number == ${t}u) { ${o} }`):t===e-1?n.push(`else { ${o} }`):n.push(`else if (output_number == ${t}) { ${o} }`)}return`
      fn writeBufferData(output_number: u32, indices: ${r[0].type.indices}, global_idx: u32) {
        ${n.join(`
`)}
      }`},eT=(r,e)=>{let n=r[0].dims,t=G.size(n),o=r[0].dataType,i=G.normalizeAxis(e.axis,n.length),s=new Array(e.numOutputs),a=U("input",o,n),u=new Array(e.numOutputs),l=[],d=[],f=0,p=[{type:"uint32",data:t}];for(let b=0;b<e.numOutputs;b++){f+=e.splitSizes[b],u[b]=f;let y=n.slice();y[e.axis]=e.splitSizes[b],d.push(y),s[b]=J(`output${b}`,o,y),l.push({dims:d[b],dataType:r[0].dataType})}p.push({type:"uint32",data:u}),p.push(...X(n)),d.forEach(b=>p.push(...X(b)));let m=b=>`
  ${b.registerUniform("input_size","u32").registerUniform("size_in_split_axis","u32",u.length).declareVariables(a,...s)}
  ${J1(u.length)}
  ${Q1(s)}

  ${b.mainStart()}
    ${b.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.input_size")}

    var indices = ${a.offsetToIndices("global_idx")};
    var index = ${a.indicesGet("indices",i)};
    let output_number = calculateOutputIndex(index);
    if (output_number != 0) {
      index -= ${Te("uniforms.size_in_split_axis","output_number - 1u",u.length)};
      ${a.indicesSet("indices",i,"index")};
    }
    writeBufferData(output_number, indices, global_idx);
  }`;return{name:"Split",shaderCache:{hint:e.cacheKey,inputDependencies:["rank"]},getShaderSource:m,getRunData:()=>({outputs:l,dispatchGroup:{x:Math.ceil(t/64)},programUniforms:p})}},jb=(r,e)=>{X1(r.inputs);let n=r.inputs.length===1?e:Z1(r.inputs,e);r.compute(eT(r.inputs,n),{inputs:[0]})},Kb=r=>{let e=r.axis,n=r.splitSizes,t=r.numOutputs<0?n.length:r.numOutputs;if(t!==n.length)throw new Error("numOutputs and splitSizes lengh must be equal");return Oe({axis:e,numOutputs:t,splitSizes:n})}});var Xb,tT,rT,nT,Zb,Jb=D(()=>{"use strict";ut();Re();Be();Xb=r=>Array.from(r.getBigInt64Array(),Number),tT=r=>{if(!r||r.length!==2)throw new Error("Tile requires 2 inputs.");if(r[0].dataType!==1&&r[0].dataType!==6&&r[0].dataType!==12)throw new Error("Tile only support float, int32, and uint32 data types");if(r[1].dataType!==7)throw new Error("Tile `repeats` input should be of int64 data type");if(r[1].dims.length!==1)throw new Error("Tile `repeats` input should be 1-D");if(Xb(r[1]).length!==r[0].dims.length)throw new Error("Tile `repeats` input should have same number of elements as rank of input data tensor")},rT=(r,e)=>{let n=[];for(let t=0;t<r.length;++t)n.push(r[t]*e[t]);return n},nT=r=>{let e=r[0].dims,n=Xb(r[1]),t=rT(e,n),o=G.size(t),i=r[0].dataType,s=U("input",i,e.length),a=J("output",i,t.length),u=l=>`
      const inputShape = ${s.indices(...e)};
      ${l.registerUniform("output_size","u32").declareVariables(s,a)}
      ${l.mainStart()}
      ${l.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}
      let output_indices = ${a.offsetToIndices("global_idx")};
      var input_indices: ${s.type.indices};
      for (var i = 0; i < ${e.length}; i++) {
        let input_dim_i = ${s.indicesGet("uniforms.input_shape","i")};
        let input_dim_value = ${a.indicesGet("output_indices","i")}  % input_dim_i;

        ${s.indicesSet("input_indices","i","input_dim_value")}
      }
      ${a.setByOffset("global_idx",s.getByIndices("input_indices"))}
    }`;return{name:"Tile",shaderCache:{hint:`${n}`,inputDependencies:["rank"]},getRunData:()=>({outputs:[{dims:t,dataType:r[0].dataType}],dispatchGroup:{x:Math.ceil(o/64)},programUniforms:[{type:"uint32",data:o},...X(r[0].dims),...X(t)]}),getShaderSource:u}},Zb=r=>{tT(r.inputs),r.compute(nT(r.inputs),{inputs:[0]})}});var oT,iT,Qb,ey=D(()=>{"use strict";ut();Re();Be();oT=(r,e,n,t,o)=>{let i=J("output_data",o,n.length,4),s=U("a_data",e[1].dataType,e[1].dims.length,4),a=U("b_data",e[2].dataType,e[2].dims.length,4),u=U("c_data",e[0].dataType,e[0].dims.length,4),l,d=(f,p,m)=>`select(${p}, ${f}, ${m})`;if(!t)l=i.setByOffset("global_idx",d(s.getByOffset("global_idx"),a.getByOffset("global_idx"),u.getByOffset("global_idx")));else{let f=(p,m,b="")=>{let y=`a_data[index_a${m}][component_a${m}]`,$=`b_data[index_b${m}][component_b${m}]`,x=`bool(c_data[index_c${m}] & ${4278190080>>>(3-m)*8}u)`;return`
            let output_indices${m} = ${i.offsetToIndices(`global_idx * 4u + ${m}u`)};
            let offset_a${m} = ${s.broadcastedIndicesToOffset(`output_indices${m}`,i)};
            let offset_b${m} = ${a.broadcastedIndicesToOffset(`output_indices${m}`,i)};
            let offset_c${m} = ${u.broadcastedIndicesToOffset(`output_indices${m}`,i)};
            let index_a${m} = offset_a${m} / 4u;
            let index_b${m} = offset_b${m} / 4u;
            let index_c${m} = offset_c${m} / 4u;
            let component_a${m} = offset_a${m} % 4u;
            let component_b${m} = offset_b${m} % 4u;
            ${p}[${m}] = ${b}(${d(y,$,x)});
          `};o===9?l=`
            var data = vec4<u32>(0);
            ${f("data",0,"u32")}
            ${f("data",1,"u32")}
            ${f("data",2,"u32")}
            ${f("data",3,"u32")}
            output_data[global_idx] = dot(vec4<u32>(0x1, 0x100, 0x10000, 0x1000000), vec4<u32>(data));`:l=`
            ${f("output_data[global_idx]",0)}
            ${f("output_data[global_idx]",1)}
            ${f("output_data[global_idx]",2)}
            ${f("output_data[global_idx]",3)}
          `}return`
        ${r.registerUniform("vec_size","u32").declareVariables(u,s,a,i)}
        ${r.mainStart()}
        ${r.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}
        ${l}
      }`},iT=r=>{let e=r[1].dims,n=r[2].dims,t=r[0].dims,o=r[1].dataType,i=!(G.areEqual(e,n)&&G.areEqual(n,t)),s=e,a=G.size(e);if(i){let l=yr.calcShape(yr.calcShape(e,n,!1),t,!1);if(!l)throw new Error("Can't perform where op on the given tensors");s=l,a=G.size(s)}let u=Math.ceil(a/4);return{name:"Where",shaderCache:{inputDependencies:["rank","rank","rank"]},getShaderSource:l=>oT(l,r,s,i,o),getRunData:()=>({outputs:[{dims:s,dataType:o}],dispatchGroup:{x:Math.ceil(a/64/4)},programUniforms:[{type:"uint32",data:u},...X(t),...X(e),...X(n),...X(s)]})}},Qb=r=>{r.compute(iT(r.inputs))}});var ty,ry=D(()=>{"use strict";Sm();ru();Om();Cm();lg();wg();_g();su();Ng();Vg();Hg();Kg();Zg();eb();nb();ib();sb();lu();cb();pb();Cb();kb();ea();zb();Mb();Gb();qb();Yb();Jb();Nn();nu();ey();ty=new Map([["Abs",[Pm]],["Acos",[km]],["Acosh",[Dm]],["Add",[dg]],["ArgMax",[$m,tu]],["ArgMin",[_m,tu]],["Asin",[Bm]],["Asinh",[Rm]],["Atan",[zm]],["Atanh",[Nm]],["Attention",[Im]],["AveragePool",[xb,wb]],["BatchNormalization",[Am]],["BiasAdd",[Em]],["BiasSplitGelu",[ug]],["Cast",[Mm,Lm]],["Ceil",[Fm]],["Clip",[Vm]],["Concat",[xg,Tg]],["Conv",[cu,du]],["ConvTranspose",[zg,Rg]],["Cos",[Um]],["Cosh",[Gm]],["CumSum",[Lg,Mg]],["Div",[cg]],["Einsum",[Gg,Wg]],["Elu",[Wm,na]],["Equal",[fg]],["Erf",[Hm]],["Exp",[qm]],["Expand",[jg]],["Floor",[jm]],["FusedConv",[cu,du]],["Gather",[Xg,Yg]],["GatherElements",[Qg,Jg]],["Gelu",[Km]],["Gemm",[rb,tb]],["GlobalAveragePool",[$b,_b]],["GlobalMaxPool",[Eb,Ob]],["Greater",[gg]],["GreaterOrEqual",[yg]],["InstanceNormalization",[ob]],["LayerNormalization",[ab]],["LeakyRelu",[Ym,na]],["Less",[bg]],["LessOrEqual",[vg]],["Log",[sg]],["MatMul",[Og]],["MaxPool",[Ib,Ab]],["Mul",[pg]],["MultiHeadAttention",[db,lb]],["Neg",[Zm]],["Not",[Xm]],["Pad",[fb]],["Pow",[hg]],["Range",[Pb]],["Reciprocal",[Jm]],["ReduceMin",[bm]],["ReduceMean",[fm]],["ReduceMax",[gm]],["ReduceSum",[vm]],["ReduceProd",[ym]],["ReduceL1",[pm]],["ReduceL2",[hm]],["ReduceLogSum",[xm]],["ReduceLogSumExp",[mm]],["ReduceSumSquare",[wm]],["Relu",[Qm]],["Resize",[Bb,Rb]],["Sigmoid",[eg]],["Sin",[tg]],["Sinh",[rg]],["Slice",[Fb,Ub]],["SkipLayerNormalization",[Nb,Lb]],["Split",[jb,Kb]],["Sqrt",[ng]],["Softmax",[Wb,Hb]],["Sub",[mg]],["Tan",[og]],["Tanh",[ig]],["ThresholdedRelu",[ag,na]],["Tile",[Zb]],["Transpose",[Qh,em]],["Where",[Qb]]])});var pa,ny=D(()=>{"use strict";Et();qr();Be();pa=class{constructor(e){this.backend=e;this.repo=new Map,this.attributesBound=!1}getArtifact(e){return this.repo.get(e)}setArtifact(e,n){this.repo.set(e,n)}run(e,n,t,o,i){zt(e.programInfo.name);let s=this.backend.device,a=this.backend.getComputePassEncoder();this.backend.writeTimestamp(this.backend.pendingDispatchNumber*2),a.setPipeline(e.computePipeline);let u=[];for(let d of n)u.push({binding:u.length,resource:{buffer:d.buffer}});for(let d of t)u.push({binding:u.length,resource:{buffer:d.buffer}});i&&u.push({binding:u.length,resource:i});let l=s.createBindGroup({layout:e.computePipeline.getBindGroupLayout(0),entries:u,label:e.programInfo.name});a.setBindGroup(0,l),a.dispatchWorkgroups(...o),this.backend.writeTimestamp(this.backend.pendingDispatchNumber*2+1),this.backend.pendingDispatchNumber++,(this.backend.pendingDispatchNumber>=this.backend.maxDispatchNumber||this.backend.queryType==="at-passes")&&this.backend.endComputePass(),this.backend.pendingDispatchNumber>=this.backend.maxDispatchNumber&&this.backend.flush(),Nt(e.programInfo.name)}dispose(){}build(e,n){zt(e.name);let t=this.backend.device,o=[];t.features.has("shader-f16")&&o.push("enable f16;");let i=Zh(n),s=e.getShaderSource(i),a=`${o.join(`
`)}
${i.additionalImplementations}
${s}`,u=t.createShaderModule({code:a,label:e.name});it("verbose",()=>`[WebGPU] ${e.name} shader code: ${a}`);let l=t.createComputePipeline({compute:{module:u,entryPoint:"main"},layout:"auto",label:e.name});return Nt(e.name),{programInfo:e,computePipeline:l}}normalizeDispatchGroupSize(e){let n=typeof e=="number"?e:e.x,t=typeof e=="number"?1:e.y||1,o=typeof e=="number"?1:e.z||1,i=this.backend.device.limits.maxComputeWorkgroupsPerDimension;if(n<=i&&t<=i&&o<=i)return[n,t,o];let s=n*t*o,a=Math.ceil(Math.sqrt(s));if(a>i){if(a=Math.ceil(Math.cbrt(s)),a>i)throw new Error("Total dispatch size exceeds WebGPU maximum.");return[a,a,a]}else return[a,a,1]}}});var aT,sT,ha,oy=D(()=>{"use strict";Et();ut();qr();qh();Xh();ry();ny();aT=(r,e)=>{if(e.length!==r.length)throw new Error(`inputDependencies length ${e.length} is not equal to inputTensors length ${r.length}.`);let n=[];for(let t=0;t<r.length;++t){let o=r[t].dataType;switch(e[t]){case"none":{n.push("");break}case"type":{n.push(`${o}`);break}case"rank":{let i=r[t].dims.length;n.push(`${o};${i}`);break}case"dims":{let i=r[t].dims.join(",");n.push(`${o};${i}`);break}default:throw new Error(`unsupported input dependency: ${e[t]}`)}}return n.join("|")},sT=(r,e,n)=>{let t=r.name;return r.shaderCache?.hint&&(t+="["+r.shaderCache.hint+"]"),t+=":"+n+`:${aT(e,r.shaderCache?.inputDependencies??new Array(e.length).fill("dims"))}`,t},ha=class{constructor(){this.currentKernelId=null;this.commandEncoder=null;this.computePassEncoder=null;this.maxDispatchNumber=16;this.pendingDispatchNumber=0;this.pendingKernels=[];this.pendingQueries=new Map;this.sessionExternalDataMapping=new Map}get currentKernelCustomData(){if(this.currentKernelId===null)throw new Error("currentKernelCustomData(): currentKernelId is null. (should not happen)");let e=this.kernelCustomData.get(this.currentKernelId);return e||(e={},this.kernelCustomData.set(this.currentKernelId,e)),e}async initialize(e,n){this.env=e;let t=[],o={requiredLimits:{maxComputeWorkgroupStorageSize:n.limits.maxComputeWorkgroupStorageSize,maxComputeWorkgroupsPerDimension:n.limits.maxComputeWorkgroupsPerDimension,maxStorageBufferBindingSize:n.limits.maxStorageBufferBindingSize,maxBufferSize:n.limits.maxBufferSize,maxComputeInvocationsPerWorkgroup:n.limits.maxComputeInvocationsPerWorkgroup,maxComputeWorkgroupSizeX:n.limits.maxComputeWorkgroupSizeX,maxComputeWorkgroupSizeY:n.limits.maxComputeWorkgroupSizeY,maxComputeWorkgroupSizeZ:n.limits.maxComputeWorkgroupSizeZ},requiredFeatures:t};n.features.has("chromium-experimental-timestamp-query-inside-passes")?t.push("chromium-experimental-timestamp-query-inside-passes"):n.features.has("timestamp-query")&&t.push("timestamp-query"),n.features.has("shader-f16")&&t.push("shader-f16"),this.device=await n.requestDevice(o),this.gpuDataManager=Yh(this),this.programManager=new pa(this),this.kernels=new Map,this.kernelPersistentData=new Map,this.kernelCustomData=new Map,Wh(e.logLevel,!!e.debug),this.device.onuncapturederror=i=>{i.error instanceof GPUValidationError&&console.error(`An uncaught WebGPU validation error was raised: ${i.error.message}`)},Object.defineProperty(this.env.webgpu,"device",{value:this.device}),this.setQueryType()}dispose(){typeof this.querySet<"u"&&this.querySet.destroy(),this.gpuDataManager.dispose()}getCommandEncoder(){return this.commandEncoder||(this.commandEncoder=this.device.createCommandEncoder(),this.setQueryType(),this.queryType!=="none"&&typeof this.querySet>"u"&&(this.querySet=this.device.createQuerySet({type:"timestamp",count:this.maxDispatchNumber*2}),this.queryResolveBuffer=this.device.createBuffer({size:this.maxDispatchNumber*2*8,usage:GPUBufferUsage.COPY_SRC|GPUBufferUsage.QUERY_RESOLVE}))),this.commandEncoder}getComputePassEncoder(){if(!this.computePassEncoder){let e={};this.queryType==="at-passes"&&(e.timestampWrites={querySet:this.querySet,beginningOfPassWriteIndex:this.pendingDispatchNumber*2,endOfPassWriteIndex:this.pendingDispatchNumber*2+1}),this.computePassEncoder=this.getCommandEncoder().beginComputePass(e)}return this.computePassEncoder}endComputePass(){this.computePassEncoder&&(this.computePassEncoder.end(),this.computePassEncoder=null)}flush(){if(!this.commandEncoder)return;zt(),this.endComputePass();let e;this.queryType!=="none"&&(this.commandEncoder.resolveQuerySet(this.querySet,0,this.pendingDispatchNumber*2,this.queryResolveBuffer,0),e=this.device.createBuffer({size:this.pendingDispatchNumber*2*8,usage:GPUBufferUsage.MAP_READ|GPUBufferUsage.COPY_DST}),this.pendingQueries.set(e,this.pendingKernels),this.pendingKernels=[],this.commandEncoder.copyBufferToBuffer(this.queryResolveBuffer,0,e,0,this.pendingDispatchNumber*2*8)),this.device.queue.submit([this.commandEncoder.finish()]),this.gpuDataManager.refreshPendingBuffers(),this.commandEncoder=null,this.pendingDispatchNumber=0,this.queryType!=="none"&&e.mapAsync(GPUMapMode.READ).then(()=>{let n=new BigUint64Array(e.getMappedRange()),t=this.pendingQueries.get(e);for(let o=0;o<n.length/2;o++){let i=t[o],s=i.kernelId,a=this.kernels.get(s),u=a.kernelType,l=a.kernelName,d=i.programName,f=i.inputTensorViews,p=i.outputTensorViews,m=n[o*2],b=n[o*2+1];typeof this.queryTimeBase>"u"&&(this.queryTimeBase=m);let y=Number(m-this.queryTimeBase),$=Number(b-this.queryTimeBase);if(!Number.isSafeInteger(y)||!Number.isSafeInteger($))throw new RangeError("incorrect timestamp range");if(this.env.webgpu.profiling?.ondata)this.env.webgpu.profiling.ondata({version:1,inputsMetadata:f.map(x=>({dims:x.dims,dataType:Ft(x.dataType)})),outputsMetadata:p.map(x=>({dims:x.dims,dataType:Ft(x.dataType)})),kernelId:s,kernelType:u,kernelName:l,programName:d,startTime:y,endTime:$});else{let x="";f.forEach((A,E)=>{x+=`input[${E}]: [${A.dims}] | ${Ft(A.dataType)}, `});let T="";p.forEach((A,E)=>{T+=`output[${E}]: [${A.dims}] | ${Ft(A.dataType)}, `}),console.log(`[profiling] kernel "${s}|${u}|${l}|${d}" ${x}${T}execution time: ${$-y} ns`)}no("GPU",`${d}::${m}::${b}`)}e.unmap(),this.pendingQueries.delete(e)}),Nt()}run(e,n,t,o,i){zt(e.name);let s=[];for(let T=0;T<n.length;++T){let A=this.gpuDataManager.get(n[T].data);if(!A)throw new Error(`no GPU data for input: ${n[T].data}`);s[T]=A}let{outputs:a,dispatchGroup:u,programUniforms:l}=e.getRunData(n),d=t.length===0?a.map((T,A)=>A):t;if(d.length!==a.length)throw new Error(`Output size ${d.length} must be equal to ${a.length}.`);let f=[],p=[];for(let T=0;T<a.length;++T){if(!Number.isInteger(d[T])||d[T]<-3||d[T]>=a.length)throw new Error(`Invalid output index: ${d[T]}`);if(d[T]===-3)continue;let A=d[T]===-1,E=d[T]===-2,N=A||E?i(a[T].dataType,a[T].dims):o(d[T],a[T].dataType,a[T].dims),B=this.gpuDataManager.get(N.data);if(!B)throw new Error(`no GPU data for output: ${N.data}`);if(A&&this.temporaryData.push(B),E){let F=this.kernelPersistentData.get(this.currentKernelId);F||(F=[],this.kernelPersistentData.set(this.currentKernelId,F)),F.push(B)}f.push(N),p.push(B)}let m;if(l){let T=0,A=[];l.forEach(F=>{let P=typeof F.data=="number"?[F.data]:F.data;if(P.length===0)return;let W=P.length<=2?P.length*4:16;T=Math.ceil(T/W)*W,A.push(T),T+=P.length>4?Math.ceil(P.length/4)*16:P.length*4});let E=16;T=Math.ceil(T/E)*E;let N=new ArrayBuffer(T);l.forEach((F,P)=>{let W=A[P],oe=typeof F.data=="number"?[F.data]:F.data;F.type==="int32"?new Int32Array(N,W,oe.length).set(oe):F.type==="uint32"?new Uint32Array(N,W,oe.length).set(oe):new Float32Array(N,W,oe.length).set(oe)});let B=this.gpuDataManager.create(T,GPUBufferUsage.COPY_DST|GPUBufferUsage.UNIFORM);this.device.queue.writeBuffer(B.buffer,0,N,0,T),this.gpuDataManager.release(B.id),m={offset:0,size:T,buffer:B.buffer}}let b=this.programManager.normalizeDispatchGroupSize(u),y=b[1]===1&&b[2]===1,$=sT(e,n,y),x=this.programManager.getArtifact($);if(x||(x=this.programManager.build(e,b),this.programManager.setArtifact($,x),it("info",()=>`[artifact] key: ${$}, programName: ${e.name}`)),it("info",()=>`[ProgramManager] run "${e.name}" (key=${$}) with ${b[0]}x${b[1]}x${b[2]}`),this.queryType!=="none"){let T={kernelId:this.currentKernelId,programName:x.programInfo.name,inputTensorViews:n,outputTensorViews:f};this.pendingKernels.push(T)}return this.programManager.run(x,s,p,b,m),Nt(e.name),f}upload(e,n){this.gpuDataManager.upload(e,n)}memcpy(e,n){this.gpuDataManager.memcpy(e,n)}async download(e,n){await this.gpuDataManager.download(e,n)}alloc(e){return this.gpuDataManager.create(e).id}free(e){return this.gpuDataManager.release(e)}createKernel(e,n,t,o){let i=ty.get(e);if(!i)throw new Error(`kernel not implemented: ${e}`);let s={kernelType:e,kernelName:o,kernelEntry:i[0],attributes:[i[1],t]};this.kernels.set(n,s)}releaseKernel(e){let n=this.kernelPersistentData.get(e);if(n){for(let t of n)this.gpuDataManager.release(t.id);this.kernelPersistentData.delete(e)}this.kernelCustomData.delete(e),this.kernels.delete(e)}computeKernel(e,n,t){let o=this.kernels.get(e);if(!o)throw new Error(`kernel not created: ${e}`);let i=o.kernelType,s=o.kernelName,a=o.kernelEntry,u=o.attributes;if(this.currentKernelId!==null)throw new Error(`kernel "[${i}] ${s}" is not allowed to be called recursively`);this.currentKernelId=e,u[0]&&(u[1]=u[0](u[1]),u[0]=void 0),it("info",()=>`[WebGPU] Start to run kernel "[${i}] ${s}"...`);let l=this.env.debug;this.temporaryData=[];try{return l&&this.device.pushErrorScope("validation"),a(n,u[1]),0}catch(d){return t.push(Promise.resolve(`[WebGPU] Kernel "[${i}] ${s}" failed. ${d}`)),1}finally{l&&t.push(this.device.popErrorScope().then(d=>d?`GPU validation error for kernel "[${i}] ${s}": ${d.message}`:null));for(let d of this.temporaryData)this.gpuDataManager.release(d.id);this.temporaryData=[],this.currentKernelId=null}}registerBuffer(e,n,t,o){let i=this.sessionExternalDataMapping.get(e);i||(i=new Map,this.sessionExternalDataMapping.set(e,i));let s=i.get(n),a=this.gpuDataManager.registerExternalBuffer(t,o,s?.[1]);return i.set(n,[a,t]),a}unregisterBuffers(e){let n=this.sessionExternalDataMapping.get(e);n&&(n.forEach(t=>this.gpuDataManager.unregisterExternalBuffer(t[1])),this.sessionExternalDataMapping.delete(e))}getBuffer(e){let n=this.gpuDataManager.get(e);if(!n)throw new Error(`no GPU data for buffer: ${e}`);return n.buffer}createDownloader(e,n,t){return async()=>{let o=await Ks(this,e,n);return Hh(o.buffer,t)}}writeTimestamp(e){this.queryType==="inside-passes"&&this.computePassEncoder.writeTimestamp(this.querySet,e)}setQueryType(){this.queryType="none",(this.env.webgpu.profiling?.mode==="default"||this.env.wasm.trace)&&(this.device.features.has("chromium-experimental-timestamp-query-inside-passes")?this.queryType="inside-passes":this.device.features.has("timestamp-query")&&(this.queryType="at-passes"))}}});var iy={};Mr(iy,{init:()=>uT});var Ao,bu,uT,ay=D(()=>{"use strict";ut();oy();qr();Re();Ao=class r{constructor(e,n,t,o){this.module=e;this.dataType=n;this.data=t;this.dims=o}getFloat32Array(){if(this.dataType!==1)throw new Error("Invalid data type");let e=G.size(this.dims);return e===0?new Float32Array:new Float32Array(this.module.HEAP8.buffer,this.data,e)}getBigInt64Array(){if(this.dataType!==7)throw new Error("Invalid data type");let e=G.size(this.dims);return e===0?new BigInt64Array:new BigInt64Array(this.module.HEAP8.buffer,this.data,e)}getInt32Array(){if(this.dataType!==6)throw new Error("Invalid data type");let e=G.size(this.dims);return e===0?new Int32Array:new Int32Array(this.module.HEAP8.buffer,this.data,e)}reshape(e){if(G.size(e)!==G.size(this.dims))throw new Error("Invalid new shape");return new r(this.module,this.dataType,this.data,e)}},bu=class{constructor(e,n,t){this.module=e;this.backend=n;this.customDataOffset=0;this.customDataSize=0;let o=e.HEAPU32,i=t>>>2;this.opKernelContext=o[i++];let s=o[i++];this.outputCount=o[i++],this.customDataOffset=o[i++],this.customDataSize=o[i++];let a=[];for(let u=0;u<s;u++){let l=o[i++],d=o[i++],f=o[i++],p=[];for(let m=0;m<f;m++)p.push(o[i++]);a.push(new Ao(e,l,d,p))}this.inputs=a}get kernelCustomData(){return this.backend.currentKernelCustomData}get customDataBuffer(){return this.module.HEAPU8.subarray(this.customDataOffset,this.customDataOffset+this.customDataSize)}compute(e,n){let t=n?.inputs?.map(a=>typeof a=="number"?this.inputs[a]:a)??this.inputs,o=n?.outputs??[],i=(a,u,l)=>new Ao(this.module,u,this.output(a,l),l),s=(a,u)=>{let l=xo(a);if(!l)throw new Error(`Unsupported data type: ${a}`);let d=l*G.size(u);return new Ao(this.module,a,this.backend.gpuDataManager.create(d).id,u)};return this.backend.run(e,t,o,i,s)}output(e,n){let t=this.module.stackSave();try{let o=this.module.stackAlloc((1+n.length)*4),i=o>>2;this.module.HEAPU32[i++]=n.length;for(let s=0;s<n.length;s++)this.module.HEAPU32[i++]=n[s];return this.module._JsepOutput(this.opKernelContext,e,o)}catch(o){throw new Error(`Failed to generate kernel's output[${e}] with dims [${n}]. If you are running with pre-allocated output, please make sure the output type/dims are correct. Error: ${o}`)}finally{this.module.stackRestore(t)}}},uT=async(r,e,n)=>{let t=r.jsepInit;if(!t)throw new Error("Failed to initialize JSEP. The WebAssembly module is not built with JSEP support.");let o=new ha;await o.initialize(e,n),t(o,i=>o.alloc(i),i=>o.free(i),(i,s,a,u=!1)=>{if(u)it("verbose",()=>`[WebGPU] jsepCopyGpuToGpu: src=${i}, dst=${s}, size=${a}`),o.memcpy(i,s);else{it("verbose",()=>`[WebGPU] jsepCopyCpuToGpu: dataOffset=${i}, gpuDataId=${s}, size=${a}`);let l=r.HEAPU8.subarray(i>>>0,(i>>>0)+a);o.upload(s,l)}},async(i,s,a)=>{it("verbose",()=>`[WebGPU] jsepCopyGpuToCpu: gpuDataId=${i}, dataOffset=${s}, size=${a}`),await o.download(i,()=>r.HEAPU8.subarray(s>>>0,(s>>>0)+a))},(i,s,a)=>o.createKernel(i,s,a,r.UTF8ToString(r._JsepGetNodeName(s))),i=>o.releaseKernel(i),(i,s,a,u)=>{it("verbose",()=>`[WebGPU] jsepRun: sessionHandle=${a}, kernel=${i}, contextDataOffset=${s}`);let l=new bu(r,o,s);return o.computeKernel(i,l,u)})}});var lT,uy,ly,Oo,dT,yu,dy,cy,sy,fy,py,hy,my=D(()=>{"use strict";Mh();Fh();ut();Rn();Hi();qs();lT=(r,e)=>{ct()._OrtInit(r,e)!==0&&rt("Can't initialize onnxruntime.")},uy=async r=>{lT(r.wasm.numThreads,To(r.logLevel))},ly=async(r,e)=>{if(e==="webgpu"){if(typeof navigator>"u"||!navigator.gpu)throw new Error("WebGPU is not supported in current environment");let n=await navigator.gpu.requestAdapter();if(!n)throw new Error('Failed to get GPU adapter. You may need to enable flag "--enable-unsafe-webgpu" if you are using Chrome.');if(!r.wasm.simd)throw new Error("Not supported for WebGPU=ON and SIMD=OFF. Please set `env.wasm.simd` to true when using `webgpu` EP");let t=(ay(),Or(iy)).init;await t(ct(),r,n)}},Oo=new Map,dT=r=>{let e=ct(),n=e.stackSave();try{let t=e.stackAlloc(8);return e._OrtGetInputOutputCount(r,t,t+4)!==0&&rt("Can't get session input/output count."),[e.HEAP32[t/4],e.HEAP32[t/4+1]]}finally{e.stackRestore(n)}},yu=r=>{let e=ct(),n=e._malloc(r.byteLength);if(n===0)throw new Error(`Can't create a session. failed to allocate a buffer of size ${r.byteLength}.`);return e.HEAPU8.set(r,n),[n,r.byteLength]},dy=async(r,e)=>{let n,t,o=ct();Array.isArray(r)?[n,t]=r:r.buffer===o.HEAPU8.buffer?[n,t]=[r.byteOffset,r.byteLength]:[n,t]=yu(r);let i=0,s=0,a=0,u=[],l=[],d=[];try{if([s,u]=Vh(e),e?.externalData&&o.mountExternalData){let x=[];for(let T of e.externalData){let A=typeof T=="string"?T:T.path;x.push(_o(typeof T=="string"?T:T.data).then(E=>{o.mountExternalData(A,E)}))}await Promise.all(x)}i=o._OrtCreateSession(n,t,s),i===0&&rt("Can't create a session.");let[f,p]=dT(i),m=[],b=[],y=[];for(let x=0;x<f;x++){let T=o._OrtGetInputName(i,x);T===0&&rt("Can't get an input name."),l.push(T),m.push(o.UTF8ToString(T))}for(let x=0;x<p;x++){let T=o._OrtGetOutputName(i,x);T===0&&rt("Can't get an output name."),d.push(T);let A=o.UTF8ToString(T);b.push(A);{let E=typeof e?.preferredOutputLocation=="string"?e.preferredOutputLocation:e?.preferredOutputLocation?.[A]??"cpu";if(E!=="cpu"&&E!=="cpu-pinned"&&E!=="gpu-buffer")throw new Error(`Not supported preferred output location: ${E}.`);y.push(E)}}let $=null;return y.some(x=>x==="gpu-buffer")&&(a=o._OrtCreateBinding(i),a===0&&rt("Can't create IO binding."),$={handle:a,outputPreferredLocations:y,outputPreferredLocationsEncoded:y.map(x=>Hs(x))}),Oo.set(i,[i,l,d,$]),[i,m,b]}catch(f){throw l.forEach(p=>o._OrtFree(p)),d.forEach(p=>o._OrtFree(p)),a!==0&&o._OrtReleaseBinding(a),i!==0&&o._OrtReleaseSession(i),f}finally{o._free(n),s!==0&&o._OrtReleaseSessionOptions(s),u.forEach(f=>o._free(f)),o.unmountExternalData?.()}},cy=r=>{let e=ct(),n=Oo.get(r);if(!n)throw new Error(`cannot release session. invalid session id: ${r}`);let[t,o,i,s]=n;s&&e._OrtReleaseBinding(s.handle),e.jsepUnregisterBuffers?.(r),o.forEach(a=>e._OrtFree(a)),i.forEach(a=>e._OrtFree(a)),e._OrtReleaseSession(t),Oo.delete(r)},sy=(r,e,n,t,o)=>{if(!r){e.push(0);return}let i=ct(),s=r[0],a=r[1],u=r[3],l,d;if(s==="string"&&u==="gpu-buffer")throw new Error("String tensor is not supported on GPU.");if(u==="gpu-buffer"){let m=r[2].gpuBuffer,b=xo(Ws(s));d=a.reduce((y,$)=>y*$,1)*b,l=i.jsepRegisterBuffer(t,o,m,d)}else{let m=r[2];if(Array.isArray(m)){d=4*m.length,l=i._malloc(d),n.push(l);let b=l/4;for(let y=0;y<m.length;y++){if(typeof m[y]!="string")throw new TypeError(`tensor data at index ${y} is not a string`);i.HEAPU32[b++]=gt(m[y],n)}}else d=m.byteLength,l=i._malloc(d),n.push(l),i.HEAPU8.set(new Uint8Array(m.buffer,m.byteOffset,d),l)}let f=i.stackSave(),p=i.stackAlloc(4*a.length);try{let m=p/4;a.forEach(y=>i.HEAP32[m++]=y);let b=i._OrtCreateTensor(Ws(s),l,d,p,a.length,Hs(u));b===0&&rt(`Can't create tensor for input/output. session=${t}, index=${o}.`),e.push(b)}finally{i.stackRestore(f)}},fy=async(r,e,n,t,o,i)=>{let s=ct(),a=Oo.get(r);if(!a)throw new Error(`cannot run inference. invalid session id: ${r}`);let[u,l,d,f]=a,p=e.length,m=t.length,b=0,y=[],$=[],x=[],T=[],A=s.stackSave(),E=s.stackAlloc(p*4),N=s.stackAlloc(p*4),B=s.stackAlloc(m*4),F=s.stackAlloc(m*4);try{[b,y]=Lh(i);for(let ne=0;ne<p;ne++)sy(n[ne],$,T,r,e[ne]);for(let ne=0;ne<m;ne++)sy(o[ne],x,T,r,p+t[ne]);let P=E/4,W=N/4,oe=B/4,H=F/4;for(let ne=0;ne<p;ne++)s.HEAPU32[P++]=$[ne],s.HEAPU32[W++]=l[e[ne]];for(let ne=0;ne<m;ne++)s.HEAPU32[oe++]=x[ne],s.HEAPU32[H++]=d[t[ne]];if(f){let{handle:ne,outputPreferredLocations:Ye,outputPreferredLocationsEncoded:Ze}=f;if(l.length!==p)throw new Error(`input count from feeds (${p}) is expected to be always equal to model's input count (${l.length}).`);for(let Se=0;Se<p;Se++){let He=e[Se];await s._OrtBindInput(ne,l[He],$[Se])!==0&&rt(`Can't bind input[${Se}] for session=${r}.`)}for(let Se=0;Se<m;Se++){let He=t[Se];o[Se]?.[3]?s._OrtBindOutput(ne,d[He],x[Se],0)!==0&&rt(`Can't bind pre-allocated output[${Se}] for session=${r}.`):s._OrtBindOutput(ne,d[He],0,Ze[He])!==0&&rt(`Can't bind output[${Se}] to ${Ye[Se]} for session=${r}.`)}}let re;f?re=await s._OrtRunWithBinding(u,f.handle,m,B,b):re=await s._OrtRun(u,N,E,p,F,m,B,b),re!==0&&rt("failed to call OrtRun().");let ie=[];for(let ne=0;ne<m;ne++){let Ye=s.HEAPU32[B/4+ne];if(Ye===x[ne]){ie.push(o[ne]);continue}let Ze=s.stackSave(),Se=s.stackAlloc(4*4),He=!1,Ie,Ce=0;try{s._OrtGetTensorData(Ye,Se,Se+4,Se+8,Se+12)!==0&&rt(`Can't access output tensor data on index ${ne}.`);let at=Se/4,bt=s.HEAPU32[at++];Ce=s.HEAPU32[at++];let Y=s.HEAPU32[at++],de=s.HEAPU32[at++],Pe=[];for(let dt=0;dt<de;dt++)Pe.push(s.HEAPU32[Y/4+dt]);s._OrtFree(Y);let Gt=Pe.reduce((dt,st)=>dt*st,1);Ie=Ft(bt);let lt=f?.outputPreferredLocations[t[ne]];if(Ie==="string"){if(lt==="gpu-buffer")throw new Error("String tensor is not supported on GPU.");let dt=[],st=Ce/4;for(let Dr=0;Dr<Gt;Dr++){let er=s.HEAPU32[st++],mn=Dr===Gt-1?void 0:s.HEAPU32[st]-er;dt.push(s.UTF8ToString(er,mn))}ie.push([Ie,Pe,dt,"cpu"])}else if(lt==="gpu-buffer"&&Gt>0){let dt=s.jsepGetBuffer(Ce),st=xo(bt);if(st===void 0||!ji(Ie))throw new Error(`Unsupported data type: ${Ie}`);He=!0,ie.push([Ie,Pe,{gpuBuffer:dt,download:s.jsepCreateDownloader(dt,Gt*st,Ie),dispose:()=>{s._OrtReleaseTensor(Ye)}},"gpu-buffer"])}else{let dt=qi(Ie),st=new dt(Gt);new Uint8Array(st.buffer,st.byteOffset,st.byteLength).set(s.HEAPU8.subarray(Ce,Ce+st.byteLength)),ie.push([Ie,Pe,st,"cpu"])}}finally{s.stackRestore(Ze),Ie==="string"&&Ce&&s._free(Ce),He||s._OrtReleaseTensor(Ye)}}return f&&s._OrtClearBoundOutputs(f.handle),ie}finally{s.stackRestore(A),$.forEach(P=>s._OrtReleaseTensor(P)),x.forEach(P=>s._OrtReleaseTensor(P)),T.forEach(P=>s._free(P)),b!==0&&s._OrtReleaseRunOptions(b),y.forEach(P=>s._free(P))}},py=r=>{let e=ct(),n=Oo.get(r);if(!n)throw new Error("invalid session id");let t=n[0],o=e._OrtEndProfiling(t);o===0&&rt("Can't get an profile file name."),e._OrtFree(o)},hy=r=>{let e=[];for(let n of r){let t=n[2];!Array.isArray(t)&&"buffer"in t&&e.push(t.buffer)}return e}});var gy=Je((Oz,fT)=>{fT.exports='/*!\n * ONNX Runtime Web v1.17.1\n * Copyright (c) Microsoft Corporation. All rights reserved.\n * Licensed under the MIT License.\n */\n"use strict";(()=>{var hn=Object.defineProperty;var Lu=Object.getOwnPropertyDescriptor;var Fu=Object.getOwnPropertyNames;var ju=Object.prototype.hasOwnProperty;var j=(e,t)=>()=>(e&&(t=e(e=0)),t);var dr=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),Br=(e,t)=>{for(var r in t)hn(e,r,{get:t[r],enumerable:!0})},qu=(e,t,r,o)=>{if(t&&typeof t=="object"||typeof t=="function")for(let n of Fu(t))!ju.call(e,n)&&n!==r&&hn(e,n,{get:()=>t[n],enumerable:!(o=Lu(t,n))||o.enumerable});return e};var Ht=e=>qu(hn({},"__esModule",{value:!0}),e);var gn={};Br(gn,{createReadStream:()=>xo,readFile:()=>Ku,readFileSync:()=>Yu});var Ku,Yu,xo,yn=j(()=>{Ku=void 0,Yu=void 0,xo=void 0});var bn={};Br(bn,{join:()=>Zu});var Zu,wn=j(()=>{Zu=void 0});var Io=dr((Co,vn)=>{"use strict";var _o=(()=>{var e=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(e=e||__filename),function(t={}){var r=t,o,n;r.ready=new Promise((d,m)=>{o=d,n=m}),r.mountExternalData=(d,m)=>{(r.Fa||(r.Fa=new Map)).set(d,m)},r.unmountExternalData=()=>{delete r.Fa},r.jsepInit=(d,m,v,C,B,H,q,le)=>{r.ab=d,r.Qa=m,r.Sa=v,r.La=C,r.Ra=B,r.sa=H,r.Ta=q,r.Ua=le,m=(J,re,se)=>(...we)=>{let _e=tt,P=re?.();we=J(...we);let ue=re?.();return P!==ue&&(J=ue,se(P),re=se=null),tt!=_e?xr():we},v=J=>async(...re)=>{try{if(r.Ea)throw Error("Session already started");let se=r.Ea={Va:re[0],errors:[]},we=await J(...re);if(r.Ea!==se)throw Error("Session mismatch");d.flush();let _e=se.errors;if(0<_e.length){let P=await Promise.all(_e);if(P=P.filter(ue=>ue),0<P.length)throw Error(P.join(`\n`))}return we}finally{r.Ea=null}},r._OrtRun=v(m(r._OrtRun,()=>r._OrtRun,J=>r._OrtRun=J)),r._OrtRunWithBinding=v(m(r._OrtRunWithBinding,()=>r._OrtRunWithBinding,J=>r._OrtRunWithBinding=J)),r._OrtBindInput=m(r._OrtBindInput,()=>r._OrtBindInput,J=>r._OrtBindInput=J),r.jsepRegisterBuffer=(J,re,se,we)=>d.registerBuffer(J,re,se,we),r.jsepUnregisterBuffers=J=>{d.unregisterBuffers(J)},r.jsepGetBuffer=J=>d.getBuffer(J),r.jsepCreateDownloader=(J,re,se)=>d.createDownloader(J,re,se)};var s=Object.assign({},r),u="./this.program",l=(d,m)=>{throw m},a=typeof window=="object",p=typeof importScripts=="function",h=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",g="",b,w,y;if(h){var _=(yn(),Ht(gn)),I=(wn(),Ht(bn));g=p?I.dirname(g)+"/":__dirname+"/",b=(d,m)=>(d=We(d)?new URL(d):I.normalize(d),_.readFileSync(d,m?void 0:"utf8")),y=d=>(d=b(d,!0),d.buffer||(d=new Uint8Array(d)),d),w=(d,m,v,C=!0)=>{d=We(d)?new URL(d):I.normalize(d),_.readFile(d,C?void 0:"utf8",(B,H)=>{B?v(B):m(C?H.buffer:H)})},!r.thisProgram&&1<process.argv.length&&(u=process.argv[1].replace(/\\\\/g,"/")),process.argv.slice(2),l=(d,m)=>{throw process.exitCode=d,m},r.inspect=()=>"[Emscripten Module object]"}else(a||p)&&(p?g=self.location.href:typeof document<"u"&&document.currentScript&&(g=document.currentScript.src),e&&(g=e),g.indexOf("blob:")!==0?g=g.substr(0,g.replace(/[?#].*/,"").lastIndexOf("/")+1):g="",b=d=>{var m=new XMLHttpRequest;return m.open("GET",d,!1),m.send(null),m.responseText},p&&(y=d=>{var m=new XMLHttpRequest;return m.open("GET",d,!1),m.responseType="arraybuffer",m.send(null),new Uint8Array(m.response)}),w=(d,m,v)=>{var C=new XMLHttpRequest;C.open("GET",d,!0),C.responseType="arraybuffer",C.onload=()=>{C.status==200||C.status==0&&C.response?m(C.response):v()},C.onerror=v,C.send(null)});var $=console.log.bind(console),x=console.error.bind(console);Object.assign(r,s),s=null,typeof WebAssembly!="object"&&he("no native wasm support detected");var E,A=!1,z,R,V,T,N,te,Y;function K(){var d=E.buffer;r.HEAP8=R=new Int8Array(d),r.HEAP16=new Int16Array(d),r.HEAPU8=V=new Uint8Array(d),r.HEAPU16=new Uint16Array(d),r.HEAP32=T=new Int32Array(d),r.HEAPU32=N=new Uint32Array(d),r.HEAPF32=te=new Float32Array(d),r.HEAPF64=Y=new Float64Array(d)}var Q=[],Z=[],Ee=[],Pe=0,fe=null,Ie=null;function he(d){throw d="Aborted("+d+")",x(d),A=!0,z=1,d=new WebAssembly.RuntimeError(d+". Build with -sASSERTIONS for more info."),n(d),d}var ye=d=>d.startsWith("data:application/octet-stream;base64,"),We=d=>d.startsWith("file://"),De;if(De="ort-wasm-simd.wasm",!ye(De)){var Ge=De;De=r.locateFile?r.locateFile(Ge,g):g+Ge}function G(d){if(y)return y(d);throw"both async and sync fetching of the wasm failed"}function ee(d){if(a||p){if(typeof fetch=="function"&&!We(d))return fetch(d,{credentials:"same-origin"}).then(m=>{if(!m.ok)throw"failed to load wasm binary file at \'"+d+"\'";return m.arrayBuffer()}).catch(()=>G(d));if(w)return new Promise((m,v)=>{w(d,C=>m(new Uint8Array(C)),v)})}return Promise.resolve().then(()=>G(d))}function be(d,m,v){return ee(d).then(C=>WebAssembly.instantiate(C,m)).then(C=>C).then(v,C=>{x(`failed to asynchronously prepare wasm: ${C}`),he(C)})}function et(d,m){var v=De;return typeof WebAssembly.instantiateStreaming!="function"||ye(v)||We(v)||h||typeof fetch!="function"?be(v,d,m):fetch(v,{credentials:"same-origin"}).then(C=>WebAssembly.instantiateStreaming(C,d).then(m,function(B){return x(`wasm streaming compile failed: ${B}`),x("falling back to ArrayBuffer instantiation"),be(v,d,m)}))}var ze,Ue={931056:(d,m,v,C)=>{if(typeof r>"u"||!r.Fa)return 1;if(d=qe(d>>>0),d.startsWith("./")&&(d=d.substring(2)),d=r.Fa.get(d),!d)return 2;if(m>>>=0,v>>>=0,m+v>d.byteLength)return 3;try{return V.set(d.subarray(m,m+v),C>>>0>>>0),0}catch{return 4}},931557:d=>r.Qa(d),931590:d=>r.Sa(d),931622:(d,m,v)=>{r.La(d,m,v,!0)},931661:(d,m,v)=>{r.La(d,m,v)},931694:d=>{r.sa("Abs",d,void 0)},931745:d=>{r.sa("Neg",d,void 0)},931796:d=>{r.sa("Floor",d,void 0)},931849:d=>{r.sa("Ceil",d,void 0)},931901:d=>{r.sa("Reciprocal",d,void 0)},931959:d=>{r.sa("Sqrt",d,void 0)},932011:d=>{r.sa("Exp",d,void 0)},932062:d=>{r.sa("Erf",d,void 0)},932113:d=>{r.sa("Sigmoid",d,void 0)},932168:d=>{r.sa("Log",d,void 0)},932219:d=>{r.sa("Sin",d,void 0)},932270:d=>{r.sa("Cos",d,void 0)},932321:d=>{r.sa("Tan",d,void 0)},932372:d=>{r.sa("Asin",d,void 0)},932424:d=>{r.sa("Acos",d,void 0)},932476:d=>{r.sa("Atan",d,void 0)},932528:d=>{r.sa("Sinh",d,void 0)},932580:d=>{r.sa("Cosh",d,void 0)},932632:d=>{r.sa("Asinh",d,void 0)},932685:d=>{r.sa("Acosh",d,void 0)},932738:d=>{r.sa("Atanh",d,void 0)},932791:d=>{r.sa("Tanh",d,void 0)},932843:d=>{r.sa("Not",d,void 0)},932894:(d,m,v)=>{r.sa("Clip",d,{min:m,max:v})},932963:d=>{r.sa("Clip",d,void 0)},933015:(d,m)=>{r.sa("Elu",d,{alpha:m})},933073:d=>{r.sa("Relu",d,void 0)},933125:(d,m)=>{r.sa("LeakyRelu",d,{alpha:m})},933189:(d,m)=>{r.sa("ThresholdedRelu",d,{alpha:m})},933259:(d,m)=>{r.sa("Cast",d,{to:m})},933317:d=>{r.sa("Add",d,void 0)},933368:d=>{r.sa("Sub",d,void 0)},933419:d=>{r.sa("Mul",d,void 0)},933470:d=>{r.sa("Div",d,void 0)},933521:d=>{r.sa("Pow",d,void 0)},933572:d=>{r.sa("Equal",d,void 0)},933625:d=>{r.sa("Greater",d,void 0)},933680:d=>{r.sa("GreaterOrEqual",d,void 0)},933742:d=>{r.sa("Less",d,void 0)},933794:d=>{r.sa("LessOrEqual",d,void 0)},933853:(d,m,v,C,B)=>{r.sa("ReduceMean",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934012:(d,m,v,C,B)=>{r.sa("ReduceMax",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934170:(d,m,v,C,B)=>{r.sa("ReduceMin",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934328:(d,m,v,C,B)=>{r.sa("ReduceProd",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934487:(d,m,v,C,B)=>{r.sa("ReduceSum",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934645:(d,m,v,C,B)=>{r.sa("ReduceL1",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934802:(d,m,v,C,B)=>{r.sa("ReduceL2",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},934959:(d,m,v,C,B)=>{r.sa("ReduceLogSum",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},935120:(d,m,v,C,B)=>{r.sa("ReduceSumSquare",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},935284:(d,m,v,C,B)=>{r.sa("ReduceLogSumExp",d,{keepDims:!!m,noopWithEmptyAxes:!!v,axes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},935448:d=>{r.sa("Where",d,void 0)},935501:(d,m,v)=>{r.sa("Transpose",d,{perm:m?Array.from(T.subarray(m>>>0,v>>>0)):[]})},935609:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue)=>{r.sa("ConvTranspose",d,{format:J?"NHWC":"NCHW",autoPad:m,dilations:[v],group:C,kernel_shape:[B],pads:[H,q],strides:[le],wIsConst:()=>!!R[re>>>0],outputPadding:se?Array.from(T.subarray(se>>>0,we>>>0)):[],outputShape:_e?Array.from(T.subarray(_e>>>0,P>>>0)):[],activation:qe(ue)})},936011:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P)=>{r.sa("ConvTranspose",d,{format:le?"NHWC":"NCHW",autoPad:m,dilations:Array.from(T.subarray(v>>>0,(v>>>0)+2>>>0)),group:C,kernelShape:Array.from(T.subarray(B>>>0,(B>>>0)+2>>>0)),pads:Array.from(T.subarray(H>>>0,(H>>>0)+4>>>0)),strides:Array.from(T.subarray(q>>>0,(q>>>0)+2>>>0)),wIsConst:()=>!!R[J>>>0],outputPadding:re?Array.from(T.subarray(re>>>0,se>>>0)):[],outputShape:we?Array.from(T.subarray(we>>>0,_e>>>0)):[],activation:qe(P)})},936576:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue)=>{r.sa("ConvTranspose",d,{format:J?"NHWC":"NCHW",autoPad:m,dilations:[v],group:C,kernel_shape:[B],pads:[H,q],strides:[le],wIsConst:()=>!!R[re>>>0],outputPadding:se?Array.from(T.subarray(se>>>0,we>>>0)):[],outputShape:_e?Array.from(T.subarray(_e>>>0,P>>>0)):[],activation:qe(ue)})},936978:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P)=>{r.sa("ConvTranspose",d,{format:le?"NHWC":"NCHW",autoPad:m,dilations:Array.from(T.subarray(v>>>0,(v>>>0)+2>>>0)),group:C,kernelShape:Array.from(T.subarray(B>>>0,(B>>>0)+2>>>0)),pads:Array.from(T.subarray(H>>>0,(H>>>0)+4>>>0)),strides:Array.from(T.subarray(q>>>0,(q>>>0)+2>>>0)),wIsConst:()=>!!R[J>>>0],outputPadding:re?Array.from(T.subarray(re>>>0,se>>>0)):[],outputShape:we?Array.from(T.subarray(we>>>0,_e>>>0)):[],activation:qe(P)})},937543:(d,m)=>{r.sa("GlobalAveragePool",d,{format:m?"NHWC":"NCHW"})},937634:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue,Se)=>{r.sa("AveragePool",d,{format:Se?"NHWC":"NCHW",auto_pad:m,ceil_mode:v,count_include_pad:C,storage_order:B,dilations:[H,q],kernel_shape:[le,J],pads:[re,se,we,_e],strides:[P,ue]})},937918:(d,m)=>{r.sa("GlobalAveragePool",d,{format:m?"NHWC":"NCHW"})},938009:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue,Se)=>{r.sa("AveragePool",d,{format:Se?"NHWC":"NCHW",auto_pad:m,ceil_mode:v,count_include_pad:C,storage_order:B,dilations:[H,q],kernel_shape:[le,J],pads:[re,se,we,_e],strides:[P,ue]})},938293:(d,m)=>{r.sa("GlobalMaxPool",d,{format:m?"NHWC":"NCHW"})},938380:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue,Se)=>{r.sa("MaxPool",d,{format:Se?"NHWC":"NCHW",auto_pad:m,ceil_mode:v,count_include_pad:C,storage_order:B,dilations:[H,q],kernel_shape:[le,J],pads:[re,se,we,_e],strides:[P,ue]})},938660:(d,m)=>{r.sa("GlobalMaxPool",d,{format:m?"NHWC":"NCHW"})},938747:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue,Se)=>{r.sa("MaxPool",d,{format:Se?"NHWC":"NCHW",auto_pad:m,ceil_mode:v,count_include_pad:C,storage_order:B,dilations:[H,q],kernel_shape:[le,J],pads:[re,se,we,_e],strides:[P,ue]})},939027:(d,m,v,C,B)=>{r.sa("Gemm",d,{alpha:m,beta:v,transA:C,transB:B})},939131:d=>{r.sa("MatMul",d,void 0)},939185:(d,m,v,C)=>{r.sa("ArgMax",d,{keepDims:!!m,selectLastIndex:!!v,axis:C})},939293:(d,m,v,C)=>{r.sa("ArgMin",d,{keepDims:!!m,selectLastIndex:!!v,axis:C})},939401:(d,m)=>{r.sa("Softmax",d,{axis:m})},939464:(d,m)=>{r.sa("Concat",d,{axis:m})},939524:(d,m,v,C,B)=>{r.sa("Split",d,{axis:m,numOutputs:v,splitSizes:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},939664:d=>{r.sa("Expand",d,void 0)},939718:(d,m)=>{r.sa("Gather",d,{axis:Number(m)})},939789:(d,m)=>{r.sa("GatherElements",d,{axis:Number(m)})},939868:(d,m,v,C,B,H,q,le,J,re,se)=>{r.sa("Resize",d,{antialias:m,axes:v?Array.from(T.subarray(v>>>0,C>>>0)):[],coordinateTransformMode:qe(B),cubicCoeffA:H,excludeOutside:q,extrapolationValue:le,keepAspectRatioPolicy:qe(J),mode:qe(re),nearestMode:qe(se)})},940214:(d,m,v,C,B,H,q)=>{r.sa("Slice",d,{starts:m?Array.from(T.subarray(m>>>0,v>>>0)):[],ends:C?Array.from(T.subarray(C>>>0,B>>>0)):[],axes:H?Array.from(T.subarray(H>>>0,q>>>0)):[]})},940430:d=>{r.sa("Tile",d,void 0)},940482:(d,m,v)=>{r.sa("LayerNormalization",d,{axis:Number(m),epsilon:Number(v)})},940589:(d,m,v)=>{r.sa("InstanceNormalization",d,{epsilon:m,format:v?"NHWC":"NCHW"})},940703:(d,m,v)=>{r.sa("InstanceNormalization",d,{epsilon:m,format:v?"NHWC":"NCHW"})},940817:d=>{r.sa("Range",d,void 0)},940870:(d,m)=>{r.sa("Einsum",d,{equation:qe(m)})},940951:(d,m,v,C,B)=>{r.sa("Pad",d,{mode:m,value:v,pads:C?Array.from(T.subarray(C>>>0,B>>>0)):[]})},941078:(d,m,v,C,B,H)=>{r.sa("BatchNormalization",d,{epsilon:m,momentum:v,spatial:!!B,trainingMode:!!C,format:H?"NHWC":"NCHW"})},941247:(d,m,v,C,B,H)=>{r.sa("BatchNormalization",d,{epsilon:m,momentum:v,spatial:!!B,trainingMode:!!C,format:H?"NHWC":"NCHW"})},941416:(d,m,v)=>{r.sa("CumSum",d,{exclusive:Number(m),reverse:Number(v)})},941513:(d,m,v,C,B,H,q,le,J)=>{r.sa("Attention",d,{numHeads:m,isUnidirectional:v,maskFilterValue:C,scale:B,doRotary:H,qkvHiddenSizes:q?Array.from(T.subarray(Number(le)>>>0,Number(le)+q>>>0)):[],pastPresentShareBuffer:!!J})},941785:d=>{r.sa("Gelu",d,void 0)},941837:(d,m,v,C,B,H)=>{r.sa("MultiHeadAttention",d,{numHeads:m,isUnidirectional:v,maskFilterValue:C,scale:B,doRotary:H})},941996:d=>{r.sa("BiasAdd",d,void 0)},942051:d=>{r.sa("BiasSplitGelu",d,void 0)},942112:(d,m)=>{r.sa("SkipLayerNormalization",d,{epsilon:m})},942193:(d,m,v,C,B,H,q,le,J,re,se,we,_e)=>{r.sa("Conv",d,{format:J?"NHWC":"NCHW",auto_pad:m,dilations:[v],group:C,kernel_shape:[B],pads:H?Array.from(T.subarray(H>>>0,q>>>0)):[],strides:[le],w_is_const:()=>!!R[re>>>0],activation:qe(se),activation_params:we?Array.from(te.subarray(we>>>0,_e>>>0)):[]})},942563:(d,m,v,C,B,H,q,le,J,re,se,we,_e,P,ue,Se)=>{r.sa("Conv",d,{format:we?"NHWC":"NCHW",auto_pad:m,dilations:[v,C],group:B,kernel_shape:[H,q],pads:le?Array.from(T.subarray(le>>>0,J>>>0)):[],strides:[re,se],w_is_const:()=>!!R[_e>>>0],activation:qe(P),activation_params:ue?Array.from(te.subarray(ue>>>0,Se>>>0)):[]})},942954:d=>{r.Ta(d)},942988:(d,m)=>r.Ua(d,m,r.Ea.Va,r.Ea.errors)};function Me(d){this.name="ExitStatus",this.message=`Program terminated with exit(${d})`,this.status=d}function wt(d){this.Ja=d-24,this.Oa=function(m){N[this.Ja+4>>>2>>>0]=m},this.Na=function(m){N[this.Ja+8>>>2>>>0]=m},this.$a=function(m,v){this.Ma(),this.Oa(m),this.Na(v)},this.Ma=function(){N[this.Ja+16>>>2>>>0]=0}}var rt=0,Dt=0,At=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,vt=(d,m,v)=>{m>>>=0;var C=m+v;for(v=m;d[v]&&!(v>=C);)++v;if(16<v-m&&d.buffer&&At)return At.decode(d.subarray(m,v));for(C="";m<v;){var B=d[m++];if(B&128){var H=d[m++]&63;if((B&224)==192)C+=String.fromCharCode((B&31)<<6|H);else{var q=d[m++]&63;B=(B&240)==224?(B&15)<<12|H<<6|q:(B&7)<<18|H<<12|q<<6|d[m++]&63,65536>B?C+=String.fromCharCode(B):(B-=65536,C+=String.fromCharCode(55296|B>>10,56320|B&1023))}}else C+=String.fromCharCode(B)}return C},qe=(d,m)=>(d>>>=0)?vt(V,d,m):"",qt=d=>{for(var m=0,v=0;v<d.length;++v){var C=d.charCodeAt(v);127>=C?m++:2047>=C?m+=2:55296<=C&&57343>=C?(m+=4,++v):m+=3}return m},Mt=(d,m,v,C)=>{if(v>>>=0,!(0<C))return 0;var B=v;C=v+C-1;for(var H=0;H<d.length;++H){var q=d.charCodeAt(H);if(55296<=q&&57343>=q){var le=d.charCodeAt(++H);q=65536+((q&1023)<<10)|le&1023}if(127>=q){if(v>=C)break;m[v++>>>0]=q}else{if(2047>=q){if(v+1>=C)break;m[v++>>>0]=192|q>>6}else{if(65535>=q){if(v+2>=C)break;m[v++>>>0]=224|q>>12}else{if(v+3>=C)break;m[v++>>>0]=240|q>>18,m[v++>>>0]=128|q>>12&63}m[v++>>>0]=128|q>>6&63}m[v++>>>0]=128|q&63}}return m[v>>>0]=0,v-B},$t=d=>d%4===0&&(d%100!==0||d%400===0),yt=[0,31,60,91,121,152,182,213,244,274,305,335],zt=[0,31,59,90,120,151,181,212,243,273,304,334],Ut=d=>{var m=qt(d)+1,v=Wt(m);return v&&Mt(d,V,v,m),v},Tt=[],Kt=(d,m)=>{Tt.length=0;for(var v;v=V[d++>>>0];){var C=v!=105;C&=v!=112,m+=C&&m%8?4:0,Tt.push(v==112?N[m>>>2>>>0]:v==105?T[m>>>2>>>0]:Y[m>>>3>>>0]),m+=C?8:4}return Tt},nt={},Yt=()=>{if(!Vt){var d={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:u||"./this.program"},m;for(m in nt)nt[m]===void 0?delete d[m]:d[m]=nt[m];var v=[];for(m in d)v.push(`${m}=${d[m]}`);Vt=v}return Vt},Vt,Ye=[null,[],[]],br=[31,29,31,30,31,30,31,31,30,31,30,31],Oe=[31,28,31,30,31,30,31,31,30,31,30,31];function wr(d){var m=Array(qt(d)+1);return Mt(d,m,0,m.length),m}function Nt(d,m,v,C){function B(P,ue,Se){for(P=typeof P=="number"?P.toString():P||"";P.length<ue;)P=Se[0]+P;return P}function H(P,ue){return B(P,ue,"0")}function q(P,ue){function Se(Tr){return 0>Tr?-1:0<Tr?1:0}var st;return(st=Se(P.getFullYear()-ue.getFullYear()))===0&&(st=Se(P.getMonth()-ue.getMonth()))===0&&(st=Se(P.getDate()-ue.getDate())),st}function le(P){switch(P.getDay()){case 0:return new Date(P.getFullYear()-1,11,29);case 1:return P;case 2:return new Date(P.getFullYear(),0,3);case 3:return new Date(P.getFullYear(),0,2);case 4:return new Date(P.getFullYear(),0,1);case 5:return new Date(P.getFullYear()-1,11,31);case 6:return new Date(P.getFullYear()-1,11,30)}}function J(P){var ue=P.Ca;for(P=new Date(new Date(P.Da+1900,0,1).getTime());0<ue;){var Se=P.getMonth(),st=($t(P.getFullYear())?br:Oe)[Se];if(ue>st-P.getDate())ue-=st-P.getDate()+1,P.setDate(1),11>Se?P.setMonth(Se+1):(P.setMonth(0),P.setFullYear(P.getFullYear()+1));else{P.setDate(P.getDate()+ue);break}}return Se=new Date(P.getFullYear()+1,0,4),ue=le(new Date(P.getFullYear(),0,4)),Se=le(Se),0>=q(ue,P)?0>=q(Se,P)?P.getFullYear()+1:P.getFullYear():P.getFullYear()-1}d>>>=0,m>>>=0,v>>>=0,C>>>=0;var re=N[C+40>>>2>>>0];C={Ya:T[C>>>2>>>0],Xa:T[C+4>>>2>>>0],Ga:T[C+8>>>2>>>0],Ka:T[C+12>>>2>>>0],Ha:T[C+16>>>2>>>0],Da:T[C+20>>>2>>>0],xa:T[C+24>>>2>>>0],Ca:T[C+28>>>2>>>0],bb:T[C+32>>>2>>>0],Wa:T[C+36>>>2>>>0],Za:re?qe(re):""},v=qe(v),re={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var se in re)v=v.replace(new RegExp(se,"g"),re[se]);var we="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),_e="January February March April May June July August September October November December".split(" ");re={"%a":P=>we[P.xa].substring(0,3),"%A":P=>we[P.xa],"%b":P=>_e[P.Ha].substring(0,3),"%B":P=>_e[P.Ha],"%C":P=>H((P.Da+1900)/100|0,2),"%d":P=>H(P.Ka,2),"%e":P=>B(P.Ka,2," "),"%g":P=>J(P).toString().substring(2),"%G":P=>J(P),"%H":P=>H(P.Ga,2),"%I":P=>(P=P.Ga,P==0?P=12:12<P&&(P-=12),H(P,2)),"%j":P=>{for(var ue=0,Se=0;Se<=P.Ha-1;ue+=($t(P.Da+1900)?br:Oe)[Se++]);return H(P.Ka+ue,3)},"%m":P=>H(P.Ha+1,2),"%M":P=>H(P.Xa,2),"%n":()=>`\n`,"%p":P=>0<=P.Ga&&12>P.Ga?"AM":"PM","%S":P=>H(P.Ya,2),"%t":()=>"	","%u":P=>P.xa||7,"%U":P=>H(Math.floor((P.Ca+7-P.xa)/7),2),"%V":P=>{var ue=Math.floor((P.Ca+7-(P.xa+6)%7)/7);if(2>=(P.xa+371-P.Ca-2)%7&&ue++,ue)ue==53&&(Se=(P.xa+371-P.Ca)%7,Se==4||Se==3&&$t(P.Da)||(ue=1));else{ue=52;var Se=(P.xa+7-P.Ca-1)%7;(Se==4||Se==5&&$t(P.Da%400-1))&&ue++}return H(ue,2)},"%w":P=>P.xa,"%W":P=>H(Math.floor((P.Ca+7-(P.xa+6)%7)/7),2),"%y":P=>(P.Da+1900).toString().substring(2),"%Y":P=>P.Da+1900,"%z":P=>{P=P.Wa;var ue=0<=P;return P=Math.abs(P)/60,(ue?"+":"-")+("0000"+(P/60*100+P%60)).slice(-4)},"%Z":P=>P.Za,"%%":()=>"%"},v=v.replace(/%%/g,"\\0\\0");for(se in re)v.includes(se)&&(v=v.replace(new RegExp(se,"g"),re[se](C)));return v=v.replace(/\\0\\0/g,"%"),se=wr(v),se.length>m?0:(R.set(se,d>>>0),se.length-1)}var St=d=>{try{d()}catch(m){he(m)}};function un(){var d=ae,m={};for(let[v,C]of Object.entries(d))m[v]=typeof C=="function"?function(){bt.push(v);try{return C.apply(null,arguments)}finally{A||(bt.pop(),tt&&ot===1&&bt.length===0&&(ot=0,St(ir),typeof Fibers<"u"&&Fibers.cb()))}}:C;return m}var ot=0,tt=null,de=0,bt=[],Zt={},vr={},$r=0,Qt=null,Sr=[];function xr(){return new Promise((d,m)=>{Qt={resolve:d,reject:m}})}function _r(){var d=Wt(65548),m=d+12;N[d>>>2>>>0]=m,N[d+4>>>2>>>0]=m+65536,m=bt[0];var v=Zt[m];return v===void 0&&(v=$r++,Zt[m]=v,vr[v]=m),T[d+8>>>2>>>0]=v,d}function Cr(d){if(!A){if(ot===0){var m=!1,v=!1;d((C=0)=>{if(!A&&(de=C,m=!0,v)){ot=2,St(()=>sr(tt)),typeof Browser<"u"&&Browser.Ia.Pa&&Browser.Ia.resume(),C=!1;try{var B=(0,ae[vr[T[tt+8>>>2>>>0]]])()}catch(le){B=le,C=!0}var H=!1;if(!tt){var q=Qt;q&&(Qt=null,(C?q.reject:q.resolve)(B),H=!0)}if(C&&!H)throw B}}),v=!0,m||(ot=1,tt=_r(),typeof Browser<"u"&&Browser.Ia.Pa&&Browser.Ia.pause(),St(()=>ar(tt)))}else ot===2?(ot=0,St(ur),er(tt),tt=null,Sr.forEach(C=>{if(!A)try{C();try{z=z=C=z,r.onExit?.(C),A=!0,l(C,new Me(C))}catch(B){B instanceof Me||B=="unwind"||l(1,B)}}catch(B){B instanceof Me||B=="unwind"||l(1,B)}})):he(`invalid state: ${ot}`);return de}}function Xt(d){return Cr(m=>{d().then(m)})}var Ir={n:function(d,m,v){return Xt(async()=>{await r.Ra(d,m,v)})},a:function(d,m,v){throw d>>>=0,new wt(d).$a(m>>>0,v>>>0),rt=d,Dt++,rt},g:function(){return 0},J:function(){},A:function(){},C:function(){},L:function(){return 0},H:function(){},D:function(){},G:function(){},l:function(){},B:function(){},y:function(){},I:function(){},z:function(){},m:()=>1,q:function(d,m,v){d=m+2097152>>>0<4194305-!!d?(d>>>0)+4294967296*m:NaN,v>>>=0,d=new Date(1e3*d),T[v>>>2>>>0]=d.getUTCSeconds(),T[v+4>>>2>>>0]=d.getUTCMinutes(),T[v+8>>>2>>>0]=d.getUTCHours(),T[v+12>>>2>>>0]=d.getUTCDate(),T[v+16>>>2>>>0]=d.getUTCMonth(),T[v+20>>>2>>>0]=d.getUTCFullYear()-1900,T[v+24>>>2>>>0]=d.getUTCDay(),T[v+28>>>2>>>0]=(d.getTime()-Date.UTC(d.getUTCFullYear(),0,1,0,0,0,0))/864e5|0},r:function(d,m,v){d=m+2097152>>>0<4194305-!!d?(d>>>0)+4294967296*m:NaN,v>>>=0,d=new Date(1e3*d),T[v>>>2>>>0]=d.getSeconds(),T[v+4>>>2>>>0]=d.getMinutes(),T[v+8>>>2>>>0]=d.getHours(),T[v+12>>>2>>>0]=d.getDate(),T[v+16>>>2>>>0]=d.getMonth(),T[v+20>>>2>>>0]=d.getFullYear()-1900,T[v+24>>>2>>>0]=d.getDay(),T[v+28>>>2>>>0]=($t(d.getFullYear())?yt:zt)[d.getMonth()]+d.getDate()-1|0,T[v+36>>>2>>>0]=-(60*d.getTimezoneOffset()),m=new Date(d.getFullYear(),6,1).getTimezoneOffset();var C=new Date(d.getFullYear(),0,1).getTimezoneOffset();T[v+32>>>2>>>0]=(m!=C&&d.getTimezoneOffset()==Math.min(C,m))|0},s:function(d){d>>>=0;var m=new Date(T[d+20>>>2>>>0]+1900,T[d+16>>>2>>>0],T[d+12>>>2>>>0],T[d+8>>>2>>>0],T[d+4>>>2>>>0],T[d>>>2>>>0],0),v=T[d+32>>>2>>>0],C=m.getTimezoneOffset(),B=new Date(m.getFullYear(),6,1).getTimezoneOffset(),H=new Date(m.getFullYear(),0,1).getTimezoneOffset(),q=Math.min(H,B);return 0>v?T[d+32>>>2>>>0]=+(B!=H&&q==C):0<v!=(q==C)&&(B=Math.max(H,B),m.setTime(m.getTime()+6e4*((0<v?q:B)-C))),T[d+24>>>2>>>0]=m.getDay(),T[d+28>>>2>>>0]=($t(m.getFullYear())?yt:zt)[m.getMonth()]+m.getDate()-1|0,T[d>>>2>>>0]=m.getSeconds(),T[d+4>>>2>>>0]=m.getMinutes(),T[d+8>>>2>>>0]=m.getHours(),T[d+12>>>2>>>0]=m.getDate(),T[d+16>>>2>>>0]=m.getMonth(),T[d+20>>>2>>>0]=m.getYear(),d=m.getTime(),isNaN(d)?(T[Jt()>>>2>>>0]=61,d=-1):d/=1e3,tr((ze=d,1<=+Math.abs(ze)?0<ze?+Math.floor(ze/4294967296)>>>0:~~+Math.ceil((ze-+(~~ze>>>0))/4294967296)>>>0:0)),d>>>0},o:function(){return-52},p:function(){},w:function(d,m,v){function C(J){return(J=J.toTimeString().match(/\\(([A-Za-z ]+)\\)$/))?J[1]:"GMT"}v>>>=0;var B=new Date().getFullYear(),H=new Date(B,0,1),q=new Date(B,6,1);B=H.getTimezoneOffset();var le=q.getTimezoneOffset();N[d>>>0>>>2>>>0]=60*Math.max(B,le),T[m>>>0>>>2>>>0]=+(B!=le),d=C(H),m=C(q),d=Ut(d),m=Ut(m),le<B?(N[v>>>2>>>0]=d,N[v+4>>>2>>>0]=m):(N[v>>>2>>>0]=m,N[v+4>>>2>>>0]=d)},e:()=>{he("")},b:function(d,m,v){return d>>>=0,m=Kt(m>>>0,v>>>0),Ue[d].apply(null,m)},i:function(d,m,v){return d>>>=0,m=Kt(m>>>0,v>>>0),Ue[d].apply(null,m)},h:()=>Date.now(),x:function(){return 4294901760},c:()=>performance.now(),K:function(d,m,v){return m>>>=0,V.copyWithin(d>>>0>>>0,m>>>0,m+(v>>>0)>>>0)},u:function(d){d>>>=0;var m=V.length;if(4294901760<d)return!1;for(var v=1;4>=v;v*=2){var C=m*(1+.2/v);C=Math.min(C,d+100663296);var B=Math;C=Math.max(d,C);e:{B=(B.min.call(B,4294901760,C+(65536-C%65536)%65536)-E.buffer.byteLength+65535)/65536;try{E.grow(B),K();var H=1;break e}catch{}H=void 0}if(H)return!0}return!1},E:function(d,m){d>>>=0,m>>>=0;var v=0;return Yt().forEach((C,B)=>{var H=m+v;for(B=N[d+4*B>>>2>>>0]=H,H=0;H<C.length;++H)R[B++>>>0>>>0]=C.charCodeAt(H);R[B>>>0>>>0]=0,v+=C.length+1}),0},F:function(d,m){d>>>=0,m>>>=0;var v=Yt();N[d>>>2>>>0]=v.length;var C=0;return v.forEach(B=>C+=B.length+1),N[m>>>2>>>0]=C,0},f:()=>52,k:function(){return 52},t:function(){return 70},j:function(d,m,v,C){m>>>=0,v>>>=0,C>>>=0;for(var B=0,H=0;H<v;H++){var q=N[m>>>2>>>0],le=N[m+4>>>2>>>0];m+=8;for(var J=0;J<le;J++){var re=V[q+J>>>0],se=Ye[d];re===0||re===10?((d===1?$:x)(vt(se,0)),se.length=0):se.push(re)}B+=le}return N[C>>>2>>>0]=B,0},v:Nt,d:function(d,m,v,C){return Nt(d>>>0,m>>>0,v>>>0,C>>>0)}},ae=function(){function d(v){return ae=v.exports,ae=un(),ae=Ar(),E=ae.M,K(),Z.unshift(ae.N),Pe--,Pe==0&&(fe!==null&&(clearInterval(fe),fe=null),Ie&&(v=Ie,Ie=null,v())),ae}var m={a:Ir};if(Pe++,r.instantiateWasm)try{return r.instantiateWasm(m,d)}catch(v){x(`Module.instantiateWasm callback failed with error: ${v}`),n(v)}return et(m,function(v){d(v.instance)}).catch(n),{}}();r._OrtInit=(d,m)=>(r._OrtInit=ae.O)(d,m),r._OrtGetLastError=(d,m)=>(r._OrtGetLastError=ae.P)(d,m),r._OrtCreateSessionOptions=(d,m,v,C,B,H,q,le,J,re)=>(r._OrtCreateSessionOptions=ae.Q)(d,m,v,C,B,H,q,le,J,re),r._OrtAppendExecutionProvider=(d,m)=>(r._OrtAppendExecutionProvider=ae.R)(d,m),r._OrtAddFreeDimensionOverride=(d,m,v)=>(r._OrtAddFreeDimensionOverride=ae.S)(d,m,v),r._OrtAddSessionConfigEntry=(d,m,v)=>(r._OrtAddSessionConfigEntry=ae.T)(d,m,v),r._OrtReleaseSessionOptions=d=>(r._OrtReleaseSessionOptions=ae.U)(d),r._OrtCreateSession=(d,m,v)=>(r._OrtCreateSession=ae.V)(d,m,v),r._OrtReleaseSession=d=>(r._OrtReleaseSession=ae.W)(d),r._OrtGetInputOutputCount=(d,m,v)=>(r._OrtGetInputOutputCount=ae.X)(d,m,v),r._OrtGetInputName=(d,m)=>(r._OrtGetInputName=ae.Y)(d,m),r._OrtGetOutputName=(d,m)=>(r._OrtGetOutputName=ae.Z)(d,m),r._OrtFree=d=>(r._OrtFree=ae._)(d),r._OrtCreateTensor=(d,m,v,C,B,H)=>(r._OrtCreateTensor=ae.$)(d,m,v,C,B,H),r._OrtGetTensorData=(d,m,v,C,B)=>(r._OrtGetTensorData=ae.aa)(d,m,v,C,B),r._OrtReleaseTensor=d=>(r._OrtReleaseTensor=ae.ba)(d),r._OrtCreateRunOptions=(d,m,v,C)=>(r._OrtCreateRunOptions=ae.ca)(d,m,v,C),r._OrtAddRunConfigEntry=(d,m,v)=>(r._OrtAddRunConfigEntry=ae.da)(d,m,v),r._OrtReleaseRunOptions=d=>(r._OrtReleaseRunOptions=ae.ea)(d),r._OrtCreateBinding=d=>(r._OrtCreateBinding=ae.fa)(d),r._OrtBindInput=(d,m,v)=>(r._OrtBindInput=ae.ga)(d,m,v),r._OrtBindOutput=(d,m,v,C)=>(r._OrtBindOutput=ae.ha)(d,m,v,C),r._OrtClearBoundOutputs=d=>(r._OrtClearBoundOutputs=ae.ia)(d),r._OrtReleaseBinding=d=>(r._OrtReleaseBinding=ae.ja)(d),r._OrtRunWithBinding=(d,m,v,C,B)=>(r._OrtRunWithBinding=ae.ka)(d,m,v,C,B),r._OrtRun=(d,m,v,C,B,H,q,le)=>(r._OrtRun=ae.la)(d,m,v,C,B,H,q,le),r._OrtEndProfiling=d=>(r._OrtEndProfiling=ae.ma)(d),r._JsepOutput=(d,m,v)=>(r._JsepOutput=ae.na)(d,m,v),r._JsepGetNodeName=d=>(r._JsepGetNodeName=ae.oa)(d);var Jt=()=>(Jt=ae.pa)(),Wt=r._malloc=d=>(Wt=r._malloc=ae.qa)(d),er=r._free=d=>(er=r._free=ae.ra)(d),tr=d=>(tr=ae.ta)(d),rr=()=>(rr=ae.ua)(),nr=d=>(nr=ae.va)(d),or=d=>(or=ae.wa)(d),ar=d=>(ar=ae.ya)(d),ir=()=>(ir=ae.za)(),sr=d=>(sr=ae.Aa)(d),ur=()=>(ur=ae.Ba)();r.___start_em_js=943100,r.___stop_em_js=943261;function Ar(){var d=ae;d=Object.assign({},d);var m=C=>()=>C()>>>0,v=C=>B=>C(B)>>>0;return d.pa=m(d.pa),d.qa=v(d.qa),d.ua=m(d.ua),d.wa=v(d.wa),d}r.stackAlloc=or,r.stackSave=rr,r.stackRestore=nr,r.UTF8ToString=qe,r.stringToUTF8=(d,m,v)=>Mt(d,V,m,v),r.lengthBytesUTF8=qt;var xt;Ie=function d(){xt||Et(),xt||(Ie=d)};function Et(){if(!(0<Pe)){if(r.preRun)for(typeof r.preRun=="function"&&(r.preRun=[r.preRun]);r.preRun.length;){var d=r.preRun.shift();Q.unshift(d)}for(;0<Q.length;)Q.shift()(r);if(!(0<Pe||xt||(xt=!0,r.calledRun=!0,A))){for(;0<Z.length;)Z.shift()(r);for(o(r);0<Ee.length;)Ee.shift()(r)}}}return Et(),t.ready}})();typeof Co=="object"&&typeof vn=="object"?vn.exports=_o:typeof define=="function"&&define.amd&&define([],()=>_o)});var Ao=dr(()=>{});var To=dr(()=>{});var Eo={};Br(Eo,{cpus:()=>Qu});var Qu,Oo=j(()=>{Qu=void 0});var Ro=dr((ko,$n)=>{"use strict";var Po=(()=>{var e=typeof document<"u"&&document.currentScript?document.currentScript.src:void 0;return typeof __filename<"u"&&(e=e||__filename),function(t={}){function r(){return Q.buffer!=fe.buffer&&Ge(),fe}function o(){return Q.buffer!=fe.buffer&&Ge(),Ie}function n(){return Q.buffer!=fe.buffer&&Ge(),he}function s(){return Q.buffer!=fe.buffer&&Ge(),ye}function u(){return Q.buffer!=fe.buffer&&Ge(),We}function l(){return Q.buffer!=fe.buffer&&Ge(),De}var a=t,p,h;a.ready=new Promise((i,c)=>{p=i,h=c}),a.mountExternalData=(i,c)=>{(a.cb||(a.cb=new Map)).set(i,c)},a.unmountExternalData=()=>{delete a.cb},a.jsepInit=(i,c,f,S,O,D,W,ie)=>{a.Mb=i,a.wb=c,a.yb=f,a.kb=S,a.xb=O,a.Ea=D,a.zb=W,a.Ab=ie,c=(ne,oe,pe)=>(...xe)=>{let Te=ut,k=oe?.();xe=ne(...xe);let me=oe?.();return k!==me&&(ne=me,pe(k),oe=pe=null),ut!=Te?Mu():xe},f=ne=>async(...oe)=>{try{if(a.bb)throw Error("Session already started");let pe=a.bb={Cb:oe[0],errors:[]},xe=await ne(...oe);if(a.bb!==pe)throw Error("Session mismatch");i.flush();let Te=pe.errors;if(0<Te.length){let k=await Promise.all(Te);if(k=k.filter(me=>me),0<k.length)throw Error(k.join(`\n`))}return xe}finally{a.bb=null}},a._OrtRun=f(c(a._OrtRun,()=>a._OrtRun,ne=>a._OrtRun=ne)),a._OrtRunWithBinding=f(c(a._OrtRunWithBinding,()=>a._OrtRunWithBinding,ne=>a._OrtRunWithBinding=ne)),a._OrtBindInput=c(a._OrtBindInput,()=>a._OrtBindInput,ne=>a._OrtBindInput=ne),a.jsepRegisterBuffer=(ne,oe,pe,xe)=>i.registerBuffer(ne,oe,pe,xe),a.jsepUnregisterBuffers=ne=>{i.unregisterBuffers(ne)},a.jsepGetBuffer=ne=>i.getBuffer(ne),a.jsepCreateDownloader=(ne,oe,pe)=>i.createDownloader(ne,oe,pe)};var g=Object.assign({},a),b="./this.program",w=(i,c)=>{throw c},y=typeof window=="object",_=typeof importScripts=="function",I=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string",$=a.ENVIRONMENT_IS_PTHREAD||!1,x="";function E(i){return a.locateFile?a.locateFile(i,x):x+i}var A,z,R;if(I){var V=(yn(),Ht(gn)),T=(wn(),Ht(bn));x=_?T.dirname(x)+"/":__dirname+"/",A=(c,f)=>(c=At(c)?new URL(c):T.normalize(c),V.readFileSync(c,f?void 0:"utf8")),R=c=>(c=A(c,!0),c.buffer||(c=new Uint8Array(c)),c),z=(c,f,S,O=!0)=>{c=At(c)?new URL(c):T.normalize(c),V.readFile(c,O?void 0:"utf8",(D,W)=>{D?S(D):f(O?W.buffer:W)})},!a.thisProgram&&1<process.argv.length&&(b=process.argv[1].replace(/\\\\/g,"/")),process.argv.slice(2),w=(c,f)=>{throw process.exitCode=c,f},a.inspect=()=>"[Emscripten Module object]";let i;try{i=Ao()}catch(c){throw console.error(\'The "worker_threads" module is not supported in this node.js build - perhaps a newer version is needed?\'),c}global.Worker=i.Worker}else(y||_)&&(_?x=self.location.href:typeof document<"u"&&document.currentScript&&(x=document.currentScript.src),typeof e<"u"&&e&&(x=e),x.indexOf("blob:")!==0?x=x.substr(0,x.replace(/[?#].*/,"").lastIndexOf("/")+1):x="",I||(A=i=>{var c=new XMLHttpRequest;return c.open("GET",i,!1),c.send(null),c.responseText},_&&(R=i=>{var c=new XMLHttpRequest;return c.open("GET",i,!1),c.responseType="arraybuffer",c.send(null),new Uint8Array(c.response)}),z=(i,c,f)=>{var S=new XMLHttpRequest;S.open("GET",i,!0),S.responseType="arraybuffer",S.onload=()=>{S.status==200||S.status==0&&S.response?c(S.response):f()},S.onerror=f,S.send(null)}));I&&typeof performance>"u"&&(global.performance=To().performance);var N=console.log.bind(console),te=console.error.bind(console);I&&(N=(...i)=>V.writeSync(1,i.join(" ")+`\n`),te=(...i)=>V.writeSync(2,i.join(" ")+`\n`));var Y=N,K=te;Object.assign(a,g),g=null,typeof WebAssembly!="object"&&rt("no native wasm support detected");var Q,Z,Ee=!1,Pe,fe,Ie,he,ye,We,De;function Ge(){var i=Q.buffer;a.HEAP8=fe=new Int8Array(i),a.HEAP16=new Int16Array(i),a.HEAPU8=Ie=new Uint8Array(i),a.HEAPU16=new Uint16Array(i),a.HEAP32=he=new Int32Array(i),a.HEAPU32=ye=new Uint32Array(i),a.HEAPF32=We=new Float32Array(i),a.HEAPF64=De=new Float64Array(i)}var G=16777216;if($)Q=a.wasmMemory;else if(a.wasmMemory)Q=a.wasmMemory;else if(Q=new WebAssembly.Memory({initial:G/65536,maximum:65536,shared:!0}),!(Q.buffer instanceof SharedArrayBuffer))throw K("requested a shared WebAssembly.Memory but the returned buffer is not a SharedArrayBuffer, indicating that while the browser has SharedArrayBuffer it does not have WebAssembly threads support - you may need to set a flag"),I&&K("(on node you may need: --experimental-wasm-threads --experimental-wasm-bulk-memory and/or recent version)"),Error("bad memory");Ge(),G=Q.buffer.byteLength;var ee=[],be=[],et=[],ze=0,Ue=null,Me=null;function wt(){if(ze--,ze==0&&(Ue!==null&&(clearInterval(Ue),Ue=null),Me)){var i=Me;Me=null,i()}}function rt(i){throw i="Aborted("+i+")",K(i),Ee=!0,Pe=1,i=new WebAssembly.RuntimeError(i+". Build with -sASSERTIONS for more info."),h(i),i}var Dt=i=>i.startsWith("data:application/octet-stream;base64,"),At=i=>i.startsWith("file://"),vt;vt="ort-wasm-simd-threaded.wasm",Dt(vt)||(vt=E(vt));function qe(i){if(R)return R(i);throw"both async and sync fetching of the wasm failed"}function qt(i){if(y||_){if(typeof fetch=="function"&&!At(i))return fetch(i,{credentials:"same-origin"}).then(c=>{if(!c.ok)throw"failed to load wasm binary file at \'"+i+"\'";return c.arrayBuffer()}).catch(()=>qe(i));if(z)return new Promise((c,f)=>{z(i,S=>c(new Uint8Array(S)),f)})}return Promise.resolve().then(()=>qe(i))}function Mt(i,c,f){return qt(i).then(S=>WebAssembly.instantiate(S,c)).then(S=>S).then(f,S=>{K(`failed to asynchronously prepare wasm: ${S}`),rt(S)})}function $t(i,c){var f=vt;return typeof WebAssembly.instantiateStreaming!="function"||Dt(f)||At(f)||I||typeof fetch!="function"?Mt(f,i,c):fetch(f,{credentials:"same-origin"}).then(S=>WebAssembly.instantiateStreaming(S,i).then(c,function(O){return K(`wasm streaming compile failed: ${O}`),K("falling back to ArrayBuffer instantiation"),Mt(f,i,c)}))}var yt,zt={932428:(i,c,f,S)=>{if(typeof a>"u"||!a.cb)return 1;if(i=Ye(i>>>0),i.startsWith("./")&&(i=i.substring(2)),i=a.cb.get(i),!i)return 2;if(c>>>=0,f>>>=0,S>>>=0,c+f>i.byteLength)return 3;try{return o().set(i.subarray(c,c+f),S>>>0),0}catch{return 4}},932929:i=>a.wb(i),932962:i=>a.yb(i),932994:(i,c,f)=>{a.kb(i,c,f,!0)},933033:(i,c,f)=>{a.kb(i,c,f)},933066:i=>{a.Ea("Abs",i,void 0)},933117:i=>{a.Ea("Neg",i,void 0)},933168:i=>{a.Ea("Floor",i,void 0)},933221:i=>{a.Ea("Ceil",i,void 0)},933273:i=>{a.Ea("Reciprocal",i,void 0)},933331:i=>{a.Ea("Sqrt",i,void 0)},933383:i=>{a.Ea("Exp",i,void 0)},933434:i=>{a.Ea("Erf",i,void 0)},933485:i=>{a.Ea("Sigmoid",i,void 0)},933540:i=>{a.Ea("Log",i,void 0)},933591:i=>{a.Ea("Sin",i,void 0)},933642:i=>{a.Ea("Cos",i,void 0)},933693:i=>{a.Ea("Tan",i,void 0)},933744:i=>{a.Ea("Asin",i,void 0)},933796:i=>{a.Ea("Acos",i,void 0)},933848:i=>{a.Ea("Atan",i,void 0)},933900:i=>{a.Ea("Sinh",i,void 0)},933952:i=>{a.Ea("Cosh",i,void 0)},934004:i=>{a.Ea("Asinh",i,void 0)},934057:i=>{a.Ea("Acosh",i,void 0)},934110:i=>{a.Ea("Atanh",i,void 0)},934163:i=>{a.Ea("Tanh",i,void 0)},934215:i=>{a.Ea("Not",i,void 0)},934266:(i,c,f)=>{a.Ea("Clip",i,{min:c,max:f})},934335:i=>{a.Ea("Clip",i,void 0)},934387:(i,c)=>{a.Ea("Elu",i,{alpha:c})},934445:i=>{a.Ea("Relu",i,void 0)},934497:(i,c)=>{a.Ea("LeakyRelu",i,{alpha:c})},934561:(i,c)=>{a.Ea("ThresholdedRelu",i,{alpha:c})},934631:(i,c)=>{a.Ea("Cast",i,{to:c})},934689:i=>{a.Ea("Add",i,void 0)},934740:i=>{a.Ea("Sub",i,void 0)},934791:i=>{a.Ea("Mul",i,void 0)},934842:i=>{a.Ea("Div",i,void 0)},934893:i=>{a.Ea("Pow",i,void 0)},934944:i=>{a.Ea("Equal",i,void 0)},934997:i=>{a.Ea("Greater",i,void 0)},935052:i=>{a.Ea("GreaterOrEqual",i,void 0)},935114:i=>{a.Ea("Less",i,void 0)},935166:i=>{a.Ea("LessOrEqual",i,void 0)},935225:(i,c,f,S,O)=>{a.Ea("ReduceMean",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},935384:(i,c,f,S,O)=>{a.Ea("ReduceMax",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},935542:(i,c,f,S,O)=>{a.Ea("ReduceMin",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},935700:(i,c,f,S,O)=>{a.Ea("ReduceProd",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},935859:(i,c,f,S,O)=>{a.Ea("ReduceSum",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},936017:(i,c,f,S,O)=>{a.Ea("ReduceL1",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},936174:(i,c,f,S,O)=>{a.Ea("ReduceL2",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},936331:(i,c,f,S,O)=>{a.Ea("ReduceLogSum",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},936492:(i,c,f,S,O)=>{a.Ea("ReduceSumSquare",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},936656:(i,c,f,S,O)=>{a.Ea("ReduceLogSumExp",i,{keepDims:!!c,noopWithEmptyAxes:!!f,axes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},936820:i=>{a.Ea("Where",i,void 0)},936873:(i,c,f)=>{a.Ea("Transpose",i,{perm:c?Array.from(n().subarray(c>>>0,f>>>0)):[]})},936981:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me)=>{a.Ea("ConvTranspose",i,{format:ne?"NHWC":"NCHW",autoPad:c,dilations:[f],group:S,kernel_shape:[O],pads:[D,W],strides:[ie],wIsConst:()=>!!r()[oe>>>0],outputPadding:pe?Array.from(n().subarray(pe>>>0,xe>>>0)):[],outputShape:Te?Array.from(n().subarray(Te>>>0,k>>>0)):[],activation:Ye(me)})},937383:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k)=>{a.Ea("ConvTranspose",i,{format:ie?"NHWC":"NCHW",autoPad:c,dilations:Array.from(n().subarray(f>>>0,(f>>>0)+2>>>0)),group:S,kernelShape:Array.from(n().subarray(O>>>0,(O>>>0)+2>>>0)),pads:Array.from(n().subarray(D>>>0,(D>>>0)+4>>>0)),strides:Array.from(n().subarray(W>>>0,(W>>>0)+2>>>0)),wIsConst:()=>!!r()[ne>>>0],outputPadding:oe?Array.from(n().subarray(oe>>>0,pe>>>0)):[],outputShape:xe?Array.from(n().subarray(xe>>>0,Te>>>0)):[],activation:Ye(k)})},937948:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me)=>{a.Ea("ConvTranspose",i,{format:ne?"NHWC":"NCHW",autoPad:c,dilations:[f],group:S,kernel_shape:[O],pads:[D,W],strides:[ie],wIsConst:()=>!!r()[oe>>>0],outputPadding:pe?Array.from(n().subarray(pe>>>0,xe>>>0)):[],outputShape:Te?Array.from(n().subarray(Te>>>0,k>>>0)):[],activation:Ye(me)})},938350:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k)=>{a.Ea("ConvTranspose",i,{format:ie?"NHWC":"NCHW",autoPad:c,dilations:Array.from(n().subarray(f>>>0,(f>>>0)+2>>>0)),group:S,kernelShape:Array.from(n().subarray(O>>>0,(O>>>0)+2>>>0)),pads:Array.from(n().subarray(D>>>0,(D>>>0)+4>>>0)),strides:Array.from(n().subarray(W>>>0,(W>>>0)+2>>>0)),wIsConst:()=>!!r()[ne>>>0],outputPadding:oe?Array.from(n().subarray(oe>>>0,pe>>>0)):[],outputShape:xe?Array.from(n().subarray(xe>>>0,Te>>>0)):[],activation:Ye(k)})},938915:(i,c)=>{a.Ea("GlobalAveragePool",i,{format:c?"NHWC":"NCHW"})},939006:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me,Ce)=>{a.Ea("AveragePool",i,{format:Ce?"NHWC":"NCHW",auto_pad:c,ceil_mode:f,count_include_pad:S,storage_order:O,dilations:[D,W],kernel_shape:[ie,ne],pads:[oe,pe,xe,Te],strides:[k,me]})},939290:(i,c)=>{a.Ea("GlobalAveragePool",i,{format:c?"NHWC":"NCHW"})},939381:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me,Ce)=>{a.Ea("AveragePool",i,{format:Ce?"NHWC":"NCHW",auto_pad:c,ceil_mode:f,count_include_pad:S,storage_order:O,dilations:[D,W],kernel_shape:[ie,ne],pads:[oe,pe,xe,Te],strides:[k,me]})},939665:(i,c)=>{a.Ea("GlobalMaxPool",i,{format:c?"NHWC":"NCHW"})},939752:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me,Ce)=>{a.Ea("MaxPool",i,{format:Ce?"NHWC":"NCHW",auto_pad:c,ceil_mode:f,count_include_pad:S,storage_order:O,dilations:[D,W],kernel_shape:[ie,ne],pads:[oe,pe,xe,Te],strides:[k,me]})},940032:(i,c)=>{a.Ea("GlobalMaxPool",i,{format:c?"NHWC":"NCHW"})},940119:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me,Ce)=>{a.Ea("MaxPool",i,{format:Ce?"NHWC":"NCHW",auto_pad:c,ceil_mode:f,count_include_pad:S,storage_order:O,dilations:[D,W],kernel_shape:[ie,ne],pads:[oe,pe,xe,Te],strides:[k,me]})},940399:(i,c,f,S,O)=>{a.Ea("Gemm",i,{alpha:c,beta:f,transA:S,transB:O})},940503:i=>{a.Ea("MatMul",i,void 0)},940557:(i,c,f,S)=>{a.Ea("ArgMax",i,{keepDims:!!c,selectLastIndex:!!f,axis:S})},940665:(i,c,f,S)=>{a.Ea("ArgMin",i,{keepDims:!!c,selectLastIndex:!!f,axis:S})},940773:(i,c)=>{a.Ea("Softmax",i,{axis:c})},940836:(i,c)=>{a.Ea("Concat",i,{axis:c})},940896:(i,c,f,S,O)=>{a.Ea("Split",i,{axis:c,numOutputs:f,splitSizes:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},941036:i=>{a.Ea("Expand",i,void 0)},941090:(i,c)=>{a.Ea("Gather",i,{axis:Number(c)})},941161:(i,c)=>{a.Ea("GatherElements",i,{axis:Number(c)})},941240:(i,c,f,S,O,D,W,ie,ne,oe,pe)=>{a.Ea("Resize",i,{antialias:c,axes:f?Array.from(n().subarray(f>>>0,S>>>0)):[],coordinateTransformMode:Ye(O),cubicCoeffA:D,excludeOutside:W,extrapolationValue:ie,keepAspectRatioPolicy:Ye(ne),mode:Ye(oe),nearestMode:Ye(pe)})},941586:(i,c,f,S,O,D,W)=>{a.Ea("Slice",i,{starts:c?Array.from(n().subarray(c>>>0,f>>>0)):[],ends:S?Array.from(n().subarray(S>>>0,O>>>0)):[],axes:D?Array.from(n().subarray(D>>>0,W>>>0)):[]})},941802:i=>{a.Ea("Tile",i,void 0)},941854:(i,c,f)=>{a.Ea("LayerNormalization",i,{axis:Number(c),epsilon:Number(f)})},941961:(i,c,f)=>{a.Ea("InstanceNormalization",i,{epsilon:c,format:f?"NHWC":"NCHW"})},942075:(i,c,f)=>{a.Ea("InstanceNormalization",i,{epsilon:c,format:f?"NHWC":"NCHW"})},942189:i=>{a.Ea("Range",i,void 0)},942242:(i,c)=>{a.Ea("Einsum",i,{equation:Ye(c)})},942323:(i,c,f,S,O)=>{a.Ea("Pad",i,{mode:c,value:f,pads:S?Array.from(n().subarray(S>>>0,O>>>0)):[]})},942450:(i,c,f,S,O,D)=>{a.Ea("BatchNormalization",i,{epsilon:c,momentum:f,spatial:!!O,trainingMode:!!S,format:D?"NHWC":"NCHW"})},942619:(i,c,f,S,O,D)=>{a.Ea("BatchNormalization",i,{epsilon:c,momentum:f,spatial:!!O,trainingMode:!!S,format:D?"NHWC":"NCHW"})},942788:(i,c,f)=>{a.Ea("CumSum",i,{exclusive:Number(c),reverse:Number(f)})},942885:(i,c,f,S,O,D,W,ie,ne)=>{a.Ea("Attention",i,{numHeads:c,isUnidirectional:f,maskFilterValue:S,scale:O,doRotary:D,qkvHiddenSizes:W?Array.from(n().subarray(Number(ie)>>>0,Number(ie)+W>>>0)):[],pastPresentShareBuffer:!!ne})},943157:i=>{a.Ea("Gelu",i,void 0)},943209:(i,c,f,S,O,D)=>{a.Ea("MultiHeadAttention",i,{numHeads:c,isUnidirectional:f,maskFilterValue:S,scale:O,doRotary:D})},943368:i=>{a.Ea("BiasAdd",i,void 0)},943423:i=>{a.Ea("BiasSplitGelu",i,void 0)},943484:(i,c)=>{a.Ea("SkipLayerNormalization",i,{epsilon:c})},943565:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te)=>{a.Ea("Conv",i,{format:ne?"NHWC":"NCHW",auto_pad:c,dilations:[f],group:S,kernel_shape:[O],pads:D?Array.from(n().subarray(D>>>0,W>>>0)):[],strides:[ie],w_is_const:()=>!!r()[oe>>>0],activation:Ye(pe),activation_params:xe?Array.from(u().subarray(xe>>>0,Te>>>0)):[]})},943935:(i,c,f,S,O,D,W,ie,ne,oe,pe,xe,Te,k,me,Ce)=>{a.Ea("Conv",i,{format:xe?"NHWC":"NCHW",auto_pad:c,dilations:[f,S],group:O,kernel_shape:[D,W],pads:ie?Array.from(n().subarray(ie>>>0,ne>>>0)):[],strides:[oe,pe],w_is_const:()=>!!r()[Te>>>0],activation:Ye(k),activation_params:me?Array.from(u().subarray(me>>>0,Ce>>>0)):[]})},944326:i=>{a.zb(i)},944360:(i,c)=>a.Ab(i,c,a.bb.Cb,a.bb.errors)};function Ut(i){this.name="ExitStatus",this.message=`Program terminated with exit(${i})`,this.status=i}var Tt=i=>{i.terminate(),i.onmessage=()=>{}},Kt=i=>{de.Ya.length==0&&(ot(),de.lb(de.Ya[0]));var c=de.Ya.pop();if(!c)return 6;de.Za.push(c),de.Qa[i.Xa]=c,c.Xa=i.Xa;var f={cmd:"run",start_routine:i.Db,arg:i.tb,pthread_ptr:i.Xa};return I&&c.unref(),c.postMessage(f,i.Jb),0},nt=0,Yt=typeof TextDecoder<"u"?new TextDecoder("utf8"):void 0,Vt=(i,c,f)=>{c>>>=0;var S=c+f;for(f=c;i[f]&&!(f>=S);)++f;if(16<f-c&&i.buffer&&Yt)return Yt.decode(i.buffer instanceof SharedArrayBuffer?i.slice(c,f):i.subarray(c,f));for(S="";c<f;){var O=i[c++];if(O&128){var D=i[c++]&63;if((O&224)==192)S+=String.fromCharCode((O&31)<<6|D);else{var W=i[c++]&63;O=(O&240)==224?(O&15)<<12|D<<6|W:(O&7)<<18|D<<12|W<<6|i[c++]&63,65536>O?S+=String.fromCharCode(O):(O-=65536,S+=String.fromCharCode(55296|O>>10,56320|O&1023))}}else S+=String.fromCharCode(O)}return S},Ye=(i,c)=>(i>>>=0)?Vt(o(),i,c):"",br=i=>{var c=mn();return i=i(),kr(c),i};function Oe(i,c){var f=arguments.length-2,S=arguments;return br(()=>{for(var O=fn(8*f),D=O>>>3,W=0;W<f;W++){var ie=S[2+W];l()[D+W>>>0]=ie}return po(i,f,O,c)})}function wr(i){if($)return Oe(0,1,i);Pe=i,0<nt||(de.Eb(),a.onExit?.(i),Ee=!0),w(i,new Ut(i))}var Nt=i=>{if(Pe=i,$)throw Zt(i),"unwind";wr(i)},St=i=>{i instanceof Ut||i=="unwind"||w(1,i)};function un(){for(var i=a.numThreads;i--;)ot();ee.unshift(()=>{ze++,tt(()=>wt())})}function ot(){var i=E("ort-wasm-simd-threaded.worker.js");i=new Worker(i),de.Ya.push(i)}function tt(i){$?i():Promise.all(de.Ya.map(de.lb)).then(i)}var de={Ya:[],Za:[],pb:[],Qa:{},hb(){$?(de.receiveObjectTransfer=de.Bb,de.threadInitTLS=de.ob,de.setExitStatus=de.nb):un()},nb:i=>Pe=i,Nb:["$terminateWorker"],Eb:()=>{for(var i of de.Za)Tt(i);for(i of de.Ya)Tt(i);de.Ya=[],de.Za=[],de.Qa=[]},mb:i=>{var c=i.Xa;delete de.Qa[c],de.Ya.push(i),de.Za.splice(de.Za.indexOf(i),1),i.Xa=0,cn(c)},Bb(){},ob(){de.pb.forEach(i=>i())},lb:i=>new Promise(c=>{i.onmessage=D=>{D=D.data;var W=D.cmd;if(D.targetThread&&D.targetThread!=Pr()){var ie=de.Qa[D.targetThread];ie?ie.postMessage(D,D.transferList):K(`Internal error! Worker sent a message "${W}" to target pthread ${D.targetThread}, but that thread no longer exists!`)}else W==="checkMailbox"?Et():W==="spawnThread"?Kt(D):W==="cleanupThread"?de.mb(de.Qa[D.thread]):W==="killThread"?(D=D.thread,W=de.Qa[D],delete de.Qa[D],Tt(W),cn(D),de.Za.splice(de.Za.indexOf(W),1),W.Xa=0):W==="cancelThread"?de.Qa[D.thread].postMessage({cmd:"cancel"}):W==="loaded"?(i.loaded=!0,I&&!i.Xa&&i.unref(),c(i)):W==="alert"?alert(`Thread ${D.threadId}: ${D.text}`):D.target==="setimmediate"?i.postMessage(D):W==="callHandler"?a[D.handler](...D.args):W&&K(`worker sent an unknown command ${W}`)},i.onerror=D=>{throw K(`worker sent an error! ${D.filename}:${D.lineno}: ${D.message}`),D},I&&(i.on("message",D=>i.onmessage({data:D})),i.on("error",D=>i.onerror(D)));var f=[],S=["onExit"],O;for(O of S)a.hasOwnProperty(O)&&f.push(O);i.postMessage({cmd:"load",handlers:f,urlOrBlob:a.mainScriptUrlOrBlob||e,wasmMemory:Q,wasmModule:Z})})};a.PThread=de;var bt=i=>{for(;0<i.length;)i.shift()(a)};a.establishStackSpace=()=>{var i=Pr(),c=s()[i+52>>>2>>>0];i=s()[i+56>>>2>>>0],ho(c,c-i),kr(c)};function Zt(i){if($)return Oe(1,0,i);Nt(i)}a.invokeEntryPoint=(i,c)=>{i=go.apply(null,[i,c]),0<nt?de.nb(i):pn(i)};function vr(i){this.gb=i-24,this.sb=function(c){s()[this.gb+4>>>2>>>0]=c},this.rb=function(c){s()[this.gb+8>>>2>>>0]=c},this.hb=function(c,f){this.qb(),this.sb(c),this.rb(f)},this.qb=function(){s()[this.gb+16>>>2>>>0]=0}}var $r=0,Qt=0;function Sr(i,c,f,S){return $?Oe(2,1,i,c,f,S):xr(i,c,f,S)}function xr(i,c,f,S){if(i>>>=0,c>>>=0,f>>>=0,S>>>=0,typeof SharedArrayBuffer>"u")return K("Current environment does not support SharedArrayBuffer, pthreads are not available!"),6;var O=[];return $&&O.length===0?Sr(i,c,f,S):(i={Db:f,Xa:i,tb:S,Jb:O},$?(i.Lb="spawnThread",postMessage(i,O),0):Kt(i))}function _r(i,c,f){return $?Oe(3,1,i,c,f):0}function Cr(i,c){if($)return Oe(4,1,i,c)}var Xt=i=>{for(var c=0,f=0;f<i.length;++f){var S=i.charCodeAt(f);127>=S?c++:2047>=S?c+=2:55296<=S&&57343>=S?(c+=4,++f):c+=3}return c},Ir=(i,c,f,S)=>{if(f>>>=0,!(0<S))return 0;var O=f;S=f+S-1;for(var D=0;D<i.length;++D){var W=i.charCodeAt(D);if(55296<=W&&57343>=W){var ie=i.charCodeAt(++D);W=65536+((W&1023)<<10)|ie&1023}if(127>=W){if(f>=S)break;c[f++>>>0]=W}else{if(2047>=W){if(f+1>=S)break;c[f++>>>0]=192|W>>6}else{if(65535>=W){if(f+2>=S)break;c[f++>>>0]=224|W>>12}else{if(f+3>=S)break;c[f++>>>0]=240|W>>18,c[f++>>>0]=128|W>>12&63}c[f++>>>0]=128|W>>6&63}c[f++>>>0]=128|W&63}}return c[f>>>0]=0,f-O},ae=(i,c,f)=>Ir(i,o(),c,f);function Jt(i,c){if($)return Oe(5,1,i,c)}function Wt(i,c,f){if($)return Oe(6,1,i,c,f)}function er(i,c,f){return $?Oe(7,1,i,c,f):0}function tr(i,c){if($)return Oe(8,1,i,c)}function rr(i,c,f){if($)return Oe(9,1,i,c,f)}function nr(i,c,f,S){if($)return Oe(10,1,i,c,f,S)}function or(i,c,f,S){if($)return Oe(11,1,i,c,f,S)}function ar(i,c,f,S){if($)return Oe(12,1,i,c,f,S)}function ir(i){if($)return Oe(13,1,i)}function sr(i,c){if($)return Oe(14,1,i,c)}function ur(i,c,f){if($)return Oe(15,1,i,c,f)}var Ar=()=>{if(!(0<nt))try{$?pn(Pe):Nt(Pe)}catch(i){St(i)}};function xt(i){i>>>=0,typeof Atomics.Kb=="function"&&(Atomics.Kb(n(),i>>>2,i).value.then(Et),i+=128,Atomics.store(n(),i>>>2,1))}a.__emscripten_thread_mailbox_await=xt;var Et=()=>{var i=Pr();if(i&&(xt(i),!Ee))try{mo(),Ar()}catch(c){St(c)}};a.checkMailbox=Et;var d=[],m=i=>i%4===0&&(i%100!==0||i%400===0),v=[0,31,60,91,121,152,182,213,244,274,305,335],C=[0,31,59,90,120,151,181,212,243,273,304,334];function B(i,c,f,S,O,D,W,ie){return $?Oe(16,1,i,c,f,S,O,D,W,ie):-52}function H(i,c,f,S,O,D,W){if($)return Oe(17,1,i,c,f,S,O,D,W)}var q=i=>{var c=Xt(i)+1,f=ln(c);return f&&ae(i,f,c),f},le=[],J=(i,c)=>{le.length=0;for(var f;f=o()[i++>>>0];){var S=f!=105;S&=f!=112,c+=S&&c%8?4:0,le.push(f==112?s()[c>>>2>>>0]:f==105?n()[c>>>2>>>0]:l()[c>>>3>>>0]),c+=S?8:4}return le},re={},se=()=>{if(!we){var i={USER:"web_user",LOGNAME:"web_user",PATH:"/",PWD:"/",HOME:"/home/web_user",LANG:(typeof navigator=="object"&&navigator.languages&&navigator.languages[0]||"C").replace("-","_")+".UTF-8",_:b||"./this.program"},c;for(c in re)re[c]===void 0?delete i[c]:i[c]=re[c];var f=[];for(c in i)f.push(`${c}=${i[c]}`);we=f}return we},we;function _e(i,c){if($)return Oe(18,1,i,c);i>>>=0,c>>>=0;var f=0;return se().forEach((S,O)=>{var D=c+f;for(O=s()[i+4*O>>>2>>>0]=D,D=0;D<S.length;++D)r()[O++>>>0>>>0]=S.charCodeAt(D);r()[O>>>0>>>0]=0,f+=S.length+1}),0}function P(i,c){if($)return Oe(19,1,i,c);i>>>=0,c>>>=0;var f=se();s()[i>>>2>>>0]=f.length;var S=0;return f.forEach(O=>S+=O.length+1),s()[c>>>2>>>0]=S,0}function ue(i){return $?Oe(20,1,i):52}function Se(i,c,f,S){return $?Oe(21,1,i,c,f,S):52}function st(i,c,f,S,O){return $?Oe(22,1,i,c,f,S,O):70}var Tr=[null,[],[]];function to(i,c,f,S){if($)return Oe(23,1,i,c,f,S);c>>>=0,f>>>=0,S>>>=0;for(var O=0,D=0;D<f;D++){var W=s()[c>>>2>>>0],ie=s()[c+4>>>2>>>0];c+=8;for(var ne=0;ne<ie;ne++){var oe=o()[W+ne>>>0],pe=Tr[i];oe===0||oe===10?((i===1?Y:K)(Vt(pe,0)),pe.length=0):pe.push(oe)}O+=ie}return s()[S>>>2>>>0]=O,0}var ro=[31,29,31,30,31,30,31,31,30,31,30,31],no=[31,28,31,30,31,30,31,31,30,31,30,31];function Pu(i){var c=Array(Xt(i)+1);return Ir(i,c,0,c.length),c}var ku=(i,c)=>{r().set(i,c>>>0)};function oo(i,c,f,S){function O(k,me,Ce){for(k=typeof k=="number"?k.toString():k||"";k.length<me;)k=Ce[0]+k;return k}function D(k,me){return O(k,me,"0")}function W(k,me){function Ce(So){return 0>So?-1:0<So?1:0}var Ot;return(Ot=Ce(k.getFullYear()-me.getFullYear()))===0&&(Ot=Ce(k.getMonth()-me.getMonth()))===0&&(Ot=Ce(k.getDate()-me.getDate())),Ot}function ie(k){switch(k.getDay()){case 0:return new Date(k.getFullYear()-1,11,29);case 1:return k;case 2:return new Date(k.getFullYear(),0,3);case 3:return new Date(k.getFullYear(),0,2);case 4:return new Date(k.getFullYear(),0,1);case 5:return new Date(k.getFullYear()-1,11,31);case 6:return new Date(k.getFullYear()-1,11,30)}}function ne(k){var me=k.$a;for(k=new Date(new Date(k.ab+1900,0,1).getTime());0<me;){var Ce=k.getMonth(),Ot=(m(k.getFullYear())?ro:no)[Ce];if(me>Ot-k.getDate())me-=Ot-k.getDate()+1,k.setDate(1),11>Ce?k.setMonth(Ce+1):(k.setMonth(0),k.setFullYear(k.getFullYear()+1));else{k.setDate(k.getDate()+me);break}}return Ce=new Date(k.getFullYear()+1,0,4),me=ie(new Date(k.getFullYear(),0,4)),Ce=ie(Ce),0>=W(me,k)?0>=W(Ce,k)?k.getFullYear()+1:k.getFullYear():k.getFullYear()-1}i>>>=0,c>>>=0,f>>>=0,S>>>=0;var oe=s()[S+40>>>2>>>0];S={Hb:n()[S>>>2>>>0],Gb:n()[S+4>>>2>>>0],eb:n()[S+8>>>2>>>0],jb:n()[S+12>>>2>>>0],fb:n()[S+16>>>2>>>0],ab:n()[S+20>>>2>>>0],Wa:n()[S+24>>>2>>>0],$a:n()[S+28>>>2>>>0],Ob:n()[S+32>>>2>>>0],Fb:n()[S+36>>>2>>>0],Ib:oe?Ye(oe):""},f=Ye(f),oe={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S","%Ec":"%c","%EC":"%C","%Ex":"%m/%d/%y","%EX":"%H:%M:%S","%Ey":"%y","%EY":"%Y","%Od":"%d","%Oe":"%e","%OH":"%H","%OI":"%I","%Om":"%m","%OM":"%M","%OS":"%S","%Ou":"%u","%OU":"%U","%OV":"%V","%Ow":"%w","%OW":"%W","%Oy":"%y"};for(var pe in oe)f=f.replace(new RegExp(pe,"g"),oe[pe]);var xe="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),Te="January February March April May June July August September October November December".split(" ");oe={"%a":k=>xe[k.Wa].substring(0,3),"%A":k=>xe[k.Wa],"%b":k=>Te[k.fb].substring(0,3),"%B":k=>Te[k.fb],"%C":k=>D((k.ab+1900)/100|0,2),"%d":k=>D(k.jb,2),"%e":k=>O(k.jb,2," "),"%g":k=>ne(k).toString().substring(2),"%G":k=>ne(k),"%H":k=>D(k.eb,2),"%I":k=>(k=k.eb,k==0?k=12:12<k&&(k-=12),D(k,2)),"%j":k=>{for(var me=0,Ce=0;Ce<=k.fb-1;me+=(m(k.ab+1900)?ro:no)[Ce++]);return D(k.jb+me,3)},"%m":k=>D(k.fb+1,2),"%M":k=>D(k.Gb,2),"%n":()=>`\n`,"%p":k=>0<=k.eb&&12>k.eb?"AM":"PM","%S":k=>D(k.Hb,2),"%t":()=>"	","%u":k=>k.Wa||7,"%U":k=>D(Math.floor((k.$a+7-k.Wa)/7),2),"%V":k=>{var me=Math.floor((k.$a+7-(k.Wa+6)%7)/7);if(2>=(k.Wa+371-k.$a-2)%7&&me++,me)me==53&&(Ce=(k.Wa+371-k.$a)%7,Ce==4||Ce==3&&m(k.ab)||(me=1));else{me=52;var Ce=(k.Wa+7-k.$a-1)%7;(Ce==4||Ce==5&&m(k.ab%400-1))&&me++}return D(me,2)},"%w":k=>k.Wa,"%W":k=>D(Math.floor((k.$a+7-(k.Wa+6)%7)/7),2),"%y":k=>(k.ab+1900).toString().substring(2),"%Y":k=>k.ab+1900,"%z":k=>{k=k.Fb;var me=0<=k;return k=Math.abs(k)/60,(me?"+":"-")+("0000"+(k/60*100+k%60)).slice(-4)},"%Z":k=>k.Ib,"%%":()=>"%"},f=f.replace(/%%/g,"\\0\\0");for(pe in oe)f.includes(pe)&&(f=f.replace(new RegExp(pe,"g"),oe[pe](S)));return f=f.replace(/\\0\\0/g,"%"),pe=Pu(f),pe.length>c?0:(ku(pe,i),pe.length-1)}var Er=i=>{try{i()}catch(c){rt(c)}};function Ru(){var i=X,c={};for(let[f,S]of Object.entries(i))c[f]=typeof S=="function"?function(){Or.push(f);try{return S.apply(null,arguments)}finally{Ee||(Or.pop(),ut&&_t===1&&Or.length===0&&(_t=0,nt+=1,Er(bo),typeof Fibers<"u"&&Fibers.Pb()))}}:S;return c}var _t=0,ut=null,ao=0,Or=[],io={},so={},Bu=0,dn=null,Du=[];function Mu(){return new Promise((i,c)=>{dn={resolve:i,reject:c}})}function zu(){var i=ln(65548),c=i+12;s()[i>>>2>>>0]=c,s()[i+4>>>2>>>0]=c+65536,c=Or[0];var f=io[c];return f===void 0&&(f=Bu++,io[c]=f,so[f]=c),c=f,n()[i+8>>>2>>>0]=c,i}function Uu(){var i=n()[ut+8>>>2>>>0];return i=X[so[i]],--nt,i()}function Vu(i){if(!Ee){if(_t===0){var c=!1,f=!1;i((S=0)=>{if(!Ee&&(ao=S,c=!0,f)){_t=2,Er(()=>wo(ut)),typeof Browser<"u"&&Browser.ib.vb&&Browser.ib.resume(),S=!1;try{var O=Uu()}catch(ie){O=ie,S=!0}var D=!1;if(!ut){var W=dn;W&&(dn=null,(S?W.reject:W.resolve)(O),D=!0)}if(S&&!D)throw O}}),f=!0,c||(_t=1,ut=zu(),typeof Browser<"u"&&Browser.ib.vb&&Browser.ib.pause(),Er(()=>yo(ut)))}else _t===2?(_t=0,Er(vo),lo(ut),ut=null,Du.forEach(S=>{if(!Ee)try{S(),Ar()}catch(O){St(O)}})):rt(`invalid state: ${_t}`);return ao}}function Nu(i){return Vu(c=>{i().then(c)})}de.hb();var Wu=[wr,Zt,Sr,_r,Cr,Jt,Wt,er,tr,rr,nr,or,ar,ir,sr,ur,B,H,_e,P,ue,Se,st,to],Hu={r:function(i,c,f){return Nu(async()=>{await a.xb(i,c,f)})},b:function(i,c,f){throw i>>>=0,new vr(i).hb(c>>>0,f>>>0),$r=i,Qt++,$r},N:function(i){co(i>>>0,!_,1,!y,131072,!1),de.ob()},l:function(i){i>>>=0,$?postMessage({cmd:"cleanupThread",thread:i}):de.mb(de.Qa[i])},J:xr,i:_r,T:Cr,F:Jt,H:Wt,U:er,R:tr,L:rr,Q:nr,p:or,G:ar,D:ir,S:sr,E:ur,q:()=>1,B:function(i,c){i>>>=0,i==c>>>0?setTimeout(()=>Et()):$?postMessage({targetThread:i,cmd:"checkMailbox"}):(i=de.Qa[i])&&i.postMessage({cmd:"checkMailbox"})},K:function(i,c,f,S){c>>>=0,d.length=f,S=S>>>0>>>3;for(var O=0;O<f;O++)d[O]=l()[S+O>>>0];return i=0>i?zt[-i-1]:Wu[i],de.ub=c,c=i.apply(null,d),de.ub=0,c},M:xt,W:function(i){I&&de.Qa[i>>>0].ref()},u:function(i,c,f){i=c+2097152>>>0<4194305-!!i?(i>>>0)+4294967296*c:NaN,f>>>=0,i=new Date(1e3*i),n()[f>>>2>>>0]=i.getUTCSeconds(),n()[f+4>>>2>>>0]=i.getUTCMinutes(),n()[f+8>>>2>>>0]=i.getUTCHours(),n()[f+12>>>2>>>0]=i.getUTCDate(),n()[f+16>>>2>>>0]=i.getUTCMonth(),n()[f+20>>>2>>>0]=i.getUTCFullYear()-1900,n()[f+24>>>2>>>0]=i.getUTCDay(),i=(i.getTime()-Date.UTC(i.getUTCFullYear(),0,1,0,0,0,0))/864e5|0,n()[f+28>>>2>>>0]=i},v:function(i,c,f){i=c+2097152>>>0<4194305-!!i?(i>>>0)+4294967296*c:NaN,f>>>=0,i=new Date(1e3*i),n()[f>>>2>>>0]=i.getSeconds(),n()[f+4>>>2>>>0]=i.getMinutes(),n()[f+8>>>2>>>0]=i.getHours(),n()[f+12>>>2>>>0]=i.getDate(),n()[f+16>>>2>>>0]=i.getMonth(),n()[f+20>>>2>>>0]=i.getFullYear()-1900,n()[f+24>>>2>>>0]=i.getDay(),c=(m(i.getFullYear())?v:C)[i.getMonth()]+i.getDate()-1|0,n()[f+28>>>2>>>0]=c,n()[f+36>>>2>>>0]=-(60*i.getTimezoneOffset()),c=new Date(i.getFullYear(),6,1).getTimezoneOffset();var S=new Date(i.getFullYear(),0,1).getTimezoneOffset();i=(c!=S&&i.getTimezoneOffset()==Math.min(S,c))|0,n()[f+32>>>2>>>0]=i},w:function(i){i>>>=0;var c=new Date(n()[i+20>>>2>>>0]+1900,n()[i+16>>>2>>>0],n()[i+12>>>2>>>0],n()[i+8>>>2>>>0],n()[i+4>>>2>>>0],n()[i>>>2>>>0],0),f=n()[i+32>>>2>>>0],S=c.getTimezoneOffset(),O=new Date(c.getFullYear(),6,1).getTimezoneOffset(),D=new Date(c.getFullYear(),0,1).getTimezoneOffset(),W=Math.min(D,O);return 0>f?n()[i+32>>>2>>>0]=+(O!=D&&W==S):0<f!=(W==S)&&(O=Math.max(D,O),c.setTime(c.getTime()+6e4*((0<f?W:O)-S))),n()[i+24>>>2>>>0]=c.getDay(),f=(m(c.getFullYear())?v:C)[c.getMonth()]+c.getDate()-1|0,n()[i+28>>>2>>>0]=f,n()[i>>>2>>>0]=c.getSeconds(),n()[i+4>>>2>>>0]=c.getMinutes(),n()[i+8>>>2>>>0]=c.getHours(),n()[i+12>>>2>>>0]=c.getDate(),n()[i+16>>>2>>>0]=c.getMonth(),n()[i+20>>>2>>>0]=c.getYear(),i=c.getTime(),isNaN(i)?(n()[uo()>>>2>>>0]=61,i=-1):i/=1e3,fo((yt=i,1<=+Math.abs(yt)?0<yt?+Math.floor(yt/4294967296)>>>0:~~+Math.ceil((yt-+(~~yt>>>0))/4294967296)>>>0:0)),i>>>0},s:B,t:H,A:function(i,c,f){function S(oe){return(oe=oe.toTimeString().match(/\\(([A-Za-z ]+)\\)$/))?oe[1]:"GMT"}i>>>=0,c>>>=0,f>>>=0;var O=new Date().getFullYear(),D=new Date(O,0,1),W=new Date(O,6,1);O=D.getTimezoneOffset();var ie=W.getTimezoneOffset(),ne=Math.max(O,ie);s()[i>>>2>>>0]=60*ne,n()[c>>>2>>>0]=+(O!=ie),i=S(D),c=S(W),i=q(i),c=q(c),ie<O?(s()[f>>>2>>>0]=i,s()[f+4>>>2>>>0]=c):(s()[f>>>2>>>0]=c,s()[f+4>>>2>>>0]=i)},d:()=>{rt("")},c:function(i,c,f){return i>>>=0,c=J(c>>>0,f>>>0),zt[i].apply(null,c)},k:function(i,c,f){return i>>>=0,c=J(c>>>0,f>>>0),zt[i].apply(null,c)},m:()=>{},j:()=>Date.now(),V:()=>{throw nt+=1,"unwind"},C:function(){return 4294901760},f:()=>performance.timeOrigin+performance.now(),g:()=>I?(Oo(),Ht(Eo)).cpus().length:navigator.hardwareConcurrency,y:function(i){i>>>=0;var c=o().length;if(i<=c||4294901760<i)return!1;for(var f=1;4>=f;f*=2){var S=c*(1+.2/f);S=Math.min(S,i+100663296);var O=Math;S=Math.max(i,S);e:{O=(O.min.call(O,4294901760,S+(65536-S%65536)%65536)-Q.buffer.byteLength+65535)/65536;try{Q.grow(O),Ge();var D=1;break e}catch{}D=void 0}if(D)return!0}return!1},O:_e,P,I:Nt,h:ue,o:Se,x:st,n:to,a:Q||a.wasmMemory,z:oo,e:function(i,c,f,S){return oo(i>>>0,c>>>0,f>>>0,S>>>0)}},X=function(){function i(f,S){return X=f.exports,X=Ru(),X=Gu(),de.pb.push(X.Da),be.unshift(X.X),Z=S,wt(),X}var c={a:Hu};if(ze++,a.instantiateWasm)try{return a.instantiateWasm(c,i)}catch(f){K(`Module.instantiateWasm callback failed with error: ${f}`),h(f)}return $t(c,function(f){i(f.instance,f.module)}).catch(h),{}}();a._OrtInit=(i,c)=>(a._OrtInit=X.Y)(i,c),a._OrtGetLastError=(i,c)=>(a._OrtGetLastError=X.Z)(i,c),a._OrtCreateSessionOptions=(i,c,f,S,O,D,W,ie,ne,oe)=>(a._OrtCreateSessionOptions=X._)(i,c,f,S,O,D,W,ie,ne,oe),a._OrtAppendExecutionProvider=(i,c)=>(a._OrtAppendExecutionProvider=X.$)(i,c),a._OrtAddFreeDimensionOverride=(i,c,f)=>(a._OrtAddFreeDimensionOverride=X.aa)(i,c,f),a._OrtAddSessionConfigEntry=(i,c,f)=>(a._OrtAddSessionConfigEntry=X.ba)(i,c,f),a._OrtReleaseSessionOptions=i=>(a._OrtReleaseSessionOptions=X.ca)(i),a._OrtCreateSession=(i,c,f)=>(a._OrtCreateSession=X.da)(i,c,f),a._OrtReleaseSession=i=>(a._OrtReleaseSession=X.ea)(i),a._OrtGetInputOutputCount=(i,c,f)=>(a._OrtGetInputOutputCount=X.fa)(i,c,f),a._OrtGetInputName=(i,c)=>(a._OrtGetInputName=X.ga)(i,c),a._OrtGetOutputName=(i,c)=>(a._OrtGetOutputName=X.ha)(i,c),a._OrtFree=i=>(a._OrtFree=X.ia)(i),a._OrtCreateTensor=(i,c,f,S,O,D)=>(a._OrtCreateTensor=X.ja)(i,c,f,S,O,D),a._OrtGetTensorData=(i,c,f,S,O)=>(a._OrtGetTensorData=X.ka)(i,c,f,S,O),a._OrtReleaseTensor=i=>(a._OrtReleaseTensor=X.la)(i),a._OrtCreateRunOptions=(i,c,f,S)=>(a._OrtCreateRunOptions=X.ma)(i,c,f,S),a._OrtAddRunConfigEntry=(i,c,f)=>(a._OrtAddRunConfigEntry=X.na)(i,c,f),a._OrtReleaseRunOptions=i=>(a._OrtReleaseRunOptions=X.oa)(i),a._OrtCreateBinding=i=>(a._OrtCreateBinding=X.pa)(i),a._OrtBindInput=(i,c,f)=>(a._OrtBindInput=X.qa)(i,c,f),a._OrtBindOutput=(i,c,f,S)=>(a._OrtBindOutput=X.ra)(i,c,f,S),a._OrtClearBoundOutputs=i=>(a._OrtClearBoundOutputs=X.sa)(i),a._OrtReleaseBinding=i=>(a._OrtReleaseBinding=X.ta)(i),a._OrtRunWithBinding=(i,c,f,S,O)=>(a._OrtRunWithBinding=X.ua)(i,c,f,S,O),a._OrtRun=(i,c,f,S,O,D,W,ie)=>(a._OrtRun=X.va)(i,c,f,S,O,D,W,ie),a._OrtEndProfiling=i=>(a._OrtEndProfiling=X.wa)(i),a._JsepOutput=(i,c,f)=>(a._JsepOutput=X.xa)(i,c,f),a._JsepGetNodeName=i=>(a._JsepGetNodeName=X.ya)(i);var uo=()=>(uo=X.za)(),Pr=a._pthread_self=()=>(Pr=a._pthread_self=X.Aa)(),ln=a._malloc=i=>(ln=a._malloc=X.Ba)(i),lo=a._free=i=>(lo=a._free=X.Ca)(i);a.__emscripten_tls_init=()=>(a.__emscripten_tls_init=X.Da)();var co=a.__emscripten_thread_init=(i,c,f,S,O,D)=>(co=a.__emscripten_thread_init=X.Fa)(i,c,f,S,O,D);a.__emscripten_thread_crashed=()=>(a.__emscripten_thread_crashed=X.Ga)();var po=(i,c,f,S)=>(po=X.Ha)(i,c,f,S),cn=i=>(cn=X.Ia)(i),pn=a.__emscripten_thread_exit=i=>(pn=a.__emscripten_thread_exit=X.Ja)(i),mo=()=>(mo=X.Ka)(),fo=i=>(fo=X.La)(i),ho=(i,c)=>(ho=X.Ma)(i,c),mn=()=>(mn=X.Na)(),kr=i=>(kr=X.Oa)(i),fn=i=>(fn=X.Pa)(i),go=a.dynCall_ii=(i,c)=>(go=a.dynCall_ii=X.Ra)(i,c),yo=i=>(yo=X.Sa)(i),bo=()=>(bo=X.Ta)(),wo=i=>(wo=X.Ua)(i),vo=()=>(vo=X.Va)();a.___start_em_js=944472,a.___stop_em_js=944633;function Gu(){var i=X;i=Object.assign({},i);var c=S=>()=>S()>>>0,f=S=>O=>S(O)>>>0;return i.za=c(i.za),i.Aa=c(i.Aa),i.Ba=f(i.Ba),i.emscripten_main_runtime_thread_id=c(i.emscripten_main_runtime_thread_id),i.Na=c(i.Na),i.Pa=f(i.Pa),i}a.wasmMemory=Q,a.stackAlloc=fn,a.stackSave=mn,a.stackRestore=kr,a.keepRuntimeAlive=()=>0<nt,a.UTF8ToString=Ye,a.stringToUTF8=ae,a.lengthBytesUTF8=Xt,a.ExitStatus=Ut,a.PThread=de;var Rr;Me=function i(){Rr||$o(),Rr||(Me=i)};function $o(){if(!(0<ze))if($)p(a),$||bt(be),startWorker(a);else{if(a.preRun)for(typeof a.preRun=="function"&&(a.preRun=[a.preRun]);a.preRun.length;)ee.unshift(a.preRun.shift());bt(ee),0<ze||Rr||(Rr=!0,a.calledRun=!0,Ee||($||bt(be),p(a),$||bt(et)))}}return $o(),t.ready}})();typeof ko=="object"&&typeof $n=="object"?$n.exports=Po:typeof define=="function"&&define.amd&&define([],()=>Po)});var Bo=dr((qc,Xu)=>{Xu.exports=\'"use strict";var Module={},ENVIRONMENT_IS_NODE=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string";if(ENVIRONMENT_IS_NODE){var nodeWorkerThreads=require("worker_threads"),parentPort=nodeWorkerThreads.parentPort;parentPort.on("message",e=>onmessage({data:e}));var fs=require("fs"),vm=require("vm");Object.assign(global,{self:global,require,Module,location:{href:__filename},Worker:nodeWorkerThreads.Worker,importScripts:e=>vm.runInThisContext(fs.readFileSync(e,"utf8"),{filename:e}),postMessage:e=>parentPort.postMessage(e),performance:global.performance||{now:Date.now}})}var initializedJS=!1;function threadPrintErr(){var e=Array.prototype.slice.call(arguments).join(" ");if(ENVIRONMENT_IS_NODE){fs.writeSync(2,e+`\\n`);return}console.error(e)}function threadAlert(){var e=Array.prototype.slice.call(arguments).join(" ");postMessage({cmd:"alert",text:e,threadId:Module._pthread_self()})}var err=threadPrintErr;self.alert=threadAlert,Module.instantiateWasm=(e,t)=>{var a=Module.wasmModule;Module.wasmModule=null;var r=new WebAssembly.Instance(a,e);return t(r)},self.onunhandledrejection=e=>{throw e.reason||e};function handleMessage(e){try{if(e.data.cmd==="load"){let a=[];self.onmessage=r=>a.push(r),self.startWorker=r=>{Module=r,postMessage({cmd:"loaded"});for(let s of a)handleMessage(s);self.onmessage=handleMessage},Module.wasmModule=e.data.wasmModule;for(const r of e.data.handlers)Module[r]=(...s)=>{postMessage({cmd:"callHandler",handler:r,args:s})};if(Module.wasmMemory=e.data.wasmMemory,Module.buffer=Module.wasmMemory.buffer,Module.ENVIRONMENT_IS_PTHREAD=!0,typeof e.data.urlOrBlob=="string")importScripts(e.data.urlOrBlob);else{var t=URL.createObjectURL(e.data.urlOrBlob);importScripts(t),URL.revokeObjectURL(t)}ortWasmThreaded(Module)}else if(e.data.cmd==="run"){Module.__emscripten_thread_init(e.data.pthread_ptr,0,0,1),Module.__emscripten_thread_mailbox_await(e.data.pthread_ptr),Module.establishStackSpace(),Module.PThread.receiveObjectTransfer(e.data),Module.PThread.threadInitTLS(),initializedJS||(initializedJS=!0);try{Module.invokeEntryPoint(e.data.start_routine,e.data.arg)}catch(a){if(a!="unwind")throw a}}else e.data.cmd==="cancel"?Module._pthread_self()&&Module.__emscripten_thread_exit(-1):e.data.target==="setimmediate"||(e.data.cmd==="checkMailbox"?initializedJS&&Module.checkMailbox():e.data.cmd&&(err(`worker.js received unknown command ${e.data.cmd}`),err(e.data)))}catch(a){throw Module.__emscripten_thread_crashed?.(),a}}self.onmessage=handleMessage;\\n\'});var _n,Xe,cr,Mr,pr,No,Cn,Ne=j(()=>{"use strict";_n=e=>{switch(e){case"int8":return 3;case"uint8":return 2;case"bool":return 9;case"int16":return 5;case"uint16":return 4;case"int32":return 6;case"uint32":return 12;case"float16":return 10;case"float32":return 1;case"float64":return 11;case"string":return 8;case"int64":return 7;case"uint64":return 13;default:throw new Error(`unsupported data type: ${e}`)}},Xe=e=>{switch(e){case 3:return"int8";case 2:return"uint8";case 9:return"bool";case 5:return"int16";case 4:return"uint16";case 6:return"int32";case 12:return"uint32";case 10:return"float16";case 1:return"float32";case 11:return"float64";case 8:return"string";case 7:return"int64";case 13:return"uint64";default:throw new Error(`unsupported data type: ${e}`)}},cr=e=>[void 0,4,1,1,2,2,4,8,void 0,1,2,8,4,8,void 0,void 0,void 0][e],Mr=e=>{switch(e){case"float16":return Uint16Array;case"float32":return Float32Array;case"uint8":return Uint8Array;case"int8":return Int8Array;case"uint16":return Uint16Array;case"int16":return Int16Array;case"int32":return Int32Array;case"bool":return Uint8Array;case"float64":return Float64Array;case"uint32":return Uint32Array;case"int64":return BigInt64Array;case"uint64":return BigUint64Array;default:throw new Error(`unsupported type: ${e}`)}},pr=e=>{switch(e){case"verbose":return 0;case"info":return 1;case"warning":return 2;case"error":return 3;case"fatal":return 4;default:throw new Error(`unsupported logging level: ${e}`)}},No=e=>e==="float32"||e==="int32"||e==="int64"||e==="bool"||e==="float16"||e==="uint32",Cn=e=>{switch(e){case"none":return 0;case"cpu":return 1;case"cpu-pinned":return 2;case"texture":return 3;case"gpu-buffer":return 4;default:throw new Error(`unsupported data location: ${e}`)}}});var zr=j(()=>{"use strict"});var Ho=j(()=>{"use strict";zr()});var Go,Lo=j(()=>{"use strict";Go="1.17.1"});var Fo,Pt,In=j(()=>{"use strict";Lo();Fo="warning",Pt={wasm:{},webgl:{},webgpu:{},versions:{common:Go},set logLevel(e){if(e!==void 0){if(typeof e!="string"||["verbose","info","warning","error","fatal"].indexOf(e)===-1)throw new Error(`Unsupported logging level: ${e}`);Fo=e}},get logLevel(){return Fo}};Object.defineProperty(Pt,"logLevel",{enumerable:!0})});var Gt,jo=j(()=>{"use strict";In();Gt=Pt});var qo=j(()=>{"use strict"});var Ko=j(()=>{"use strict";Ur()});var Zo=j(()=>{"use strict"});var Qo=j(()=>{"use strict";Ur()});var Ur=j(()=>{"use strict";qo();Ko();Zo();Qo()});var Vr=j(()=>{"use strict";Ur()});var An,Xo,kt,Rt,Tn=j(()=>{"use strict";In();An=(e,t)=>{Pt.wasm.trace&&console.timeStamp(`${e}::ORT::${t}`)},Xo=(e,t)=>{let r=new Error().stack?.split(/\\r\\n|\\r|\\n/g)||[],o=!1;for(let n=0;n<r.length;n++){if(o&&!r[n].includes("TRACE_FUNC")){let s=`FUNC_${e}::${r[n].trim().split(" ")[1]}`;t&&(s+=`::${t}`),An("CPU",s);return}r[n].includes("TRACE_FUNC")&&(o=!0)}},kt=e=>{Pt.wasm.trace&&Xo("BEGIN",e)},Rt=e=>{Pt.wasm.trace&&Xo("END",e)}});var Jo=j(()=>{"use strict";zr();Vr();Tn()});var ea=j(()=>{"use strict";Jo()});var ta=j(()=>{"use strict"});var ra=j(()=>{"use strict";zr();Vr()});var na=j(()=>{"use strict";ra()});var Lt=j(()=>{"use strict";Ho();jo();ea();Vr();Tn();ta();na()});var dd,ld,oa,aa,ia,cd,Be,Ct=j(()=>{"use strict";Ne();dd=["V","I","W","E","F"],ld=(e,t)=>{console.log(`[${dd[e]},${new Date().toISOString()}]${t}`)},ia=(e,t)=>{oa=e,aa=t},cd=(e,t)=>{let r=pr(e),o=pr(oa);r>=o&&ld(r,typeof t=="function"?t():t)},Be=(...e)=>{aa&&cd(...e)}});var sa,ua=j(()=>{"use strict";Ne();sa=(e,t)=>new(Mr(t))(e)});var Nr=j(()=>{"use strict"});var Wr,pd,da,On,En,ca,pa=j(()=>{"use strict";Ct();Nr();Wr=e=>Math.ceil(e/16)*16,pd=1,da=()=>pd++,On=async(e,t,r,o)=>{let n=Wr(r),s=e.device.createBuffer({size:n,usage:GPUBufferUsage.COPY_DST|GPUBufferUsage.MAP_READ});try{let u=e.getCommandEncoder();e.endComputePass(),u.copyBufferToBuffer(t,0,s,0,n),e.flush(),await s.mapAsync(GPUMapMode.READ);let l=s.getMappedRange();if(o){let a=o();return a.set(new Uint8Array(l,0,r)),a}else return new Uint8Array(l.slice(0,r))}finally{s.destroy()}},En=class{constructor(t){this.backend=t;this.storageCache=new Map,this.freeBuffers=new Map,this.freeUniformBuffers=new Map,this.buffersForUploadingPending=[],this.buffersPending=[],this.externalBuffers=new Map}upload(t,r){let o=r.buffer,n=r.byteOffset,s=r.byteLength,u=Wr(s),l=this.storageCache.get(t);if(!l)throw new Error("gpu data for uploading does not exist");if(l.originalSize!==s)throw new Error(`inconsistent data size. gpu data size=${l.originalSize}, data size=${s}`);let a=this.backend.device.createBuffer({mappedAtCreation:!0,size:u,usage:GPUBufferUsage.MAP_WRITE|GPUBufferUsage.COPY_SRC}),p=a.getMappedRange();new Uint8Array(p).set(new Uint8Array(o,n,s)),a.unmap();let h=this.backend.getCommandEncoder();this.backend.endComputePass(),h.copyBufferToBuffer(a,0,l.gpuData.buffer,0,u),Be("verbose",()=>`[WebGPU] GpuDataManager.upload(id=${t})`),this.buffersForUploadingPending.push(a)}memcpy(t,r){let o=this.storageCache.get(t);if(!o)throw new Error("source gpu data for memcpy does not exist");let n=this.storageCache.get(r);if(!n)throw new Error("destination gpu data for memcpy does not exist");if(o.originalSize!==n.originalSize)throw new Error("inconsistent source and destination gpu data size");let s=Wr(o.originalSize),u=this.backend.getCommandEncoder();this.backend.endComputePass(),u.copyBufferToBuffer(o.gpuData.buffer,0,n.gpuData.buffer,0,s)}registerExternalBuffer(t,r,o){let n;if(o){if(n=this.externalBuffers.get(o),n===void 0)throw new Error("previous buffer is not registered");if(t===o)return Be("verbose",()=>`[WebGPU] GpuDataManager.registerExternalBuffer(size=${r}) => id=${n}, buffer is the same, skip.`),n;this.externalBuffers.delete(o)}else n=da();return this.storageCache.set(n,{gpuData:{id:n,type:0,buffer:t},originalSize:r}),this.externalBuffers.set(t,n),Be("verbose",()=>`[WebGPU] GpuDataManager.registerExternalBuffer(size=${r}) => id=${n}, registered.`),n}unregisterExternalBuffer(t){let r=this.externalBuffers.get(t);r!==void 0&&(this.storageCache.delete(r),this.externalBuffers.delete(t),Be("verbose",()=>`[WebGPU] GpuDataManager.unregisterExternalBuffer() => id=${r}`))}create(t,r=GPUBufferUsage.STORAGE|GPUBufferUsage.COPY_SRC|GPUBufferUsage.COPY_DST){let o=Wr(t),n,s=(r&GPUBufferUsage.STORAGE)===GPUBufferUsage.STORAGE,u=(r&GPUBufferUsage.UNIFORM)===GPUBufferUsage.UNIFORM;if(s||u){let a=s?this.freeBuffers:this.freeUniformBuffers,p=a.get(o);p||(p=[],a.set(o,p)),p.length>0?n=p.pop():n=this.backend.device.createBuffer({size:o,usage:r})}else n=this.backend.device.createBuffer({size:o,usage:r});let l={id:da(),type:0,buffer:n};return this.storageCache.set(l.id,{gpuData:l,originalSize:t}),Be("verbose",()=>`[WebGPU] GpuDataManager.create(size=${t}) => id=${l.id}`),l}get(t){return this.storageCache.get(t)?.gpuData}release(t){let r=this.storageCache.get(t);if(!r)throw new Error("releasing data does not exist");return Be("verbose",()=>`[WebGPU] GpuDataManager.release(id=${t}), gpuDataId=${r.gpuData.id}`),this.storageCache.delete(t),this.buffersPending.push(r.gpuData.buffer),r.originalSize}async download(t,r){let o=this.storageCache.get(t);if(!o)throw new Error("data does not exist");await On(this.backend,o.gpuData.buffer,o.originalSize,r)}refreshPendingBuffers(){for(let t of this.buffersForUploadingPending)t.destroy();this.buffersForUploadingPending=[];for(let t of this.buffersPending)(t.usage&GPUBufferUsage.STORAGE)===GPUBufferUsage.STORAGE?this.freeBuffers.get(t.size).push(t):(t.usage&GPUBufferUsage.UNIFORM)===GPUBufferUsage.UNIFORM?this.freeUniformBuffers.get(t.size).push(t):t.destroy();this.buffersPending=[]}dispose(){this.freeBuffers.forEach(t=>{t.forEach(r=>{r.destroy()})}),this.freeUniformBuffers.forEach(t=>{t.forEach(r=>{r.destroy()})}),this.storageCache.forEach(t=>{t.gpuData.buffer.destroy()}),this.storageCache=new Map,this.freeBuffers=new Map,this.freeUniformBuffers=new Map}},ca=(...e)=>new En(...e)});var Pn,ge,je=j(()=>{"use strict";Pn=class{constructor(t){Object.assign(this,t)}get cacheKey(){return this.key||(this.key=Object.getOwnPropertyNames(this).sort().map(t=>`${this[t]}`).join(";")),this.key}},ge=e=>new Pn(e)});var kn,dt,U,Bt,Hr,Gr,Lr,$e=j(()=>{"use strict";kn=class{static calcMatMulShape(t,r){return t[1]!==r[0]?void 0:[t[0],r[1]]}},dt=class{static calcShape(t,r,o=!1){let n=t.length,s=r.length;if(n===0)return r;if(s===0)return t;let u=Math.max(t.length,r.length),l=new Array(u);if(o){if(n<2||s<2)return;let a=kn.calcMatMulShape([t[n-2],t[n-1]],[r[s-2],r[s-1]]);if(a===void 0)return;[l[u-2],l[u-1]]=a}for(let a=o?3:1;a<=u;a++){let p=n-a<0?1:t[n-a],h=s-a<0?1:r[s-a];if(p!==h&&p>1&&h>1)return;l[u-a]=Math.max(p,h)}return l}static isValidBroadcast(t,r){let o=t.length,n=r.length;if(o>n)return!1;for(let s=1;s<=o;s++)if(t[o-s]!==1&&t[o-s]!==r[n-s])return!1;return!0}},U=class e{static size(t){return e.getSizeFromDimensionRange(t,0,t.length)}static sizeFromDimension(t,r){if(r<0||r>t.length)throw new Error(`invalid dimension of ${r} for sizeFromDimension as Tensor has ${t.length} dimensions.`);return e.getSizeFromDimensionRange(t,r,t.length)}static sizeToDimension(t,r){if(r<0||r>t.length)throw new Error(`invalid dimension of ${r} for sizeToDimension as Tensor has ${t.length} dimensions.`);return e.getSizeFromDimensionRange(t,0,r)}static getSizeFromDimensionRange(t,r,o){let n=1;for(let s=r;s<o;s++){if(t[s]<0)throw new Error("cannot get valid size from specified dimension range. Most likely the range contains negative values in them.");n*=t[s]}return n}static computeStrides(t){let r=t.length;if(r===0)return[];if(r===1)return[1];let o=new Array(r);o[r-1]=1,o[r-2]=t[r-1];for(let n=r-3;n>=0;--n)o[n]=o[n+1]*t[n+1];return o}static normalizeAxis(t,r){if(t<-r&&t>=r)throw new Error("unsupported axis for this operation.");return t<0?t+r:t}static normalizeAxes(t,r){return t.map(o=>this.normalizeAxis(o,r??t.length))}static sortBasedOnPerm(t,r){return r?r.map(o=>t[o]):t.slice().reverse()}static padShape(t,r){let o=t.length;return t.map((n,s)=>n+r[s]+r[s+o])}static areEqual(t,r){return t.length!==r.length?!1:t.every((o,n)=>o===r[n])}},Bt=class e{static adjustPoolAttributes(t,r,o,n,s,u){if(!t&&o.length!==r.length-2)throw new Error("length of specified kernel shapes should be 2 less than length of input dimensions");if(t)for(let l=0;l<r.length-2;l++)l>=o.length?o.push(r[l+2]):o[l]=r[l+2];for(let l=0;l<o.length;l++)if(l<n.length){if(n[l]<0)throw new Error("strides should be greater than or equal to 1")}else n.push(1);for(let l=0;l<o.length;l++)if(l<s.length){if(s[l]<0)throw new Error("dilations should be greater than or equal to 1")}else s.push(1);for(let l=0;l<o.length*2;l++)if(l<u.length){if(u[l]<0)throw new Error("pad should be greater than or equal to 1")}else u.push(0);for(let l=0;l<o.length;l++){if(o[l]<=0)throw new Error("kernel shapes need to be greater than 0");if(u[l]>=o[l]||u[l+o.length]>=o[l])throw new Error("pads should be smaller than kernel")}}static adjustPadsBasedOnAutoPad(t,r,o,n,s,u,l){if(l){if(s.length!==2*(t.length-2))throw new Error("length of pads should be twice the length of data dimensions");if(r.length!==t.length-2)throw new Error("length of strides should be the length of data dimensions");if(n.length!==t.length-2)throw new Error("length of kernel shapes should be the length of data dimensions");for(let a=0;a<t.length-2;a++)e.adjustPadAndReturnShape(t[a+(u?1:2)],r[a],o[a],n[a],s,a,a+t.length-2,l)}}static computePoolOutputShape(t,r,o,n,s,u,l){if(r.length<=0)throw new Error("input shape must be of size greater than 0");let a=[r[0],r[1]];return e.computeShapeHelper(t,r,a,o,n,s,u,l),a}static computeConvOutputShape(t,r,o,n,s,u,l){if(t.length<=0||r.length<=0)throw new Error("invalid input tensor dims or invalid filter tensor dims");let a=[t[0],r[0]];return e.computeShapeHelper(!1,t,a,o,n,s,u,l),a}static computeShapeHelper(t,r,o,n,s,u,l,a){if(t)for(let p=0;p<r.length-2;p++)o.push(1);else for(let p=0;p<r.length-2;p++)o.push(e.adjustPadAndReturnShape(r[p+2],n[p],s[p],u[p],l,p,p+r.length-2,a))}static adjustPadAndReturnShape(t,r,o,n,s,u,l,a){let p=o*(n-1)+1;if(a&&a!=="NOTSET")switch(a){case"VALID":return s[u]=0,s[l]=0,Math.floor((t-p)/r+1);case"SAME_LOWER":case"SAME_UPPER":if(o!==1)throw new Error("Dilation not supported for SAME_UPPER or SAME_LOWER");{let g=((t+r-1)/r-1)*r+n-t;return s[u]=Math.floor(a==="SAME_LOWER"?(g+1)/2:g/2),s[l]=g-s[u],Math.floor((t+g-n)/r+1)}default:throw new Error("Unsupported AutoPad type")}else return Math.floor((t+s[u]+s[l]-p)/r+1)}},Hr=class{static getShapeOfGemmResult(t,r,o,n,s){if(t.length!==2||o.length!==2)throw new Error("shape need to be of size 2");let u,l,a;r?(u=t[1],l=t[0]):(u=t[0],l=t[1]);let p=-1;if(n?(a=o[0],p=1):(a=o[1],p=0),o[p]!==l)throw new Error("dimension mismatch");if(u<=0||a<=0||l<=0)throw new Error("invalid shape specified");if(s&&!dt.isValidBroadcast(s,[u,a]))throw new Error("gemm: invalid bias shape for broadcast");return[u,a,l]}},Gr=-34028234663852886e22,Lr=34028234663852886e22});var md,Bn,Le,lt,L,Fe,Ze,at,Je,ce,Dn,M,F,Fr,Rn,ma,Ft,Re,ve=j(()=>{"use strict";Ne();$e();md=64,Bn=(e,t)=>{if(t===3)throw new Error("vec3 has same alignment as vec4, use vec4 instead");switch(e){case 10:return t>1?`vec${t}<f16>`:"f16";case 1:return t>1?`vec${t}<f32>`:"f32";case 6:return t>1?`vec${t}<i32>`:"i32";case 12:return t>1?`vec${t}<u32>`:"u32";case 7:if(t>1)throw new Error("currently not supported vecX of uint64 yet");return["vec2<u32>","i32"];case 13:if(t>1)throw new Error("currently not supported vecX of uint64 yet");return["vec2<u32>","u32"];case 9:if(t!==4)throw new Error("bool must be vec4");return["u32","vec4<bool>"];default:throw new Error(`Unknown data type: ${e}`)}},Le=(e,t=1)=>{let r=Bn(e,t);return typeof r=="string"?r:r[0]},lt=(e,t=1)=>{let r=Bn(e,t);return typeof r=="string"?r:r[1]},L=e=>e.length===0?[]:[{type:"uint32",data:e},{type:"uint32",data:U.computeStrides(e)}],Fe=e=>e%4===0?4:e%2===0?2:1,Ze=(e="f32",t,r="0")=>!t||t===1?`${e}(${r})`:`vec${t}<${e}>(${r})`,at=(e,t,r)=>e==="f32"?r:t===1?`f32(${r})`:`vec${t}f(${r})`,Je=(e,t)=>t===4?`(${e}.x + ${e}.y + ${e}.z + ${e}.w)`:t===2?`(${e}.x + ${e}.y)`:t===3?`(${e}.x + ${e}.y + ${e}.z)`:e,ce=(e,t,r)=>e.startsWith("uniforms.")&&r>4?typeof t=="string"?`${e}[(${t}) / 4][(${t}) % 4]`:`${e}[${Math.floor(t/4)}][${t%4}]`:r>1?`${e}[${t}]`:e,Dn=(e,t,r,o,n)=>{let s=typeof r=="number",u=s?r:r.length,l=[...new Array(u).keys()],a=u<2?"u32":u<=4?`vec${u}<u32>`:`array<u32, ${u}>`,p=Bn(t,n),h=typeof p=="string"?p:p[1],g=typeof p=="string"?p:p[0],b={indices:a,value:h,storage:g,tensor:t},w=G=>typeof G=="string"?G:`${G}u`,y={offsetToIndices:!1,indicesToOffset:!1,broadcastedIndicesToOffset:!1,set:!1,setByIndices:!1,get:!1,getByIndices:!1},_=s?"uniforms.":"",I=`${_}${e}_shape`,$=`${_}${e}_strides`,x="";for(let G=0;G<u-1;G++)x+=`\n    let dim${G} = current / ${ce($,G,u)};\n    let rest${G} = current % ${ce($,G,u)};\n    indices[${G}] = dim${G};\n    current = rest${G};\n    `;x+=`indices[${u-1}] = current;`;let E=u<2?"":`\n  fn o2i_${e}(offset: u32) -> ${b.indices} {\n    var indices: ${b.indices};\n    var current = offset;\n    ${x}\n    return indices;\n  }`,A=G=>(y.offsetToIndices=!0,u<2?G:`o2i_${e}(${G})`),z=[];if(u>=2)for(let G=u-1;G>=0;G--)z.push(`${ce($,G,u)} * (indices[${G}])`);let R=u<2?"":`\n  fn i2o_${e}(indices: ${b.indices}) -> u32 {\n    return ${z.join("+")};\n  }`,V=G=>(y.indicesToOffset=!0,u<2?G:`i2o_${e}(${G})`),T=(...G)=>u===0?"0u":`${b.indices}(${G.map(w).join(",")})`,N=(G,ee)=>u<2?`${G}`:`${ce(G,ee,u)}`,te=(G,ee,be)=>u<2?`${G}=${be};`:`${ce(G,ee,u)}=${be};`,Y={},K=(G,ee)=>{y.broadcastedIndicesToOffset=!0;let be=`${ee.name}broadcastedIndicesTo${e}Offset`;if(be in Y)return`${be}(${G})`;let et=[];for(let ze=u-1;ze>=0;ze--){let Ue=ee.indicesGet("outputIndices",ze+ee.rank-u);et.push(`${N($,ze)} * (${Ue} % ${N(I,ze)})`)}return Y[be]=`fn ${be}(outputIndices: ${ee.type.indices}) -> u32 {\n             return ${et.length>0?et.join("+"):"0u"};\n           }`,`${be}(${G})`},Q=(G,ee)=>(()=>{if(b.storage===b.value)return`${e}[${G}]=${ee};`;if(b.storage==="vec2<u32>"&&b.value==="i32")return`${e}[${G}]=vec2<u32>(u32(${ee}), select(0u, 0xFFFFFFFFu, ${ee} < 0));`;if(b.storage==="vec2<u32>"&&b.value==="u32")return`${e}[${G}]=vec2<u32>(u32(${ee}), 0u);`;if(b.storage==="u32"&&b.value==="vec4<bool>")return`${e}[${G}]=dot(vec4<u32>(0x1, 0x100, 0x10000, 0x1000000), vec4<u32>(${ee}));`;throw new Error(`not supported combination of storage type ${b.storage} and value type ${b.value} yet`)})(),Z=G=>(()=>{if(b.storage===b.value)return`${e}[${G}]`;if(b.storage==="vec2<u32>"&&b.value==="i32")return`i32(${e}[${G}].x)`;if(b.storage==="vec2<u32>"&&b.value==="u32")return`u32(${e}[${G}].x)`;if(b.storage==="u32"&&b.value==="vec4<bool>")return`vec4<bool>(bool(${e}[${G}] & 0xFFu), bool(${e}[${G}] & 0xFF00u), bool(${e}[${G}] & 0xFF0000u), bool(${e}[${G}] & 0xFF000000u))`;throw new Error(`not supported combination of storage type ${b.storage} and value type ${b.value} yet`)})(),Ee=u<2?"":`\n  fn get_${e}ByIndices(indices: ${b.indices}) -> ${h} {\n    return ${Z(`i2o_${e}(indices)`)};\n  }`,Pe=u<2?"":(()=>{let G=l.map(be=>`d${be}: u32`).join(", "),ee=l.map(be=>`d${be}`).join(", ");return`\n  fn get_${e}(${G}) -> ${h} {\n    return get_${e}ByIndices(${T(ee)});\n  }`})(),fe=(...G)=>{if(G.length!==u)throw new Error(`indices length must be ${u}`);let ee=G.map(w).join(",");return u===0?Z("0u"):u===1?Z(ee[0]):(y.get=!0,y.getByIndices=!0,y.indicesToOffset=!0,`get_${e}(${ee})`)},Ie=G=>u<2?Z(G):(y.getByIndices=!0,y.indicesToOffset=!0,`get_${e}ByIndices(${G})`),he=u<2?"":`\n  fn set_${e}ByIndices(indices: ${b.indices}, value: ${h}) {\n    ${Q(`i2o_${e}(indices)`,"value")}\n  }`,ye=u<2?"":(()=>{let G=l.map(be=>`d${be}: u32`).join(", "),ee=l.map(be=>`d${be}`).join(", ");return`\n  fn set_${e}(${G}, value: ${h}) {\n    set_${e}ByIndices(${T(ee)}, value);\n  }`})();return{impl:()=>{let G=[],ee=!1;return y.offsetToIndices&&(G.push(E),ee=!0),y.indicesToOffset&&(G.push(R),ee=!0),y.broadcastedIndicesToOffset&&(Object.values(Y).forEach(be=>G.push(be)),ee=!0),y.set&&(G.push(ye),ee=!0),y.setByIndices&&(G.push(he),ee=!0),y.get&&(G.push(Pe),ee=!0),y.getByIndices&&(G.push(Ee),ee=!0),!s&&ee&&G.unshift(`const ${I} = ${b.indices}(${r.join(",")});`,`const ${$} = ${b.indices}(${U.computeStrides(r).join(",")});`),G.join(`\n`)},type:b,offsetToIndices:A,indicesToOffset:V,broadcastedIndicesToOffset:K,indices:T,indicesGet:N,indicesSet:te,set:(...G)=>{if(G.length!==u+1)throw new Error(`indices length must be ${u}`);let ee=G[u];if(typeof ee!="string")throw new Error("value must be string");let be=G.slice(0,u).map(w).join(",");return u===0?Q("0u",ee):u===1?Q(be[0],ee):(y.set=!0,y.setByIndices=!0,y.indicesToOffset=!0,`set_${e}(${be}, ${ee})`)},setByOffset:Q,setByIndices:(G,ee)=>u<2?Q(G,ee):(y.setByIndices=!0,y.indicesToOffset=!0,`set_${e}ByIndices(${G}, ${ee});`),get:fe,getByOffset:Z,getByIndices:Ie,usage:o,name:e,strides:$,shape:I,rank:u}},M=(e,t,r,o=1)=>Dn(e,t,r,"input",o),F=(e,t,r,o=1)=>Dn(e,t,r,"output",o),Fr=(e,t,r,o=1)=>Dn(e,t,r,"internal",o),Rn=class{constructor(t){this.normalizedDispatchGroup=t;this.internalVariables=[];this.variables=[];this.uniforms=[];this.variableIndex=0}guardAgainstOutOfBoundsWorkgroupSizes(t){return`if (global_idx >= ${typeof t=="number"?`${t}u`:t}) { return; }`}mainStart(t=md){let r=typeof t=="number"?t:t[0],o=typeof t=="number"?1:t[1],n=typeof t=="number"?1:t[2],s=this.normalizedDispatchGroup[1]===1&&this.normalizedDispatchGroup[2]===1,u=s?`@builtin(global_invocation_id) global_id : vec3<u32>,\n    @builtin(workgroup_id) workgroup_id : vec3<u32>,\n    @builtin(local_invocation_id) local_id : vec3<u32>`:`@builtin(local_invocation_id) local_id : vec3<u32>,\n    @builtin(local_invocation_index) local_idx : u32,\n    @builtin(workgroup_id) workgroup_id : vec3<u32>,\n    @builtin(num_workgroups) num_workgroups : vec3<u32>`,l=s?"let global_idx = global_id.x; let local_idx = local_id.x;":`let global_idx = (workgroup_id.z * num_workgroups[0] * num_workgroups[1] +\n          workgroup_id.y * num_workgroups[0] + workgroup_id.x) * ${r*o*n}u + local_idx;`;return`@compute @workgroup_size(${r}, ${o}, ${n})\n  fn main(${u}) {\n    ${l}\n  `}appendVariableUniforms(t){t.rank!==0&&(t.shape.startsWith("uniforms.")&&this.uniforms.push({name:t.shape.replace("uniforms.",""),type:"u32",length:t.rank}),t.strides.startsWith("uniforms.")&&this.uniforms.push({name:t.strides.replace("uniforms.",""),type:"u32",length:t.rank}))}declareVariable(t,r){if(t.usage==="internal")throw new Error("cannot use internal variable with declareVariable(). use registerInternalVariables() instead.");this.variables.push(t),this.appendVariableUniforms(t);let o=t.usage==="input"?"read":"read_write",n=t.type.storage;return`@group(0) @binding(${r}) var<storage, ${o}> ${t.name}: array<${n}>;`}declareVariables(...t){return t.map(r=>this.declareVariable(r,this.variableIndex++)).join(`\n`)}registerInternalVariable(t){if(t.usage!=="internal")throw new Error("cannot use input or output variable with registerInternalVariable(). use declareVariables() instead.");this.internalVariables.push(t),this.appendVariableUniforms(t)}registerInternalVariables(...t){return t.forEach(r=>this.registerInternalVariable(r)),this}registerUniform(t,r,o=1){return this.uniforms.push({name:t,type:r,length:o}),this}registerUniforms(t){return this.uniforms=this.uniforms.concat(t),this}uniformDeclaration(){if(this.uniforms.length===0)return"";let t=[];for(let{name:r,type:o,length:n}of this.uniforms)if(n&&n>4)t.push(`${r}:array<vec4<${o}>, ${Math.ceil(n/4)}>`);else{let s=n==null||n===1?o:`vec${n}<${o}>`;t.push(`${r}:${s}`)}return`\n      struct Uniforms { ${t.join(", ")} };\n      @group(0) @binding(${this.variableIndex}) var<uniform> uniforms: Uniforms;`}get additionalImplementations(){return this.uniformDeclaration()+this.variables.map(t=>t.impl()).join(`\n`)+this.internalVariables.map(t=>t.impl()).join(`\n`)}},ma=e=>new Rn(e),Ft=(e,t)=>{let r=e.length,o=[];for(let n=0;n<r;n++){let s=r-1-n,u=e[s]||1;(t[t.length-1-n]||1)>1&&u===1&&o.unshift(s)}return o},Re=e=>!0});var fd,fa,hd,gd,it,ha,ga,jt=j(()=>{"use strict";$e();je();ve();fd=e=>{if(!e||e.length!==1)throw new Error("Transpose requires 1 input.")},fa=(e,t)=>t&&t.length!==e?[...new Array(e).keys()].reverse():t,hd=(e,t)=>U.sortBasedOnPerm(e,fa(e.length,t)),gd=(e,t,r,o)=>{let n=[];n.push(`fn perm(i: ${o.type.indices}) -> ${r.type.indices} {\n    var a: ${r.type.indices};`);for(let s=0;s<t;++s)n.push(r.indicesSet("a",e[s],`i[${s}]`));return n.push("return a;}"),n.join(`\n`)},it=(e,t)=>{let r=e.dataType,o=e.dims.length,n=fa(o,t),s=Re(o),u=hd(e.dims,n),l=s?u.length:u,a=s?o:e.dims,p=F("output",r,l),h=M("a",r,a),g=b=>`\n  ${b.registerUniform("output_size","u32").declareVariables(h,p)}\n\n  ${gd(n,o,h,p)}\n\n  ${b.mainStart()}\n    ${b.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n\n    let indices = ${p.offsetToIndices("global_idx")};\n    let aIndices = perm(indices);\n\n    ${p.setByOffset("global_idx",h.getByIndices("aIndices"))}\n  }`;return{name:"Transpose",shaderCache:{hint:`${t}`,inputDependencies:s?["rank"]:["dims"]},getRunData:b=>{let w=U.size(u);return{outputs:[{dims:u,dataType:b[0].dataType}],dispatchGroup:{x:Math.ceil(w/64)},programUniforms:s?[{type:"uint32",data:w},...L(b[0].dims),...L(u)]:[{type:"uint32",data:w}]}},getShaderSource:g}},ha=(e,t)=>{fd(e.inputs),e.compute(it(e.inputs[0],t.perm))},ga=e=>ge({perm:e.perm})});var yd,bd,wd,vd,$d,Sd,xd,_d,Cd,Id,ct,ya,ba,wa,va,$a,Sa,xa,_a,Ca,Ia,Aa=j(()=>{"use strict";$e();ve();jr();jt();yd={max:"select(bestValue, candidate, candidate > bestValue)",min:"select(bestValue, candidate, candidate < bestValue)",mean:"bestValue + candidate",sum:"bestValue + candidate",prod:"bestValue * candidate",sumSquare:"bestValue + candidate * candidate",logSumExp:"bestValue + exp(candidate)",l1:"bestValue + abs(candidate)",l2:"bestValue + candidate * candidate",logSum:"bestValue + candidate"},bd={max:"select(bestValue, candidate, candidate > bestValue)",min:"select(bestValue, candidate, candidate < bestValue)",mean:"bestValue + candidate",sum:"bestValue + candidate",prod:"bestValue * candidate",sumSquare:"bestValue + candidate",logSumExp:"bestValue + candidate",l1:"bestValue + candidate",l2:"bestValue + candidate",logSum:"bestValue + candidate"},wd={max:"_A[offset]",min:"_A[offset]",mean:"0",sum:"0",prod:"1",sumSquare:"0",logSumExp:"0",l1:"0",l2:"0",logSum:"0"},vd={max:"bestValue",min:"bestValue",sum:"bestValue",prod:"bestValue",sumSquare:"bestValue",logSumExp:"log(bestValue)",l1:"bestValue",l2:"sqrt(bestValue)",logSum:"log(bestValue)"},$d=(e,t)=>{let r=[];for(let o=t-e;o<t;++o)r.push(o);return r},Sd=(e,t)=>{let r=[],o=e.length;for(let s=0;s<o;s++)t.indexOf(s)===-1&&r.push(e[s]);let n=t.map(s=>e[s]);return[r,n]},xd=(e,t)=>{let r=e.length+t.length,o=[],n=0;for(let s=0;s<r;s++)t.indexOf(s)===-1?o.push(e[n++]):o.push(1);return o},_d=(e,t)=>{for(let r=0;r<e.length;++r)if(e[e.length-r-1]!==t-1-r)return!1;return!0},Cd=(e,t)=>{let r=[];if(!_d(e,t)){for(let o=0;o<t;++o)e.indexOf(o)===-1&&r.push(o);e.forEach(o=>r.push(o))}return r},Id=(e,t,r,o,n,s,u)=>{let l=r[0].dims,a=U.size(s),p=U.size(u),h=M("_A",r[0].dataType,l),g=F("output",n,s),b=32,w=`\n          var<workgroup> aBestValues : array<${g.type.storage}, ${b}>;\n       `;return{name:e,shaderCache:t,getShaderSource:_=>`\n        ${_.registerUniform("reduceSize","u32").declareVariables(h,g)}\n        ${w}\n        fn DIV_CEIL(a : u32, b : u32) -> u32 {\n          return ((a - 1u) / b + 1u);\n         }\n         ${_.mainStart(b)}\n\n          let outputIndex = global_idx / ${b};\n          let offset = outputIndex * uniforms.reduceSize;\n\n          var bestValue = ${g.type.storage}(${wd[o]});\n          let Length = uniforms.reduceSize;\n          for (var k = local_idx; k < Length; k = k + ${b}) {\n           let candidate = ${g.type.storage}(${h.getByOffset("offset + k")});\n           bestValue = ${yd[o]};\n          }\n          aBestValues[local_idx] = bestValue;\n          workgroupBarrier();\n\n         var reduceSize = min(Length, ${b}u);\n         for (var currentSize = reduceSize / 2u; reduceSize > 1u;\n             currentSize = reduceSize / 2u) {\n           let interval = DIV_CEIL(reduceSize, 2u);\n           if (local_idx < currentSize) {\n            let candidate = aBestValues[local_idx + interval];\n            bestValue = ${bd[o]};\n            aBestValues[local_idx] = bestValue;\n           }\n           reduceSize = interval;\n           workgroupBarrier();\n         }\n\n         if (local_idx == 0u) {\n          ${g.setByOffset("outputIndex",`${o==="mean"?`bestValue / ${g.type.storage}(uniforms.reduceSize)`:`${vd[o]}`}`)};\n         }\n        }`,getRunData:()=>({outputs:[{dims:s,dataType:n}],dispatchGroup:{x:a},programUniforms:[{type:"uint32",data:p}]})}},ct=(e,t,r,o)=>{let n=e.inputs.length===1?r:Mn(e.inputs,r),s=n.axes;s.length===0&&!n.noopWithEmptyAxes&&(s=e.inputs[0].dims.map((w,y)=>y));let u=U.normalizeAxes(s,e.inputs[0].dims.length),l=u,a=e.inputs[0],p=Cd(l,e.inputs[0].dims.length);p.length>0&&(a=e.compute(it(e.inputs[0],p),{inputs:[0],outputs:[-1]})[0],l=$d(l.length,a.dims.length));let[h,g]=Sd(a.dims,l),b=h;n.keepDims&&(b=xd(h,u)),e.compute(Id(t,{hint:n.cacheKey,inputDependencies:["type"]},[a],o,e.inputs[0].dataType,b,g),{inputs:[a]})},ya=(e,t)=>{ct(e,"ReduceMeanShared",t,"mean")},ba=(e,t)=>{ct(e,"ReduceL1Shared",t,"l1")},wa=(e,t)=>{ct(e,"ReduceL2Shared",t,"l2")},va=(e,t)=>{ct(e,"ReduceLogSumExpShared",t,"logSumExp")},$a=(e,t)=>{ct(e,"ReduceMaxShared",t,"max")},Sa=(e,t)=>{ct(e,"ReduceMinShared",t,"min")},xa=(e,t)=>{ct(e,"ReduceProdShared",t,"prod")},_a=(e,t)=>{ct(e,"ReduceSumShared",t,"sum")},Ca=(e,t)=>{ct(e,"ReduceSumSquareShared",t,"sumSquare")},Ia=(e,t)=>{ct(e,"ReduceLogSumShared",t,"logSum")}});var pt,Ad,qr,Mn,mt,Td,Ed,Od,Pd,kd,Rd,Bd,Dd,Md,zd,ft,Ta,Ea,Oa,Pa,ka,Ra,Ba,Da,Ma,za,jr=j(()=>{"use strict";$e();je();ve();Aa();pt=e=>{if(!e||e.length===0||e.length>2)throw new Error("Reduce op requires 1 or 2 inputs.");if(e.length===2&&e[1].dims.length!==1)throw new Error("Invalid axes input dims.")},Ad=e=>["","",`var value = ${e.getByIndices("input_indices")};`,""],qr=(e,t,r,o,n,s,u=!1,l=!1)=>{let a=[],p=r[0].dims,h=p.length,g=U.normalizeAxes(n,h),b=!l&&g.length===0;p.forEach((I,$)=>{b||g.indexOf($)>=0?u&&a.push(1):a.push(I)});let w=a.length,y=U.size(a);return{name:e,shaderCache:t,getShaderSource:I=>{let $=[],x=M("_A",r[0].dataType,h),E=F("output",s,w),A=o(x,E,g),z=A[2];for(let R=0,V=0;R<h;R++)b||g.indexOf(R)>=0?(u&&V++,z=`for(var j${R}: u32 = 0; j${R} < ${p[R]}; j${R}++) {\n                  ${A[2].includes("last_index")?`let last_index = j${R};`:""}\n                  ${x.indicesSet("input_indices",R,`j${R}`)}\n                  ${z}\n                }`):($.push(`${x.indicesSet("input_indices",R,E.indicesGet("output_indices",V))};`),V++);return`\n\n        ${I.registerUniform("output_size","u32").declareVariables(x,E)}\n\n        ${I.mainStart()}\n          ${I.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n          var input_indices: ${x.type.indices};\n          let output_indices = ${E.offsetToIndices("global_idx")};\n\n          ${$.join(`\n`)}\n          ${A[0]}       // init ops for reduce max/min\n          ${A[1]}\n          ${z}\n          ${A[3]}\n          ${A.length===4?E.setByOffset("global_idx","value"):A.slice(4).join(`\n`)}\n        }`},getRunData:()=>({outputs:[{dims:a,dataType:s}],dispatchGroup:{x:Math.ceil(y/64)},programUniforms:[{type:"uint32",data:y},...L(p),...L(a)]})}},Mn=(e,t)=>{let r=[];return e[1].dims[0]>0&&e[1].getBigInt64Array().forEach(o=>r.push(Number(o))),ge({axes:r,keepDims:t.keepDims,noopWithEmptyAxes:t.noopWithEmptyAxes})},mt=(e,t,r,o)=>{let n=e.inputs,s=n.length===1?r:Mn(n,r);e.compute(qr(t,{hint:s.cacheKey,inputDependencies:["rank"]},[n[0]],s.noopWithEmptyAxes&&s.axes.length===0?Ad:o,s.axes,n[0].dataType,s.keepDims,s.noopWithEmptyAxes),{inputs:[0]})},Td=(e,t)=>{pt(e.inputs),mt(e,"ReduceLogSum",t,(o,n)=>[`var value = ${n.type.storage}(0);`,"",`value += ${o.getByIndices("input_indices")};`,"value = log(value);"])},Ed=(e,t)=>{pt(e.inputs),mt(e,"ReduceL1",t,(o,n)=>[`var value = ${n.type.storage}(0);`,"",`value += abs(${o.getByIndices("input_indices")});`,""])},Od=(e,t)=>{pt(e.inputs),mt(e,"ReduceL2",t,(o,n)=>[`var t = ${n.type.value}(0); var value = ${n.type.value}(0);`,"",`t = ${o.getByIndices("input_indices")}; value += (t * t);`,"value = sqrt(value);"])},Pd=(e,t)=>{pt(e.inputs),mt(e,"ReduceLogSumExp",t,(o,n)=>[`var value = ${n.type.storage}(0);`,"",`value += exp(${o.getByIndices("input_indices")});`,"value = log(value);"])},kd=(e,t)=>{pt(e.inputs),mt(e,"ReduceMax",t,(o,n,s)=>{let u=[];for(let l=0;l<o.rank;l++)(s.indexOf(l)>=0||s.length===0)&&u.push(o.indicesSet("input_indices",l,0));return[`${u.join(`\n`)}`,`var value = ${o.getByIndices("input_indices")};`,`value = max(value, ${o.getByIndices("input_indices")});`,""]})},Rd=(e,t)=>{pt(e.inputs),mt(e,"ReduceMean",t,(o,n,s)=>{let u=1;for(let l=0;l<o.rank;l++)(s.indexOf(l)>=0||s.length===0)&&(u*=e.inputs[0].dims[l]);return["var sum = f32(0);","",`sum += f32(${o.getByIndices("input_indices")});`,`let value = ${n.type.value}(sum / ${u});`]})},Bd=(e,t)=>{pt(e.inputs),mt(e,"ReduceMin",t,(o,n,s)=>{let u=[];for(let l=0;l<o.rank;l++)(s.indexOf(l)>=0||s.length===0)&&u.push(`input_indices[${l}] = 0;`);return[`${u.join(`\n`)}`,`var value = ${o.getByIndices("input_indices")};`,`value = min(value, ${o.getByIndices("input_indices")});`,""]})},Dd=(e,t)=>{pt(e.inputs),mt(e,"ReduceProd",t,(o,n)=>[`var value = ${n.type.storage}(1);`,"",`value *= ${o.getByIndices("input_indices")};`,""])},Md=(e,t)=>{pt(e.inputs),mt(e,"ReduceSum",t,(o,n)=>[`var value = ${n.type.storage}(0);`,"",`value += ${o.getByIndices("input_indices")};`,""])},zd=(e,t)=>{pt(e.inputs),mt(e,"ReduceSumSquare",t,(o,n)=>[`var t = ${n.type.value}(0); var value = ${n.type.value}(0);`,"",`t = ${o.getByIndices("input_indices")}; value += t * t;`,""])},ft=(e,t,r)=>{if(t.length===0)return r;let o=1,n=1;for(let s=0;s<t.length;s++)t.indexOf(s)===-1?o*=e[s]:n*=e[s];return n<32&&o>1024},Ta=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Rd(e,t):ya(e,t)},Ea=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Ed(e,t):ba(e,t)},Oa=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Od(e,t):wa(e,t)},Pa=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Pd(e,t):va(e,t)},ka=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?kd(e,t):$a(e,t)},Ra=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Bd(e,t):Sa(e,t)},Ba=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Dd(e,t):xa(e,t)},Da=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Md(e,t):_a(e,t)},Ma=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?zd(e,t):Ca(e,t)},za=(e,t)=>{ft(e.inputs[0].dims,t.axes,t.noopWithEmptyAxes)?Td(e,t):Ia(e,t)}});var Ua,Va,Na,zn,Wa=j(()=>{"use strict";Ne();je();jr();Ua=e=>{if(!e||e.length===0||e.length>2)throw new Error("ArgMinMaxOp op requires 1 or 2 inputs.");if(e[0].dataType!==1)throw new Error("Invalid input type.")},Va=(e,t)=>{Ua(e.inputs);let r=(o,n,s)=>{let u=[];for(let l=0;l<o.rank;l++)(s.indexOf(l)>=0||s.length===0)&&u.push(`input_indices[${l}] = 0;`);return[`${u.join(`\n`)}`,`var value = ${o.getByIndices("input_indices")};\nvar best_index : i32 = 0;`,`if (${o.getByIndices("input_indices")} ${t.selectLastIndex>0?"<=":"<"} value) {\n         value = ${o.getByIndices("input_indices")};\n         best_index = i32(last_index);\n       }`,"",n.setByOffset("global_idx","best_index")]};e.compute(qr("ArgMin",{hint:t.cacheKey,inputDependencies:["rank"]},[e.inputs[0]],r,[t.axis],7,t.keepDims),{inputs:[0]})},Na=(e,t)=>{Ua(e.inputs);let r=(o,n,s)=>{let u=[];for(let l=0;l<o.rank;l++)(s.indexOf(l)>=0||s.length===0)&&u.push(`input_indices[${l}] = 0;`);return[`${u.join(`\n`)}`,`var value = ${o.getByIndices("input_indices")};\nvar best_index : i32 = 0;`,`if (${o.getByIndices("input_indices")} ${t.selectLastIndex>0?">=":">"} value) {\n         value = ${o.getByIndices("input_indices")};\n         best_index = i32(last_index);\n       }`,"",n.setByOffset("global_idx","best_index")]};e.compute(qr("argMax",{hint:t.cacheKey,inputDependencies:["rank"]},[e.inputs[0]],r,[t.axis],7,t.keepDims),{inputs:[0]})},zn=e=>ge(e)});var Ud,Vd,Nd,Wd,Kr,Hd,Ha,Un=j(()=>{"use strict";Ne();Nr();ve();Ud=(e,t)=>{let r=e[0],o=e[1],n=e[2],s=e[3],u=e[4],l=e[5];if(u&&l)throw new Error("Attention cannot have both past and relative_position_bias");if(r.dims.length!==3)throw new Error(\'Input "input" must have 3 dimensions\');let a=r.dims[0],p=r.dims[1],h=r.dims[2];if(n.dims.length!==1)throw new Error(\'Input "bias" is expected to have 1 dimensions\');if(o.dims.length!==2)throw new Error(\'Input "weights" is expected to have 2 dimensions\');if(o.dims[0]!==h)throw new Error("Input 1 dimension 0 should have same length as dimension 2 of input 0");if(n.dims[0]!==o.dims[1])throw new Error(\'Input "bias" dimension 0 should have same length as dimension 1 of input "weights"\');let g=n.dims[0]/3,b=g,w=b;if(t.qkvHiddenSizes.length>0){if(t.qkvHiddenSizes.length!==3)throw new Error("qkv_hidden_sizes attribute should have 3 elements");for(let E of t.qkvHiddenSizes)if(E%t.numHeads!==0)throw new Error("qkv_hidden_sizes should be divisible by num_heads");g=t.qkvHiddenSizes[0],b=t.qkvHiddenSizes[1],w=t.qkvHiddenSizes[2]}let y=p;if(g!==b)throw new Error("qkv_hidden_sizes first element should be same as the second");if(n.dims[0]!==g+b+w)throw new Error(\'Input "bias" dimension 0 should have same length as sum of Q/K/V hidden sizes\');let _=0;if(u){if(b!==w)throw new Error(\'Input "past" expect k_hidden_size == v_hidden_size\');if(u.dims.length!==5)throw new Error(\'Input "past" must have 5 dimensions\');if(u.dims[0]!==2)throw new Error(\'Input "past" first dimension must be 2\');if(u.dims[1]!==a)throw new Error(\'Input "past" second dimension must be batch_size\');if(u.dims[2]!==t.numHeads)throw new Error(\'Input "past" third dimension must be num_heads\');if(u.dims[4]!==b/t.numHeads)throw new Error(\'Input "past" fifth dimension must be k_hidden_size / num_heads\');t.pastPresentShareBuffer||(_=u.dims[3])}let I=y+_,$=-1,x=0;if(s)throw new Error("Mask not supported");if(u)throw new Error("past is not supported");if(l)throw new Error("relativePositionBias is not supported");return{batchSize:a,sequenceLength:p,pastSequenceLength:_,kvSequenceLength:y,totalSequenceLength:I,maxSequenceLength:$,inputHiddenSize:h,hiddenSize:g,vHiddenSize:w,headSize:Math.floor(g/t.numHeads),vHeadSize:Math.floor(w/t.numHeads),numHeads:t.numHeads,isUnidirectional:!1,pastPresentShareBuffer:!1,maskFilterValue:t.maskFilterValue,maskType:x,scale:t.scale,broadcastResPosBias:!1,passPastInKv:!1,qkvFormat:1}},Vd=(e,t,r,o)=>{let n=Fe(o),s=64,u=o/n;u<s?s=1:u/8<64&&(s=Math.ceil(u/8));let l=Math.ceil(o/n/s),p=[{type:Xe(t.dataType),data:1/o},{type:"uint32",data:u},{type:"uint32",data:l}],h=Le(t.dataType,n),g=b=>{let w=F("x",t.dataType,t.dims,n),y="thread_max_vector";n===2?y="max(thread_max_vector.x, thread_max_vector.y)":n===4&&(y="max(max(thread_max_vector.x, thread_max_vector.y), max(thread_max_vector.z, thread_max_vector.w))");let _=lt(t.dataType),I=[{name:"d_inv",type:_},{name:"d_comp",type:"u32"},{name:"elements_per_wg",type:"u32"}];return`\n  var<workgroup> wgMax: array<f32, ${s}>;\n  var<workgroup> wgSum: array<f32, ${s}>;\n  ${b.registerUniforms(I).declareVariables(w)}\n  ${b.mainStart([s,1,1])}\n    let localOffset = local_idx * uniforms.elements_per_wg;\n    let offset: u32 = workgroup_id.x * uniforms.d_comp + localOffset;\n\n    var thread_max_vector = ${Ze("f32",n,"-3.402823e+38f")};\n    for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {\n      thread_max_vector = max(${at(_,n,"x[offset + i]")}, thread_max_vector);\n    }\n    wgMax[local_idx] = ${y};\n    workgroupBarrier();\n\n    var maxValue = -3.402823e+38f;\n    for (var i = 0u; i < ${s}; i++) {\n      maxValue = max(wgMax[i], maxValue);\n    }\n\n    var sumVector = ${Ze("f32",n,"0")};\n    for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {\n      sumVector += exp(${at(_,n,"x[offset + i]")} - maxValue);\n    }\n    wgSum[local_idx] = ${Je("sumVector",n)};\n    workgroupBarrier();\n\n    var sum: f32 = 0;\n    for (var i = 0u; i < ${s}; i++) {\n      sum += wgSum[i];\n    }\n\n    if (sum == 0) {\n      for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {\n        x[offset + i] = ${Ze("f32",n,"uniforms.d_inv")};\n      }\n    } else {\n      for (var i: u32 = 0; i < uniforms.elements_per_wg && i + localOffset < uniforms.d_comp; i++) {\n        let f32input = ${at(_,n,"x[offset + i]")};\n        x[offset + i] = ${w.type.value}(exp(f32input - maxValue) / sum);\n      }\n    }\n  }`};e.compute({name:"AttentionProbsSoftmax",shaderCache:{hint:`${s};${h};${n}`},getShaderSource:g,getRunData:()=>({outputs:[],dispatchGroup:{x:r},programUniforms:p})},{inputs:[t],outputs:[]})},Nd=(e,t,r,o,n,s)=>{let u=[n.batchSize,n.numHeads,n.sequenceLength,n.kvSequenceLength+n.pastSequenceLength],l=s.scale===0?1/Math.sqrt(n.headSize):s.scale,a=Fe(n.headSize),p=n.headSize/a,h=12,g={x:Math.ceil(n.totalSequenceLength/h),y:Math.ceil(n.sequenceLength/h),z:n.batchSize*n.numHeads},b=Xe(t.dataType),w=[{type:"uint32",data:n.sequenceLength},{type:"uint32",data:p},{type:"uint32",data:n.totalSequenceLength},{type:"uint32",data:n.kvSequenceLength},{type:b,data:l}],y=[t,r],_=$=>{let x=M("q",t.dataType,t.dims,a),E=M("key",r.dataType,r.dims,a),A=F("output",t.dataType,u),z=Le(t.dataType),R=[{name:"M",type:"u32"},{name:"K",type:"u32"},{name:"N",type:"u32"},{name:"kv_sequence_length",type:"u32"},{name:"alpha",type:z}];return`\n  const beta: ${z} = 1.0;\n  const TILE_SIZE = ${h}u;\n\n  var<workgroup> tileQ: array<${x.type.storage}, ${h*h}>;\n  var<workgroup> tileK: array<${x.type.storage}, ${h*h}>;\n  ${$.registerUniforms(R).declareVariables(x,E,A)}\n  ${$.mainStart([h,h,1])}\n    // x holds the N and y holds the M\n    let headIdx = workgroup_id.z;\n    let m = workgroup_id.y * TILE_SIZE;\n    let n = workgroup_id.x * TILE_SIZE;\n    let lm = m + local_id.y;\n    let ln = n + local_id.x;\n\n    let qOffset = uniforms.M * uniforms.K * headIdx + m * uniforms.K;\n    let kOffset = uniforms.kv_sequence_length * uniforms.K * headIdx + n * uniforms.K;\n\n    var value = ${Ze(z,a)};\n    for (var w: u32 = 0u; w < uniforms.K; w += TILE_SIZE) {\n      if (m + local_id.y < uniforms.M && w + local_id.x < uniforms.K) {\n        tileQ[TILE_SIZE * local_id.y + local_id.x] = q[qOffset + local_id.y * uniforms.K + w + local_id.x];\n      }\n      if (n + local_id.y < uniforms.N && w + local_id.x < uniforms.K) {\n        tileK[TILE_SIZE * local_id.y + local_id.x] = key[kOffset + local_id.y * uniforms.K + w + local_id.x];\n      }\n      workgroupBarrier();\n\n      for (var k: u32 = 0u; k<TILE_SIZE && w+k < uniforms.K; k++) {\n        value += tileQ[TILE_SIZE * local_id.y + k] * tileK[TILE_SIZE * local_id.x + k];\n      }\n\n      workgroupBarrier();\n    }\n\n    let headOffset = headIdx * uniforms.M * uniforms.N;\n    if (lm < uniforms.M && ln < uniforms.N) {\n      let outputIdx = headOffset + lm * uniforms.N + ln;\n      output[outputIdx] = ${Je("value",a)} * uniforms.alpha;\n    }\n  }`},I=e.compute({name:"AttentionProbs",shaderCache:{hint:`${a}`,inputDependencies:["type","type"]},getRunData:()=>({outputs:[{dims:u,dataType:t.dataType,gpuDataType:0}],dispatchGroup:g,programUniforms:w}),getShaderSource:_},{inputs:y,outputs:[-1]})[0];return Vd(e,I,n.batchSize*n.numHeads*n.sequenceLength,n.totalSequenceLength),I},Wd=(e,t,r,o)=>{let n=[o.batchSize,o.sequenceLength,o.vHiddenSize],s=12,u={x:Math.ceil(o.vHeadSize/s),y:Math.ceil(o.sequenceLength/s),z:o.batchSize*o.numHeads},l=[{type:"uint32",data:o.sequenceLength},{type:"uint32",data:o.totalSequenceLength},{type:"uint32",data:o.vHeadSize},{type:"uint32",data:o.numHeads},{type:"uint32",data:o.vHiddenSize}],a=p=>{let h=M("probs",t.dataType,t.dims),g=M("v",r.dataType,r.dims),b=F("output",t.dataType,n),w=[{name:"M",type:"u32"},{name:"K",type:"u32"},{name:"N",type:"u32"},{name:"num_heads",type:"u32"},{name:"v_hidden_size",type:"u32"}];return`\n  const TILE_SIZE = ${s}u;\n  var<workgroup> tileQ: array<${h.type.value}, ${s*s}>;\n  var<workgroup> tileK: array<${h.type.value}, ${s*s}>;\n  ${p.registerUniforms(w).declareVariables(h,g,b)}\n  ${p.mainStart([s,s,1])}\n   let headIdx = workgroup_id.z;\n   let m = workgroup_id.y * TILE_SIZE + local_id.y;\n   let n = workgroup_id.x * TILE_SIZE + local_id.x;\n\n   let offsetA = headIdx * (uniforms.M * uniforms.K) + m * uniforms.K;\n   let offsetB = headIdx * (uniforms.N * uniforms.K) + n;\n\n   var value = ${h.type.storage}(0);\n   for (var w: u32 = 0u; w < uniforms.K; w += TILE_SIZE) {\n     if (m < uniforms.M && w + local_id.x < uniforms.K) {\n       tileQ[TILE_SIZE * local_id.y + local_id.x] = probs[offsetA + w + local_id.x];\n     }\n     if (n < uniforms.N && w + local_id.y < uniforms.K) {\n       tileK[TILE_SIZE * local_id.y + local_id.x] = v[offsetB + (w + local_id.y) * uniforms.N];\n     }\n     workgroupBarrier();\n     for (var k: u32 = 0u; k<TILE_SIZE && w+k < uniforms.K; k++) {\n       value += tileQ[TILE_SIZE * local_id.y + k] * tileK[TILE_SIZE * k + local_id.x];\n     }\n     workgroupBarrier();\n   }\n\n   // we need to transpose output from BNSH_v to BSND_v\n   let batchIdx = workgroup_id.z / uniforms.num_heads;\n   let currentBatchHeadNumber = workgroup_id.z % uniforms.num_heads;\n   let headOffset = (batchIdx * uniforms.M * uniforms.num_heads + currentBatchHeadNumber) * uniforms.N;\n   if (m < uniforms.M && n < uniforms.N) {\n     let outputIdx = batchIdx * uniforms.M *uniforms.v_hidden_size + m * uniforms.v_hidden_size\n       + currentBatchHeadNumber * uniforms.N + n;\n     output[outputIdx] = value;\n   }\n  }`};return e.compute({name:"AttentionScore",shaderCache:{inputDependencies:["type","type"]},getRunData:()=>({outputs:[{dims:n,dataType:t.dataType,gpuDataType:0}],dispatchGroup:u,programUniforms:l}),getShaderSource:a},{inputs:[t,r],outputs:[0]})[0]},Kr=(e,t,r,o,n,s,u,l,a,p,h)=>{let g=Nd(e,t,r,a,p,h);Wd(e,g,o,p)},Hd=(e,t)=>{let r=[t.batchSize,t.numHeads,t.sequenceLength,t.headSize],o=t.sequenceLength,n=t.inputHiddenSize,s=t.headSize,u=12,l={x:Math.ceil(t.headSize/u),y:Math.ceil(t.sequenceLength/u),z:t.batchSize*t.numHeads},a=[e.inputs[0],e.inputs[1],e.inputs[2]],p=[{type:"uint32",data:o},{type:"uint32",data:n},{type:"uint32",data:s},{type:"uint32",data:t.numHeads},{type:"uint32",data:t.headSize},{type:"uint32",data:t.hiddenSize},{type:"uint32",data:t.hiddenSize+t.hiddenSize+t.vHiddenSize}],h=g=>{let b=F("output_q",a[0].dataType,r),w=F("output_k",a[0].dataType,r),y=F("output_v",a[0].dataType,r),_=M("input",a[0].dataType,a[0].dims),I=M("weight",a[1].dataType,a[1].dims),$=M("bias",a[2].dataType,a[2].dims),x=_.type.storage,E=[{name:"M",type:"u32"},{name:"K",type:"u32"},{name:"N",type:"u32"},{name:"num_heads",type:"u32"},{name:"head_size",type:"u32"},{name:"hidden_size",type:"u32"},{name:"ldb",type:"u32"}];return`\n  const TILE_SIZE = ${u}u;\n  var<workgroup> tileInput: array<${x}, ${u*u}>;\n  var<workgroup> tileWeightQ: array<${x}, ${u*u}>;\n  var<workgroup> tileWeightK: array<${x}, ${u*u}>;\n  var<workgroup> tileWeightV: array<${x}, ${u*u}>;\n  ${g.registerUniforms(E).declareVariables(_,I,$,b,w,y)}\n  ${g.mainStart([u,u,1])}\n    let batchIndex = workgroup_id.z / uniforms.num_heads;\n    let headNumber = workgroup_id.z % uniforms.num_heads;\n    let m = workgroup_id.y * TILE_SIZE + local_id.y;\n    let n = workgroup_id.x * TILE_SIZE + local_id.x;\n\n    let inputOffset = batchIndex * (uniforms.M * uniforms.K) + m * uniforms.K;\n    let biasOffsetQ = headNumber * uniforms.head_size;\n    let biasOffsetK = uniforms.hidden_size + biasOffsetQ;\n    let biasOffsetV = uniforms.hidden_size + biasOffsetK;\n\n    var valueQ = ${x}(0);\n    var valueK = ${x}(0);\n    var valueV = ${x}(0);\n    for (var w: u32 = 0u; w < uniforms.K; w += TILE_SIZE) {\n      if (m < uniforms.M && w + local_id.x < uniforms.K) {\n        tileInput[TILE_SIZE * local_id.y + local_id.x] = input[inputOffset + w + local_id.x];\n      }\n      if (n < uniforms.N && w + local_id.y < uniforms.K) {\n        let offset = n + (w + local_id.y) * uniforms.ldb;\n        tileWeightQ[TILE_SIZE * local_id.y + local_id.x] = weight[biasOffsetQ + offset];\n        tileWeightK[TILE_SIZE * local_id.y + local_id.x] = weight[biasOffsetK + offset];\n        tileWeightV[TILE_SIZE * local_id.y + local_id.x] = weight[biasOffsetV + offset];\n      }\n      workgroupBarrier();\n      for (var k: u32 = 0u; k<TILE_SIZE && w+k < uniforms.K; k++) {\n        let inputTileOffset = TILE_SIZE * local_id.y + k;\n        let weightTileOffset = TILE_SIZE * k + local_id.x;\n        valueQ += tileInput[inputTileOffset] * tileWeightQ[weightTileOffset];\n        valueK += tileInput[inputTileOffset] * tileWeightK[weightTileOffset];\n        valueV += tileInput[inputTileOffset] * tileWeightV[weightTileOffset];\n      }\n\n      workgroupBarrier();\n    }\n\n    let headOffset = (m * uniforms.N + n) % uniforms.head_size;\n    valueQ += bias[headOffset + biasOffsetQ];\n    valueK += bias[headOffset + biasOffsetK];\n    valueV += bias[headOffset + biasOffsetV];\n\n    let offset = workgroup_id.z * uniforms.M * uniforms.N;\n    if (m < uniforms.M && n < uniforms.N) {\n      let outputIdx = offset + m * uniforms.N + n;\n      output_q[outputIdx] = valueQ;\n      output_k[outputIdx] = valueK;\n      output_v[outputIdx] = valueV;\n    }\n  }`};return e.compute({name:"AttentionPrepare",shaderCache:{inputDependencies:["type","type","type"]},getRunData:()=>({outputs:[{dims:r,dataType:e.inputs[0].dataType,gpuDataType:0},{dims:r,dataType:e.inputs[0].dataType,gpuDataType:0},{dims:r,dataType:e.inputs[0].dataType,gpuDataType:0}],dispatchGroup:l,programUniforms:p}),getShaderSource:h},{inputs:a,outputs:[-1,-1,-1]})},Ha=(e,t)=>{let r=Ud(e.inputs,t),[o,n,s]=Hd(e,r);return Kr(e,o,n,s,e.inputs[4],void 0,void 0,void 0,e.inputs[5],r,t)}});var Gd,Ld,Fd,Ga,La=j(()=>{"use strict";Lt();$e();je();ve();Gd=(e,t)=>{if(!e||e.length!==5)throw new Error("BatchNormalization requires 5 inputs");let r=(o,n,s)=>{let u=n.length;if(u!==o.length)throw new Error(`${s}: num dimensions != ${u}`);n.forEach((l,a)=>{if(l!==o[a])throw new Error(`${s}: dim[${a}] do not match`)})};if(e[0].dims.length>1){let o=t.format==="NHWC"?t.spatial?e[0].dims.slice(-1):e[0].dims.slice(-1).concat(e[0].dims.slice(1,e[0].dims.length-1)):e[0].dims.slice(1,t.spatial?2:void 0);r(e[1].dims,o,"Invalid input scale"),r(e[2].dims,o,"Invalid input B"),r(e[3].dims,o,"Invalid input mean"),r(e[4].dims,o,"Invalid input var")}else r(e[1].dims,[1],"Invalid input scale"),r(e[2].dims,[1],"Invalid input B"),r(e[3].dims,[1],"Invalid input mean"),r(e[4].dims,[1],"Invalid input var")},Ld=(e,t)=>{let{epsilon:r,spatial:o,format:n}=t,s=e[0].dims,u=o?Fe(s[s.length-1]):1,l=n==="NHWC"&&s.length>1?u:1,a=U.size(s)/u,p=Re(s.length)&&o,h=p?s.length:s,g=M("x",e[0].dataType,e[0].dims,u),b=M("scale",e[1].dataType,e[1].dims,l),w=M("bias",e[2].dataType,e[2].dims,l),y=M("inputMean",e[3].dataType,e[3].dims,l),_=M("inputVar",e[4].dataType,e[4].dims,l),I=F("y",e[0].dataType,h,u),$=()=>{let E="";if(o)E=`let cOffset = ${s.length===1?"0u":n==="NHWC"?`outputIndices[${s.length-1}] / ${u}`:"outputIndices[1]"};`;else if(n==="NCHW")E=`\n            ${I.indicesSet("outputIndices","0","0")}\n            let cOffset = ${I.indicesToOffset("outputIndices")};`;else{E=`var cIndices = ${b.type.indices}(0);\n                       cIndices[0] = outputIndices[${s.length-1}];`;for(let A=1;A<b.rank;A++)E+=`cIndices[${A}] = outputIndices[${A}];`;E+=`let cOffset = ${b.indicesToOffset("cIndices")};`}return E},x=E=>`\n  const epsilon = ${r};\n  ${E.registerUniform("outputSize","u32").declareVariables(g,b,w,y,_,I)}\n  ${E.mainStart()}\n  ${E.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n    var outputIndices = ${I.offsetToIndices(`global_idx * ${u}`)};\n    ${$()}\n    let scale = ${b.getByOffset("cOffset")};\n    let bias = ${w.getByOffset("cOffset")};\n    let inputMean = ${y.getByOffset("cOffset")};\n    let inputVar = ${_.getByOffset("cOffset")};\n    let x = ${g.getByOffset("global_idx")};\n    let value = (x - inputMean) * inverseSqrt(inputVar + epsilon) * scale + bias;\n    ${I.setByOffset("global_idx","value")}\n  }`;return{name:"BatchNormalization",shaderCache:{hint:`${t.epsilon}_${t.format}_${o}_${u}`,inputDependencies:p?["rank","type","type","type","type"]:void 0},getShaderSource:x,getRunData:()=>({outputs:[{dims:e[0].dims,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(a/64)},programUniforms:p?[{type:"uint32",data:a},...L(s)]:[{type:"uint32",data:a}]})}},Fd=e=>ge(e),Ga=(e,t)=>{let{inputs:r,outputCount:o}=e,n=Fd({...t,outputCount:o});if(Gt.webgpu.validateInputContent&&Gd(r,n),t.trainingMode)throw new Error("BatchNormalization trainingMode is not supported yet.");e.compute(Ld(r,n))}});var jd,qd,Fa,ja=j(()=>{"use strict";$e();ve();jd=e=>{if(e[0].dims.length!==3)throw new Error("input should have 3 dimensions");if(![320,640,1280].includes(e[0].dims[2]))throw new Error("number of channels should be 320, 640 or 1280");if(e[1].dims.length!==1)throw new Error("bias is expected to have 1 dimensions");if(e[0].dims[2]!==e[1].dims[0])throw new Error("last dimension of input and bias are not the same")},qd=e=>{let t=e[0].dims,r=e[0].dims[2],o=U.size(t)/4,n=e[0].dataType,s=M("input",n,t,4),u=M("bias",n,[r],4),l=M("residual",n,t,4),a=F("output",n,t,4);return{name:"BiasAdd",getRunData:()=>({outputs:[{dims:t,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(o/64)}}),getShaderSource:h=>`\n  const channels = ${r}u / 4;\n  ${h.declareVariables(s,u,l,a)}\n\n  ${h.mainStart()}\n    ${h.guardAgainstOutOfBoundsWorkgroupSizes(o)}\n    let value = ${s.getByOffset("global_idx")}\n      + ${u.getByOffset("global_idx % channels")} + ${l.getByOffset("global_idx")};\n    ${a.setByOffset("global_idx","value")}\n  }`}},Fa=e=>{jd(e.inputs),e.compute(qd(e.inputs))}});var Kd,Ae,qa,Ka,Ya,Za,Qa,Xa,Ja,ei,ti,Yd,ri,ni,oi,ai,Yr,ii,Zr,si,ui,di,li,ci,pi,mi,fi,hi,gi,yi,bi,wi,vi,$i,Si,xi,Vn=j(()=>{"use strict";Ne();$e();je();ve();Kd=(e,t,r,o,n,s)=>{let u=Math.ceil(t/4),l="";typeof n=="string"?l=`${n}(a)`:l=n("a");let a=M("inputData",r,[u],4),p=F("outputData",o,[u],4);return`\n      ${e.registerUniform("vec_size","u32").declareVariables(a,p)}\n\n  ${s??""}\n\n  ${e.mainStart()}\n    ${e.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}\n\n    let a = ${a.getByOffset("global_idx")};\n    ${p.setByOffset("global_idx",l)}\n  }`},Ae=(e,t,r,o,n,s=e.dataType)=>({name:t,shaderCache:{hint:n,inputDependencies:["type"]},getShaderSource:u=>Kd(u,U.size(e.dims),e.dataType,s,r,o),getRunData:u=>({outputs:[{dims:e.dims,dataType:s}],dispatchGroup:{x:Math.ceil(U.size(u[0].dims)/64/4)},programUniforms:[{type:"uint32",data:Math.ceil(U.size(e.dims)/4)}]})}),qa=e=>{e.compute(Ae(e.inputs[0],"Abs","abs"))},Ka=e=>{e.compute(Ae(e.inputs[0],"Acos","acos"))},Ya=e=>{e.compute(Ae(e.inputs[0],"Acosh","acosh"))},Za=e=>{e.compute(Ae(e.inputs[0],"Asin","asin"))},Qa=e=>{e.compute(Ae(e.inputs[0],"Asinh","asinh"))},Xa=e=>{e.compute(Ae(e.inputs[0],"Atan","atan"))},Ja=e=>{e.compute(Ae(e.inputs[0],"Atanh","atanh"))},ei=e=>ge(e),ti=(e,t)=>{let r;switch(t.to){case 10:r="vec4<f16>";break;case 1:r="vec4<f32>";break;case 12:r="vec4<u32>";break;case 6:r="vec4<i32>";break;case 9:r="vec4<bool>";break;default:throw new RangeError(`not supported type (specified in attribute \'to\' from \'Cast\' operator): ${t.to}`)}e.compute(Ae(e.inputs[0],"Cast",r,void 0,t.cacheKey,t.to))},Yd=e=>{let t=e.length>=2&&e[1].data!==0?e[1].getFloat32Array()[0]:Gr,r=e.length>=3&&e[2].data!==0?e[2].getFloat32Array()[0]:Lr;return ge({min:t,max:r})},ri=(e,t)=>{let r=e.inputs.length===1?t:Yd(e.inputs),o=lt(e.inputs[0].dataType);e.compute(Ae(e.inputs[0],"Clip",n=>`clamp(${n}, clip_min_, clip_max_)`,`\n    const clip_min_: vec4<${o}> = vec4(${o}(${r.min}));\n    const clip_max_: vec4<${o}> = vec4(${o}(${r.max}));\n`,r.cacheKey),{inputs:[0]})},ni=e=>{e.compute(Ae(e.inputs[0],"Ceil","ceil"))},oi=e=>{e.compute(Ae(e.inputs[0],"Cos","cos"))},ai=e=>{e.compute(Ae(e.inputs[0],"Cosh","cosh"))},Yr=e=>ge(e),ii=(e,t)=>{let r=lt(e.inputs[0].dataType);e.compute(Ae(e.inputs[0],"Elu",o=>`elu_vf32(${o})`,`\n  const elu_alpha_ = ${r}(${t.alpha});\n\n  fn elu_f32(a: ${r}) -> ${r} {\n  return select((exp(a) - 1.0) * elu_alpha_, a, a >= 0.0);\n  }\n\n  fn elu_vf32(v: vec4<${r}>) -> vec4<${r}> {\n  return vec4(elu_f32(v.x), elu_f32(v.y), elu_f32(v.z), elu_f32(v.w));\n  }`,t.cacheKey))},Zr=(e,t="f32")=>`\nconst r0: ${t} = 0.3275911;\nconst r1: ${t} = 0.254829592;\nconst r2: ${t} = -0.284496736;\nconst r3: ${t} = 1.421413741;\nconst r4: ${t} = -1.453152027;\nconst r5: ${t} = 1.061405429;\n\nfn erf_vf32(v: ${e}) -> ${e} {\n  let absv = abs(v);\n  let x = 1.0 / (1.0 + r0 * absv);\n  return sign(v) * (1.0 - ((((r5 * x + r4) * x + r3) * x + r2) * x + r1) * x * exp(-absv * absv));\n}`,si=e=>{let t=lt(e.inputs[0].dataType);e.compute(Ae(e.inputs[0],"Erf",r=>`erf_vf32(${r})`,Zr(`vec4<${t}>`,t)))},ui=e=>{e.compute(Ae(e.inputs[0],"Exp","exp"))},di=e=>{e.compute(Ae(e.inputs[0],"Floor","floor"))},li=e=>{let t=lt(e.inputs[0].dataType);e.compute(Ae(e.inputs[0],"Gelu",r=>`0.5 * ${r} * (1.0 + erf_vf32(${r} * 0.7071067811865475))`,Zr(`vec4<${t}>`,t)))},ci=(e,t)=>{let r=lt(e.inputs[0].dataType);e.compute(Ae(e.inputs[0],"LeakyRelu",o=>`select(leaky_relu_alpha_ * ${o}, ${o}, ${o} >= vec4<${r}>(0.0))`,`const leaky_relu_alpha_ = ${r}(${t.alpha});`,t.cacheKey))},pi=e=>{e.compute(Ae(e.inputs[0],"Not",t=>`!${t}`))},mi=e=>{e.compute(Ae(e.inputs[0],"Neg",t=>`-${t}`))},fi=e=>{e.compute(Ae(e.inputs[0],"Reciprocal",t=>`1.0/${t}`))},hi=e=>{let t=lt(e.inputs[0].dataType);e.compute(Ae(e.inputs[0],"Relu",r=>`select(vec4<${t}>(0.0), ${r}, ${r} > vec4<${t}>(0.0))`))},gi=e=>{e.compute(Ae(e.inputs[0],"Sigmoid",t=>`(1.0 / (1.0 + exp(-${t})))`))},yi=e=>{e.compute(Ae(e.inputs[0],"Sin","sin"))},bi=e=>{e.compute(Ae(e.inputs[0],"Sinh","sinh"))},wi=e=>{e.compute(Ae(e.inputs[0],"Sqrt","sqrt"))},vi=e=>{e.compute(Ae(e.inputs[0],"Tan","tan"))},$i=e=>{e.compute(Ae(e.inputs[0],"Tanh","tanh"))},Si=(e,t)=>{let r=lt(e.inputs[0].dataType);return e.compute(Ae(e.inputs[0],"ThresholdedRelu",o=>`select(vec4<${r}>(0.0), ${o}, ${o} > thresholded_relu_alpha_)`,`const thresholded_relu_alpha_ = vec4<${r}>(${t.alpha});`,t.cacheKey)),0},xi=e=>{e.compute(Ae(e.inputs[0],"Log","log"))}});var Qd,Xd,_i,Ci=j(()=>{"use strict";$e();ve();Vn();Qd=e=>{if(e[0].dims.length!==3)throw new Error("input should have 3 dimensions");if(![2560,5120,10240].includes(e[0].dims[2]))throw new Error("hidden state should be 2560, 5120 or 10240");if(e[1].dims.length!==1)throw new Error("bias is expected to have 1 dimensions");if(e[0].dims[2]!==e[1].dims[0])throw new Error("last dimension of input and bias are not the same")},Xd=e=>{let t=e[0].dims.slice();t[2]=t[2]/2;let r=M("input",e[0].dataType,e[0].dims,4),o=M("bias",e[0].dataType,[e[0].dims[2]],4),n=F("output",e[0].dataType,t,4),s=U.size(t)/4,u=Le(e[0].dataType);return{name:"BiasSplitGelu",getRunData:()=>({outputs:[{dims:t,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(s/64)}}),getShaderSource:a=>`\n  const M_SQRT2 = sqrt(2.0);\n  const halfChannels = ${e[0].dims[2]/4/2}u;\n\n  ${a.declareVariables(r,o,n)}\n\n  ${Zr(`vec4<${u}>`,u)}\n\n  ${a.mainStart()}\n    ${a.guardAgainstOutOfBoundsWorkgroupSizes(s)}\n    let biasIdx = global_idx % halfChannels;\n    let batchIndex = global_idx / halfChannels;\n    let inputOffset = biasIdx + batchIndex * halfChannels * 2;\n    let valueLeft = input[inputOffset] + bias[biasIdx];\n    let valueRight = input[inputOffset + halfChannels] + bias[biasIdx + halfChannels];\n    let geluRight = valueRight * 0.5 * (erf_vf32(valueRight / M_SQRT2) + 1);\n\n    ${n.setByOffset("global_idx","valueLeft * geluRight")}\n  }`}},_i=e=>{Qd(e.inputs),e.compute(Xd(e.inputs))}});var Jd,el,ht,Ii,Ai,Ti,Ei,Oi,Pi,ki,Ri,Bi,Di,Mi=j(()=>{"use strict";Ne();$e();ve();Jd=(e,t,r,o,n,s,u,l,a,p,h,g,b)=>{let w,y;typeof l=="string"?w=y=(R,V)=>`${l}((${R}),(${V}))`:typeof l=="function"?w=y=l:(w=l.scalar,y=l.vector);let _=g?t.length:t,I=g?r.length:r,$=g?o.length:o,x=F("outputData",h,$,4),E=M("aData",a,_,4),A=M("bData",p,I,4),z;if(n)if(s){let R=U.size(t)===1,V=U.size(r)===1,T=t.length>0&&t[t.length-1]%4===0,N=r.length>0&&r[r.length-1]%4===0;R||V?z=x.setByOffset("global_idx",y(R?`${E.type.value}(${E.getByOffset("0")}.x)`:E.getByOffset("global_idx"),V?`${A.type.value}(${A.getByOffset("0")}.x)`:A.getByOffset("global_idx"))):z=`\n            let outputIndices = ${x.offsetToIndices("global_idx * 4u")};\n            let offsetA = ${E.broadcastedIndicesToOffset("outputIndices",x)};\n            let offsetB = ${A.broadcastedIndicesToOffset("outputIndices",x)};\n            ${x.setByOffset("global_idx",y(u||T?E.getByOffset("offsetA / 4u"):`${E.type.value}(${E.getByOffset("offsetA / 4u")}[offsetA % 4u])`,u||N?A.getByOffset("offsetB / 4u"):`${A.type.value}(${A.getByOffset("offsetB / 4u")}[offsetB % 4u])`))}\n          `}else z=x.setByOffset("global_idx",y(E.getByOffset("global_idx"),A.getByOffset("global_idx")));else{if(!s)throw new Error("no necessary to use scalar implementation for element-wise binary op implementation.");let R=(V,T,N="")=>{let te=`aData[indexA${T}][componentA${T}]`,Y=`bData[indexB${T}][componentB${T}]`;return`\n            let outputIndices${T} = ${x.offsetToIndices(`global_idx * 4u + ${T}u`)};\n            let offsetA${T} = ${E.broadcastedIndicesToOffset(`outputIndices${T}`,x)};\n            let offsetB${T} = ${A.broadcastedIndicesToOffset(`outputIndices${T}`,x)};\n            let indexA${T} = offsetA${T} / 4u;\n            let indexB${T} = offsetB${T} / 4u;\n            let componentA${T} = offsetA${T} % 4u;\n            let componentB${T} = offsetB${T} % 4u;\n            ${V}[${T}] = ${N}(${w(te,Y)});\n          `};h===9?z=`\n            var data = vec4<u32>(0);\n            ${R("data",0,"u32")}\n            ${R("data",1,"u32")}\n            ${R("data",2,"u32")}\n            ${R("data",3,"u32")}\n            outputData[global_idx] = dot(vec4<u32>(0x1, 0x100, 0x10000, 0x1000000), vec4<u32>(data));`:z=`\n            ${R("outputData[global_idx]",0)}\n            ${R("outputData[global_idx]",1)}\n            ${R("outputData[global_idx]",2)}\n            ${R("outputData[global_idx]",3)}\n          `}return`\n        ${e.registerUniform("vec_size","u32").declareVariables(E,A,x)}\n\n        ${b??""}\n\n        ${e.mainStart()}\n        ${e.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}\n        ${z}\n      }`},el=(e,t,r,o,n,s,u=r.dataType)=>{let l=!U.areEqual(r.dims,o.dims),a=r.dims,p=U.size(r.dims),h=!1,g=!1,b=[l];if(l){let y=dt.calcShape(r.dims,o.dims,!1);if(!y)throw new Error("Can\'t perform binary op on the given tensors");a=y,p=U.size(a);let _=U.size(r.dims)===1,I=U.size(o.dims)===1,$=r.dims.length>0&&r.dims[r.dims.length-1]%4===0,x=o.dims.length>0&&o.dims[o.dims.length-1]%4===0;b.push(_),b.push(I),b.push($),b.push(x);let E=1;for(let A=1;A<a.length;A++){let z=r.dims[r.dims.length-A]??1,R=o.dims[o.dims.length-A]??1;if(z===R)E*=z;else break}E%4===0?(g=!0,h=!0):(_||I||$||x)&&(h=!0)}else h=!0;b.push(h);let w=Re(r.dims.length)&&Re(o.dims.length)&&Re(a.length);return{name:e,shaderCache:{hint:t+b.map(y=>y.toString()).join("_"),inputDependencies:w?["rank","rank"]:["dims","dims"]},getShaderSource:y=>Jd(y,r.dims,o.dims,a,h,l,g,n,r.dataType,o.dataType,u,w,s),getRunData:()=>({outputs:[{dims:a,dataType:u}],dispatchGroup:{x:Math.ceil(p/64/4)},programUniforms:w?[{type:"uint32",data:Math.ceil(U.size(a)/4)},...L(r.dims),...L(o.dims),...L(a)]:[{type:"uint32",data:Math.ceil(U.size(a)/4)}]})}},ht=(e,t,r,o,n,s)=>{e.compute(el(t,n??"",e.inputs[0],e.inputs[1],r,o,s))},Ii=e=>{ht(e,"Add",(t,r)=>`${t}+${r}`)},Ai=e=>{ht(e,"Div",(t,r)=>`${t}/${r}`)},Ti=e=>{ht(e,"Equal",{scalar:(t,r)=>`u32(${t}==${r})`,vector:(t,r)=>`vec4<u32>(${t}==${r})`},void 0,void 0,9)},Ei=e=>{ht(e,"Mul",(t,r)=>`${t}*${r}`)},Oi=e=>{let t=M("input",e.inputs[0].dataType,e.inputs[0].dims).type.value;ht(e,"Pow",{scalar:(o,n)=>`pow_custom(${o},${n})`,vector:(o,n)=>`pow_vector_custom(${o},${n})`},`\n    fn pow_custom(a : ${t}, b : ${t}) -> ${t} {\n      if (b == ${t}(0.0)) {\n        return ${t}(1.0);\n      } else if (a < ${t}(0.0) && f32(b) != floor(f32(b))) {\n        return ${t}(pow(f32(a), f32(b))); // NaN\n      }\n      return select(sign(a), ${t}(1.0), round(f32(abs(b) % ${t}(2.0))) != 1.0) * ${t}(${t==="i32"?"round":""}(pow(f32(abs(a)), f32(b))));\n    }\n    fn pow_vector_custom(a : vec4<${t}>, b : vec4<${t}>) -> vec4<${t}> {\n      // TODO: implement vectorized pow\n      return vec4<${t}>(pow_custom(a.x, b.x), pow_custom(a.y, b.y), pow_custom(a.z, b.z), pow_custom(a.w, b.w));\n    }\n      `)},Pi=e=>{ht(e,"Sub",(t,r)=>`${t}-${r}`)},ki=e=>{ht(e,"Greater",{scalar:(t,r)=>`u32(${t}>${r})`,vector:(t,r)=>`vec4<u32>(${t}>${r})`},void 0,void 0,9)},Ri=e=>{ht(e,"Less",{scalar:(t,r)=>`u32(${t}<${r})`,vector:(t,r)=>`vec4<u32>(${t}<${r})`},void 0,void 0,9)},Bi=e=>{ht(e,"GreaterOrEqual",{scalar:(t,r)=>`u32(${t}>=${r})`,vector:(t,r)=>`vec4<u32>(${t}>=${r})`},void 0,void 0,9)},Di=e=>{ht(e,"LessOrEqual",{scalar:(t,r)=>`u32(${t}<=${r})`,vector:(t,r)=>`vec4<u32>(${t}<=${r})`},void 0,void 0,9)}});var rl,nl,ol,al,zi,Ui,Vi=j(()=>{"use strict";$e();je();ve();rl=e=>{if(!e||e.length<1)throw new Error("too few inputs");let t=e[0].dataType,r=e[0].dims.length;for(let o of e){if(o.dataType!==t)throw new Error("input tensors should be one type");if(o.dims.length!==r)throw new Error("input tensors should have the same shape")}},nl=(e,t)=>`\n  fn calculateInputIndex(index: u32) -> u32 {\n    let sizeInConcatAxis = array<u32, ${e}u>(${t});\n    for (var i: u32 = 0u; i < ${e}; i += 1u ) {\n      if (index < sizeInConcatAxis[i]) {\n        return i;\n      }\n    }\n    return ${e}u;\n  }`,ol=(e,t)=>{let r=e.length,o=[];for(let n=0;n<r;++n){let s=t.setByOffset("global_idx",e[n].getByIndices("indices"));r===1?o.push(s):n===0?o.push(`if (inputIndex == ${n}u) { ${s} }`):n===r-1?o.push(`else { ${s} }`):o.push(`else if (inputIndex == ${n}) { ${s} }`)}return o.join(`\n`)},al=(e,t)=>{let r=e[0].dims.slice();if(t>=r.length||t<-1*r.length)throw new Error("axis specified for concat doesn\'t match input dimensionality");let o=t<0?r.length+t:t,n=r.slice(0);for(let A=1;A<e.length;A++){let z=e[A].dims.slice();for(let R=0;R<r.length;R++)if(R===o)n[o]+=z[R];else if(r[R]!==z[R])throw new Error("non concat dimensions must match")}let s=U.size(n),u=new Array(e.length),l=new Array(e.length),a=e[0].dataType,p=0,h=[],g=[],b=[],w=[{type:"uint32",data:s}];for(let A=0;A<e.length;++A)p+=e[A].dims[o],u[A]=p,b.push(Re(e[A].dims.length)),g.push(b[A]?e[A].dims.length:e[A].dims),l[A]=M(`input${A}`,a,g[A]),h.push(b[A]?"rank":"dims"),w.push({type:"uint32",data:u[A]});for(let A=0;A<e.length;++A)b[A]&&w.push(...L(e[A].dims));let y=Re(n.length);y&&w.push(...L(n));let _=y?n.length:n,I=F("output",a,_),$=I.indicesGet("indices",o),x=Array.from(Array(u.length).keys()).map(A=>`uniforms.sizeInConcatAxis${A}`).join(","),E=A=>`\n\n  ${(()=>{A.registerUniform("outputSize","u32");for(let z=0;z<e.length;z++)A.registerUniform(`sizeInConcatAxis${z}`,"u32");return A.declareVariables(...l,I)})()}\n\n  ${nl(u.length,x)}\n\n  ${A.mainStart()}\n    ${A.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n\n    var indices = ${I.offsetToIndices("global_idx")};\n\n    let inputIndex = calculateInputIndex(${$});\n    if (inputIndex != 0u) {\n      let sizeInConcatAxis = array<u32, ${u.length}u>(${x});\n      ${$} -= sizeInConcatAxis[inputIndex - 1u];\n    }\n\n    ${ol(l,I)}\n  }`;return{name:"Concat",shaderCache:{hint:`${t}`,inputDependencies:h},getRunData:()=>({outputs:[{dims:n,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(s/64)},programUniforms:w}),getShaderSource:E}},zi=(e,t)=>{rl(e.inputs),e.compute(al(e.inputs,t.axis))},Ui=e=>ge({axis:e.axis})});var gt,Qr,It=j(()=>{"use strict";$e();gt=(e,t)=>{switch(e.activation){case"Relu":return{activationFunction:"",applyActivation:`value = max(value, ${t}(0.0));`};case"Sigmoid":return{activationFunction:"",applyActivation:`value = (${t}(1.0) / (${t}(1.0) + exp(-value)));`};case"Clip":return{activationFunction:`const clip_min_=${t}(${e.clipMin});const clip_max_=${t}(${e.clipMax});`,applyActivation:"value = clamp(value, clip_min_, clip_max_);"};default:return{activationFunction:"",applyActivation:""}}},Qr=e=>{let t=e?.activation||"";if(t==="Clip"){let[r,o]=e?.activation_params||[Gr,Lr];return{activation:t,clipMax:o,clipMin:r,activationCacheKey:`${t}:${r},${o}`}}return{activation:t,activationCacheKey:t}}});var Ke,Xr,Jr=j(()=>{"use strict";Ke=(e,t)=>{switch(e){case 1:return t;case 2:return`vec2<${t}>`;case 3:return`vec3<${t}>`;case 4:return`vec4<${t}>`;default:throw new Error(`${e}-component is not supported.`)}},Xr=e=>`\n      ${e?"value = value + getBiasByOutputCoords(coords);":""}\n      `});var en,Nn=j(()=>{"use strict";en=e=>`\nfn getIndexFromCoords4D(coords : vec4<i32>, shape : vec4<i32>) -> i32 {\n  return dot(coords, vec4<i32>(\n      shape.y * shape.z * shape.w, shape.z * shape.w, shape.w, 1));\n}\nfn getOutputIndexFromCoords(coords : vec4<i32>) -> i32 {\n  return dot(coords, vec4<i32>(\n    i32(${e}.x), i32(${e}.y), i32(${e}.z), 1));\n}\n`});var il,sl,mr,Ni,ul,fr,dl,tn,hr=j(()=>{"use strict";$e();ve();It();Jr();il=(e,t)=>e?`\n        mm_Asub[inputRow][inputCol] = mm_readA(batch,\n          kStart + inputRow,\n          globalRowStart / innerElementSize + inputCol${t?", batchIndices":""});\n        `:`\n        mm_Asub[inputRow][inputCol] = mm_readA(batch,\n          globalRow + innerRow,\n          kStart / innerElementSize + inputCol${t?", batchIndices":""});\n        `,sl=(e,t)=>e?`\n        let ACached0 = mm_Asub[k * innerElementSize][localRow];\n        let ACached1 = mm_Asub[k * innerElementSize + 1][localRow];\n        let ACached2 = mm_Asub[k * innerElementSize + 2][localRow];\n        ${t===3?"":"let ACached3 = mm_Asub[k * innerElementSize + 3][localRow];"}\n        for (var i = 0; i < rowPerThread; i = i + 1) {\n          acc[i] = BCached0 * ACached0[i] + acc[i];\n          acc[i] = BCached1 * ACached1[i] + acc[i];\n          acc[i] = BCached2 * ACached2[i] + acc[i];\n          ${t===3?"":"acc[i] = BCached3 * ACached3[i] + acc[i];"}\n        }`:`\n        for (var i = 0; i < rowPerThread; i = i + 1) {\n          let ACached = mm_Asub[tileRow + i][k];\n          acc[i] = BCached0 * ACached.x + acc[i];\n          acc[i] = BCached1 * ACached.y + acc[i];\n          acc[i] = BCached2 * ACached.z + acc[i];\n          ${t===3?"":"acc[i] = BCached3 * ACached.w + acc[i];"}\n        }`,mr=(e,t,r="f32",o,n=!1,s=32,u=!1,l=32)=>{let a=t[1]*e[1],p=t[0]*e[0],h=n?a:s,g=n?s:a,b=h/t[0],w=s/t[1];if(!((n&&b===4&&e[1]===4||!n&&(b===3||b===4))&&h%t[0]===0&&s%t[1]===0&&e[0]===4))throw new Error(`If transposeA ${n} is true, innerElementSize ${b} and workPerThread[1] ${e[1]} must be 4.\n      Otherwise, innerElementSize ${b} must be 3 or 4.\n  tileAWidth ${h} must be divisible by workgroupSize[0]${t[0]}. tileInner ${s} must be divisible by workgroupSize[1] ${t[1]}. colPerThread ${e[0]} must be 4.`);return`\nvar<workgroup> mm_Asub: array<array<vec${b}<${r}>, ${h/b}>, ${g}>;\nvar<workgroup> mm_Bsub: array<array<vec4<${r}>, ${p/e[0]}>, ${s}>;\n\nconst rowPerThread = ${e[1]};\nconst colPerThread = ${e[0]};\nconst innerElementSize = ${b};\nconst tileInner = ${s};\n\n@compute @workgroup_size(${t[0]}, ${t[1]}, ${t[2]})\nfn main(@builtin(local_invocation_id) localId : vec3<u32>,\n        @builtin(global_invocation_id) globalId : vec3<u32>,\n        @builtin(workgroup_id) workgroupId : vec3<u32>) {\n  let localRow = i32(localId.y);\n  let tileRow = localRow * rowPerThread;\n  let tileCol = i32(localId.x);\n\n  let globalRow =i32(globalId.y) * rowPerThread;\n  let globalCol = i32(globalId.x);\n  let batch = ${u?"0":"i32(globalId.z)"};\n  ${o?`let batchIndices = ${o.offsetToIndices("u32(batch)")};`:""}\n  let globalRowStart = i32(workgroupId.y) * ${a};\n\n  let numTiles = ${u?`${Math.ceil(l/s)}`:"(uniforms.dimInner - 1) / tileInner + 1"};\n  var kStart = ${u?`i32(globalId.z) * ${l}`:"0"};\n\n  var acc: array<vec4<${r}>, rowPerThread>;\n\n  // Loop over shared dimension.\n  let tileRowB = localRow * ${w};\n  for (var t = 0; t < numTiles; t = t + 1) {\n      // Load one tile of A into local memory.\n      for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n          let inputRow = tileRow + innerRow;\n          let inputCol = tileCol;\n          ${il(n,o)}\n      }\n\n      // Load one tile of B into local memory.\n      for (var innerRow = 0; innerRow < ${w}; innerRow = innerRow + 1) {\n          let inputRow = tileRowB + innerRow;\n          let inputCol = tileCol;\n          mm_Bsub[inputRow][inputCol] = mm_readB(batch, kStart + inputRow, globalCol${o?", batchIndices":""});\n      }\n      kStart = kStart + tileInner;\n      workgroupBarrier();\n\n      // Compute acc values for a single thread.\n      for (var k = 0; k < tileInner / innerElementSize; k = k + 1) {\n          let BCached0 = mm_Bsub[k * innerElementSize][tileCol];\n          let BCached1 = mm_Bsub[k * innerElementSize + 1][tileCol];\n          let BCached2 = mm_Bsub[k * innerElementSize + 2][tileCol];\n          ${b===3?"":"let BCached3 = mm_Bsub[k * innerElementSize + 3][tileCol];"}\n\n          ${sl(n,b)}\n      }\n\n      workgroupBarrier();\n  }\n\n  for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n      mm_write(batch, globalRow + innerRow, globalCol, acc[innerRow]);\n  }\n}`},Ni=(e,t)=>e?`\n            mm_Asub[inputRow][inputCol] = mm_readA(batch,\n              kStart + inputRow,\n              globalRowStart + inputCol${t?", batchIndices":""});\n            `:`\n            mm_Asub[inputRow][inputCol] = mm_readA(batch,\n              globalRowStart + inputRow,\n              kStart + inputCol${t?", batchIndices":""});\n            `,ul=e=>e?"let ACached = mm_Asub[k][tileRow + innerRow];":"let ACached = mm_Asub[tileRow + innerRow][k];",fr=(e,t,r="f32",o,n=!1,s=32,u=!1,l=32,a=!1)=>{let p=e[1]*t[1],h=e[0]*t[0],g=n?p:s,b=n?s:p;if(!(b%t[1]===0&&g%t[0]===0&&s%t[1]===0))throw new Error(`tileAHight ${b} must be divisible by workgroupSize[1]${t[1]}, tileAWidth ${g} must be divisible by workgroupSize[0]${t[0]}, tileInner ${s} must be divisible by workgroupSize[1]${t[1]}`);let w=b/t[1],y=g/t[0],_=s/t[1],I=a?`\n    let localRow = i32(localId.y);\n    let localCol = i32(localId.x);\n    let globalRowStart = i32(workgroupId.y) * ${p};\n    let globalColStart = i32(workgroupId.x) * ${h};\n\n    // Loop over shared dimension.\n    for (var t = 0; t < numTiles; t = t + 1) {\n      // Load one tile of A into local memory.\n      for (var inputRow = localRow; inputRow < ${b}; inputRow = inputRow + ${t[1]}) {\n        for (var inputCol = localCol; inputCol < ${g}; inputCol = inputCol + ${t[0]}) {\n          ${Ni(n,o)}\n        }\n      }\n      // Load one tile of B into local memory.\n      for (var inputRow = localRow; inputRow < ${s}; inputRow = inputRow + ${t[1]}) {\n            for (var inputCol = localCol; inputCol < ${h}; inputCol = inputCol + ${t[0]}) {\n          mm_Bsub[inputRow][inputCol] = mm_readB(batch,\n            kStart + inputRow,\n            globalColStart + inputCol${o?", batchIndices":""});\n        }\n      }\n      kStart = kStart + tileInner;\n      workgroupBarrier();\n\n      // Compute acc values for a single thread.\n      var BCached : array<${r}, colPerThread>;\n      for (var k = 0; k < tileInner; k = k + 1) {\n        for (var inner = 0; inner < colPerThread; inner = inner + 1) {\n          BCached[inner] = mm_Bsub[k][localCol + inner * ${t[0]}];\n        }\n        for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n          let ACached = ${n?`mm_Asub[k][localRow + innerRow * ${t[1]}];`:`mm_Asub[localRow + innerRow * ${t[1]}][k];`}\n          for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {\n            acc[innerRow][innerCol] = acc[innerRow][innerCol] +\n                ACached * BCached[innerCol];\n          }\n        }\n      }\n      workgroupBarrier();\n    }\n    for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n      let gRow = globalRowStart + localRow + innerRow * ${t[1]};\n      for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {\n        let gCol = globalColStart + localCol + innerCol * ${t[0]};\n        mm_write(batch, gRow, gCol, acc[innerRow][innerCol]);\n      }\n    }\n    `:`\nlet tileRow = i32(localId.y) * rowPerThread;\nlet tileCol = i32(localId.x) * colPerThread;\n\nlet globalRow = i32(globalId.y) * rowPerThread;\nlet globalCol = i32(globalId.x) * colPerThread;\nlet globalRowStart = i32(workgroupId.y) * ${p};\n\nlet tileRowA = i32(localId.y) * ${w};\nlet tileColA = i32(localId.x) * ${y};\nlet tileRowB = i32(localId.y) * ${_};\n// Loop over shared dimension.\nfor (var t = 0; t < numTiles; t = t + 1) {\n  // Load one tile of A into local memory.\n  for (var innerRow = 0; innerRow < ${w}; innerRow = innerRow + 1) {\n    for (var innerCol = 0; innerCol < ${y}; innerCol = innerCol + 1) {\n      let inputRow = tileRowA + innerRow;\n      let inputCol = tileColA + innerCol;\n      ${Ni(n,o)}\n    }\n  }\n\n  // Load one tile of B into local memory.\n  for (var innerRow = 0; innerRow < ${_}; innerRow = innerRow + 1) {\n    for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {\n      let inputRow = tileRowB + innerRow;\n      let inputCol = tileCol + innerCol;\n      mm_Bsub[inputRow][inputCol] = mm_readB(batch,\n        kStart + inputRow,\n        globalCol + innerCol${o?", batchIndices":""});\n    }\n  }\n  kStart = kStart + tileInner;\n  workgroupBarrier();\n\n  // Compute acc values for a single thread.\n  var BCached : array<${r}, colPerThread>;\n  for (var k = 0; k < tileInner; k = k + 1) {\n    for (var inner = 0; inner < colPerThread; inner = inner + 1) {\n      BCached[inner] = mm_Bsub[k][tileCol + inner];\n    }\n\n    for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n      ${ul(n)}\n      for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {\n        acc[innerRow][innerCol] = acc[innerRow][innerCol] + ACached * BCached[innerCol];\n      }\n    }\n  }\n\n  workgroupBarrier();\n}\n\nfor (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n  for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {\n    mm_write(batch, globalRow + innerRow, globalCol + innerCol,\n        acc[innerRow][innerCol]);\n  }\n}\n`;return`\n  var<workgroup> mm_Asub : array<array<${r}, ${g}>, ${b}>;\n  var<workgroup> mm_Bsub : array<array<${r}, ${h}>, ${s}>;\n  const rowPerThread = ${e[1]};\n  const colPerThread = ${e[0]};\n  const tileInner = ${s};\n\n@compute @workgroup_size(${t[0]}, ${t[1]}, ${t[2]})\nfn main(@builtin(local_invocation_id) localId : vec3<u32>,\n        @builtin(global_invocation_id) globalId : vec3<u32>,\n        @builtin(workgroup_id) workgroupId : vec3<u32>) {\n    let batch = ${u?"0":"i32(globalId.z)"};\n    ${o?`let batchIndices = ${o.offsetToIndices("u32(batch)")};`:""}\n    let numTiles = ${u?`${Math.ceil(l/s)}`:"(uniforms.dimInner - 1) / tileInner + 1"};\n    var kStart = ${u?`i32(globalId.z) * ${l}`:"0"};\n\n    var acc : array<array<${r}, colPerThread>, rowPerThread>;\n\n    // Without this initialization strange values show up in acc.\n    for (var innerRow = 0; innerRow < rowPerThread; innerRow = innerRow + 1) {\n      for (var innerCol = 0; innerCol < colPerThread; innerCol = innerCol + 1) {\n        acc[innerRow][innerCol] = 0.0;\n      }\n    }\n    ${I}\n  }\n`},dl=(e,t,r,o,n,s=!1)=>{let[u,l,a]=n,[p,h,g,b]=o,w=Ft(u,a),y=Ft(l,a),_=Le(o[0].type.tensor),I=()=>{let E=h.rank,A=p.rank,z=`var aIndices: ${h.type.indices};`;for(let R=E-2-1,V=A-1;R>=0;R--,V--)z+=`\naIndices[${R}] = ${A>1?`batchIndices[${V}]`:"batchIndices"};`;return w.forEach(R=>{z+=`\naIndices[${R}] = 0;`}),z+=`\naIndices[${E-2}] = u32(row);\n                   aIndices[${E-1}] = u32(colIn);`,z},$=()=>{let E=g.rank,A=p.rank,z=`var bIndices: ${g.type.indices};`;for(let R=E-2-1,V=A-1;R>=0;R--,V--)z+=`\nbIndices[${R}] = ${A>1?`batchIndices[${V}]`:"batchIndices"};`;return y.forEach(R=>{z+=`\nbIndices[${R}] = 0;`}),z+=`\nbIndices[${E-2}] = u32(row);\n                   bIndices[${E-1}] = u32(colIn);`,z};return`\n    fn mm_readA(batch: i32, row: i32, colIn: i32, batchIndices: ${p.type.indices}) -> ${Ke(e,_)} {\n      var value = ${Ke(e,_)}(0.0);\n      let col = colIn * ${e};\n      if(row < uniforms.dimAOuter && col < uniforms.dimInner)\n      {\n        ${I()}\n        value = ${h.getByIndices("aIndices")};\n      }\n      return value;\n    }\n\n    fn mm_readB(batch: i32, row: i32, colIn: i32, batchIndices: ${p.type.indices}) -> ${Ke(e,_)} {\n      var value = ${Ke(e,_)}(0.0);\n      let col = colIn * ${e};\n      if(row < uniforms.dimInner && col < uniforms.dimBOuter)\n      {\n        ${$()}\n        value = ${g.getByIndices("bIndices")};\n      }\n      return value;\n    }\n\n    fn mm_write(batch: i32, row: i32, colIn: i32, valueIn: ${Ke(e,_)}) {\n      let col = colIn * ${e};\n      if (row < uniforms.dimAOuter && col < uniforms.dimBOuter) {\n        var value = valueIn;\n        let coords = vec3<i32>(batch, row, colIn);\n        ${t?`value = value + ${s?"bias[colIn]":`${Ke(e,_)}(bias[row])`};`:""}\n        ${r}\n        ${b.setByIndices("vec3<u32>(coords)","value")}\n      }\n    }\n    `},tn=(e,t,r,o,n=!1)=>{let s=e[0].dims,u=e[1].dims,l=s.slice(0,-2),a=u.slice(0,-2),p=o?o.slice(0,-2):r.slice(0,-2),h=Re(p.length),g=h?p.length:p,b=Fr("batchDims",e[0].dataType,g,1),w=U.size(p),y=s[s.length-2],_=s[s.length-1],I=u[u.length-1],$=_%4===0&&I%4===0,x=y<=8?[4,1,1]:[4,4,1],E=[8,8,1],A=[Math.ceil(I/E[0]/x[0]),Math.ceil(y/E[1]/x[1]),Math.ceil(w/E[2]/x[2])],z=Le(e[0].dataType),R=$?4:1,V=[...l,y,_/R],T=Re(V.length),N=T?V.length:V,te=[...a,_,I/R],Y=Re(te.length),K=Y?te.length:te,Q=[w,y,I/R],Z=M("a",e[0].dataType,N,R),Ee=M("b",e[1].dataType,K,R),Pe=F("result",e[0].dataType,Q.length,R),fe=[Z,Ee],Ie=[{type:"int32",data:y},{type:"int32",data:I},{type:"int32",data:_}];h&&Ie.push(...L(p)),T&&Ie.push(...L(V)),Y&&Ie.push(...L(te));let he=[];he.push(T?"rank":"dims"),he.push(Y?"rank":"dims");let ye=e.length>2,{activationFunction:We,applyActivation:De}=gt(t,Pe.type.value),Ge=dl(R,ye,De,[b,Z,Ee,Pe],[l,a,p],n);if(ye){let ee=n?R:1;fe.push(M("bias",e[2].dataType,e[2].dims.length,ee)),Ie.push(...L(e[2].dims)),he.push("rank")}Ie.push(...L(Q));let G=ee=>`\n  ${ee.registerUniform("dimAOuter","i32").registerUniform("dimBOuter","i32").registerUniform("dimInner","i32").registerInternalVariables(b).declareVariables(...fe,Pe)}\n  ${We}\n  ${Ge}\n  ${$?mr(x,E,z,b):fr(x,E,z,b)}\n                   `;return{name:"MatMul",shaderCache:{hint:t.activationCacheKey+`${x}${$}${n}`,inputDependencies:he},getRunData:()=>({outputs:[{dims:r,dataType:e[0].dataType}],dispatchGroup:{x:A[0],y:A[1],z:A[2]},programUniforms:Ie}),getShaderSource:G}}});var ll,Wi,Hi=j(()=>{"use strict";Ct();ve();It();Jr();Nn();hr();ll=(e,t,r,o,n=!1,s,u=4,l=4,a=4,p="f32")=>{let h=Y=>{switch(Y){case 1:return"resData = x[xIndex];";case 3:return`resData = vec3<${p}>(x[xIndex], x[xIndex + 1], x[xIndex + 2]);`;case 4:return"resData = x[xIndex / 4];";default:throw new Error(`innerElementSize ${Y} is not supported.`)}},g=Y=>{switch(Y){case 1:return"return w[row * i32(uniforms.w_shape[3]) + colIn];";case 4:return"return w[row * i32(uniforms.w_shape[3]) / 4 + colIn];";default:throw new Error(`innerElementSize ${Y} is not supported.`)}},b=e?`\n    let coord = vec4<i32>(batch, xRow, xCol, xCh);\n    `:`\n    let coord = vec4<i32>(batch, xCh, xRow, xCol);\n    `,w=e?`\n    let coords = vec4<i32>(\n      batch,\n      row / outWidth,\n      row % outWidth,\n      col);\n    `:`\n    let coords = vec4<i32>(\n      batch,\n      row,\n      col / outWidth,\n      col % outWidth);\n    `,y=e?"i32(uniforms.x_shape[1])":"i32(uniforms.x_shape[2])",_=e?"i32(uniforms.x_shape[2])":"i32(uniforms.x_shape[3])",I=e?"row":"col",$=e?"col":"row",x=`\n    let inChannels = i32(uniforms.w_shape[2]);\n    let outWidth = ${e?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};\n    let outRow = ${I} / outWidth;\n    let outCol = ${I} % outWidth;\n\n    let WRow = ${$} / (filterDims[1] * inChannels);\n    let WCol = ${$} / inChannels % filterDims[1];\n    let xRow = outRow * stride[0] + dilation[0] * WRow - pad[0];\n    let xCol = outCol * stride[1] + dilation[1] * WCol - pad[1];\n    let xCh = ${$} % inChannels;\n    var resData = ${Ke(u,p)}(0.0);\n    // The bounds checking is always needed since we use it to pad zero for\n    // the \'same\' padding type.\n    if (xRow >= 0 && xRow < ${y} && xCol >= 0 && xCol < ${_}) {\n      ${b}\n      let xIndex = getIndexFromCoords4D(coord, vec4<i32>(uniforms.x_shape));\n      ${h(u)}\n    }\n    return resData;`,E=e?t&&o?`\n    let col = colIn * ${u};\n    ${x}`:`\n    let col = colIn * ${u};\n    if (row < uniforms.dimAOuter && col < uniforms.dimInner) {\n      ${x}\n    }\n    return ${Ke(u,p)}(0.0);`:o&&r?`\n    let col = colIn * ${u};\n    ${x}`:`\n    let col = colIn * ${u};\n    if (row < uniforms.dimInner && col < uniforms.dimBOuter) {\n      ${x}\n    }\n    return ${Ke(u,p)}(0.0);`,A=`${g(l)}`,z=Ke(a,p),R=e?Ke(u,p):Ke(l,p),V=e?Ke(l,p):Ke(u,p),{activationFunction:T,applyActivation:N}=gt(s,z);return`\n    ${T}\n    fn mm_readA(batch: i32, row : i32, colIn : i32) -> ${R} {\n      ${e?E:A}\n    }\n\n    fn mm_readB(batch: i32, row : i32, colIn : i32) -> ${V} {\n      ${e?A:E}\n    }\n\n    fn mm_write(batch: i32, row : i32, colIn : i32, valueIn : ${z}) {\n      let col = colIn * ${a};\n      if (row < uniforms.dimAOuter && col < uniforms.dimBOuter)\n      {\n      var value = valueIn;\n      let outWidth = ${e?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};\n      ${w}\n      ${Xr(n)}\n      ${N}\n      setOutputAtCoords(coords[0], coords[1], coords[2], coords[3], value);\n      }\n    }`},Wi=(e,t,r,o,n,s,u,l)=>{let a=t.format==="NHWC",p=a?e[0].dims[3]:e[0].dims[1],h=r[0],g=a?r[2]:r[3],b=a?r[1]:r[2],w=a?r[3]:r[1],y=a&&(p%4===0||p%3===0)&&w%4===0,_=a?w:g*b,I=a?g*b:w,$=[8,8,1],x=o<=8?[4,1,1]:[4,4,1],E=[Math.ceil(_/$[0]/x[0]),Math.ceil(I/$[1]/x[1]),Math.ceil(h/$[2]/x[2])];Be("verbose",()=>`[conv2d_mm_webgpu] dispatch = ${E}`);let A=y?a&&p%4!==0?3:4:1,z=$[1]*x[1],R=$[0]*x[0],V=Math.max($[0]*A,$[1]),T=o%z===0,N=n%R===0,te=s%V===0,Y=y?[A,4,4]:[1,1,1],K=Le(e[0].dataType),Q=y?4:1,Z=[{type:"int32",data:o},{type:"int32",data:n},{type:"int32",data:s}],Ee=M("x",e[0].dataType,e[0].dims.length,A===3?1:A),Pe=M("w",e[1].dataType,e[1].dims.length,Q),fe=[Ee,Pe];Z.push(...L(e[0].dims)),Z.push(...L(e[1].dims));let Ie=`\n      fn setOutputAtIndex(flatIndex : i32, value : ${y?`vec4<${K}>`:K}) {\n        result[flatIndex] = ${y?`vec4<${K}>`:K}(value);\n      }\n      fn setOutputAtCoords(d0 : i32, d1 : i32, d2 : i32, d3 : i32, value : ${y?`vec4<${K}>`:K}) {\n        let flatIndex = getOutputIndexFromCoords(vec4<i32>(d0, d1, d2, d3));\n        setOutputAtIndex(flatIndex ${y?"/ 4":""}, value);\n      }`;if(u){let ye=M("bias",e[2].dataType,e[2].dims.length,Q);fe.push(ye),Z.push(...L(e[2].dims)),Ie+=`\n        fn getBiasByOutputCoords(coords : vec4<i32>) -> ${y?`vec4<${K}>`:K} {\n          return bias[coords.${a?"w":"y"}${y?"/ 4":""}];\n        }`}let he=F("result",e[0].dataType,r.length,Q);return Z.push(...L(r)),{name:"Conv2DMatMul",shaderCache:{hint:t.cacheKey},getRunData:()=>({outputs:[{dims:r,dataType:e[0].dataType}],dispatchGroup:{x:E[0],y:E[1],z:E[2]},programUniforms:Z}),getShaderSource:ye=>`\n        ${en("uniforms.result_strides")}\n        //struct Uniforms { xShape : vec4<i32>, wShape : vec4<i32>, outShape : vec4<i32>,\n        //  outShapeStrides: vec3<i32>, filterDims : vec2<i32>, pad : vec2<i32>, stride : vec2<i32>,\n        //  dilation : vec2<i32>, dimAOuter : i32, dimBOuter : i32, dimInner : i32 };\n        ${ye.registerUniform("dimAOuter","i32").registerUniform("dimBOuter","i32").registerUniform("dimInner","i32").declareVariables(...fe,he)}\n        const filterDims : vec2<i32> = vec2<i32>(${t.kernelShape[0]}, ${t.kernelShape[1]});\n        const pad : vec2<i32> = vec2<i32>(${t.pads[0]}, ${t.pads[1]});\n        const stride : vec2<i32> = vec2<i32>(${t.strides[0]}, ${t.strides[1]});\n        const dilation : vec2<i32> = vec2<i32>(${t.dilations[0]}, ${t.dilations[1]});\n        ${Ie}\n        ${ll(a,T,N,te,u,t,Y[0],Y[1],Y[2],K)}\n            ${y?mr(x,$,K,void 0,!a,V):fr(x,$,K,void 0,!a,V,!1,void 0,l)}`}}});var Wn,Gi=j(()=>{"use strict";$e();ve();Gn();It();Wn=(e,t,r)=>{let o=e.length>2,n=o?"value += b[output_channel];":"",s=e[0].dims,u=e[1].dims,l=u[0]/t.group,a=t.format==="NHWC",p=Hn(s,u,t.dilations,t.pads,t.strides,a),h=U.size(p),g=F("output",e[0].dataType,p),{activationFunction:b,applyActivation:w}=gt(t,g.type.value),y=M("x",e[0].dataType,s),_=M("w",e[1].dataType,u),I=[y,_];o&&I.push(M("b",e[2].dataType,e[2].dims));let $=x=>`\n  const strides: vec2<u32> = vec2(${t.strides[0]}u, ${t.strides[1]}u);\n  const pads: vec2<u32> = vec2(${t.pads[0]}u, ${t.pads[1]}u);\n\n  ${x.declareVariables(...I,g)}\n\n  ${b}\n\n  ${x.mainStart()}\n    ${x.guardAgainstOutOfBoundsWorkgroupSizes(h)}\n\n    let outputIndices = ${g.offsetToIndices("global_idx")};\n    let batch: u32 = outputIndices[0];\n    let output_channel: u32 = outputIndices[${a?3:1}];\n    let xRCCorner: vec2<u32> = vec2<u32>(outputIndices[${a?1:2}], outputIndices[${a?2:3}]) * strides - pads;\n    let group_id: u32 = output_channel / ${l}u;\n\n    var value: ${g.type.value} = ${g.type.value}(0);\n    for (var wInChannel: u32 = 0u; wInChannel < ${u[1]}u; wInChannel++) {\n      let input_channel = group_id * ${u[1]}u + wInChannel;\n      for (var wHeight: u32 = 0u; wHeight < ${u[2]}u; wHeight++) {\n        let xHeight = xRCCorner.x + wHeight * ${t.dilations[0]}u;\n\n        if (xHeight < 0u || xHeight >= ${s[a?1:2]}u) {\n          continue;\n        }\n\n        for (var wWidth: u32 = 0u; wWidth < ${u[3]}u; wWidth++) {\n          let xWidth = xRCCorner.y + wWidth * ${t.dilations[1]}u;\n          if (xWidth < 0u || xWidth >= ${s[a?2:3]}u) {\n            continue;\n          }\n\n          let xVal = ${a?y.get("batch","xHeight","xWidth","input_channel"):y.get("batch","input_channel","xHeight","xWidth")};\n          let wVal = ${_.get("output_channel","wInChannel","wHeight","wWidth")};\n          value += xVal*wVal;\n        }\n      }\n    }\n    ${n}\n    ${w}\n    ${g.setByOffset("global_idx","value")}\n  }`;return{name:"GroupedConv",shaderCache:{hint:t.cacheKey},getRunData:()=>({outputs:[{dims:r?r(p):p,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(h/64)}}),getShaderSource:$}}});var Ln,cl,Li,Fn=j(()=>{"use strict";$e();hr();ve();It();Ln=(e,t,r,o,n=!1)=>{let s=e[0].dims,u=e[1].dims,l=s[s.length-2],a=u[u.length-1],p=s[s.length-1],h=Fe(a),g=Fe(p),b=Fe(l),w=U.size(r)/h/b,y=e.length>2,_=o?o.slice(0,-2):r.slice(0,-2),$=[U.size(_),l,a],x=[{type:"uint32",data:w},{type:"uint32",data:l},{type:"uint32",data:a},{type:"uint32",data:p},...L(_),...L(s),...L(u)];y&&x.push(...L(e[2].dims)),x.push(...L($));let E=A=>{let z=Fr("batch_dims",e[0].dataType,_.length),R=M("a",e[0].dataType,s.length,g),V=M("b",e[1].dataType,u.length,h),T=F("output",e[0].dataType,$.length,h),{activationFunction:N,applyActivation:te}=gt(t,T.type.value),Y=[R,V],K="";if(y){let he=n?h:1;Y.push(M("bias",e[2].dataType,e[2].dims.length,he)),K=`${n?`value += bias[col / ${he}];`:`value += ${T.type.value}(bias[row + i]);`}`}let Q=s.slice(0,-2),Z=u.slice(0,-2),Ee=Ft(Q,_),Pe=Ft(Z,_),fe=(he,ye)=>{let We=he.rank,De=he.name;if(We===2)return`var ${De}_indices = ${he.type.indices}(0u, 0u);`;let Ge=z.rank,G=`var ${De}_indices: ${he.type.indices};`;for(let ee=We-2-1,be=Ge-1;ee>=0;ee--,be--)G+=`\n${De}_indices[${ee}] = ${Ge>1?`batch_indices[${be}]`:"batch_indices"};`;return ye.forEach(ee=>{G+=`\n${De}_indices[${ee}] = 0;`}),G+=`${De}_indices[${We-2}] = 0u;\n                     ${De}_indices[${We-1}] = 0u;`,G},Ie=()=>{let he=`var a_data: ${R.type.value};`;for(let ye=0;ye<g;ye++)he+=`\n              let b_data${ye} = b[(b_offset + (k + ${ye}) * uniforms.N + col) / ${h}];`;for(let ye=0;ye<b;ye++){he+=`a_data = a[(a_offset + (row + ${ye}) * uniforms.K + k) / ${g}];`;for(let We=0;We<g;We++)he+=`\n            values[${ye}] = fma(${V.type.value}(a_data${g===1?"":`[${We}]`}), b_data${We}, values[${ye}]);\n`}return he};return`\n  ${A.registerUniform("outputSize","u32").registerUniform("M","u32").registerUniform("N","u32").registerUniform("K","u32").registerInternalVariables(z).declareVariables(...Y,T)}\n  ${N}\n  ${A.mainStart()}\n    ${A.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n    let col = (global_idx % (uniforms.N / ${h})) * ${h};\n    var index1 = global_idx / (uniforms.N / ${h});\n    let stride1 = uniforms.M / ${b};\n    let row = (index1 % stride1) * ${b};\n    let batch = index1 / stride1;\n\n    ${r.length===2?"":`let batch_indices = ${z.offsetToIndices("batch")};`}\n    ${fe(R,Ee)}\n    let a_offset = ${R.indicesToOffset("a_indices")};\n    ${fe(V,Pe)}\n    let b_offset = ${V.indicesToOffset("b_indices")};\n    var values: array<${T.type.value}, ${b}>;\n    for (var k: u32 = 0u; k < uniforms.K; k = k + ${g}) {\n      ${Ie()}\n    }\n    for (var i = 0u; i < ${b}u; i++) {\n      var value = values[i];\n      ${K}\n      ${te}\n      let cur_indices = ${T.type.indices}(batch, row + i, col);\n      let offset = ${T.indicesToOffset("cur_indices")};\n      ${T.setByOffset(`offset / ${h}`,"value")};\n    }\n  }\n  `};return{name:"MatMulNaive",shaderCache:{hint:`${t.activationCacheKey}_${h}_${g}_${b}_${n}`,inputDependencies:y?["rank","rank","rank"]:["rank","rank"]},getRunData:()=>({outputs:[{dims:r,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(w/64)},programUniforms:x}),getShaderSource:E}},cl=e=>{if(!e||e.length!==2)throw new Error("MatMul requires 2 inputs.");if(e[0].dims[e[0].dims.length-1]!==e[1].dims[e[1].dims.length-2])throw new Error("shared dimension does not match.")},Li=e=>{cl(e.inputs);let t=dt.calcShape(e.inputs[0].dims,e.inputs[1].dims,!0);if(!t)throw new Error("Can\'t use matmul on the given tensors");let r=t[t.length-1],o=e.inputs[0].dims[e.inputs[0].dims.length-1];r<8&&o<8?e.compute(Ln(e.inputs,{activation:"",activationCacheKey:""},t)):e.compute(tn(e.inputs,{activation:"",activationCacheKey:""},t))}});var Hn,Fi,pl,ji,jn,ml,fl,qn,Gn=j(()=>{"use strict";$e();je();Hi();hr();Gi();It();Fn();jt();Hn=(e,t,r,o,n,s)=>{let u=e[0],l=e.slice(s?1:2,s?3:4),a=l.length,p=t[0],g=t.slice(2).map((y,_)=>y+(y-1)*(r[_]-1)),w=l.map((y,_)=>y+o[_]+o[_+a]).map((y,_)=>Math.floor((y-g[_]+n[_])/n[_]));return w.splice(0,0,u),w.splice(s?3:1,0,p),w},Fi=[2,3,1,0],pl=(e,t)=>{if(!e||e.length!==2&&e.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(e[0].dims.length!==4&&e[0].dims.length!==3)throw new Error("currently only support conv 1D and 2D");if(e[0].dims.length!==e[1].dims.length)throw new Error("filter does not have same dimension as input");let r=e[0].dims[t.format==="NHWC"?e[0].dims.length-1:1],o=e[1].dims[1]*t.group;if(r!==o)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");if(e.length===3&&(e[2].dims.length!==1||e[1].dims[0]!==e[2].dims[0]))throw new Error("invalid bias");let n=e[0].dims.length-2;if(t.dilations.length!==n)throw new Error(`dilations should be ${n}D`);if(t.strides.length!==n)throw new Error(`strides should be ${n}D`);if(t.pads.length!==n*2)throw new Error(`pads should be ${n*2}D`);if(t.kernelShape.length!==0&&t.kernelShape.length!==e[1].dims.length-2)throw new Error("invalid kernel shape")},ji=(e,t)=>{let r=e.kernelShape.slice();for(let s=2;s<t[1].dims.length;++s)r[s-2]===0&&(r[s-2]=t[1].dims[s]);let o=e.pads.slice();Bt.adjustPadsBasedOnAutoPad(t[0].dims,e.strides,e.dilations,r,o,e.format==="NHWC",e.autoPad);let n=Object.assign({},e);return Object.assign(n,{kernelShape:r,pads:o,cacheKey:e.cacheKey}),n},jn=e=>{let t=Qr(e),r=e.format,o=["NOTSET","VALID","SAME_UPPER","SAME_LOWER"][e.auto_pad],n=e.dilations,s=e.group,u=e.kernel_shape,l=e.pads,a=e.strides,p=e.w_is_const();return ge({autoPad:o,format:r,dilations:n,group:s,kernelShape:u,pads:l,strides:a,wIsConst:p,...t})},ml=(e,t,r)=>{let o=ji(r,t),n=r.format==="NHWC";if(r.group!==1){e.compute(Wn(t,o));return}let s=t.length===3,u=t[0].dims[n?1:2],l=t[0].dims[n?2:3],a=t[0].dims[n?3:1],p=t[1].dims[2],h=t[1].dims[3],g=Hn(t[0].dims,t[1].dims,r.dilations,o.pads,r.strides,n),b=g[n?1:2],w=g[n?2:3],y=g[n?3:1],_=n&&p===u&&h===l&&r.pads[0]===0&&r.pads[1]===0;if(_||p===1&&h===1&&r.dilations[0]===1&&r.dilations[1]===1&&r.strides[0]===1&&r.strides[1]===1&&r.pads[0]===0&&r.pads[1]===0){let R=g[0],V,T,N,te=[];if(n){let Q=e.kernelCustomData.wT??e.compute(it(t[1],Fi),{inputs:[1],outputs:[r.wIsConst?-2:-1]})[0];if(r.wIsConst&&!e.kernelCustomData.wT&&(e.kernelCustomData.wT=Q),_){let Z=u*l*a;V=t[0].reshape([1,R,Z]),T=Q.reshape([1,Z,y]),N=[1,R,y]}else V=t[0].reshape([R,u*l,a]),T=Q.reshape([1,a,y]),N=[R,b*w,y];te.push(V),te.push(T)}else V=t[0].reshape([R,a,u*l]),T=t[1].reshape([1,y,a]),N=[R,y,b*w],te.push(T),te.push(V);s&&te.push(t[2]);let Y=N[2],K=te[0].dims[te[0].dims.length-1];Y<8&&K<8?e.compute(Ln(te,o,g,N,n),{inputs:te}):e.compute(tn(te,o,g,N,n),{inputs:te});return}let I=!0,$=e.kernelCustomData.wT??e.compute(it(t[1],Fi),{inputs:[1],outputs:[r.wIsConst?-2:-1]})[0];r.wIsConst&&!e.kernelCustomData.wT&&(e.kernelCustomData.wT=$);let x=[t[0],$];s&&x.push(t[2]);let E=n?b*w:y,A=n?y:b*w,z=p*h*a;e.compute(Wi(x,o,g,E,A,z,s,I),{inputs:x})},fl=(e,t)=>{let r=t.format==="NHWC",o=[e.inputs[0].reshape(r?[e.inputs[0].dims[0],1,e.inputs[0].dims[1],e.inputs[0].dims[2]]:[e.inputs[0].dims[0],e.inputs[0].dims[1],1,e.inputs[0].dims[2]]),e.inputs[1].reshape([e.inputs[1].dims[0],e.inputs[1].dims[1],1,e.inputs[1].dims[2]])];e.inputs.length===3&&o.push(e.inputs[2]);let n=[0,t.pads[0],0,t.pads[1]],s=[1].concat(t.strides),u=[1].concat(t.dilations),l=[1].concat(t.kernelShape),a=ji({...t,pads:n,strides:s,dilations:u,kernelShape:l},o);e.compute(Wn(o,a,p=>r?[p[0],p[2],p[3]]:[]))},qn=(e,t)=>{pl(e.inputs,t),e.inputs[0].dims.length===3?fl(e,t):ml(e,e.inputs,t)}});var hl,qi,Ki=j(()=>{"use strict";Ct();ve();It();Jr();Nn();hr();hl=(e,t=!1,r,o=4)=>{let n=Ke(o,"f32"),s=x=>{switch(x){case 1:return"return w[getIndexFromCoords4D(coord, vec4<i32>(uniforms.w_shape))];";case 4:return`\n            let coord1 = vec4<i32>(coordX, coordY, col + 1, rowInner);\n            let coord2 = vec4<i32>(coordX, coordY, col + 2, rowInner);\n            let coord3 = vec4<i32>(coordX, coordY, col + 3, rowInner);\n            let v0 = w[getIndexFromCoords4D(coord, vec4<i32>(uniforms.w_shape))];\n            let v1 = w[getIndexFromCoords4D(coord1, vec4<i32>(uniforms.w_shape))];\n            let v2 = w[getIndexFromCoords4D(coord2, vec4<i32>(uniforms.w_shape))];\n            let v3 = w[getIndexFromCoords4D(coord3, vec4<i32>(uniforms.w_shape))];\n            return vec4<f32>(v0, v1, v2, v3);\n            `;default:throw new Error(`innerElementSize ${x} is not supported.`)}},u=e?`\n      let coord = vec4<i32>(batch, iXR, iXC, xCh);\n      `:`\n      let coord = vec4<i32>(batch, xCh, iXR, iXC);\n      `,l=e?`\n    let coords = vec4<i32>(\n      batch,\n      row / outWidth,\n      row % outWidth,\n      col);\n    `:`\n    let coords = vec4<i32>(\n      batch,\n      row,\n      col / outWidth,\n      col % outWidth);\n    `,a=e?"outBackprop[1]":"outBackprop[2]",p=e?"outBackprop[2]":"outBackprop[3]",h=e?"row":"col",g=e?"col":"row",b=`\n      let inChannels = ${e?"outBackprop[3]":"outBackprop[1]"};\n      let outWidth = ${e?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};\n      let outRow = ${h} / outWidth;\n      let outCol = ${h} % outWidth;\n\n      let WRow = ${g} / (filterDims[1] * inChannels);\n      let WCol = ${g} / inChannels % filterDims[1];\n      let xR = f32(outRow - pads[0] + dilation[0] * WRow) / f32(strides[0]);\n      let xC = f32(outCol - pads[1] + dilation[1] * WCol) / f32(strides[1]);\n      if (xR < 0.0 || xR >= f32(${a}) || fract(xR) > 0.0) {\n        return ${n}(0.0);\n      }\n      if (xC < 0.0 || xC >= f32(${p}) || fract(xC) > 0.0) {\n        return ${n}(0.0);\n      }\n      let iXR = i32(xR);\n      let iXC = i32(xC);\n      let xCh = ${g} % inChannels;\n      ${u}\n      return x[getIndexFromCoords4D(coord, vec4<i32>(uniforms.x_shape))/${o}];`,w=e?`\n      let col = colIn * ${o};\n      if (row < uniforms.dimAOuter && col < uniforms.dimInner) {\n        ${b}\n      }\n      return ${n}(0.0);`:`\n      let col = colIn * ${o};\n      if (row < uniforms.dimInner && col < uniforms.dimBOuter) {\n        ${b}\n      }\n      return ${n}(0.0);`,y=`\n      let col = colIn * ${o};\n      let inChannels = ${e?"outBackprop[3]":"outBackprop[1]"};\n      let coordX = filterDims.x - 1 - row / (filterDims[1] * inChannels);\n      let coordY = filterDims.y - 1 - (row / inChannels) % filterDims[1];\n      if (${e?"row < uniforms.dimInner && col < uniforms.dimBOuter":"row < uniforms.dimInner && col < uniforms.dimAOuter"}  && coordX >= 0 && coordY >= 0) {\n        let rowInner = row % inChannels;\n        let coord = vec4<i32>(coordX, coordY, col, rowInner);\n        ${s(o)}\n      }\n      return ${n}(0.0);\n      `,{activationFunction:_,applyActivation:I}=gt(r,n);return`\n      ${_}\n  fn mm_readA(batch: i32, row : i32, colIn : i32) -> ${n} {\n    ${e?w:y}\n  }\n\n  fn mm_readB(batch: i32, row : i32, colIn : i32) -> ${n} {\n    ${e?y:w}\n  }\n\n  fn mm_write(batch: i32, row : i32, colIn : i32, valueInput : ${n}) {\n    let col = colIn * ${o};\n    if (row < uniforms.dimAOuter && col < uniforms.dimBOuter) {\n      var value = valueInput;\n      let outWidth = ${e?"i32(uniforms.result_shape[2])":"i32(uniforms.result_shape[3])"};\n      ${l}\n      ${Xr(t)}\n      ${I}\n      result[getIndexFromCoords4D(coords, vec4<i32>(uniforms.result_shape))/${o}] = value;\n    }\n  }`},qi=(e,t,r,o,n,s,u,l)=>{let a=t.format==="NHWC",p=a?e[0].dims[3]:e[0].dims[1],h=r[0],g=a?r[2]:r[3],b=a?r[1]:r[2],w=a?r[3]:r[1],y=a?p%4===0&&w%4===0:g%4===0&&w%4===0,_=a?w:g*b,I=a?g*b:w,$=y?[8,8,1]:[_<=4||I<=4?4:16,_>4&&I<=4?4:16,1],x=y?[4,4,1]:[_<=4?1:4,_>4&&I<=4?1:4,1],E=[Math.ceil(_/$[0]/x[0]),Math.ceil(I/$[1]/x[1]),Math.ceil(h/$[2]/x[2])];Be("verbose",()=>`[conv_backprop_mm_webgpu] dispatch = ${E}`);let A=y?4:1,z=Math.max($[0]*A,$[1]),R=y?4:1,V=[{type:"int32",data:o},{type:"int32",data:n},{type:"int32",data:s}],T=M("x",e[0].dataType,e[0].dims.length,R),N=M("w",e[1].dataType,e[1].dims.length,1),te=F("result",e[0].dataType,r.length,R),Y=[T,N];V.push(...L(e[0].dims)),V.push(...L(e[1].dims));let K="";if(u){let Q=M("bias",e[2].dataType,e[2].dims.length,R);Y.push(Q),V.push(...L(e[2].dims)),K+=`\n        fn getBiasByOutputCoords(coords : vec4<i32>) -> ${y?"vec4<f32>":"f32"} {\n          return bias[coords.${a?"w":"y"}${y?"/ 4":""}];\n        }`}return V.push(...L(r)),{name:"Conv2DTransposeMatMul",shaderCache:{hint:t.cacheKey},getRunData:()=>({outputs:[{dims:r,dataType:e[0].dataType}],dispatchGroup:{x:E[0],y:E[1],z:E[2]},programUniforms:V}),getShaderSource:Q=>`\n        ${en("uniforms.result_strides")}\n        ${Q.registerUniform("dimAOuter","i32").registerUniform("dimBOuter","i32").registerUniform("dimInner","i32").declareVariables(...Y,te)};\n        const outBackprop : vec4<i32> = vec4<i32>(${e[0].dims.join(",")});\n        const filterDims : vec2<i32> = vec2<i32>(${t.kernelShape[a?1:2]}, ${t.kernelShape[a?2:3]});\n        const effectiveFilterDims : vec2<i32> = filterDims + vec2<i32>(\n              ${t.dilations[0]<=1?0:(t.kernelShape[a?1:2]-1)*(t.dilations[0]-1)},\n              ${t.dilations[1]<=1?0:(t.kernelShape[a?2:3]-1)*(t.dilations[1]-1)});\n        const pads : vec2<i32> = vec2<i32>(i32(effectiveFilterDims[0]) - 1 - (${t.pads[0]+t.pads[2]})/2,\n                                         i32(effectiveFilterDims[1]) - 1 - (${t.pads[1]+t.pads[3]})/2);\n        const strides : vec2<i32> = vec2<i32>(${t.strides[0]}, ${t.strides[1]});\n        const dilation : vec2<i32> = vec2<i32>(${t.dilations[0]}, ${t.dilations[1]});\n        const dimAOuter : i32 = ${o};\n        const dimBOuter : i32 = ${n};\n        const dimInner : i32 = ${s};\n        ${K}\n        ${hl(a,u,t,A)}\n        ${y?mr(x,$,"f32",void 0,!a,z):fr(x,$,"f32",void 0,!a,z,!1,void 0,l)}`}}});var gl,Kn,Yi=j(()=>{"use strict";Ct();$e();ve();gl=(e,t,r,o,n,s,u=!1,l)=>{let a=r.format==="NHWC",p=a?1:2,h=a?2:3,g=a?3:1,b=U.size(o),w=u?2:1,y=r.group,_=t[1].dims,I=_[0]/y,$=_[1],x=`\n  fn setOutputAtIndex(flatIndex : u32, value : ${u?`vec4<${l}>`:l}) {\n    result[flatIndex] = ${u?`vec4<${l}>`:l}(value);\n  }`;n&&(x+=`\n    fn getBiasByOutputCoords(coords : vec4<u32>) -> ${u?`vec4<${l}>`:l} {\n      return bias[coords.${a?"w":"y"}${u?"/ 4":""}];\n    }`);let E=u?4:1,A=M("W",t[1].dataType,t[1].dims,E),z=M("Dy",t[0].dataType,t[0].dims,E),R=[z,A];n&&R.push(M("bias",t[2].dataType,[o[g]],E));let V=F("result",t[0].dataType,o,E),T=`{\n        let batch: u32 = ${s?"global_id.z":"workgroup_id.z"} / outShape[1];\n        let r = ${s?"global_id.z":"workgroup_id.z"} % outShape[1];\n        let c = ${s?"global_id.y":"workgroup_id.y"} * ${w};\n        let d1: u32 = ${s?"global_id.x":"workgroup_id.x"} * 4;\n\n        let dyCorner = vec2<i32>(i32(r), i32(c)) - vec2<i32>(pads);\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        var dotProd: array<vec4<${l}>, ${w}>;\n        for (var i = 0; i < ${w}; i++) {\n          dotProd[i] = vec4<${l}>(0.0);\n        }\n        for (var wR: u32 = 0; wR < filterDims[0]; wR = wR + 1) {\n          var dyR = (${l}(dyCorner.x) + ${l}(wR)) / ${l}(strides.x);\n          let wRPerm = filterDims[0] - 1 - wR;\n          if (dyR < 0.0 || dyR >= ${l}(outBackprop[1]) ||\n              fract(dyR) > 0.0 || wRPerm < 0) {\n            continue;\n          }\n          let idyR: u32 = u32(dyR);\n\n          for (var wC: u32 = 0; wC < filterDims[1]; wC = wC + 1) {\n            let dyC = (${l}(dyCorner.y) + ${l}(wC)) / ${l}(strides.y);\n            let dyC2 = (${l}(dyCorner.y) + 1.0 + ${l}(wC)) / ${l}(strides.y);\n            let wCPerm = filterDims[1] - 1 - wC;\n            if (wCPerm < 0) {\n              continue;\n            }\n            var bDyCVal = true;\n            var bDyCVal2 = true;\n            if (dyC < 0.0 || dyC >= ${l}(outBackprop[2]) ||\n                fract(dyC) > 0.0) {\n              bDyCVal = false;\n            }\n            if (dyC2 < 0.0 || dyC2 >= ${l}(outBackprop[2]) ||\n                fract(dyC2) > 0.0) {\n              bDyCVal2 = false;\n            }\n\n            let idyC: u32 = u32(dyC);\n            let idyC2: u32 = u32(dyC2);\n            if (bDyCVal && bDyCVal2) {\n              let d2Length = outBackprop[3];\n              for (var d2 :u32 = 0; d2 < d2Length; d2 = d2 + 4) {\n                let wValue0 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1","d2")};\n                let wValue1 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 1","d2")};\n                let wValue2 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 2","d2")};\n                let wValue3 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 3","d2")};\n\n                var xValue = ${z.get("batch","idyR","idyC","d2")};\n                let tmpval = vec4<${l}>(dot(xValue, wValue0),\n                                      dot(xValue, wValue1),\n                                      dot(xValue, wValue2),\n                                      dot(xValue, wValue3));\n                dotProd[0] = dotProd[0] + tmpval;\n\n                xValue =  ${z.get("batch","idyR","idyC2","d2")};\n\n                dotProd[1] = dotProd[1] + vec4<${l}>(dot(xValue, wValue0),\n                                                    dot(xValue, wValue1),\n                                                    dot(xValue, wValue2),\n                                                    dot(xValue, wValue3));\n              }\n            } else if (bDyCVal) {\n              let d2Length = outBackprop[${g}];\n              for (var d2: u32 = 0; d2 < d2Length; d2 = d2 + 4) {\n                let wValue0 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1","d2")};\n                let wValue1 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 1","d2")};\n                let wValue2 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 2","d2")};\n                let wValue3 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 3","d2")};\n\n                var xValue = ${z.get("batch","idyR","idyC","d2")};\n                let tmpval = vec4<${l}>(dot(xValue, wValue0),\n                                      dot(xValue, wValue1),\n                                      dot(xValue, wValue2),\n                                      dot(xValue, wValue3));\n                dotProd[0] = dotProd[0] + tmpval;\n              }\n            } else if (bDyCVal2) {\n              let d2Length = outBackprop[3];\n              for (var d2: u32 = 0; d2 < d2Length; d2 = d2 + 4) {\n                let wValue0 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1","d2")};\n                let wValue1 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 1","d2")};\n                let wValue2 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 2","d2")};\n                let wValue3 = ${A.get("u32(wRPerm)","u32(wCPerm)","d1 + 3","d2")};\n\n                var xValue = ${z.get("batch","idyR","idyC2","d2")};\n                let tmpval = vec4<${l}>(dot(xValue, wValue0),\n                                      dot(xValue, wValue1),\n                                      dot(xValue, wValue2),\n                                      dot(xValue, wValue3));\n                dotProd[1] = dotProd[1] + tmpval;\n              }\n            }\n          }\n        }\n\n        for (var i: u32 = 0; i < ${w}; i = i + 1) {\n          let value = dotProd[i] + ${n?"bias[c+i]":`vec4<${l}>(0.0)`};\n          ${V.set("batch","r","c + i","d1","value")};\n        }\n      }`,N=`\n          let outputIndices = ${V.offsetToIndices("global_idx")};\n          let batch = ${V.indicesGet("outputIndices",0)};\n          let d1 = ${V.indicesGet("outputIndices",g)};\n          let r = ${V.indicesGet("outputIndices",p)};\n          let c = ${V.indicesGet("outputIndices",h)};\n          let dyCorner = vec2<i32>(i32(r), i32(c)) - pads;\n          let dyRCorner = dyCorner.x;\n          let dyCCorner = dyCorner.y;\n          let groupId = d1 / ${$};\n          let wOutChannel = d1 - groupId * ${$};\n          // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n          // ? = to be determined. : = across all values in that axis.\n          var dotProd = ${l}(0.0);\n          for (var wR: u32 = 0; wR < effectiveFilterDims.x; wR = wR + 1) {\n            if (wR % dilations.x != 0) {\n              continue;\n            }\n            let dyR = (${l}(dyRCorner) + ${l}(wR)) / ${l}(strides[0]);\n            let wRPerm = filterDims.x - 1 - wR / dilations.x;\n            if (dyR < 0.0 || dyR >= ${l}(outBackprop[${p}]) || fract(dyR) > 0.0 ||\n                wRPerm < 0) {\n              continue;\n            }\n            let idyR: u32 = u32(dyR);\n\n            for (var wC: u32 = 0; wC < effectiveFilterDims.y; wC = wC + 1) {\n              if (wC % dilations.y != 0) {\n                continue;\n              }\n              let dyC = (${l}(dyCCorner) + ${l}(wC)) / ${l}(strides.y);\n              let wCPerm = filterDims.y - 1 - wC / dilations.y;\n              if (dyC < 0.0 || dyC >= ${l}(outBackprop[${h}]) ||\n                  fract(dyC) > 0.0 || wCPerm < 0) {\n                continue;\n              }\n              let idyC: u32 = u32(dyC);\n              var inputChannel = groupId * ${I};\n              for (var d2: u32 = 0; d2 < ${I}; d2 = d2 + 1) {\n                let xValue = ${a?z.get("batch","idyR","idyC","inputChannel"):z.get("batch","inputChannel","idyR","idyC")};\n                let wValue = ${A.get("inputChannel","wOutChannel","u32(wRPerm)","u32(wCPerm)")};\n                dotProd = dotProd + xValue * wValue;\n                inputChannel = inputChannel + 1;\n              }\n            }\n          }\n          let value = dotProd + ${n?"bias[d1]":`${l}(0.0)`};\n          ${V.setByOffset("global_idx","value")};\n        `;return`\n  ${e.declareVariables(...R,V)}\n  ${x}\n  const outShape : vec4<u32> = vec4<u32>(${o.join(",")});\n  const outBackprop : vec4<u32> = vec4<u32>(${t[0].dims.join(",")});\n  const strides : vec2<u32> = vec2<u32>(${r.strides[0]}, ${r.strides[1]});\n  const filterDims : vec2<u32> = vec2<u32>(${r.kernelShape[a?1:2]}, ${r.kernelShape[a?2:3]});\n  const dilations : vec2<u32> = vec2<u32>(${r.dilations[0]}, ${r.dilations[1]});\n  const effectiveFilterDims : vec2<u32> = filterDims + vec2<u32>(\n          ${r.dilations[0]<=1?0:(r.kernelShape[a?1:2]-1)*(r.dilations[0]-1)},\n          ${r.dilations[1]<=1?0:(r.kernelShape[a?2:3]-1)*(r.dilations[1]-1)});\n  const pads : vec2<i32> = vec2<i32>(i32(effectiveFilterDims[0]) - 1 - (${r.pads[0]+r.pads[2]})/2,\n                                     i32(effectiveFilterDims[1]) - 1 - (${r.pads[1]+r.pads[3]})/2);\n    ${e.mainStart()}\n    ${e.guardAgainstOutOfBoundsWorkgroupSizes(b)};\n  ${u?T:N}}`},Kn=(e,t,r)=>{let o=e.length>2,n=t.outputShape,s=U.size(n),u=[Math.ceil(s/64),1,1];Be("verbose",()=>`[conv2d_backprop_webgpu] dispatch = ${u}`);let l=Le(e[0].dataType);return{name:"ConvTranspose2D",shaderCache:{hint:t.cacheKey},getRunData:()=>({dispatchGroup:{x:u[0],y:u[1],z:u[2]},outputs:[{dims:r?r(n):n,dataType:e[0].dataType}]}),getShaderSource:a=>gl(a,e,t,n,o,u[1]===1&&u[2]===1,!1,l)}}});var yl,bl,wl,Zi,Qi,vl,$l,Sl,xl,Xi,Ji=j(()=>{"use strict";je();Ki();Yi();It();jt();yl=(e,t,r,o,n,s)=>(e-1)*t+r+(o-1)*n+1-s,bl=(e,t,r,o,n)=>{let s=Math.floor(e/2);t==="SAME_UPPER"?(r[o]=s,r[n]=e-s):t==="SAME_LOWER"&&(r[o]=e-s,r[n]=s)},wl=(e,t,r,o,n,s,u,l,a,p)=>{let h=e.length-2,g=p.length===0;if(a.length===0)for(let y=0;y<h;++y)a.push(0);let b=e[0],w=t[l?3:1]*n;for(let y=0,_=e.length-h-(l?1:0);y<h;++y,++_){let I=e[_],$=g?I*u[y]:p[y],x=yl(I,u[y],s[y],t[_],r[y],$);bl(x,o,s,y,y+h),g&&p.push(u[y]*(I-1)+a[y]+(t[_]-1)*r[y]+1-s[y]-s[y+h])}p.splice(0,0,b),p.splice(l?3:1,0,w)},Zi=(e,t)=>{let r=e.kernelShape.slice();if(e.kernelShape.length===0||e.kernelShape.reduce((b,w)=>b*w,1)===0){r.length=0;for(let b=2;b<t[1].dims.length;++b)r.push(t[1].dims[b])}let o=e.format==="NHWC";r.splice(0,0,t[1].dims[0]),r.splice(o?3:1,0,t[1].dims[1]);let n=e.pads.slice(),s=e.outputShape.slice(),u=e.outputPadding.slice(),l=t[0].dims,a=e.dilations.slice();if(a.reduce((b,w)=>b+w,0)===0){let b=t[0].dims.length-2;a=new Array(b).fill(1)}let p=e.strides.slice();if(p.reduce((b,w)=>b+w,0)===0){let b=t[0].dims.length-2;p=new Array(b).fill(1)}wl(l,r,a,e.autoPad,e.group,n,p,o,u,s);let h=Object.assign({},e),g=e.cacheKey+[r.join("n,"),n.join(","),p.join(","),u.join(","),s.join(","),a.join(",")].join("_");return Object.assign(h,{kernelShape:r,pads:n,outputPadding:u,outputShape:s,dilations:a,strides:p,cacheKey:g}),h},Qi=e=>{let t=Qr(e),r=e.format,o=["NOTSET","VALID","SAME_UPPER","SAME_LOWER"][typeof e.autoPad>"u"?0:e.autoPad],n=e.dilations,s=e.group,u=e.kernelShape,l=e.pads,a=e.strides,p=e.wIsConst(),h=e.outputPadding,g=e.outputShape;return ge({autoPad:o,format:r,dilations:n,group:s,kernelShape:u,outputPadding:h,outputShape:g,pads:l,strides:a,wIsConst:p,...t})},vl=(e,t)=>{if(!e||e.length!==2&&e.length!==3)throw new Error("Conv requires 2 or 3 inputs");if(e[0].dims.length!==4&&e[0].dims.length!==3)throw new Error("currently only support 2-dimensional conv");if(e[0].dims.length!==e[1].dims.length)throw new Error("filter does not have same dimension as input");let r=e[0].dims[t.format==="NHWC"?e[0].dims.length-1:1],o=e[1].dims[0];if(r!==o)throw new Error("FILTER_IN_CHANNEL should be equal to DATA_CHANNEL");let n=e[1].dims[1]*t.group;if(e.length===3&&(e[2].dims.length!==1||e[2].dims[0]!==n))throw new Error("invalid bias");let s=e[0].dims.length-2;if(t.dilations.reduce((h,g)=>h+g,0)>0&&t.dilations.length!==s)throw new Error(`dilations should be ${s}D`);if(t.strides.reduce((h,g)=>h+g,0)>0&&t.strides.length!==s)throw new Error(`strides should be ${s}D`);if(t.pads.reduce((h,g)=>h+g,0)>0&&t.pads.length!==s*2)throw new Error(`pads should be ${s*2}D`);if(t.outputPadding.length!==s&&t.outputPadding.length!==0)throw new Error(`output_padding should be ${s}D`);if(t.kernelShape.reduce((h,g)=>h+g,0)>0&&t.kernelShape.length!==0&&t.kernelShape.length!==e[1].dims.length-2)throw new Error("invalid kernel shape");if(t.outputShape.length!==0&&t.outputShape.length!==e[0].dims.length-2)throw new Error("invalid output shape")},$l=[2,3,1,0],Sl=(e,t,r)=>{let o=Zi(r,t),n=r.format==="NHWC",s=o.outputShape,u=s[n?3:1],l=t[0].dims[n?3:1];if(o.group!==1||u===1&&l===1){e.compute(Kn(t,o));return}let a=s[n?1:2],p=s[n?2:3],h=t[1].dims[2],g=t[1].dims[3],b=n?a*p:u,w=n?u:a*p,y=h*g*l,_=!0,I=e.kernelCustomData.wT??e.compute(it(t[1],$l),{inputs:[1],outputs:[r.wIsConst?-2:-1]})[0];r.wIsConst&&!e.kernelCustomData.wT&&(e.kernelCustomData.wT=I);let $=[t[0],I],x=t.length===3;x&&(!n&&t[2].dims.length===1?$.push(t[2].reshape([t[2].dims[0],1,1])):$.push(t[2])),e.compute(qi($,o,s,b,w,y,x,_),{inputs:$})},xl=(e,t)=>{let r=t.format==="NHWC",o=[e.inputs[0].reshape(r?[e.inputs[0].dims[0],1,e.inputs[0].dims[1],e.inputs[0].dims[2]]:[e.inputs[0].dims[0],e.inputs[0].dims[1],1,e.inputs[0].dims[2]]),e.inputs[1].reshape([e.inputs[1].dims[0],e.inputs[1].dims[1],1,e.inputs[1].dims[2]])];o.length===3&&o.push(e.inputs[2]);let n=t.kernelShape;(n.length===0||n[0]===0)&&(n=[e.inputs[1].dims[2]]);let s=t.dilations;(s.length===0||s[0]===0)&&(s=[1]);let u=t.strides;(u.length===0||u[0]===0)&&(u=[1]);let l=t.pads;l.length===0&&(l=[0,0]),l=[0,l[0],0,l[1]],u=[1].concat(u),s=[1].concat(s),n=[1].concat(n);let a=Zi({...t,pads:l,strides:u,dilations:s,kernelShape:n},o);e.compute(Kn(o,a,p=>r?[p[0],p[2],p[3]]:[p[0],p[1],p[3]]))},Xi=(e,t)=>{vl(e.inputs,t),e.inputs[0].dims.length===3?xl(e,t):Sl(e,e.inputs,t)}});var _l,es,ts,rs=j(()=>{"use strict";Ne();$e();je();ve();_l=(e,t,r,o)=>{let n=U.size(t),s=t.length,u=M("input",e,s),l=F("output",e,s),a=r.dataType===6?r.getInt32Array()[0]:Number(r.getBigInt64Array()[0]),p=U.normalizeAxis(a,s),h=g=>{let b=` i32(${u.indicesGet("inputIndices","uniforms.axis")}) `,w=ce("uniforms.input_shape","uniforms.axis",s),y=o.reverse?b+(o.exclusive?" + 1":""):"0",_=o.reverse?w:b+(o.exclusive?"":" + 1");return`\n                ${g.registerUniform("outputSize","u32").registerUniform("axis","u32").declareVariables(u,l)}\n                ${g.mainStart()}\n                  ${g.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n                  var inputIndices = ${l.offsetToIndices("global_idx")};\n                  var sum = ${l.type.value}(0);\n                  let first : i32 = ${y};\n                  let last : i32 = ${_};\n                  for (var i : i32 = first; i < last; i++) {\n                    ${u.indicesSet("inputIndices","uniforms.axis","u32(i)")};\n                    sum = sum + ${u.getByIndices("inputIndices")};\n                  }\n                  ${l.setByOffset("global_idx","sum")};\n                }`};return{name:"CumSum",shaderCache:{hint:o.cacheKey,inputDependencies:["rank"]},getRunData:()=>({outputs:[{dims:t,dataType:e}],dispatchGroup:{x:Math.ceil(n/64)},programUniforms:[{type:"uint32",data:n},{type:"int32",data:p},...L(t),...L(t)]}),getShaderSource:h}},es=(e,t)=>{let r=e.inputs[0].dims,o=e.inputs[0].dataType,n=e.inputs[1];e.compute(_l(o,r,n,t),{inputs:[0]})},ts=e=>{let t=e.exclusive===1,r=e.reverse===1;return ge({exclusive:t,reverse:r})}});var Yn,rn,ns,Cl,Il,Zn,Qn,os,Al,as,is,ss=j(()=>{"use strict";$e();je();ve();Yn="[a-zA-Z]|\\\\.\\\\.\\\\.",rn="("+Yn+")+",ns="^"+rn+"$",Cl="("+rn+",)*"+rn,Il="^"+Cl+"$",Zn=class{constructor(t=-1){this.symbolToIndices=new Map,this.inputIndex=t}addSymbol(t,r){let o=this.symbolToIndices.get(t);o===void 0?o=[r]:o.push(r),this.symbolToIndices.set(t,o)}},Qn=class{constructor(t,r){this.equation=r;this.hasEllipsis=!1,this.symbolToInfo=new Map,this.lhs=new Array,this.outputDims=[];let[o,n]=r.includes("->")?r.split("->",2):[r,""];if(!o.match(RegExp(Il)))throw new Error("Invalid LHS term");if(o.split(",").forEach((l,a)=>{let p=t[a].dims.slice();if(!l.match(RegExp(ns)))throw new Error("Invalid LHS term");let h=this.processTerm(l,!0,p,a);this.lhs.push(h)}),n==="")n+=[...this.symbolToInfo.entries()].filter(([l,a])=>a.count===1||l==="...").map(([l])=>l).join("");else if(!n.match(RegExp(rn)))throw new Error("Invalid RHS");n.match(RegExp(Yn,"g"))?.forEach(l=>{if(l==="...")this.outputDims=this.outputDims.concat(this.ellipsisDims);else{let a=this.symbolToInfo.get(l);if(a===void 0)throw new Error("Invalid RHS symbol");this.outputDims.push(a.dimValue)}}),this.rhs=this.processTerm(n,!1,this.outputDims)}addSymbol(t,r,o){let n=this.symbolToInfo.get(t);if(n!==void 0){if(n.dimValue!==r&&n.count!==1)throw new Error("Dimension mismatch");n.count++,n.inputIndices.push(o)}else n={count:1,dimValue:r,inputIndices:[o]};this.symbolToInfo.set(t,n)}processTerm(t,r,o,n=-1){let s=o.length,u=!1,l=[],a=0;if(!t.match(RegExp(ns))&&!r&&t!=="")throw new Error("Invalid LHS term");let p=t.match(RegExp(Yn,"g")),h=new Zn(n);return p?.forEach((g,b)=>{if(g==="..."){if(u)throw new Error("Only one ellipsis is allowed per input term");u=!0;let w=s-p.length+1;if(w<0)throw new Error("Ellipsis out of bounds");if(l=o.slice(a,a+w),this.hasEllipsis){if(this.ellipsisDims.length!==l.length||this.ellipsisDims.toString()!==l.toString())throw new Error("Ellipsis dimensions mismatch")}else if(r)this.hasEllipsis=!0,this.ellipsisDims=l;else throw new Error("Ellipsis must be specified in the LHS");for(let y=0;y<l.length;y++){let _=String.fromCharCode("0".charCodeAt(0)+y);h.addSymbol(_,b+y),this.addSymbol(_,o[a++],n)}}else h.addSymbol(g,b+(this.hasEllipsis?this.ellipsisDims.length-1:0)),this.addSymbol(g,o[a++],n)}),h}},os=e=>e+"_max",Al=(e,t,r,o,n)=>{let u=t.map((w,y)=>e[y]?w.length:w).map((w,y)=>M(`input${y}`,r,w)),l=U.size(n),a=Re(n.length),p=a?n.length:n,h=F("output",r,p),g=[...o.symbolToInfo.keys()].filter(w=>!o.rhs.symbolToIndices.has(w)),b=w=>{let y=[],_="var prod = 1.0;",I="var sum = 0.0;",$="sum += prod;",x=[],E=[],A=[],z=[],R=o.symbolToInfo.size===o.rhs.symbolToIndices.size;o.symbolToInfo.forEach((T,N)=>{if(o.rhs.symbolToIndices.has(N)){let te=o.rhs.symbolToIndices.get(N)?.[0];te!==void 0&&o.lhs.forEach((Y,K)=>{if(T.inputIndices.includes(K)){let Q=Y.symbolToIndices.get(N);if(Q===void 0)throw new Error("Invalid symbol error");Q.forEach(Z=>{y.push(`${u[K].indicesSet(`input${K}Indices`,Z,h.indicesGet("outputIndices",te))}`)})}})}else o.lhs.forEach((te,Y)=>{if(T.inputIndices.includes(Y)){let K=te.symbolToIndices.get(N);if(K===void 0)throw new Error("Invalid symbol error");K.forEach(Q=>{x.push(`${u[Y].indicesSet(`input${Y}Indices`,Q,`${N}`)}`)}),z.push(`prod *= ${u[Y].getByIndices(`input${Y}Indices`)};`)}}),E.push(`for(var ${N}: u32 = 0; ${N} < uniforms.${os(N)}; ${N}++) {`),A.push("}")});let V=R?[...y,`let sum = ${u.map((T,N)=>T.getByIndices(`input${N}Indices`)).join(" * ")};`]:[...y,I,...E,...x,_,...z,$,...A];return`\n            ${w.registerUniforms(g.map(T=>({name:`${os(T)}`,type:"u32"}))).registerUniform("outputSize","u32").declareVariables(...u,h)}\n\n            ${w.mainStart()}\n            ${w.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n            var outputIndices = ${h.offsetToIndices("global_idx")};\n            ${u.map((T,N)=>`var input${N}Indices: ${u[N].type.indices};`).join(`\n`)}\n            ${V.join(`\n`)};\n            ${h.setByOffset("global_idx","sum")};\n          }`};return{name:"Einsum",shaderCache:{hint:o.equation,inputDependencies:e.map(w=>w?"rank":"dims")},getRunData:()=>{let w=g.filter(_=>o.symbolToInfo.has(_)).map(_=>({type:"uint32",data:o.symbolToInfo.get(_)?.dimValue||0}));w.push({type:"uint32",data:l});let y=t.filter((_,I)=>e[I]).map((_,I)=>[...L(_)]).reduce((_,I)=>_.concat(I),w);return a&&y.push(...L(n)),{outputs:[{dims:n,dataType:r}],dispatchGroup:{x:Math.ceil(l/64)},programUniforms:y}},getShaderSource:b}},as=(e,t)=>{let r=new Qn(e.inputs,t.equation),o=e.inputs.map((u,l)=>Re(u.dims.length)),n=r.outputDims,s=e.inputs.map((u,l)=>u.dims);e.compute(Al(o,s,e.inputs[0].dataType,r,n))},is=e=>{let t=e.equation.replace(/\\s+/g,"");return ge({equation:t})}});var Tl,us,El,Ol,ds,ls=j(()=>{"use strict";Ne();$e();ve();Tl=e=>{if(!e||e.length!==2)throw new Error("Expand requires 2 input.");let t=e[0].dims,r=Array.from(e[1].getBigInt64Array(),Number),o=r.length<t.length?0:r.length-t.length,n=t.length<r.length?0:t.length-r.length;for(;o<r.length&&n<t.length;++o,++n)if(r[o]!==t[n]&&r[o]!==1&&t[n]!==1)throw new Error("Expand requires shape to be broadcastable to input")},us=(e,t)=>{let r=e.length-t.length,o=[];for(let n=0;n<r;++n)o.push(e[n]);for(let n=0;n<t.length;++n)o.push(t[n]===1?e[n+r]:t[n]);return o},El=(e,t)=>e.length>t.length?us(e,t):us(t,e),Ol=e=>{let t=e[0].dims,r=Array.from(e[1].getBigInt64Array(),Number),o=El(t,r),n=e[0].dataType,s=n===9?4:1,u=Math.ceil(U.size(o)/s),l=Re(t.length),a=Re(o.length),p=g=>{let b=l?t.length:t,w=a?o.length:o,y=M("input",n,b,s),_=F("output",n,w,s),I;if(n===9){let $=(x,E,A="")=>`\n          let outputIndices${E} = ${_.offsetToIndices(`outputOffset + ${E}u`)};\n          let offset${E} = ${y.broadcastedIndicesToOffset(`outputIndices${E}`,_)};\n          let index${E} = offset${E} / 4u;\n          let component${E} = offset${E} % 4u;\n          ${x}[${E}] = ${A}(${y.getByOffset(`index${E}`)}[component${E}]);\n        `;I=`\n        let outputOffset = global_idx * ${s};\n        var data = vec4<u32>(0);\n        ${$("data",0,"u32")}\n        ${$("data",1,"u32")}\n        ${$("data",2,"u32")}\n        ${$("data",3,"u32")}\n        ${_.setByOffset("global_idx","data")}\n      }`}else I=`\n        let outputIndices = ${_.offsetToIndices("global_idx")};\n        let inputOffset = ${y.broadcastedIndicesToOffset("outputIndices",_)};\n        ${_.setByOffset("global_idx",y.getByOffset("inputOffset"))}\n      }`;return`\n    ${g.registerUniform("vec_size","u32").declareVariables(y,_)}\n    ${g.mainStart()}\n    ${g.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}\n    ${I}`},h=[{type:"uint32",data:u}];return l&&h.push(...L(t)),a&&h.push(...L(o)),{name:"Expand",shaderCache:{hint:`${o.length}`,inputDependencies:[l?"rank":"dims"]},getShaderSource:p,getRunData:()=>({outputs:[{dims:o,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(u/64)},programUniforms:h})}},ds=e=>{Tl(e.inputs),e.compute(Ol(e.inputs),{inputs:[0]})}});var Pl,kl,cs,ps,ms=j(()=>{"use strict";Ne();$e();je();ve();Pl=e=>{if(!e||e.length!==2)throw new Error("Gather requires 2 inputs.")},kl=(e,t)=>{let r=e[0].dims,o=e[1].dims,n=r.length,s=U.normalizeAxis(t.axis,n),u=r.slice(0);u.splice(s,1,...o);let l=r[s],a=e[0].dataType===9?4:1,p=Math.ceil(U.size(u)/a),h=Re(e[0].dims.length),g=h?e[0].dims.length:e[0].dims,b=Re(e[1].dims.length),w=b?e[1].dims.length:e[1].dims,y=Re(u.length),_=y?u.length:u,I=[{type:"uint32",data:p},{type:"int32",data:l},{type:"uint32",data:s}];h&&I.push(...L(e[0].dims)),b&&I.push(...L(e[1].dims)),y&&I.push(...L(u));let $=[];$.push(h?"rank":"dims"),$.push(b?"rank":"dims");let x=E=>{let A=M("data",e[0].dataType,g,a),z=M("inputIndices",e[1].dataType,w),R=F("output",e[0].dataType,_,a),V=N=>{let te=o.length,Y=`var indicesIndices${N}  = ${z.type.indices}(0);`;for(let K=0;K<te;K++)Y+=`${te>1?`indicesIndices${N}[${K}]`:`indicesIndices${N}`} = ${u.length>1?`outputIndices${N}[uniforms.axis + ${K}]`:`outputIndices${N}`};`;Y+=`\n          var idx${N} = ${z.getByIndices(`indicesIndices${N}`)};\n          if (idx${N} < 0) {\n            idx${N} = idx${N} + uniforms.axisDimLimit;\n          }\n          var dataIndices${N} = ${A.type.indices}(0);\n        `;for(let K=0,Q=0;K<n;K++)K===s?(Y+=`${n>1?`dataIndices${N}[${K}]`:`dataIndices${N}`} = u32(idx${N});`,Q+=te):(Y+=`${n>1?`dataIndices${N}[${K}]`:`dataIndices${N}`} = ${u.length>1?`outputIndices${N}[${Q}]`:`outputIndices${N}`};`,Q++);return Y},T;if(e[0].dataType===9){let N=(te,Y,K="")=>`\n          let outputIndices${Y} = ${R.offsetToIndices(`outputOffset + ${Y}u`)};\n          ${V(Y)};\n          let offset${Y} = ${A.indicesToOffset(`dataIndices${Y}`)};\n          let index${Y} = offset${Y} / 4u;\n          let component${Y} = offset${Y} % 4u;\n          ${te}[${Y}] = ${K}(${A.getByOffset(`index${Y}`)}[component${Y}]);\n        `;T=`\n        let outputOffset = global_idx * ${a};\n        var value = vec4<u32>(0);\n        ${N("value",0,"u32")}\n        ${N("value",1,"u32")}\n        ${N("value",2,"u32")}\n        ${N("value",3,"u32")}\n        ${R.setByOffset("global_idx","value")}\n      `}else T=`\n      let outputIndices = ${R.offsetToIndices("global_idx")};\n      ${V("")};\n      let value = ${A.getByIndices("dataIndices")};\n      ${R.setByOffset("global_idx","value")};\n      `;return`\n      ${E.registerUniform("outputSize","u32").registerUniform("axisDimLimit","i32").registerUniform("axis","u32").declareVariables(A,z,R)}\n      ${E.mainStart()}\n        ${E.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n        ${T}\n      }`};return{name:"Gather",shaderCache:{hint:t.cacheKey,inputDependencies:$},getRunData:()=>({outputs:[{dims:u,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(p/64)},programUniforms:I}),getShaderSource:x}},cs=e=>ge({axis:e.axis}),ps=(e,t)=>{let r=e.inputs;Pl(r),e.compute(kl(e.inputs,t))}});var Rl,Bl,fs,hs,gs=j(()=>{"use strict";$e();je();ve();Rl=e=>{if(!e||e.length!==2)throw new Error("GatherElements requires 2 inputs.");if(e[0].dims.length<1)throw new Error("GatherElements requires that the data input be rank >= 1.");if(e[0].dims.length!==e[1].dims.length)throw new Error(`GatherElements requires that the data input and\n                     indices input tensors be of same rank.`)},Bl=(e,t)=>{let r=e[0].dims,o=e[0].dataType,n=r.length,s=e[1].dims,u=e[1].dataType,l=U.normalizeAxis(t.axis,n),a=r[l],p=s.slice(0),h=U.size(p),g=M("input",o,n),b=M("indicesInput",u,s.length),w=F("output",o,p.length),y=[{type:"uint32",data:h},{type:"int32",data:a},{type:"uint32",data:l}];return y.push(...L(r)),y.push(...L(s)),y.push(...L(p)),{name:"GatherElements",shaderCache:{inputDependencies:["rank","rank"]},getRunData:()=>({outputs:[{dims:p,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(h/64)},programUniforms:y}),getShaderSource:$=>`\n      ${$.registerUniform("outputSize","u32").registerUniform("axisDimLimit","i32").registerUniform("axis","u32").declareVariables(g,b,w)}\n      ${$.mainStart()}\n      ${$.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n\n      let outputIndices = ${w.offsetToIndices("global_idx")};\n\n      var idx = ${b.getByOffset("global_idx")};\n      if (idx < 0) {\n        idx = idx + uniforms.axisDimLimit;\n      }\n      var inputIndices = ${g.type.indices}(outputIndices);\n      ${g.indicesSet("inputIndices","uniforms.axis","u32(idx)")};\n      let value = ${g.getByIndices("inputIndices")};\n\n      ${w.setByOffset("global_idx","value")};\n  }`}},fs=e=>ge({axis:e.axis}),hs=(e,t)=>{let r=e.inputs;Rl(r),e.compute(Bl(e.inputs,t))}});var Dl,Ml,ys,bs,ws=j(()=>{"use strict";$e();ve();Dl=e=>{if(!e)throw new Error("Input is missing");if(e.length<2||e.length>3)throw new Error("Invaid input number.");if(e.length===3&&e[2].dims.length>2)throw new Error("Invalid input shape of C");if(e[0].dataType!==e[1].dataType||e.length===3&&e[0].dataType!==e[2].dataType)throw new Error("Input types are mismatched")},Ml=(e,t)=>{let r=e[0].dims.slice(),o=e[1].dims.slice(),[n,s,u]=Hr.getShapeOfGemmResult(r,t.transA,o,t.transB,e.length===3?e[2].dims:void 0),l=[n,s];if(!l)throw new Error("Can\'t use gemm on the given tensors");let a=U.size(l),p=[{type:"uint32",data:a},{type:"uint32",data:n},{type:"uint32",data:s},{type:"uint32",data:u},{type:"float32",data:t.alpha},{type:"float32",data:t.beta}],h=["type","type"];e.length===3&&(p.push(...L(e[2].dims)),h.push("rank")),p.push(...L(l));let g=b=>{let w="";t.transA&&t.transB?w="value += a[k * uniforms.M + m] * b[n * uniforms.K + k];":t.transA&&!t.transB?w="value += a[k * uniforms.M + m] * b[k * uniforms.N + n];":!t.transA&&t.transB?w="value += a[m * uniforms.K + k] * b[n * uniforms.K + k];":!t.transA&&!t.transB&&(w="value += a[m * uniforms.K + k] * b[k * uniforms.N + n];");let y=t.alpha===1?"":"value *= uniforms.alpha;",_=M("a",e[0].dataType,e[0].dims),I=M("b",e[1].dataType,e[1].dims),$=_.type.value,x=null,E=[_,I];e.length===3&&(x=M("c",e[2].dataType,e[2].dims.length),E.push(x));let A=F("output",e[0].dataType,l.length);E.push(A);let z=[{name:"output_size",type:"u32"},{name:"M",type:"u32"},{name:"N",type:"u32"},{name:"K",type:"u32"},{name:"alpha",type:"f32"},{name:"beta",type:"f32"}];return`\n  ${b.registerUniforms(z).declareVariables(...E)}\n\n  ${b.mainStart()}\n    ${b.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n\n    let m = global_idx / uniforms.N;\n    let n = global_idx % uniforms.N;\n\n    var value = ${$}(0);\n    for (var k: u32 = 0u; k < uniforms.K; k++) {\n      ${w}\n    }\n\n    ${y}\n    ${(()=>x!=null?`let cOffset = ${x.broadcastedIndicesToOffset("vec2(m, n)",A)}; value += ${$}(uniforms.beta) * ${x.getByOffset("cOffset")};`:"")()}\n    output[global_idx] = value;\n  }`};return{name:"Gemm",shaderCache:{hint:`${t.cacheKey}`,inputDependencies:h},getRunData:()=>({outputs:[{dims:l,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(a/64)},programUniforms:p}),getShaderSource:g}},ys=e=>{let t=e.transA,r=e.transB,o=e.alpha,n=e.beta;return{transA:t,transB:r,alpha:o,beta:n,cacheKey:`${e.transA};${e.transB};${e.alpha===1}`}},bs=(e,t)=>{Dl(e.inputs),e.compute(Ml(e.inputs,t))}});var zl,Ul,Vl,vs,$s=j(()=>{"use strict";Ne();$e();ve();zl=(e,t)=>{let r=e[0].dims,o=r,n=2,s=U.sizeToDimension(r,n),u=U.sizeFromDimension(r,n),l=Fe(u),a=u/l,p=[r[0],r[1],a],h=["rank","type","type"],g=[{type:"uint32",data:u},{type:"uint32",data:a}];g.push(...L(p),...L(p));let b=w=>{let y=M("x",e[0].dataType,p.length,l),_=M("scale",e[1].dataType,e[1].dims),I=M("bias",e[2].dataType,e[2].dims),$=F("output",e[0].dataType,p.length,l),x=[y,_,I,$],E=y.type.value,A=l===1?"f32":`vec${l}<f32>`,z=64,R=[{name:"normSize",type:"u32"},{name:"normPackedSize",type:"u32"}];return`\n  var<workgroup> meanShared : f32;\n  var<workgroup> squaredNormShared : f32;\n  var<workgroup> workgroupShared : array<${A}, ${z}>;\n  const workgroupSize = ${z}u;\n  ${w.registerUniforms(R).declareVariables(...x)}\n  ${w.mainStart(z)}\n    let norm = global_idx / workgroupSize;\n    let batch = norm / uniforms.x_shape[1];\n    let channel = norm % uniforms.x_shape[1];\n    let localIndex = local_id.x;\n\n    // initialize workgroup memory\n    var initial = ${A}(0);\n    for (var h = localIndex; h < uniforms.normPackedSize; h += workgroupSize) {\n      initial = initial + ${A}(${y.get("batch","channel","h")});\n    }\n    workgroupShared[localIndex] = initial;\n    workgroupBarrier();\n\n    // Calculate the mean of current channel data.\n    for (var currSize = workgroupSize >> 1;  currSize > 0; currSize = currSize >> 1) {\n      if (localIndex < currSize) {\n        workgroupShared[localIndex] = workgroupShared[localIndex] + workgroupShared[localIndex + currSize];\n      }\n      workgroupBarrier();\n    }\n    if (localIndex == 0) {\n      meanShared = ${Je("workgroupShared[0]",l)} / f32(uniforms.normSize);\n    }\n    workgroupBarrier();\n\n    // reinitialize workgroup memory.\n    initial = ${A}(0);\n    for (var h = localIndex; h < uniforms.normPackedSize; h += workgroupSize) {\n      let deviation =  ${A}(${y.get("batch","channel","h")}) - ${A}(meanShared);\n      initial = initial + deviation * deviation;\n    }\n    workgroupShared[localIndex] = initial;\n    workgroupBarrier();\n\n    // Calculate the sum of square of deviation of current channel data.\n    for (var currSize = workgroupSize >> 1;  currSize > 0; currSize = currSize >> 1) {\n      if (localIndex < currSize) {\n        workgroupShared[localIndex] = workgroupShared[localIndex] + workgroupShared[localIndex + currSize];\n      }\n      workgroupBarrier();\n    }\n    if (localIndex == 0) {\n      squaredNormShared = ${Je("workgroupShared[0]",l)};\n    }\n    workgroupBarrier();\n\n    let invStdDev = inverseSqrt(squaredNormShared / f32(uniforms.normSize) + f32(${t.epsilon}));\n    let channelScale = invStdDev * f32(${_.getByOffset("channel")});\n    let channelShift = f32(${I.getByOffset("channel")}) - meanShared * channelScale;\n    for (var h = localIndex; h < uniforms.normPackedSize; h += workgroupSize) {\n      let value = ${y.get("batch","channel","h")} * ${E}(${A}(channelScale)) + ${E}(${A}(channelShift));\n      ${$.set("batch","channel","h","value")};\n    }\n  }`};return{name:"InstanceNormalization",shaderCache:{hint:`${t.epsilon};${l}`,inputDependencies:h},getRunData:()=>({outputs:[{dims:o,dataType:e[0].dataType}],dispatchGroup:{x:s},programUniforms:g}),getShaderSource:b}},Ul=(e,t,r,o,n,s,u,l)=>{let a=Fe(u),p=64,h=a===1?"vec2f":`mat2x${a}f`,g=a===1?"f32":`vec${a}f`,b=(R,V)=>`${h}(${R}, ${V})`,w=n*u/a,y=Math.ceil(s/p),_=["type"],I=[{type:"uint32",data:y},{type:"uint32",data:s},{type:"uint32",data:Math.floor(u/a)},{type:"uint32",data:Math.floor(s*u/a)}],$=R=>{let V=M("input",t.dataType,t.dims,a);return`\n  ${R.declareVariables(V)}\n  @group(0) @binding(1) var<storage, read_write> output : array<${h}>;\n  struct Uniforms {wg_size:u32, H:u32, C:u32, image_size:u32};\n  @group(0) @binding(2) var<uniform> uniforms: Uniforms;\n\n  ${R.mainStart(p)}\n    let currentImageNumber = global_idx / ${p} / uniforms.C;\n    let currentChannelNumber = (global_idx / ${p}) % uniforms.C;\n    let wgId = global_idx % ${p};\n    let wgOffset = wgId * uniforms.wg_size;\n    if (wgOffset >= uniforms.H) {\n        return;\n    }\n    let wgMax = min(wgOffset + uniforms.wg_size, uniforms.H);\n\n    let offset = currentImageNumber * uniforms.image_size + currentChannelNumber;\n    var sum = ${Ze("f32",a)};\n    var squaredSum = ${Ze("f32",a)};\n    for (var i: u32 = wgOffset; i < wgMax; i++) {\n        let value = ${g}(input[offset + i * uniforms.C]);\n        sum += value;\n        squaredSum += value * value;\n    }\n    output[global_idx] = ${b("sum","squaredSum")};\n  }`},x=e.compute({name:"InstanceNormComputeMean",shaderCache:{hint:`${a}`,inputDependencies:_},getRunData:()=>({outputs:[{dims:[n,u,p,2],dataType:1}],dispatchGroup:{x:n*u/a},programUniforms:I}),getShaderSource:$},{inputs:[t],outputs:[-1]})[0],E=[{type:"uint32",data:w},{type:"uint32",data:s},{type:"uint32",data:Math.floor(u/a)},{type:"uint32",data:Math.floor(p*u/a)}],A=["type","type","type"],z=R=>{let V=M("scale",r.dataType,r.dims,a),T=M("bias",o.dataType,o.dims,a);return`\n  @group(0) @binding(0) var<storage, read> input : array<${h}>;\n  @group(0) @binding(1) var<storage, read> scale : array<${V.type.storage}>;\n  @group(0) @binding(2) var<storage, read> bias : array<${T.type.storage}>;\n  @group(0) @binding(3) var<storage, read_write> output : array<${h}>;\n  struct Uniforms {units_of_work : u32, H: u32, C : u32, image_size : u32};\n  @group(0) @binding(4) var<uniform> uniforms: Uniforms;\n\n  ${R.mainStart()}\n    ${R.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.units_of_work")}\n    let currentImageNumber = global_idx / uniforms.C;\n    let currentChannelNumber = global_idx % uniforms.C;\n\n    let offset = currentImageNumber * uniforms.image_size;\n    var sum = ${Ze("f32",a)};\n    var squaredSum = ${Ze("f32",a)};\n    for (var i: u32 = 0; i < ${p}; i++) {\n        let value = input[offset + i + currentChannelNumber * ${p}];\n        sum += value[0];\n        squaredSum += value[1];\n    }\n    sum = sum / f32(uniforms.H);\n    squaredSum = squaredSum / f32(uniforms.H);\n    let invStdDev = inverseSqrt(squaredSum - sum * sum + f32(${l}));\n    let channelScale = invStdDev * ${g}(scale[currentChannelNumber]);\n    let channelShift = ${g}(bias[currentChannelNumber]) - sum * channelScale;\n\n    output[global_idx] = ${b("channelScale","channelShift")};\n  }`};return e.compute({name:"InstanceNormComputeChannelScaleShift",shaderCache:{hint:`${a};${l}`,inputDependencies:A},getRunData:()=>({outputs:[{dims:[n,u,2],dataType:1}],dispatchGroup:{x:Math.ceil(w/64)},programUniforms:E}),getShaderSource:z},{inputs:[x,r,o],outputs:[-1]})[0]},Vl=(e,t,r)=>{let o=t[0].dims,n=o,s=o[0],u=o[o.length-1],l=U.sizeFromDimension(o,1)/u,a=Fe(u),p=U.size(n)/a,h=[{type:"uint32",data:l},{type:"uint32",data:Math.floor(u/a)}],g=["type","type"],b=Ul(e,t[0],t[1],t[2],s,l,u,r.epsilon),w=y=>{let _=Le(t[0].dataType),I=a===1?"vec2f":`mat2x${a}f`,$=a===1?_:`vec${a}<${_}>`,x=M("input",t[0].dataType,t[0].dims,a),E=F("output",t[0].dataType,n,a);return`\n  @group(0) @binding(0) var<storage, read> input : array<${x.type.storage}>;\n  @group(0) @binding(1) var<storage, read> scaleInput : array<${I}>;\n  @group(0) @binding(2) var<storage, read_write> output : array<${E.type.storage}>;\n  struct Uniforms {H: u32, C : u32};\n  @group(0) @binding(3) var<uniform> uniforms: Uniforms;\n\n  ${y.mainStart()}\n    let currentImageNumber = global_idx / (uniforms.C * uniforms.H);\n    let currentChannelNumber = global_idx % uniforms.C;\n\n    let scaleOffset = currentImageNumber * uniforms.C + currentChannelNumber;\n    let scale = scaleInput[scaleOffset];\n    output[global_idx] = fma(input[global_idx], ${$}(scale[0]), ${$}(scale[1]));\n  }`};e.compute({name:"InstanceNormalizationNHWC",shaderCache:{hint:`${a}`,inputDependencies:g},getRunData:()=>({outputs:[{dims:n,dataType:t[0].dataType}],dispatchGroup:{x:Math.ceil(p/64)},programUniforms:h}),getShaderSource:w},{inputs:[t[0],b]})},vs=(e,t)=>{t.format==="NHWC"?Vl(e,e.inputs,t):e.compute(zl(e.inputs,t))}});var Nl,Wl,Ss,xs=j(()=>{"use strict";Ne();$e();ve();Nl=e=>{if(!e||e.length<2)throw new Error("layerNorm requires at least 2 inputs.")},Wl=(e,t,r)=>{let o=e[0].dims,n=e[1],s=e[2],u=o,l=U.normalizeAxis(t.axis,o.length),a=U.sizeToDimension(o,l),p=U.sizeFromDimension(o,l),h=U.size(n.dims),g=s?U.size(s.dims):0;if(h!==p||s&&g!==p)throw new Error(`Size of X.shape()[axis:] == ${p}.\n       Size of scale and bias (if provided) must match this.\n       Got scale size of ${h} and bias size of ${g}`);let b=[];for(let A=0;A<o.length;++A)A<l?b.push(o[A]):b.push(1);let w=Fe(p),y=["type","type"],_=[{type:"uint32",data:a},{type:"float32",data:p},{type:"uint32",data:Math.floor(p/w)},{type:"float32",data:t.epsilon}];s&&y.push("type");let I=r>1,$=r>2,x=A=>{let z=Le(e[0].dataType),R=[M("x",e[0].dataType,e[0].dims,w),M("scale",n.dataType,n.dims,w)];s&&R.push(M("bias",s.dataType,s.dims,w)),R.push(F("output",e[0].dataType,u,w)),I&&R.push(F("mean_data_output",1,b)),$&&R.push(F("inv_std_output",1,b));let V=[{name:"norm_count",type:"u32"},{name:"norm_size",type:"f32"},{name:"norm_size_vectorized",type:"u32"},{name:"epsilon",type:"f32"}];return`\n  ${A.registerUniforms(V).declareVariables(...R)}\n  ${A.mainStart()}\n    ${A.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.norm_count")}\n    let offset = global_idx * uniforms.norm_size_vectorized;\n    var meanVector = ${Ze("f32",w)};\n    var meanSquareVector = ${Ze("f32",w)};\n\n    for (var h: u32 = 0u; h < uniforms.norm_size_vectorized; h++) {\n      let value = ${at(z,w,"x[h + offset]")};\n      meanVector += value;\n      meanSquareVector += value * value;\n    }\n    let mean = ${Je("meanVector",w)} / uniforms.norm_size;\n    let invStdDev =\n        inverseSqrt(${Je("meanSquareVector",w)} / uniforms.norm_size - mean * mean + uniforms.epsilon);\n\n    for (var j: u32 = 0; j < uniforms.norm_size_vectorized; j++) {\n      let f32input = ${at(z,w,"x[j + offset]")};\n      let f32scale = ${at(z,w,"scale[j]")};\n      output[j + offset] = ${R[0].type.value}((f32input - mean) * invStdDev * f32scale\n        ${s?`+ ${at(z,w,"bias[j]")}`:""}\n      );\n    }\n\n    ${I?"mean_data_output[global_idx] = mean":""};\n    ${$?"inv_std_output[global_idx] = invStdDev":""};\n  }`},E=[{dims:u,dataType:e[0].dataType}];return I&&E.push({dims:b,dataType:1}),$&&E.push({dims:b,dataType:1}),{name:"LayerNormalization",shaderCache:{hint:`${w};${r}`,inputDependencies:y},getRunData:()=>({outputs:E,dispatchGroup:{x:Math.ceil(a/64)},programUniforms:_}),getShaderSource:x}},Ss=(e,t)=>{Nl(e.inputs),e.compute(Wl(e.inputs,t,e.outputCount))}});var Hl,Cs,_s,Gl,Xn,Is,As=j(()=>{"use strict";$e();je();Nr();Un();ve();jt();Hl=(e,t)=>{let r=e[0],o=e[1],n=e[2],s=e[3],u=e[4],l=e[5],a=e[6],p=e[7];if(r.dims.length!==3&&r.dims.length!==5)throw new Error("Input query is expected to have 3 or 5 dimensions");let h=!1,g=r.dims[0],b=r.dims[1],w=r.dims.length===3?h?r.dims[2]/3:r.dims[2]:t.numHeads*r.dims[4],y=b,_=0,I=0,$=Math.floor(w/t.numHeads);if(a&&p){if(a.dims.length!==4)throw new Error(\'Input "past_key" is expected to have 4 dimensions\');if(p.dims.length!==4)throw new Error(\'Input "past_value" is expected to have 4 dimensions\');_=a.dims[2],I=a.dims[2]}else if(a||p)throw new Error(\'Input "past_key" and "past_value" shall be both present or both absent\');let x;if(o){if(r.dims.length!==3)throw new Error(\'Input "query" is expected to have 3 dimensions when key is given\');if(o.dims.length<3||o.dims.length>5)throw new Error(\'Input "key" is expected to have 3, 4, or 5 dimensions\');if(r.dims[0]!==o.dims[0])throw new Error(\'Input "query" and "key" shall have same dim 0 (batch size)\');if(o.dims.length===3){if(o.dims[2]!==r.dims[2])throw new Error(\'Input "query" and "key" shall have same dim 2 (hidden_size)\');x=2,y=o.dims[1]}else if(o.dims.length===5){if(o.dims[2]!==t.numHeads||o.dims[3]!==2||o.dims[4]!==$)throw new Error(\'Expect "key" shape (batch_size, kv_sequence_length, num_heads, 2, head_size) for packed kv\');if(n)throw new Error(\'Expect "value" be none when "key" has packed kv format.\');x=5,y=o.dims[1]}else{if(o.dims[1]!==t.numHeads||o.dims[3]!==$)throw new Error(\'Expect "key" shape (batch_size, num_heads, kv_sequence_length, head_size) for past_key\');x=0,y=o.dims[2]}}else{if(r.dims.length!==3&&r.dims.length!==5)throw new Error(\'Input "query" is expected to have 3 or 5 dimensions when key is empty\');if(r.dims.length===5&&(r.dims[2]!==t.numHeads||r.dims[3]!==3))throw new Error(\'Expect "query" shape (batch_size, kv_sequence_length, num_heads, 3, head_size) for packed kv\');x=3}if(s){if(s.dims.length!==1)throw new Error(\'Input "bias" is expected to have 1 dimension\');if(n&&r.dims.length===5&&r.dims[3]===2)throw new Error("bias is not allowed for packed kv.")}let E=0;if(u){E=8;let T=u.dims;throw T.length===1?T[0]===g?E=1:T[0]===3*g+2&&(E=3):T.length===2&&T[0]===g&&T[1]===y&&(E=5),E===8?new Error(\'Input "key_padding_mask" shape shall be (batch_size) or (batch_size, kv_sequence_length)\'):new Error("Mask not supported")}let A=!1,z=w;if(n){if(n.dims.length!==3&&n.dims.length!==4)throw new Error(\'Input "value" is expected to have 3 or 4 dimensions\');if(r.dims[0]!==n.dims[0])throw new Error(\'Input "query" and "value" shall have same dim 0 (batch_size)\');if(n.dims.length===3){if(y!==n.dims[1])throw new Error(\'Input "key" and "value" shall have the same dim 1 (kv_sequence_length)\');z=n.dims[2]}else{if(y!==n.dims[2])throw new Error(\'Input "past_key" and "past_value" shall have the same dim 2 (kv_sequence_length)\');z=n.dims[1]*n.dims[3],A=!0}}let R=_+y,V=!1;if(u)throw new Error("Key padding mask is not supported");if(l)throw new Error("extraAddQk is not supported");if(a)throw new Error("pastKey is not supported");if(p)throw new Error("pastValue is not supported");return{batchSize:g,sequenceLength:b,pastSequenceLength:_,kvSequenceLength:y,totalSequenceLength:R,maxSequenceLength:I,inputHiddenSize:0,hiddenSize:w,vHiddenSize:z,headSize:$,vHeadSize:Math.floor(z/t.numHeads),numHeads:t.numHeads,isUnidirectional:!1,pastPresentShareBuffer:!1,maskFilterValue:t.maskFilterValue,maskType:E,scale:t.scale,broadcastResPosBias:V,passPastInKv:A,qkvFormat:x}},Cs=e=>ge({...e}),_s=ge({perm:[0,2,1,3]}),Gl=(e,t,r,o,n,s,u)=>{let l=[o,n,s],a=U.size(l),p=[{type:"uint32",data:a},{type:"uint32",data:u},{type:"uint32",data:s}],h=g=>{let b=F("qkv_with_bias",t.dataType,l),w=M("qkv",t.dataType,l),y=M("bias",r.dataType,l),_=[{name:"output_size",type:"u32"},{name:"bias_offset",type:"u32"},{name:"hidden_size",type:"u32"}];return`\n  ${g.registerUniforms(_).declareVariables(w,y,b)}\n  ${g.mainStart()}\n    ${g.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n    let bias_offset_idx = (global_idx % uniforms.hidden_size) + uniforms.bias_offset;\n\n    qkv_with_bias[global_idx] = qkv[global_idx] + bias[bias_offset_idx];\n  }`};return e.compute({name:"MultiHeadAttentionAddBias",shaderCache:{inputDependencies:["type","type"]},getRunData:()=>({outputs:[{dims:l,dataType:t.dataType,gpuDataType:0}],dispatchGroup:{x:Math.ceil(a/64)},programUniforms:p}),getShaderSource:h},{inputs:[t,r],outputs:[-1]})[0]},Xn=(e,t,r,o,n,s,u,l)=>{let a=s;if(u){if(o===1)throw new Error("AddBiasReshape is not implemented. Please export your model with packed QKV or KV");return a=Gl(e,s,u,t,o,r*n,l),a=a.reshape([t,o,r,n]),e.compute(it(a,_s.perm),{inputs:[a],outputs:[-1]})[0]}else return s.dims.length===3&&(a=s.reshape([t,o,r,n])),e.compute(it(a,_s.perm),{inputs:[a],outputs:[-1]})[0]},Is=(e,t)=>{let r=Hl(e.inputs,t);if(e.inputs[0].dims.length===5)throw new Error("Packed QKV is not implemented");if(e.inputs[1]?.dims.length===5)throw new Error("Packed KV is not implemented");let o=e.inputs[1]&&e.inputs[2]&&e.inputs[1].dims.length===4&&e.inputs[2].dims.length===4,n=Xn(e,r.batchSize,r.numHeads,r.sequenceLength,r.headSize,e.inputs[0],e.inputs[3],0);if(o)return Kr(e,n,e.inputs[1],e.inputs[2],e.inputs[4],void 0,void 0,void 0,e.inputs[5],r,t);let s=Xn(e,r.batchSize,r.numHeads,r.kvSequenceLength,r.headSize,e.inputs[1],e.inputs[3],r.hiddenSize),u=Xn(e,r.batchSize,r.numHeads,r.kvSequenceLength,r.vHeadSize,e.inputs[2],e.inputs[3],2*r.hiddenSize);Kr(e,n,s,u,e.inputs[4],void 0,e.inputs[6],e.inputs[7],e.inputs[5],r,t)}});var Ll,Fl,jl,ql,Kl,Yl,Zl,Ql,Ts,Es=j(()=>{"use strict";Ne();$e();ve();Ll=e=>{if(!e||e.length<1)throw new Error("Too few inputs");if(e[0].dataType!==1)throw new Error("Input type must be float.");if(e.length>=2){let t=e[0].dims.length*2===e[1].dims[0];if(e.length===4&&(t=e[3].dims[0]*2===e[1].dims[0]),!t)throw new Error("The pads should be a 1D tensor of shape [2 * input_rank] or [2 * num_axes].")}},Fl=(e,t,r)=>{let o="";for(let n=t-1;n>=0;--n)o+=`\n            k = i32(${e.indicesGet("indices",n)}) - ${ce("uniforms.pads",n,r)};\n            if (k < 0) {\n              break;\n            }\n            if (k >= i32(${ce("uniforms.x_shape",n,t)})) {\n              break;\n            }\n            offset += k * i32(${ce("uniforms.x_strides",n,t)});\n        `;return`\n          value = ${e.type.value}(uniforms.constant_value);\n          for (var i = 0; i < 1; i++) {\n            var offset = 0;\n            var k = 0;\n            ${o}\n            value = x[offset];\n          }\n      `},jl=(e,t,r)=>{let o="";for(let n=t-1;n>=0;--n)o+=`\n                k = i32(${e.indicesGet("indices",n)}) - ${ce("uniforms.pads",n,r)};\n                if (k < 0) {\n                  k = -k;\n                }\n                {\n                  let _2n_1 = 2 * (i32(${ce("uniforms.x_shape",n,t)}) - 1);\n                  k = k % _2n_1;\n                  if(k >= i32(${ce("uniforms.x_shape",n,t)})) {\n                    k = _2n_1 - k;\n                  }\n                }\n                offset += k * i32(${ce("uniforms.x_strides",n,t)});\n            `;return`\n              var offset = 0;\n              var k = 0;\n              ${o}\n              value = x[offset];\n          `},ql=(e,t,r)=>{let o="";for(let n=t-1;n>=0;--n)o+=`\n                k = i32(${e.indicesGet("indices",n)}) - ${ce("uniforms.pads",n,r)};\n                if (k < 0) {\n                  k = 0;\n                }\n                if (k >= i32(${ce("uniforms.x_shape",n,t)})) {\n                  k = i32(${ce("uniforms.x_shape",n,t)}) - 1;\n                }\n                offset += k * i32(${ce("uniforms.x_strides",n,t)});\n            `;return`\n              var offset = 0;\n              var k = 0;\n              ${o}\n              value = x[offset];\n          `},Kl=(e,t,r)=>{let o="";for(let n=t-1;n>=0;--n)o+=`\n                k = i32(${e.indicesGet("indices",n)}) - ${ce("uniforms.pads",n,r)};\n                if (k < 0)  {\n                  k += i32(${ce("uniforms.x_shape",n,t)}]);\n                }\n                if (k >= i32(${ce("uniforms.x_shape",n,t)})) {\n                  k -= i32(${ce("uniforms.x_shape",n,t)});\n                }\n                offset += k * i32(${ce("uniforms.x_strides",n,t)});\n            `;return`\n              var offset = 0;\n              var k = 0;\n              ${o}\n              value = x[offset];\n          `},Yl=(e,t,r)=>{switch(r.mode){case 0:return Fl(e,t,r.pads.length);case 1:return jl(e,t,r.pads.length);case 2:return ql(e,t,r.pads.length);case 3:return Kl(e,t,r.pads.length);default:throw new Error("Invalid mode")}},Zl=(e,t)=>{let r=U.padShape(e[0].dims.slice(),t.pads),o=e[0].dims,s=[{type:"uint32",data:U.size(r)},{type:"uint32",data:t.pads}];if(t.mode===0){let a=Xe(e[0].dataType);s.push({type:a,data:t.value})}s.push(...L(e[0].dims),...L(r));let u=["rank"],l=a=>{let p=F("output",e[0].dataType,r.length),h=M("x",e[0].dataType,o.length),g=h.type.value,b=Yl(p,o.length,t),w=[{name:"output_size",type:"u32"},{name:"pads",type:"i32",length:t.pads.length}];return t.mode===0&&w.push({name:"constant_value",type:g}),`\n            ${a.registerUniforms(w).declareVariables(h,p)}\n            ${a.mainStart()}\n            ${a.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n\n            let indices = ${p.offsetToIndices("global_idx")};\n\n            var value = ${g}(0);\n            ${b}\n            output[global_idx] = value;\n        }`};return{name:"Pad",shaderCache:{hint:`${t.mode}`,inputDependencies:u},getRunData:()=>({outputs:[{dims:r,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(U.size(r)/64)},programUniforms:s}),getShaderSource:l}},Ql=(e,t)=>{if(e.length>1){let r=e[1].getBigInt64Array(),o=e.length>=3&&e[2].data?e[2].getFloat32Array()[0]:0,n=e[0].dims.length,s=new Int32Array(2*n).fill(0);if(e.length>=4){let l=e[3].getBigInt64Array();for(let a=0;a<l.length;a++)s[Number(l[a])]=Number(r[a]),s[Number(l[a])+n]=Number(r[a+l.length])}else r.forEach((l,a)=>s[Number(a)]=Number(l));let u=[];return s.forEach(l=>u.push(l)),{mode:t.mode,value:o,pads:u}}else return t},Ts=(e,t)=>{Ll(e.inputs);let r=Ql(e.inputs,t);e.compute(Zl(e.inputs,r),{inputs:[0]})}});var nn,Os,Ps,ks,Rs,Xl,Jl,Bs,Ds,Ms,zs,Us,Vs,Ns,Ws,Hs,Gs,Ls,Fs,js=j(()=>{"use strict";Lt();$e();ve();nn=e=>{if(Gt.webgpu.validateInputContent&&(!e||e.length!==1))throw new Error("Pool ops requires 1 input.")},Os=(e,t,r)=>{let o=t.format==="NHWC",n=e.dims.slice();o&&n.splice(1,0,n.pop());let s=Object.hasOwnProperty.call(t,"dilations"),u=t.kernelShape.slice(),l=t.strides.slice(),a=s?t.dilations.slice():[],p=t.pads.slice();Bt.adjustPoolAttributes(r,n,u,l,a,p);let h=Bt.computePoolOutputShape(r,n,l,a,u,p,t.autoPad),g=Object.assign({},t);s?Object.assign(g,{kernelShape:u,strides:l,pads:p,dilations:a,cacheKey:t.cacheKey}):Object.assign(g,{kernelShape:u,strides:l,pads:p,cacheKey:t.cacheKey});let b=h.slice();return b.push(b.splice(1,1)[0]),[g,o?b:h]},Ps=(e,t)=>{let r=t.format==="NHWC",o=U.size(e),n=U.size(t.kernelShape),s=[{type:"uint32",data:o},{type:"uint32",data:n}],u=[{name:"outputSize",type:"u32"},{name:"kernelSize",type:"u32"}];if(t.kernelShape.length<=2){let l=t.kernelShape[t.kernelShape.length-1],a=t.strides[t.strides.length-1],p=t.pads[t.pads.length/2-1],h=t.pads[t.pads.length-1],g=!!(p+h);s.push({type:"uint32",data:l},{type:"uint32",data:a},{type:"uint32",data:p},{type:"uint32",data:h}),u.push({name:"kw",type:"u32"},{name:"sw",type:"u32"},{name:"pwStart",type:"u32"},{name:"pwEnd",type:"u32"});let b=!1;if(t.kernelShape.length===2){let w=t.kernelShape[t.kernelShape.length-2],y=t.strides[t.strides.length-2],_=t.pads[t.pads.length/2-2],I=t.pads[t.pads.length-2];b=!!(_+I),s.push({type:"uint32",data:w},{type:"uint32",data:y},{type:"uint32",data:_},{type:"uint32",data:I}),u.push({name:"kh",type:"u32"},{name:"sh",type:"u32"},{name:"phStart",type:"u32"},{name:"phEnd",type:"u32"})}return[s,u,!0,g,b]}else{if(r)throw new Error("Pooling with kernelShape.length > 2 is not supported for NHWC format.");let l=U.computeStrides(t.kernelShape);s.push({type:"uint32",data:l},{type:"uint32",data:t.pads},{type:"uint32",data:t.strides}),u.push({name:"kernelStrides",type:"u32",length:l.length},{name:"pads",type:"u32",length:t.pads.length},{name:"strides",type:"u32",length:t.strides.length});let a=t.pads.reduce((p,h)=>p+h);return[s,u,!!a,!1,!1]}},ks=(e,t,r,o,n,s,u,l,a,p,h,g)=>{let b=n.format==="NHWC",w=t.type.value,y=F("output",t.type.tensor,o);if(n.kernelShape.length<=2){let _="",I="",$="",x=r-(b?2:1);if(h?_=`\n                for (var i: u32 = 0u; i < uniforms.kw; i++) {\n                  xIndices[${x}] = indices[${x}] * uniforms.sw - uniforms.pwStart + i;\n                  if (xIndices[${x}] < 0 || xIndices[${x}]\n                      >= uniforms.x_shape[${x}]) {\n                    pad++;\n                    continue;\n                  }\n                  let x_val = x[${t.indicesToOffset("xIndices")}];\n                  ${s}\n                }`:_=`\n                for (var i: u32 = 0u; i < uniforms.kw; i++) {\n                  xIndices[${x}] = indices[${x}] * uniforms.sw - uniforms.pwStart + i;\n                  let x_val = x[${t.indicesToOffset("xIndices")}];\n                  ${s}\n                }`,n.kernelShape.length===2){let A=r-(b?3:2);g?I=`\n                for (var j: u32 = 0u; j < uniforms.kh; j++) {\n                  xIndices[${A}] = indices[${A}] * uniforms.sh - uniforms.phStart + j;\n                  if (xIndices[${A}] < 0 || xIndices[${A}] >= uniforms.x_shape[${A}]) {\n                    pad += i32(uniforms.kw);\n                    continue;\n                  }\n              `:I=`\n                for (var j: u32 = 0u; j < uniforms.kh; j++) {\n                  xIndices[${A}] = indices[${A}] * uniforms.sh - uniforms.phStart + j;\n                `,$=`\n              }\n            `}return`\n            ${e.registerUniforms(a).declareVariables(t,y)}\n\n            ${e.mainStart()}\n              ${e.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n\n              let indices = ${y.offsetToIndices("global_idx")};\n              var xIndices = ${y.offsetToIndices("global_idx")};\n\n              var value = ${w}(${l});\n              var pad = 0;\n              ${I}\n              ${_}\n              ${$}\n              ${u}\n\n              output[global_idx] = value;\n            }`}else{if(b)throw new Error("Pooling with kernelShape.length > 2 is not supported for NHWC format.");let _=n.kernelShape.length,I=n.pads.length,$="";return p?$=`\n                if (xIndices[j] >= uniforms.x_shape[j]) {\n                  pad++;\n                  isPad = true;\n                  break;\n                }\n              }\n              if (!isPad) {\n                let x_val = x[${t.indicesToOffset("xIndices")}];\n                ${s}\n              }`:$=`\n              }\n              let x_val = x[${t.indicesToOffset("xIndices")}];\n              ${s}\n            `,`\n            ${e.registerUniforms(a).declareVariables(t,y)}\n\n            ${e.mainStart()}\n              ${e.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n              let indices = ${y.offsetToIndices("global_idx")};\n              var xIndices = ${y.offsetToIndices("global_idx")};\n\n              var offsets: array<u32, ${_}>;\n\n              var value = ${w}(${l});\n              var pad = 0;\n              var isPad = false;\n\n              for (var i: u32 = 0u; i < uniforms.kernelSize; i++) {\n                var offset = i;\n                for (var j = 0u; j < ${_-1}u; j++) {\n                  offsets[j] = offset / ${ce("uniforms.kernelStrides","j",_)};\n                  offset -= offsets[j] * ${ce("uniforms.kernelStrides","j",_)};\n                }\n                offsets[${_-1}] = offset;\n\n                isPad = false;\n                for (var j = ${r-_}u; j < ${r}u; j++) {\n                  xIndices[j] = indices[j] * ${ce("uniforms.strides",`j - ${r-_}u`,_)}\n                    + offsets[j - ${r-_}u] - ${ce("uniforms.pads","j - 2u",I)};\n                  ${$}\n              }\n              ${u}\n\n              output[global_idx] = value;\n            }`}},Rs=e=>`${e.format};${e.ceilMode};${e.autoPad};${e.kernelShape.length}`,Xl=e=>`${Rs(e)};${e.countIncludePad}`,Jl=e=>`${Rs(e)};${e.storageOrder};${e.dilations}`,Bs=e=>({format:e.format,autoPad:["NOTSET","VALID","SAME_UPPER","SAME_LOWER"][e.auto_pad],ceilMode:e.ceil_mode,kernelShape:e.kernel_shape,strides:e.strides,pads:e.pads}),Ds=(e,t,r,o)=>{let[n,s]=Os(t,o,r),u=M("x",t.dataType,t.dims.length),l=u.type.value,a="value += x_val;",p="";n.countIncludePad?p+=`value /= ${l}(uniforms.kernelSize);`:p+=`value /= ${l}(i32(uniforms.kernelSize) - pad);`;let[h,g,b,w,y]=Ps(s,n);h.push(...L(t.dims),...L(s));let _=["rank"];return{name:e,shaderCache:{hint:`${o.cacheKey};${b};${w};${y}`,inputDependencies:_},getRunData:()=>({outputs:[{dims:s,dataType:t.dataType}],dispatchGroup:{x:Math.ceil(U.size(s)/64)},programUniforms:h}),getShaderSource:I=>ks(I,u,t.dims.length,s.length,n,a,p,0,g,b,w,y)}},Ms=e=>{let t=e.count_include_pad!==0,r=Bs(e);if(r.ceilMode!==0)throw new Error("using ceil() in shape computation is not yet supported for AveragePool");let o={countIncludePad:t,...r,cacheKey:""};return{...o,cacheKey:Xl(o)}},zs=(e,t)=>{nn(e.inputs),e.compute(Ds("AveragePool",e.inputs[0],!1,t))},Us={autoPad:"",ceilMode:0,countIncludePad:!1,kernelShape:[],strides:[],pads:[],storageOrder:0,dilations:[]},Vs=e=>{let t=e.format;return{format:t,...Us,cacheKey:t}},Ns=(e,t)=>{nn(e.inputs),e.compute(Ds("GlobalAveragePool",e.inputs[0],!0,t))},Ws=(e,t,r,o)=>{let[n,s]=Os(t,o,r),u=`\n      value = max(x_val, value);\n    `,l="",a=M("x",t.dataType,t.dims.length),p=["rank"],[h,g,b,w,y]=Ps(s,n);return h.push(...L(t.dims),...L(s)),{name:e,shaderCache:{hint:`${o.cacheKey};${b};${w};${y}`,inputDependencies:p},getRunData:()=>({outputs:[{dims:s,dataType:t.dataType}],dispatchGroup:{x:Math.ceil(U.size(s)/64)},programUniforms:h}),getShaderSource:_=>ks(_,a,t.dims.length,s.length,n,u,l,-1e5,g,b,w,y)}},Hs=(e,t)=>{nn(e.inputs),e.compute(Ws("MaxPool",e.inputs[0],!1,t))},Gs=e=>{let t=e.storage_order,r=e.dilations,o=Bs(e);if(t!==0)throw new Error("column major storage order is not yet supported for MaxPool");if(o.ceilMode!==0)throw new Error("using ceil() in shape computation is not yet supported for MaxPool");let n={storageOrder:t,dilations:r,...o,cacheKey:""};return{...n,cacheKey:Jl(n)}},Ls=e=>{let t=e.format;return{format:t,...Us,cacheKey:t}},Fs=(e,t)=>{nn(e.inputs),e.compute(Ws("GlobalMaxPool",e.inputs[0],!0,t))}});var tc,rc,qs,Ks=j(()=>{"use strict";Lt();Ne();ve();tc=(e,t,r)=>{let o=e===t,n=e<t&&r<0,s=e>t&&r>0;if(o||n||s)throw new Error("Range these inputs\' contents are invalid.")},rc=(e,t,r,o)=>{let n=Math.abs(Math.ceil((t-e)/r)),s=[n],u=n,l=Xe(o),a=[{type:"uint32",data:u},{type:l,data:e},{type:l,data:r},...L(s)],p=h=>{let g=F("output",o,s.length),b=g.type.value,w=[{name:"outputSize",type:"u32"},{name:"start",type:b},{name:"delta",type:b}];return`\n        ${h.registerUniforms(w).declareVariables(g)}\n        ${h.mainStart()}\n        ${h.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n        output[global_idx] = uniforms.start + ${b}(global_idx) * uniforms.delta;\n      }`};return{name:"Range",shaderCache:{hint:`${o}`},getShaderSource:p,getRunData:()=>({outputs:[{dims:s,dataType:o}],dispatchGroup:{x:Math.ceil(u/64)},programUniforms:a})}},qs=e=>{let t=0,r=0,o=0;e.inputs[0].dataType===6?(t=e.inputs[0].getInt32Array()[0],r=e.inputs[1].getInt32Array()[0],o=e.inputs[2].getInt32Array()[0]):e.inputs[0].dataType===1&&(t=e.inputs[0].getFloat32Array()[0],r=e.inputs[1].getFloat32Array()[0],o=e.inputs[2].getFloat32Array()[0]),Gt.webgpu.validateInputContent&&tc(t,r,o),e.compute(rc(t,r,o,e.inputs[0].dataType),{inputs:[]})}});var nc,oc,ac,ic,sc,uc,dc,lc,cc,pc,mc,Ys,fc,hc,gc,yc,bc,Zs,Qs,Xs=j(()=>{"use strict";$e();je();ve();nc=(e,t)=>{if(e.every(r=>r>0||(()=>{throw new Error("Resize requires scales input values to be positive")})),e.length>0){if(t.mode==="linear"){if(!(e.length===2||e.length===3||e.length===4&&e[0]===1&&e[1]===1||e.length===4&&e[0]===1&&e[3]===1||e.length===5&&e[0]===1&&e[1]===1))throw new Error(`For linear mode, Resize requires scales to be 2D, 3D, 4D with either two outermost or one innermost and\n            one outermost scale values equal to 1, or 5D with two outermost scale values equal to 1`)}else if(t.mode==="cubic"&&!(e.length===2||e.length===4&&e[0]===1&&e[1]===1||e.length===4&&e[0]===1&&e[3]===1))throw new Error("Resize requires scales input size to be 2 or 4 for cubic mode")}},oc=(e,t,r)=>{t.every(n=>n>=0&&n<r||(()=>{throw new Error("Resize requires axes input values to be positive and less than rank")}));let o=new Array(r).fill(1);return t.forEach((n,s)=>o[n]=e[s]),o},ac=(e,t,r,o,n,s)=>{let[u,l,a]=r>10?[1,2,3]:[-1,e.length>1?1:-1,-1],p=e[0].dims.length;if(u>0&&e.length>u&&e[u].dims.length>0)e[u].getFloat32Array().forEach(h=>s.push(h));else if(t.coordinateTransformMode==="tf_crop_and_resize")throw new Error("Resize requires RoI input to be specified when coordinateTransformMode is tfCropAndResize");if(l>0&&e.length>l&&e[l].dims.length>0){if(e[l].getFloat32Array().forEach(h=>o.push(h)),o.length!==0&&o.length!==p&&r>=18&&o.length!==t.axes.length)throw new Error("Resize requires scales input size to be same as input rank or axes size for opset 18 and up");nc(o,t),t.axes.length>0&&oc(o,t.axes,p).forEach((h,g)=>o[g]=h)}if(a>0&&e.length>a&&(e[a].getBigInt64Array().forEach(h=>n.push(Number(h))),n.length!==p||r>=18&&n.length===t.axes.length))throw new Error("Resize requires sizes input size to be same as input rank or axes size for opset 18 and up");if(t.axes.length>0){if(o.length!==t.axes.length)throw new Error(\'Resize requires "scales" input size to be of axes rank when axes attributes is specified\');if(n.length!==t.axes.length)throw new Error(\'Resize requires "sizes" input size to be of rank axes rank when axes attributes is specified\')}if(typeof o<"u"&&typeof n<"u"&&o.length>0&&n.length>p)throw new Error("Resize requires only of scales or sizes to be specified")},ic=(e,t)=>`fn getOriginalCoordinateFromResizedCoordinate(xResized: u32, xScale: f32, lengthResized: u32,\n     lengthOriginal: u32, roiStart: f32, roiEnd: f32) -> ${t} { `+(()=>{switch(e){case"asymmetric":return`return ${t}(xResized) / ${t}(xScale);`;case"pytorch_half_pixel":return`if (lengthResized > 1) {\n                    return (${t}(xResized) + 0.5) / ${t}(xScale) - 0.5;\n                  } else {\n                    return 0.0;\n                  }`;case"tf_half_pixel_for_nn":return`return (${t}(xResized) + 0.5) / ${t}(xScale);`;case"align_corners":return`if (lengthResized == 1) {\n                    return 0.0;\n                  } else {\n                    // The whole part and the fractional part are calculated separately due to inaccuracy of floating\n                    // point division. As an example, f32(21) / f32(7) may evaluate to 2.99... instead of 3, causing an\n                    // offset-by-one error later in floor().\n                    let whole = ${t}(xResized * (lengthOriginal - 1) / (lengthResized - 1));\n                    let fract =\n                        ${t}(xResized * (lengthOriginal - 1) % (lengthResized - 1)) / ${t}(lengthResized - 1);\n                    return whole + fract;\n                  }`;case"tf_crop_and_resize":return`if (lengthResized > 1) {\n                    return ${t}(roiStart) * ${t}(lengthOriginal - 1) +\n                        (${t}(xResized) * ${t}(roiEnd - roiStart) * ${t}(lengthOriginal - 1)) /\n                        ${t}(lengthResized - 1);\n                  } else {\n                    return 0.5 * ${t}(roiStart + roiEnd) * ${t}(lengthOriginal - 1);\n                  }`;case"half_pixel_symmetric":return`const outputWidth = ${t}xScale * ${t}(lengthResized);\n                  const adjustment = ${t}(lengthResized) / outputWidth;\n                  const center = ${t}(lengthOriginal) / 2;\n                  const offset = center * (1 - adjustment);\n                  return offset + ((${t}(xResized) + 0.5) / ${t}(xScale)) - 0.5;`;case"half_pixel":return`return ((${t}(xResized) + 0.5) / ${t}(xScale)) - 0.5;`;default:throw new Error(`Coordinate transform mode ${e} is not supported`)}})()+"}",sc=(e,t,r)=>`fn getNearestPixelFromOriginal(xOriginal: ${r}, isDownSample: bool) -> ${r} {`+(()=>{switch(e){case"round_prefer_ceil":return"if (fract(xOriginal) == 0.5) {             return ceil(xOriginal);           } else {             return round(xOriginal);           }";case"floor":return"return floor(xOriginal);";case"ceil":return"return ceil(xOriginal);";case"round_prefer_floor":return"if (fract(xOriginal) == 0.5) {                     return floor(xOriginal);                   } else {                     return round(xOriginal);                   }";case"simple":default:if(t<11)return"if (isDownSample)                     {                       return ceil(xOriginal);                     } else {                       return xOriginal;                     }";throw new Error(`Nearest mode ${e} is not supported`)}})()+"}",uc=(e,t,r)=>{let o=new Array(r).fill(0).concat(new Array(r).fill(1)),n=e.length===0?o:e.slice();return t.length>0?(t.forEach((s,u)=>{o[s]=n[u],o[u+r]=n[t.length+u]}),o):n},dc=(e,t,r,o)=>{let n=[];if(r.length>0)if(o.length>0){if(e.forEach(s=>n.push(s)),Math.max(...o)>e.length)throw new Error("axes is out of bound");o.forEach((s,u)=>n[s]=r[u])}else r.forEach(s=>n.push(s));else{if(t.length===0)throw new Error("Resize requires either scales or sizes.");n=e.map((s,u)=>Math.round(s*t[u]))}return n},lc=(e,t,r)=>{let o=(()=>{switch(r.keepAspectRatioPolicy){case"not_larger":return r.axes.length>0?Math.min(...r.axes.map(s=>t[s]),Number.MAX_VALUE):Math.min(...t,Number.MAX_VALUE);case"not_smaller":return r.axes.length>0?Math.max(...r.axes.map(s=>t[s]),Number.MIN_VALUE):Math.max(...t,Number.MIN_VALUE);default:throw new Error(`Keep aspect ratio policy ${r.keepAspectRatioPolicy} is not supported`)}})();t.fill(1,0,t.length);let n=e.slice();return r.axes.length>0?(r.axes.forEach(s=>t[s]=o),r.axes.forEach(s=>n[s]=Math.round(e[s]*t[s]))):(t.fill(o,0,t.length),n.forEach((s,u)=>n[u]=Math.round(s*t[u]))),n},cc=(e,t,r,o,n)=>`\n    fn calculateOriginalIndicesFromOutputIndices(output_indices: ${e.type.indices}) -> array<${e.type.value}, ${r.length}> {\n      var original_indices: array<${e.type.value}, ${r.length}>;\n      for (var i:u32 = 0; i < ${r.length}; i++) {\n        var output_index = ${e.indicesGet("output_indices","i")};\n        var scale = ${ce("uniforms.scales","i",o)};\n        var roi_low = ${ce("uniforms.roi","i",n)};\n        var roi_hi = ${ce("uniforms.roi",`i + ${t.length}`,n)};\n        if (scale == 1.0) {\n          original_indices[i] = ${e.type.value}(output_index);\n        } else {\n          var input_shape_i = ${ce("uniforms.input_shape","i",t.length)};\n          var output_shape_i = ${ce("uniforms.output_shape","i",r.length)};\n          original_indices[i] = getOriginalCoordinateFromResizedCoordinate(output_index, scale, output_shape_i,\n                                                                           input_shape_i, roi_low, roi_hi);\n        }\n      }\n      return original_indices;\n    }`,pc=(e,t,r,o,n,s,u)=>`\n    fn calculateInputIndicesFromOutputIndices(output_indices: ${t.type.indices}) -> ${e.type.indices} {\n      var input_indices: ${e.type.indices};\n      for (var i:u32 = 0; i < ${o.length}; i++) {\n        var output_index = ${t.indicesGet("output_indices","i")};\n        var input_index: u32;\n        var scale = ${ce("uniforms.scales","i",n)};\n        if (scale == 1.0) {\n          input_index = output_index;\n        } else {\n          var roi_low = ${ce("uniforms.roi","i",s)};\n          var roi_hi = ${ce("uniforms.roi",`i + ${r.length}`,s)};\n          var input_shape_i = ${ce("uniforms.input_shape","i",r.length)};\n          var output_shape_i = ${ce("uniforms.output_shape","i",o.length)};\n          var original_idx = getOriginalCoordinateFromResizedCoordinate(output_index, scale, output_shape_i,\n                                                                        input_shape_i, roi_low, roi_hi);\n          if (!${u} || (original_idx >= 0 && original_idx < ${t.type.value}(input_shape_i))) {\n            if (original_idx < 0) {\n              input_index = 0;\n            } else if (original_idx > ${t.type.value}(input_shape_i - 1)) {\n              input_index = input_shape_i - 1;\n            } else {\n              input_index = u32(getNearestPixelFromOriginal(original_idx, scale < 1));\n            }\n          } else {\n            input_index = u32(original_idx);\n          }\n        }\n        ${e.indicesSet("input_indices","i"," input_index")}\n      }\n      return input_indices;\n    }`,mc=(e,t)=>`\n    fn checkInputIndices(input_indices: ${e.type.indices}) -> bool {\n      for (var i:u32 = 0; i < ${t.length}; i++) {\n        var input_index = ${e.indicesGet("input_indices","i")};\n        if (input_index < 0 || input_index >= ${ce("uniforms.input_shape","i",t.length)}) {\n          return false;\n        }\n      }\n      return true;\n    }`,Ys=(e,t,r,o)=>e.rank>o?`\n    ${e.indicesSet("input_indices",t,"channel")};\n    ${e.indicesSet("input_indices",r,"batch")};\n`:"",fc=(e,t,r,o,n)=>{let[u,l,a,p]=r.length===2?[-1,0,1,-1]:[0,2,3,1],h=e.type.value;return`\n    fn getInputValue(batch: u32, channel: u32, row: u32, col: u32) -> ${h} {\n      var input_indices: ${e.type.indices};\n      ${e.indicesSet("input_indices",l,`max(0, min(row, ${r[l]} - 1))`)};\n      ${e.indicesSet("input_indices",a,`max(0, min(col, ${r[a]} - 1))`)};\n      ${Ys(e,p,u,2)}\n      return ${e.getByIndices("input_indices")};\n    }\n\n    fn bilinearInterpolation(output_indices: ${t.type.indices}) -> ${h} {\n      var originalIndices = calculateOriginalIndicesFromOutputIndices(output_indices);\n      var row:${h} = originalIndices[${l}];\n      var col:${h} = originalIndices[${a}];\n      ${o?`if (row < 0 || row > (${r[l]} - 1) || col < 0 || col > (${r[a]} - 1)) {\n        return ${n};\n      }`:""};\n      row = max(0, min(row, ${r[l]} - 1));\n      col = max(0, min(col, ${r[a]} - 1));\n      var row1: u32 = u32(row);\n      var col1: u32 = u32(col);\n      var row2: u32 = u32(row + 1);\n      var col2: u32 = u32(col + 1);\n      var channel: u32 = ${r.length>2?`u32(originalIndices[${p}])`:"0"};\n      var batch: u32 =  ${r.length>2?`u32(originalIndices[${u}])`:"0"};\n      var x11: ${h} = getInputValue(batch, channel, row1, col1);\n      var x12: ${h} = getInputValue(batch, channel, row1, col2);\n      var x21: ${h} = getInputValue(batch, channel, row2, col1);\n      var x22: ${h} = getInputValue(batch, channel, row2, col2);\n      var dx1: ${h} = abs(row - ${h}(row1));\n      var dx2: ${h} = abs(${h}(row2) - row);\n      var dy1: ${h} = abs(col - ${h}(col1));\n      var dy2: ${h} = abs(${h}(col2) - col);\n      if (row1 == row2) {\n        dx1 = 0.5;\n        dx2 = 0.5;\n      }\n      if (col1 == col2) {\n        dy1 = 0.5;\n        dy2 = 0.5;\n      }\n      return (x11 * dx2 * dy2 + x12 * dx2 * dy1 + x21 * dx1 * dy2 + x22 * dx1 * dy1);\n    }`},hc=(e,t,r,o,n,s,u,l,a,p)=>{let h=r.length===2,g=!0,[b,w]=h?[0,1]:g?[2,3]:[1,2],y=e.type.value,_=I=>{let $=I===b?"row":"col";return`\n      fn ${$}CubicInterpolation(input_indices: ${e.type.indices}, output_indices: ${t.type.indices}) -> ${y} {\n        var output_index = ${t.indicesGet("output_indices",I)};\n        var originalIdx: ${y} = getOriginalCoordinateFromResizedCoordinate(output_index, ${n[I]},\n        ${o[I]}, ${r[I]}, ${s[I]}, ${s[I]} + ${r.length});\n        var fractOriginalIdx: ${y} = originalIdx - floor(originalIdx);\n        var coefs = getCubicInterpolationCoefs(fractOriginalIdx);\n\n        if (${l} && (originalIdx < 0 || originalIdx > (${r[I]} - 1))) {\n          return ${a};\n        }\n        var data: array<${y}, 4> = array<${y}, 4>(0.0, 0.0, 0.0, 0.0);\n        for (var i: i32 = -1; i < 3; i++) {\n          var ${$}: ${y} = originalIdx + ${y}(i);\n          if (${$} < 0 || ${$} >= ${r[I]}) {\n            ${(()=>p?`coefs[i + 1] = 0.0;\n                        continue;`:l?`return ${a};`:`${$} = max(0, min(${$}, ${r[I]} - 1));`)()};\n          }\n        var input_indices_copy: ${e.type.indices} = input_indices;\n          ${e.indicesSet("input_indices_copy",I,`u32(${$})`)};\n          data[i + 1] = ${I===b?e.getByIndices("input_indices_copy"):"rowCubicInterpolation(input_indices_copy, output_indices)"};\n        }\n        return cubicInterpolation1D(data, coefs);\n      }`};return`\n    ${_(b)};\n    ${_(w)};\n  fn getCubicInterpolationCoefs(s: ${y}) -> array<${y}, 4> {\n    var absS = abs(s);\n    var coeffs: array<${y}, 4> = array<${y}, 4>(0.0, 0.0, 0.0, 0.0);\n    var oneMinusAbsS: ${y} = 1.0 - absS;\n    var twoMinusAbsS: ${y} = 2.0 - absS;\n    var onePlusAbsS: ${y} = 1.0 + absS;\n    coeffs[0] = ((${u} * onePlusAbsS - 5 * ${u}) * onePlusAbsS + 8 * ${u}) * onePlusAbsS - 4 * ${u};\n    coeffs[1] = ((${u} + 2) * absS - (${u} + 3)) * absS * absS + 1;\n    coeffs[2] = ((${u} + 2) * oneMinusAbsS - (${u} + 3)) * oneMinusAbsS * oneMinusAbsS + 1;\n    coeffs[3] = ((${u} * twoMinusAbsS - 5 * ${u}) * twoMinusAbsS + 8 * ${u}) * twoMinusAbsS - 4 * ${u};\n    return coeffs;\n  }\n\n  fn cubicInterpolation1D(x: array<${y}, 4>, coefs: array<${y}, 4>) -> ${y} {\n    var coefsSum: ${y} = coefs[0] + coefs[1] + coefs[2] + coefs[3];\n    return (x[0] * coefs[0] + x[1] * coefs[1]+ x[2] * coefs[2]+ x[3] * coefs[3]) / coefsSum;\n  }\n\n  fn bicubicInterpolation(output_indices: ${t.type.indices}) -> ${y} {\n    var input_indices: ${e.type.indices} = output_indices;\n    return colCubicInterpolation(input_indices, output_indices);\n  }\n    `},gc=(e,t,r,o,n)=>{let[u,l,a,p,h]=r.length===3?[-1,0,1,2,-1]:[0,2,3,4,1],g=e.type.value;return`\n    fn getInputValue(batch: u32, channel: u32, depth:u32, height: u32, width: u32) -> ${g} {\n      var input_indices: ${e.type.indices};\n      ${e.indicesSet("input_indices",l,`max(0, min(depth, ${r[l]} - 1))`)};\n      ${e.indicesSet("input_indices",a,`max(0, min(height, ${r[a]} - 1))`)};\n      ${e.indicesSet("input_indices",p,`max(0, min(width, ${r[p]} - 1))`)};\n      ${Ys(e,h,u,3)}\n      return ${e.getByIndices("input_indices")};\n    }\n\n    fn trilinearInterpolation(output_indices: ${t.type.indices}) -> ${g} {\n      var originalIndices = calculateOriginalIndicesFromOutputIndices(output_indices);\n      var depth:${g} = originalIndices[${l}];\n      var height:${g} = originalIndices[${a}];\n      var width:${g} = originalIndices[${p}];\n      ${o?`if (depth < 0 || depth > (${r[l]} - 1) || height < 0 || height > (${r[a]} - 1) || width < 0 || (width > ${r[p]} - 1)) {\n      return ${n};\n        }`:""};\n\n    depth = max(0, min(depth, ${r[l]} - 1));\n      height = max(0, min(height, ${r[a]} - 1));\n      width = max(0, min(width, ${r[p]} - 1));\n      var depth1: u32 = u32(depth);\n      var height1: u32 = u32(height);\n      var width1: u32 = u32(width);\n      var depth2: u32 = u32(depth + 1);\n      var height2: u32 = u32(height + 1);\n      var width2: u32 = u32(width + 1);\n      var channel: u32 = ${r.length>3?`u32(originalIndices[${h}])`:"0"};\n      var batch: u32 =  ${r.length>3?`u32(originalIndices[${u}])`:"0"};\n\n      var x111: ${g} = getInputValue(batch, channel, depth1, height1, width1);\n      var x112: ${g} = getInputValue(batch, channel, depth1, height1, width2);\n      var x121: ${g} = getInputValue(batch, channel, depth1, height2, width1);\n      var x122: ${g} = getInputValue(batch, channel, depth1, height2, width2);\n      var x211: ${g} = getInputValue(batch, channel, depth2, height1, width1);\n      var x212: ${g} = getInputValue(batch, channel, depth2, height1, width2);\n      var x221: ${g} = getInputValue(batch, channel, depth2, height2, width1);\n      var x222: ${g} = getInputValue(batch, channel, depth2, height2, width2);\n      var dx1: ${g} = abs(depth - ${g}(depth1));\n      var dx2: ${g} = abs(${g}(depth2) - depth);\n      var dy1: ${g} = abs(height - ${g}(height1));\n      var dy2: ${g} = abs(${g}(height2) - height);\n      var dz1: ${g} = abs(width - ${g}(width1));\n      var dz2: ${g} = abs(${g}(width2) - width);\n      if (depth1 == depth2) {\n        dx1 = 0.5;\n        dx2 = 0.5;\n      }\n      if (height1 == height2) {\n        dy1 = 0.5;\n        dy2 = 0.5;\n      }\n      if (width1 == width2) {\n        dz1 = 0.5;\n        dz2 = 0.5;\n      }\n      return (x111 * dx2 * dy2 * dz2 + x112 * dx2 * dy2 * dz1 + x121 * dx2 * dy1 *dz2 + x122 * dx2 * dy1 * dz1 +\n              x211 * dx1 * dy2 * dz2 + x212 * dx1 * dy2 * dz1 + x221 * dx1 * dy1 *dz2 + x222 * dx1 * dy1 * dz1);\n    }`},yc=(e,t,r,o,n,s)=>{let u=e.dims,l=uc(s,t.axes,u.length),a=dc(u,o,n,t.axes),p=o.slice();o.length===0&&(p=u.map((x,E)=>x===0?1:a[E]/x),t.keepAspectRatioPolicy!=="stretch"&&(a=lc(u,p,t)));let h=F("output",e.dataType,a.length),g=M("input",e.dataType,u.length),b=U.size(a),w=u.length===a.length&&u.every((x,E)=>x===a[E]),y=t.coordinateTransformMode==="tf_crop_and_resize",_=t.extrapolationValue,I=g.type.value,$=x=>`\n      ${w?"":`\n      ${ic(t.coordinateTransformMode,I)};\n      ${(()=>{switch(t.mode){case"nearest":return`\n              ${mc(g,u)};\n              ${sc(t.nearestMode,r,I)};\n              ${pc(g,h,u,a,p.length,l.length,y)};\n              `;case"linear":return`\n              ${cc(h,u,a,p.length,l.length)};\n              ${(()=>{if(u.length===2||u.length===4)return`${fc(g,h,u,y,_)}`;if(u.length===3||u.length===5)return`${gc(g,h,u,y,_)}`;throw Error("Linear mode only supports input dims 2, 3, 4 and 5 are supported in linear mode.")})()};\n            `;case"cubic":return`\n            ${(()=>{if(u.length===2||u.length===4)return`${hc(g,h,u,a,p,l,t.cubicCoeffA,y,t.extrapolationValue,t.excludeOutside)}`;throw Error("Cubic mode only supports input dims 2 and 4 are supported in linear mode.")})()};\n            `;default:throw Error("Invalid resize mode")}})()};\n      `}\n      ${x.registerUniform("output_size","u32").registerUniform("scales","f32",p.length).registerUniform("roi","f32",l.length).declareVariables(g,h)}\n      ${x.mainStart()}\n        ${x.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n        ${w?"output[global_idx] = input[global_idx];":`\n        let output_indices = ${h.offsetToIndices("global_idx")};\n        var input_indices: ${g.type.indices};\n        ${(()=>{switch(t.mode){case"nearest":return`input_indices = calculateInputIndicesFromOutputIndices(output_indices);\n                if (checkInputIndices(input_indices)) {\n                  output[global_idx] = ${g.getByIndices("input_indices")};\n                } else {\n                  output[global_idx] = ${t.extrapolationValue};\n                }`;case"linear":return`output[global_idx] = ${u.length===2||u.length===4?"bilinearInterpolation":"trilinearInterpolation"}(output_indices);`;case"cubic":return"output[global_idx] = bicubicInterpolation(output_indices);";default:throw Error(`Unsupported resize mode: ${t.mode}`)}})()};\n`}\n      }`;return{name:"Resize",shaderCache:{hint:`${t.cacheKey}|${r}|${p.length>0?p:""}|${n.length>0?n:""}|${l.length>0?l:""}|${w}|${u}`,inputDependencies:["rank"]},getShaderSource:$,getRunData:()=>({outputs:[{dims:a,dataType:e.dataType}],dispatchGroup:{x:Math.ceil(b/64)},programUniforms:[{type:"uint32",data:b},{type:"float32",data:p},{type:"float32",data:l},...L(u),...L(a)]})}},bc=e=>{let t=e.customDataBuffer;return new Uint32Array(t,t.byteOffset,1)[0]},Zs=(e,t)=>{let r=[],o=[],n=[],s=bc(e);if(t.antialias!==0)throw Error("Only default value (0) for Antialias attribute is supported");ac(e.inputs,t,s,r,o,n),e.compute(yc(e.inputs[0],t,s,r,o,n),{inputs:[0]})},Qs=e=>{let t=e.antialias,r=e.axes,o=e.coordinateTransformMode,n=e.cubicCoeffA,s=e.excludeOutside!==0,u=e.extrapolationValue,l=e.keepAspectRatioPolicy,a=e.mode,p=e.nearestMode===""?"simple":e.nearestMode;return ge({antialias:t,axes:r,coordinateTransformMode:o,cubicCoeffA:n,excludeOutside:s,extrapolationValue:u,keepAspectRatioPolicy:l,mode:a,nearestMode:p})}});var wc,vc,Js,eu,tu=j(()=>{"use strict";Ne();$e();je();ve();wc=e=>{if(!e||e.length<3)throw new Error("layerNorm requires at least 3 inputs.");let t=e[0],r=e[1],o=e[2];if(t.dataType!==r.dataType||t.dataType!==o.dataType)throw new Error("All inputs must have the same data type");if(t.dims.length!==3&&t.dims.length!==2)throw new Error("Input must be 2D or 3D");if(r.dims.length!==3&&r.dims.length!==2)throw new Error("Skip must be 2D or 3D");let n=t.dims[t.dims.length-1],s=t.dims[t.dims.length-2];if(r.dims[r.dims.length-1]!==n)throw new Error("Skip must have the same hidden size as input");if(r.dims[r.dims.length-2]!==s)throw new Error("Skip must have the same sequence length as input");if(o.dims.length!==1)throw new Error("Gamma must be 1D");if(o.dims[o.dims.length-1]!==n)throw new Error("Gamma must have the same hidden size as input");if(e.length>3){let u=e[3];if(u.dims.length!==1)throw new Error("Beta must be 1D");if(u.dims[u.dims.length-1]!==n)throw new Error("Beta must have the same hidden size as input")}if(e.length>4){let u=e[4];if(u.dims.length!==1)throw new Error("Bias must be 1D");if(u.dims[u.dims.length-1]!==n)throw new Error("Bias must have the same hidden size as input")}},vc=(e,t,r,o)=>{let n=e[0].dims,s=U.size(n),u=n,l=s,a=n.slice(-1)[0],p=o?n.slice(0,-1).concat(1):[],h=e.length>3,g=e.length>4,b=o&&r>1,w=o&&r>2,y=r>3,_=Fe(a),I=[M("x",e[0].dataType,e[0].dims,_),M("skip",e[1].dataType,e[1].dims,_),M("gamma",e[2].dataType,e[2].dims,_)];h&&I.push(M("beta",e[3].dataType,e[3].dims,_)),g&&I.push(M("bias",e[4].dataType,e[4].dims,_)),I.push(F("output",e[0].dataType,u,_)),b&&I.push(F("meanOutput",1,p)),w&&I.push(F("invStdOutput",1,p)),y&&I.push(F("inputSkipBiasSum",e[0].dataType,u,_));let $=Le(e[0].dataType),x=A=>`\n      const hiddenSize: f32 = ${a};\n      const hiddenSizeVectorized: u32 = ${a/_};\n      const epsilon: f32 = ${t.epsilon};\n\n      ${A.declareVariables(...I)}\n\n      ${A.mainStart()}\n        ${A.guardAgainstOutOfBoundsWorkgroupSizes(l/a)}\n        let offset = global_idx * hiddenSizeVectorized;\n        var sum = ${Ze("f32",_)};\n        var squareSum = ${Ze("f32",_)};\n        for (var i: u32 = 0; i < hiddenSizeVectorized; i++) {\n          let skipValue = skip[offset + i];\n          let biasValue = ${g?"bias[i]":"0.0"};\n          let inputValue = x[offset + i];\n          let value = inputValue + skipValue + biasValue;\n          ${y?"inputSkipBiasSum[offset + i] = value;":""}\n          output[offset + i] = value;\n          let f32Value = ${at($,_,"value")};\n          sum += f32Value;\n          squareSum += f32Value * f32Value;\n        }\n        let mean = ${Je("sum",_)} / hiddenSize;\n        let invStdDev = inverseSqrt(${Je("squareSum",_)} / hiddenSize - mean * mean + epsilon);\n        ${b?"meanOutput[global_idx] = mean;":""}\n        ${w?"invStdOutput[global_idx] = invStdDev;":""}\n        for (var i: u32 = 0; i < hiddenSizeVectorized; i++) {\n          output[offset + i] = (output[offset + i] - ${$}(mean)) * ${$}(invStdDev) * gamma[i]\n           + ${h?"beta[i]":"0.0"};\n        }\n      }`,E=[{dims:u,dataType:e[0].dataType}];return r>1&&E.push({dims:p,dataType:1}),r>2&&E.push({dims:p,dataType:1}),r>3&&E.push({dims:n,dataType:e[0].dataType}),{name:"SkipLayerNormalization",shaderCache:{hint:t.cacheKey},getShaderSource:x,getRunData:()=>({outputs:E,dispatchGroup:{x:Math.ceil(l/a/64)}})}},Js=(e,t)=>{wc(e.inputs);let o=[0];e.outputCount>1&&o.push(-3),e.outputCount>2&&o.push(-3),e.outputCount>3&&o.push(3),e.compute(vc(e.inputs,t,e.outputCount,!1),{outputs:o})},eu=e=>{let t=e.epsilon;return ge({epsilon:t})}});var $c,on,Sc,ru,xc,_c,nu,ou,au=j(()=>{"use strict";Ne();$e();je();ve();$c=(e,t)=>{if(!e||e.length<1)throw new Error("too few inputs");if(t.axes.length!==0){if(t.axes.length!==t.starts.length||t.axes.length!==t.ends.length)throw new Error("axes, starts and ends must have the same length")}else if(t.starts.length!==t.ends.length)throw new Error("starts and ends must have the same length");e.slice(1).forEach((r,o)=>{if(e[o+1].dataType!==6&&e[o+1].dataType!==7)throw new Error(`Input ${o} must be an array of int32 or int64`)})},on=(e,t)=>{let r=[];if(e.length>t)if(e[t].dataType===7)e[t].getBigInt64Array().forEach(o=>r.push(Number(o)));else if(e[t].dataType===6)e[t].getInt32Array().forEach(o=>r.push(Number(o)));else throw new Error(`Input ${t} must be an array of int32 or int64`);return r},Sc=(e,t)=>{if(e.length>1){let r=on(e,1),o=on(e,2),n=on(e,3);return n.length===0&&(n=[...Array(e[0].dims.length).keys()]),ge({starts:r,ends:o,axes:n})}else return t},ru=(e,t,r,o,n)=>{let s=e;return e<0&&(s+=r[o[t]]),n[t]<0?Math.max(0,Math.min(s,r[o[t]]-1)):Math.max(0,Math.min(s,r[o[t]]))},xc=(e,t,r)=>`fn calculateInputIndices(output_indices: ${t.type.indices}) -> ${e.type.indices} {\n          var input_indices: ${e.type.indices};\n          var carry = 0u;\n          for (var i = ${r.length}; i >= 0; i--) {\n            let input_shape_i = ${ce("uniforms.input_shape","i",r.length)};\n            let steps_i = ${ce("uniforms.steps","i",r.length)};\n            let signs_i = ${ce("uniforms.signs","i",r.length)};\n            let starts_i = ${ce("uniforms.starts","i",r.length)};\n            var output_index = ${t.indicesGet("output_indices","i")};\n            var input_index = output_index * steps_i + starts_i + carry;\n            carry = input_index / input_shape_i;\n            input_index = input_index % input_shape_i;\n            if (signs_i < 0) {\n              input_index = input_shape_i - input_index - 1u + starts_i;\n            }\n            ${e.indicesSet("input_indices","i","input_index")};\n          }\n          return input_indices;\n      }`,_c=(e,t)=>{let r=e[0].dims,o=U.size(r),n=t.axes.length>0?U.normalizeAxes(t.axes,r.length):[...Array(r.length).keys()],s=on(e,4);s.forEach($=>$!==0||(()=>{throw new Error("step cannot be 0")})),s.length===0&&(s=Array(n.length).fill(1));let u=t.starts.map(($,x)=>ru($,x,r,n,s)),l=t.ends.map(($,x)=>ru($,x,r,n,s));if(n.length!==u.length||n.length!==l.length)throw new Error("start, ends and axes should have the same number of elements");if(n.length!==r.length)for(let $=0;$<r.length;++$)n.includes($)||(u.splice($,0,0),l.splice($,0,r[$]),s.splice($,0,1));let a=s.map($=>Math.sign($));s.forEach(($,x,E)=>{if($<0){let A=(l[x]-u[x])/$,z=u[x],R=z+A*s[x];u[x]=R,l[x]=z,E[x]=-$}});let p=r.slice(0);n.forEach(($,x)=>{p[$]=Math.ceil((l[$]-u[$])/s[$])});let h={dims:p,dataType:e[0].dataType},g=F("output",e[0].dataType,p.length),b=M("input",e[0].dataType,e[0].dims.length),w=U.size(p),y=[{name:"outputSize",type:"u32"},{name:"starts",type:"u32",length:u.length},{name:"signs",type:"i32",length:a.length},{name:"steps",type:"u32",length:s.length}],_=[{type:"uint32",data:w},{type:"uint32",data:u},{type:"int32",data:a},{type:"uint32",data:s},...L(e[0].dims),...L(p)],I=$=>`\n      ${$.registerUniforms(y).declareVariables(b,g)}\n        ${xc(b,g,r)}\n        ${$.mainStart()}\n          ${$.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.outputSize")}\n          let output_indices = ${g.offsetToIndices("global_idx")};\n          let input_indices = calculateInputIndices(output_indices);\n          ${g.setByOffset("global_idx",b.getByIndices("input_indices"))}\n      }`;return{name:"Slice",shaderCache:{hint:`${a.length}_${u.length}_${s.length}`,inputDependencies:["rank"]},getShaderSource:I,getRunData:()=>({outputs:[h],dispatchGroup:{x:Math.ceil(o/64)},programUniforms:_})}},nu=(e,t)=>{$c(e.inputs,t);let r=Sc(e.inputs,t);e.compute(_c(e.inputs,r),{inputs:[0]})},ou=e=>{let t=e.starts,r=e.ends,o=e.axes;return ge({starts:t,ends:r,axes:o})}});var Cc,Ic,iu,su,uu=j(()=>{"use strict";$e();je();ve();Cc=e=>{if(!e||e.length!==1)throw new Error("Softmax op requires 1 input.")},Ic=(e,t)=>{let r=e.dims,o=U.size(r),n=64,s=t.axis;if(s<0&&(s=r.length+s),s<r.length-1)throw new Error("softmax only supports last axis for now.");let u=r[s],l=o/u,a=Fe(u),p=u/a,h=(I,$)=>$===4?`max(max(${I}.x, ${I}.y), max(${I}.z, ${I}.w))`:$===2?`max(${I}.x, ${I}.y)`:$===3?`max(max(${I}.x, ${I}.y), ${I}.z)`:I,g=M("x",e.dataType,e.dims,a),b=F("result",e.dataType,e.dims,a),w=g.type.value,y=Le(e.dataType)==="f32"?`var threadMax = ${w}(-3.402823e+38f);`:`var threadMax = ${w}(-65504.0h);`,_=I=>`\n      var<workgroup> rowMaxShared : ${w};\n      var<workgroup> rowSumShared : ${w};\n      var<workgroup> threadShared : array<${w}, ${n}>;\n\n      fn getValue(row: i32, col: i32, row_stride: i32) -> ${w} {\n        let index = row * row_stride + col;\n        return x[index];\n      }\n\n      fn setValue(row: i32, col: i32, row_stride: i32, value: ${w}) {\n        let index = row * row_stride + col;\n        result[index] = value;\n      }\n      ${I.registerUniform("packedCols","i32").declareVariables(g,b)}\n      ${I.mainStart()}\n        let gindex = i32(global_idx);\n        let lindex = i32(local_idx);\n        const wg = ${n};\n        let row = gindex / wg;\n        let cols = uniforms.packedCols;\n        let row_stride : i32 = uniforms.packedCols;\n\n        // find the rows max\n        ${y}\n        for (var col = lindex; col < cols; col += wg) {\n          let value = getValue(row, col, row_stride);\n          threadMax = max(threadMax, value);\n        }\n        if (lindex < cols) {\n          threadShared[lindex] = threadMax;\n        }\n        workgroupBarrier();\n\n        var reduceSize = min(cols, wg);\n        for (var currSize = reduceSize >> 1;  currSize > 0; currSize = reduceSize >> 1) {\n          reduceSize = currSize + (reduceSize & 1);\n          if (lindex < currSize) {\n            threadShared[lindex] = max(threadShared[lindex], threadShared[lindex + reduceSize]);\n          }\n          workgroupBarrier();\n        }\n        if (lindex == 0) {\n          rowMaxShared = ${w}(${h("threadShared[0]",a)});\n        }\n        workgroupBarrier();\n\n        // find the rows sum\n        var threadSum = ${w}(0.0);\n        for (var col = lindex; col < cols; col += wg) {\n          let subExp = exp(getValue(row, col, row_stride) - rowMaxShared);\n          threadSum += subExp;\n        }\n        threadShared[lindex] = threadSum;\n        workgroupBarrier();\n\n        for (var currSize = wg >> 1;  currSize > 0; currSize = currSize >> 1) {\n          if (lindex < currSize) {\n            threadShared[lindex] = threadShared[lindex] + threadShared[lindex + currSize];\n          }\n          workgroupBarrier();\n        }\n        if (lindex == 0) {\n          rowSumShared = ${w}(${Je("threadShared[0]",a)});\n        }\n        workgroupBarrier();\n\n        // calculate final value for each element in the row\n        for (var col = lindex; col < cols; col += wg) {\n          let value = exp(getValue(row, col, row_stride) - rowMaxShared) / rowSumShared;\n          setValue(row, col, row_stride, value);\n        }\n      }`;return{name:"Softmax",shaderCache:{hint:`${a}`,inputDependencies:["type"]},getRunData:()=>({outputs:[{dims:r,dataType:e.dataType}],dispatchGroup:{x:l},programUniforms:[{type:"uint32",data:p}]}),getShaderSource:_}},iu=(e,t)=>{Cc(e.inputs),e.compute(Ic(e.inputs[0],t))},su=e=>ge({axis:e.axis})});var Ac,Tc,Ec,Oc,Pc,du,lu,cu=j(()=>{"use strict";$e();je();ve();Ac=e=>{if(!e||e.length<1)throw new Error("too few inputs")},Tc=(e,t)=>{let r=[],o=t.numOutputs;return e[1].dims[0]>0&&(e[1].getBigInt64Array().forEach(n=>r.push(Number(n))),o=r.length),ge({numOutputs:o,axis:t.axis,splitSizes:r})},Ec=e=>`\nfn calculateOutputIndex(index: u32) -> u32 {\n    for (var i: u32 = 0u; i < ${e}u; i += 1u ) {\n    if (index < ${ce("uniforms.size_in_split_axis","i",e)}) {\n        return i;\n    }\n    }\n    return ${e}u;\n}`,Oc=e=>{let t=e.length,r=[];for(let o=0;o<t;++o){let n=e[o].setByIndices("indices","input[global_idx]");t===1?r.push(n):o===0?r.push(`if (output_number == ${o}u) { ${n} }`):o===t-1?r.push(`else { ${n} }`):r.push(`else if (output_number == ${o}) { ${n} }`)}return`\n      fn writeBufferData(output_number: u32, indices: ${e[0].type.indices}, global_idx: u32) {\n        ${r.join(`\n`)}\n      }`},Pc=(e,t)=>{let r=e[0].dims,o=U.size(r),n=e[0].dataType,s=U.normalizeAxis(t.axis,r.length),u=new Array(t.numOutputs),l=M("input",n,r),a=new Array(t.numOutputs),p=[],h=[],g=0,b=[{type:"uint32",data:o}];for(let y=0;y<t.numOutputs;y++){g+=t.splitSizes[y],a[y]=g;let _=r.slice();_[t.axis]=t.splitSizes[y],h.push(_),u[y]=F(`output${y}`,n,_),p.push({dims:h[y],dataType:e[0].dataType})}b.push({type:"uint32",data:a}),b.push(...L(r)),h.forEach(y=>b.push(...L(y)));let w=y=>`\n  ${y.registerUniform("input_size","u32").registerUniform("size_in_split_axis","u32",a.length).declareVariables(l,...u)}\n  ${Ec(a.length)}\n  ${Oc(u)}\n\n  ${y.mainStart()}\n    ${y.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.input_size")}\n\n    var indices = ${l.offsetToIndices("global_idx")};\n    var index = ${l.indicesGet("indices",s)};\n    let output_number = calculateOutputIndex(index);\n    if (output_number != 0) {\n      index -= ${ce("uniforms.size_in_split_axis","output_number - 1u",a.length)};\n      ${l.indicesSet("indices",s,"index")};\n    }\n    writeBufferData(output_number, indices, global_idx);\n  }`;return{name:"Split",shaderCache:{hint:t.cacheKey,inputDependencies:["rank"]},getShaderSource:w,getRunData:()=>({outputs:p,dispatchGroup:{x:Math.ceil(o/64)},programUniforms:b})}},du=(e,t)=>{Ac(e.inputs);let r=e.inputs.length===1?t:Tc(e.inputs,t);e.compute(Pc(e.inputs,r),{inputs:[0]})},lu=e=>{let t=e.axis,r=e.splitSizes,o=e.numOutputs<0?r.length:e.numOutputs;if(o!==r.length)throw new Error("numOutputs and splitSizes lengh must be equal");return ge({axis:t,numOutputs:o,splitSizes:r})}});var pu,kc,Rc,Bc,mu,fu=j(()=>{"use strict";Ne();$e();ve();pu=e=>Array.from(e.getBigInt64Array(),Number),kc=e=>{if(!e||e.length!==2)throw new Error("Tile requires 2 inputs.");if(e[0].dataType!==1&&e[0].dataType!==6&&e[0].dataType!==12)throw new Error("Tile only support float, int32, and uint32 data types");if(e[1].dataType!==7)throw new Error("Tile `repeats` input should be of int64 data type");if(e[1].dims.length!==1)throw new Error("Tile `repeats` input should be 1-D");if(pu(e[1]).length!==e[0].dims.length)throw new Error("Tile `repeats` input should have same number of elements as rank of input data tensor")},Rc=(e,t)=>{let r=[];for(let o=0;o<e.length;++o)r.push(e[o]*t[o]);return r},Bc=e=>{let t=e[0].dims,r=pu(e[1]),o=Rc(t,r),n=U.size(o),s=e[0].dataType,u=M("input",s,t.length),l=F("output",s,o.length),a=p=>`\n      const inputShape = ${u.indices(...t)};\n      ${p.registerUniform("output_size","u32").declareVariables(u,l)}\n      ${p.mainStart()}\n      ${p.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.output_size")}\n      let output_indices = ${l.offsetToIndices("global_idx")};\n      var input_indices: ${u.type.indices};\n      for (var i = 0; i < ${t.length}; i++) {\n        let input_dim_i = ${u.indicesGet("uniforms.input_shape","i")};\n        let input_dim_value = ${l.indicesGet("output_indices","i")}  % input_dim_i;\n\n        ${u.indicesSet("input_indices","i","input_dim_value")}\n      }\n      ${l.setByOffset("global_idx",u.getByIndices("input_indices"))}\n    }`;return{name:"Tile",shaderCache:{hint:`${r}`,inputDependencies:["rank"]},getRunData:()=>({outputs:[{dims:o,dataType:e[0].dataType}],dispatchGroup:{x:Math.ceil(n/64)},programUniforms:[{type:"uint32",data:n},...L(e[0].dims),...L(o)]}),getShaderSource:a}},mu=e=>{kc(e.inputs),e.compute(Bc(e.inputs),{inputs:[0]})}});var Dc,Mc,hu,gu=j(()=>{"use strict";Ne();$e();ve();Dc=(e,t,r,o,n)=>{let s=F("output_data",n,r.length,4),u=M("a_data",t[1].dataType,t[1].dims.length,4),l=M("b_data",t[2].dataType,t[2].dims.length,4),a=M("c_data",t[0].dataType,t[0].dims.length,4),p,h=(g,b,w)=>`select(${b}, ${g}, ${w})`;if(!o)p=s.setByOffset("global_idx",h(u.getByOffset("global_idx"),l.getByOffset("global_idx"),a.getByOffset("global_idx")));else{let g=(b,w,y="")=>{let _=`a_data[index_a${w}][component_a${w}]`,I=`b_data[index_b${w}][component_b${w}]`,$=`bool(c_data[index_c${w}] & ${4278190080>>>(3-w)*8}u)`;return`\n            let output_indices${w} = ${s.offsetToIndices(`global_idx * 4u + ${w}u`)};\n            let offset_a${w} = ${u.broadcastedIndicesToOffset(`output_indices${w}`,s)};\n            let offset_b${w} = ${l.broadcastedIndicesToOffset(`output_indices${w}`,s)};\n            let offset_c${w} = ${a.broadcastedIndicesToOffset(`output_indices${w}`,s)};\n            let index_a${w} = offset_a${w} / 4u;\n            let index_b${w} = offset_b${w} / 4u;\n            let index_c${w} = offset_c${w} / 4u;\n            let component_a${w} = offset_a${w} % 4u;\n            let component_b${w} = offset_b${w} % 4u;\n            ${b}[${w}] = ${y}(${h(_,I,$)});\n          `};n===9?p=`\n            var data = vec4<u32>(0);\n            ${g("data",0,"u32")}\n            ${g("data",1,"u32")}\n            ${g("data",2,"u32")}\n            ${g("data",3,"u32")}\n            output_data[global_idx] = dot(vec4<u32>(0x1, 0x100, 0x10000, 0x1000000), vec4<u32>(data));`:p=`\n            ${g("output_data[global_idx]",0)}\n            ${g("output_data[global_idx]",1)}\n            ${g("output_data[global_idx]",2)}\n            ${g("output_data[global_idx]",3)}\n          `}return`\n        ${e.registerUniform("vec_size","u32").declareVariables(a,u,l,s)}\n        ${e.mainStart()}\n        ${e.guardAgainstOutOfBoundsWorkgroupSizes("uniforms.vec_size")}\n        ${p}\n      }`},Mc=e=>{let t=e[1].dims,r=e[2].dims,o=e[0].dims,n=e[1].dataType,s=!(U.areEqual(t,r)&&U.areEqual(r,o)),u=t,l=U.size(t);if(s){let p=dt.calcShape(dt.calcShape(t,r,!1),o,!1);if(!p)throw new Error("Can\'t perform where op on the given tensors");u=p,l=U.size(u)}let a=Math.ceil(l/4);return{name:"Where",shaderCache:{inputDependencies:["rank","rank","rank"]},getShaderSource:p=>Dc(p,e,u,s,n),getRunData:()=>({outputs:[{dims:u,dataType:n}],dispatchGroup:{x:Math.ceil(l/64/4)},programUniforms:[{type:"uint32",data:a},...L(o),...L(t),...L(r),...L(u)]})}},hu=e=>{e.compute(Mc(e.inputs))}});var yu,bu=j(()=>{"use strict";Wa();Un();La();ja();Ci();Mi();Vi();Gn();Ji();rs();ss();ls();ms();gs();ws();$s();xs();Fn();As();Es();js();Ks();jr();Xs();tu();au();uu();cu();fu();jt();Vn();gu();yu=new Map([["Abs",[qa]],["Acos",[Ka]],["Acosh",[Ya]],["Add",[Ii]],["ArgMax",[Na,zn]],["ArgMin",[Va,zn]],["Asin",[Za]],["Asinh",[Qa]],["Atan",[Xa]],["Atanh",[Ja]],["Attention",[Ha]],["AveragePool",[zs,Ms]],["BatchNormalization",[Ga]],["BiasAdd",[Fa]],["BiasSplitGelu",[_i]],["Cast",[ti,ei]],["Ceil",[ni]],["Clip",[ri]],["Concat",[zi,Ui]],["Conv",[qn,jn]],["ConvTranspose",[Xi,Qi]],["Cos",[oi]],["Cosh",[ai]],["CumSum",[es,ts]],["Div",[Ai]],["Einsum",[as,is]],["Elu",[ii,Yr]],["Equal",[Ti]],["Erf",[si]],["Exp",[ui]],["Expand",[ds]],["Floor",[di]],["FusedConv",[qn,jn]],["Gather",[ps,cs]],["GatherElements",[hs,fs]],["Gelu",[li]],["Gemm",[bs,ys]],["GlobalAveragePool",[Ns,Vs]],["GlobalMaxPool",[Fs,Ls]],["Greater",[ki]],["GreaterOrEqual",[Bi]],["InstanceNormalization",[vs]],["LayerNormalization",[Ss]],["LeakyRelu",[ci,Yr]],["Less",[Ri]],["LessOrEqual",[Di]],["Log",[xi]],["MatMul",[Li]],["MaxPool",[Hs,Gs]],["Mul",[Ei]],["MultiHeadAttention",[Is,Cs]],["Neg",[mi]],["Not",[pi]],["Pad",[Ts]],["Pow",[Oi]],["Range",[qs]],["Reciprocal",[fi]],["ReduceMin",[Ra]],["ReduceMean",[Ta]],["ReduceMax",[ka]],["ReduceSum",[Da]],["ReduceProd",[Ba]],["ReduceL1",[Ea]],["ReduceL2",[Oa]],["ReduceLogSum",[za]],["ReduceLogSumExp",[Pa]],["ReduceSumSquare",[Ma]],["Relu",[hi]],["Resize",[Zs,Qs]],["Sigmoid",[gi]],["Sin",[yi]],["Sinh",[bi]],["Slice",[nu,ou]],["SkipLayerNormalization",[Js,eu]],["Split",[du,lu]],["Sqrt",[wi]],["Softmax",[iu,su]],["Sub",[Pi]],["Tan",[vi]],["Tanh",[$i]],["ThresholdedRelu",[Si,Yr]],["Tile",[mu]],["Transpose",[ha,ga]],["Where",[hu]]])});var an,wu=j(()=>{"use strict";Lt();Ct();ve();an=class{constructor(t){this.backend=t;this.repo=new Map,this.attributesBound=!1}getArtifact(t){return this.repo.get(t)}setArtifact(t,r){this.repo.set(t,r)}run(t,r,o,n,s){kt(t.programInfo.name);let u=this.backend.device,l=this.backend.getComputePassEncoder();this.backend.writeTimestamp(this.backend.pendingDispatchNumber*2),l.setPipeline(t.computePipeline);let a=[];for(let h of r)a.push({binding:a.length,resource:{buffer:h.buffer}});for(let h of o)a.push({binding:a.length,resource:{buffer:h.buffer}});s&&a.push({binding:a.length,resource:s});let p=u.createBindGroup({layout:t.computePipeline.getBindGroupLayout(0),entries:a,label:t.programInfo.name});l.setBindGroup(0,p),l.dispatchWorkgroups(...n),this.backend.writeTimestamp(this.backend.pendingDispatchNumber*2+1),this.backend.pendingDispatchNumber++,(this.backend.pendingDispatchNumber>=this.backend.maxDispatchNumber||this.backend.queryType==="at-passes")&&this.backend.endComputePass(),this.backend.pendingDispatchNumber>=this.backend.maxDispatchNumber&&this.backend.flush(),Rt(t.programInfo.name)}dispose(){}build(t,r){kt(t.name);let o=this.backend.device,n=[];o.features.has("shader-f16")&&n.push("enable f16;");let s=ma(r),u=t.getShaderSource(s),l=`${n.join(`\n`)}\n${s.additionalImplementations}\n${u}`,a=o.createShaderModule({code:l,label:t.name});Be("verbose",()=>`[WebGPU] ${t.name} shader code: ${l}`);let p=o.createComputePipeline({compute:{module:a,entryPoint:"main"},layout:"auto",label:t.name});return Rt(t.name),{programInfo:t,computePipeline:p}}normalizeDispatchGroupSize(t){let r=typeof t=="number"?t:t.x,o=typeof t=="number"?1:t.y||1,n=typeof t=="number"?1:t.z||1,s=this.backend.device.limits.maxComputeWorkgroupsPerDimension;if(r<=s&&o<=s&&n<=s)return[r,o,n];let u=r*o*n,l=Math.ceil(Math.sqrt(u));if(l>s){if(l=Math.ceil(Math.cbrt(u)),l>s)throw new Error("Total dispatch size exceeds WebGPU maximum.");return[l,l,l]}else return[l,l,1]}}});var zc,Uc,sn,vu=j(()=>{"use strict";Lt();Ne();Ct();ua();pa();bu();wu();zc=(e,t)=>{if(t.length!==e.length)throw new Error(`inputDependencies length ${t.length} is not equal to inputTensors length ${e.length}.`);let r=[];for(let o=0;o<e.length;++o){let n=e[o].dataType;switch(t[o]){case"none":{r.push("");break}case"type":{r.push(`${n}`);break}case"rank":{let s=e[o].dims.length;r.push(`${n};${s}`);break}case"dims":{let s=e[o].dims.join(",");r.push(`${n};${s}`);break}default:throw new Error(`unsupported input dependency: ${t[o]}`)}}return r.join("|")},Uc=(e,t,r)=>{let o=e.name;return e.shaderCache?.hint&&(o+="["+e.shaderCache.hint+"]"),o+=":"+r+`:${zc(t,e.shaderCache?.inputDependencies??new Array(t.length).fill("dims"))}`,o},sn=class{constructor(){this.currentKernelId=null;this.commandEncoder=null;this.computePassEncoder=null;this.maxDispatchNumber=16;this.pendingDispatchNumber=0;this.pendingKernels=[];this.pendingQueries=new Map;this.sessionExternalDataMapping=new Map}get currentKernelCustomData(){if(this.currentKernelId===null)throw new Error("currentKernelCustomData(): currentKernelId is null. (should not happen)");let t=this.kernelCustomData.get(this.currentKernelId);return t||(t={},this.kernelCustomData.set(this.currentKernelId,t)),t}async initialize(t,r){this.env=t;let o=[],n={requiredLimits:{maxComputeWorkgroupStorageSize:r.limits.maxComputeWorkgroupStorageSize,maxComputeWorkgroupsPerDimension:r.limits.maxComputeWorkgroupsPerDimension,maxStorageBufferBindingSize:r.limits.maxStorageBufferBindingSize,maxBufferSize:r.limits.maxBufferSize,maxComputeInvocationsPerWorkgroup:r.limits.maxComputeInvocationsPerWorkgroup,maxComputeWorkgroupSizeX:r.limits.maxComputeWorkgroupSizeX,maxComputeWorkgroupSizeY:r.limits.maxComputeWorkgroupSizeY,maxComputeWorkgroupSizeZ:r.limits.maxComputeWorkgroupSizeZ},requiredFeatures:o};r.features.has("chromium-experimental-timestamp-query-inside-passes")?o.push("chromium-experimental-timestamp-query-inside-passes"):r.features.has("timestamp-query")&&o.push("timestamp-query"),r.features.has("shader-f16")&&o.push("shader-f16"),this.device=await r.requestDevice(n),this.gpuDataManager=ca(this),this.programManager=new an(this),this.kernels=new Map,this.kernelPersistentData=new Map,this.kernelCustomData=new Map,ia(t.logLevel,!!t.debug),this.device.onuncapturederror=s=>{s.error instanceof GPUValidationError&&console.error(`An uncaught WebGPU validation error was raised: ${s.error.message}`)},Object.defineProperty(this.env.webgpu,"device",{value:this.device}),this.setQueryType()}dispose(){typeof this.querySet<"u"&&this.querySet.destroy(),this.gpuDataManager.dispose()}getCommandEncoder(){return this.commandEncoder||(this.commandEncoder=this.device.createCommandEncoder(),this.setQueryType(),this.queryType!=="none"&&typeof this.querySet>"u"&&(this.querySet=this.device.createQuerySet({type:"timestamp",count:this.maxDispatchNumber*2}),this.queryResolveBuffer=this.device.createBuffer({size:this.maxDispatchNumber*2*8,usage:GPUBufferUsage.COPY_SRC|GPUBufferUsage.QUERY_RESOLVE}))),this.commandEncoder}getComputePassEncoder(){if(!this.computePassEncoder){let t={};this.queryType==="at-passes"&&(t.timestampWrites={querySet:this.querySet,beginningOfPassWriteIndex:this.pendingDispatchNumber*2,endOfPassWriteIndex:this.pendingDispatchNumber*2+1}),this.computePassEncoder=this.getCommandEncoder().beginComputePass(t)}return this.computePassEncoder}endComputePass(){this.computePassEncoder&&(this.computePassEncoder.end(),this.computePassEncoder=null)}flush(){if(!this.commandEncoder)return;kt(),this.endComputePass();let t;this.queryType!=="none"&&(this.commandEncoder.resolveQuerySet(this.querySet,0,this.pendingDispatchNumber*2,this.queryResolveBuffer,0),t=this.device.createBuffer({size:this.pendingDispatchNumber*2*8,usage:GPUBufferUsage.MAP_READ|GPUBufferUsage.COPY_DST}),this.pendingQueries.set(t,this.pendingKernels),this.pendingKernels=[],this.commandEncoder.copyBufferToBuffer(this.queryResolveBuffer,0,t,0,this.pendingDispatchNumber*2*8)),this.device.queue.submit([this.commandEncoder.finish()]),this.gpuDataManager.refreshPendingBuffers(),this.commandEncoder=null,this.pendingDispatchNumber=0,this.queryType!=="none"&&t.mapAsync(GPUMapMode.READ).then(()=>{let r=new BigUint64Array(t.getMappedRange()),o=this.pendingQueries.get(t);for(let n=0;n<r.length/2;n++){let s=o[n],u=s.kernelId,l=this.kernels.get(u),a=l.kernelType,p=l.kernelName,h=s.programName,g=s.inputTensorViews,b=s.outputTensorViews,w=r[n*2],y=r[n*2+1];typeof this.queryTimeBase>"u"&&(this.queryTimeBase=w);let _=Number(w-this.queryTimeBase),I=Number(y-this.queryTimeBase);if(!Number.isSafeInteger(_)||!Number.isSafeInteger(I))throw new RangeError("incorrect timestamp range");if(this.env.webgpu.profiling?.ondata)this.env.webgpu.profiling.ondata({version:1,inputsMetadata:g.map($=>({dims:$.dims,dataType:Xe($.dataType)})),outputsMetadata:b.map($=>({dims:$.dims,dataType:Xe($.dataType)})),kernelId:u,kernelType:a,kernelName:p,programName:h,startTime:_,endTime:I});else{let $="";g.forEach((E,A)=>{$+=`input[${A}]: [${E.dims}] | ${Xe(E.dataType)}, `});let x="";b.forEach((E,A)=>{x+=`output[${A}]: [${E.dims}] | ${Xe(E.dataType)}, `}),console.log(`[profiling] kernel "${u}|${a}|${p}|${h}" ${$}${x}execution time: ${I-_} ns`)}An("GPU",`${h}::${w}::${y}`)}t.unmap(),this.pendingQueries.delete(t)}),Rt()}run(t,r,o,n,s){kt(t.name);let u=[];for(let x=0;x<r.length;++x){let E=this.gpuDataManager.get(r[x].data);if(!E)throw new Error(`no GPU data for input: ${r[x].data}`);u[x]=E}let{outputs:l,dispatchGroup:a,programUniforms:p}=t.getRunData(r),h=o.length===0?l.map((x,E)=>E):o;if(h.length!==l.length)throw new Error(`Output size ${h.length} must be equal to ${l.length}.`);let g=[],b=[];for(let x=0;x<l.length;++x){if(!Number.isInteger(h[x])||h[x]<-3||h[x]>=l.length)throw new Error(`Invalid output index: ${h[x]}`);if(h[x]===-3)continue;let E=h[x]===-1,A=h[x]===-2,z=E||A?s(l[x].dataType,l[x].dims):n(h[x],l[x].dataType,l[x].dims),R=this.gpuDataManager.get(z.data);if(!R)throw new Error(`no GPU data for output: ${z.data}`);if(E&&this.temporaryData.push(R),A){let V=this.kernelPersistentData.get(this.currentKernelId);V||(V=[],this.kernelPersistentData.set(this.currentKernelId,V)),V.push(R)}g.push(z),b.push(R)}let w;if(p){let x=0,E=[];p.forEach(V=>{let T=typeof V.data=="number"?[V.data]:V.data;if(T.length===0)return;let N=T.length<=2?T.length*4:16;x=Math.ceil(x/N)*N,E.push(x),x+=T.length>4?Math.ceil(T.length/4)*16:T.length*4});let A=16;x=Math.ceil(x/A)*A;let z=new ArrayBuffer(x);p.forEach((V,T)=>{let N=E[T],te=typeof V.data=="number"?[V.data]:V.data;V.type==="int32"?new Int32Array(z,N,te.length).set(te):V.type==="uint32"?new Uint32Array(z,N,te.length).set(te):new Float32Array(z,N,te.length).set(te)});let R=this.gpuDataManager.create(x,GPUBufferUsage.COPY_DST|GPUBufferUsage.UNIFORM);this.device.queue.writeBuffer(R.buffer,0,z,0,x),this.gpuDataManager.release(R.id),w={offset:0,size:x,buffer:R.buffer}}let y=this.programManager.normalizeDispatchGroupSize(a),_=y[1]===1&&y[2]===1,I=Uc(t,r,_),$=this.programManager.getArtifact(I);if($||($=this.programManager.build(t,y),this.programManager.setArtifact(I,$),Be("info",()=>`[artifact] key: ${I}, programName: ${t.name}`)),Be("info",()=>`[ProgramManager] run "${t.name}" (key=${I}) with ${y[0]}x${y[1]}x${y[2]}`),this.queryType!=="none"){let x={kernelId:this.currentKernelId,programName:$.programInfo.name,inputTensorViews:r,outputTensorViews:g};this.pendingKernels.push(x)}return this.programManager.run($,u,b,y,w),Rt(t.name),g}upload(t,r){this.gpuDataManager.upload(t,r)}memcpy(t,r){this.gpuDataManager.memcpy(t,r)}async download(t,r){await this.gpuDataManager.download(t,r)}alloc(t){return this.gpuDataManager.create(t).id}free(t){return this.gpuDataManager.release(t)}createKernel(t,r,o,n){let s=yu.get(t);if(!s)throw new Error(`kernel not implemented: ${t}`);let u={kernelType:t,kernelName:n,kernelEntry:s[0],attributes:[s[1],o]};this.kernels.set(r,u)}releaseKernel(t){let r=this.kernelPersistentData.get(t);if(r){for(let o of r)this.gpuDataManager.release(o.id);this.kernelPersistentData.delete(t)}this.kernelCustomData.delete(t),this.kernels.delete(t)}computeKernel(t,r,o){let n=this.kernels.get(t);if(!n)throw new Error(`kernel not created: ${t}`);let s=n.kernelType,u=n.kernelName,l=n.kernelEntry,a=n.attributes;if(this.currentKernelId!==null)throw new Error(`kernel "[${s}] ${u}" is not allowed to be called recursively`);this.currentKernelId=t,a[0]&&(a[1]=a[0](a[1]),a[0]=void 0),Be("info",()=>`[WebGPU] Start to run kernel "[${s}] ${u}"...`);let p=this.env.debug;this.temporaryData=[];try{return p&&this.device.pushErrorScope("validation"),l(r,a[1]),0}catch(h){return o.push(Promise.resolve(`[WebGPU] Kernel "[${s}] ${u}" failed. ${h}`)),1}finally{p&&o.push(this.device.popErrorScope().then(h=>h?`GPU validation error for kernel "[${s}] ${u}": ${h.message}`:null));for(let h of this.temporaryData)this.gpuDataManager.release(h.id);this.temporaryData=[],this.currentKernelId=null}}registerBuffer(t,r,o,n){let s=this.sessionExternalDataMapping.get(t);s||(s=new Map,this.sessionExternalDataMapping.set(t,s));let u=s.get(r),l=this.gpuDataManager.registerExternalBuffer(o,n,u?.[1]);return s.set(r,[l,o]),l}unregisterBuffers(t){let r=this.sessionExternalDataMapping.get(t);r&&(r.forEach(o=>this.gpuDataManager.unregisterExternalBuffer(o[1])),this.sessionExternalDataMapping.delete(t))}getBuffer(t){let r=this.gpuDataManager.get(t);if(!r)throw new Error(`no GPU data for buffer: ${t}`);return r.buffer}createDownloader(t,r,o){return async()=>{let n=await On(this,t,r);return sa(n.buffer,o)}}writeTimestamp(t){this.queryType==="inside-passes"&&this.computePassEncoder.writeTimestamp(this.querySet,t)}setQueryType(){this.queryType="none",(this.env.webgpu.profiling?.mode==="default"||this.env.wasm.trace)&&(this.device.features.has("chromium-experimental-timestamp-query-inside-passes")?this.queryType="inside-passes":this.device.features.has("timestamp-query")&&(this.queryType="at-passes"))}}});var $u={};Br($u,{init:()=>Vc});var gr,Jn,Vc,Su=j(()=>{"use strict";Ne();vu();Ct();$e();gr=class e{constructor(t,r,o,n){this.module=t;this.dataType=r;this.data=o;this.dims=n}getFloat32Array(){if(this.dataType!==1)throw new Error("Invalid data type");let t=U.size(this.dims);return t===0?new Float32Array:new Float32Array(this.module.HEAP8.buffer,this.data,t)}getBigInt64Array(){if(this.dataType!==7)throw new Error("Invalid data type");let t=U.size(this.dims);return t===0?new BigInt64Array:new BigInt64Array(this.module.HEAP8.buffer,this.data,t)}getInt32Array(){if(this.dataType!==6)throw new Error("Invalid data type");let t=U.size(this.dims);return t===0?new Int32Array:new Int32Array(this.module.HEAP8.buffer,this.data,t)}reshape(t){if(U.size(t)!==U.size(this.dims))throw new Error("Invalid new shape");return new e(this.module,this.dataType,this.data,t)}},Jn=class{constructor(t,r,o){this.module=t;this.backend=r;this.customDataOffset=0;this.customDataSize=0;let n=t.HEAPU32,s=o>>>2;this.opKernelContext=n[s++];let u=n[s++];this.outputCount=n[s++],this.customDataOffset=n[s++],this.customDataSize=n[s++];let l=[];for(let a=0;a<u;a++){let p=n[s++],h=n[s++],g=n[s++],b=[];for(let w=0;w<g;w++)b.push(n[s++]);l.push(new gr(t,p,h,b))}this.inputs=l}get kernelCustomData(){return this.backend.currentKernelCustomData}get customDataBuffer(){return this.module.HEAPU8.subarray(this.customDataOffset,this.customDataOffset+this.customDataSize)}compute(t,r){let o=r?.inputs?.map(l=>typeof l=="number"?this.inputs[l]:l)??this.inputs,n=r?.outputs??[],s=(l,a,p)=>new gr(this.module,a,this.output(l,p),p),u=(l,a)=>{let p=cr(l);if(!p)throw new Error(`Unsupported data type: ${l}`);let h=p*U.size(a);return new gr(this.module,l,this.backend.gpuDataManager.create(h).id,a)};return this.backend.run(t,o,n,s,u)}output(t,r){let o=this.module.stackSave();try{let n=this.module.stackAlloc((1+r.length)*4),s=n>>2;this.module.HEAPU32[s++]=r.length;for(let u=0;u<r.length;u++)this.module.HEAPU32[s++]=r[u];return this.module._JsepOutput(this.opKernelContext,t,n)}catch(n){throw new Error(`Failed to generate kernel\'s output[${t}] with dims [${r}]. If you are running with pre-allocated output, please make sure the output type/dims are correct. Error: ${n}`)}finally{this.module.stackRestore(o)}}},Vc=async(e,t,r)=>{let o=e.jsepInit;if(!o)throw new Error("Failed to initialize JSEP. The WebAssembly module is not built with JSEP support.");let n=new sn;await n.initialize(t,r),o(n,s=>n.alloc(s),s=>n.free(s),(s,u,l,a=!1)=>{if(a)Be("verbose",()=>`[WebGPU] jsepCopyGpuToGpu: src=${s}, dst=${u}, size=${l}`),n.memcpy(s,u);else{Be("verbose",()=>`[WebGPU] jsepCopyCpuToGpu: dataOffset=${s}, gpuDataId=${u}, size=${l}`);let p=e.HEAPU8.subarray(s>>>0,(s>>>0)+l);n.upload(u,p)}},async(s,u,l)=>{Be("verbose",()=>`[WebGPU] jsepCopyGpuToCpu: gpuDataId=${s}, dataOffset=${u}, size=${l}`),await n.download(s,()=>e.HEAPU8.subarray(u>>>0,(u>>>0)+l))},(s,u,l)=>n.createKernel(s,u,l,e.UTF8ToString(e._JsepGetNodeName(u))),s=>n.releaseKernel(s),(s,u,l,a)=>{Be("verbose",()=>`[WebGPU] jsepRun: sessionHandle=${l}, kernel=${s}, contextDataOffset=${u}`);let p=new Jn(e,n,u);return n.computeKernel(s,p,a)})}});var Mo;Mo=Io();var Ju=Ro(),Sn,xn=!1,Dr=!1,Do=!1,ed=e=>{if(e===1)return!1;if(typeof SharedArrayBuffer>"u")return typeof self<"u"&&!self.crossOriginIsolated&&console.warn("env.wasm.numThreads is set to "+e+", but this will not work unless you enable crossOriginIsolated mode. See https://web.dev/cross-origin-isolation-guide/ for more info."),!1;typeof process<"u"&&process.versions&&process.versions.node&&console.warn("env.wasm.numThreads is set to "+e+", however, currently onnxruntime-web does not support multi-threads in Node.js. Please consider using onnxruntime-node for performance critical scenarios.");try{return typeof MessageChannel<"u"&&new MessageChannel().port1.postMessage(new SharedArrayBuffer(1)),WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,5,4,1,3,1,1,10,11,1,9,0,65,0,254,16,2,0,26,11]))}catch{return!1}},td=()=>{try{return WebAssembly.validate(new Uint8Array([0,97,115,109,1,0,0,0,1,4,1,96,0,0,3,2,1,0,10,30,1,28,0,65,0,253,15,253,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,186,1,26,11]))}catch{return!1}},rd=(e,t)=>e?t?"ort-wasm-simd-threaded.wasm":"ort-wasm-simd.wasm":t?"ort-wasm-threaded.wasm":"ort-wasm.wasm",zo=async e=>{if(xn)return Promise.resolve();if(Dr)throw new Error("multiple calls to \'initializeWebAssembly()\' detected.");if(Do)throw new Error("previous call to \'initializeWebAssembly()\' failed.");Dr=!0;let t=e.initTimeout,r=e.numThreads,o=e.simd,n=ed(r),s=o&&td(),u=e.wasmPaths,l=typeof u=="string"?u:void 0,a=rd(s,n),p=typeof u=="object"?u[a]:void 0,h=!1,g=[];if(t>0&&g.push(new Promise(b=>{setTimeout(()=>{h=!0,b()},t)})),g.push(new Promise((b,w)=>{let y=n?Ju:Mo,_={locateFile:(I,$)=>{if(n&&I.endsWith(".worker.js")&&typeof Blob<"u")return URL.createObjectURL(new Blob([Bo()],{type:"text/javascript"}));if(I.endsWith(".wasm")){if(p)return p;let x=l??$;return a==="ort-wasm-simd.wasm"?x+"ort-wasm-simd.jsep.wasm":a==="ort-wasm-simd-threaded.wasm"?x+"ort-wasm-simd-threaded.jsep.wasm":x+a}return $+I}};if(n)if(_.numThreads=r,typeof Blob>"u")_.mainScriptUrlOrBlob=(void 0)(__dirname,"ort-wasm-threaded.js");else{let I=`var ortWasmThreaded=${y.toString()};`;_.mainScriptUrlOrBlob=new Blob([I],{type:"text/javascript"})}y(_).then(I=>{Dr=!1,xn=!0,Sn=I,b()},I=>{Dr=!1,Do=!0,w(I)})})),await Promise.race(g),h)throw new Error(`WebAssembly backend initializing failed due to timeout: ${t}ms`)},Ve=()=>{if(xn&&Sn)return Sn;throw new Error("WebAssembly is not initialized yet.")};var He=(e,t)=>{let r=Ve(),o=r.lengthBytesUTF8(e)+1,n=r._malloc(o);return r.stringToUTF8(e,n,o),t.push(n),n},lr=(e,t,r,o)=>{if(typeof e=="object"&&e!==null){if(r.has(e))throw new Error("Circular reference in options");r.add(e)}Object.entries(e).forEach(([n,s])=>{let u=t?t+n:n;if(typeof s=="object")lr(s,u+".",r,o);else if(typeof s=="string"||typeof s=="number")o(u,s.toString());else if(typeof s=="boolean")o(u,s?"1":"0");else throw new Error(`Can\'t handle extra config type: ${typeof s}`)})},ke=e=>{let t=Ve(),r=t.stackSave();try{let o=t.stackAlloc(8);t._OrtGetLastError(o,o+4);let n=t.HEAP32[o/4],s=t.HEAPU32[o/4+1],u=s?t.UTF8ToString(s):"";throw new Error(`${e} ERROR_CODE: ${n}, ERROR_MESSAGE: ${u}`)}finally{t.stackRestore(r)}};var Uo=e=>{let t=Ve(),r=0,o=[],n=e||{};try{if(e?.logSeverityLevel===void 0)n.logSeverityLevel=2;else if(typeof e.logSeverityLevel!="number"||!Number.isInteger(e.logSeverityLevel)||e.logSeverityLevel<0||e.logSeverityLevel>4)throw new Error(`log serverity level is not valid: ${e.logSeverityLevel}`);if(e?.logVerbosityLevel===void 0)n.logVerbosityLevel=0;else if(typeof e.logVerbosityLevel!="number"||!Number.isInteger(e.logVerbosityLevel))throw new Error(`log verbosity level is not valid: ${e.logVerbosityLevel}`);e?.terminate===void 0&&(n.terminate=!1);let s=0;return e?.tag!==void 0&&(s=He(e.tag,o)),r=t._OrtCreateRunOptions(n.logSeverityLevel,n.