"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// libs/core/src/lib/add-dependencies.ts
function addDependencies(projects, projectGraph) {
  const projectsLookup = new Set(projects.map((p) => p.name));
  const dependencies = projectGraph.localPackageDependencies;
  const collected = /* @__PURE__ */ new Set();
  projects.forEach((currentNode) => {
    if (dependencies[currentNode.name] && dependencies[currentNode.name].length === 0) {
      return;
    }
    const queue2 = [currentNode];
    const seen = /* @__PURE__ */ new Set();
    while (queue2.length) {
      const node = queue2.shift();
      dependencies[node.name]?.forEach(({ target }) => {
        if (seen.has(target)) {
          return;
        }
        seen.add(target);
        if (target === currentNode.name || projectsLookup.has(target)) {
          return;
        }
        const dependencyNode = projectGraph.nodes[target];
        collected.add(dependencyNode);
        queue2.push(dependencyNode);
      });
    }
  });
  return Array.from(/* @__PURE__ */ new Set([...projects, ...collected]));
}
var init_add_dependencies = __esm({
  "libs/core/src/lib/add-dependencies.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/add-dependents.ts
function addDependents(projects, projectGraph) {
  const projectsLookup = new Set(projects.map((p) => p.name));
  const dependents = (0, import_lodash.flatten)(
    Object.values(projectGraph.localPackageDependencies)
  ).reduce(
    (prev, next) => ({
      ...prev,
      [next.target]: [...prev[next.target] || [], next.source]
    }),
    {}
  );
  const collected = /* @__PURE__ */ new Set();
  projects.forEach((currentNode) => {
    if (dependents[currentNode.name] && dependents[currentNode.name].length === 0) {
      return;
    }
    const queue2 = [currentNode];
    const seen = /* @__PURE__ */ new Set();
    while (queue2.length) {
      const node = queue2.shift();
      dependents[node.name]?.forEach((dep) => {
        if (seen.has(dep)) {
          return;
        }
        seen.add(dep);
        if (dep === currentNode.name || projectsLookup.has(dep)) {
          return;
        }
        const dependentNode = projectGraph.nodes[dep];
        collected.add(dependentNode);
        queue2.push(dependentNode);
      });
    }
  });
  return Array.from(/* @__PURE__ */ new Set([...projects, ...collected]));
}
var import_lodash;
var init_add_dependents = __esm({
  "libs/core/src/lib/add-dependents.ts"() {
    "use strict";
    import_lodash = require("lodash");
  }
});

// libs/core/src/lib/collect-uncommitted.ts
function collectUncommitted({ cwd, log: log63 = import_npmlog.default }) {
  log63.silly("collect-uncommitted", "git status --porcelain (async)");
  return childProcess.exec("git", ["status", "--porcelain"], { cwd }).then(({ stdout }) => transformOutput(stdout));
}
var import_chalk, import_npmlog, childProcess, maybeColorize, cRed, cGreen, replaceStatus, colorizeStats, splitOnNewLine, filterEmpty, o, transformOutput;
var init_collect_uncommitted = __esm({
  "libs/core/src/lib/collect-uncommitted.ts"() {
    "use strict";
    import_chalk = __toESM(require("chalk"));
    import_npmlog = __toESM(require("npmlog"));
    childProcess = require("@lerna/child-process");
    maybeColorize = (colorize) => (s) => s !== " " ? colorize(s) : s;
    cRed = maybeColorize(import_chalk.default.red);
    cGreen = maybeColorize(import_chalk.default.green);
    replaceStatus = (_, maybeGreen, maybeRed) => `${cGreen(maybeGreen)}${cRed(maybeRed)}`;
    colorizeStats = (stats) => stats.replace(/^([^U]| )([A-Z]| )/gm, replaceStatus).replace(/^\?{2}|U{2}/gm, cRed("$&"));
    splitOnNewLine = (str) => str.split("\n");
    filterEmpty = (lines) => lines.filter((line) => line.length);
    o = (l, r) => (x) => l(r(x));
    transformOutput = o(filterEmpty, o(splitOnNewLine, colorizeStats));
  }
});

// libs/core/src/lib/describe-ref.ts
function getArgs(options, includeMergedTags = false) {
  let args = [
    "describe",
    // fallback to short sha if no tags located
    "--always",
    // always return full result, helps identify existing release
    "--long",
    // annotate if uncommitted changes present
    "--dirty",
    // prefer tags originating on upstream branch
    "--first-parent"
  ];
  if (options.match) {
    args.push("--match", options.match);
  }
  if (includeMergedTags) {
    args = args.filter((arg) => arg !== "--first-parent");
  }
  return args;
}
function describeRef(options = {}, includeMergedTags) {
  const promise = childProcess2.exec("git", getArgs(options, includeMergedTags), options);
  return promise.then(({ stdout }) => {
    const result = parse(stdout, options.cwd);
    import_npmlog2.default.verbose("git-describe", "%j => %j", options && options.match, stdout);
    import_npmlog2.default.silly("git-describe", "parsed => %j", result);
    return result;
  });
}
function describeRefSync(options = {}, includeMergedTags) {
  const stdout = childProcess2.execSync("git", getArgs(options, includeMergedTags), options);
  const result = parse(stdout, options.cwd);
  import_npmlog2.default.silly("git-describe.sync", "%j => %j", stdout, result);
  return result;
}
function parse(stdout, cwd) {
  const minimalShaRegex = /^([0-9a-f]{7,40})(-dirty)?$/;
  if (minimalShaRegex.test(stdout)) {
    const [, sha2, isDirty2] = minimalShaRegex.exec(stdout);
    const refCount2 = childProcess2.execSync("git", ["rev-list", "--count", sha2], { cwd });
    return { refCount: refCount2, sha: sha2, isDirty: Boolean(isDirty2) };
  }
  const [, lastTagName, lastVersion, refCount, sha, isDirty] = /^((?:.*@)?(.*))-(\d+)-g([0-9a-f]+)(-dirty)?$/.exec(stdout) || [];
  return { lastTagName, lastVersion, refCount, sha, isDirty: Boolean(isDirty) };
}
var import_npmlog2, childProcess2;
var init_describe_ref = __esm({
  "libs/core/src/lib/describe-ref.ts"() {
    "use strict";
    import_npmlog2 = __toESM(require("npmlog"));
    childProcess2 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/validation-error.ts
var import_npmlog3, ValidationError;
var init_validation_error = __esm({
  "libs/core/src/lib/validation-error.ts"() {
    "use strict";
    import_npmlog3 = __toESM(require("npmlog"));
    ValidationError = class extends Error {
      prefix;
      constructor(prefix, message, ...rest) {
        super(message);
        this.name = "ValidationError";
        this.prefix = prefix;
        import_npmlog3.default.resume();
        import_npmlog3.default.error(prefix, message, ...rest);
      }
    };
  }
});

// libs/core/src/lib/check-working-tree.ts
function checkWorkingTree({ cwd } = {}) {
  let chain = Promise.resolve();
  chain = chain.then(() => describeRef({ cwd }));
  const tests = [
    // prevent duplicate versioning
    chain.then(throwIfReleased),
    // prevent publish of uncommitted changes
    chain.then(mkThrowIfUncommitted({ cwd }))
  ];
  return chain.then((result) => Promise.all(tests).then(() => result));
}
function throwIfReleased({ refCount }) {
  if (refCount === "0") {
    throw new ValidationError(
      "ERELEASED",
      "The current commit has already been released. Please make new commits before continuing."
    );
  }
}
function mkThrowIfUncommitted(options = {}) {
  return function throwIfUncommitted2(opts) {
    if (opts.isDirty) {
      return collectUncommitted(options).then((uncommitted) => {
        throw new ValidationError("EUNCOMMIT", `${EUNCOMMIT_MSG}${uncommitted.join("\n")}`);
      });
    }
  };
}
var EUNCOMMIT_MSG, throwIfUncommitted;
var init_check_working_tree = __esm({
  "libs/core/src/lib/check-working-tree.ts"() {
    "use strict";
    init_collect_uncommitted();
    init_describe_ref();
    init_validation_error();
    EUNCOMMIT_MSG = "Working tree has uncommitted changes, please commit or remove the following changes before continuing:\n";
    throwIfUncommitted = mkThrowIfUncommitted();
  }
});

// libs/core/src/lib/cli.ts
function lernaCLI(argv, cwd) {
  const cli = (0, import_yargs.default)(argv, cwd);
  return globalOptions(cli).usage("Usage: $0 <command> [options]").demandCommand(1, "A command is required. Pass --help to see all available commands and options.").recommendCommands().strict().fail((msg, err) => {
    const actual = err || new Error(msg);
    if (actual.name !== "ValidationError" && !actual.pkg) {
      if (/Did you mean/.test(actual.message)) {
        import_npmlog4.default.error("lerna", `Unknown command "${cli.parsed.argv._[0]}"`);
      }
      import_npmlog4.default.error("lerna", actual.message);
    }
    cli.exit(actual.exitCode > 0 ? actual.exitCode : 1, actual);
  }).alias("h", "help").alias("v", "version").wrap(cli.terminalWidth()).epilogue(import_dedent.default`
      When a command fails, all logs are written to lerna-debug.log in the current working directory.

      For more information, check out the docs at https://lerna.js.org/docs/introduction
    `);
}
function globalOptions(argv) {
  const opts = {
    loglevel: {
      defaultDescription: "info",
      describe: "What level of logs to report.",
      type: "string"
    },
    concurrency: {
      defaultDescription: String(import_os.default.cpus().length),
      describe: "How many processes to use when lerna parallelizes tasks.",
      type: "number",
      requiresArg: true
    },
    "reject-cycles": {
      describe: "Fail if a cycle is detected among dependencies.",
      type: "boolean"
    },
    "no-progress": {
      describe: "Disable progress bars. (Always off in CI)",
      type: "boolean"
    },
    progress: {
      // proxy for --no-progress
      hidden: true,
      type: "boolean"
    },
    "no-sort": {
      describe: "Do not sort packages topologically (dependencies before dependents).",
      type: "boolean"
    },
    sort: {
      // proxy for --no-sort
      hidden: true,
      type: "boolean"
    },
    "max-buffer": {
      describe: "Set max-buffer (in bytes) for subcommand execution",
      type: "number",
      requiresArg: true
    }
  };
  const globalKeys = Object.keys(opts).concat(["help", "version"]);
  return argv.options(opts).group(globalKeys, "Global Options:").option("ci", {
    hidden: true,
    type: "boolean"
  });
}
var import_dedent, import_npmlog4, import_os, import_yargs;
var init_cli = __esm({
  "libs/core/src/lib/cli.ts"() {
    "use strict";
    import_dedent = __toESM(require("dedent"));
    import_npmlog4 = __toESM(require("npmlog"));
    import_os = __toESM(require("os"));
    import_yargs = __toESM(require("yargs"));
  }
});

// libs/core/src/lib/get-packages-for-option.ts
function getPackagesForOption(option) {
  let inputs = null;
  if (option === true) {
    inputs = ["*"];
  } else if (typeof option === "string") {
    inputs = option.split(",");
  } else if (Array.isArray(option)) {
    inputs = [...option];
  }
  return new Set(inputs);
}
var init_get_packages_for_option = __esm({
  "libs/core/src/lib/get-packages-for-option.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/prerelease-id-from-version.ts
function prereleaseIdFromVersion(version) {
  return (import_semver.default.prerelease(version) || []).shift();
}
var import_semver;
var init_prerelease_id_from_version = __esm({
  "libs/core/src/lib/prerelease-id-from-version.ts"() {
    "use strict";
    import_semver = __toESM(require("semver"));
  }
});

// libs/core/src/lib/project-graph-with-packages.ts
function getPackage(project) {
  if (!project.package) {
    throw new Error(`Failed attempting to find package for project ${project.name}`);
  }
  return project.package;
}
var isExternalNpmDependency;
var init_project_graph_with_packages = __esm({
  "libs/core/src/lib/project-graph-with-packages.ts"() {
    "use strict";
    isExternalNpmDependency = (dep) => dep.startsWith("npm:");
  }
});

// libs/core/src/lib/collect-updates/has-tags.ts
function hasTags(opts) {
  import_npmlog5.default.silly("hasTags");
  let result = false;
  try {
    result = !!childProcess3.execSync("git", ["tag"], opts);
  } catch (err) {
    import_npmlog5.default.warn("ENOTAGS", "No git tags were reachable from this branch!");
    import_npmlog5.default.verbose("hasTags error", err);
  }
  import_npmlog5.default.verbose("hasTags", result);
  return result;
}
var import_npmlog5, childProcess3;
var init_has_tags = __esm({
  "libs/core/src/lib/collect-updates/has-tags.ts"() {
    "use strict";
    import_npmlog5 = __toESM(require("npmlog"));
    childProcess3 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/collect-updates/make-diff-predicate.ts
function makeDiffPredicate(committish, execOpts, ignorePatterns = []) {
  const ignoreFilters = new Set(
    ignorePatterns.map(
      (p) => import_minimatch.default.filter(`!${p}`, {
        matchBase: true,
        // dotfiles inside ignored directories should also match
        dot: true
      })
    )
  );
  if (ignoreFilters.size) {
    import_npmlog6.default.info("ignoring diff in paths matching", ignorePatterns);
  }
  return function hasDiffSinceThatIsntIgnored(node) {
    const diff = diffSinceIn(committish, getPackage(node).location, execOpts);
    if (diff === "") {
      import_npmlog6.default.silly("", "no diff found in %s", node.name);
      return false;
    }
    import_npmlog6.default.silly("found diff in", diff);
    let changedFiles = diff.split("\n");
    if (ignoreFilters.size) {
      for (const ignored of ignoreFilters) {
        changedFiles = changedFiles.filter(ignored);
      }
    }
    if (changedFiles.length) {
      import_npmlog6.default.verbose("filtered diff", changedFiles);
    } else {
      import_npmlog6.default.verbose("", "no diff found in %s (after filtering)", node.name);
    }
    return changedFiles.length > 0;
  };
}
function diffSinceIn(committish, location, opts) {
  const args = ["diff", "--name-only", committish];
  const formattedLocation = (0, import_slash.default)((0, import_path.relative)(opts.cwd, location));
  if (formattedLocation) {
    args.push("--", formattedLocation);
  }
  import_npmlog6.default.silly("checking diff", formattedLocation);
  return execSync("git", args, opts);
}
var import_minimatch, import_npmlog6, import_path, import_slash, execSync;
var init_make_diff_predicate = __esm({
  "libs/core/src/lib/collect-updates/make-diff-predicate.ts"() {
    "use strict";
    import_minimatch = __toESM(require("minimatch"));
    import_npmlog6 = __toESM(require("npmlog"));
    import_path = require("path");
    import_slash = __toESM(require("slash"));
    init_project_graph_with_packages();
    ({ execSync } = require("@lerna/child-process"));
  }
});

// libs/core/src/lib/collect-updates/collect-project-updates.ts
function collectProjectUpdates(filteredProjects, projectGraph, execOpts, commandOptions) {
  const {
    forcePublish,
    conventionalCommits,
    forceConventionalGraduate,
    conventionalGraduate,
    excludeDependents
  } = commandOptions;
  const useConventionalGraduate = conventionalCommits && (conventionalGraduate || forceConventionalGraduate);
  const forced = getPackagesForOption(useConventionalGraduate ? conventionalGraduate : forcePublish);
  let committish = commandOptions.since ?? "";
  if (hasTags(execOpts)) {
    const { sha, refCount, lastTagName } = describeRefSync(execOpts, commandOptions.includeMergedTags);
    if (refCount === "0" && forced.size === 0 && !committish) {
      import_npmlog7.default.notice("", "Current HEAD is already released, skipping change detection.");
      return [];
    }
    if (commandOptions.canary) {
      committish = `${sha}^..${sha}`;
    } else if (!committish) {
      committish = lastTagName;
    }
  }
  if (forced.size) {
    import_npmlog7.default.warn(
      useConventionalGraduate ? "conventional-graduate" : "force-publish",
      forced.has("*") ? "all packages" : Array.from(forced.values()).join("\n")
    );
  }
  if (useConventionalGraduate) {
    if (forced.has("*")) {
      import_npmlog7.default.info("", "Graduating all prereleased packages");
    } else {
      import_npmlog7.default.info("", "Graduating prereleased packages");
    }
  } else if (!committish || forced.has("*")) {
    import_npmlog7.default.info("", "Assuming all packages changed");
    return collectProjects(filteredProjects, projectGraph, {
      onInclude: (name) => import_npmlog7.default.verbose("updated", name),
      excludeDependents
    });
  }
  import_npmlog7.default.info("", `Looking for changed packages since ${committish}`);
  const hasDiff = makeDiffPredicate(committish, execOpts, commandOptions.ignoreChanges);
  const needsBump = !commandOptions.bump || commandOptions.bump.startsWith("pre") ? () => false : (
    /* skip packages that have not been previously prereleased */
    (node) => !!prereleaseIdFromVersion(getPackage(node).version)
  );
  const isForced = (node, name) => !!((forced.has("*") || forced.has(name)) && ((useConventionalGraduate ? prereleaseIdFromVersion(getPackage(node).version) : true) || forceConventionalGraduate));
  return collectProjects(filteredProjects, projectGraph, {
    isCandidate: (node, name) => isForced(node, name) || needsBump(node) || hasDiff(node),
    onInclude: (name) => import_npmlog7.default.verbose("updated", name),
    excludeDependents
  });
}
function collectProjects(projects, projectGraph, { isCandidate = () => true, onInclude, excludeDependents } = {}) {
  const candidates = {};
  projects.forEach((node) => {
    if (isCandidate(node, getPackage(node).name)) {
      candidates[node.name] = node;
    }
  });
  if (!excludeDependents) {
    collectDependents(candidates, projectGraph).forEach((node) => candidates[node.name] = node);
  }
  const updates = [];
  projects.forEach((node) => {
    if (candidates[node.name]) {
      if (onInclude) {
        onInclude(getPackage(node).name);
      }
      updates.push(node);
    }
  });
  return updates;
}
function collectDependents(nodes, projectGraph) {
  const dependents = (0, import_lodash2.flatten)(
    Object.values(projectGraph.localPackageDependencies)
  ).reduce(
    (prev, next) => ({
      ...prev,
      [next.target]: [...prev[next.target] || [], next.source]
    }),
    {}
  );
  const collected = /* @__PURE__ */ new Set();
  Object.values(nodes).forEach((currentNode) => {
    if (dependents[currentNode.name] && dependents[currentNode.name].length === 0) {
      return;
    }
    const queue2 = [currentNode];
    const seen = /* @__PURE__ */ new Set();
    while (queue2.length) {
      const node = queue2.shift();
      dependents[node.name]?.forEach((dep) => {
        if (seen.has(dep)) {
          return;
        }
        seen.add(dep);
        if (dep === currentNode.name || nodes[dep]) {
          return;
        }
        const dependentNode = projectGraph.nodes[dep];
        collected.add(dependentNode);
        queue2.push(dependentNode);
      });
    }
  });
  return collected;
}
var import_lodash2, import_npmlog7;
var init_collect_project_updates = __esm({
  "libs/core/src/lib/collect-updates/collect-project-updates.ts"() {
    "use strict";
    import_lodash2 = require("lodash");
    import_npmlog7 = __toESM(require("npmlog"));
    init_describe_ref();
    init_get_packages_for_option();
    init_prerelease_id_from_version();
    init_project_graph_with_packages();
    init_has_tags();
    init_make_diff_predicate();
  }
});

// libs/core/src/lib/collect-updates/index.ts
var init_collect_updates = __esm({
  "libs/core/src/lib/collect-updates/index.ts"() {
    "use strict";
    init_collect_project_updates();
  }
});

// libs/core/src/lib/package.ts
function binSafeName({ name, scope }) {
  return scope ? name.substring(scope.length + 1) : name;
}
function shallowCopy(json) {
  return Object.keys(json).reduce((obj, key) => {
    const val = json[key];
    if (Array.isArray(val)) {
      obj[key] = val.slice();
    } else if (val && typeof val === "object") {
      obj[key] = Object.assign({}, val);
    } else {
      obj[key] = val;
    }
    return obj;
  }, {});
}
var import_devkit, import_fs, import_load_json_file, import_npm_package_arg, import_path2, import_write_pkg, PKG, _location, _resolved, _rootPath, _scripts, _contents, Package;
var init_package = __esm({
  "libs/core/src/lib/package.ts"() {
    "use strict";
    import_devkit = require("@nx/devkit");
    import_fs = __toESM(require("fs"));
    import_load_json_file = __toESM(require("load-json-file"));
    import_npm_package_arg = __toESM(require("npm-package-arg"));
    import_path2 = __toESM(require("path"));
    import_write_pkg = __toESM(require("write-pkg"));
    PKG = Symbol("pkg");
    _location = Symbol("location");
    _resolved = Symbol("resolved");
    _rootPath = Symbol("rootPath");
    _scripts = Symbol("scripts");
    _contents = Symbol("contents");
    Package = class {
      name;
      [PKG];
      [_location];
      [_resolved];
      [_rootPath];
      [_scripts];
      [_contents];
      licensePath;
      packed;
      /**
       * Create a Package instance from parameters, possibly reusing existing instance.
       * @param ref A path to a package.json file, Package instance, or JSON object
       * @param [dir] If `ref` is a JSON object, this is the location of the manifest
       */
      static lazy(ref, dir = ".") {
        if (typeof ref === "string") {
          const location = import_path2.default.resolve(import_path2.default.basename(ref) === "package.json" ? import_path2.default.dirname(ref) : ref);
          const manifest = import_load_json_file.default.sync(import_path2.default.join(location, "package.json"));
          return new Package(manifest, location);
        }
        if ("__isLernaPackage" in ref) {
          return ref;
        }
        return new Package(ref, dir);
      }
      constructor(pkg2, location, rootPath = location) {
        const resolved = import_npm_package_arg.default.resolve(pkg2.name, `file:${import_path2.default.relative(rootPath, location)}`, rootPath);
        this.name = pkg2.name;
        this[PKG] = pkg2;
        Object.defineProperty(this, PKG, { enumerable: false, writable: true });
        this[_location] = location;
        this[_resolved] = resolved;
        this[_rootPath] = rootPath;
        this[_scripts] = { ...pkg2.scripts };
      }
      // readonly getters
      get location() {
        return this[_location];
      }
      get private() {
        return Boolean(this[PKG].private);
      }
      set private(isPrivate) {
        this[PKG].private = isPrivate;
      }
      get resolved() {
        return this[_resolved];
      }
      get rootPath() {
        return this[_rootPath];
      }
      get scripts() {
        return this[_scripts];
      }
      get lernaConfig() {
        return this[PKG].lerna;
      }
      set lernaConfig(config) {
        this[PKG].lerna = config;
      }
      get bin() {
        const pkg2 = this[PKG];
        return typeof pkg2.bin === "string" ? {
          // See note on function implementation
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          [binSafeName(this.resolved)]: pkg2.bin
        } : Object.assign({}, pkg2.bin);
      }
      get binLocation() {
        return import_path2.default.join(this.location, "node_modules", ".bin");
      }
      get manifestLocation() {
        return import_path2.default.join(this.location, "package.json");
      }
      get nodeModulesLocation() {
        return import_path2.default.join(this.location, "node_modules");
      }
      // eslint-disable-next-line class-methods-use-this
      get __isLernaPackage() {
        return true;
      }
      // accessors
      get version() {
        return this[PKG].version;
      }
      set version(version) {
        this[PKG].version = version;
      }
      get contents() {
        if (this[_contents]) {
          return this[_contents];
        }
        if (this[PKG].publishConfig && this[PKG].publishConfig.directory) {
          return import_path2.default.join(this.location, this[PKG].publishConfig.directory);
        }
        return this.location;
      }
      set contents(subDirectory) {
        const _workspaceRoot = process.env["NX_WORKSPACE_ROOT_PATH"] || import_devkit.workspaceRoot;
        if (subDirectory.startsWith(_workspaceRoot)) {
          this[_contents] = subDirectory;
          return;
        }
        this[_contents] = import_path2.default.join(this.location, subDirectory);
      }
      // "live" collections
      get dependencies() {
        return this[PKG].dependencies;
      }
      get devDependencies() {
        return this[PKG].devDependencies;
      }
      get optionalDependencies() {
        return this[PKG].optionalDependencies;
      }
      get peerDependencies() {
        return this[PKG].peerDependencies;
      }
      /**
       * Map-like retrieval of arbitrary values
       */
      get(key) {
        return this[PKG][key];
      }
      /**
       * Map-like storage of arbitrary values
       */
      set(key, val) {
        this[PKG][key] = val;
        return this;
      }
      /**
       * Provide shallow copy for munging elsewhere
       */
      toJSON() {
        return shallowCopy(this[PKG]);
      }
      /**
       * Refresh internal state from disk (e.g., changed by external lifecycles)
       */
      refresh() {
        return (0, import_load_json_file.default)(this.manifestLocation).then((pkg2) => {
          this[PKG] = pkg2;
          return this;
        });
      }
      /**
       * Write manifest changes to disk
       * @returns {Promise} resolves when write finished
       */
      serialize() {
        return (0, import_write_pkg.default)(this.manifestLocation, this[PKG]).then(() => this);
      }
      /**
       * Sync dist manifest version
       */
      async syncDistVersion(doSync) {
        if (doSync) {
          const distPkg = import_path2.default.join(this.contents, "package.json");
          if (distPkg !== this.manifestLocation && import_fs.default.existsSync(distPkg)) {
            const pkg2 = await (0, import_load_json_file.default)(distPkg);
            pkg2.version = this[PKG].version;
            await (0, import_write_pkg.default)(distPkg, pkg2);
          }
        }
        return this;
      }
      getLocalDependency(depName) {
        if (this.dependencies && this.dependencies[depName]) {
          return {
            collection: "dependencies",
            spec: this.dependencies[depName]
          };
        }
        if (this.devDependencies && this.devDependencies[depName]) {
          return {
            collection: "devDependencies",
            spec: this.devDependencies[depName]
          };
        }
        if (this.optionalDependencies && this.optionalDependencies[depName]) {
          return {
            collection: "optionalDependencies",
            spec: this.optionalDependencies[depName]
          };
        }
        return null;
      }
      /**
       * Mutate local dependency spec according to type
       * @param resolved npa metadata
       * @param depVersion semver
       * @param savePrefix npm_config_save_prefix
       */
      updateLocalDependency(resolved, depVersion, savePrefix, options = { retainWorkspacePrefix: true }) {
        const depName = resolved.name;
        let depCollection = this.dependencies;
        if (!depCollection || !depCollection[depName]) {
          depCollection = this.optionalDependencies;
        }
        if (!depCollection || !depCollection[depName]) {
          depCollection = this.devDependencies;
        }
        if (resolved.workspaceSpec && options.retainWorkspacePrefix) {
          if (!resolved.workspaceAlias) {
            const workspacePrefix = resolved.workspaceSpec.match(/^(workspace:[*~^]?)/)[0];
            depCollection[depName] = `${workspacePrefix}${depVersion}`;
          }
        } else if (resolved.registry || resolved.type === "directory") {
          depCollection[depName] = `${savePrefix}${depVersion}`;
        } else if (resolved.gitCommittish) {
          const [tagPrefix] = /^\D*/.exec(resolved.gitCommittish);
          const { hosted } = resolved;
          hosted.committish = `${tagPrefix}${depVersion}`;
          depCollection[depName] = hosted.toString({ noGitPlus: false, noCommittish: false });
        } else if (resolved.gitRange) {
          const { hosted } = resolved;
          hosted.committish = `semver:${savePrefix}${depVersion}`;
          depCollection[depName] = hosted.toString({ noGitPlus: false, noCommittish: false });
        }
      }
      /**
       * Remove the private property, effectively making the package public.
       */
      removePrivate() {
        delete this[PKG].private;
      }
    };
  }
});

// libs/core/src/lib/project/shallow-extend.ts
function shallowExtend(json, defaults = {}) {
  return Object.keys(json).reduce((obj, key) => {
    const val = json[key];
    if (Array.isArray(val)) {
      obj[key] = val.slice();
    } else if (val && typeof val === "object") {
      obj[key] = shallowExtend(val, obj[key]);
    } else {
      obj[key] = val;
    }
    return obj;
  }, defaults);
}
var init_shallow_extend = __esm({
  "libs/core/src/lib/project/shallow-extend.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/project/apply-extends.ts
function applyExtends(config, cwd, seen = /* @__PURE__ */ new Set()) {
  let defaultConfig = {};
  if ("extends" in config) {
    let pathToDefault;
    try {
      pathToDefault = (0, import_resolve_from.default)(cwd, config.extends);
    } catch (err) {
      throw new ValidationError("ERESOLVED", "Config .extends must be locally-resolvable", err);
    }
    if (seen.has(pathToDefault)) {
      throw new ValidationError("ECIRCULAR", "Config .extends cannot be circular", seen);
    }
    seen.add(pathToDefault);
    defaultConfig = require(pathToDefault);
    delete config.extends;
    defaultConfig = applyExtends(defaultConfig, import_path3.default.dirname(pathToDefault), seen);
  }
  return shallowExtend(config, defaultConfig);
}
var import_path3, import_resolve_from;
var init_apply_extends = __esm({
  "libs/core/src/lib/project/apply-extends.ts"() {
    "use strict";
    import_path3 = __toESM(require("path"));
    import_resolve_from = __toESM(require("resolve-from"));
    init_validation_error();
    init_shallow_extend();
  }
});

// libs/core/src/lib/project/make-file-finder.ts
function normalize(results) {
  return results.map((fp) => import_path4.default.normalize(fp));
}
function getGlobOpts(rootPath, packageConfigs) {
  const globOpts = {
    cwd: rootPath,
    absolute: true,
    expandDirectories: false,
    followSymbolicLinks: false
  };
  if (packageConfigs.some((cfg) => cfg.indexOf("**") > -1)) {
    if (packageConfigs.some((cfg) => cfg.indexOf("node_modules") > -1)) {
      throw new ValidationError(
        "EPKGCONFIG",
        "An explicit node_modules package path does not allow globstars (**)"
      );
    }
    globOpts.ignore = [
      // allow globs like "packages/**",
      // but avoid picking up node_modules/**/package.json
      "**/node_modules/**"
    ];
  }
  return globOpts;
}
function makeFileFinder(rootPath, packageConfigs) {
  const globOpts = getGlobOpts(rootPath, packageConfigs);
  return (fileName, fileMapper, customGlobOpts) => {
    const options = Object.assign({}, customGlobOpts, globOpts);
    const promise = (0, import_p_map.default)(
      Array.from(packageConfigs).sort(),
      (globPath) => {
        let chain = (0, import_globby.default)(import_path4.default.posix.join(globPath, fileName), options);
        chain = chain.then((results) => results.sort());
        chain = chain.then(normalize);
        if (fileMapper) {
          chain = chain.then(fileMapper);
        }
        return chain;
      },
      { concurrency: 4 }
    );
    return promise.then((results) => results.reduce((acc, result) => acc.concat(result), []));
  };
}
function makeSyncFileFinder(rootPath, packageConfigs) {
  const globOpts = getGlobOpts(rootPath, packageConfigs);
  return (fileName, fileMapper) => {
    const patterns = packageConfigs.map((globPath) => import_path4.default.posix.join(globPath, fileName)).sort();
    let results = import_globby.default.sync(patterns, globOpts);
    results = normalize(results);
    return results.map((res) => fileMapper(res));
  };
}
var import_globby, import_p_map, import_path4;
var init_make_file_finder = __esm({
  "libs/core/src/lib/project/make-file-finder.ts"() {
    "use strict";
    import_globby = __toESM(require("globby"));
    import_p_map = __toESM(require("p-map"));
    import_path4 = __toESM(require("path"));
    init_validation_error();
  }
});

// libs/core/src/lib/project/index.ts
var import_devkit2, import_cosmiconfig, import_dedent2, import_fs2, import_glob_parent, import_globby2, import_js_yaml, import_load_json_file2, import_npmlog8, import_p_map2, import_path5, LICENSE_GLOB, Project, getPackages, getPackagesSync;
var init_project = __esm({
  "libs/core/src/lib/project/index.ts"() {
    "use strict";
    import_devkit2 = require("@nx/devkit");
    import_cosmiconfig = require("cosmiconfig");
    import_dedent2 = __toESM(require("dedent"));
    import_fs2 = __toESM(require("fs"));
    import_glob_parent = __toESM(require("glob-parent"));
    import_globby2 = __toESM(require("globby"));
    import_js_yaml = require("js-yaml");
    import_load_json_file2 = __toESM(require("load-json-file"));
    import_npmlog8 = __toESM(require("npmlog"));
    import_p_map2 = __toESM(require("p-map"));
    import_path5 = __toESM(require("path"));
    init_package();
    init_validation_error();
    init_apply_extends();
    init_make_file_finder();
    LICENSE_GLOB = "LICEN{S,C}E{,.*}";
    Project = class {
      config;
      configNotFound;
      rootConfigLocation;
      rootPath;
      packageConfigs;
      manifest;
      /**
       * @deprecated Only used in legacy core utilities
       * TODO: remove in v8
       */
      static getPackages(cwd) {
        return new Project(cwd).getPackages();
      }
      /**
       * @deprecated Only used in legacy core utilities
       * TODO: remove in v8
       */
      static getPackagesSync(cwd) {
        return new Project(cwd).getPackagesSync();
      }
      constructor(cwd, options) {
        const { config, configNotFound, filepath } = this.#resolveLernaConfig(cwd);
        this.config = config;
        this.configNotFound = configNotFound || false;
        this.rootConfigLocation = filepath;
        this.rootPath = import_path5.default.dirname(filepath);
        this.manifest = this.#resolveRootPackageJson();
        if (this.configNotFound) {
          throw new ValidationError("ENOLERNA", "`lerna.json` does not exist, have you run `lerna init`?");
        }
        if (!options?.skipLernaConfigValidations) {
          this.#validateLernaConfig(config);
        }
        this.packageConfigs = this.#resolvePackageConfigs();
        import_npmlog8.default.verbose("rootPath", this.rootPath);
      }
      get version() {
        return this.config.version;
      }
      set version(val) {
        this.config.version = val;
      }
      get packageParentDirs() {
        return this.packageConfigs.map((packagePattern) => (0, import_glob_parent.default)(packagePattern)).map((parentDir) => import_path5.default.resolve(this.rootPath, parentDir));
      }
      get licensePath() {
        let licensePath;
        try {
          const search = import_globby2.default.sync(LICENSE_GLOB, {
            cwd: this.rootPath,
            absolute: true,
            caseSensitiveMatch: false,
            // Project license is always a sibling of the root manifest
            deep: 0
          });
          licensePath = search.shift();
          if (licensePath) {
            licensePath = import_path5.default.normalize(licensePath);
            Object.defineProperty(this, "licensePath", {
              value: licensePath
            });
          }
        } catch (err) {
          throw new ValidationError(err.name, err.message);
        }
        return licensePath;
      }
      get fileFinder() {
        const finder = makeFileFinder(this.rootPath, this.packageConfigs);
        Object.defineProperty(this, "fileFinder", {
          value: finder
        });
        return finder;
      }
      /**
       * A promise resolving to a list of Package instances
       */
      getPackages() {
        const mapper = (packageConfigPath) => (0, import_load_json_file2.default)(packageConfigPath).then(
          (packageJson) => new Package(packageJson, import_path5.default.dirname(packageConfigPath), this.rootPath)
        );
        return this.fileFinder("package.json", (filePaths) => (0, import_p_map2.default)(filePaths, mapper, { concurrency: 50 }));
      }
      /**
       * A list of Package instances
       */
      getPackagesSync() {
        const syncFileFinder = makeSyncFileFinder(this.rootPath, this.packageConfigs);
        return syncFileFinder("package.json", (packageConfigPath) => {
          return new Package(
            import_load_json_file2.default.sync(packageConfigPath),
            import_path5.default.dirname(packageConfigPath),
            this.rootPath
          );
        });
      }
      getPackageLicensePaths() {
        return this.fileFinder(LICENSE_GLOB, null, { caseSensitiveMatch: false });
      }
      isIndependent() {
        return this.version === "independent";
      }
      serializeConfig() {
        (0, import_devkit2.writeJsonFile)(this.rootConfigLocation, this.config, { spaces: 2 });
        return this.rootConfigLocation;
      }
      #resolveRootPackageJson() {
        try {
          const manifestLocation = import_path5.default.join(this.rootPath, "package.json");
          const packageJson = import_load_json_file2.default.sync(manifestLocation);
          if (!packageJson.name) {
            packageJson.name = import_path5.default.basename(import_path5.default.dirname(manifestLocation));
          }
          return new Package(packageJson, this.rootPath);
        } catch (err) {
          if (err instanceof Error && err?.name === "JSONError") {
            throw new ValidationError(err.name, err.message);
          }
          throw new ValidationError("ENOPKG", "`package.json` does not exist, have you run `lerna init`?");
        }
      }
      #resolveLernaConfig(cwd) {
        try {
          const explorer = (0, import_cosmiconfig.cosmiconfigSync)("lerna", {
            loaders: {
              ...import_cosmiconfig.defaultLoaders,
              ".json": (filepath, content) => {
                if (!filepath.endsWith("lerna.json")) {
                  return import_cosmiconfig.defaultLoaders[".json"](filepath, content);
                }
                try {
                  return (0, import_devkit2.parseJson)(content);
                } catch (err) {
                  if (err instanceof Error) {
                    err.name = "JSONError";
                    err.message = `Error in: ${filepath}
${err.message}`;
                  }
                  throw err;
                }
              }
            },
            searchPlaces: ["lerna.json", "package.json"],
            transform(obj) {
              if (!obj) {
                const configNotFoundResult = {
                  // No need to distinguish between missing and empty,
                  // saves a lot of noisy guards elsewhere
                  config: {},
                  configNotFound: true,
                  // path.resolve(".", ...) starts from process.cwd()
                  filepath: import_path5.default.resolve(cwd || ".", "lerna.json")
                };
                return configNotFoundResult;
              }
              obj.config = applyExtends(obj.config, import_path5.default.dirname(obj.filepath));
              return obj;
            }
          });
          return explorer.search(cwd);
        } catch (err) {
          if (err.name === "JSONError") {
            throw new ValidationError(err.name, err.message);
          }
          throw err;
        }
      }
      #validateLernaConfig(config) {
        if (!this.version) {
          throw new ValidationError("ENOVERSION", "Required property version does not exist in `lerna.json`");
        }
        if (config.useWorkspaces !== void 0) {
          throw new ValidationError(
            "ECONFIGWORKSPACES",
            `The "useWorkspaces" option has been removed. By default lerna will resolve your packages using your package manager's workspaces configuration. Alternatively, you can manually provide a list of package globs to be used instead via the "packages" option in lerna.json.`
          );
        }
      }
      #resolvePnpmWorkspaceConfig() {
        let config;
        try {
          const configLocation = import_path5.default.join(this.rootPath, "pnpm-workspace.yaml");
          const configContent = import_fs2.default.readFileSync(configLocation, { encoding: "utf8" });
          config = (0, import_js_yaml.load)(configContent);
        } catch (err) {
          if (err.message.includes("ENOENT: no such file or directory")) {
            throw new ValidationError(
              "ENOENT",
              "No pnpm-workspace.yaml found. See https://pnpm.io/workspaces for help configuring workspaces in pnpm."
            );
          }
          throw new ValidationError(err.name, err.message);
        }
        return config;
      }
      /**
       * By default, the user's package manager workspaces configuration will be used to resolve packages.
       * However, they can optionally specify an explicit set of package globs to be used instead.
       *
       * NOTE: This does not impact the project graph creation process, which will still ultimately use
       * the package manager workspaces configuration to construct a full graph, it will only impact which
       * of the packages in that graph will be considered when running commands.
       */
      #resolvePackageConfigs() {
        if (this.config.packages) {
          import_npmlog8.default.verbose(
            "packageConfigs",
            `Explicit "packages" configuration found in lerna.json. Resolving packages using the configured glob(s): ${JSON.stringify(
              this.config.packages
            )}`
          );
          return this.config.packages;
        }
        if (this.config.npmClient === "pnpm") {
          import_npmlog8.default.verbose(
            "packageConfigs",
            'Package manager "pnpm" detected. Resolving packages using `pnpm-workspace.yaml`.'
          );
          const workspaces2 = this.#resolvePnpmWorkspaceConfig().packages;
          if (!workspaces2) {
            throw new ValidationError(
              "EWORKSPACES",
              'No "packages" property found in `pnpm-workspace.yaml`. See https://pnpm.io/workspaces for help configuring workspaces in pnpm.'
            );
          }
          return workspaces2;
        }
        const workspaces = this.manifest?.get("workspaces");
        const isYarnClassicWorkspacesObjectConfig = Boolean(
          workspaces && typeof workspaces === "object" && Array.isArray(workspaces.packages)
        );
        const isValidWorkspacesConfig = Array.isArray(workspaces) || isYarnClassicWorkspacesObjectConfig;
        if (!workspaces || !isValidWorkspacesConfig) {
          throw new ValidationError(
            "EWORKSPACES",
            import_dedent2.default`
          Lerna is expecting to able to resolve the "workspaces" configuration from your package manager in order to determine what packages to work on, but no "workspaces" config was found.
          (A) Did you mean to specify a "packages" config manually in lerna.json instead of using your workspaces config?
          (B) Alternatively, if you are using pnpm as your package manager, make sure you set "npmClient": "pnpm" in your lerna.json so that lerna knows to read from the "pnpm-workspace.yaml" file instead of package.json.
          See: https://lerna.js.org/docs/getting-started
        `
          );
        }
        import_npmlog8.default.verbose("packageConfigs", `Resolving packages based on package.json "workspaces" configuration.`);
        if (isYarnClassicWorkspacesObjectConfig) {
          return workspaces.packages;
        }
        return workspaces;
      }
    };
    getPackages = Project.getPackages;
    getPackagesSync = Project.getPackagesSync;
  }
});

// libs/core/src/lib/write-log-file.ts
function writeLogFile(cwd) {
  let logOutput = "";
  import_npmlog9.default.record.forEach((m) => {
    let pref = [m.id, m.level];
    if (m.prefix) {
      pref.push(m.prefix);
    }
    pref = pref.join(" ");
    m.message.trim().split(/\r?\n/).map((line) => `${pref} ${line}`.trim()).forEach((line) => {
      logOutput += line + import_os2.default.EOL;
    });
  });
  import_write_file_atomic.default.sync(import_path6.default.join(cwd, "lerna-debug.log"), logOutput);
  import_npmlog9.default.record.length = 0;
}
var import_npmlog9, import_os2, import_path6, import_write_file_atomic;
var init_write_log_file = __esm({
  "libs/core/src/lib/write-log-file.ts"() {
    "use strict";
    import_npmlog9 = __toESM(require("npmlog"));
    import_os2 = __toESM(require("os"));
    import_path6 = __toESM(require("path"));
    import_write_file_atomic = __toESM(require("write-file-atomic"));
  }
});

// libs/core/src/lib/command/clean-stack.ts
function cleanStack(err, className) {
  const lines = isErrorWithStack(err) ? err.stack.split("\n") : String(err).split("\n");
  const cutoff = new RegExp(`^    at ${className}.runCommand .*$`);
  const relevantIndex = lines.findIndex((line) => cutoff.test(line));
  if (relevantIndex) {
    return lines.slice(0, relevantIndex).join("\n");
  }
  return err.toString();
}
function isErrorWithStack(err) {
  return err.stack !== void 0;
}
var init_clean_stack = __esm({
  "libs/core/src/lib/command/clean-stack.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/command/default-options.ts
function defaultOptions(...sources) {
  const options = {};
  for (const source of sources) {
    if (source != null) {
      for (const key of Object.keys(source)) {
        if (options[key] === void 0) {
          options[key] = source[key];
        }
      }
    }
  }
  return options;
}
var init_default_options = __esm({
  "libs/core/src/lib/command/default-options.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/get-package-manifest-path.ts
function getPackageManifestPath(node, files) {
  const pkgJsonPath = (0, import_path7.resolve)((0, import_path7.join)(node.data.root, "package.json"));
  return files.find((f) => (0, import_path7.resolve)(f.file) === pkgJsonPath)?.file;
}
var import_path7;
var init_get_package_manifest_path = __esm({
  "libs/core/src/lib/get-package-manifest-path.ts"() {
    "use strict";
    import_path7 = require("path");
  }
});

// libs/core/src/lib/command/create-project-graph-with-packages.ts
async function createProjectGraphWithPackages(projectGraph, projectFileMap, packageConfigs) {
  const _workspaceRoot = process.env["NX_WORKSPACE_ROOT_PATH"] || import_devkit3.workspaceRoot;
  const projectNodes = Object.values(projectGraph.nodes);
  const projectNodesMatchingPackageConfigs = projectNodes.filter((node) => {
    const matchesRootPath = (config) => (0, import_minimatch2.default)(node.data.root, config);
    return packageConfigs.some(matchesRootPath);
  });
  const tuples = await Promise.all(
    projectNodesMatchingPackageConfigs.map(
      (node) => new Promise((resolve3) => {
        const manifestPath = getPackageManifestPath(node, projectFileMap[node.name] || []);
        if (manifestPath) {
          const fullManifestPath = (0, import_path8.join)(_workspaceRoot, manifestPath);
          resolve3((0, import_fs_extra.readJson)(fullManifestPath).then((manifest) => [node, manifest]));
        } else {
          resolve3([node, null]);
        }
      })
    )
  );
  const projectGraphWithOrderedNodes = {
    ...projectGraph,
    nodes: {},
    localPackageDependencies: {}
  };
  const projectLookupByPackageName = {};
  const sortedTuples = (0, import_lodash3.sortBy)(tuples, (t) => t[0].data.root);
  sortedTuples.forEach(([node, manifest]) => {
    let pkg2 = null;
    if (manifest) {
      pkg2 = new Package(manifest, (0, import_path8.join)(_workspaceRoot, node.data.root), _workspaceRoot);
      projectLookupByPackageName[pkg2.name] = node.name;
    }
    projectGraphWithOrderedNodes.nodes[node.name] = {
      ...node,
      package: pkg2
    };
  });
  projectGraphWithOrderedNodes.dependencies = (0, import_lodash3.reduce)(
    (0, import_lodash3.sortBy)(Object.keys(projectGraphWithOrderedNodes.dependencies)),
    (prev, next) => ({ ...prev, [next]: projectGraphWithOrderedNodes.dependencies[next] }),
    {}
  );
  Object.values(projectGraphWithOrderedNodes.dependencies).forEach((projectDeps) => {
    const workspaceDeps = projectDeps.filter(
      (dep) => !isExternalNpmDependency(dep.target) && !isExternalNpmDependency(dep.source)
    );
    for (const dep of workspaceDeps) {
      const source = projectGraphWithOrderedNodes.nodes[dep.source];
      const target = projectGraphWithOrderedNodes.nodes[dep.target];
      if (!source || !source.package || !target || !target.package) {
        continue;
      }
      const sourcePkg = getPackage(source);
      const targetPkg = getPackage(target);
      const sourceNpmDependency = sourcePkg.getLocalDependency(targetPkg.name);
      if (!sourceNpmDependency) {
        continue;
      }
      const workspaceDep = dep;
      const resolvedTarget = resolvePackage(
        targetPkg.name,
        targetPkg.version,
        sourceNpmDependency.spec,
        sourcePkg.location
      );
      const targetMatchesRequirement = resolvedTarget.fetchSpec === targetPkg.location || (0, import_semver2.satisfies)(
        targetPkg.version,
        resolvedTarget.gitCommittish || resolvedTarget.gitRange || resolvedTarget.fetchSpec
      );
      workspaceDep.dependencyCollection = sourceNpmDependency.collection;
      workspaceDep.targetResolvedNpaResult = resolvedTarget;
      workspaceDep.targetVersionMatchesDependencyRequirement = targetMatchesRequirement;
      if (workspaceDep.targetVersionMatchesDependencyRequirement) {
        projectGraphWithOrderedNodes.localPackageDependencies[dep.source] = [
          ...projectGraphWithOrderedNodes.localPackageDependencies[dep.source] || [],
          workspaceDep
        ];
      }
    }
  });
  return projectGraphWithOrderedNodes;
}
var import_devkit3, import_fs_extra, import_lodash3, import_minimatch2, import_npm_package_arg2, import_path8, import_semver2, resolvePackage;
var init_create_project_graph_with_packages = __esm({
  "libs/core/src/lib/command/create-project-graph-with-packages.ts"() {
    "use strict";
    import_devkit3 = require("@nx/devkit");
    import_fs_extra = require("fs-extra");
    import_lodash3 = require("lodash");
    import_minimatch2 = __toESM(require("minimatch"));
    import_npm_package_arg2 = require("npm-package-arg");
    import_path8 = require("path");
    import_semver2 = require("semver");
    init_get_package_manifest_path();
    init_package();
    init_project_graph_with_packages();
    resolvePackage = (name, version, spec, location) => {
      spec = spec.replace(/^link:/, "file:");
      const isWorkspaceSpec = /^workspace:/.test(spec);
      let fullWorkspaceSpec;
      let workspaceAlias;
      if (isWorkspaceSpec) {
        fullWorkspaceSpec = spec;
        spec = spec.replace(/^workspace:/, "");
        if (spec === "*" || spec === "^" || spec === "~") {
          workspaceAlias = spec;
          if (version) {
            const prefix = spec === "*" ? "" : spec;
            spec = `${prefix}${version}`;
          } else {
            spec = "*";
          }
        }
      }
      const resolved = (0, import_npm_package_arg2.resolve)(name, spec, location);
      resolved.workspaceSpec = fullWorkspaceSpec;
      resolved.workspaceAlias = workspaceAlias;
      return resolved;
    };
  }
});

// libs/core/src/lib/command/detect-projects.ts
async function detectProjects(packageConfigs) {
  const _projectGraph = await (0, import_devkit4.createProjectGraphAsync)();
  const projectFileMap = await (0, import_devkit4.createProjectFileMapUsingProjectGraph)(_projectGraph);
  const projectGraph = await createProjectGraphWithPackages(_projectGraph, projectFileMap, packageConfigs);
  return {
    projectGraph,
    projectFileMap
  };
}
var import_devkit4;
var init_detect_projects = __esm({
  "libs/core/src/lib/command/detect-projects.ts"() {
    "use strict";
    import_devkit4 = require("@nx/devkit");
    init_create_project_graph_with_packages();
  }
});

// libs/core/src/lib/command/is-git-initialized.ts
function isGitInitialized(cwd) {
  const opts = {
    cwd,
    // don't throw, just want boolean
    reject: false,
    // only return code, no stdio needed
    stdio: "ignore"
  };
  return import_execa.default.sync("git", ["rev-parse"], opts).exitCode === 0;
}
var import_execa;
var init_is_git_initialized = __esm({
  "libs/core/src/lib/command/is-git-initialized.ts"() {
    "use strict";
    import_execa = __toESM(require("execa"));
  }
});

// libs/core/src/lib/command/log-package-error.ts
function logPackageError(err, stream = false) {
  import_npmlog10.default.error(err.command, `exited ${err.exitCode} in '${err.pkg.name}'`);
  if (stream) {
    return;
  }
  if (err.stdout) {
    import_npmlog10.default.error(err.command, "stdout:");
    directLog(err.stdout);
  }
  if (err.stderr) {
    import_npmlog10.default.error(err.command, "stderr:");
    directLog(err.stderr);
  }
  import_npmlog10.default.error(err.command, `exited ${err.exitCode} in '${err.pkg.name}'`);
}
function directLog(message) {
  import_npmlog10.default.pause();
  console.error(message);
  import_npmlog10.default.resume();
}
var import_npmlog10;
var init_log_package_error = __esm({
  "libs/core/src/lib/command/log-package-error.ts"() {
    "use strict";
    import_npmlog10 = __toESM(require("npmlog"));
  }
});

// libs/core/src/lib/command/warn-if-hanging.ts
function warnIfHanging() {
  const childProcessCount = childProcess4.getChildProcessCount();
  if (childProcessCount > 0) {
    import_npmlog11.default.warn(
      "complete",
      `Waiting for ${childProcessCount} child process${childProcessCount === 1 ? "" : "es"} to exit. CTRL-C to exit immediately.`
    );
  }
}
var import_npmlog11, childProcess4;
var init_warn_if_hanging = __esm({
  "libs/core/src/lib/command/warn-if-hanging.ts"() {
    "use strict";
    import_npmlog11 = __toESM(require("npmlog"));
    childProcess4 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/command/index.ts
var import_clone_deep, import_dedent3, import_npmlog12, import_client, import_os3, DEFAULT_CONCURRENCY, Command;
var init_command = __esm({
  "libs/core/src/lib/command/index.ts"() {
    "use strict";
    import_clone_deep = __toESM(require("clone-deep"));
    import_dedent3 = __toESM(require("dedent"));
    import_npmlog12 = __toESM(require("npmlog"));
    import_client = require("nx/src/daemon/client/client");
    import_os3 = __toESM(require("os"));
    init_project();
    init_validation_error();
    init_write_log_file();
    init_clean_stack();
    init_default_options();
    init_detect_projects();
    init_is_git_initialized();
    init_log_package_error();
    init_warn_if_hanging();
    DEFAULT_CONCURRENCY = import_os3.default.cpus().length;
    Command = class {
      name;
      composed;
      options = {};
      runner;
      concurrency;
      toposort = false;
      execOpts;
      logger;
      envDefaults;
      argv;
      projectGraph;
      projectFileMap;
      _project;
      get project() {
        if (this._project === void 0) {
          throw new ValidationError("ENOPROJECT", "Lerna Project not initialized!");
        }
        return this._project;
      }
      set project(project) {
        this._project = project;
      }
      constructor(_argv, {
        skipValidations,
        preInitializedProjectData
      } = { skipValidations: false }) {
        import_npmlog12.default.pause();
        import_npmlog12.default.heading = "lerna";
        const argv = (0, import_clone_deep.default)(_argv);
        import_npmlog12.default.silly("argv", argv);
        this.name = this.constructor.name.replace(/Command$/, "").toLowerCase();
        this.composed = typeof argv.composed === "string" && argv.composed !== this.name;
        if (!this.composed) {
          import_npmlog12.default.notice("cli", `v${argv.lernaVersion}`);
        }
        let runner = new Promise((resolve3, reject) => {
          let chain = Promise.resolve();
          chain = chain.then(() => {
            this.project = new Project(argv.cwd, { skipLernaConfigValidations: skipValidations });
          });
          chain = chain.then(() => this.configureEnvironment());
          chain = chain.then(() => this.configureOptions());
          chain = chain.then(() => this.configureProperties());
          chain = chain.then(() => {
            const logger = Command.createLogger(this.name, this.options.loglevel);
            Object.defineProperty(this, "logger", {
              value: logger
            });
          });
          if (!skipValidations) {
            chain = chain.then(() => this.runValidations());
          }
          chain = chain.then(() => {
            if (preInitializedProjectData) {
              this.projectFileMap = preInitializedProjectData.projectFileMap;
              this.projectGraph = preInitializedProjectData.projectGraph;
              return;
            }
            return this.detectProjects();
          });
          chain = chain.then(() => this.runPreparations());
          chain = chain.then(() => this.runCommand());
          chain.then(
            (result) => {
              warnIfHanging();
              import_client.daemonClient.reset();
              resolve3(result);
            },
            (err) => {
              if (err.pkg) {
                logPackageError(err, this.options.stream);
              } else if (err.name !== "ValidationError") {
                import_npmlog12.default.error("", cleanStack(err, this.constructor.name));
              }
              if (err.name !== "ValidationError" && !err.pkg) {
                writeLogFile(this.project.rootPath);
              }
              warnIfHanging();
              import_client.daemonClient.reset();
              reject(err);
            }
          );
        });
        if (argv.onResolved || argv.onRejected) {
          runner = runner.then(argv.onResolved, argv.onRejected);
          delete argv.onResolved;
          delete argv.onRejected;
        }
        for (const key of ["cwd", "$0"]) {
          Object.defineProperty(argv, key, { enumerable: false });
        }
        Object.defineProperty(this, "argv", {
          value: Object.freeze(argv)
        });
        this.runner = runner;
      }
      static createLogger(name, loglevel) {
        if (loglevel) {
          import_npmlog12.default.level = loglevel;
        }
        import_npmlog12.default.addLevel("success", 3001, { fg: "green", bold: true });
        import_npmlog12.default.resume();
        return import_npmlog12.default["newGroup"](name);
      }
      // proxy "Promise" methods to "private" instance
      then(onResolved, onRejected) {
        return this.runner.then(onResolved, onRejected);
      }
      /* istanbul ignore next */
      catch(onRejected) {
        return this.runner.catch(onRejected);
      }
      get requiresGit() {
        return true;
      }
      // Override this to inherit config from another command.
      // For example `changed` inherits config from `publish`.
      get otherCommandConfigs() {
        return [];
      }
      async detectProjects() {
        const { projectGraph, projectFileMap } = await detectProjects(this.project.packageConfigs);
        this.projectGraph = projectGraph;
        this.projectFileMap = projectFileMap;
      }
      configureEnvironment() {
        const ci = require("is-ci");
        let loglevel;
        let progress;
        if (ci || !process.stderr.isTTY) {
          import_npmlog12.default.disableColor();
          progress = false;
        } else if (!process.stdout.isTTY) {
          progress = false;
          loglevel = "error";
        } else if (process.stderr.isTTY) {
          import_npmlog12.default.enableColor();
          import_npmlog12.default.enableUnicode();
        }
        Object.defineProperty(this, "envDefaults", {
          value: {
            ci,
            progress,
            loglevel
          }
        });
      }
      configureOptions() {
        const commandConfig = this.project.config.command || {};
        const overrides = [this.name, ...this.otherCommandConfigs].map((key) => commandConfig[key]);
        this.options = defaultOptions(
          // CLI flags, which if defined overrule subsequent values
          this.argv,
          ...overrides,
          // Global options from `lerna.json`
          this.project.config,
          // Environmental defaults prepared in previous step
          this.envDefaults
        );
        if (this.options.verbose && this.options.loglevel !== "silly") {
          this.options.loglevel = "verbose";
        }
      }
      configureProperties() {
        const { concurrency = 0, sort, maxBuffer } = this.options;
        this.concurrency = Math.max(1, +concurrency || DEFAULT_CONCURRENCY);
        this.toposort = sort === void 0 || sort;
        this.execOpts = {
          cwd: this.project.rootPath,
          maxBuffer
        };
      }
      enableProgressBar() {
        if (this.options.progress !== false) {
          import_npmlog12.default.enableProgress();
        }
      }
      runValidations() {
        if ((this.options.since !== void 0 || this.requiresGit) && !isGitInitialized(this.project.rootPath)) {
          throw new ValidationError("ENOGIT", "The git binary was not found, or this is not a git repository.");
        }
        if (this.options.independent && !this.project.isIndependent()) {
          throw new ValidationError(
            "EVERSIONMODE",
            import_dedent3.default`
          You ran lerna with --independent or -i, but the repository is not set to independent mode.
          To use independent mode you need to set lerna.json's "version" property to "independent".
          Then you won't need to pass the --independent or -i flags.
        `
          );
        }
      }
      runPreparations() {
        if (!this.composed && this.project.isIndependent()) {
          import_npmlog12.default.info("versioning", "independent");
        }
        if (!this.composed && this.options.ci) {
          import_npmlog12.default.info("ci", "enabled");
        }
      }
      async runCommand() {
        const proceed = await this.initialize();
        if (proceed !== false) {
          return this.execute();
        }
        return void 0;
      }
      initialize() {
        throw new ValidationError(this.name, "initialize() needs to be implemented.");
      }
      /**
       * The execute() method can return a value in some cases (e.g. on the version command)
       */
      execute() {
        throw new ValidationError(this.name, "execute() needs to be implemented.");
      }
    };
  }
});

// libs/core/src/lib/conventional-commits/apply-build-metadata.ts
function applyBuildMetadata(version, buildMetadata) {
  if (!buildMetadata) {
    return version;
  }
  if (isValidBuildMetadata(buildMetadata)) {
    return `${version}+${buildMetadata}`;
  }
  throw new ValidationError("EBUILDMETADATA", "Build metadata does not satisfy SemVer specification.");
}
function isValidBuildMetadata(buildMetadata) {
  return BUILD_METADATA_REGEX.test(buildMetadata);
}
var BUILD_METADATA_REGEX;
var init_apply_build_metadata = __esm({
  "libs/core/src/lib/conventional-commits/apply-build-metadata.ts"() {
    "use strict";
    init_validation_error();
    BUILD_METADATA_REGEX = /^[0-9a-zA-Z-]+(\.[0-9a-zA-Z-]+)*$/;
  }
});

// libs/core/src/lib/conventional-commits/get-changelog-config.ts
function isFunction(config) {
  return Object.prototype.toString.call(config) === "[object Function]" || Object.prototype.toString.call(config) === "[object AsyncFunction]";
}
function resolveConfigPromise(presetPackageName, presetConfig) {
  import_npmlog13.default.verbose("getChangelogConfig", "Attempting to resolve preset %j", presetPackageName);
  let config = require(presetPackageName);
  import_npmlog13.default.info("getChangelogConfig", "Successfully resolved preset %j", presetPackageName);
  if (isFunction(config)) {
    try {
      config = config(presetConfig);
    } catch (_) {
      config = (0, import_pify.default)(config)();
    }
  }
  return config;
}
function getChangelogConfig(changelogPreset = "conventional-changelog-angular", rootPath) {
  const presetName = typeof changelogPreset === "string" ? changelogPreset : changelogPreset.name;
  const presetConfig = typeof changelogPreset === "object" ? changelogPreset : {};
  const cacheKey = `${presetName}${presetConfig ? JSON.stringify(presetConfig) : ""}`;
  let config = cfgCache.get(cacheKey);
  if (!config) {
    let presetPackageName = presetName;
    const parsed = (0, import_npm_package_arg3.default)(presetPackageName, rootPath);
    import_npmlog13.default.verbose("getChangelogConfig", "using preset %j", presetPackageName);
    import_npmlog13.default.silly("npa", parsed);
    if (parsed.type === "directory") {
      if (parsed.raw[0] === "@") {
        parsed.name = parsed.raw;
        parsed.scope = parsed.raw.substring(0, parsed.raw.indexOf("/"));
      } else {
        presetPackageName = parsed.fetchSpec;
      }
    } else if (parsed.type === "git" && parsed.hosted && parsed.hosted.default === "shortcut") {
      parsed.name = parsed.raw;
    }
    try {
      config = resolveConfigPromise(presetPackageName, presetConfig);
      cfgCache.set(cacheKey, config);
      return Promise.resolve(config);
    } catch (err) {
      import_npmlog13.default.verbose("getChangelogConfig", err.message);
      import_npmlog13.default.info("getChangelogConfig", "Auto-prefixing conventional-changelog preset %j", presetName);
      parsed.name = parsed.raw;
    }
    if (parsed.name.indexOf("conventional-changelog-") < 0) {
      const parts = parsed.name.split("/");
      const start = parsed.scope ? 1 : 0;
      parts.splice(start, 1, `conventional-changelog-${parts[start]}`);
      presetPackageName = parts.join("/");
    }
    try {
      config = resolveConfigPromise(presetPackageName, presetConfig);
      cfgCache.set(cacheKey, config);
    } catch (err) {
      import_npmlog13.default.warn("getChangelogConfig", err.message);
      throw new ValidationError(
        "EPRESET",
        `Unable to load conventional-changelog preset '${presetName}'${presetName !== presetPackageName ? ` (${presetPackageName})` : ""}`
      );
    }
  }
  return Promise.resolve(config);
}
var import_npm_package_arg3, import_npmlog13, import_pify, cfgCache;
var init_get_changelog_config = __esm({
  "libs/core/src/lib/conventional-commits/get-changelog-config.ts"() {
    "use strict";
    import_npm_package_arg3 = __toESM(require("npm-package-arg"));
    import_npmlog13 = __toESM(require("npmlog"));
    import_pify = __toESM(require("pify"));
    init_validation_error();
    cfgCache = /* @__PURE__ */ new Map();
  }
});

// libs/core/src/lib/conventional-commits/recommend-version.ts
function recommendVersion(pkg2, type, {
  changelogPreset,
  rootPath,
  tagPrefix,
  prereleaseId,
  conventionalBumpPrerelease,
  buildMetadata
}) {
  import_npmlog14.default.silly(type, "for %s at %s", pkg2.name, pkg2.location);
  const options = {
    path: pkg2.location
  };
  if (type === "independent") {
    options.lernaPackage = pkg2.name;
  } else {
    options.tagPrefix = tagPrefix;
  }
  const shouldBumpPrerelease = (releaseType, version) => {
    if (!import_semver3.default.prerelease(version)) {
      return true;
    }
    switch (releaseType) {
      case "major":
        return import_semver3.default.minor(version) !== 0 || import_semver3.default.patch(version) !== 0;
      case "minor":
        return import_semver3.default.patch(version) !== 0;
      default:
        return false;
    }
  };
  let chain = Promise.resolve();
  chain = chain.then(() => getChangelogConfig(changelogPreset, rootPath));
  chain = chain.then((config) => {
    options.config = config;
    return new Promise((resolve3, reject) => {
      (0, import_conventional_recommended_bump.default)(options, (err, data) => {
        if (err) {
          return reject(err);
        }
        let releaseType = data.releaseType || "patch";
        if (prereleaseId) {
          const shouldBump = conventionalBumpPrerelease || shouldBumpPrerelease(releaseType, pkg2.version);
          const prereleaseType = shouldBump ? `pre${releaseType}` : "prerelease";
          import_npmlog14.default.verbose(type, "increment %s by %s", pkg2.version, prereleaseType);
          resolve3(applyBuildMetadata(import_semver3.default.inc(pkg2.version, prereleaseType, prereleaseId), buildMetadata));
        } else {
          if (import_semver3.default.major(pkg2.version) === 0) {
            if (releaseType === "major") {
              releaseType = "minor";
            }
          }
          import_npmlog14.default.verbose(type, "increment %s by %s", pkg2.version, releaseType);
          resolve3(applyBuildMetadata(import_semver3.default.inc(pkg2.version, releaseType), buildMetadata));
        }
      });
    });
  });
  return chain;
}
var import_conventional_recommended_bump, import_npmlog14, import_semver3;
var init_recommend_version = __esm({
  "libs/core/src/lib/conventional-commits/recommend-version.ts"() {
    "use strict";
    import_conventional_recommended_bump = __toESM(require("conventional-recommended-bump"));
    import_npmlog14 = __toESM(require("npmlog"));
    import_semver3 = __toESM(require("semver"));
    init_apply_build_metadata();
    init_get_changelog_config();
  }
});

// libs/core/src/lib/conventional-commits/constants.ts
var EOL, BLANK_LINE, COMMIT_GUIDELINE, CHANGELOG_HEADER;
var init_constants = __esm({
  "libs/core/src/lib/conventional-commits/constants.ts"() {
    "use strict";
    EOL = "\n";
    BLANK_LINE = EOL + EOL;
    COMMIT_GUIDELINE = "See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.";
    CHANGELOG_HEADER = [
      "# Change Log",
      "",
      "All notable changes to this project will be documented in this file.",
      COMMIT_GUIDELINE
    ].join(EOL);
  }
});

// libs/core/src/lib/conventional-commits/make-bump-only-filter.ts
function makeBumpOnlyFilter(pkg2) {
  return (newEntry) => {
    if (!newEntry.split("\n").some((line) => line.startsWith("*"))) {
      const message = `**Note:** Version bump only for package ${pkg2.name}`;
      return [newEntry.trim(), message, BLANK_LINE].join(BLANK_LINE);
    }
    return newEntry;
  };
}
var init_make_bump_only_filter = __esm({
  "libs/core/src/lib/conventional-commits/make-bump-only-filter.ts"() {
    "use strict";
    init_constants();
  }
});

// libs/core/src/lib/conventional-commits/read-existing-changelog.ts
function readExistingChangelog(pkg2) {
  const changelogFileLoc = import_path9.default.join(pkg2.location, "CHANGELOG.md");
  let chain = Promise.resolve();
  chain = chain.then(() => import_fs_extra2.default.readFile(changelogFileLoc, "utf8").catch(() => ""));
  chain = chain.then((changelogContents) => {
    const headerIndex = changelogContents.indexOf(COMMIT_GUIDELINE);
    if (headerIndex !== -1) {
      return changelogContents.substring(headerIndex + COMMIT_GUIDELINE.length + BLANK_LINE.length);
    }
    return changelogContents;
  });
  chain = chain.then((changelogContents) => [changelogFileLoc, changelogContents]);
  return chain;
}
var import_fs_extra2, import_path9;
var init_read_existing_changelog = __esm({
  "libs/core/src/lib/conventional-commits/read-existing-changelog.ts"() {
    "use strict";
    import_fs_extra2 = __toESM(require("fs-extra"));
    import_path9 = __toESM(require("path"));
    init_constants();
  }
});

// libs/core/src/lib/conventional-commits/update-changelog.ts
function updateChangelog(pkg2, type, {
  changelogPreset,
  changelogEntryAdditionalMarkdown,
  rootPath,
  tagPrefix = "v",
  version
}) {
  import_npmlog15.default.silly(type, "for %s at %s", pkg2.name, pkg2.location);
  return getChangelogConfig(changelogPreset, rootPath).then((config) => {
    const options = {};
    const context = {};
    if (config.conventionalChangelog) {
      options.config = Object.assign({}, config.conventionalChangelog);
    } else {
      options.config = Object.assign({}, config);
    }
    const gitRawCommitsOpts = Object.assign({}, options.config.gitRawCommitsOpts);
    if (type === "root") {
      context.version = version;
      context.currentTag = `${tagPrefix}${version}`;
      options.tagPrefix = tagPrefix;
    } else {
      gitRawCommitsOpts.path = pkg2.location;
      options.pkg = { path: pkg2.manifestLocation };
      if (type === "independent") {
        options.lernaPackage = pkg2.name;
      } else {
        options.tagPrefix = tagPrefix;
        context.currentTag = `${tagPrefix}${pkg2.version}`;
      }
    }
    const changelogStream = (0, import_conventional_changelog_core.default)(options, context, gitRawCommitsOpts);
    return Promise.all([
      (0, import_get_stream.default)(changelogStream).then(makeBumpOnlyFilter(pkg2)),
      readExistingChangelog(pkg2)
    ]).then(([newEntry, [changelogFileLoc, changelogContents]]) => {
      if (changelogEntryAdditionalMarkdown) {
        const trailingWhitespace = newEntry.match(/\s*$/);
        newEntry = newEntry.replace(
          /\s*$/,
          BLANK_LINE + changelogEntryAdditionalMarkdown + trailingWhitespace
        );
      }
      import_npmlog15.default.silly(type, "writing new entry: %j", newEntry);
      const content = [CHANGELOG_HEADER, newEntry, changelogContents].join(BLANK_LINE);
      return import_fs_extra3.default.writeFile(changelogFileLoc, content.trim() + EOL).then(() => {
        import_npmlog15.default.verbose(type, "wrote", changelogFileLoc);
        return {
          logPath: changelogFileLoc,
          newEntry
        };
      });
    });
  });
}
var import_conventional_changelog_core, import_fs_extra3, import_get_stream, import_npmlog15;
var init_update_changelog = __esm({
  "libs/core/src/lib/conventional-commits/update-changelog.ts"() {
    "use strict";
    import_conventional_changelog_core = __toESM(require("conventional-changelog-core"));
    import_fs_extra3 = __toESM(require("fs-extra"));
    import_get_stream = __toESM(require("get-stream"));
    import_npmlog15 = __toESM(require("npmlog"));
    init_constants();
    init_get_changelog_config();
    init_make_bump_only_filter();
    init_read_existing_changelog();
  }
});

// libs/core/src/lib/conventional-commits/index.ts
var init_conventional_commits = __esm({
  "libs/core/src/lib/conventional-commits/index.ts"() {
    "use strict";
    init_recommend_version();
    init_update_changelog();
    init_apply_build_metadata();
  }
});

// libs/core/src/lib/filter-options.ts
function filterOptions(yargs2) {
  const opts = {
    scope: {
      describe: "Include only packages with names matching the given glob.",
      type: "string",
      requiresArg: true
    },
    ignore: {
      describe: "Exclude packages with names matching the given glob.",
      type: "string",
      requiresArg: true
    },
    "no-private": {
      describe: 'Exclude packages with { "private": true } in their package.json.',
      type: "boolean"
    },
    private: {
      // proxy for --no-private
      hidden: true,
      type: "boolean"
    },
    since: {
      describe: import_dedent4.default`
        Only include packages that have been changed since the specified [ref].
        If no ref is passed, it defaults to the most-recent tag.
      `,
      type: "string"
    },
    "exclude-dependents": {
      describe: import_dedent4.default`
        Exclude all transitive dependents when running a command
        with --since, overriding the default "changed" algorithm.
      `,
      conflicts: "include-dependents",
      type: "boolean"
    },
    "include-dependents": {
      describe: import_dedent4.default`
        Include all transitive dependents when running a command
        regardless of --scope, --ignore, or --since.
      `,
      conflicts: "exclude-dependents",
      type: "boolean"
    },
    "include-dependencies": {
      describe: import_dedent4.default`
        Include all transitive dependencies when running a command
        regardless of --scope, --ignore, or --since.
      `,
      type: "boolean"
    },
    "include-merged-tags": {
      describe: "Include tags from merged branches when running a command with --since.",
      type: "boolean"
    },
    "continue-if-no-match": {
      describe: "Don't fail if no package is matched",
      hidden: true,
      type: "boolean"
    }
  };
  return yargs2.options(opts).group(Object.keys(opts), "Filter Options:").option("include-filtered-dependents", {
    // TODO: remove in next major release
    hidden: true,
    conflicts: ["exclude-dependents", "include-dependents"],
    type: "boolean"
  }).option("include-filtered-dependencies", {
    // TODO: remove in next major release
    hidden: true,
    conflicts: "include-dependencies",
    type: "boolean"
  }).check((argv) => {
    if (argv["includeFilteredDependents"]) {
      argv["includeDependents"] = true;
      argv["include-dependents"] = true;
      delete argv["includeFilteredDependents"];
      delete argv["include-filtered-dependents"];
      import_npmlog16.default.warn("deprecated", "--include-filtered-dependents has been renamed --include-dependents");
    }
    if (argv["includeFilteredDependencies"]) {
      argv["includeDependencies"] = true;
      argv["include-dependencies"] = true;
      delete argv["includeFilteredDependencies"];
      delete argv["include-filtered-dependencies"];
      import_npmlog16.default.warn("deprecated", "--include-filtered-dependencies has been renamed --include-dependencies");
    }
    return argv;
  });
}
var import_dedent4, import_npmlog16;
var init_filter_options = __esm({
  "libs/core/src/lib/filter-options.ts"() {
    "use strict";
    import_dedent4 = __toESM(require("dedent"));
    import_npmlog16 = __toESM(require("npmlog"));
  }
});

// libs/core/src/lib/filter-projects.ts
function filterProjects(projectGraph, execOpts = {}, opts = {}) {
  const options = { log: import_npmlog17.default, ...opts };
  if (options.scope) {
    options.log.notice("filter", "including %j", options.scope);
  }
  if (options.ignore) {
    options.log.notice("filter", "excluding %j", options.ignore);
  }
  let projects = Object.values(projectGraph.nodes).filter((p) => !!p.package);
  const patterns = [].concat(arrify(options.scope), negate(arrify(options.ignore)));
  if (options.private === false) {
    projects = projects.filter((p) => !p.package?.private);
  }
  const patternsToLog = [...patterns];
  if (patterns.length) {
    if (!options.scope?.length) {
      patterns.unshift("**");
    }
    const packageNames = Array.from(projects).map((p) => p.package?.name).filter((p) => !!p);
    const chosen = new Set((0, import_multimatch.default)(packageNames, patterns));
    projects = projects.filter((p) => p.package?.name && chosen.has(p.package.name));
    if (!projects.length && !options.continueIfNoMatch) {
      throw new ValidationError("EFILTER", import_util.default.format("No packages remain after filtering", patterns));
    }
  }
  if (options.since !== void 0) {
    options.log.notice("filter", "changed since %j", options.since);
    if (options.excludeDependents) {
      options.log.notice("filter", "excluding dependents");
    }
    if (options.includeMergedTags) {
      options.log.notice("filter", "including merged tags");
    }
    const updates = collectProjectUpdates(projects, projectGraph, execOpts, opts);
    const updated = new Set(updates.map((node) => node.name));
    projects = projects.filter((project) => updated.has(project.name));
  }
  if (options.includeDependents) {
    options.log.notice("filter", "including dependents");
    projects = addDependents(projects, projectGraph);
  }
  if (options.includeDependencies) {
    options.log.notice("filter", "including dependencies");
    projects = addDependencies(projects, projectGraph);
  }
  if (patternsToLog.length) {
    import_npmlog17.default.info("filter", patternsToLog);
  }
  return projects;
}
function arrify(thing) {
  if (!thing) {
    return [];
  }
  if (!Array.isArray(thing)) {
    return [thing];
  }
  return thing;
}
function negate(patterns) {
  return patterns.map((pattern) => `!${pattern}`);
}
var import_multimatch, import_npmlog17, import_util;
var init_filter_projects = __esm({
  "libs/core/src/lib/filter-projects.ts"() {
    "use strict";
    import_multimatch = __toESM(require("multimatch"));
    import_npmlog17 = __toESM(require("npmlog"));
    import_util = __toESM(require("util"));
    init_add_dependencies();
    init_add_dependents();
    init_collect_project_updates();
    init_validation_error();
  }
});

// libs/core/src/lib/git-checkout.ts
function gitCheckout(stagedFiles, gitOpts, execOpts) {
  const files = gitOpts.granularPathspec ? stagedFiles : ".";
  import_npmlog18.default.silly("gitCheckout", files);
  return childProcess5.exec("git", ["checkout", "--"].concat(files), execOpts);
}
var import_npmlog18, childProcess5;
var init_git_checkout = __esm({
  "libs/core/src/lib/git-checkout.ts"() {
    "use strict";
    import_npmlog18 = __toESM(require("npmlog"));
    childProcess5 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/has-npm-version.ts
var import_semver4, childProcess6;
var init_has_npm_version = __esm({
  "libs/core/src/lib/has-npm-version.ts"() {
    "use strict";
    import_semver4 = __toESM(require("semver"));
    childProcess6 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/cycles/get-cycles.ts
function getCycles(dependencies) {
  const cycles = [];
  const visited = /* @__PURE__ */ new Set();
  function dfs(next, path22) {
    visited.add(next);
    path22.push(next);
    for (const dep of dependencies[next] || []) {
      if (path22.includes(dep)) {
        const cycle = path22.slice(path22.indexOf(dep));
        cycles.push(cycle);
      } else if (!visited.has(dep)) {
        dfs(dep, path22);
      }
    }
    path22.pop();
  }
  for (const next of Object.keys(dependencies)) {
    if (!visited.has(next)) {
      dfs(next, []);
    }
  }
  return cycles;
}
var init_get_cycles = __esm({
  "libs/core/src/lib/cycles/get-cycles.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/cycles/merge-overlapping-cycles.ts
function mergeOverlappingCycles(cycles) {
  const mergedCycles = [];
  cycles.forEach((cycle) => {
    let intersectionNodes = [];
    const mergedCycle = mergedCycles.find((mergedCycle2) => {
      intersectionNodes = (0, import_lodash4.intersection)(mergedCycle2, cycle);
      return intersectionNodes.length > 0;
    });
    if (mergedCycle) {
      mergedCycle.push(...(0, import_lodash4.difference)(cycle, intersectionNodes));
    } else {
      mergedCycles.push(cycle);
    }
  });
  return mergedCycles;
}
var import_lodash4;
var init_merge_overlapping_cycles = __esm({
  "libs/core/src/lib/cycles/merge-overlapping-cycles.ts"() {
    "use strict";
    import_lodash4 = require("lodash");
  }
});

// libs/core/src/lib/cycles/report-cycles.ts
function reportCycles(cycles, rejectCycles) {
  const cyclesWithRepeatedNodes = cycles.map((cycle) => [...cycle, cycle[0]]);
  const paths = Array.from(cyclesWithRepeatedNodes, (cycle) => cycle.join(" -> "), false);
  if (!paths.length) {
    return;
  }
  const cycleMessage = ["Dependency cycles detected, you should fix these!"].concat(paths).join("\n");
  if (rejectCycles) {
    throw new ValidationError("ECYCLE", cycleMessage);
  }
  import_npmlog19.default.warn("ECYCLE", cycleMessage);
}
var import_npmlog19;
var init_report_cycles = __esm({
  "libs/core/src/lib/cycles/report-cycles.ts"() {
    "use strict";
    import_npmlog19 = __toESM(require("npmlog"));
    init_validation_error();
  }
});

// libs/core/src/lib/cycles/index.ts
var init_cycles = __esm({
  "libs/core/src/lib/cycles/index.ts"() {
    "use strict";
    init_get_cycles();
    init_merge_overlapping_cycles();
    init_report_cycles();
  }
});

// libs/core/src/lib/toposort-projects.ts
function toposortProjects(projects, projectGraph, rejectCycles = false) {
  const projectsMap = new Map(projects.map((p) => [p.name, p]));
  const localDependencies = projectGraph.localPackageDependencies;
  const flattenedLocalDependencies = (0, import_lodash5.flatten)(Object.values(localDependencies));
  const getProject = (name) => {
    const project = projectsMap.get(name);
    if (!project) {
      throw new Error(`Failed to find project ${name}. This is likely a bug in Lerna's toposort algorithm.`);
    }
    return project;
  };
  const dependenciesBySource = projects.reduce(
    (prev, next) => ({
      ...prev,
      [next.name]: /* @__PURE__ */ new Set()
    }),
    {}
  );
  flattenedLocalDependencies.forEach((dep) => {
    if (dependenciesBySource[dep.source] && projectsMap.has(dep.target)) {
      dependenciesBySource[dep.source].add(dep.target);
    }
  });
  const unmergedCycles = getCycles(dependenciesBySource);
  reportCycles(unmergedCycles, rejectCycles);
  const cycles = new Set(mergeOverlappingCycles(unmergedCycles));
  const seen = /* @__PURE__ */ new Set();
  const queueNextPackages = () => {
    if (seen.size === projects.length) {
      return;
    }
    let batch = Object.keys(dependenciesBySource).filter((p) => dependenciesBySource[p].size === 0).filter((p) => !seen.has(p));
    if (batch.length === 0) {
      const cycle = Array.from(cycles.values()).find((cycle2) => {
        const cycleHasExternalDependencies = cycle2.some((project) => {
          const projectDeps = dependenciesBySource[project];
          const depIsNotInCycle = (dep) => cycle2.indexOf(dep) === -1;
          return !!projectDeps && Array.from(projectDeps).filter(depIsNotInCycle).length > 0;
        });
        return !cycleHasExternalDependencies;
      });
      if (cycle) {
        cycles.delete(cycle);
        batch = cycle.filter((p) => projectsMap.has(p));
      }
    }
    batch.forEach((p) => {
      seen.add(p);
      delete dependenciesBySource[p];
      Object.keys(dependenciesBySource).forEach((dep) => dependenciesBySource[dep].delete(p));
    });
    queueNextPackages();
  };
  queueNextPackages();
  return Array.from(seen).map((p) => getProject(p));
}
var import_lodash5;
var init_toposort_projects = __esm({
  "libs/core/src/lib/toposort-projects.ts"() {
    "use strict";
    import_lodash5 = require("lodash");
    init_cycles();
  }
});

// libs/core/src/lib/listable-format-projects.ts
function listableFormatProjects(projectsList, projectGraph, options) {
  const viewOptions = parseViewOptions(options);
  const resultList = filterResultList(projectsList, projectGraph, viewOptions);
  const count = resultList.length;
  let text;
  if (viewOptions.showJSON) {
    text = formatJSON(resultList);
  } else if (viewOptions.showNDJSON) {
    text = formatNDJSON(resultList);
  } else if (viewOptions.showParseable) {
    text = formatParseable(resultList, viewOptions);
  } else if (viewOptions.showGraph) {
    text = formatJSONGraph(resultList, viewOptions);
  } else {
    text = formatColumns(resultList, viewOptions);
  }
  return { text, count };
}
function parseViewOptions(options) {
  const alias = options._[0];
  return {
    showAll: alias === "la" || options.all,
    showLong: alias === "la" || alias === "ll" || options.long,
    showJSON: options.json,
    showNDJSON: options.ndjson,
    showParseable: options.parseable,
    isTopological: options.toposort,
    showGraph: options.graph
  };
}
function filterResultList(projectList, projectGraph, viewOptions) {
  let result = viewOptions.showAll ? projectList : projectList.filter((project) => !getPackage(project).private);
  if (viewOptions.isTopological) {
    result = toposortProjects(result, projectGraph);
  }
  return result;
}
function toJSONList(resultList, addtionalProperties = () => ({})) {
  return resultList.map((project) => {
    const pkg2 = getPackage(project);
    return {
      name: pkg2.name,
      version: pkg2.version,
      private: pkg2.private,
      location: pkg2.location,
      ...addtionalProperties(project)
    };
  });
}
function formatJSON(resultList, additionalProperties = () => ({})) {
  return JSON.stringify(toJSONList(resultList, additionalProperties), null, 2);
}
function formatNDJSON(resultList) {
  return toJSONList(resultList).map((data) => JSON.stringify(data)).join("\n");
}
function formatJSONGraph(resultList, viewOptions) {
  const graph = {};
  const getNeighbors = viewOptions.showAll ? (pkg2) => Object.keys(
    Object.assign(
      {},
      pkg2.devDependencies,
      pkg2.peerDependencies,
      pkg2.optionalDependencies,
      pkg2.dependencies
    )
  ).sort() : (pkg2) => Object.keys(
    Object.assign(
      {},
      // no devDependencies
      // no peerDependencies
      pkg2.optionalDependencies,
      pkg2.dependencies
    )
  ).sort();
  for (const project of resultList) {
    const pkg2 = getPackage(project);
    graph[pkg2.name] = getNeighbors(pkg2);
  }
  return JSON.stringify(graph, null, 2);
}
function makeParseable(pkg2) {
  const result = [pkg2.location, pkg2.name];
  if (pkg2.version) {
    result.push(pkg2.version);
  } else {
    result.push("MISSING");
  }
  if (pkg2.private) {
    result.push("PRIVATE");
  }
  return result.join(":");
}
function formatParseable(resultList, viewOptions) {
  return resultList.map((project) => {
    const pkg2 = getPackage(project);
    return viewOptions.showLong ? makeParseable(pkg2) : pkg2.location;
  }).join("\n");
}
function getColumnOrder(viewOptions) {
  const columns = ["name"];
  if (viewOptions.showLong) {
    columns.push("version", "location");
  }
  if (viewOptions.showAll) {
    columns.push("private");
  }
  return columns;
}
function trimmedColumns(formattedResults, viewOptions) {
  const str = (0, import_columnify.default)(formattedResults, {
    showHeaders: false,
    columns: getColumnOrder(viewOptions),
    config: {
      version: {
        align: "right"
      }
    }
  });
  return str.split("\n").map((line) => line.trimRight()).join("\n");
}
function formatColumns(resultList, viewOptions) {
  const formattedResults = resultList.map((project) => {
    const pkg2 = getPackage(project);
    const formatted = {
      name: pkg2.name
    };
    if (pkg2.version) {
      formatted.version = import_chalk2.default.green(`v${pkg2.version}`);
    } else {
      formatted.version = import_chalk2.default.yellow("MISSING");
    }
    if (pkg2.private) {
      formatted.private = `(${import_chalk2.default.red("PRIVATE")})`;
    }
    formatted.location = import_chalk2.default.grey(import_path10.default.relative(".", pkg2.location));
    return formatted;
  });
  return trimmedColumns(formattedResults, viewOptions);
}
var import_chalk2, import_columnify, import_path10;
var init_listable_format_projects = __esm({
  "libs/core/src/lib/listable-format-projects.ts"() {
    "use strict";
    import_chalk2 = __toESM(require("chalk"));
    import_columnify = __toESM(require("columnify"));
    import_path10 = __toESM(require("path"));
    init_project_graph_with_packages();
    init_toposort_projects();
  }
});

// libs/core/src/lib/listable-options.ts
function listableOptions(yargs2, group = "Command Options:") {
  return yargs2.options({
    json: {
      group,
      describe: "Show information as a JSON array",
      type: "boolean"
    },
    ndjson: {
      group,
      describe: "Show information as newline-delimited JSON",
      type: "boolean"
    },
    a: {
      group,
      describe: "Show private packages that are normally hidden",
      type: "boolean",
      alias: "all"
    },
    l: {
      group,
      describe: "Show extended information",
      type: "boolean",
      alias: "long"
    },
    p: {
      group,
      describe: "Show parseable output instead of columnified view",
      type: "boolean",
      alias: "parseable"
    },
    toposort: {
      group,
      describe: "Sort packages in topological order instead of lexical by directory",
      type: "boolean"
    },
    graph: {
      group,
      describe: "Show dependency graph as a JSON-formatted adjacency list",
      type: "boolean"
    }
  });
}
var init_listable_options = __esm({
  "libs/core/src/lib/listable-options.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/log-packed.ts
function logPacked(tarball) {
  import_npmlog20.default.notice("");
  import_npmlog20.default.notice("", `${hasUnicode ? "\u{1F4E6} " : "package:"} ${tarball.name}@${tarball.version}`);
  if (tarball.files && tarball.files.length) {
    import_npmlog20.default.notice("=== Tarball Contents ===");
    import_npmlog20.default.notice(
      "",
      (0, import_columnify2.default)(
        tarball.files.map((f) => {
          const bytes = (0, import_byte_size.default)(f.size);
          return {
            path: f.path,
            size: `${bytes.value}${bytes.unit}`
          };
        }),
        {
          // TODO: refactor based on TS feedback
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          include: ["size", "path"],
          showHeaders: false
        }
      )
    );
  }
  if (tarball.bundled && tarball.bundled.length) {
    import_npmlog20.default.notice("=== Bundled Dependencies ===");
    tarball.bundled.forEach((name) => import_npmlog20.default.notice("", name));
  }
  import_npmlog20.default.notice("=== Tarball Details ===");
  import_npmlog20.default.notice(
    "",
    (0, import_columnify2.default)(
      [
        { name: "name:", value: tarball.name },
        { name: "version:", value: tarball.version },
        tarball.filename && { name: "filename:", value: tarball.filename },
        tarball.size && { name: "package size:", value: (0, import_byte_size.default)(tarball.size) },
        tarball.unpackedSize && { name: "unpacked size:", value: (0, import_byte_size.default)(tarball.unpackedSize) },
        tarball.shasum && { name: "shasum:", value: tarball.shasum },
        tarball.integrity && { name: "integrity:", value: elideIntegrity(tarball.integrity) },
        tarball.bundled && tarball.bundled.length && {
          name: "bundled deps:",
          value: tarball.bundled.length
        },
        tarball.bundled && tarball.bundled.length && {
          name: "bundled files:",
          value: tarball.entryCount - tarball.files.length
        },
        tarball.bundled && tarball.bundled.length && {
          name: "own files:",
          value: tarball.files.length
        },
        tarball.entryCount && { name: "total files:", value: tarball.entryCount }
      ].filter((x) => x),
      {
        // TODO: refactor based on TS feedback
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        include: ["name", "value"],
        showHeaders: false
      }
    )
  );
  import_npmlog20.default.notice("", "");
}
function elideIntegrity(integrity) {
  const str = integrity.toString();
  return `${str.substr(0, 20)}[...]${str.substr(80)}`;
}
var import_byte_size, import_columnify2, import_npmlog20, import_has_unicode, hasUnicode;
var init_log_packed = __esm({
  "libs/core/src/lib/log-packed.ts"() {
    "use strict";
    import_byte_size = __toESM(require("byte-size"));
    import_columnify2 = __toESM(require("columnify"));
    import_npmlog20 = __toESM(require("npmlog"));
    import_has_unicode = __toESM(require("has-unicode"));
    hasUnicode = (0, import_has_unicode.default)();
  }
});

// libs/core/src/lib/npm-conf/env-replace.ts
function envReplace(str) {
  if (typeof str !== "string" || !str) {
    return str;
  }
  const regex = /(\\*)\$\{([^}]+)\}/g;
  return str.replace(regex, (orig, esc, name) => {
    esc = esc.length > 0 && esc.length % 2;
    if (esc) {
      return orig;
    }
    if (process.env[name] === void 0) {
      throw new Error(`Failed to replace env in config: ${orig}`);
    }
    return process.env[name];
  });
}
var init_env_replace = __esm({
  "libs/core/src/lib/npm-conf/env-replace.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/npm-conf/find-prefix.ts
function findPrefix(start) {
  let dir = import_path11.default.resolve(start);
  let walkedUp = false;
  while (import_path11.default.basename(dir) === "node_modules") {
    dir = import_path11.default.dirname(dir);
    walkedUp = true;
  }
  if (walkedUp) {
    return dir;
  }
  return find(dir, dir);
}
function find(name, original) {
  if (name === "/" || process.platform === "win32" && /^[a-zA-Z]:(\\|\/)?$/.test(name)) {
    return original;
  }
  try {
    const files = import_fs3.default.readdirSync(name);
    if (files.indexOf("node_modules") !== -1 || files.indexOf("package.json") !== -1) {
      return name;
    }
    const dirname = import_path11.default.dirname(name);
    if (dirname === name) {
      return original;
    }
    return find(dirname, original);
  } catch (err) {
    if (name === original) {
      if (err.code === "ENOENT") {
        return original;
      }
      throw err;
    }
    return original;
  }
}
var import_fs3, import_path11;
var init_find_prefix = __esm({
  "libs/core/src/lib/npm-conf/find-prefix.ts"() {
    "use strict";
    import_fs3 = __toESM(require("fs"));
    import_path11 = __toESM(require("path"));
  }
});

// libs/core/src/lib/npm-conf/types.ts
var require_types = __commonJS({
  "libs/core/src/lib/npm-conf/types.ts"(exports2) {
    "use strict";
    var import_path25 = __toESM(require("path"));
    var import_stream = require("stream");
    var import_url2 = __toESM(require("url"));
    var Umask = () => {
    };
    var getLocalAddresses = () => [];
    var semver8 = () => {
    };
    exports2.types = {
      access: [null, "restricted", "public"],
      "allow-same-version": Boolean,
      "always-auth": Boolean,
      also: [null, "dev", "development"],
      audit: Boolean,
      "audit-level": ["low", "moderate", "high", "critical"],
      "auth-type": ["legacy", "sso", "saml", "oauth"],
      "bin-links": Boolean,
      browser: [null, String],
      ca: [null, String, Array],
      cafile: import_path25.default,
      cache: import_path25.default,
      "cache-lock-stale": Number,
      "cache-lock-retries": Number,
      "cache-lock-wait": Number,
      "cache-max": Number,
      "cache-min": Number,
      cert: [null, String],
      cidr: [null, String, Array],
      color: ["always", Boolean],
      depth: Number,
      description: Boolean,
      dev: Boolean,
      "dry-run": Boolean,
      editor: String,
      "engine-strict": Boolean,
      force: Boolean,
      "fetch-retries": Number,
      "fetch-retry-factor": Number,
      "fetch-retry-mintimeout": Number,
      "fetch-retry-maxtimeout": Number,
      git: String,
      "git-tag-version": Boolean,
      "commit-hooks": Boolean,
      global: Boolean,
      globalconfig: import_path25.default,
      "global-style": Boolean,
      group: [Number, String],
      "https-proxy": [null, import_url2.default],
      "user-agent": String,
      "ham-it-up": Boolean,
      heading: String,
      "if-present": Boolean,
      "ignore-prepublish": Boolean,
      "ignore-scripts": Boolean,
      "init-module": import_path25.default,
      "init-author-name": String,
      "init-author-email": String,
      "init-author-url": ["", import_url2.default],
      "init-license": String,
      "init-version": semver8,
      json: Boolean,
      key: [null, String],
      "legacy-bundling": Boolean,
      link: Boolean,
      "local-address": getLocalAddresses(),
      loglevel: ["silent", "error", "warn", "notice", "http", "timing", "info", "verbose", "silly"],
      logstream: import_stream.Stream,
      "logs-max": Number,
      long: Boolean,
      maxsockets: Number,
      message: String,
      "metrics-registry": [null, String],
      "node-options": [null, String],
      "node-version": [null, semver8],
      noproxy: [null, String, Array],
      offline: Boolean,
      "onload-script": [null, String],
      only: [null, "dev", "development", "prod", "production"],
      optional: Boolean,
      "package-lock": Boolean,
      otp: [null, String],
      "package-lock-only": Boolean,
      parseable: Boolean,
      "prefer-offline": Boolean,
      "prefer-online": Boolean,
      prefix: import_path25.default,
      preid: String,
      production: Boolean,
      progress: Boolean,
      // allow proxy to be disabled explicitly
      proxy: [null, false, import_url2.default],
      "read-only": Boolean,
      "rebuild-bundle": Boolean,
      registry: [null, import_url2.default],
      rollback: Boolean,
      save: Boolean,
      "save-bundle": Boolean,
      "save-dev": Boolean,
      "save-exact": Boolean,
      "save-optional": Boolean,
      "save-prefix": String,
      "save-prod": Boolean,
      scope: String,
      "script-shell": [null, String],
      "scripts-prepend-node-path": [false, true, "auto", "warn-only"],
      searchopts: String,
      searchexclude: [null, String],
      searchlimit: Number,
      searchstaleness: Number,
      "send-metrics": Boolean,
      shell: String,
      shrinkwrap: Boolean,
      "sign-git-commit": Boolean,
      "sign-git-tag": Boolean,
      "sso-poll-frequency": Number,
      "sso-type": [null, "oauth", "saml"],
      "strict-ssl": Boolean,
      tag: String,
      timing: Boolean,
      tmp: import_path25.default,
      unicode: Boolean,
      "unsafe-perm": Boolean,
      "update-notifier": Boolean,
      usage: Boolean,
      user: [Number, String],
      userconfig: import_path25.default,
      umask: Umask,
      version: Boolean,
      "tag-version-prefix": String,
      versions: Boolean,
      viewer: String,
      _exit: Boolean
    };
  }
});

// libs/core/src/lib/npm-conf/parse-field.ts
function parseField(input, key) {
  if (typeof input !== "string") {
    return input;
  }
  const typeList = [].concat(types[key]);
  const isPath = typeList.indexOf(import_path12.default) !== -1;
  const isBool = typeList.indexOf(Boolean) !== -1;
  const isString = typeList.indexOf(String) !== -1;
  const isNumber = typeList.indexOf(Number) !== -1;
  let field = `${input}`.trim();
  if (/^".*"$/.test(field)) {
    try {
      field = JSON.parse(field);
    } catch (err) {
      throw new Error(`Failed parsing JSON config key ${key}: ${field}`);
    }
  }
  if (isBool && !isString && field === "") {
    return true;
  }
  switch (field) {
    case "true": {
      return true;
    }
    case "false": {
      return false;
    }
    case "null": {
      return null;
    }
    case "undefined": {
      return void 0;
    }
  }
  field = envReplace(field);
  if (isPath) {
    const regex = process.platform === "win32" ? /^~(\/|\\)/ : /^~\//;
    if (regex.test(field) && process.env["HOME"]) {
      field = import_path12.default.resolve(process.env["HOME"], field.substr(2));
    }
    field = import_path12.default.resolve(field);
  }
  if (isNumber && !Number.isNaN(field)) {
    field = Number(field);
  }
  return field;
}
var import_path12, types;
var init_parse_field = __esm({
  "libs/core/src/lib/npm-conf/parse-field.ts"() {
    "use strict";
    import_path12 = __toESM(require("path"));
    init_env_replace();
    ({ types } = require_types());
  }
});

// libs/core/src/lib/npm-conf/nerf-dart.ts
function toNerfDart(uri) {
  const parsed = import_url.default.parse(uri);
  delete parsed.protocol;
  delete parsed.auth;
  delete parsed.query;
  delete parsed.search;
  delete parsed.hash;
  return import_url.default.resolve(import_url.default.format(parsed), ".");
}
var import_url;
var init_nerf_dart = __esm({
  "libs/core/src/lib/npm-conf/nerf-dart.ts"() {
    "use strict";
    import_url = __toESM(require("url"));
  }
});

// libs/core/src/lib/npm-conf/config-chain/proto-list.ts
var require_proto_list = __commonJS({
  "libs/core/src/lib/npm-conf/config-chain/proto-list.ts"(exports2, module2) {
    "use strict";
    module2.exports = ProtoList;
    function setProto(obj, proto) {
      if (typeof Object.setPrototypeOf === "function")
        return Object.setPrototypeOf(obj, proto);
      else
        obj.__proto__ = proto;
    }
    function ProtoList() {
      this.list = [];
      var root = null;
      Object.defineProperty(this, "root", {
        get: function() {
          return root;
        },
        set: function(r) {
          root = r;
          if (this.list.length) {
            setProto(this.list[this.list.length - 1], r);
          }
        },
        enumerable: true,
        configurable: true
      });
    }
    ProtoList.prototype = {
      get length() {
        return this.list.length;
      },
      get keys() {
        var k = [];
        for (var i in this.list[0])
          k.push(i);
        return k;
      },
      get snapshot() {
        var o2 = {};
        this.keys.forEach(function(k) {
          o2[k] = this.get(k);
        }, this);
        return o2;
      },
      get store() {
        return this.list[0];
      },
      push: function(obj) {
        if (typeof obj !== "object")
          obj = { valueOf: obj };
        if (this.list.length >= 1) {
          setProto(this.list[this.list.length - 1], obj);
        }
        setProto(obj, this.root);
        return this.list.push(obj);
      },
      pop: function() {
        if (this.list.length >= 2) {
          setProto(this.list[this.list.length - 2], this.root);
        }
        return this.list.pop();
      },
      unshift: function(obj) {
        setProto(obj, this.list[0] || this.root);
        return this.list.unshift(obj);
      },
      shift: function() {
        if (this.list.length === 1) {
          setProto(this.list[0], this.root);
        }
        return this.list.shift();
      },
      get: function(key) {
        return this.list[0][key];
      },
      set: function(key, val, save) {
        if (!this.length)
          this.push({});
        if (save && this.list[0].hasOwnProperty(key))
          this.push({});
        return this.list[0][key] = val;
      },
      forEach: function(fn, thisp) {
        for (var key in this.list[0])
          fn.call(thisp, key, this.list[0][key]);
      },
      slice: function() {
        return this.list.slice.apply(this.list, arguments);
      },
      splice: function() {
        var ret = this.list.splice.apply(this.list, arguments);
        for (var i = 0, l = this.list.length; i < l; i++) {
          setProto(this.list[i], this.list[i + 1] || this.root);
        }
        return ret;
      }
    };
  }
});

// libs/core/src/lib/npm-conf/config-chain/index.ts
var require_config_chain = __commonJS({
  "libs/core/src/lib/npm-conf/config-chain/index.ts"(exports2, module2) {
    "use strict";
    var ProtoList = require_proto_list();
    var path22 = require("path");
    var fs19 = require("fs");
    var ini = require("ini");
    var EE = require("events").EventEmitter;
    var url2 = require("url");
    var http = require("http");
    var exports2 = module2.exports = function() {
      var args = [].slice.call(arguments), conf = new ConfigChain2();
      while (args.length) {
        var a = args.shift();
        if (a)
          conf.push("string" === typeof a ? json(a) : a);
      }
      return conf;
    };
    var find2 = exports2.find = function() {
      var rel = path22.join.apply(null, [].slice.call(arguments));
      function find3(start, rel2) {
        var file = path22.join(start, rel2);
        try {
          fs19.statSync(file);
          return file;
        } catch (err) {
          if (path22.dirname(start) !== start)
            return find3(path22.dirname(start), rel2);
        }
      }
      return find3(__dirname, rel);
    };
    var parse2 = exports2.parse = function(content, file, type) {
      content = "" + content;
      if (!type) {
        try {
          return JSON.parse(content);
        } catch (er) {
          return ini.parse(content);
        }
      } else if (type === "json") {
        if (this.emit) {
          try {
            return JSON.parse(content);
          } catch (er) {
            this.emit("error", er);
          }
        } else {
          return JSON.parse(content);
        }
      } else {
        return ini.parse(content);
      }
    };
    var json = exports2.json = function() {
      var args = [].slice.call(arguments).filter(function(arg) {
        return arg != null;
      });
      var file = path22.join.apply(null, args);
      var content;
      try {
        content = fs19.readFileSync(file, "utf-8");
      } catch (err) {
        return;
      }
      return parse2(content, file, "json");
    };
    var env = exports2.env = function(prefix, env2) {
      env2 = env2 || process.env;
      var obj = {};
      var l = prefix.length;
      for (var k in env2) {
        if (k.indexOf(prefix) === 0)
          obj[k.substring(l)] = env2[k];
      }
      return obj;
    };
    exports2.ConfigChain = ConfigChain2;
    function ConfigChain2() {
      EE.apply(this);
      ProtoList.apply(this, arguments);
      this._awaiting = 0;
      this._saving = 0;
      this.sources = {};
    }
    var extras = {
      constructor: { value: ConfigChain2 }
    };
    Object.keys(EE.prototype).forEach(function(k) {
      extras[k] = Object.getOwnPropertyDescriptor(EE.prototype, k);
    });
    ConfigChain2.prototype = Object.create(ProtoList.prototype, extras);
    ConfigChain2.prototype.del = function(key, where) {
      if (where) {
        var target = this.sources[where];
        target = target && target.data;
        if (!target) {
          return this.emit("error", new Error("not found " + where));
        }
        delete target[key];
      } else {
        for (var i = 0, l = this.list.length; i < l; i++) {
          delete this.list[i][key];
        }
      }
      return this;
    };
    ConfigChain2.prototype.set = function(key, value, where) {
      var target;
      if (where) {
        target = this.sources[where];
        target = target && target.data;
        if (!target) {
          return this.emit("error", new Error("not found " + where));
        }
      } else {
        target = this.list[0];
        if (!target) {
          return this.emit("error", new Error("cannot set, no confs!"));
        }
      }
      target[key] = value;
      return this;
    };
    ConfigChain2.prototype.get = function(key, where) {
      if (where) {
        where = this.sources[where];
        if (where)
          where = where.data;
        if (where && Object.hasOwnProperty.call(where, key))
          return where[key];
        return void 0;
      }
      return this.list[0][key];
    };
    ConfigChain2.prototype.save = function(where, type, cb) {
      if (typeof type === "function")
        cb = type, type = null;
      var target = this.sources[where];
      if (!target || !(target.path || target.source) || !target.data) {
        return this.emit("error", new Error("bad save target: " + where));
      }
      if (target.source) {
        var pref = target.prefix || "";
        Object.keys(target.data).forEach(function(k) {
          target.source[pref + k] = target.data[k];
        });
        return this;
      }
      var type = type || target.type;
      var data = target.data;
      if (target.type === "json") {
        data = JSON.stringify(data);
      } else {
        data = ini.stringify(data);
      }
      this._saving++;
      fs19.writeFile(
        target.path,
        data,
        "utf8",
        function(er) {
          this._saving--;
          if (er) {
            if (cb)
              return cb(er);
            else
              return this.emit("error", er);
          }
          if (this._saving === 0) {
            if (cb)
              cb();
            this.emit("save");
          }
        }.bind(this)
      );
      return this;
    };
    ConfigChain2.prototype.addFile = function(file, type, name) {
      name = name || file;
      var marker = { __source__: name };
      this.sources[name] = { path: file, type };
      this.push(marker);
      this._await();
      fs19.readFile(
        file,
        "utf8",
        function(er, data) {
          if (er)
            this.emit("error", er);
          this.addString(data, file, type, marker);
        }.bind(this)
      );
      return this;
    };
    ConfigChain2.prototype.addEnv = function(prefix, env2, name) {
      name = name || "env";
      var data = exports2.env(prefix, env2);
      this.sources[name] = { data, source: env2, prefix };
      return this.add(data, name);
    };
    ConfigChain2.prototype.addUrl = function(req, type, name) {
      this._await();
      var href = url2.format(req);
      name = name || href;
      var marker = { __source__: name };
      this.sources[name] = { href, type };
      this.push(marker);
      http.request(
        req,
        function(res) {
          var c = [];
          var ct = res.headers["content-type"];
          if (!type) {
            type = ct.indexOf("json") !== -1 ? "json" : ct.indexOf("ini") !== -1 ? "ini" : href.match(/\.json$/) ? "json" : href.match(/\.ini$/) ? "ini" : null;
            marker.type = type;
          }
          res.on("data", c.push.bind(c)).on(
            "end",
            function() {
              this.addString(Buffer.concat(c), href, type, marker);
            }.bind(this)
          ).on("error", this.emit.bind(this, "error"));
        }.bind(this)
      ).on("error", this.emit.bind(this, "error")).end();
      return this;
    };
    ConfigChain2.prototype.addString = function(data, file, type, marker) {
      data = this.parse(data, file, type);
      this.add(data, marker);
      return this;
    };
    ConfigChain2.prototype.add = function(data, marker) {
      if (marker && typeof marker === "object") {
        var i = this.list.indexOf(marker);
        if (i === -1) {
          return this.emit("error", new Error("bad marker"));
        }
        this.splice(i, 1, data);
        marker = marker.__source__;
        this.sources[marker] = this.sources[marker] || {};
        this.sources[marker].data = data;
        this._resolve();
      } else {
        if (typeof marker === "string") {
          this.sources[marker] = this.sources[marker] || {};
          this.sources[marker].data = data;
        }
        this._await();
        this.push(data);
        process.nextTick(this._resolve.bind(this));
      }
      return this;
    };
    ConfigChain2.prototype.parse = exports2.parse;
    ConfigChain2.prototype._await = function() {
      this._awaiting++;
    };
    ConfigChain2.prototype._resolve = function() {
      this._awaiting--;
      if (this._awaiting === 0)
        this.emit("load", this);
    };
  }
});

// libs/core/src/lib/npm-conf/conf.ts
var import_assert, import_fs4, import_path13, ConfigChain, Conf;
var init_conf = __esm({
  "libs/core/src/lib/npm-conf/conf.ts"() {
    "use strict";
    import_assert = __toESM(require("assert"));
    import_fs4 = __toESM(require("fs"));
    import_path13 = __toESM(require("path"));
    init_env_replace();
    init_find_prefix();
    init_parse_field();
    init_nerf_dart();
    ({ ConfigChain } = require_config_chain());
    Conf = class extends ConfigChain {
      root;
      // https://github.com/npm/npm/blob/latest/lib/config/core.js#L208-L222
      constructor(base) {
        super(base);
        this.root = base;
      }
      // https://github.com/npm/npm/blob/latest/lib/config/core.js#L332-L342
      add(data, marker) {
        try {
          for (const x of Object.keys(data)) {
            const newKey = envReplace(x);
            const newField = parseField(data[x], newKey);
            delete data[x];
            data[newKey] = newField;
          }
        } catch (err) {
          throw err;
        }
        return super.add(data, marker);
      }
      // https://github.com/npm/npm/blob/latest/lib/config/core.js#L312-L325
      addFile(file, name = file) {
        const marker = { __source__: name };
        this["sources"][name] = { path: file, type: "ini" };
        this["push"](marker);
        this["_await"]();
        try {
          const contents = import_fs4.default.readFileSync(file, "utf8");
          this["addString"](contents, file, "ini", marker);
        } catch (err) {
          this["add"]({}, marker);
        }
        return this;
      }
      // https://github.com/npm/npm/blob/latest/lib/config/core.js#L344-L360
      addEnv(env = process.env) {
        const conf = {};
        Object.keys(env).filter((x) => /^npm_config_/i.test(x)).forEach((x) => {
          if (!env[x]) {
            return;
          }
          const p = x.toLowerCase().replace(/^npm_config_/, "").replace(/(?!^)_/g, "-");
          conf[p] = env[x];
        });
        return super.addEnv("", conf, "env");
      }
      // https://github.com/npm/npm/blob/latest/lib/config/load-prefix.js
      loadPrefix() {
        const cli = this["list"][0];
        Object.defineProperty(this, "prefix", {
          enumerable: true,
          set: (prefix) => {
            const g = this["get"]("global");
            this[g ? "globalPrefix" : "localPrefix"] = prefix;
          },
          get: () => {
            const g = this["get"]("global");
            return g ? this["globalPrefix"] : this["localPrefix"];
          }
        });
        Object.defineProperty(this, "globalPrefix", {
          enumerable: true,
          set: (prefix) => {
            this["set"]("prefix", prefix);
          },
          get: () => import_path13.default.resolve(this["get"]("prefix"))
        });
        let p;
        Object.defineProperty(this, "localPrefix", {
          enumerable: true,
          set: (prefix) => {
            p = prefix;
          },
          get: () => p
        });
        if (Object.prototype.hasOwnProperty.call(cli, "prefix")) {
          p = import_path13.default.resolve(cli.prefix);
        } else {
          try {
            p = findPrefix(process.cwd());
          } catch (err) {
            throw err;
          }
        }
        return p;
      }
      // https://github.com/npm/npm/blob/latest/lib/config/load-cafile.js
      loadCAFile(file) {
        if (!file) {
          return;
        }
        try {
          const contents = import_fs4.default.readFileSync(file, "utf8");
          const delim = "-----END CERTIFICATE-----";
          const output2 = contents.split(delim).filter((x) => Boolean(x.trim())).map((x) => x.trimLeft() + delim);
          this["set"]("ca", output2);
        } catch (err) {
          if (err.code === "ENOENT") {
            return;
          }
          throw err;
        }
      }
      // https://github.com/npm/npm/blob/latest/lib/config/set-user.js
      loadUser() {
        const defConf = this.root;
        if (this["get"]("global")) {
          return;
        }
        if (process.env["SUDO_UID"]) {
          defConf.user = Number(process.env["SUDO_UID"]);
          return;
        }
        const prefix = import_path13.default.resolve(this["get"]("prefix"));
        try {
          const stats = import_fs4.default.statSync(prefix);
          defConf.user = stats.uid;
        } catch (err) {
          if (err.code === "ENOENT") {
            return;
          }
          throw err;
        }
      }
      // https://github.com/npm/npm/blob/24ec9f2/lib/config/get-credentials-by-uri.js
      getCredentialsByURI(uri) {
        (0, import_assert.default)(uri && typeof uri === "string", "registry URL is required");
        const nerfed = toNerfDart(uri);
        const defnerf = toNerfDart(this["get"]("registry"));
        const c = {
          scope: nerfed,
          token: void 0,
          password: void 0,
          username: void 0,
          email: void 0,
          auth: void 0,
          alwaysAuth: void 0
        };
        if (this["get"](`${nerfed}:always-auth`) !== void 0) {
          const val = this["get"](`${nerfed}:always-auth`);
          c.alwaysAuth = val === "false" ? false : !!val;
        } else if (this["get"]("always-auth") !== void 0) {
          c.alwaysAuth = this["get"]("always-auth");
        }
        if (this["get"](`${nerfed}:_authToken`)) {
          c.token = this["get"](`${nerfed}:_authToken`);
          return c;
        }
        let authDef = this["get"]("_auth");
        let userDef = this["get"]("username");
        let passDef = this["get"]("_password");
        if (authDef && !(userDef && passDef)) {
          authDef = Buffer.from(authDef, "base64").toString();
          authDef = authDef.split(":");
          userDef = authDef.shift();
          passDef = authDef.join(":");
        }
        if (this["get"](`${nerfed}:_password`)) {
          c.password = Buffer.from(this["get"](`${nerfed}:_password`), "base64").toString("utf8");
        } else if (nerfed === defnerf && passDef) {
          c.password = passDef;
        }
        if (this["get"](`${nerfed}:username`)) {
          c.username = this["get"](`${nerfed}:username`);
        } else if (nerfed === defnerf && userDef) {
          c.username = userDef;
        }
        if (this["get"](`${nerfed}:email`)) {
          c.email = this["get"](`${nerfed}:email`);
        } else if (this["get"]("email")) {
          c.email = this["get"]("email");
        }
        if (c.username && c.password) {
          c.auth = Buffer.from(`${c.username}:${c.password}`).toString("base64");
        }
        return c;
      }
      // https://github.com/npm/npm/blob/24ec9f2/lib/config/set-credentials-by-uri.js
      setCredentialsByURI(uri, c) {
        (0, import_assert.default)(uri && typeof uri === "string", "registry URL is required");
        (0, import_assert.default)(c && typeof c === "object", "credentials are required");
        const nerfed = toNerfDart(uri);
        if (c.token) {
          this["set"](`${nerfed}:_authToken`, c.token, "user");
          this["del"](`${nerfed}:_password`, "user");
          this["del"](`${nerfed}:username`, "user");
          this["del"](`${nerfed}:email`, "user");
          this["del"](`${nerfed}:always-auth`, "user");
        } else if (c.username || c.password || c.email) {
          (0, import_assert.default)(c.username, "must include username");
          (0, import_assert.default)(c.password, "must include password");
          (0, import_assert.default)(c.email, "must include email address");
          this["del"](`${nerfed}:_authToken`, "user");
          const encoded = Buffer.from(c.password, "utf8").toString("base64");
          this["set"](`${nerfed}:_password`, encoded, "user");
          this["set"](`${nerfed}:username`, c.username, "user");
          this["set"](`${nerfed}:email`, c.email, "user");
          if (c.alwaysAuth !== void 0) {
            this["set"](`${nerfed}:always-auth`, c.alwaysAuth, "user");
          } else {
            this["del"](`${nerfed}:always-auth`, "user");
          }
        } else {
          throw new Error("No credentials to set.");
        }
      }
    };
  }
});

// libs/core/src/lib/get-npm-exec-opts.ts
function getNpmExecOpts(pkg2, registry) {
  const env = {
    LERNA_PACKAGE_NAME: pkg2.name
  };
  if (registry) {
    env.npm_config_registry = registry;
  }
  import_npmlog21.default.silly("getNpmExecOpts", pkg2.location, registry);
  return {
    cwd: pkg2.location,
    env,
    pkg: pkg2
  };
}
var import_npmlog21;
var init_get_npm_exec_opts = __esm({
  "libs/core/src/lib/get-npm-exec-opts.ts"() {
    "use strict";
    import_npmlog21 = __toESM(require("npmlog"));
  }
});

// libs/core/src/lib/npm-install.ts
function npmInstall(pkg2, { registry, npmClient, npmClientArgs, npmGlobalStyle, mutex, stdio = "pipe", subCommand = "install" }) {
  const opts = getNpmExecOpts(pkg2, registry);
  const args = [subCommand];
  let cmd = npmClient || "npm";
  if (npmGlobalStyle) {
    cmd = "npm";
    args.push("--global-style");
  }
  if (cmd === "yarn" && mutex) {
    args.push("--mutex", mutex);
  }
  if (cmd === "yarn") {
    args.push("--non-interactive");
  }
  if (npmClientArgs && npmClientArgs.length) {
    args.push(...npmClientArgs);
  }
  opts.stdio = stdio;
  opts.env.LERNA_EXEC_PATH = pkg2.location;
  opts.env.LERNA_ROOT_PATH = pkg2.rootPath;
  import_npmlog22.default.silly("npmInstall", [cmd, args]);
  return childProcess7.exec(cmd, args, opts);
}
function npmInstallDependencies(pkg2, dependencies, config) {
  import_npmlog22.default.silly("npmInstallDependencies", pkg2.name, dependencies);
  if (!(dependencies && dependencies.length)) {
    import_npmlog22.default.verbose("npmInstallDependencies", "no dependencies to install");
    return Promise.resolve();
  }
  const packageJsonBkp = `${pkg2.manifestLocation}.lerna_backup`;
  import_npmlog22.default.silly("npmInstallDependencies", "backup", pkg2.manifestLocation);
  return import_fs_extra4.default.copy(pkg2.manifestLocation, packageJsonBkp).then(() => {
    const cleanup = () => {
      import_npmlog22.default.silly("npmInstallDependencies", "cleanup", pkg2.manifestLocation);
      import_fs_extra4.default.renameSync(packageJsonBkp, pkg2.manifestLocation);
    };
    const unregister = (0, import_signal_exit.default)(cleanup);
    const done = (finalError) => {
      cleanup();
      unregister();
      if (finalError) {
        throw finalError;
      }
    };
    const tempJson = transformManifest(pkg2, dependencies);
    import_npmlog22.default.silly("npmInstallDependencies", "writing tempJson", tempJson);
    return (0, import_write_pkg2.default)(pkg2.manifestLocation, tempJson).then(() => npmInstall(pkg2, config)).then(() => done(), done);
  });
}
function transformManifest(pkg2, dependencies) {
  const json = pkg2.toJSON();
  const depMap = new Map(
    dependencies.map((dep) => {
      const { name, rawSpec } = (0, import_npm_package_arg4.default)(dep, pkg2.location);
      return [name, rawSpec || "*"];
    })
  );
  delete json.scripts;
  ["dependencies", "devDependencies", "optionalDependencies"].forEach((depType) => {
    const collection = json[depType];
    if (collection) {
      Object.keys(collection).forEach((depName) => {
        if (depMap.has(depName)) {
          collection[depName] = depMap.get(depName);
          depMap.delete(depName);
        } else {
          delete collection[depName];
        }
      });
    }
  });
  ["bundledDependencies", "bundleDependencies"].forEach((depType) => {
    const collection = json[depType];
    if (Array.isArray(collection)) {
      const newCollection = [];
      for (const depName of collection) {
        if (depMap.has(depName)) {
          newCollection.push(depName);
          depMap.delete(depName);
        }
      }
      json[depType] = newCollection;
    }
  });
  if (depMap.size) {
    if (!json.dependencies) {
      json.dependencies = {};
    }
    depMap.forEach((depVersion, depName) => {
      json.dependencies[depName] = depVersion;
    });
  }
  return json;
}
var import_fs_extra4, import_npm_package_arg4, import_npmlog22, import_signal_exit, import_write_pkg2, childProcess7;
var init_npm_install = __esm({
  "libs/core/src/lib/npm-install.ts"() {
    "use strict";
    import_fs_extra4 = __toESM(require("fs-extra"));
    import_npm_package_arg4 = __toESM(require("npm-package-arg"));
    import_npmlog22 = __toESM(require("npmlog"));
    import_signal_exit = __toESM(require("signal-exit"));
    import_write_pkg2 = __toESM(require("write-pkg"));
    init_get_npm_exec_opts();
    childProcess7 = require("@lerna/child-process");
    module.exports.npmInstallDependencies = npmInstallDependencies;
  }
});

// libs/core/src/lib/prompt.ts
function promptConfirmation(message) {
  import_npmlog23.default.pause();
  return import_inquirer.default.prompt([
    {
      type: "expand",
      name: "confirm",
      message,
      default: 2,
      // default to help in order to avoid clicking straight through
      choices: [
        { key: "y", name: "Yes", value: true },
        { key: "n", name: "No", value: false }
      ]
    }
  ]).then((answers) => {
    import_npmlog23.default.resume();
    return answers["confirm"];
  });
}
function promptSelectOne(message, { choices, filter, validate } = {}) {
  import_npmlog23.default.pause();
  return import_inquirer.default.prompt([
    {
      type: "list",
      name: "prompt",
      message,
      choices,
      pageSize: choices?.length,
      filter,
      validate
    }
  ]).then((answers) => {
    import_npmlog23.default.resume();
    return answers["prompt"];
  });
}
function promptTextInput(message, { filter, validate } = {}) {
  import_npmlog23.default.pause();
  return import_inquirer.default.prompt([
    {
      type: "input",
      name: "input",
      message,
      filter,
      validate
    }
  ]).then((answers) => {
    import_npmlog23.default.resume();
    return answers["input"];
  });
}
var import_inquirer, import_npmlog23;
var init_prompt = __esm({
  "libs/core/src/lib/prompt.ts"() {
    "use strict";
    import_inquirer = __toESM(require("inquirer"));
    import_npmlog23 = __toESM(require("npmlog"));
  }
});

// libs/core/src/lib/otplease.ts
function otplease(fn, _opts, otpCache) {
  const opts = { ...otpCache, ..._opts };
  return attempt(fn, opts, otpCache);
}
function attempt(fn, opts, otpCache) {
  return new Promise((resolve3) => {
    resolve3(fn(opts));
  }).catch((err) => {
    if (err.code !== "EOTP" && !(err.code === "E401" && /one-time pass/.test(err.body))) {
      throw err;
    } else if (!process.stdin.isTTY || !process.stdout.isTTY) {
      throw err;
    } else {
      if (otpCache != null && otpCache.otp != null && otpCache.otp !== opts["otp"]) {
        return attempt(fn, { ...opts, ...otpCache }, otpCache);
      }
      return semaphore.wait().then(() => {
        if (otpCache != null && otpCache.otp != null && otpCache.otp !== opts["otp"]) {
          semaphore.release();
          return attempt(fn, { ...opts, ...otpCache }, otpCache);
        }
        return getOneTimePassword().then(
          (otp) => {
            if (otpCache != null) {
              otpCache.otp = otp;
            }
            semaphore.release();
            return otp;
          },
          (promptError) => {
            semaphore.release();
            return Promise.reject(promptError);
          }
        ).then((otp) => {
          return fn({ ...opts, otp });
        });
      });
    }
  });
}
function getOneTimePassword(message = "This operation requires a one-time password:") {
  return promptTextInput(message, {
    filter: (otp) => otp.replace(/\s+/g, ""),
    validate: (otp) => otp && /^[\d ]+$|^[A-Fa-f0-9]{64,64}$/.test(otp) || "Must be a valid one-time-password. See https://docs.npmjs.com/getting-started/using-two-factor-authentication"
  });
}
var semaphore;
var init_otplease = __esm({
  "libs/core/src/lib/otplease.ts"() {
    "use strict";
    init_prompt();
    semaphore = {
      _promise: void 0,
      _resolve: void 0,
      wait() {
        return new Promise((resolve3) => {
          if (!this._promise) {
            this._promise = new Promise((release) => {
              this._resolve = release;
            });
            resolve3(void 0);
          } else {
            resolve3(this._promise.then(() => this.wait()));
          }
        });
      },
      release() {
        const resolve3 = this._resolve;
        if (resolve3) {
          this._resolve = void 0;
          this._promise = void 0;
          resolve3();
        }
      }
    };
  }
});

// libs/core/src/lib/npm-conf/defaults.ts
var require_defaults = __commonJS({
  "libs/core/src/lib/npm-conf/defaults.ts"(exports2) {
    "use strict";
    var import_os7 = __toESM(require("os"));
    var import_path25 = __toESM(require("path"));
    var temp = import_os7.default.tmpdir();
    var uidOrPid = process.getuid ? process.getuid() : process.pid;
    var hasUnicode2 = () => true;
    var isWindows = process.platform === "win32";
    var osenv = {
      editor: () => process.env["EDITOR"] || process.env["VISUAL"] || (isWindows ? "notepad.exe" : "vi"),
      shell: () => isWindows ? process.env["COMSPEC"] || "cmd.exe" : process.env["SHELL"] || "/bin/bash"
    };
    var umask = {
      fromString: () => process.umask()
    };
    var home = import_os7.default.homedir();
    if (home) {
      process.env["HOME"] = home;
    } else {
      home = import_path25.default.resolve(temp, `npm-${uidOrPid}`);
    }
    var cacheExtra = process.platform === "win32" ? "npm-cache" : ".npm";
    var cacheRoot = process.platform === "win32" && process.env["APPDATA"] || home;
    var cache = import_path25.default.resolve(cacheRoot, cacheExtra);
    var defaults;
    var globalPrefix;
    Object.defineProperty(exports2, "defaults", {
      get() {
        if (defaults) {
          return defaults;
        }
        if (process.env["PREFIX"]) {
          globalPrefix = process.env["PREFIX"];
        } else if (process.platform === "win32") {
          globalPrefix = import_path25.default.dirname(process.execPath);
        } else {
          globalPrefix = import_path25.default.dirname(import_path25.default.dirname(process.execPath));
          if (process.env["DESTDIR"]) {
            globalPrefix = import_path25.default.join(process.env["DESTDIR"], globalPrefix);
          }
        }
        defaults = {
          access: null,
          "allow-same-version": false,
          "always-auth": false,
          also: null,
          audit: true,
          "audit-level": "low",
          "auth-type": "legacy",
          "bin-links": true,
          browser: null,
          ca: null,
          cafile: null,
          cache,
          "cache-lock-stale": 6e4,
          "cache-lock-retries": 10,
          "cache-lock-wait": 1e4,
          "cache-max": Infinity,
          "cache-min": 10,
          cert: null,
          cidr: null,
          color: process.env["NO_COLOR"] == null,
          depth: Infinity,
          description: true,
          dev: false,
          "dry-run": false,
          editor: osenv.editor(),
          "engine-strict": false,
          force: false,
          "fetch-retries": 2,
          "fetch-retry-factor": 10,
          "fetch-retry-mintimeout": 1e4,
          "fetch-retry-maxtimeout": 6e4,
          git: "git",
          "git-tag-version": true,
          "commit-hooks": true,
          global: false,
          globalconfig: import_path25.default.resolve(globalPrefix, "etc", "npmrc"),
          "global-style": false,
          group: process.platform === "win32" ? 0 : process.env["SUDO_GID"] || process.getgid && process.getgid(),
          "ham-it-up": false,
          heading: "npm",
          "if-present": false,
          "ignore-prepublish": false,
          "ignore-scripts": false,
          "init-module": import_path25.default.resolve(home, ".npm-init.js"),
          "init-author-name": "",
          "init-author-email": "",
          "init-author-url": "",
          "init-version": "1.0.0",
          "init-license": "ISC",
          json: false,
          key: null,
          "legacy-bundling": false,
          link: false,
          "local-address": void 0,
          loglevel: "notice",
          logstream: process.stderr,
          "logs-max": 10,
          long: false,
          maxsockets: 50,
          message: "%s",
          "metrics-registry": null,
          "node-options": null,
          "node-version": process.version,
          offline: false,
          "onload-script": false,
          only: null,
          optional: true,
          otp: void 0,
          "package-lock": true,
          "package-lock-only": false,
          parseable: false,
          "prefer-offline": false,
          "prefer-online": false,
          prefix: globalPrefix,
          preid: "",
          production: process.env["NODE_ENV"] === "production",
          progress: !process.env["TRAVIS"] && !process.env["CI"],
          proxy: null,
          "https-proxy": null,
          noproxy: null,
          "user-agent": "npm/{npm-version} node/{node-version} {platform} {arch}",
          "read-only": false,
          "rebuild-bundle": true,
          registry: "https://registry.npmjs.org/",
          rollback: true,
          save: true,
          "save-bundle": false,
          "save-dev": false,
          "save-exact": false,
          "save-optional": false,
          "save-prefix": "^",
          "save-prod": false,
          scope: "",
          "script-shell": void 0,
          "scripts-prepend-node-path": "warn-only",
          searchopts: "",
          searchexclude: null,
          searchlimit: 20,
          searchstaleness: 15 * 60,
          "send-metrics": false,
          shell: osenv.shell(),
          shrinkwrap: true,
          "sign-git-commit": false,
          "sign-git-tag": false,
          "sso-poll-frequency": 500,
          "sso-type": "oauth",
          "strict-ssl": true,
          tag: "latest",
          "tag-version-prefix": "v",
          timing: false,
          tmp: temp,
          unicode: hasUnicode2(),
          "unsafe-perm": process.platform === "win32" || process.platform === "cygwin" || // TODO: refactor based on TS feedback
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          !(process.getuid && process.setuid && process.getgid && process.setgid) || process.getuid() !== 0,
          "update-notifier": true,
          usage: false,
          user: process.platform === "win32" || import_os7.default.type() === "OS400" ? 0 : "nobody",
          userconfig: import_path25.default.resolve(home, ".npmrc"),
          // TODO: refactor based on TS feedback
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          umask: process.umask ? process.umask() : umask.fromString("022"),
          version: false,
          versions: false,
          viewer: process.platform === "win32" ? "browser" : "man",
          _exit: true
        };
        return defaults;
      }
    });
  }
});

// libs/core/src/lib/npm-conf/index.ts
var require_npm_conf = __commonJS({
  "libs/core/src/lib/npm-conf/index.ts"(exports2, module2) {
    "use strict";
    var import_path25 = __toESM(require("path"));
    init_conf();
    init_nerf_dart();
    var { defaults } = require_defaults();
    module2.exports = npmConf3;
    module2.exports.Conf = Conf;
    module2.exports.defaults = Object.assign({}, defaults);
    module2.exports.toNerfDart = toNerfDart;
    function npmConf3(opts) {
      const conf = new Conf(Object.assign({}, defaults));
      const cleanOpts = opts ? Object.keys(opts).reduce((acc, key) => {
        if (opts[key] !== void 0) {
          acc[key] = opts[key];
        }
        return acc;
      }, {}) : {};
      conf.add(cleanOpts, "cli");
      conf.addEnv();
      conf.loadPrefix();
      const projectConf = import_path25.default.resolve(conf["localPrefix"], ".npmrc");
      const userConf = conf["get"]("userconfig");
      if (!conf["get"]("global") && projectConf !== userConf) {
        conf.addFile(projectConf, "project");
      } else {
        conf.add({}, "project");
      }
      conf.addFile(conf["get"]("userconfig"), "user");
      if (conf["get"]("prefix")) {
        const etc = import_path25.default.resolve(conf["get"]("prefix"), "etc");
        conf.root.globalconfig = import_path25.default.resolve(etc, "npmrc");
        conf.root.globalignorefile = import_path25.default.resolve(etc, "npmignore");
      }
      conf.addFile(conf["get"]("globalconfig"), "global");
      conf.loadUser();
      const caFile = conf["get"]("cafile");
      if (caFile) {
        conf.loadCAFile(caFile);
      }
      return conf;
    }
  }
});

// libs/core/src/lib/run-lifecycle.ts
function flattenOptions(obj) {
  return {
    ignorePrepublish: obj["ignore-prepublish"],
    ignoreScripts: obj["ignore-scripts"],
    nodeOptions: obj["node-options"],
    scriptShell: obj["script-shell"],
    scriptsPrependNodePath: obj["scripts-prepend-node-path"],
    unsafePerm: obj["unsafe-perm"],
    ...obj
  };
}
function printCommandBanner(id, event, cmd, path22) {
  return console.log(`
> ${id ? `${id} ` : ""}${event} ${path22}
> ${cmd.trim().replace(/\n/g, "\n> ")}
`);
}
function runLifecycle(pkg2, stage, options) {
  if ("root" in options) {
    options = options.snapshot;
  }
  const opts = {
    log: import_npmlog24.default,
    unsafePerm: true,
    ...flattenOptions(options)
  };
  const dir = pkg2.location;
  const id = `${pkg2.name}@${pkg2.version}`;
  const config = {};
  if (opts.ignoreScripts) {
    opts.log.verbose("lifecycle", "%j ignored in %j", stage, pkg2.name);
    return Promise.resolve();
  }
  if (!pkg2.scripts || !pkg2.scripts[stage]) {
    opts.log.silly("lifecycle", "No script for %j in %j, continuing", stage, pkg2.name);
    return Promise.resolve();
  }
  if (stage === "prepublish" && opts.ignorePrepublish) {
    opts.log.verbose("lifecycle", "%j ignored in %j", stage, pkg2.name);
    return Promise.resolve();
  }
  for (const [key, val] of Object.entries(opts)) {
    if (val != null && key !== "log" && key !== "logstream") {
      config[key] = val;
    }
  }
  if (pkg2.__isLernaPackage) {
    pkg2 = pkg2.toJSON();
  }
  pkg2._id = id;
  opts.log.silly("lifecycle", "%j starting in %j", stage, pkg2.name);
  opts.log.info("lifecycle", `${id}~${stage}: ${id}`);
  const stdio = opts.stdio || "pipe";
  if (import_npmlog24.default.level !== "silent") {
    printCommandBanner(id, stage, pkg2.scripts[stage], dir);
  }
  return queue.add(
    async () => runScript({
      event: stage,
      path: dir,
      pkg: pkg2,
      args: [],
      stdio,
      banner: false,
      // TODO: refactor based on TS feedback
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      scriptShell: config.scriptShell
    }).then(
      ({ stdout }) => {
        if (stdout) {
          process.stdout.write(stdout.toString().trimEnd() + "\n");
        }
        opts.log.silly("lifecycle", "%j finished in %j", stage, pkg2.name);
      },
      (err) => {
        const exitCode = err.code || 1;
        import_npmlog24.default.error("lifecycle", "%j errored in %j, exiting %d", stage, pkg2.name, exitCode);
        err.name = "ValidationError";
        err.exitCode = exitCode;
        process.exitCode = exitCode;
        throw err;
      }
    )
  );
}
function createRunner(commandOptions) {
  const cfg = npmConf(commandOptions).snapshot;
  return (pkg2, stage) => runLifecycle(pkg2, stage, cfg);
}
var import_npmlog24, import_p_queue, runScript, npmConf, queue;
var init_run_lifecycle = __esm({
  "libs/core/src/lib/run-lifecycle.ts"() {
    "use strict";
    import_npmlog24 = __toESM(require("npmlog"));
    import_p_queue = __toESM(require("p-queue"));
    runScript = require("@npmcli/run-script");
    npmConf = require_npm_conf();
    queue = new import_p_queue.default({ concurrency: 1 });
  }
});

// libs/core/src/lib/npm-publish.ts
function flattenOptions2(obj) {
  return {
    // eslint-disable-next-line dot-notation -- (npm v7 compat)
    defaultTag: obj["tag"] || "latest",
    dryRun: obj["dry-run"],
    // libnpmpublish / npm-registry-fetch check strictSSL rather than strict-ssl
    strictSSL: obj["strict-ssl"],
    ...obj
  };
}
function npmPublish(pkg2, tarFilePath, options = {}, otpCache) {
  const { dryRun, ...remainingOptions } = flattenOptions2(options);
  const { scope } = (0, import_npm_package_arg5.default)(pkg2.name);
  const opts = {
    log: import_npmlog25.default,
    ...remainingOptions,
    projectScope: scope
  };
  opts.log.verbose("publish", pkg2.name);
  let chain = Promise.resolve();
  if (!dryRun) {
    chain = chain.then(() => {
      let { manifestLocation } = pkg2;
      if (pkg2.contents !== pkg2.location) {
        manifestLocation = import_path14.default.join(pkg2.contents, "package.json");
      }
      return Promise.all([import_fs_extra5.default.readFile(tarFilePath), readJSONAsync(manifestLocation)]);
    });
    chain = chain.then(([tarData, manifest]) => {
      if (opts.defaultTag !== "latest" && manifest.publishConfig && manifest.publishConfig.tag && manifest.publishConfig.tag !== opts.defaultTag) {
        manifest.publishConfig.tag = opts.defaultTag;
      }
      if (manifest.publishConfig) {
        Object.assign(opts, publishConfigToOpts(manifest.publishConfig));
      }
      return otplease((innerOpts) => (0, import_libnpmpublish.publish)(manifest, tarData, innerOpts), opts, otpCache);
    });
  }
  chain = chain.then(() => runLifecycle(pkg2, "publish", opts));
  chain = chain.then(() => runLifecycle(pkg2, "postpublish", opts));
  return chain;
}
function publishConfigToOpts(publishConfig) {
  const opts = { ...publishConfig };
  if (publishConfig.tag) {
    opts.defaultTag = publishConfig.tag;
    delete opts.tag;
  }
  return opts;
}
var import_fs_extra5, import_libnpmpublish, import_npm_package_arg5, import_npmlog25, import_path14, import_pify2, readJSON, readJSONAsync;
var init_npm_publish = __esm({
  "libs/core/src/lib/npm-publish.ts"() {
    "use strict";
    import_fs_extra5 = __toESM(require("fs-extra"));
    import_libnpmpublish = require("libnpmpublish");
    import_npm_package_arg5 = __toESM(require("npm-package-arg"));
    import_npmlog25 = __toESM(require("npmlog"));
    import_path14 = __toESM(require("path"));
    import_pify2 = __toESM(require("pify"));
    init_otplease();
    init_run_lifecycle();
    readJSON = require("read-package-json");
    readJSONAsync = (0, import_pify2.default)(readJSON);
  }
});

// libs/core/src/lib/npm-run-script.ts
function npmRunScript(script, { args, npmClient, pkg: pkg2, reject = true }) {
  import_npmlog26.default.silly("npmRunScript", script, args, pkg2.name);
  const argv = ["run", script, ...args];
  const opts = makeOpts(pkg2, reject);
  return childProcess8.exec(npmClient, argv, opts);
}
function npmRunScriptStreaming(script, { args, npmClient, pkg: pkg2, prefix, reject = true }) {
  import_npmlog26.default.silly("npmRunScriptStreaming", [script, args, pkg2.name]);
  const argv = ["run", script, ...args];
  const opts = makeOpts(pkg2, reject);
  return childProcess8.spawnStreaming(npmClient, argv, opts, prefix && pkg2.name);
}
function makeOpts(pkg2, reject) {
  return Object.assign(getNpmExecOpts(pkg2), {
    windowsHide: false,
    reject
  });
}
var import_npmlog26, childProcess8;
var init_npm_run_script = __esm({
  "libs/core/src/lib/npm-run-script.ts"() {
    "use strict";
    import_npmlog26 = __toESM(require("npmlog"));
    init_get_npm_exec_opts();
    childProcess8 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/output.ts
function output(...args) {
  import_npmlog27.default["clearProgress"]();
  console.log(...args);
  import_npmlog27.default["showProgress"]();
}
var import_npmlog27;
var init_output = __esm({
  "libs/core/src/lib/output.ts"() {
    "use strict";
    import_npmlog27 = __toESM(require("npmlog"));
  }
});

// libs/core/src/lib/get-packed.ts
function getPacked(pkg2, tarFilePath) {
  const bundledWanted = new Set(pkg2.bundleDependencies || pkg2.bundledDependencies || []);
  const bundled = /* @__PURE__ */ new Set();
  const files = [];
  let totalEntries = 0;
  let totalEntrySize = 0;
  return import_tar.default.list({
    file: tarFilePath,
    onentry(entry) {
      totalEntries += 1;
      totalEntrySize += entry.size;
      const p = entry.path;
      if (p.startsWith("package/node_modules/")) {
        const name = p.match(/^package\/node_modules\/((?:@[^/]+\/)?[^/]+)/)[1];
        if (bundledWanted.has(name)) {
          bundled.add(name);
        }
      } else {
        files.push({
          path: entry.path.replace(/^package\//, ""),
          size: entry.size,
          mode: entry.mode
        });
      }
    },
    strip: 1
  }).then(
    () => Promise.all([
      import_fs_extra6.default.stat(tarFilePath),
      import_ssri.default.fromStream(import_fs_extra6.default.createReadStream(tarFilePath), {
        algorithms: ["sha1", "sha512"]
      })
    ])
  ).then(([{ size }, { sha1, sha512 }]) => {
    const shasum = sha1[0].hexDigest();
    return {
      id: `${pkg2.name}@${pkg2.version}`,
      name: pkg2.name,
      version: pkg2.version,
      size,
      unpackedSize: totalEntrySize,
      shasum,
      integrity: import_ssri.default.parse(sha512[0]),
      filename: import_path15.default.basename(tarFilePath),
      files,
      entryCount: totalEntries,
      bundled: Array.from(bundled),
      tarFilePath
    };
  });
}
var import_fs_extra6, import_path15, import_ssri, import_tar;
var init_get_packed = __esm({
  "libs/core/src/lib/get-packed.ts"() {
    "use strict";
    import_fs_extra6 = __toESM(require("fs-extra"));
    import_path15 = __toESM(require("path"));
    import_ssri = __toESM(require("ssri"));
    import_tar = __toESM(require("tar"));
  }
});

// libs/core/src/lib/temp-write.ts
async function tempWrite(fileContent, filePath) {
  const tempPath = tempfile(filePath);
  const write = (0, import_is_stream.default)(fileContent) ? writeStream : writeFileP;
  await (0, import_make_dir.default)(import_path16.default.dirname(tempPath));
  await write(tempPath, fileContent);
  return tempPath;
}
var import_graceful_fs, import_is_stream, import_make_dir, import_path16, import_temp_dir, import_util2, uuid, writeFileP, tempfile, writeStream, temp_write_default;
var init_temp_write = __esm({
  "libs/core/src/lib/temp-write.ts"() {
    "use strict";
    import_graceful_fs = __toESM(require("graceful-fs"));
    import_is_stream = __toESM(require("is-stream"));
    import_make_dir = __toESM(require("make-dir"));
    import_path16 = __toESM(require("path"));
    import_temp_dir = __toESM(require("temp-dir"));
    import_util2 = require("util");
    uuid = __toESM(require("uuid"));
    writeFileP = (0, import_util2.promisify)(import_graceful_fs.default.writeFile);
    tempfile = (filePath) => import_path16.default.join(import_temp_dir.default, uuid.v4(), filePath || "");
    writeStream = async (filePath, fileContent) => new Promise((resolve3, reject) => {
      const writable = import_graceful_fs.default.createWriteStream(filePath);
      fileContent.on("error", (error) => {
        reject(error);
        fileContent.unpipe(writable);
        writable.end();
      }).pipe(writable).on("error", reject).on("finish", resolve3);
    });
    tempWrite.sync = (fileContent, filePath) => {
      const tempPath = tempfile(filePath);
      import_make_dir.default.sync(import_path16.default.dirname(tempPath));
      import_graceful_fs.default.writeFileSync(tempPath, fileContent);
      return tempPath;
    };
    temp_write_default = tempWrite;
  }
});

// libs/core/src/lib/pack-directory.ts
function packDirectory(_pkg, dir, options) {
  const pkg2 = Package.lazy(_pkg, dir);
  const opts = {
    log: import_npmlog28.default,
    ...options
  };
  opts.log.verbose("pack-directory", import_path17.default.relative(".", pkg2.contents));
  let chain = Promise.resolve();
  if (opts.ignorePrepublish !== true) {
    chain = chain.then(() => runLifecycle(pkg2, "prepublish", opts));
  }
  chain = chain.then(() => runLifecycle(pkg2, "prepare", opts));
  if (opts.lernaCommand === "publish") {
    opts.stdio = "inherit";
    chain = chain.then(() => pkg2.refresh());
    chain = chain.then(() => runLifecycle(pkg2, "prepublishOnly", opts));
    chain = chain.then(() => pkg2.refresh());
  }
  chain = chain.then(() => runLifecycle(pkg2, "prepack", opts));
  chain = chain.then(() => pkg2.refresh());
  chain = chain.then(() => (0, import_npm_packlist.default)({ path: pkg2.contents }));
  chain = chain.then(
    (files) => import_tar2.default.create(
      {
        cwd: pkg2.contents,
        prefix: "package/",
        portable: true,
        // Provide a specific date in the 1980s for the benefit of zip,
        // which is confounded by files dated at the Unix epoch 0.
        // TODO: refactor based on TS feedback
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        mtime: /* @__PURE__ */ new Date("1985-10-26T08:15:00.000Z"),
        gzip: true
      },
      // NOTE: node-tar does some Magic Stuff depending on prefixes for files
      //       specifically with @ signs, so we just neutralize that one
      //       and any such future "features" by prepending `./`
      // TODO: refactor based on TS feedback
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      files.map((f) => `./${f}`)
    )
  );
  chain = chain.then((stream) => temp_write_default(stream, getTarballName(pkg2)));
  chain = chain.then(
    (tarFilePath) => getPacked(pkg2, tarFilePath).then(
      (packed) => Promise.resolve().then(() => runLifecycle(pkg2, "postpack", opts)).then(() => packed)
    )
  );
  return chain;
}
function getTarballName(pkg2) {
  const name = pkg2.name[0] === "@" ? (
    // scoped packages get special treatment
    pkg2.name.substr(1).replace(/\//g, "-")
  ) : pkg2.name;
  return `${name}-${pkg2.version}.tgz`;
}
var import_npm_packlist, import_npmlog28, import_path17, import_tar2;
var init_pack_directory = __esm({
  "libs/core/src/lib/pack-directory.ts"() {
    "use strict";
    import_npm_packlist = __toESM(require("npm-packlist"));
    import_npmlog28 = __toESM(require("npmlog"));
    import_path17 = __toESM(require("path"));
    import_tar2 = __toESM(require("tar"));
    init_get_packed();
    init_package();
    init_run_lifecycle();
    init_temp_write();
  }
});

// libs/core/src/lib/profiler.ts
function generateProfileOutputPath(outputDirectory) {
  return import_upath.default.join(import_upath.default.resolve(outputDirectory || "."), getTimeBasedFilename());
}
var import_fs_extra7, import_npmlog29, import_upath, hrtimeToMicroseconds, range, getTimeBasedFilename, Profiler;
var init_profiler = __esm({
  "libs/core/src/lib/profiler.ts"() {
    "use strict";
    import_fs_extra7 = __toESM(require("fs-extra"));
    import_npmlog29 = __toESM(require("npmlog"));
    import_upath = __toESM(require("upath"));
    hrtimeToMicroseconds = (hrtime) => {
      return (hrtime[0] * 1e9 + hrtime[1]) / 1e3;
    };
    range = (len) => {
      return Array(len).fill().map((_, idx) => idx);
    };
    getTimeBasedFilename = () => {
      const now = /* @__PURE__ */ new Date();
      const datetime = now.toISOString().split(".")[0];
      const datetimeNormalized = datetime.replace(/-|:/g, "");
      return `Lerna-Profile-${datetimeNormalized}.json`;
    };
    Profiler = class {
      events;
      logger;
      outputPath;
      threads;
      constructor({ concurrency, log: log63 = import_npmlog29.default, outputDirectory }) {
        this.events = [];
        this.logger = log63;
        this.outputPath = generateProfileOutputPath(outputDirectory);
        this.threads = range(concurrency);
      }
      run(fn, name) {
        let startTime;
        let threadId;
        return Promise.resolve().then(() => {
          startTime = process.hrtime();
          threadId = this.threads.shift();
        }).then(() => fn()).then((value) => {
          const duration = process.hrtime(startTime);
          const event = {
            name,
            ph: "X",
            ts: hrtimeToMicroseconds(startTime),
            pid: 1,
            tid: threadId,
            dur: hrtimeToMicroseconds(duration)
          };
          this.events.push(event);
          this.threads.unshift(threadId);
          this.threads.sort();
          return value;
        });
      }
      output() {
        return import_fs_extra7.default.outputJson(this.outputPath, this.events).then(() => this.logger.info("profiler", `Performance profile saved to ${this.outputPath}`));
      }
    };
  }
});

// libs/core/src/lib/pulse-till-done.ts
function pulseStart(prefix) {
  pulsers += 1;
  if (pulsers > 1) {
    return;
  }
  pulse = setInterval(() => import_npmlog30.default["gauge"].pulse(prefix), 150);
}
function pulseStop() {
  pulsers -= 1;
  if (pulsers > 0) {
    return;
  }
  clearInterval(pulse);
}
function pulseTillDone(prefix, promise) {
  if (!promise) {
    promise = prefix;
    prefix = "";
  }
  pulseStart(prefix);
  return Promise.resolve(promise).then(
    (val) => {
      pulseStop();
      return val;
    },
    (err) => {
      pulseStop();
      throw err;
    }
  );
}
var import_npmlog30, pulsers, pulse;
var init_pulse_till_done = __esm({
  "libs/core/src/lib/pulse-till-done.ts"() {
    "use strict";
    import_npmlog30 = __toESM(require("npmlog"));
    pulsers = 0;
  }
});

// libs/core/src/lib/rimraf-dir.ts
async function rimrafDir(dirPath) {
  import_npmlog31.default.silly("rimrafDir", dirPath);
  if (!(0, import_fs5.existsSync)(dirPath)) {
    return;
  }
  const isSuccessful = await (0, import_rimraf.default)(dirPath);
  if (!isSuccessful) {
    throw new Error(`Failed to fully remove ${dirPath}`);
  }
  import_npmlog31.default.verbose("rimrafDir", "removed", dirPath);
}
var import_fs5, import_npmlog31, import_rimraf;
var init_rimraf_dir = __esm({
  "libs/core/src/lib/rimraf-dir.ts"() {
    "use strict";
    import_fs5 = require("fs");
    import_npmlog31 = __toESM(require("npmlog"));
    import_rimraf = __toESM(require("rimraf"));
  }
});

// libs/core/src/lib/run-projects-topologically.ts
async function runProjectsTopologically(projects, projectGraph, runner, { concurrency, rejectCycles } = {}) {
  const queue2 = new import_p_queue2.default({ concurrency });
  const returnValues = [];
  const projectsMap = new Map(projects.map((p) => [p.name, p]));
  const localDependencies = projectGraph.localPackageDependencies;
  const flattenedLocalDependencies = (0, import_lodash6.flatten)(Object.values(localDependencies));
  const getProject = (name) => {
    const project = projectsMap.get(name);
    if (!project) {
      throw new Error(`Failed to find project ${name}. This is likely a bug in Lerna's toposort algorithm.`);
    }
    return project;
  };
  const dependenciesBySource = projects.reduce(
    (prev, next) => ({
      ...prev,
      [next.name]: /* @__PURE__ */ new Set()
    }),
    {}
  );
  flattenedLocalDependencies.forEach((dep) => {
    if (dependenciesBySource[dep.source] && projectsMap.has(dep.target)) {
      dependenciesBySource[dep.source].add(dep.target);
    }
  });
  const unmergedCycles = getCycles(dependenciesBySource);
  reportCycles(unmergedCycles, rejectCycles);
  const cycles = new Set(mergeOverlappingCycles(unmergedCycles));
  const seen = /* @__PURE__ */ new Set();
  const errors = [];
  const queueNextPackages = () => {
    if (seen.size === projects.length) {
      return;
    }
    let batch = Object.keys(dependenciesBySource).filter((p) => dependenciesBySource[p].size === 0).filter((p) => !seen.has(p));
    if (batch.length === 0) {
      const cycle = Array.from(cycles.values()).find((cycle2) => {
        const cycleHasExternalDependencies = cycle2.some((project) => {
          const projectDeps = dependenciesBySource[project];
          const depIsNotInCycle = (dep) => cycle2.indexOf(dep) === -1;
          return !!projectDeps && Array.from(projectDeps).filter(depIsNotInCycle).length > 0;
        });
        return !cycleHasExternalDependencies;
      });
      if (cycle) {
        cycles.delete(cycle);
        batch = cycle.filter((p) => projectsMap.has(p));
      }
    }
    batch.forEach((p) => {
      const project = getProject(p);
      seen.add(p);
      queue2.add(
        () => runner(project).then((value) => {
          returnValues.push(value);
          delete dependenciesBySource[p];
          Object.keys(dependenciesBySource).forEach((dep) => dependenciesBySource[dep].delete(p));
          queueNextPackages();
        })
      ).catch((err) => {
        errors.push(err);
      });
    });
  };
  queueNextPackages();
  await queue2.onIdle();
  if (errors.length) {
    throw errors[0];
  }
  if (seen.size !== projects.length) {
    throw new ValidationError("ERROR", "Not all tasks were run. This is likely a bug in Lerna.");
  }
  return returnValues;
}
var import_lodash6, import_p_queue2;
var init_run_projects_topologically = __esm({
  "libs/core/src/lib/run-projects-topologically.ts"() {
    "use strict";
    import_lodash6 = require("lodash");
    import_p_queue2 = __toESM(require("p-queue"));
    init_cycles();
    init_validation_error();
  }
});

// libs/core/src/lib/scm-clients/github/create-github-client.ts
function createGitHubClient() {
  import_npmlog32.default.silly("createGitHubClient");
  const { GH_TOKEN, GHE_API_URL, GHE_VERSION } = process.env;
  if (!GH_TOKEN) {
    throw new ValidationError(
      "",
      `A GH_TOKEN environment variable is required when "createRelease" is set to "github"`
    );
  }
  if (GHE_VERSION) {
    import_rest.Octokit.plugin(require(`@octokit/plugin-enterprise-rest/ghe-${GHE_VERSION}`));
  }
  const options = {
    auth: `token ${GH_TOKEN}`
  };
  if (GHE_API_URL) {
    options.baseUrl = GHE_API_URL;
  }
  return new import_rest.Octokit(options);
}
function parseGitRepo(remote = "origin", opts) {
  import_npmlog32.default.silly("parseGitRepo");
  const args = ["config", "--get", `remote.${remote}.url`];
  import_npmlog32.default.verbose("git", args);
  const url2 = childProcess9.execSync("git", args, opts);
  if (!url2) {
    throw new ValidationError("", `Git remote URL could not be found using "${remote}".`);
  }
  return (0, import_git_url_parse.default)(url2);
}
var import_rest, import_git_url_parse, import_npmlog32, childProcess9;
var init_create_github_client = __esm({
  "libs/core/src/lib/scm-clients/github/create-github-client.ts"() {
    "use strict";
    import_rest = require("@octokit/rest");
    import_git_url_parse = __toESM(require("git-url-parse"));
    import_npmlog32 = __toESM(require("npmlog"));
    init_validation_error();
    childProcess9 = require("@lerna/child-process");
  }
});

// libs/core/src/lib/scm-clients/gitlab/gitlab-client.ts
var import_node_fetch, import_npmlog33, import_path18, GitLabClient;
var init_gitlab_client = __esm({
  "libs/core/src/lib/scm-clients/gitlab/gitlab-client.ts"() {
    "use strict";
    import_node_fetch = __toESM(require("node-fetch"));
    import_npmlog33 = __toESM(require("npmlog"));
    import_path18 = __toESM(require("path"));
    GitLabClient = class {
      constructor(token, baseUrl = "https://gitlab.com/api/v4") {
        this.token = token;
        this.baseUrl = baseUrl;
      }
      // TODO: refactor based on TS feedback
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      createRelease({ owner, repo, name, tag_name: tagName, body }) {
        const releasesUrl = this.releasesUrl(owner, repo, "releases");
        import_npmlog33.default.silly("Requesting GitLab releases", releasesUrl);
        return (0, import_node_fetch.default)(releasesUrl, {
          method: "post",
          body: JSON.stringify({ name, tag_name: tagName, description: body }),
          headers: {
            "PRIVATE-TOKEN": this.token,
            "Content-Type": "application/json"
          }
        }).then(({ ok, status, statusText }) => {
          if (!ok) {
            import_npmlog33.default.error("gitlab", `Failed to create release
Request returned ${status} ${statusText}`);
          } else {
            import_npmlog33.default.silly("gitlab", "Created release successfully.");
          }
        });
      }
      releasesUrl(namespace, project) {
        return new URL(
          `${this.baseUrl}/${import_path18.default.join("projects", encodeURIComponent(`${namespace}/${project}`), "releases")}`
        ).toString();
      }
    };
  }
});

// libs/core/src/lib/scm-clients/gitlab/create-gitlab-client.ts
function OcktokitAdapter(client) {
  return { repos: { createRelease: client.createRelease.bind(client) } };
}
function createGitLabClient() {
  const { GL_API_URL, GL_TOKEN } = process.env;
  import_npmlog34.default.silly("Creating a GitLab client...");
  if (!GL_TOKEN) {
    throw new Error("A GL_TOKEN environment variable is required.");
  }
  const client = new GitLabClient(GL_TOKEN, GL_API_URL);
  return OcktokitAdapter(client);
}
var import_npmlog34;
var init_create_gitlab_client = __esm({
  "libs/core/src/lib/scm-clients/gitlab/create-gitlab-client.ts"() {
    "use strict";
    import_npmlog34 = __toESM(require("npmlog"));
    init_gitlab_client();
  }
});

// libs/core/src/lib/scm-clients/index.ts
var init_scm_clients = __esm({
  "libs/core/src/lib/scm-clients/index.ts"() {
    "use strict";
    init_create_github_client();
    init_create_gitlab_client();
  }
});

// libs/core/src/lib/timer.ts
function timer() {
  if (process.env["LERNA_INTEGRATION"]) {
    return () => 0;
  }
  const startMillis = Date.now();
  return () => Date.now() - startMillis;
}
var init_timer = __esm({
  "libs/core/src/lib/timer.ts"() {
    "use strict";
  }
});

// libs/core/src/lib/npm-dist-tag.ts
var npm_dist_tag_exports = {};
__export(npm_dist_tag_exports, {
  add: () => add,
  list: () => list,
  remove: () => remove
});
function add(spec, tag, options, otpCache) {
  const opts = {
    log: import_npmlog35.default,
    ...options,
    spec: (0, import_npm_package_arg6.default)(spec)
  };
  const cleanTag = (tag || opts.defaultTag || opts.tag).trim();
  const { name, rawSpec: version } = opts.spec;
  opts.log.verbose("dist-tag", `adding "${cleanTag}" to ${name}@${version}`);
  if (opts.dryRun) {
    opts.log.silly("dist-tag", "dry-run configured, bailing now");
    return Promise.resolve();
  }
  return fetchTags(opts).then((tags) => {
    if (tags[cleanTag] === version) {
      opts.log.warn("dist-tag", `${name}@${cleanTag} already set to ${version}`);
      return tags;
    }
    const uri = `/-/package/${opts.spec.escapedName}/dist-tags/${encodeURIComponent(cleanTag)}`;
    const payload = {
      ...opts,
      method: "PUT",
      body: JSON.stringify(version),
      headers: {
        // cannot use fetch.json() due to HTTP 204 response,
        // so we manually set the required content-type
        "content-type": "application/json"
      },
      spec: opts.spec
    };
    return otplease((wrappedPayload) => (0, import_npm_registry_fetch.default)(uri, wrappedPayload), payload, otpCache).then(() => {
      opts.log.verbose("dist-tag", `added "${cleanTag}" to ${name}@${version}`);
      tags[cleanTag] = version;
      return tags;
    });
  });
}
function remove(spec, tag, options, otpCache) {
  const opts = {
    log: import_npmlog35.default,
    ...options,
    spec: (0, import_npm_package_arg6.default)(spec)
  };
  opts.log.verbose("dist-tag", `removing "${tag}" from ${opts.spec.name}`);
  if (opts.dryRun) {
    opts.log.silly("dist-tag", "dry-run configured, bailing now");
    return Promise.resolve();
  }
  return fetchTags(opts).then((tags) => {
    const version = tags[tag];
    if (!version) {
      opts.log.info("dist-tag", `"${tag}" is not a dist-tag on ${opts.spec.name}`);
      return tags;
    }
    const uri = `/-/package/${opts.spec.escapedName}/dist-tags/${encodeURIComponent(tag)}`;
    const payload = {
      ...opts,
      method: "DELETE",
      spec: opts.spec
    };
    return otplease((wrappedPayload) => (0, import_npm_registry_fetch.default)(uri, wrappedPayload), payload, otpCache).then(() => {
      opts.log.verbose("dist-tag", `removed "${tag}" from ${opts.spec.name}@${version}`);
      delete tags[tag];
      return tags;
    });
  });
}
function list(spec, options) {
  const opts = {
    log: import_npmlog35.default,
    ...options,
    spec: (0, import_npm_package_arg6.default)(spec)
  };
  if (opts.dryRun) {
    opts.log.silly("dist-tag", "dry-run configured, bailing now");
    return Promise.resolve();
  }
  return fetchTags(opts);
}
function fetchTags(opts) {
  return import_npm_registry_fetch.default.json(`/-/package/${opts.spec.escapedName}/dist-tags`, {
    ...opts,
    preferOnline: true,
    spec: opts.spec
  }).then((data) => {
    if (data && typeof data === "object") {
      delete data["_etag"];
    }
    return data || {};
  });
}
var import_npm_package_arg6, import_npm_registry_fetch, import_npmlog35;
var init_npm_dist_tag = __esm({
  "libs/core/src/lib/npm-dist-tag.ts"() {
    "use strict";
    import_npm_package_arg6 = __toESM(require("npm-package-arg"));
    import_npm_registry_fetch = __toESM(require("npm-registry-fetch"));
    import_npmlog35 = __toESM(require("npmlog"));
    init_otplease();
  }
});

// libs/core/src/index.ts
var npmConf2, npmDistTag;
var init_src = __esm({
  "libs/core/src/index.ts"() {
    "use strict";
    init_add_dependencies();
    init_add_dependents();
    init_check_working_tree();
    init_cli();
    init_collect_updates();
    init_command();
    init_detect_projects();
    init_is_git_initialized();
    init_conventional_commits();
    init_describe_ref();
    init_filter_options();
    init_filter_projects();
    init_get_package_manifest_path();
    init_get_packages_for_option();
    init_git_checkout();
    init_has_npm_version();
    init_listable_format_projects();
    init_listable_options();
    init_log_packed();
    init_conf();
    init_npm_install();
    init_npm_publish();
    init_npm_run_script();
    init_otplease();
    init_output();
    init_pack_directory();
    init_package();
    init_prerelease_id_from_version();
    init_profiler();
    init_project();
    init_project_graph_with_packages();
    init_prompt();
    init_pulse_till_done();
    init_rimraf_dir();
    init_run_lifecycle();
    init_run_projects_topologically();
    init_scm_clients();
    init_temp_write();
    init_timer();
    init_toposort_projects();
    init_validation_error();
    npmConf2 = require_npm_conf();
    npmDistTag = (init_npm_dist_tag(), __toCommonJS(npm_dist_tag_exports));
  }
});

// libs/commands/changed/src/index.ts
var require_src = __commonJS({
  "libs/commands/changed/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    module2.exports = function factory2(argv) {
      return new ChangedCommand(argv);
    };
    var ChangedCommand = class extends Command {
      result;
      get otherCommandConfigs() {
        return ["version", "publish"];
      }
      initialize() {
        if (this.options.conventionalGraduate) {
          this.options.conventionalCommits = true;
          if (this.options.forcePublish) {
            this.logger.warn("option", "--force-publish superseded by --conventional-graduate");
          }
        }
        const projectsWithPackage = Object.values(this.projectGraph.nodes).filter((node) => !!node.package);
        const updates = collectProjectUpdates(
          projectsWithPackage,
          this.projectGraph,
          this.execOpts,
          this.options
        );
        this.result = listableFormatProjects(updates, this.projectGraph, this.options);
        if (this.result.count === 0) {
          this.logger.info("", "No changed packages found");
          process.exitCode = 1;
          return false;
        }
      }
      execute() {
        output(this.result.text);
        this.logger.success(
          "found",
          "%d %s ready to publish",
          this.result.count,
          this.result.count === 1 ? "package" : "packages"
        );
      }
    };
    module2.exports.ChangedCommand = ChangedCommand;
  }
});

// libs/commands/changed/src/command.ts
var require_command = __commonJS({
  "libs/commands/changed/src/command.ts"(exports2, module2) {
    "use strict";
    init_src();
    var command = {
      command: "changed",
      aliases: ["updated"],
      describe: "List local packages that have changed since the last tagged release",
      builder(yargs2) {
        const opts = {
          // only the relevant bits from `lerna version`
          "conventional-commits": {
            // fallback for overzealous --conventional-graduate
            hidden: true,
            type: "boolean"
          },
          "conventional-graduate": {
            describe: "Detect currently prereleased packages that would change to a non-prerelease version."
            // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
          },
          "force-conventional-graduate": {
            describe: "Always include all packages by specified by --conventional-graduate whether or not they are a prerelease or have changes since the previous version.",
            type: "boolean"
          },
          "force-publish": {
            describe: "Always include targeted packages when detecting changed packages, skipping default logic."
            // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
          },
          "ignore-changes": {
            describe: [
              "Ignore changes in files matched by glob(s) when detecting changed packages.",
              "Pass --no-ignore-changes to completely disable."
            ].join("\n"),
            type: "array"
          },
          "include-merged-tags": {
            describe: "Include tags from merged branches when detecting changed packages.",
            type: "boolean"
          }
        };
        yargs2.options(opts).group(Object.keys(opts), "Command Options:");
        return listableOptions(yargs2, "Output Options:");
      },
      handler(argv) {
        return require_src()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/legacy-core/src/lib/collect-updates/collect-dependents.ts
function collectDependents2(nodes) {
  const collected = /* @__PURE__ */ new Set();
  nodes.forEach((currentNode) => {
    if (currentNode.localDependents.size === 0) {
      return;
    }
    const queue2 = [currentNode];
    const seen = /* @__PURE__ */ new Set();
    const visit = (dependentNode, dependentName, siblingDependents) => {
      if (seen.has(dependentNode)) {
        return;
      }
      seen.add(dependentNode);
      if (dependentNode === currentNode || siblingDependents.has(currentNode.name)) {
        return;
      }
      collected.add(dependentNode);
      queue2.push(dependentNode);
    };
    while (queue2.length) {
      const node = queue2.shift();
      node.localDependents.forEach(visit);
    }
  });
  return collected;
}
var init_collect_dependents = __esm({
  "libs/legacy-core/src/lib/collect-updates/collect-dependents.ts"() {
    "use strict";
  }
});

// libs/legacy-core/src/lib/collect-updates/collect-packages.ts
function collectPackages(packages, { isCandidate = () => true, onInclude, excludeDependents } = {}) {
  const candidates = /* @__PURE__ */ new Set();
  packages.forEach((node, name) => {
    if (isCandidate(node, name)) {
      candidates.add(node);
    }
  });
  if (!excludeDependents) {
    collectDependents2(candidates).forEach((node) => candidates.add(node));
  }
  const updates = [];
  packages.forEach((node, name) => {
    if (candidates.has(node)) {
      if (onInclude) {
        onInclude(name);
      }
      updates.push(node);
    }
  });
  return updates;
}
var init_collect_packages = __esm({
  "libs/legacy-core/src/lib/collect-updates/collect-packages.ts"() {
    "use strict";
    init_collect_dependents();
  }
});

// libs/legacy-core/src/lib/collect-updates/has-tags.ts
function hasTags2(opts) {
  import_npmlog36.default.silly("hasTags");
  let result = false;
  try {
    result = !!childProcess10.execSync("git", ["tag"], opts);
  } catch (err) {
    import_npmlog36.default.warn("ENOTAGS", "No git tags were reachable from this branch!");
    import_npmlog36.default.verbose("hasTags error", err);
  }
  import_npmlog36.default.verbose("hasTags", result);
  return result;
}
var import_npmlog36, childProcess10;
var init_has_tags2 = __esm({
  "libs/legacy-core/src/lib/collect-updates/has-tags.ts"() {
    "use strict";
    import_npmlog36 = __toESM(require("npmlog"));
    childProcess10 = require("@lerna/child-process");
  }
});

// libs/legacy-core/src/lib/collect-updates/make-diff-predicate.ts
function makeDiffPredicate2(committish, execOpts, ignorePatterns = []) {
  const ignoreFilters = new Set(
    ignorePatterns.map(
      (p) => import_minimatch3.default.filter(`!${p}`, {
        matchBase: true,
        // dotfiles inside ignored directories should also match
        dot: true
      })
    )
  );
  if (ignoreFilters.size) {
    import_npmlog37.default.info("ignoring diff in paths matching", ignorePatterns);
  }
  return function hasDiffSinceThatIsntIgnored(node) {
    const diff = diffSinceIn2(committish, node.location, execOpts);
    if (diff === "") {
      import_npmlog37.default.silly("", "no diff found in %s", node.name);
      return false;
    }
    import_npmlog37.default.silly("found diff in", diff);
    let changedFiles = diff.split("\n");
    if (ignoreFilters.size) {
      for (const ignored of ignoreFilters) {
        changedFiles = changedFiles.filter(ignored);
      }
    }
    if (changedFiles.length) {
      import_npmlog37.default.verbose("filtered diff", changedFiles);
    } else {
      import_npmlog37.default.verbose("", "no diff found in %s (after filtering)", node.name);
    }
    return changedFiles.length > 0;
  };
}
function diffSinceIn2(committish, location, opts) {
  const args = ["diff", "--name-only", committish];
  const formattedLocation = (0, import_slash2.default)(import_path19.default.relative(opts.cwd, location));
  if (formattedLocation) {
    args.push("--", formattedLocation);
  }
  import_npmlog37.default.silly("checking diff", formattedLocation);
  return childProcess11.execSync("git", args, opts);
}
var import_minimatch3, import_npmlog37, import_path19, import_slash2, childProcess11;
var init_make_diff_predicate2 = __esm({
  "libs/legacy-core/src/lib/collect-updates/make-diff-predicate.ts"() {
    "use strict";
    import_minimatch3 = __toESM(require("minimatch"));
    import_npmlog37 = __toESM(require("npmlog"));
    import_path19 = __toESM(require("path"));
    import_slash2 = __toESM(require("slash"));
    childProcess11 = require("@lerna/child-process");
  }
});

// libs/legacy-core/src/lib/collect-updates/index.ts
function collectUpdates(filteredPackages, packageGraph, execOpts, commandOptions) {
  const { forcePublish, conventionalCommits, conventionalGraduate, excludeDependents } = commandOptions;
  const useConventionalGraduate = conventionalCommits && conventionalGraduate;
  const forced = getPackagesForOption(useConventionalGraduate ? conventionalGraduate : forcePublish);
  const packages = filteredPackages.length === packageGraph.size ? packageGraph : new Map(filteredPackages.map(({ name }) => [name, packageGraph.get(name)]));
  let committish = commandOptions.since;
  if (hasTags2(execOpts)) {
    const { sha, refCount, lastTagName } = describeRefSync(execOpts, commandOptions.includeMergedTags);
    if (refCount === "0" && forced.size === 0 && !committish) {
      import_npmlog38.default.notice("", "Current HEAD is already released, skipping change detection.");
      return [];
    }
    if (commandOptions.canary) {
      committish = `${sha}^..${sha}`;
    } else if (!committish) {
      committish = lastTagName;
    }
  }
  if (forced.size) {
    import_npmlog38.default.warn(
      useConventionalGraduate ? "conventional-graduate" : "force-publish",
      forced.has("*") ? "all packages" : Array.from(forced.values()).join("\n")
    );
  }
  if (useConventionalGraduate) {
    if (forced.has("*")) {
      import_npmlog38.default.info("", "Graduating all prereleased packages");
    } else {
      import_npmlog38.default.info("", "Graduating prereleased packages");
    }
  } else if (!committish || forced.has("*")) {
    import_npmlog38.default.info("", "Assuming all packages changed");
    return collectPackages(packages, {
      onInclude: (name) => import_npmlog38.default.verbose("updated", name),
      excludeDependents
    });
  }
  import_npmlog38.default.info("", `Looking for changed packages since ${committish}`);
  const hasDiff = makeDiffPredicate2(committish, execOpts, commandOptions.ignoreChanges);
  const needsBump = !commandOptions.bump || commandOptions.bump.startsWith("pre") ? () => false : (
    /* skip packages that have not been previously prereleased */
    // TODO: refactor to address type issues
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    (node) => node.prereleaseId
  );
  const isForced = (node, name) => (forced.has("*") || forced.has(name)) && (useConventionalGraduate ? node.prereleaseId : true);
  return collectPackages(packages, {
    // TODO: refactor to address type issues
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    isCandidate: (node, name) => isForced(node, name) || needsBump(node) || hasDiff(node),
    onInclude: (name) => import_npmlog38.default.verbose("updated", name),
    excludeDependents
  });
}
var import_npmlog38;
var init_collect_updates2 = __esm({
  "libs/legacy-core/src/lib/collect-updates/index.ts"() {
    "use strict";
    init_src();
    init_describe_ref();
    import_npmlog38 = __toESM(require("npmlog"));
    init_collect_packages();
    init_has_tags2();
    init_make_diff_predicate2();
  }
});

// libs/legacy-core/src/lib/package-graph/cyclic-package-graph-node.ts
var lastCollapsedNodeId, CyclicPackageGraphNode;
var init_cyclic_package_graph_node = __esm({
  "libs/legacy-core/src/lib/package-graph/cyclic-package-graph-node.ts"() {
    "use strict";
    lastCollapsedNodeId = 0;
    CyclicPackageGraphNode = class extends Map {
      name;
      localDependencies;
      localDependents;
      constructor() {
        super();
        this.name = `(cycle) ${lastCollapsedNodeId += 1}`;
        this.localDependencies = /* @__PURE__ */ new Map();
        this.localDependents = /* @__PURE__ */ new Map();
      }
      // eslint-disable-next-line class-methods-use-this
      get isCycle() {
        return true;
      }
      /**
       * @returns A representation of a cycle, like like `A -> B -> C -> A`.
       */
      toString() {
        const parts = Array.from(
          this,
          ([key, node]) => (
            // TODO: refactor to address type issues
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            node.isCycle ? `(nested cycle: ${node.toString()})` : key
          )
        );
        parts.push(parts[0]);
        return parts.reverse().join(" -> ");
      }
      /**
       * Flattens a CyclicPackageGraphNode (which can have multiple level of cycles).
       */
      flatten() {
        const result = [];
        for (const node of this.values()) {
          if (node.isCycle) {
            result.push(...node.flatten());
          } else {
            result.push(node);
          }
        }
        return result;
      }
      /**
       * Checks if a given node is contained in this cycle (or in a nested one)
       *
       * @param name The name of the package to search in this cycle
       */
      contains(name) {
        for (const [currentName, currentNode] of this) {
          if (currentNode.isCycle) {
            if (currentNode.contains(name)) {
              return true;
            }
          } else if (currentName === name) {
            return true;
          }
        }
        return false;
      }
      /**
       * Adds a graph node, or a nested cycle, to this group.
       */
      insert(node) {
        this.set(node.name, node);
        this.unlink(node);
        for (const [dependencyName, dependencyNode] of node.localDependencies) {
          if (!this.contains(dependencyName)) {
            this.localDependencies.set(dependencyName, dependencyNode);
          }
        }
        for (const [dependentName, dependentNode] of node.localDependents) {
          if (!this.contains(dependentName)) {
            this.localDependents.set(dependentName, dependentNode);
          }
        }
      }
      /**
       * Remove pointers to candidate node from internal collections.
       * @param candidateNode instance to unlink
       */
      unlink(candidateNode) {
        this.localDependencies.delete(candidateNode.name);
        this.localDependents.delete(candidateNode.name);
      }
    };
  }
});

// libs/legacy-core/src/lib/package-graph/package-graph-node.ts
var import_semver5, PKG2, PackageGraphNode;
var init_package_graph_node = __esm({
  "libs/legacy-core/src/lib/package-graph/package-graph-node.ts"() {
    "use strict";
    init_src();
    import_semver5 = __toESM(require("semver"));
    PKG2 = Symbol("pkg");
    PackageGraphNode = class {
      name;
      externalDependencies;
      localDependencies;
      localDependents;
      [PKG2];
      constructor(pkg2) {
        this.name = pkg2.name;
        this[PKG2] = pkg2;
        Object.defineProperty(this, PKG2, { enumerable: false });
        this.externalDependencies = /* @__PURE__ */ new Map();
        this.localDependencies = /* @__PURE__ */ new Map();
        this.localDependents = /* @__PURE__ */ new Map();
      }
      get location() {
        return this[PKG2].location;
      }
      get pkg() {
        return this[PKG2];
      }
      get prereleaseId() {
        return prereleaseIdFromVersion(this.version);
      }
      get version() {
        return this[PKG2].version;
      }
      /**
       * Determine if the Node satisfies a resolved semver range.
       * @see https://github.com/npm/npm-package-arg#result-object
       *
       * @param {!Result} resolved npm-package-arg Result object
       */
      satisfies({ gitCommittish, gitRange, fetchSpec }) {
        return import_semver5.default.satisfies(this.version, gitCommittish || gitRange || fetchSpec);
      }
      /**
       * Returns a string representation of this node (its name)
       *
       * @returns {String}
       */
      toString() {
        return this.name;
      }
    };
  }
});

// libs/legacy-core/src/lib/package-graph/report-cycles.ts
function reportCycles2(paths, rejectCycles) {
  if (!paths.length) {
    return;
  }
  const cycleMessage = ["Dependency cycles detected, you should fix these!"].concat(paths).join("\n");
  if (rejectCycles) {
    throw new ValidationError("ECYCLE", cycleMessage);
  }
  import_npmlog39.default.warn("ECYCLE", cycleMessage);
}
var import_npmlog39;
var init_report_cycles2 = __esm({
  "libs/legacy-core/src/lib/package-graph/report-cycles.ts"() {
    "use strict";
    init_src();
    import_npmlog39 = __toESM(require("npmlog"));
  }
});

// libs/legacy-core/src/lib/package-graph/index.ts
var import_npm_package_arg7, PackageGraph;
var init_package_graph = __esm({
  "libs/legacy-core/src/lib/package-graph/index.ts"() {
    "use strict";
    init_src();
    import_npm_package_arg7 = __toESM(require("npm-package-arg"));
    init_cyclic_package_graph_node();
    init_package_graph_node();
    init_report_cycles2();
    PackageGraph = class extends Map {
      /**
       * @param {import("@lerna/package").Package[]} packages An array of Packages to build the graph out of.
       * @param {'allDependencies'|'dependencies'} [graphType]
       *    Pass "dependencies" to create a graph of only dependencies,
       *    excluding the devDependencies that would normally be included.
       * @param {boolean} [forceLocal] Force all local dependencies to be linked.
       */
      constructor(packages, graphType = "allDependencies", forceLocal) {
        super(packages.map((pkg2) => [pkg2.name, new PackageGraphNode(pkg2)]));
        if (packages.length !== this.size) {
          const seen = /* @__PURE__ */ new Map();
          for (const { name, location } of packages) {
            if (seen.has(name)) {
              seen.get(name).push(location);
            } else {
              seen.set(name, [location]);
            }
          }
          for (const [name, locations] of seen) {
            if (locations.length > 1) {
              throw new ValidationError(
                "ENAME",
                [`Package name "${name}" used in multiple packages:`, ...locations].join("\n	")
              );
            }
          }
        }
        this.forEach((currentNode, currentName) => {
          const graphDependencies = graphType === "dependencies" ? Object.assign({}, currentNode.pkg.optionalDependencies, currentNode.pkg.dependencies) : Object.assign(
            {},
            currentNode.pkg.devDependencies,
            currentNode.pkg.optionalDependencies,
            currentNode.pkg.dependencies
          );
          Object.keys(graphDependencies).forEach((depName) => {
            const depNode = this.get(depName);
            let spec = graphDependencies[depName].replace(/^link:/, "file:");
            const isWorkspaceSpec = /^workspace:/.test(spec);
            let fullWorkspaceSpec;
            let workspaceAlias;
            if (isWorkspaceSpec) {
              fullWorkspaceSpec = spec;
              spec = spec.replace(/^workspace:/, "");
              if (spec === "*" || spec === "^" || spec === "~") {
                workspaceAlias = spec;
                if (depNode?.version) {
                  const prefix = spec === "*" ? "" : spec;
                  const version = depNode.version;
                  spec = `${prefix}${version}`;
                } else {
                  spec = "*";
                }
              }
            }
            const resolved = import_npm_package_arg7.default.resolve(depName, spec, currentNode.location);
            resolved.workspaceSpec = fullWorkspaceSpec;
            resolved.workspaceAlias = workspaceAlias;
            if (!depNode) {
              return currentNode.externalDependencies.set(depName, resolved);
            }
            if (forceLocal || resolved.fetchSpec === depNode.location || depNode.satisfies(resolved)) {
              currentNode.localDependencies.set(depName, resolved);
              depNode.localDependents.set(currentName, currentNode);
            } else {
              if (isWorkspaceSpec) {
                throw new ValidationError(
                  "EWORKSPACE",
                  `Package specification "${depName}@${spec}" could not be resolved within the workspace. To reference a non-matching, remote version of a local dependency, remove the 'workspace:' prefix.`
                );
              }
              currentNode.externalDependencies.set(depName, resolved);
            }
          });
        });
      }
      get rawPackageList() {
        return Array.from(this.values()).map((node) => node.pkg);
      }
      /**
       * Takes a list of Packages and returns a list of those same Packages with any Packages
       * they depend on. i.e if packageA depended on packageB `graph.addDependencies([packageA])`
       * would return [packageA, packageB].
       *
       * @param filteredPackages The packages to include dependencies for.
       */
      addDependencies(filteredPackages) {
        return this.extendList(filteredPackages, "localDependencies");
      }
      /**
       * Takes a list of Packages and returns a list of those same Packages with any Packages
       * that depend on them. i.e if packageC depended on packageD `graph.addDependents([packageD])`
       * would return [packageD, packageC].
       *
       * @param filteredPackages The packages to include dependents for.
       */
      addDependents(filteredPackages) {
        return this.extendList(filteredPackages, "localDependents");
      }
      /**
       * Extends a list of packages by traversing on a given property, which must refer to a
       * `PackageGraphNode` property that is a collection of `PackageGraphNode`s.
       * Returns input packages with any additional packages found by traversing `nodeProp`.
       *
       * @param packageList The list of packages to extend
       * @param nodeProp The property on `PackageGraphNode` used to traverse
       */
      extendList(packageList, nodeProp) {
        const search = new Set(packageList.map(({ name }) => this.get(name)));
        const result = [];
        search.forEach((currentNode) => {
          result.push(currentNode);
          currentNode[nodeProp].forEach((meta, depName) => {
            const depNode = this.get(depName);
            if (depNode !== currentNode && !search.has(depNode)) {
              search.add(depNode);
            }
          });
        });
        return result.map((node) => node.pkg);
      }
      /**
       * Return a tuple of cycle paths and nodes.
       *
       * @deprecated Use collapseCycles instead.
       *
       * @param  rejectCycles Whether or not to reject cycles
       */
      partitionCycles(rejectCycles) {
        const cyclePaths = /* @__PURE__ */ new Set();
        const cycleNodes = /* @__PURE__ */ new Set();
        this.forEach((currentNode, currentName) => {
          const seen = /* @__PURE__ */ new Set();
          const visits = (walk) => (dependentNode, dependentName, siblingDependents) => {
            const step = walk.concat(dependentName);
            if (seen.has(dependentNode)) {
              return;
            }
            seen.add(dependentNode);
            if (dependentNode === currentNode) {
              cycleNodes.add(currentNode);
              cyclePaths.add(step);
              return;
            }
            if (siblingDependents.has(currentName)) {
              const cycleDependentName = Array.from(dependentNode.localDependencies.keys()).find(
                (key) => currentNode.localDependents.has(key)
              );
              const pathToCycle = step.slice().reverse().concat(cycleDependentName);
              cycleNodes.add(dependentNode);
              cyclePaths.add(pathToCycle);
            }
            dependentNode.localDependents.forEach(visits(step));
          };
          currentNode.localDependents.forEach(visits([currentName]));
        });
        reportCycles2(
          Array.from(cyclePaths, (cycle) => cycle.join(" -> ")),
          rejectCycles
        );
        return [cyclePaths, cycleNodes];
      }
      /**
       * Returns the cycles of this graph. If two cycles share some elements, they will
       * be returned as a single cycle.
       *
       * @param {boolean} rejectCycles Whether or not to reject cycles
       * @returns {Set<CyclicPackageGraphNode>}
       */
      collapseCycles(rejectCycles) {
        const cyclePaths = [];
        const nodeToCycle = /* @__PURE__ */ new Map();
        const cycles = /* @__PURE__ */ new Set();
        const walkStack = [];
        const alreadyVisited = /* @__PURE__ */ new Set();
        function visits(baseNode, dependentNode) {
          if (nodeToCycle.has(baseNode)) {
            return;
          }
          let topLevelDependent = dependentNode;
          while (nodeToCycle.has(topLevelDependent)) {
            topLevelDependent = nodeToCycle.get(topLevelDependent);
          }
          const identifier = `${baseNode.name}:${topLevelDependent.name}`;
          if (alreadyVisited.has(identifier)) {
            return;
          }
          alreadyVisited.add(identifier);
          if (topLevelDependent === baseNode || topLevelDependent.isCycle && topLevelDependent.has(baseNode.name)) {
            const cycle = new CyclicPackageGraphNode();
            walkStack.forEach((nodeInCycle) => {
              nodeToCycle.set(nodeInCycle, cycle);
              cycle.insert(nodeInCycle);
              cycles.delete(nodeInCycle);
            });
            cycles.add(cycle);
            cyclePaths.push(cycle.toString());
            return;
          }
          if (walkStack.indexOf(topLevelDependent) === -1) {
            visitWithStack(baseNode, topLevelDependent);
          }
        }
        function visitWithStack(baseNode, currentNode = baseNode) {
          walkStack.push(currentNode);
          currentNode.localDependents.forEach(visits.bind(null, baseNode));
          walkStack.pop();
        }
        this.forEach((currentNode) => visitWithStack(currentNode));
        cycles.forEach((collapsedNode) => visitWithStack(collapsedNode));
        reportCycles2(cyclePaths, rejectCycles);
        return cycles;
      }
      /**
       * Remove cycle nodes.
       *
       * @deprecated Spread set into prune() instead.
       */
      pruneCycleNodes(cycleNodes) {
        return this.prune(...cycleNodes);
      }
      /**
       * Remove all candidate nodes.
       */
      prune(...candidates) {
        if (candidates.length === this.size) {
          return this.clear();
        }
        candidates.forEach((node) => this.remove(node));
      }
      /**
       * Delete by value (instead of key), as well as removing pointers
       * to itself in the other node's internal collections.
       * @param candidateNode instance to remove
       */
      remove(candidateNode) {
        this.delete(candidateNode.name);
        this.forEach((node) => {
          node.localDependencies.delete(candidateNode.name);
          node.localDependents.delete(candidateNode.name);
        });
      }
    };
  }
});

// libs/legacy-core/src/lib/write-log-file.ts
function writeLogFile2(cwd) {
  let logOutput = "";
  import_npmlog40.default.record.forEach((m) => {
    let pref = [m.id, m.level];
    if (m.prefix) {
      pref.push(m.prefix);
    }
    pref = pref.join(" ");
    m.message.trim().split(/\r?\n/).map((line) => `${pref} ${line}`.trim()).forEach((line) => {
      logOutput += line + import_os4.default.EOL;
    });
  });
  import_write_file_atomic2.default.sync(import_path20.default.join(cwd, "lerna-debug.log"), logOutput);
  import_npmlog40.default.record.length = 0;
}
var import_npmlog40, import_os4, import_path20, import_write_file_atomic2;
var init_write_log_file2 = __esm({
  "libs/legacy-core/src/lib/write-log-file.ts"() {
    "use strict";
    import_npmlog40 = __toESM(require("npmlog"));
    import_os4 = __toESM(require("os"));
    import_path20 = __toESM(require("path"));
    import_write_file_atomic2 = __toESM(require("write-file-atomic"));
  }
});

// libs/legacy-core/src/lib/command/clean-stack.ts
function cleanStack2(err, className) {
  const lines = isErrorWithStack2(err) ? err.stack.split("\n") : String(err).split("\n");
  const cutoff = new RegExp(`^    at ${className}.runCommand .*$`);
  const relevantIndex = lines.findIndex((line) => cutoff.test(line));
  if (relevantIndex) {
    return lines.slice(0, relevantIndex).join("\n");
  }
  return err.toString();
}
function isErrorWithStack2(err) {
  return err.stack !== void 0;
}
var init_clean_stack2 = __esm({
  "libs/legacy-core/src/lib/command/clean-stack.ts"() {
    "use strict";
  }
});

// libs/legacy-core/src/lib/command/default-options.ts
function defaultOptions2(...sources) {
  const options = {};
  for (const source of sources) {
    if (source != null) {
      for (const key of Object.keys(source)) {
        if (options[key] === void 0) {
          options[key] = source[key];
        }
      }
    }
  }
  return options;
}
var init_default_options2 = __esm({
  "libs/legacy-core/src/lib/command/default-options.ts"() {
    "use strict";
  }
});

// libs/legacy-core/src/lib/command/log-package-error.ts
function logPackageError2(err, stream = false) {
  import_npmlog41.default.error(err.command, `exited ${err.exitCode} in '${err.pkg.name}'`);
  if (stream) {
    return;
  }
  if (err.stdout) {
    import_npmlog41.default.error(err.command, "stdout:");
    directLog2(err.stdout);
  }
  if (err.stderr) {
    import_npmlog41.default.error(err.command, "stderr:");
    directLog2(err.stderr);
  }
  import_npmlog41.default.error(err.command, `exited ${err.exitCode} in '${err.pkg.name}'`);
}
function directLog2(message) {
  import_npmlog41.default.pause();
  console.error(message);
  import_npmlog41.default.resume();
}
var import_npmlog41;
var init_log_package_error2 = __esm({
  "libs/legacy-core/src/lib/command/log-package-error.ts"() {
    "use strict";
    import_npmlog41 = __toESM(require("npmlog"));
  }
});

// libs/legacy-core/src/lib/command/warn-if-hanging.ts
function warnIfHanging2() {
  const childProcessCount = childProcess12.getChildProcessCount();
  if (childProcessCount > 0) {
    import_npmlog42.default.warn(
      "complete",
      `Waiting for ${childProcessCount} child process${childProcessCount === 1 ? "" : "es"} to exit. CTRL-C to exit immediately.`
    );
  }
}
var import_npmlog42, childProcess12;
var init_warn_if_hanging2 = __esm({
  "libs/legacy-core/src/lib/command/warn-if-hanging.ts"() {
    "use strict";
    import_npmlog42 = __toESM(require("npmlog"));
    childProcess12 = require("@lerna/child-process");
  }
});

// libs/legacy-core/src/lib/command/index.ts
var import_clone_deep2, import_dedent5, import_execa2, import_npmlog43, import_os5, DEFAULT_CONCURRENCY2, Command2;
var init_command2 = __esm({
  "libs/legacy-core/src/lib/command/index.ts"() {
    "use strict";
    init_src();
    import_clone_deep2 = __toESM(require("clone-deep"));
    import_dedent5 = __toESM(require("dedent"));
    import_execa2 = __toESM(require("execa"));
    import_npmlog43 = __toESM(require("npmlog"));
    import_os5 = __toESM(require("os"));
    init_package_graph();
    init_write_log_file2();
    init_clean_stack2();
    init_default_options2();
    init_log_package_error2();
    init_warn_if_hanging2();
    DEFAULT_CONCURRENCY2 = import_os5.default.cpus().length;
    Command2 = class {
      name;
      composed;
      options = {};
      runner;
      concurrency;
      toposort = false;
      execOpts;
      packageGraph;
      logger;
      _project;
      get project() {
        if (this._project === void 0) {
          throw new ValidationError("ENOPROJECT", "Lerna Project not initialized!");
        }
        return this._project;
      }
      set project(project) {
        this._project = project;
      }
      constructor(_argv, { skipValidations } = { skipValidations: false }) {
        import_npmlog43.default.pause();
        import_npmlog43.default.heading = "lerna";
        const argv = (0, import_clone_deep2.default)(_argv);
        import_npmlog43.default.silly("argv", argv);
        this.name = this.constructor.name.replace(/Command$/, "").toLowerCase();
        this.composed = typeof argv.composed === "string" && argv.composed !== this.name;
        if (!this.composed) {
          import_npmlog43.default.notice("cli", `v${argv.lernaVersion}`);
        }
        let runner = new Promise((resolve3, reject) => {
          let chain = Promise.resolve();
          chain = chain.then(() => {
            this.project = new Project(argv.cwd);
          });
          chain = chain.then(() => this.configureEnvironment());
          chain = chain.then(() => this.configureOptions());
          chain = chain.then(() => this.configureProperties());
          chain = chain.then(() => this.configureLogging());
          if (!skipValidations) {
            chain = chain.then(() => this.runValidations());
          }
          chain = chain.then(() => this.runPreparations());
          chain = chain.then(() => this.runCommand());
          chain.then(
            (result) => {
              warnIfHanging2();
              resolve3(result);
            },
            (err) => {
              if (err.pkg) {
                logPackageError2(err, this.options.stream);
              } else if (err.name !== "ValidationError") {
                import_npmlog43.default.error("", cleanStack2(err, this.constructor.name));
              }
              if (err.name !== "ValidationError" && !err.pkg) {
                writeLogFile2(this.project.rootPath);
              }
              warnIfHanging2();
              reject(err);
            }
          );
        });
        if (argv.onResolved || argv.onRejected) {
          runner = runner.then(argv.onResolved, argv.onRejected);
          delete argv.onResolved;
          delete argv.onRejected;
        }
        for (const key of ["cwd", "$0"]) {
          Object.defineProperty(argv, key, { enumerable: false });
        }
        Object.defineProperty(this, "argv", {
          value: Object.freeze(argv)
        });
        this.runner = runner;
      }
      // proxy "Promise" methods to "private" instance
      then(onResolved, onRejected) {
        return this.runner.then(onResolved, onRejected);
      }
      /* istanbul ignore next */
      catch(onRejected) {
        return this.runner.catch(onRejected);
      }
      get requiresGit() {
        return true;
      }
      // Override this to inherit config from another command.
      // For example `changed` inherits config from `publish`.
      get otherCommandConfigs() {
        return [];
      }
      configureEnvironment() {
        const ci = require("is-ci");
        let loglevel;
        let progress;
        if (ci || !process.stderr.isTTY) {
          import_npmlog43.default.disableColor();
          progress = false;
        } else if (!process.stdout.isTTY) {
          progress = false;
          loglevel = "error";
        } else if (process.stderr.isTTY) {
          import_npmlog43.default.enableColor();
          import_npmlog43.default.enableUnicode();
        }
        Object.defineProperty(this, "envDefaults", {
          value: {
            ci,
            progress,
            loglevel
          }
        });
      }
      configureOptions() {
        const commandConfig = this.project.config.command || {};
        const overrides = [this.name, ...this.otherCommandConfigs].map((key) => commandConfig[key]);
        this.options = defaultOptions2(
          // CLI flags, which if defined overrule subsequent values
          this.argv,
          ...overrides,
          // Global options from `lerna.json`
          this.project.config,
          // Environmental defaults prepared in previous step
          this.envDefaults
        );
        if (this.options.verbose && this.options.loglevel !== "silly") {
          this.options.loglevel = "verbose";
        }
      }
      argv(argv, arg1, config, envDefaults) {
        throw new Error("Method not implemented.");
      }
      envDefaults(argv, arg1, config, envDefaults) {
        throw new Error("Method not implemented.");
      }
      configureProperties() {
        const { concurrency = 0, sort, maxBuffer } = this.options;
        this.concurrency = Math.max(1, +concurrency || DEFAULT_CONCURRENCY2);
        this.toposort = sort === void 0 || sort;
        this.execOpts = {
          cwd: this.project.rootPath,
          maxBuffer
        };
      }
      configureLogging() {
        const { loglevel } = this.options;
        if (loglevel) {
          import_npmlog43.default.level = loglevel;
        }
        import_npmlog43.default.addLevel("success", 3001, { fg: "green", bold: true });
        Object.defineProperty(this, "logger", {
          value: import_npmlog43.default["newGroup"](this.name)
        });
        import_npmlog43.default.resume();
      }
      enableProgressBar() {
        if (this.options.progress !== false) {
          import_npmlog43.default.enableProgress();
        }
      }
      gitInitialized() {
        const opts = {
          cwd: this.project.rootPath,
          // don't throw, just want boolean
          reject: false,
          // only return code, no stdio needed
          stdio: "ignore"
        };
        return import_execa2.default.sync("git", ["rev-parse"], opts).exitCode === 0;
      }
      runValidations() {
        if ((this.options.since !== void 0 || this.requiresGit) && !this.gitInitialized()) {
          throw new ValidationError("ENOGIT", "The git binary was not found, or this is not a git repository.");
        }
        if (this.options.independent && !this.project.isIndependent()) {
          throw new ValidationError(
            "EVERSIONMODE",
            import_dedent5.default`
          You ran lerna with --independent or -i, but the repository is not set to independent mode.
          To use independent mode you need to set lerna.json's "version" property to "independent".
          Then you won't need to pass the --independent or -i flags.
        `
          );
        }
      }
      runPreparations() {
        if (!this.composed && this.project.isIndependent()) {
          import_npmlog43.default.info("versioning", "independent");
        }
        if (!this.composed && this.options.ci) {
          import_npmlog43.default.info("ci", "enabled");
        }
        let chain = Promise.resolve();
        chain = chain.then(() => this.project.getPackages());
        chain = chain.then((packages) => {
          this.packageGraph = new PackageGraph(packages);
        });
        return chain;
      }
      runCommand() {
        return Promise.resolve().then(() => this.initialize()).then((proceed) => {
          if (proceed !== false) {
            return this.execute();
          }
        });
      }
      initialize() {
        throw new ValidationError(this.name, "initialize() needs to be implemented.");
      }
      execute() {
        throw new ValidationError(this.name, "execute() needs to be implemented.");
      }
    };
  }
});

// libs/legacy-core/src/lib/create-symlink.ts
var import_cmd_shim, import_fs_extra8, import_npmlog44;
var init_create_symlink = __esm({
  "libs/legacy-core/src/lib/create-symlink.ts"() {
    "use strict";
    import_cmd_shim = __toESM(require("cmd-shim"));
    import_fs_extra8 = __toESM(require("fs-extra"));
    import_npmlog44 = __toESM(require("npmlog"));
  }
});

// libs/legacy-core/src/lib/filter-packages.ts
function filterPackages(packagesToFilter, include = [], exclude = [], showPrivate, continueIfNoMatch) {
  const filtered = new Set(packagesToFilter);
  const patterns = [].concat(arrify2(include), negate2(exclude));
  if (showPrivate === false) {
    for (const pkg2 of filtered) {
      if (pkg2.private) {
        filtered.delete(pkg2);
      }
    }
  }
  if (patterns.length) {
    import_npmlog45.default.info("filter", patterns);
    if (!include.length) {
      patterns.unshift("**");
    }
    const pnames = Array.from(filtered).map((pkg2) => pkg2.name);
    const chosen = new Set((0, import_multimatch2.default)(pnames, patterns));
    for (const pkg2 of filtered) {
      if (!chosen.has(pkg2.name)) {
        filtered.delete(pkg2);
      }
    }
    if (!filtered.size && !continueIfNoMatch) {
      throw new ValidationError("EFILTER", import_util3.default.format("No packages remain after filtering", patterns));
    }
  }
  return Array.from(filtered);
}
function arrify2(thing) {
  if (!thing) {
    return [];
  }
  if (!Array.isArray(thing)) {
    return [thing];
  }
  return thing;
}
function negate2(patterns) {
  return arrify2(patterns).map((pattern) => `!${pattern}`);
}
var import_multimatch2, import_npmlog45, import_util3;
var init_filter_packages = __esm({
  "libs/legacy-core/src/lib/filter-packages.ts"() {
    "use strict";
    init_src();
    import_multimatch2 = __toESM(require("multimatch"));
    import_npmlog45 = __toESM(require("npmlog"));
    import_util3 = __toESM(require("util"));
  }
});

// libs/legacy-core/src/lib/get-filtered-packages.ts
function getFilteredPackages(packageGraph, execOpts, opts) {
  const options = { log: import_npmlog46.default, ...opts };
  if (options.scope) {
    options.log.notice("filter", "including %j", options.scope);
  }
  if (options.ignore) {
    options.log.notice("filter", "excluding %j", options.ignore);
  }
  let chain = Promise.resolve();
  chain = chain.then(
    () => filterPackages(
      packageGraph.rawPackageList,
      // TODO: refactor to address type issues
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      options.scope,
      options.ignore,
      options.private,
      options.continueIfNoMatch
    )
  );
  if (options.since !== void 0) {
    options.log.notice("filter", "changed since %j", options.since);
    if (options.excludeDependents) {
      options.log.notice("filter", "excluding dependents");
    }
    if (options.includeMergedTags) {
      options.log.notice("filter", "including merged tags");
    }
    chain = chain.then(
      (filteredPackages) => (
        // TODO: refactor to address type issues
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        Promise.resolve(collectUpdates(filteredPackages, packageGraph, execOpts, opts)).then((updates) => {
          const updated = new Set(updates.map(({ pkg: pkg2 }) => pkg2.name));
          return filteredPackages.filter((pkg2) => updated.has(pkg2.name));
        })
      )
    );
  }
  if (options.includeDependents) {
    options.log.notice("filter", "including dependents");
    chain = chain.then((filteredPackages) => packageGraph.addDependents(filteredPackages));
  }
  if (options.includeDependencies) {
    options.log.notice("filter", "including dependencies");
    chain = chain.then((filteredPackages) => packageGraph.addDependencies(filteredPackages));
  }
  return chain;
}
var import_npmlog46;
var init_get_filtered_packages = __esm({
  "libs/legacy-core/src/lib/get-filtered-packages.ts"() {
    "use strict";
    import_npmlog46 = __toESM(require("npmlog"));
    init_collect_updates2();
    init_filter_packages();
  }
});

// libs/legacy-core/src/lib/query-graph.ts
var QueryGraph, toposort;
var init_query_graph = __esm({
  "libs/legacy-core/src/lib/query-graph.ts"() {
    "use strict";
    init_package_graph();
    QueryGraph = class {
      graph;
      cycles;
      /**
       * Sort a list of Packages topologically.
       * @returns A list of Package instances in topological order
       */
      static toposort(packages, options) {
        const graph = new QueryGraph(packages, options);
        const result = [];
        let batch = graph.getAvailablePackages();
        while (batch.length) {
          for (const node of batch) {
            result.push(node.pkg);
            graph.markAsDone(node);
          }
          batch = graph.getAvailablePackages();
        }
        return result;
      }
      constructor(packages, { graphType = "allDependencies", rejectCycles } = {}) {
        this.graph = new PackageGraph(packages, graphType);
        this.cycles = this.graph.collapseCycles(rejectCycles);
      }
      _getNextLeaf() {
        return Array.from(this.graph.values()).filter((node) => node.localDependencies.size === 0);
      }
      _getNextCycle() {
        const cycle = Array.from(this.cycles).find((cycleNode) => cycleNode.localDependencies.size === 0);
        if (!cycle) {
          return [];
        }
        this.cycles.delete(cycle);
        return cycle.flatten();
      }
      getAvailablePackages() {
        const availablePackages = this._getNextLeaf();
        if (availablePackages.length > 0) {
          return availablePackages;
        }
        return this._getNextCycle();
      }
      markAsTaken(name) {
        this.graph.delete(name);
      }
      markAsDone(candidateNode) {
        this.graph.remove(candidateNode);
        for (const cycle of this.cycles) {
          cycle.unlink(candidateNode);
        }
      }
    };
    toposort = QueryGraph.toposort;
  }
});

// libs/legacy-core/src/lib/listable-format.ts
var import_chalk3, import_columnify3;
var init_listable_format = __esm({
  "libs/legacy-core/src/lib/listable-format.ts"() {
    "use strict";
    import_chalk3 = __toESM(require("chalk"));
    import_columnify3 = __toESM(require("columnify"));
    init_query_graph();
  }
});

// libs/legacy-core/src/lib/run-topologically.ts
var import_p_queue3;
var init_run_topologically = __esm({
  "libs/legacy-core/src/lib/run-topologically.ts"() {
    "use strict";
    import_p_queue3 = __toESM(require("p-queue"));
    init_query_graph();
  }
});

// libs/legacy-core/src/lib/symlink-binary/index.ts
var import_fs_extra9, import_p_map3;
var init_symlink_binary = __esm({
  "libs/legacy-core/src/lib/symlink-binary/index.ts"() {
    "use strict";
    init_src();
    import_fs_extra9 = __toESM(require("fs-extra"));
    import_p_map3 = __toESM(require("p-map"));
    init_create_symlink();
  }
});

// libs/legacy-core/src/lib/resolve-symlink.ts
var import_fs_extra10, import_npmlog47, readCmdShim;
var init_resolve_symlink = __esm({
  "libs/legacy-core/src/lib/resolve-symlink.ts"() {
    "use strict";
    import_fs_extra10 = __toESM(require("fs-extra"));
    import_npmlog47 = __toESM(require("npmlog"));
    readCmdShim = require("read-cmd-shim");
  }
});

// libs/legacy-core/src/lib/symlink-dependencies.ts
var import_fs_extra11, import_p_map4, import_p_map_series;
var init_symlink_dependencies = __esm({
  "libs/legacy-core/src/lib/symlink-dependencies.ts"() {
    "use strict";
    import_fs_extra11 = __toESM(require("fs-extra"));
    import_p_map4 = __toESM(require("p-map"));
    import_p_map_series = __toESM(require("p-map-series"));
    init_create_symlink();
    init_resolve_symlink();
    init_symlink_binary();
  }
});

// libs/legacy-core/src/index.ts
var init_src2 = __esm({
  "libs/legacy-core/src/index.ts"() {
    "use strict";
    init_collect_updates2();
    init_command2();
    init_create_symlink();
    init_get_filtered_packages();
    init_listable_format();
    init_package_graph();
    init_package_graph_node();
    init_run_topologically();
    init_symlink_binary();
    init_symlink_dependencies();
  }
});

// libs/commands/clean/src/index.ts
var require_src2 = __commonJS({
  "libs/commands/clean/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    init_src2();
    var import_p_map8 = __toESM(require("p-map"));
    var import_path25 = __toESM(require("path"));
    module2.exports = function factory2(argv) {
      return new CleanCommand(argv);
    };
    var CleanCommand = class extends Command2 {
      get requiresGit() {
        return false;
      }
      initialize() {
        let chain = Promise.resolve();
        chain = chain.then(() => getFilteredPackages(this.packageGraph, this.execOpts, this.options));
        chain = chain.then((filteredPackages) => {
          this.directoriesToDelete = filteredPackages.map((pkg2) => pkg2.nodeModulesLocation);
        });
        return chain.then(() => {
          if (this.options.yes) {
            return true;
          }
          this.logger.info("", "Removing the following directories:");
          this.logger.info(
            "clean",
            this.directoriesToDelete.map((dir) => import_path25.default.relative(this.project.rootPath, dir)).join("\n")
          );
          return promptConfirmation("Proceed?");
        });
      }
      execute() {
        this.enableProgressBar();
        const tracker = this.logger.newItem("clean");
        const mapper = (dirPath) => {
          tracker.info("clean", "removing", dirPath);
          return pulseTillDone(rimrafDir(dirPath)).then(() => {
            tracker.completeWork(1);
          });
        };
        tracker.addWork(this.directoriesToDelete.length);
        return (0, import_p_map8.default)(this.directoriesToDelete, mapper, { concurrency: this.concurrency }).then(() => {
          tracker.finish();
          this.logger.success("clean", "finished");
        });
      }
    };
    module2.exports.CleanCommand = CleanCommand;
  }
});

// libs/commands/clean/src/command.ts
var require_command2 = __commonJS({
  "libs/commands/clean/src/command.ts"(exports2, module2) {
    "use strict";
    init_src();
    var command = {
      command: "clean",
      describe: "Remove the node_modules directory from all packages",
      builder(yargs2) {
        yargs2.options({
          y: {
            group: "Command Options:",
            describe: "Skip all confirmation prompts",
            alias: "yes",
            type: "boolean"
          }
        });
        return filterOptions(yargs2);
      },
      handler(argv) {
        return require_src2()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/diff/src/lib/get-last-commit.ts
function getLastCommit(execOpts) {
  if (hasTags3(execOpts)) {
    import_npmlog48.default.silly("getLastTagInBranch", "");
    return childProcess13.execSync("git", ["describe", "--tags", "--abbrev=0"], execOpts);
  }
  import_npmlog48.default.silly("getFirstCommit", "");
  return childProcess13.execSync("git", ["rev-list", "--max-parents=0", "HEAD"], execOpts);
}
function hasTags3(opts) {
  let result = false;
  try {
    result = !!childProcess13.execSync("git", ["tag"], opts);
  } catch (err) {
    import_npmlog48.default.warn("ENOTAGS", "No git tags were reachable from this branch!");
    import_npmlog48.default.verbose("hasTags error", err);
  }
  import_npmlog48.default.verbose("hasTags", result.toString());
  return result;
}
var import_npmlog48, childProcess13;
var init_get_last_commit = __esm({
  "libs/commands/diff/src/lib/get-last-commit.ts"() {
    "use strict";
    import_npmlog48 = __toESM(require("npmlog"));
    childProcess13 = require("@lerna/child-process");
  }
});

// libs/commands/diff/src/lib/has-commit.ts
function hasCommit(opts) {
  import_npmlog49.default.silly("hasCommit", "");
  let retVal;
  try {
    childProcess14.execSync("git", ["log"], opts);
    retVal = true;
  } catch (e) {
    retVal = false;
  }
  import_npmlog49.default.verbose("hasCommit", retVal.toString());
  return retVal;
}
var import_npmlog49, childProcess14;
var init_has_commit = __esm({
  "libs/commands/diff/src/lib/has-commit.ts"() {
    "use strict";
    import_npmlog49 = __toESM(require("npmlog"));
    childProcess14 = require("@lerna/child-process");
  }
});

// libs/commands/diff/src/index.ts
var src_exports = {};
__export(src_exports, {
  DiffCommand: () => DiffCommand,
  factory: () => factory
});
function factory(argv) {
  return new DiffCommand(argv);
}
var childProcess15, DiffCommand;
var init_src3 = __esm({
  "libs/commands/diff/src/index.ts"() {
    "use strict";
    init_src();
    init_get_last_commit();
    init_has_commit();
    childProcess15 = require("@lerna/child-process");
    DiffCommand = class extends Command {
      args = [];
      initialize() {
        const packageName = this.options.pkgName;
        let targetPackage;
        if (packageName) {
          const project = Object.values(this.projectGraph.nodes).find(
            (p) => p.package && getPackage(p).name === packageName
          );
          targetPackage = project && getPackage(project);
          if (!targetPackage) {
            throw new ValidationError("ENOPKG", `Cannot diff, the package '${packageName}' does not exist.`);
          }
        }
        if (!hasCommit(this.execOpts)) {
          throw new ValidationError("ENOCOMMITS", "Cannot diff, there are no commits in this repository yet.");
        }
        const args = ["diff", getLastCommit(this.execOpts), "--color=auto"];
        if (targetPackage) {
          args.push("--", targetPackage.location);
        } else {
          args.push("--", ...this.project.packageParentDirs);
        }
        if (this.options.ignoreChanges) {
          this.options.ignoreChanges.forEach((ignorePattern) => {
            args.push(`:(exclude,glob)${ignorePattern}`);
          });
        }
        this.args = args;
      }
      execute() {
        return childProcess15.spawn("git", this.args, this.execOpts).catch((err) => {
          if (err.exitCode) {
            throw err;
          }
        });
      }
    };
  }
});

// libs/commands/diff/src/command.ts
var require_command3 = __commonJS({
  "libs/commands/diff/src/command.ts"(exports2, module2) {
    "use strict";
    var command = {
      command: "diff [pkgName]",
      describe: "Diff all packages or a single package since the last release",
      builder(yargs2) {
        return yargs2.positional("pkgName", {
          describe: "An optional package name to filter the diff output"
        }).options({
          "ignore-changes": {
            group: "Command Options:",
            describe: "Ignore changes in files matched by glob(s).",
            type: "array"
          }
        }).epilogue(
          "When ignoreChanges is configured in lerna.json, pass --no-ignore-changes to include ignored files."
        );
      },
      handler(argv) {
        return (init_src3(), __toCommonJS(src_exports)).factory(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/exec/src/index.ts
var require_src3 = __commonJS({
  "libs/commands/exec/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_p_map8 = __toESM(require("p-map"));
    var childProcess27 = require("@lerna/child-process");
    module2.exports = function factory2(argv) {
      return new ExecCommand(argv);
    };
    var ExecCommand = class extends Command {
      options;
      command;
      args;
      bail;
      prefix;
      env;
      filteredProjects;
      count;
      packagePlural;
      joinedCommand;
      get requiresGit() {
        return false;
      }
      async initialize() {
        const dashedArgs = this.options["--"] || [];
        this.command = this.options.cmd || dashedArgs.shift();
        this.args = (this.options.args || []).concat(dashedArgs);
        if (!this.command) {
          throw new ValidationError("ENOCOMMAND", "A command to execute is required");
        }
        this.bail = this.options.bail !== false;
        this.prefix = this.options.prefix !== false;
        this.env = Object.assign({}, process.env);
        this.filteredProjects = filterProjects(this.projectGraph, this.execOpts, this.options);
        this.count = this.filteredProjects.length;
        this.packagePlural = this.count === 1 ? "package" : "packages";
        this.joinedCommand = [this.command].concat(this.args).join(" ");
      }
      async execute() {
        this.logger.info(
          "",
          "Executing command in %d %s: %j",
          this.count,
          this.packagePlural,
          this.joinedCommand
        );
        let runCommand;
        if (this.options.parallel) {
          runCommand = () => this.runCommandInPackagesParallel();
        } else if (this.toposort) {
          runCommand = () => this.runCommandInPackagesTopological();
        } else {
          runCommand = () => this.runCommandInPackagesLexical();
        }
        if (this.bail) {
          try {
            await runCommand();
          } catch (err) {
            process.exitCode = err.exitCode;
            throw err;
          }
        } else {
          const results = await runCommand();
          if (results.some((result) => result.failed)) {
            const codes = results.filter((result) => result.failed).map((result) => result.exitCode);
            const exitCode = Math.max(...codes, 1);
            this.logger.error("", "Received non-zero exit code %d during execution", exitCode);
            process.exitCode = exitCode;
          }
        }
        this.logger.success(
          "exec",
          "Executed command in %d %s: %j",
          this.count,
          this.packagePlural,
          this.joinedCommand
        );
      }
      getOpts(pkg2) {
        return {
          cwd: pkg2.location,
          shell: true,
          extendEnv: false,
          env: Object.assign({}, this.env, {
            LERNA_PACKAGE_NAME: pkg2.name,
            LERNA_ROOT_PATH: this.project.rootPath
          }),
          reject: this.bail,
          pkg: pkg2
        };
      }
      getRunner() {
        return this.options.stream ? (pkg2) => this.runCommandInPackageStreaming(pkg2) : (pkg2) => this.runCommandInPackageCapturing(pkg2);
      }
      runCommandInPackagesTopological() {
        let profiler;
        let runner;
        if (this.options.profile) {
          profiler = new Profiler({
            concurrency: this.concurrency,
            log: this.logger,
            outputDirectory: this.options.profileLocation || this.project.rootPath
          });
          const callback = this.getRunner();
          runner = (pkg2) => profiler.run(() => callback(pkg2), pkg2.name);
        } else {
          runner = this.getRunner();
        }
        let chain = runProjectsTopologically(
          this.filteredProjects,
          this.projectGraph,
          (p) => runner(getPackage(p)),
          {
            concurrency: this.concurrency,
            rejectCycles: this.options.rejectCycles
          }
        );
        if (profiler) {
          chain = chain.then((results) => profiler.output().then(() => results));
        }
        return chain;
      }
      runCommandInPackagesParallel() {
        return (0, import_p_map8.default)(this.filteredProjects, (p) => this.runCommandInPackageStreaming(getPackage(p)));
      }
      runCommandInPackagesLexical() {
        return (0, import_p_map8.default)(this.filteredProjects, (p) => this.getRunner()(getPackage(p)), {
          concurrency: this.concurrency
        });
      }
      runCommandInPackageStreaming(pkg2) {
        return childProcess27.spawnStreaming(this.command, this.args, this.getOpts(pkg2), this.prefix && pkg2.name);
      }
      runCommandInPackageCapturing(pkg2) {
        return childProcess27.spawn(this.command, this.args, this.getOpts(pkg2));
      }
    };
    module2.exports.ExecCommand = ExecCommand;
  }
});

// libs/commands/exec/src/command.ts
var require_command4 = __commonJS({
  "libs/commands/exec/src/command.ts"(exports2, module2) {
    "use strict";
    init_src();
    var command = {
      command: "exec [cmd] [args..]",
      describe: "Execute an arbitrary command in each package",
      builder(yargs2) {
        yargs2.example("$0 exec ls -- --la", "# execute `ls -la` in all packages").example("$0 exec -- ls --la", "# execute `ls -la` in all packages, keeping cmd outside").parserConfiguration({
          "populate--": true
        }).positional("cmd", {
          describe: "The command to execute. Any command flags must be passed after --",
          type: "string"
        }).positional("args", {
          describe: "Positional arguments (not recognized by lerna) to send to command",
          type: "string"
        }).options({
          stream: {
            group: "Command Options:",
            describe: "Stream output with lines prefixed by originating package name.",
            type: "boolean"
          },
          parallel: {
            group: "Command Options:",
            describe: "Execute command with unlimited concurrency, streaming prefixed output.",
            type: "boolean"
          },
          "no-bail": {
            group: "Command Options:",
            describe: "Continue executing command despite non-zero exit in a given package.",
            type: "boolean"
          },
          bail: {
            // proxy for --no-bail
            hidden: true,
            type: "boolean"
          },
          // This option controls prefix for stream output so that it can be disabled to be friendly
          // to tools like Visual Studio Code to highlight the raw results
          "no-prefix": {
            group: "Command Options:",
            describe: "Do not prefix streaming output.",
            type: "boolean"
          },
          prefix: {
            // proxy for --no-prefix
            hidden: true,
            type: "boolean"
          },
          profile: {
            group: "Command Options:",
            describe: "Profile command executions and output performance profile to default location.",
            type: "boolean"
          },
          "profile-location": {
            group: "Command Options:",
            describe: "Output performance profile to custom location instead of default project root.",
            type: "string"
          }
        });
        return filterOptions(yargs2);
      },
      handler(argv) {
        return require_src3()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/import/src/index.ts
var require_src4 = __commonJS({
  "libs/commands/import/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_dedent6 = __toESM(require("dedent"));
    var import_fs_extra14 = __toESM(require("fs-extra"));
    var import_p_map_series2 = __toESM(require("p-map-series"));
    var import_path25 = __toESM(require("path"));
    var childProcess27 = require("@lerna/child-process");
    module2.exports = function factory2(argv) {
      return new ImportCommand(argv);
    };
    var ImportCommand = class extends Command {
      gitParamsForTargetCommits() {
        const params = ["log", "--format=%h"];
        if (this.options.flatten) {
          params.push("--first-parent");
        }
        return params;
      }
      initialize() {
        const inputPath = this.options.dir;
        const externalRepoPath = import_path25.default.resolve(inputPath);
        const externalRepoBase = import_path25.default.basename(externalRepoPath);
        this.externalExecOpts = Object.assign({}, this.execOpts, {
          cwd: externalRepoPath
        });
        let stats;
        try {
          stats = import_fs_extra14.default.statSync(externalRepoPath);
        } catch (e) {
          if (e.code === "ENOENT") {
            throw new ValidationError("ENOENT", `No repository found at "${inputPath}"`);
          }
          throw e;
        }
        if (!stats.isDirectory()) {
          throw new ValidationError("ENODIR", `Input path "${inputPath}" is not a directory`);
        }
        const packageJson = import_path25.default.join(externalRepoPath, "package.json");
        const packageName = require(packageJson).name;
        if (!packageName) {
          throw new ValidationError("ENOPKG", `No package name specified in "${packageJson}"`);
        }
        const targetBase = this.getTargetBase();
        if (this.getPackageDirectories().indexOf(targetBase) === -1) {
          throw new ValidationError(
            "EDESTDIR",
            `--dest does not match with the package directories: ${this.getPackageDirectories()}`
          );
        }
        const targetDir = import_path25.default.join(targetBase, externalRepoBase);
        const gitRepoRoot = this.getWorkspaceRoot();
        const lernaRootRelativeToGitRoot = import_path25.default.relative(gitRepoRoot, this.project.rootPath);
        this.targetDirRelativeToGitRoot = import_path25.default.join(lernaRootRelativeToGitRoot, targetDir);
        if (this.targetDirRelativeToGitRoot.startsWith("..")) {
          throw new ValidationError(
            "ENOTINREPO",
            `Project root ${this.project.rootPath} is not a subdirectory of git root ${gitRepoRoot}`
          );
        }
        if (import_fs_extra14.default.existsSync(import_path25.default.resolve(this.project.rootPath, targetDir))) {
          throw new ValidationError("EEXISTS", `Target directory already exists "${targetDir}"`);
        }
        this.commits = this.externalExecSync("git", this.gitParamsForTargetCommits()).split("\n").reverse();
        if (!this.commits.length) {
          throw new ValidationError("NOCOMMITS", `No git commits to import at "${inputPath}"`);
        }
        if (this.options.preserveCommit) {
          this.origGitEmail = this.execSync("git", ["config", "user.email"]);
          this.origGitName = this.execSync("git", ["config", "user.name"]);
        }
        this.preImportHead = this.getCurrentSHA();
        if (this.execSync("git", ["diff-index", "HEAD"])) {
          throw new ValidationError("ECHANGES", "Local repository has un-committed changes");
        }
        this.logger.info(
          "",
          `About to import ${this.commits.length} commits from ${inputPath} into ${targetDir}`
        );
        if (this.options.yes) {
          return true;
        }
        return promptConfirmation("Are you sure you want to import these commits onto the current branch?");
      }
      getPackageDirectories() {
        return this.project.packageConfigs.filter((p) => p.endsWith("*")).map((p) => import_path25.default.dirname(p));
      }
      getTargetBase() {
        if (this.options.dest) {
          return this.options.dest;
        }
        return this.getPackageDirectories().shift() || "packages";
      }
      getCurrentSHA() {
        return this.execSync("git", ["rev-parse", "HEAD"]);
      }
      getWorkspaceRoot() {
        return this.execSync("git", ["rev-parse", "--show-toplevel"]);
      }
      execSync(cmd, args) {
        return childProcess27.execSync(cmd, args, this.execOpts);
      }
      externalExecSync(cmd, args) {
        return childProcess27.execSync(cmd, args, this.externalExecOpts);
      }
      createPatchForCommit(sha) {
        let patch = null;
        if (this.options.flatten) {
          const diff = this.externalExecSync("git", [
            "log",
            "--reverse",
            "--first-parent",
            "-p",
            "-m",
            "--pretty=email",
            "--stat",
            "--binary",
            "-1",
            "--color=never",
            sha,
            // custom git prefixes for accurate parsing of filepaths (#1655)
            `--src-prefix=COMPARE_A/`,
            `--dst-prefix=COMPARE_B/`
          ]);
          const version = this.externalExecSync("git", ["--version"]).replace(/git version /g, "");
          patch = `${diff}
--
${version}`;
        } else {
          patch = this.externalExecSync("git", [
            "format-patch",
            "-1",
            sha,
            "--stdout",
            // custom git prefixes for accurate parsing of filepaths (#1655)
            `--src-prefix=COMPARE_A/`,
            `--dst-prefix=COMPARE_B/`
          ]);
        }
        const formattedTarget = this.targetDirRelativeToGitRoot.replace(/\\/g, "/");
        const replacement = `$1/${formattedTarget}`;
        return patch.replace(/^([-+]{3} "?COMPARE_[AB])/gm, replacement).replace(/^(diff --git "?COMPARE_A)/gm, replacement).replace(/^(diff --git (?! "?COMPARE_B\/).+ "?COMPARE_B)/gm, replacement).replace(/^(copy (from|to)) ("?)/gm, `$1 $3${formattedTarget}/`).replace(/^(rename (from|to)) ("?)/gm, `$1 $3${formattedTarget}/`);
      }
      getGitUserFromSha(sha) {
        return {
          email: this.externalExecSync("git", ["show", "-s", "--format='%ae'", sha]),
          name: this.externalExecSync("git", ["show", "-s", "--format='%an'", sha])
        };
      }
      configureGitUser({ email, name }) {
        this.execSync("git", ["config", "user.email", `"${email}"`]);
        this.execSync("git", ["config", "user.name", `"${name}"`]);
      }
      execute() {
        this.enableProgressBar();
        const tracker = this.logger.newItem("execute");
        const mapper = (sha) => {
          tracker.info(sha);
          const patch = this.createPatchForCommit(sha);
          const procArgs = ["am", "-3", "--keep-non-patch"];
          if (this.options.preserveCommit) {
            this.configureGitUser(this.getGitUserFromSha(sha));
            procArgs.push("--committer-date-is-author-date");
          }
          const proc = childProcess27.exec("git", procArgs, this.execOpts);
          proc.stdin.end(patch);
          return pulseTillDone(proc).then(() => {
            tracker.completeWork(1);
          }).catch((err) => {
            const diff = this.externalExecSync("git", ["diff", "-s", `${sha}^!`]).trim();
            if (diff === "") {
              tracker.completeWork(1);
              return childProcess27.exec("git", ["am", "--skip"], this.execOpts);
            }
            err.sha = sha;
            throw err;
          });
        };
        tracker.addWork(this.commits.length);
        return (0, import_p_map_series2.default)(this.commits, mapper).then(() => {
          tracker.finish();
          if (this.options.preserveCommit) {
            this.configureGitUser({
              email: this.origGitEmail,
              name: this.origGitName
            });
          }
          this.logger.success("import", "finished");
        }).catch((err) => {
          tracker.finish();
          if (this.options.preserveCommit) {
            this.configureGitUser({
              email: this.origGitEmail,
              name: this.origGitName
            });
          }
          this.logger.error("import", `Rolling back to previous HEAD (commit ${this.preImportHead})`);
          this.execSync("git", ["am", "--abort"]);
          this.execSync("git", ["reset", "--hard", this.preImportHead]);
          throw new ValidationError(
            "EIMPORT",
            import_dedent6.default`
            Failed to apply commit ${err.sha}.
            ${err.message}

            You may try again with --flatten to import flat history.
          `
          );
        });
      }
    };
    module2.exports.ImportCommand = ImportCommand;
  }
});

// libs/commands/import/src/command.ts
var require_command5 = __commonJS({
  "libs/commands/import/src/command.ts"(exports2, module2) {
    "use strict";
    var command = {
      command: "import <dir>",
      describe: "Import a package into the monorepo with commit history",
      builder(yargs2) {
        return yargs2.positional("dir", { describe: "The path to an external git repository that contains an npm package" }).options({
          flatten: {
            group: "Command Options:",
            describe: "Import each merge commit as a single change the merge introduced",
            type: "boolean"
          },
          dest: {
            group: "Command Options:",
            describe: "Import destination directory for the external git repository",
            type: "string"
          },
          "preserve-commit": {
            group: "Command Options:",
            describe: "Preserve original committer in addition to original author",
            type: "boolean"
          },
          y: {
            group: "Command Options:",
            describe: "Skip all confirmation prompts",
            alias: "yes",
            type: "boolean"
          }
        });
      },
      handler(argv) {
        return require_src4()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/info/src/index.ts
var require_src5 = __commonJS({
  "libs/commands/info/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_envinfo = __toESM(require("envinfo"));
    module2.exports = function factory2(argv) {
      return new InfoCommand(argv);
    };
    var InfoCommand = class extends Command {
      initialize() {
      }
      execute() {
        output("\n Environment info:");
        import_envinfo.default.run({
          System: ["OS", "CPU"],
          Binaries: ["Node", "Yarn", "npm"],
          Utilities: ["Git"],
          npmPackages: ["lerna"]
        }).then(output);
      }
    };
    module2.exports.InfoCommand = InfoCommand;
  }
});

// libs/commands/info/src/command.ts
var require_command6 = __commonJS({
  "libs/commands/info/src/command.ts"(exports2, module2) {
    "use strict";
    var command = {
      command: "info",
      describe: "Prints debugging information about the local environment",
      handler(argv) {
        return require_src5()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/init/src/index.ts
var require_src6 = __commonJS({
  "libs/commands/init/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_devkit8 = require("@nx/devkit");
    var import_fs7 = require("fs");
    var import_fs_extra14 = require("fs-extra");
    var import_npmlog65 = __toESM(require("npmlog"));
    var import_tree = require("nx/src/generators/tree");
    var LARGE_BUFFER = 1024 * 1e6;
    var childProcess27 = require("@lerna/child-process");
    var PACKAGE_GLOB = "packages/*";
    module2.exports = function factory2(args) {
      return new InitCommand(args);
    };
    var InitCommand = class {
      constructor(args) {
        this.args = args;
        import_npmlog65.default.heading = "lerna";
        this.logger = Command.createLogger(this.name, args.loglevel);
        this.logger.notice("cli", `v${this.args.lernaVersion}`);
        this.packageManager = this.detectPackageManager() || this.detectInvokedPackageManager() || "npm";
        this.execute();
      }
      name = "init";
      logger;
      cwd = process.cwd();
      packageManager;
      async execute() {
        const tree = new import_tree.FsTree(this.cwd, false);
        const task = await this.generate(tree);
        const changes = tree.listChanges();
        if (!changes.length) {
          return;
        }
        const isDryRun = this.args.dryRun;
        const { default: chalk4 } = await import("chalk");
        const { diff } = await import("jest-diff");
        function printDiff(before, after) {
          console.error(
            diff(before, after, {
              omitAnnotationLines: true,
              contextLines: 1,
              expand: false,
              aColor: chalk4.red,
              bColor: chalk4.green,
              patchColor: (s) => ""
            })
          );
        }
        if (isDryRun) {
          this.logger.info("", "The following file system updates will be made:");
        } else {
          this.logger.info("", "Applying the following file system updates:");
        }
        const indent = "";
        changes.forEach((f) => {
          if (f.type === "CREATE") {
            console.error(
              `${indent}${chalk4.green("CREATE")} ${f.path}${isDryRun ? chalk4.yellow(" [preview]") : ""}`
            );
            if (isDryRun) {
              printDiff("", f.content?.toString() || "");
            }
          } else if (f.type === "UPDATE") {
            console.error(
              `${indent}${chalk4.white("UPDATE")} ${f.path}${isDryRun ? chalk4.yellow(" [preview]") : ""}`
            );
            if (isDryRun) {
              const currentContentsOnDisk = (0, import_fs_extra14.readFileSync)((0, import_devkit8.joinPathFragments)(tree.root, f.path)).toString();
              printDiff(currentContentsOnDisk, f.content?.toString() || "");
            }
          } else if (f.type === "DELETE") {
            console.error(`${indent}${chalk4.yellow("DELETE")} ${f.path}`);
          }
        });
        if (!isDryRun) {
          (0, import_tree.flushChanges)(this.cwd, changes);
          if (task) {
            await task();
          }
          this.logger.success("", "Initialized Lerna files");
          this.logger.info("", "New to Lerna? Check out the docs: https://lerna.js.org/docs/getting-started");
        } else {
          this.logger.warn("", `The "dryRun" flag means no changes were made.`);
        }
      }
      async generate(tree) {
        const defaultLernaJson = {
          $schema: "node_modules/lerna/schemas/lerna-schema.json",
          version: this.args.independent === true ? "independent" : "0.0.0"
        };
        if (tree.exists("lerna.json")) {
          this.logger.error("", "Lerna has already been initialized for this repo.");
          this.logger.error(
            "",
            "If you are looking to ensure that your config is up to date with the latest and greatest, run `lerna repair` instead"
          );
          return;
        }
        const lernaJson = defaultLernaJson;
        if (this.args.packages) {
          lernaJson.packages = this.args.packages;
        }
        if (this.packageManager !== "npm") {
          lernaJson.npmClient = this.packageManager;
        }
        if (!tree.exists("package.json")) {
          (0, import_devkit8.writeJson)(tree, "lerna.json", lernaJson);
          const basePackageJson = {
            name: "root",
            private: true
          };
          if (this.packageManager === "pnpm") {
            (0, import_devkit8.writeJson)(tree, "package.json", basePackageJson);
            if (!tree.exists("pnpm-workspace.yaml")) {
              tree.write("pnpm-workspace.yaml", `packages:
  - '${PACKAGE_GLOB}'
`);
            }
          } else {
            (0, import_devkit8.writeJson)(tree, "package.json", {
              ...basePackageJson,
              workspaces: [PACKAGE_GLOB]
            });
          }
        } else {
          if (this.args.packages || this.#hasWorkspacesConfigured(tree)) {
            (0, import_devkit8.writeJson)(tree, "lerna.json", lernaJson);
          } else {
            this.logger.error(
              "",
              "Cannot initialize lerna because your package manager has not been configured to use `workspaces`, and you have not explicitly specified any packages to operate on"
            );
            this.logger.error(
              "",
              "See https://lerna.js.org/docs/getting-started#adding-lerna-to-an-existing-repo for how to resolve this"
            );
            return;
          }
        }
        (0, import_devkit8.addDependenciesToPackageJson)(
          tree,
          {},
          { lerna: this.args.exact ? this.args.lernaVersion : `^${this.args.lernaVersion}` }
        );
        if (!tree.exists(".gitignore")) {
          tree.write(".gitignore", "node_modules/");
        }
        return async () => {
          if (isGitInitialized(this.cwd)) {
            this.logger.info("", "Git is already initialized");
          } else {
            this.logger.info("", "Initializing Git repository");
            await childProcess27.exec("git", ["init"], {
              cwd: this.cwd,
              maxBuffer: 1024
            });
          }
          if (this.args.skipInstall === void 0) {
            this.logger.info("", `Using ${this.packageManager} to install packages`);
            const packageManagerCommand = (0, import_devkit8.getPackageManagerCommand)(this.packageManager);
            const [command, ...args] = packageManagerCommand.install.split(" ");
            await childProcess27.exec(command, args, {
              cwd: this.cwd,
              maxBuffer: LARGE_BUFFER
            });
          }
        };
      }
      #hasWorkspacesConfigured(tree) {
        const packageJson = (0, import_devkit8.readJson)(tree, "package.json");
        return Array.isArray(packageJson.workspaces) || tree.exists("pnpm-workspace.yaml");
      }
      detectPackageManager() {
        const packageManager = (0, import_fs7.existsSync)("yarn.lock") ? "yarn" : (0, import_fs7.existsSync)("pnpm-lock.yaml") ? "pnpm" : (0, import_fs7.existsSync)("package-lock.json") ? "npm" : null;
        if (packageManager) {
          this.logger.verbose("", `Detected lock file for ${packageManager}`);
        }
        return packageManager;
      }
      /**
       * Detects which package manager was used to invoke lerna init command
       * based on the main Module process that invokes the command
       * - npx returns 'npm'
       * - pnpx returns 'pnpm'
       * - yarn create returns 'yarn'
       */
      detectInvokedPackageManager() {
        let detectedPackageManager = null;
        const invoker = require.main || process["mainModule"];
        if (!invoker) {
          this.logger.verbose("", "Could not detect package manager from process");
          return detectedPackageManager;
        }
        for (const pkgManager of ["pnpm", "yarn", "npm"]) {
          if (invoker.path.includes(pkgManager)) {
            this.logger.verbose("", `Detected package manager ${pkgManager} from process`);
            detectedPackageManager = pkgManager;
            break;
          }
        }
        return detectedPackageManager;
      }
    };
    module2.exports.InitCommand = InitCommand;
  }
});

// libs/commands/init/src/command.ts
var require_command7 = __commonJS({
  "libs/commands/init/src/command.ts"(exports2, module2) {
    "use strict";
    var command = {
      command: "init",
      describe: "Create a new Lerna repo or upgrade an existing repo to the current version of Lerna",
      builder: {
        exact: {
          describe: "Specify lerna dependency version in package.json without a caret (^)",
          type: "boolean"
        },
        independent: {
          describe: "Version packages independently",
          alias: "i",
          type: "boolean"
        },
        packages: {
          describe: "A glob pattern matching packages that should be included (instead of defaulting to the package manager's workspaces config)",
          type: "array"
        },
        dryRun: {
          describe: "Preview the changes that will be made to the file system without actually modifying anything",
          type: "boolean",
          default: false
        },
        skipInstall: {
          describe: "Skip installation of dependencies after initialization",
          type: "boolean"
        }
      },
      handler(argv) {
        return require_src6()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/list/src/index.ts
var require_src7 = __commonJS({
  "libs/commands/list/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    module2.exports = function factory2(argv) {
      return new ListCommand(argv);
    };
    var ListCommand = class extends Command {
      // TODO: refactor based on TS feedback
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      result;
      get requiresGit() {
        return false;
      }
      async initialize() {
        const filteredProjects = filterProjects(this.projectGraph, this.execOpts, this.options);
        this.result = listableFormatProjects(filteredProjects, this.projectGraph, this.options);
      }
      execute() {
        if (this.result.text.length) {
          output(this.result.text);
        }
        this.logger.success(
          "found",
          "%d %s",
          this.result.count,
          this.result.count === 1 ? "package" : "packages"
        );
      }
    };
    module2.exports.ListCommand = ListCommand;
  }
});

// libs/commands/list/src/command.ts
var require_command8 = __commonJS({
  "libs/commands/list/src/command.ts"(exports2, module2) {
    "use strict";
    init_src();
    var command = {
      command: "list",
      aliases: ["ls", "la", "ll"],
      describe: "List local packages",
      builder(yargs2) {
        listableOptions(yargs2);
        return filterOptions(yargs2);
      },
      handler(argv) {
        return require_src7()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/version/src/lib/create-release.ts
function createReleaseClient(type) {
  switch (type) {
    case "gitlab":
      return createGitLabClient();
    case "github":
      return createGitHubClient();
    default:
      throw new ValidationError("ERELEASE", "Invalid release client type");
  }
}
function createRelease(client, { tags, releaseNotes }, { gitRemote, execOpts }) {
  const repo = parseGitRepo(gitRemote, execOpts);
  return Promise.all(
    releaseNotes.map(({ notes, name }) => {
      const tag = name === "fixed" ? tags[0] : tags.find((t) => t.startsWith(`${name}@`));
      if (!tag) {
        return Promise.resolve();
      }
      const prereleaseParts = import_semver6.default.prerelease(tag.replace(`${name}@`, "")) || [];
      return client.repos.createRelease({
        owner: repo.owner,
        repo: repo.name,
        tag_name: tag,
        name: tag,
        body: notes,
        draft: false,
        prerelease: prereleaseParts.length > 0
      });
    })
  );
}
var import_semver6;
var init_create_release = __esm({
  "libs/commands/version/src/lib/create-release.ts"() {
    "use strict";
    init_src();
    import_semver6 = __toESM(require("semver"));
  }
});

// libs/commands/version/src/lib/get-current-branch.ts
function getCurrentBranch(opts) {
  import_npmlog50.default.silly("getCurrentBranch");
  const branch = childProcess16.execSync("git", ["rev-parse", "--abbrev-ref", "HEAD"], opts);
  import_npmlog50.default.verbose("currentBranch", branch);
  return branch;
}
var import_npmlog50, childProcess16;
var init_get_current_branch = __esm({
  "libs/commands/version/src/lib/get-current-branch.ts"() {
    "use strict";
    import_npmlog50 = __toESM(require("npmlog"));
    childProcess16 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/git-add.ts
function resolvePrettier() {
  if (!resolvedPrettier) {
    try {
      const packageJson = (0, import_devkit5.readJsonFile)(import_path21.default.join(import_devkit5.workspaceRoot, "package.json"));
      const hasPrettier = packageJson.devDependencies?.prettier || packageJson.dependencies?.prettier;
      if (!hasPrettier) {
        return;
      }
      resolvedPrettier = require("prettier");
    } catch {
      return;
    }
  }
  return resolvedPrettier;
}
async function maybeFormatFile(filePath) {
  const prettier = resolvePrettier();
  if (!prettier) {
    return;
  }
  const config = await resolvedPrettier.resolveConfig(filePath);
  const ignorePath = import_path21.default.join(import_devkit5.workspaceRoot, ".prettierignore");
  const fullFilePath = import_path21.default.join(import_devkit5.workspaceRoot, filePath);
  const fileInfo = await resolvedPrettier.getFileInfo(fullFilePath, { ignorePath });
  if (fileInfo.ignored) {
    import_npmlog51.default.silly("version", `Skipped applying prettier to ignored file: ${filePath}`);
    return;
  }
  try {
    const input = import_fs6.default.readFileSync(fullFilePath, "utf8");
    import_fs6.default.writeFileSync(
      fullFilePath,
      await resolvedPrettier.format(input, { ...config, filepath: fullFilePath }),
      "utf8"
    );
    import_npmlog51.default.silly("version", `Successfully applied prettier to updated file: ${filePath}`);
  } catch {
    import_npmlog51.default.silly("version", `Failed to apply prettier to updated file: ${filePath}`);
  }
}
async function gitAdd(changedFiles, gitOpts, execOpts) {
  let files = [];
  for (const file of changedFiles) {
    const filePath = (0, import_slash3.default)(import_path21.default.relative(execOpts.cwd, import_path21.default.resolve(execOpts.cwd, file)));
    await maybeFormatFile(filePath);
    if (gitOpts.granularPathspec) {
      files.push(filePath);
    }
  }
  if (!gitOpts.granularPathspec) {
    files = ".";
  }
  import_npmlog51.default.silly("gitAdd", files);
  return childProcess17.exec("git", ["add", "--", ...files], execOpts);
}
var import_devkit5, import_fs6, import_npmlog51, import_path21, import_slash3, childProcess17, resolvedPrettier;
var init_git_add = __esm({
  "libs/commands/version/src/lib/git-add.ts"() {
    "use strict";
    import_devkit5 = require("@nx/devkit");
    import_fs6 = __toESM(require("fs"));
    import_npmlog51 = __toESM(require("npmlog"));
    import_path21 = __toESM(require("path"));
    import_slash3 = __toESM(require("slash"));
    childProcess17 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/git-commit.ts
function gitCommit(message, { amend, commitHooks, signGitCommit, signoffGitCommit }, opts) {
  import_npmlog52.default.silly("gitCommit", message);
  const args = ["commit"];
  if (commitHooks === false) {
    args.push("--no-verify");
  }
  if (signGitCommit) {
    args.push("--gpg-sign");
  }
  if (signoffGitCommit) {
    args.push("--signoff");
  }
  if (amend) {
    args.push("--amend", "--no-edit");
  } else if (message.indexOf(import_os6.EOL) > -1) {
    args.push("-F", temp_write_default.sync(message, "lerna-commit.txt"));
  } else {
    args.push("-m", message);
  }
  import_npmlog52.default.verbose("git", args);
  return childProcess18.exec("git", args, opts);
}
var import_npmlog52, import_os6, childProcess18;
var init_git_commit = __esm({
  "libs/commands/version/src/lib/git-commit.ts"() {
    "use strict";
    init_src();
    import_npmlog52 = __toESM(require("npmlog"));
    import_os6 = require("os");
    childProcess18 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/git-push.ts
function gitPush(remote, branch, opts) {
  import_npmlog53.default.silly("gitPush", remote, branch);
  return childProcess19.exec("git", ["push", "--follow-tags", "--no-verify", "--atomic", remote, branch], opts).catch((error) => {
    if (/atomic/.test(error.stderr) || process.env.GIT_REDIRECT_STDERR === "2>&1" && /atomic/.test(error.stdout)) {
      import_npmlog53.default.warn("gitPush", error.stderr);
      import_npmlog53.default.info("gitPush", "--atomic failed, attempting non-atomic push");
      return childProcess19.exec("git", ["push", "--follow-tags", "--no-verify", remote, branch], opts);
    }
    throw error;
  });
}
var import_npmlog53, childProcess19;
var init_git_push = __esm({
  "libs/commands/version/src/lib/git-push.ts"() {
    "use strict";
    import_npmlog53 = __toESM(require("npmlog"));
    childProcess19 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/git-tag.ts
function gitTag(tag, { forceGitTag, signGitTag }, opts, command = "git tag %s -m %s") {
  import_npmlog54.default.silly("gitTag", tag, command);
  const [cmd, ...args] = command.split(" ");
  const interpolatedArgs = args.map((arg) => arg.replace(/%s/, tag));
  if (forceGitTag) {
    interpolatedArgs.push("--force");
  }
  if (signGitTag) {
    interpolatedArgs.push("--sign");
  }
  import_npmlog54.default.verbose(cmd, interpolatedArgs);
  return childProcess20.exec(cmd, interpolatedArgs, opts);
}
var import_npmlog54, childProcess20;
var init_git_tag = __esm({
  "libs/commands/version/src/lib/git-tag.ts"() {
    "use strict";
    import_npmlog54 = __toESM(require("npmlog"));
    childProcess20 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/is-anything-committed.ts
function isAnythingCommitted(opts) {
  import_npmlog55.default.silly("isAnythingCommitted", "");
  const anyCommits = childProcess21.execSync("git", ["rev-list", "--count", "--all", "--max-count=1"], opts);
  import_npmlog55.default.verbose("isAnythingCommitted", anyCommits);
  return Boolean(parseInt(anyCommits, 10));
}
var import_npmlog55, childProcess21;
var init_is_anything_committed = __esm({
  "libs/commands/version/src/lib/is-anything-committed.ts"() {
    "use strict";
    import_npmlog55 = __toESM(require("npmlog"));
    childProcess21 = require("@lerna/child-process");
    module.exports.isAnythingCommitted = isAnythingCommitted;
  }
});

// libs/commands/version/src/lib/is-behind-upstream.ts
function isBehindUpstream(gitRemote, branch, opts) {
  import_npmlog56.default.silly("isBehindUpstream", "");
  updateRemote(opts);
  const remoteBranch = `${gitRemote}/${branch}`;
  const [behind, ahead] = countLeftRight(`${remoteBranch}...${branch}`, opts);
  import_npmlog56.default.silly(
    "isBehindUpstream",
    `${branch} is behind ${remoteBranch} by ${behind} commit(s) and ahead by ${ahead}`
  );
  return Boolean(behind);
}
function updateRemote(opts) {
  childProcess22.execSync("git", ["remote", "update"], opts);
}
function countLeftRight(symmetricDifference, opts) {
  const stdout = childProcess22.execSync(
    "git",
    ["rev-list", "--left-right", "--count", symmetricDifference],
    opts
  );
  return stdout.split("	").map((val) => parseInt(val, 10));
}
var import_npmlog56, childProcess22;
var init_is_behind_upstream = __esm({
  "libs/commands/version/src/lib/is-behind-upstream.ts"() {
    "use strict";
    import_npmlog56 = __toESM(require("npmlog"));
    childProcess22 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/is-breaking-change.ts
function isBreakingChange(currentVersion, nextVersion) {
  const releaseType = import_semver7.default.diff(currentVersion, nextVersion);
  let breaking;
  if (releaseType === "major") {
    breaking = true;
  } else if (releaseType === "minor") {
    breaking = import_semver7.default.lt(currentVersion, "1.0.0");
  } else if (releaseType === "patch") {
    breaking = import_semver7.default.lt(currentVersion, "0.1.0");
  } else {
    breaking = false;
  }
  return breaking;
}
var import_semver7;
var init_is_breaking_change = __esm({
  "libs/commands/version/src/lib/is-breaking-change.ts"() {
    "use strict";
    import_semver7 = __toESM(require("semver"));
  }
});

// libs/commands/version/src/lib/prompt-version.ts
function makePromptVersion(resolvePrereleaseId, buildMetadata) {
  return (node) => promptVersion(node.version, node.name, resolvePrereleaseId(node.prereleaseId), buildMetadata);
}
function promptVersion(currentVersion, name, prereleaseId, buildMetadata) {
  const patch = applyBuildMetadata(import_semver8.default.inc(currentVersion, "patch"), buildMetadata);
  const minor = applyBuildMetadata(import_semver8.default.inc(currentVersion, "minor"), buildMetadata);
  const major = applyBuildMetadata(import_semver8.default.inc(currentVersion, "major"), buildMetadata);
  const prepatch = applyBuildMetadata(import_semver8.default.inc(currentVersion, "prepatch", prereleaseId), buildMetadata);
  const preminor = applyBuildMetadata(import_semver8.default.inc(currentVersion, "preminor", prereleaseId), buildMetadata);
  const premajor = applyBuildMetadata(import_semver8.default.inc(currentVersion, "premajor", prereleaseId), buildMetadata);
  const message = `Select a new version ${name ? `for ${name} ` : ""}(currently ${currentVersion})`;
  return promptSelectOne(message, {
    choices: [
      { value: patch, name: `Patch (${patch})` },
      { value: minor, name: `Minor (${minor})` },
      { value: major, name: `Major (${major})` },
      { value: prepatch, name: `Prepatch (${prepatch})` },
      { value: preminor, name: `Preminor (${preminor})` },
      { value: premajor, name: `Premajor (${premajor})` },
      { value: "PRERELEASE", name: "Custom Prerelease" },
      { value: "CUSTOM", name: "Custom Version" }
    ]
  }).then((choice) => {
    if (choice === "CUSTOM") {
      return promptTextInput("Enter a custom version", {
        filter: import_semver8.default.valid,
        // semver.valid() always returns null with invalid input
        validate: (v) => v !== null || "Must be a valid semver version"
      });
    }
    if (choice === "PRERELEASE") {
      const defaultVersion = import_semver8.default.inc(currentVersion, "prerelease", prereleaseId);
      const prompt = `(default: "${prereleaseId}", yielding ${defaultVersion})`;
      return promptTextInput(`Enter a prerelease identifier ${prompt}`, {
        filter: (v) => applyBuildMetadata(import_semver8.default.inc(currentVersion, "prerelease", v || prereleaseId), buildMetadata)
      });
    }
    return choice;
  });
}
var import_semver8;
var init_prompt_version = __esm({
  "libs/commands/version/src/lib/prompt-version.ts"() {
    "use strict";
    init_src();
    import_semver8 = __toESM(require("semver"));
  }
});

// libs/commands/version/src/lib/remote-branch-exists.ts
function remoteBranchExists(gitRemote, branch, opts) {
  import_npmlog57.default.silly("remoteBranchExists", "");
  const remoteBranch = `${gitRemote}/${branch}`;
  try {
    childProcess23.execSync("git", ["show-ref", "--verify", `refs/remotes/${remoteBranch}`], opts);
    return true;
  } catch (e) {
    return false;
  }
}
var import_npmlog57, childProcess23;
var init_remote_branch_exists = __esm({
  "libs/commands/version/src/lib/remote-branch-exists.ts"() {
    "use strict";
    import_npmlog57 = __toESM(require("npmlog"));
    childProcess23 = require("@lerna/child-process");
  }
});

// libs/commands/version/src/lib/update-lockfile-version.ts
async function updateLockfileVersion(pkg2) {
  const lockfilePath = import_path22.default.join(pkg2.location, "package-lock.json");
  const obj = await (0, import_load_json_file3.default)(lockfilePath).catch(() => {
    import_npmlog58.default.verbose("version", `${pkg2.name} has no lockfile. Skipping lockfile update.`);
  });
  if (!obj) {
    return;
  }
  obj.version = pkg2.version;
  if (obj.packages && obj.packages[""]) {
    obj.packages[""].version = pkg2.version;
    if (obj.packages[""].dependencies) {
      const updatedPkgDependencies = Object.keys(obj.packages[""].dependencies).reduce(
        (prev, next) => ({ ...prev, [next]: pkg2.dependencies?.[next] }),
        {}
      );
      obj.packages[""].dependencies = updatedPkgDependencies;
    }
    if (obj.packages[""].devDependencies) {
      const updatedPkgDevDependencies = Object.keys(obj.packages[""].devDependencies).reduce(
        (prev, next) => ({ ...prev, [next]: pkg2.devDependencies?.[next] }),
        {}
      );
      obj.packages[""].devDependencies = updatedPkgDevDependencies;
    }
  }
  (0, import_devkit6.writeJsonFile)(lockfilePath, obj, {
    spaces: 2
  });
  return lockfilePath;
}
var import_devkit6, import_load_json_file3, import_npmlog58, import_path22;
var init_update_lockfile_version = __esm({
  "libs/commands/version/src/lib/update-lockfile-version.ts"() {
    "use strict";
    import_devkit6 = require("@nx/devkit");
    import_load_json_file3 = __toESM(require("load-json-file"));
    import_npmlog58 = __toESM(require("npmlog"));
    import_path22 = __toESM(require("path"));
  }
});

// libs/commands/version/src/index.ts
var require_src8 = __commonJS({
  "libs/commands/version/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_chalk4 = __toESM(require("chalk"));
    var import_dedent6 = __toESM(require("dedent"));
    var import_execa3 = __toESM(require("execa"));
    var import_fs7 = __toESM(require("fs"));
    var import_minimatch4 = __toESM(require("minimatch"));
    var import_os7 = __toESM(require("os"));
    var import_p_map8 = __toESM(require("p-map"));
    var import_p_pipe = __toESM(require("p-pipe"));
    var import_p_reduce = __toESM(require("p-reduce"));
    var import_p_waterfall = __toESM(require("p-waterfall"));
    var import_path25 = __toESM(require("path"));
    var import_semver9 = __toESM(require("semver"));
    init_create_release();
    init_get_current_branch();
    init_git_add();
    init_git_commit();
    init_git_push();
    init_git_tag();
    init_is_anything_committed();
    init_is_behind_upstream();
    init_is_breaking_change();
    init_prompt_version();
    init_remote_branch_exists();
    init_update_lockfile_version();
    var childProcess27 = require("@lerna/child-process");
    module2.exports = function factory2(argv, preInitializedProjectData) {
      return new VersionCommand(argv, preInitializedProjectData);
    };
    var VersionCommand = class extends Command {
      options;
      commitAndTag;
      pushToRemote;
      allowBranch;
      gitRemote;
      tagPrefix;
      releaseClient;
      releaseNotes;
      gitOpts;
      savePrefix;
      currentBranch;
      updates = [];
      tags;
      globalVersion;
      hasRootedLeaf;
      runPackageLifecycle;
      runRootLifecycle;
      updatesVersions;
      packagesToVersion;
      projectsWithPackage = [];
      get otherCommandConfigs() {
        return ["publish"];
      }
      get requiresGit() {
        return !!(this.commitAndTag || this.pushToRemote || this.options.allowBranch || this.options.conventionalCommits);
      }
      /**
       * Due to lerna publish's legacy of being backwards compatible with running versioning and publishing
       * in a single step, we need to be able to receive any project data which might already exist from the
       * publish command (in the case that it invokes the version command from within its implementation details).
       */
      constructor(argv, preInitializedProjectData) {
        super(argv, { skipValidations: false, preInitializedProjectData });
      }
      configureProperties() {
        super.configureProperties();
        const {
          amend,
          commitHooks = true,
          gitRemote = "origin",
          gitTagVersion = true,
          granularPathspec = true,
          push = true,
          signGitCommit,
          signoffGitCommit,
          signGitTag,
          forceGitTag,
          tagVersionPrefix = "v"
        } = this.options;
        this.gitRemote = gitRemote;
        this.tagPrefix = tagVersionPrefix;
        this.commitAndTag = gitTagVersion;
        this.pushToRemote = gitTagVersion && amend !== true && push;
        this.releaseClient = this.pushToRemote && this.options.createRelease && createReleaseClient(this.options.createRelease);
        this.releaseNotes = [];
        if (this.releaseClient && this.options.conventionalCommits !== true) {
          throw new ValidationError("ERELEASE", "To create a release, you must enable --conventional-commits");
        }
        if (this.releaseClient && this.options.changelog === false) {
          throw new ValidationError("ERELEASE", "To create a release, you cannot pass --no-changelog");
        }
        this.gitOpts = {
          amend,
          commitHooks,
          granularPathspec,
          signGitCommit,
          signoffGitCommit,
          signGitTag,
          forceGitTag
        };
        this.savePrefix = this.options.exact ? "" : "^";
      }
      async initialize() {
        if (!this.project.isIndependent()) {
          this.logger.info("current version", this.project.version);
        }
        if (this.requiresGit) {
          if (!isAnythingCommitted(this.execOpts)) {
            throw new ValidationError(
              "ENOCOMMIT",
              "No commits in this repository. Please commit something before using version."
            );
          }
          this.currentBranch = getCurrentBranch(this.execOpts);
          if (this.currentBranch === "HEAD") {
            throw new ValidationError(
              "ENOGIT",
              "Detached git HEAD, please checkout a branch to choose versions."
            );
          }
          if (this.pushToRemote && !remoteBranchExists(this.gitRemote, this.currentBranch, this.execOpts)) {
            throw new ValidationError(
              "ENOREMOTEBRANCH",
              import_dedent6.default`
            Branch '${this.currentBranch}' doesn't exist in remote '${this.gitRemote}'.
            If this is a new branch, please make sure you push it to the remote first.
          `
            );
          }
          if (this.options.allowBranch && ![].concat(this.options.allowBranch).some((x) => (0, import_minimatch4.default)(this.currentBranch, x))) {
            throw new ValidationError(
              "ENOTALLOWED",
              import_dedent6.default`
            Branch '${this.currentBranch}' is restricted from versioning due to allowBranch config.
            Please consider the reasons for this restriction before overriding the option.
          `
            );
          }
          if (this.commitAndTag && this.pushToRemote && isBehindUpstream(this.gitRemote, this.currentBranch, this.execOpts)) {
            const message = `Local branch '${this.currentBranch}' is behind remote upstream ${this.gitRemote}/${this.currentBranch}`;
            if (!this.options.ci) {
              throw new ValidationError(
                "EBEHIND",
                import_dedent6.default`
              ${message}
              Please merge remote changes into '${this.currentBranch}' with 'git pull'
            `
              );
            }
            this.logger.warn("EBEHIND", `${message}, exiting`);
            return false;
          }
        } else {
          this.logger.notice(
            "FYI",
            "git repository validation has been skipped, please ensure your version bumps are correct"
          );
        }
        if (this.options.conventionalPrerelease && this.options.conventionalGraduate) {
          throw new ValidationError(
            "ENOTALLOWED",
            import_dedent6.default`
          --conventional-prerelease cannot be combined with --conventional-graduate.
        `
          );
        }
        this.projectsWithPackage = Object.values(this.projectGraph.nodes).filter((node) => !!node.package);
        this.updates = collectProjectUpdates(
          this.projectsWithPackage,
          this.projectGraph,
          this.execOpts,
          this.options
        ).filter((node) => {
          const pkg2 = getPackage(node);
          if (pkg2.private && this.options.private === false) {
            return false;
          }
          if (!pkg2.version) {
            if (pkg2.private) {
              this.logger.info("version", "Skipping unversioned private package %j", pkg2.name);
            } else {
              throw new ValidationError(
                "ENOVERSION",
                import_dedent6.default`
              A version field is required in ${pkg2.name}'s package.json file.
              If you wish to keep the package unversioned, it must be made private.
            `
              );
            }
          }
          return !!pkg2.version;
        });
        if (!this.updates.length) {
          this.logger.success(`No changed packages to ${this.composed ? "publish" : "version"}`);
          return false;
        }
        this.hasRootedLeaf = !!this.projectGraph.nodes[this.project.manifest.name];
        if (this.hasRootedLeaf && !this.composed) {
          this.logger.info("version", "rooted leaf detected, skipping synthetic root lifecycles");
        }
        this.runPackageLifecycle = createRunner({ ...this.options, stdio: "inherit" });
        this.runRootLifecycle = /^(pre|post)?version$/.test(process.env.npm_lifecycle_event) ? (stage) => {
          this.logger.warn("lifecycle", "Skipping root %j because it has already been called", stage);
        } : (stage) => this.runPackageLifecycle(this.project.manifest, stage);
        if (this.commitAndTag && this.gitOpts.amend !== true) {
          const { forcePublish, conventionalCommits, conventionalGraduate } = this.options;
          const checkUncommittedOnly = forcePublish || conventionalCommits && conventionalGraduate;
          const check = checkUncommittedOnly ? throwIfUncommitted : checkWorkingTree;
          await check(this.execOpts);
        } else {
          this.logger.warn("version", "Skipping working tree validation, proceed at your own risk");
        }
        const versions = await this.getVersionsForUpdates();
        this.setUpdatesForVersions(versions);
        return this.confirmVersions();
      }
      execute() {
        const tasks = [() => this.updatePackageVersions()];
        if (this.commitAndTag) {
          tasks.push(() => this.commitAndTagUpdates());
        } else {
          this.logger.info("execute", "Skipping git tag/commit");
        }
        if (this.pushToRemote) {
          tasks.push(() => this.gitPushToRemote());
        } else {
          this.logger.info("execute", "Skipping git push");
        }
        if (this.releaseClient) {
          this.logger.info("execute", "Creating releases...");
          tasks.push(
            () => createRelease(
              this.releaseClient,
              { tags: this.tags, releaseNotes: this.releaseNotes },
              { gitRemote: this.options.gitRemote, execOpts: this.execOpts }
            )
          );
        } else {
          this.logger.info("execute", "Skipping releases");
        }
        return (0, import_p_waterfall.default)(tasks).then(() => {
          if (!this.composed) {
            this.logger.success("version", "finished");
          }
          return {
            updates: this.updates,
            updatesVersions: this.updatesVersions
          };
        });
      }
      /**
       * Gets a mapping of project names to their package's new version.
       * @returns {Promise<Record<string, string>>} A map of project names to their package's new versions
       */
      getVersionsForUpdates() {
        const independentVersions = this.project.isIndependent();
        const { bump, conventionalCommits, preid } = this.options;
        const repoVersion = bump ? import_semver9.default.clean(bump) : "";
        const increment = bump && !import_semver9.default.valid(bump) ? bump : "";
        const resolvePrereleaseId = (existingPreid) => preid || existingPreid || "alpha";
        const makeGlobalVersionPredicate = (nextVersion) => {
          this.globalVersion = nextVersion;
          return () => nextVersion;
        };
        let predicate;
        if (repoVersion) {
          predicate = makeGlobalVersionPredicate(applyBuildMetadata(repoVersion, this.options.buildMetadata));
        } else if (increment && independentVersions) {
          predicate = (node) => applyBuildMetadata(
            import_semver9.default.inc(node.version, increment, resolvePrereleaseId(node.prereleaseId)),
            this.options.buildMetadata
          );
        } else if (increment) {
          const baseVersion = this.project.version;
          const prereleaseId = prereleaseIdFromVersion(baseVersion);
          const nextVersion = applyBuildMetadata(
            import_semver9.default.inc(baseVersion, increment, resolvePrereleaseId(prereleaseId)),
            this.options.buildMetadata
          );
          predicate = makeGlobalVersionPredicate(nextVersion);
        } else if (conventionalCommits) {
          return this.recommendVersions(resolvePrereleaseId);
        } else if (independentVersions) {
          predicate = makePromptVersion(resolvePrereleaseId, this.options.buildMetadata);
        } else {
          const baseVersion = this.project.version;
          const prereleaseId = prereleaseIdFromVersion(baseVersion);
          const node = { version: baseVersion, prereleaseId };
          const prompt = makePromptVersion(resolvePrereleaseId, this.options.buildMetadata);
          predicate = prompt(node).then(makeGlobalVersionPredicate);
        }
        return Promise.resolve(predicate).then(
          (getVersion) => this.reduceVersions((node) => {
            const pkg2 = getPackage(node);
            return getVersion({
              version: pkg2.version,
              name: pkg2.name,
              prereleaseId: prereleaseIdFromVersion(pkg2.version)
            });
          })
        );
      }
      reduceVersions(getVersion) {
        const iterator = (versionMap, node) => Promise.resolve(getVersion(node)).then((version) => versionMap.set(node.name, version));
        return (0, import_p_reduce.default)(this.updates, iterator, /* @__PURE__ */ new Map());
      }
      getPrereleasePackageNames() {
        const prereleasePackageNames = getPackagesForOption(this.options.conventionalPrerelease);
        const isCandidate = prereleasePackageNames.has("*") ? () => true : (node, name) => prereleasePackageNames.has(name);
        return collectProjects(this.projectsWithPackage, this.projectGraph, { isCandidate }).map(
          (pkg2) => pkg2.name
        );
      }
      async recommendVersions(resolvePrereleaseId) {
        const independentVersions = this.project.isIndependent();
        const { buildMetadata, changelogPreset, conventionalGraduate, conventionalBumpPrerelease } = this.options;
        const rootPath = this.project.manifest.location;
        const type = independentVersions ? "independent" : "fixed";
        const prereleasePackageNames = this.getPrereleasePackageNames();
        const graduatePackageNames = Array.from(getPackagesForOption(conventionalGraduate));
        const shouldPrerelease = (name) => prereleasePackageNames && prereleasePackageNames.includes(name);
        const shouldGraduate = (name) => graduatePackageNames.includes("*") || graduatePackageNames.includes(name);
        const getPrereleaseId = (node) => {
          if (!shouldGraduate(node.name) && (shouldPrerelease(node.name) || node.prereleaseId)) {
            return resolvePrereleaseId(node.prereleaseId);
          }
        };
        if (type === "fixed") {
          this.setGlobalVersionFloor();
        }
        const versions = await this.reduceVersions((node) => {
          const pkg2 = getPackage(node);
          return recommendVersion(pkg2, type, {
            changelogPreset,
            rootPath,
            tagPrefix: this.tagPrefix,
            prereleaseId: getPrereleaseId({
              name: node.name,
              prereleaseId: prereleaseIdFromVersion(pkg2.version)
            }),
            conventionalBumpPrerelease,
            buildMetadata
          });
        });
        if (type === "fixed") {
          this.globalVersion = await this.setGlobalVersionCeiling(versions);
        }
        return versions;
      }
      setGlobalVersionFloor() {
        const globalVersion = this.project.version;
        for (const node of this.updates) {
          const pkg2 = getPackage(node);
          if (import_semver9.default.lt(pkg2.version, globalVersion)) {
            this.logger.verbose(
              "version",
              `Overriding version of ${pkg2.name} from ${pkg2.version} to ${globalVersion}`
            );
            pkg2.set("version", globalVersion);
          }
        }
      }
      setGlobalVersionCeiling(versions) {
        let highestVersion = this.project.version;
        versions.forEach((bump) => {
          if (bump && import_semver9.default.gt(bump, highestVersion)) {
            highestVersion = bump;
          }
        });
        versions.forEach((_, name) => versions.set(name, highestVersion));
        return highestVersion;
      }
      setUpdatesForVersions(versions) {
        if (this.project.isIndependent() || versions.size === this.projectsWithPackage.length) {
          this.updatesVersions = versions;
        } else {
          let hasBreakingChange;
          for (const [name, bump] of versions) {
            const pkg2 = getPackage(this.projectGraph.nodes[name]);
            hasBreakingChange = hasBreakingChange || isBreakingChange(pkg2.version, bump);
          }
          if (hasBreakingChange) {
            this.updates = this.projectsWithPackage;
            if (this.options.private === false) {
              this.updates = this.updates.filter((node) => !getPackage(node).private);
            }
            this.updatesVersions = new Map(this.updates.map((node) => [node.name, this.globalVersion]));
          } else {
            this.updatesVersions = versions;
          }
        }
        this.packagesToVersion = this.updates.map((node) => getPackage(node));
      }
      confirmVersions() {
        if (this.options.json) {
          const updatedProjectsJson = formatJSON(this.updates, ({ name }) => ({
            newVersion: this.updatesVersions.get(name)
          }));
          output(updatedProjectsJson);
        } else {
          const changes = this.updates.map((node) => {
            const pkg2 = getPackage(node);
            let line = ` - ${pkg2.name}: ${pkg2.version} => ${this.updatesVersions.get(node.name)}`;
            if (pkg2.private) {
              line += ` (${import_chalk4.default.red("private")})`;
            }
            return line;
          });
          output("");
          output("Changes:");
          output(changes.join(import_os7.default.EOL));
          output("");
        }
        if (this.options.yes) {
          this.logger.info("auto-confirmed", "");
          return true;
        }
        const message = this.composed ? "Are you sure you want to publish these packages?" : "Are you sure you want to create these versions?";
        return promptConfirmation(message);
      }
      async updatePackageVersions() {
        const {
          conventionalCommits,
          changelogPreset,
          changelogEntryAdditionalMarkdown,
          changelog = true,
          runScriptsOnLockfileUpdate = false,
          syncDistVersion = false
        } = this.options;
        const independentVersions = this.project.isIndependent();
        const rootPath = this.project.manifest.location;
        const changedFiles = /* @__PURE__ */ new Set();
        if (!this.hasRootedLeaf) {
          await this.runRootLifecycle("preversion");
        }
        const actions = [
          (node) => this.runPackageLifecycle(getPackage(node), "preversion").then(() => node),
          // manifest may be mutated by any previous lifecycle
          (node) => getPackage(node).refresh().then(() => node),
          (node) => {
            const pkg2 = getPackage(node);
            pkg2.version = this.updatesVersions.get(node.name);
            this.updateDependencies(node);
            return Promise.all([
              updateLockfileVersion(pkg2),
              pkg2.serialize(),
              pkg2.syncDistVersion(syncDistVersion)
            ]).then(([lockfilePath]) => {
              changedFiles.add(pkg2.manifestLocation);
              if (lockfilePath) {
                changedFiles.add(lockfilePath);
              }
              return node;
            });
          },
          (node) => this.runPackageLifecycle(getPackage(node), "version").then(() => node)
        ];
        if (conventionalCommits && changelog) {
          const type = independentVersions ? "independent" : "fixed";
          actions.push(
            (node) => updateChangelog(getPackage(node), type, {
              changelogPreset,
              changelogEntryAdditionalMarkdown,
              rootPath,
              tagPrefix: this.tagPrefix
            }).then(({ logPath, newEntry }) => {
              changedFiles.add(logPath);
              if (independentVersions) {
                this.releaseNotes.push({
                  name: getPackage(node).name,
                  notes: newEntry
                });
              }
              return node;
            })
          );
        }
        const mapUpdate = (0, import_p_pipe.default)(...actions);
        await runProjectsTopologically(this.updates, this.projectGraph, mapUpdate, {
          concurrency: this.concurrency,
          rejectCycles: this.options.rejectCycles
        });
        if (!independentVersions) {
          this.project.version = this.globalVersion;
          if (conventionalCommits && changelog) {
            const { logPath, newEntry } = await updateChangelog(this.project.manifest, "root", {
              changelogPreset,
              changelogEntryAdditionalMarkdown,
              rootPath,
              tagPrefix: this.tagPrefix,
              version: this.globalVersion
            });
            changedFiles.add(logPath);
            this.releaseNotes.push({
              name: "fixed",
              notes: newEntry
            });
          }
          const lernaConfigLocation = await Promise.resolve(this.project.serializeConfig());
          changedFiles.add(lernaConfigLocation);
        }
        const npmClientArgsRaw = this.options.npmClientArgs || [];
        const npmClientArgs = npmClientArgsRaw.reduce((args, arg) => args.concat(arg.split(/\s|,/)), []);
        if (!this.hasRootedLeaf) {
          await this.runRootLifecycle("version");
        }
        if (this.options.npmClient === "pnpm") {
          this.logger.verbose("version", "Updating root pnpm-lock.yaml");
          await childProcess27.exec(
            "pnpm",
            [
              "install",
              "--lockfile-only",
              !runScriptsOnLockfileUpdate ? "--ignore-scripts" : "",
              ...npmClientArgs
            ].filter(Boolean),
            this.execOpts
          );
          const lockfilePath = import_path25.default.join(this.project.rootPath, "pnpm-lock.yaml");
          changedFiles.add(lockfilePath);
        }
        if (this.options.npmClient === "yarn") {
          const yarnVersion = await childProcess27.execSync("yarn", ["--version"], this.execOpts);
          this.logger.verbose("version", `Detected yarn version ${yarnVersion}`);
          if (import_semver9.default.gte(yarnVersion, "2.0.0")) {
            this.logger.verbose("version", "Updating root yarn.lock");
            await childProcess27.exec("yarn", ["install", "--mode", "update-lockfile", ...npmClientArgs], {
              ...this.execOpts,
              env: {
                ...process.env,
                YARN_ENABLE_SCRIPTS: false
              }
            });
            const lockfilePath = import_path25.default.join(this.project.rootPath, "yarn.lock");
            changedFiles.add(lockfilePath);
          }
        }
        if (this.options.npmClient === "npm" || !this.options.npmClient) {
          const lockfilePath = import_path25.default.join(this.project.rootPath, "package-lock.json");
          if (import_fs7.default.existsSync(lockfilePath)) {
            this.logger.verbose("version", "Updating root package-lock.json");
            await childProcess27.exec(
              "npm",
              [
                "install",
                "--package-lock-only",
                !runScriptsOnLockfileUpdate ? "--ignore-scripts" : "",
                ...npmClientArgs
              ].filter(Boolean),
              this.execOpts
            );
            changedFiles.add(lockfilePath);
          }
        }
        if (this.commitAndTag) {
          await gitAdd(Array.from(changedFiles), this.gitOpts, this.execOpts);
        }
      }
      updateDependencies(node) {
        const dependencies = this.projectGraph.localPackageDependencies[node.name] || [];
        const pkg2 = getPackage(node);
        dependencies.forEach((dep) => {
          const depVersion = this.updatesVersions.get(dep.target);
          if (
            // only update if the dependency version is being changed
            depVersion && // don't overwrite local file: specifiers, they only change during publish
            dep.targetResolvedNpaResult.type !== "directory"
          ) {
            pkg2.updateLocalDependency(dep.targetResolvedNpaResult, depVersion, this.savePrefix);
          }
        });
      }
      async commitAndTagUpdates() {
        let tags = [];
        if (this.project.isIndependent()) {
          tags = await this.gitCommitAndTagVersionForUpdates();
        } else {
          tags = await this.gitCommitAndTagVersion();
        }
        this.tags = tags;
        await (0, import_p_map8.default)(this.packagesToVersion, (pkg2) => this.runPackageLifecycle(pkg2, "postversion"));
        if (!this.hasRootedLeaf) {
          await this.runRootLifecycle("postversion");
        }
      }
      async gitCommitAndTagVersionForUpdates() {
        const tags = this.updates.map((node) => {
          const pkg2 = getPackage(node);
          return `${pkg2.name}@${this.updatesVersions.get(node.name)}`;
        });
        const subject = this.options.message || "Publish";
        const message = tags.reduce((msg, tag) => `${msg}${import_os7.default.EOL} - ${tag}`, `${subject}${import_os7.default.EOL}`);
        if (await this.hasChanges()) {
          await gitCommit(message, this.gitOpts, this.execOpts);
        }
        if (this.gitOpts.signGitTag) {
          for (const tag in tags)
            await gitTag(tag, this.gitOpts, this.execOpts, this.options.gitTagCommand);
        } else {
          await Promise.all(
            tags.map((tag) => gitTag(tag, this.gitOpts, this.execOpts, this.options.gitTagCommand))
          );
        }
        return tags;
      }
      async gitCommitAndTagVersion() {
        const version = this.globalVersion;
        const tag = `${this.tagPrefix}${version}`;
        const message = this.options.message ? this.options.message.replace(/%s/g, tag).replace(/%v/g, version) : tag;
        if (await this.hasChanges()) {
          await gitCommit(message, this.gitOpts, this.execOpts);
        }
        await gitTag(tag, this.gitOpts, this.execOpts, this.options.gitTagCommand);
        return [tag];
      }
      gitPushToRemote() {
        this.logger.info("git", "Pushing tags...");
        return gitPush(this.gitRemote, this.currentBranch, this.execOpts);
      }
      async hasChanges() {
        try {
          await (0, import_execa3.default)("git", ["diff", "--staged", "--quiet"], { stdio: "pipe", ...this.execOpts });
        } catch (e) {
          return true;
        }
      }
    };
    module2.exports.VersionCommand = VersionCommand;
  }
});

// libs/commands/version/src/command.ts
var require_command9 = __commonJS({
  "libs/commands/version/src/command.ts"(exports2, module2) {
    "use strict";
    var import_npmlog65 = __toESM(require("npmlog"));
    var import_semver9 = __toESM(require("semver"));
    function addBumpPositional(yargs2, additionalKeywords = []) {
      const semverKeywords = ["major", "minor", "patch", "premajor", "preminor", "prepatch", "prerelease"].concat(
        additionalKeywords
      );
      const bumpOptionList = `'${semverKeywords.slice(0, -1).join("', '")}', or '${semverKeywords[semverKeywords.length - 1]}'.`;
      yargs2.positional("bump", {
        describe: `Increment version(s) by explicit version _or_ semver keyword,
${bumpOptionList}`,
        type: "string",
        coerce: (choice) => {
          if (!import_semver9.default.valid(choice) && semverKeywords.indexOf(choice) === -1) {
            throw new Error(`bump must be an explicit version string _or_ one of: ${bumpOptionList}`);
          }
          return choice;
        }
      });
    }
    var command = {
      command: "version [bump]",
      describe: "Bump version of packages changed since the last release",
      // TODO: refactor based on TS feedback
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      builder(yargs2, composed) {
        const opts = {
          "allow-branch": {
            describe: "Specify which branches to allow versioning from.",
            type: "array"
          },
          amend: {
            describe: "Amend the existing commit, instead of generating a new one.",
            type: "boolean"
          },
          "build-metadata": {
            describe: "Apply semver-compatible build metadata to the release",
            requiresArg: true,
            type: "string"
          },
          "conventional-commits": {
            describe: "Use conventional-changelog to determine version bump and generate CHANGELOG.",
            type: "boolean"
          },
          "conventional-graduate": {
            describe: "Version currently prereleased packages to a non-prerelease version."
            // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
          },
          "force-conventional-graduate": {
            describe: "Forces all packages specified by --conventional-graduate to bump their version whether or not they are a prerelease or have changes since the previous version.",
            type: "boolean"
          },
          "conventional-prerelease": {
            describe: "Version changed packages as prereleases when using --conventional-commits."
            // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
          },
          "conventional-bump-prerelease": {
            describe: "Bumps prerelease versions if conventional commits requires it.",
            type: "boolean"
          },
          "changelog-preset": {
            describe: "Custom conventional-changelog preset.",
            type: "string",
            requiresArg: true,
            defaultDescription: "angular"
          },
          "changelog-entry-additional-markdown": {
            describe: "Additional markdown to add to CHANGELOG.md entries.",
            type: "string"
          },
          exact: {
            describe: "Specify cross-dependency version numbers exactly rather than with a caret (^).",
            type: "boolean"
          },
          "force-publish": {
            describe: "Always include targeted packages in versioning operations, skipping default logic."
            // type must remain ambiguous because it is overloaded (boolean _or_ string _or_ array)
          },
          "git-remote": {
            describe: "Push git changes to the specified remote.",
            type: "string",
            requiresArg: true,
            defaultDescription: "origin"
          },
          "create-release": {
            describe: "Create an official GitHub or GitLab release for every version.",
            type: "string",
            choices: ["gitlab", "github"]
          },
          "ignore-changes": {
            describe: [
              "Ignore changes in files matched by glob(s) when detecting changed packages.",
              "Pass --no-ignore-changes to completely disable."
            ].join("\n"),
            type: "array"
          },
          "ignore-scripts": {
            describe: "Disable all lifecycle scripts",
            type: "boolean"
          },
          "include-merged-tags": {
            describe: "Include tags from merged branches when detecting changed packages.",
            type: "boolean"
          },
          json: {
            describe: "Outputs changed packages in json format",
            type: "boolean"
          },
          m: {
            describe: "Use a custom commit message when creating the version commit.",
            alias: "message",
            type: "string",
            requiresArg: true
          },
          "no-changelog": {
            describe: "Do not generate CHANGELOG.md files when using --conventional-commits.",
            type: "boolean"
          },
          changelog: {
            // proxy for --no-changelog
            hidden: true,
            type: "boolean"
          },
          "no-commit-hooks": {
            describe: "Do not run git commit hooks when committing version changes.",
            type: "boolean"
          },
          "commit-hooks": {
            // proxy for --no-commit-hooks
            hidden: true,
            type: "boolean"
          },
          "no-git-tag-version": {
            describe: "Do not commit or tag version changes.",
            type: "boolean"
          },
          "git-tag-version": {
            // proxy for --no-git-tag-version
            hidden: true,
            type: "boolean"
          },
          "sync-dist-version": {
            describe: "Update the version of the package.json of the contents directory.",
            type: "boolean"
          },
          // TODO: (major) make --no-granular-pathspec the default
          "no-granular-pathspec": {
            describe: "Do not stage changes file-by-file, but globally.",
            type: "boolean"
          },
          "granular-pathspec": {
            // proxy for --no-granular-pathspec
            hidden: true,
            // describe: "Stage changes file-by-file, not globally.",
            type: "boolean"
          },
          // TODO: (major) make --no-private the default
          "no-private": {
            describe: "Do not version private packages.",
            type: "boolean"
          },
          private: {
            // proxy for --no-private
            hidden: true,
            type: "boolean"
          },
          "no-push": {
            describe: "Do not push tagged commit to git remote.",
            type: "boolean"
          },
          push: {
            // proxy for --no-push
            hidden: true,
            type: "boolean"
          },
          // preid is copied into ../publish/command because a whitelist for one option isn't worth it
          preid: {
            describe: "Specify the prerelease identifier when versioning a prerelease",
            type: "string",
            requiresArg: true,
            defaultDescription: "alpha"
          },
          "sign-git-commit": {
            describe: "Pass the `--gpg-sign` flag to `git commit`.",
            type: "boolean"
          },
          "signoff-git-commit": {
            describe: "Pass the `--signoff` flag to `git commit`.",
            type: "boolean"
          },
          "sign-git-tag": {
            describe: "Pass the `--sign` flag to `git tag`.",
            type: "boolean"
          },
          "force-git-tag": {
            describe: "Pass the `--force` flag to `git tag`.",
            type: "boolean"
          },
          "tag-version-prefix": {
            describe: "Customize the tag prefix. To remove entirely, pass an empty string.",
            type: "string",
            requiresArg: true,
            defaultDescription: "v"
          },
          "git-tag-command": {
            describe: "Allows users to specify a custom command to be used when applying git tags. For example, this may be useful for providing a wrapper command in CI/CD pipelines that have no direct write access.",
            type: "string"
          },
          "run-scripts-on-lockfile-update": {
            describe: "Do not disable all lifecycle scripts while updating the lock file after the version bump.",
            type: "boolean"
          },
          "npm-client-args": {
            describe: "Additional arguments to pass to the npm client when performing 'npm install'.",
            type: "array"
          },
          y: {
            describe: "Skip all confirmation prompts.",
            alias: "yes",
            type: "boolean"
          }
        };
        if (composed) {
          Object.keys(opts).forEach((key) => {
            opts[key].hidden = true;
          });
          yargs2.default("composed", composed).hide("composed");
        } else {
          addBumpPositional(yargs2);
        }
        yargs2.options(opts);
        yargs2.parserConfiguration({
          "populate--": true
        });
        if (!composed) {
          yargs2.group(Object.keys(opts), "Command Options:");
        }
        return yargs2.option("ignore", {
          // NOT the same as filter-options --ignore
          hidden: true,
          conflicts: "ignore-changes",
          type: "array"
        }).option("cd-version", {
          hidden: true,
          conflicts: "bump",
          type: "string",
          requiresArg: true
        }).option("repo-version", {
          hidden: true,
          conflicts: "bump",
          type: "string",
          requiresArg: true
        }).option("skip-git", {
          hidden: true,
          type: "boolean"
        }).option("github-release", {
          hidden: true,
          type: "boolean"
        }).check((argv) => {
          if (argv.ignore) {
            throw new Error(
              "--ignore was renamed to --ignore-changes. We recommend running `lerna repair` in order to ensure your lerna.json is up to date, otherwise check your CLI usage and/or any configs you extend from."
            );
          }
          if (argv.cdVersion) {
            throw new Error(
              "--cd-version was replaced by positional [bump]. We recommend running `lerna repair` in order to ensure your lerna.json is up to date, otherwise check your CLI usage and/or any configs you extend from."
            );
          }
          if (argv.repoVersion) {
            throw new Error(
              "--repo-version was replaced by positional [bump]. We recommend running `lerna repair` in order to ensure your lerna.json is up to date, otherwise check your CLI usage and/or any configs you extend from."
            );
          }
          if (argv.skipGit) {
            throw new Error(
              "--skip-git was replaced by --no-git-tag-version --no-push. We recommend running `lerna repair` in order to ensure your lerna.json is up to date, otherwise check your CLI usage and/or any configs you extend from."
            );
          }
          if (argv.githubRelease) {
            throw new Error(
              "--github-release was replaced by --create-release=github. We recommend running `lerna repair` in order to ensure your lerna.json is up to date, otherwise check your CLI usage and/or any configs you extend from."
            );
          }
          if (argv["--"]) {
            import_npmlog65.default.warn("EDOUBLEDASH", "Arguments after -- are no longer passed to subprocess executions.");
            import_npmlog65.default.warn("EDOUBLEDASH", "This will cause an error in a future major version.");
          }
          return argv;
        });
      },
      handler(argv) {
        return require_src8()(argv);
      },
      addBumpPositional
    };
    module2.exports = command;
  }
});

// libs/commands/publish/src/lib/create-temp-licenses.ts
function createTempLicenses(srcLicensePath, packagesToBeLicensed) {
  if (!srcLicensePath || !packagesToBeLicensed.length) {
    return Promise.resolve();
  }
  const licenseFileName = import_path23.default.basename(srcLicensePath);
  const options = {
    // make an effort to keep package contents stable over time
    preserveTimestamps: process.arch !== "ia32"
    // (give up on 32-bit architecture to avoid fs-extra warning)
  };
  packagesToBeLicensed.forEach((pkg2) => {
    pkg2.licensePath = import_path23.default.join(pkg2.contents, licenseFileName);
  });
  return (0, import_p_map5.default)(packagesToBeLicensed, (pkg2) => import_fs_extra12.default.copy(srcLicensePath, pkg2.licensePath, options));
}
var import_fs_extra12, import_p_map5, import_path23;
var init_create_temp_licenses = __esm({
  "libs/commands/publish/src/lib/create-temp-licenses.ts"() {
    "use strict";
    import_fs_extra12 = __toESM(require("fs-extra"));
    import_p_map5 = __toESM(require("p-map"));
    import_path23 = __toESM(require("path"));
  }
});

// libs/commands/publish/src/lib/get-current-sha.ts
function getCurrentSHA(opts) {
  import_npmlog59.default.silly("getCurrentSHA", "");
  const sha = childProcess24.execSync("git", ["rev-parse", "HEAD"], opts);
  import_npmlog59.default.verbose("getCurrentSHA", sha);
  return sha;
}
var import_npmlog59, childProcess24;
var init_get_current_sha = __esm({
  "libs/commands/publish/src/lib/get-current-sha.ts"() {
    "use strict";
    import_npmlog59 = __toESM(require("npmlog"));
    childProcess24 = require("@lerna/child-process");
  }
});

// libs/commands/publish/src/lib/get-current-tags.ts
async function getCurrentTags(execOpts, matchingPattern) {
  import_npmlog60.default.silly("getCurrentTags", "matching %j", matchingPattern);
  const opts = Object.assign({}, execOpts, {
    // don't reject due to non-zero exit code when there are no results
    reject: false
  });
  const result = await childProcess25.exec(
    "git",
    ["tag", "--sort", "version:refname", "--points-at", "HEAD", "--list", matchingPattern],
    opts
  );
  const lines = result.stdout.split("\n").filter(Boolean);
  if (matchingPattern === "*@*") {
    return lines.map((tag) => (0, import_npm_package_arg8.default)(tag).name);
  }
  return lines;
}
var import_npm_package_arg8, import_npmlog60, childProcess25;
var init_get_current_tags = __esm({
  "libs/commands/publish/src/lib/get-current-tags.ts"() {
    "use strict";
    import_npm_package_arg8 = __toESM(require("npm-package-arg"));
    import_npmlog60 = __toESM(require("npmlog"));
    childProcess25 = require("@lerna/child-process");
  }
});

// libs/commands/publish/src/lib/fetch-config.ts
function getFetchConfig(options, extra) {
  return {
    log: import_npmlog61.default,
    ...options,
    ...extra
  };
}
var import_npmlog61;
var init_fetch_config = __esm({
  "libs/commands/publish/src/lib/fetch-config.ts"() {
    "use strict";
    import_npmlog61 = __toESM(require("npmlog"));
  }
});

// libs/commands/publish/src/lib/get-profile-data.ts
function getProfileData(opts) {
  opts.log.verbose("", "Retrieving npm user profile");
  return pulseTillDone(import_npm_registry_fetch2.default.json("/-/npm/v1/user", opts)).then((data) => {
    opts.log.silly("npm profile get", "received %j", data);
    return Object.assign(
      // remap to match legacy whoami format
      { username: data.name },
      data
    );
  });
}
var import_npm_registry_fetch2;
var init_get_profile_data = __esm({
  "libs/commands/publish/src/lib/get-profile-data.ts"() {
    "use strict";
    init_src();
    import_npm_registry_fetch2 = __toESM(require("npm-registry-fetch"));
  }
});

// libs/commands/publish/src/lib/get-whoami.ts
function getWhoAmI(opts) {
  opts.log.verbose("", "Retrieving npm username");
  return pulseTillDone(import_npm_registry_fetch3.default.json("/-/whoami", opts)).then((data) => {
    opts.log.silly("npm whoami", "received %j", data);
    return data;
  });
}
var import_npm_registry_fetch3;
var init_get_whoami = __esm({
  "libs/commands/publish/src/lib/get-whoami.ts"() {
    "use strict";
    init_src();
    import_npm_registry_fetch3 = __toESM(require("npm-registry-fetch"));
  }
});

// libs/commands/publish/src/lib/get-npm-username.ts
function getNpmUsername(options = {}) {
  const opts = getFetchConfig(options, {
    // don't wait forever for third-party failures to be dealt with
    fetchRetries: 0
  });
  opts.log.info("", "Verifying npm credentials");
  return getProfileData(opts).catch((err) => {
    if (err.code === "E500" || err.code === "E404") {
      return getWhoAmI(opts);
    }
    throw err;
  }).then(success, failure);
  function success(result) {
    opts.log.silly("get npm username", "received %j", result);
    if (!result.username) {
      throw new ValidationError(
        "ENEEDAUTH",
        "You must be logged in to publish packages. Use `npm login` and try again."
      );
    }
    return result.username;
  }
  function failure(err) {
    opts.log.pause();
    console.error(err.message);
    opts.log.resume();
    if (opts.registry === "https://registry.npmjs.org/") {
      if (err.code === "E403") {
        throw new ValidationError(
          "ENEEDAUTH",
          "Access verification failed. Ensure that your npm access token has both read and write access, or remove the verifyAccess option to skip this verification. Note that npm automation tokens do NOT have read access (https://docs.npmjs.com/creating-and-viewing-access-tokens)."
        );
      }
      throw new ValidationError("EWHOAMI", "Authentication error. Use `npm whoami` to troubleshoot.");
    }
    opts.log.warn(
      "EWHOAMI",
      "Unable to determine npm username from third-party registry, this command will likely fail soon!"
    );
  }
}
var init_get_npm_username = __esm({
  "libs/commands/publish/src/lib/get-npm-username.ts"() {
    "use strict";
    init_src();
    init_fetch_config();
    init_get_profile_data();
    init_get_whoami();
  }
});

// libs/commands/publish/src/lib/get-packages-without-license.ts
function getPackagesWithoutLicense(project, packagesToPublish) {
  return project.getPackageLicensePaths().then((licensePaths) => {
    const licensed = new Set(licensePaths.map((lp) => import_path24.default.dirname(lp)));
    return packagesToPublish.filter((pkg2) => !licensed.has(pkg2.location));
  });
}
var import_path24;
var init_get_packages_without_license = __esm({
  "libs/commands/publish/src/lib/get-packages-without-license.ts"() {
    "use strict";
    import_path24 = __toESM(require("path"));
  }
});

// libs/commands/publish/src/lib/get-projects-with-tagged-packages.ts
async function getProjectsWithTaggedPackages(projectNodes, projectFileMap, execOpts) {
  import_npmlog62.default.silly("getTaggedPackages", "");
  const result = await childProcess26.exec(
    "git",
    ["diff-tree", "--name-only", "--no-commit-id", "--root", "-r", "-c", "HEAD"],
    execOpts
  );
  const stdout = result.stdout;
  const files = new Set(stdout.split("\n"));
  return projectNodes.filter((node) => projectFileMap[node.name]?.some((file) => files.has(file.file)));
}
var import_npmlog62, childProcess26;
var init_get_projects_with_tagged_packages = __esm({
  "libs/commands/publish/src/lib/get-projects-with-tagged-packages.ts"() {
    "use strict";
    import_npmlog62 = __toESM(require("npmlog"));
    childProcess26 = require("@lerna/child-process");
  }
});

// libs/commands/publish/src/lib/get-projects-with-unpublished-packages.ts
async function getProjectsWithUnpublishedPackages(projectNodes, opts) {
  import_npmlog63.default.silly("getProjectsWithUnpublishedPackages", "");
  const mapper = (node) => {
    const pkg2 = getPackage(node);
    opts["strictSSL"] = opts["strict-ssl"];
    return import_pacote.default.packument(pkg2.name, opts).then(
      (packument) => {
        if (packument.versions === void 0 || packument.versions[pkg2.version] === void 0) {
          return node;
        }
      },
      () => {
        import_npmlog63.default.warn("", "Unable to determine published version, assuming %j unpublished.", pkg2.name);
        return node;
      }
    );
  };
  const results = await (0, import_p_map6.default)(projectNodes, mapper, { concurrency: 4 });
  return results.filter(Boolean);
}
var import_npmlog63, import_p_map6, import_pacote;
var init_get_projects_with_unpublished_packages = __esm({
  "libs/commands/publish/src/lib/get-projects-with-unpublished-packages.ts"() {
    "use strict";
    init_src();
    import_npmlog63 = __toESM(require("npmlog"));
    import_p_map6 = __toESM(require("p-map"));
    import_pacote = __toESM(require("pacote"));
  }
});

// libs/commands/publish/src/lib/get-two-factor-auth-required.ts
function getTwoFactorAuthRequired(options = {}) {
  const opts = getFetchConfig(options, {
    // don't wait forever for third-party failures to be dealt with
    fetchRetries: 0
  });
  opts.log.info("", "Checking two-factor auth mode");
  return getProfileData(opts).then(success, failure);
  function success(result) {
    opts.log.silly("2FA", result.tfa);
    if (result.tfa.pending) {
      return false;
    }
    return result.tfa.mode === "auth-and-writes";
  }
  function failure(err) {
    if (err.code === "E500" || err.code === "E404") {
      opts.log.warn(
        "EREGISTRY",
        `Registry "${opts.registry}" does not support 'npm profile get', skipping two-factor auth check...`
      );
      return false;
    }
    opts.log.pause();
    console.error(err.message);
    opts.log.resume();
    throw new ValidationError("ETWOFACTOR", "Unable to obtain two-factor auth mode");
  }
}
var init_get_two_factor_auth_required = __esm({
  "libs/commands/publish/src/lib/get-two-factor-auth-required.ts"() {
    "use strict";
    init_src();
    init_fetch_config();
    init_get_profile_data();
  }
});

// libs/commands/publish/src/lib/git-checkout.ts
var init_git_checkout2 = __esm({
  "libs/commands/publish/src/lib/git-checkout.ts"() {
    "use strict";
    init_src();
  }
});

// libs/commands/publish/src/lib/interpolate.ts
function interpolate(template, data) {
  const _workspaceRoot = process.env["NX_WORKSPACE_ROOT_PATH"] || import_devkit7.workspaceRoot;
  if (template.includes("{workspaceRoot}", 1)) {
    throw new Error(
      `Config '${template}' is invalid. {workspaceRoot} can only be used at the beginning of the expression.`
    );
  }
  if (data.projectRoot == "." && template.includes("{projectRoot}", 1)) {
    throw new Error(
      `Config '${template}' is invalid. When {projectRoot} is '.', it can only be used at the beginning of the expression.`
    );
  }
  let res = template.replace("{workspaceRoot}", _workspaceRoot);
  if (data.projectRoot == ".") {
    res = res.replace("{projectRoot}/", "");
  }
  return res.replace(/{([\s\S]+?)}/g, (match) => {
    let value = data;
    const path22 = match.slice(1, -1).trim().split(".");
    for (let idx = 0; idx < path22.length; idx++) {
      if (!value[path22[idx]]) {
        return match;
      }
      value = value[path22[idx]];
    }
    return value;
  });
}
var import_devkit7;
var init_interpolate = __esm({
  "libs/commands/publish/src/lib/interpolate.ts"() {
    "use strict";
    import_devkit7 = require("@nx/devkit");
  }
});

// libs/commands/publish/src/lib/remove-temp-licenses.ts
function removeTempLicenses(packagesToBeLicensed) {
  if (!packagesToBeLicensed.length) {
    return Promise.resolve();
  }
  return (0, import_p_map7.default)(packagesToBeLicensed, (pkg2) => import_fs_extra13.default.remove(pkg2.licensePath));
}
var import_fs_extra13, import_p_map7;
var init_remove_temp_licenses = __esm({
  "libs/commands/publish/src/lib/remove-temp-licenses.ts"() {
    "use strict";
    import_fs_extra13 = __toESM(require("fs-extra"));
    import_p_map7 = __toESM(require("p-map"));
  }
});

// libs/commands/publish/src/lib/verify-npm-package-access.ts
function verifyNpmPackageAccess(packages, username, options) {
  const opts = getFetchConfig(options, {
    // don't wait forever for third-party failures to be dealt with
    fetchRetries: 0
  });
  opts.log.silly("verifyNpmPackageAccess", "");
  return pulseTillDone(import_libnpmaccess.default.getPackages(username, opts)).then(success, failure);
  function success(result) {
    const userPackages = Object.keys(result || {});
    if (userPackages.length === 0) {
      opts.log.warn(
        "",
        "The logged-in user does not have any previously-published packages, skipping permission checks..."
      );
      return;
    }
    for (const pkg2 of packages) {
      if (pkg2.name in result && result[pkg2.name] !== "read-write") {
        throw new ValidationError(
          "EACCESS",
          `You do not have write permission required to publish "${pkg2.name}"`
        );
      }
    }
  }
  function failure(err) {
    if (err.code === "E500" || err.code === "E404") {
      opts.log.warn(
        "EREGISTRY",
        "Registry %j does not support `npm access list packages`, skipping permission checks...",
        // registry
        opts.registry
      );
      return;
    }
    opts.log.pause();
    console.error(err.message);
    opts.log.resume();
    throw new ValidationError("EWHOAMI", "Authentication error. Use `npm whoami` to troubleshoot.");
  }
}
var import_libnpmaccess;
var init_verify_npm_package_access = __esm({
  "libs/commands/publish/src/lib/verify-npm-package-access.ts"() {
    "use strict";
    init_src();
    import_libnpmaccess = __toESM(require("libnpmaccess"));
    init_fetch_config();
  }
});

// libs/commands/publish/src/index.ts
var require_src9 = __commonJS({
  "libs/commands/publish/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_devkit8 = require("@nx/devkit");
    var import_crypto = __toESM(require("crypto"));
    var import_fs7 = __toESM(require("fs"));
    var import_os7 = __toESM(require("os"));
    var import_p_map8 = __toESM(require("p-map"));
    var import_p_pipe = __toESM(require("p-pipe"));
    var import_path25 = __toESM(require("path"));
    var import_semver9 = __toESM(require("semver"));
    var import_fs_extra14 = require("fs-extra");
    var import_globby3 = __toESM(require("globby"));
    var import_npm_package_arg9 = __toESM(require("npm-package-arg"));
    init_create_temp_licenses();
    init_get_current_sha();
    init_get_current_tags();
    init_get_npm_username();
    init_get_packages_without_license();
    init_get_projects_with_tagged_packages();
    init_get_projects_with_unpublished_packages();
    init_get_two_factor_auth_required();
    init_git_checkout2();
    init_interpolate();
    init_remove_temp_licenses();
    init_verify_npm_package_access();
    var versionCommand = require_src8();
    module2.exports = function factory2(argv) {
      return new PublishCommand(argv);
    };
    var PublishCommand = class extends Command {
      options;
      savePrefix;
      tagPrefix;
      gitReset;
      npmSession;
      verifyAccess;
      conf;
      otpCache;
      hasRootedLeaf;
      runPackageLifecycle;
      runRootLifecycle;
      updates;
      projectsWithPackage;
      updatesVersions;
      packagesToPublish;
      publishedPackages;
      privatePackagesToPublish;
      packagesToBeLicensed;
      twoFactorAuthRequired;
      uniqueProvenanceUrls = /* @__PURE__ */ new Set();
      get otherCommandConfigs() {
        return ["version"];
      }
      get requiresGit() {
        return this.options.bump !== "from-package";
      }
      configureProperties() {
        super.configureProperties();
        this.toposort = this.options.sort !== false;
        const {
          // prettier-ignore
          exact,
          gitHead,
          gitReset,
          tagVersionPrefix = "v",
          verifyAccess
        } = this.options;
        if (this.requiresGit && gitHead) {
          throw new ValidationError("EGITHEAD", "--git-head is only allowed with 'from-package' positional");
        }
        this.savePrefix = exact ? "" : "^";
        this.tagPrefix = tagVersionPrefix;
        this.gitReset = gitReset !== false;
        this.npmSession = import_crypto.default.randomBytes(8).toString("hex");
        this.verifyAccess = verifyAccess;
      }
      get userAgent() {
        return `lerna/${this.options.lernaVersion}/node@${process.version}+${process.arch} (${process.platform})`;
      }
      async initialize() {
        if (this.options.verifyAccess === false) {
          this.logger.warn(
            "verify-access",
            "--verify-access=false and --no-verify-access are no longer needed, because the legacy preemptive access verification is now disabled by default. Requests will fail with appropriate errors when not authorized correctly."
          );
        }
        if (this.options.includePrivate) {
          if (this.options.includePrivate.length === 0) {
            throw new ValidationError(
              "EINCLPRIV",
              "Must specify at least one private package to include with --include-private."
            );
          }
          this.logger.info("publish", `Including private packages %j`, this.options.includePrivate);
        }
        if (this.options.skipNpm) {
          this.logger.warn("deprecated", "Instead of --skip-npm, call `lerna version` directly");
          return versionCommand(this.argv).then(() => false);
        }
        if (this.options.buildMetadata && this.options.canary) {
          throw new ValidationError(
            "ENOTSATISFIED",
            "Cannot use --build-metadata in conjunction with --canary option."
          );
        } else if (this.options.canary) {
          this.logger.info("canary", "enabled");
        }
        if (this.options.requireScripts) {
          this.logger.info("require-scripts", "enabled");
        }
        this.logger.verbose("session", this.npmSession);
        this.logger.verbose("user-agent", this.userAgent);
        this.conf = npmConf2({
          lernaCommand: "publish",
          _auth: this.options.legacyAuth,
          npmSession: this.npmSession,
          npmVersion: this.userAgent,
          otp: this.options.otp,
          registry: this.options.registry,
          "ignore-prepublish": this.options.ignorePrepublish,
          "ignore-scripts": this.options.ignoreScripts
        });
        this.otpCache = { otp: this.conf.get("otp") };
        this.conf.set("user-agent", this.userAgent, "cli");
        if (this.conf.get("registry") === "https://registry.yarnpkg.com") {
          this.logger.warn("", "Yarn's registry proxy is broken, replacing with public npm registry");
          this.logger.warn("", "If you don't have an npm token, you should exit and run `npm login`");
          this.conf.set("registry", "https://registry.npmjs.org/", "cli");
        }
        const distTag = this.getDistTag();
        if (distTag) {
          this.conf.set("tag", distTag.trim(), "cli");
        }
        this.hasRootedLeaf = !!this.projectGraph.nodes[this.project.manifest.name];
        if (this.hasRootedLeaf) {
          this.logger.info("publish", "rooted leaf detected, skipping synthetic root lifecycles");
        }
        this.runPackageLifecycle = createRunner(this.options);
        this.runRootLifecycle = /^(pre|post)?publish$/.test(process.env.npm_lifecycle_event) ? (stage) => {
          this.logger.warn("lifecycle", "Skipping root %j because it has already been called", stage);
        } : (stage) => this.runPackageLifecycle(this.project.manifest, stage);
        this.projectsWithPackage = Object.values(this.projectGraph.nodes).filter((node) => !!node.package);
        this.projectsWithPackage.map((node) => {
          const interpolateStr = (str) => {
            const res = interpolate(str, {
              projectRoot: node.data.root,
              projectName: node.name,
              workspaceRoot: this.project.rootPath
            });
            this.logger.verbose(
              "silly",
              `Interpolated string "%s" for node "%s" to produce "%s"`,
              str,
              node.name,
              res
            );
            return res;
          };
          const pkg2 = getPackage(node);
          if (this.options.contents) {
            pkg2.contents = this.options.contents;
          }
          if (pkg2.lernaConfig?.command?.publish?.directory) {
            pkg2.contents = interpolateStr(pkg2.lernaConfig.command.publish.directory);
          } else if (this.project.config.command?.publish?.["directory"]) {
            pkg2.contents = interpolateStr(this.project.config.command.publish["directory"]);
          }
          if (pkg2.lernaConfig?.command?.publish?.assets) {
            pkg2.lernaConfig.command.publish.assets = pkg2.lernaConfig.command.publish.assets.map(
              (asset) => interpolateAsset(asset, interpolateStr)
            );
          } else if (this.project.config.command?.publish?.["assets"]) {
            const assets = this.project.config.command?.publish?.["assets"].map(
              (asset) => interpolateAsset(asset, interpolateStr)
            );
            pkg2.lernaConfig = pkg2.lernaConfig || {};
            pkg2.lernaConfig.command = pkg2.lernaConfig.command || {};
            pkg2.lernaConfig.command.publish = pkg2.lernaConfig.command.publish || {};
            pkg2.lernaConfig.command.publish.assets = assets;
          }
        });
        let result;
        if (this.options.bump === "from-git") {
          result = await this.detectFromGit();
        } else if (this.options.bump === "from-package") {
          result = await this.detectFromPackage();
        } else if (this.options.canary) {
          result = await this.detectCanaryVersions();
        } else {
          result = await versionCommand(this.argv, {
            projectFileMap: this.projectFileMap,
            projectGraph: this.projectGraph
          });
        }
        if (!result) {
          return false;
        }
        if (!result.updates.length) {
          this.logger.success("No changed packages to publish");
          return false;
        }
        this.updates = this.filterPrivatePkgUpdates(result.updates);
        this.updatesVersions = new Map(result.updatesVersions);
        function interpolateAsset(asset, interpolationFn) {
          if (typeof asset === "string") {
            return interpolationFn(asset);
          }
          if (asset.from) {
            asset.from = interpolationFn(asset.from);
          }
          if (asset.to) {
            asset.to = interpolationFn(asset.to);
          }
          return asset;
        }
        this.packagesToPublish = this.updates.map((node) => getPackage(node));
        if (result.needsConfirmation) {
          return this.confirmPublish();
        }
        return true;
      }
      async execute() {
        this.enableProgressBar();
        this.logger.info("publish", "Publishing packages to npm...");
        await this.prepareRegistryActions();
        await this.prepareLicenseActions();
        this.preparePrivatePackages();
        if (this.options.canary) {
          await this.updateCanaryVersions();
        }
        await this.resolveLocalDependencyLinks();
        await this.resolveWorkspaceDependencyLinks();
        this.annotateGitHead();
        await this.serializeChanges();
        await this.packUpdated();
        await this.publishPacked();
        this.restorePrivatePackages();
        await this.serializeChanges();
        if (this.gitReset) {
          await this.resetChanges();
        }
        if (this.options.tempTag) {
          await this.npmUpdateAsLatest();
        }
        const count = this.publishedPackages.length;
        const publishedPackagesSorted = this.publishedPackages.sort((a, b) => a.name.localeCompare(b.name));
        if (!count) {
          this.logger.success("All packages have already been published.");
          return;
        }
        output("Successfully published:");
        if (this.options.summaryFile !== void 0) {
          const filePath = this.options.summaryFile ? `${this.options.summaryFile}/lerna-publish-summary.json` : "./lerna-publish-summary.json";
          const jsonObject = publishedPackagesSorted.map((pkg2) => {
            return {
              packageName: pkg2.name,
              version: pkg2.version
            };
          });
          output(jsonObject);
          try {
            import_fs7.default.writeFileSync(filePath, JSON.stringify(jsonObject));
            output("Publish summary created: ", filePath);
          } catch (error) {
            output("Failed to create the summary report", error);
          }
        } else {
          const message = publishedPackagesSorted.map((pkg2) => ` - ${pkg2.name}@${pkg2.version}`);
          output(message.join(import_os7.default.EOL));
        }
        this.logger.success("published", "%d %s", count, count === 1 ? "package" : "packages");
        if (this.uniqueProvenanceUrls.size > 0) {
          output("The following provenance transparency log entries were created during publishing:");
          const message = Array.from(this.uniqueProvenanceUrls).map((url2) => ` - ${url2}`);
          output(message.join(import_os7.default.EOL));
        }
      }
      verifyWorkingTreeClean() {
        return describeRef(this.execOpts).then(throwIfUncommitted);
      }
      async detectFromGit() {
        const matchingPattern = this.project.isIndependent() ? "*@*" : `${this.tagPrefix}*.*.*`;
        try {
          await this.verifyWorkingTreeClean();
        } catch (err) {
          if (err.failed && /git describe/.test(err.command)) {
            this.logger.silly("EWORKINGTREE", err.message);
            this.logger.notice("FYI", "Unable to verify working tree, proceed at your own risk");
          } else {
            throw err;
          }
        }
        const taggedPackageNames = await getCurrentTags(this.execOpts, matchingPattern);
        let updates;
        let updatesVersions;
        if (!taggedPackageNames.length) {
          this.logger.notice("from-git", "No tagged release found");
          updates = [];
        } else if (this.project.isIndependent()) {
          updates = [];
          updatesVersions = [];
          taggedPackageNames.forEach((tag) => {
            const npaResult = (0, import_npm_package_arg9.default)(tag);
            const node = this.projectsWithPackage.find((node2) => getPackage(node2).name === npaResult.name);
            updates.push(node);
            updatesVersions.push([node.name, getPackage(node).version || npaResult.rawSpec]);
          });
        } else {
          updates = await getProjectsWithTaggedPackages(
            this.projectsWithPackage,
            this.projectFileMap,
            this.execOpts
          );
          updatesVersions = updates.map((node) => [node.name, getPackage(node).version]);
        }
        updates = this.filterPrivatePkgUpdates(updates);
        return {
          updates,
          updatesVersions,
          needsConfirmation: true
        };
      }
      async detectFromPackage() {
        try {
          await this.verifyWorkingTreeClean();
        } catch (err) {
          if (err.failed && /git describe/.test(err.command)) {
            this.logger.silly("EWORKINGTREE", err.message);
            this.logger.notice("FYI", "Unable to verify working tree, proceed at your own risk");
            process.exitCode = 0;
          } else {
            throw err;
          }
        }
        let updates;
        updates = await getProjectsWithUnpublishedPackages(this.projectsWithPackage, this.conf.snapshot);
        updates = this.filterPrivatePkgUpdates(updates);
        if (!updates.length) {
          this.logger.notice("from-package", "No unpublished release found");
        }
        const updatesVersions = updates.map((node) => [node.name, getPackage(node).version]);
        return {
          updates,
          updatesVersions,
          needsConfirmation: true
        };
      }
      async detectCanaryVersions() {
        const { cwd } = this.execOpts;
        const {
          bump = "prepatch",
          preid = "alpha",
          ignoreChanges,
          forcePublish,
          includeMergedTags
        } = this.options;
        const release = bump.startsWith("pre") ? bump.replace("release", "patch") : `pre${bump}`;
        try {
          await this.verifyWorkingTreeClean();
        } catch (err) {
          if (err.failed && /git describe/.test(err.command)) {
            this.logger.silly("EWORKINGTREE", err.message);
            this.logger.notice("FYI", "Unable to verify working tree, proceed at your own risk");
          } else {
            throw err;
          }
        }
        const updates = this.filterPrivatePkgUpdates(
          collectProjectUpdates(this.projectsWithPackage, this.projectGraph, this.execOpts, {
            bump: "prerelease",
            canary: true,
            ignoreChanges,
            forcePublish,
            includeMergedTags
          })
        );
        const makeVersion = (fallback) => ({ lastVersion = fallback, refCount, sha }) => {
          const nextVersion = import_semver9.default.inc(
            lastVersion.replace(this.tagPrefix, ""),
            release.replace("pre", "")
          );
          return `${nextVersion}-${preid}.${Math.max(0, refCount - 1)}+${sha}`;
        };
        let updatesVersions;
        if (this.project.isIndependent()) {
          updatesVersions = await (0, import_p_map8.default)(
            updates,
            (node) => describeRef(
              {
                match: `${getPackage(node).name}@*`,
                cwd
              },
              includeMergedTags
            ).then(makeVersion(getPackage(node).version)).then((version) => [node.name, version])
          );
        } else {
          updatesVersions = await describeRef(
            {
              match: `${this.tagPrefix}*.*.*`,
              cwd
            },
            includeMergedTags
          ).then(makeVersion(this.project.version)).then((version) => updates.map((node) => [node.name, version]));
        }
        return {
          updates,
          updatesVersions,
          needsConfirmation: true
        };
      }
      confirmPublish() {
        const count = this.updates.length;
        const message = this.updates.map((node) => {
          const pkg2 = getPackage(node);
          const version = this.updatesVersions.get(node.name);
          return ` - ${pkg2.name} => ${version}${pkg2.private ? " (private!)" : ""}`;
        });
        output("");
        output(`Found ${count} ${count === 1 ? "package" : "packages"} to publish:`);
        output(message.join(import_os7.default.EOL));
        output("");
        if (this.options.yes) {
          this.logger.info("auto-confirmed", "");
          return true;
        }
        return promptConfirmation("Are you sure you want to publish these packages?");
      }
      preparePrivatePackages() {
        this.privatePackagesToPublish = [];
        this.packagesToPublish.forEach((pkg2) => {
          if (pkg2.private) {
            pkg2.removePrivate();
            this.privatePackagesToPublish.push(pkg2);
          }
        });
      }
      restorePrivatePackages() {
        this.privatePackagesToPublish.forEach((pkg2) => {
          pkg2.private = true;
        });
      }
      async prepareLicenseActions() {
        const packagesWithoutLicense = await getPackagesWithoutLicense(this.project, this.packagesToPublish);
        if (packagesWithoutLicense.length && !this.project.licensePath) {
          this.packagesToBeLicensed = [];
          const names = packagesWithoutLicense.map((pkg2) => pkg2.name);
          const noun = names.length > 1 ? "Packages" : "Package";
          const verb = names.length > 1 ? "are" : "is";
          const list2 = names.length > 1 ? `${names.slice(0, -1).join(", ")}${names.length > 2 ? "," : ""} and ${names[names.length - 1]}` : names[0];
          this.logger.warn(
            "ENOLICENSE",
            "%s %s %s missing a license.\n%s\n%s",
            noun,
            list2,
            verb,
            "One way to fix this is to add a LICENSE.md file to the root of this repository.",
            "See https://choosealicense.com for additional guidance."
          );
        } else {
          this.packagesToBeLicensed = packagesWithoutLicense;
        }
      }
      async prepareRegistryActions() {
        if (this.conf.get("registry") !== "https://registry.npmjs.org/") {
          this.logger.notice("", "Skipping all user and access validation due to third-party registry");
          this.logger.notice("", "Make sure you're authenticated properly \xAF\\_(\u30C4)_/\xAF");
          return;
        }
        if (process.env.LERNA_INTEGRATION) {
          return;
        }
        if (this.verifyAccess) {
          const username = await getNpmUsername(this.conf.snapshot);
          if (username) {
            await verifyNpmPackageAccess(this.packagesToPublish, username, this.conf.snapshot);
          }
          this.twoFactorAuthRequired = await getTwoFactorAuthRequired(this.conf.snapshot);
        }
      }
      async updateCanaryVersions() {
        await (0, import_p_map8.default)(this.updates, (node) => {
          const pkg2 = getPackage(node);
          pkg2.set("version", this.updatesVersions.get(node.name));
          const dependencies = this.projectGraph.localPackageDependencies[node.name] || [];
          dependencies.forEach((dep) => {
            const depPkg = getPackage(this.projectGraph.nodes[dep.target]);
            const depVersion = this.updatesVersions.get(dep.target) || depPkg.version;
            pkg2.updateLocalDependency(dep.targetResolvedNpaResult, depVersion, this.savePrefix);
          });
        });
      }
      async resolveLocalDependencyLinks() {
        const updatesWithLocalLinks = this.updates.filter((node) => {
          const dependencies = this.projectGraph.localPackageDependencies[node.name] || [];
          return dependencies.some((dep) => dep.targetResolvedNpaResult.type === "directory");
        });
        await (0, import_p_map8.default)(updatesWithLocalLinks, (node) => {
          const pkg2 = getPackage(node);
          const dependencies = this.projectGraph.localPackageDependencies[node.name] || [];
          dependencies.forEach((dep) => {
            const depPkg = getPackage(this.projectGraph.nodes[dep.target]);
            const depVersion = this.updatesVersions.get(dep.target) || depPkg.version;
            pkg2.updateLocalDependency(dep.targetResolvedNpaResult, depVersion, this.savePrefix);
          });
        });
      }
      async resolveWorkspaceDependencyLinks() {
        const updatesWithWorkspaceLinks = this.updates.filter((node) => {
          const dependencies = this.projectGraph.localPackageDependencies[node.name] || [];
          return dependencies.some((dep) => !!dep.targetResolvedNpaResult.workspaceSpec);
        });
        await (0, import_p_map8.default)(updatesWithWorkspaceLinks, (node) => {
          const pkg2 = getPackage(node);
          const dependencies = this.projectGraph.localPackageDependencies[node.name] || [];
          dependencies.forEach((dep) => {
            const depPkg = getPackage(this.projectGraph.nodes[dep.target]);
            const resolved = dep.targetResolvedNpaResult;
            if (resolved.workspaceSpec) {
              let depVersion;
              let savePrefix;
              if (resolved.workspaceAlias) {
                depVersion = this.updatesVersions.get(dep.target) || depPkg.version;
                savePrefix = resolved.workspaceAlias === "*" ? "" : resolved.workspaceAlias;
              } else {
                const specMatch = resolved.workspaceSpec.match(/^workspace:([~^]?)(.*)/);
                savePrefix = specMatch[1];
                depVersion = this.updatesVersions.get(dep.target) || depPkg.version;
              }
              pkg2.updateLocalDependency(resolved, depVersion, savePrefix, { retainWorkspacePrefix: false });
            }
          });
        });
      }
      annotateGitHead() {
        try {
          const gitHead = this.options.gitHead || getCurrentSHA(this.execOpts);
          for (const pkg2 of this.packagesToPublish) {
            pkg2.set("gitHead", gitHead);
          }
        } catch (err) {
          this.logger.silly("EGITHEAD", err.message);
          this.logger.notice(
            "FYI",
            "Unable to set temporary gitHead property, it will be missing from registry metadata"
          );
        }
      }
      async serializeChanges() {
        await (0, import_p_map8.default)(this.packagesToPublish, (pkg2) => pkg2.serialize());
      }
      async resetChanges() {
        const _workspaceRoot = process.env["NX_WORKSPACE_ROOT_PATH"] || import_devkit8.workspaceRoot;
        const gitOpts = {
          granularPathspec: this.options.granularPathspec !== false
        };
        const dirtyManifests = [this.project.manifest].concat(this.packagesToPublish).map((pkg2) => import_path25.default.relative(_workspaceRoot, pkg2.manifestLocation));
        try {
          await gitCheckout(dirtyManifests, gitOpts, this.execOpts);
        } catch (err) {
          this.logger.silly("EGITCHECKOUT", err.message);
          this.logger.notice("FYI", "Unable to reset working tree changes, this probably isn't a git repo.");
        }
      }
      execScript(pkg2, script) {
        const scriptLocation = import_path25.default.join(pkg2.location, "scripts", script);
        try {
          require(scriptLocation);
        } catch (ex) {
          this.logger.silly("execScript", `No ${script} script found at ${scriptLocation}`);
        }
        return pkg2;
      }
      async removeTempLicensesOnError() {
        await removeTempLicenses(this.packagesToBeLicensed).catch((removeError) => {
          this.logger.error(
            "licenses",
            "error removing temporary license files",
            removeError.stack || removeError
          );
        });
      }
      async requestOneTimePassword() {
        if (this.otpCache.otp) {
          return;
        }
        const otp = await getOneTimePassword("Enter OTP:");
        this.otpCache.otp = otp;
      }
      topoMapPackages(mapper) {
        return runProjectsTopologically(this.updates, this.projectGraph, (node) => mapper(getPackage(node)), {
          concurrency: this.concurrency,
          rejectCycles: this.options.rejectCycles
        });
      }
      async packUpdated() {
        const tracker = this.logger.newItem("npm pack");
        tracker.addWork(this.packagesToPublish.length);
        await createTempLicenses(this.project.licensePath, this.packagesToBeLicensed);
        if (!this.hasRootedLeaf) {
          await this.runRootLifecycle("prepublish");
          await this.runPackageLifecycle(this.project.manifest, "prepare");
          await this.runPackageLifecycle(this.project.manifest, "prepublishOnly");
          await this.runPackageLifecycle(this.project.manifest, "prepack");
        }
        const opts = this.conf.snapshot;
        const mapper = (0, import_p_pipe.default)(
          ...[
            this.options.requireScripts && ((pkg2) => this.execScript(pkg2, "prepublish")),
            (pkg2) => this.copyAssets(pkg2).then(() => pkg2),
            (pkg2) => pulseTillDone(packDirectory(pkg2, pkg2.location, opts)).then((packed) => {
              tracker.verbose("packed", import_path25.default.relative(this.project.rootPath, pkg2.contents));
              tracker.completeWork(1);
              pkg2.packed = packed;
              return pkg2.refresh();
            })
          ].filter(Boolean)
        );
        if (this.toposort) {
          await this.topoMapPackages(mapper).catch((err) => {
            this.removeTempLicensesOnError();
            throw err;
          });
        } else {
          await (0, import_p_map8.default)(this.packagesToPublish, mapper, { concurrency: this.concurrency });
        }
        await removeTempLicenses(this.packagesToBeLicensed);
        if (!this.hasRootedLeaf) {
          await this.runPackageLifecycle(this.project.manifest, "postpack");
        }
        tracker.finish();
      }
      async publishPacked() {
        this.publishedPackages = [];
        const tracker = this.logger.newItem("publish");
        tracker.addWork(this.packagesToPublish.length);
        let chain = Promise.resolve();
        if (this.twoFactorAuthRequired) {
          chain = chain.then(() => this.requestOneTimePassword());
        }
        const opts = Object.assign(this.conf.snapshot, {
          // distTag defaults to "latest" OR whatever is in pkg.publishConfig.tag
          // if we skip temp tags we should tag with the proper value immediately
          tag: this.options.tempTag ? "lerna-temp" : this.conf.get("tag")
        });
        const logListener = (...args) => {
          const str = args.join(" ");
          if (str.toLowerCase().includes("provenance statement") && str.includes("https://")) {
            const url2 = str.match(/https:\/\/[^ ]+/)[0];
            this.uniqueProvenanceUrls.add(url2);
          }
        };
        process.on("log", logListener);
        const mapper = (0, import_p_pipe.default)(
          ...[
            (pkg2) => {
              const preDistTag = this.getPreDistTag(pkg2);
              const tag = !this.options.tempTag && preDistTag ? preDistTag : opts.tag;
              const pkgOpts = Object.assign({}, opts, { tag });
              return pulseTillDone(npmPublish(pkg2, pkg2.packed.tarFilePath, pkgOpts, this.otpCache)).then(() => {
                this.publishedPackages.push(pkg2);
                tracker.success("published", pkg2.name, pkg2.version);
                tracker.completeWork(1);
                logPacked(pkg2.packed);
                return pkg2;
              }).catch((err) => {
                if (err.code === "EPUBLISHCONFLICT" || err.code === "E403" && err.body?.error?.includes("You cannot publish over the previously published versions")) {
                  tracker.warn("publish", `Package is already published: ${pkg2.name}@${pkg2.version}`);
                  tracker.completeWork(1);
                  return pkg2;
                }
                this.logger.silly("", err);
                this.logger.warn("notice", `Package failed to publish: ${pkg2.name}`);
                this.logger.error(err.code, err.body && err.body.error || err.message);
                err.name = "ValidationError";
                if ("errno" in err && typeof err.errno === "number" && Number.isFinite(err.errno)) {
                  process.exitCode = err.errno;
                } else {
                  this.logger.error("", `errno "${err.errno}" is not a valid exit code - exiting with code 1`);
                  process.exitCode = 1;
                }
                throw err;
              });
            },
            this.options.requireScripts && ((pkg2) => this.execScript(pkg2, "postpublish"))
          ].filter(Boolean)
        );
        chain = chain.then(() => {
          if (this.toposort) {
            return this.topoMapPackages(mapper);
          } else {
            return (0, import_p_map8.default)(this.packagesToPublish, mapper, { concurrency: this.concurrency });
          }
        });
        if (!this.hasRootedLeaf) {
          chain = chain.then(() => this.runRootLifecycle("publish"));
          chain = chain.then(() => this.runRootLifecycle("postpublish"));
        }
        return chain.finally(() => {
          process.removeListener("log", logListener);
          tracker.finish();
        });
      }
      async npmUpdateAsLatest() {
        const tracker = this.logger.newItem("npmUpdateAsLatest");
        tracker.addWork(this.updates.length);
        tracker.showProgress();
        const opts = this.conf.snapshot;
        const getDistTag = (publishConfig) => {
          if (opts.tag === "latest" && publishConfig && publishConfig.tag) {
            return publishConfig.tag;
          }
          return opts.tag;
        };
        const mapper = (pkg2) => {
          const spec = `${pkg2.name}@${pkg2.version}`;
          const preDistTag = this.getPreDistTag(pkg2);
          const distTag = preDistTag || getDistTag(pkg2.get("publishConfig"));
          return Promise.resolve().then(() => pulseTillDone(npmDistTag.remove(spec, "lerna-temp", opts, this.otpCache))).then(() => pulseTillDone(npmDistTag.add(spec, distTag, opts, this.otpCache))).then(() => {
            tracker.success("dist-tag", "%s@%s => %j", pkg2.name, pkg2.version, distTag);
            tracker.completeWork(1);
            return pkg2;
          });
        };
        if (this.toposort) {
          await this.topoMapPackages(mapper);
        } else {
          await (0, import_p_map8.default)(this.packagesToPublish, mapper, { concurrency: this.concurrency });
        }
        tracker.finish();
      }
      getDistTag() {
        if (this.options.distTag) {
          return this.options.distTag;
        }
        if (this.options.canary) {
          return "canary";
        }
        return void 0;
      }
      getPreDistTag(pkg2) {
        if (!this.options.preDistTag) {
          return;
        }
        const isPrerelease = prereleaseIdFromVersion(pkg2.version);
        if (isPrerelease) {
          return this.options.preDistTag;
        }
      }
      // filter out private packages, respecting the --include-private option
      filterPrivatePkgUpdates(updates) {
        const privatePackagesToInclude = new Set(this.options.includePrivate || []);
        return updates.filter(
          (node) => !getPackage(node).private || privatePackagesToInclude.has("*") || privatePackagesToInclude.has(getPackage(node).name)
        );
      }
      async copyAssets(pkg2) {
        if (!pkg2.lernaConfig?.command?.publish?.assets) {
          return;
        }
        if ((0, import_path25.normalize)(pkg2.location) === (0, import_path25.normalize)(pkg2.contents)) {
          return;
        }
        const _workspaceRoot = process.env["NX_WORKSPACE_ROOT_PATH"] || import_devkit8.workspaceRoot;
        const assets = pkg2.lernaConfig?.command?.publish?.assets;
        const filesToCopy = [];
        const getFiles = (glob) => (0, import_globby3.default)(glob, {
          cwd: pkg2.location,
          onlyFiles: false,
          expandDirectories: false
        });
        for (const asset of assets) {
          if (typeof asset === "string") {
            const files = await getFiles(asset);
            this.logger.verbose("publish", "Expanded asset glob %s into files %j", asset, files);
            for (const file of files) {
              filesToCopy.push({
                from: (0, import_path25.join)(pkg2.location, file),
                to: (0, import_path25.join)(pkg2.contents, file)
              });
            }
          } else if (asset.from && typeof asset.from === "string" && asset.to && typeof asset.to === "string") {
            const files = await getFiles(asset.from);
            this.logger.verbose("publish", "Expanded asset glob %s into files %j", asset.from, files);
            for (const file of files) {
              filesToCopy.push({
                from: (0, import_path25.join)(pkg2.location, file),
                to: (0, import_path25.join)(pkg2.contents, asset.to, (0, import_path25.basename)(file))
              });
            }
          } else {
            throw new ValidationError(
              "EINVALIDASSETS",
              "Asset configuration must be a plain string or object with both `from` and `to` string properties."
            );
          }
        }
        for (const file of filesToCopy) {
          if ((0, import_path25.normalize)(file.from) === (0, import_path25.normalize)(file.to)) {
            this.logger.warn(
              "EPUBLISHASSET",
              "Asset %s is already in package directory",
              file.from.replace(`${_workspaceRoot}/`, "")
            );
          } else if ((0, import_fs7.existsSync)(file.from)) {
            this.logger.verbose(
              "publish",
              "Copying asset %s to %s",
              file.from.replace(`${_workspaceRoot}/`, ""),
              file.to.replace(`${_workspaceRoot}/`, "")
            );
            await (0, import_fs_extra14.copy)(file.from, file.to);
          } else {
            this.logger.warn(
              "EPUBLISHASSET",
              "Asset %s does not exist",
              file.from.replace(`${_workspaceRoot}/`, "")
            );
          }
        }
      }
    };
    module2.exports.PublishCommand = PublishCommand;
  }
});

// libs/commands/publish/src/command.ts
var require_command10 = __commonJS({
  "libs/commands/publish/src/command.ts"(exports2, module2) {
    "use strict";
    var import_npmlog65 = __toESM(require("npmlog"));
    var versionCommand = require_command9();
    function composeVersionOptions(yargs2) {
      versionCommand.addBumpPositional(yargs2, ["from-git", "from-package"]);
      versionCommand.builder(yargs2, "publish");
      return yargs2;
    }
    var command = {
      command: "publish [bump]",
      describe: "Publish packages in the current project",
      builder(yargs2) {
        const opts = {
          c: {
            describe: "Publish packages after every successful merge using the sha as part of the tag.",
            alias: "canary",
            type: "boolean"
          },
          // preid is copied from ../version/command because a whitelist for one option isn't worth it
          preid: {
            describe: "Specify the prerelease identifier when publishing a prerelease",
            type: "string",
            requiresArg: true,
            defaultDescription: "alpha"
          },
          contents: {
            describe: "Subdirectory to publish. Must apply to ALL packages.",
            type: "string",
            requiresArg: true,
            defaultDescription: "."
          },
          "dist-tag": {
            describe: "Publish packages with the specified npm dist-tag",
            type: "string",
            requiresArg: true
          },
          "legacy-auth": {
            describe: "Legacy Base64 Encoded username and password.",
            type: "string"
          },
          "pre-dist-tag": {
            describe: "Publish prerelease packages with the specified npm dist-tag",
            type: "string",
            requiresArg: true
          },
          "git-head": {
            describe: "Explicit SHA to set as gitHead when packing tarballs, only allowed with 'from-package' positional.",
            type: "string",
            requiresArg: true
          },
          "graph-type": {
            describe: "Type of dependency to use when determining package hierarchy.",
            choices: ["all", "dependencies"],
            defaultDescription: "dependencies"
          },
          "ignore-prepublish": {
            describe: "Disable deprecated 'prepublish' lifecycle script",
            type: "boolean"
          },
          "ignore-scripts": {
            describe: "Disable all lifecycle scripts",
            type: "boolean"
          },
          // TODO: (major) make --no-granular-pathspec the default
          "no-granular-pathspec": {
            describe: "Do not reset changes file-by-file, but globally.",
            type: "boolean"
          },
          "granular-pathspec": {
            // proxy for --no-granular-pathspec
            hidden: true,
            // describe: "Reset changes file-by-file, not globally.",
            type: "boolean"
          },
          otp: {
            describe: "Supply a one-time password for publishing with two-factor authentication.",
            type: "string",
            requiresArg: true
          },
          registry: {
            describe: "Use the specified registry for all npm client operations.",
            type: "string",
            requiresArg: true
          },
          "require-scripts": {
            describe: "Execute ./scripts/prepublish.js and ./scripts/postpublish.js, relative to package root.",
            type: "boolean"
          },
          "no-git-reset": {
            describe: "Do not reset changes to working tree after publishing is complete.",
            type: "boolean"
          },
          "git-reset": {
            // proxy for --no-git-reset
            hidden: true,
            type: "boolean"
          },
          "temp-tag": {
            describe: "Create a temporary tag while publishing.",
            type: "boolean"
          },
          "no-verify-access": {
            // proxy for --verify-access
            describe: "Do not verify package read-write access for current npm user.",
            type: "boolean"
          },
          "verify-access": {
            describe: "Verify package read-write access for current npm user.",
            type: "boolean"
          },
          "summary-file": {
            // generate lerna publish json output.
            describe: "Generate a json summary report after all packages have been successfully published, you can pass an optional path for where to save the file.",
            type: "string"
          },
          "include-private": {
            describe: "Include specified private packages when publishing by temporarily removing the private property from the package manifest. This should only be used for testing private packages that will become public. Private packages should not usually be published. See the npm docs for details (https://docs.npmjs.com/cli/v9/configuring-npm/package-json#private).",
            type: "array"
          }
        };
        composeVersionOptions(yargs2);
        yargs2.options(opts);
        const { hiddenOptions } = yargs2.getOptions();
        const sharedKeys = ["preid", "y", "ignore-scripts"];
        for (const sharedKey of sharedKeys) {
          hiddenOptions.splice(
            hiddenOptions.findIndex((k) => k === sharedKey),
            1
          );
        }
        yargs2.group(Object.keys(opts).concat(sharedKeys), "Command Options:");
        return yargs2.option("npm-tag", {
          // TODO: remove in next major release
          hidden: true,
          conflicts: "dist-tag",
          type: "string",
          requiresArg: true
        }).option("verify-registry", {
          // TODO: remove in next major release
          hidden: true,
          type: "boolean"
        }).option("skip-npm", {
          // TODO: remove in next major release
          // deprecation notice handled in initialize()
          hidden: true,
          type: "boolean"
        }).check((argv) => {
          if (argv["npmTag"]) {
            argv["distTag"] = argv["npmTag"];
            argv["dist-tag"] = argv["npmTag"];
            delete argv["npmTag"];
            delete argv["npm-tag"];
            import_npmlog65.default.warn("deprecated", "--npm-tag has been renamed --dist-tag");
          }
          return argv;
        }).middleware((args) => {
          const { includePrivate } = args;
          if (includePrivate && Array.isArray(includePrivate)) {
            args["includePrivate"] = includePrivate.reduce((acc, pkg2) => [...acc, ...pkg2.split(/[\s,]/)], []);
          }
        }, true);
      },
      handler(argv) {
        return require_src9()(argv);
      }
    };
    module2.exports = command;
  }
});

// libs/commands/run/src/index.ts
var require_src10 = __commonJS({
  "libs/commands/run/src/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_fs_extra14 = require("fs-extra");
    var import_run_many = require("nx/src/command-line/run-many/run-many");
    var import_run_one = require("nx/src/command-line/run/run-one");
    var import_p_map8 = __toESM(require("p-map"));
    var import_path25 = __toESM(require("path"));
    var import_perf_hooks = require("perf_hooks");
    module2.exports = function factory2(argv) {
      return new RunCommand(argv);
    };
    var RunCommand = class extends Command {
      options;
      script;
      args;
      npmClient;
      bail;
      prefix;
      projectsWithScript;
      count;
      packagePlural;
      joinedCommand;
      get requiresGit() {
        return false;
      }
      async initialize() {
        const { script, npmClient = "npm", bail, prefix } = this.options;
        this.script = script;
        this.args = this.options["--"] || [];
        this.npmClient = npmClient;
        if (!this.script) {
          throw new ValidationError("ENOSCRIPT", "You must specify a lifecycle script to run");
        }
        if (this.argv.npmClient && this.options.useNx !== false) {
          throw new ValidationError(
            "run",
            "The legacy task runner option `--npm-client` is not currently supported. Please open an issue on https://github.com/lerna/lerna if you require this feature."
          );
        }
        if (Array.isArray(this.script) && this.options.useNx === false) {
          throw new ValidationError(
            "run",
            "The legacy task runner does not support running multiple scripts concurrently. Please update to the latest version of lerna and ensure you do not have useNx set to false in your lerna.json."
          );
        }
        this.bail = bail !== false;
        this.prefix = prefix !== false;
        const filteredProjects = filterProjects(this.projectGraph, this.execOpts, this.options);
        this.projectsWithScript = script === "env" ? filteredProjects : filteredProjects.filter((project) => {
          if (Array.isArray(this.script)) {
            return this.script.some((scriptName) => project.data.targets?.[scriptName]);
          }
          return project.data.targets?.[this.script];
        });
        this.count = this.projectsWithScript.length;
        this.packagePlural = this.count === 1 ? "package" : "packages";
        this.joinedCommand = [this.npmClient, "run", this.script].concat(this.args).join(" ");
        if (!this.count) {
          this.logger.success("run", `No packages found with the lifecycle script '${script}'`);
          return false;
        }
      }
      async execute() {
        if (this.options.useNx === false) {
          this.logger.info(
            "",
            "Executing command in %d %s: %j",
            this.count,
            this.packagePlural,
            this.joinedCommand
          );
        }
        const getElapsed = timer();
        let runScripts;
        if (this.options.useNx !== false) {
          runScripts = () => this.runScriptsUsingNx();
        } else if (this.options.parallel) {
          runScripts = () => this.runScriptInPackagesParallel();
        } else if (this.toposort) {
          runScripts = () => this.runScriptInPackagesTopological();
        } else {
          runScripts = () => this.runScriptInPackagesLexical();
        }
        if (this.bail) {
          try {
            await runScripts();
          } catch (err) {
            process.exitCode = err.exitCode;
            throw err;
          }
        } else {
          const results = await runScripts();
          if (results.some((result) => result.failed)) {
            const codes = results.filter((result) => result.failed).map((result) => result.exitCode);
            const exitCode = Math.max(...codes, 1);
            this.logger.error("", "Received non-zero exit code %d during execution", exitCode);
            process.exitCode = exitCode;
          }
        }
        this.logger.success(
          "run",
          "Ran npm script '%s' in %d %s in %ss:",
          this.script,
          this.count,
          this.packagePlural,
          (getElapsed() / 1e3).toFixed(1)
        );
        this.logger.success("", this.projectsWithScript.map((p) => `- ${getPackage(p).name}`).join("\n"));
      }
      getOpts(pkg2) {
        return {
          args: this.args,
          npmClient: this.npmClient,
          prefix: this.prefix,
          reject: this.bail,
          pkg: pkg2
        };
      }
      getRunner() {
        return this.options.stream ? (pkg2) => this.runScriptInPackageStreaming(pkg2) : (pkg2) => this.runScriptInPackageCapturing(pkg2);
      }
      runScriptInPackagesTopological() {
        let profiler;
        let runner;
        if (this.options.profile) {
          profiler = new Profiler({
            concurrency: this.concurrency,
            log: this.logger,
            outputDirectory: this.options.profileLocation
          });
          const callback = this.getRunner();
          runner = (pkg2) => profiler.run(() => callback(pkg2), pkg2.name);
        } else {
          runner = this.getRunner();
        }
        let chain = runProjectsTopologically(
          this.projectsWithScript,
          this.projectGraph,
          (p) => runner(getPackage(p)),
          {
            concurrency: this.concurrency,
            rejectCycles: this.options.rejectCycles
          }
        );
        if (profiler) {
          chain = chain.then((results) => profiler.output().then(() => results));
        }
        return chain;
      }
      runScriptInPackagesParallel() {
        return (0, import_p_map8.default)(this.projectsWithScript, (p) => this.runScriptInPackageStreaming(getPackage(p)));
      }
      runScriptInPackagesLexical() {
        return (0, import_p_map8.default)(this.projectsWithScript, (p) => this.getRunner()(getPackage(p)), {
          concurrency: this.concurrency
        });
      }
      runScriptInPackageStreaming(pkg2) {
        return npmRunScriptStreaming(this.script, this.getOpts(pkg2));
      }
      runScriptInPackageCapturing(pkg2) {
        const getElapsed = timer();
        return npmRunScript(this.script, this.getOpts(pkg2)).then((result) => {
          this.logger.info(
            "run",
            "Ran npm script '%s' in '%s' in %ss:",
            this.script,
            pkg2.name,
            (getElapsed() / 1e3).toFixed(1)
          );
          output(result.stdout);
          return result;
        });
      }
      async runScriptsUsingNx() {
        if (this.options.ci) {
          process.env.CI = "true";
        }
        if (this.options.profile) {
          const absolutePath = generateProfileOutputPath(this.options.profileLocation);
          process.env.NX_PROFILE = import_path25.default.relative(this.project.rootPath, absolutePath);
        }
        import_perf_hooks.performance.mark("init-local");
        this.configureNxOutput();
        const { targetDependencies, options, extraOptions } = await this.prepNxOptions();
        if (this.projectsWithScript.length === 1 && !Array.isArray(this.script)) {
          const fullQualifiedTarget = this.projectsWithScript.map((p) => p.name)[0] + ":" + this.addQuotesAroundScriptNameIfItHasAColon(this.script);
          return (0, import_run_one.runOne)(
            process.cwd(),
            {
              "project:target:configuration": fullQualifiedTarget,
              ...options
            },
            targetDependencies,
            extraOptions
          );
        } else {
          const projects = this.projectsWithScript.map((p) => p.name).join(",");
          return (0, import_run_many.runMany)(
            {
              projects,
              targets: Array.isArray(this.script) ? this.script : [this.script],
              ...options
            },
            targetDependencies,
            extraOptions
          );
        }
      }
      addQuotesAroundScriptNameIfItHasAColon(scriptName) {
        if (scriptName.includes(":")) {
          return `"${scriptName}"`;
        } else {
          return scriptName;
        }
      }
      async prepNxOptions() {
        const nxJsonExists = (0, import_fs_extra14.existsSync)(import_path25.default.join(this.project.rootPath, "nx.json"));
        const { readNxJson } = require("nx/src/config/configuration");
        const nxJson = readNxJson();
        const targetDependenciesAreDefined = Object.keys(nxJson.targetDependencies || nxJson.targetDefaults || {}).length > 0;
        const hasProjectSpecificNxConfiguration = this.projectsWithScript.some((p) => !!getPackage(p).get("nx"));
        const hasCustomizedNxConfiguration = nxJsonExists && targetDependenciesAreDefined || hasProjectSpecificNxConfiguration;
        const mimicLernaDefaultBehavior = !hasCustomizedNxConfiguration;
        const targetDependencies = this.toposort && !this.options.parallel && mimicLernaDefaultBehavior && !Array.isArray(this.script) ? {
          [this.script]: [
            {
              projects: "dependencies",
              target: this.script
            }
          ]
        } : {};
        if (this.options.prefix === false && !this.options.stream) {
          this.logger.warn(this.name, `"no-prefix" is ignored when not using streaming output.`);
        }
        const outputStyle = this.options.stream ? this.prefix ? "stream" : "stream-without-prefixes" : "dynamic";
        const options = {
          outputStyle,
          /**
           * To match lerna's own behavior (via pMap's default concurrency), we set parallel to a very large number if
           * the flag has been set (we can't use Infinity because that would cause issues with the task runner).
           */
          parallel: this.options.parallel && mimicLernaDefaultBehavior ? 999 : this.concurrency,
          nxBail: this.bail,
          nxIgnoreCycles: !this.options.rejectCycles,
          skipNxCache: this.options.skipNxCache,
          verbose: this.options.verbose,
          __overrides__: this.args.map((t) => t.toString())
        };
        if (hasCustomizedNxConfiguration) {
          this.logger.verbose(
            this.name,
            "Nx target configuration was found. Task dependencies will be automatically included."
          );
          if (this.options.parallel || this.options.sort !== void 0) {
            this.logger.warn(
              this.name,
              `"parallel", "sort", and "no-sort" are ignored when Nx targets are configured. See https://lerna.js.org/docs/lerna6-obsolete-options for details.`
            );
          }
          if (this.options.includeDependencies) {
            this.logger.info(
              this.name,
              `Using the "include-dependencies" option when Nx targets are configured will include both task dependencies detected by Nx and project dependencies detected by Lerna. See https://lerna.js.org/docs/lerna6-obsolete-options#--include-dependencies for details.`
            );
          }
          if (this.options.ignore) {
            this.logger.info(
              this.name,
              `Using the "ignore" option when Nx targets are configured will exclude only tasks that are not determined to be required by Nx. See https://lerna.js.org/docs/lerna6-obsolete-options#--ignore for details.`
            );
          }
        } else {
          this.logger.verbose(
            this.name,
            "Nx target configuration was not found. Task dependencies will not be automatically included."
          );
        }
        const extraOptions = {
          excludeTaskDependencies: mimicLernaDefaultBehavior,
          loadDotEnvFiles: this.options.loadEnvFiles ?? true
        };
        return { targetDependencies, options, extraOptions };
      }
      configureNxOutput() {
        try {
          const nxOutput = require("nx/src/utils/output");
          nxOutput.output.cliName = "Lerna (powered by Nx)";
          nxOutput.output.formatCommand = (taskId) => taskId;
          return nxOutput;
        } catch (err) {
          this.logger.error(
            "\n",
            "There was a critical error when configuring the task runner, please report this on https://github.com/lerna/lerna"
          );
          throw err;
        }
      }
    };
    module2.exports.RunCommand = RunCommand;
  }
});

// libs/commands/run/src/command.ts
var require_command11 = __commonJS({
  "libs/commands/run/src/command.ts"(exports2, module2) {
    "use strict";
    init_src();
    var command = {
      command: "run <script>",
      describe: "Run an npm script in each package that contains that script",
      builder(yargs2) {
        yargs2.example("$0 run build -- --silent", "# `npm run build --silent` in all packages with a build script").parserConfiguration({
          "populate--": true
        }).positional("script", {
          describe: "The npm script to run. Pass flags to send to the npm client after --",
          type: "string",
          coerce: (script) => {
            if (script.includes(",")) {
              return script.split(",").filter(Boolean).map((s) => s.trim());
            }
            return script;
          }
        }).options({
          "npm-client": {
            group: "Command Options:",
            describe: "Executable used to run scripts (npm, yarn, pnpm, ...).",
            defaultDescription: "npm",
            type: "string",
            requiresArg: true
          },
          stream: {
            group: "Command Options:",
            describe: "Stream output with lines prefixed by package.",
            type: "boolean"
          },
          parallel: {
            group: "Command Options:",
            describe: "Run script with unlimited concurrency, streaming prefixed output.",
            type: "boolean"
          },
          "no-bail": {
            group: "Command Options:",
            describe: "Continue running script despite non-zero exit in a given package.",
            type: "boolean"
          },
          bail: {
            // proxy for --no-bail
            hidden: true,
            type: "boolean"
          },
          // This option controls prefix for stream output so that it can be disabled to be friendly
          // to tools like Visual Studio Code to highlight the raw results
          "no-prefix": {
            group: "Command Options:",
            describe: "Do not prefix streaming output.",
            type: "boolean"
          },
          prefix: {
            // proxy for --no-prefix
            hidden: true,
            type: "boolean"
          },
          profile: {
            group: "Command Options:",
            describe: "Profile script executions and output performance profile to default location.",
            type: "boolean"
          },
          "profile-location": {
            group: "Command Options:",
            describe: "Output performance profile to custom location instead of default project root.",
            type: "string"
          },
          "skip-nx-cache": {
            hidden: true,
            type: "boolean"
          },
          verbose: {
            group: "Command Options:",
            describe: "When useNx is not false, show verbose output from dependent tasks.",
            type: "boolean"
          },
          "load-env-files": {
            group: "Command Options:",
            describe: "When useNx is not false, automatically load .env files",
            type: "boolean"
          }
        });
        return filterOptions(yargs2);
      },
      handler(argv) {
        return require_src10()(argv);
      }
    };
    module2.exports = command;
  }
});

// packages/lerna/src/commands/add-caching/index.ts
var require_add_caching = __commonJS({
  "packages/lerna/src/commands/add-caching/index.ts"(exports2, module2) {
    "use strict";
    init_src2();
    var import_devkit8 = require("@nx/devkit");
    var import_inquirer2 = __toESM(require("inquirer"));
    var import_npmlog65 = __toESM(require("npmlog"));
    module2.exports = function factory2(argv) {
      return new AddCachingCommand(argv);
    };
    var AddCachingCommand = class extends Command2 {
      uniqueScriptNames = [];
      constructor(argv) {
        super(argv, { skipValidations: true });
      }
      initialize() {
        if (this.options.useNx === false) {
          this.logger.error(
            "add-caching",
            "The `add-caching` command is only available when using the Nx task runner (do not set `useNx` to `false` in `lerna.json`)"
          );
          process.exit(1);
        }
        const packages = this.packageGraph?.rawPackageList || [];
        const uniqueScriptNames = /* @__PURE__ */ new Set();
        for (const pkg2 of packages) {
          for (const scriptName of Object.keys(pkg2.scripts || {})) {
            uniqueScriptNames.add(scriptName);
          }
        }
        this.uniqueScriptNames = Array.from(uniqueScriptNames);
      }
      async execute() {
        this.logger.info(
          "add-caching",
          "Please answer the following questions about the scripts found in your workspace in order to generate task runner configuration"
        );
        process.stdout.write("\n");
        import_npmlog65.default.pause();
        const { targetDefaults } = await import_inquirer2.default.prompt([
          {
            type: "checkbox",
            name: "targetDefaults",
            message: "Which scripts need to be run in order? (e.g. before building a project, dependent projects must be built.)\n",
            choices: this.uniqueScriptNames
          }
        ]);
        const { cacheableOperations } = await import_inquirer2.default.prompt([
          {
            type: "checkbox",
            name: "cacheableOperations",
            message: "Which scripts are cacheable? (Produce the same output given the same input, e.g. build, test and lint usually are, serve and start are not.)\n",
            choices: this.uniqueScriptNames
          }
        ]);
        const scriptOutputs = {};
        for (const scriptName of cacheableOperations) {
          scriptOutputs[scriptName] = await import_inquirer2.default.prompt([
            {
              type: "input",
              name: scriptName,
              message: `Does the "${scriptName}" script create any outputs? If not, leave blank, otherwise provide a path relative to a project root (e.g. dist, lib, build, coverage)
`
            }
          ]);
        }
        import_npmlog65.default.resume();
        process.stdout.write("\n");
        this.convertAnswersToNxConfig({ cacheableOperations, targetDefaults, scriptOutputs });
        this.logger["success"]("add-caching", "Successfully updated task runner configuration in `nx.json`");
        this.logger.info(
          "add-caching",
          "Learn more about task runner configuration here: https://lerna.js.org/docs/concepts/task-pipeline-configuration"
        );
        this.logger.info(
          "add-caching",
          "Note that the legacy task runner options of --sort, --no-sort and --parallel no longer apply. Learn more here: https://lerna.js.org/docs/lerna6-obsolete-options"
        );
      }
      convertAnswersToNxConfig(answers) {
        const nxJsonPath = (0, import_devkit8.joinPathFragments)(import_devkit8.workspaceRoot, "nx.json");
        let nxJson = {};
        try {
          nxJson = (0, import_devkit8.readJsonFile)(nxJsonPath);
        } catch {
        }
        nxJson.tasksRunnerOptions = nxJson.tasksRunnerOptions || {};
        nxJson.tasksRunnerOptions["default"] = nxJson.tasksRunnerOptions["default"] || {};
        nxJson.tasksRunnerOptions["default"].runner = nxJson.tasksRunnerOptions["default"].runner || "nx/tasks-runners/default";
        nxJson.tasksRunnerOptions["default"].options = nxJson.tasksRunnerOptions["default"].options || {};
        if (nxJson.tasksRunnerOptions["default"].options.cacheableOperations) {
          this.logger.warn(
            "add-caching",
            "The `tasksRunnerOptions.default.cacheableOperations` property already exists in `nx.json` and will be overwritten by your answers"
          );
        }
        nxJson.tasksRunnerOptions["default"].options.cacheableOperations = answers.cacheableOperations;
        if (nxJson.targetDefaults) {
          this.logger.warn(
            "add-caching",
            "The `targetDefaults` property already exists in `nx.json` and will be overwritten by your answers"
          );
        }
        nxJson.targetDefaults = nxJson.targetDefaults || {};
        for (const scriptName of answers.targetDefaults) {
          nxJson.targetDefaults[scriptName] = nxJson.targetDefaults[scriptName] || {};
          nxJson.targetDefaults[scriptName] = { dependsOn: [`^${scriptName}`] };
        }
        for (const [scriptName, scriptAnswerData] of Object.entries(answers.scriptOutputs)) {
          if (!scriptAnswerData[scriptName]) {
            continue;
          }
          nxJson.targetDefaults[scriptName] = nxJson.targetDefaults[scriptName] || {};
          nxJson.targetDefaults[scriptName].outputs = [`{projectRoot}/${scriptAnswerData[scriptName]}`];
        }
        (0, import_devkit8.writeJsonFile)(nxJsonPath, nxJson);
      }
    };
    module2.exports.AddCachingCommand = AddCachingCommand;
  }
});

// packages/lerna/src/commands/add-caching/command.ts
var require_command12 = __commonJS({
  "packages/lerna/src/commands/add-caching/command.ts"(exports2, module2) {
    "use strict";
    var command = {
      command: "add-caching",
      describe: "Interactive prompt to generate task runner configuration",
      builder(yargs2) {
        return yargs2;
      },
      handler(argv) {
        return require_add_caching()(argv);
      }
    };
    module2.exports = command;
  }
});

// packages/lerna/migrations.json
var require_migrations = __commonJS({
  "packages/lerna/migrations.json"(exports2, module2) {
    module2.exports = {
      generators: {
        "add-schema-config": {
          cli: "nx",
          version: "7.0.0-alpha.5",
          description: "Add `$schema` config to lerna.json if not already present to allow for IDE validation of lerna.json",
          implementation: "./dist/migrations/add-schema-config/add-schema-config"
        },
        "remove-invalid-init-config": {
          cli: "nx",
          version: "7.0.0-alpha.2",
          description: "Remove invalid `init` config from lerna.json as it is no longer applicable, given init cannot be run on an existing workspace",
          implementation: "./dist/migrations/remove-invalid-init-config/remove-invalid-init-config"
        },
        "remove-invalid-lerna-config": {
          cli: "nx",
          version: "7.0.0-alpha.2",
          description: "Remove invalid `lerna` config from lerna.json as it is no longer used for anything",
          implementation: "./dist/migrations/remove-invalid-lerna-config/remove-invalid-lerna-config"
        },
        "remove-invalid-use-workspaces": {
          cli: "nx",
          version: "7.0.0-alpha.2",
          description: "Remove invalid `useWorkspaces` config from lerna.json as it no longer exists",
          implementation: "./dist/migrations/remove-invalid-use-workspaces/remove-invalid-use-workspaces"
        },
        "remove-unnecessary-use-nx": {
          cli: "nx",
          version: "6.0.0-alpha.0",
          description: "Remove unnecessary `useNx: true` from lerna.json as it is the default",
          implementation: "./dist/migrations/remove-unnecessary-use-nx/remove-unnecessary-use-nx"
        },
        "update-options-from-legacy-deprecate-config": {
          cli: "nx",
          version: "7.0.0-alpha.2",
          description: "Migrate legacy deprecated config usage to their updated counterparts",
          implementation: "./dist/migrations/update-options-from-legacy-deprecate-config/update-options-from-legacy-deprecate-config"
        }
      }
    };
  }
});

// packages/lerna/src/commands/repair/index.ts
var require_repair = __commonJS({
  "packages/lerna/src/commands/repair/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_npmlog65 = __toESM(require("npmlog"));
    var import_repair = require("nx/src/command-line/repair/repair");
    var migrationsJson = require_migrations();
    module2.exports = function factory2(argv) {
      return new RepairCommand(argv);
    };
    var RepairCommand = class extends Command {
      constructor(argv) {
        super(argv, { skipValidations: true });
      }
      initialize() {
      }
      async execute() {
        this.configureNxOutput();
        const verbose = this.options?.verbose ? true : import_npmlog65.default.level === "verbose";
        const lernaMigrations = Object.entries(migrationsJson.generators).map(
          ([name, migration]) => {
            return {
              package: "lerna",
              cli: "nx",
              name,
              description: migration.description,
              version: migration.version
            };
          }
        );
        await (0, import_repair.repair)({ verbose }, lernaMigrations);
      }
      configureNxOutput() {
        try {
          const nxOutput = require("nx/src/utils/output");
          nxOutput.output.cliName = "Lerna";
          nxOutput.output.formatCommand = (taskId) => taskId;
          return nxOutput;
        } catch (err) {
          this.logger.error("There was a critical issue when trying to execute the repair command.");
          throw err;
        }
      }
    };
    module2.exports.RepairCommand = RepairCommand;
  }
});

// packages/lerna/src/commands/repair/command.ts
var require_command13 = __commonJS({
  "packages/lerna/src/commands/repair/command.ts"(exports2, module2) {
    "use strict";
    var command = {
      command: "repair",
      describe: "Runs automated migrations to repair the state of a lerna repo",
      builder(yargs2) {
        yargs2.options({
          /**
           * equivalent to --loglevel=verbose, but added explicitly here because the repair()
           * output will potentially contain instructions to run with --verbose
           */
          verbose: {
            hidden: true,
            type: "boolean"
          }
        });
        return yargs2;
      },
      handler(argv) {
        return require_repair()(argv);
      }
    };
    module2.exports = command;
  }
});

// packages/lerna/src/commands/watch/index.ts
var require_watch = __commonJS({
  "packages/lerna/src/commands/watch/index.ts"(exports2, module2) {
    "use strict";
    init_src();
    var import_watch = require("nx/src/command-line/watch/watch");
    module2.exports = function factory2(argv) {
      return new WatchCommand(argv);
    };
    var WatchCommand = class extends Command {
      filteredProjects = [];
      count = 0;
      packagePlural = "packages";
      get requiresGit() {
        return false;
      }
      async initialize() {
        if (!this.options.command) {
          throw new ValidationError("ENOCOMMAND", "A command to execute is required");
        }
        this.filteredProjects = filterProjects(this.projectGraph, this.execOpts, this.options);
        this.count = this.filteredProjects.length;
        this.packagePlural = this.count === 1 ? "package" : "packages";
      }
      async execute() {
        this.logger.info(
          "watch",
          "Executing command %j on changes in %d %s.",
          this.options.command,
          this.count,
          this.packagePlural
        );
        const projectNames = this.filteredProjects.map((p) => p.name);
        await (0, import_watch.watch)({
          command: this.options.command,
          projectNameEnvName: "LERNA_PACKAGE_NAME",
          fileChangesEnvName: "LERNA_FILE_CHANGES",
          includeDependentProjects: false,
          // dependent projects are accounted for via lerna filter options
          projects: projectNames,
          verbose: this.options.verbose
        });
      }
    };
    module2.exports.WatchCommand = WatchCommand;
  }
});

// packages/lerna/src/commands/watch/command.ts
var require_command14 = __commonJS({
  "packages/lerna/src/commands/watch/command.ts"(exports2, module2) {
    "use strict";
    init_src();
    var command = {
      command: "watch",
      describe: "Runs a command whenever packages or their dependents change.",
      builder(yargs2) {
        yargs2.parserConfiguration({
          "populate--": true,
          "strip-dashed": true
        }).option("command", { type: "string", hidden: true }).option("verbose", {
          type: "boolean",
          description: "Run watch mode in verbose mode, where commands are logged before execution."
        }).middleware((args) => {
          const { "--": doubleDash } = args;
          if (doubleDash && Array.isArray(doubleDash)) {
            args.command = doubleDash.join(" ");
          }
        }, true);
        return filterOptions(yargs2);
      },
      handler(argv) {
        return require_watch()(argv);
      }
    };
    module2.exports = command;
  }
});

// packages/lerna/src/index.ts
var import_npmlog64 = __toESM(require("npmlog"));
init_src();
var import_command3 = __toESM(require_command());
var import_command4 = __toESM(require_command2());
var import_command5 = __toESM(require_command3());
var import_command6 = __toESM(require_command4());
var import_command7 = __toESM(require_command5());
var import_command8 = __toESM(require_command6());
var import_command9 = __toESM(require_command7());
var import_command10 = __toESM(require_command8());
var import_command11 = __toESM(require_command10());
var import_command12 = __toESM(require_command11());
var import_command13 = __toESM(require_command9());
var import_command14 = __toESM(require_command12());
var import_command15 = __toESM(require_command13());
var import_command16 = __toESM(require_command14());
var createCmd = require("@lerna/create/command");
var pkg = require("../package.json");
module.exports = function main(argv) {
  const context = {
    lernaVersion: pkg.version
  };
  const cli = lernaCLI().command(import_command14.default).command(import_command3.default).command(import_command4.default).command(createCmd).command(import_command5.default).command(import_command6.default).command(import_command7.default).command(import_command8.default).command(import_command9.default).command(import_command10.default).command(import_command11.default).command(import_command15.default).command(import_command12.default).command(import_command16.default).command(import_command13.default);
  applyLegacyPackageManagementCommands(cli);
  return cli.parse(argv, context);
};
function applyLegacyPackageManagementCommands(yargsInstance) {
  try {
    const { addCmd, bootstrapCmd, linkCmd } = require("@lerna/legacy-package-management");
    yargsInstance.command(addCmd).command(bootstrapCmd).command(linkCmd);
  } catch {
    ["add", "bootstrap", "link"].forEach((commandName) => {
      yargsInstance.command({
        command: commandName === "add" ? "add <pkg> [globs..]" : commandName,
        describe: `The "${commandName}" command was removed by default in v7, and is no longer maintained.`,
        builder: (yargs2) => {
          const parsed = require("yargs/yargs")(process.argv.slice(2)).argv;
          for (const x of Object.keys(parsed)) {
            if (x !== "_" && x !== "$0") {
              yargs2.option(x, {});
            }
          }
          return yargs2;
        },
        handler() {
          import_npmlog64.default.error(
            commandName,
            `The "${commandName}" command was removed by default in v7, and is no longer maintained.`
          );
          import_npmlog64.default.error(
            commandName,
            `Learn more about this change at https://lerna.js.org/docs/legacy-package-management`
          );
          process.exit(1);
        }
      });
    });
  }
}
