import copyImage from './copy-image.js';
const haveSharedArrayBuffer = typeof globalThis.SharedArrayBuffer === 'function';
/** If SharedArrayBuffer's are available, ensure an itk.Image's buffer is a
 * SharedArrayBuffer. If SharedArrayBuffer's are not available, return a copy.
 * */
function imageSharedBufferOrCopy(image) {
    if (image.data === null) {
        return image;
    }
    if (haveSharedArrayBuffer) {
        if (image.data.buffer instanceof SharedArrayBuffer) { // eslint-disable-line
            return image;
        }
        const sharedBuffer = new SharedArrayBuffer(image.data.buffer.byteLength); // eslint-disable-line
        const CTor = image.data.constructor;
        const sharedTypedArray = new CTor(sharedBuffer);
        if (sharedTypedArray !== null) {
            // @ts-expect-error: error TS2345: Argument of type 'TypedArray' is not assignable to parameter of type 'ArrayLike<number> & ArrayLike<bigint>'.
            sharedTypedArray.set(image.data, 0);
        }
        image.data = sharedTypedArray;
        return image;
    }
    else {
        return copyImage(image);
    }
}
export default imageSharedBufferOrCopy;
//# sourceMappingURL=image-shared-buffer-or-copy.js.map