const haveSharedArrayBuffer = typeof globalThis.SharedArrayBuffer !== 'undefined'; // eslint-disable-line
function getTransferables(data, noCopy) {
    if (data === undefined || data === null) {
        return [];
    }
    const transferables = [];
    for (let i = 0; i < data.length; i++) {
        const transferable = getTransferable(data[i], noCopy);
        if (transferable !== null) {
            transferables.push(transferable);
        }
    }
    return transferables;
}
function getTransferable(data, noCopy) {
    if (data === undefined || data === null) {
        return null;
    }
    let result = null;
    if (data.buffer !== undefined) {
        result = data.buffer;
    }
    else if (data.byteLength !== undefined) {
        result = data;
    }
    if (haveSharedArrayBuffer && result instanceof SharedArrayBuffer) { // eslint-disable-line
        return null;
    }
    // eslint-disable-next-line
    if (noCopy) {
        return result;
    }
    return result.slice(0);
}
export default getTransferables;
//# sourceMappingURL=get-transferables.js.map