/**
 * @param {string | Iterable<string>} paths
 * @param {object} [options]
 * @param {boolean} [options.hidden]
 * @param {boolean} [options.sort] Sort by path. Default: true.
 * @param {FileSystem} [options.fs] Custom FileSystem implementation.
 * @returns {Promise<FileLike[]>}
 */
export function filesFromPaths(paths: string | Iterable<string>, options?: {
    hidden?: boolean | undefined;
    sort?: boolean | undefined;
    fs?: FileSystem | undefined;
} | undefined): Promise<FileLike[]>;
export type FileLike = Pick<File, 'stream' | 'name' | 'size'>;
export type Dirent = {
    name: string;
    isFile: () => boolean;
    isDirectory: () => boolean;
};
export type DirReader = {
    readdir: (path: string, options: {
        withFileTypes: true;
    }) => Promise<Dirent[]>;
};
export type Stats = {
    size: number;
    isFile: () => boolean;
    isDirectory: () => boolean;
};
export type StatGetter = {
    stat: (path: string) => Promise<Stats>;
};
export type FileSystem = {
    createReadStream: (path: string) => import('node:fs').ReadStream;
    promises: DirReader & StatGetter;
};
//# sourceMappingURL=index.d.ts.map