/**
 * Validates IPLD block bytes.
 * @param {Block} block
 */
export function validateBlock(block: Block): Promise<void> | undefined;
/**
 * @typedef {object} Block
 * @property {import('multiformats/cid').CID} cid
 * @property {Uint8Array} bytes
 */
/** @type {Map<number, import('multiformats/hashes/interface').MultihashHasher>} */
export const hashMap: Map<number, import('multiformats/hashes/interface').MultihashHasher>;
/** The multihash hasher is not supported by this library. */
export class UnsupportedHashError extends Error {
    /** @param {number} code */
    constructor(code: number);
}
/** The bytes did not hash to the same value as the passed multihash. */
export class HashMismatchError extends Error {
    constructor();
}
export type Block = {
    cid: import('multiformats/cid').CID;
    bytes: Uint8Array;
};
//# sourceMappingURL=index.d.ts.map