import * as __WEBPACK_EXTERNAL_MODULE_node_module_ab9f2194__ from "node:module";
import * as __WEBPACK_EXTERNAL_MODULE_node_path_c5b9b54f__ from "node:path";
let react_require = (0, __WEBPACK_EXTERNAL_MODULE_node_module_ab9f2194__.createRequire)(import.meta.url), applyBasicReactSupport = (api, options)=>{
    let REACT_REFRESH_PATH = options.fastRefresh ? react_require.resolve('react-refresh') : '';
    api.modifyEnvironmentConfig((config, { mergeEnvironmentConfig })=>{
        let isDev = 'development' === config.mode, usingHMR = isDev && config.dev.hmr && 'web' === config.output.target;
        return mergeEnvironmentConfig({
            tools: {
                swc: {
                    jsc: {
                        parser: {
                            syntax: "typescript",
                            tsx: !0
                        },
                        transform: {
                            react: {
                                development: isDev,
                                refresh: usingHMR && options.fastRefresh,
                                runtime: 'automatic',
                                ...options.swcReactOptions
                            }
                        }
                    }
                }
            }
        }, config);
    }), api.modifyBundlerChain(async (chain, { CHAIN_ID, environment, isDev, target })=>{
        let { config } = environment;
        if (!(isDev && config.dev.hmr && 'web' === target) || !options.fastRefresh) return;
        chain.resolve.alias.set('react-refresh', __WEBPACK_EXTERNAL_MODULE_node_path_c5b9b54f__.default.dirname(REACT_REFRESH_PATH));
        let { ReactRefreshRspackPlugin } = await import("@rspack/plugin-react-refresh");
        chain.plugin(CHAIN_ID.PLUGIN.REACT_FAST_REFRESH).use(ReactRefreshRspackPlugin, [
            {
                include: [
                    /\.(?:js|jsx|mjs|cjs|ts|tsx|mts|cts)$/
                ],
                exclude: [
                    /[\\/]node_modules[\\/]/
                ],
                resourceQuery: {
                    not: /raw/
                },
                ...options.reactRefreshOptions
            }
        ]);
    });
}, applyReactProfiler = (api)=>{
    api.modifyEnvironmentConfig((config, { mergeEnvironmentConfig })=>{
        if ('production' === config.mode) return mergeEnvironmentConfig(config, {
            output: {
                minify: {
                    jsOptions: {
                        minimizerOptions: {
                            mangle: {
                                keep_classnames: !0,
                                keep_fnames: !0
                            }
                        }
                    }
                }
            }
        });
    }), api.modifyBundlerChain((chain, { isProd })=>{
        isProd && (chain.resolve.alias.set('react-dom$', 'react-dom/profiling'), chain.resolve.alias.set('scheduler/tracing', 'scheduler/tracing-profiling'));
    });
}, isPlainObject = (obj)=>null !== obj && 'object' == typeof obj && '[object Object]' === Object.prototype.toString.call(obj), applySplitChunksRule = (api, options = {
    react: !0,
    router: !0
})=>{
    api.modifyBundlerChain((chain, { environment, isProd })=>{
        let { config } = environment;
        if ('split-by-experience' !== config.performance.chunkSplit.strategy) return;
        let currentConfig = chain.optimization.splitChunks.values();
        if (!isPlainObject(currentConfig)) return;
        let extraGroups = {};
        options.react && (extraGroups.react = {
            name: 'lib-react',
            test: isProd ? /node_modules[\\/](?:react|react-dom|scheduler)[\\/]/ : /node_modules[\\/](?:react|react-dom|scheduler|react-refresh|@rspack[\\/]plugin-react-refresh)[\\/]/,
            priority: 0
        }), options.router && (extraGroups.router = {
            name: 'lib-router',
            test: /node_modules[\\/](?:react-router|react-router-dom|history|@remix-run[\\/]router)[\\/]/,
            priority: 0
        }), Object.keys(extraGroups).length && chain.optimization.splitChunks({
            ...currentConfig,
            cacheGroups: {
                ...extraGroups,
                ...currentConfig.cacheGroups
            }
        });
    });
}, PLUGIN_REACT_NAME = 'rsbuild:react', pluginReact = (options = {})=>({
        name: PLUGIN_REACT_NAME,
        setup (api) {
            let finalOptions = {
                fastRefresh: !0,
                enableProfiler: !1,
                ...options
            };
            'rspack' === api.context.bundlerType && (applyBasicReactSupport(api, finalOptions), finalOptions.enableProfiler && applyReactProfiler(api)), applySplitChunksRule(api, null == finalOptions ? void 0 : finalOptions.splitChunks);
        }
    });
export { PLUGIN_REACT_NAME, pluginReact };
