import type { InternalContext, NormalizedEnvironmentConfig, ResolvedCreateRsbuildOptions, RsbuildConfig, RsbuildContext } from './types';
export declare function getBrowserslist(path: string): Promise<string[] | null>;
export declare function getBrowserslistByEnvironment(path: string, config: NormalizedEnvironmentConfig): Promise<string[]>;
export declare function updateEnvironmentContext(context: InternalContext, configs: Record<string, NormalizedEnvironmentConfig>): Promise<void>;
export declare function updateContextByNormalizedConfig(context: InternalContext): void;
export declare function createPublicContext(context: RsbuildContext): Readonly<RsbuildContext>;
/**
 * Generate the actual context used in the build,
 * which can have a lot of overhead and take some side effects.
 */
export declare function createContext(options: ResolvedCreateRsbuildOptions, userConfig: RsbuildConfig): Promise<InternalContext>;
