"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireNx = void 0;
// After Nx v18, this can be removed and replaced with either:
// - import {} from 'nx/src/devkit-exports'
// - import {} from 'nx/src/devkit-internals'
function requireNx() {
    try {
        let result = { ...require('nx/src/devkit-exports') };
        try {
            result = {
                ...result,
                // Remove in Nx v18, devkit should not support Nx v16.0.2 at that point.
                ...require('nx/src/devkit-internals'),
            };
        }
        catch { }
        return result;
    }
    catch {
        // Remove in Nx V17, devkit should not support Nx < 16 at that point.
        return require('./nx-reexports-pre16');
    }
}
exports.requireNx = requireNx;
