import type { Button } from "@ohif/core/types";

import { EVENTS } from "@cornerstonejs/core";
import { ViewportGridService } from "@ohif/core";

const callbacks = (toolName: string) => [
  {
    commandName: "setViewportForToolConfiguration",
    commandOptions: {
      toolName,
    },
  },
];

export const setToolActiveToolbar = {
  commandName: "setToolActiveToolbar",
  commandOptions: {
    toolGroupIds: ["default", "mpr", "SRToolGroup", "volume3d"],
  },
};

const toolbarButtons: Button[] = [
  // sections
  {
    id: "MeasurementTools",
    uiType: "ohif.toolButtonList",
    props: {
      buttonSection: true,
    },
  },
  {
    id: "MoreTools",
    uiType: "ohif.toolButtonList",
    props: {
      buttonSection: true,
    },
  },
  {
    id: "AdvancedRenderingControls",
    uiType: "ohif.advancedRenderingControls",
    props: {
      buttonSection: true,
    },
  },
  // tool defs
  {
    id: "modalityLoadBadge",
    uiType: "ohif.modalityLoadBadge",
    props: {
      icon: "Status",
      label: "Status",
      tooltip: "Status",
      evaluate: {
        name: "evaluate.modalityLoadBadge",
        hideWhenDisabled: true,
      },
    },
  },
  {
    id: "navigationComponent",
    uiType: "ohif.navigationComponent",
    props: {
      icon: "Navigation",
      label: "Navigation",
      tooltip:
        "Navigate between segments/measurements and manage their visibility",
      evaluate: {
        name: "evaluate.navigationComponent",
        hideWhenDisabled: true,
      },
    },
  },
  {
    id: "trackingStatus",
    uiType: "ohif.trackingStatus",
    props: {
      icon: "TrackingStatus",
      label: "Tracking Status",
      tooltip:
        "View and manage tracking status of measurements and annotations",
      evaluate: {
        name: "evaluate.trackingStatus",
        hideWhenDisabled: true,
      },
    },
  },
  {
    id: "dataOverlayMenu",
    uiType: "ohif.dataOverlayMenu",
    props: {
      icon: "ViewportViews",
      label: "Data Overlay",
      tooltip:
        "Configure data overlay options and manage foreground/background display sets",
      evaluate: "evaluate.dataOverlayMenu",
    },
  },
  {
    id: "orientationMenu",
    uiType: "ohif.orientationMenu",
    props: {
      icon: "OrientationSwitch",
      label: "Orientation",
      tooltip:
        "Change viewport orientation between axial, sagittal, coronal and reformat planes",
      evaluate: {
        name: "evaluate.orientationMenu",
        // hideWhenDisabled: true,
      },
    },
  },
  {
    id: "windowLevelMenuEmbedded",
    uiType: "ohif.windowLevelMenuEmbedded",
    props: {
      icon: "WindowLevel",
      label: "Window Level",
      tooltip:
        "Adjust window/level presets and customize image contrast settings",
      evaluate: {
        name: "evaluate.windowLevelMenuEmbedded",
        hideWhenDisabled: true,
      },
    },
  },
  {
    id: "windowLevelMenu",
    uiType: "ohif.windowLevelMenu",
    props: {
      icon: "WindowLevel",
      label: "Window Level",
      tooltip:
        "Adjust window/level presets and customize image contrast settings",
      evaluate: {
        name: "evaluate.windowLevelMenu",
      },
    },
  },
  {
    id: "voiManualControlMenu",
    uiType: "ohif.voiManualControlMenu",
    props: {
      icon: "WindowLevelAdvanced",
      label: "Advanced Window Level",
      tooltip:
        "Advanced window/level settings with manual controls and presets",
      evaluate: "evaluate.voiManualControlMenu",
    },
  },
  {
    id: "thresholdMenu",
    uiType: "ohif.thresholdMenu",
    props: {
      icon: "Threshold",
      label: "Threshold",
      tooltip: "Image threshold settings",
      evaluate: {
        name: "evaluate.thresholdMenu",
        hideWhenDisabled: true,
      },
    },
  },
  {
    id: "opacityMenu",
    uiType: "ohif.opacityMenu",
    props: {
      icon: "Opacity",
      label: "Opacity",
      tooltip: "Image opacity settings",
      evaluate: {
        name: "evaluate.opacityMenu",
        hideWhenDisabled: true,
      },
    },
  },
  {
    id: "Colorbar",
    uiType: "ohif.colorbar",
    props: {
      type: "tool",
      label: "Colorbar",
    },
  },
  {
    id: "Reset",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-reset",
      label: "Reset View",
      tooltip: "Reset View",
      commands: "resetViewport",
      evaluate: "evaluate.action",
    },
  },
  {
    id: "rotate-right",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-rotate-right",
      label: "Rotate Right",
      tooltip: "Rotate +90",
      commands: "rotateViewportCW",
      evaluate: [
        "evaluate.action",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "flipHorizontal",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-flip-horizontal",
      label: "Flip Horizontal",
      tooltip: "Flip Horizontally",
      commands: "flipViewportHorizontal",
      evaluate: [
        "evaluate.viewportProperties.toggle",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video", "volume3d"],
        },
      ],
    },
  },
  {
    id: "ImageSliceSync",
    uiType: "ohif.toolButton",
    props: {
      icon: "link",
      label: "Image Slice Sync",
      tooltip: "Enable position synchronization on stack viewports",
      commands: {
        commandName: "toggleSynchronizer",
        commandOptions: {
          type: "imageSlice",
        },
      },
      listeners: {
        [EVENTS.VIEWPORT_NEW_IMAGE_SET]: {
          commandName: "toggleImageSliceSync",
          commandOptions: { toggledState: true },
        },
      },
      evaluate: [
        "evaluate.cornerstone.synchronizer",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video", "volume3d"],
        },
      ],
    },
  },
  {
    id: "ReferenceLines",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-referenceLines",
      label: "Reference Lines",
      tooltip: "Show Reference Lines",
      commands: "toggleEnabledDisabledToolbar",
      listeners: {
        [ViewportGridService.EVENTS.ACTIVE_VIEWPORT_ID_CHANGED]:
          callbacks("ReferenceLines"),
        [ViewportGridService.EVENTS.VIEWPORTS_READY]:
          callbacks("ReferenceLines"),
      },
      evaluate: [
        "evaluate.cornerstoneTool.toggle",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "ImageOverlayViewer",
    uiType: "ohif.toolButton",
    props: {
      icon: "toggle-dicom-overlay",
      label: "Image Overlay",
      tooltip: "Toggle Image Overlay",
      commands: "toggleEnabledDisabledToolbar",
      evaluate: [
        "evaluate.cornerstoneTool.toggle",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "StackScroll",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-stack-scroll",
      label: "Stack Scroll",
      tooltip: "Stack Scroll",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "invert",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-invert",
      label: "Invert",
      tooltip: "Invert Colors",
      commands: "invertViewport",
      evaluate: [
        "evaluate.viewportProperties.toggle",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "Reporting",
    uiType: "ohif.radioGroup",
    props: {
      icon: "icon-reporting",
      label: "REPORTING",
      commands: [
        {
          commandName: "openReportingPanel",
          commandOptions: {},
          context: "ACTIVE_VIEWPORT::CORNERSTONE",
        },
      ],
    },
  },

  {
    id: "PatientHistory",
    uiType: "ohif.radioGroup",
    props: {
      icon: "icon-history",
      label: "HISTORY",
      commands: [
        {
          commandName: "openHistoryPanel",
          commandOptions: {},
        },
      ],
    },
  },
  {
    id: "Probe",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-probe",
      label: "Probe",
      tooltip: "Probe",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "Cine",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-cine",
      label: "Cine",
      tooltip: "Cine",
      commands: "toggleCine",
      evaluate: [
        "evaluate.cine",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["volume3d"],
        },
      ],
    },
  },
  {
    id: "Angle",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-angle",
      label: "Angle",
      tooltip: "Angle",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "CobbAngle",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-cobb-angle",
      label: "Cobb Angle",
      tooltip: "Cobb Angle",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "Magnify",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-magnify",
      label: "Zoom-in",
      tooltip: "Zoom-in",
      commands: setToolActiveToolbar,
      evaluate: [
        "evaluate.cornerstoneTool",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "CalibrationLine",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-calibration",
      label: "Calibration",
      tooltip: "Calibration Line",
      commands: setToolActiveToolbar,
      evaluate: [
        "evaluate.cornerstoneTool",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "TagBrowser",
    uiType: "ohif.toolButton",
    props: {
      icon: "dicom-tag-browser",
      label: "Dicom Tag Browser",
      tooltip: "Dicom Tag Browser",
      commands: "openDICOMTagViewer",
    },
  },
  {
    id: "AdvancedMagnify",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-loupe",
      label: "Magnify Probe",
      tooltip: "Magnify Probe",
      commands: "toggleActiveDisabledToolbar",
      evaluate: [
        "evaluate.cornerstoneTool.toggle.ifStrictlyDisabled",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "UltrasoundDirectionalTool",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-ultrasound-bidirectional",
      label: "Ultrasound Directional",
      tooltip: "Ultrasound Directional",
      commands: setToolActiveToolbar,
      evaluate: [
        "evaluate.cornerstoneTool",
        {
          name: "evaluate.modality.supported",
          supportedModalities: ["US"],
        },
      ],
    },
  },
  {
    id: "WindowLevelRegion",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-window-region",
      label: "Window Level Region",
      tooltip: "Window Level Region",
      commands: setToolActiveToolbar,
      evaluate: [
        "evaluate.cornerstoneTool",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video"],
        },
      ],
    },
  },
  {
    id: "Length",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-length",
      label: "Length",
      tooltip: "Length Tool",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "Bidirectional",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-bidirectional",
      label: "Bidirectional",
      tooltip: "Bidirectional Tool",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "ArrowAnnotate",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-annotate",
      label: "Annotation",
      tooltip: "Arrow Annotate",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "EllipticalROI",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-ellipse",
      label: "Ellipse",
      tooltip: "Ellipse ROI",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "RectangleROI",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-rectangle",
      label: "Rectangle",
      tooltip: "Rectangle ROI",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "CircleROI",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-circle",
      label: "Circle",
      tooltip: "Circle Tool",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "PlanarFreehandROI",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-freehand-roi",
      label: "Freehand ROI",
      tooltip: "Freehand ROI",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "SplineROI",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-spline-roi",
      label: "Spline ROI",
      tooltip: "Spline ROI",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "LivewireContour",
    uiType: "ohif.toolButton",
    props: {
      icon: "icon-tool-livewire",
      label: "Livewire tool",
      tooltip: "Livewire tool",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  // Window Level
  {
    id: "WindowLevel",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-window-level",
      label: "Window Level",
      commands: setToolActiveToolbar,
      evaluate: [
        "evaluate.cornerstoneTool",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["wholeSlide"],
        },
      ],
    },
  },
  {
    id: "Pan",
    uiType: "ohif.toolButton",
    props: {
      type: "tool",
      icon: "tool-move",
      label: "Pan",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "Zoom",
    uiType: "ohif.toolButton",
    props: {
      type: "tool",
      icon: "tool-zoom",
      label: "Zoom",
      commands: setToolActiveToolbar,
      evaluate: "evaluate.cornerstoneTool",
    },
  },
  {
    id: "TrackballRotate",
    uiType: "ohif.toolButton",
    props: {
      type: "tool",
      icon: "tool-3d-rotate",
      label: "3D Rotate",
      commands: setToolActiveToolbar,
      evaluate: {
        name: "evaluate.cornerstoneTool",
        disabledText: "Select a 3D viewport to enable this tool",
      },
    },
  },
  {
    id: "Capture",
    uiType: "ohif.toolButton",
    props: {
      icon: "tool-capture",
      label: "Capture",
      commands: "showDownloadViewportModal",
      evaluate: [
        "evaluate.action",
        {
          name: "evaluate.viewport.supported",
          unsupportedViewportTypes: ["video", "wholeSlide"],
        },
      ],
    },
  },
  {
    id: "Layout",
    uiType: "ohif.layoutSelector",
    props: {
      rows: 3,
      columns: 4,
      evaluate: "evaluate.action",
    },
  },
  {
    id: "Crosshairs",
    uiType: "ohif.toolButton",
    props: {
      type: "tool",
      icon: "tool-crosshair",
      label: "Crosshairs",
      commands: {
        commandName: "setToolActiveToolbar",
        commandOptions: {
          toolGroupIds: ["mpr"],
        },
      },
      evaluate: {
        name: "evaluate.cornerstoneTool",
        disabledText: "Select an MPR viewport to enable this tool",
      },
    },
  },
  // Section containers for the nested toolbox
  {
    id: "SegmentationUtilities",
    uiType: "ohif.toolBoxButton",
    props: {
      buttonSection: true,
    },
  },
  {
    id: "SegmentLabelTool",
    uiType: "ohif.toolBoxButton",
    props: {
      icon: "tool-segment-label",
      label: "Segment Label Display",
      tooltip:
        "Click to show or hide segment labels when hovering with your mouse.",
      commands: { commandName: "toggleSegmentLabel" },
      evaluate: [
        "evaluate.cornerstoneTool.toggle",
        {
          name: "evaluate.cornerstone.hasSegmentation",
        },
      ],
    },
  },
  // {
  //   id: 'Undo',
  //   uiType: 'ohif.toolButton',
  //   props: {
  //     type: 'tool',
  //     icon: 'prev-arrow',
  //     label: 'Undo',
  //     commands: {
  //       commandName: 'undo',
  //     },
  //     evaluate: 'evaluate.action',
  //   },
  // },
  // {
  //   id: 'Redo',
  //   uiType: 'ohif.toolButton',
  //   props: {
  //     type: 'tool',
  //     icon: 'next-arrow',
  //     label: 'Redo',
  //     commands: {
  //       commandName: 'redo',
  //     },
  //     evaluate: 'evaluate.action',
  //   },
  // },
];

export default toolbarButtons;
